"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.galleryExample = void 0;
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var _doc_utils_1 = require("@doc-utils");
var generated_props_json_1 = tslib_1.__importDefault(require("./generated-props.json"));
var generated_examples_json_1 = tslib_1.__importDefault(require("./generated-examples.json"));
var _1 = require(".");
function Readme() {
    return (react_1.default.createElement(_doc_utils_1.Docs, { title: "Top App Bar", lead: "Top App Bar acts as a container for items such as application title, navigation icon, and action items.", module: "@rmwc/top-app-bar", styles: [
            '@material/top-app-bar/dist/mdc.top-app-bar.css',
            '@material/icon-button/dist/mdc.icon-button.css',
            '@material/ripple/dist/mdc.ripple.css',
            '@rmwc/icon/icon.css'
        ], docsLink: "https://material.io/develop/web/components/top-app-bar/", examples: generated_examples_json_1.default },
        react_1.default.createElement(_doc_utils_1.DocsP, null, "Whats the difference between the TopAppBar and Toolbar? Toolbar is technically deprecated (although it still works just fine). TopAppBar functionality continues to be worked on by the `material-components-web` team."),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Basic Usage"),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Default", iframe: true },
            react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(_1.TopAppBar, null,
                    react_1.default.createElement(_1.TopAppBarRow, null,
                        react_1.default.createElement(_1.TopAppBarSection, null,
                            react_1.default.createElement(_1.TopAppBarTitle, null, "Default")))),
                react_1.default.createElement(_1.TopAppBarFixedAdjust, null),
                react_1.default.createElement("div", { style: { height: '100rem', padding: '1rem' } }, "Scroll Me"))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Fully Featured", iframe: true },
            react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(_1.TopAppBar, null,
                    react_1.default.createElement(_1.TopAppBarRow, null,
                        react_1.default.createElement(_1.TopAppBarSection, { alignStart: true },
                            react_1.default.createElement(_1.TopAppBarNavigationIcon, { icon: "menu" }),
                            react_1.default.createElement(_1.TopAppBarTitle, null, "All Features")),
                        react_1.default.createElement(_1.TopAppBarSection, { alignEnd: true },
                            react_1.default.createElement(_1.TopAppBarActionItem, { icon: "favorite" }),
                            react_1.default.createElement(_1.TopAppBarActionItem, { icon: "star" }),
                            react_1.default.createElement(_1.TopAppBarActionItem, { icon: "mood" }))),
                    react_1.default.createElement(_1.TopAppBarRow, null,
                        react_1.default.createElement(_1.TopAppBarSection, { alignStart: true },
                            react_1.default.createElement(_1.TopAppBarTitle, null, "Another Row")))),
                react_1.default.createElement(_1.TopAppBarFixedAdjust, null),
                react_1.default.createElement("div", { style: { height: '100rem', padding: '1rem' } }, "Scroll Me"))),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Simplified Usage"),
        react_1.default.createElement(_doc_utils_1.DocsP, null, "You can use the `SimpleTopAppBar` component which contains a default template already laid out for you. Specify any actions you want as an array of props"),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Simple", iframe: true },
            react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(_1.SimpleTopAppBar, { title: "test", navigationIcon: true, onNav: function () { return console.log('Navigate'); }, actionItems: [
                        {
                            icon: 'file_download',
                            onClick: function () { return console.log('Do Something'); }
                        },
                        { icon: 'print', onClick: function () { return console.log('Do Something'); } },
                        { icon: 'bookmark', onClick: function () { return console.log('Do Something'); } }
                    ] }),
                react_1.default.createElement(_1.TopAppBarFixedAdjust, null),
                react_1.default.createElement("div", { style: { height: '100rem', padding: '1rem' } }, "Scroll Me"))),
        react_1.default.createElement(_doc_utils_1.DocsSubtitle, null, "Variants"),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Fixed", iframe: true },
            react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(_1.TopAppBar, { fixed: true },
                    react_1.default.createElement(_1.TopAppBarRow, null,
                        react_1.default.createElement(_1.TopAppBarSection, null,
                            react_1.default.createElement(_1.TopAppBarTitle, null, "Fixed")))),
                react_1.default.createElement(_1.TopAppBarFixedAdjust, null),
                react_1.default.createElement("div", { style: { height: '100rem', padding: '1rem' } }, "Scroll Me"))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Dense", iframe: true },
            react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(_1.TopAppBar, { dense: true },
                    react_1.default.createElement(_1.TopAppBarRow, null,
                        react_1.default.createElement(_1.TopAppBarSection, null,
                            react_1.default.createElement(_1.TopAppBarTitle, null, "Dense")))),
                react_1.default.createElement(_1.TopAppBarFixedAdjust, null),
                react_1.default.createElement("div", { style: { height: '100rem', padding: '1rem' } }, "Scroll Me"))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Short", iframe: true },
            react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(_1.TopAppBar, { short: true },
                    react_1.default.createElement(_1.TopAppBarRow, null,
                        react_1.default.createElement(_1.TopAppBarSection, null,
                            react_1.default.createElement(_1.TopAppBarNavigationIcon, { icon: "menu" }),
                            react_1.default.createElement(_1.TopAppBarTitle, null, "Short")),
                        react_1.default.createElement(_1.TopAppBarSection, { alignEnd: true },
                            react_1.default.createElement(_1.TopAppBarActionItem, { icon: "favorite" })))),
                react_1.default.createElement(_1.TopAppBarFixedAdjust, null),
                react_1.default.createElement("div", { style: { height: '100rem', padding: '1rem' } }, "Scroll Me"))),
        react_1.default.createElement(_doc_utils_1.DocsExample, { label: "Prominent", iframe: true },
            react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(_1.TopAppBar, { prominent: true },
                    react_1.default.createElement(_1.TopAppBarRow, null,
                        react_1.default.createElement(_1.TopAppBarSection, null,
                            react_1.default.createElement(_1.TopAppBarTitle, null, "Prominent")))),
                react_1.default.createElement(_1.TopAppBarFixedAdjust, null),
                react_1.default.createElement("div", { style: { height: '100rem', padding: '1rem' } }, "Scroll Me"))),
        react_1.default.createElement(_doc_utils_1.DocProps, { src: generated_props_json_1.default, components: [
                { displayName: 'TopAppBar', component: _1.TopAppBar },
                { displayName: 'TopAppBarRow', component: _1.TopAppBarRow },
                { displayName: 'TopAppBarSection', component: _1.TopAppBarSection },
                { displayName: 'TopAppBarTitle', component: _1.TopAppBarTitle },
                {
                    displayName: 'TopAppBarNavigationIcon',
                    component: _1.TopAppBarNavigationIcon
                },
                {
                    displayName: 'TopAppBarActionItem',
                    component: _1.TopAppBarActionItem
                },
                {
                    displayName: 'TopAppBarFixedAdjust',
                    component: _1.TopAppBarFixedAdjust
                },
                { displayName: 'SimpleTopAppBar', component: _1.SimpleTopAppBar }
            ] })));
}
exports.default = Readme;
exports.galleryExample = (react_1.default.createElement(react_1.default.Fragment, null,
    react_1.default.createElement(_1.SimpleTopAppBar, { style: { position: 'static', top: 0, transform: 'scale(0.9)' }, title: "App Bar", navigationIcon: { onClick: function () { return console.log('Navigate'); } }, actionItems: [
            {
                icon: 'file_download',
                onClick: function () { return console.log('Do Something'); }
            },
            {
                icon: 'print',
                onClick: function () { return console.log('Do Something'); }
            }
        ] })));
