import { IRoom } from '../rooms/IRoom';
import { IUser } from '../users';
import { IDepartment } from './IDepartment';
import { IVisitor } from './IVisitor';
export declare enum OmnichannelSourceType {
    WIDGET = "widget",
    EMAIL = "email",
    SMS = "sms",
    APP = "app",
    OTHER = "other"
}
interface IOmnichannelSourceApp {
    type: 'app';
    id: string;
    alias?: string;
    label?: string;
    sidebarIcon?: string;
    defaultIcon?: string;
}
declare type OmnichannelSource = {
    type: Omit<OmnichannelSourceType, 'app'>;
} | IOmnichannelSourceApp;
export interface ILivechatRoom extends IRoom {
    visitor: IVisitor;
    department?: IDepartment;
    servedBy?: IUser;
    responseBy?: IUser;
    isWaitingResponse: boolean;
    isOpen: boolean;
    closedAt?: Date;
    source?: OmnichannelSource;
}
export declare const isLivechatRoom: (room: IRoom) => room is ILivechatRoom;
export declare const isLivechatFromApp: (room: ILivechatRoom) => room is ILivechatRoom & {
    source: IOmnichannelSourceApp;
};
export {};
