import { Omit } from '../../lib/utils';
import { IUIKitErrorInteractionParam } from '../accessors/IUIController';
import { IUIKitContextualBarResponse, IUIKitErrorResponse, IUIKitModalResponse, IUIKitResponse } from './IUIKitInteractionType';
import { IUIKitSurface } from './IUIKitSurface';
import { IUIKitBaseIncomingInteraction } from './UIKitIncomingInteractionTypes';
export declare type IUIKitModalViewParam = Omit<IUIKitSurface, 'appId' | 'id' | 'type'> & Partial<Pick<IUIKitSurface, 'id'>>;
export declare type IUIKitContextualBarViewParam = Omit<IUIKitSurface, 'appId' | 'id' | 'type'> & Partial<Pick<IUIKitSurface, 'id'>>;
export declare class UIKitInteractionResponder {
    private readonly baseContext;
    constructor(baseContext: IUIKitBaseIncomingInteraction);
    successResponse(): IUIKitResponse;
    errorResponse(): IUIKitResponse;
    openModalViewResponse(viewData: IUIKitModalViewParam): IUIKitModalResponse;
    updateModalViewResponse(viewData: IUIKitModalViewParam): IUIKitModalResponse;
    openContextualBarViewResponse(viewData: IUIKitContextualBarViewParam): IUIKitContextualBarResponse;
    updateContextualBarViewResponse(viewData: IUIKitContextualBarViewParam): IUIKitContextualBarResponse;
    viewErrorResponse(errorInteraction: IUIKitErrorInteractionParam): IUIKitErrorResponse;
}
