import { Omit } from '../../../lib/utils';
import { IActionsBlock, IBlock, IConditionalBlockFilters, IContextBlock, IImageBlock, IInputBlock, ISectionBlock } from './Blocks';
import { IBlockElement, IButtonElement, IImageElement, IInteractiveElement, IMultiStaticSelectElement, IOverflowMenuElement, IPlainTextInputElement, IStaticSelectElement } from './Elements';
import { ITextObject } from './Objects';
declare type BlockFunctionParameter<T extends IBlock> = Omit<T, 'type'>;
declare type ElementFunctionParameter<T extends IBlockElement> = T extends IInteractiveElement ? Omit<T, 'type' | 'actionId'> | Partial<Pick<T, 'actionId'>> : Omit<T, 'type'>;
declare type SectionBlockParam = BlockFunctionParameter<ISectionBlock>;
declare type ImageBlockParam = BlockFunctionParameter<IImageBlock>;
declare type ActionsBlockParam = BlockFunctionParameter<IActionsBlock>;
declare type ContextBlockParam = BlockFunctionParameter<IContextBlock>;
declare type InputBlockParam = BlockFunctionParameter<IInputBlock>;
declare type ButtonElementParam = ElementFunctionParameter<IButtonElement>;
declare type ImageElementParam = ElementFunctionParameter<IImageElement>;
declare type OverflowMenuElementParam = ElementFunctionParameter<IOverflowMenuElement>;
declare type PlainTextInputElementParam = ElementFunctionParameter<IPlainTextInputElement>;
declare type StaticSelectElementParam = ElementFunctionParameter<IStaticSelectElement>;
declare type MultiStaticSelectElementParam = ElementFunctionParameter<IMultiStaticSelectElement>;
export declare class BlockBuilder {
    private readonly appId;
    private readonly blocks;
    constructor(appId: string);
    addSectionBlock(block: SectionBlockParam): BlockBuilder;
    addImageBlock(block: ImageBlockParam): BlockBuilder;
    addDividerBlock(): BlockBuilder;
    addActionsBlock(block: ActionsBlockParam): BlockBuilder;
    addContextBlock(block: ContextBlockParam): BlockBuilder;
    addInputBlock(block: InputBlockParam): BlockBuilder;
    addConditionalBlock(innerBlocks: BlockBuilder | Array<IBlock>, condition?: IConditionalBlockFilters): BlockBuilder;
    getBlocks(): IBlock[];
    newPlainTextObject(text: string, emoji?: boolean): ITextObject;
    newMarkdownTextObject(text: string): ITextObject;
    newButtonElement(info: ButtonElementParam): IButtonElement;
    newImageElement(info: ImageElementParam): IImageElement;
    newOverflowMenuElement(info: OverflowMenuElementParam): IOverflowMenuElement;
    newPlainTextInputElement(info: PlainTextInputElementParam): IPlainTextInputElement;
    newStaticSelectElement(info: StaticSelectElementParam): IStaticSelectElement;
    newMultiStaticElement(info: MultiStaticSelectElementParam): IMultiStaticSelectElement;
    private newInteractiveElement;
    private newInputElement;
    private newSelectElement;
    private addBlock;
    private generateBlockId;
    private generateActionId;
}
export {};
