import { ILivechatMessageBuilder, IMessageBuilder } from '../../definition/accessors';
import { ILivechatMessage } from '../../definition/livechat/ILivechatMessage';
import { IVisitor } from '../../definition/livechat/IVisitor';
import { IMessageAttachment } from '../../definition/messages';
import { RocketChatAssociationModel } from '../../definition/metadata';
import { IRoom } from '../../definition/rooms';
import { IUser } from '../../definition/users';
export declare class LivechatMessageBuilder implements ILivechatMessageBuilder {
    kind: RocketChatAssociationModel.LIVECHAT_MESSAGE;
    private msg;
    constructor(message?: ILivechatMessage);
    setData(data: ILivechatMessage): ILivechatMessageBuilder;
    setRoom(room: IRoom): ILivechatMessageBuilder;
    getRoom(): IRoom;
    setSender(sender: IUser): ILivechatMessageBuilder;
    getSender(): IUser;
    setText(text: string): ILivechatMessageBuilder;
    getText(): string;
    setEmojiAvatar(emoji: string): ILivechatMessageBuilder;
    getEmojiAvatar(): string;
    setAvatarUrl(avatarUrl: string): ILivechatMessageBuilder;
    getAvatarUrl(): string;
    setUsernameAlias(alias: string): ILivechatMessageBuilder;
    getUsernameAlias(): string;
    addAttachment(attachment: IMessageAttachment): ILivechatMessageBuilder;
    setAttachments(attachments: Array<IMessageAttachment>): ILivechatMessageBuilder;
    getAttachments(): Array<IMessageAttachment>;
    replaceAttachment(position: number, attachment: IMessageAttachment): ILivechatMessageBuilder;
    removeAttachment(position: number): ILivechatMessageBuilder;
    setEditor(user: IUser): ILivechatMessageBuilder;
    getEditor(): IUser;
    setGroupable(groupable: boolean): ILivechatMessageBuilder;
    getGroupable(): boolean;
    setParseUrls(parseUrls: boolean): ILivechatMessageBuilder;
    getParseUrls(): boolean;
    setToken(token: string): ILivechatMessageBuilder;
    getToken(): string;
    setVisitor(visitor: IVisitor): ILivechatMessageBuilder;
    getVisitor(): IVisitor;
    getMessage(): ILivechatMessage;
    getMessageBuilder(): IMessageBuilder;
}
