import { IMessageBuilder, INotifier } from '../../definition/accessors';
import { ITypingOptions } from '../../definition/accessors/INotifier';
import { IMessage } from '../../definition/messages';
import { IRoom } from '../../definition/rooms';
import { IUser } from '../../definition/users';
import { MessageBridge, UserBridge } from '../bridges';
export declare class Notifier implements INotifier {
    private readonly userBridge;
    private readonly msgBridge;
    private readonly appId;
    constructor(userBridge: UserBridge, msgBridge: MessageBridge, appId: string);
    notifyUser(user: IUser, message: IMessage): Promise<void>;
    notifyRoom(room: IRoom, message: IMessage): Promise<void>;
    typing(options: ITypingOptions): Promise<() => Promise<void>>;
    getMessageBuilder(): IMessageBuilder;
}
