import { IRoomRead } from '../../definition/accessors';
import { IMessage } from '../../definition/messages';
import { IRoom } from '../../definition/rooms';
import { IUser } from '../../definition/users';
import { RoomBridge } from '../bridges';
export declare class RoomRead implements IRoomRead {
    private roomBridge;
    private appId;
    constructor(roomBridge: RoomBridge, appId: string);
    getById(id: string): Promise<IRoom>;
    getCreatorUserById(id: string): Promise<IUser>;
    getByName(name: string): Promise<IRoom>;
    getCreatorUserByName(name: string): Promise<IUser>;
    getMessages(roomId: string): Promise<IterableIterator<IMessage>>;
    getMembers(roomId: string): Promise<Array<IUser>>;
    getDirectByUsernames(usernames: Array<string>): Promise<IRoom>;
    getModerators(roomId: string): Promise<Array<IUser>>;
    getOwners(roomId: string): Promise<Array<IUser>>;
    getLeaders(roomId: string): Promise<Array<IUser>>;
}
