import { IOAuthApp, IOAuthAppParams } from '../../definition/accessors/IOAuthApp';
import { BaseBridge } from './BaseBridge';
export declare abstract class OAuthAppsBridge extends BaseBridge {
    doCreate(OAuthApp: IOAuthAppParams, appId: string): Promise<string>;
    doGetByid(id: string, appId: string): Promise<IOAuthApp>;
    doGetByName(name: string, appId: string): Promise<IOAuthApp[]>;
    doUpdate(OAuthApp: IOAuthAppParams, id: string, appId: string): Promise<void>;
    doDelete(id: string, appId: string): Promise<void>;
    doPurge(appId: string): Promise<void>;
    protected abstract create(OAuthApp: IOAuthAppParams, appId: string): Promise<string | null>;
    protected abstract getById(id: string, appId: string): Promise<IOAuthApp | null>;
    protected abstract getByName(name: string, appId: string): Promise<Array<IOAuthApp | null>>;
    protected abstract update(OAuthApp: IOAuthAppParams, id: string, appId: string): Promise<void>;
    protected abstract delete(id: string, appId: string): Promise<void>;
    protected abstract purge(appId: string): Promise<void>;
    private hasWritePermission;
    private hasReadPermission;
}
