"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppCompiler = void 0;
const path = require("path");
const metadata_1 = require("../../definition/metadata");
const accessors_1 = require("../accessors");
const errors_1 = require("../errors");
const logging_1 = require("../logging");
const ProxiedApp_1 = require("../ProxiedApp");
const runtime_1 = require("../runtime");
const require_1 = require("../runtime/require");
class AppCompiler {
    normalizeStorageFiles(files) {
        const result = {};
        Object.entries(files).forEach(([name, content]) => {
            result[name.replace(/\$/g, '.')] = content;
        });
        return result;
    }
    toSandBox(manager, storage, { files }) {
        if (typeof files[path.normalize(storage.info.classFile)] === 'undefined') {
            throw new Error(`Invalid App package for "${storage.info.name}". ` +
                `Could not find the classFile (${storage.info.classFile}) file.`);
        }
        const Runtime = runtime_1.getRuntime();
        const customRequire = require_1.buildCustomRequire(files, storage.info.id);
        const result = Runtime.runCode(files[path.normalize(storage.info.classFile)], {
            require: customRequire,
        });
        if (typeof result !== 'function') {
            // tslint:disable-next-line:max-line-length
            throw new Error(`The App's main class for ${storage.info.name} is not valid ("${storage.info.classFile}").`);
        }
        const appAccessors = new accessors_1.AppAccessors(manager, storage.info.id);
        const logger = new logging_1.AppConsole(metadata_1.AppMethod._CONSTRUCTOR);
        const rl = Runtime.runCode('exports.app = new App(info, rcLogger, appAccessors);', {
            rcLogger: logger,
            info: storage.info,
            App: result,
            appAccessors,
        }, { timeout: 1000, filename: `App_${storage.info.nameSlug}.js` });
        // TODO: app is importing the Class App internally so it's not same object to compare. Need to find a way to make this test
        // if (!(rl instanceof App)) {
        //     throw new MustExtendAppError();
        // }
        if (typeof rl.getName !== 'function') {
            throw new errors_1.MustContainFunctionError(storage.info.classFile, 'getName');
        }
        if (typeof rl.getNameSlug !== 'function') {
            throw new errors_1.MustContainFunctionError(storage.info.classFile, 'getNameSlug');
        }
        if (typeof rl.getVersion !== 'function') {
            throw new errors_1.MustContainFunctionError(storage.info.classFile, 'getVersion');
        }
        if (typeof rl.getID !== 'function') {
            throw new errors_1.MustContainFunctionError(storage.info.classFile, 'getID');
        }
        if (typeof rl.getDescription !== 'function') {
            throw new errors_1.MustContainFunctionError(storage.info.classFile, 'getDescription');
        }
        if (typeof rl.getRequiredApiVersion !== 'function') {
            throw new errors_1.MustContainFunctionError(storage.info.classFile, 'getRequiredApiVersion');
        }
        // TODO: Fix this type cast from to any to the right one
        const app = new ProxiedApp_1.ProxiedApp(manager, storage, rl, new Runtime(rl, customRequire));
        manager.getLogStorage().storeEntries(app.getID(), logger);
        return app;
    }
}
exports.AppCompiler = AppCompiler;

//# sourceMappingURL=AppCompiler.js.map
