"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppSlashCommand = void 0;
const metadata_1 = require("../../definition/metadata");
class AppSlashCommand {
    constructor(app, slashCommand) {
        this.app = app;
        this.slashCommand = slashCommand;
        this.isRegistered = false;
        this.isEnabled = false;
        this.isDisabled = false;
    }
    hasBeenRegistered() {
        this.isDisabled = false;
        this.isEnabled = true;
        this.isRegistered = true;
    }
    canBeRan(method) {
        return this.app.hasMethod(method);
    }
    runExecutorOrPreviewer(method, context, logStorage, accessors) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.runTheCode(method, logStorage, accessors, context, new Array());
        });
    }
    runPreviewExecutor(previewItem, context, logStorage, accessors) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.runTheCode(metadata_1.AppMethod._COMMAND_PREVIEW_EXECUTOR, logStorage, accessors, context, [previewItem]);
            return;
        });
    }
    runTheCode(method, logStorage, accessors, context, runContextArgs) {
        return __awaiter(this, void 0, void 0, function* () {
            const command = this.slashCommand.command;
            // Ensure the slash command has the property before going on
            if (typeof this.slashCommand[method] !== 'function') {
                return;
            }
            const logger = this.app.setupLogger(method);
            logger.debug(`${command}'s ${method} is being executed...`, context);
            try {
                const runCode = `module.exports = slashCommand.${method}.apply(slashCommand, args)`;
                const result = yield this.app.getRuntime().runInSandbox(runCode, {
                    slashCommand: this.slashCommand,
                    args: [
                        ...runContextArgs,
                        context,
                        accessors.getReader(this.app.getID()),
                        accessors.getModifier(this.app.getID()),
                        accessors.getHttp(this.app.getID()),
                        accessors.getPersistence(this.app.getID()),
                    ],
                });
                logger.debug(`${command}'s ${method} was successfully executed.`);
                return result;
            }
            catch (e) {
                logger.error(e);
                logger.debug(`${command}'s ${method} was unsuccessful.`);
            }
            finally {
                yield logStorage.storeEntries(this.app.getID(), logger);
            }
        });
    }
}
exports.AppSlashCommand = AppSlashCommand;

//# sourceMappingURL=AppSlashCommand.js.map
