import { AppMethod } from '../../definition/metadata';
import { IVideoConferenceUser } from '../../definition/videoConferences/IVideoConferenceUser';
import type { IVideoConferenceOptions, IVideoConfProvider, VideoConfData, VideoConfDataExtended } from '../../definition/videoConfProviders';
import { ProxiedApp } from '../ProxiedApp';
import { AppLogStorage } from '../storage';
import { AppAccessorManager } from './AppAccessorManager';
export declare class AppVideoConfProvider {
    app: ProxiedApp;
    provider: IVideoConfProvider;
    /**
     * States whether this provider has been registered into the Rocket.Chat system or not.
     */
    isRegistered: boolean;
    constructor(app: ProxiedApp, provider: IVideoConfProvider);
    hasBeenRegistered(): void;
    canBeRan(method: AppMethod): boolean;
    runIsFullyConfigured(logStorage: AppLogStorage, accessors: AppAccessorManager): Promise<boolean>;
    runGenerateUrl(call: VideoConfData, logStorage: AppLogStorage, accessors: AppAccessorManager): Promise<string>;
    runCustomizeUrl(call: VideoConfDataExtended, user: IVideoConferenceUser | undefined, options: IVideoConferenceOptions, logStorage: AppLogStorage, accessors: AppAccessorManager): Promise<string>;
    private runTheCode;
}
