"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppVideoConfProvider = void 0;
const metadata_1 = require("../../definition/metadata");
class AppVideoConfProvider {
    constructor(app, provider) {
        this.app = app;
        this.provider = provider;
        this.isRegistered = false;
    }
    hasBeenRegistered() {
        this.isRegistered = true;
    }
    canBeRan(method) {
        return this.app.hasMethod(method);
    }
    runIsFullyConfigured(logStorage, accessors) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof this.provider[metadata_1.AppMethod._VIDEOCONF_IS_CONFIGURED] !== 'function') {
                return true;
            }
            return !!(yield this.runTheCode(metadata_1.AppMethod._VIDEOCONF_IS_CONFIGURED, logStorage, accessors, []));
        });
    }
    runGenerateUrl(call, logStorage, accessors) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.runTheCode(metadata_1.AppMethod._VIDEOCONF_GENERATE_URL, logStorage, accessors, [call]);
        });
    }
    runCustomizeUrl(call, user, options = {}, logStorage, accessors) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.runTheCode(metadata_1.AppMethod._VIDEOCONF_CUSTOMIZE_URL, logStorage, accessors, [call, user, options]);
        });
    }
    runTheCode(method, logStorage, accessors, runContextArgs) {
        return __awaiter(this, void 0, void 0, function* () {
            // Ensure the provider has the property before going on
            if (typeof this.provider[method] !== 'function') {
                return;
            }
            const runContext = {
                provider: this.provider,
                args: [
                    ...runContextArgs,
                    accessors.getReader(this.app.getID()),
                    accessors.getModifier(this.app.getID()),
                    accessors.getHttp(this.app.getID()),
                    accessors.getPersistence(this.app.getID()),
                ],
            };
            const logger = this.app.setupLogger(method);
            logger.debug(`Executing ${method} on video conference provider...`);
            let result;
            try {
                const runCode = `module.exports = provider.${method}.apply(provider, args)`;
                result = yield this.app.getRuntime().runInSandbox(runCode, runContext);
                logger.debug(`Video Conference Provider's ${method} was successfully executed.`);
            }
            catch (e) {
                logger.error(e);
                logger.debug(`Video Conference Provider's ${method} was unsuccessful.`);
            }
            try {
                yield logStorage.storeEntries(this.app.getID(), logger);
            }
            catch (e) {
                // Don't care, at the moment.
                // TODO: Evaluate to determine if we do care
            }
            return result;
        });
    }
}
exports.AppVideoConfProvider = AppVideoConfProvider;

//# sourceMappingURL=AppVideoConfProvider.js.map
