import { IVideoConferenceUser } from '../../definition/videoConferences/IVideoConferenceUser';
import type { IVideoConferenceOptions, IVideoConfProvider, VideoConfData, VideoConfDataExtended } from '../../definition/videoConfProviders';
import { AppManager } from '../AppManager';
export declare class AppVideoConfProviderManager {
    private readonly manager;
    private readonly accessors;
    private readonly bridge;
    private videoConfProviders;
    private providerApps;
    constructor(manager: AppManager);
    canProviderBeTouchedBy(appId: string, providerName: string): boolean;
    isAlreadyDefined(providerName: string): boolean;
    addProvider(appId: string, provider: IVideoConfProvider): void;
    registerProviders(appId: string): void;
    unregisterProviders(appId: string): void;
    isFullyConfigured(providerName: string): Promise<boolean>;
    generateUrl(providerName: string, call: VideoConfData): Promise<string>;
    customizeUrl(providerName: string, call: VideoConfDataExtended, user?: IVideoConferenceUser, options?: IVideoConferenceOptions): Promise<string>;
    private retrieveProviderInfo;
    private linkAppProvider;
    private registerProvider;
    private unregisterProvider;
}
