"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppsEngineVM2Runtime = void 0;
const path = require("path");
const timers = require("timers");
const vm2_1 = require("vm2");
const AppsEngineRuntime_1 = require("./AppsEngineRuntime");
class AppsEngineVM2Runtime extends AppsEngineRuntime_1.AppsEngineRuntime {
    constructor(app, customRequire) {
        super(app, customRequire);
        this.app = app;
        this.vm = new vm2_1.NodeVM(Object.assign(Object.assign({}, AppsEngineVM2Runtime.defaultNodeVMOptions), { require: { customRequire } }));
    }
    static runCode(code, sandbox, options) {
        const vmOptions = Object.assign(Object.assign({}, AppsEngineVM2Runtime.defaultNodeVMOptions), { timeout: options === null || options === void 0 ? void 0 : options.timeout, sandbox: Object.assign(Object.assign({}, AppsEngineVM2Runtime.defaultNodeVMOptions.sandbox), (sandbox || {})) });
        const resolve = sandbox && sandbox.require;
        if (resolve instanceof Function) {
            vmOptions.require = {
                external: ['@rocket.chat/apps-engine', 'uuid'],
                builtin: ['path', 'url', 'crypto', 'buffer', 'stream', 'net', 'http', 'https', 'zlib', 'util', 'punycode', 'os', 'querystring'],
                resolve: (moduleName, p) => {
                    return path.resolve(p + '/npm/node_modules/' + moduleName);
                },
                context: 'sandbox',
            };
            delete sandbox.require;
        }
        const vm = new vm2_1.NodeVM(vmOptions);
        const app = vm.run(code, {
            filename: (options === null || options === void 0 ? void 0 : options.filename) || 'app.js',
            require: (mod) => resolve(mod, vm.require.bind(vm)),
        });
        // Get first exported object, vm2 does not return the last value when it's an assignment as intern vm
        // so we use the first exported value as the class.
        return (options === null || options === void 0 ? void 0 : options.returnAllExports) ? app : app && app[Object.keys(app)[0]];
    }
    runInSandbox(code, sandbox, options) {
        return __awaiter(this, void 0, void 0, function* () {
            sandbox !== null && sandbox !== void 0 ? sandbox : (sandbox = {});
            this.vm.setGlobals(sandbox);
            const result = yield this.vm.run(code, {
                filename: AppsEngineRuntime_1.getFilenameForApp((options === null || options === void 0 ? void 0 : options.filename) || this.app.getName()),
            });
            // Clean up the sandbox after the code has run
            this.vm.setGlobals(Object.keys(sandbox).reduce((acc, key) => {
                acc[key] = undefined;
                return acc;
            }, {}));
            return result;
        });
    }
}
exports.AppsEngineVM2Runtime = AppsEngineVM2Runtime;
AppsEngineVM2Runtime.defaultNodeVMOptions = {
    console: 'inherit',
    // wrapper: 'none',
    timeout: AppsEngineRuntime_1.APPS_ENGINE_RUNTIME_DEFAULT_TIMEOUT,
    // we don't need any compiling happening
    compiler: (code, filename) => code,
    // We keep require inaccessible here as we expect it to be provided
    // require: false,
    sandbox: Object.assign({ Buffer }, timers),
};

//# sourceMappingURL=AppsEngineVM2Runtime.js.map
