"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildCustomRequire = exports.allowedInternalModuleRequire = exports.transformModuleForCustomRequire = exports.transformFallbackModuleForCustomRequire = void 0;
const path = require("path");
const _1 = require(".");
const modules_1 = require("../compiler/modules");
/**
 * Keeps compatibility with apps compiled and stored in the database
 * with previous Apps-Engine versions
 */
function transformFallbackModuleForCustomRequire(moduleName) {
    return path.normalize(moduleName).replace(/\.\.?\//g, '').replace(/^\//, '') + '.ts';
}
exports.transformFallbackModuleForCustomRequire = transformFallbackModuleForCustomRequire;
function transformModuleForCustomRequire(moduleName) {
    return path.normalize(moduleName).replace(/\.\.?\//g, '').replace(/^\//, '') + '.js';
}
exports.transformModuleForCustomRequire = transformModuleForCustomRequire;
function allowedInternalModuleRequire(moduleName) {
    return moduleName in modules_1.AllowedInternalModules;
}
exports.allowedInternalModuleRequire = allowedInternalModuleRequire;
function buildCustomRequire(files, appId, currentPath = '.') {
    return function _requirer(mod, requirer) {
        // Keep compatibility with apps importing apps-ts-definition
        if (mod.startsWith('@rocket.chat/apps-ts-definition/')) {
            if (requirer) {
                return requirer(mod);
            }
            mod = path.normalize(mod);
            mod = mod.replace('@rocket.chat/apps-ts-definition/', '../../definition/');
            return require(mod);
        }
        if (mod.startsWith('@rocket.chat/apps-engine/definition/')) {
            if (requirer) {
                return requirer(mod);
            }
            mod = path.normalize(mod);
            mod = mod.replace('@rocket.chat/apps-engine/definition/', '../../definition/');
            return require(mod);
        }
        if (allowedInternalModuleRequire(mod)) {
            // TODO: Need to use the vm2 require in this function and evaluate the necessity of the proxies
            return modules_1.requireNativeModule(mod, appId, requirer);
        }
        if (currentPath !== '.') {
            mod = path.join(currentPath, mod);
        }
        const transformedModule = transformModuleForCustomRequire(mod);
        const fallbackModule = transformFallbackModuleForCustomRequire(mod);
        const filename = files[transformedModule] ? transformedModule : files[fallbackModule] ? fallbackModule : undefined;
        if (!filename) {
            return;
        }
        const Runtime = _1.getRuntime();
        // TODO: specify correct file name
        return Runtime.runCode(files[filename], {
            require: buildCustomRequire(files, appId, path.dirname(filename) + '/'),
        }, {
            returnAllExports: true,
            filename,
        });
    };
}
exports.buildCustomRequire = buildCustomRequire;

//# sourceMappingURL=require.js.map
