'use strict';

function isPath(path) {
    return typeof path === 'string';
}

function isContents(contents) {
    return typeof contents === 'string' || Buffer.isBuffer(contents);
}

function memory(config) {
    if ( config === void 0 ) config = {};

    var path = isPath(config.path) ? config.path : null;
    var contents = isContents(config.contents) ? String(config.contents) : null;

    return {
        options: function options(options) {
            var entry = options.entry;
            if (entry && typeof entry === 'object') {
                if (isPath(entry.path)) {
                    path = entry.path;
                }
                if (isContents(entry.contents)) {
                    contents = String(entry.contents);
                }
            }
            options.entry = path;
        },

        resolveId: function resolveId(id) {
            if (path === null || contents === null) {
                throw Error('\'path\' should be a string and \'contents\' should be a string of Buffer');
            }
            if (id === path) {
                return path;
            }
        },

        load: function load(id) {
            if (id === path) {
                return contents;
            }
        }
    };
}

module.exports = memory;