"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("mz/fs");
const path = require("path");
const camelcase = require("camelcase");
const postcss = require("rollup-plugin-postcss");
const postcssModules = require("postcss-modules");
const formatCSSDefinition = (name, classNames) => `\
declare namespace ${name} {
	${classNames.map(t => `const ${t}: string`).join('\n\t')}
}
export default ${name}`;
function writeCSSDefinition(cssPath, classNames) {
    return __awaiter(this, void 0, void 0, function* () {
        const name = camelcase(path.basename(cssPath, '.css'));
        const definition = formatCSSDefinition(name, classNames);
        const dPath = `${cssPath}.d.ts`;
        yield fs.writeFile(dPath, `${definition}\n`);
        return dPath;
    });
}
class CSSExports {
    constructor(writeDefinitions) {
        this.definitionCB = (dPath) => __awaiter(this, void 0, void 0, function* () {
            if (typeof this.writeDefinitions === 'function') {
                yield Promise.resolve(this.writeDefinitions(dPath));
            }
            else {
                console.log(`${dPath} written`);
            }
        });
        this.getJSON = (id, exportTokens) => __awaiter(this, void 0, void 0, function* () {
            const ccTokens = {};
            for (const className of Object.keys(exportTokens)) {
                ccTokens[camelcase(className)] = exportTokens[className];
            }
            if (this.writeDefinitions) {
                const dPath = yield writeCSSDefinition(id, Object.keys(ccTokens));
                yield this.definitionCB(dPath);
            }
            this.exports[id] = ccTokens;
        });
        this.getExport = (id) => this.exports[id];
        this.writeDefinitions = writeDefinitions;
        this.exports = {};
    }
}
function eslintPluginPostCSSModules(options = {}) {
    const { plugins = [], writeDefinitions = false, modules = {} } = options, rest = __rest(options, ["plugins", "writeDefinitions", "modules"]);
    if (rest.getExport) {
        throw new Error("rollup-plugin-postcss-modules' provides getExport, you cannot specify your own.");
    }
    if (plugins.some(p => p.postcssPlugin === 'postcss-modules')) {
        throw new Error("'rollup-plugin-postcss-modules' provides a 'postcss-modules' plugin, you cannot specify your own. Use `postcssModulesOptions` for configuration.");
    }
    if (modules.getJSON) {
        throw new Error("'rollup-plugin-postcss-modules' provides a 'postcss-modules' plugin and its `getJSON()`. You cannot specify `modules.getJSON`.");
    }
    const { getExport, getJSON } = new CSSExports(writeDefinitions);
    const postcssModulesPlugin = postcssModules(Object.assign({ getJSON }, modules));
    return postcss(Object.assign({ plugins: [postcssModulesPlugin, ...plugins], getExport }, rest));
}
exports.default = eslintPluginPostCSSModules;
//# sourceMappingURL=index.js.map