import { Node } from '../ast/nodes/shared/Node';
import MagicString from 'magic-string';
import { DynamicImportMechanism } from '../Chunk';
export interface RenderOptions {
    legacy: boolean;
    freeze: boolean;
    namespaceToStringTag: boolean;
    indent: string;
    importMechanism?: DynamicImportMechanism;
    systemBindings: boolean;
}
export interface NodeRenderOptions {
    start?: number;
    end?: number;
    isNoStatement?: boolean;
}
export declare const NO_SEMICOLON: NodeRenderOptions;
export declare function findFirstOccurrenceOutsideComment(code: string, searchString: string, start?: number): number;
export declare function renderStatementList(statements: Node[], code: MagicString, start: number, end: number, options: RenderOptions): void;
export declare function getCommaSeparatedNodesWithBoundaries<N extends Node>(nodes: N[], code: MagicString, start: number, end: number): ({
    node: N;
    start: number;
    separator: number | null;
    contentEnd: number;
    end: number;
})[];
