import dateutil from '../dateutil';
import { pymod, isPresent, includes } from '../helpers';
export function buildPoslist(bysetpos, timeset, start, end, ii, dayset) {
    var poslist = [];
    for (var j = 0; j < bysetpos.length; j++) {
        var daypos = void 0;
        var timepos = void 0;
        var pos = bysetpos[j];
        if (pos < 0) {
            daypos = Math.floor(pos / timeset.length);
            timepos = pymod(pos, timeset.length);
        }
        else {
            daypos = Math.floor((pos - 1) / timeset.length);
            timepos = pymod(pos - 1, timeset.length);
        }
        var tmp = [];
        for (var k = start; k < end; k++) {
            var val = dayset[k];
            if (!isPresent(val))
                continue;
            tmp.push(val);
        }
        var i = void 0;
        if (daypos < 0) {
            i = tmp.slice(daypos)[0];
        }
        else {
            i = tmp[daypos];
        }
        var time = timeset[timepos];
        var date = dateutil.fromOrdinal(ii.yearordinal + i);
        var res = dateutil.combine(date, time);
        // XXX: can this ever be in the array?
        // - compare the actual date instead?
        if (!includes(poslist, res))
            poslist.push(res);
    }
    dateutil.sort(poslist);
    return poslist;
}
//# sourceMappingURL=poslist.js.map