# Master

* [Bugfix] fix regression in denodeify that broke foreign thenables as arguments to denodeifed functions [#281](https://github.com/tildeio/rsvp.js/pull/281)

# 3.0.11

* [Bugfix] some onerror scenarios did not result in error notifications [4dcf](https://github.com/tildeio/rsvp.js/commit/4dcfa92bab6f5fc9e97ca3abfb71025a08984e7e)
* [Bugfix] for more correctness internal optimization should only occure
  if constructors equal, not just if instanceof check passes [96b5ec](https://github.com/tildeio/rsvp.js/commit/96b5ec201b2ddafc70cd5c836bc341a46081ae23)
* fancy new s3 publishing thanks to @rondale-sc

# 3.0.10

* faster denodeify
* rework tooling (Broccoli, testem, no grunt)
* utilize bundle format for super small UMD builds

# 3.0.9
* [Bugfix] no longer include promise-aplus tests as a production
  dependency
* [Enhancement] fast then path for both rejection/fulfilment [0d252](https://github.com/tildeio/rsvp.js/commit/0d252ed4831eabb82991584e2e3eaae2a3a2ba42)
* [Enhancement] short-cut for faster then chaining in specific scenarios
  [#256](https://github.com/tildeio/rsvp.js/pull/256)

# 3.0.8
* [Bugfix] custom onerror handler, for potentially unhandled errors
  would report unhandled errors in some incorrect scenarios.
[#255](https://github.com/tildeio/rsvp.js/pull/255)

# 3.0.7

* improve tests in some older es5+ browsers
* [Bugfix] denodeify should not use console for deprecation warning unless console is defined
* [Enhancement] instrumentation should emit out-of-band. This should improve ember-extension performance
* [Bugfix] race should not be susceptible to zalgo
* [Perf] PromiseEnumerator increase performance of all enumerable methods all/allSettled/hash/hasSettled -> https://gist.github.com/stefanpenner/26465d5848f2924e2aca
* [Docfix] Fix small documentation inconsistency
* [Perf] an internal promise shouldn't bother validating `this` and `resolver`
* [Perf] flatten asap’s QUEUE structure
* [Perf] Reduce Constructor AST size.
* [Perf] some versions of v8, think keep marking these functions to be optimized. This hints to them not to be.
* [Perf] accidental resolve step, that merely needed to be a fulfill
* [Perf/Enhancement] simplify publishing
* [Spec ADdition]add spec test “Ensure `then` is always called with a clean stack.” ensure RSVP passes future a+ spec
* [Bugfix] web worker support
* [Docfix] Add a param name to make yuidoc happy
* [Enhancement] simplify async vs sync pub/sub code-paths
* [Bugfix] Passed the label through to the Promise object, as expected
* [Docfix] missing Parentheses on promise example in documentation
* [License] Add Stefan Penner to license
* [Docfix] document `var promises` in filter.js

# 3.0.3 -> 3.0.6 (missing changelog)

* Changes to RSVP.denodeify: Behaviour for multiple success callback parameters
  has been improved and the denodefied function now inherits from the original
  node function.

# 3.0.2

* [Spec compliance] Promise.all and Promise.race should reject, not throw on invalid input
* Add RSVP.allSettled

# 3.0.1

* Optimization: promises with noop resolvers now don't bother try to handle them.
* [perf] skip costly resolver invocation if it is known not to be needed.
* improve promise inspector interopt

# 3.0.0

* align with the promise spec
  https://github.com/domenic/promises-unwrapping
* idiomatic es6 usage
* RSVP.all: now now casts rather then resolves, and doesn't touch the
  "then"
* RSVP.hash: now now casts rather then resolves, and doesn't touch the
  "then"
* MutationObserver: prefer text mutation, this fixes interop with
  MutationObserver polyfils
* Removing asap unload listener. Allows back/forward page cache, chrome
  bug is old. Fixes #168
* add grunt docs task
* document: Promise.cast
* document: Promise.resolve/Promise.reject
* document: Promise.race
* document: Promise.all
* document: Promise.hash
* document: RSVP.denodeify
* document: RSVP.EventTarget
* document: RSVP.rethrow
* document: RSVP.defer
* Document: RSVP.on('error'
* Add Instrumentation hooks for tooling
* Significant internal cleanup and performance improvements
* require Promise constructor to be new'd (aligned with es6 spec)
* Prefer tasks + config inline within project
* Add Promise#finally
* Add Promise.cast
* Add Promise.resolve
* Add Promise.reject
* Add Promise.all
* Add Promise.race
* Add RSVP.map
* Support promise inheritance
* optimize onerror and reduce promise creation cost by 20x
* promise/a+ 2.0.3 compliant
* RSVP.async to schedule callbacks on internal queue
* Optimization: only enforce a single nextTick for each queue flush.

# 2.0.4

* Fix npm package

# 2.0.3

* Fix useSetTimeout bug

# 2.0.2

* Adding RSVP#rethrow
* add pre-built AMD link to README
* adding promise#fail

# 2.0.1
* misc IE fixes, including IE array detection
* upload passing builds to s3
* async: use three args for addEventListener
* satisfy both 1.0 and 1.1 specs
* Run reduce tests only in node
* RSVP.resolve now simply uses the internal resolution procedure
* prevent multiple promise resolutions
* simplify thenable handling
* pre-allocate the deferred's shape
* Moved from Rake-based builds to Grunt
* Fix Promise subclassing bug
* Add RSVP.configure('onerror')
* Throw exception when RSVP.all is called without an array
* refactor RSVP.all to just use a promise directly
* Make `RSVP.denodeify` pass along `thisArg`
* add RSVP.reject
* Reject promise if resolver function throws an exception
* add travis build-status
* correctly test and fix self fulfillment
* remove promise coercion.
* Fix infinite recursion with deep self fulfilling promises
* doc fixes

# 2.0.0

* No changelog beyond this point. Here be dragons.
