
// We are modularizing this manually because the current modularize setting in Emscripten has some issues:
// https://github.com/kripken/emscripten/issues/5820
// In addition, When you use emcc's modularization, it still expects to export a global object called `Module`,
// which is able to be used/called before the WASM is loaded.
// The modularization below exports a promise that loads and resolves to the actual sql.js module.
// That way, this module can't be used before the WASM is finished loading.

// We are going to define a function that a user will call to start loading initializing our Sql.js library
// However, that function might be called multiple times, and on subsequent calls, we don't actually want it to instantiate a new instance of the Module
// Instead, we want to return the previously loaded module

// TODO: Make this not declare a global if used in the browser
var initSqlJsPromise = undefined;

var initSqlJs = function (moduleConfig) {

    if (initSqlJsPromise){
      return initSqlJsPromise;
    }
    // If we're here, we've never called this function before
    initSqlJsPromise = new Promise((resolveModule, reject) => {

        // We are modularizing this manually because the current modularize setting in Emscripten has some issues:
        // https://github.com/kripken/emscripten/issues/5820

        // The way to affect the loading of emcc compiled modules is to create a variable called `Module` and add
        // properties to it, like `preRun`, `postRun`, etc
        // We are using that to get notified when the WASM has finished loading.
        // Only then will we return our promise

        // If they passed in a moduleConfig object, use that
        // Otherwise, initialize Module to the empty object
        var Module = typeof moduleConfig !== 'undefined' ? moduleConfig : {};

        // EMCC only allows for a single onAbort function (not an array of functions)
        // So if the user defined their own onAbort function, we remember it and call it
        var originalOnAbortFunction = Module['onAbort'];
        Module['onAbort'] = function (errorThatCausedAbort) {
            reject(new Error(errorThatCausedAbort));
            if (originalOnAbortFunction){
              originalOnAbortFunction(errorThatCausedAbort);
            }
        };

        Module['postRun'] = Module['postRun'] || [];
        Module['postRun'].push(function () {
            // When Emscripted calls postRun, this promise resolves with the built Module
            resolveModule(Module);
        });

        // There is a section of code in the emcc-generated code below that looks like this:
        // (Note that this is lowercase `module`)
        // if (typeof module !== 'undefined') {
        //     module['exports'] = Module;
        // }
        // When that runs, it's going to overwrite our own modularization export efforts in shell-post.js!
        // The only way to tell emcc not to emit it is to pass the MODULARIZE=1 or MODULARIZE_INSTANCE=1 flags,
        // but that carries with it additional unnecessary baggage/bugs we don't want either.
        // So, we have three options:
        // 1) We undefine `module`
        // 2) We remember what `module['exports']` was at the beginning of this function and we restore it later
        // 3) We write a script to remove those lines of code as part of the Make process.
        //
        // Since those are the only lines of code that care about module, we will undefine it. It's the most straightforward
        // of the options, and has the side effect of reducing emcc's efforts to modify the module if its output were to change in the future.
        // That's a nice side effect since we're handling the modularization efforts ourselves
        module = undefined;
        
        // The emcc-generated code and shell-post.js code goes below,
        // meaning that all of it runs inside of this promise. If anything throws an exception, our promise will abort
var aa;var f;f||(f=typeof Module !== 'undefined' ? Module : {});
var wa=function(){var a;var b=h(4);var c={};var d=function(){function a(a,b){this.ga=a;this.db=b;this.oa=1;this.Ha=[]}a.prototype.bind=function(a){if(!this.ga)throw"Statement closed";this.reset();return Array.isArray(a)?this.pb(a):this.qb(a)};a.prototype.step=function(){var a;if(!this.ga)throw"Statement closed";this.oa=1;switch(a=cc(this.ga)){case c.lb:return!0;case c.DONE:return!1;default:return this.db.handleError(a)}};a.prototype.wb=function(a){null==a&&(a=this.oa++);return dc(this.ga,a)};a.prototype.xb=
function(a){null==a&&(a=this.oa++);return ec(this.ga,a)};a.prototype.getBlob=function(a){var b;null==a&&(a=this.oa++);var c=fc(this.ga,a);var d=hc(this.ga,a);var e=new Uint8Array(c);for(a=b=0;0<=c?b<c:b>c;a=0<=c?++b:--b)e[a]=l[d+a];return e};a.prototype.get=function(a){var b,d;null!=a&&this.bind(a)&&this.step();var e=[];a=b=0;for(d=ob(this.ga);0<=d?b<d:b>d;a=0<=d?++b:--b)switch(ic(this.ga,a)){case c.kb:case c.FLOAT:e.push(this.wb(a));break;case c.mb:e.push(this.xb(a));break;case c.cb:e.push(this.getBlob(a));
break;default:e.push(null)}return e};a.prototype.getColumnNames=function(){var a,b;var c=[];var d=a=0;for(b=ob(this.ga);0<=b?a<b:a>b;d=0<=b?++a:--a)c.push(jc(this.ga,d));return c};a.prototype.getAsObject=function(a){var b,c;var d=this.get(a);var e=this.getColumnNames();var g={};a=b=0;for(c=e.length;b<c;a=++b){var Ma=e[a];g[Ma]=d[a]}return g};a.prototype.run=function(a){null!=a&&this.bind(a);this.step();return this.reset()};a.prototype.tb=function(a,b){var c;null==b&&(b=this.oa++);a=ba(a);this.Ha.push(c=
ca(a));this.db.handleError(da(this.ga,b,c,a.length-1,0))};a.prototype.ob=function(a,b){var c;null==b&&(b=this.oa++);this.Ha.push(c=ca(a));this.db.handleError(Na(this.ga,b,c,a.length,0))};a.prototype.sb=function(a,b){null==b&&(b=this.oa++);this.db.handleError((a===(a|0)?kc:lc)(this.ga,b,a))};a.prototype.rb=function(a){null==a&&(a=this.oa++);Na(this.ga,a,0,0,0)};a.prototype.Ta=function(a,b){null==b&&(b=this.oa++);switch(typeof a){case "string":this.tb(a,b);break;case "number":case "boolean":this.sb(a+
0,b);break;case "object":if(null===a)this.rb(b);else if(null!=a.length)this.ob(a,b);else throw"Wrong API use : tried to bind a value of an unknown type ("+a+").";}};a.prototype.qb=function(a){var b;for(b in a){var c=a[b];var d=mc(this.ga,b);0!==d&&this.Ta(c,d)}return!0};a.prototype.pb=function(a){var b,c;var d=b=0;for(c=a.length;b<c;d=++b){var e=a[d];this.Ta(e,d+1)}return!0};a.prototype.reset=function(){this.freemem();return nc(this.ga)===c.Aa&&oc(this.ga)===c.Aa};a.prototype.freemem=function(){for(var a;a=
this.Ha.pop();)fa(a);return null};a.prototype.free=function(){this.freemem();var a=pc(this.ga)===c.Aa;delete this.db.Ea[this.ga];this.ga=ea;return a};return a}();var e=function(){function a(a){this.filename="dbfile_"+(4294967295*Math.random()>>>0);if(null!=a){var c=this.filename,d=c?m("/",c):"/";c=ia(!0,!0);d=ja(d,(void 0!==c?c:438)&4095|32768,0);if(a){if("string"===typeof a){for(var e=Array(a.length),k=0,Ma=a.length;k<Ma;++k)e[k]=a.charCodeAt(k);a=e}ka(d,c|146);e=p(d,"w");la(e,a,0,a.length,0,void 0);
ma(e);ka(d,c)}}this.handleError(g(this.filename,b));this.db=q(b,"i32");qc(this.db);this.Ea={};this.qa={}}a.prototype.run=function(a,c){if(!this.db)throw"Database closed";c?(a=this.prepare(a,c),a.step(),a.free()):this.handleError(n(this.db,a,0,0,b));return this};a.prototype.exec=function(a){if(!this.db)throw"Database closed";var c=na();var e=oa(a)+1;var g=h(e);r(a,l,g,e);a=g;e=h(4);for(g=[];q(a,"i8")!==ea;){pa(b);pa(e);this.handleError(ha(this.db,a,-1,b,e));var k=q(b,"i32");a=q(e,"i32");if(k!==ea){var n=
new d(k,this);for(k=null;n.step();)null===k&&(k={columns:n.getColumnNames(),values:[]},g.push(k)),k.values.push(n.get());n.free()}}qa(c);return g};a.prototype.each=function(a,b,c,d){"function"===typeof b&&(d=c,c=b,b=void 0);for(a=this.prepare(a,b);a.step();)c(a.getAsObject());a.free();if("function"===typeof d)return d()};a.prototype.prepare=function(a,c){pa(b);this.handleError(A(this.db,a,-1,b,ea));a=q(b,"i32");if(a===ea)throw"Nothing to prepare";var e=new d(a,this);null!=c&&e.bind(c);return this.Ea[a]=
e};a.prototype["export"]=function(){var a;var c=this.Ea;for(e in c){var d=c[e];d.free()}d=this.qa;for(e in d)c=d[e],t[c-ra]=null;this.qa={};this.handleError(k(this.db));d=this.filename;var e=e={encoding:"binary"};e.flags=e.flags||"r";e.encoding=e.encoding||"binary";if("utf8"!==e.encoding&&"binary"!==e.encoding)throw Error('Invalid encoding type "'+e.encoding+'"');c=p(d,e.flags);d=sa(d).size;var n=new Uint8Array(d);ta(c,n,0,d,0);"utf8"===e.encoding?a=u(n,0):"binary"===e.encoding&&(a=n);ma(c);this.handleError(g(this.filename,
b));this.db=q(b,"i32");return a};a.prototype.close=function(){var a;var b=this.Ea;for(a in b){var c=b[a];c.free()}c=this.qa;for(a in c)b=c[a],t[b-ra]=null;this.qa={};this.handleError(k(this.db));ua("/"+this.filename);return this.db=null};a.prototype.handleError=function(a){if(a===c.Aa)return null;a=rc(this.db);throw Error(a);};a.prototype.getRowsModified=function(){return v(this.db)};a.prototype.create_function=function(a,b){a in this.qa&&(t[this.qa[a]-ra]=null,delete this.qa[a]);var d=va(function(a,
c,d){var e,g;var k=[];for(e=g=0;0<=c?g<c:g>c;e=0<=c?++g:--g){var n=q(d+4*e,"i32");var A=tc(n);e=function(){switch(!1){case 1!==A:return tb;case 2!==A:return tb;case 3!==A:return uc;case 4!==A:return function(a){var b,c;var d=wc(a);var e=xc(a);a=new Uint8Array(d);for(b=c=0;0<=d?c<d:c>d;b=0<=d?++c:--c)a[b]=l[e+b];return a};default:return function(){return null}}}();e=e(n);k.push(e)}try{var v=b.apply(null,k)}catch(vc){v=vc;ub(a,v,-1);return}switch(typeof v){case "boolean":yc(a,v?1:0);break;case "number":zc(a,
v);break;case "string":Ac(a,v,-1,-1);break;case "object":null===v?vb(a):null!=v.length?(c=ca(v),Bc(a,c,v.length,-1),fa(c)):ub(a,"Wrong API use : tried to return a value of an unknown type ("+v+").",-1);break;default:vb(a)}});this.qa[a]=d;this.handleError(Cc(this.db,a,b.length,c.nb,0,d,0,0,0));return this};return a}();var g=f.cwrap("sqlite3_open","number",["string","number"]);var k=f.cwrap("sqlite3_close_v2","number",["number"]);var n=f.cwrap("sqlite3_exec","number",["number","string","number","number",
"number"]);f.cwrap("sqlite3_free","",["number"]);var v=f.cwrap("sqlite3_changes","number",["number"]);var A=f.cwrap("sqlite3_prepare_v2","number",["number","string","number","number","number"]);var ha=f.cwrap("sqlite3_prepare_v2","number",["number","number","number","number","number"]);var da=f.cwrap("sqlite3_bind_text","number",["number","number","number","number","number"]);var Na=f.cwrap("sqlite3_bind_blob","number",["number","number","number","number","number"]);var lc=f.cwrap("sqlite3_bind_double",
"number",["number","number","number"]);var kc=f.cwrap("sqlite3_bind_int","number",["number","number","number"]);var mc=f.cwrap("sqlite3_bind_parameter_index","number",["number","string"]);var cc=f.cwrap("sqlite3_step","number",["number"]);var rc=f.cwrap("sqlite3_errmsg","string",["number"]);var ob=f.cwrap("sqlite3_data_count","number",["number"]);var dc=f.cwrap("sqlite3_column_double","number",["number","number"]);var ec=f.cwrap("sqlite3_column_text","string",["number","number"]);var hc=f.cwrap("sqlite3_column_blob",
"number",["number","number"]);var fc=f.cwrap("sqlite3_column_bytes","number",["number","number"]);var ic=f.cwrap("sqlite3_column_type","number",["number","number"]);var jc=f.cwrap("sqlite3_column_name","string",["number","number"]);var oc=f.cwrap("sqlite3_reset","number",["number"]);var nc=f.cwrap("sqlite3_clear_bindings","number",["number"]);var pc=f.cwrap("sqlite3_finalize","number",["number"]);var Cc=f.cwrap("sqlite3_create_function_v2","number","number string number number number number number number number".split(" "));
var tc=f.cwrap("sqlite3_value_type","number",["number"]);var wc=f.cwrap("sqlite3_value_bytes","number",["number"]);var uc=f.cwrap("sqlite3_value_text","string",["number"]);f.cwrap("sqlite3_value_int","number",["number"]);var xc=f.cwrap("sqlite3_value_blob","number",["number"]);var tb=f.cwrap("sqlite3_value_double","number",["number"]);var zc=f.cwrap("sqlite3_result_double","",["number","number"]);var vb=f.cwrap("sqlite3_result_null","",["number"]);var Ac=f.cwrap("sqlite3_result_text","",["number",
"string","number","number"]);var Bc=f.cwrap("sqlite3_result_blob","",["number","number","number","number"]);var yc=f.cwrap("sqlite3_result_int","",["number","number"]);f.cwrap("sqlite3_result_int64","",["number","number"]);var ub=f.cwrap("sqlite3_result_error","",["number","string","number"]);var qc=f.cwrap("RegisterExtensionFunctions","number",["number"]);this.SQL={Database:e};for(a in this.SQL)f[a]=this.SQL[a];var ea=0;c.Aa=0;c.Dd=1;c.Wd=2;c.ge=3;c.Gb=4;c.Ib=5;c.Zd=6;c.NOMEM=7;c.je=8;c.Xd=9;c.Yd=
10;c.Lb=11;c.NOTFOUND=12;c.Vd=13;c.Jb=14;c.he=15;c.EMPTY=16;c.ke=17;c.le=18;c.Kb=19;c.$d=20;c.be=21;c.ce=22;c.Hb=23;c.Ud=24;c.ie=25;c.de=26;c.ee=27;c.me=28;c.lb=100;c.DONE=101;c.kb=1;c.FLOAT=2;c.mb=3;c.cb=4;c.fe=5;c.nb=1}.bind(this);f.preRun=f.preRun||[];f.preRun.push(wa);var xa={},w;for(w in f)f.hasOwnProperty(w)&&(xa[w]=f[w]);f.arguments=[];f.thisProgram="./this.program";f.quit=function(a,b){throw b;};f.preRun=[];f.postRun=[];var ya=!1,x=!1,y=!1,za=!1;ya="object"===typeof window;
x="function"===typeof importScripts;y="object"===typeof process&&"function"===typeof require&&!ya&&!x;za=!ya&&!y&&!x;var z="";
if(y){z=__dirname+"/";var Aa,Ba;f.read=function(a,b){var c=B(a);c||(Aa||(Aa=require("fs")),Ba||(Ba=require("path")),a=Ba.normalize(a),c=Aa.readFileSync(a));return b?c:c.toString()};f.readBinary=function(a){a=f.read(a,!0);a.buffer||(a=new Uint8Array(a));assert(a.buffer);return a};1<process.argv.length&&(f.thisProgram=process.argv[1].replace(/\\/g,"/"));f.arguments=process.argv.slice(2);"undefined"!==typeof module&&(module.exports=f);process.on("unhandledRejection",C);f.quit=function(a){process.exit(a)};
f.inspect=function(){return"[Emscripten Module object]"}}else if(za)"undefined"!=typeof read&&(f.read=function(a){var b=B(a);return b?Ca(b):read(a)}),f.readBinary=function(a){var b;if(b=B(a))return b;if("function"===typeof readbuffer)return new Uint8Array(readbuffer(a));b=read(a,"binary");assert("object"===typeof b);return b},"undefined"!=typeof scriptArgs?f.arguments=scriptArgs:"undefined"!=typeof arguments&&(f.arguments=arguments),"function"===typeof quit&&(f.quit=function(a){quit(a)});else if(ya||
x)x?z=self.location.href:document.currentScript&&(z=document.currentScript.src),z=0!==z.indexOf("blob:")?z.substr(0,z.lastIndexOf("/")+1):"",f.read=function(a){try{var b=new XMLHttpRequest;b.open("GET",a,!1);b.send(null);return b.responseText}catch(c){if(a=B(a))return Ca(a);throw c;}},x&&(f.readBinary=function(a){try{var b=new XMLHttpRequest;b.open("GET",a,!1);b.responseType="arraybuffer";b.send(null);return new Uint8Array(b.response)}catch(c){if(a=B(a))return a;throw c;}}),f.readAsync=function(a,
b,c){var d=new XMLHttpRequest;d.open("GET",a,!0);d.responseType="arraybuffer";d.onload=function(){if(200==d.status||0==d.status&&d.response)b(d.response);else{var e=B(a);e?b(e.buffer):c()}};d.onerror=c;d.send(null)},f.setWindowTitle=function(a){document.title=a};var Da=f.print||("undefined"!==typeof console?console.log.bind(console):"undefined"!==typeof print?print:null),Ea=f.printErr||("undefined"!==typeof printErr?printErr:"undefined"!==typeof console&&console.warn.bind(console)||Da);
for(w in xa)xa.hasOwnProperty(w)&&(f[w]=xa[w]);xa=void 0;function Fa(a){var b=D[Ga>>2];a=b+a+15&-16;if(a<=Ha())D[Ga>>2]=a;else return 0;return b}var ra=1,t=Array(64);function va(a){for(var b=0;64>b;b++)if(!t[b])return t[b]=a,ra+b;throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.";}var Ia=0;
function q(a,b){b=b||"i8";"*"===b.charAt(b.length-1)&&(b="i32");switch(b){case "i1":return l[a>>0];case "i8":return l[a>>0];case "i16":return Ja[a>>1];case "i32":return D[a>>2];case "i64":return D[a>>2];case "float":return Ka[a>>2];case "double":return La[a>>3];default:C("invalid type for getValue: "+b)}return null}var Oa=!1;function assert(a,b){a||C("Assertion failed: "+b)}function Pa(a){var b=f["_"+a];assert(b,"Cannot call unknown function "+a+", make sure it is exported");return b}
function Qa(a,b,c,d){var e={string:function(a){var b=0;if(null!==a&&void 0!==a&&0!==a){var c=(a.length<<2)+1;b=h(c);r(a,E,b,c)}return b},array:function(a){var b=h(a.length);l.set(a,b);return b}},g=Pa(a),k=[];a=0;if(d)for(var n=0;n<d.length;n++){var v=e[c[n]];v?(0===a&&(a=na()),k[n]=v(d[n])):k[n]=d[n]}c=g.apply(null,k);c=function(a){return"string"===b?F(a):"boolean"===b?!!a:a}(c);0!==a&&qa(a);return c}
function pa(a){var b="i32";"*"===b.charAt(b.length-1)&&(b="i32");switch(b){case "i1":l[a>>0]=0;break;case "i8":l[a>>0]=0;break;case "i16":Ja[a>>1]=0;break;case "i32":D[a>>2]=0;break;case "i64":aa=[0,1<=+Ra(0)?~~+Sa(0)>>>0:0];D[a>>2]=aa[0];D[a+4>>2]=aa[1];break;case "float":Ka[a>>2]=0;break;case "double":La[a>>3]=0;break;default:C("invalid type for setValue: "+b)}}var Ta=0,Ua=3;
function ca(a){var b=Ta;if("number"===typeof a){var c=!0;var d=a}else c=!1,d=a.length;var e;b==Ua?e=g:e=[Va,h,Fa][b](Math.max(d,1));if(c){var g=e;assert(0==(e&3));for(a=e+(d&-4);g<a;g+=4)D[g>>2]=0;for(a=e+d;g<a;)l[g++>>0]=0;return e}a.subarray||a.slice?E.set(a,e):E.set(new Uint8Array(a),e);return e}var Wa="undefined"!==typeof TextDecoder?new TextDecoder("utf8"):void 0;
function u(a,b,c){var d=b+c;for(c=b;a[c]&&!(c>=d);)++c;if(16<c-b&&a.subarray&&Wa)return Wa.decode(a.subarray(b,c));for(d="";b<c;){var e=a[b++];if(e&128){var g=a[b++]&63;if(192==(e&224))d+=String.fromCharCode((e&31)<<6|g);else{var k=a[b++]&63;e=224==(e&240)?(e&15)<<12|g<<6|k:(e&7)<<18|g<<12|k<<6|a[b++]&63;65536>e?d+=String.fromCharCode(e):(e-=65536,d+=String.fromCharCode(55296|e>>10,56320|e&1023))}}else d+=String.fromCharCode(e)}return d}function F(a){return a?u(E,a,void 0):""}
function r(a,b,c,d){if(!(0<d))return 0;var e=c;d=c+d-1;for(var g=0;g<a.length;++g){var k=a.charCodeAt(g);if(55296<=k&&57343>=k){var n=a.charCodeAt(++g);k=65536+((k&1023)<<10)|n&1023}if(127>=k){if(c>=d)break;b[c++]=k}else{if(2047>=k){if(c+1>=d)break;b[c++]=192|k>>6}else{if(65535>=k){if(c+2>=d)break;b[c++]=224|k>>12}else{if(c+3>=d)break;b[c++]=240|k>>18;b[c++]=128|k>>12&63}b[c++]=128|k>>6&63}b[c++]=128|k&63}}b[c]=0;return c-e}
function oa(a){for(var b=0,c=0;c<a.length;++c){var d=a.charCodeAt(c);55296<=d&&57343>=d&&(d=65536+((d&1023)<<10)|a.charCodeAt(++c)&1023);127>=d?++b:b=2047>=d?b+2:65535>=d?b+3:b+4}return b}"undefined"!==typeof TextDecoder&&new TextDecoder("utf-16le");function Xa(a){return a.replace(/__Z[\w\d_]+/g,function(a){return a===a?a:a+" ["+a+"]"})}var buffer,l,E,Ja,D,Ka,La,Ga=60240,Ya=f.TOTAL_MEMORY||16777216;5242880>Ya&&Ea("TOTAL_MEMORY should be larger than TOTAL_STACK, was "+Ya+"! (TOTAL_STACK=5242880)");
f.buffer?buffer=f.buffer:buffer=new ArrayBuffer(Ya);f.HEAP8=l=new Int8Array(buffer);f.HEAP16=Ja=new Int16Array(buffer);f.HEAP32=D=new Int32Array(buffer);f.HEAPU8=E=new Uint8Array(buffer);f.HEAPU16=new Uint16Array(buffer);f.HEAPU32=new Uint32Array(buffer);f.HEAPF32=Ka=new Float32Array(buffer);f.HEAPF64=La=new Float64Array(buffer);D[Ga>>2]=5303376;
function Za(a){for(;0<a.length;){var b=a.shift();if("function"==typeof b)b();else{var c=b.vb;"number"===typeof c?void 0===b.Ia?f.dynCall_v(c):f.dynCall_vi(c,b.Ia):c(void 0===b.Ia?null:b.Ia)}}}var $a=[],ab=[],bb=[],cb=[],db=!1;function eb(){var a=f.preRun.shift();$a.unshift(a)}var Ra=Math.abs,Sa=Math.ceil,G=0,fb=null,gb=null;f.preloadedImages={};f.preloadedAudios={};var H=null,hb="data:application/octet-stream;base64,";ab.push({vb:function(){ib()}});H="data:application/octet-stream;base64,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";
var I={};
function jb(a){if(jb.pa){var b=D[a>>2];var c=D[b>>2]}else jb.pa=!0,I.USER=I.LOGNAME="web_user",I.PATH="/",I.PWD="/",I.HOME="/home/web_user",I.LANG="C.UTF-8",I._=f.thisProgram,c=db?Va(1024):Fa(1024),b=db?Va(256):Fa(256),D[b>>2]=c,D[a>>2]=b;a=[];var d=0,e;for(e in I)if("string"===typeof I[e]){var g=e+"="+I[e];a.push(g);d+=g.length}if(1024<d)throw Error("Environment size exceeded TOTAL_ENV_SIZE!");for(e=0;e<a.length;e++){d=g=a[e];for(var k=c,n=0;n<d.length;++n)l[k++>>0]=d.charCodeAt(n);l[k>>0]=0;D[b+
4*e>>2]=c;c+=g.length+1}D[b+4*a.length>>2]=0}function kb(a){f.___errno_location&&(D[f.___errno_location()>>2]=a);return a}function lb(a,b){for(var c=0,d=a.length-1;0<=d;d--){var e=a[d];"."===e?a.splice(d,1):".."===e?(a.splice(d,1),c++):c&&(a.splice(d,1),c--)}if(b)for(;c;c--)a.unshift("..");return a}function mb(a){var b="/"===a.charAt(0),c="/"===a.substr(-1);(a=lb(a.split("/").filter(function(a){return!!a}),!b).join("/"))||b||(a=".");a&&c&&(a+="/");return(b?"/":"")+a}
function nb(a){var b=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/.exec(a).slice(1);a=b[0];b=b[1];if(!a&&!b)return".";b&&(b=b.substr(0,b.length-1));return a+b}function pb(a){if("/"===a)return"/";var b=a.lastIndexOf("/");return-1===b?a:a.substr(b+1)}function qb(){var a=Array.prototype.slice.call(arguments,0);return mb(a.join("/"))}function m(a,b){return mb(a+"/"+b)}
function rb(){for(var a="",b=!1,c=arguments.length-1;-1<=c&&!b;c--){b=0<=c?arguments[c]:"/";if("string"!==typeof b)throw new TypeError("Arguments to path.resolve must be strings");if(!b)return"";a=b+"/"+a;b="/"===b.charAt(0)}a=lb(a.split("/").filter(function(a){return!!a}),!b).join("/");return(b?"/":"")+a||"."}var sb=[];function wb(a,b){sb[a]={input:[],output:[],wa:b};xb(a,yb)}
var yb={open:function(a){var b=sb[a.node.rdev];if(!b)throw new J(K.Fa);a.tty=b;a.seekable=!1},close:function(a){a.tty.wa.flush(a.tty)},flush:function(a){a.tty.wa.flush(a.tty)},read:function(a,b,c,d){if(!a.tty||!a.tty.wa.$a)throw new J(K.Ra);for(var e=0,g=0;g<d;g++){try{var k=a.tty.wa.$a(a.tty)}catch(n){throw new J(K.Oa);}if(void 0===k&&0===e)throw new J(K.fb);if(null===k||void 0===k)break;e++;b[c+g]=k}e&&(a.node.timestamp=Date.now());return e},write:function(a,b,c,d){if(!a.tty||!a.tty.wa.La)throw new J(K.Ra);
try{for(var e=0;e<d;e++)a.tty.wa.La(a.tty,b[c+e])}catch(g){throw new J(K.Oa);}d&&(a.node.timestamp=Date.now());return e}},zb={$a:function(a){if(!a.input.length){var b=null;if(y){var c=new Buffer(256),d=0,e=process.stdin.fd;if("win32"!=process.platform){var g=!1;try{e=fs.openSync("/dev/stdin","r"),g=!0}catch(k){}}try{d=fs.readSync(e,c,0,256,null)}catch(k){if(-1!=k.toString().indexOf("EOF"))d=0;else throw k;}g&&fs.closeSync(e);0<d?b=c.slice(0,d).toString("utf-8"):b=null}else"undefined"!=typeof window&&
"function"==typeof window.prompt?(b=window.prompt("Input: "),null!==b&&(b+="\n")):"function"==typeof readline&&(b=readline(),null!==b&&(b+="\n"));if(!b)return null;a.input=ba(b,!0)}return a.input.shift()},La:function(a,b){null===b||10===b?(Da(u(a.output,0)),a.output=[]):0!=b&&a.output.push(b)},flush:function(a){a.output&&0<a.output.length&&(Da(u(a.output,0)),a.output=[])}},Ab={La:function(a,b){null===b||10===b?(Ea(u(a.output,0)),a.output=[]):0!=b&&a.output.push(b)},flush:function(a){a.output&&0<a.output.length&&
(Ea(u(a.output,0)),a.output=[])}},L={na:null,ka:function(){return L.createNode(null,"/",16895,0)},createNode:function(a,b,c,d){if(24576===(c&61440)||4096===(c&61440))throw new J(K.ib);L.na||(L.na={dir:{node:{ma:L.ba.ma,ia:L.ba.ia,lookup:L.ba.lookup,ya:L.ba.ya,rename:L.ba.rename,unlink:L.ba.unlink,rmdir:L.ba.rmdir,readdir:L.ba.readdir,symlink:L.ba.symlink},stream:{ra:L.ea.ra}},file:{node:{ma:L.ba.ma,ia:L.ba.ia},stream:{ra:L.ea.ra,read:L.ea.read,write:L.ea.write,Sa:L.ea.Sa,Ca:L.ea.Ca,Da:L.ea.Da}},link:{node:{ma:L.ba.ma,
ia:L.ba.ia,readlink:L.ba.readlink},stream:{}},Va:{node:{ma:L.ba.ma,ia:L.ba.ia},stream:Bb}});c=Cb(a,b,c,d);M(c.mode)?(c.ba=L.na.dir.node,c.ea=L.na.dir.stream,c.da={}):32768===(c.mode&61440)?(c.ba=L.na.file.node,c.ea=L.na.file.stream,c.ha=0,c.da=null):40960===(c.mode&61440)?(c.ba=L.na.link.node,c.ea=L.na.link.stream):8192===(c.mode&61440)&&(c.ba=L.na.Va.node,c.ea=L.na.Va.stream);c.timestamp=Date.now();a&&(a.da[b]=c);return c},ne:function(a){if(a.da&&a.da.subarray){for(var b=[],c=0;c<a.ha;++c)b.push(a.da[c]);
return b}return a.da},oe:function(a){return a.da?a.da.subarray?a.da.subarray(0,a.ha):new Uint8Array(a.da):new Uint8Array},Wa:function(a,b){var c=a.da?a.da.length:0;c>=b||(b=Math.max(b,c*(1048576>c?2:1.125)|0),0!=c&&(b=Math.max(b,256)),c=a.da,a.da=new Uint8Array(b),0<a.ha&&a.da.set(c.subarray(0,a.ha),0))},Cb:function(a,b){if(a.ha!=b)if(0==b)a.da=null,a.ha=0;else{if(!a.da||a.da.subarray){var c=a.da;a.da=new Uint8Array(new ArrayBuffer(b));c&&a.da.set(c.subarray(0,Math.min(b,a.ha)))}else if(a.da||(a.da=
[]),a.da.length>b)a.da.length=b;else for(;a.da.length<b;)a.da.push(0);a.ha=b}},ba:{ma:function(a){var b={};b.dev=8192===(a.mode&61440)?a.id:1;b.ino=a.id;b.mode=a.mode;b.nlink=1;b.uid=0;b.gid=0;b.rdev=a.rdev;M(a.mode)?b.size=4096:32768===(a.mode&61440)?b.size=a.ha:40960===(a.mode&61440)?b.size=a.link.length:b.size=0;b.atime=new Date(a.timestamp);b.mtime=new Date(a.timestamp);b.ctime=new Date(a.timestamp);b.sa=4096;b.blocks=Math.ceil(b.size/b.sa);return b},ia:function(a,b){void 0!==b.mode&&(a.mode=
b.mode);void 0!==b.timestamp&&(a.timestamp=b.timestamp);void 0!==b.size&&L.Cb(a,b.size)},lookup:function(){throw Db[K.gb];},ya:function(a,b,c,d){return L.createNode(a,b,c,d)},rename:function(a,b,c){if(M(a.mode)){try{var d=N(b,c)}catch(g){}if(d)for(var e in d.da)throw new J(K.Qa);}delete a.parent.da[a.name];a.name=c;b.da[c]=a;a.parent=b},unlink:function(a,b){delete a.da[b]},rmdir:function(a,b){var c=N(a,b),d;for(d in c.da)throw new J(K.Qa);delete a.da[b]},readdir:function(a){var b=[".",".."],c;for(c in a.da)a.da.hasOwnProperty(c)&&
b.push(c);return b},symlink:function(a,b,c){a=L.createNode(a,b,41471,0);a.link=c;return a},readlink:function(a){if(40960!==(a.mode&61440))throw new J(K.ja);return a.link}},ea:{read:function(a,b,c,d,e){var g=a.node.da;if(e>=a.node.ha)return 0;a=Math.min(a.node.ha-e,d);if(8<a&&g.subarray)b.set(g.subarray(e,e+a),c);else for(d=0;d<a;d++)b[c+d]=g[e+d];return a},write:function(a,b,c,d,e,g){if(!d)return 0;a=a.node;a.timestamp=Date.now();if(b.subarray&&(!a.da||a.da.subarray)){if(g)return a.da=b.subarray(c,
c+d),a.ha=d;if(0===a.ha&&0===e)return a.da=new Uint8Array(b.subarray(c,c+d)),a.ha=d;if(e+d<=a.ha)return a.da.set(b.subarray(c,c+d),e),d}L.Wa(a,e+d);if(a.da.subarray&&b.subarray)a.da.set(b.subarray(c,c+d),e);else for(g=0;g<d;g++)a.da[e+g]=b[c+g];a.ha=Math.max(a.ha,e+d);return d},ra:function(a,b,c){1===c?b+=a.position:2===c&&32768===(a.node.mode&61440)&&(b+=a.node.ha);if(0>b)throw new J(K.ja);return b},Sa:function(a,b,c){L.Wa(a.node,b+c);a.node.ha=Math.max(a.node.ha,b+c)},Ca:function(a,b,c,d,e,g,k){if(32768!==
(a.node.mode&61440))throw new J(K.Fa);c=a.node.da;if(k&2||c.buffer!==b&&c.buffer!==b.buffer){if(0<e||e+d<a.node.ha)c.subarray?c=c.subarray(e,e+d):c=Array.prototype.slice.call(c,e,e+d);a=!0;d=Va(d);if(!d)throw new J(K.Pa);b.set(c,d)}else a=!1,d=c.byteOffset;return{Bb:d,Ga:a}},Da:function(a,b,c,d,e){if(32768!==(a.node.mode&61440))throw new J(K.Fa);if(e&2)return 0;L.ea.write(a,b,0,d,c,!1);return 0}}},O={Ba:!1,Eb:function(){O.Ba=!!process.platform.match(/^win/);var a=process.binding("constants");a.fs&&
(a=a.fs);O.Xa={1024:a.O_APPEND,64:a.O_CREAT,128:a.O_EXCL,0:a.O_RDONLY,2:a.O_RDWR,4096:a.O_SYNC,512:a.O_TRUNC,1:a.O_WRONLY}},Ua:function(a){return Buffer.pa?Buffer.from(a):new Buffer(a)},ka:function(a){assert(y);return O.createNode(null,"/",O.Za(a.Ka.root),0)},createNode:function(a,b,c){if(!M(c)&&32768!==(c&61440)&&40960!==(c&61440))throw new J(K.ja);a=Cb(a,b,c);a.ba=O.ba;a.ea=O.ea;return a},Za:function(a){try{var b=fs.lstatSync(a);O.Ba&&(b.mode=b.mode|(b.mode&292)>>2)}catch(c){if(!c.code)throw c;
throw new J(K[c.code]);}return b.mode},la:function(a){for(var b=[];a.parent!==a;)b.push(a.name),a=a.parent;b.push(a.ka.Ka.root);b.reverse();return qb.apply(null,b)},ub:function(a){a&=-2656257;var b=0,c;for(c in O.Xa)a&c&&(b|=O.Xa[c],a^=c);if(a)throw new J(K.ja);return b},ba:{ma:function(a){a=O.la(a);try{var b=fs.lstatSync(a)}catch(c){if(!c.code)throw c;throw new J(K[c.code]);}O.Ba&&!b.sa&&(b.sa=4096);O.Ba&&!b.blocks&&(b.blocks=(b.size+b.sa-1)/b.sa|0);return{dev:b.dev,ino:b.ino,mode:b.mode,nlink:b.nlink,
uid:b.uid,gid:b.gid,rdev:b.rdev,size:b.size,atime:b.atime,mtime:b.mtime,ctime:b.ctime,sa:b.sa,blocks:b.blocks}},ia:function(a,b){var c=O.la(a);try{void 0!==b.mode&&(fs.chmodSync(c,b.mode),a.mode=b.mode),void 0!==b.size&&fs.truncateSync(c,b.size)}catch(d){if(!d.code)throw d;throw new J(K[d.code]);}},lookup:function(a,b){var c=m(O.la(a),b);c=O.Za(c);return O.createNode(a,b,c)},ya:function(a,b,c,d){a=O.createNode(a,b,c,d);b=O.la(a);try{M(a.mode)?fs.mkdirSync(b,a.mode):fs.writeFileSync(b,"",{mode:a.mode})}catch(e){if(!e.code)throw e;
throw new J(K[e.code]);}return a},rename:function(a,b,c){a=O.la(a);b=m(O.la(b),c);try{fs.renameSync(a,b)}catch(d){if(!d.code)throw d;throw new J(K[d.code]);}},unlink:function(a,b){a=m(O.la(a),b);try{fs.unlinkSync(a)}catch(c){if(!c.code)throw c;throw new J(K[c.code]);}},rmdir:function(a,b){a=m(O.la(a),b);try{fs.rmdirSync(a)}catch(c){if(!c.code)throw c;throw new J(K[c.code]);}},readdir:function(a){a=O.la(a);try{return fs.readdirSync(a)}catch(b){if(!b.code)throw b;throw new J(K[b.code]);}},symlink:function(a,
b,c){a=m(O.la(a),b);try{fs.symlinkSync(c,a)}catch(d){if(!d.code)throw d;throw new J(K[d.code]);}},readlink:function(a){var b=O.la(a);try{return b=fs.readlinkSync(b),b=Eb.relative(Eb.resolve(a.ka.Ka.root),b)}catch(c){if(!c.code)throw c;throw new J(K[c.code]);}}},ea:{open:function(a){var b=O.la(a.node);try{32768===(a.node.mode&61440)&&(a.za=fs.openSync(b,O.ub(a.flags)))}catch(c){if(!c.code)throw c;throw new J(K[c.code]);}},close:function(a){try{32768===(a.node.mode&61440)&&a.za&&fs.closeSync(a.za)}catch(b){if(!b.code)throw b;
throw new J(K[b.code]);}},read:function(a,b,c,d,e){if(0===d)return 0;try{return fs.readSync(a.za,O.Ua(b.buffer),c,d,e)}catch(g){throw new J(K[g.code]);}},write:function(a,b,c,d,e){try{return fs.writeSync(a.za,O.Ua(b.buffer),c,d,e)}catch(g){throw new J(K[g.code]);}},ra:function(a,b,c){if(1===c)b+=a.position;else if(2===c&&32768===(a.node.mode&61440))try{b+=fs.fstatSync(a.za).size}catch(d){throw new J(K[d.code]);}if(0>b)throw new J(K.ja);return b}}},Fb=null,Gb={},P=[],Hb=1,Q=null,Ib=!0,R={},J=null,
Db={};function S(a,b){a=rb("/",a);b=b||{};if(!a)return{path:"",node:null};var c={Ya:!0,Ma:0},d;for(d in c)void 0===b[d]&&(b[d]=c[d]);if(8<b.Ma)throw new J(40);a=lb(a.split("/").filter(function(a){return!!a}),!1);var e=Fb;c="/";for(d=0;d<a.length;d++){var g=d===a.length-1;if(g&&b.parent)break;e=N(e,a[d]);c=m(c,a[d]);e.ua&&(!g||g&&b.Ya)&&(e=e.ua.root);if(!g||b.ta)for(g=0;40960===(e.mode&61440);)if(e=Jb(c),c=rb(nb(c),e),e=S(c,{Ma:b.Ma}).node,40<g++)throw new J(40);}return{path:c,node:e}}
function Kb(a){for(var b;;){if(a===a.parent)return a=a.ka.bb,b?"/"!==a[a.length-1]?a+"/"+b:a+b:a;b=b?a.name+"/"+b:a.name;a=a.parent}}function Lb(a,b){for(var c=0,d=0;d<b.length;d++)c=(c<<5)-c+b.charCodeAt(d)|0;return(a+c>>>0)%Q.length}function Mb(a){var b=Lb(a.parent.id,a.name);a.va=Q[b];Q[b]=a}function Nb(a){var b=Lb(a.parent.id,a.name);if(Q[b]===a)Q[b]=a.va;else for(b=Q[b];b;){if(b.va===a){b.va=a.va;break}b=b.va}}
function N(a,b){var c;if(c=(c=Ob(a,"x"))?c:a.ba.lookup?0:13)throw new J(c,a);for(c=Q[Lb(a.id,b)];c;c=c.va){var d=c.name;if(c.parent.id===a.id&&d===b)return c}return a.ba.lookup(a,b)}
function Cb(a,b,c,d){Pb||(Pb=function(a,b,c,d){a||(a=this);this.parent=a;this.ka=a.ka;this.ua=null;this.id=Hb++;this.name=b;this.mode=c;this.ba={};this.ea={};this.rdev=d},Pb.prototype={},Object.defineProperties(Pb.prototype,{read:{get:function(){return 365===(this.mode&365)},set:function(a){a?this.mode|=365:this.mode&=-366}},write:{get:function(){return 146===(this.mode&146)},set:function(a){a?this.mode|=146:this.mode&=-147}}}));a=new Pb(a,b,c,d);Mb(a);return a}
function M(a){return 16384===(a&61440)}var Qb={r:0,rs:1052672,"r+":2,w:577,wx:705,xw:705,"w+":578,"wx+":706,"xw+":706,a:1089,ax:1217,xa:1217,"a+":1090,"ax+":1218,"xa+":1218};function Rb(a){var b=["r","w","rw"][a&3];a&512&&(b+="w");return b}function Ob(a,b){if(Ib)return 0;if(-1===b.indexOf("r")||a.mode&292){if(-1!==b.indexOf("w")&&!(a.mode&146)||-1!==b.indexOf("x")&&!(a.mode&73))return 13}else return 13;return 0}function Sb(a,b){try{return N(a,b),17}catch(c){}return Ob(a,"wx")}
function Tb(a,b,c){try{var d=N(a,b)}catch(e){return e.fa}if(a=Ob(a,"wx"))return a;if(c){if(!M(d.mode))return 20;if(d===d.parent||"/"===Kb(d))return 16}else if(M(d.mode))return 21;return 0}function Ub(a){var b=4096;for(a=a||0;a<=b;a++)if(!P[a])return a;throw new J(24);}
function Vb(a,b){Wb||(Wb=function(){},Wb.prototype={},Object.defineProperties(Wb.prototype,{object:{get:function(){return this.node},set:function(a){this.node=a}}}));var c=new Wb,d;for(d in a)c[d]=a[d];a=c;b=Ub(b);a.fd=b;return P[b]=a}var Bb={open:function(a){a.ea=Gb[a.node.rdev].ea;a.ea.open&&a.ea.open(a)},ra:function(){throw new J(29);}};function xb(a,b){Gb[a]={ea:b}}
function Xb(a,b){var c="/"===b,d=!b;if(c&&Fb)throw new J(16);if(!c&&!d){var e=S(b,{Ya:!1});b=e.path;e=e.node;if(e.ua)throw new J(16);if(!M(e.mode))throw new J(20);}b={type:a,Ka:{},bb:b,Ab:[]};a=a.ka(b);a.ka=b;b.root=a;c?Fb=a:e&&(e.ua=b,e.ka&&e.ka.Ab.push(b))}function ja(a,b,c){var d=S(a,{parent:!0}).node;a=pb(a);if(!a||"."===a||".."===a)throw new J(22);var e=Sb(d,a);if(e)throw new J(e);if(!d.ba.ya)throw new J(1);return d.ba.ya(d,a,b,c)}function T(a,b){ja(a,(void 0!==b?b:511)&1023|16384,0)}
function Yb(a,b,c){"undefined"===typeof c&&(c=b,b=438);ja(a,b|8192,c)}function Zb(a,b){if(!rb(a))throw new J(2);var c=S(b,{parent:!0}).node;if(!c)throw new J(2);b=pb(b);var d=Sb(c,b);if(d)throw new J(d);if(!c.ba.symlink)throw new J(1);c.ba.symlink(c,b,a)}
function ua(a){var b=S(a,{parent:!0}).node,c=pb(a),d=N(b,c),e=Tb(b,c,!1);if(e)throw new J(e);if(!b.ba.unlink)throw new J(1);if(d.ua)throw new J(16);try{R.willDeletePath&&R.willDeletePath(a)}catch(g){console.log("FS.trackingDelegate['willDeletePath']('"+a+"') threw an exception: "+g.message)}b.ba.unlink(b,c);Nb(d);try{if(R.onDeletePath)R.onDeletePath(a)}catch(g){console.log("FS.trackingDelegate['onDeletePath']('"+a+"') threw an exception: "+g.message)}}
function Jb(a){a=S(a).node;if(!a)throw new J(2);if(!a.ba.readlink)throw new J(22);return rb(Kb(a.parent),a.ba.readlink(a))}function sa(a,b){a=S(a,{ta:!b}).node;if(!a)throw new J(2);if(!a.ba.ma)throw new J(1);return a.ba.ma(a)}function $b(a){return sa(a,!0)}function ka(a,b){var c;"string"===typeof a?c=S(a,{ta:!0}).node:c=a;if(!c.ba.ia)throw new J(1);c.ba.ia(c,{mode:b&4095|c.mode&-4096,timestamp:Date.now()})}
function ac(a){var b;"string"===typeof a?b=S(a,{ta:!0}).node:b=a;if(!b.ba.ia)throw new J(1);b.ba.ia(b,{timestamp:Date.now()})}function bc(a,b){if(0>b)throw new J(22);var c;"string"===typeof a?c=S(a,{ta:!0}).node:c=a;if(!c.ba.ia)throw new J(1);if(M(c.mode))throw new J(21);if(32768!==(c.mode&61440))throw new J(22);if(a=Ob(c,"w"))throw new J(a);c.ba.ia(c,{size:b,timestamp:Date.now()})}
function p(a,b,c,d){if(""===a)throw new J(2);if("string"===typeof b){var e=Qb[b];if("undefined"===typeof e)throw Error("Unknown file open mode: "+b);b=e}c=b&64?("undefined"===typeof c?438:c)&4095|32768:0;if("object"===typeof a)var g=a;else{a=mb(a);try{g=S(a,{ta:!(b&131072)}).node}catch(k){}}e=!1;if(b&64)if(g){if(b&128)throw new J(17);}else g=ja(a,c,0),e=!0;if(!g)throw new J(2);8192===(g.mode&61440)&&(b&=-513);if(b&65536&&!M(g.mode))throw new J(20);if(!e&&(c=g?40960===(g.mode&61440)?40:M(g.mode)&&
("r"!==Rb(b)||b&512)?21:Ob(g,Rb(b)):2))throw new J(c);b&512&&bc(g,0);b&=-641;d=Vb({node:g,path:Kb(g),flags:b,seekable:!0,position:0,ea:g.ea,Fb:[],error:!1},d);d.ea.open&&d.ea.open(d);!f.logReadFiles||b&1||(sc||(sc={}),a in sc||(sc[a]=1,console.log("FS.trackingDelegate error on read file: "+a)));try{R.onOpenFile&&(g=0,1!==(b&2097155)&&(g|=1),0!==(b&2097155)&&(g|=2),R.onOpenFile(a,g))}catch(k){console.log("FS.trackingDelegate['onOpenFile']('"+a+"', flags) threw an exception: "+k.message)}return d}
function ma(a){if(null===a.fd)throw new J(9);a.Ja&&(a.Ja=null);try{a.ea.close&&a.ea.close(a)}catch(b){throw b;}finally{P[a.fd]=null}a.fd=null}function Dc(a,b,c){if(null===a.fd)throw new J(9);if(!a.seekable||!a.ea.ra)throw new J(29);if(0!=c&&1!=c&&2!=c)throw new J(22);a.position=a.ea.ra(a,b,c);a.Fb=[]}
function ta(a,b,c,d,e){if(0>d||0>e)throw new J(22);if(null===a.fd)throw new J(9);if(1===(a.flags&2097155))throw new J(9);if(M(a.node.mode))throw new J(21);if(!a.ea.read)throw new J(22);var g="undefined"!==typeof e;if(!g)e=a.position;else if(!a.seekable)throw new J(29);b=a.ea.read(a,b,c,d,e);g||(a.position+=b);return b}
function la(a,b,c,d,e,g){if(0>d||0>e)throw new J(22);if(null===a.fd)throw new J(9);if(0===(a.flags&2097155))throw new J(9);if(M(a.node.mode))throw new J(21);if(!a.ea.write)throw new J(22);a.flags&1024&&Dc(a,0,2);var k="undefined"!==typeof e;if(!k)e=a.position;else if(!a.seekable)throw new J(29);b=a.ea.write(a,b,c,d,e,g);k||(a.position+=b);try{if(a.path&&R.onWriteToFile)R.onWriteToFile(a.path)}catch(n){console.log("FS.trackingDelegate['onWriteToFile']('"+a.path+"') threw an exception: "+n.message)}return b}
function Ec(){J||(J=function(a,b){this.node=b;this.Db=function(a){this.fa=a};this.Db(a);this.message="FS error";this.stack&&Object.defineProperty(this,"stack",{value:Error().stack,writable:!0})},J.prototype=Error(),J.prototype.constructor=J,[2].forEach(function(a){Db[a]=new J(a);Db[a].stack="<generic error, no stack>"}))}var Fc;function ia(a,b){var c=0;a&&(c|=365);b&&(c|=146);return c}
function Gc(a,b,c){a=m("/dev",a);var d=ia(!!b,!!c);Hc||(Hc=64);var e=Hc++<<8|0;xb(e,{open:function(a){a.seekable=!1},close:function(){c&&c.buffer&&c.buffer.length&&c(10)},read:function(a,c,d,e){for(var g=0,k=0;k<e;k++){try{var n=b()}catch(Na){throw new J(5);}if(void 0===n&&0===g)throw new J(11);if(null===n||void 0===n)break;g++;c[d+k]=n}g&&(a.node.timestamp=Date.now());return g},write:function(a,b,d,e){for(var g=0;g<e;g++)try{c(b[d+g])}catch(ha){throw new J(5);}e&&(a.node.timestamp=Date.now());return g}});
Yb(a,d,e)}
var Hc,U={},Pb,Wb,sc,K={ib:1,gb:2,Hd:3,wc:4,Oa:5,Ra:6,Mb:7,Xc:8,Na:9,bc:10,fb:11,Rd:11,Pa:12,eb:13,pc:14,ld:15,Zb:16,oc:17,Sd:18,Fa:19,hb:20,yc:21,ja:22,Sc:23,Kc:24,qd:25,Od:26,qc:27,gd:28,Gd:29,Cd:30,Lc:31,wd:32,lc:33,jb:34,bd:42,tc:43,cc:44,Ac:45,Bc:46,Cc:47,Ic:48,Pd:49,Vc:50,zc:51,ic:35,Yc:37,Sb:52,Vb:53,Td:54,Tc:55,Wb:56,Xb:57,jc:35,Yb:59,jd:60,Wc:61,Ld:62,hd:63,cd:64,dd:65,Bd:66,Zc:67,Pb:68,Id:69,dc:70,xd:71,Nc:72,mc:73,Ub:74,rd:76,Tb:77,Ad:78,Dc:79,Ec:80,Hc:81,Gc:82,Fc:83,kd:38,Qa:39,Oc:36,
Jc:40,sd:95,vd:96,hc:104,Uc:105,Qb:97,zd:91,od:88,ed:92,Ed:108,fc:111,Nb:98,ec:103,Rc:101,Pc:100,Md:110,rc:112,sc:113,vc:115,Rb:114,kc:89,Mc:90,yd:93,Fd:94,Ob:99,Qc:102,xc:106,md:107,Nd:109,Qd:87,nc:122,Jd:116,pd:95,$c:123,uc:84,td:75,$b:125,nd:131,ud:130,Kd:86},Ic={};
function Jc(a,b,c){try{var d=a(b)}catch(e){if(e&&e.node&&mb(b)!==mb(Kb(e.node)))return-K.hb;throw e;}D[c>>2]=d.dev;D[c+4>>2]=0;D[c+8>>2]=d.ino;D[c+12>>2]=d.mode;D[c+16>>2]=d.nlink;D[c+20>>2]=d.uid;D[c+24>>2]=d.gid;D[c+28>>2]=d.rdev;D[c+32>>2]=0;D[c+36>>2]=d.size;D[c+40>>2]=4096;D[c+44>>2]=d.blocks;D[c+48>>2]=d.atime.getTime()/1E3|0;D[c+52>>2]=0;D[c+56>>2]=d.mtime.getTime()/1E3|0;D[c+60>>2]=0;D[c+64>>2]=d.ctime.getTime()/1E3|0;D[c+68>>2]=0;D[c+72>>2]=d.ino;return 0}var V=0;
function W(){V+=4;return D[V-4>>2]}function X(){return F(W())}function Y(){var a=P[W()];if(!a)throw new J(K.Na);return a}function Kc(a,b){V=b;return 0}function Ha(){return l.length}function Lc(){C("OOM")}function Mc(a){if(0===a)return 0;a=F(a);if(!I.hasOwnProperty(a))return 0;Mc.pa&&fa(Mc.pa);a=I[a];var b=oa(a)+1,c=Va(b);c&&r(a,l,c,b);Mc.pa=c;return Mc.pa}function Nc(a){return Math.log(a)/Math.LN10}r("GMT",E,60384,4);
function Oc(){function a(a){return(a=a.toTimeString().match(/\(([A-Za-z ]+)\)$/))?a[1]:"GMT"}if(!Oc.pa){Oc.pa=!0;D[Pc()>>2]=60*(new Date).getTimezoneOffset();var b=new Date(2E3,0,1),c=new Date(2E3,6,1);D[Qc()>>2]=Number(b.getTimezoneOffset()!=c.getTimezoneOffset());var d=a(b),e=a(c);d=ca(ba(d));e=ca(ba(e));c.getTimezoneOffset()<b.getTimezoneOffset()?(D[Rc()>>2]=d,D[Rc()+4>>2]=e):(D[Rc()>>2]=e,D[Rc()+4>>2]=d)}}
function Sc(a,b){Oc();a=new Date(1E3*D[a>>2]);D[b>>2]=a.getSeconds();D[b+4>>2]=a.getMinutes();D[b+8>>2]=a.getHours();D[b+12>>2]=a.getDate();D[b+16>>2]=a.getMonth();D[b+20>>2]=a.getFullYear()-1900;D[b+24>>2]=a.getDay();var c=new Date(a.getFullYear(),0,1);D[b+28>>2]=(a.getTime()-c.getTime())/864E5|0;D[b+36>>2]=-(60*a.getTimezoneOffset());var d=(new Date(2E3,6,1)).getTimezoneOffset();c=c.getTimezoneOffset();a=(d!=c&&a.getTimezoneOffset()==Math.min(c,d))|0;D[b+32>>2]=a;a=D[Rc()+(a?4:0)>>2];D[b+40>>2]=
a;return b}function Tc(a){a/=1E3;if((ya||x)&&self.performance&&self.performance.now)for(var b=self.performance.now();self.performance.now()-b<a;);else for(b=Date.now();Date.now()-b<a;);return 0}f._usleep=Tc;Ec();Q=Array(4096);Xb(L,"/");T("/tmp");T("/home");T("/home/web_user");
(function(){T("/dev");xb(259,{read:function(){return 0},write:function(a,b,c,k){return k}});Yb("/dev/null",259);wb(1280,zb);wb(1536,Ab);Yb("/dev/tty",1280);Yb("/dev/tty1",1536);if("object"===typeof crypto&&"function"===typeof crypto.getRandomValues){var a=new Uint8Array(1);var b=function(){crypto.getRandomValues(a);return a[0]}}else if(y)try{var c=require("crypto");b=function(){return c.randomBytes(1)[0]}}catch(d){}b||(b=function(){C("random_device")});Gc("random",b);Gc("urandom",b);T("/dev/shm");
T("/dev/shm/tmp")})();T("/proc");T("/proc/self");T("/proc/self/fd");Xb({ka:function(){var a=Cb("/proc/self","fd",16895,73);a.ba={lookup:function(a,c){var b=P[+c];if(!b)throw new J(9);a={parent:null,ka:{bb:"fake"},ba:{readlink:function(){return b.path}}};return a.parent=a}};return a}},"/proc/self/fd");if(y){var fs=require("fs"),Eb=require("path");O.Eb()}var Uc=!1;function ba(a,b){var c=Array(oa(a)+1);a=r(a,c,0,c.length);b&&(c.length=a);return c}
function Ca(a){for(var b=[],c=0;c<a.length;c++){var d=a[c];255<d&&(Uc&&assert(!1,"Character code "+d+" ("+String.fromCharCode(d)+")  at offset "+c+" not in 0x00-0xFF."),d&=255);b.push(String.fromCharCode(d))}return b.join("")}
var Vc="function"===typeof atob?atob:function(a){var b="",c=0;a=a.replace(/[^A-Za-z0-9\+\/=]/g,"");do{var d="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(a.charAt(c++));var e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(a.charAt(c++));var g="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(a.charAt(c++));var k="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".indexOf(a.charAt(c++));d=d<<2|e>>4;
e=(e&15)<<4|g>>2;var n=(g&3)<<6|k;b+=String.fromCharCode(d);64!==g&&(b+=String.fromCharCode(e));64!==k&&(b+=String.fromCharCode(n))}while(c<a.length);return b};
function B(a){if(String.prototype.startsWith?a.startsWith(hb):0===a.indexOf(hb)){a=a.slice(hb.length);if("boolean"===typeof y&&y){try{var b=Buffer.from(a,"base64")}catch(g){b=new Buffer(a,"base64")}var c=new Uint8Array(b.buffer,b.byteOffset,b.byteLength)}else try{var d=Vc(a),e=new Uint8Array(d.length);for(b=0;b<d.length;++b)e[b]=d.charCodeAt(b);c=e}catch(g){throw Error("Converting base64 string to bytes failed.");}return c}}
var Wc={Math:Math,Int8Array:Int8Array,Int16Array:Int16Array,Int32Array:Int32Array,Uint8Array:Uint8Array,Uint16Array:Uint16Array,Float32Array:Float32Array,Float64Array:Float64Array,Infinity:Infinity},Zc={a:C,b:function(a){Ia=a},c:function(){return Ia},d:function(a){return t[a]()},e:function(a,b){return t[a](b)},f:function(a,b,c){return t[a](b,c)},g:function(a,b,c,d){return t[a](b,c,d)},h:function(a,b,c,d,e){return t[a](b,c,d,e)},i:function(a,b,c,d,e,g){return t[a](b,c,d,e,g)},j:function(a,b,c,d,e,
g,k){return t[a](b,c,d,e,g,k)},k:function(a,b){t[a](b)},l:function(a,b,c){t[a](b,c)},m:function(a,b,c,d){t[a](b,c,d)},n:function(a,b,c,d,e){t[a](b,c,d,e)},o:function(a,b,c,d,e,g,k){t[a](b,c,d,e,g,k)},p:function(a,b,c,d){C("Assertion failed: "+F(a)+", at: "+[b?F(b):"unknown filename",c,d?F(d):"unknown function"])},q:jb,r:kb,s:function(a,b){V=b;try{var c=X();ua(c);return 0}catch(d){return"undefined"!==typeof U&&d instanceof J||C(d),-d.fa}},t:function(a,b){V=b;try{return Y(),0}catch(c){return"undefined"!==
typeof U&&c instanceof J||C(c),-c.fa}},u:function(a,b){V=b;try{var c=Y();W();var d=W(),e=W(),g=W();Dc(c,d,g);D[e>>2]=c.position;c.Ja&&0===d&&0===g&&(c.Ja=null);return 0}catch(k){return"undefined"!==typeof U&&k instanceof J||C(k),-k.fa}},v:function(a,b){V=b;try{var c=X(),d=W();ka(c,d);return 0}catch(e){return"undefined"!==typeof U&&e instanceof J||C(e),-e.fa}},w:function(a,b){V=b;try{var c=W(),d=W();if(0===d)return-K.ja;if(d<oa("/")+1)return-K.jb;r("/",E,c,d);return c}catch(e){return"undefined"!==
typeof U&&e instanceof J||C(e),-e.fa}},x:function(a,b){V=b;try{var c=W(),d=W(),e=W(),g=W(),k=W(),n=W();n<<=12;a=!1;if(-1===k){var v=Xc(16384,d);if(!v)return-K.Pa;Yc(v,0,d);a=!0}else{var A=P[k];if(!A)return-K.Na;b=E;if(1===(A.flags&2097155))throw new J(13);if(!A.ea.Ca)throw new J(19);var ha=A.ea.Ca(A,b,c,d,n,e,g);v=ha.Bb;a=ha.Ga}Ic[v]={zb:v,yb:d,Ga:a,fd:k,flags:g};return v}catch(da){return"undefined"!==typeof U&&da instanceof J||C(da),-da.fa}},y:function(a,b){V=b;try{var c=W();W();var d=W();W();var e=
P[c];if(!e)throw new J(9);if(0===(e.flags&2097155))throw new J(22);bc(e.node,d);return 0}catch(g){return"undefined"!==typeof U&&g instanceof J||C(g),-g.fa}},z:function(a,b){V=b;try{var c=X(),d=W();return Jc(sa,c,d)}catch(e){return"undefined"!==typeof U&&e instanceof J||C(e),-e.fa}},A:function(a,b){V=b;try{var c=X(),d=W();return Jc($b,c,d)}catch(e){return"undefined"!==typeof U&&e instanceof J||C(e),-e.fa}},B:function(a,b){V=b;try{var c=Y(),d=W();return Jc(sa,c.path,d)}catch(e){return"undefined"!==
typeof U&&e instanceof J||C(e),-e.fa}},C:function(a,b){V=b;return 42},D:function(a,b){return Kc(a,b)},E:Kc,F:function(a,b){V=b;try{var c=W();W();W();var d=P[c];if(!d)throw new J(9);ac(d.node);return 0}catch(e){return"undefined"!==typeof U&&e instanceof J||C(e),-e.fa}},G:function(a,b){V=b;try{var c=X();W();W();ac(c);return 0}catch(d){return"undefined"!==typeof U&&d instanceof J||C(d),-d.fa}},H:function(a,b){V=b;try{var c=Y();switch(W()){case 0:var d=W();return 0>d?-K.ja:p(c.path,c.flags,0,d).fd;case 1:case 2:return 0;
case 3:return c.flags;case 4:return d=W(),c.flags|=d,0;case 12:return d=W(),Ja[d+0>>1]=2,0;case 13:case 14:return 0;case 16:case 8:return-K.ja;case 9:return kb(K.ja),-1;default:return-K.ja}}catch(e){return"undefined"!==typeof U&&e instanceof J||C(e),-e.fa}},I:function(a,b){V=b;try{var c=Y(),d=W(),e=W();return ta(c,l,d,e)}catch(g){return"undefined"!==typeof U&&g instanceof J||C(g),-g.fa}},J:function(a,b){V=b;try{var c=X();var d=W();if(d&-8)var e=-K.ja;else{var g=S(c,{ta:!0}).node;a="";d&4&&(a+="r");
d&2&&(a+="w");d&1&&(a+="x");e=a&&Ob(g,a)?-K.eb:0}return e}catch(k){return"undefined"!==typeof U&&k instanceof J||C(k),-k.fa}},K:function(a,b){V=b;try{var c=X(),d=W();a=c;a=mb(a);"/"===a[a.length-1]&&(a=a.substr(0,a.length-1));T(a,d);return 0}catch(e){return"undefined"!==typeof U&&e instanceof J||C(e),-e.fa}},L:function(a,b){V=b;try{var c=Y(),d=W(),e=W();return la(c,l,d,e)}catch(g){return"undefined"!==typeof U&&g instanceof J||C(g),-g.fa}},M:function(a,b){V=b;try{var c=X(),d=S(c,{parent:!0}).node,
e=pb(c),g=N(d,e),k=Tb(d,e,!0);if(k)throw new J(k);if(!d.ba.rmdir)throw new J(1);if(g.ua)throw new J(16);try{R.willDeletePath&&R.willDeletePath(c)}catch(n){console.log("FS.trackingDelegate['willDeletePath']('"+c+"') threw an exception: "+n.message)}d.ba.rmdir(d,e);Nb(g);try{if(R.onDeletePath)R.onDeletePath(c)}catch(n){console.log("FS.trackingDelegate['onDeletePath']('"+c+"') threw an exception: "+n.message)}return 0}catch(n){return"undefined"!==typeof U&&n instanceof J||C(n),-n.fa}},N:function(a,b){V=
b;try{var c=X(),d=W(),e=W();return p(c,d,e).fd}catch(g){return"undefined"!==typeof U&&g instanceof J||C(g),-g.fa}},O:function(a,b){V=b;try{var c=Y();ma(c);return 0}catch(d){return"undefined"!==typeof U&&d instanceof J||C(d),-d.fa}},P:function(a,b){V=b;try{var c=X(),d=W();var e=W();if(0>=e)var g=-K.ja;else{var k=Jb(c),n=Math.min(e,oa(k)),v=l[d+n];r(k,E,d,e+1);l[d+n]=v;g=n}return g}catch(A){return"undefined"!==typeof U&&A instanceof J||C(A),-A.fa}},Q:function(a,b){V=b;try{var c=W(),d=W(),e=Ic[c];if(!e)return 0;
if(d===e.yb){var g=P[e.fd],k=e.flags,n=new Uint8Array(E.subarray(c,c+d));g&&g.ea.Da&&g.ea.Da(g,n,0,d,k);Ic[c]=null;e.Ga&&fa(e.zb)}return 0}catch(v){return"undefined"!==typeof U&&v instanceof J||C(v),-v.fa}},R:function(a,b){V=b;try{var c=W(),d=W(),e=P[c];if(!e)throw new J(9);ka(e.node,d);return 0}catch(g){return"undefined"!==typeof U&&g instanceof J||C(g),-g.fa}},S:Ha,T:function(a,b,c){E.set(E.subarray(b,b+c),a)},U:function(a){Lc(a)},V:Mc,W:function(a){var b=Date.now();D[a>>2]=b/1E3|0;D[a+4>>2]=b%
1E3*1E3|0;return 0},X:Nc,Y:function(a){return Nc(a)},Z:function(){C("trap!")},_:function(a){return Sc(a,60336)},$:Sc,aa:function(a,b){var c=D[a>>2];a=D[a+4>>2];0!==b&&(D[b>>2]=0,D[b+4>>2]=0);return Tc(1E6*c+a/1E3)},ab:function(a){switch(a){case 30:return 16384;case 85:return E.length/16384;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;
case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;
case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1E3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:return"object"===typeof navigator?navigator.hardwareConcurrency||1:1}kb(22);return-1},
ac:function(a){var b=Date.now()/1E3|0;a&&(D[a>>2]=b);return b},ad:Oc,ae:Tc,af:function(a,b){if(b){var c=1E3*D[b+8>>2];c+=D[b+12>>2]/1E3}else c=Date.now();a=F(a);try{b=c;var d=S(a,{ta:!0}).node;d.ba.ia(d,{timestamp:Math.max(b,c)});return 0}catch(e){a=e;if(!(a instanceof J)){a+=" : ";a:{d=Error();if(!d.stack){try{throw Error(0);}catch(g){d=g}if(!d.stack){d="(no stack trace available)";break a}}d=d.stack.toString()}f.extraStackTrace&&(d+="\n"+f.extraStackTrace());d=Xa(d);throw a+d;}kb(a.fa);return-1}},
ag:Lc,ah:60480,ai:Ga};// EMSCRIPTEN_START_ASM
var Z=(/** @suppress {uselessCode} */ function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer),b=new global.Int16Array(buffer),c=new global.Int32Array(buffer),d=new global.Uint8Array(buffer),e=new global.Uint16Array(buffer),f=new global.Float32Array(buffer),g=new global.Float64Array(buffer),h=env.ah|0,i=env.ai|0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=global.Infinity,s=global.Math.floor,t=global.Math.abs,u=global.Math.sqrt,v=global.Math.pow,w=global.Math.cos,x=global.Math.sin,y=global.Math.tan,z=global.Math.acos,A=global.Math.asin,B=global.Math.atan,C=global.Math.atan2,D=global.Math.exp,E=global.Math.log,F=global.Math.ceil,G=global.Math.imul,H=global.Math.min,I=global.Math.clz32,J=env.a,K=env.b,L=env.c,M=env.d,N=env.e,O=env.f,P=env.g,Q=env.h,R=env.i,S=env.j,T=env.k,U=env.l,V=env.m,W=env.n,X=env.o,Y=env.p,Z=env.q,_=env.r,$=env.s,aa=env.t,ba=env.u,ca=env.v,da=env.w,ea=env.x,fa=env.y,ga=env.z,ha=env.A,ia=env.B,ja=env.C,ka=env.D,la=env.E,ma=env.F,na=env.G,oa=env.H,pa=env.I,qa=env.J,ra=env.K,sa=env.L,ta=env.M,ua=env.N,va=env.O,wa=env.P,xa=env.Q,ya=env.R,za=env.S,Aa=env.T,Ba=env.U,Ca=env.V,Da=env.W,Ea=env.X,Fa=env.Y,Ga=env.Z,Ha=env._,Ia=env.$,Ja=env.aa,Ka=env.ab,La=env.ac,Ma=env.ad,Na=env.ae,Oa=env.af,Pa=env.ag,Qa=60496,Ra=5303376,Sa=0.0;
// EMSCRIPTEN_START_FUNCS
function Pg(f){f=f|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,H=0,I=0,J=0,K=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Ra=0,Sa=0,Ta=0,Za=0,bb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,rb=0,sb=0,tb=0,ub=0,vb=0,wb=0,xb=0,yb=0,zb=0,Ab=0,Cb=0,Eb=0,Fb=0,Gb=0,Hb=0,Ib=0,Jb=0,Kb=0,Lb=0,Mb=0,Nb=0,Ob=0,Pb=0,Qb=0,Rb=0,Sb=0,Tb=0,Ub=0,Vb=0,Wb=0,Yb=0,_b=0,$b=0,ac=0,bc=0,cc=0,dc=0,ec=0,fc=0,gc=0,hc=0,ic=0,jc=0,kc=0,lc=0,mc=0,nc=0,oc=0,pc=0,qc=0,rc=0,sc=0,tc=0,uc=0,vc=0,xc=0,yc=0,zc=0,Ac=0,Bc=0,Cc=0,Dc=0,Ec=0,Fc=0,Gc=0,Hc=0,Ic=0,Jc=0,Kc=0,Lc=0,Mc=0,Nc=0,Oc=0,Pc=0,Qc=0,Rc=0,Sc=0,Tc=0,Uc=0,Vc=0,Wc=0,Xc=0,Zc=0,_c=0,$c=0,ad=0,cd=0,dd=0,ed=0,fd=0,gd=0,hd=0,id=0,jd=0,kd=0,md=0,nd=0,od=0,pd=0,qd=0,rd=0,sd=0,td=0,ud=0,vd=0,wd=0,xd=0,yd=0,zd=0,Ad=0,Bd=0,Cd=0,Dd=0,Ed=0,Fd=0,Gd=0,Hd=0,Id=0,Jd=0,Kd=0,Md=0,Nd=0,Od=0,Pd=0,Rd=0,Sd=0,Td=0,Ud=0,Wd=0,_d=0,$d=0,ae=0,be=0,ce=0,de=0,ee=0,fe=0,ge=0,he=0,ie=0,je=0,ke=0,le=0,me=0,ne=0,oe=0,pe=0,qe=0,re=0,se=0,te=0,ue=0,ve=0,we=0,xe=0,ye=0,ze=0,Ae=0,Be=0,Ce=0,De=0,Ee=0,Fe=0,Ge=0,He=0,Ie=0,Je=0,Ke=0,Le=0,Me=0,Oe=0,Pe=0,Qe=0,Re=0,Se=0,Ue=0,Ve=0,We=0,Xe=0,Ye=0,Ze=0,_e=0,$e=0,af=0,bf=0,cf=0,df=0,ef=0,ff=0,gf=0,hf=0,jf=0,kf=0,lf=0,mf=0,nf=0,of=0,pf=0,qf=0,rf=0,sf=0,tf=0,vf=0,wf=0,xf=0,yf=0,zf=0,Af=0,Cf=0,Df=0,Ef=0,Ff=0,Gf=0,Hf=0;Hf=Qa;Qa=Qa+864|0;nf=Hf+848|0;yf=Hf+840|0;Be=Hf+832|0;Gf=Hf+816|0;Ff=Hf+800|0;Ef=Hf+792|0;ze=Hf+784|0;ye=Hf+776|0;xe=Hf+768|0;we=Hf+760|0;ve=Hf+752|0;ue=Hf+736|0;te=Hf+728|0;bf=Hf+720|0;Ye=Hf+712|0;Xe=Hf+704|0;We=Hf+696|0;Ve=Hf+688|0;Ue=Hf+664|0;Se=Hf+656|0;Re=Hf+648|0;Qe=Hf+640|0;Pe=Hf+624|0;Oe=Hf+608|0;Me=Hf+592|0;Le=Hf+576|0;Ke=Hf+560|0;Je=Hf+544|0;ef=Hf+536|0;df=Hf+528|0;cf=Hf+520|0;Ie=Hf+512|0;He=Hf+504|0;Ge=Hf+496|0;Fe=Hf+488|0;Ee=Hf+472|0;De=Hf+456|0;Ce=Hf+440|0;Ae=Hf+432|0;lf=Hf+416|0;gf=Hf+408|0;kf=Hf+400|0;ff=Hf+392|0;rf=Hf+352|0;Hd=Hf+112|0;Td=Hf+280|0;$d=Hf;ee=Hf+272|0;je=Hf+852|0;le=f+104|0;q=c[le>>2]|0;Df=c[f>>2]|0;sd=a[Df+78>>0]|0;xd=f+88|0;o=c[xd>>2]|0;i=c[f+156>>2]|0;if(i|0?(k=c[Df+16>>2]|0,l=c[Df+20>>2]|0,(l|0)>0):0){h=0;do{if(((h|0)!=1?1<<h&i|0:0)?(m=c[k+(h<<4)+4>>2]|0,m|0):0)c[(c[m+4>>2]|0)+4>>2]=c[m>>2];h=h+1|0}while((h|0)!=(l|0))}Af=Df+320|0;if(!(c[Af>>2]|0))h=-1;else{h=c[Df+328>>2]|0;h=h-(((c[f+176>>2]|0)>>>0)%(h>>>0)|0)|0}Cf=f+40|0;a:do if((c[Cf>>2]|0)==7){l=q;n=0;k=0;m=q;j=h;i=Df+81|0;oa=3892}else{_c=f+56|0;c[_c>>2]=0;c[_c+4>>2]=0;_c=f+120|0;c[_c>>2]=0;c[Df+404>>2]=0;lc=Df+264|0;b:do if(!(c[lc>>2]|0)){xf=f+36|0;mc=f+100|0;qf=Df+88|0;nc=f+196|0;oc=f+96|0;pc=f+147|0;vf=Df+16|0;wf=f+149|0;qc=rf+8|0;rc=f+44|0;sc=Df+100|0;tc=Df+104|0;uc=f+168|0;vc=Hd+8|0;xc=Hd+10|0;yc=Hd+4|0;zc=Hd+8|0;Ac=Hd+10|0;Bc=Hd+4|0;Cc=Df+90|0;Dc=Td+4|0;Ec=Td+12|0;Fc=Td+16|0;Gc=Td+20|0;Hc=Td+24|0;Ic=Td+28|0;Jc=Td+8|0;Kc=Td+64|0;Lc=Td+40|0;Mc=Td+44|0;Nc=Td+48|0;Oc=Td+52|0;Pc=Td+56|0;Qc=Td+60|0;Rc=Td+61|0;Sc=Df+32|0;$c=Df+272|0;Tc=rf+8|0;Uc=rf+4|0;mf=f+124|0;Vc=Df+332|0;Wc=rf+32|0;sa=rf+8|0;ad=Df+184|0;ta=f+92|0;zf=Df+81|0;ua=f+32|0;cd=Df+176|0;qd=Df+444|0;va=f+24|0;wa=$d+8|0;xa=$d+10|0;ya=$d+4|0;za=$d+14|0;Aa=Hd+8|0;Ba=Hd+4|0;Ca=Df+232|0;Da=Df+108|0;Ea=rf+8|0;Fa=rf+32|0;Ga=rf+24|0;Ha=Df+172|0;hf=Df+24|0;Ia=rf+8|0;Ja=rf+4|0;Ka=rf+16|0;Ze=Df+480|0;La=f+204|0;Ma=Df+148|0;Na=Df+472|0;Oa=f+64|0;Pa=Df+464|0;Xc=Df+276|0;Ra=rf+12|0;Sa=Hd+8|0;Ta=Hd+32|0;Za=rf+8|0;bb=rf+4|0;db=Df+4|0;eb=Df+356|0;fb=Df+328|0;gb=Df+324|0;hb=sd<<24>>24==1;ib=f+184|0;_e=Df+304|0;$e=Df+308|0;af=Df+300|0;jb=Hd+8|0;kb=Hd+32|0;lb=Hd+24|0;mb=rf+16|0;nb=rf+12|0;ob=Df+165|0;pb=rf+12|0;rb=rf+20|0;Zc=Df+288|0;sb=rf+20|0;tb=rf+8|0;ub=rf+4|0;vb=rf+20|0;wb=f+108|0;hd=f+188|0;Fd=Df+456|0;Gd=Df+452|0;xb=rf+16|0;yb=rf+28|0;zb=Df+40|0;Ab=Hd+8|0;Cb=Hd+20|0;Eb=Hd+24|0;Fb=Hd+16|0;Gb=Hd+12|0;Hb=f+216|0;Ib=f+28|0;dd=Df+296|0;ed=Df+284|0;Jb=rf+10|0;Kb=rf+20|0;Lb=Df+180|0;of=Df+196|0;pf=Df+200|0;Mb=rf+8|0;Nb=rf+8|0;fd=Df+292|0;Ob=rf+16|0;Pb=Df+348|0;Qb=rf+24|0;Rb=Df+86|0;gd=Df+79|0;Sb=rf+32|0;Tb=Df+228|0;Ub=rf+8|0;Vb=Df+344|0;Wb=Df+340|0;Yb=rf+12|0;_b=Hd+16|0;$b=Hd+8|0;ac=Hd+12|0;bc=f+48|0;ra=Df+80|0;cc=rf+8|0;dc=Df+336|0;ec=rf+20|0;Id=Df+87|0;fc=Hd+24|0;sf=Df+20|0;jf=Df+56|0;gc=f+72|0;hc=f+80|0;ic=rf+8|0;Jd=f+146|0;jc=Df+8|0;kc=rf+4|0;m=q;p=q+((c[xf>>2]|0)*20|0)|0;K=0;k=0;qa=0;n=0;pa=o;c:while(1){n=n+1|0;z=a[p>>0]|0;d:do switch(z<<24>>24){case 81:{oa=153;break c}case 1:{oa=922;break c}case 11:{i=K;oa=20;break}case 12:{i=c[p+4>>2]|0;b[pa+(i*40|0)+8>>1]=4;oa=(p-m|0)/20|0;i=pa+(i*40|0)|0;c[i>>2]=oa;c[i+4>>2]=((oa|0)<0)<<31>>31;i=K;oa=28;break}case 66:{l=c[p+4>>2]|0;p=m+((c[pa+(l*40|0)>>2]|0)*20|0)|0;b[pa+(l*40|0)+8>>1]=128;l=m;q=pa;o=qa;i=K;break}case 13:{na=c[p+4>>2]|0;la=(c[p+12>>2]|0)+-1|0;ma=pa+(na*40|0)|0;c[ma>>2]=la;c[ma+4>>2]=((la|0)<0)<<31>>31;b[pa+(na*40|0)+8>>1]=4;if(!(c[p+8>>2]|0)){l=m;q=pa;o=qa;i=K}else{i=K;oa=28}break}case 67:{l=c[p+4>>2]|0;p=m+(((c[m+((c[pa+(l*40|0)>>2]|0)*20|0)+8>>2]|0)+-1|0)*20|0)|0;b[pa+(l*40|0)+8>>1]=128;l=m;q=pa;o=qa;i=K;break}case 14:{l=c[p+4>>2]|0;b[pa+(l*40|0)+8>>1]=4;l=pa+(l*40|0)|0;i=c[l>>2]|0;q=(p-m|0)/20|0;c[l>>2]=q;c[l+4>>2]=((q|0)<0)<<31>>31;l=m;q=pa;o=qa;p=m+(i*20|0)|0;i=K;break}case 68:{if(!(b[pa+((c[p+12>>2]|0)*40|0)+8>>1]&1)){l=m;q=pa;o=qa;i=K}else oa=34;break}case 69:{oa=34;break}case 70:{na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216))b[l>>1]=4;else jh(i)|0;q=c[p+4>>2]|0;l=i;c[l>>2]=q;c[l+4>>2]=((q|0)<0)<<31>>31;l=m;q=pa;o=qa;i=K;break}case 71:{na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216))b[l>>1]=4;else jh(i)|0;o=c[p+16>>2]|0;q=c[o+4>>2]|0;l=i;c[l>>2]=c[o>>2];c[l+4>>2]=q;l=m;q=pa;o=qa;i=K;break}case -111:{na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216))b[l>>1]=4;else jh(i)|0;b[i+8>>1]=8;g[i>>3]=+g[c[p+16>>2]>>3];l=m;q=pa;o=qa;i=K;break}case 110:{oa=c[xd>>2]|0;s=p+8|0;l=c[s>>2]|0;i=oa+(l*40|0)|0;l=oa+(l*40|0)+8|0;if(!(b[l>>1]&9216))b[l>>1]=4;else jh(i)|0;a[p>>0]=72;q=p+16|0;o=c[q>>2]|0;if(!o)l=0;else l=(Cu(o)|0)&1073741823;r=p+4|0;c[r>>2]=l;if(hb)i=K;else{if(wc(i,o,-1,1,0)|0){oa=3891;break c}o=i+8|0;l=b[o>>1]|0;if((l&2)!=0?(a[i+10>>0]|0)!=sd<<24>>24:0){if(Gg(i,sd)|0){l=p;j=h;i=zf;oa=3892;break a}l=b[o>>1]|0}c[i+24>>2]=0;b[o>>1]=l|2048;l=p+1|0;e:do if((a[l>>0]|0)==-7?(ae=c[q>>2]|0,ae|0):0){if(c[Ze>>2]|0){Vd(Df,ae);break}o=ae;do if((c[_e>>2]|0)>>>0<=o>>>0){if((c[$e>>2]|0)>>>0<=o>>>0)break;c[ae>>2]=c[af>>2];c[af>>2]=ae;break e}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](ae);break}else{oa=Ua[c[29352>>2]&127](ae)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](ae);break}}while(0);a[l>>0]=-7;c[q>>2]=c[i+16>>2];l=c[i+12>>2]|0;c[r>>2]=l;i=0}if((l|0)>(c[Da>>2]|0)){oa=3891;break c}else{l=s;oa=83}break}case 72:{l=p+8|0;i=K;oa=83;break}case 73:{o=c[xd>>2]|0;q=p+8|0;i=c[q>>2]|0;l=o+(i*40|0)|0;o=o+(i*40|0)+8|0;if(!(b[o>>1]&9216))b[o>>1]=4;else{jh(l)|0;i=c[q>>2]|0}i=(c[p+12>>2]|0)-i|0;r=(c[p+4>>2]|0)==0?1:257;b[l+8>>1]=r;c[l+12>>2]=0;if((i|0)>0)while(1){o=l;l=l+40|0;q=o+48|0;if(!(b[q>>1]&9216))b[q>>1]=1;else Bg(l);b[q>>1]=r;c[o+52>>2]=0;if((i|0)<=1){l=m;q=pa;o=qa;i=K;break}else i=i+-1|0}else{l=m;q=pa;o=qa;i=K}break}case 74:{l=pa+((c[p+4>>2]|0)*40|0)+8|0;b[l>>1]=b[l>>1]&-160|1;l=m;q=pa;o=qa;i=K;break}case 75:{na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216))b[l>>1]=4;else jh(i)|0;wc(i,c[p+16>>2]|0,c[p+4>>2]|0,0,0)|0;a[i+10>>0]=sd;l=m;q=pa;o=qa;i=K;break}case 76:{o=c[mc>>2]|0;q=(c[p+4>>2]|0)+-1|0;r=o+(q*40|0)|0;l=e[o+(q*40|0)+8>>1]|0;if(l&18|0){i=c[o+(q*40|0)+12>>2]|0;if(l&16384)i=(c[r>>2]|0)+i|0;if((i|0)>(c[(c[o+(q*40|0)+32>>2]|0)+108>>2]|0)){oa=3891;break c}}l=c[p+8>>2]|0;i=pa+(l*40|0)|0;l=pa+(l*40|0)+8|0;if(b[l>>1]&9216)Bg(i);c[i>>2]=c[r>>2];c[i+4>>2]=c[r+4>>2];c[i+8>>2]=c[r+8>>2];c[i+12>>2]=c[r+12>>2];c[i+16>>2]=c[r+16>>2];b[l>>1]=b[l>>1]&-7201|2080;l=m;q=pa;o=qa;i=K;break}case 77:{q=pa+((c[p+4>>2]|0)*40|0)|0;r=c[p+12>>2]|0;s=pa+((c[p+8>>2]|0)*40|0)|0;while(1){t=s+8|0;if(!((b[t>>1]&9216)==0?!(c[s+24>>2]|0):0))Ag(s);ea=s;l=q;fa=ea+40|0;do{c[ea>>2]=c[l>>2];ea=ea+4|0;l=l+4|0}while((ea|0)<(fa|0));b[q+8>>1]=1;c[q+24>>2]=0;i=b[t>>1]|0;if(i&4096){l=i&65535;do if(l&18){do if(l&16384){o=s+12|0;l=(c[s>>2]|0)+(c[o>>2]|0)|0;if((l|0)<1)if(!(i&16))break;else i=1;else i=l;if(Cg(s,i,1)|0){l=p;j=h;i=zf;oa=3892;break a}ew((c[s+16>>2]|0)+(c[o>>2]|0)|0,0,c[s>>2]|0)|0;c[o>>2]=(c[o>>2]|0)+(c[s>>2]|0);i=b[t>>1]&-16897;b[t>>1]=i}while(0);if(c[s+24>>2]|0?(c[s+16>>2]|0)==(c[s+20>>2]|0):0)break;if(Hg(s)|0){l=p;j=h;i=zf;oa=3892;break a}i=b[t>>1]|0}while(0);b[t>>1]=i&-4097}r=r+-1|0;if(!r){l=m;q=pa;o=qa;i=K;break}else{q=q+40|0;s=s+40|0}}break}case 78:{q=c[p+12>>2]|0;r=pa+((c[p+4>>2]|0)*40|0)|0;s=pa+((c[p+8>>2]|0)*40|0)|0;while(1){t=s+8|0;if(!(b[t>>1]&9216)){c[s>>2]=c[r>>2];c[s+4>>2]=c[r+4>>2];c[s+8>>2]=c[r+8>>2];c[s+12>>2]=c[r+12>>2];c[s+16>>2]=c[r+16>>2];if(!(b[r+8>>1]&2048))b[t>>1]=b[t>>1]&-7169|4096}else kh(s,r,4096);i=b[t>>1]|0;if(i&4096){l=i&65535;do if(l&18){do if(l&16384){o=s+12|0;l=(c[s>>2]|0)+(c[o>>2]|0)|0;if((l|0)<1)if(!(i&16))break;else i=1;else i=l;if(Cg(s,i,1)|0){l=p;j=h;i=zf;oa=3892;break a}ew((c[s+16>>2]|0)+(c[o>>2]|0)|0,0,c[s>>2]|0)|0;c[o>>2]=(c[o>>2]|0)+(c[s>>2]|0);i=b[t>>1]&-16897;b[t>>1]=i}while(0);if(c[s+24>>2]|0?(c[s+16>>2]|0)==(c[s+20>>2]|0):0)break;if(Hg(s)|0){l=p;j=h;i=zf;oa=3892;break a}i=b[t>>1]|0}while(0);b[t>>1]=i&-4097}if(!q){l=m;q=pa;o=qa;i=K;break d}q=q+-1|0;r=r+40|0;s=s+40|0}}case 79:{i=c[p+4>>2]|0;l=pa+(i*40|0)|0;q=c[p+8>>2]|0;o=pa+(q*40|0)|0;q=pa+(q*40|0)+8|0;if(b[q>>1]&9216){kh(o,l,4096);l=m;q=pa;o=qa;i=K;break d};c[o>>2]=c[l>>2];c[o+4>>2]=c[l+4>>2];c[o+8>>2]=c[l+8>>2];c[o+12>>2]=c[l+12>>2];c[o+16>>2]=c[l+16>>2];if(!(b[pa+(i*40|0)+8>>1]&2048)){b[q>>1]=b[q>>1]&-7169|4096;l=m;q=pa;o=qa;i=K}else{l=m;q=pa;o=qa;i=K}break}case 80:{q=c[p+8>>2]|0;i=pa+(q*40|0)|0;o=pa+((c[p+4>>2]|0)*40|0)|0;l=c[o>>2]|0;o=c[o+4>>2]|0;q=pa+(q*40|0)+8|0;if(!(b[q>>1]&9216)){c[i>>2]=l;c[i+4>>2]=o;b[q>>1]=4;l=m;q=pa;o=qa;i=K;break d}else{Ng(i,l,o);l=m;q=pa;o=qa;i=K;break d}}case 105:{z=c[p+4>>2]|0;s=pa+(z*40|0)|0;x=c[p+8>>2]|0;w=pa+(x*40|0)|0;A=c[p+12>>2]|0;y=pa+(A*40|0)|0;r=pa+(z*40|0)+8|0;l=b[r>>1]|0;t=pa+(x*40|0)+8|0;i=b[t>>1]|0;if((i|l)&1){i=pa+(A*40|0)+8|0;if(!(b[i>>1]&9216)){b[i>>1]=1;l=m;q=pa;o=qa;i=K;break d}else{Bg(y);l=m;q=pa;o=qa;i=K;break d}}do if(l&16384){q=pa+(z*40|0)+12|0;o=(c[s>>2]|0)+(c[q>>2]|0)|0;if((o|0)<1)if(!(l&16))break;else i=1;else i=o;if(Cg(s,i,1)|0){l=p;j=h;i=zf;oa=3892;break a}ew((c[pa+(z*40|0)+16>>2]|0)+(c[q>>2]|0)|0,0,c[s>>2]|0)|0;c[q>>2]=(c[q>>2]|0)+(c[s>>2]|0);l=b[r>>1]&-16897;b[r>>1]=l;i=b[t>>1]|0}while(0);do if(i&16384){q=pa+(x*40|0)+12|0;o=(c[w>>2]|0)+(c[q>>2]|0)|0;if((o|0)<1)if(!(i&16))break;else i=1;else i=o;if(Cg(w,i,1)|0){l=p;j=h;i=zf;oa=3892;break a}ew((c[pa+(x*40|0)+16>>2]|0)+(c[q>>2]|0)|0,0,c[w>>2]|0)|0;c[q>>2]=(c[q>>2]|0)+(c[w>>2]|0);i=b[t>>1]&-16897;b[t>>1]=i;l=b[r>>1]|0}while(0);if(!(l&18)){if(Fg(s,sd,0)|0){l=p;j=h;i=zf;oa=3892;break a}i=b[t>>1]|0}if((i&18)==0?Fg(w,sd,0)|0:0){l=p;j=h;i=zf;oa=3892;break a}q=pa+(z*40|0)+12|0;r=pa+(x*40|0)+12|0;s=(c[r>>2]|0)+(c[q>>2]|0)|0;if((s|0)>(c[Da>>2]|0)){oa=3891;break c}l=(A|0)==(x|0);if(Cg(y,s+2|0,l&1)|0){l=p;j=h;i=zf;oa=3892;break a}o=pa+(A*40|0)+8|0;b[o>>1]=b[o>>1]&15904|2;i=pa+(x*40|0)+16|0;if(!l){na=pa+(A*40|0)+16|0;cw(c[na>>2]|0,c[i>>2]|0,c[r>>2]|0)|0;i=na}cw((c[i>>2]|0)+(c[r>>2]|0)|0,c[pa+(z*40|0)+16>>2]|0,c[q>>2]|0)|0;a[(c[i>>2]|0)+s>>0]=0;a[(c[i>>2]|0)+(s+1)>>0]=0;b[o>>1]=b[o>>1]|512;c[pa+(A*40|0)+12>>2]=s;a[pa+(A*40|0)+10>>0]=sd;l=m;q=pa;o=qa;i=K;break}case 104:case 103:case 102:case 101:case 100:{s=c[p+4>>2]|0;t=pa+(s*40|0)|0;r=pa+(s*40|0)+8|0;i=e[r>>1]|0;l=i&12;if(!l)if(!(i&18))B=0;else B=lh(t)|0;else B=l&65535;x=c[p+8>>2]|0;y=pa+(x*40|0)|0;w=pa+(x*40|0)+8|0;i=e[w>>1]|0;l=i&12;if(!l)if(!(i&18))A=0;else A=lh(y)|0;else A=l&65535;C=c[p+12>>2]|0;D=pa+(C*40|0)|0;f:do if(!((B&4&A)<<16>>16)){if(!((b[w>>1]|b[r>>1])&1)){z=0;oa=245}}else{i=t;o=c[i>>2]|0;i=c[i+4>>2]|0;q=y;l=c[q>>2]|0;q=c[q+4>>2]|0;g:do switch(a[p>>0]|0){case 100:{if((i|0)>-1|(i|0)==-1&o>>>0>4294967295){na=Rv(-1,2147483647,l|0,q|0)|0;ma=L()|0;if(((q|0)>0|(q|0)==0&l>>>0>0)&((ma|0)<(i|0)|(ma|0)==(i|0)&na>>>0<o>>>0)){z=1;oa=245;break f}}else if((q|0)<0?(ma=Rv(1,-2147483648,l|0,q|0)|0,ka=L()|0,na=Qv(o|0,i|0,1,0)|0,la=L()|0,(ka|0)>(la|0)|(ka|0)==(la|0)&ma>>>0>na>>>0):0){z=1;oa=245;break f}l=Qv(l|0,q|0,o|0,i|0)|0;i=L()|0;break}case 101:{if((o|0)==0&(i|0)==-2147483648)if((q|0)>-1|(q|0)==-1&l>>>0>4294967295){z=1;oa=245;break f}else{i=q^-2147483648;break g}if((i|0)<0|(i|0)==0&o>>>0<1){na=Rv(0,0,o|0,i|0)|0;la=L()|0;ma=Rv(-1,2147483647,l|0,q|0)|0;ka=L()|0;if(((q|0)>0|(q|0)==0&l>>>0>0)&((ka|0)<(la|0)|(ka|0)==(la|0)&ma>>>0<na>>>0)){z=1;oa=245;break f}}else if((q|0)<0?(ma=Rv(1,-2147483648,l|0,q|0)|0,ka=L()|0,na=Rv(1,0,o|0,i|0)|0,la=L()|0,(ka|0)>(la|0)|(ka|0)==(la|0)&ma>>>0>na>>>0):0){z=1;oa=245;break f}l=Rv(l|0,q|0,o|0,i|0)|0;i=L()|0;break}case 102:{do if((i|0)>0|(i|0)==0&o>>>0>0){na=Yv(-1,2147483647,o|0,i|0)|0;ma=L()|0;if((q|0)>(ma|0)|(q|0)==(ma|0)&l>>>0>na>>>0){z=1;oa=245;break f}na=Uv(0,-2147483648,o|0,i|0)|0;ma=L()|0;if((q|0)<(ma|0)|(q|0)==(ma|0)&l>>>0<na>>>0){z=1;oa=245;break f}}else if((i|0)<0){if((q|0)>0|(q|0)==0&l>>>0>0){na=Uv(0,-2147483648,l|0,q|0)|0;ma=L()|0;if((ma|0)>(i|0)|(ma|0)==(i|0)&na>>>0>o>>>0){z=1;oa=245;break f}else break}if((q|0)<0){if((o|0)==0&(i|0)==-2147483648|(l|0)==0&(q|0)==-2147483648){z=1;oa=245;break f}na=Rv(0,0,l|0,q|0)|0;la=L()|0;ma=Rv(0,0,o|0,i|0)|0;ma=Uv(-1,2147483647,ma|0,L()|0)|0;ka=L()|0;if((ka|0)<(la|0)|(ka|0)==(la|0)&ma>>>0<na>>>0){z=1;oa=245;break f}}}while(0);l=Wv(l|0,q|0,o|0,i|0)|0;i=L()|0;break}case 103:{if((o|0)==0&(i|0)==0)break f;if((o|0)==-1&(i|0)==-1&((l|0)==0&(q|0)==-2147483648)){z=1;oa=245;break f}l=Uv(l|0,q|0,o|0,i|0)|0;i=L()|0;break}default:{switch(o|0){case 0:{if(!i)break f;break}case -1:{if((i|0)==-1){o=1;i=0}break}default:{}}l=Xv(l|0,q|0,o|0,i|0)|0;i=L()|0}}while(0);q=D;c[q>>2]=l;c[q+4>>2]=i;l=pa+(C*40|0)+8|0;b[l>>1]=b[l>>1]&15904|4;l=m;q=pa;o=qa;i=K;break d}while(0);h:do if((oa|0)==245){oa=0;i=e[r>>1]|0;do if(!(i&8)){if(i&4|0){na=t;v=+((c[na>>2]|0)>>>0)+4294967296.0*+(c[na+4>>2]|0);break}if(!(i&18))v=0.0;else v=+Ig(a[pa+(s*40|0)+10>>0]|0,c[pa+(s*40|0)+12>>2]|0,c[pa+(s*40|0)+16>>2]|0)}else v=+g[t>>3];while(0);i=e[w>>1]|0;do if(!(i&8)){if(i&4|0){na=y;u=+((c[na>>2]|0)>>>0)+4294967296.0*+(c[na+4>>2]|0);break}if(!(i&18))u=0.0;else u=+Ig(a[pa+(x*40|0)+10>>0]|0,c[pa+(x*40|0)+12>>2]|0,c[pa+(x*40|0)+16>>2]|0)}else u=+g[y>>3];while(0);switch(a[p>>0]|0){case 100:{u=v+u;break}case 101:{u=u-v;break}case 102:{u=v*u;break}case 103:{if(v==0.0)break h;u=u/v;break}default:{i=e[r>>1]|0;do if(!(i&4)){if(i&8|0){r=Kg(+g[t>>3])|0;i=L()|0;break}if(!(i&18)){r=0;i=0}else{r=Lg(a[pa+(s*40|0)+10>>0]|0,c[pa+(s*40|0)+12>>2]|0,c[pa+(s*40|0)+16>>2]|0)|0;i=L()|0}}else{i=t;r=c[i>>2]|0;i=c[i+4>>2]|0}while(0);l=e[w>>1]|0;do if(!(l&4)){if(l&8|0){o=Kg(+g[y>>3])|0;q=L()|0;break}if(!(l&18)){o=0;q=0}else{o=Lg(a[pa+(x*40|0)+10>>0]|0,c[pa+(x*40|0)+12>>2]|0,c[pa+(x*40|0)+16>>2]|0)|0;q=L()|0}}else{q=y;o=c[q>>2]|0;q=c[q+4>>2]|0}while(0);switch(r|0){case 0:{if(!i)break h;else l=r;break}case -1:{if((i|0)==-1){l=1;i=0}else l=r;break}default:l=r}u=+((Xv(o|0,q|0,l|0,i|0)|0)>>>0)+4294967296.0*+(L()|0)}}g[rf>>3]=u;g[Hd>>3]=+g[rf>>3];if(+g[rf>>3]==+g[Hd>>3]){g[D>>3]=u;o=pa+(C*40|0)+8|0;q=b[o>>1]&15904;b[o>>1]=q|8;if(((A|B)&8)!=0|z<<24>>24!=0){l=m;q=pa;o=qa;i=K;break d}i=Kg(u)|0;l=L()|0;na=Qv(i|0,l|0,1,-2147483648)|0;ma=L()|0;if(!((ma>>>0>0|(ma|0)==0&na>>>0>1)&u==+(i>>>0)+4294967296.0*+(l|0))){l=m;q=pa;o=qa;i=K;break d}na=D;c[na>>2]=i;c[na+4>>2]=l;b[o>>1]=q|4;l=m;q=pa;o=qa;i=K;break d}}while(0);i=pa+(C*40|0)+8|0;if(!(b[i>>1]&9216)){b[i>>1]=1;l=m;q=pa;o=qa;i=K;break d}else{Bg(D);l=m;q=pa;o=qa;i=K;break d}}case 82:{i=c[p+4>>2]|0;if(i){l=pa+(i*40|0)|0;i=pa+(i*40|0)+8|0;if(!(b[i>>1]&9216)){c[l>>2]=0;c[l+4>>2]=0;b[i>>1]=4;l=m;q=pa;o=qa;i=K;break d}else{Ng(l,0,0);l=m;q=pa;o=qa;i=K;break d}}else{l=m;q=pa;o=qa;i=K}break}case 99:case 98:case 97:case 96:{s=c[p+4>>2]|0;l=c[p+8>>2]|0;w=c[p+12>>2]|0;x=pa+(w*40|0)|0;q=pa+(s*40|0)+8|0;o=b[q>>1]|0;i=b[pa+(l*40|0)+8>>1]|0;if((i|o)&1){i=pa+(w*40|0)+8|0;if(!(b[i>>1]&9216)){b[i>>1]=1;l=m;q=pa;o=qa;i=K;break d}else{Bg(x);l=m;q=pa;o=qa;i=K;break d}}r=pa+(l*40|0)|0;t=pa+(s*40|0)|0;i=i&65535;do if(!(i&4)){if(i&8|0){l=Kg(+g[r>>3])|0;i=L()|0;break}if(!(i&18)){l=0;i=0}else{l=Lg(a[pa+(l*40|0)+10>>0]|0,c[pa+(l*40|0)+12>>2]|0,c[pa+(l*40|0)+16>>2]|0)|0;i=L()|0;o=b[q>>1]|0}}else{i=r;l=c[i>>2]|0;i=c[i+4>>2]|0}while(0);o=o&65535;do if(!(o&4)){if(o&8|0){q=Kg(+g[t>>3])|0;s=L()|0;break}if(!(o&18)){q=0;s=0}else{q=Lg(a[pa+(s*40|0)+10>>0]|0,c[pa+(s*40|0)+12>>2]|0,c[pa+(s*40|0)+16>>2]|0)|0;s=L()|0}}else{s=t;q=c[s>>2]|0;s=c[s+4>>2]|0}while(0);o=a[p>>0]|0;i:do switch(o<<24>>24){case 96:{l=q&l;i=s&i;break}case 97:{l=q|l;i=s|i;break}default:if(!((q|0)==0&(s|0)==0)){la=(s|0)<0;ma=(s|0)>-1|(s|0)==-1&q>>>0>4294967232;ka=Rv(0,0,q|0,s|0)|0;na=L()|0;r=la?197-(o&255)&255:o;q=la?(ma?ka:64):q;o=la?(ma?na:0):s;if((o|0)>0|(o|0)==0&q>>>0>63){i=((i|0)<0&r<<24>>24!=98)<<31>>31;l=i;i=((i|0)<0)<<31>>31;break i}if(r<<24>>24==98){l=aw(l|0,i|0,q|0)|0;i=L()|0;break i}else{l=$v(l|0,i|0,q|0)|0;na=L()|0;ma=(i|0)<0;la=Rv(64,0,q|0,o|0)|0;L()|0;la=aw(-1,-1,la|0)|0;i=L()|0;l=(ma?la:0)|l;i=(ma?i:0)|na;break i}}}while(0);q=x;c[q>>2]=l;c[q+4>>2]=i;l=pa+(w*40|0)+8|0;b[l>>1]=b[l>>1]&15904|4;l=m;q=pa;o=qa;i=K;break}case 83:{i=c[p+4>>2]|0;r=pa+(i*40|0)|0;s=pa+(i*40|0)+8|0;q=b[s>>1]|0;l=q&65535;do if(!(l&4)){if(l&8|0){l=Kg(+g[r>>3])|0;o=L()|0;i=q;break}if(!(l&18)){l=0;o=0;i=q}else{l=Lg(a[pa+(i*40|0)+10>>0]|0,c[pa+(i*40|0)+12>>2]|0,c[pa+(i*40|0)+16>>2]|0)|0;o=L()|0;i=b[s>>1]|0}}else{o=r;l=c[o>>2]|0;o=c[o+4>>2]|0;i=q}while(0);q=r;c[q>>2]=l;c[q+4>>2]=o;b[s>>1]=i&15904|4;q=c[p+8>>2]|0;o=Qv(l|0,o|0,q|0,((q|0)<0)<<31>>31|0)|0;q=L()|0;l=r;c[l>>2]=o;c[l+4>>2]=q;l=m;q=pa;o=qa;i=K;break}case 15:{q=c[p+4>>2]|0;s=pa+(q*40|0)+8|0;i=b[s>>1]|0;if(!(i&4)){r=pa+(q*40|0)|0;l=i&65535;do if(!(l&4)){if(l&8|0){v=+g[r>>3];l=Kg(v)|0;o=L()|0;na=Qv(l|0,o|0,1,-2147483648)|0;ma=L()|0;q=i&15904|4;if(!((ma>>>0>0|(ma|0)==0&na>>>0>1)&v==+(l>>>0)+4294967296.0*+(o|0)))break;i=r;c[i>>2]=l;c[i+4>>2]=o;b[s>>1]=q;i=q;break}if(l&2){l=a[pa+(q*40|0)+10>>0]|0;o=pa+(q*40|0)+16|0;i=pa+(q*40|0)+12|0;if(!(Jg(c[o>>2]|0,rf,c[i>>2]|0,l)|0))i=b[s>>1]|0;else{if(Mg(c[o>>2]|0,Hd,c[i>>2]|0,l)|0){v=+g[rf>>3];g[r>>3]=v;l=b[s>>1]|0;i=l|8;b[s>>1]=i;o=Kg(v)|0;q=L()|0;na=Qv(o|0,q|0,1,-2147483648)|0;ma=L()|0;if((ma>>>0>0|(ma|0)==0&na>>>0>1)&v==+(o>>>0)+4294967296.0*+(q|0)){i=r;c[i>>2]=o;c[i+4>>2]=q;i=l&15904;oa=334}}else{na=Hd;oa=c[na+4>>2]|0;i=r;c[i>>2]=c[na>>2];c[i+4>>2]=oa;i=b[s>>1]|0;oa=334}if((oa|0)==334){oa=0;i=i|4;b[s>>1]=i}i=i&-3;b[s>>1]=i}}}while(0);if(!(i&4))if(!(c[p+8>>2]|0)){i=20;oa=3855;break c}else{i=K;oa=28;break d}}b[s>>1]=i&15904|4;l=m;q=pa;o=qa;i=K;break}case 84:{l=c[p+4>>2]|0;q=pa+(l*40|0)+8|0;i=b[q>>1]|0;if(!(i&4)){l=m;q=pa;o=qa;i=K}else{r=pa+(l*40|0)|0;o=i&65535;do if(!(o&8)){if(o&4|0){na=r;u=+((c[na>>2]|0)>>>0)+4294967296.0*+(c[na+4>>2]|0);break}if(!(o&18))u=0.0;else{u=+Ig(a[pa+(l*40|0)+10>>0]|0,c[pa+(l*40|0)+12>>2]|0,c[pa+(l*40|0)+16>>2]|0);i=b[q>>1]|0}}else u=+g[r>>3];while(0);g[r>>3]=u;b[q>>1]=i&15904|8;l=m;q=pa;o=qa;i=K}break}case 85:{o=c[p+4>>2]|0;s=pa+(o*40|0)|0;q=pa+(o*40|0)+8|0;l=b[q>>1]|0;do if(l&16384){r=pa+(o*40|0)+12|0;i=(c[s>>2]|0)+(c[r>>2]|0)|0;if((i|0)<1)if(!(l&16)){i=0;break}else i=1;if(!(Cg(s,i,1)|0)){ew((c[pa+(o*40|0)+16>>2]|0)+(c[r>>2]|0)|0,0,c[s>>2]|0)|0;c[r>>2]=(c[r>>2]|0)+(c[s>>2]|0);b[q>>1]=b[q>>1]&-16897;i=0}else i=7}else i=0;while(0);Qg(s,c[p+8>>2]&255,sd);if(!i){l=m;q=pa;o=qa;i=0}else{oa=3855;break c}break}case 57:case 54:case 55:case 56:case 52:case 53:{s=c[p+4>>2]|0;y=pa+(s*40|0)|0;w=c[p+12>>2]|0;x=pa+(w*40|0)|0;A=pa+(s*40|0)+8|0;i=b[A>>1]|0;B=pa+(w*40|0)+8|0;l=b[B>>1]|0;q=i&65535;t=l&65535;r=(l|i)&65535;C=p+2|0;o=e[C>>1]|0;do if(r&1){if(o&128|0){if(!((i&1&l)<<16>>16!=0&(t&256|0)==0)){r=(t<<1&2^2)+-1|0;oa=389;break}q=z;o=(z&255)+-52|0;oa=392;break}if(!(o&32))if(!(o&16)){l=m;q=pa;o=qa;i=K;break d}else{i=K;oa=28;break d}else{l=pa+((c[p+8>>2]|0)*40|0)+8|0;b[l>>1]=b[l>>1]&15904|1;l=m;q=pa;o=1;i=K;break d}}else{o=o&71;if(o>>>0>66){if(r&2){if((q&14|0)==2){o=a[pa+(s*40|0)+10>>0]|0;q=pa+(s*40|0)+16|0;l=pa+(s*40|0)+12|0;if(Jg(c[q>>2]|0,rf,c[l>>2]|0,o)|0){if(!(Mg(c[q>>2]|0,Hd,c[l>>2]|0,o)|0)){na=Hd;oa=c[na+4>>2]|0;l=y;c[l>>2]=c[na>>2];c[l+4>>2]=oa;l=4}else{g[y>>3]=+g[rf>>3];l=8}b[A>>1]=b[A>>1]&-3|l}r=b[B>>1]|0}else r=l;if((r&14)==2){o=a[pa+(w*40|0)+10>>0]|0;q=pa+(w*40|0)+16|0;l=pa+(w*40|0)+12|0;if(!(Jg(c[q>>2]|0,rf,c[l>>2]|0,o)|0))l=b[B>>1]|0;else{if(!(Mg(c[q>>2]|0,Hd,c[l>>2]|0,o)|0)){na=Hd;oa=c[na+4>>2]|0;l=x;c[l>>2]=c[na>>2];c[l+4>>2]=oa;l=4}else{g[x>>3]=+g[rf>>3];l=8}l=b[B>>1]&-3|l;b[B>>1]=l}s=r}else{s=r;l=r}}else s=l;if(!((l&4&b[A>>1])<<16>>16))l=s;else{r=x;q=c[r>>2]|0;r=c[r+4>>2]|0;o=y;l=c[o>>2]|0;o=c[o+4>>2]|0;if(!((r|0)>(o|0)|(r|0)==(o|0)&q>>>0>l>>>0)){r=((r|0)<(o|0)|(r|0)==(o|0)&q>>>0<l>>>0)<<31>>31;l=s;oa=389;break}o=a[p>>0]|0;r=1;l=s;q=o;o=(o&255)+-52|0;oa=393;break}}else if((o|0)==66){if(!((q&2|0)!=0|(q&12|0)==0)){Fg(y,sd,1)|0;i=(q&49631|b[A>>1]&15904)&65535}if(!((t&2|0)!=0|(t&12|0)==0)){Fg(x,sd,1)|0;l=(t&49631|b[B>>1]&15904)&65535}}r=Rg(x,y,c[p+16>>2]|0)|0;oa=389}while(0);do if((oa|0)==389){oa=0;if((r|0)>=0){q=a[p>>0]|0;o=(q&255)+-52|0;if(!r){oa=392;break}else{oa=393;break}}else{na=a[p>>0]|0;s=r;o=34207+((na&255)+-52)|0;r=na;break}}while(0);if((oa|0)==392){oa=0;s=0;o=34213+o|0;r=q}else if((oa|0)==393){oa=0;s=r;o=34219+o|0;r=q}o=a[o>>0]|0;q=o&255;b[A>>1]=i;b[B>>1]=l;l=e[C>>1]|0;if(!(l&32))if(!(o<<24>>24)){l=m;q=pa;o=qa;i=K;break d}else{i=K;oa=28;break d}i=c[p+8>>2]|0;if(l&8|0?(q|0)==(r<<24>>24==53|0):0){l=m;q=pa;o=s;i=K;break d}l=pa+(i*40|0)+8|0;b[l>>1]=b[l>>1]&15904|4;l=pa+(i*40|0)|0;c[l>>2]=o&255;c[l+4>>2]=0;l=m;q=pa;o=s;i=K;break}case 58:{if(!qa){l=m;q=pa;o=0;i=K}else{i=K;oa=28}break}case -88:case 61:{l=a[qf>>0]|0;do if(l&65?((d[wf>>0]|d[wf+1>>0]<<8)&16)==0:0){i=c[p+16>>2]|0;if(!i){i=c[hd>>2]|0;if(!i)break}if(l&64){na=c[of>>2]|0;i=Yc(f,i)|0;$a[na&127](c[pf>>2]|0,i);if(!i)break;if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{na=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}if((c[Lb>>2]|0)<=1){Xa[c[of>>2]&127](1,c[pf>>2]|0,f,i)|0;break}c[ze>>2]=i;i=bd(Df,34793,ze)|0;Xa[c[of>>2]&127](1,c[pf>>2]|0,f,i)|0;if(i|0){if(c[Ze>>2]|0){Vd(Df,i);break}na=i;if((c[_e>>2]|0)>>>0<=na>>>0?(c[$e>>2]|0)>>>0>na>>>0:0){c[i>>2]=c[af>>2];c[af>>2]=i;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{na=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}}while(0);q=p+4|0;i=c[q>>2]|0;if((i|0)>=(c[7392]|0)){if((a[p>>0]|0)==-88){l=m;q=pa;o=qa;i=K;break d}l=c[wb>>2]|0;if((l|0)>1){o=c[le>>2]|0;i=1;do{if((a[o+(i*20|0)>>0]|0)==17)c[o+(i*20|0)+4>>2]=0;i=i+1|0}while((i|0)!=(l|0))}c[q>>2]=0;i=0}c[q>>2]=i+1;c[ib>>2]=(c[ib>>2]|0)+1;i=K;oa=28;break}case 87:{if(!(b[p+2>>1]&1))q=0;else q=(c[p+-4>>2]|0)+4|0;s=c[p+12>>2]|0;t=c[p+16>>2]|0;w=c[p+4>>2]|0;x=c[p+8>>2]|0;if((s|0)>0){r=t+16|0;j:do if(!q){l=0;while(1){i=a[(c[r>>2]|0)+l>>0]|0;o=Rg(pa+((l+w|0)*40|0)|0,pa+((l+x|0)*40|0)|0,c[t+20+(l<<2)>>2]|0)|0;l=l+1|0;if(o|0)break j;if((l|0)>=(s|0)){l=m;q=pa;o=0;i=K;break d}}}else{l=0;while(1){o=c[q+(l<<2)>>2]|0;i=a[(c[r>>2]|0)+l>>0]|0;o=Rg(pa+((o+w|0)*40|0)|0,pa+((o+x|0)*40|0)|0,c[t+20+(l<<2)>>2]|0)|0;l=l+1|0;if(o|0)break j;if((l|0)>=(s|0)){l=m;q=pa;o=0;i=K;break d}}}while(0);l=m;q=pa;o=i<<24>>24==0?o:0-o|0;i=K}else{l=m;q=pa;o=qa;i=K}break}case 16:{if((qa|0)<0){l=m;q=pa;o=qa;p=m+(((c[p+4>>2]|0)+-1|0)*20|0)|0;i=K;break d}if(!qa){l=m;q=pa;o=0;p=m+(((c[p+8>>2]|0)+-1|0)*20|0)|0;i=K;break d}else{l=m;q=pa;o=qa;p=m+(((c[p+12>>2]|0)+-1|0)*20|0)|0;i=K;break d}}case 43:case 44:{i=c[p+4>>2]|0;l=pa+(i*40|0)|0;o=e[pa+(i*40|0)+8>>1]|0;if(!(o&4))if(!(o&1)){if(!(o&8))if(!(o&18))u=0.0;else u=+Ig(a[pa+(i*40|0)+10>>0]|0,c[pa+(i*40|0)+12>>2]|0,c[pa+(i*40|0)+16>>2]|0);else u=+g[l>>3];q=u!=0.0&1}else q=2;else{q=l;q=((c[q>>2]|0)!=0|(c[q+4>>2]|0)!=0)&1}i=c[p+8>>2]|0;l=pa+(i*40|0)|0;o=e[pa+(i*40|0)+8>>1]|0;if(!(o&4))if(!(o&1)){if(!(o&8))if(!(o&18))u=0.0;else u=+Ig(a[pa+(i*40|0)+10>>0]|0,c[pa+(i*40|0)+12>>2]|0,c[pa+(i*40|0)+16>>2]|0);else u=+g[l>>3];i=u!=0.0&1}else i=2;else{i=l;i=((c[i>>2]|0)!=0|(c[i+4>>2]|0)!=0)&1}i=a[((a[p>>0]|0)==44?34225:34234)+(i+(q*3|0))>>0]|0;l=c[p+12>>2]|0;if(i<<24>>24==2){l=pa+(l*40|0)+8|0;b[l>>1]=b[l>>1]&15904|1;l=m;q=pa;o=qa;i=K;break d}else{q=pa+(l*40|0)|0;c[q>>2]=i&255;c[q+4>>2]=0;l=pa+(l*40|0)+8|0;b[l>>1]=b[l>>1]&15904|4;l=m;q=pa;o=qa;i=K;break d}}case 88:{r=c[p+8>>2]|0;s=pa+(r*40|0)|0;l=c[p+4>>2]|0;o=pa+(l*40|0)|0;q=e[pa+(l*40|0)+8>>1]|0;if(!(q&4)){i=c[p+12>>2]|0;if(!(q&1)){if(!(q&8))if(!(q&18))u=0.0;else u=+Ig(a[pa+(l*40|0)+10>>0]|0,c[pa+(l*40|0)+12>>2]|0,c[pa+(l*40|0)+16>>2]|0);else u=+g[o>>3];i=u!=0.0&1}}else{i=o;i=((c[i>>2]|0)!=0|(c[i+4>>2]|0)!=0)&1}l=c[p+16>>2]^i;o=((l|0)<0)<<31>>31;i=pa+(r*40|0)+8|0;if(!(b[i>>1]&9216)){q=s;c[q>>2]=l;c[q+4>>2]=o;b[i>>1]=4;l=m;q=pa;o=qa;i=K;break d}else{Ng(s,l,o);l=m;q=pa;o=qa;i=K;break d}}case 19:{l=c[p+4>>2]|0;q=c[p+8>>2]|0;r=pa+(q*40|0)|0;i=b[pa+(l*40|0)+8>>1]|0;if(i&1){i=pa+(q*40|0)+8|0;if(!(b[i>>1]&9216)){b[i>>1]=1;l=m;q=pa;o=qa;i=K;break d}else{Bg(r);l=m;q=pa;o=qa;i=K;break d}}o=pa+(l*40|0)|0;i=i&65535;if(!(i&4))if(!(i&1)){if(!(i&8))if(!(i&18))u=0.0;else u=+Ig(a[pa+(l*40|0)+10>>0]|0,c[pa+(l*40|0)+12>>2]|0,c[pa+(l*40|0)+16>>2]|0);else u=+g[o>>3];i=u!=0.0}else i=0;else{i=o;i=(c[i>>2]|0)!=0|(c[i+4>>2]|0)!=0}l=(i^1)&1;i=pa+(q*40|0)+8|0;if(!(b[i>>1]&9216)){q=r;c[q>>2]=l;c[q+4>>2]=0;b[i>>1]=4;l=m;q=pa;o=qa;i=K;break d}else{Ng(r,l,0);l=m;q=pa;o=qa;i=K;break d}}case 107:{o=c[p+4>>2]|0;i=c[p+8>>2]|0;r=pa+(i*40|0)|0;i=pa+(i*40|0)+8|0;if(!(b[i>>1]&9216))b[i>>1]=1;else Bg(r);l=pa+(o*40|0)+8|0;if(!(b[l>>1]&1)){q=pa+(o*40|0)|0;b[i>>1]=4;i=e[l>>1]|0;do if(!(i&4)){if(i&8|0){i=Kg(+g[q>>3])|0;l=L()|0;break}if(!(i&18)){i=0;l=0}else{i=Lg(a[pa+(o*40|0)+10>>0]|0,c[pa+(o*40|0)+12>>2]|0,c[pa+(o*40|0)+16>>2]|0)|0;l=L()|0}}else{l=q;i=c[l>>2]|0;l=c[l+4>>2]|0}while(0);q=r;c[q>>2]=~i;c[q+4>>2]=~l;l=m;q=pa;o=qa;i=K}else{l=m;q=pa;o=qa;i=K}break}case 17:{i=c[nc>>2]|0;if(!i){l=c[(c[le>>2]|0)+4>>2]|0;i=p+4|0;if((l|0)==(c[i>>2]|0)){i=K;oa=28;break d}}else{o=(p-(c[le>>2]|0)|0)/20|0;i=(c[i+24>>2]|0)+(o>>>3)|0;l=d[i>>0]|0;o=1<<(o&7);if(o&l|0){i=K;oa=28;break d}a[i>>0]=o|l;i=p+4|0;l=c[(c[le>>2]|0)+4>>2]|0}c[i>>2]=l;l=m;q=pa;o=qa;i=K;break}case 18:{l=c[p+4>>2]|0;o=pa+(l*40|0)|0;q=e[pa+(l*40|0)+8>>1]|0;if(!(q&4)){i=c[p+12>>2]|0;if(!(q&1)){if(!(q&8))if(!(q&18))u=0.0;else u=+Ig(a[pa+(l*40|0)+10>>0]|0,c[pa+(l*40|0)+12>>2]|0,c[pa+(l*40|0)+16>>2]|0);else u=+g[o>>3];i=u!=0.0&1}}else{i=o;i=((c[i>>2]|0)!=0|(c[i+4>>2]|0)!=0)&1}if(!i){l=m;q=pa;o=qa;i=K}else{i=K;oa=28}break}case 20:{i=c[p+4>>2]|0;l=pa+(i*40|0)|0;o=e[pa+(i*40|0)+8>>1]|0;if(o&4|0){na=l;if((c[na>>2]|0)==0&(c[na+4>>2]|0)==0){i=K;oa=28;break d}else{l=m;q=pa;o=qa;i=K;break d}}if(o&1|0)if(!(c[p+12>>2]|0)){l=m;q=pa;o=qa;i=K;break d}else{i=K;oa=28;break d}if(!(o&8)){if(!(o&18)){i=K;oa=28;break d}u=+Ig(a[pa+(i*40|0)+10>>0]|0,c[pa+(i*40|0)+12>>2]|0,c[pa+(i*40|0)+16>>2]|0)}else u=+g[l>>3];if(u!=0.0){l=m;q=pa;o=qa;i=K}else{i=K;oa=28}break}case 50:{if(!(b[pa+((c[p+4>>2]|0)*40|0)+8>>1]&1)){l=m;q=pa;o=qa;i=K}else{i=K;oa=28}break}case 51:{if(!(b[pa+((c[p+4>>2]|0)*40|0)+8>>1]&1)){i=K;oa=28}else{l=m;q=pa;o=qa;i=K}break}case 21:{if(a[(c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0)+2>>0]|0){i=c[p+12>>2]|0;l=pa+(i*40|0)+8|0;if(!(b[l>>1]&9216)){b[l>>1]=1;i=K;oa=28;break d}else{Bg(pa+(i*40|0)|0);i=K;oa=28;break d}}else{l=m;q=pa;o=qa;i=K}break}case 90:{o=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;l=c[p+8>>2]|0;do if(!(a[o+3>>0]|0)){if(a[c[o+40>>2]>>0]|0){i=qh(o)|0;oa=508}}else{i=c[o+24>>2]|0;if(i|0?(Kd=c[i+(l+1<<2)>>2]|0,(Kd|0)>0):0){l=Kd+-1|0;o=c[o+36>>2]|0;break}i=ph(o)|0;oa=508}while(0);if((oa|0)==508){oa=0;if(i){oa=601;break c}}F=c[p+12>>2]|0;H=pa+(F*40|0)|0;E=c[o+72>>2]|0;r=o+28|0;i=c[ua>>2]|0;k:do if((c[r>>2]|0)!=(i|0)){do if(a[o+2>>0]|0){if((a[o>>0]|0)==3){q=c[o+32>>2]|0;x=c[pa+(q*40|0)+12>>2]|0;c[o+84>>2]=x;c[o+80>>2]=x;q=c[pa+(q*40|0)+16>>2]|0;x=o+76|0;c[x>>2]=q;break}i=pa+(F*40|0)+8|0;if(!(b[i>>1]&9216)){b[i>>1]=1;break k}else{Bg(H);break k}}else{na=c[o+40>>2]|0;$f(na);oa=c[na+44>>2]|0;c[o+80>>2]=oa;i=e[na+48>>1]|0;q=c[na+40>>2]|0;na=(c[(c[na+116>>2]|0)+60>>2]|0)-q|0;c[o+84>>2]=(na|0)<(i|0)?((na|0)>0?na:0):i;i=o+76|0;c[i>>2]=q;if(oa>>>0>(c[Da>>2]|0)>>>0){oa=518;break c}x=i;i=c[ua>>2]|0}while(0);c[r>>2]=i;oa=a[q>>0]|0;i=oa&255;if(oa<<24>>24>-1){c[E>>2]=i;w=1}else{r=d[q+1>>0]|0;do if(r&128){s=d[q+2>>0]|0;if(!(s&128)){c[E>>2]=(i<<14|s)&2080895|r<<7&16256;i=3;break}else{i=Mf(q,rf)|0;na=rf;oa=c[na>>2]|0;c[E>>2]=((oa|0)==(oa|0)?0==(c[na+4>>2]|0):0)?oa:-1;break}}else{c[E>>2]=i<<7&16256|r;i=2}while(0);w=i&255}t=o+48|0;c[t>>2]=w;r=o+58|0;b[r>>1]=0;i=o+84|0;s=c[E>>2]|0;if((c[i>>2]|0)>>>0>=s>>>0){q=c[x>>2]|0;i=0;oa=540;break}c[x>>2]=0;c[i>>2]=0;oa=c[E>>2]|0;if(oa>>>0<=98307?oa>>>0<=(c[o+80>>2]|0)>>>0:0){i=0;oa=532}else oa=597}else{i=o+58|0;r=i;i=b[i>>1]|0;oa=532}while(0);do if((oa|0)==532){if((l|0)<(i&65535|0)){r=c[o+88+(l<<2)>>2]|0;oa=576;break}x=o+48|0;w=c[x>>2]|0;s=c[E>>2]|0;if(w>>>0<s>>>0){q=c[o+76>>2]|0;if(!q){ea=Hd;fa=ea+40|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));s=c[o+40>>2]|0;t=c[E>>2]|0;oa=e[s+48>>1]|0;q=c[s+40>>2]|0;na=(c[(c[s+116>>2]|0)+60>>2]|0)-q|0;if(t>>>0>((na|0)<(oa|0)?((na|0)>0?na:0):oa)>>>0){i=sh(s,0,t,Hd)|0;if(i|0){oa=601;break c}i=b[r>>1]|0;s=c[x>>2]|0;q=c[_b>>2]|0}else{c[_b>>2]=q;b[$b>>1]=4112;c[ac>>2]=t;s=w}t=x;w=s;s=c[E>>2]|0;oa=540}else{t=x;oa=540}}else{q=0;oa=566}}while(0);do if((oa|0)==540){B=i&65535;D=q+s|0;i=B;s=q+w|0;B=c[E+(B<<2)>>2]|0;C=0;do{oa=a[s>>0]|0;w=oa&255;A=o+88+(i<<2)|0;c[A>>2]=w;if(oa<<24>>24>-1){s=s+1|0;y=w;w=d[3520+w>>0]|0;x=0}else{x=d[s>>0]|0;y=d[s+1>>0]|0;do if(y&128){z=d[s+2>>0]|0;if(!(z&128)){w=3;x=(x<<14|z)&2080895|y<<7&16256;oa=549;break}w=Mf(s,rf)|0;oa=rf;x=c[oa>>2]|0;if((x|0)==(x|0)?0==(c[oa+4>>2]|0):0)oa=549;else{c[A>>2]=-1;x=-1;s=s+(w&255)|0;oa=550}}else{w=2;x=x<<7&16256|y;oa=549}while(0);if((oa|0)==549){oa=0;s=s+(w&255)|0;c[A>>2]=x;if(x>>>0>127)oa=550;else w=d[3520+x>>0]|0}if((oa|0)==550)w=(x+-12|0)>>>1;y=x;x=0}B=Qv(w|0,x|0,B|0,C|0)|0;C=L()|0;oa=i;i=i+1|0;c[E+(i<<2)>>2]=B;w=s>>>0<D>>>0}while((oa|0)<(l|0)&w);if(!w)if(s>>>0<=D>>>0?((C|0)==0?(B|0)==(c[o+80>>2]|0):0):0){w=C;x=B;oa=558}else oa=559;else{w=0;x=c[o+80>>2]|0;oa=558}if((oa|0)==558){oa=0;if(C>>>0>w>>>0|(C|0)==(w|0)&B>>>0>x>>>0)oa=559}if((oa|0)==559)if(!(c[E>>2]|0)){i=0;s=D}else{if(c[o+76>>2]|0){oa=597;break}if((b[$b>>1]&9216)==0&(c[fc>>2]|0)==0){oa=597;break}Ag(Hd);oa=597;break}i=i&65535;b[r>>1]=i;c[t>>2]=s-q;if((c[o+76>>2]|0)==0?!((b[$b>>1]&9216)==0&(c[fc>>2]|0)==0):0){Ag(Hd);q=y;i=b[r>>1]|0;oa=566}else{q=y;oa=566}}while(0);do if((oa|0)==566){oa=0;if((l|0)>=(i&65535|0)){if((a[p+1>>0]|0)!=-11){i=pa+(F*40|0)+8|0;if(!(b[i>>1]&9216)){b[i>>1]=1;break}else{Bg(H);break}}l=c[p+16>>2]|0;i=pa+(F*40|0)+8|0;if(b[i>>1]&9216){kh(H,l,2048);break};c[H>>2]=c[l>>2];c[H+4>>2]=c[l+4>>2];c[H+8>>2]=c[l+8>>2];c[H+12>>2]=c[l+12>>2];c[H+16>>2]=c[l+16>>2];if(!(b[l+8>>1]&2048))b[i>>1]=b[i>>1]&-7169|2048}else{r=q;oa=576}}else if((oa|0)==597){oa=0;i=c[m+12>>2]|0;if((i|0)<=0){oa=599;break c}p=m+((i+-1|0)*20|0)|0}while(0);l:do if((oa|0)==576){oa=0;s=pa+(F*40|0)+8|0;if(b[s>>1]&9216)Bg(H);if((c[o+84>>2]|0)>>>0>=(c[E+(l+1<<2)>>2]|0)>>>0){o=(c[o+76>>2]|0)+(c[E+(l<<2)>>2]|0)|0;if(r>>>0<12){Sg(o,r,H)|0;break}q=(r+-12|0)>>>1;c[pa+(F*40|0)+12>>2]=q;a[pa+(F*40|0)+10>>0]=sd;i=q+2|0;if((c[pa+(F*40|0)+24>>2]|0)<(i|0)){b[s>>1]=1;if(Cg(H,i,0)|0){oa=602;break c}l=pa+(F*40|0)+16|0;i=l;l=c[l>>2]|0}else{l=c[pa+(F*40|0)+20>>2]|0;i=pa+(F*40|0)+16|0;c[i>>2]=l}cw(l|0,o|0,q|0)|0;a[(c[i>>2]|0)+q>>0]=0;a[(c[i>>2]|0)+(q+1)>>0]=0;b[s>>1]=b[31112+((r&1)<<1)>>1]|0;break}a[pa+(F*40|0)+10>>0]=sd;na=b[p+2>>1]|0;if(!((na&192)!=0?!((r>>>0<12|(r&1|0)!=0)&(na&128)==0):0))oa=588;do if((oa|0)==588){oa=0;if(r>>>0<=127){i=a[3520+r>>0]|0;if(!(i<<24>>24))break;else q=i&255}else q=(r+-12|0)>>>1;o=c[o+40>>2]|0;i=c[E+(l<<2)>>2]|0;na=e[o+48>>1]|0;l=c[o+40>>2]|0;ma=(c[(c[o+116>>2]|0)+60>>2]|0)-l|0;if((i+q|0)>>>0>((ma|0)<(na|0)?((ma|0)>0?ma:0):na)>>>0){i=sh(o,i,q,H)|0;if(i|0){oa=601;break c}i=c[pa+(F*40|0)+16>>2]|0}else{i=l+i|0;c[pa+(F*40|0)+16>>2]=i;b[s>>1]=4112;c[pa+(F*40|0)+12>>2]=q}Sg(i,r,H)|0;b[s>>1]=b[s>>1]&-4097;break l}while(0);Sg(59040,r,H)|0}while(0);l=m;q=pa;o=qa;i=0;break}case 91:{i=c[p+16>>2]|0;s=i;t=pa+((c[p+4>>2]|0)*40|0)|0;i=a[i>>0]|0;while(1){s=s+1|0;do if(i<<24>>24>66){r=t+8|0;o=b[r>>1]|0;i=o&65535;if(!(i&4)){if(i&8|0){v=+g[t>>3];i=Kg(v)|0;l=L()|0;na=Qv(i|0,l|0,1,-2147483648)|0;ma=L()|0;if(!((ma>>>0>0|(ma|0)==0&na>>>0>1)&v==+(i>>>0)+4294967296.0*+(l|0)))break;na=t;c[na>>2]=i;c[na+4>>2]=l;b[r>>1]=o&15904|4;break}if(i&2|0?(Md=a[t+10>>0]|0,Nd=t+16|0,Od=t+12|0,Jg(c[Nd>>2]|0,rf,c[Od>>2]|0,Md)|0):0){if(Mg(c[Nd>>2]|0,Hd,c[Od>>2]|0,Md)|0){v=+g[rf>>3];g[t>>3]=v;l=b[r>>1]|0;i=l|8;b[r>>1]=i;o=Kg(v)|0;q=L()|0;na=Qv(o|0,q|0,1,-2147483648)|0;ma=L()|0;if((ma>>>0>0|(ma|0)==0&na>>>0>1)&v==+(o>>>0)+4294967296.0*+(q|0)){i=t;c[i>>2]=o;c[i+4>>2]=q;i=l&15904;oa=613}}else{na=Hd;oa=c[na+4>>2]|0;i=t;c[i>>2]=c[na>>2];c[i+4>>2]=oa;i=b[r>>1]|0;oa=613}if((oa|0)==613){oa=0;i=i|4;b[r>>1]=i}b[r>>1]=i&-3}}}else if(i<<24>>24==66){l=t+8|0;i=b[l>>1]|0;na=i&65535;if(!((na&2|0)!=0|(na&12|0)==0)){Fg(t,sd,1)|0;i=b[l>>1]|0}b[l>>1]=i&-13}while(0);i=a[s>>0]|0;if(!(i<<24>>24)){l=m;q=pa;o=qa;i=K;break}else t=t+40|0}break}case 92:{i=c[p+16>>2]|0;E=pa+((c[p+4>>2]|0)*40|0)|0;F=E+(((c[p+8>>2]|0)+-1|0)*40|0)|0;x=a[pc>>0]|0;H=c[p+12>>2]|0;I=pa+(H*40|0)|0;if(i|0){t=E;w=i;i=a[i>>0]|0;do{s=t;t=t+40|0;w=w+1|0;do if(i<<24>>24>66){r=s+8|0;o=b[r>>1]|0;i=o&65535;if(!(i&4)){if(i&8|0){v=+g[s>>3];i=Kg(v)|0;l=L()|0;na=Qv(i|0,l|0,1,-2147483648)|0;ma=L()|0;if(!((ma>>>0>0|(ma|0)==0&na>>>0>1)&v==+(i>>>0)+4294967296.0*+(l|0)))break;na=s;c[na>>2]=i;c[na+4>>2]=l;b[r>>1]=o&15904|4;break}if(i&2|0?(Pd=a[s+10>>0]|0,Rd=s+16|0,Sd=s+12|0,Jg(c[Rd>>2]|0,rf,c[Sd>>2]|0,Pd)|0):0){do if(!(Mg(c[Rd>>2]|0,Hd,c[Sd>>2]|0,Pd)|0)){na=Hd;oa=c[na+4>>2]|0;i=s;c[i>>2]=c[na>>2];c[i+4>>2]=oa;i=b[r>>1]|0;oa=634}else{v=+g[rf>>3];g[s>>3]=v;l=b[r>>1]|0;i=l|8;b[r>>1]=i;o=Kg(v)|0;q=L()|0;na=Qv(o|0,q|0,1,-2147483648)|0;ma=L()|0;if(!((ma>>>0>0|(ma|0)==0&na>>>0>1)&v==+(o>>>0)+4294967296.0*+(q|0)))break;i=s;c[i>>2]=o;c[i+4>>2]=q;i=l&15904;oa=634}while(0);if((oa|0)==634){oa=0;i=i|4;b[r>>1]=i}b[r>>1]=i&-3}}}else if(i<<24>>24==66){l=s+8|0;i=b[l>>1]|0;na=i&65535;if(!((na&2|0)!=0|(na&12|0)==0)){Fg(s,sd,1)|0;i=b[l>>1]|0}b[l>>1]=i&-13}while(0);i=a[w>>0]|0}while(i<<24>>24!=0)}B=(x&255)>3;C=0;A=F;z=0;y=0;s=0;t=0;while(1){w=A+8|0;r=b[w>>1]|0;l=r&65535;do if(!(l&1)){if(!(l&4)){if(l&8|0){o=8;x=7;break}i=c[A+12>>2]|0;if(l&16384)i=(c[A>>2]|0)+i|0;o=i;x=(i<<1)+12|l>>>1&1;break}l=A;i=c[l>>2]|0;l=c[l+4>>2]|0;q=_v(i|0,l|0,63)|0;q=q^i;o=(L()|0)^l;if(o>>>0<0|(o|0)==0&q>>>0<128){if(!(B&((i&1|0)==(i|0)&0==(l|0)))){o=1;x=1;break}o=0;x=q+8|0;break}if(!(o>>>0<0|(o|0)==0&q>>>0<32768))if(o>>>0<0|(o|0)==0&q>>>0<8388608){o=3;x=3}else{na=o>>>0<0|(o|0)==0&q>>>0<2147483648;x=o>>>0<32768|(o|0)==32768&q>>>0<0;o=na?4:x?6:8;x=na?4:x?5:6}else{o=2;x=2}}else{o=0;x=0}while(0);do if(!(r&16384)){i=o;oa=666}else{if(!x){w=Qv(z|0,y|0,o|0,0)|0;i=10;o=1;x=L()|0;D=s;break}if((z|0)==0&(y|0)==0){i=c[A>>2]|0;s=Qv(s|0,t|0,i|0,((i|0)<0)<<31>>31|0)|0;i=o-i|0;t=L()|0;oa=666;break}l=A+12|0;i=(c[A>>2]|0)+(c[l>>2]|0)|0;if((i|0)<1)if(!(r&16)){i=o;oa=666;break}else i=1;if(Cg(A,i,1)|0){l=p;j=h;i=zf;oa=3892;break a}ew((c[A+16>>2]|0)+(c[l>>2]|0)|0,0,c[A>>2]|0)|0;c[l>>2]=(c[l>>2]|0)+(c[A>>2]|0);b[w>>1]=b[w>>1]&-16897;i=o;oa=666}while(0);if((oa|0)==666){oa=0;q=Qv(z|0,y|0,i|0,0)|0;r=L()|0;if(x>>>0<128){i=x;o=1;w=q;x=r;D=s}else{o=1;i=x;l=0;while(1){i=$v(i|0,l|0,7)|0;l=L()|0;if((i|0)==0&(l|0)==0){i=x;w=q;x=r;D=s;break}else o=o+1|0}}}C=o+C|0;c[A+28>>2]=i;if((A|0)==(E|0))break;else{A=A+-40|0;z=w;y=x;s=D}}if(C>>>0<127)r=C+1|0;else{r=1;i=C;l=0;while(1){i=$v(i|0,l|0,7)|0;l=L()|0;if((i|0)==0&(l|0)==0)break;else r=r+1|0}l=r+C|0;i=1;o=l;q=0;while(1){o=$v(o|0,q|0,7)|0;q=L()|0;if((o|0)==0&(q|0)==0)break;else i=i+1|0}r=l+(r>>>0<i>>>0&1)|0}q=((r|0)<0)<<31>>31;z=Qv(w|0,x|0,r|0,q|0)|0;i=Qv(z|0,L()|0,D|0,t|0)|0;l=L()|0;o=c[pa+(H*40|0)+24>>2]|0;na=((o|0)<0)<<31>>31;do if((l|0)>(na|0)|(l|0)==(na|0)&i>>>0>o>>>0){na=c[Da>>2]|0;ma=((na|0)<0)<<31>>31;if((l|0)>(ma|0)|(l|0)==(ma|0)&i>>>0>na>>>0){oa=3891;break c}if((o|0)>=(z|0)){y=c[pa+(H*40|0)+20>>2]|0;c[pa+(H*40|0)+16>>2]=y;na=pa+(H*40|0)+8|0;b[na>>1]=b[na>>1]&13;break}if(Cg(I,z,0)|0){l=p;j=h;i=zf;oa=3892;break a}y=c[pa+(H*40|0)+16>>2]|0}else{y=c[pa+(H*40|0)+20>>2]|0;c[pa+(H*40|0)+16>>2]=y}while(0);do if(r>>>0>=128)if(r>>>0<16384){i=$v(r|0,q|0,7)|0;L()|0;a[y>>0]=i&255|-128;a[y+1>>0]=r&127;i=2;break}else{i=uh(y,r,q)|0;break}else{a[y>>0]=r;i=1}while(0);o=i&255;x=r;w=E;while(1){l=c[w+28>>2]|0;do if(l>>>0<128){a[y+o>>0]=l;i=o+1|0;o=y+x|0;if((l+-1|0)>>>0>=7)if(l>>>0>11){oa=699;break}else{l=0;break}s=w;l=d[3520+l>>0]|0;q=l;r=c[s>>2]|0;s=c[s+4>>2]|0;do{q=q+-1|0;a[o+q>>0]=r;r=$v(r|0,s|0,8)|0;s=L()|0}while((q|0)!=0)}else{i=y+o|0;if(l>>>0<16384){a[i>>0]=l>>>7&255|-128;a[i+1>>0]=l&127;i=2}else i=uh(i,l,0)|0;i=(i&255)+o|0;o=y+x|0;oa=699}while(0);if((oa|0)==699){oa=0;l=c[w+12>>2]|0;if(!l)l=0;else cw(o|0,c[w+16>>2]|0,l|0)|0}w=w+40|0;if(w>>>0>F>>>0)break;else{o=i;x=l+x|0}}c[pa+(H*40|0)+12>>2]=z;i=pa+(H*40|0)+8|0;b[i>>1]=16;if((D|0)==0&(t|0)==0){l=m;q=pa;o=qa;i=K}else{c[I>>2]=D;b[i>>1]=16400;l=m;q=pa;o=qa;i=K}break}case 93:{F=c[(c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0)+40>>2]|0;i=vh(F)|0;switch(i|0){case 16:{q=0;o=0;break}case 0:{y=F+116|0;z=F+70|0;A=F+68|0;B=F+50|0;C=F+1|0;D=F+20|0;E=F+2|0;q=0;o=0;m:while(1){l=c[y>>2]|0;if(!(a[l+8>>0]|0)){t=(a[l+2>>0]|0)==0;r=b[l+24>>1]|0;q=Qv((t?r&65535:0)|0,(t?0:0)|0,q|0,o|0)|0;o=L()|0;t=l;x=b[z>>1]|0;s=l}else{q=Qv(q|0,o|0,e[l+24>>1]|0,0)|0;o=L()|0;do{i=a[A>>0]|0;if(!(i<<24>>24))break m;b[B>>1]=0;a[C>>0]=a[C>>0]&-7;s=b[F+72+((i<<24>>24)+-1<<1)>>1]|0;b[z>>1]=s;r=i+-1<<24>>24;a[A>>0]=r;r=c[F+120+(r<<24>>24<<2)>>2]|0;c[y>>2]=r;i=c[l+72>>2]|0;if(!(b[i+28>>1]&32)){Bf(i);l=c[y>>2]|0;w=l;i=b[z>>1]|0}else{w=c[i+20>>2]|0;l=w+120|0;c[l>>2]=(c[l>>2]|0)+-1;w=w+136|0;c[i+16>>2]=c[w>>2];c[w>>2]=i;w=r;l=r;i=s}r=b[l+24>>1]|0}while((i&65535)>=(r&65535));x=i+1<<16>>16;b[z>>1]=x;t=l;s=w}i=c[t+56>>2]|0;if(x<<16>>16==r<<16>>16){i=i+((d[t+9>>0]|0)+8)|0;l=a[A>>0]|0;if(l<<24>>24>18){oa=717;break c}i=d[i>>0]<<24|d[i+1>>0]<<16|d[i+2>>0]<<8|d[i+3>>0];na=c[D>>2]|0;b[B>>1]=0;a[C>>0]=a[C>>0]&-7;ma=l<<24>>24;b[F+72+(ma<<1)>>1]=x;c[F+120+(ma<<2)>>2]=s;b[z>>1]=0;a[A>>0]=l+1<<24>>24;i=wh(na,i,y,F,d[E>>0]|0)|0}else{l=(c[t+64>>2]|0)+((x&65535)<<1)|0;i=i+((d[l>>0]<<8|d[l+1>>0])&e[t+26>>1])|0;l=a[A>>0]|0;if(l<<24>>24>18){oa=720;break c}i=d[i>>0]<<24|d[i+1>>0]<<16|d[i+2>>0]<<8|d[i+3>>0];na=c[D>>2]|0;b[B>>1]=0;a[C>>0]=a[C>>0]&-7;ma=l<<24>>24;b[F+72+(ma<<1)>>1]=x;c[F+120+(ma<<2)>>2]=s;b[z>>1]=0;a[A>>0]=l+1<<24>>24;i=wh(na,i,y,F,d[E>>0]|0)|0}if(i){oa=3845;break c}}i=vh(F)|0;if(i){oa=3855;break c}break}default:{oa=3855;break c}}na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216))b[l>>1]=4;else jh(i)|0;l=i;c[l>>2]=q;c[l+4>>2]=o;l=m;q=pa;o=qa;i=0;break}case 0:{w=c[p+4>>2]|0;A=c[p+16>>2]|0;if(!w){if((c[cd>>2]|0)>0){oa=730;break c}if(!A)z=0;else z=(Cu(A)|0)&1073741823;x=(c[Gd>>2]|0)+(c[Fd>>2]|0)|0;n:do if(c[eb>>2]|0){y=x+1|0;w=0;while(1){if((w|0)>=(c[Vc>>2]|0))break n;t=c[(c[eb>>2]|0)+(w<<2)>>2]|0;i=c[c[t+4>>2]>>2]|0;r=t+8|0;l=c[r>>2]|0;o:do if((l|0)!=0?(c[i>>2]|0)>1:0){s=t+12|0;o=(c[s>>2]|0)+1|0;c[s>>2]=o;i=c[i+80>>2]|0;c[t+20>>2]=y;if(!i){q=0;i=o}else{q=Va[i&255](l,x)|0;i=c[s>>2]|0}l=c[t>>2]|0;na=i+-1|0;c[s>>2]=na;if(na|0){i=q;break}i=c[r>>2]|0;if(i|0)Ua[c[(c[i>>2]|0)+16>>2]&127](i)|0;do if(l|0){if(c[l+480>>2]|0){Vd(l,t);i=q;break o}i=t;if((c[l+304>>2]|0)>>>0>i>>>0)break;if((c[l+308>>2]|0)>>>0<=i>>>0)break;i=l+300|0;c[t>>2]=c[i>>2];c[i>>2]=t;i=q;break o}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](t);i=q;break}else{i=Ua[c[29352>>2]&127](t)|0;c[14978]=(c[14978]|0)-i;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](t);i=q;break}}else i=0;while(0);if(!i)w=w+1|0;else{oa=3846;break c}}}while(0);l=z+33|0;do if(c[$c>>2]|0)if(!(a[zf>>0]|0))oa=761;else{l=m;q=pa;o=qa;i=0;break d}else{if(!(0<0|(0==0?(e[Xc>>1]|0)>>>0<l>>>0:0))){i=c[af>>2]|0;if(i|0){c[af>>2]=c[i>>2];c[ed>>2]=(c[ed>>2]|0)+1;break}i=c[dd>>2]|0;if(!i)i=fd;else{c[dd>>2]=c[i>>2];c[ed>>2]=(c[ed>>2]|0)+1;break}}else i=Zc;c[i>>2]=(c[i>>2]|0)+1;oa=761}while(0);if((oa|0)==761){oa=0;i=Yd(Df,l,0)|0}if(!i){l=m;q=pa;o=qa;i=0;break d}na=i+32|0;c[i>>2]=na;cw(na|0,A|0,z+1|0)|0;if(!(a[gd>>0]|0))c[Gd>>2]=(c[Gd>>2]|0)+1;else{a[gd>>0]=0;a[Id>>0]=1}c[i+24>>2]=c[qd>>2];c[qd>>2]=i;l=Pa;q=c[l+4>>2]|0;o=i+8|0;c[o>>2]=c[l>>2];c[o+4>>2]=q;o=Na;q=c[o+4>>2]|0;l=i+16|0;c[l>>2]=c[o>>2];c[l+4>>2]=q;l=m;q=pa;o=qa;i=0;break d}i=c[qd>>2]|0;if(!i){oa=774;break c}q=d[208+(d[A>>0]|0)>>0]|0;B=i;r=0;while(1){l=c[B>>2]|0;na=a[l>>0]|0;i=(d[208+(na&255)>>0]|0)-q|0;if(!(na<<24>>24==0|(i|0)!=0)){o=A;do{l=l+1|0;o=o+1|0;na=a[l>>0]|0;i=(d[208+(na&255)>>0]|0)-(d[208+(d[o>>0]|0)>>0]|0)|0}while(!(na<<24>>24==0|(i|0)!=0))}if(!i)break;i=c[B+24>>2]|0;if(!i){oa=774;break c}else{B=i;r=r+1|0}}z=(w|0)==1;if(z&(c[cd>>2]|0)>0){oa=776;break c}A=B+24|0;if(!(c[A>>2]|0)){i=(a[Id>>0]|0)!=0;if(z&i){ma=c[f>>2]|0;na=ma+464|0;ma=ma+472|0;na=Qv(c[ma>>2]|0,c[ma+4>>2]|0,c[na>>2]|0,c[na+4>>2]|0)|0;ma=L()|0;if((ma|0)>0|(ma|0)==0&na>>>0>0){oa=780;break c}a[gd>>0]=1;if((ng(f)|0)==5){oa=782;break c}a[Id>>0]=0;y=r;i=c[Cf>>2]|0;q=1}else{q=i;oa=784}}else{q=0;oa=784}if((oa|0)==784){oa=0;s=(c[Gd>>2]|0)-r|0;x=s+-1|0;t=(w|0)==2;if(t){l=c[hf>>2]&1;if((c[sf>>2]|0)>0){o=l^1;i=0;while(1){r=hg(c[(c[vf>>2]|0)+(i<<4)+4>>2]|0,516,o)|0;i=i+1|0;if(r|0){oa=3854;break c}r=c[sf>>2]|0;if((i|0)>=(r|0)){i=0;oa=790;break}}}else i=K}else{l=0;i=K;r=c[sf>>2]|0;oa=790}p:do if((oa|0)==790){oa=0;if((r|0)>0){i=(s|0)<1;if(!t){if(!i){s=0;i=r;while(1){o=c[(c[vf>>2]|0)+(s<<4)+4>>2]|0;do if(o){if((a[o+8>>0]|0)!=2)break;r=c[o+4>>2]|0;c[r+4>>2]=c[o>>2];i=uf(c[r>>2]|0,w,x)|0;if(i|0){oa=3853;break c}i=Pf(r)|0;na=c[(c[r+12>>2]|0)+56>>2]|0;c[r+44>>2]=d[na+29>>0]<<16|d[na+28>>0]<<24|d[na+30>>0]<<8|d[na+31>>0];if(i|0){oa=3853;break c}i=c[sf>>2]|0}while(0);s=s+1|0;if((s|0)>=(i|0)){i=0;break p}}}s=0;i=r;while(1){o=c[(c[vf>>2]|0)+(s<<4)+4>>2]|0;do if(o){if((a[o+8>>0]|0)!=2)break;r=c[o+4>>2]|0;c[r+4>>2]=c[o>>2];i=uf(c[r>>2]|0,w,x)|0;if(i|0){oa=3852;break c}o=r+44|0;if(b[r+22>>1]&16)c[o>>2]=0;i=Pf(r)|0;na=c[(c[r+12>>2]|0)+56>>2]|0;c[o>>2]=d[na+29>>0]<<16|d[na+28>>0]<<24|d[na+30>>0]<<8|d[na+31>>0];if(i|0){oa=3852;break c}i=c[sf>>2]|0}while(0);s=s+1|0;if((s|0)>=(i|0)){i=0;break p}}}if(!i){s=0;i=r;while(1){o=c[(c[vf>>2]|0)+(s<<4)+4>>2]|0;do if(o){if((a[o+8>>0]|0)!=2)break;r=c[o+4>>2]|0;c[r+4>>2]=c[o>>2];i=c[r+8>>2]|0;if(i|0?(Wd=Zf(i,0,0)|0,Wd|0):0){i=Wd;oa=3851;break c}i=uf(c[r>>2]|0,2,x)|0;if(i|0){oa=3851;break c}i=Pf(r)|0;na=c[(c[r+12>>2]|0)+56>>2]|0;c[r+44>>2]=d[na+29>>0]<<16|d[na+28>>0]<<24|d[na+30>>0]<<8|d[na+31>>0];if(i|0){oa=3851;break c}i=c[sf>>2]|0}while(0);s=s+1|0;if((s|0)>=(i|0)){i=0;break p}}}s=0;i=r;while(1){o=c[(c[vf>>2]|0)+(s<<4)+4>>2]|0;do if(o){if((a[o+8>>0]|0)!=2)break;r=c[o+4>>2]|0;c[r+4>>2]=c[o>>2];i=c[r+8>>2]|0;if(i|0?(Ud=Zf(i,0,0)|0,Ud|0):0){i=Ud;oa=3850;break c}i=uf(c[r>>2]|0,2,x)|0;if(i|0){oa=3850;break c}o=r+44|0;if(b[r+22>>1]&16)c[o>>2]=0;i=Pf(r)|0;na=c[(c[r+12>>2]|0)+56>>2]|0;c[o>>2]=d[na+29>>0]<<16|d[na+28>>0]<<24|d[na+30>>0]<<8|d[na+31>>0];if(i|0){oa=3850;break c}i=c[sf>>2]|0}while(0);s=s+1|0;if((s|0)>=(i|0)){i=0;break}}}}while(0);if(!l)y=x;else{l=c[db>>2]|0;if(l|0)do{na=l+149|0;ma=(d[na>>0]|d[na+1>>0]<<8)&-4|1;a[na>>0]=ma;a[na+1>>0]=ma>>8;l=c[l+8>>2]|0}while((l|0)!=0);Zb(Df);c[hf>>2]=c[hf>>2]|1;y=x}}l=c[qd>>2]|0;if((l|0)!=(B|0))do{c[qd>>2]=c[l+24>>2];q:do if(l|0){if(c[Ze>>2]|0){Vd(Df,l);break}o=l;do if((c[_e>>2]|0)>>>0<=o>>>0){if((c[$e>>2]|0)>>>0<=o>>>0)break;c[l>>2]=c[af>>2];c[af>>2]=l;break q}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);c[Gd>>2]=(c[Gd>>2]|0)+-1;l=c[qd>>2]|0}while((l|0)!=(B|0));if(z){c[qd>>2]=c[A>>2];do if(!(c[Ze>>2]|0)){na=B;if((c[_e>>2]|0)>>>0<=na>>>0?(c[$e>>2]|0)>>>0>na>>>0:0){c[B>>2]=c[af>>2];c[af>>2]=B;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](B);break}else{na=Ua[c[29352>>2]&127](B)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](B);break}}else Vd(Df,B);while(0);if(q){_d=1;oa=859}else c[Gd>>2]=(c[Gd>>2]|0)+-1}else{_d=B+8|0;oa=c[_d+4>>2]|0;na=Pa;c[na>>2]=c[_d>>2];c[na+4>>2]=oa;na=B+16|0;oa=c[na+4>>2]|0;_d=Na;c[_d>>2]=c[na>>2];c[_d+4>>2]=oa;_d=q;oa=859}if((oa|0)==859?(oa=0,!((w|0)==2|_d^1)):0)if(!i){l=m;q=pa;o=qa;i=0;break d}else{oa=3855;break c}if(!(c[eb>>2]|0)){l=m;q=pa;o=qa;i=0}else{x=y+1|0;switch(w|0){case 0:while(1){if((w|0)>=(c[Vc>>2]|0)){l=m;q=pa;o=qa;i=0;break d}t=c[(c[eb>>2]|0)+(w<<2)>>2]|0;i=c[c[t+4>>2]>>2]|0;r=t+8|0;l=c[r>>2]|0;r:do if(l){if((c[i>>2]|0)<=1){i=0;break}s=t+12|0;o=(c[s>>2]|0)+1|0;c[s>>2]=o;i=c[i+80>>2]|0;c[t+20>>2]=x;if(!i){q=0;i=o}else{q=Va[i&255](l,y)|0;i=c[s>>2]|0}l=c[t>>2]|0;na=i+-1|0;c[s>>2]=na;if(na|0){i=q;break}i=c[r>>2]|0;if(i|0)Ua[c[(c[i>>2]|0)+16>>2]&127](i)|0;do if(l|0){if(c[l+480>>2]|0){Vd(l,t);i=q;break r}i=t;if((c[l+304>>2]|0)>>>0>i>>>0)break;if((c[l+308>>2]|0)>>>0<=i>>>0)break;i=l+300|0;c[t>>2]=c[i>>2];c[i>>2]=t;i=q;break r}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](t);i=q;break}else{i=Ua[c[29352>>2]&127](t)|0;c[14978]=(c[14978]|0)-i;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](t);i=q;break}}else i=0;while(0);if(!i)w=w+1|0;else{oa=3848;break c}}case 2:{w=0;while(1){if((w|0)>=(c[Vc>>2]|0)){l=m;q=pa;o=qa;i=0;break d}t=c[(c[eb>>2]|0)+(w<<2)>>2]|0;i=c[c[t+4>>2]>>2]|0;r=t+8|0;l=c[r>>2]|0;s:do if(l){if((c[i>>2]|0)<=1){i=0;break}s=t+12|0;o=(c[s>>2]|0)+1|0;c[s>>2]=o;i=c[i+88>>2]|0;do if(!i){q=0;i=o}else{if((c[t+20>>2]|0)<=(y|0)){q=0;i=o;break}q=Va[i&255](l,y)|0;i=c[s>>2]|0}while(0);l=c[t>>2]|0;na=i+-1|0;c[s>>2]=na;if(na|0){i=q;break}i=c[r>>2]|0;if(i|0)Ua[c[(c[i>>2]|0)+16>>2]&127](i)|0;do if(l|0){if(c[l+480>>2]|0){Vd(l,t);i=q;break s}i=t;if((c[l+304>>2]|0)>>>0>i>>>0)break;if((c[l+308>>2]|0)>>>0<=i>>>0)break;i=l+300|0;c[t>>2]=c[i>>2];c[i>>2]=t;i=q;break s}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](t);i=q;break}else{i=Ua[c[29352>>2]&127](t)|0;c[14978]=(c[14978]|0)-i;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](t);i=q;break}}else i=0;while(0);if(!i)w=w+1|0;else{oa=3849;break c}}}default:{w=0;while(1){if((w|0)>=(c[Vc>>2]|0)){l=m;q=pa;o=qa;i=0;break d}t=c[(c[eb>>2]|0)+(w<<2)>>2]|0;i=c[c[t+4>>2]>>2]|0;r=t+8|0;l=c[r>>2]|0;t:do if(l){if((c[i>>2]|0)<=1){i=0;break}s=t+12|0;o=(c[s>>2]|0)+1|0;c[s>>2]=o;i=c[i+84>>2]|0;do if(!i){q=0;i=o}else{if((c[t+20>>2]|0)<=(y|0)){q=0;i=o;break}q=Va[i&255](l,y)|0;i=c[s>>2]|0}while(0);l=c[t>>2]|0;na=i+-1|0;c[s>>2]=na;if(na|0){i=q;break}i=c[r>>2]|0;if(i|0)Ua[c[(c[i>>2]|0)+16>>2]&127](i)|0;do if(l|0){if(c[l+480>>2]|0){Vd(l,t);i=q;break t}i=t;if((c[l+304>>2]|0)>>>0>i>>>0)break;if((c[l+308>>2]|0)>>>0<=i>>>0)break;i=l+300|0;c[t>>2]=c[i>>2];c[i>>2]=t;i=q;break t}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](t);i=q;break}else{i=Ua[c[29352>>2]&127](t)|0;c[14978]=(c[14978]|0)-i;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](t);i=q;break}}else i=0;while(0);if(!i)w=w+1|0;else{oa=3847;break c}}}}}break}case 2:{c[rf>>2]=0;o=p+8|0;i=c[o>>2]|0;if(i|0?!((c[Sc>>2]&1048576|0)==0&0==0):0){l=8;oa=1017;break c}z=p+4|0;y=c[(c[vf>>2]|0)+(c[z>>2]<<4)+4>>2]|0;do if(y){l=Xb(y,i,rf)|0;if(l|0){oa=950;break c}if((c[o>>2]|0)!=0?((d[wf>>0]|d[wf+1>>0]<<8)&128)!=0:0){if(a[gd>>0]|0?(c[Ha>>2]|0)<=1:0){i=0;break}i=c[bc>>2]|0;if(!i){l=(c[Fd>>2]|0)+1|0;c[Fd>>2]=l;l=(c[Gd>>2]|0)+l|0;c[bc>>2]=l}else l=i;x=l+-1|0;u:do if(!(c[eb>>2]|0))oa=979;else{w=0;while(1){if((w|0)>=(c[Vc>>2]|0))break;t=c[(c[eb>>2]|0)+(w<<2)>>2]|0;i=c[c[t+4>>2]>>2]|0;r=t+8|0;q=c[r>>2]|0;v:do if(q){if((c[i>>2]|0)<=1){i=0;break}s=t+12|0;o=(c[s>>2]|0)+1|0;c[s>>2]=o;i=c[i+80>>2]|0;c[t+20>>2]=l;if(!i)i=0;else{i=Va[i&255](q,x)|0;o=c[s>>2]|0}q=c[t>>2]|0;na=o+-1|0;c[s>>2]=na;if(na|0)break;o=c[r>>2]|0;if(o|0)Ua[c[(c[o>>2]|0)+16>>2]&127](o)|0;do if(q|0){if(c[q+480>>2]|0){Vd(q,t);break v}o=t;if((c[q+304>>2]|0)>>>0>o>>>0)break;if((c[q+308>>2]|0)>>>0<=o>>>0)break;na=q+300|0;c[t>>2]=c[na>>2];c[na>>2]=t;break v}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](t);break}else{na=Ua[c[29352>>2]&127](t)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](t);break}}else i=0;while(0);if(!i)w=w+1|0;else break u}l=c[bc>>2]|0;oa=979}while(0);if((oa|0)==979){oa=0;i=c[y+4>>2]|0;c[i+4>>2]=c[y>>2];i=c[i>>2]|0;if((c[i+96>>2]|0)<(l|0)?(a[i+6>>0]|0)!=0:0)i=Tf(i,l)|0;else i=0}na=Pa;ma=c[na+4>>2]|0;la=gc;c[la>>2]=c[na>>2];c[la+4>>2]=ma;la=Na;ma=c[la+4>>2]|0;na=hc;c[na>>2]=c[la>>2];c[na+4>>2]=ma}else i=0}else i=K;while(0);if(b[p+2>>1]|0){if((c[rf>>2]|0)!=(c[p+12>>2]|0)){oa=986;break c}if((c[(c[(c[vf>>2]|0)+(c[z>>2]<<4)+12>>2]|0)+4>>2]|0)!=(c[p+16>>2]|0)){oa=986;break c}}if(!i){l=m;q=pa;o=qa;i=0}else{oa=3855;break c}break}case 94:{i=c[p+12>>2]|0;l=c[(c[vf>>2]|0)+(c[p+4>>2]<<4)+4>>2]|0;o=c[l+4>>2]|0;c[o+4>>2]=c[l>>2];if((i|0)==15)o=(c[l+20>>2]|0)+(c[(c[o>>2]|0)+100>>2]|0)|0;else{o=(c[(c[o+12>>2]|0)+56>>2]|0)+((i<<2)+36)|0;o=d[o+1>>0]<<16|d[o>>0]<<24|d[o+2>>0]<<8|d[o+3>>0]}na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216))b[l>>1]=4;else jh(i)|0;l=i;c[l>>2]=o;c[l+4>>2]=((o|0)<0)<<31>>31;l=m;q=pa;o=qa;i=K;break}case 95:{w=c[vf>>2]|0;x=p+4|0;y=c[x>>2]|0;l=c[w+(y<<4)+4>>2]|0;z=p+8|0;s=c[z>>2]|0;A=p+12|0;q=c[A>>2]|0;t=c[l+4>>2]|0;c[t+4>>2]=c[l>>2];l=c[t+12>>2]|0;r=c[l+56>>2]|0;l=c[l+72>>2]|0;o=c[l+20>>2]|0;if((b[l+28>>1]&4)!=0?(c[o+24>>2]|0)>>>0>=(c[l+24>>2]|0)>>>0:0)if(!(c[o+96>>2]|0))oa=1035;else{i=Te(l)|0;oa=1034}else oa=1030;do if((oa|0)==1030){oa=0;i=c[o+40>>2]|0;if(!i)if((c[o+148>>2]|0)>>>0>(c[o+152>>2]|0)>>>0){i=Uf(l)|0;oa=1034;break}else{i=Vf(l)|0;oa=1034;break}else o=0}while(0);if((oa|0)==1034){oa=0;if(!i)oa=1035;else o=0}if((oa|0)==1035){oa=0;na=r+((s<<2)+36)|0;a[na>>0]=q>>>24;a[na+1>>0]=q>>>16;a[na+2>>0]=q>>>8;i=q&255;a[na+3>>0]=i;if((s|0)==7){a[t+18>>0]=i;i=0;o=1}else{i=0;o=1}}switch(c[z>>2]|0){case 1:{c[c[w+(y<<4)+12>>2]>>2]=c[A>>2];c[hf>>2]=c[hf>>2]|1;break}case 2:{a[(c[w+(y<<4)+12>>2]|0)+76>>0]=c[A>>2];break}default:{}}if((c[x>>2]|0)==1){l=c[db>>2]|0;if(l|0)do{na=l+149|0;ma=(d[na>>0]|d[na+1>>0]<<8)&-4|1;a[na>>0]=ma;a[na+1>>0]=ma>>8;l=c[l+8>>2]|0}while((l|0)!=0);na=(d[wf>>0]|d[wf+1>>0]<<8)&-4;a[wf>>0]=na;a[wf+1>>0]=na>>8}if(o){l=m;q=pa;o=qa}else{oa=3855;break c}break}case 106:{i=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;if((i|0)!=0?(c[i+52>>2]|0)==(c[p+8>>2]|0):0){o=i;i=K;l=p+2|0;oa=1074}else oa=1049;break}case 109:case 108:{oa=1049;break}case 111:{l=c[oc>>2]|0;w=c[l+(c[p+8>>2]<<2)>>2]|0;q=c[p+4>>2]|0;s=b[w+56>>1]|0;t=s<<16>>16;i=c[xd>>2]|0;if((q|0)>0)i=i+(((c[va>>2]|0)-q|0)*40|0)|0;o=t<<3;r=o+96|0;o=o+296|0;l=c[l+(q<<2)>>2]|0;if(l|0){na=l+5|0;a[na>>0]=a[na>>0]&-2;rg(f,c[(c[oc>>2]|0)+(q<<2)>>2]|0);c[(c[oc>>2]|0)+(q<<2)>>2]=0}if((c[i+24>>2]|0)<(o|0)){if(Cg(i,o,0)|0){l=p;j=h;i=zf;oa=3892;break a}o=i+16|0;l=o;o=c[o>>2]|0}else{o=c[i+20>>2]|0;l=i+16|0;c[l>>2]=o;na=i+8|0;b[na>>1]=b[na>>1]&13}c[(c[oc>>2]|0)+(q<<2)>>2]=o;i=o+1|0;ea=o;fa=ea+36|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));a[i>>0]=-1;b[o+56>>1]=s;c[o+72>>2]=o+88+(t<<2);na=(c[l>>2]|0)+r|0;i=o+40|0;c[i>>2]=na;c[na>>2]=0;c[na+4>>2]=0;c[na+8>>2]=0;c[na+12>>2]=0;c[na+16>>2]=0;if(!o){l=p;j=h;i=zf;oa=3892;break a}a[o+2>>0]=1;l=o+5|0;q=a[l>>0]|1;a[l>>0]=q;na=c[w+44>>2]|0;c[o+44>>2]=na;a[o+4>>0]=a[w+4>>0]|0;ma=c[w+52>>2]|0;c[o+52>>2]=ma;a[l>>0]=a[w+5>>0]&4|q&-5;l=m;q=pa;o=qa;i=Tg(c[w+8>>2]|0,ma,4,na,c[i>>2]|0)|0;break}case 113:case 112:{o=c[p+4>>2]|0;q=(c[oc>>2]|0)+(o<<2)|0;i=c[q>>2]|0;if(!i){s=c[p+8>>2]|0;i=c[xd>>2]|0;if((o|0)>0)i=i+(((c[va>>2]|0)-o|0)*40|0)|0;l=s<<3;r=l+96|0;l=l+296|0;if((c[i+24>>2]|0)<(l|0)){if(Cg(i,l,0)|0){l=p;j=h;i=zf;oa=3892;break a}w=i+16|0;l=w;i=(c[oc>>2]|0)+(o<<2)|0;w=c[w>>2]|0}else{w=c[i+20>>2]|0;l=i+16|0;c[l>>2]=w;i=i+8|0;b[i>>1]=b[i>>1]&13;i=q}c[i>>2]=w;i=w+1|0;ea=w;fa=ea+36|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));a[i>>0]=-1;b[w+56>>1]=s;c[w+72>>2]=w+88+(s<<2);na=(c[l>>2]|0)+r|0;q=w+40|0;c[q>>2]=na;c[na>>2]=0;c[na+4>>2]=0;c[na+8>>2]=0;c[na+12>>2]=0;c[na+16>>2]=0;if(!w){l=p;j=h;i=zf;oa=3892;break a}a[w+2>>0]=1;s=w+5|0;a[s>>0]=a[s>>0]|1;r=w+8|0;t=p+2|0;i=Ne(c[Df>>2]|0,0,Df,r,(b[t>>1]|5)&65535,1054)|0;do if(!i){i=Xb(c[r>>2]|0,1,0)|0;if(!i){l=c[p+16>>2]|0;c[w+44>>2]=l;if(!l){c[w+52>>2]=1;i=Tg(c[r>>2]|0,1,4,0,c[q>>2]|0)|0;a[w+4>>0]=1;break}o=w+52|0;i=Ug(c[r>>2]|0,o,(b[t>>1]|2)&65535)|0;if(!i)i=Tg(c[r>>2]|0,c[o>>2]|0,4,l,c[q>>2]|0)|0;a[w+4>>0]=0}}while(0);a[s>>0]=((b[t>>1]|0)!=8&1)<<2&255|a[s>>0]&-5}else{l=c[i+8>>2]|0;q=c[i+52>>2]|0;o=l+4|0;r=c[o>>2]|0;c[r+4>>2]=c[l>>2];i=c[r+8>>2]|0;w:do if(i|0){x:do if(q)while(1){if((c[i+64>>2]|0)==(q|0))break x;i=c[i+24>>2]|0;if(!i)break w}while(0);i=Zf(i,q,0)|0;if(i|0){oa=3855;break c}}while(0);l=l+11|0;if(a[l>>0]|0?(a[l>>0]=0,nd=c[(c[o>>2]|0)+8>>2]|0,nd|0):0){i=nd;do{if(a[i+1>>0]&16?(a[l>>0]=1,(c[i+64>>2]|0)==(q|0)):0)a[i>>0]=1;i=c[i+24>>2]|0}while((i|0)!=0)}i=xh(r,q,0,0)|0}if(!i){l=m;q=pa;o=qa;i=0}else{oa=3855;break c}break}case 114:{q=c[p+4>>2]|0;r=c[p+8>>2]|0;i=c[xd>>2]|0;if((q|0)>0)i=i+(((c[va>>2]|0)-q|0)*40|0)|0;l=(r<<3)+96|0;o=c[(c[oc>>2]|0)+(q<<2)>>2]|0;if(o|0){na=o+5|0;a[na>>0]=a[na>>0]&-2;rg(f,c[(c[oc>>2]|0)+(q<<2)>>2]|0);c[(c[oc>>2]|0)+(q<<2)>>2]=0}if((c[i+24>>2]|0)<(l|0)){if(Cg(i,l,0)|0){l=p;j=h;i=zf;oa=3892;break a}s=c[i+16>>2]|0}else{s=c[i+20>>2]|0;c[i+16>>2]=s;na=i+8|0;b[na>>1]=b[na>>1]&13}c[(c[oc>>2]|0)+(q<<2)>>2]=s;ea=s;fa=ea+36|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));a[s>>0]=1;a[s+1>>0]=-1;b[s+56>>1]=r;c[s+72>>2]=s+88+(r<<2);if(!s){l=p;j=h;i=zf;oa=3892;break a}q=c[p+16>>2]|0;l=s+44|0;c[l>>2]=q;o=c[p+12>>2]|0;q=e[q+6>>1]<<2;r=q+156|0;do if(c[$c>>2]|0)if(!(a[zf>>0]|0))oa=1133;else{oa=1135;break c}else{if(!(0<0|(0==0?(e[Xc>>1]|0)>>>0<r>>>0:0))){i=c[af>>2]|0;if(i|0){c[af>>2]=c[i>>2];c[ed>>2]=(c[ed>>2]|0)+1;t=i;break}i=c[dd>>2]|0;if(!i)i=fd;else{c[dd>>2]=c[i>>2];c[ed>>2]=(c[ed>>2]|0)+1;t=i;break}}else i=Zc;c[i>>2]=(c[i>>2]|0)+1;oa=1133}while(0);if((oa|0)==1133){oa=0;t=Yd(Df,r,0)|0}if(!t){oa=1135;break c}ew(t|0,0,r|0)|0;c[s+40>>2]=t;na=t+136|0;c[t+28>>2]=na;cw(na|0,c[l>>2]|0,q+20|0)|0;c[t+148>>2]=0;if(o|0)b[t+142>>1]=o;i=c[vf>>2]|0;l=c[(c[(c[i+4>>2]|0)+4>>2]|0)+32>>2]|0;c[t+12>>2]=l;a[t+59>>0]=1;a[t+58>>0]=-1;a[t+57>>0]=0;c[t+24>>2]=Df;c[t+72>>2]=t;if((a[ra>>0]|0)!=2?(ma=G(c[7379]|0,l)|0,c[t>>2]=ma,na=c[(c[i+12>>2]|0)+80>>2]|0,la=(na|0)<0,be=((l|0)<0)<<31>>31,na=Wv((la?-1024:l)|0,(la?-1:be)|0,na|0,((na|0)<0)<<31>>31|0)|0,la=L()|0,ka=(la|0)<0|(la|0)==0&na>>>0<536870912,na=ka?na:536870912,ka?la:0,c[t+4>>2]=(ma|0)>(na|0)?ma:na,(c[7329]|0)==0):0){c[t+52>>2]=l;na=Qv(l|0,be|0,-1,-1)|0;ma=L()|0;do if(ma>>>0>0|(ma|0)==0&na>>>0>2147483390)i=0;else{if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](l)|0;break}o=Ua[c[29356>>2]&127](l)|0;if((c[14985]|0)>>>0<l>>>0)c[14985]=l;l=59064;i=c[l>>2]|0;l=c[l+4>>2]|0;if((l|0)>0|(l|0)==0&i>>>0>0){na=c[14978]|0;ma=Rv(i|0,l|0,o|0,((o|0)<0)<<31>>31|0)|0;la=L()|0;c[14768]=((la|0)<0|(la|0)==0&ma>>>0<=na>>>0)&1}i=Ua[c[29340>>2]&127](o)|0;if(!i){i=0;break}l=Ua[c[29352>>2]&127](i)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0<=(c[14987]|0)>>>0)break;c[14987]=l}while(0);c[t+40>>2]=i;i=(i|0)==0?7:0}else i=0;do if((e[t+144>>1]|0)<13){na=c[t+156>>2]|0;if(na|0?(na|0)!=(c[jc>>2]|0):0)break;a[t+60>>0]=3}while(0);if(!i){l=m;q=pa;o=qa;i=0}else{oa=3855;break c}break}case 115:{la=(c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0)+16|0;na=la;ma=c[na>>2]|0;na=c[na+4>>2]|0;ja=Qv(ma|0,na|0,1,0)|0;ka=L()|0;c[la>>2]=ja;c[la+4>>2]=ka;if((ma|0)==0&(na|0)==0){i=K;oa=28}else{l=m;q=pa;o=qa;i=K}break}case 116:{q=c[p+4>>2]|0;r=c[p+12>>2]|0;i=c[xd>>2]|0;if((q|0)>0)i=i+(((c[va>>2]|0)-q|0)*40|0)|0;l=(r<<3)+96|0;o=c[(c[oc>>2]|0)+(q<<2)>>2]|0;if(o|0){na=o+5|0;a[na>>0]=a[na>>0]&-2;rg(f,c[(c[oc>>2]|0)+(q<<2)>>2]|0);c[(c[oc>>2]|0)+(q<<2)>>2]=0}if((c[i+24>>2]|0)<(l|0)){if(Cg(i,l,0)|0){l=p;j=h;i=zf;oa=3892;break a}i=c[i+16>>2]|0}else{na=c[i+20>>2]|0;c[i+16>>2]=na;i=i+8|0;b[i>>1]=b[i>>1]&13;i=na}c[(c[oc>>2]|0)+(q<<2)>>2]=i;ea=i;fa=ea+36|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));a[i>>0]=3;a[i+1>>0]=-1;b[i+56>>1]=r;c[i+72>>2]=i+88+(r<<2);if(!i){l=p;j=h;i=zf;oa=3892;break a}a[i+2>>0]=1;c[i+32>>2]=c[p+8>>2];a[i+4>>0]=1;c[i+40>>2]=59954;l=m;q=pa;o=qa;i=K;break}case 117:{l=p+4|0;rg(f,c[(c[oc>>2]|0)+(c[l>>2]<<2)>>2]|0);c[(c[oc>>2]|0)+(c[l>>2]<<2)>>2]=0;l=m;q=pa;o=qa;i=K;break}case 25:case 24:case 23:case 22:{w=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;l=z&255;a[w+2>>0]=0;y:do if(!(a[w+4>>0]|0)){i=c[w+40>>2]|0;o=(d[i+3>>0]|0)>>>1&1;oa=c[p+16>>2]|0;c[$d>>2]=c[w+44>>2];b[wa>>1]=oa;a[xa>>0]=(l<<1&2^2)+255;c[ya>>2]=pa+((c[p+12>>2]|0)*40|0);a[za>>0]=0;i=Vg(i,$d,0,0,0,Td)|0;if(i|0){oa=1213;break c}i=o&255;if(o<<24>>24!=0&(a[za>>0]|0)==0)if(!(c[Td>>2]|0)){p=p+20|0;oa=1212}else{i=0;oa=1211}else{o=i;oa=1194}}else{r=c[p+12>>2]|0;t=pa+(r*40|0)|0;s=pa+(r*40|0)+8|0;i=b[s>>1]|0;if((i&14)==2){i=a[pa+(r*40|0)+10>>0]|0;o=pa+(r*40|0)+16|0;q=pa+(r*40|0)+12|0;if(!(Jg(c[o>>2]|0,rf,c[q>>2]|0,i)|0))i=b[s>>1]|0;else{if(!(Mg(c[o>>2]|0,Hd,c[q>>2]|0,i)|0)){na=Hd;oa=c[na+4>>2]|0;i=t;c[i>>2]=c[na>>2];c[i+4>>2]=oa;i=4}else{g[t>>3]=+g[rf>>3];i=8}i=b[s>>1]&-3|i;b[s>>1]=i}}i=i&65535;do if(!(i&4)){if(i&8|0){o=Kg(+g[t>>3])|0;q=L()|0;break}if(!(i&18)){o=0;q=0}else{o=Lg(a[pa+(r*40|0)+10>>0]|0,c[pa+(r*40|0)+12>>2]|0,c[pa+(r*40|0)+16>>2]|0)|0;q=L()|0;i=e[s>>1]|0}}else{q=t;o=c[q>>2]|0;q=c[q+4>>2]|0}while(0);do if(!(i&4)){if(!(i&8)){i=K;oa=1211;break y}u=+g[t>>3];v=+(o>>>0)+4294967296.0*+(q|0);if(u<v){l=(l<<31>>31)+l|0;break}else{l=((l&1|0)==0&u>v&1)+l|0;break}}while(0);i=Vg(c[w+40>>2]|0,0,o,q,0,Td)|0;oa=w+64|0;c[oa>>2]=o;c[oa+4>>2]=q;if(!i){o=0;oa=1194}else{oa=1213;break c}}while(0);z:do if((oa|0)==1194){oa=0;a[w+3>>0]=0;c[w+28>>2]=0;i=c[Td>>2]|0;if((l|0)>23){if((i|0)>=0?!((l|0)==25&(i|0)==0):0)c[Td>>2]=0;else oa=1197;A:do if((oa|0)==1197){c[Td>>2]=0;i=Wg(c[w+40>>2]|0,0)|0;switch(i|0){case 0:break A;case 101:break;default:{oa=1213;break c}}c[Td>>2]=1;i=0;oa=1211;break z}while(0);p=(o|0)==0?p:p+20|0;oa=1212;break}if((i|0)<=0?!((l|0)==22&(i|0)==0):0){oa=(a[c[w+40>>2]>>0]|0)!=0;c[Td>>2]=oa&1;if(oa){i=0;oa=1211;break}else{p=(o|0)==0?p:p+20|0;oa=1212;break}}c[Td>>2]=0;i=c[w+40>>2]|0;na=i+1|0;a[na>>0]=a[na>>0]&-15;b[i+50>>1]=0;if(((a[i>>0]|0)==0?(ce=i+70|0,de=b[ce>>1]|0,de<<16>>16!=0):0)?(a[(c[i+116>>2]|0)+8>>0]|0)!=0:0)b[ce>>1]=de+-1<<16>>16;else oa=1206;B:do if((oa|0)==1206){i=Fh(i)|0;switch(i|0){case 0:break B;case 101:break;default:{oa=1213;break c}}c[Td>>2]=1;i=0;oa=1211;break z}while(0);p=(o|0)==0?p:p+20|0;oa=1212}while(0);if((oa|0)==1211){oa=28;break d}else if((oa|0)==1212){oa=0;l=m;q=pa;o=qa;i=0;break d}break}case 119:{l=(c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0)+5|0;a[l>>0]=(c[p+8>>2]&255)<<3&8|a[l>>0]&-9;l=m;q=pa;o=qa;i=K;break}case 26:{if(!(a[(c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0)+5>>0]&8))oa=1216;else{l=m;q=pa;o=qa;i=K}break}case 29:case 28:case 27:{oa=1216;break}case 30:{i=p+12|0;o=c[i>>2]|0;t=pa+(o*40|0)+8|0;w=b[t>>1]|0;if(!(w&4)){s=pa+(o*40|0)|0;l=w&65535;do if(!(l&4)){if(l&8|0){v=+g[s>>3];o=Kg(v)|0;q=L()|0;oa=Qv(o|0,q|0,1,-2147483648)|0;na=L()|0;l=w&15904|4;if(!((na>>>0>0|(na|0)==0&oa>>>0>1)&v==+(o>>>0)+4294967296.0*+(q|0))){l=w;break}oa=s;c[oa>>2]=o;c[oa+4>>2]=q;b[t>>1]=l;break}if(l&2){q=a[pa+(o*40|0)+10>>0]|0;r=pa+(o*40|0)+16|0;l=pa+(o*40|0)+12|0;if(!(Jg(c[r>>2]|0,rf,c[l>>2]|0,q)|0))l=b[t>>1]|0;else{if(Mg(c[r>>2]|0,Hd,c[l>>2]|0,q)|0){v=+g[rf>>3];g[s>>3]=v;o=b[t>>1]|0;l=o|8;b[t>>1]=l;q=Kg(v)|0;r=L()|0;na=Qv(q|0,r|0,1,-2147483648)|0;ma=L()|0;if((ma>>>0>0|(ma|0)==0&na>>>0>1)&v==+(q>>>0)+4294967296.0*+(r|0)){l=s;c[l>>2]=q;c[l+4>>2]=r;l=o&15904;oa=1281}}else{na=Hd;oa=c[na+4>>2]|0;l=s;c[l>>2]=c[na>>2];c[l+4>>2]=oa;l=b[t>>1]|0;oa=1281}if((oa|0)==1281){l=l|4;b[t>>1]=l}l=l&-3;b[t>>1]=l}}else l=w}else l=w;while(0);b[t>>1]=w;if(!(l&4)){i=K;oa=28}else oa=1287}else oa=1287;break}case 31:{i=p+12|0;oa=1287;break}case 120:{na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216))b[l>>1]=4;else jh(i)|0;l=(c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0)+16|0;q=l;o=c[q>>2]|0;q=c[q+4>>2]|0;ma=Qv(o|0,q|0,1,0)|0;na=L()|0;c[l>>2]=ma;c[l+4>>2]=na;l=i;c[l>>2]=o;c[l+4>>2]=q;l=m;q=pa;o=qa;i=K;break}case 121:{na=rf;c[na>>2]=0;c[na+4>>2]=0;c[Hd>>2]=0;na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216)){b[l>>1]=4;y=i}else{jh(i)|0;y=i}z=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;x=z+5|0;do if(!(a[x>>0]&2)){l=z+40|0;i=Zg(c[l>>2]|0,Hd)|0;if(i|0){oa=1328;break c}if(c[Hd>>2]|0){i=rf;c[i>>2]=1;c[i+4>>2]=0;i=0;break}l=c[l>>2]|0;$f(l);l=l+32|0;i=c[l>>2]|0;l=c[l+4>>2]|0;na=rf;c[na>>2]=i;c[na+4>>2]=l;if((i|0)==-1&(l|0)==2147483647){a[x>>0]=a[x>>0]|2;i=0;break}else{ma=Qv(i|0,l|0,1,0)|0;na=L()|0;i=rf;c[i>>2]=ma;c[i+4>>2]=na;i=0;break}}else i=K;while(0);r=c[p+12>>2]|0;if(r|0){l=c[nc>>2]|0;if(!l)o=pa;else{while(1){o=c[l+4>>2]|0;if(!o)break;else l=o}o=c[l+16>>2]|0}w=o+(r*40|0)|0;s=o+(r*40|0)+8|0;l=b[s>>1]|0;q=l&65535;do if(!(q&4)){if(q&8|0){q=Kg(+g[w>>3])|0;o=L()|0;oa=1317;break}if(!(q&18)){t=w;c[t>>2]=0;c[t+4>>2]=0;b[s>>1]=l&15904|4;t=0;q=0;break}else{q=Lg(a[o+(r*40|0)+10>>0]|0,c[o+(r*40|0)+12>>2]|0,c[o+(r*40|0)+16>>2]|0)|0;o=L()|0;l=b[s>>1]|0;oa=1317;break}}else{o=w;q=c[o>>2]|0;o=c[o+4>>2]|0;oa=1317}while(0);if((oa|0)==1317){oa=0;na=w;c[na>>2]=q;c[na+4>>2]=o;b[s>>1]=l&15904|4;if((q|0)==-1&(o|0)==2147483647){i=13;oa=1328;break c}else t=o}if(a[x>>0]&2){i=13;oa=1328;break c}l=rf;o=c[l>>2]|0;l=c[l+4>>2]|0;r=Qv(q|0,t|0,1,0)|0;s=L()|0;if(!((l|0)>(t|0)|(l|0)==(t|0)&o>>>0>q>>>0)){o=rf;c[o>>2]=r;c[o+4>>2]=s;o=r;l=s}na=w;c[na>>2]=o;c[na+4>>2]=l}if(a[x>>0]&2){o=z+40|0;l=0;do{Db(8,rf);q=rf;q=Qv(c[q>>2]|0,c[q+4>>2]&1073741823|0,1,0)|0;i=L()|0;na=rf;c[na>>2]=q;c[na+4>>2]=i;i=Vg(c[o>>2]|0,0,q,i,0,Hd)|0;q=c[Hd>>2]|0;if(q|i|0)break;l=l+1|0}while(l>>>0<100);if(i|0){oa=1328;break c}if(!q){i=13;oa=1328;break c}else i=0}a[z+3>>0]=0;c[z+28>>2]=0;o=rf;q=c[o+4>>2]|0;l=y;c[l>>2]=c[o>>2];c[l+4>>2]=q;l=m;q=pa;o=qa;break}case 122:{i=c[p+8>>2]|0;s=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;w=pa+((c[p+12>>2]|0)*40|0)|0;t=c[w>>2]|0;w=c[w+4>>2]|0;na=qc;c[na>>2]=t;c[na+4>>2]=w;if((a[p+1>>0]|0)==-6?(c[Ca>>2]|0)!=0:0){q=c[(c[vf>>2]|0)+(a[s+1>>0]<<4)>>2]|0;r=c[p+16>>2]|0}else{q=0;r=0}x=p+2|0;l=b[x>>1]|0;if(l&1)c[rc>>2]=(c[rc>>2]|0)+1;if(l&32){na=zb;c[na>>2]=t;c[na+4>>2]=w}c[xb>>2]=c[pa+(i*40|0)+16>>2];c[yb>>2]=c[pa+(i*40|0)+12>>2];if(!(l&16))o=0;else o=c[s+32>>2]|0;if(!(b[pa+(i*40|0)+8>>1]&16384))i=0;else i=c[pa+(i*40|0)>>2]|0;c[Sb>>2]=i;c[rf>>2]=0;i=_g(c[s+40>>2]|0,rf,l&10,o)|0;a[s+3>>0]=0;c[s+28>>2]=0;if(i|0){oa=1345;break c}if(r|0)cb[c[Ca>>2]&127](c[Tb>>2]|0,(b[x>>1]&4)==0?18:23,q,c[r>>2]|0,t,w);l=m;q=pa;o=qa;i=0;break}case 123:{q=c[p+8>>2]|0;r=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;if((a[p+1>>0]|0)==-6?(c[Ca>>2]|0)!=0:0){i=c[(c[vf>>2]|0)+(a[r+1>>0]<<4)>>2]|0;l=c[p+16>>2]|0;if((b[p+2>>1]&2)!=0?(a[r+4>>0]|0)!=0:0){ma=c[r+40>>2]|0;$f(ma);ma=ma+32|0;na=c[ma+4>>2]|0;o=r+64|0;c[o>>2]=c[ma>>2];c[o+4>>2]=na;o=i}else o=i}else{o=0;l=0}i=$g(c[r+40>>2]|0,b[p+2>>1]&255)|0;c[r+28>>2]=0;c[r+32>>2]=0;if(i|0){oa=3855;break c}if(((q&1|0)!=0?(c[rc>>2]=(c[rc>>2]|0)+1,ge=c[Ca>>2]|0,(ge|0)!=0):0)?(c[l+36>>2]&32|0)==0:0){q=r+64|0;cb[ge&127](c[Tb>>2]|0,9,o,c[l>>2]|0,c[q>>2]|0,c[q+4>>2]|0);l=m;q=pa;o=qa;i=0}else{l=m;q=pa;o=qa;i=0}break}case 124:{l=c[rc>>2]|0;c[sc>>2]=l;c[tc>>2]=(c[tc>>2]|0)+l;c[rc>>2]=0;l=m;q=pa;o=qa;i=K;break}case 125:{t=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;w=c[p+12>>2]|0;x=c[p+16>>2]|0;s=c[t+40>>2]|0;r=s+32|0;i=c[r>>2]|0;t=c[t+44>>2]|0;if(!i){q=((e[t+6>>1]|0)*40|0)+56|0;o=c[t+12>>2]|0;C:do if(!o){if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](q)|0;oa=1381;break}o=Ua[c[29356>>2]&127](q)|0;if((c[14985]|0)>>>0<q>>>0)c[14985]=q;l=59064;i=c[l>>2]|0;l=c[l+4>>2]|0;if((l|0)>0|(l|0)==0&i>>>0>0){na=c[14978]|0;ma=Rv(i|0,l|0,o|0,((o|0)<0)<<31>>31|0)|0;la=L()|0;c[14768]=((la|0)<0|(la|0)==0&ma>>>0<=na>>>0)&1}i=Ua[c[29340>>2]&127](o)|0;if(!i){oa=1382;break c}l=Ua[c[29352>>2]&127](i)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else{if(c[o+272>>2]|0){if(a[o+81>>0]|0){oa=1382;break c}}else{do if(!(0<0|(0==0?(e[o+276>>1]|0)>>>0<q>>>0:0))){l=o+300|0;i=c[l>>2]|0;if(i|0){c[l>>2]=c[i>>2];oa=o+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=1381;break C}l=o+296|0;i=c[l>>2]|0;if(!i){i=o+292|0;break}else{c[l>>2]=c[i>>2];oa=o+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=1381;break C}}else i=o+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1}i=Yd(o,q,0)|0;oa=1381}while(0);if((oa|0)==1381){oa=0;if(!i){oa=1382;break c}}c[i+4>>2]=i+16;c[i>>2]=t;c[r>>2]=i;b[i+8>>1]=x;o=i}else o=i;if(!(a[s+56>>0]|0)){l=c[s+36>>2]|0;i=l+8|0}else{l=c[s+20>>2]|0;na=c[l+12>>2]|0;l=c[(c[l+8>>2]|0)+4>>2]|0;i=c[na+(l*56|0)+32>>2]|0;l=na+(l*56|0)+20|0}Yg(t,c[l>>2]|0,i,o);if((x|0)>0){l=c[o+4>>2]|0;i=0;do{if(b[l+(i*40|0)+8>>1]&1){i=0;oa=28;break d}i=i+1|0}while((i|0)<(x|0))}if(!(Dh(c[pa+(w*40|0)+12>>2]|0,c[pa+(w*40|0)+16>>2]|0,o,0)|0)){l=m;q=pa;o=qa;i=0}else{i=0;oa=28}break}case 126:{s=c[p+8>>2]|0;i=c[(c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0)+40>>2]|0;if(!(a[i+56>>0]|0)){i=c[i+36>>2]|0;r=i+8|0}else{i=c[i+20>>2]|0;na=c[i+12>>2]|0;i=c[(c[i+8>>2]|0)+4>>2]|0;r=c[na+(i*56|0)+32>>2]|0;i=na+(i*56|0)+20|0}i=c[i>>2]|0;if((c[pa+(s*40|0)+24>>2]|0)<(i|0)){if(Cg(pa+(s*40|0)|0,i,0)|0){i=7;oa=3855;break c}o=pa+(s*40|0)+8|0;l=o;o=b[o>>1]|0;q=c[pa+(s*40|0)+16>>2]|0}else{q=c[pa+(s*40|0)+20>>2]|0;c[pa+(s*40|0)+16>>2]=q;l=pa+(s*40|0)+8|0;o=b[l>>1]&13;b[l>>1]=o}c[pa+(s*40|0)+12>>2]=i;b[l>>1]=o&15904|16;cw(q|0,r|0,i|0)|0;c[(c[(c[oc>>2]|0)+(c[p+12>>2]<<2)>>2]|0)+28>>2]=0;l=m;q=pa;o=qa;i=0;break}case 127:{na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216)){b[l>>1]=4;q=i}else{jh(i)|0;q=i}i=c[(c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0)+40>>2]|0;$f(i);l=c[i+44>>2]|0;if(l>>>0>(c[Da>>2]|0)>>>0){oa=3891;break c}na=e[i+48>>1]|0;o=c[i+40>>2]|0;ma=(c[(c[i+116>>2]|0)+60>>2]|0)-o|0;if(l>>>0>((ma|0)<(na|0)?((ma|0)>0?ma:0):na)>>>0){i=sh(i,0,l,q)|0;if(i|0){oa=3855;break c}}else{c[q+16>>2]=o;b[q+8>>1]=4112;c[q+12>>2]=l}if((c[p+12>>2]|0)==0?(he=q+8|0,ie=b[he>>1]|0,(ie&4096)!=0):0){i=ie&65535;do if(!(i&18))i=ie;else{do if(!(i&16384))i=ie;else{l=q+12|0;i=(c[q>>2]|0)+(c[l>>2]|0)|0;if((i|0)<1)if(!(ie&16)){i=ie;break}else i=1;if(Cg(q,i,1)|0){l=p;j=h;i=zf;oa=3892;break a}ew((c[q+16>>2]|0)+(c[l>>2]|0)|0,0,c[q>>2]|0)|0;c[l>>2]=(c[l>>2]|0)+(c[q>>2]|0);i=b[he>>1]&-16897;b[he>>1]=i}while(0);if(c[q+24>>2]|0?(c[q+16>>2]|0)==(c[q+20>>2]|0):0)break;if(Hg(q)|0){l=p;j=h;i=zf;oa=3892;break a}i=b[he>>1]|0}while(0);b[he>>1]=i&-4097;l=m;q=pa;o=qa;i=0}else{l=m;q=pa;o=qa;i=0}break}case -128:{na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216)){b[l>>1]=4;w=i}else{jh(i)|0;w=i}l=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;q=l+2|0;D:do if(!(a[q>>0]|0)){do if(!(a[l+3>>0]|0)){if((a[l>>0]|0)!=2){o=l+40|0;i=c[o>>2]|0;do if(a[i>>0]|0){i=qh(l)|0;if(i|0){oa=1481;break c}if(!(a[q>>0]|0)){i=c[o>>2]|0;break}else{b[w+8>>1]=1;i=0;break D}}while(0);$f(i);o=i+32|0;l=c[o>>2]|0;o=c[o+4>>2]|0;i=rf;c[i>>2]=l;c[i+4>>2]=o;i=0;break}i=c[l+40>>2]|0;t=c[i>>2]|0;i=Va[c[(c[t>>2]|0)+48>>2]&255](i,rf)|0;t=t+8|0;if(c[t>>2]|0){q=c[f>>2]|0;l=c[mf>>2]|0;E:do if(l|0){do if(q|0){if(c[q+480>>2]|0){Vd(q,l);break E}o=l;if((c[q+304>>2]|0)>>>0>o>>>0)break;if((c[q+308>>2]|0)>>>0<=o>>>0)break;na=q+300|0;c[l>>2]=c[na>>2];c[na>>2]=l;break E}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);r=c[t>>2]|0;F:do if(!r)l=0;else{s=(Cu(r)|0)+1|0;G:do if(!q){na=Qv(s|0,0,-1,-1)|0;ma=L()|0;if(ma>>>0>0|(ma|0)==0&na>>>0>2147483390){l=0;break F}if(!(c[7324]|0)){l=Ua[c[29340>>2]&127](s)|0;oa=1464;break}l=Ua[c[29356>>2]&127](s)|0;if((c[14985]|0)>>>0<s>>>0)c[14985]=s;q=59064;o=c[q>>2]|0;q=c[q+4>>2]|0;if((q|0)>0|(q|0)==0&o>>>0>0){na=c[14978]|0;ma=Rv(o|0,q|0,l|0,((l|0)<0)<<31>>31|0)|0;la=L()|0;c[14768]=((la|0)<0|(la|0)==0&ma>>>0<=na>>>0)&1}l=Ua[c[29340>>2]&127](l)|0;if(!l){l=0;break F}o=Ua[c[29352>>2]&127](l)|0;o=(c[14978]|0)+o|0;c[14978]=o;if(o>>>0>(c[14982]|0)>>>0)c[14982]=o;o=(c[14981]|0)+1|0;c[14981]=o;if(o>>>0<=(c[14987]|0)>>>0)break;c[14987]=o}else{if(c[q+272>>2]|0){if(a[q+81>>0]|0){l=0;break F}}else{do if(!(0<0|(0==0?(e[q+276>>1]|0)>>>0<s>>>0:0))){o=q+300|0;l=c[o>>2]|0;if(l|0){c[o>>2]=c[l>>2];oa=q+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=1464;break G}o=q+296|0;l=c[o>>2]|0;if(!l){l=q+292|0;break}else{c[o>>2]=c[l>>2];oa=q+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=1464;break G}}else l=q+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1}l=Yd(q,s,0)|0;oa=1464}while(0);if((oa|0)==1464){oa=0;if(!l){l=0;break}}cw(l|0,r|0,s|0)|0}while(0);c[mf>>2]=l;l=c[t>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);c[t>>2]=0}if(i|0){oa=1481;break c}o=rf;i=0;l=c[o>>2]|0;o=c[o+4>>2]|0}else{o=l+64|0;l=c[o>>2]|0;o=c[o+4>>2]|0;i=rf;c[i>>2]=l;c[i+4>>2]=o;i=K}while(0);na=w;c[na>>2]=l;c[na+4>>2]=o}else{b[w+8>>1]=1;i=K}while(0);l=m;q=pa;o=qa;break}case -127:{i=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;a[i+2>>0]=1;c[i+28>>2]=0;if(!(a[i>>0]|0)){i=c[i+40>>2]|0;l=i+16|0;o=c[l>>2]|0;do if(o|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](o);break}else{na=Ua[c[29352>>2]&127](o)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](o);break}while(0);c[l>>2]=0;a[i>>0]=1;l=m;q=pa;o=qa;i=K}else{l=m;q=pa;o=qa;i=K}break}case 32:case -126:{l=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;i=c[l+40>>2]|0;c[rf>>2]=0;if(z<<24>>24==-126?(c[l+32>>2]=-1,(a[i>>0]|0)==0):0){l=m;q=pa;o=qa;i=K;break d}r=Zg(i,rf)|0;i=c[rf>>2]|0;a[l+2>>0]=i;a[l+3>>0]=0;c[l+28>>2]=0;if(r|0){oa=1492;break c}if((i|0)!=0&(c[p+8>>2]|0)>0){i=0;oa=28}else{l=m;q=pa;o=qa;i=0}break}case 33:{s=c[(c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0)+40>>2]|0;i=ah(s,rf)|0;if(i|0){oa=1519;break c}do if(!(c[rf>>2]|0)){if((a[s>>0]|0)==0?(ke=c[s+116>>2]|0,a[ke+8>>0]|0):0){i=e[ke+24>>1]|0;l=a[s+68>>0]|0;if(l<<24>>24>0){q=l<<24>>24;o=0;r=0;l=0;do{i=Wv(i|0,l|0,e[(c[s+120+(r<<2)>>2]|0)+24>>1]|0,0)|0;l=L()|0;o=o+1<<24>>24;r=o&255}while((r|0)<(q|0))}else l=0;if(l>>>0<0|(l|0)==0&i>>>0<8)if(l>>>0<0|(l|0)==0&i>>>0<2)i=0;else{o=40;do{o=(o&65535)+65526|0;i=aw(i|0,l|0,1)|0;l=L()|0}while(l>>>0<0|(l|0)==0&i>>>0<8);o=o&65535;oa=1514}else{if(l>>>0>0|(l|0)==0&i>>>0>255){o=40;do{o=(o&65535)+40|0;oa=i;i=$v(i|0,l|0,4)|0;na=l;l=L()|0}while(na>>>0>0|(na|0)==0&oa>>>0>4095);o=o&65535}else o=40;if(l>>>0>0|(l|0)==0&i>>>0>15){do{o=(o&65535)+10&65535;oa=i;i=$v(i|0,l|0,1)|0;na=l;l=L()|0}while(na>>>0>0|(na|0)==0&oa>>>0>31);oa=1514}else oa=1514}if((oa|0)==1514){oa=0;i=(o&65535)+65526+(e[3648+((i&7)<<1)>>1]|0)|0}if((c[p+12>>2]|0)>(i<<16>>16|0)){c[rf>>2]=1;break}}l=m;q=pa;o=qa;i=0;break d}while(0);i=0;oa=28;break}case 35:case 34:{c[uc>>2]=(c[uc>>2]|0)+1;oa=1521;break}case 36:{oa=1521;break}case 3:{l=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;i=c[l+40>>2]|0;if(a[i+56>>0]|0){c[rf>>2]=0;i=di(c[i+20>>2]|0,rf)|0;i=(i|0)==0&(c[rf>>2]|0)!=0?101:i;oa=2160;break d}q=i+36|0;o=c[q>>2]|0;oa=o+4|0;c[q>>2]=c[oa>>2];c[oa>>2]=0;do if(!((o|0)==0|(c[i+40>>2]|0)!=0)){if(c[Ze>>2]|0){Vd(Df,o);break}oa=o;if((c[_e>>2]|0)>>>0<=oa>>>0?(c[$e>>2]|0)>>>0>oa>>>0:0){c[o>>2]=c[af>>2];c[af>>2]=o;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](o);break}else{oa=Ua[c[29352>>2]&127](o)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](o);break}}while(0);i=(c[q>>2]|0)==0?101:0;oa=2160;break}case 5:case 4:{i=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;l=i;i=Va[c[p+16>>2]&255](c[i+40>>2]|0,c[p+12>>2]|0)|0;oa=2160;break}case -124:case -125:{t=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;w=c[p+8>>2]|0;o=pa+(w*40|0)|0;s=p+2|0;if(b[s>>1]&1)c[rc>>2]=(c[rc>>2]|0)+1;q=pa+(w*40|0)+8|0;l=b[q>>1]|0;do if(!(l&16384))i=z;else{r=pa+(w*40|0)+12|0;i=(c[o>>2]|0)+(c[r>>2]|0)|0;if((i|0)<1)if(!(l&16)){i=z;break}else i=1;if(Cg(o,i,1)|0){oa=2221;break c}ew((c[pa+(w*40|0)+16>>2]|0)+(c[r>>2]|0)|0,0,c[o>>2]|0)|0;c[r>>2]=(c[r>>2]|0)+(c[o>>2]|0);b[q>>1]=b[q>>1]&-16897;i=a[p>>0]|0}while(0);if(i<<24>>24==-125){t=c[t+40>>2]|0;F=pa+(w*40|0)+16|0;l=c[F>>2]|0;o=l+1|0;na=a[o>>0]|0;i=na&255;do if(na<<24>>24<=-1){q=d[l+2>>0]|0;if(!(q&128)){i=i<<7&16256|q;break}l=d[l+3>>0]|0;if(!(l&128)){i=(i<<14|l)&2080895|q<<7&16256;break}else{Mf(o,rf)|0;na=rf;i=c[na>>2]|0;i=((i|0)==(i|0)?0==(c[na+4>>2]|0):0)?i:-1;break}}while(0);do if(!((i|0)!=7&(i+-1|0)>>>0<9)){l=t+60|0;if((i|0)<11|(i&1|0)==0){a[l>>0]=0;break}else{a[l>>0]=a[l>>0]&2;break}}else{na=t+60|0;a[na>>0]=a[na>>0]&1}while(0);E=pa+(w*40|0)+12|0;D=c[E>>2]|0;o=1;i=D;l=((D|0)<0)<<31>>31;while(1){i=$v(i|0,l|0,7)|0;l=L()|0;if((i|0)==0&(l|0)==0)break;else o=o+1|0}s=D+8|0;q=o+D|0;B=t+4|0;l=c[B>>2]|0;do if(!l)i=0;else{if(!(c[t+40>>2]|0)){i=t+44|0;na=c[i>>2]|0;if((na|0)<=(l|0)?!(c[14768]|0?(na|0)>(c[t>>2]|0):0):0){i=0;break}}else{na=c[t+48>>2]|0;if((na|0)==0|(na+s|0)<=(l|0)){i=0;break}i=t+44|0}na=Th(t)|0;c[i>>2]=0;c[t+48>>2]=0;i=na}while(0);o=t+36|0;l=t+44|0;c[l>>2]=(c[l>>2]|0)+q;l=t+8|0;if((q|0)>(c[l>>2]|0))c[l>>2]=q;A=t+40|0;l=c[A>>2]|0;r=l;if(l){C=t+48|0;q=c[C>>2]|0;y=q+s|0;z=t+52|0;s=c[z>>2]|0;if((y|0)>(s|0)){q=c[o>>2]|0;x=((y|0)<0)<<31>>31;w=s;t=((s|0)<0)<<31>>31;do{w=aw(w|0,t|0,1)|0;t=L()|0}while((t|0)<(x|0)|(t|0)==(x|0)&w>>>0<y>>>0);s=(q|0)==0?-1:q-r|0;q=c[B>>2]|0;r=((q|0)<0)<<31>>31;na=(t|0)>(r|0)|(t|0)==(r|0)&w>>>0>q>>>0;q=na?q:w;r=na?r:t;na=(r|0)<(x|0)|(r|0)==(x|0)&q>>>0<y>>>0;q=na?y:q;r=qb(l,q,na?x:r)|0;if(!r){oa=2221;break c}if((s|0)>-1)c[o>>2]=r+s;c[A>>2]=r;c[z>>2]=q;l=r;q=c[C>>2]|0}l=l+q|0;c[C>>2]=q+(D+15&-8);q=c[o>>2]|0;if(q)c[l+4>>2]=q-r}else{na=Qv(s|0,((s|0)<0)<<31>>31|0,-1,-1)|0;ma=L()|0;if(ma>>>0>0|(ma|0)==0&na>>>0>2147483390){oa=2221;break c}do if(!(c[7324]|0)){l=Ua[c[29340>>2]&127](s)|0;if(!l){oa=2221;break c}}else{r=Ua[c[29356>>2]&127](s)|0;if((c[14985]|0)>>>0<s>>>0)c[14985]=s;q=59064;l=c[q>>2]|0;q=c[q+4>>2]|0;if((q|0)>0|(q|0)==0&l>>>0>0){na=c[14978]|0;ma=Rv(l|0,q|0,r|0,((r|0)<0)<<31>>31|0)|0;la=L()|0;c[14768]=((la|0)<0|(la|0)==0&ma>>>0<=na>>>0)&1}l=Ua[c[29340>>2]&127](r)|0;if(!l){oa=2221;break c}q=Ua[c[29352>>2]&127](l)|0;q=(c[14978]|0)+q|0;c[14978]=q;if(q>>>0>(c[14982]|0)>>>0)c[14982]=q;q=(c[14981]|0)+1|0;c[14981]=q;if(q>>>0<=(c[14987]|0)>>>0)break;c[14987]=q}while(0);c[l+4>>2]=c[o>>2]}cw(l+8|0,c[F>>2]|0,c[E>>2]|0)|0;c[l>>2]=c[E>>2];c[o>>2]=l}else{na=c[pa+(w*40|0)+12>>2]|0;i=Ab;c[i>>2]=na;c[i+4>>2]=((na|0)<0)<<31>>31;c[Hd>>2]=c[pa+(w*40|0)+16>>2];c[Cb>>2]=pa+((c[p+12>>2]|0)*40|0);b[Eb>>1]=c[p+16>>2];i=e[s>>1]|0;if(!(i&16))l=0;else l=c[t+32>>2]|0;i=_g(c[t+40>>2]|0,Hd,i&10,l)|0;c[t+28>>2]=0}if(!i){l=m;q=pa;o=qa;i=0}else{oa=3855;break c}break}case -123:{l=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;o=c[l+40>>2]|0;c[Hd>>2]=c[l+44>>2];b[vc>>1]=c[p+12>>2];a[xc>>0]=0;c[yc>>2]=pa+((c[p+8>>2]|0)*40|0);i=Vg(o,Hd,0,0,0,rf)|0;if(i|0){oa=2226;break c}if((c[rf>>2]|0)==0?(me=$g(o,4)|0,me|0):0){i=me;oa=2226;break c}c[l+28>>2]=0;c[l+32>>2]=0;l=m;q=pa;o=qa;i=0;break}case -121:case -122:{s=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;i=s+40|0;if(a[c[i>>2]>>0]|0?(ne=qh(s)|0,ne|0):0){i=ne;oa=3855;break c}if(a[s+2>>0]|0){i=c[p+8>>2]|0;l=pa+(i*40|0)+8|0;if(!(b[l>>1]&9216)){b[l>>1]=1;l=m;q=pa;o=qa;i=0;break d}else{Bg(pa+(i*40|0)|0);l=m;q=pa;o=qa;i=0;break d}}i=c[i>>2]|0;$f(i);l=c[i+44>>2]|0;b[jb>>1]=0;c[kb>>2]=Df;c[lb>>2]=0;na=e[i+48>>1]|0;o=c[i+40>>2]|0;ma=(c[(c[i+116>>2]|0)+60>>2]|0)-o|0;if(l>>>0>((ma|0)<(na|0)?((ma|0)>0?ma:0):na)>>>0){i=sh(i,0,l,Hd)|0;if(i|0){oa=2256;break c}o=c[Fb>>2]|0}else{c[Fb>>2]=o;b[jb>>1]=4112;c[Gb>>2]=l}na=a[o>>0]|0;i=na&255;do if(na<<24>>24<=-1){l=d[o+1>>0]|0;if(!(l&128)){i=i<<7&16256|l;oa=2241;break}q=d[o+2>>0]|0;if(q&128){Mf(o,rf)|0;na=rf;i=c[na>>2]|0;if((i|0)==(i|0)?0==(c[na+4>>2]|0):0){oa=2241;break}else{i=-1;break}}else{i=(i<<14|q)&2080895|l<<7&16256;oa=2241;break}}else oa=2241;while(0);if((oa|0)==2241){oa=0;if(i>>>0<3){oa=2253;break c}}if(i>>>0>(c[Gb>>2]|0)>>>0){oa=2253;break c}o=c[Fb>>2]|0;r=o+(i+-1)|0;na=a[r>>0]|0;l=na&255;do if(na<<24>>24<=-1){o=d[o+i>>0]|0;if(!(o&128)){l=l<<7&16256|o;break}q=d[r+2>>0]|0;if(!(q&128)){l=(l<<14|q)&2080895|o<<7&16256;break}else{Mf(r,rf)|0;na=rf;l=c[na>>2]|0;l=((l|0)==(l|0)?0==(c[na+4>>2]|0):0)?l:-1;break}}while(0);if((l|0)==7|(l+-1|0)>>>0>8){oa=2253;break c}o=d[3520+l>>0]|0;q=c[Gb>>2]|0;if(q>>>0<(i+o|0)>>>0){oa=2253;break c}Sg((c[Fb>>2]|0)+(q-o)|0,l,Td)|0;q=Td;o=c[q>>2]|0;q=c[q+4>>2]|0;if(!((b[jb>>1]&9216)==0&(c[lb>>2]|0)==0))Ag(Hd);if((a[p>>0]|0)==-122){l=c[(c[oc>>2]|0)+(c[p+12>>2]<<2)>>2]|0;a[l+2>>0]=0;i=l+64|0;c[i>>2]=o;c[i+4>>2]=q;a[l+3>>0]=1;c[l+24>>2]=c[p+16>>2];c[l+36>>2]=s;l=m;q=pa;o=qa;i=0;break d}na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216))b[l>>1]=4;else jh(i)|0;l=i;c[l>>2]=o;c[l+4>>2]=q;l=m;q=pa;o=qa;i=0;break}case 40:case 39:case 38:case 37:{o=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;c[Hd>>2]=c[o+44>>2];b[zc>>1]=c[p+16>>2];a[Ac>>0]=((z&255)<39)<<31>>31;c[Bc>>2]=pa+((c[p+12>>2]|0)*40|0);o=c[o+40>>2]|0;$f(o);i=c[o+44>>2]|0;if((i|0)<1){oa=2267;break c}b[Ea>>1]=0;c[Fa>>2]=Df;c[Ga>>2]=0;na=e[o+48>>1]|0;l=c[o+40>>2]|0;ma=(c[(c[o+116>>2]|0)+60>>2]|0)-l|0;if(i>>>0>((ma|0)<(na|0)?((ma|0)>0?ma:0):na)>>>0){i=sh(o,0,i,rf)|0;if(i|0){oa=2274;break c}i=c[nb>>2]|0;l=c[mb>>2]|0}else{c[mb>>2]=l;b[Ea>>1]=4112;c[nb>>2]=i}i=Dh(i,l,Hd,0)|0;if(!((b[Ea>>1]&9216)==0&(c[Ga>>2]|0)==0))Ag(rf);if((((a[p>>0]&1)==0?i+1|0:0-i|0)|0)>0){i=0;oa=28}else{l=m;q=pa;o=qa;i=0}break}case -120:{na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216)){b[l>>1]=4;A=i}else{jh(i)|0;A=i}B=A+8|0;b[B>>1]=1;if((c[Ha>>2]|0)>((c[ad>>2]|0)+1|0)){oa=2280;break c}C=c[p+12>>2]|0;x=c[(c[vf>>2]|0)+(C<<4)+4>>2]|0;z=p+4|0;s=c[z>>2]|0;y=x+4|0;w=c[y>>2]|0;c[w+4>>2]=c[x>>2];if((c[w+44>>2]|0)>>>0<s>>>0){oa=2282;break c}l=c[w>>2]|0;l=Xa[c[l+204>>2]&127](l,s,rf,0)|0;if(l|0){oa=2286;break c}i=c[rf>>2]|0;r=c[i+8>>2]|0;q=r+4|0;if((c[q>>2]|0)!=(s|0)){c[r+56>>2]=c[i+4>>2];c[r+72>>2]=i;c[r+52>>2]=w;c[q>>2]=s;a[r+9>>0]=(s|0)==1?100:0}o=c[y>>2]|0;c[o+4>>2]=c[x>>2];i=c[o+8>>2]|0;H:do if(i|0){I:do if(s)while(1){if((c[i+64>>2]|0)==(s|0))break I;i=c[i+24>>2]|0;if(!i)break H}while(0);i=Zf(i,s,0)|0;if(i|0){j=i;oa=2301;break c}}while(0);l=x+11|0;if(a[l>>0]|0?(a[l>>0]=0,kd=c[(c[y>>2]|0)+8>>2]|0,kd|0):0){i=kd;do{do if(a[i+1>>0]&16){a[l>>0]=1;if((c[i+64>>2]|0)!=(s|0))break;a[i>>0]=1}while(0);i=c[i+24>>2]|0}while((i|0)!=0)}i=xh(o,s,0,0)|0;if(i|0){j=i;oa=2301;break c}if(!(a[w+17>>0]|0)){i=zh(c[r+52>>2]|0,r,c[q>>2]|0)|0;do if(r|0){l=c[r+72>>2]|0;if(!(b[l+28>>1]&32)){Bf(l);break}else{na=c[l+20>>2]|0;ma=na+120|0;c[ma>>2]=(c[ma>>2]|0)+-1;na=na+136|0;c[l+16>>2]=c[na>>2];c[na>>2]=l;break}}while(0);b[B>>1]=4;na=A;c[na>>2]=0;c[na+4>>2]=0;if(!i){l=m;q=pa;o=qa;i=0;break d}else{oa=3855;break c}}t=c[y>>2]|0;c[t+4>>2]=c[x>>2];t=c[(c[t+12>>2]|0)+56>>2]|0;t=d[t+53>>0]<<16|d[t+52>>0]<<24|d[t+54>>0]<<8|d[t+55>>0];if((t|0)==(s|0)){l=zh(c[r+52>>2]|0,r,c[q>>2]|0)|0;do if(r|0){i=c[r+72>>2]|0;if(!(b[i+28>>1]&32)){Bf(i);break}else{na=c[i+20>>2]|0;ma=na+120|0;c[ma>>2]=(c[ma>>2]|0)+-1;na=na+136|0;c[i+16>>2]=c[na>>2];c[na>>2]=i;break}}while(0);if(!l)i=0;else{i=0;j=l;oa=2353;break c}}else{do if(r|0){i=c[r+72>>2]|0;if(!(b[i+28>>1]&32)){Bf(i);break}else{na=c[i+20>>2]|0;ma=na+120|0;c[ma>>2]=(c[ma>>2]|0)+-1;na=na+136|0;c[i+16>>2]=c[na>>2];c[na>>2]=i;break}}while(0);l=c[w>>2]|0;l=Xa[c[l+204>>2]&127](l,t,rf,0)|0;if(l|0){oa=2319;break c}i=c[rf>>2]|0;o=c[i+8>>2]|0;l=o+4|0;if((c[l>>2]|0)!=(t|0)){c[o+56>>2]=c[i+4>>2];c[o+72>>2]=i;c[o+52>>2]=w;c[l>>2]=t;a[o+9>>0]=(t|0)==1?100:0}l=eg(w,o,1,0,s,0)|0;do if(o|0){i=c[o+72>>2]|0;if(!(b[i+28>>1]&32)){Bf(i);break}else{na=c[i+20>>2]|0;ma=na+120|0;c[ma>>2]=(c[ma>>2]|0)+-1;na=na+136|0;c[i+16>>2]=c[na>>2];c[na>>2]=i;break}}while(0);if(l|0){i=0;j=l;oa=2353;break c}l=c[w>>2]|0;l=Xa[c[l+204>>2]&127](l,t,rf,0)|0;if(l|0){oa=2329;break c}i=c[rf>>2]|0;o=c[i+8>>2]|0;l=o+4|0;if((c[l>>2]|0)==(t|0)){l=o+72|0;i=c[o+52>>2]|0}else{c[o+56>>2]=c[i+4>>2];na=o+72|0;c[na>>2]=i;c[o+52>>2]=w;c[l>>2]=t;a[o+9>>0]=(t|0)==1?100:0;l=na;i=w}o=zh(i,o,t)|0;i=c[l>>2]|0;if(!(b[i+28>>1]&32))Bf(i);else{na=c[i+20>>2]|0;ma=na+120|0;c[ma>>2]=(c[ma>>2]|0)+-1;na=na+136|0;c[i+16>>2]=c[na>>2];c[na>>2]=i}if(!o)i=t;else{i=0;j=o;oa=2353;break c}}q=1073741824/((c[w+32>>2]|0)>>>0)|0;r=q+1|0;o=w+36|0;l=t;while(1){s=l+-1|0;if((s|0)!=(r|0)){if(s>>>0<2)l=0;else{l=l+-3|0;l=l-((l>>>0)%(((((c[o>>2]|0)>>>0)/5|0)+1|0)>>>0)|0)|0;l=((l+1|0)==(q|0)?3:2)+l|0}if((l|0)!=(s|0))break}l=s}o=c[y>>2]|0;c[o+4>>2]=c[x>>2];o=c[o+12>>2]|0;l=c[o+56>>2]|0;o=c[o+72>>2]|0;q=c[o+20>>2]|0;do if(!(b[o+28>>1]&4))oa=2344;else{if((c[q+24>>2]|0)>>>0<(c[o+24>>2]|0)>>>0){oa=2344;break}if(!(c[q+96>>2]|0))break;j=Te(o)|0;oa=2348}while(0);do if((oa|0)==2344){j=c[q+40>>2]|0;if(j|0){oa=2353;break c}if((c[q+148>>2]|0)>>>0>(c[q+152>>2]|0)>>>0){j=Uf(o)|0;oa=2348;break}else{j=Vf(o)|0;oa=2348;break}}while(0);if((oa|0)==2348?(oa=0,j|0):0){oa=2353;break c}a[l+52>>0]=s>>>24;a[l+53>>0]=s>>>16;a[l+54>>0]=s>>>8;a[l+55>>0]=s;b[B>>1]=4;na=A;c[na>>2]=i;c[na+4>>2]=((i|0)<0)<<31>>31;if(!i){l=m;q=pa;o=qa;i=0}else{q=c[z>>2]|0;o=c[(c[vf>>2]|0)+(C<<4)+12>>2]|0;k=c[o+16>>2]|0;if(k|0)do{l=(c[k+8>>2]|0)+28|0;if((c[l>>2]|0)==(i|0))c[l>>2]=q;k=c[k>>2]|0}while((k|0)!=0);k=c[o+32>>2]|0;if(k|0)do{l=(c[k+8>>2]|0)+44|0;if((c[l>>2]|0)==(i|0))c[l>>2]=q;k=c[k>>2]|0}while((k|0)!=0);k=C+1&255;l=m;q=pa;o=qa;i=0}break}case -119:{c[rf>>2]=0;l=c[(c[vf>>2]|0)+(c[p+8>>2]<<4)+4>>2]|0;r=c[p+4>>2]|0;t=p+12|0;q=(c[t>>2]|0)==0?0:rf;o=l+4|0;s=c[o>>2]|0;c[s+4>>2]=c[l>>2];i=c[s+8>>2]|0;J:do if(i){K:do if(r)while(1){if((c[i+64>>2]|0)==(r|0))break K;i=c[i+24>>2]|0;if(!i){oa=2373;break J}}while(0);i=Zf(i,r,0)|0;if(!i)oa=2373}else oa=2373;while(0);if((oa|0)==2373){oa=0;l=l+11|0;if(a[l>>0]|0?(a[l>>0]=0,md=c[(c[o>>2]|0)+8>>2]|0,md|0):0){i=md;do{if(a[i+1>>0]&16?(a[l>>0]=1,(c[i+64>>2]|0)==(r|0)):0)a[i>>0]=1;i=c[i+24>>2]|0}while((i|0)!=0)}i=xh(s,r,0,q)|0}l=c[t>>2]|0;if(l|0?(oe=c[rf>>2]|0,c[rc>>2]=(c[rc>>2]|0)+oe,pe=pa+(l*40|0)|0,(l|0)>0):0){la=pe;la=Qv(c[la>>2]|0,c[la+4>>2]|0,oe|0,((oe|0)<0)<<31>>31|0)|0;ma=L()|0;na=pe;c[na>>2]=la;c[na+4>>2]=ma}if(!i){l=m;q=pa;o=qa;i=0}else{oa=3855;break c}break}case -118:{i=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;if((a[i>>0]|0)==1){ug(Df,c[i+40>>2]|0);l=m;q=pa;o=qa;i=K;break d}q=c[i+40>>2]|0;l=c[q+8>>2]|0;q=c[q+64>>2]|0;o=l+4|0;r=c[o>>2]|0;c[r+4>>2]=c[l>>2];i=c[r+8>>2]|0;L:do if(i|0){M:do if(q)while(1){if((c[i+64>>2]|0)==(q|0))break M;i=c[i+24>>2]|0;if(!i)break L}while(0);i=Zf(i,q,0)|0;if(i|0){oa=3855;break c}}while(0);l=l+11|0;if(a[l>>0]|0?(a[l>>0]=0,jd=c[(c[o>>2]|0)+8>>2]|0,jd|0):0){i=jd;do{if(a[i+1>>0]&16?(a[l>>0]=1,(c[i+64>>2]|0)==(q|0)):0)a[i>>0]=1;i=c[i+24>>2]|0}while((i|0)!=0)}i=xh(r,q,0,0)|0;if(!i){l=m;q=pa;o=qa;i=0}else{oa=3855;break c}break}case -117:{na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216))b[l>>1]=4;else jh(i)|0;c[rf>>2]=0;l=Ug(c[(c[vf>>2]|0)+(c[p+4>>2]<<4)+4>>2]|0,rf,c[p+12>>2]|0)|0;if(l|0){oa=2406;break c}q=c[rf>>2]|0;l=i;c[l>>2]=q;c[l+4>>2]=((q|0)<0)<<31>>31;l=m;q=pa;o=qa;i=0;break}case -116:{a[Cc>>0]=(a[Cc>>0]|0)+1<<24>>24;i=ld(Df,c[p+16>>2]|0,0,0,0)|0;a[Cc>>0]=(a[Cc>>0]|0)+-1<<24>>24;if(!i){l=m;q=pa;o=qa;i=0}else{oa=3855;break c}break}case -115:{i=c[p+4>>2]|0;l=p+16|0;if(!(c[l>>2]|0)){bh(c[(c[vf>>2]|0)+(i<<4)+12>>2]|0);c[hf>>2]=c[hf>>2]&-17;i=ch(Df,i,mf,1)|0;c[hf>>2]=c[hf>>2]|1;na=(d[wf>>0]|d[wf+1>>0]<<8)&-4;a[wf>>0]=na;a[wf+1>>0]=na>>8}else{c[rf>>2]=Df;c[Ia>>2]=i;c[Ja>>2]=mf;c[Ka>>2]=0;l=c[l>>2]|0;c[Oe>>2]=c[(c[vf>>2]|0)+(i<<4)>>2];c[Oe+4>>2]=34585;c[Oe+8>>2]=l;l=bd(Df,34599,Oe)|0;if(!l){oa=2424;break c}a[ob>>0]=1;c[pb>>2]=0;c[rb>>2]=0;i=ld(Df,l,77,rf,0)|0;i=(i|0)==0?c[pb>>2]|0:i;if(!(i|c[rb>>2])){c[Pe>>2]=32306;c[Pe+4>>2]=89378;c[Pe+8>>2]=31517;Bb(11,32001,Pe);i=11}do if(!(c[Ze>>2]|0)){na=l;if((c[_e>>2]|0)>>>0<=na>>>0?(c[$e>>2]|0)>>>0>na>>>0:0){c[l>>2]=c[af>>2];c[af>>2]=l;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}else Vd(Df,l);while(0);a[ob>>0]=0}switch(i|0){case 7:{oa=2424;break c}case 0:break;default:{oa=2425;break c}}l=m;q=pa;o=qa;i=0;break}case -114:{i=eh(Df,c[p+4>>2]|0)|0;if(!i){l=m;q=pa;o=qa;i=0}else{oa=3855;break c}break}case -113:{i=ki((c[(c[vf>>2]|0)+(c[p+4>>2]<<4)+12>>2]|0)+8|0,c[p+16>>2]|0,0)|0;do if(i|0){if(c[Ze>>2]|0){Ti(Df,i);break}ma=i+32|0;na=(c[ma>>2]|0)+-1|0;c[ma>>2]=na;if(!na)Ti(Df,i)}while(0);c[hf>>2]=c[hf>>2]|1;l=m;q=pa;o=qa;i=K;break}case -112:{o=ki((c[(c[vf>>2]|0)+(c[p+4>>2]<<4)+12>>2]|0)+24|0,c[p+16>>2]|0,0)|0;do if(o|0){l=(c[o+12>>2]|0)+8|0;i=c[l>>2]|0;if((i|0)==(o|0)){c[l>>2]=c[o+20>>2];i=c[o+36>>2]|0;if(i|0)li(Df,i);i=c[o+40>>2]|0;if(i|0)pi(Df,i);i=c[o+16>>2]|0;do if(i|0){if(c[Ze>>2]|0){Vd(Df,i);break}na=i;if((c[_e>>2]|0)>>>0<=na>>>0?(c[$e>>2]|0)>>>0>na>>>0:0){c[i>>2]=c[af>>2];c[af>>2]=i;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{na=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);na=o+55|0;N:do if((d[na>>0]|d[na+1>>0]<<8)&16?(qe=c[o+32>>2]|0,qe|0):0){if(c[Ze>>2]|0){Vd(Df,qe);break}i=qe;do if((c[_e>>2]|0)>>>0<=i>>>0){if((c[$e>>2]|0)>>>0<=i>>>0)break;c[qe>>2]=c[af>>2];c[af>>2]=qe;break N}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](qe);break}else{na=Ua[c[29352>>2]&127](qe)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](qe);break}}while(0);if(c[Ze>>2]|0){Vd(Df,o);break}na=o;if((c[_e>>2]|0)>>>0<=na>>>0?(c[$e>>2]|0)>>>0>na>>>0:0){c[o>>2]=c[af>>2];c[af>>2]=o;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](o);break}else{na=Ua[c[29352>>2]&127](o)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](o);break}}O:do if(i|0){while(1){l=c[i+20>>2]|0;if((l|0)==(o|0))break;if(!l)break O;else i=l}c[i+20>>2]=c[o+20>>2]}while(0);i=c[o+36>>2]|0;if(i|0)li(Df,i);i=c[o+40>>2]|0;if(i|0)pi(Df,i);i=c[o+16>>2]|0;do if(i|0){if(c[Ze>>2]|0){Vd(Df,i);break}na=i;if((c[_e>>2]|0)>>>0<=na>>>0?(c[$e>>2]|0)>>>0>na>>>0:0){c[i>>2]=c[af>>2];c[af>>2]=i;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{na=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);na=o+55|0;P:do if((d[na>>0]|d[na+1>>0]<<8)&16?(re=c[o+32>>2]|0,re|0):0){if(c[Ze>>2]|0){Vd(Df,re);break}i=re;do if((c[_e>>2]|0)>>>0<=i>>>0){if((c[$e>>2]|0)>>>0<=i>>>0)break;c[re>>2]=c[af>>2];c[af>>2]=re;break P}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](re);break}else{na=Ua[c[29352>>2]&127](re)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](re);break}}while(0);if(c[Ze>>2]|0){Vd(Df,o);break}na=o;if((c[_e>>2]|0)>>>0<=na>>>0?(c[$e>>2]|0)>>>0>na>>>0:0){c[o>>2]=c[af>>2];c[af>>2]=o;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](o);break}else{na=Ua[c[29352>>2]&127](o)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](o);break}}while(0);c[hf>>2]=c[hf>>2]|1;l=m;q=pa;o=qa;i=K;break}case -110:{x=ki((c[(c[vf>>2]|0)+(c[p+4>>2]<<4)+12>>2]|0)+40|0,c[p+16>>2]|0,0)|0;if(!x){l=m;q=pa;o=qa;i=K}else{q=c[x+20>>2]|0;Q:do if((q|0)==(c[x+24>>2]|0)){w=x+4|0;t=c[w>>2]|0;r=c[q+20>>2]|0;if(!r){l=q+12|0;i=q+16|0}else{l=a[t>>0]|0;if(!(l<<24>>24))i=0;else{i=0;o=t;do{o=o+1|0;i=G(i+(d[208+(l&255)>>0]|0)|0,-1640531535)|0;l=a[o>>0]|0}while(l<<24>>24!=0)}i=(i>>>0)%((c[q+8>>2]|0)>>>0)|0;l=r+(i<<3)|0;i=r+(i<<3)+4|0}l=c[l>>2]|0;R:do if(!l)i=59292;else{s=d[208+(d[t>>0]|0)>>0]|0;while(1){i=c[i>>2]|0;l=l+-1|0;q=c[i+12>>2]|0;na=a[q>>0]|0;o=(d[208+(na&255)>>0]|0)-s|0;if(!(na<<24>>24==0|(o|0)!=0)){r=t;do{q=q+1|0;r=r+1|0;na=a[q>>0]|0;o=(d[208+(na&255)>>0]|0)-(d[208+(d[r>>0]|0)>>0]|0)|0}while(!(na<<24>>24==0|(o|0)!=0))}if(!o)break R;if(!l){i=59292;break}}}while(0);i=(c[i+8>>2]|0)+68|0;while(1){na=c[i>>2]|0;l=na+32|0;if((na|0)==(x|0))break;else i=l}c[i>>2]=c[l>>2];Vi(Df,c[x+28>>2]|0);i=c[x>>2]|0;do if(i|0){if(c[Ze>>2]|0){Vd(Df,i);break}na=i;if((c[_e>>2]|0)>>>0<=na>>>0?(c[$e>>2]|0)>>>0>na>>>0:0){c[i>>2]=c[af>>2];c[af>>2]=i;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{na=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);i=c[w>>2]|0;do if(i|0){if(c[Ze>>2]|0){Vd(Df,i);break}na=i;if((c[_e>>2]|0)>>>0<=na>>>0?(c[$e>>2]|0)>>>0>na>>>0:0){c[i>>2]=c[af>>2];c[af>>2]=i;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{na=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);i=c[x+12>>2]|0;if(i|0)li(Df,i);r=c[x+16>>2]|0;S:do if(r|0){q=r+4|0;i=c[r>>2]|0;if((c[q>>2]|0)>0){o=0;do{i=c[i+(o<<3)>>2]|0;T:do if(i|0){if(c[Ze>>2]|0){Vd(Df,i);break}l=i;do if((c[_e>>2]|0)>>>0<=l>>>0){if((c[$e>>2]|0)>>>0<=l>>>0)break;c[i>>2]=c[af>>2];c[af>>2]=i;break T}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{na=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);o=o+1|0;i=c[r>>2]|0}while((o|0)<(c[q>>2]|0))}U:do if(i|0){if(c[Ze>>2]|0){Vd(Df,i);break}l=i;do if((c[_e>>2]|0)>>>0<=l>>>0){if((c[$e>>2]|0)>>>0<=l>>>0)break;c[i>>2]=c[af>>2];c[af>>2]=i;break U}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{na=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);if(c[Ze>>2]|0){Vd(Df,r);break}i=r;do if((c[_e>>2]|0)>>>0<=i>>>0){if((c[$e>>2]|0)>>>0<=i>>>0)break;c[r>>2]=c[af>>2];c[af>>2]=r;break S}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](r);break}else{na=Ua[c[29352>>2]&127](r)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](r);break}}while(0);if(c[Ze>>2]|0){Vd(Df,x);break}i=x;do if((c[_e>>2]|0)>>>0<=i>>>0){if((c[$e>>2]|0)>>>0<=i>>>0)break;c[x>>2]=c[af>>2];c[af>>2]=x;break Q}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](x);break}else{na=Ua[c[29352>>2]&127](x)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](x);break}}else{Vi(Df,c[x+28>>2]|0);i=c[x>>2]|0;do if(i|0){if(c[Ze>>2]|0){Vd(Df,i);break}na=i;if((c[_e>>2]|0)>>>0<=na>>>0?(c[$e>>2]|0)>>>0>na>>>0:0){c[i>>2]=c[af>>2];c[af>>2]=i;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{na=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);i=c[x+4>>2]|0;do if(i|0){if(c[Ze>>2]|0){Vd(Df,i);break}na=i;if((c[_e>>2]|0)>>>0<=na>>>0?(c[$e>>2]|0)>>>0>na>>>0:0){c[i>>2]=c[af>>2];c[af>>2]=i;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{na=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);i=c[x+12>>2]|0;if(i|0)li(Df,i);r=c[x+16>>2]|0;V:do if(r|0){q=r+4|0;i=c[r>>2]|0;if((c[q>>2]|0)>0){o=0;do{i=c[i+(o<<3)>>2]|0;W:do if(i|0){if(c[Ze>>2]|0){Vd(Df,i);break}l=i;do if((c[_e>>2]|0)>>>0<=l>>>0){if((c[$e>>2]|0)>>>0<=l>>>0)break;c[i>>2]=c[af>>2];c[af>>2]=i;break W}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{na=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);o=o+1|0;i=c[r>>2]|0}while((o|0)<(c[q>>2]|0))}X:do if(i|0){if(c[Ze>>2]|0){Vd(Df,i);break}l=i;do if((c[_e>>2]|0)>>>0<=l>>>0){if((c[$e>>2]|0)>>>0<=l>>>0)break;c[i>>2]=c[af>>2];c[af>>2]=i;break X}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{na=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);if(c[Ze>>2]|0){Vd(Df,r);break}i=r;do if((c[_e>>2]|0)>>>0<=i>>>0){if((c[$e>>2]|0)>>>0<=i>>>0)break;c[r>>2]=c[af>>2];c[af>>2]=r;break V}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](r);break}else{na=Ua[c[29352>>2]&127](r)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](r);break}}while(0);if(c[Ze>>2]|0){Vd(Df,x);break}na=x;if((c[_e>>2]|0)>>>0<=na>>>0?(c[$e>>2]|0)>>>0>na>>>0:0){c[x>>2]=c[af>>2];c[af>>2]=x;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](x);break}else{na=Ua[c[29352>>2]&127](x)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](x);break}}while(0);c[hf>>2]=c[hf>>2]|1;l=m;q=pa;o=qa;i=K}break}case -109:{w=c[p+8>>2]|0;C=c[p+4>>2]|0;D=pa+(C*40|0)|0;i=c[(c[vf>>2]|0)+(e[p+2>>1]<<4)+4>>2]|0;x=(c[p+16>>2]|0)+4|0;E=pa+((c[p+12>>2]|0)*40|0)|0;na=(c[E>>2]|0)+1|0;z=c[i+4>>2]|0;y=z+4|0;B=(c[y>>2]|0)+32|0;A=c[B>>2]|0;B=c[B+4>>2]|0;c[y>>2]=c[i>>2];c[Td>>2]=z;c[Dc>>2]=c[z>>2];i=c[z+44>>2]|0;c[Ec>>2]=i;c[Fc>>2]=na;c[Jc>>2]=0;c[Kc>>2]=0;c[Gc>>2]=0;c[Gc+4>>2]=0;c[Gc+8>>2]=0;c[Gc+12>>2]=0;c[Gc+16>>2]=0;c[Mc>>2]=$d;c[Lc>>2]=0;c[Nc>>2]=100;c[Oc>>2]=1e9;c[Pc>>2]=0;a[Qc>>0]=0;a[Rc>>0]=1;Y:do if(i){i=i>>>3;q=i+1|0;if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](q)|0;if(!i)oa=2649}else{o=Ua[c[29356>>2]&127](q)|0;if((c[14985]|0)>>>0<=i>>>0)c[14985]=q;l=59064;i=c[l>>2]|0;l=c[l+4>>2]|0;if((l|0)>0|(l|0)==0&i>>>0>0){na=c[14978]|0;ma=Rv(i|0,l|0,o|0,((o|0)<0)<<31>>31|0)|0;la=L()|0;c[14768]=((la|0)<0|(la|0)==0&ma>>>0<=na>>>0)&1}i=Ua[c[29340>>2]&127](o)|0;if(i){l=Ua[c[29352>>2]&127](i)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else oa=2649}if((oa|0)==2649){c[Jc>>2]=0;c[Hc>>2]=1;oa=2710;break}ew(i|0,0,q|0)|0;c[Jc>>2]=i;t=z+32|0;q=c[t>>2]|0;if((c[14813]|0)>=(q|0)?(se=c[14819]|0,(se|0)!=0):0){c[14819]=c[se>>2];na=c[14820]|0;c[14820]=na+-1;c[14821]=(na|0)<=(c[14815]|0)&1;if((c[14986]|0)>>>0<q>>>0)c[14986]=q;i=(c[14979]|0)+1|0;c[14979]=i;if(i>>>0>(c[14983]|0)>>>0){c[14983]=i;i=se}else i=se}else oa=2656;Z:do if((oa|0)==2656){oa=0;na=Qv(q|0,((q|0)<0)<<31>>31|0,-1,-1)|0;ma=L()|0;_:do if(!(ma>>>0>0|(ma|0)==0&na>>>0>2147483390)){do if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](q)|0;if(!i)break _}else{l=Ua[c[29356>>2]&127](q)|0;if((c[14985]|0)>>>0<q>>>0)c[14985]=q;i=59064;o=c[i>>2]|0;i=c[i+4>>2]|0;if((i|0)>0|(i|0)==0&o>>>0>0){na=c[14978]|0;ma=Rv(o|0,i|0,l|0,((l|0)<0)<<31>>31|0)|0;la=L()|0;c[14768]=((la|0)<0|(la|0)==0&ma>>>0<=na>>>0)&1}i=Ua[c[29340>>2]&127](l)|0;if(!i)break _;l=Ua[c[29352>>2]&127](i)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0<=(c[14987]|0)>>>0)break;c[14987]=l}while(0);l=Ua[c[29352>>2]&127](i)|0;if((c[14986]|0)>>>0<q>>>0)c[14986]=q;l=(c[14980]|0)+l|0;c[14980]=l;if(l>>>0<=(c[14984]|0)>>>0)break Z;c[14984]=l;break Z}while(0);c[Kc>>2]=0;c[Hc>>2]=1;break Y}while(0);c[Kc>>2]=i;i=(1073741824/((c[t>>2]|0)>>>0)|0)+1|0;if(i>>>0<=(c[Ec>>2]|0)>>>0){na=(c[Jc>>2]|0)+(i>>>3)|0;a[na>>0]=1<<(i&7)|d[na>>0]}c[Ic>>2]=35261;o=z+12|0;s=c[(c[o>>2]|0)+56>>2]|0;qi(Td,1,d[s+33>>0]<<16|d[s+32>>0]<<24|d[s+34>>0]<<8|d[s+35>>0],d[s+37>>0]<<16|d[s+36>>0]<<24|d[s+38>>0]<<8|d[s+39>>0]);c[Ic>>2]=0;s=z+17|0;if(!(a[s>>0]|0)){na=c[(c[o>>2]|0)+56>>2]|0;if(d[na+65>>0]<<16|d[na+64>>0]<<24|d[na+66>>0]<<8|d[na+67>>0]|0)ri(Td,35322,Re)}else{if((w|0)>0){i=0;l=0;do{na=c[x+(i<<2)>>2]|0;l=(l|0)<(na|0)?na:l;i=i+1|0}while((i|0)!=(w|0))}else l=0;i=c[(c[o>>2]|0)+56>>2]|0;i=d[i+53>>0]<<16|d[i+52>>0]<<24|d[i+54>>0]<<8|d[i+55>>0];if((l|0)!=(i|0)){c[Qe>>2]=l;c[Qe+4>>2]=i;ri(Td,35277,Qe)}}l=(c[y>>2]|0)+32|0;ma=l;na=c[ma+4>>2]|0;i=l;c[i>>2]=c[ma>>2]&-2097153;c[i+4>>2]=na;i=c[Fc>>2]|0;if((w|0)>0&(i|0)!=0){r=0;do{o=x+(r<<2)|0;q=c[o>>2]|0;if(q){if((q|0)>1&(a[s>>0]|0)!=0){i=cg(c[Td>>2]|0,q,rf,Hd)|0;$:do if((i|0)<7){switch(i|0){case 0:break;default:{oa=2689;break $}}i=a[rf>>0]|0;l=c[Hd>>2]|0;if(i<<24>>24==1&(l|0)==0)break;c[Ue>>2]=q;c[Ue+4>>2]=1;c[Ue+8>>2]=0;c[Ue+12>>2]=i&255;c[Ue+16>>2]=l;ri(Td,35625,Ue)}else{if((i|0)<3082)switch(i|0){case 7:break;default:{oa=2689;break $}}else switch(i|0){case 3082:break;default:{oa=2689;break $}}c[Hc>>2]=1;oa=2689}while(0);if((oa|0)==2689){oa=0;c[Se>>2]=q;ri(Td,35596,Se)}i=c[o>>2]|0}else i=q;si(Td,i,ee,-1,2147483647)|0;i=c[Fc>>2]|0}r=r+1|0}while((r|0)<(w|0)&(i|0)!=0);l=(c[y>>2]|0)+32|0}na=l;c[na>>2]=A;c[na+4>>2]=B;if((i|0)!=0&(c[Ec>>2]|0)!=0){r=z+36|0;q=1;do{l=q>>>3;o=1<<(q&7);do if(!(o&d[(c[Jc>>2]|0)+l>>0])){if(q>>>0<2)i=0;else{i=q+-2|0;i=i-((i>>>0)%(((((c[r>>2]|0)>>>0)/5|0)+1|0)>>>0)|0)|0;i=((i+1|0)==(1073741824/((c[t>>2]|0)>>>0)|0|0)?3:2)+i|0}if((i|0)==(q|0)?a[s>>0]|0:0)break;c[Ve>>2]=q;ri(Td,35377,Ve);if(o&d[(c[Jc>>2]|0)+l>>0]|0)oa=2704}else oa=2704;while(0);do if((oa|0)==2704){oa=0;if(q>>>0<2)i=0;else{i=q+-2|0;i=i-((i>>>0)%(((((c[r>>2]|0)>>>0)/5|0)+1|0)>>>0)|0)|0;i=((i+1|0)==(1073741824/((c[t>>2]|0)>>>0)|0|0)?3:2)+i|0}if((i|0)!=(q|0))break;if(!(a[s>>0]|0))break;c[We>>2]=q;ri(Td,35399,We)}while(0);q=q+1|0}while(c[Fc>>2]|0?q>>>0<=(c[Ec>>2]|0)>>>0:0);oa=2710}else oa=2710}else oa=2710;while(0);aa:do if((oa|0)==2710?(oa=0,pd=c[Kc>>2]|0,pd|0):0){i=pd;do if((c[14816]|0)>>>0<=i>>>0)if((c[14817]|0)>>>0>i>>>0){c[14979]=(c[14979]|0)+-1;c[pd>>2]=c[14819];c[14819]=pd;na=(c[14820]|0)+1|0;c[14820]=na;c[14821]=(na|0)<(c[14815]|0)&1;break aa}else{i=Ua[c[29352>>2]&127](pd)|0;break}else i=Ua[c[29352>>2]&127](pd)|0;while(0);c[14980]=(c[14980]|0)-i;if(!(c[7324]|0)){_a[c[29344>>2]&127](pd);break}else{na=Ua[c[29352>>2]&127](pd)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](pd);break}}while(0);i=c[Jc>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{na=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);if(!(c[Hc>>2]|0))r=c[Gc>>2]|0;else{if(a[Rc>>0]&4){i=c[Lc>>2]|0;l=c[Mc>>2]|0;ba:do if(l|0){do if(i|0){if(c[i+480>>2]|0){Vd(i,l);break ba}o=l;if((c[i+304>>2]|0)>>>0<=o>>>0){if((c[i+308>>2]|0)>>>0<=o>>>0)break;na=i+300|0;c[l>>2]=c[na>>2];c[na>>2]=l;break ba}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);a[Rc>>0]=a[Rc>>0]&-5}c[Nc>>2]=0;c[Pc>>2]=0;c[Mc>>2]=0;r=(c[Gc>>2]|0)+1|0;c[Gc>>2]=r}q=(r|0)==0;if(!q){i=c[Mc>>2]|0;if(((i|0)!=0?(a[i+(c[Pc>>2]|0)>>0]=0,(c[Oc>>2]|0)!=0):0)?(a[Rc>>0]&4)==0:0)i=Zd(Lc)|0;else oa=2756}else{if(a[Rc>>0]&4){i=c[Lc>>2]|0;l=c[Mc>>2]|0;ca:do if(l|0){do if(i|0){if(c[i+480>>2]|0){Vd(i,l);break ca}o=l;if((c[i+304>>2]|0)>>>0>o>>>0)break;if((c[i+308>>2]|0)>>>0<=o>>>0)break;oa=i+300|0;c[l>>2]=c[oa>>2];c[oa>>2]=l;break ca}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{oa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);a[Rc>>0]=a[Rc>>0]&-5}c[Nc>>2]=0;c[Pc>>2]=0;c[Mc>>2]=0;oa=2756}if((oa|0)==2756){oa=0;i=c[Mc>>2]|0}l=pa+(C*40|0)+8|0;if(!(b[l>>1]&9216))b[l>>1]=1;else Bg(D);if(!q){if(!i){l=p;j=h;i=zf;oa=3892;break a}la=r+-1|0;ma=E;la=Rv(c[ma>>2]|0,c[ma+4>>2]|0,la|0,((la|0)<0)<<31>>31|0)|0;ma=L()|0;na=E;c[na>>2]=la;c[na+4>>2]=ma;wc(D,i,-1,1,90)|0}if((b[l>>1]&2)!=0?(a[pa+(C*40|0)+10>>0]|0)!=sd<<24>>24:0){Gg(D,sd)|0;l=m;q=pa;o=qa;i=K}else{l=m;q=pa;o=qa;i=K}break}case -108:{i=c[p+4>>2]|0;l=c[p+8>>2]|0;if((b[pa+(i*40|0)+8>>1]&16)==0?fh(pa+(i*40|0)|0)|0:0){l=p;j=h;i=zf;oa=3892;break a}t=c[pa+(i*40|0)+16>>2]|0;s=pa+(l*40|0)|0;r=c[s>>2]|0;s=c[s+4>>2]|0;q=t+24|0;l=b[q>>1]|0;if(l<<16>>16){na=t+16|0;i=c[na>>2]|0;b[q>>1]=l+-1<<16>>16;c[na>>2]=i+16;if(!i){l=m;q=pa;o=qa;i=K;break d}}else{o=c[t+4>>2]|0;da:do if(c[o+272>>2]|0)if(!(a[o+81>>0]|0))oa=2779;else{l=m;q=pa;o=qa;i=K;break d}else{do if((e[o+276>>1]|0)>=1016){l=o+300|0;i=c[l>>2]|0;if(i|0){c[l>>2]=c[i>>2];na=o+284|0;c[na>>2]=(c[na>>2]|0)+1;break da}l=o+296|0;i=c[l>>2]|0;if(!i){i=o+292|0;break}else{c[l>>2]=c[i>>2];na=o+284|0;c[na>>2]=(c[na>>2]|0)+1;break da}}else i=o+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1;oa=2779}while(0);if((oa|0)==2779){oa=0;i=Yd(o,1016,0)|0}if(!i){l=m;q=pa;o=qa;i=K;break d}c[i>>2]=c[t>>2];c[t>>2]=i;b[q>>1]=62;c[t+16>>2]=i+24;i=i+8|0}l=i;c[l>>2]=r;c[l+4>>2]=s;c[i+8>>2]=0;l=t+12|0;o=c[l>>2]|0;if(!o)c[t+8>>2]=i;else{na=o;ma=c[na+4>>2]|0;if(!((ma|0)<(s|0)|((ma|0)==(s|0)?(c[na>>2]|0)>>>0<r>>>0:0))){na=t+26|0;b[na>>1]=b[na>>1]&-2}c[o+8>>2]=i}c[l>>2]=i;l=m;q=pa;o=qa;i=K;break}case 41:{l=c[p+4>>2]|0;B=pa+(l*40|0)|0;C=pa+(l*40|0)+8|0;i=b[C>>1]|0;do if(i&16){D=c[pa+(l*40|0)+16>>2]|0;E=D+26|0;A=b[E>>1]|0;i=A&65535;if(!(i&2)){if(!(i&1)){z=D+8|0;i=c[z>>2]|0;ew(Hd|0,0,160)|0;if(!i)i=0;else{l=0;while(1){na=i+8|0;o=i;i=c[na>>2]|0;c[na>>2]=0;if(!l)l=Hd;else{y=0;x=Hd;while(1){q=rf;ea:while(1){w=l;t=c[w>>2]|0;w=c[w+4>>2]|0;while(1){s=o;r=c[s>>2]|0;s=c[s+4>>2]|0;if(!((w|0)>(s|0)|(w|0)==(s|0)&t>>>0>r>>>0))break;c[q+8>>2]=o;q=c[o+8>>2]|0;if(!q){q=o;break ea}else{na=o;o=q;q=na}}if((w|0)<(s|0)|(w|0)==(s|0)&t>>>0<r>>>0){c[q+8>>2]=l;q=l}l=c[l+8>>2]|0;if(!l){l=o;break}}c[q+8>>2]=l;o=c[Nb>>2]|0;c[x>>2]=0;y=y+1|0;q=Hd+(y<<2)|0;l=c[q>>2]|0;if(!l){l=q;break}else x=q}}c[l>>2]=o;l=c[Hd>>2]|0;if(!i){i=l;break}}}w=1;do{o=c[Hd+(w<<2)>>2]|0;if(o)if(!i)i=o;else{l=rf;fa:while(1){t=i;s=c[t>>2]|0;t=c[t+4>>2]|0;while(1){r=o;q=c[r>>2]|0;r=c[r+4>>2]|0;if(!((t|0)>(r|0)|(t|0)==(r|0)&s>>>0>q>>>0))break;c[l+8>>2]=o;l=c[o+8>>2]|0;if(!l){l=o;break fa}else{na=o;o=l;l=na}}if((t|0)<(r|0)|(t|0)==(r|0)&s>>>0<q>>>0){c[l+8>>2]=i;l=i}i=c[i+8>>2]|0;if(!i){i=o;break}}c[l+8>>2]=i;i=c[Mb>>2]|0}w=w+1|0}while((w|0)!=40);c[z>>2]=i}b[E>>1]=A|3}s=D+8|0;i=c[s>>2]|0;if(!i){i=b[C>>1]|0;break}w=i;t=c[w>>2]|0;w=c[w+4>>2]|0;na=c[i+8>>2]|0;c[s>>2]=na;if(!na){i=c[D>>2]|0;if(i|0){r=D+4|0;do{l=i;i=c[i>>2]|0;o=c[r>>2]|0;do if(!o)oa=2830;else{if(c[o+480>>2]|0){Vd(o,l);break}q=l;if((c[o+304>>2]|0)>>>0>q>>>0){oa=2830;break}if((c[o+308>>2]|0)>>>0<=q>>>0){oa=2830;break}na=o+300|0;c[l>>2]=c[na>>2];c[na>>2]=l}while(0);do if((oa|0)==2830){oa=0;if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0)}while((i|0)!=0)}c[D>>2]=0;b[D+24>>1]=0;c[s>>2]=0;c[D+12>>2]=0;c[D+20>>2]=0;b[E>>1]=1}l=c[p+12>>2]|0;i=pa+(l*40|0)|0;l=pa+(l*40|0)+8|0;if(!(b[l>>1]&9216)){o=i;c[o>>2]=t;c[o+4>>2]=w;b[l>>1]=4;l=m;o=pa;i=K;oa=21;break d}else{Ng(i,t,w);l=m;o=pa;i=K;oa=21;break d}}while(0);if(!(i&9216)){b[C>>1]=1;i=K;oa=20;break d}else{Bg(B);i=K;oa=20;break d}}case 42:{l=c[p+4>>2]|0;i=pa+((c[p+12>>2]|0)*40|0)|0;J=c[p+16>>2]|0;if((b[pa+(l*40|0)+8>>1]&16)==0?fh(pa+(l*40|0)|0)|0:0){l=p;j=h;i=zf;oa=3892;break a}I=pa+(l*40|0)+16|0;if(J){B=c[I>>2]|0;H=i;F=c[H>>2]|0;H=c[H+4>>2]|0;C=B+28|0;if((c[C>>2]|0)!=(J|0)){D=B+8|0;l=c[D>>2]|0;if(l|0){A=B+20|0;E=B+26|0;if(!(b[E>>1]&1)){ew(Hd|0,0,160)|0;z=l;l=0;do{na=z+8|0;o=z;z=c[na>>2]|0;c[na>>2]=0;if(!l)l=Hd;else{y=0;x=Hd;while(1){q=rf;ga:while(1){w=l;t=c[w>>2]|0;w=c[w+4>>2]|0;while(1){s=o;r=c[s>>2]|0;s=c[s+4>>2]|0;if(!((w|0)>(s|0)|(w|0)==(s|0)&t>>>0>r>>>0))break;c[q+8>>2]=o;q=c[o+8>>2]|0;if(!q){q=o;break ga}else{na=o;o=q;q=na}}if((w|0)<(s|0)|(w|0)==(s|0)&t>>>0<r>>>0){c[q+8>>2]=l;q=l}l=c[l+8>>2]|0;if(!l){l=o;break}}c[q+8>>2]=l;o=c[Ub>>2]|0;c[x>>2]=0;y=y+1|0;q=Hd+(y<<2)|0;l=c[q>>2]|0;if(!l){l=q;break}else x=q}}c[l>>2]=o;l=c[Hd>>2]|0}while((z|0)!=0);x=1;do{q=c[Hd+(x<<2)>>2]|0;do if(q){if(!l){l=q;break}o=rf;ha:while(1){w=l;t=c[w>>2]|0;w=c[w+4>>2]|0;while(1){s=q;r=c[s>>2]|0;s=c[s+4>>2]|0;if(!((w|0)>(s|0)|(w|0)==(s|0)&t>>>0>r>>>0))break;c[o+8>>2]=q;o=c[q+8>>2]|0;if(!o){o=q;break ha}else{na=q;q=o;o=na}}if((w|0)<(s|0)|(w|0)==(s|0)&t>>>0<r>>>0){c[o+8>>2]=l;o=l}l=c[l+8>>2]|0;if(!l){l=q;break}}c[o+8>>2]=l;l=c[ic>>2]|0}while(0);x=x+1|0}while((x|0)!=40)}o=c[A>>2]|0;ia:do if(!o){s=A;oa=2889}else{while(1){x=o+8|0;r=o+12|0;o=c[r>>2]|0;if(!o)break;ui(o,Hd,Td);c[r>>2]=0;o=rf;w=c[Hd>>2]|0;ja:do{t=w;s=c[t>>2]|0;t=c[t+4>>2]|0;while(1){r=l;q=c[r>>2]|0;r=c[r+4>>2]|0;if(!((t|0)>(r|0)|(t|0)==(r|0)&s>>>0>q>>>0))break;c[o+8>>2]=l;o=c[l+8>>2]|0;if(!o){o=l;l=w;break ja}else{na=l;l=o;o=na}}if((t|0)<(r|0)|(t|0)==(r|0)&s>>>0<q>>>0){c[o+8>>2]=w;o=w}w=c[w+8>>2]|0}while((w|0)!=0);c[o+8>>2]=l;l=c[cc>>2]|0;o=c[x>>2]|0;if(!o){s=x;oa=2889;break ia}}na=l+8|0;o=c[na>>2]|0;c[rf>>2]=o;c[na>>2]=0;c[l+12>>2]=0;if(!o){c[r>>2]=l;break}q=1;while(1){na=o+8|0;c[rf>>2]=c[na>>2];c[o+12>>2]=l;c[na>>2]=vi(rf,q)|0;l=c[rf>>2]|0;if(!l)break;else{na=o;q=q+1|0;o=l;l=na}}c[r>>2]=o}while(0);ka:do if((oa|0)==2889){oa=0;t=B+24|0;q=b[t>>1]|0;la:do if(q<<16>>16){na=B+16|0;o=c[na>>2]|0;b[t>>1]=q+-1<<16>>16;c[na>>2]=o+16;c[s>>2]=o;if(!o)break ka}else{r=c[B+4>>2]|0;ma:do if(c[r+272>>2]|0){if(!(a[r+81>>0]|0))oa=2900}else{do if((e[r+276>>1]|0)>=1016){q=r+300|0;o=c[q>>2]|0;if(o|0){c[q>>2]=c[o>>2];oa=r+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=2901;break ma}q=r+296|0;o=c[q>>2]|0;if(!o){o=r+292|0;break}else{c[q>>2]=c[o>>2];oa=r+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=2901;break ma}}else o=r+288|0;while(0);c[o>>2]=(c[o>>2]|0)+1;oa=2900}while(0);if((oa|0)==2900){o=Yd(r,1016,0)|0;oa=2901}do if((oa|0)==2901){oa=0;if(!o)break;c[o>>2]=c[B>>2];c[B>>2]=o;na=o+8|0;b[t>>1]=62;c[B+16>>2]=o+24;c[s>>2]=na;o=na;break la}while(0);c[s>>2]=0;break ka}while(0);na=o;c[na>>2]=0;c[na+4>>2]=0;c[o+8>>2]=0;na=l+8|0;q=c[na>>2]|0;c[rf>>2]=q;c[na>>2]=0;c[l+12>>2]=0;if(q){r=1;while(1){na=q+8|0;c[rf>>2]=c[na>>2];c[q+12>>2]=l;c[na>>2]=vi(rf,r)|0;l=c[rf>>2]|0;if(!l){l=q;break}else{na=q;r=r+1|0;q=l;l=na}}}c[o+12>>2]=l}while(0);c[D>>2]=0;c[B+12>>2]=0;b[E>>1]=b[E>>1]|1}c[C>>2]=J}l=c[B+20>>2]|0;if(l|0)do{o=c[l+12>>2]|0;if(o|0)do{r=o;q=c[r>>2]|0;r=c[r+4>>2]|0;if((r|0)<(H|0)|(r|0)==(H|0)&q>>>0<F>>>0)o=o+8|0;else{if(!((r|0)>(H|0)|(r|0)==(H|0)&q>>>0>F>>>0)){i=K;oa=28;break d}o=o+12|0}o=c[o>>2]|0}while((o|0)!=0);l=c[l+8>>2]|0}while((l|0)!=0);if((J|0)<=-1){l=m;q=pa;o=qa;i=K;break d}}t=c[I>>2]|0;s=i;r=c[s>>2]|0;s=c[s+4>>2]|0;q=t+24|0;l=b[q>>1]|0;if(l<<16>>16){na=t+16|0;i=c[na>>2]|0;b[q>>1]=l+-1<<16>>16;c[na>>2]=i+16;if(!i){l=m;q=pa;o=qa;i=K;break d}}else{o=c[t+4>>2]|0;na:do if(c[o+272>>2]|0)if(!(a[o+81>>0]|0))oa=2933;else{l=m;q=pa;o=qa;i=K;break d}else{do if((e[o+276>>1]|0)>=1016){l=o+300|0;i=c[l>>2]|0;if(i|0){c[l>>2]=c[i>>2];na=o+284|0;c[na>>2]=(c[na>>2]|0)+1;break na}l=o+296|0;i=c[l>>2]|0;if(!i){i=o+292|0;break}else{c[l>>2]=c[i>>2];na=o+284|0;c[na>>2]=(c[na>>2]|0)+1;break na}}else i=o+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1;oa=2933}while(0);if((oa|0)==2933){oa=0;i=Yd(o,1016,0)|0}if(!i){l=m;q=pa;o=qa;i=K;break d}c[i>>2]=c[t>>2];c[t>>2]=i;b[q>>1]=62;c[t+16>>2]=i+24;i=i+8|0}l=i;c[l>>2]=r;c[l+4>>2]=s;c[i+8>>2]=0;l=t+12|0;o=c[l>>2]|0;if(!o)c[t+8>>2]=i;else{na=o;ma=c[na+4>>2]|0;if(!((ma|0)<(s|0)|((ma|0)==(s|0)?(c[na>>2]|0)>>>0<r>>>0:0))){na=t+26|0;b[na>>1]=b[na>>1]&-2}c[o+8>>2]=i}c[l>>2]=i;l=m;q=pa;o=qa;i=K;break}case 45:{z=c[p+16>>2]|0;s=c[p+12>>2]|0;t=pa+(s*40|0)|0;if(b[p+2>>1]|0?(rd=c[z+20>>2]|0,od=c[nc>>2]|0,od|0):0){i=od;do{if((c[i+28>>2]|0)==(rd|0)){l=m;q=pa;o=qa;i=K;break d}i=c[i+4>>2]|0}while((i|0)!=0)}if((c[La>>2]|0)>=(c[Ma>>2]|0)){oa=2968;break c}o=pa+(s*40|0)+8|0;if(!(b[o>>1]&16)){q=z+12|0;r=c[q>>2]|0;w=r+(c[z+8>>2]|0)+((r|0)==0&1)|0;y=z+4|0;r=(r<<2)+80+(((c[y>>2]|0)+7|0)/8|0)+(w*40|0)|0;l=((r|0)<0)<<31>>31;do if(c[$c>>2]|0)if(!(a[zf>>0]|0))oa=2958;else{l=p;j=m;i=zf;oa=3898;break a}else{if(!(0<l>>>0|(0==(l|0)?(e[Xc>>1]|0)>>>0<r>>>0:0))){i=c[af>>2]|0;if(i|0){c[af>>2]=c[i>>2];c[ed>>2]=(c[ed>>2]|0)+1;x=i;break}i=c[dd>>2]|0;if(!i)i=fd;else{c[dd>>2]=c[i>>2];c[ed>>2]=(c[ed>>2]|0)+1;x=i;break}}else i=Zc;c[i>>2]=(c[i>>2]|0)+1;oa=2958}while(0);if((oa|0)==2958)x=Yd(Df,r,l)|0;if(!x){l=p;j=h;i=zf;oa=3892;break a}ew(x|0,0,r|0)|0;if(!((b[o>>1]&9216)==0?!(c[pa+(s*40|0)+24>>2]|0):0))Ag(t);b[o>>1]=1040;c[pa+(s*40|0)+16>>2]=x;c[pa+(s*40|0)+12>>2]=r;c[pa+(s*40|0)+36>>2]=93;c[x>>2]=f;c[x+60>>2]=w;r=c[q>>2]|0;c[x+64>>2]=r;c[x+48>>2]=(p-m|0)/20|0;c[x+16>>2]=c[xd>>2];c[x+56>>2]=c[va>>2];c[x+20>>2]=c[oc>>2];c[x+44>>2]=c[Ib>>2];c[x+8>>2]=c[le>>2];c[x+52>>2]=c[wb>>2];c[x+28>>2]=c[z+20>>2];m=x+80|0;l=m+(w*40|0)|0;if((l|0)==(m|0)){o=x;p=m;q=m;m=y;l=x;i=r}else{i=m;do{b[i+8>>1]=128;c[i+32>>2]=Df;i=i+40|0}while((i|0)!=(l|0));o=x;p=m;q=m;m=y;l=x;i=r}}else{l=c[pa+(s*40|0)+16>>2]|0;q=l+80|0;o=l;p=q;m=z+4|0;i=c[z+12>>2]|0}c[La>>2]=(c[La>>2]|0)+1;c[o+4>>2]=c[nc>>2];na=zb;pa=c[na+4>>2]|0;oa=o+32|0;c[oa>>2]=c[na>>2];c[oa+4>>2]=pa;c[o+68>>2]=c[rc>>2];c[o+72>>2]=c[(c[f>>2]|0)+100>>2];c[o+40>>2]=c[Hb>>2];c[Hb>>2]=0;c[rc>>2]=0;c[nc>>2]=l;c[xd>>2]=p;p=c[o+60>>2]|0;c[va>>2]=p;c[Ib>>2]=c[o+64>>2]&65535;p=q+(p*40|0)|0;c[oc>>2]=p;p=p+(i<<2)|0;c[o+24>>2]=p;ew(p|0,0,((c[m>>2]|0)+7|0)/8|0|0)|0;p=c[z>>2]|0;c[le>>2]=p;c[wb>>2]=c[m>>2];l=p;p=p+-20|0;o=q;i=K;oa=21;break}case -107:{na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216))b[l>>1]=4;else jh(i)|0;o=c[nc>>2]|0;l=c[o+16>>2]|0;o=(c[(c[o+8>>2]|0)+((c[o+48>>2]|0)*20|0)+4>>2]|0)+(c[p+4>>2]|0)|0;q=l+(o*40|0)|0;r=i+8|0;if(b[r>>1]&9216){kh(i,q,4096);l=m;q=pa;o=qa;i=K;break d};c[i>>2]=c[q>>2];c[i+4>>2]=c[q+4>>2];c[i+8>>2]=c[q+8>>2];c[i+12>>2]=c[q+12>>2];c[i+16>>2]=c[q+16>>2];if(!(b[l+(o*40|0)+8>>1]&2048)){b[r>>1]=b[r>>1]&-7169|4096;l=m;q=pa;o=qa;i=K}else{l=m;q=pa;o=qa;i=K}break}case -106:{if(!((c[Sc>>2]&524288|0)==0&0==0)){o=c[p+8>>2]|0;q=Na;o=Qv(c[q>>2]|0,c[q+4>>2]|0,o|0,((o|0)<0)<<31>>31|0)|0;q=L()|0;l=Na;c[l>>2]=o;c[l+4>>2]=q;l=m;q=pa;o=qa;i=K;break d}i=c[p+8>>2]|0;l=((i|0)<0)<<31>>31;if(!(c[p+4>>2]|0)){o=Oa;o=Qv(c[o>>2]|0,c[o+4>>2]|0,i|0,l|0)|0;q=L()|0;l=Oa;c[l>>2]=o;c[l+4>>2]=q;l=m;q=pa;o=qa;i=K;break d}else{o=Pa;o=Qv(c[o>>2]|0,c[o+4>>2]|0,i|0,l|0)|0;q=L()|0;l=Pa;c[l>>2]=o;c[l+4>>2]=q;l=m;q=pa;o=qa;i=K;break d}}case 46:if(!(c[p+4>>2]|0)){na=Oa;if(!((c[na>>2]|0)==0&(c[na+4>>2]|0)==0)){l=m;q=pa;o=qa;i=K;break d}na=Na;if((c[na>>2]|0)==0&(c[na+4>>2]|0)==0){i=K;oa=28;break d}else{l=m;q=pa;o=qa;i=K;break d}}else{na=Pa;if(!((c[na>>2]|0)==0&(c[na+4>>2]|0)==0)){l=m;q=pa;o=qa;i=K;break d}na=Na;if((c[na>>2]|0)==0&(c[na+4>>2]|0)==0){i=K;oa=28;break d}else{l=m;q=pa;o=qa;i=K;break d}}case -105:{i=c[nc>>2]|0;if(!i)l=pa;else{while(1){l=c[i+4>>2]|0;if(!l)break;else i=l}l=c[i+16>>2]|0}o=c[p+4>>2]|0;t=l+(o*40|0)|0;r=l+(o*40|0)+8|0;i=b[r>>1]|0;q=i&65535;do if(!(q&4)){if(q&8|0){l=Kg(+g[t>>3])|0;o=L()|0;break}if(!(q&18)){l=0;o=0}else{l=Lg(a[l+(o*40|0)+10>>0]|0,c[l+(o*40|0)+12>>2]|0,c[l+(o*40|0)+16>>2]|0)|0;o=L()|0;i=b[r>>1]|0}}else{o=t;l=c[o>>2]|0;o=c[o+4>>2]|0}while(0);s=t;c[s>>2]=l;c[s+4>>2]=o;b[r>>1]=i&15904|4;i=c[p+8>>2]|0;r=pa+(i*40|0)|0;s=pa+(i*40|0)+8|0;q=b[s>>1]|0;l=q&65535;do if(!(l&4)){if(l&8|0){l=Kg(+g[r>>3])|0;o=L()|0;i=q;break}if(!(l&18)){l=0;o=0;i=q}else{l=Lg(a[pa+(i*40|0)+10>>0]|0,c[pa+(i*40|0)+12>>2]|0,c[pa+(i*40|0)+16>>2]|0)|0;o=L()|0;i=b[s>>1]|0}}else{o=r;l=c[o>>2]|0;o=c[o+4>>2]|0;i=q}while(0);na=r;c[na>>2]=l;c[na+4>>2]=o;b[s>>1]=i&15904|4;na=t;ma=c[na+4>>2]|0;if((ma|0)<(o|0)|((ma|0)==(o|0)?(c[na>>2]|0)>>>0<l>>>0:0)){q=t;c[q>>2]=l;c[q+4>>2]=o;l=m;q=pa;o=qa;i=K}else{l=m;q=pa;o=qa;i=K}break}case 47:{i=pa+((c[p+4>>2]|0)*40|0)|0;o=i;l=c[o>>2]|0;o=c[o+4>>2]|0;if((o|0)>0|(o|0)==0&l>>>0>0){na=c[p+12>>2]|0;na=Rv(l|0,o|0,na|0,((na|0)<0)<<31>>31|0)|0;oa=L()|0;c[i>>2]=na;c[i+4>>2]=oa;i=K;oa=28}else{l=m;q=pa;o=qa;i=K}break}case -104:{o=c[p+4>>2]|0;q=c[p+12>>2]|0;na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216))b[l>>1]=4;else jh(i)|0;o=pa+(o*40|0)|0;l=c[o>>2]|0;o=c[o+4>>2]|0;if(!((o|0)<0|(o|0)==0&l>>>0<1)?(ud=pa+(q*40|0)|0,td=c[ud>>2]|0,ud=c[ud+4>>2]|0,na=(ud|0)>0|(ud|0)==0&td>>>0>0,td=na?td:0,ud=na?ud:0,na=Rv(-1,2147483647,l|0,o|0)|0,ma=L()|0,!(((ud|0)>-1|(ud|0)==-1&td>>>0>4294967295)&((ma|0)<(ud|0)|(ma|0)==(ud|0)&na>>>0<td>>>0))):0){o=Qv(td|0,ud|0,l|0,o|0)|0;q=L()|0;l=i;c[l>>2]=o;c[l+4>>2]=q;l=m;q=pa;o=qa;i=K;break d}l=i;c[l>>2]=-1;c[l+4>>2]=-1;l=m;q=pa;o=qa;i=K;break}case 48:{i=pa+((c[p+4>>2]|0)*40|0)|0;o=i;l=c[o>>2]|0;o=c[o+4>>2]|0;if(!((l|0)==0&(o|0)==0))if((o|0)>0|(o|0)==0&l>>>0>0){na=Qv(l|0,o|0,-1,-1)|0;oa=L()|0;c[i>>2]=na;c[i+4>>2]=oa;i=K;oa=28}else{i=K;oa=28}else{l=m;q=pa;o=qa;i=K}break}case 49:{i=pa+((c[p+4>>2]|0)*40|0)|0;na=i;ma=c[na>>2]|0;na=c[na+4>>2]|0;l=Qv(ma|0,na|0,-1,-1)|0;o=L()|0;if(!((ma|0)==0&(na|0)==-2147483648)?(na=i,c[na>>2]=l,c[na+4>>2]=o,(l|0)==0&(o|0)==0):0){i=K;oa=28}else{l=m;q=pa;o=qa;i=K}break}case -102:case -103:{o=b[p+2>>1]|0;q=o&65535;l=(q<<2)+68|0;do if(c[$c>>2]|0)if(!(a[zf>>0]|0))oa=3026;else{l=p;j=m;i=zf;oa=3898;break a}else{if(!(0<0|(0==0?(e[Xc>>1]|0)>>>0<l>>>0:0))){i=c[af>>2]|0;if(i|0){c[af>>2]=c[i>>2];c[ed>>2]=(c[ed>>2]|0)+1;break}i=c[dd>>2]|0;if(!i)i=fd;else{c[dd>>2]=c[i>>2];c[ed>>2]=(c[ed>>2]|0)+1;break}}else i=Zc;c[i>>2]=(c[i>>2]|0)+1;oa=3026}while(0);if((oa|0)==3026)i=Yd(Df,l,0)|0;if(!i){l=p;j=h;i=zf;oa=3892;break a}c[i+8>>2]=0;s=i+28+(q<<2)|0;c[i>>2]=s;b[s+8>>1]=1;c[s+32>>2]=Df;c[s+24>>2]=0;s=p+16|0;c[i+4>>2]=c[s>>2];c[i+16>>2]=(p-m|0)/20|0;c[i+12>>2]=f;a[i+24>>0]=0;c[i+20>>2]=0;a[i+25>>0]=o;a[p+1>>0]=-16;c[s>>2]=i;a[p>>0]=-101;s=i;oa=3029;break}case -101:{s=c[p+16>>2]|0;oa=3029;break}case -99:case -100:{o=c[p+4>>2]|0;r=pa+(o*40|0)|0;q=p+12|0;i=c[q>>2]|0;if(!i){l=c[p+16>>2]|0;c[Ra>>2]=0;c[Ra+4>>2]=0;c[Ra+8>>2]=0;c[Ra+12>>2]=0;c[Ra+16>>2]=0;ea=Hd;fa=ea+40|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));b[Sa>>1]=1;i=pa+(o*40|0)+32|0;c[Ta>>2]=c[i>>2];c[rf>>2]=Hd;c[Za>>2]=r;c[bb>>2]=l;_a[c[l+20>>2]&127](rf);do if((c[pa+(o*40|0)+24>>2]|0)>0){l=c[i>>2]|0;i=c[pa+(o*40|0)+20>>2]|0;if(l|0){if(c[l+480>>2]|0){Vd(l,i);break}na=i;if((c[l+304>>2]|0)>>>0<=na>>>0?(c[l+308>>2]|0)>>>0>na>>>0:0){na=l+300|0;c[i>>2]=c[na>>2];c[na>>2]=i;break}}if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{na=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);ea=r;l=Hd;fa=ea+40|0;do{c[ea>>2]=c[l>>2];ea=ea+4|0;l=l+4|0}while((ea|0)<(fa|0));o=r;l=c[sb>>2]|0}else{l=pa+(i*40|0)|0;o=c[p+16>>2]|0;c[rf>>2]=0;c[rf+4>>2]=0;c[rf+8>>2]=0;c[rf+12>>2]=0;c[rf+16>>2]=0;c[rf+20>>2]=0;c[rf+24>>2]=0;c[rf+28>>2]=0;i=pa+(i*40|0)+8|0;if(!(b[i>>1]&9216))b[i>>1]=1;else Bg(l);c[rf>>2]=l;c[tb>>2]=r;c[ub>>2]=o;_a[c[o+24>>2]&127](rf);o=pa+((c[q>>2]|0)*40|0)|0;l=c[vb>>2]|0}if(l|0){oa=3073;break c}l=o+8|0;i=b[l>>1]|0;if((i&2)!=0?(a[o+10>>0]|0)!=sd<<24>>24:0){Gg(o,sd)|0;i=b[l>>1]|0}l=i&65535;if(l&18){i=c[o+12>>2]|0;if(l&16384)i=(c[o>>2]|0)+i|0;if((i|0)>(c[(c[o+32>>2]|0)+108>>2]|0)){oa=3891;break c}else{l=m;q=pa;o=qa;i=0}}else{l=m;q=pa;o=qa;i=0}break}case 6:{c[rf>>2]=0;c[Tc>>2]=-1;c[Uc>>2]=-1;i=Ld(Df,c[p+4>>2]|0,c[p+8>>2]|0,Uc,Tc)|0;switch(i|0){case 0:{l=c[rf>>2]|0;break}case 5:{c[rf>>2]=1;l=1;break}default:{oa=3094;break c}}q=c[p+12>>2]|0;i=pa+(q*40|0)|0;o=((l|0)<0)<<31>>31;q=pa+(q*40|0)+8|0;if(!(b[q>>1]&9216)){na=i;c[na>>2]=l;c[na+4>>2]=o;b[q>>1]=4}else Ng(i,l,o);i=i+40|0;l=c[Uc>>2]|0;o=((l|0)<0)<<31>>31;q=i+8|0;if(!(b[q>>1]&9216)){na=i;c[na>>2]=l;c[na+4>>2]=o;b[q>>1]=4}else Ng(i,l,o);i=i+40|0;l=c[Tc>>2]|0;o=((l|0)<0)<<31>>31;q=i+8|0;if(!(b[q>>1]&9216)){na=i;c[na>>2]=l;c[na+4>>2]=o;b[q>>1]=4}else Ng(i,l,o);l=m;q=pa;o=qa;i=0;break}case 7:{na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216)){b[l>>1]=4;B=i}else{jh(i)|0;B=i}i=c[p+12>>2]|0;x=c[(c[vf>>2]|0)+(c[p+4>>2]<<4)+4>>2]|0;s=x+4|0;z=c[c[s>>2]>>2]|0;o=a[z+5>>0]|0;A=o&255;i=(i|0)==-1?A:i;if((d[z+16>>0]|0)<=2){if((c[c[z+64>>2]>>2]|0)!=0?(na=z+72|0,ma=c[na+4>>2]|0,(ma|0)>0|(ma|0)==0&(c[na>>2]|0)>>>0>0):0)oa=3101}else oa=3101;if((oa|0)==3101){oa=0;i=A}if(!(a[z+15>>0]|0))l=c[z+168>>2]|0;else l=59952;if((i|0)==5)if(((l|0)!=0?((Cu(l)|0)&1073741823|0)!=0:0)?(wd=c[c[z+60>>2]>>2]|0,(a[z+13>>0]|0)==0):0)if(!(a[z+4>>0]|0))if((c[wd>>2]|0)>1?(c[wd+52>>2]|0)!=0:0){y=5;oa=3111}else{l=A;i=K}else{y=5;oa=3111}else{l=A;i=K}else{y=i;oa=3111}oa:do if((oa|0)==3111){oa=0;if((y|0)!=(A|0)){i=o<<24>>24==5;w=(y|0)==5;if(i|w){if(!(a[gd>>0]|0)){oa=3115;break c}if((c[Ha>>2]|0)>1){oa=3115;break c}if(!i){if(o<<24>>24==4)hh(z,2)|0;if(K|0){l=y;i=K;break}}else{o=z+216|0;i=c[o>>2]|0;if(!i){c[rf>>2]=0;l=z+17|0;i=a[l>>0]|0;pa:do switch(i<<24>>24){case 0:case 5:{do if(!(a[z+13>>0]|0)){i=c[z+60>>2]|0;i=Va[c[(c[i>>2]|0)+28>>2]&255](i,1)|0;if(!i){i=a[l>>0]|0;break}else{l=y;break oa}}while(0);if(i<<24>>24==5)break pa;a[l>>0]=1;break}default:{}}while(0);i=c[z>>2]|0;i=Xa[c[i+32>>2]&127](i,c[z+220>>2]|0,0,rf)|0;if((i|0)==0&(c[rf>>2]|0)!=0)i=Sf(z)|0;if(i|0){l=y;break}i=c[o>>2]|0;if(i|0){r=l;oa=3130}}else{r=z+17|0;oa=3130}do if((oa|0)==3130){oa=0;switch(a[r>>0]|0){case 0:case 1:case 2:case 3:case 5:{q=z+13|0;do if(!(a[q>>0]|0)){l=z+60|0;i=c[l>>2]|0;i=Va[c[(c[i>>2]|0)+28>>2]&255](i,4)|0;if(!i){i=c[o>>2]|0;break}l=c[l>>2]|0;o=c[l>>2]|0;if(!o){l=y;break oa}if(!(a[q>>0]|0))Va[c[o+32>>2]&255](l,1)|0;if((a[r>>0]|0)==5){l=y;break oa}a[r>>0]=1;l=y;break oa}while(0);a[r>>0]=4;break}default:{}}i=Nf(i,Df,d[z+11>>0]|0,c[z+152>>2]|0,c[z+208>>2]|0)|0;c[o>>2]=0;if(!i)break;if(a[z+4>>0]|0){l=y;break oa}l=c[z+60>>2]|0;o=c[l>>2]|0;if(!o){l=y;break oa}if(!(a[z+13>>0]|0))Va[c[o+32>>2]&255](l,1)|0;if((a[r>>0]|0)==5){l=y;break oa}a[r>>0]=1;l=y;break oa}while(0);hh(z,y)|0}l=c[s>>2]|0;t=l+22|0;i=b[t>>1]|0;b[t>>1]=w?i&-33:i|32;i=Xb(x,0,0)|0;qa:do if(!i){l=l+12|0;r=c[(c[l>>2]|0)+56>>2]|0;s=r+18|0;na=a[s>>0]|0;q=w?2:1;if(na<<24>>24==q<<24>>24?(a[r+19>>0]|0)==na<<24>>24:0){i=0;break}i=Xb(x,2,0)|0;if(i|0)break;l=c[(c[l>>2]|0)+72>>2]|0;o=c[l+20>>2]|0;do if(!(b[l+28>>1]&4))oa=3159;else{if((c[o+24>>2]|0)>>>0<(c[l+24>>2]|0)>>>0){oa=3159;break}if(!(c[o+96>>2]|0))break;id=Te(l)|0;oa=3163}while(0);do if((oa|0)==3159){oa=0;i=c[o+40>>2]|0;if(i|0)break qa;if((c[o+148>>2]|0)>>>0>(c[o+152>>2]|0)>>>0){id=Uf(l)|0;oa=3163;break}else{id=Vf(l)|0;oa=3163;break}}while(0);if((oa|0)==3163?(oa=0,id|0):0){i=id;break}a[s>>0]=q;a[r+19>>0]=q;i=0}while(0);b[t>>1]=b[t>>1]&-33;l=y}else{l=y;i=K}}else{l=A;i=K}}while(0);o=(i|0)!=0;l=hh(z,o?A:l)|0;b[B+8>>1]=2562;if((l|0)==6){c[B+16>>2]=0;l=0}else{l=c[3664+(l<<2)>>2]|0;c[B+16>>2]=l;l=(Cu(l)|0)&1073741823}c[B+12>>2]=l;a[B+10>>0]=1;if(!hb)Gg(B,sd)|0;if(o){oa=3855;break c}else{l=m;q=pa;o=qa;i=0}break}case 8:{i=c[p+8>>2]|0;i=ih(mf,Df,c[p+4>>2]|0,(i|0)==0?0:pa+(i*40|0)|0)|0;if(!i){l=m;q=pa;o=qa;i=0}else{oa=3855;break c}break}case 59:{na=c[(c[vf>>2]|0)+(c[p+4>>2]<<4)+4>>2]|0;w=c[na+4>>2]|0;c[w+4>>2]=c[na>>2];if(a[w+17>>0]|0){x=w+44|0;t=c[x>>2]|0;y=w+12|0;r=c[(c[y>>2]|0)+56>>2]|0;r=d[r+37>>0]<<16|d[r+36>>0]<<24|d[r+38>>0]<<8|d[r+39>>0];l=((c[w+36>>2]|0)>>>0)/5|0;if(t>>>0<2){i=0;o=1073741824/((c[w+32>>2]|0)>>>0)|0;q=l+1|0}else{q=l+1|0;i=t+-2|0;i=i-((i>>>0)%(q>>>0)|0)|0;o=1073741824/((c[w+32>>2]|0)>>>0)|0;i=((i+1|0)==(o|0)?3:2)+i|0}s=t-r-(((l-t+r+i|0)>>>0)/(l>>>0)|0)|0;l=o+1|0;s=s+((l>>>0<t>>>0&s>>>0<l>>>0)<<31>>31)|0;while(1){if(s>>>0<2)i=0;else{i=s+-2|0;i=i-((i>>>0)%(q>>>0)|0)|0;i=((i+1|0)==(o|0)?3:2)+i|0}if((s|0)==(l|0)|(i|0)==(s|0))s=s+-1|0;else break}if(t>>>0<s>>>0){oa=3182;break c}if(r){l=w+8|0;i=c[l>>2]|0;if(i){i=Zf(i,0,0)|0;if(!i){i=c[l>>2]|0;if(!i)oa=3189;else{do{oa=i+1|0;a[oa>>0]=a[oa>>0]&-5;i=c[i+24>>2]|0}while((i|0)!=0);oa=3189}}}else oa=3189;if((oa|0)==3189){oa=0;i=Yf(w,s,t,0)|0;if(!i){l=c[(c[y>>2]|0)+72>>2]|0;o=c[l+20>>2]|0;if((b[l+28>>1]&4)!=0?(c[o+24>>2]|0)>>>0>=(c[l+24>>2]|0)>>>0:0)if(!(c[o+96>>2]|0))i=0;else i=Te(l)|0;else oa=3194;do if((oa|0)==3194){oa=0;i=c[o+40>>2]|0;if(!i)if((c[o+148>>2]|0)>>>0>(c[o+152>>2]|0)>>>0){i=Uf(l)|0;break}else{i=Vf(l)|0;break}}while(0);na=c[(c[y>>2]|0)+56>>2]|0;ma=c[x>>2]|0;a[na+28>>0]=ma>>>24;a[na+29>>0]=ma>>>16;a[na+30>>0]=ma>>>8;a[na+31>>0]=ma}}switch(i|0){case 101:{i=0;oa=28;break}case 0:{l=m;q=pa;o=qa;break}default:{oa=3855;break c}}}else{i=0;oa=28}}else{i=0;oa=28}break}case -98:{l=c[p+8>>2]|0;if(c[p+4>>2]|0){l=(d[wf>>0]|d[wf+1>>0]<<8)&-4|l+1&3;a[wf>>0]=l;a[wf+1>>0]=l>>8;l=m;q=pa;o=qa;i=K;break d}i=c[db>>2]|0;if(!i){l=m;q=pa;o=qa;i=K}else{l=l+1&3;do{na=i+149|0;ma=(d[na>>0]|d[na+1>>0]<<8)&-4|l;a[na>>0]=ma;a[na+1>>0]=ma>>8;i=c[i+8>>2]|0}while((i|0)!=0);l=m;q=pa;o=qa;i=K}break}case -97:{i=c[p+12>>2]|0;if((i&255|0)==0?!((c[Sc>>2]&1024|0)==0&0==0):0){l=m;q=pa;o=qa;i=K;break d}r=c[(c[vf>>2]|0)+(c[p+4>>2]<<4)+4>>2]|0;s=c[p+8>>2]|0;if(a[r+9>>0]|0){t=i+1&255;o=c[r+4>>2]|0;c[o+4>>2]=c[r>>2];if((c[o+76>>2]|0)!=(r|0)?b[o+22>>1]&64:0){oa=3236;break c}q=o+72|0;i=c[q>>2]|0;ra:do if(!i)oa=3222;else{l=i;do{if(((c[l>>2]|0)!=(r|0)?(c[l+4>>2]|0)==(s|0):0)?(a[l+8>>0]|0)!=t<<24>>24:0){oa=3215;break c}l=c[l+12>>2]|0}while((l|0)!=0);while(1){if((c[i+4>>2]|0)==(s|0)?(c[i>>2]|0)==(r|0):0)break ra;i=c[i+12>>2]|0;if(!i){oa=3222;break}}}while(0);if((oa|0)==3222){oa=0;if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](16)|0;if(!i){i=7;oa=3855;break c}}else{i=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;o=59064;l=c[o>>2]|0;o=c[o+4>>2]|0;if((o|0)>0|(o|0)==0&l>>>0>0){na=c[14978]|0;ma=Rv(l|0,o|0,i|0,((i|0)<0)<<31>>31|0)|0;la=L()|0;c[14768]=((la|0)<0|(la|0)==0&ma>>>0<=na>>>0)&1}i=Ua[c[29340>>2]&127](i)|0;if(!i){i=7;oa=3855;break c}l=Ua[c[29352>>2]&127](i)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}na=i+8|0;a[na>>0]=0;a[na+1>>0]=0;a[na+2>>0]=0;a[na+3>>0]=0;c[i+4>>2]=s;c[i>>2]=r;c[i+12>>2]=c[q>>2];c[q>>2]=i}i=i+8|0;if((d[i>>0]|0)<(t&255)){a[i>>0]=t;l=m;q=pa;o=qa;i=0}else{l=m;q=pa;o=qa;i=0}}else{l=m;q=pa;o=qa;i=0}break}case -96:{x=c[p+16>>2]|0;s=c[Vc>>2]|0;q=(s|0)>0;if(q?(c[eb>>2]|0)==0:0){i=6;oa=3268}else oa=3239;sa:do if((oa|0)==3239){oa=0;if(!x){l=m;q=pa;o=qa;i=0;break d}l=x+8|0;i=c[l>>2]|0;w=c[i>>2]|0;t=w+56|0;o=c[t>>2]|0;if(o){if(q){r=c[eb>>2]|0;q=0;do{if((c[r+(q<<2)>>2]|0)==(x|0)){i=0;oa=3268;break sa}q=q+1|0}while((q|0)<(s|0))}if(!((s|0)%5|0)){o=aw(s|0,((s|0)<0)<<31>>31|0,2)|0;o=Qv(o|0,L()|0,20,0)|0;q=L()|0;i=c[eb>>2]|0;ta:do if(!i){if(c[$c>>2]|0){if(a[zf>>0]|0){i=7;oa=3268;break sa}}else{do if(q>>>0>0|((q|0)==0?o>>>0>(e[Xc>>1]|0)>>>0:0))i=Zc;else{i=c[af>>2]|0;if(i|0){c[af>>2]=c[i>>2];c[ed>>2]=(c[ed>>2]|0)+1;oa=3261;break ta}i=c[dd>>2]|0;if(!i){i=fd;break}c[dd>>2]=c[i>>2];c[ed>>2]=(c[ed>>2]|0)+1;oa=3261;break ta}while(0);c[i>>2]=(c[i>>2]|0)+1}i=Yd(Df,o,q)|0;oa=3261}else{na=i;if((c[_e>>2]|0)>>>0<=na>>>0?(c[$e>>2]|0)>>>0>na>>>0:0){if(!(q>>>0>0|((q|0)==0?o>>>0>(e[Xc>>1]|0)>>>0:0))){o=s;break}i=Xd(Df,i,o,q)|0;oa=3261;break}i=Xd(Df,i,o,q)|0;oa=3261}while(0);if((oa|0)==3261){if(!i){i=7;oa=3268;break}o=c[Vc>>2]|0}o=i+(o<<2)|0;c[o>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;c[o+16>>2]=0;c[eb>>2]=i;o=c[t>>2]|0;i=c[l>>2]|0}i=Ua[o&127](i)|0;if(!i){i=(c[Gd>>2]|0)+(c[Fd>>2]|0)|0;na=c[eb>>2]|0;oa=c[Vc>>2]|0;c[Vc>>2]=oa+1;c[na+(oa<<2)>>2]=x;oa=x+12|0;c[oa>>2]=(c[oa>>2]|0)+1;if((i|0)!=0?(yd=c[w+80>>2]|0,(yd|0)!=0):0){c[x+20>>2]=i;i=Va[yd&255](c[l>>2]|0,i+-1|0)|0;oa=3270}else{i=0;oa=3270}}else oa=3268}else{i=0;oa=3270}}while(0);if((oa|0)==3268){oa=0;if(x){l=x+8|0;oa=3270}}if((oa|0)==3270){oa=0;t=(c[l>>2]|0)+8|0;if(c[t>>2]|0){q=c[f>>2]|0;l=c[mf>>2]|0;do if(l|0){if(q|0){if(c[q+480>>2]|0){Vd(q,l);break}na=l;if((c[q+304>>2]|0)>>>0<=na>>>0?(c[q+308>>2]|0)>>>0>na>>>0:0){na=q+300|0;c[l>>2]=c[na>>2];c[na>>2]=l;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);r=c[t>>2]|0;ua:do if(!r)l=0;else{s=(Cu(r)|0)+1|0;va:do if(!q){na=Qv(s|0,0,-1,-1)|0;ma=L()|0;if(ma>>>0>0|(ma|0)==0&na>>>0>2147483390){l=0;break ua}if(!(c[7324]|0)){l=Ua[c[29340>>2]&127](s)|0;oa=3306;break}l=Ua[c[29356>>2]&127](s)|0;if((c[14985]|0)>>>0<s>>>0)c[14985]=s;q=59064;o=c[q>>2]|0;q=c[q+4>>2]|0;if((q|0)>0|(q|0)==0&o>>>0>0){na=c[14978]|0;ma=Rv(o|0,q|0,l|0,((l|0)<0)<<31>>31|0)|0;la=L()|0;c[14768]=((la|0)<0|(la|0)==0&ma>>>0<=na>>>0)&1}l=Ua[c[29340>>2]&127](l)|0;if(!l){l=0;break ua}o=Ua[c[29352>>2]&127](l)|0;o=(c[14978]|0)+o|0;c[14978]=o;if(o>>>0>(c[14982]|0)>>>0)c[14982]=o;o=(c[14981]|0)+1|0;c[14981]=o;if(o>>>0<=(c[14987]|0)>>>0)break;c[14987]=o}else{if(c[q+272>>2]|0){if(a[q+81>>0]|0){l=0;break ua}}else{do if(!(0<0|(0==0?(e[q+276>>1]|0)>>>0<s>>>0:0))){o=q+300|0;l=c[o>>2]|0;if(l|0){c[o>>2]=c[l>>2];oa=q+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=3306;break va}o=q+296|0;l=c[o>>2]|0;if(!l){l=q+292|0;break}else{c[o>>2]=c[l>>2];oa=q+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=3306;break va}}else l=q+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1}l=Yd(q,s,0)|0;oa=3306}while(0);if((oa|0)==3306){oa=0;if(!l){l=0;break}}cw(l|0,r|0,s|0)|0}while(0);c[mf>>2]=l;l=c[t>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);c[t>>2]=0}}if(!i){l=m;q=pa;o=qa;i=0}else{oa=3855;break c}break}case -95:{ea=rf;fa=ea+40|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));c[Wc>>2]=Df;na=c[p+8>>2]|0;i=pa+(na*40|0)|0;c[rf>>2]=c[i>>2];c[rf+4>>2]=c[i+4>>2];c[rf+8>>2]=c[i+8>>2];c[rf+12>>2]=c[i+12>>2];c[rf+16>>2]=c[i+16>>2];i=b[sa>>1]&-1025;b[sa>>1]=i;i=i&65535;wa:do if((i&18|0)!=0?(b[pa+(na*40|0)+8>>1]&2048)==0:0){l=(i|4096)&65535;b[sa>>1]=l;do if(i&16384){i=(c[rf>>2]|0)+(c[Yb>>2]|0)|0;if((i|0)<1)if(!(l&16)){oa=3322;break}else i=1;if(Cg(rf,i,1)|0){i=7;break wa}ew((c[Ob>>2]|0)+(c[Yb>>2]|0)|0,0,c[rf>>2]|0)|0;c[Yb>>2]=(c[Yb>>2]|0)+(c[rf>>2]|0);i=b[sa>>1]&-16897;b[sa>>1]=i;if(!((c[Qb>>2]|0)!=0?(c[Ob>>2]|0)==(c[ec>>2]|0):0))oa=3322}else oa=3322;while(0);if((oa|0)==3322){oa=0;i=Hg(rf)|0;if(i|0)break;i=b[sa>>1]|0}b[sa>>1]=i&-4097;i=0}else i=0;while(0);l=b[sa>>1]|0;if(!((l&514)==514&(a[Jb>>0]|0)==1)){if(!(l&1)){l=Eg(rf,1)|0;oa=3329}}else{l=c[Ob>>2]|0;oa=3329}xa:do if((oa|0)==3329){oa=0;if(l){w=Qd(Df,l,c[(c[vf>>2]|0)+(c[p+4>>2]<<4)>>2]|0)|0;t=c[c[w+60>>2]>>2]|0;q=c[Pb>>2]|0;if(!q){l=Wb;i=Vb}else{l=a[t>>0]|0;if(!(l<<24>>24))i=0;else{i=0;o=t;do{o=o+1|0;i=G(i+(d[208+(l&255)>>0]|0)|0,-1640531535)|0;l=a[o>>0]|0}while(l<<24>>24!=0)}i=(i>>>0)%((c[dc>>2]|0)>>>0)|0;l=q+(i<<3)|0;i=q+(i<<3)+4|0}l=c[l>>2]|0;ya:do if(!l)i=59292;else{s=d[208+(d[t>>0]|0)>>0]|0;while(1){i=c[i>>2]|0;l=l+-1|0;q=c[i+12>>2]|0;na=a[q>>0]|0;o=(d[208+(na&255)>>0]|0)-s|0;if(!(na<<24>>24==0|(o|0)!=0)){r=t;do{q=q+1|0;r=r+1|0;na=a[q>>0]|0;o=(d[208+(na&255)>>0]|0)-(d[208+(d[r>>0]|0)>>0]|0)|0}while(!(na<<24>>24==0|(o|0)!=0))}if(!o)break ya;if(!l){i=59292;break}}}while(0);i=c[i+8>>2]|0;if((i|0?(zd=c[i>>2]|0,Ad=c[zd+4>>2]|0,Ad|0):0)?c[zd+20>>2]|0:0){i=yi(Df,w,i,Ad,mf)|0;if(i|0)break;s=w+64|0;i=c[s>>2]|0;if(!i){i=0;break}l=i;while(1){if((c[l>>2]|0)==(Df|0))break;l=c[l+24>>2]|0;if(!l){i=0;break xa}}l=c[Vc>>2]|0;if(!((l|0)%5|0)){q=aw(l|0,((l|0)<0)<<31>>31|0,2)|0;q=Qv(q|0,L()|0,20,0)|0;r=L()|0;i=c[eb>>2]|0;za:do if(!i){if(c[$c>>2]|0){if(a[zf>>0]|0){i=7;break xa}}else{do if(r>>>0>0|((r|0)==0?q>>>0>(e[Xc>>1]|0)>>>0:0))i=Zc;else{i=c[af>>2]|0;if(i|0){c[af>>2]=c[i>>2];c[ed>>2]=(c[ed>>2]|0)+1;oa=3367;break za}i=c[dd>>2]|0;if(!i){i=fd;break}c[dd>>2]=c[i>>2];c[ed>>2]=(c[ed>>2]|0)+1;oa=3367;break za}while(0);c[i>>2]=(c[i>>2]|0)+1}i=Yd(Df,q,r)|0;oa=3367}else{o=i;do if((c[_e>>2]|0)>>>0<=o>>>0){if((c[$e>>2]|0)>>>0<=o>>>0)break;if(!(r>>>0>0|((r|0)==0?q>>>0>(e[Xc>>1]|0)>>>0:0)))break za;i=Xd(Df,i,q,r)|0;oa=3367;break za}while(0);i=Xd(Df,i,q,r)|0;oa=3367}while(0);if((oa|0)==3367){oa=0;if(!i){i=7;break}l=c[Vc>>2]|0}na=i+(l<<2)|0;c[na>>2]=0;c[na+4>>2]=0;c[na+8>>2]=0;c[na+12>>2]=0;c[na+16>>2]=0;c[eb>>2]=i;i=c[s>>2]|0}Aa:do if(!i)i=0;else while(1){if((c[i>>2]|0)==(Df|0))break Aa;i=c[i+24>>2]|0;if(!i){i=0;break}}while(0);ma=c[eb>>2]|0;na=c[Vc>>2]|0;c[Vc>>2]=na+1;c[ma+(na<<2)>>2]=i;i=i+12|0;c[i>>2]=(c[i>>2]|0)+1;i=0;break}c[we>>2]=t;c[mf>>2]=bd(Df,36690,we)|0;i=1}}while(0);if(!((b[sa>>1]&9216)==0&(c[Qb>>2]|0)==0))Ag(rf);if(!i){l=m;q=pa;o=qa;i=0}else{oa=3855;break c}break}case -94:{i=(c[ad>>2]|0)+1|0;c[ad>>2]=i;l=Qd(Df,c[p+16>>2]|0,c[(c[vf>>2]|0)+(c[p+4>>2]<<4)>>2]|0)|0;do if(l|0?(Bd=l+64|0,Cd=c[Bd>>2]|0,Cd|0):0){l=Cd;do{if((c[(c[l+8>>2]|0)+4>>2]|0)>0){j=6;oa=3401;break c}l=c[l+24>>2]|0}while((l|0)!=0);c[Bd>>2]=0;r=Cd;l=0;while(1){o=c[r>>2]|0;q=r+24|0;i=r;r=c[q>>2]|0;if((o|0)==(Df|0)){c[Bd>>2]=i;c[q>>2]=0;o=i}else{o=o+360|0;c[q>>2]=c[o>>2];c[o>>2]=i;o=l}if(!r)break;else l=o}i=o+8|0;l=Ua[c[(c[c[o+4>>2]>>2]|0)+20>>2]&127](c[i>>2]|0)|0;if(l|0){oa=3400;break c}c[i>>2]=0;c[Bd>>2]=0;i=c[o>>2]|0;ma=o+12|0;na=(c[ma>>2]|0)+-1|0;c[ma>>2]=na;if(!na){if(i|0){if(c[i+480>>2]|0){Vd(i,o);break}na=o;if((c[i+304>>2]|0)>>>0<=na>>>0?(c[i+308>>2]|0)>>>0>na>>>0:0){na=i+300|0;c[o>>2]=c[na>>2];c[na>>2]=o;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](o);break}else{na=Ua[c[29352>>2]&127](o)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](o);break}}}while(0);c[ad>>2]=(c[ad>>2]|0)+-1;l=m;q=pa;o=qa;i=0;break}case -93:{c[rf>>2]=0;w=c[(c[p+16>>2]|0)+8>>2]|0;if(!w){i=6;oa=3458;break c}x=c[w>>2]|0;if(!x){i=6;oa=3458;break c}i=Va[c[x+24>>2]&255](w,rf)|0;t=w+8|0;if(c[t>>2]|0){q=c[f>>2]|0;l=c[mf>>2]|0;do if(l|0){if(q|0){if(c[q+480>>2]|0){Vd(q,l);break}na=l;if((c[q+304>>2]|0)>>>0<=na>>>0?(c[q+308>>2]|0)>>>0>na>>>0:0){na=q+300|0;c[l>>2]=c[na>>2];c[na>>2]=l;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);r=c[t>>2]|0;Ba:do if(!r)l=0;else{s=(Cu(r)|0)+1|0;Ca:do if(!q){na=Qv(s|0,0,-1,-1)|0;ma=L()|0;if(ma>>>0>0|(ma|0)==0&na>>>0>2147483390){l=0;break Ba}if(!(c[7324]|0)){l=Ua[c[29340>>2]&127](s)|0;oa=3440;break}l=Ua[c[29356>>2]&127](s)|0;if((c[14985]|0)>>>0<s>>>0)c[14985]=s;q=59064;o=c[q>>2]|0;q=c[q+4>>2]|0;if((q|0)>0|(q|0)==0&o>>>0>0){na=c[14978]|0;ma=Rv(o|0,q|0,l|0,((l|0)<0)<<31>>31|0)|0;la=L()|0;c[14768]=((la|0)<0|(la|0)==0&ma>>>0<=na>>>0)&1}l=Ua[c[29340>>2]&127](l)|0;if(!l){l=0;break Ba}o=Ua[c[29352>>2]&127](l)|0;o=(c[14978]|0)+o|0;c[14978]=o;if(o>>>0>(c[14982]|0)>>>0)c[14982]=o;o=(c[14981]|0)+1|0;c[14981]=o;if(o>>>0<=(c[14987]|0)>>>0)break;c[14987]=o}else{if(c[q+272>>2]|0){if(a[q+81>>0]|0){l=0;break Ba}}else{do if(!(0<0|(0==0?(e[q+276>>1]|0)>>>0<s>>>0:0))){o=q+300|0;l=c[o>>2]|0;if(l|0){c[o>>2]=c[l>>2];oa=q+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=3440;break Ca}o=q+296|0;l=c[o>>2]|0;if(!l){l=q+292|0;break}else{c[o>>2]=c[l>>2];oa=q+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=3440;break Ca}}else l=q+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1}l=Yd(q,s,0)|0;oa=3440}while(0);if((oa|0)==3440){oa=0;if(!l){l=0;break}}cw(l|0,r|0,s|0)|0}while(0);c[mf>>2]=l;l=c[t>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);c[t>>2]=0}if(i|0){oa=3458;break c}c[c[rf>>2]>>2]=w;o=c[p+4>>2]|0;i=c[xd>>2]|0;if((o|0)>0)i=i+(((c[va>>2]|0)-o|0)*40|0)|0;l=c[(c[oc>>2]|0)+(o<<2)>>2]|0;if(l|0){na=l+5|0;a[na>>0]=a[na>>0]&-2;rg(f,c[(c[oc>>2]|0)+(o<<2)>>2]|0);c[(c[oc>>2]|0)+(o<<2)>>2]=0}if((c[i+24>>2]|0)<96){if(Cg(i,96,0)|0){oa=3459;break c}i=c[i+16>>2]|0}else{na=c[i+20>>2]|0;c[i+16>>2]=na;i=i+8|0;b[i>>1]=b[i>>1]&13;i=na}c[(c[oc>>2]|0)+(o<<2)>>2]=i;ea=i;fa=ea+36|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));a[i>>0]=2;a[i+1>>0]=-1;b[i+56>>1]=0;c[i+72>>2]=i+88;if(!i){oa=3459;break c}c[i+40>>2]=c[rf>>2];l=w+4|0;c[l>>2]=(c[l>>2]|0)+1;l=m;q=pa;o=qa;i=0;break}case 9:{q=pa+((c[p+12>>2]|0)*40|0)|0;l=q+40|0;w=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;x=c[w+40>>2]|0;s=c[x>>2]|0;y=c[s>>2]|0;o=c[l>>2]|0;q=c[q>>2]|0;r=c[ta>>2]|0;if((o|0)>0){i=0;do{na=i;i=i+1|0;c[r+(na<<2)>>2]=l+(i*40|0)}while((i|0)!=(o|0))}i=Ya[c[y+32>>2]&127](x,q,c[p+16>>2]|0,o,r)|0;t=s+8|0;if(c[t>>2]|0){q=c[f>>2]|0;l=c[mf>>2]|0;do if(l|0){if(q|0){if(c[q+480>>2]|0){Vd(q,l);break}na=l;if((c[q+304>>2]|0)>>>0<=na>>>0?(c[q+308>>2]|0)>>>0>na>>>0:0){na=q+300|0;c[l>>2]=c[na>>2];c[na>>2]=l;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);r=c[t>>2]|0;Da:do if(!r)l=0;else{s=(Cu(r)|0)+1|0;Ea:do if(!q){na=Qv(s|0,0,-1,-1)|0;ma=L()|0;if(ma>>>0>0|(ma|0)==0&na>>>0>2147483390){l=0;break Da}if(!(c[7324]|0)){l=Ua[c[29340>>2]&127](s)|0;oa=3499;break}l=Ua[c[29356>>2]&127](s)|0;if((c[14985]|0)>>>0<s>>>0)c[14985]=s;q=59064;o=c[q>>2]|0;q=c[q+4>>2]|0;if((q|0)>0|(q|0)==0&o>>>0>0){na=c[14978]|0;ma=Rv(o|0,q|0,l|0,((l|0)<0)<<31>>31|0)|0;la=L()|0;c[14768]=((la|0)<0|(la|0)==0&ma>>>0<=na>>>0)&1}l=Ua[c[29340>>2]&127](l)|0;if(!l){l=0;break Da}o=Ua[c[29352>>2]&127](l)|0;o=(c[14978]|0)+o|0;c[14978]=o;if(o>>>0>(c[14982]|0)>>>0)c[14982]=o;o=(c[14981]|0)+1|0;c[14981]=o;if(o>>>0<=(c[14987]|0)>>>0)break;c[14987]=o}else{if(c[q+272>>2]|0){if(a[q+81>>0]|0){l=0;break Da}}else{do if(!(0<0|(0==0?(e[q+276>>1]|0)>>>0<s>>>0:0))){o=q+300|0;l=c[o>>2]|0;if(l|0){c[o>>2]=c[l>>2];oa=q+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=3499;break Ea}o=q+296|0;l=c[o>>2]|0;if(!l){l=q+292|0;break}else{c[o>>2]=c[l>>2];oa=q+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=3499;break Ea}}else l=q+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1}l=Yd(q,s,0)|0;oa=3499}while(0);if((oa|0)==3499){oa=0;if(!l){l=0;break}}cw(l|0,r|0,s|0)|0}while(0);c[mf>>2]=l;l=c[t>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);c[t>>2]=0}if(i|0){oa=3855;break c}na=Ua[c[y+40>>2]&127](x)|0;a[w+2>>0]=0;if(!na){l=m;q=pa;o=qa;i=0}else{i=0;oa=28}break}case -92:{i=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;x=c[p+12>>2]|0;y=pa+(x*40|0)|0;if(a[i+2>>0]|0){i=pa+(x*40|0)+8|0;if(!(b[i>>1]&9216))b[i>>1]=1;else Bg(y);l=m;q=pa;o=qa;i=K;break d}i=i+40|0;q=c[c[i>>2]>>2]|0;l=c[q>>2]|0;c[kc>>2]=0;c[kc+4>>2]=0;c[kc+8>>2]=0;c[kc+12>>2]=0;c[kc+16>>2]=0;c[kc+20>>2]=0;c[kc+24>>2]=0;c[rf>>2]=y;w=pa+(x*40|0)+8|0;o=b[w>>1]|0;if(!(b[p+2>>1]&1))b[w>>1]=o&15904|1;else{if(!(o&9216))b[w>>1]=1;else Bg(y);b[w>>1]=16385;c[y>>2]=0}i=Wa[c[l+44>>2]&127](c[i>>2]|0,rf,c[p+8>>2]|0)|0;t=q+8|0;if(c[t>>2]|0){q=c[f>>2]|0;l=c[mf>>2]|0;do if(l|0){if(q|0){if(c[q+480>>2]|0){Vd(q,l);break}na=l;if((c[q+304>>2]|0)>>>0<=na>>>0?(c[q+308>>2]|0)>>>0>na>>>0:0){na=q+300|0;c[l>>2]=c[na>>2];c[na>>2]=l;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);r=c[t>>2]|0;Fa:do if(!r)l=0;else{s=(Cu(r)|0)+1|0;Ga:do if(!q){na=Qv(s|0,0,-1,-1)|0;ma=L()|0;if(ma>>>0>0|(ma|0)==0&na>>>0>2147483390){l=0;break Fa}if(!(c[7324]|0)){l=Ua[c[29340>>2]&127](s)|0;oa=3554;break}l=Ua[c[29356>>2]&127](s)|0;if((c[14985]|0)>>>0<s>>>0)c[14985]=s;q=59064;o=c[q>>2]|0;q=c[q+4>>2]|0;if((q|0)>0|(q|0)==0&o>>>0>0){na=c[14978]|0;ma=Rv(o|0,q|0,l|0,((l|0)<0)<<31>>31|0)|0;la=L()|0;c[14768]=((la|0)<0|(la|0)==0&ma>>>0<=na>>>0)&1}l=Ua[c[29340>>2]&127](l)|0;if(!l){l=0;break Fa}o=Ua[c[29352>>2]&127](l)|0;o=(c[14978]|0)+o|0;c[14978]=o;if(o>>>0>(c[14982]|0)>>>0)c[14982]=o;o=(c[14981]|0)+1|0;c[14981]=o;if(o>>>0<=(c[14987]|0)>>>0)break;c[14987]=o}else{if(c[q+272>>2]|0){if(a[q+81>>0]|0){l=0;break Fa}}else{do if(!(0<0|(0==0?(e[q+276>>1]|0)>>>0<s>>>0:0))){o=q+300|0;l=c[o>>2]|0;if(l|0){c[o>>2]=c[l>>2];oa=q+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=3554;break Ga}o=q+296|0;l=c[o>>2]|0;if(!l){l=q+292|0;break}else{c[o>>2]=c[l>>2];oa=q+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=3554;break Ga}}else l=q+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1}l=Yd(q,s,0)|0;oa=3554}while(0);if((oa|0)==3554){oa=0;if(!l){l=0;break}}cw(l|0,r|0,s|0)|0}while(0);c[mf>>2]=l;l=c[t>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);c[t>>2]=0}if((c[Kb>>2]|0)>0){i=b[w>>1]|0;if((i&514)==514?(a[pa+(x*40|0)+10>>0]|0)==1:0)i=c[pa+(x*40|0)+16>>2]|0;else if(!(i&1))i=Eg(y,1)|0;else i=0;c[xe>>2]=i;yg(f,31408,xe);i=c[Kb>>2]|0}l=b[w>>1]|0;if((l&2)!=0?(a[pa+(x*40|0)+10>>0]|0)!=sd<<24>>24:0){Gg(y,sd)|0;l=b[w>>1]|0}o=l&65535;if(o&18){l=c[pa+(x*40|0)+12>>2]|0;if(o&16384)l=(c[y>>2]|0)+l|0;if((l|0)>(c[(c[pa+(x*40|0)+32>>2]|0)+108>>2]|0)){oa=3576;break c}else l=(i|0)==0?7:12}else l=(i|0)==0?7:12;switch(l&15){case 12:{oa=3855;break c}case 15:{oa=3891;break c}case 7:{l=m;q=pa;o=qa;break}default:{h=0;oa=3900;break c}}break}case 60:{i=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;if(!(a[i+2>>0]|0)){t=i+40|0;i=c[t>>2]|0;x=c[i>>2]|0;w=c[x>>2]|0;i=Ua[c[w+36>>2]&127](i)|0;x=x+8|0;if(c[x>>2]|0){q=c[f>>2]|0;l=c[mf>>2]|0;do if(l|0){if(q|0){if(c[q+480>>2]|0){Vd(q,l);break}na=l;if((c[q+304>>2]|0)>>>0<=na>>>0?(c[q+308>>2]|0)>>>0>na>>>0:0){na=q+300|0;c[l>>2]=c[na>>2];c[na>>2]=l;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);r=c[x>>2]|0;Ha:do if(!r)l=0;else{s=(Cu(r)|0)+1|0;Ia:do if(!q){na=Qv(s|0,0,-1,-1)|0;ma=L()|0;if(ma>>>0>0|(ma|0)==0&na>>>0>2147483390){l=0;break Ha}if(!(c[7324]|0)){l=Ua[c[29340>>2]&127](s)|0;oa=3616;break}l=Ua[c[29356>>2]&127](s)|0;if((c[14985]|0)>>>0<s>>>0)c[14985]=s;q=59064;o=c[q>>2]|0;q=c[q+4>>2]|0;if((q|0)>0|(q|0)==0&o>>>0>0){na=c[14978]|0;ma=Rv(o|0,q|0,l|0,((l|0)<0)<<31>>31|0)|0;la=L()|0;c[14768]=((la|0)<0|(la|0)==0&ma>>>0<=na>>>0)&1}l=Ua[c[29340>>2]&127](l)|0;if(!l){l=0;break Ha}o=Ua[c[29352>>2]&127](l)|0;o=(c[14978]|0)+o|0;c[14978]=o;if(o>>>0>(c[14982]|0)>>>0)c[14982]=o;o=(c[14981]|0)+1|0;c[14981]=o;if(o>>>0<=(c[14987]|0)>>>0)break;c[14987]=o}else{if(c[q+272>>2]|0){if(a[q+81>>0]|0){l=0;break Ha}}else{do if(!(0<0|(0==0?(e[q+276>>1]|0)>>>0<s>>>0:0))){o=q+300|0;l=c[o>>2]|0;if(l|0){c[o>>2]=c[l>>2];oa=q+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=3616;break Ia}o=q+296|0;l=c[o>>2]|0;if(!l){l=q+292|0;break}else{c[o>>2]=c[l>>2];oa=q+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=3616;break Ia}}else l=q+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1}l=Yd(q,s,0)|0;oa=3616}while(0);if((oa|0)==3616)if(!l){l=0;break}cw(l|0,r|0,s|0)|0}while(0);c[mf>>2]=l;l=c[x>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{oa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);c[x>>2]=0}if(i|0){oa=3855;break c}if(!(Ua[c[w+40>>2]&127](c[t>>2]|0)|0)){i=0;oa=20}else{l=m;o=pa;i=0;oa=21}}else{l=m;q=pa;o=qa;i=K}break}case -91:{i=Sc;o=c[i>>2]|0;i=c[i+4>>2]|0;q=Sc;c[q>>2]=o|67108864;c[q+4>>2]=i;q=c[(c[p+16>>2]|0)+8>>2]|0;i=c[p+4>>2]|0;l=pa+(i*40|0)|0;if((b[pa+(i*40|0)+8>>1]&2?(a[pa+(i*40|0)+10>>0]|0)!=1:0)?(Dd=Gg(l,1)|0,Dd|0):0){i=Dd;oa=3855;break c}i=Va[c[(c[q>>2]|0)+76>>2]&255](q,c[pa+(i*40|0)+16>>2]|0)|0;if((o&67108864|0)==0&0==0){la=Sc;ma=c[la+4>>2]|0;na=Sc;c[na>>2]=c[la>>2]&-67108865;c[na+4>>2]=ma}t=q+8|0;if(c[t>>2]|0){q=c[f>>2]|0;l=c[mf>>2]|0;do if(l|0){if(q|0){if(c[q+480>>2]|0){Vd(q,l);break}na=l;if((c[q+304>>2]|0)>>>0<=na>>>0?(c[q+308>>2]|0)>>>0>na>>>0:0){na=q+300|0;c[l>>2]=c[na>>2];c[na>>2]=l;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);r=c[t>>2]|0;Ja:do if(!r)l=0;else{s=(Cu(r)|0)+1|0;Ka:do if(!q){na=Qv(s|0,0,-1,-1)|0;ma=L()|0;if(ma>>>0>0|(ma|0)==0&na>>>0>2147483390){l=0;break Ja}if(!(c[7324]|0)){l=Ua[c[29340>>2]&127](s)|0;oa=3666;break}l=Ua[c[29356>>2]&127](s)|0;if((c[14985]|0)>>>0<s>>>0)c[14985]=s;q=59064;o=c[q>>2]|0;q=c[q+4>>2]|0;if((q|0)>0|(q|0)==0&o>>>0>0){na=c[14978]|0;ma=Rv(o|0,q|0,l|0,((l|0)<0)<<31>>31|0)|0;la=L()|0;c[14768]=((la|0)<0|(la|0)==0&ma>>>0<=na>>>0)&1}l=Ua[c[29340>>2]&127](l)|0;if(!l){l=0;break Ja}o=Ua[c[29352>>2]&127](l)|0;o=(c[14978]|0)+o|0;c[14978]=o;if(o>>>0>(c[14982]|0)>>>0)c[14982]=o;o=(c[14981]|0)+1|0;c[14981]=o;if(o>>>0<=(c[14987]|0)>>>0)break;c[14987]=o}else{if(c[q+272>>2]|0){if(a[q+81>>0]|0){l=0;break Ja}}else{do if(!(0<0|(0==0?(e[q+276>>1]|0)>>>0<s>>>0:0))){o=q+300|0;l=c[o>>2]|0;if(l|0){c[o>>2]=c[l>>2];oa=q+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=3666;break Ka}o=q+296|0;l=c[o>>2]|0;if(!l){l=q+292|0;break}else{c[o>>2]=c[l>>2];oa=q+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=3666;break Ka}}else l=q+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1}l=Yd(q,s,0)|0;oa=3666}while(0);if((oa|0)==3666){oa=0;if(!l){l=0;break}}cw(l|0,r|0,s|0)|0}while(0);c[mf>>2]=l;l=c[t>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{na=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);c[t>>2]=0}na=(d[wf>>0]|d[wf+1>>0]<<8)&-4;a[wf>>0]=na;a[wf+1>>0]=na>>8;if(!i){l=m;q=pa;o=qa;i=0}else{oa=3855;break c}break}case 10:{if(a[zf>>0]|0){i=2;j=K;break c}y=p+16|0;t=c[(c[y>>2]|0)+8>>2]|0;if(!t){i=12;j=6;break c}i=c[t>>2]|0;if(!i){i=12;j=6;break c}s=c[p+8>>2]|0;o=i+52|0;i=c[o>>2]|0;La:do if(i){r=a[Rb>>0]|0;q=c[ta>>2]|0;if((s|0)>0){i=pa+((c[p+12>>2]|0)*40|0)|0;l=0;while(1){c[q+(l<<2)>>2]=i;l=l+1|0;if((l|0)==(s|0))break;else i=i+40|0}i=c[o>>2]|0}w=p+2|0;a[Rb>>0]=b[w>>1];x=Xa[i&127](t,s,q,rf)|0;a[Rb>>0]=r;s=t+8|0;if(c[s>>2]|0){o=c[f>>2]|0;i=c[mf>>2]|0;Ma:do if(i|0){do if(o|0){if(c[o+480>>2]|0){Vd(o,i);break Ma}l=i;if((c[o+304>>2]|0)>>>0>l>>>0)break;if((c[o+308>>2]|0)>>>0<=l>>>0)break;na=o+300|0;c[i>>2]=c[na>>2];c[na>>2]=i;break Ma}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{na=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);q=c[s>>2]|0;Na:do if(!q)i=0;else{r=(Cu(q)|0)+1|0;Oa:do if(!o){na=Qv(r|0,0,-1,-1)|0;ma=L()|0;if(ma>>>0>0|(ma|0)==0&na>>>0>2147483390){i=0;break Na}if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](r)|0;oa=3718;break}i=Ua[c[29356>>2]&127](r)|0;if((c[14985]|0)>>>0<r>>>0)c[14985]=r;o=59064;l=c[o>>2]|0;o=c[o+4>>2]|0;if((o|0)>0|(o|0)==0&l>>>0>0){na=c[14978]|0;ma=Rv(l|0,o|0,i|0,((i|0)<0)<<31>>31|0)|0;la=L()|0;c[14768]=((la|0)<0|(la|0)==0&ma>>>0<=na>>>0)&1}i=Ua[c[29340>>2]&127](i)|0;if(!i){i=0;break Na}l=Ua[c[29352>>2]&127](i)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0<=(c[14987]|0)>>>0)break;c[14987]=l}else{if(c[o+272>>2]|0){if(a[o+81>>0]|0){i=0;break Na}}else{do if(!(0<0|(0==0?(e[o+276>>1]|0)>>>0<r>>>0:0))){l=o+300|0;i=c[l>>2]|0;if(i|0){c[l>>2]=c[i>>2];oa=o+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=3718;break Oa}l=o+296|0;i=c[l>>2]|0;if(!i){i=o+292|0;break}else{c[l>>2]=c[i>>2];oa=o+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=3718;break Oa}}else i=o+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1}i=Yd(o,r,0)|0;oa=3718}while(0);if((oa|0)==3718){oa=0;if(!i){i=0;break}}cw(i|0,q|0,r|0)|0}while(0);c[mf>>2]=i;i=c[s>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{na=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);c[s>>2]=0}if(!x){if(c[p+4>>2]|0){la=rf;ma=c[la+4>>2]|0;na=zb;c[na>>2]=c[la>>2];c[na+4>>2]=ma}c[rc>>2]=(c[rc>>2]|0)+1;i=0;break}else{if((x&255|0)!=19){oa=3733;break c}if(!(a[(c[y>>2]|0)+16>>0]|0)){oa=3733;break c}i=b[w>>1]|0;switch(i<<16>>16){case 5:{i=2;oa=3732;break c}case 4:{i=0;break La}default:{oa=3731;break c}}}}else i=K;while(0);l=m;q=pa;o=qa;break}case -90:{na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216))b[l>>1]=4;else jh(i)|0;l=i;c[l>>2]=c[(c[(c[(c[vf>>2]|0)+(c[p+4>>2]<<4)+4>>2]|0)+4>>2]|0)+44>>2];c[l+4>>2]=0;l=m;q=pa;o=qa;i=K;break}case -89:{na=c[xd>>2]|0;l=c[p+8>>2]|0;i=na+(l*40|0)|0;l=na+(l*40|0)+8|0;if(!(b[l>>1]&9216))b[l>>1]=4;else jh(i)|0;q=c[(c[vf>>2]|0)+(c[p+4>>2]<<4)+4>>2]|0;l=c[p+12>>2]|0;o=c[q+4>>2]|0;if(!l)l=0;else{na=c[o+44>>2]|0;l=na>>>0<l>>>0?l:na}c[o+4>>2]=c[q>>2];o=(c[o>>2]|0)+156|0;if((l|0)>0)c[o>>2]=l;else l=c[o>>2]|0;q=i;c[q>>2]=l;c[q+4>>2]=((l|0)<0)<<31>>31;l=m;q=pa;o=qa;i=K;break}case 63:case 62:{o=b[p+2>>1]|0;l=((o&65535)<<2)+28|0;do if(c[$c>>2]|0)if(!(a[zf>>0]|0))oa=3758;else{l=p;j=m;i=zf;oa=3898;break a}else{if(!(0<0|(0==0?(e[Xc>>1]|0)>>>0<l>>>0:0))){i=c[af>>2]|0;if(i|0){c[af>>2]=c[i>>2];c[ed>>2]=(c[ed>>2]|0)+1;break}i=c[dd>>2]|0;if(!i)i=fd;else{c[dd>>2]=c[i>>2];c[ed>>2]=(c[ed>>2]|0)+1;break}}else i=Zc;c[i>>2]=(c[i>>2]|0)+1;oa=3758}while(0);if((oa|0)==3758)i=Yd(Df,l,0)|0;if(!i){l=p;j=h;i=zf;oa=3892;break a}c[i>>2]=0;oa=p+16|0;c[i+4>>2]=c[oa>>2];c[i+16>>2]=(p-m|0)/20|0;c[i+12>>2]=f;c[i+20>>2]=0;a[i+25>>0]=o;a[p+1>>0]=-16;c[oa>>2]=i;a[p>>0]=(d[p>>0]|0)+2;oa=3761;break}case 65:case 64:{oa=3761;break}default:{l=m;q=pa;o=qa;i=K}}while(0);Pa:do if((oa|0)==34){oa=0;i=c[p+4>>2]|0;if(i|0){oa=39;break c}i=c[nc>>2]|0;if(!i){oa=38;break c}c[nc>>2]=c[i+4>>2];c[La>>2]=(c[La>>2]|0)+-1;m=c[rc>>2]|0;c[sc>>2]=m;c[tc>>2]=(c[tc>>2]|0)+m;i=qg(i)|0;m=c[le>>2]|0;if((c[p+8>>2]|0)==4)i=(c[m+(i*20|0)+8>>2]|0)+-1|0;l=m;q=c[xd>>2]|0;o=qa;p=m+(i*20|0)|0;i=K}else if((oa|0)==83){oa=0;na=c[xd>>2]|0;o=c[l>>2]|0;l=na+(o*40|0)|0;o=na+(o*40|0)+8|0;if(!(b[o>>1]&9216))b[o>>1]=4;else jh(l)|0;o=l+8|0;b[o>>1]=2562;c[l+16>>2]=c[p+16>>2];c[l+12>>2]=c[p+4>>2];a[l+10>>0]=sd;l=c[p+12>>2]|0;if((l|0)>0?(na=pa+(l*40|0)|0,(c[na+4>>2]|0)==0?(c[na>>2]|0)==(e[p+2>>1]|0):0):0){b[o>>1]=2576;l=m;q=pa;o=qa}else{l=m;q=pa;o=qa}}else if((oa|0)==1049){if(((d[wf>>0]|d[wf+1>>0]<<8)&3)==1){i=516;oa=3855;break c}w=c[p+8>>2]|0;A=c[p+12>>2]|0;i=c[vf>>2]|0;C=c[i+(A<<4)+4>>2]|0;l=p+2|0;q=b[l>>1]|0;if(z<<24>>24==109){o=(q&8|4)&65535;i=a[(c[i+(A<<4)+12>>2]|0)+76>>0]|0;if((i&255)<(d[pc>>0]|0)){a[pc>>0]=i;B=o}else B=o}else B=0;if(q&16){s=pa+(w*40|0)|0;t=pa+(w*40|0)+8|0;r=b[t>>1]|0;i=r&65535;do if(!(i&4)){if(i&8|0){o=Kg(+g[s>>3])|0;q=L()|0;i=r;break}if(!(i&18)){o=0;q=0;i=r}else{o=Lg(a[pa+(w*40|0)+10>>0]|0,c[pa+(w*40|0)+12>>2]|0,c[pa+(w*40|0)+16>>2]|0)|0;q=L()|0;i=b[t>>1]|0}}else{q=s;o=c[q>>2]|0;q=c[q+4>>2]|0;i=r}while(0);w=s;c[w>>2]=o;c[w+4>>2]=q;b[t>>1]=i&15904|4;w=o}z=p+1|0;switch(a[z>>0]|0){case -9:{y=c[p+16>>2]|0;x=e[y+8>>1]|0;break}case -3:{x=c[p+16>>2]|0;y=0;break}default:{x=0;y=0}}s=c[p+4>>2]|0;i=c[xd>>2]|0;if((s|0)>0)i=i+(((c[va>>2]|0)-s|0)*40|0)|0;o=x<<3;t=o+96|0;o=o+296|0;q=c[(c[oc>>2]|0)+(s<<2)>>2]|0;if(q|0){oa=q+5|0;a[oa>>0]=a[oa>>0]&-2;rg(f,c[(c[oc>>2]|0)+(s<<2)>>2]|0);c[(c[oc>>2]|0)+(s<<2)>>2]=0}if((c[i+24>>2]|0)<(o|0)){if(Cg(i,o,0)|0){l=p;j=h;i=zf;oa=3892;break a}o=i+16|0;r=o;o=c[o>>2]|0}else{o=c[i+20>>2]|0;r=i+16|0;c[r>>2]=o;oa=i+8|0;b[oa>>1]=b[oa>>1]&13}c[(c[oc>>2]|0)+(s<<2)>>2]=o;i=A&255;q=o+1|0;ea=o;fa=ea+36|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));a[q>>0]=i;b[o+56>>1]=x;c[o+72>>2]=o+88+(x<<2);oa=(c[r>>2]|0)+t|0;i=o+40|0;c[i>>2]=oa;c[oa>>2]=0;c[oa+4>>2]=0;c[oa+8>>2]=0;c[oa+12>>2]=0;c[oa+16>>2]=0;if(!o){l=p;j=h;i=zf;oa=3892;break a}a[o+2>>0]=1;oa=o+5|0;a[oa>>0]=a[oa>>0]|4;c[o+52>>2]=w;i=Tg(C,w,B,y,c[i>>2]|0)|0;c[o+44>>2]=y;a[o+4>>0]=(a[z>>0]|0)!=-9&1;oa=1074}else if((oa|0)==1216){oa=0;x=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;w=c[p+12>>2]|0;r=pa+(w*40|0)|0;i=c[p+16>>2]|0;if((i|0)>0){c[Hd>>2]=c[x+44>>2];b[Aa>>1]=i;c[Ba>>2]=r;s=0;r=Hd;i=z;q=0}else{o=pa+(w*40|0)+8|0;l=b[o>>1]|0;do if(l&16384){q=pa+(w*40|0)+12|0;i=(c[r>>2]|0)+(c[q>>2]|0)|0;if((i|0)<1)if(!(l&16))break;else i=1;if(Cg(r,i,1)|0){oa=1268;break c}ew((c[pa+(w*40|0)+16>>2]|0)+(c[q>>2]|0)|0,0,c[r>>2]|0)|0;c[q>>2]=(c[q>>2]|0)+(c[r>>2]|0);b[o>>1]=b[o>>1]&-16897}while(0);r=x+44|0;s=c[r>>2]|0;t=s+6|0;q=((e[t>>1]|0)*40|0)+56|0;o=c[s+12>>2]|0;Qa:do if(!o){if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](q)|0;oa=1246;break}o=Ua[c[29356>>2]&127](q)|0;if((c[14985]|0)>>>0<q>>>0)c[14985]=q;l=59064;i=c[l>>2]|0;l=c[l+4>>2]|0;if((l|0)>0|(l|0)==0&i>>>0>0){na=c[14978]|0;ma=Rv(i|0,l|0,o|0,((o|0)<0)<<31>>31|0)|0;la=L()|0;c[14768]=((la|0)<0|(la|0)==0&ma>>>0<=na>>>0)&1}l=Ua[c[29340>>2]&127](o)|0;if(!l){oa=1268;break c}i=Ua[c[29352>>2]&127](l)|0;i=(c[14978]|0)+i|0;c[14978]=i;if(i>>>0>(c[14982]|0)>>>0)c[14982]=i;i=(c[14981]|0)+1|0;c[14981]=i;if(i>>>0>(c[14987]|0)>>>0)c[14987]=i}else{if(c[o+272>>2]|0){if(a[o+81>>0]|0){oa=1268;break c}}else{do if(!(0<0|(0==0?(e[o+276>>1]|0)>>>0<q>>>0:0))){l=o+300|0;i=c[l>>2]|0;if(i|0){c[l>>2]=c[i>>2];oa=o+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=1246;break Qa}l=o+296|0;i=c[l>>2]|0;if(!i){i=o+292|0;break}else{c[l>>2]=c[i>>2];oa=o+284|0;c[oa>>2]=(c[oa>>2]|0)+1;oa=1246;break Qa}}else i=o+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1}i=Yd(o,q,0)|0;oa=1246}while(0);if((oa|0)==1246)if(!i){oa=1268;break c}else l=i;c[l+4>>2]=l+16;c[l>>2]=s;b[l+8>>1]=(e[t>>1]|0)+1;Yg(c[r>>2]|0,c[pa+(w*40|0)+12>>2]|0,c[pa+(w*40|0)+16>>2]|0,l);s=l;r=l;i=a[p>>0]|0;q=l}a[r+10>>0]=0;Ra:do if(i<<24>>24==27?(fe=b[r+8>>1]|0,fe<<16>>16!=0):0){l=c[r+4>>2]|0;o=fe&65535;i=0;while(1){if(b[l+(i*40|0)+8>>1]&1){o=1;break Ra}i=i+1|0;if(i>>>0>=o>>>0){o=0;break}}}else o=0;while(0);i=Vg(c[x+40>>2]|0,r,0,0,0,rf)|0;do if(s|0){if(c[Ze>>2]|0){Vd(Df,q);break}oa=q;if((c[_e>>2]|0)>>>0<=oa>>>0?(c[$e>>2]|0)>>>0>oa>>>0:0){c[q>>2]=c[af>>2];c[af>>2]=q;break}if(q|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](q);break}else{oa=Ua[c[29352>>2]&127](q)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](q);break}}while(0);if(i|0){oa=1270;break c}i=c[rf>>2]|0;c[x+32>>2]=i;l=(i|0)==0;a[x+2>>0]=(l^1)&1;a[x+3>>0]=0;c[x+28>>2]=0;if((a[p>>0]|0)==29)if(l)oa=1269;else oa=1267;else if(!(i|o))oa=1267;else oa=1269;if((oa|0)==1267){oa=0;l=m;q=pa;o=qa;i=0;break}else if((oa|0)==1269){i=0;oa=28;break}}else if((oa|0)==1287){oa=0;la=c[i>>2]|0;ma=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;i=c[ma+40>>2]|0;c[je>>2]=0;la=pa+(la*40|0)|0;ka=c[la>>2]|0;la=c[la+4>>2]|0;i=Vg(i,0,ka,la,0,je)|0;na=ma+64|0;c[na>>2]=ka;c[na+4>>2]=la;a[ma+2>>0]=0;c[ma+28>>2]=0;a[ma+3>>0]=0;na=c[je>>2]|0;c[ma+32>>2]=na;if(!na)if(!i){l=m;q=pa;o=qa;i=0;break}else{oa=3855;break c}else if(!(c[p+8>>2]|0)){oa=1289;break c}else{oa=28;break}}else if((oa|0)==1521){oa=0;na=c[(c[oc>>2]|0)+(c[p+4>>2]<<2)>>2]|0;c[$d>>2]=1;do if((a[na>>0]|0)==1){ma=c[na+40>>2]|0;if(!(a[ma+56>>0]|0)){i=ma+36|0;if(!(c[i>>2]|0)){c[$d>>2]=1;a[na+2>>0]=1;break}else{c[$d>>2]=0;i=Sh(ma+64|0,i)|0;oa=2142;break}}i=Th(ma)|0;if(i|0){oa=2145;break c}la=ma+59|0;R=0;ka=0;while(1){if(ka>>>0>=(d[la>>0]|0)>>>0){oa=2138;break}ha=ma+64+(ka*72|0)|0;c[rf>>2]=0;ia=ma+64+(ka*72|0)+28|0;i=c[ia>>2]|0;l=((i|0)<0)<<31>>31;if((i|0)>16){ga=0;o=16;q=0;while(1){o=aw(o|0,q|0,4)|0;q=L()|0;ja=ga+1|0;if(!((q|0)<(l|0)|(q|0)==(l|0)&o>>>0<i>>>0))break;else ga=ja}fa=Hd;c[fa>>2]=0;c[fa+4>>2]=0;if((i|0)>=17){i=c[7389]|0;if((i|0)!=0?(Ua[i&127](100)|0)!=0:0){S=0;U=0}else oa=1537;Sa:do if((oa|0)==1537){oa=0;do if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](976)|0;if(!i){S=0;U=0;break Sa}}else{i=Ua[c[29356>>2]&127](976)|0;if((c[14985]|0)>>>0<976)c[14985]=976;o=59064;l=c[o>>2]|0;o=c[o+4>>2]|0;if((o|0)>0|(o|0)==0&l>>>0>0){fa=c[14978]|0;ea=Rv(l|0,o|0,i|0,((i|0)<0)<<31>>31|0)|0;da=L()|0;c[14768]=((da|0)<0|(da|0)==0&ea>>>0<=fa>>>0)&1}i=Ua[c[29340>>2]&127](i)|0;if(!i){S=0;U=0;break Sa}l=Ua[c[29352>>2]&127](i)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0<=(c[14987]|0)>>>0)break;c[14987]=l}while(0);S=i+16|0;ew(S|0,0,960)|0;c[i>>2]=16;c[i+4>>2]=0;c[i+12>>2]=S;c[i+8>>2]=i+912;S=i;U=i}while(0);c[rf>>2]=U;fa=(U|0)==0;i=fa?7:0;l=c[ia>>2]|0;if((l|0)>0&(fa^1)){ba=(ga|0)==0;ca=ma+64+(ka*72|0)+8|0;da=ma+64+(ka*72|0)+64|0;o=0;aa=0;do{c[Td>>2]=0;i=l-aa|0;i=Zh(ha,(i|0)<16?i:16,Hd,Td)|0;do if(!i){$=o+1|0;Z=c[Td>>2]|0;i=c[7389]|0;if((i|0)!=0?(Ua[i&127](100)|0)!=0:0)oa=1566;else oa=1554;Ta:do if((oa|0)==1554){oa=0;do if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](64)|0;if(!i){oa=1566;break Ta}else l=i}else{i=Ua[c[29356>>2]&127](64)|0;if((c[14985]|0)>>>0<64)c[14985]=64;q=59064;l=c[q>>2]|0;q=c[q+4>>2]|0;if((q|0)>0|(q|0)==0&l>>>0>0){fa=c[14978]|0;ea=Rv(l|0,q|0,i|0,((i|0)<0)<<31>>31|0)|0;_=L()|0;c[14768]=((_|0)<0|(_|0)==0&ea>>>0<=fa>>>0)&1}l=Ua[c[29340>>2]&127](i)|0;if(!l){oa=1566;break Ta}i=Ua[c[29352>>2]&127](l)|0;i=(c[14978]|0)+i|0;c[14978]=i;if(i>>>0>(c[14982]|0)>>>0)c[14982]=i;i=(c[14981]|0)+1|0;c[14981]=i;if(i>>>0<=(c[14987]|0)>>>0)break;c[14987]=i}while(0);ea=l+8|0;fa=ea+56|0;do{a[ea>>0]=0;ea=ea+1|0}while((ea|0)<(fa|0));c[l+4>>2]=Z;c[l>>2]=ha;_=c[ca>>2]|0;Z=(c[_+8>>2]|0)+9|0;_=(c[_+4>>2]|0)/2|0;_=(Z|0)>(_|0)?Z:_;c[l+16>>2]=_;Z=da;_=Qv(c[Z>>2]|0,c[Z+4>>2]|0,_|0,((_|0)<0)<<31>>31|0)|0;Z=L()|0;i=da;c[i>>2]=_;c[i+4>>2]=Z;i=0;Z=l;_=l}while(0);do if((oa|0)==1566){oa=0;if(!Z){i=7;Z=0;_=0;break}if((c[Z>>2]|0)>0){X=Z+12|0;W=0;do{l=c[X>>2]|0;Y=l+(W*56|0)|0;i=c[l+(W*56|0)+28>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);i=c[l+(W*56|0)+36>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);P=c[l+(W*56|0)+48>>2]|0;do if(P|0){Q=c[P+4>>2]|0;do if(Q|0){if((c[Q>>2]|0)>0){T=Q+12|0;O=0;do{l=c[T>>2]|0;V=l+(O*56|0)|0;i=c[l+(O*56|0)+28>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);i=c[l+(O*56|0)+36>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);J=c[l+(O*56|0)+48>>2]|0;do if(J|0){K=c[J+4>>2]|0;do if(K|0){if((c[K>>2]|0)>0){M=K+12|0;I=0;do{l=c[M>>2]|0;N=l+(I*56|0)|0;i=c[l+(I*56|0)+28>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);i=c[l+(I*56|0)+36>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);D=c[l+(I*56|0)+48>>2]|0;do if(D|0){E=c[D+4>>2]|0;do if(E|0){if((c[E>>2]|0)>0){F=E+12|0;C=0;do{l=c[F>>2]|0;H=l+(C*56|0)|0;i=c[l+(C*56|0)+28>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);i=c[l+(C*56|0)+36>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);y=c[l+(C*56|0)+48>>2]|0;do if(y|0){z=c[y+4>>2]|0;do if(z|0){if((c[z>>2]|0)>0){A=z+12|0;x=0;do{l=c[A>>2]|0;B=l+(x*56|0)|0;i=c[l+(x*56|0)+28>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);i=c[l+(x*56|0)+36>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);s=c[l+(x*56|0)+48>>2]|0;do if(s|0){t=c[s+4>>2]|0;do if(t|0){if((c[t>>2]|0)>0){w=t+12|0;r=0;do{l=c[w>>2]|0;q=l+(r*56|0)|0;i=c[l+(r*56|0)+28>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);i=c[l+(r*56|0)+36>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);i=c[l+(r*56|0)+48>>2]|0;do if(i|0){vg(c[i+4>>2]|0);if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);ea=q;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));r=r+1|0}while((r|0)<(c[t>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](t);break}else{fa=Ua[c[29352>>2]&127](t)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](t);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](s);break}else{fa=Ua[c[29352>>2]&127](s)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](s);break}}while(0);ea=B;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));x=x+1|0}while((x|0)<(c[z>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](z);break}else{fa=Ua[c[29352>>2]&127](z)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](z);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](y);break}else{fa=Ua[c[29352>>2]&127](y)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](y);break}}while(0);ea=H;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));C=C+1|0}while((C|0)<(c[E>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](E);break}else{fa=Ua[c[29352>>2]&127](E)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](E);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](D);break}else{fa=Ua[c[29352>>2]&127](D)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](D);break}}while(0);ea=N;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));I=I+1|0}while((I|0)<(c[K>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](K);break}else{fa=Ua[c[29352>>2]&127](K)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](K);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](J);break}else{fa=Ua[c[29352>>2]&127](J)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](J);break}}while(0);ea=V;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));O=O+1|0}while((O|0)<(c[Q>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](Q);break}else{fa=Ua[c[29352>>2]&127](Q)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](Q);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](P);break}else{fa=Ua[c[29352>>2]&127](P)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](P);break}}while(0);ea=Y;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));W=W+1|0}while((W|0)<(c[Z>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](Z);i=7;Z=0;_=0;break}else{i=Ua[c[29352>>2]&127](Z)|0;c[14978]=(c[14978]|0)-i;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](Z);i=7;Z=0;_=0;break}}while(0);Ua:do if(ba){if(!i){i=U;oa=1830}}else{q=1;l=1;do{q=q<<4;l=l+1|0}while((l|0)!=(ja|0));if(i|0)break;i=U;w=1;Va:while(1){t=(c[i+12>>2]|0)+((((o|0)/(q|0)|0|0)%16|0)*56|0)+48|0;i=c[t>>2]|0;if(!i){i=c[7389]|0;if(i|0?Ua[i&127](100)|0:0){i=7;break Ua}do if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](976)|0;if(!i){i=7;break Ua}else l=i}else{i=Ua[c[29356>>2]&127](976)|0;if((c[14985]|0)>>>0<976)c[14985]=976;r=59064;l=c[r>>2]|0;r=c[r+4>>2]|0;if((r|0)>0|(r|0)==0&l>>>0>0){fa=c[14978]|0;ea=Rv(l|0,r|0,i|0,((i|0)<0)<<31>>31|0)|0;Y=L()|0;c[14768]=((Y|0)<0|(Y|0)==0&ea>>>0<=fa>>>0)&1}l=Ua[c[29340>>2]&127](i)|0;if(!l){i=7;break Ua}i=Ua[c[29352>>2]&127](l)|0;i=(c[14978]|0)+i|0;c[14978]=i;if(i>>>0>(c[14982]|0)>>>0)c[14982]=i;i=(c[14981]|0)+1|0;c[14981]=i;if(i>>>0<=(c[14987]|0)>>>0)break;c[14987]=i}while(0);i=l+16|0;ew(i|0,0,960)|0;Y=l+12|0;c[l>>2]=16;c[l+4>>2]=0;c[Y>>2]=i;c[l+8>>2]=l+912;i=c[7389]|0;if(i|0?Ua[i&127](100)|0:0){oa=1702;break}do if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](64)|0;if(!i){oa=1714;break Va}}else{i=Ua[c[29356>>2]&127](64)|0;if((c[14985]|0)>>>0<64)c[14985]=64;s=59064;r=c[s>>2]|0;s=c[s+4>>2]|0;if((s|0)>0|(s|0)==0&r>>>0>0){fa=c[14978]|0;ea=Rv(r|0,s|0,i|0,((i|0)<0)<<31>>31|0)|0;X=L()|0;c[14768]=((X|0)<0|(X|0)==0&ea>>>0<=fa>>>0)&1}i=Ua[c[29340>>2]&127](i)|0;if(!i){oa=1714;break Va}r=Ua[c[29352>>2]&127](i)|0;r=(c[14978]|0)+r|0;c[14978]=r;if(r>>>0>(c[14982]|0)>>>0)c[14982]=r;r=(c[14981]|0)+1|0;c[14981]=r;if(r>>>0<=(c[14987]|0)>>>0)break;c[14987]=r}while(0);ea=i+8|0;fa=ea+56|0;do{a[ea>>0]=0;ea=ea+1|0}while((ea|0)<(fa|0));c[t>>2]=i;c[i+4>>2]=l;c[i>>2]=ha;Y=c[ca>>2]|0;ea=(c[Y+8>>2]|0)+9|0;Y=(c[Y+4>>2]|0)/2|0;Y=(ea|0)>(Y|0)?ea:Y;c[i+16>>2]=Y;ea=da;Y=Qv(c[ea>>2]|0,c[ea+4>>2]|0,Y|0,((Y|0)<0)<<31>>31|0)|0;ea=L()|0;fa=da;c[fa>>2]=Y;c[fa+4>>2]=ea}i=c[i+4>>2]|0;if(w>>>0<ga>>>0){q=(q|0)/16|0;w=w+1|0}else{oa=1830;break Ua}}if((oa|0)==1702){oa=0;c[t>>2]=0}else if((oa|0)==1714){oa=0;c[t>>2]=0}if((c[l>>2]|0)>0){W=0;do{o=c[Y>>2]|0;X=o+(W*56|0)|0;i=c[o+(W*56|0)+28>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);i=c[o+(W*56|0)+36>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);P=c[o+(W*56|0)+48>>2]|0;do if(P|0){Q=c[P+4>>2]|0;do if(Q|0){if((c[Q>>2]|0)>0){T=Q+12|0;O=0;do{o=c[T>>2]|0;V=o+(O*56|0)|0;i=c[o+(O*56|0)+28>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);i=c[o+(O*56|0)+36>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);J=c[o+(O*56|0)+48>>2]|0;do if(J|0){K=c[J+4>>2]|0;do if(K|0){if((c[K>>2]|0)>0){M=K+12|0;I=0;do{o=c[M>>2]|0;N=o+(I*56|0)|0;i=c[o+(I*56|0)+28>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);i=c[o+(I*56|0)+36>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);D=c[o+(I*56|0)+48>>2]|0;do if(D|0){E=c[D+4>>2]|0;do if(E|0){if((c[E>>2]|0)>0){F=E+12|0;C=0;do{o=c[F>>2]|0;H=o+(C*56|0)|0;i=c[o+(C*56|0)+28>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);i=c[o+(C*56|0)+36>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);y=c[o+(C*56|0)+48>>2]|0;do if(y|0){z=c[y+4>>2]|0;do if(z|0){if((c[z>>2]|0)>0){A=z+12|0;x=0;do{o=c[A>>2]|0;B=o+(x*56|0)|0;i=c[o+(x*56|0)+28>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);i=c[o+(x*56|0)+36>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);s=c[o+(x*56|0)+48>>2]|0;do if(s|0){t=c[s+4>>2]|0;do if(t|0){if((c[t>>2]|0)>0){w=t+12|0;r=0;do{o=c[w>>2]|0;q=o+(r*56|0)|0;i=c[o+(r*56|0)+28>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);i=c[o+(r*56|0)+36>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);i=c[o+(r*56|0)+48>>2]|0;do if(i|0){vg(c[i+4>>2]|0);if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{fa=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);ea=q;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));r=r+1|0}while((r|0)<(c[t>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](t);break}else{fa=Ua[c[29352>>2]&127](t)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](t);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](s);break}else{fa=Ua[c[29352>>2]&127](s)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](s);break}}while(0);ea=B;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));x=x+1|0}while((x|0)<(c[z>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](z);break}else{fa=Ua[c[29352>>2]&127](z)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](z);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](y);break}else{fa=Ua[c[29352>>2]&127](y)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](y);break}}while(0);ea=H;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));C=C+1|0}while((C|0)<(c[E>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](E);break}else{fa=Ua[c[29352>>2]&127](E)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](E);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](D);break}else{fa=Ua[c[29352>>2]&127](D)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](D);break}}while(0);ea=N;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));I=I+1|0}while((I|0)<(c[K>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](K);break}else{fa=Ua[c[29352>>2]&127](K)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](K);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](J);break}else{fa=Ua[c[29352>>2]&127](J)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](J);break}}while(0);ea=V;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));O=O+1|0}while((O|0)<(c[Q>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](Q);break}else{fa=Ua[c[29352>>2]&127](Q)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](Q);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](P);break}else{fa=Ua[c[29352>>2]&127](P)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](P);break}}while(0);ea=X;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));W=W+1|0}while((W|0)<(c[l>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](l);i=7;break}else{i=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-i;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);i=7;break}}while(0);if((oa|0)==1830){oa=0;c[(c[i+12>>2]|0)+(((o|0)%16|0)*56|0)+48>>2]=_;o=$;i=0;break}if(!Z){o=$;break}X=c[Z+4>>2]|0;do if(X|0){if((c[X>>2]|0)>0){Y=X+12|0;W=0;do{o=c[Y>>2]|0;Z=o+(W*56|0)|0;l=c[o+(W*56|0)+28>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{fa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(W*56|0)+36>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{fa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);P=c[o+(W*56|0)+48>>2]|0;do if(P|0){Q=c[P+4>>2]|0;do if(Q|0){if((c[Q>>2]|0)>0){T=Q+12|0;O=0;do{o=c[T>>2]|0;V=o+(O*56|0)|0;l=c[o+(O*56|0)+28>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{fa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(O*56|0)+36>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{fa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);J=c[o+(O*56|0)+48>>2]|0;do if(J|0){K=c[J+4>>2]|0;do if(K|0){if((c[K>>2]|0)>0){M=K+12|0;I=0;do{o=c[M>>2]|0;N=o+(I*56|0)|0;l=c[o+(I*56|0)+28>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{fa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(I*56|0)+36>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{fa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);D=c[o+(I*56|0)+48>>2]|0;do if(D|0){E=c[D+4>>2]|0;do if(E|0){if((c[E>>2]|0)>0){F=E+12|0;C=0;do{o=c[F>>2]|0;H=o+(C*56|0)|0;l=c[o+(C*56|0)+28>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{fa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(C*56|0)+36>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{fa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);y=c[o+(C*56|0)+48>>2]|0;do if(y|0){z=c[y+4>>2]|0;do if(z|0){if((c[z>>2]|0)>0){A=z+12|0;x=0;do{o=c[A>>2]|0;B=o+(x*56|0)|0;l=c[o+(x*56|0)+28>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{fa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(x*56|0)+36>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{fa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);s=c[o+(x*56|0)+48>>2]|0;do if(s|0){t=c[s+4>>2]|0;do if(t|0){if((c[t>>2]|0)>0){w=t+12|0;r=0;do{o=c[w>>2]|0;q=o+(r*56|0)|0;l=c[o+(r*56|0)+28>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{fa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(r*56|0)+36>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{fa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);xg(c[o+(r*56|0)+48>>2]|0);ea=q;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));r=r+1|0}while((r|0)<(c[t>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](t);break}else{fa=Ua[c[29352>>2]&127](t)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](t);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](s);break}else{fa=Ua[c[29352>>2]&127](s)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](s);break}}while(0);ea=B;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));x=x+1|0}while((x|0)<(c[z>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](z);break}else{fa=Ua[c[29352>>2]&127](z)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](z);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](y);break}else{fa=Ua[c[29352>>2]&127](y)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](y);break}}while(0);ea=H;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));C=C+1|0}while((C|0)<(c[E>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](E);break}else{fa=Ua[c[29352>>2]&127](E)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](E);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](D);break}else{fa=Ua[c[29352>>2]&127](D)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](D);break}}while(0);ea=N;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));I=I+1|0}while((I|0)<(c[K>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](K);break}else{fa=Ua[c[29352>>2]&127](K)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](K);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](J);break}else{fa=Ua[c[29352>>2]&127](J)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](J);break}}while(0);ea=V;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));O=O+1|0}while((O|0)<(c[Q>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](Q);break}else{fa=Ua[c[29352>>2]&127](Q)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](Q);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](P);break}else{fa=Ua[c[29352>>2]&127](P)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](P);break}}while(0);ea=Z;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));W=W+1|0}while((W|0)<(c[X>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](X);break}else{fa=Ua[c[29352>>2]&127](X)|0;c[14978]=(c[14978]|0)-fa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](X);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](_);o=$;break}else{o=Ua[c[29352>>2]&127](_)|0;c[14978]=(c[14978]|0)-o;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](_);o=$;break}}while(0);aa=aa+16|0;l=c[ia>>2]|0}while((i|0)==0&(l|0)>(aa|0))}}else oa=1534}else{oa=Hd;c[oa>>2]=0;c[oa+4>>2]=0;oa=1534}if((oa|0)==1534){oa=0;i=Zh(ha,i,Hd,rf)|0;S=c[rf>>2]|0;U=S}T=(i|0)==0;do if(!T){if(U){if((c[U>>2]|0)>0){P=U+12|0;O=0;do{o=c[P>>2]|0;Q=o+(O*56|0)|0;l=c[o+(O*56|0)+28>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{ja=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(O*56|0)+36>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{ja=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);J=c[o+(O*56|0)+48>>2]|0;do if(J|0){K=c[J+4>>2]|0;do if(K|0){if((c[K>>2]|0)>0){M=K+12|0;I=0;do{o=c[M>>2]|0;N=o+(I*56|0)|0;l=c[o+(I*56|0)+28>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{ja=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(I*56|0)+36>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{ja=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);D=c[o+(I*56|0)+48>>2]|0;do if(D|0){E=c[D+4>>2]|0;do if(E|0){if((c[E>>2]|0)>0){F=E+12|0;C=0;do{o=c[F>>2]|0;H=o+(C*56|0)|0;l=c[o+(C*56|0)+28>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{ja=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(C*56|0)+36>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{ja=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);y=c[o+(C*56|0)+48>>2]|0;do if(y|0){z=c[y+4>>2]|0;do if(z|0){if((c[z>>2]|0)>0){A=z+12|0;x=0;do{o=c[A>>2]|0;B=o+(x*56|0)|0;l=c[o+(x*56|0)+28>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{ja=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(x*56|0)+36>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{ja=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);s=c[o+(x*56|0)+48>>2]|0;do if(s|0){t=c[s+4>>2]|0;do if(t|0){if((c[t>>2]|0)>0){w=t+12|0;r=0;do{o=c[w>>2]|0;q=o+(r*56|0)|0;l=c[o+(r*56|0)+28>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{ja=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(r*56|0)+36>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{ja=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(r*56|0)+48>>2]|0;do if(l|0){vg(c[l+4>>2]|0);if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{ja=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);ea=q;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));r=r+1|0}while((r|0)<(c[t>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](t);break}else{ja=Ua[c[29352>>2]&127](t)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](t);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](s);break}else{ja=Ua[c[29352>>2]&127](s)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](s);break}}while(0);ea=B;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));x=x+1|0}while((x|0)<(c[z>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](z);break}else{ja=Ua[c[29352>>2]&127](z)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](z);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](y);break}else{ja=Ua[c[29352>>2]&127](y)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](y);break}}while(0);ea=H;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));C=C+1|0}while((C|0)<(c[E>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](E);break}else{ja=Ua[c[29352>>2]&127](E)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](E);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](D);break}else{ja=Ua[c[29352>>2]&127](D)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](D);break}}while(0);ea=N;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));I=I+1|0}while((I|0)<(c[K>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](K);break}else{ja=Ua[c[29352>>2]&127](K)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](K);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](J);break}else{ja=Ua[c[29352>>2]&127](J)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](J);break}}while(0);ea=Q;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));O=O+1|0}while((O|0)<(c[U>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](S);break}else{ja=Ua[c[29352>>2]&127](S)|0;c[14978]=(c[14978]|0)-ja;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](S);break}}}else R=U;while(0);if(T)ka=ka+1|0;else{oa=2043;break}}do if((oa|0)==2043)if(R){if((c[R>>2]|0)>0){P=R+12|0;O=0;do{o=c[P>>2]|0;Q=o+(O*56|0)|0;l=c[o+(O*56|0)+28>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{oa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(O*56|0)+36>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{oa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);J=c[o+(O*56|0)+48>>2]|0;do if(J|0){K=c[J+4>>2]|0;do if(K|0){if((c[K>>2]|0)>0){M=K+12|0;I=0;do{o=c[M>>2]|0;N=o+(I*56|0)|0;l=c[o+(I*56|0)+28>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{oa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(I*56|0)+36>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{oa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);D=c[o+(I*56|0)+48>>2]|0;do if(D|0){E=c[D+4>>2]|0;do if(E|0){if((c[E>>2]|0)>0){F=E+12|0;C=0;do{o=c[F>>2]|0;H=o+(C*56|0)|0;l=c[o+(C*56|0)+28>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{oa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(C*56|0)+36>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{oa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);y=c[o+(C*56|0)+48>>2]|0;do if(y|0){z=c[y+4>>2]|0;do if(z|0){if((c[z>>2]|0)>0){A=z+12|0;x=0;do{o=c[A>>2]|0;B=o+(x*56|0)|0;l=c[o+(x*56|0)+28>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{oa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(x*56|0)+36>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{oa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);s=c[o+(x*56|0)+48>>2]|0;do if(s|0){t=c[s+4>>2]|0;do if(t|0){if((c[t>>2]|0)>0){w=t+12|0;r=0;do{o=c[w>>2]|0;q=o+(r*56|0)|0;l=c[o+(r*56|0)+28>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{oa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(r*56|0)+36>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{oa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);l=c[o+(r*56|0)+48>>2]|0;do if(l|0){vg(c[l+4>>2]|0);if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{oa=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);ea=q;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));r=r+1|0}while((r|0)<(c[t>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](t);break}else{oa=Ua[c[29352>>2]&127](t)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](t);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](s);break}else{oa=Ua[c[29352>>2]&127](s)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](s);break}}while(0);ea=B;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));x=x+1|0}while((x|0)<(c[z>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](z);break}else{oa=Ua[c[29352>>2]&127](z)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](z);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](y);break}else{oa=Ua[c[29352>>2]&127](y)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](y);break}}while(0);ea=H;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));C=C+1|0}while((C|0)<(c[E>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](E);break}else{oa=Ua[c[29352>>2]&127](E)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](E);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](D);break}else{oa=Ua[c[29352>>2]&127](D)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](D);break}}while(0);ea=N;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));I=I+1|0}while((I|0)<(c[K>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](K);break}else{oa=Ua[c[29352>>2]&127](K)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](K);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](J);break}else{oa=Ua[c[29352>>2]&127](J)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](J);break}}while(0);ea=Q;fa=ea+56|0;do{c[ea>>2]=0;ea=ea+4|0}while((ea|0)<(fa|0));O=O+1|0}while((O|0)<(c[R>>2]|0))}if(!(c[7324]|0)){_a[c[29344>>2]&127](R);oa=2139;break}else{oa=Ua[c[29352>>2]&127](R)|0;c[14978]=(c[14978]|0)-oa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](R);oa=2139;break}}else oa=2139;else if((oa|0)==2138){oa=0;i=Yh(ma+64|0,R)|0;c[ma+20>>2]=R;if(!i)i=0;else oa=2139}while(0);c[$d>>2]=0;oa=2142}else{i=ah(c[na+40>>2]|0,$d)|0;a[na+3>>0]=0;c[na+28>>2]=0;oa=2142}while(0);if((oa|0)==2142){oa=0;if(i|0){oa=2145;break c}ma=c[$d>>2]|0;a[na+2>>0]=ma;if(!ma){l=m;q=pa;o=qa;i=0;break}}i=0;oa=28}else if((oa|0)==2160){c[l+28>>2]=0;switch(i|0){case 0:{a[l+2>>0]=0;i=f+160+(e[p+2>>1]<<2)|0;c[i>>2]=(c[i>>2]|0)+1;i=0;oa=20;break Pa}case 101:{a[l+2>>0]=1;l=m;o=pa;i=0;oa=21;break Pa}default:{oa=3855;break c}}}else if((oa|0)==3029){oa=0;o=c[p+12>>2]|0;i=pa+(o*40|0)|0;l=s+8|0;if((c[l>>2]|0)!=(i|0)?(c[l>>2]=i,vd=a[s+25>>0]|0,vd<<24>>24):0){l=c[p+8>>2]|0;i=vd&255;do{na=i;i=i+-1|0;c[s+28+(i<<2)>>2]=pa+((i+l|0)*40|0)}while((na|0)>1)}i=pa+(o*40|0)+12|0;c[i>>2]=(c[i>>2]|0)+1;i=c[s+4>>2]|0;if(!(c[p+4>>2]|0))ab[c[i+16>>2]&255](s,d[s+25>>0]|0,s+28|0);else ab[c[i+28>>2]&255](s,d[s+25>>0]|0,s+28|0);r=s+20|0;i=c[r>>2]|0;if(i){if((i|0)>0){i=c[s>>2]|0;do if(i){l=b[i+8>>1]|0;if((l&514)==514?(a[i+10>>0]|0)==1:0){i=c[i+16>>2]|0;break}if(!(l&1))i=Eg(i,1)|0;else i=0}else i=0;while(0);c[Ye>>2]=i;yg(f,31408,Ye);i=c[r>>2]|0}else i=K;o=s+24|0;if(a[o>>0]|0){l=c[p+-16>>2]|0;do if(l|0){q=pa+(l*40|0)|0;l=pa+(l*40|0)+8|0;if(!(b[l>>1]&9216)){na=q;c[na>>2]=1;c[na+4>>2]=0;b[l>>1]=4;break}else{Ng(q,1,0);break}}while(0);a[o>>0]=0}o=c[s>>2]|0;l=o+8|0;if(!((b[l>>1]&9216)==0?(c[o+24>>2]|0)==0:0)){Ag(o);l=(c[s>>2]|0)+8|0}b[l>>1]=1;c[r>>2]=0;if(!i){l=m;q=pa;o=qa;i=0}else{oa=3855;break c}}else{l=m;q=pa;o=qa;i=K}}else if((oa|0)==3761){oa=0;q=c[p+16>>2]|0;y=c[p+12>>2]|0;x=pa+(y*40|0)|0;if((c[q>>2]|0)!=(x|0)){c[q>>2]=x;i=a[q+25>>0]|0;if(!(i<<24>>24))i=0;else{o=c[p+8>>2]|0;l=i&255;do{na=l;l=l+-1|0;c[q+28+(l<<2)>>2]=pa+((l+o|0)*40|0)}while((na|0)>1)}}else i=a[q+25>>0]|0;w=pa+(y*40|0)+8|0;b[w>>1]=b[w>>1]&15904|1;ab[c[(c[q+4>>2]|0)+16>>2]&255](q,i&255,q+28|0);t=q+20|0;i=c[t>>2]|0;if(i){if((i|0)>0){i=b[w>>1]|0;if((i&514)==514?(a[pa+(y*40|0)+10>>0]|0)==1:0)i=c[pa+(y*40|0)+16>>2]|0;else if(!(i&1))i=Eg(x,1)|0;else i=0;c[ye>>2]=i;yg(f,31408,ye);i=c[t>>2]|0}else i=K;r=c[q+16>>2]|0;s=c[p+4>>2]|0;o=c[Hb>>2]|0;Wa:do if(o|0){if((r|0)<0)while(1){l=c[o+12>>2]|0;if(l|0)_a[l&127](c[o+8>>2]|0);c[Hb>>2]=c[o+16>>2];Xa:do if(!(c[Ze>>2]|0)){l=o;do if((c[_e>>2]|0)>>>0<=l>>>0){if((c[$e>>2]|0)>>>0<=l>>>0)break;c[o>>2]=c[af>>2];c[af>>2]=o;break Xa}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](o);break}else{na=Ua[c[29352>>2]&127](o)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](o);break}}else Vd(Df,o);while(0);o=c[Hb>>2]|0;if(!o)break Wa}l=Hb;do{Ya:do if((c[o>>2]|0)==(r|0)?(Ed=c[o+4>>2]|0,(Ed|0)>-1):0){if((Ed|0)<=31?1<<Ed&s|0:0){oa=3803;break}q=c[o+12>>2]|0;if(q|0)_a[q&127](c[o+8>>2]|0);c[l>>2]=c[o+16>>2];if(c[Ze>>2]|0){Vd(Df,o);break}q=o;do if((c[_e>>2]|0)>>>0<=q>>>0){if((c[$e>>2]|0)>>>0<=q>>>0)break;c[o>>2]=c[af>>2];c[af>>2]=o;break Ya}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](o);break}else{na=Ua[c[29352>>2]&127](o)|0;c[14978]=(c[14978]|0)-na;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](o);break}}else oa=3803;while(0);if((oa|0)==3803){oa=0;l=o+16|0}o=c[l>>2]|0}while((o|0)!=0)}while(0);c[t>>2]=0;if(!i)i=0;else{oa=3855;break c}}else i=K;l=b[w>>1]|0;if(l&18){if((l&2)!=0?(a[pa+(y*40|0)+10>>0]|0)!=sd<<24>>24:0){Gg(x,sd)|0;l=b[w>>1]|0}o=l&65535;if(o&18){l=c[pa+(y*40|0)+12>>2]|0;if(o&16384)l=(c[x>>2]|0)+l|0;if((l|0)>(c[(c[pa+(y*40|0)+32>>2]|0)+108>>2]|0)){oa=3891;break c}else{l=m;q=pa;o=qa}}else{l=m;q=pa;o=qa}}else{l=m;q=pa;o=qa}}while(0);if((oa|0)==20){l=m;p=m+(((c[p+8>>2]|0)+-1|0)*20|0)|0;o=pa;oa=21}else if((oa|0)==28){oa=0;l=m;q=pa;o=qa;p=m+(((c[p+8>>2]|0)+-1|0)*20|0)|0}else if((oa|0)==1074){oa=0;a[(c[o+40>>2]|0)+3>>0]=b[l>>1]&3;if(!i){l=m;q=pa;o=qa;i=0}else{oa=3855;break}}Za:do if((oa|0)==21){oa=0;if(c[lc>>2]|0){j=n;i=zf;break b}if(n>>>0<h>>>0){q=o;o=qa}else while(1){m=c[Af>>2]|0;if(!m){q=o;o=qa;break Za}pa=c[fb>>2]|0;h=pa+h|0;if(Ua[m&127](c[gb>>2]|0)|0){oa=3844;break c}if(n>>>0<h>>>0){q=o;o=qa;break}}}while(0);m=l;p=p+20|0;K=i;qa=o;pa=q}switch(oa|0){case 38:{c[Cf>>2]=0;a[Jd>>0]=c[p+8>>2];c[xf>>2]=(p-m|0)/20|0;oa=44;break}case 39:{j=p+4|0;l=(p-m|0)/20|0;c[Cf>>2]=i;a[Jd>>0]=c[p+8>>2];c[xf>>2]=l;i=b[p+2>>1]|0;if(i<<16>>16){c[ff>>2]=c[3504+((i&65535)+-1<<2)>>2];yg(f,34155,ff);i=c[p+16>>2]|0;if(i|0){c[kf>>2]=c[mf>>2];c[kf+4>>2]=i;c[mf>>2]=bd(Df,34176,kf)|0}}else{c[gf>>2]=c[p+16>>2];yg(f,31408,gf)}oa=c[j>>2]|0;yf=c[hd>>2]|0;zf=c[mf>>2]|0;c[lf>>2]=l;c[lf+4>>2]=yf;c[lf+8>>2]=zf;Bb(oa,34183,lf);oa=44;break}case 153:{wf=Oa;vf=c[wf+4>>2]|0;if((vf|0)>0|(vf|0)==0&(c[wf>>2]|0)>>>0>0){c[Cf>>2]=787;a[Jd>>0]=2;yg(f,32436,Ae);o=k;q=h;h=1;i=zf;break a}if(c[(c[f>>2]|0)+456>>2]|0?c[bc>>2]|0:0)zg(f,1)|0;c[ua>>2]=(c[ua>>2]|0)+2|1;t=pa+((c[p+4>>2]|0)*40|0)|0;c[_c>>2]=t;r=p+8|0;if((c[r>>2]|0)>0){q=0;do{s=t+(q*40|0)|0;o=s+8|0;i=b[o>>1]|0;if(i&4096){j=i&65535;do if(j&18){do if(j&16384){l=s+12|0;j=(c[s>>2]|0)+(c[l>>2]|0)|0;if((j|0)<1)if(!(i&16))break;else i=1;else i=j;if(Cg(s,i,1)|0){l=p;j=h;i=zf;oa=3892;break a}ew((c[s+16>>2]|0)+(c[l>>2]|0)|0,0,c[s>>2]|0)|0;c[l>>2]=(c[l>>2]|0)+(c[s>>2]|0);i=b[o>>1]&-16897;b[o>>1]=i}while(0);if(c[s+24>>2]|0?(c[s+16>>2]|0)==(c[s+20>>2]|0):0)break;if(Hg(s)|0){l=p;j=h;i=zf;oa=3892;break a}i=b[o>>1]|0}while(0);i=i&-4097;b[o>>1]=i}if((i&514)==2)Hg(s)|0;q=q+1|0}while((q|0)<(c[r>>2]|0))}if(a[zf>>0]|0){l=p;j=m;i=zf;oa=3898;break a}if(a[qf>>0]&4)Xa[c[of>>2]&127](4,c[pf>>2]|0,f,0)|0;c[xf>>2]=((p-m|0)/20|0)+1;o=k;l=100;oa=3884;break a}case 518:{oa=3891;break}case 599:{c[Ce>>2]=32306;c[Ce+4>>2]=86318;c[Ce+8>>2]=31517;Bb(11,32001,Ce);i=11;oa=601;break}case 602:{l=p;j=h;i=zf;oa=3892;break a}case 717:{c[De>>2]=32306;c[De+4>>2]=68229;c[De+8>>2]=31517;Bb(11,32001,De);o=k;q=h;h=11;i=zf;break a}case 720:{c[Ee>>2]=32306;c[Ee+4>>2]=68229;c[Ee+8>>2]=31517;Bb(11,32001,Ee);o=k;q=h;h=11;i=zf;break a}case 730:{yg(f,34243,Fe);o=k;q=h;h=5;i=zf;break a}case 774:{c[Ge>>2]=A;yg(f,34294,Ge);o=k;q=h;h=1;i=zf;break a}case 776:{yg(f,34316,He);o=k;q=h;h=5;i=zf;break a}case 780:{c[Cf>>2]=787;a[Jd>>0]=2;yg(f,32436,Ie);o=k;l=1;oa=3884;break a}case 782:{c[xf>>2]=(p-m|0)/20|0;a[gd>>0]=0;c[Cf>>2]=5;o=k;l=5;oa=3884;break a}case 922:{j=c[p+4>>2]|0;i=c[p+8>>2]|0;if((j|0)==(d[gd>>0]|0)){yg(f,(j|0)==0?34425:(i|0)==0?34516:34473,ef);o=k;q=h;h=1;i=zf;break a}do if(!i){if(j|0?(c[cd>>2]|0)>0:0){yg(f,34370,cf);o=k;q=h;h=5;i=zf;break a}yf=c[f>>2]|0;zf=yf+464|0;yf=yf+472|0;zf=Qv(c[yf>>2]|0,c[yf+4>>2]|0,c[zf>>2]|0,c[zf+4>>2]|0)|0;yf=L()|0;if((yf|0)>0|(yf|0)==0&zf>>>0>0){c[Cf>>2]=787;a[Jd>>0]=2;yg(f,32436,df);o=k;l=1;oa=3884;break a}else{i=j&255;break}}else{pg(Df,516);i=1}while(0);a[gd>>0]=i;if((ng(f)|0)==5){c[xf>>2]=(p-m|0)/20|0;a[gd>>0]=1-j;c[Cf>>2]=5;o=k;l=5;oa=3884;break a}i=c[qd>>2]|0;if(i|0)do{c[qd>>2]=c[i+24>>2];do if(!(c[Ze>>2]|0)){zf=i;if((c[_e>>2]|0)>>>0<=zf>>>0?(c[$e>>2]|0)>>>0>zf>>>0:0){c[i>>2]=c[af>>2];c[af>>2]=i;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{zf=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-zf;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}else Vd(Df,i);while(0);i=c[qd>>2]|0}while((i|0)!=0);c[Gd>>2]=0;c[Fd>>2]=0;a[Id>>0]=0;o=k;l=(c[Cf>>2]|0)==0?101:1;oa=3884;break a}case 950:{if((l&255|0)==5){c[xf>>2]=(p-m|0)/20|0;c[Cf>>2]=l;o=k;oa=3884;break a}else oa=1017;break}case 986:{i=c[mf>>2]|0;do if(i|0){if(c[Ze>>2]|0){Vd(Df,i);break}yf=i;if((c[_e>>2]|0)>>>0<=yf>>>0?(c[$e>>2]|0)>>>0>yf>>>0:0){c[i>>2]=c[af>>2];c[af>>2]=i;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{yf=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-yf;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);do if(c[$c>>2]|0)if(!(a[zf>>0]|0))oa=1003;else i=0;else{if((e[Xc>>1]|0)>=28){i=c[af>>2]|0;if(i|0){c[af>>2]=c[i>>2];c[ed>>2]=(c[ed>>2]|0)+1;oa=1004;break}i=c[dd>>2]|0;if(!i)i=fd;else{c[dd>>2]=c[i>>2];c[ed>>2]=(c[ed>>2]|0)+1;oa=1004;break}}else i=Zc;c[i>>2]=(c[i>>2]|0)+1;oa=1003}while(0);if((oa|0)==1003){i=Yd(Df,28,0)|0;oa=1004}if((oa|0)==1004)if(!i)i=0;else{ea=i;l=34557;fa=ea+28|0;do{a[ea>>0]=a[l>>0]|0;ea=ea+1|0;l=l+1|0}while((ea|0)<(fa|0))}c[mf>>2]=i;j=c[vf>>2]|0;i=c[z>>2]|0;l=c[j+(i<<4)+12>>2]|0;_a:do if((c[l>>2]|0)!=(c[rf>>2]|0)){if((i|0)>-1){yf=l+78|0;b[yf>>1]=b[yf>>1]|8;yf=(c[j+28>>2]|0)+78|0;b[yf>>1]=b[yf>>1]|8;c[hf>>2]=c[hf>>2]&-17}if((c[jf>>2]|0)==0?(tf=c[sf>>2]|0,(tf|0)>0):0){i=0;l=tf;while(1){j=c[j+(i<<4)+12>>2]|0;if(!(b[j+78>>1]&8))j=l;else{bh(j);j=c[sf>>2]|0}i=i+1|0;if((i|0)>=(j|0))break _a;l=j;j=c[vf>>2]|0}}}while(0);l=(d[wf>>0]|d[wf+1>>0]<<8)&-4|1;a[wf>>0]=l;a[wf+1>>0]=l>>8;l=17;oa=1017;break}case 1135:{c[s+40>>2]=0;o=k;q=h;h=7;i=zf;break a}case 1213:{o=k;q=h;h=i;i=zf;break a}case 1268:{l=p;j=h;i=zf;oa=3892;break a}case 1270:{o=k;q=h;h=i;i=zf;break a}case 1289:{c[Je>>2]=32306;c[Je+4>>2]=87969;c[Je+8>>2]=31517;Bb(11,32001,Je);o=k;q=h;h=11;i=zf;break a}case 1328:{o=k;q=h;h=i;i=zf;break a}case 1345:{o=k;q=h;h=i;i=zf;break a}case 1382:{c[r>>2]=0;o=k;q=h;h=7;i=zf;break a}case 1481:{o=k;q=h;h=i;i=zf;break a}case 1492:{o=k;q=h;h=r;i=zf;break a}case 1519:{o=k;q=h;h=i;i=zf;break a}case 2145:{o=k;q=h;h=i;i=zf;break a}case 2221:{o=k;q=h;h=7;i=zf;break a}case 2226:{o=k;q=h;h=i;i=zf;break a}case 2253:{if(!((b[jb>>1]&9216)==0&(c[lb>>2]|0)==0))Ag(Hd);c[Ke>>2]=32306;c[Ke+4>>2]=81024;c[Ke+8>>2]=31517;Bb(11,32001,Ke);i=11;oa=2256;break}case 2267:{c[Le>>2]=32306;c[Le+4>>2]=81057;c[Le+8>>2]=31517;Bb(11,32001,Le);i=11;oa=2274;break}case 2280:{a[Jd>>0]=2;o=k;q=h;h=6;i=zf;break a}case 2282:{c[Me>>2]=32306;c[Me+4>>2]=72453;c[Me+8>>2]=31517;Bb(11,32001,Me);i=0;j=11;oa=2353;break}case 2286:{i=0;j=l;oa=2353;break}case 2301:{if(r){i=c[r+72>>2]|0;if(!(b[i+28>>1]&32)){Bf(i);i=0;oa=2353;break}else{oa=c[i+20>>2]|0;yf=oa+120|0;c[yf>>2]=(c[yf>>2]|0)+-1;oa=oa+136|0;c[i+16>>2]=c[oa>>2];c[oa>>2]=i;i=0;oa=2353;break}}else{i=0;oa=2353}break}case 2319:{i=0;j=l;oa=2353;break}case 2329:{i=0;j=l;oa=2353;break}case 2406:{o=k;q=h;h=l;i=zf;break a}case 2424:{Zb(Df);l=p;j=h;i=zf;oa=3892;break a}case 2425:{Zb(Df);o=k;q=h;h=i;i=zf;break a}case 2968:{yg(f,34663,Xe);o=k;q=h;h=1;i=zf;break a}case 3073:{do if(o){i=b[o+8>>1]|0;if((i&514)==514?(a[o+10>>0]|0)==1:0){i=c[o+16>>2]|0;break}if(!(i&1))i=Eg(o,1)|0;else i=0}else i=0;while(0);c[bf>>2]=i;yg(f,31408,bf);o=k;q=h;h=l;i=zf;break a}case 3094:{o=k;q=h;h=i;i=zf;break a}case 3115:{c[te>>2]=w?34752:34757;yg(f,34700,te);o=k;q=h;h=1;i=zf;break a}case 3182:{c[ue>>2]=32306;c[ue+4>>2]=67051;c[ue+8>>2]=31517;Bb(11,32001,ue);o=k;q=h;h=11;i=zf;break a}case 3215:{if(t<<24>>24==2){oa=o+22|0;b[oa>>1]=b[oa>>1]|128;oa=3236}else oa=3236;break}case 3400:{j=l;i=c[ad>>2]|0;oa=3401;break}case 3458:{o=k;q=h;h=i;i=zf;break a}case 3459:{Ua[c[x+28>>2]&127](c[rf>>2]|0)|0;l=p;j=h;i=zf;oa=3892;break a}case 3576:{oa=3891;break}case 3731:{i=i&65535;oa=3732;break}case 3733:{c[rc>>2]=(c[rc>>2]|0)+1;i=12;j=x;break}case 3844:{o=k;q=-1;m=l;h=9;i=zf;break a}case 3845:{o=k;q=h;h=i;i=zf;break a}case 3846:{o=k;q=h;h=i;i=zf;break a}case 3847:{o=k;q=h;h=i;i=zf;break a}case 3848:{o=k;q=h;h=i;i=zf;break a}case 3849:{o=k;q=h;h=i;i=zf;break a}case 3850:{o=k;q=h;h=i;i=zf;break a}case 3851:{o=k;q=h;h=i;i=zf;break a}case 3852:{o=k;q=h;h=i;i=zf;break a}case 3853:{o=k;q=h;h=i;i=zf;break a}case 3854:{o=k;q=h;h=r;i=zf;break a}case 3855:{o=k;q=h;h=i;i=zf;break a}case 3900:{Qa=Hf;return h|0}}switch(oa|0){case 44:if((ng(f)|0)==5){c[Cf>>2]=5;o=k;l=5;oa=3884;break a}else{o=k;l=(c[Cf>>2]|0)==0?101:1;oa=3884;break a}case 601:{o=k;q=h;h=i;i=zf;break a}case 1017:{o=k;q=h;h=l;i=zf;break a}case 2256:{o=k;q=h;h=i;i=zf;break a}case 2274:{o=k;q=h;h=i;i=zf;break a}case 2353:{b[B>>1]=4;o=A;c[o>>2]=i;c[o+4>>2]=((i|0)<0)<<31>>31;o=k;q=h;h=j;i=zf;break a}case 3236:{c[ve>>2]=c[p+16>>2];yg(f,34764,ve);o=k;q=h;h=262;i=zf;break a}case 3401:{c[ad>>2]=i+-1;o=k;q=h;h=j;i=zf;break a}case 3732:{a[Jd>>0]=i;i=12;j=x;break}case 3891:{yg(f,31223,Be);o=k;q=h;h=18;i=zf;break a}}switch(i&15){case 12:{o=k;q=h;h=j;i=zf;break a}case 2:{l=p;j=h;i=zf;oa=3892;break a}default:h=0}Qa=Hf;return h|0}else{p=q;j=0;k=0;l=q;i=Df+81|0}while(0);zf=(a[i>>0]|0)==0?9:7;c[Cf>>2]=zf;c[nf>>2]=c[22960+(zf<<2)>>2];yg(f,31408,nf);n=j;o=k;q=h;m=l;h=zf}while(0);if((oa|0)==3892)if((a[i>>0]|0)==0?(a[Df+82>>0]|0)==0:0){a[i>>0]=1;if((c[Df+180>>2]|0)>0)c[Df+264>>2]=1;h=Df+272|0;c[h>>2]=(c[h>>2]|0)+1;h=c[Df+236>>2]|0;if(h){c[h+12>>2]=7;h=j;j=m;oa=3898}else{h=j;j=m;oa=3898}}else{h=j;j=m;oa=3898}if((oa|0)==3898){yg(f,34831,yf);o=k;q=h;m=j;p=l;h=7}$a:while(1){if((oa|0)==3884){if(n>>>0<h>>>0)break;j=Df+328|0;k=Df+324|0;while(1){i=c[Af>>2]|0;if(!i)break $a;zf=c[j>>2]|0;h=zf+h|0;if(Ua[i&127](c[k>>2]|0)|0)break;if(n>>>0<h>>>0)break $a}q=-1;h=9;i=Df+81|0}k=(a[i>>0]|0)==0?h:7;j=f+124|0;if((c[j>>2]|0)==0&(k|0)!=3082){switch(k|0){case 516:{h=50738;break}case 100:{h=50760;break}case 101:{h=50782;break}default:{h=k&255;if(h>>>0<29?(520028155>>>h&1|0)!=0:0)h=c[22960+(h<<2)>>2]|0;else h=50724}}c[Ef>>2]=h;yg(f,31408,Ef)}c[Cf>>2]=k;if((k|0)==3082){yf=c[f+188>>2]|0;zf=c[j>>2]|0;c[Gf>>2]=(p-m|0)/20|0;c[Gf+4>>2]=yf;c[Gf+8>>2]=zf;Bb(3082,34799,Gf);ng(f)|0;if((a[i>>0]|0)==0?(a[Df+82>>0]|0)==0:0){a[i>>0]=1;if((c[Df+180>>2]|0)>0)c[Df+264>>2]=1;h=Df+272|0;c[h>>2]=(c[h>>2]|0)+1;h=c[Df+236>>2]|0;if(h|0)c[h+12>>2]=7}}else{if((k&251|4|0)==14){h=c[Df>>2]|0;i=c[h+68>>2]|0;if(!i)h=0;else h=Wa[i&127](h,0,0)|0;c[Df+72>>2]=h}yf=c[f+188>>2]|0;zf=c[j>>2]|0;c[Ff>>2]=(p-m|0)/20|0;c[Ff+4>>2]=yf;c[Ff+8>>2]=zf;Bb(k,34799,Ff);ng(f)|0}if(!(o<<24>>24)){o=0;h=q;l=1;oa=3884;continue}k=Df+16|0;i=c[k>>2]|0;zf=(c[i+((o&255)+-1<<4)+12>>2]|0)+78|0;b[zf>>1]=b[zf>>1]|8;zf=(c[i+28>>2]|0)+78|0;b[zf>>1]=b[zf>>1]|8;zf=Df+24|0;c[zf>>2]=c[zf>>2]&-17;if(c[Df+56>>2]|0){h=q;l=1;oa=3884;continue}l=Df+20|0;j=c[l>>2]|0;if((j|0)<=0){h=q;l=1;oa=3884;continue}h=0;while(1){i=c[i+(h<<4)+12>>2]|0;if(b[i+78>>1]&8){bh(i);j=c[l>>2]|0}h=h+1|0;if((h|0)>=(j|0)){h=q;l=1;oa=3884;continue $a}i=c[k>>2]|0}}Gf=f+176|0;c[Gf>>2]=(c[Gf>>2]|0)+n;Gf=l;Qa=Hf;return Gf|0}
function Zi(f,g,h,i,j){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,H=0,I=0,J=0,K=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Ra=0,Sa=0,Ta=0,Va=0,Wa=0,Xa=0,Ya=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0,lb=0,mb=0,nb=0,ob=0,pb=0,qb=0,rb=0,sb=0,tb=0,ub=0,vb=0,wb=0,xb=0,yb=0,zb=0,Bb=0,Cb=0,Db=0,Eb=0,Fb=0,Gb=0,Hb=0,Ib=0,Jb=0,Kb=0,Lb=0,Mb=0,Nb=0,Ob=0,Pb=0,Qb=0,Rb=0,Sb=0,Tb=0,Ub=0,Vb=0,Wb=0,Xb=0,Yb=0,Zb=0,_b=0,$b=0,ac=0,bc=0,cc=0,dc=0,ec=0,fc=0,gc=0,hc=0,ic=0,jc=0,kc=0,lc=0,mc=0,nc=0,oc=0,pc=0,qc=0,rc=0,sc=0,tc=0,uc=0,vc=0,wc=0,xc=0,yc=0,zc=0,Ac=0,Bc=0,Cc=0,Dc=0,Ec=0,Fc=0,Gc=0,Hc=0,Ic=0,Jc=0,Kc=0,Lc=0,Mc=0,Nc=0,Oc=0,Pc=0,Qc=0,Rc=0,Sc=0,Tc=0,Uc=0,Vc=0,Wc=0,Xc=0,Yc=0,Zc=0,_c=0,dd=0,ed=0,gd=0,hd=0,id=0,jd=0,kd=0,ld=0,md=0,nd=0,od=0,pd=0,qd=0,rd=0,sd=0,td=0,ud=0;ud=Qa;Qa=Qa+1392|0;Qc=ud+1352|0;Nc=ud+1344|0;Mc=ud+1328|0;Lc=ud+1320|0;Kc=ud+1304|0;mb=ud+1296|0;Cc=ud+1288|0;Bc=ud+1280|0;ic=ud+1272|0;Eb=ud+1264|0;na=ud+1256|0;bc=ud+1248|0;_b=ud+1232|0;ac=ud+1216|0;$b=ud+1200|0;Xb=ud+1176|0;Wb=ud+1136|0;Ub=ud+1128|0;Db=ud+1120|0;Cb=ud+1112|0;Ma=ud+1104|0;kc=ud+1096|0;Ja=ud+1088|0;Ia=ud+1080|0;Zb=ud+1056|0;Bb=ud+1048|0;xb=ud+1040|0;lb=ud+1032|0;kb=ud+1024|0;jb=ud+1016|0;fb=ud+1008|0;eb=ud+1e3|0;Vc=ud+992|0;Jc=ud+976|0;Uc=ud+960|0;Tc=ud+944|0;wc=ud+920|0;vc=ud+904|0;uc=ud+872|0;tc=ud+840|0;Ib=ud+832|0;Hb=ud+824|0;wb=ud+816|0;ib=ud+808|0;hb=ud+800|0;dc=ud+792|0;jc=ud+784|0;Pc=ud+776|0;Wa=ud+768|0;Ra=ud+760|0;Yb=ud+752|0;Vb=ud+744|0;cc=ud+736|0;qc=ud+728|0;o=ud+720|0;n=ud+712|0;i=ud+704|0;od=ud+696|0;nd=ud+688|0;md=ud+680|0;ld=ud+672|0;jd=ud+664|0;id=ud+648|0;hd=ud+640|0;dd=ud+632|0;Yc=ud+624|0;Fc=ud+616|0;Ec=ud+608|0;hc=ud+600|0;bb=ud+592|0;ab=ud+584|0;$a=ud+576|0;Xc=ud+568|0;Wc=ud+544|0;mc=ud+536|0;Ic=ud+528|0;Hc=ud+512|0;Gc=ud+504|0;Oc=ud;pc=ud+496|0;Tb=ud+488|0;Sb=ud+480|0;Mb=ud+472|0;Lb=ud+464|0;Va=ud+456|0;Ta=ud+448|0;t=ud+440|0;H=ud+432|0;ka=ud+424|0;s=ud+416|0;_=ud+408|0;M=ud+400|0;w=ud+392|0;$=ud+384|0;va=ud+376|0;ua=ud+368|0;ta=ud+360|0;sa=ud+352|0;v=ud+344|0;X=ud+336|0;K=ud+328|0;Fa=ud+320|0;ra=ud+312|0;ja=ud+304|0;u=ud+296|0;qa=ud+288|0;ia=ud+280|0;J=ud+272|0;yc=ud+264|0;Xa=ud+256|0;ha=ud+248|0;Na=ud+240|0;pa=ud+232|0;oa=ud+224|0;ma=ud+216|0;Ka=ud+208|0;Ha=ud+200|0;la=ud+192|0;nc=ud+184|0;U=ud+176|0;gb=ud+168|0;vb=ud+160|0;ub=ud+152|0;tb=ud+144|0;sb=ud+136|0;rb=ud+128|0;yb=ud+120|0;W=ud+112|0;V=ud+104|0;I=ud+96|0;F=ud+88|0;T=ud+80|0;qd=ud+48|0;_c=ud+24|0;Qb=ud+1368|0;td=c[f>>2]|0;sd=a[16752+g>>0]|0;if(sd<<24>>24==0?td>>>0>=(c[f+1208>>2]|0)>>>0:0){l=f+4|0;m=c[l>>2]|0;i=f+8|0;if(td>>>0>i>>>0?(c[f>>2]=td+-12,_i(m,b[td+2>>1]|0,td+4|0),O=c[f>>2]|0,O>>>0>i>>>0):0){k=O;do{td=c[l>>2]|0;c[f>>2]=k+-12;_i(td,b[k+2>>1]|0,k+4|0);k=c[f>>2]|0}while(k>>>0>i>>>0)}ad(m,38790,T);c[l>>2]=m;f=0;Qa=ud;return f|0}a:do switch(g|0){case 0:{a[j+199>>0]=1;break}case 1:{a[j+199>>0]=2;break}case 2:{w=c[j>>2]|0;if(!(a[j+18>>0]|0)){A=w+81|0;if((a[A>>0]|0)==0?(kd=j+36|0,(c[kd>>2]|0)==0):0){z=j+8|0;k=c[z>>2]|0;if(!k){if((c[j+116>>2]|0)==0?(b[w+76>>1]&8)==0:0)a[j+23>>0]=1;b:do if(!(c[w+272>>2]|0)){do if((e[w+276>>1]|0)>=224){k=w+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];qd=w+284|0;c[qd>>2]=(c[qd>>2]|0)+1;break b}k=w+296|0;l=c[k>>2]|0;if(!l){k=w+292|0;break}else{c[k>>2]=c[l>>2];qd=w+284|0;c[qd>>2]=(c[qd>>2]|0)+1;break b}}else k=w+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=29}else rd=29;while(0);if((rd|0)==29)l=Yd(w,224,0)|0;if(l|0){I=l+104|0;J=I+120|0;do{c[I>>2]=0;I=I+4|0}while((I|0)<(J|0));c[l>>2]=w;k=w+4|0;m=c[k>>2]|0;if(m|0)c[m+4>>2]=l;c[l+8>>2]=m;c[l+4>>2]=0;c[k>>2]=l;c[l+20>>2]=381479589;c[l+12>>2]=j;c[z>>2]=l;Bi(l,61,0,1,0)|0;rd=34}}else{l=k;rd=34}if((rd|0)==34){x=l+108|0;k=c[x>>2]|0;y=l+112|0;if((c[y>>2]|0)>(k|0)){c[x>>2]=k+1;I=c[l+104>>2]|0;a[I+(k*20|0)>>0]=69;I=I+(k*20|0)+1|0;J=I+19|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0))}else Bi(l,69,0,0,0)|0;do if(!(a[A>>0]|0)){v=j+84|0;i=c[v>>2]|0;if(!i){if(!(c[j+68>>2]|0))break;k=c[x>>2]|0;if(!(a[(c[l>>2]|0)+81>>0]|0))m=c[l+104>>2]|0;else m=59308}else{k=c[x>>2]|0;if(!(a[(c[l>>2]|0)+81>>0]|0))m=c[l+104>>2]|0;else m=59308}c[m+8>>2]=k;o=w+20|0;c:do if((c[o>>2]|0)>0){p=l+152|0;q=w+16|0;r=j+80|0;s=l+104|0;t=l+156|0;u=w+165|0;k=0;while(1){m=1<<k;do if(m&i|0){c[p>>2]=c[p>>2]|m;if((k|0)!=1?a[(c[(c[(c[l>>2]|0)+16>>2]|0)+(k<<4)+4>>2]|0)+9>>0]|0:0)c[t>>2]=c[t>>2]|m;n=c[(c[q>>2]|0)+(k<<4)+12>>2]|0;i=(c[r>>2]&m|0)!=0&1;h=c[n>>2]|0;n=c[n+4>>2]|0;m=c[x>>2]|0;if((c[y>>2]|0)>(m|0)){c[x>>2]=m+1;qd=c[s>>2]|0;a[qd+(m*20|0)>>0]=2;b[qd+(m*20|0)+2>>1]=0;c[qd+(m*20|0)+4>>2]=k;c[qd+(m*20|0)+8>>2]=i;c[qd+(m*20|0)+12>>2]=h;c[qd+(m*20|0)+16>>2]=0;a[qd+(m*20|0)+1>>0]=0}else m=Bi(l,2,k,i,h)|0;if(!(a[(c[l>>2]|0)+81>>0]|0)){qd=c[s>>2]|0;a[qd+(m*20|0)+1>>0]=-3;c[qd+(m*20|0)+16>>2]=n}if(a[u>>0]|0)break;m=c[x>>2]|0;if((m|0)<=0)break;b[(c[s>>2]|0)+((m+-1|0)*20|0)+2>>1]=1}while(0);k=k+1|0;if((k|0)>=(c[o>>2]|0))break c;i=c[v>>2]|0}}while(0);o=j+204|0;if((c[o>>2]|0)>0){p=j+252|0;q=l+104|0;n=0;do{k=c[(c[(c[p>>2]|0)+(n<<2)>>2]|0)+64>>2]|0;d:do if(!k)k=0;else while(1){if((c[k>>2]|0)==(w|0))break d;k=c[k+24>>2]|0;if(!k){k=0;break}}while(0);m=c[x>>2]|0;if((c[y>>2]|0)>(m|0)){c[x>>2]=m+1;I=c[q>>2]|0;a[I+(m*20|0)>>0]=-96;I=I+(m*20|0)+1|0;J=I+19|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0))}else m=Bi(l,160,0,0,0)|0;do if(!(a[(c[l>>2]|0)+81>>0]|0)){if((m|0)<0)m=(c[x>>2]|0)+-1|0;i=c[q>>2]|0;h=i+(m*20|0)+1|0;if(a[h>>0]|0){Ci(l,i+(m*20|0)|0,k,-12);break}if(!k)break;c[i+(m*20|0)+16>>2]=k;a[h>>0]=-12;qd=k+12|0;c[qd>>2]=(c[qd>>2]|0)+1}while(0);n=n+1|0}while((n|0)<(c[o>>2]|0))}c[o>>2]=0;k=c[z>>2]|0;e:do if(!k){i=c[j>>2]|0;if((c[j+116>>2]|0)==0?(b[i+76>>1]&8)==0:0)a[j+23>>0]=1;f:do if(c[i+272>>2]|0)if(!(a[i+81>>0]|0))rd=91;else{k=0;break e}else{do if((e[i+276>>1]|0)>=224){m=i+300|0;k=c[m>>2]|0;if(k|0){c[m>>2]=c[k>>2];qd=i+284|0;c[qd>>2]=(c[qd>>2]|0)+1;break f}m=i+296|0;k=c[m>>2]|0;if(!k){k=i+292|0;break}else{c[m>>2]=c[k>>2];qd=i+284|0;c[qd>>2]=(c[qd>>2]|0)+1;break f}}else k=i+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=91}while(0);if((rd|0)==91)k=Yd(i,224,0)|0;if(!k)k=0;else{I=k+104|0;J=I+120|0;do{c[I>>2]=0;I=I+4|0}while((I|0)<(J|0));c[k>>2]=i;m=i+4|0;i=c[m>>2]|0;if(i|0)c[i+4>>2]=k;c[k+8>>2]=i;c[k+4>>2]=0;c[m>>2]=k;c[k+20>>2]=381479589;c[k+12>>2]=j;c[z>>2]=k;Bi(k,61,0,1,0)|0}}while(0);p=j+104|0;if((c[p>>2]|0)>0){q=j+108|0;r=k+108|0;s=k+112|0;t=k+104|0;o=0;do{u=c[q>>2]|0;i=c[u+(o<<4)>>2]|0;h=c[u+(o<<4)+4>>2]|0;n=d[u+(o<<4)+8>>0]|0;u=c[u+(o<<4)+12>>2]|0;m=c[r>>2]|0;if((c[s>>2]|0)>(m|0)){c[r>>2]=m+1;qd=c[t>>2]|0;a[qd+(m*20|0)>>0]=-97;b[qd+(m*20|0)+2>>1]=0;c[qd+(m*20|0)+4>>2]=i;c[qd+(m*20|0)+8>>2]=h;c[qd+(m*20|0)+12>>2]=n;c[qd+(m*20|0)+16>>2]=0;a[qd+(m*20|0)+1>>0]=0}else m=Bi(k,159,i,h,n)|0;do if(!(a[(c[k>>2]|0)+81>>0]|0)){if((m|0)<0)m=(c[r>>2]|0)+-1|0;i=c[t>>2]|0;h=i+(m*20|0)+1|0;if(a[h>>0]|0){Ci(k,i+(m*20|0)|0,u,-1);break}if(!u)break;c[i+(m*20|0)+16>>2]=u;a[h>>0]=-1}while(0);o=o+1|0}while((o|0)<(c[p>>2]|0))}o=c[z>>2]|0;k=c[j+112>>2]|0;g:do if(k|0){p=(c[j>>2]|0)+16|0;q=o+108|0;r=o+112|0;s=o+104|0;t=j+40|0;do{n=c[k+8>>2]|0;h=c[k+12>>2]|0;Ej(j,0,n,c[(c[(c[p>>2]|0)+(n<<4)+12>>2]|0)+72>>2]|0,108);n=h+-1|0;i=c[c[k+4>>2]>>2]|0;m=c[q>>2]|0;if((c[r>>2]|0)>(m|0)){c[q>>2]=m+1;qd=c[s>>2]|0;a[qd+(m*20|0)>>0]=110;b[qd+(m*20|0)+2>>1]=0;c[qd+(m*20|0)+4>>2]=0;c[qd+(m*20|0)+8>>2]=n;c[qd+(m*20|0)+12>>2]=0;c[qd+(m*20|0)+16>>2]=0;a[qd+(m*20|0)+1>>0]=0}else m=Bi(o,110,0,n,0)|0;if(!(a[(c[o>>2]|0)+81>>0]|0)){if((m|0)<0)m=(c[q>>2]|0)+-1|0;Ci(o,(c[s>>2]|0)+(m*20|0)|0,i,0)}m=cd(o,12,17904)|0;if(!m)break g;c[m+8>>2]=h;qd=h+2|0;c[m+12>>2]=qd;c[m+52>>2]=h;c[m+64>>2]=n;c[m+72>>2]=h;b[m+62>>1]=16;c[m+88>>2]=h+1;c[m+112>>2]=h;c[m+124>>2]=h;c[m+148>>2]=qd;c[m+144>>2]=h;c[m+208>>2]=h;if(!(c[t>>2]|0))c[t>>2]=1;k=c[k>>2]|0}while((k|0)!=0)}while(0);o=c[j+68>>2]|0;if(o|0?(a[j+23>>0]=0,(c[o>>2]|0)>0):0){n=0;do{k=c[o+4+(n*20|0)>>2]|0;p=c[o+4+(n*20|0)+16>>2]|0;do if(k){if((a[k>>0]|0)!=-88){h=Hj(j,k,p)|0;rd=132;break}h=c[z>>2]|0;k=c[k+28>>2]|0;m=h+108|0;i=c[m>>2]|0;if((c[h+112>>2]|0)>(i|0)){c[m>>2]=i+1;qd=c[h+104>>2]|0;a[qd+(i*20|0)>>0]=78;b[qd+(i*20|0)+2>>1]=0;c[qd+(i*20|0)+4>>2]=k;c[qd+(i*20|0)+8>>2]=p;c[qd+(i*20|0)+12>>2]=0;c[qd+(i*20|0)+16>>2]=0;a[qd+(i*20|0)+1>>0]=0;break}else{Bi(h,78,k,p,0)|0;break}}else{h=Hj(j,0,p)|0;rd=132}while(0);do if((rd|0)==132){rd=0;if((h|0)==(p|0))break;k=c[z>>2]|0;if(!k)break;m=k+108|0;i=c[m>>2]|0;if((c[k+112>>2]|0)>(i|0)){c[m>>2]=i+1;qd=c[k+104>>2]|0;a[qd+(i*20|0)>>0]=79;b[qd+(i*20|0)+2>>1]=0;c[qd+(i*20|0)+4>>2]=h;c[qd+(i*20|0)+8>>2]=p;c[qd+(i*20|0)+12>>2]=0;c[qd+(i*20|0)+16>>2]=0;a[qd+(i*20|0)+1>>0]=0;break}else{Bi(k,79,h,p,0)|0;break}}while(0);n=n+1|0}while((n|0)<(c[o>>2]|0))}k=c[x>>2]|0;if((c[y>>2]|0)>(k|0)){c[x>>2]=k+1;rd=c[l+104>>2]|0;a[rd+(k*20|0)>>0]=11;b[rd+(k*20|0)+2>>1]=0;c[rd+(k*20|0)+4>>2]=0;c[rd+(k*20|0)+8>>2]=1;c[rd+(k*20|0)+12>>2]=0;c[rd+(k*20|0)+16>>2]=0;a[rd+(k*20|0)+1>>0]=0;break}else{Bi(l,11,0,1,0)|0;break}}while(0);if((c[kd>>2]|0)==0?(a[A>>0]|0)==0:0){fd(l,j);c[j+12>>2]=101;break a}}c[j+12>>2]=1;break a}k=j+12|0;if(!(c[k>>2]|0))c[k>>2]=1}break}case 3:{o=c[td+-8>>2]|0;n=c[j>>2]|0;do if(((a[n+165>>0]|0)==0?(a[j+200>>0]|0)==0:0)?(z=c[n+312>>2]|0,z|0):0){k=Za[z&127](c[n+316>>2]|0,22,36223,0,0,c[j+240>>2]|0)|0;if((k|0)==1){ad(j,39216,F);c[j+12>>2]=23;break a}if((k|2|0)==2)if(!k)break;else break a;else{ad(j,39231,I);c[j+12>>2]=1;break a}}while(0);h=j+8|0;k=c[h>>2]|0;if(!k){i=c[j>>2]|0;if((c[j+116>>2]|0)==0?(b[i+76>>1]&8)==0:0)a[j+23>>0]=1;h:do if(c[i+272>>2]|0)if(!(a[i+81>>0]|0))rd=167;else break a;else{do if((e[i+276>>1]|0)>=224){k=i+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];m=i+284|0;c[m>>2]=(c[m>>2]|0)+1;m=l;break h}k=i+296|0;l=c[k>>2]|0;if(!l){k=i+292|0;break}else{c[k>>2]=c[l>>2];m=i+284|0;c[m>>2]=(c[m>>2]|0)+1;m=l;break h}}else k=i+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=167}while(0);if((rd|0)==167)m=Yd(i,224,0)|0;if(!m)break a;I=m+104|0;J=I+120|0;do{c[I>>2]=0;I=I+4|0}while((I|0)<(J|0));c[m>>2]=i;k=i+4|0;l=c[k>>2]|0;if(l|0)c[l+4>>2]=m;c[m+8>>2]=l;c[m+4>>2]=0;c[k>>2]=m;c[m+20>>2]=381479589;c[m+12>>2]=j;c[h>>2]=m;Bi(m,61,0,1,0)|0;r=m}else r=k;if((o|0)==7){k=r+108|0;l=c[k>>2]|0;if((c[r+112>>2]|0)>(l|0)){c[k>>2]=l+1;I=c[r+104>>2]|0;a[I+(l*20|0)>>0]=1;I=I+(l*20|0)+1|0;J=I+19|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));break a}else{Bi(r,1,0,0,0)|0;break a}}q=n+20|0;if((c[q>>2]|0)>0){h=(o|0)==9?2:1;m=r+108|0;k=r+112|0;n=r+104|0;o=r+152|0;p=r+156|0;i=0;do{l=c[m>>2]|0;if((c[k>>2]|0)>(l|0)){c[m>>2]=l+1;j=c[n>>2]|0;a[j+(l*20|0)>>0]=2;b[j+(l*20|0)+2>>1]=0;c[j+(l*20|0)+4>>2]=i;c[j+(l*20|0)+8>>2]=h;c[j+(l*20|0)+12>>2]=0;c[j+(l*20|0)+16>>2]=0;a[j+(l*20|0)+1>>0]=0}else Bi(r,2,i,h,0)|0;l=1<<i;c[o>>2]=c[o>>2]|l;if((i|0)!=1?a[(c[(c[(c[r>>2]|0)+16>>2]|0)+(i<<4)+4>>2]|0)+9>>0]|0:0)c[p>>2]=c[p>>2]|l;i=i+1|0}while((i|0)<(c[q>>2]|0))}else{m=r+108|0;k=r+112|0}l=c[m>>2]|0;if((c[k>>2]|0)>(l|0)){c[m>>2]=l+1;I=c[r+104>>2]|0;a[I+(l*20|0)>>0]=1;I=I+(l*20|0)+1|0;J=I+19|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));break a}else{Bi(r,1,0,0,0)|0;break a}}case 4:{c[td+16>>2]=7;break}case 300:case 7:case 6:case 5:{c[td+4>>2]=e[td+2>>1];break}case 9:case 8:{k=(b[td+-10>>1]|0)==12;h=k&1;k=k?39254:39263;l=c[j>>2]|0;do if(((a[l+165>>0]|0)==0?(a[j+200>>0]|0)==0:0)?(S=c[l+312>>2]|0,S|0):0){k=Za[S&127](c[l+316>>2]|0,22,k,0,0,c[j+240>>2]|0)|0;if((k|0)==1){ad(j,39216,V);c[j+12>>2]=23;break a}if((k|2|0)==2)if(!k)break;else break a;else{ad(j,39231,W);c[j+12>>2]=1;break a}}while(0);i=j+8|0;k=c[i>>2]|0;if(!k){m=c[j>>2]|0;if((c[j+116>>2]|0)==0?(b[m+76>>1]&8)==0:0)a[j+23>>0]=1;i:do if(c[m+272>>2]|0)if(!(a[m+81>>0]|0))rd=213;else break a;else{do if((e[m+276>>1]|0)>=224){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];qd=m+284|0;c[qd>>2]=(c[qd>>2]|0)+1;break i}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];qd=m+284|0;c[qd>>2]=(c[qd>>2]|0)+1;break i}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=213}while(0);if((rd|0)==213)k=Yd(m,224,0)|0;if(!k)break a;I=k+104|0;J=I+120|0;do{c[I>>2]=0;I=I+4|0}while((I|0)<(J|0));c[k>>2]=m;l=m+4|0;m=c[l>>2]|0;if(m|0)c[m+4>>2]=k;c[k+8>>2]=m;c[k+4>>2]=0;c[l>>2]=k;c[k+20>>2]=381479589;c[k+12>>2]=j;c[i>>2]=k;Bi(k,61,0,1,0)|0}l=k+108|0;m=c[l>>2]|0;if((c[k+112>>2]|0)>(m|0)){c[l>>2]=m+1;j=c[k+104>>2]|0;a[j+(m*20|0)>>0]=1;b[j+(m*20|0)+2>>1]=0;c[j+(m*20|0)+4>>2]=1;c[j+(m*20|0)+8>>2]=h;c[j+(m*20|0)+12>>2]=0;c[j+(m*20|0)+16>>2]=0;a[j+(m*20|0)+1>>0]=0;break a}else{Bi(k,1,1,h,0)|0;break a}}case 10:{n=oj(c[j>>2]|0,td+4|0)|0;if(n|0){h=j+8|0;k=c[h>>2]|0;j:do if(!k){i=c[j>>2]|0;if((c[j+116>>2]|0)==0?(b[i+76>>1]&8)==0:0)a[j+23>>0]=1;k:do if(c[i+272>>2]|0)if(!(a[i+81>>0]|0))rd=236;else break j;else{do if((e[i+276>>1]|0)>=224){k=i+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];m=i+284|0;c[m>>2]=(c[m>>2]|0)+1;m=l;break k}k=i+296|0;l=c[k>>2]|0;if(!l){k=i+292|0;break}else{c[k>>2]=c[l>>2];m=i+284|0;c[m>>2]=(c[m>>2]|0)+1;m=l;break k}}else k=i+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=236}while(0);if((rd|0)==236)m=Yd(i,224,0)|0;if(m|0){I=m+104|0;J=I+120|0;do{c[I>>2]=0;I=I+4|0}while((I|0)<(J|0));c[m>>2]=i;k=i+4|0;l=c[k>>2]|0;if(l|0)c[l+4>>2]=m;c[m+8>>2]=l;c[m+4>>2]=0;c[k>>2]=m;c[m+20>>2]=381479589;c[m+12>>2]=j;c[h>>2]=m;Bi(m,61,0,1,0)|0;i=m;rd=241}}else{i=k;rd=241}while(0);l:do if((rd|0)==241){k=c[j>>2]|0;do if(((a[k+165>>0]|0)==0?(a[j+200>>0]|0)==0:0)?(pb=c[k+312>>2]|0,pb|0):0){k=Za[pb&127](c[k+316>>2]|0,32,36223,n,0,c[j+240>>2]|0)|0;if((k|0)==1){ad(j,39216,yb);c[j+12>>2]=23;break l}if((k|2|0)==2)if(!k)break;else break l;else{ad(j,39231,rb);c[j+12>>2]=1;break l}}while(0);m=i+108|0;k=c[m>>2]|0;if((c[i+112>>2]|0)>(k|0)){c[m>>2]=k+1;j=(c[i+104>>2]|0)+(k*20|0)|0;c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0}else k=Bi(i,0,0,0,0)|0;l=c[i>>2]|0;if(!(a[l+81>>0]|0)){if((k|0)<0)k=(c[m>>2]|0)+-1|0;l=c[i+104>>2]|0;m=l+(k*20|0)+1|0;if(!(a[m>>0]|0)){c[l+(k*20|0)+16>>2]=n;a[m>>0]=-7;break a}else{Ci(i,l+(k*20|0)|0,n,-7);break a}}if(l|0){if(c[l+480>>2]|0){Vd(l,n);break a}j=n;if((c[l+304>>2]|0)>>>0<=j>>>0?(c[l+308>>2]|0)>>>0>j>>>0:0){j=l+300|0;c[n>>2]=c[j>>2];c[j>>2]=n;break a}}if(!(c[7324]|0)){_a[c[29344>>2]&127](n);break a}else{j=Ua[c[29352>>2]&127](n)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](n);break a}}while(0);k=c[j>>2]|0;if(k|0){if(c[k+480>>2]|0){Vd(k,n);break a}j=n;if((c[k+304>>2]|0)>>>0<=j>>>0?(c[k+308>>2]|0)>>>0>j>>>0:0){j=k+300|0;c[n>>2]=c[j>>2];c[j>>2]=n;break a}}if(!(c[7324]|0)){_a[c[29344>>2]&127](n);break a}else{j=Ua[c[29352>>2]&127](n)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](n);break a}}break}case 11:{n=oj(c[j>>2]|0,td+4|0)|0;if(n|0){h=j+8|0;k=c[h>>2]|0;m:do if(!k){i=c[j>>2]|0;if((c[j+116>>2]|0)==0?(b[i+76>>1]&8)==0:0)a[j+23>>0]=1;n:do if(c[i+272>>2]|0)if(!(a[i+81>>0]|0))rd=291;else break m;else{do if((e[i+276>>1]|0)>=224){k=i+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];m=i+284|0;c[m>>2]=(c[m>>2]|0)+1;m=l;break n}k=i+296|0;l=c[k>>2]|0;if(!l){k=i+292|0;break}else{c[k>>2]=c[l>>2];m=i+284|0;c[m>>2]=(c[m>>2]|0)+1;m=l;break n}}else k=i+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=291}while(0);if((rd|0)==291)m=Yd(i,224,0)|0;if(m|0){I=m+104|0;J=I+120|0;do{c[I>>2]=0;I=I+4|0}while((I|0)<(J|0));c[m>>2]=i;k=i+4|0;l=c[k>>2]|0;if(l|0)c[l+4>>2]=m;c[m+8>>2]=l;c[m+4>>2]=0;c[k>>2]=m;c[m+20>>2]=381479589;c[m+12>>2]=j;c[h>>2]=m;Bi(m,61,0,1,0)|0;i=m;rd=296}}else{i=k;rd=296}while(0);o:do if((rd|0)==296){k=c[j>>2]|0;do if(((a[k+165>>0]|0)==0?(a[j+200>>0]|0)==0:0)?(qb=c[k+312>>2]|0,qb|0):0){k=Za[qb&127](c[k+316>>2]|0,32,39270,n,0,c[j+240>>2]|0)|0;if((k|0)==1){ad(j,39216,sb);c[j+12>>2]=23;break o}if((k|2|0)==2)if(!k)break;else break o;else{ad(j,39231,tb);c[j+12>>2]=1;break o}}while(0);m=i+108|0;k=c[m>>2]|0;if((c[i+112>>2]|0)>(k|0)){c[m>>2]=k+1;j=c[i+104>>2]|0;a[j+(k*20|0)>>0]=0;b[j+(k*20|0)+2>>1]=0;c[j+(k*20|0)+4>>2]=1;c[j+(k*20|0)+8>>2]=0;c[j+(k*20|0)+12>>2]=0;c[j+(k*20|0)+16>>2]=0;a[j+(k*20|0)+1>>0]=0}else k=Bi(i,0,1,0,0)|0;l=c[i>>2]|0;if(!(a[l+81>>0]|0)){if((k|0)<0)k=(c[m>>2]|0)+-1|0;l=c[i+104>>2]|0;m=l+(k*20|0)+1|0;if(!(a[m>>0]|0)){c[l+(k*20|0)+16>>2]=n;a[m>>0]=-7;break a}else{Ci(i,l+(k*20|0)|0,n,-7);break a}}if(l|0){if(c[l+480>>2]|0){Vd(l,n);break a}j=n;if((c[l+304>>2]|0)>>>0<=j>>>0?(c[l+308>>2]|0)>>>0>j>>>0:0){j=l+300|0;c[n>>2]=c[j>>2];c[j>>2]=n;break a}}if(!(c[7324]|0)){_a[c[29344>>2]&127](n);break a}else{j=Ua[c[29352>>2]&127](n)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](n);break a}}while(0);k=c[j>>2]|0;if(k|0){if(c[k+480>>2]|0){Vd(k,n);break a}j=n;if((c[k+304>>2]|0)>>>0<=j>>>0?(c[k+308>>2]|0)>>>0>j>>>0:0){j=k+300|0;c[n>>2]=c[j>>2];c[j>>2]=n;break a}}if(!(c[7324]|0)){_a[c[29344>>2]&127](n);break a}else{j=Ua[c[29352>>2]&127](n)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](n);break a}}break}case 12:{n=oj(c[j>>2]|0,td+4|0)|0;if(n|0){h=j+8|0;k=c[h>>2]|0;p:do if(!k){i=c[j>>2]|0;if((c[j+116>>2]|0)==0?(b[i+76>>1]&8)==0:0)a[j+23>>0]=1;q:do if(c[i+272>>2]|0)if(!(a[i+81>>0]|0))rd=346;else break p;else{do if((e[i+276>>1]|0)>=224){k=i+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];m=i+284|0;c[m>>2]=(c[m>>2]|0)+1;m=l;break q}k=i+296|0;l=c[k>>2]|0;if(!l){k=i+292|0;break}else{c[k>>2]=c[l>>2];m=i+284|0;c[m>>2]=(c[m>>2]|0)+1;m=l;break q}}else k=i+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=346}while(0);if((rd|0)==346)m=Yd(i,224,0)|0;if(m|0){I=m+104|0;J=I+120|0;do{c[I>>2]=0;I=I+4|0}while((I|0)<(J|0));c[m>>2]=i;k=i+4|0;l=c[k>>2]|0;if(l|0)c[l+4>>2]=m;c[m+8>>2]=l;c[m+4>>2]=0;c[k>>2]=m;c[m+20>>2]=381479589;c[m+12>>2]=j;c[h>>2]=m;Bi(m,61,0,1,0)|0;i=m;rd=351}}else{i=k;rd=351}while(0);r:do if((rd|0)==351){k=c[j>>2]|0;do if(((a[k+165>>0]|0)==0?(a[j+200>>0]|0)==0:0)?(nb=c[k+312>>2]|0,nb|0):0){k=Za[nb&127](c[k+316>>2]|0,32,39254,n,0,c[j+240>>2]|0)|0;if((k|0)==1){ad(j,39216,ub);c[j+12>>2]=23;break r}if((k|2|0)==2)if(!k)break;else break r;else{ad(j,39231,vb);c[j+12>>2]=1;break r}}while(0);m=i+108|0;k=c[m>>2]|0;if((c[i+112>>2]|0)>(k|0)){c[m>>2]=k+1;j=c[i+104>>2]|0;a[j+(k*20|0)>>0]=0;b[j+(k*20|0)+2>>1]=0;c[j+(k*20|0)+4>>2]=2;c[j+(k*20|0)+8>>2]=0;c[j+(k*20|0)+12>>2]=0;c[j+(k*20|0)+16>>2]=0;a[j+(k*20|0)+1>>0]=0}else k=Bi(i,0,2,0,0)|0;l=c[i>>2]|0;if(!(a[l+81>>0]|0)){if((k|0)<0)k=(c[m>>2]|0)+-1|0;l=c[i+104>>2]|0;m=l+(k*20|0)+1|0;if(!(a[m>>0]|0)){c[l+(k*20|0)+16>>2]=n;a[m>>0]=-7;break a}else{Ci(i,l+(k*20|0)|0,n,-7);break a}}if(l|0){if(c[l+480>>2]|0){Vd(l,n);break a}j=n;if((c[l+304>>2]|0)>>>0<=j>>>0?(c[l+308>>2]|0)>>>0>j>>>0:0){j=l+300|0;c[n>>2]=c[j>>2];c[j>>2]=n;break a}}if(!(c[7324]|0)){_a[c[29344>>2]&127](n);break a}else{j=Ua[c[29352>>2]&127](n)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](n);break a}}while(0);k=c[j>>2]|0;if(k|0){if(c[k+480>>2]|0){Vd(k,n);break a}j=n;if((c[k+304>>2]|0)>>>0<=j>>>0?(c[k+308>>2]|0)>>>0>j>>>0:0){j=k+300|0;c[n>>2]=c[j>>2];c[j>>2]=n;break a}}if(!(c[7324]|0)){_a[c[29344>>2]&127](n);break a}else{j=Ua[c[29352>>2]&127](n)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](n);break a}}break}case 13:{$i(j,td+-8|0,td+4|0,c[td+-44>>2]|0,0,0,c[td+-20>>2]|0);break}case 14:{rd=j+24|0;a[rd>>0]=(a[rd>>0]|0)+1<<24>>24;j=(c[j>>2]|0)+272|0;c[j>>2]=(c[j>>2]|0)+1;break}case 226:case 93:case 76:case 67:case 57:case 42:case 21:case 18:case 15:{c[td+16>>2]=0;break}case 16:{c[td+-20>>2]=1;break}case 43:case 17:{c[td+4>>2]=1;break}case 19:{aj(j,td+-20|0,td+-8|0,c[td+4>>2]&255,0);break}case 20:{k=td+4|0;aj(j,0,0,0,c[k>>2]|0);k=c[k>>2]|0;if(k|0)ni(c[j>>2]|0,k,1);break}case 22:{i=c[td+8>>2]|0;k=c[td+4>>2]|0;do if((i|0)==5)if(!k)k=0;else{l=a[k>>0]|0;do if(!(l<<24>>24)){l=38132;rd=397}else{qd=l&255;l=208+qd|0;if((qd|32|0)==114){l=a[k+1>>0]|0;if(!(l<<24>>24)){l=38133;rd=397;break}qd=l&255;l=208+qd|0;if((qd|32|0)==111){l=a[k+2>>0]|0;if(!(l<<24>>24)){l=38134;rd=397;break}qd=l&255;l=208+qd|0;if((qd|32|0)==119){l=a[k+3>>0]|0;if(!(l<<24>>24)){l=38135;rd=397;break}qd=l&255;l=208+qd|0;if((qd|32|0)==105){l=a[k+4>>0]|0;if(!(l<<24>>24)){l=38136;rd=397;break}l=l&255;if((l|32|0)==100)break;else{m=100;l=208+l|0}}else m=105}else m=119}else m=111}else m=114;cb=d[l>>0]|0;rd=401}while(0);if((rd|0)==397){cb=0;m=a[208+(d[l>>0]|0)>>0]|0;rd=401}if((rd|0)==401?(cb|0)!=(m&255|0):0)break;c[td+-8>>2]=96;break a}while(0);c[td+-8>>2]=0;c[gb>>2]=i;c[gb+4>>2]=k;ad(j,38466,gb);break}case 23:{h=td+-8|0;q=c[j>>2]|0;n=c[j+228>>2]|0;if(n|0){t=n+42|0;if((c[q+116>>2]|0)<=(b[t>>1]|0)){c[U>>2]=c[n>>2];ad(j,38221,U);break a}i=td+-4|0;s=td+8|0;m=(c[i>>2]|0)+2+(c[s>>2]|0)|0;p=q+272|0;s:do if(c[p>>2]|0)if(!(a[q+81>>0]|0))rd=417;else break a;else{do if(!(0<0|(0==0?(e[q+276>>1]|0)>>>0<m>>>0:0))){k=q+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];r=q+284|0;c[r>>2]=(c[r>>2]|0)+1;r=l;break s}k=q+296|0;l=c[k>>2]|0;if(!l){k=q+292|0;break}else{c[k>>2]=c[l>>2];r=q+284|0;c[r>>2]=(c[r>>2]|0)+1;r=l;break s}}else k=q+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=417}while(0);if((rd|0)==417)r=Yd(q,m,0)|0;if(r|0){t:do if((d[j+200>>0]|0)>1){m=c[j>>2]|0;u:do if(!m){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](16)|0;rd=443;break}k=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){pd=c[14978]|0;od=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;nd=L()|0;c[14768]=((nd|0)<0|(nd|0)==0&od>>>0<=pd>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k)break t;l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0)break t}else{do if((e[m+276>>1]|0)>=16){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=443;break u}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=443;break u}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,16,0)|0;rd=443}while(0);if((rd|0)==443)if(!k)break;l=k+4|0;I=l;J=I+12|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[k>>2]=r;nd=h;od=c[nd+4>>2]|0;pd=l;c[pd>>2]=c[nd>>2];c[pd+4>>2]=od;pd=j+272|0;c[k+12>>2]=c[pd>>2];c[pd>>2]=k}while(0);cw(r|0,c[h>>2]|0,c[i>>2]|0)|0;a[r+(c[i>>2]|0)>>0]=0;k=a[r>>0]|0;if((a[880+(k&255)>>0]|0)<0){i=k<<24>>24==91?93:k;m=0;k=1;while(1){l=a[r+k>>0]|0;if(l<<24>>24==i<<24>>24){k=k+1|0;l=r+m|0;if((a[r+k>>0]|0)!=i<<24>>24)break;a[l>>0]=i}else a[r+m>>0]=l;m=m+1|0;k=k+1|0}a[l>>0]=0}pd=b[t>>1]|0;k=pd<<16>>16;o=n+4|0;v:do if(pd<<16>>16>0){n=c[o>>2]|0;h=0;while(1){m=c[n+(h<<4)>>2]|0;if(m|0){pd=a[r>>0]|0;l=(d[208+(pd&255)>>0]|0)-(d[208+(d[m>>0]|0)>>0]|0)|0;if(!(pd<<24>>24==0|(l|0)!=0)){i=r;do{i=i+1|0;m=m+1|0;pd=a[i>>0]|0;l=(d[208+(pd&255)>>0]|0)-(d[208+(d[m>>0]|0)>>0]|0)|0}while(!(pd<<24>>24==0|(l|0)!=0))}if(!l)break}h=h+1|0;if((h|0)>=(k|0))break v}c[nc>>2]=r;ad(j,41735,nc);if(c[q+480>>2]|0){Vd(q,r);break a}j=r;if((c[q+304>>2]|0)>>>0<=j>>>0?(c[q+308>>2]|0)>>>0>j>>>0:0){j=q+300|0;c[r>>2]=c[j>>2];c[j>>2]=r;break a}if(!(c[7324]|0)){_a[c[29344>>2]&127](r);break a}else{j=Ua[c[29352>>2]&127](r)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](r);break a}}while(0);do if(!(k&7)){l=c[o>>2]|0;m=(k<<4)+128|0;w:do if(!l){if(c[p>>2]|0){if(a[q+81>>0]|0)break}else{do if(!(0<0|(0==0?(e[q+276>>1]|0)>>>0<m>>>0:0))){k=q+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];sc=q+284|0;c[sc>>2]=(c[sc>>2]|0)+1;sc=l;rd=488;break w}k=q+296|0;l=c[k>>2]|0;if(!l){k=q+292|0;break}else{c[k>>2]=c[l>>2];sc=q+284|0;c[sc>>2]=(c[sc>>2]|0)+1;sc=l;rd=488;break w}}else k=q+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}sc=Yd(q,m,0)|0;rd=488}else{rd=l;if((c[q+304>>2]|0)>>>0<=rd>>>0?(c[q+308>>2]|0)>>>0>rd>>>0:0){if(!(0<0|(0==0?(e[q+276>>1]|0)>>>0<m>>>0:0))){rd=498;break}sc=Xd(q,l,m,0)|0;rd=488;break}sc=Xd(q,l,m,0)|0;rd=488}while(0);if((rd|0)==488?sc|0:0){l=sc;k=b[t>>1]|0;rd=498}if((rd|0)==498){c[o>>2]=l;q=k;p=l;break}if(c[q+480>>2]|0){Vd(q,r);break a}j=r;if((c[q+304>>2]|0)>>>0<=j>>>0?(c[q+308>>2]|0)>>>0>j>>>0:0){j=q+300|0;c[r>>2]=c[j>>2];c[j>>2]=r;break a}if(!(c[7324]|0)){_a[c[29344>>2]&127](r);break a}else{j=Ua[c[29352>>2]&127](r)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](r);break a}}else{q=k;p=c[o>>2]|0}while(0);o=p+(q<<4)|0;k=p+(q<<4)+4|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[o>>2]=r;k=c[s>>2]|0;if(!k){a[p+(q<<4)+13>>0]=65;a[p+(q<<4)+14>>0]=1}else{n=r+((Cu(r)|0)&1073741823)+1|0;cw(n|0,c[td+4>>2]|0,k|0)|0;a[n+(c[s>>2]|0)>>0]=0;k=a[n>>0]|0;if((a[880+(k&255)>>0]|0)<0){i=k<<24>>24==91?93:k;m=0;k=1;while(1){l=a[n+k>>0]|0;if(l<<24>>24==i<<24>>24){k=k+1|0;l=n+m|0;if((a[n+k>>0]|0)!=i<<24>>24)break;a[l>>0]=i}else a[n+m>>0]=l;m=m+1|0;k=k+1|0}a[l>>0]=0;k=a[n>>0]|0}x:do if(!(k<<24>>24)){k=0;m=67}else{l=67;h=0;i=n;m=0;while(1){h=h<<8|d[208+(k&255)>>0];i=i+1|0;y:do if((h|0)<1685026146){if((h|0)<1667785074){switch(h|0){case 1651273570:break;default:{rd=521;break y}}switch(l<<24>>24){case 69:case 67:break;default:{rd=520;break y}}k=a[i>>0]|0;m=k<<24>>24==40?i:m;l=65;break}if((h|0)<1668050786)switch(h|0){case 1667785074:{k=i;l=66;rd=522;break y}default:{rd=521;break y}}switch(h|0){case 1668050786:break;default:{rd=521;break y}}k=m;l=66;rd=522}else{if((h|0)>=1919246700)if((h|0)<1952807028){switch(h|0){case 1919246700:break;default:{rd=521;break y}}if(l<<24>>24==67){k=m;l=69;rd=522;break}else{rd=520;break}}else{switch(h|0){case 1952807028:break;default:{rd=521;break y}}k=m;l=66;rd=522;break}if((h|0)<1718382433){switch(h|0){case 1685026146:break;default:{rd=521;break y}}if(l<<24>>24==67){k=m;l=69;rd=522;break}}else{switch(h|0){case 1718382433:break;default:{rd=521;break y}}if(l<<24>>24==67){k=m;l=69;rd=522;break}}k=m;rd=522}while(0);if((rd|0)==520){k=m;rd=522}else if((rd|0)==521){rd=0;if((h&16777215|0)==6909556){k=m;m=68;break x}else{k=m;rd=522}}if((rd|0)==522){rd=0;m=k;k=a[i>>0]|0}if(!(k<<24>>24)){k=m;m=l;break}}}while(0);if(o|0){c[qd>>2]=0;z:do if(m<<24>>24<67){if(!k){c[qd>>2]=16;k=5;rd=533;break}l=a[k>>0]|0;if(l<<24>>24){while(1){if(((l&255)+-48|0)>>>0<10)break;k=k+1|0;l=a[k>>0]|0;if(!(l<<24>>24)){k=1;rd=533;break z}}gi(k,qd)|0;k=c[qd>>2]|0;if((k|0)<1016){k=((k|0)/4|0)+1|0;rd=533}else k=255}else{k=1;rd=533}}else{k=1;rd=533}while(0);a[p+(q<<4)+14>>0]=k}a[p+(q<<4)+13>>0]=m;rd=p+(q<<4)+15|0;a[rd>>0]=a[rd>>0]|4}b[t>>1]=(b[t>>1]|0)+1<<16>>16;c[j+76>>2]=0}}break}case 99:case 60:case 24:{c[td+20>>2]=0;c[td+16>>2]=0;break}case 25:{c[td+-28>>2]=(c[td+4>>2]|0)+(c[td+8>>2]|0)-(c[td+-32>>2]|0);break}case 26:{c[td+-52>>2]=(c[td+4>>2]|0)+(c[td+8>>2]|0)-(c[td+-56>>2]|0);break}case 27:{c[td+-4>>2]=(c[td+4>>2]|0)+(c[td+8>>2]|0)-(c[td+-8>>2]|0);break}case 28:{c[td+16>>2]=h;break}case 62:case 29:{qd=td+4|0;rd=c[qd+4>>2]|0;j=j+72|0;c[j>>2]=c[qd>>2];c[j+4>>2]=rd;break}case 30:{bj(j,c[td+-8>>2]|0,c[td+-20>>2]|0,c[td+4>>2]|0);break}case 31:{bj(j,c[td+-8>>2]|0,(c[td+-20>>2]|0)+1|0,c[td+4>>2]|0);break}case 32:{bj(j,c[td+-8>>2]|0,c[td+-20>>2]|0,c[td+4>>2]|0);break}case 33:{rd=cj(j,165,c[td+-8>>2]|0,0)|0;bj(j,rd,c[td+-20>>2]|0,c[td+4>>2]|0);break}case 34:{o=td+4|0;p=td+8|0;q=dj(j,110,c[o>>2]|0,c[p>>2]|0)|0;do if(q|0?(c[q+4>>2]&67108864|0)==0:0){l=c[q+8>>2]|0;n=a[l>>0]|0;h=d[208+(n&255)>>0]|0;k=h+-116|0;n=n<<24>>24==0;if(!(n|(k|0)!=0)){m=41806;i=l;do{i=i+1|0;m=m+1|0;rd=a[i>>0]|0;k=(d[208+(rd&255)>>0]|0)-(d[208+(d[m>>0]|0)>>0]|0)|0}while(!(rd<<24>>24==0|(k|0)!=0))}if(k|0){k=h+-102|0;if(!(n|(k|0)!=0)){m=41811;do{l=l+1|0;m=m+1|0;rd=a[l>>0]|0;k=(d[208+(rd&255)>>0]|0)-(d[208+(d[m>>0]|0)>>0]|0)|0}while(!(rd<<24>>24==0|(k|0)!=0))}if(k|0)break}a[q>>0]=-97}while(0);rd=c[o>>2]|0;bj(j,q,rd,rd+(c[p>>2]|0)|0);break}case 35:{i=c[td+4>>2]|0;m=c[j+228>>2]|0;if(((m|0?(aa=m+42|0,l=b[aa>>1]|0,l<<16>>16>=1):0)?(rd=c[m+4>>2]|0,j=(l<<16>>16)+-1|0,a[rd+(j<<4)+12>>0]=i,qd=m+36|0,c[qd>>2]=c[qd>>2]|512,a[rd+(j<<4)+15>>0]&8):0)?(k=c[m+8>>2]|0,k|0):0)while(1){if(((l<<16>>16)+-1|0)==(b[c[k+4>>2]>>1]|0)){j=k+55|0;rd=d[j>>0]|d[j+1>>0]<<8|8;a[j>>0]=rd;a[j+1>>0]=rd>>8}k=c[k+20>>2]|0;if(!k)break a;l=b[aa>>1]|0}break}case 36:{ej(j,0,c[td+-8>>2]|0,c[td+4>>2]|0,c[td+-20>>2]|0);break}case 37:{fj(j,0,0,0,0,c[td+4>>2]|0,0,0,0,0,1);break}case 38:{k=c[td+-8>>2]|0;l=c[j+228>>2]|0;m=c[j>>2]|0;if((l|0?(Ob=j+200|0,(a[Ob>>0]|0)!=1):0)?(b[(c[(c[(c[m+16>>2]|0)+(d[m+164>>0]<<4)+4>>2]|0)+4>>2]|0)+22>>1]&1)==0:0){o=l+24|0;n=lj(m,c[o>>2]|0,k)|0;c[o>>2]=n;o=c[j+76>>2]|0;if(!o)break a;s=j+72|0;if(!n)break a;p=(c[n>>2]|0)+-1|0;m=c[j>>2]|0;q=c[s>>2]|0;A:do if(q){i=Qv(o|0,0,1,0)|0;h=L()|0;B:do if(c[m+272>>2]|0)if(!(a[m+81>>0]|0))rd=586;else{rd=588;break A}else{do if(0<0|(0==0?o>>>0<(e[m+276>>1]|0)>>>0:0)){k=m+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];r=m+284|0;c[r>>2]=(c[r>>2]|0)+1;r=l;break B}k=m+296|0;l=c[k>>2]|0;if(!l){k=m+292|0;break}else{c[k>>2]=c[l>>2];r=m+284|0;c[r>>2]=(c[r>>2]|0)+1;r=l;break B}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=586}while(0);if((rd|0)==586)r=Yd(m,i,h)|0;if(r){cw(r|0,q|0,o|0)|0;a[r+o>>0]=0;k=n+4+(p*20|0)+4|0;c[k>>2]=r;l=a[r>>0]|0;if((a[880+(l&255)>>0]|0)<0){h=l<<24>>24==91?93:l;i=0;l=1;while(1){m=a[r+l>>0]|0;if(m<<24>>24==h<<24>>24){l=l+1|0;m=r+i|0;if((a[r+l>>0]|0)!=h<<24>>24)break;a[m>>0]=h}else a[r+i>>0]=m;i=i+1|0;l=l+1|0}a[m>>0]=0}}else rd=588}else rd=588;while(0);if((rd|0)==588){k=n+4+(p*20|0)+4|0;c[k>>2]=0}if((d[Ob>>0]|0)<=1)break a;i=c[k>>2]|0;m=c[j>>2]|0;C:do if(!m){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](16)|0;rd=621;break}k=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){qd=c[14978]|0;pd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k)break a;l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0)break a}else{do if((e[m+276>>1]|0)>=16){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=621;break C}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=621;break C}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,16,0)|0;rd=621}while(0);if((rd|0)==621)if(!k)break a;l=k+4|0;I=l;J=I+12|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[k>>2]=i;pd=s;qd=c[pd+4>>2]|0;rd=l;c[rd>>2]=c[pd>>2];c[rd+4>>2]=qd;j=j+272|0;c[k+12>>2]=c[j>>2];c[j>>2]=k;break a}if(k|0)li(m,k);break}case 39:{gj(j,0,td+-20|0,c[td+-8>>2]|0,c[td+4>>2]|0);break}case 40:{l=c[td+4>>2]|0;k=c[j+228>>2]|0;if(k|0?(x=c[k+16>>2]|0,x|0):0)a[x+24>>0]=l;break}case 41:{m=c[j+228>>2]|0;if(m|0?(wa=(b[m+42>>1]|0)+-1|0,ba=c[j>>2]|0,ca=oj(ba,td+4|0)|0,ca|0):0){l=c[j>>2]|0;k=a[l+78>>0]|0;qd=a[l+165>>0]|0;l=Xi(l,k,ca,qd&255)|0;do if(!(qd<<24>>24)){if(!l){N=Yi(j,k,0,ca)|0;rd=636;break}if(!(c[l+12>>2]|0)){N=Yi(j,k,l,ca)|0;rd=636}}else{N=l;rd=636}while(0);if((rd|0)==636?(N|0)==0:0){if(ba|0){if(c[ba+480>>2]|0){Vd(ba,ca);break a}j=ca;if((c[ba+304>>2]|0)>>>0<=j>>>0?(c[ba+308>>2]|0)>>>0>j>>>0:0){j=ba+300|0;c[ca>>2]=c[j>>2];c[j>>2]=ca;break a}}if(!(c[7324]|0)){_a[c[29344>>2]&127](ca);break a}else{j=Ua[c[29352>>2]&127](ca)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](ca);break a}}l=m+4|0;k=c[(c[l>>2]|0)+(wa<<4)+8>>2]|0;do if(k|0){if(ba|0){if(c[ba+480>>2]|0){Vd(ba,k);break}j=k;if((c[ba+304>>2]|0)>>>0<=j>>>0?(c[ba+308>>2]|0)>>>0>j>>>0:0){j=ba+300|0;c[k>>2]=c[j>>2];c[j>>2]=k;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{j=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}}while(0);c[(c[l>>2]|0)+(wa<<4)+8>>2]=ca;k=c[m+8>>2]|0;if(k|0)do{if((wa|0)==(b[c[k+4>>2]>>1]|0))c[c[k+32>>2]>>2]=c[(c[l>>2]|0)+(wa<<4)+8>>2];k=c[k+20>>2]|0}while((k|0)!=0)}break}case 44:{c[td+16>>2]=0;break}case 45:{j=td+-8|0;c[j>>2]=c[j>>2]&~c[td+8>>2]|c[td+4>>2];break}case 46:{c[td+-8>>2]=0;c[td+-4>>2]=0;break}case 47:{c[td+-20>>2]=0;c[td+-16>>2]=0;break}case 48:{c[td+-20>>2]=c[td+4>>2];c[td+-16>>2]=255;break}case 49:{c[td+-20>>2]=c[td+4>>2]<<8;c[td+-16>>2]=65280;break}case 50:{c[td+-8>>2]=8;break}case 51:{c[td+-8>>2]=9;break}case 52:{c[td+4>>2]=10;break}case 53:{c[td+4>>2]=7;break}case 54:{c[td+-8>>2]=0;break}case 55:{c[td+-20>>2]=0;break}case 156:case 71:case 56:{c[td+-8>>2]=c[td+4>>2];break}case 227:case 201:case 198:case 75:case 58:{c[td+-8>>2]=1;break}case 59:{c[td+-8>>2]=0;break}case 61:{c[j+76>>2]=0;break}case 63:{ej(j,c[td+-32>>2]|0,c[td+4>>2]|0,c[td+-20>>2]|0,0);break}case 64:{fj(j,0,0,0,c[td+-20>>2]|0,c[td+4>>2]|0,0,0,0,0,1);break}case 65:{k=c[td+-20>>2]|0;l=c[j+228>>2]|0;m=c[j>>2]|0;if((l|0?(Pb=j+200|0,(a[Pb>>0]|0)!=1):0)?(b[(c[(c[(c[m+16>>2]|0)+(d[m+164>>0]<<4)+4>>2]|0)+4>>2]|0)+22>>1]&1)==0:0){o=l+24|0;n=lj(m,c[o>>2]|0,k)|0;c[o>>2]=n;o=c[j+76>>2]|0;if(!o)break a;s=j+72|0;if(!n)break a;p=(c[n>>2]|0)+-1|0;m=c[j>>2]|0;q=c[s>>2]|0;D:do if(q){i=Qv(o|0,0,1,0)|0;h=L()|0;E:do if(c[m+272>>2]|0)if(!(a[m+81>>0]|0))rd=695;else{rd=697;break D}else{do if(0<0|(0==0?o>>>0<(e[m+276>>1]|0)>>>0:0)){k=m+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];r=m+284|0;c[r>>2]=(c[r>>2]|0)+1;r=l;break E}k=m+296|0;l=c[k>>2]|0;if(!l){k=m+292|0;break}else{c[k>>2]=c[l>>2];r=m+284|0;c[r>>2]=(c[r>>2]|0)+1;r=l;break E}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=695}while(0);if((rd|0)==695)r=Yd(m,i,h)|0;if(r){cw(r|0,q|0,o|0)|0;a[r+o>>0]=0;k=n+4+(p*20|0)+4|0;c[k>>2]=r;l=a[r>>0]|0;if((a[880+(l&255)>>0]|0)<0){h=l<<24>>24==91?93:l;i=0;l=1;while(1){m=a[r+l>>0]|0;if(m<<24>>24==h<<24>>24){l=l+1|0;m=r+i|0;if((a[r+l>>0]|0)!=h<<24>>24)break;a[m>>0]=h}else a[r+i>>0]=m;i=i+1|0;l=l+1|0}a[m>>0]=0}}else rd=697}else rd=697;while(0);if((rd|0)==697){k=n+4+(p*20|0)+4|0;c[k>>2]=0}if((d[Pb>>0]|0)<=1)break a;i=c[k>>2]|0;m=c[j>>2]|0;F:do if(!m){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](16)|0;rd=730;break}k=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){qd=c[14978]|0;pd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k)break a;l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0)break a}else{do if((e[m+276>>1]|0)>=16){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=730;break F}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=730;break F}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,16,0)|0;rd=730}while(0);if((rd|0)==730)if(!k)break a;l=k+4|0;I=l;J=I+12|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[k>>2]=i;pd=s;qd=c[pd+4>>2]|0;rd=l;c[rd>>2]=c[pd>>2];c[rd+4>>2]=qd;j=j+272|0;c[k+12>>2]=c[j>>2];c[j>>2]=k;break a}if(k|0)li(m,k);break}case 66:{gj(j,c[td+-68>>2]|0,td+-32|0,c[td+-20>>2]|0,c[td+-8>>2]|0);l=c[td+4>>2]|0;k=c[j+228>>2]|0;if(k|0?(y=c[k+16>>2]|0,y|0):0)a[y+24>>0]=l;break}case 70:case 68:{c[td+16>>2]=11;break}case 69:{c[td+-20>>2]=c[td+4>>2];break}case 72:{c[td+4>>2]=4;break}case 157:case 73:{c[td+4>>2]=5;break}case 74:{hj(j,c[td+4>>2]|0,0,c[td+-8>>2]|0);break}case 77:{h=td+-44|0;i=td+-32|0;o=c[td+-20>>2]|0;l=c[td+4>>2]|0;k=c[td+-80>>2]|0;m=c[td+-56>>2]|0;p=c[j>>2]|0;if((b[j+196>>1]|0)<=0){$i(j,h,i,k,1,0,m);n=c[j+228>>2]|0;if((n|0)!=0?(c[j+36>>2]|0)==0:0){k=c[j>>2]|0;do if(c[td+-28>>2]|0){if(a[k+165>>0]|0){ad(j,39404,Ha);h=0;break}if((uk(k,h)|0)<0){c[Ka>>2]=h;ad(j,39421,Ka);h=i}else h=i}while(0);m=c[n+72>>2]|0;if(!m)k=-1e6;else{i=c[p+16>>2]|0;k=0;while(1)if((c[i+(k<<4)+12>>2]|0)==(m|0))break;else k=k+1|0}pd=c[j>>2]|0;c[Qb>>2]=j;pd=c[pd+16>>2]|0;c[Qb+12>>2]=c[pd+(k<<4)>>2];c[Qb+4>>2]=c[pd+(k<<4)+12>>2];c[Qb+16>>2]=39579;c[Qb+20>>2]=h;c[Qb+8>>2]=(k|0)==1&1;if(!(al(Qb,l)|0)){if((d[j+200>>0]|0)>1)k=0;else{k=l;l=dk(p,l,1)|0}c[n+12>>2]=l;c[n+24>>2]=ek(p,o,1)|0;if(!(a[p+81>>0]|0)){m=j+188|0;l=c[m>>2]|0;m=c[m+4>>2]|0;i=_c;c[i>>2]=l;c[i+4>>2]=m;i=l;if((a[i>>0]|0)!=59){l=i+m|0;c[_c>>2]=l}m=_c+4|0;c[m>>2]=0;i=c[td+-92>>2]|0;l=l-i|0;do l=l+-1|0;while((a[880+(d[i+l>>0]|0)>>0]&1)!=0);c[_c>>2]=i+l;c[m>>2]=1;aj(j,0,_c,0,0)}}else k=l}else k=l}else{ad(j,43004,la);k=l}if(k|0)ni(p,k,1);if((d[j+200>>0]|0)>1){if(o|0){k=qd+8|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[qd>>2]=j;c[qd+4>>2]=124;k=c[o>>2]|0;if((k|0)>0){l=o+4|0;while(1){m=c[l>>2]|0;if(m|0?Yj(qd,m)|0:0)break;if((k|0)>1){k=k+-1|0;l=l+20|0}else break}h=c[o>>2]|0;if((h|0)>0){m=j+272|0;l=0;do{i=c[o+4+(l*20|0)+4>>2]|0;k=c[m>>2]|0;G:do if(k|0){while(1){if((c[k>>2]|0)==(i|0))break;k=c[k+12>>2]|0;if(!k)break G}c[k>>2]=0}while(0);l=l+1|0}while((l|0)!=(h|0))}}rd=781}}else rd=781;if((rd|0)==781?o|0:0)pi(p,o);break}case 78:{hj(j,c[td+4>>2]|0,1,c[td+-8>>2]|0);break}case 79:{c[qd>>2]=c[7517];c[qd+4>>2]=c[7518];c[qd+8>>2]=c[7519];c[qd+12>>2]=c[7520];c[qd+16>>2]=c[7521];c[qd+20>>2]=c[7522];k=td+4|0;ij(j,c[k>>2]|0,qd)|0;k=c[k>>2]|0;if(k|0)ni(c[j>>2]|0,k,1);break}case 80:{q=c[td+4>>2]|0;do if(!q){o=c[j>>2]|0;p=c[td+-8>>2]|0;if(p|0){H:do if((c[p>>2]|0)>0){m=o+480|0;i=o+304|0;h=o+308|0;n=o+300|0;if(!o){l=0;while(1){k=c[p+8+(l<<4)+4>>2]|0;if(k|0)pi(0,k);k=c[p+8+(l<<4)+8>>2]|0;if(k|0)ni(0,k,1);k=c[p+8+(l<<4)>>2]|0;do if(k|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{j=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}while(0);l=l+1|0;if((l|0)>=(c[p>>2]|0))break H}}l=0;do{k=c[p+8+(l<<4)+4>>2]|0;if(k|0)pi(o,k);k=c[p+8+(l<<4)+8>>2]|0;if(k|0)ni(o,k,1);k=c[p+8+(l<<4)>>2]|0;do if(k|0){if(c[m>>2]|0){Vd(o,k);break}j=k;if((c[i>>2]|0)>>>0<=j>>>0?(c[h>>2]|0)>>>0>j>>>0:0){c[k>>2]=c[n>>2];c[n>>2]=k;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{j=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}}while(0);l=l+1|0}while((l|0)<(c[p>>2]|0))}while(0);if(o|0){if(c[o+480>>2]|0){Vd(o,p);break}j=p;if((c[o+304>>2]|0)>>>0<=j>>>0?(c[o+308>>2]|0)>>>0>j>>>0:0){j=o+300|0;c[p>>2]=c[j>>2];c[j>>2]=p;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](p);break}else{j=Ua[c[29352>>2]&127](p)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](p);break}}}else{c[q+64>>2]=c[td+-8>>2];k=c[q+52>>2]|0;if(k|0){c[q+56>>2]=0;h=q+8|0;c[h>>2]=c[h>>2]|256;m=q;i=0;while(1){i=i+1|0;l=c[k+52>>2]|0;c[k+56>>2]=m;rd=k+8|0;c[rd>>2]=c[rd>>2]|256;if(!l)break;else{m=k;k=l}}if((c[h>>2]&1024|0)==0?(rd=c[(c[j>>2]|0)+124>>2]|0,(rd|0)>0&(i|0)>=(rd|0)):0)ad(j,44434,ma)}}while(0);c[td+-20>>2]=q;break}case 81:{q=c[td+4>>2]|0;do if(!q){o=c[j>>2]|0;p=c[td+-8>>2]|0;if(p|0){I:do if((c[p>>2]|0)>0){m=o+480|0;i=o+304|0;h=o+308|0;n=o+300|0;if(!o){l=0;while(1){k=c[p+8+(l<<4)+4>>2]|0;if(k|0)pi(0,k);k=c[p+8+(l<<4)+8>>2]|0;if(k|0)ni(0,k,1);k=c[p+8+(l<<4)>>2]|0;do if(k|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{j=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}while(0);l=l+1|0;if((l|0)>=(c[p>>2]|0))break I}}l=0;do{k=c[p+8+(l<<4)+4>>2]|0;if(k|0)pi(o,k);k=c[p+8+(l<<4)+8>>2]|0;if(k|0)ni(o,k,1);k=c[p+8+(l<<4)>>2]|0;do if(k|0){if(c[m>>2]|0){Vd(o,k);break}j=k;if((c[i>>2]|0)>>>0<=j>>>0?(c[h>>2]|0)>>>0>j>>>0:0){c[k>>2]=c[n>>2];c[n>>2]=k;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{j=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}}while(0);l=l+1|0}while((l|0)<(c[p>>2]|0))}while(0);if(o|0){if(c[o+480>>2]|0){Vd(o,p);break}j=p;if((c[o+304>>2]|0)>>>0<=j>>>0?(c[o+308>>2]|0)>>>0>j>>>0:0){j=o+300|0;c[p>>2]=c[j>>2];c[j>>2]=p;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](p);break}else{j=Ua[c[29352>>2]&127](p)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](p);break}}}else{c[q+64>>2]=c[td+-8>>2];k=c[q+52>>2]|0;if(k|0){c[q+56>>2]=0;h=q+8|0;c[h>>2]=c[h>>2]|256;m=q;i=0;while(1){i=i+1|0;l=c[k+52>>2]|0;c[k+56>>2]=m;rd=k+8|0;c[rd>>2]=c[rd>>2]|256;if(!l)break;else{m=k;k=l}}if((c[h>>2]&1024|0)==0?(rd=c[(c[j>>2]|0)+124>>2]|0,(rd|0)>0&(i|0)>=(rd|0)):0)ad(j,44434,oa)}}while(0);c[td+-32>>2]=q;break}case 82:{h=td+4|0;n=c[h>>2]|0;if(n|0?(da=c[n+52>>2]|0,da|0):0){c[n+56>>2]=0;o=n+8|0;c[o>>2]=c[o>>2]|256;m=n;i=0;l=da;while(1){i=i+1|0;k=c[l+52>>2]|0;c[l+56>>2]=m;rd=l+8|0;c[rd>>2]=c[rd>>2]|256;if(!k)break;else{m=l;l=k}}if((c[o>>2]&1024|0)==0?(rd=c[(c[j>>2]|0)+124>>2]|0,(rd|0)>0&(i|0)>=(rd|0)):0)ad(j,44434,pa)}c[h>>2]=n;break}case 83:{k=c[td+4>>2]|0;p=td+-20|0;o=c[p>>2]|0;do if(k){l=k+52|0;m=c[l>>2]|0;if(m){c[qd+4>>2]=0;c[k+56>>2]=0;n=k+8|0;c[n>>2]=c[n>>2]|256;i=k;h=0;while(1){h=h+1|0;l=c[m+52>>2]|0;c[m+56>>2]=i;pd=m+8|0;c[pd>>2]=c[pd>>2]|256;if(!l)break;else{i=m;m=l}}if((c[n>>2]&1024|0)==0?(pd=c[(c[j>>2]|0)+124>>2]|0,(pd|0)>0&(h|0)>=(pd|0)):0)ad(j,44434,Na);l=kj(j,0,jj(j,0,0,0,qd,k,0,0)|0,0,0,0,0,0,0)|0;if(!l){rd=899;break}k=l;l=l+52|0}m=td+-8|0;a[k+4>>0]=c[m>>2];c[l>>2]=o;if(o|0){qd=o+8|0;c[qd>>2]=c[qd>>2]&-1025}qd=k+8|0;c[qd>>2]=c[qd>>2]&-1025;if((c[m>>2]|0)!=128)a[j+22>>0]=1}else rd=899;while(0);if((rd|0)==899)if(!o)k=0;else{ni(c[j>>2]|0,o,1);k=0}c[p>>2]=k;break}case 86:case 84:{c[td+4>>2]=e[td+2>>1];break}case 85:{c[td+-8>>2]=128;break}case 87:{c[td+-92>>2]=kj(j,c[td+-68>>2]|0,c[td+-56>>2]|0,c[td+-44>>2]|0,c[td+-32>>2]|0,c[td+-20>>2]|0,c[td+-8>>2]|0,c[td+-80>>2]|0,c[td+4>>2]|0)|0;break}case 88:{k=kj(j,c[td+-80>>2]|0,c[td+-68>>2]|0,c[td+-56>>2]|0,c[td+-44>>2]|0,c[td+-32>>2]|0,c[td+-8>>2]|0,c[td+-92>>2]|0,c[td+4>>2]|0)|0;c[td+-104>>2]=k;if(k|0){c[k+72>>2]=c[td+-20>>2];break a}l=c[j>>2]|0;k=c[td+-20>>2]|0;if(k|0)do{j=k;k=c[k+32>>2]|0;mi(l,j)}while((k|0)!=0);break}case 89:{c[td+-32>>2]=kj(j,c[td+-8>>2]|0,0,0,0,0,0,512,0)|0;break}case 90:{m=td+-44|0;k=c[m>>2]|0;l=kj(j,c[td+-8>>2]|0,0,0,0,0,0,1536,0)|0;if(k|0){j=k+8|0;c[j>>2]=c[j>>2]&-1025}if(l){a[l+4>>0]=-128;c[l+52>>2]=k;k=l}c[m>>2]=k;break}case 91:{c[td+4>>2]=1;break}case 92:{c[td+4>>2]=2;break}case 222:case 217:case 214:case 134:case 127:case 94:{c[td+16>>2]=0;break}case 95:{r=td+-44|0;k=lj(c[j>>2]|0,c[r>>2]|0,c[td+-20>>2]|0)|0;c[r>>2]=k;o=c[td+8>>2]|0;if(o){s=td+4|0;J:do if(k|0){p=(c[k>>2]|0)+-1|0;i=c[j>>2]|0;q=c[s>>2]|0;K:do if(q){h=Qv(o|0,0,1,0)|0;n=L()|0;L:do if(c[i+272>>2]|0)if(!(a[i+81>>0]|0))rd=932;else{rd=934;break K}else{do if(0<0|(0==0?o>>>0<(e[i+276>>1]|0)>>>0:0)){l=i+300|0;m=c[l>>2]|0;if(m|0){c[l>>2]=c[m>>2];n=i+284|0;c[n>>2]=(c[n>>2]|0)+1;n=m;break L}l=i+296|0;m=c[l>>2]|0;if(!m){l=i+292|0;break}else{c[l>>2]=c[m>>2];n=i+284|0;c[n>>2]=(c[n>>2]|0)+1;n=m;break L}}else l=i+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1;rd=932}while(0);if((rd|0)==932)n=Yd(i,h,n)|0;if(n){cw(n|0,q|0,o|0)|0;a[n+o>>0]=0;k=k+4+(p*20|0)+4|0;c[k>>2]=n;l=a[n>>0]|0;if((a[880+(l&255)>>0]|0)<0){h=l<<24>>24==91?93:l;i=0;l=1;while(1){m=a[n+l>>0]|0;if(m<<24>>24==h<<24>>24){l=l+1|0;m=n+i|0;if((a[n+l>>0]|0)!=h<<24>>24)break;a[m>>0]=h}else a[n+i>>0]=m;i=i+1|0;l=l+1|0}a[m>>0]=0}}else rd=934}else rd=934;while(0);if((rd|0)==934){k=k+4+(p*20|0)+4|0;c[k>>2]=0}if((d[j+200>>0]|0)>1){i=c[k>>2]|0;m=c[j>>2]|0;M:do if(!m){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](16)|0;rd=967;break}k=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){qd=c[14978]|0;pd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k)break J;l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0)break J}else{do if((e[m+276>>1]|0)>=16){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=967;break M}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=967;break M}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,16,0)|0;rd=967}while(0);if((rd|0)==967)if(!k)break;l=k+4|0;I=l;J=I+12|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[k>>2]=i;od=s;pd=c[od+4>>2]|0;qd=l;c[qd>>2]=c[od>>2];c[qd+4>>2]=pd;qd=j+272|0;c[k+12>>2]=c[qd>>2];c[qd>>2]=k}}while(0);k=c[r>>2]|0}l=c[td+-32>>2]|0;m=c[td+-8>>2]|0;o=c[j>>2]|0;if(k|0){p=k+4+(((c[k>>2]|0)+-1|0)*20|0)+8|0;k=c[p>>2]|0;do if(k|0){if(o|0){if(c[o+480>>2]|0){Vd(o,k);break}j=k;if((c[o+304>>2]|0)>>>0<=j>>>0?(c[o+308>>2]|0)>>>0>j>>>0:0){j=o+300|0;c[k>>2]=c[j>>2];c[j>>2]=k;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{j=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}}while(0);n=l;while(1)if(!(a[880+(d[n>>0]|0)>>0]&1))break;else n=n+1|0;k=m-n|0;N:do if((k|0)<=0)if(!n)k=0;else{l=k;rd=988}else while(1){l=k+-1|0;if(!(a[880+(d[n+l>>0]|0)>>0]&1)){l=k;rd=988;break N}if((k|0)>1)k=l;else{rd=988;break}}while(0);O:do if((rd|0)==988){i=Qv(l|0,((l|0)<0)<<31>>31|0,1,0)|0;h=L()|0;P:do if(c[o+272>>2]|0)if(!(a[o+81>>0]|0))rd=998;else{k=0;break O}else{do if(!(h>>>0>0|((h|0)==0?i>>>0>(e[o+276>>1]|0)>>>0:0))){m=o+300|0;k=c[m>>2]|0;if(k|0){c[m>>2]=c[k>>2];j=o+284|0;c[j>>2]=(c[j>>2]|0)+1;break P}m=o+296|0;k=c[m>>2]|0;if(!k){k=o+292|0;break}else{c[m>>2]=c[k>>2];j=o+284|0;c[j>>2]=(c[j>>2]|0)+1;break P}}else k=o+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=998}while(0);if((rd|0)==998)k=Yd(o,i,h)|0;if(!k)k=0;else{cw(k|0,n|0,l|0)|0;a[k+l>>0]=0}}while(0);c[p>>2]=k}break}case 96:{rd=c[j>>2]|0;c[qd>>2]=0;c[qd+4>>2]=0;qd=mj(rd,172,qd,0)|0;rd=td+-20|0;c[rd>>2]=lj(c[j>>2]|0,c[rd>>2]|0,qd)|0;break}case 97:{qd=cj(j,172,0,0)|0;qd=cj(j,134,mj(c[j>>2]|0,59,td+-20|0,1)|0,qd)|0;rd=td+-44|0;c[rd>>2]=lj(c[j>>2]|0,c[rd>>2]|0,qd)|0;break}case 239:case 238:case 109:case 98:{qd=td+4|0;rd=c[qd+4>>2]|0;j=td+-8|0;c[j>>2]=c[qd>>2];c[j+4>>2]=rd;break}case 100:{m=c[j>>2]|0;Q:do if(!m){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](80)|0;rd=1028;break}k=Ua[c[29356>>2]&127](80)|0;if((c[14985]|0)>>>0<80)c[14985]=80;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){j=c[14978]|0;qd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;pd=L()|0;c[14768]=((pd|0)<0|(pd|0)==0&qd>>>0<=j>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(k){l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0){c[14987]=l;rd=1029}else rd=1029}else k=0}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0){k=0;break}}else{do if((e[m+276>>1]|0)>=80){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1028;break Q}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1028;break Q}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,80,0)|0;rd=1028}while(0);if((rd|0)==1028)if(!k)k=0;else rd=1029;if((rd|0)==1029){I=k;J=I+80|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0))}c[td+16>>2]=k;break}case 101:{l=c[td+4>>2]|0;c[td+-8>>2]=l;if(l|0){k=c[l>>2]|0;if((k|0)>1)do{j=k;k=k+-1|0;a[l+8+(k*72|0)+36>>0]=a[l+8+((j+-2|0)*72|0)+36>>0]|0}while((j|0)>2);a[l+44>>0]=0}break}case 102:{k=c[td+-8>>2]|0;if(k|0?(p=c[k>>2]|0,(p|0)>0):0)a[k+8+((p+-1|0)*72|0)+36>>0]=c[td+4>>2];break}case 103:{c[td+16>>2]=0;break}case 104:{l=td+-68|0;k=jj(j,c[l>>2]|0,td+-56|0,td+-44|0,td+-32|0,0,c[td+-8>>2]|0,c[td+4>>2]|0)|0;c[l>>2]=k;l=td+-20|0;if(k|0?(P=c[td+-16>>2]|0,P|0):0){m=(c[k>>2]|0)+-1|0;if((P|0)==1?(c[l>>2]|0)==0:0){j=k+8+(m*72|0)+37|0;a[j>>0]=a[j>>0]|1;break a}c[k+8+(m*72|0)+64>>2]=oj(c[j>>2]|0,l)|0;j=k+8+(m*72|0)+37|0;a[j>>0]=a[j>>0]|2}break}case 105:{l=td+-92|0;k=jj(j,c[l>>2]|0,td+-80|0,td+-68|0,td+-20|0,0,c[td+-8>>2]|0,c[td+4>>2]|0)|0;c[l>>2]=k;l=c[td+-44>>2]|0;if(k|0){j=(c[k>>2]|0)+-1|0;c[k+8+(j*72|0)+64>>2]=l;j=k+8+(j*72|0)+37|0;a[j>>0]=a[j>>0]|4;break a}if(l|0)pi(c[j>>2]|0,l);break}case 106:{rd=td+-68|0;c[rd>>2]=jj(j,c[rd>>2]|0,0,0,td+-20|0,c[td+-44>>2]|0,c[td+-8>>2]|0,c[td+4>>2]|0)|0;break}case 107:{i=td+-68|0;l=c[i>>2]|0;if((((l|0)==0?(c[td+-16>>2]|0)==0:0)?(c[td+-8>>2]|0)==0:0)?(c[td+4>>2]|0)==0:0){c[i>>2]=c[td+-44>>2];break a}p=td+-44|0;m=c[p>>2]|0;k=c[m>>2]|0;if((k|0)==1){o=jj(j,l,0,0,td+-20|0,0,c[td+-8>>2]|0,c[td+4>>2]|0)|0;c[i>>2]=o;if(o|0){k=(c[o>>2]|0)+-1|0;l=c[p>>2]|0;m=l+16|0;c[o+8+(k*72|0)+8>>2]=c[m>>2];i=l+12|0;c[o+8+(k*72|0)+4>>2]=c[i>>2];h=l+28|0;c[o+8+(k*72|0)+20>>2]=c[h>>2];n=l+45|0;if(a[n>>0]&4){rd=l+72|0;c[o+8+(k*72|0)+64>>2]=c[rd>>2];c[rd>>2]=0;a[n>>0]=a[n>>0]&-5;rd=o+8+(k*72|0)+37|0;a[rd>>0]=a[rd>>0]|4}c[i>>2]=0;c[m>>2]=0;c[h>>2]=0}oi(c[j>>2]|0,c[p>>2]|0);break a}if(!m)k=0;else{if((k|0)>1)do{rd=k;k=k+-1|0;a[m+8+(k*72|0)+36>>0]=a[m+8+((rd+-2|0)*72|0)+36>>0]|0}while((rd|0)>2);a[m+44>>0]=0;k=c[p>>2]|0}rd=kj(j,0,k,0,0,0,0,2048,0)|0;c[i>>2]=jj(j,c[i>>2]|0,0,0,td+-20|0,rd,c[td+-8>>2]|0,c[td+4>>2]|0)|0;break}case 122:case 108:{c[td+16>>2]=0;c[td+20>>2]=0;break}case 110:{i=td+4|0;h=nj(j,0,i,0)|0;R:do if(!((h|0)==0|(d[j+200>>0]|0)<2)){n=c[h+16>>2]|0;m=c[j>>2]|0;S:do if(!m){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](16)|0;rd=1093;break}k=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){qd=c[14978]|0;pd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k)break R;l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0)break R}else{do if((e[m+276>>1]|0)>=16){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1093;break S}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1093;break S}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,16,0)|0;rd=1093}while(0);if((rd|0)==1093)if(!k)break;l=k+4|0;I=l;J=I+12|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[k>>2]=n;pd=i;qd=c[pd+4>>2]|0;rd=l;c[rd>>2]=c[pd>>2];c[rd+4>>2]=qd;j=j+272|0;c[k+12>>2]=c[j>>2];c[j>>2]=k}while(0);c[i>>2]=h;break}case 111:{i=td+-20|0;h=td+4|0;n=nj(j,0,i,h)|0;T:do if(!((n|0)==0|(d[j+200>>0]|0)<2)){o=c[n+16>>2]|0;m=c[j>>2]|0;U:do if(!m){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](16)|0;rd=1120;break}k=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){qd=c[14978]|0;pd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k)break T;l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0)break T}else{do if((e[m+276>>1]|0)>=16){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1120;break U}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1120;break U}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,16,0)|0;rd=1120}while(0);if((rd|0)==1120)if(!k)break;l=k+4|0;I=l;J=I+12|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[k>>2]=o;pd=h;qd=c[pd+4>>2]|0;rd=l;c[rd>>2]=c[pd>>2];c[rd+4>>2]=qd;j=j+272|0;c[k+12>>2]=c[j>>2];c[j>>2]=k}while(0);c[i>>2]=n;break}case 112:{rd=td+4|0;c[rd>>2]=nj(j,0,rd,0)|0;break}case 113:{rd=td+-20|0;c[rd>>2]=nj(j,0,rd,td+4|0)|0;break}case 114:{k=td+-44|0;rd=nj(j,0,k,td+-20|0)|0;c[k>>2]=rd;if(rd|0){j=oj(c[j>>2]|0,td+4|0)|0;c[(c[k>>2]|0)+20>>2]=j}break}case 115:{k=td+-20|0;rd=nj(j,0,k,0)|0;c[k>>2]=rd;if(rd|0){j=oj(c[j>>2]|0,td+4|0)|0;c[(c[k>>2]|0)+20>>2]=j}break}case 116:{c[td+4>>2]=1;break}case 117:{rd=td+-8|0;c[rd>>2]=pj(j,rd,0,0)|0;break}case 118:{rd=td+-20|0;c[rd>>2]=pj(j,rd,td+-8|0,0)|0;break}case 119:{rd=td+-32|0;c[rd>>2]=pj(j,rd,td+-20|0,td+-8|0)|0;break}case 231:case 210:case 144:case 137:case 120:{c[td+-8>>2]=c[td+4>>2];break}case 232:case 213:case 211:case 143:case 138:case 136:case 121:{c[td+16>>2]=0;break}case 123:{qd=td+4|0;rd=c[qd+4>>2]|0;j=td+-20|0;c[j>>2]=c[qd>>2];c[j+4>>2]=rd;break}case 124:{c[td+-8>>2]=0;c[td+-4>>2]=1;break}case 125:{c[td+-32>>2]=c[td+-8>>2];break}case 158:case 126:{c[td+16>>2]=0;break}case 135:case 128:{c[td+-20>>2]=c[td+4>>2];break}case 129:{l=td+-32|0;k=lj(c[j>>2]|0,c[l>>2]|0,c[td+-8>>2]|0)|0;c[l>>2]=k;l=c[td+4>>2]|0;if(!((k|0)==0|(l|0)<0))a[k+4+(((c[k>>2]|0)+-1|0)*20|0)+12>>0]=l;break}case 130:{l=td+-8|0;k=lj(c[j>>2]|0,0,c[l>>2]|0)|0;c[l>>2]=k;l=c[td+4>>2]|0;if(!((k|0)==0|(l|0)<0))a[k+4+(((c[k>>2]|0)+-1|0)*20|0)+12>>0]=l;break}case 131:{c[td+4>>2]=0;break}case 132:{c[td+4>>2]=1;break}case 133:{c[td+16>>2]=-1;break}case 139:{c[td+-8>>2]=cj(j,141,c[td+4>>2]|0,0)|0;break}case 140:{c[td+-32>>2]=cj(j,141,c[td+-20>>2]|0,c[td+4>>2]|0)|0;break}case 141:{c[td+-32>>2]=cj(j,141,c[td+4>>2]|0,c[td+-20>>2]|0)|0;break}case 142:{k=td+-20|0;l=c[k>>2]|0;m=td+-8|0;do if(l|0?(Y=c[td+-4>>2]|0,Y|0):0){i=(c[l>>2]|0)+-1|0;if((Y|0)==1?(c[m>>2]|0)==0:0){rd=l+8+(i*72|0)+37|0;a[rd>>0]=a[rd>>0]|1;break}c[l+8+(i*72|0)+64>>2]=oj(c[j>>2]|0,m)|0;rd=l+8+(i*72|0)+37|0;a[rd>>0]=a[rd>>0]|2}while(0);qj(j,c[k>>2]|0,c[td+4>>2]|0);break}case 145:{i=td+-44|0;k=c[i>>2]|0;l=td+-32|0;do if(k|0?(Z=c[td+-28>>2]|0,Z|0):0){m=(c[k>>2]|0)+-1|0;if((Z|0)==1?(c[l>>2]|0)==0:0){rd=k+8+(m*72|0)+37|0;a[rd>>0]=a[rd>>0]|1;break}c[k+8+(m*72|0)+64>>2]=oj(c[j>>2]|0,l)|0;rd=k+8+(m*72|0)+37|0;a[rd>>0]=a[rd>>0]|2}while(0);l=td+-8|0;k=c[l>>2]|0;if(k){if((c[k>>2]|0)>(c[(c[j>>2]|0)+116>>2]|0)){c[ha>>2]=38493;ad(j,44753,ha);k=c[l>>2]|0}}else k=0;rj(j,c[i>>2]|0,k,c[td+4>>2]|0,c[td+-56>>2]|0,0);break}case 146:{s=td+-44|0;n=lj(c[j>>2]|0,c[s>>2]|0,c[td+4>>2]|0)|0;c[s>>2]=n;s=td+-20|0;if(n|0){o=(c[n>>2]|0)+-1|0;m=c[j>>2]|0;p=c[s>>2]|0;q=c[td+-16>>2]|0;V:do if(p){i=Qv(q|0,0,1,0)|0;h=L()|0;W:do if(c[m+272>>2]|0)if(!(a[m+81>>0]|0))rd=1179;else{rd=1181;break V}else{do if(0<0|(0==0?q>>>0<(e[m+276>>1]|0)>>>0:0)){k=m+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];r=m+284|0;c[r>>2]=(c[r>>2]|0)+1;r=l;break W}k=m+296|0;l=c[k>>2]|0;if(!l){k=m+292|0;break}else{c[k>>2]=c[l>>2];r=m+284|0;c[r>>2]=(c[r>>2]|0)+1;r=l;break W}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=1179}while(0);if((rd|0)==1179)r=Yd(m,i,h)|0;if(r){cw(r|0,p|0,q|0)|0;a[r+q>>0]=0;k=n+4+(o*20|0)+4|0;c[k>>2]=r;l=a[r>>0]|0;if((a[880+(l&255)>>0]|0)<0){h=l<<24>>24==91?93:l;i=0;l=1;while(1){m=a[r+l>>0]|0;if(m<<24>>24==h<<24>>24){l=l+1|0;m=r+i|0;if((a[r+l>>0]|0)!=h<<24>>24)break;a[m>>0]=h}else a[r+i>>0]=m;i=i+1|0;l=l+1|0}a[m>>0]=0}}else rd=1181}else rd=1181;while(0);if((rd|0)==1181){k=n+4+(o*20|0)+4|0;c[k>>2]=0}if((d[j+200>>0]|0)>1){i=c[k>>2]|0;m=c[j>>2]|0;X:do if(!m){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](16)|0;rd=1214;break}k=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){qd=c[14978]|0;pd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k)break a;l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0)break a}else{do if((e[m+276>>1]|0)>=16){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1214;break X}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1214;break X}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,16,0)|0;rd=1214}while(0);if((rd|0)==1214)if(!k)break a;l=k+4|0;I=l;J=I+12|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[k>>2]=i;pd=s;qd=c[pd+4>>2]|0;rd=l;c[rd>>2]=c[pd>>2];c[rd+4>>2]=qd;j=j+272|0;c[k+12>>2]=c[j>>2];c[j>>2]=k}}break}case 147:{rd=td+-68|0;c[rd>>2]=sj(j,c[rd>>2]|0,c[td+-32>>2]|0,c[td+4>>2]|0)|0;break}case 148:{r=lj(c[j>>2]|0,0,c[td+4>>2]|0)|0;s=td+-20|0;Y:do if(r|0){n=(c[r>>2]|0)+-1|0;m=c[j>>2]|0;o=c[s>>2]|0;p=c[td+-16>>2]|0;Z:do if(o){i=Qv(p|0,0,1,0)|0;h=L()|0;_:do if(c[m+272>>2]|0)if(!(a[m+81>>0]|0))rd=1229;else{rd=1231;break Z}else{do if(0<0|(0==0?p>>>0<(e[m+276>>1]|0)>>>0:0)){k=m+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];q=m+284|0;c[q>>2]=(c[q>>2]|0)+1;q=l;break _}k=m+296|0;l=c[k>>2]|0;if(!l){k=m+292|0;break}else{c[k>>2]=c[l>>2];q=m+284|0;c[q>>2]=(c[q>>2]|0)+1;q=l;break _}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=1229}while(0);if((rd|0)==1229)q=Yd(m,i,h)|0;if(q){cw(q|0,o|0,p|0)|0;a[q+p>>0]=0;k=r+4+(n*20|0)+4|0;c[k>>2]=q;l=a[q>>0]|0;if((a[880+(l&255)>>0]|0)<0){h=l<<24>>24==91?93:l;i=0;l=1;while(1){m=a[q+l>>0]|0;if(m<<24>>24==h<<24>>24){l=l+1|0;m=q+i|0;if((a[q+l>>0]|0)!=h<<24>>24)break;a[m>>0]=h}else a[q+i>>0]=m;i=i+1|0;l=l+1|0}a[m>>0]=0}}else rd=1231}else rd=1231;while(0);if((rd|0)==1231){k=r+4+(n*20|0)+4|0;c[k>>2]=0}if((d[j+200>>0]|0)>1){i=c[k>>2]|0;m=c[j>>2]|0;$:do if(!m){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](16)|0;rd=1264;break}k=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){qd=c[14978]|0;pd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k)break Y;l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0)break Y}else{do if((e[m+276>>1]|0)>=16){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1264;break $}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1264;break $}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,16,0)|0;rd=1264}while(0);if((rd|0)==1264)if(!k)break;l=k+4|0;I=l;J=I+12|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[k>>2]=i;pd=s;qd=c[pd+4>>2]|0;rd=l;c[rd>>2]=c[pd>>2];c[rd+4>>2]=qd;j=j+272|0;c[k+12>>2]=c[j>>2];c[j>>2]=k}}while(0);c[s>>2]=r;break}case 149:{c[td+-44>>2]=sj(j,0,c[td+-32>>2]|0,c[td+4>>2]|0)|0;break}case 150:{tj(j,c[td+-32>>2]|0,c[td+-8>>2]|0,c[td+-20>>2]|0,c[td+-56>>2]|0,c[td+4>>2]|0);break}case 151:{tj(j,c[td+-32>>2]|0,0,c[td+-20>>2]|0,c[td+-56>>2]|0,0);break}case 152:{c[td+16>>2]=0;break}case 153:{i=c[j>>2]|0;h=c[td+-80>>2]|0;n=c[td+-56>>2]|0;o=c[td+-8>>2]|0;p=c[td+4>>2]|0;aa:do if(!i){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](36)|0;rd=1294;break}k=Ua[c[29356>>2]&127](36)|0;if((c[14985]|0)>>>0<36)c[14985]=36;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){j=c[14978]|0;rd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;qd=L()|0;c[14768]=((qd|0)<0|(qd|0)==0&rd>>>0<=j>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(k){l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0){c[14987]=l;rd=1303}else rd=1303}else rd=1295}else{if(c[i+272>>2]|0){if(a[i+81>>0]|0){rd=1295;break}}else{do if((e[i+276>>1]|0)>=36){l=i+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=i+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1294;break aa}l=i+296|0;k=c[l>>2]|0;if(!k){k=i+292|0;break}else{c[l>>2]=c[k>>2];rd=i+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1294;break aa}}else k=i+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(i,36,0)|0;rd=1294}while(0);if((rd|0)==1294)if(!k)rd=1295;else rd=1303;if((rd|0)==1295){if(h|0)pi(i,h);if(n|0)li(i,n);if(o|0)pi(i,o);if(!p)k=0;else{li(i,p);k=0}}else if((rd|0)==1303){c[k>>2]=h;c[k+4>>2]=n;c[k+8>>2]=o;c[k+12>>2]=p;c[k+16>>2]=0}c[td+-116>>2]=k;break}case 154:{i=c[j>>2]|0;h=c[td+-44>>2]|0;n=c[td+-20>>2]|0;ba:do if(!i){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](36)|0;rd=1328;break}k=Ua[c[29356>>2]&127](36)|0;if((c[14985]|0)>>>0<36)c[14985]=36;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){j=c[14978]|0;rd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;qd=L()|0;c[14768]=((qd|0)<0|(qd|0)==0&rd>>>0<=j>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(k){l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0){c[14987]=l;rd=1333}else rd=1333}else rd=1329}else{if(c[i+272>>2]|0){if(a[i+81>>0]|0){rd=1329;break}}else{do if((e[i+276>>1]|0)>=36){l=i+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=i+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1328;break ba}l=i+296|0;k=c[l>>2]|0;if(!k){k=i+292|0;break}else{c[l>>2]=c[k>>2];rd=i+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1328;break ba}}else k=i+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(i,36,0)|0;rd=1328}while(0);if((rd|0)==1328)if(!k)rd=1329;else rd=1333;if((rd|0)==1329){if(h|0)pi(i,h);if(!n)k=0;else{li(i,n);k=0}}else if((rd|0)==1333){c[k>>2]=h;c[k+4>>2]=n;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0}c[td+-80>>2]=k;break}case 155:{m=c[j>>2]|0;ca:do if(!m){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](36)|0;rd=1358;break}k=Ua[c[29356>>2]&127](36)|0;if((c[14985]|0)>>>0<36)c[14985]=36;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){j=c[14978]|0;qd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;pd=L()|0;c[14768]=((pd|0)<0|(pd|0)==0&qd>>>0<=j>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(k){l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0){c[14987]=l;rd=1359}else rd=1359}else k=0}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0){k=0;break}}else{do if((e[m+276>>1]|0)>=36){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1358;break ca}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1358;break ca}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,36,0)|0;rd=1358}while(0);if((rd|0)==1358)if(!k)k=0;else rd=1359;if((rd|0)==1359){c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0}c[td+-32>>2]=k;break}case 159:{c[td+-20>>2]=c[td+-8>>2];break}case 160:{rd=td+-20|0;c[rd>>2]=uj(j,c[rd>>2]|0,td+4|0)|0;break}case 161:{rd=td+4|0;c[rd>>2]=uj(j,0,rd)|0;break}case 162:{c[td+-20>>2]=c[td+-8>>2];break}case 164:case 163:{rd=td+4|0;c[rd>>2]=dj(j,59,c[rd>>2]|0,c[td+8>>2]|0)|0;break}case 165:{h=td+-20|0;n=mj(c[j>>2]|0,59,h,1)|0;i=td+4|0;o=mj(c[j>>2]|0,59,i,1)|0;da:do if((d[j+200>>0]|0)>1){m=c[j>>2]|0;ea:do if(!m){if(!(c[7324]|0)){La=Ua[c[29340>>2]&127](16)|0;rd=1390;break}k=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){qd=c[14978]|0;pd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}l=Ua[c[29340>>2]&127](k)|0;if(l|0){k=Ua[c[29352>>2]&127](l)|0;k=(c[14978]|0)+k|0;c[14978]=k;if(k>>>0>(c[14982]|0)>>>0)c[14982]=k;k=(c[14981]|0)+1|0;c[14981]=k;if(k>>>0>(c[14987]|0)>>>0){c[14987]=k;k=l;rd=1391}else{k=l;rd=1391}}}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0)break}else{do if((e[m+276>>1]|0)>=16){k=m+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];La=m+284|0;c[La>>2]=(c[La>>2]|0)+1;La=l;rd=1390;break ea}k=m+296|0;l=c[k>>2]|0;if(!l){k=m+292|0;break}else{c[k>>2]=c[l>>2];La=m+284|0;c[La>>2]=(c[La>>2]|0)+1;La=l;rd=1390;break ea}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}La=Yd(m,16,0)|0;rd=1390}while(0);if((rd|0)==1390?La|0:0){k=La;rd=1391}if((rd|0)==1391){l=k+4|0;I=l;J=I+12|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[k>>2]=o;od=i;pd=c[od+4>>2]|0;qd=l;c[qd>>2]=c[od>>2];c[qd+4>>2]=pd;qd=j+272|0;c[k+12>>2]=c[qd>>2];c[qd>>2]=k}m=c[j>>2]|0;fa:do if(!m){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](16)|0;rd=1415;break}k=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){qd=c[14978]|0;pd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k)break da;l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0)break da}else{do if((e[m+276>>1]|0)>=16){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1415;break fa}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1415;break fa}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,16,0)|0;rd=1415}while(0);if((rd|0)==1415)if(!k)break;l=k+4|0;I=l;J=I+12|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[k>>2]=n;pd=h;qd=c[pd+4>>2]|0;rd=l;c[rd>>2]=c[pd>>2];c[rd+4>>2]=qd;rd=j+272|0;c[k+12>>2]=c[rd>>2];c[rd>>2]=k}while(0);c[h>>2]=cj(j,134,n,o)|0;break}case 166:{n=td+-44|0;o=mj(c[j>>2]|0,59,n,1)|0;p=td+-20|0;q=mj(c[j>>2]|0,59,p,1)|0;i=td+4|0;h=mj(c[j>>2]|0,59,i,1)|0;r=cj(j,134,q,h)|0;ga:do if((d[j+200>>0]|0)>1){m=c[j>>2]|0;ha:do if(!m){if(!(c[7324]|0)){Ya=Ua[c[29340>>2]&127](16)|0;rd=1442;break}k=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){qd=c[14978]|0;pd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}l=Ua[c[29340>>2]&127](k)|0;if(l|0){k=Ua[c[29352>>2]&127](l)|0;k=(c[14978]|0)+k|0;c[14978]=k;if(k>>>0>(c[14982]|0)>>>0)c[14982]=k;k=(c[14981]|0)+1|0;c[14981]=k;if(k>>>0>(c[14987]|0)>>>0){c[14987]=k;k=l;rd=1443}else{k=l;rd=1443}}}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0)break}else{do if((e[m+276>>1]|0)>=16){k=m+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];Ya=m+284|0;c[Ya>>2]=(c[Ya>>2]|0)+1;Ya=l;rd=1442;break ha}k=m+296|0;l=c[k>>2]|0;if(!l){k=m+292|0;break}else{c[k>>2]=c[l>>2];Ya=m+284|0;c[Ya>>2]=(c[Ya>>2]|0)+1;Ya=l;rd=1442;break ha}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}Ya=Yd(m,16,0)|0;rd=1442}while(0);if((rd|0)==1442?Ya|0:0){k=Ya;rd=1443}if((rd|0)==1443){l=k+4|0;I=l;J=I+12|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[k>>2]=h;od=i;pd=c[od+4>>2]|0;qd=l;c[qd>>2]=c[od>>2];c[qd+4>>2]=pd;qd=j+272|0;c[k+12>>2]=c[qd>>2];c[qd>>2]=k}m=c[j>>2]|0;ia:do if(!m){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](16)|0;rd=1467;break}k=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){qd=c[14978]|0;pd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k)break ga;l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0)break ga}else{do if((e[m+276>>1]|0)>=16){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1467;break ia}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1467;break ia}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,16,0)|0;rd=1467}while(0);if((rd|0)==1467)if(!k)break;l=k+4|0;I=l;J=I+12|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[k>>2]=q;pd=p;qd=c[pd+4>>2]|0;rd=l;c[rd>>2]=c[pd>>2];c[rd+4>>2]=qd;rd=j+272|0;c[k+12>>2]=c[rd>>2];c[rd>>2]=k}while(0);c[n>>2]=cj(j,134,o,r)|0;break}case 168:case 167:{rd=td+4|0;c[rd>>2]=dj(j,e[td+2>>1]|0,c[rd>>2]|0,c[td+8>>2]|0)|0;break}case 169:{rd=td+4|0;c[rd>>2]=mj(c[j>>2]|0,147,rd,1)|0;break}case 170:{m=td+4|0;k=c[m>>2]|0;if((a[k>>0]|0)==35?((d[k+1>>0]|0)+-48|0)>>>0<10:0){pd=m;l=c[pd>>2]|0;pd=c[pd+4>>2]|0;rd=qd;c[rd>>2]=l;c[rd+4>>2]=pd;if(a[j+18>>0]|0){k=cj(j,168,0,0)|0;c[m>>2]=k;if(k|0)gi(l+1|0,k+28|0)|0}else{c[J>>2]=qd;ad(j,38502,J);c[m>>2]=0}break a}u=c[td+8>>2]|0;w=dj(j,148,k,u)|0;c[m>>2]=w;v=c[j>>2]|0;if(w|0){t=c[w+8>>2]|0;k=t+1|0;l=a[k>>0]|0;ja:do if(!(l<<24>>24)){rd=j+196|0;k=(b[rd>>1]|0)+1<<16>>16;b[rd>>1]=k}else{if((a[t>>0]|0)==63){if((u|0)==2){i=(l<<24>>24)+-48|0;m=((i|0)<0)<<31>>31;k=qd;c[k>>2]=i;c[k+4>>2]=m;k=0}else{k=(Mg(k,qd,u+-1|0,1)|0)!=0;i=qd;m=c[i+4>>2]|0;i=c[i>>2]|0}l=c[v+144>>2]|0;qd=((l|0)<0)<<31>>31;if(k|((m|0)<0|(m|0)==0&i>>>0<1)|((m|0)>(qd|0)|(m|0)==(qd|0)&i>>>0>l>>>0)){c[Xa>>2]=l;ad(j,45057,Xa);break a}k=i&65535;l=j+196|0;ka:do if((b[l>>1]|0)>=k<<16>>16){h=k<<16>>16;m=j+216|0;l=c[m>>2]|0;if(!l)l=0;else{n=c[l+4>>2]|0;i=2;while(1){if((c[l+(i<<2)>>2]|0)==(h|0))break;i=(c[l+(i+1<<2)>>2]|0)+i|0;if((i|0)>=(n|0))break ka}break ja}}else{b[l>>1]=k;l=j+216|0;m=l;l=c[l>>2]|0}while(0)}else{m=j+216|0;l=c[m>>2]|0;la:do if(l|0){h=c[l+4>>2]|0;k=2;while(1){i=l+(k+2<<2)|0;if((_u(i,t,u)|0)==0?(a[i+u>>0]|0)==0:0)break;k=(c[l+(k+1<<2)>>2]|0)+k|0;if((k|0)>=(h|0))break la}k=c[l+(k<<2)>>2]|0;if(k&65535|0){k=k&65535;break ja}}while(0);qd=j+196|0;k=(b[qd>>1]|0)+1<<16>>16;b[qd>>1]=k}r=k<<16>>16;i=(u|0)/4|0;s=i+3|0;q=(l|0)==0;ma:do if(!q){o=l+4|0;i=c[o>>2]|0;h=i+s|0;n=c[l>>2]|0;if((h|0)>(n|0)){i=aw(n|0,((n|0)<0)<<31>>31|0,1)|0;i=Qv(i|0,L()|0,s|0,((s|0)<0)<<31>>31|0)|0;h=aw(i|0,L()|0,2)|0;n=L()|0;rd=l;if((c[v+304>>2]|0)>>>0<=rd>>>0?(c[v+308>>2]|0)>>>0>rd>>>0:0){if(!(n>>>0>0|((n|0)==0?h>>>0>(e[v+276>>1]|0)>>>0:0))){rd=1518;break}n=Xd(v,l,h,n)|0;rd=1515;break}n=Xd(v,l,h,n)|0;rd=1515}else{n=o;rd=1519}}else{i=i+13|0;o=aw(i|0,((i|0)<0)<<31>>31|0,2)|0;p=L()|0;if(c[v+272>>2]|0){if(a[v+81>>0]|0){l=0;break}}else{do if(!(p>>>0>0|((p|0)==0?o>>>0>(e[v+276>>1]|0)>>>0:0))){h=v+300|0;n=c[h>>2]|0;if(n|0){c[h>>2]=c[n>>2];rd=v+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1515;break ma}h=v+296|0;n=c[h>>2]|0;if(!n){h=v+292|0;break}else{c[h>>2]=c[n>>2];rd=v+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1515;break ma}}else h=v+288|0;while(0);c[h>>2]=(c[h>>2]|0)+1}n=Yd(v,o,p)|0;rd=1515}while(0);if((rd|0)==1515)if(n)if(q){c[n+4>>2]=2;l=n;rd=1518}else{l=n;rd=1518}if((rd|0)==1518){c[l>>2]=i;n=l+4|0;i=c[n>>2]|0;h=i+s|0;rd=1519}if((rd|0)==1519){c[l+(i<<2)>>2]=r;c[l+(i+1<<2)>>2]=s;rd=l+(i+2<<2)|0;c[n>>2]=h;cw(rd|0,t|0,u|0)|0;a[rd+u>>0]=0}c[m>>2]=l}while(0);b[w+32>>1]=k;if((c[v+144>>2]|0)<(k<<16>>16|0))ad(j,45100,yc)}break}case 171:{l=td+-20|0;k=c[l>>2]|0;if((c[td+8>>2]|0)!=0?(A=mj(c[j>>2]|0,106,td+4|0,1)|0,(A|0)!=0):0){c[A+12>>2]=k;k=A+4|0;c[k>>2]=c[k>>2]|4352;k=A}c[l>>2]=k;break}case 172:{i=mj(c[j>>2]|0,36,td+-8|0,1)|0;c[td+-56>>2]=i;k=c[j>>2]|0;l=c[td+-32>>2]|0;m=(l|0)==0;if(!i){if(m)break a;li(k,l);break a}if(!m){c[i+12>>2]=l;j=i+4|0;c[j>>2]=c[j>>2]|c[l+4>>2]&2097412}Wm(i);break}case 173:{l=c[td+-8>>2]|0;n=td+-44|0;h=c[td+-20>>2]|0;m=c[j>>2]|0;k=mj(m,161,n,1)|0;i=(l|0)==0;if(!k)if(i)k=0;else{pi(m,l);k=0}else{if(!i?(c[l>>2]|0)>(c[(c[j>>2]|0)+132>>2]|0):0){c[ia>>2]=n;ad(j,45123,ia)}c[k+20>>2]=l;l=k+4|0;c[l>>2]=c[l>>2]|4;if((c[j+36>>2]|0)==0?(Wm(k),xa=c[(c[j>>2]|0)+120>>2]|0,(xa|0)<(c[k+24>>2]|0)):0){c[qa>>2]=xa;ad(j,41637,qa)}if((h|0)==1)c[l>>2]=c[l>>2]|2}c[n>>2]=k;break}case 174:{l=td+-32|0;k=mj(c[j>>2]|0,161,l,1)|0;if(k){c[k+20>>2]=0;rd=k+4|0;c[rd>>2]=c[rd>>2]|4;if((c[j+36>>2]|0)==0?(Wm(k),B=c[(c[j>>2]|0)+120>>2]|0,(B|0)<(c[k+24>>2]|0)):0){c[u>>2]=B;ad(j,41637,u)}}else k=0;c[l>>2]=k;break}case 175:{l=c[td+-20>>2]|0;n=td+-56|0;h=c[td+-32>>2]|0;m=c[j>>2]|0;k=mj(m,161,n,1)|0;i=(l|0)==0;if(k){if(!i?(c[l>>2]|0)>(c[(c[j>>2]|0)+132>>2]|0):0){c[ja>>2]=n;ad(j,45123,ja)}c[k+20>>2]=l;m=k+4|0;c[m>>2]=c[m>>2]|4;if((c[j+36>>2]|0)==0?(Wm(k),ya=c[(c[j>>2]|0)+120>>2]|0,(ya|0)<(c[k+24>>2]|0)):0){c[ra>>2]=ya;ad(j,41637,ra)}if((h|0)==1)c[m>>2]=c[m>>2]|2;l=c[td+4>>2]|0;if((l|0)!=0?(c[k+44>>2]=l,rd=c[m>>2]|0,c[m>>2]=rd|16777216,c[l+68>>2]=k,(rd&2|0)!=0):0)ad(j,45157,Fa)}else{if(!i)pi(m,l);mi(c[j>>2]|0,c[td+4>>2]|0);k=0}c[n>>2]=k;break}case 176:{i=td+-44|0;k=mj(c[j>>2]|0,161,i,1)|0;if(k){c[k+20>>2]=0;m=k+4|0;c[m>>2]=c[m>>2]|4;if((c[j+36>>2]|0)==0?(Wm(k),Q=c[(c[j>>2]|0)+120>>2]|0,(Q|0)<(c[k+24>>2]|0)):0){c[K>>2]=Q;ad(j,41637,K)}l=c[td+4>>2]|0;if((l|0)!=0?(c[k+44>>2]=l,rd=c[m>>2]|0,c[m>>2]=rd|16777216,c[l+68>>2]=k,(rd&2|0)!=0):0)ad(j,45157,X)}else{mi(c[j>>2]|0,c[td+4>>2]|0);k=0}c[i>>2]=k;break}case 177:{l=td+4|0;k=mj(c[j>>2]|0,161,l,1)|0;if(k){c[k+20>>2]=0;rd=k+4|0;c[rd>>2]=c[rd>>2]|4;if((c[j+36>>2]|0)==0?(Wm(k),C=c[(c[j>>2]|0)+120>>2]|0,(C|0)<(c[k+24>>2]|0)):0){c[v>>2]=C;ad(j,41637,v)}}else k=0;c[l>>2]=k;break}case 178:{k=lj(c[j>>2]|0,c[td+-32>>2]|0,c[td+-8>>2]|0)|0;l=cj(j,169,0,0)|0;c[td+-44>>2]=l;if(l|0){c[l+20>>2]=k;break a}if(k|0)pi(c[j>>2]|0,k);break}case 186:case 185:case 184:case 183:case 182:case 181:case 180:case 179:{rd=td+-20|0;c[rd>>2]=cj(j,e[td+-10>>1]|0,c[rd>>2]|0,c[td+4>>2]|0)|0;break}case 187:{qd=td+4|0;j=c[qd+4>>2]|0;rd=td+-8|0;c[rd>>2]=c[qd>>2];c[rd+4>>2]=j;c[td+-4>>2]=j|-2147483648;break}case 188:{l=td+-8|0;m=td+-4|0;n=c[m>>2]|0;c[m>>2]=n&2147483647;m=lj(c[j>>2]|0,0,c[td+4>>2]|0)|0;o=td+-20|0;m=lj(c[j>>2]|0,m,c[o>>2]|0)|0;i=c[j>>2]|0;k=mj(i,161,l,1)|0;h=(m|0)==0;if(!k)if(h)k=0;else{pi(i,m);k=0}else{if(!h?(c[m>>2]|0)>(c[(c[j>>2]|0)+132>>2]|0):0){c[sa>>2]=l;ad(j,45123,sa)}c[k+20>>2]=m;rd=k+4|0;c[rd>>2]=c[rd>>2]|4;if((c[j+36>>2]|0)==0?(Wm(k),za=c[(c[j>>2]|0)+120>>2]|0,(za|0)<(c[k+24>>2]|0)):0){c[ta>>2]=za;ad(j,41637,ta)}}c[o>>2]=k;if((n|0)<0){k=cj(j,19,k,0)|0;c[o>>2]=k}if(k|0){j=k+4|0;c[j>>2]=c[j>>2]|128}break}case 189:{l=td+-32|0;m=td+-28|0;n=c[m>>2]|0;c[m>>2]=n&2147483647;m=lj(c[j>>2]|0,0,c[td+-20>>2]|0)|0;o=td+-44|0;m=lj(c[j>>2]|0,m,c[o>>2]|0)|0;m=lj(c[j>>2]|0,m,c[td+4>>2]|0)|0;i=c[j>>2]|0;k=mj(i,161,l,1)|0;h=(m|0)==0;if(!k)if(h)k=0;else{pi(i,m);k=0}else{if(!h?(c[m>>2]|0)>(c[(c[j>>2]|0)+132>>2]|0):0){c[ua>>2]=l;ad(j,45123,ua)}c[k+20>>2]=m;rd=k+4|0;c[rd>>2]=c[rd>>2]|4;if((c[j+36>>2]|0)==0?(Wm(k),Aa=c[(c[j>>2]|0)+120>>2]|0,(Aa|0)<(c[k+24>>2]|0)):0){c[va>>2]=Aa;ad(j,41637,va)}}c[o>>2]=k;if((n|0)<0){k=cj(j,19,k,0)|0;c[o>>2]=k}if(k|0){j=k+4|0;c[j>>2]=c[j>>2]|128}break}case 190:{rd=td+-8|0;c[rd>>2]=cj(j,e[td+2>>1]|0,c[rd>>2]|0,0)|0;break}case 191:{rd=td+-20|0;c[rd>>2]=cj(j,51,c[rd>>2]|0,0)|0;break}case 192:{m=td+-20|0;rd=td+4|0;k=cj(j,45,c[m>>2]|0,c[rd>>2]|0)|0;c[m>>2]=k;rd=c[rd>>2]|0;m=c[j>>2]|0;if(((k|0)!=0&(rd|0)!=0?(a[rd>>0]|0)==114:0)?(d[j+200>>0]|0)<=1:0){a[k>>0]=50;k=k+16|0;l=c[k>>2]|0;if(l|0)li(m,l);c[k>>2]=0}break}case 193:{m=td+-32|0;rd=td+4|0;k=cj(j,160,c[m>>2]|0,c[rd>>2]|0)|0;c[m>>2]=k;rd=c[rd>>2]|0;m=c[j>>2]|0;if(((k|0)!=0&(rd|0)!=0?(a[rd>>0]|0)==114:0)?(d[j+200>>0]|0)<=1:0){a[k>>0]=51;k=k+16|0;l=c[k>>2]|0;if(l|0)li(m,l);c[k>>2]=0}break}case 195:case 194:{c[td+-8>>2]=cj(j,e[td+-10>>1]|0,c[td+4>>2]|0,0)|0;break}case 196:{c[td+-8>>2]=cj(j,(b[td+-10>>1]|0)==100?166:165,c[td+4>>2]|0,0)|0;break}case 200:case 197:{c[td+4>>2]=0;break}case 199:{k=lj(c[j>>2]|0,0,c[td+-20>>2]|0)|0;k=lj(c[j>>2]|0,k,c[td+4>>2]|0)|0;l=td+-44|0;m=cj(j,48,c[l>>2]|0,0)|0;c[l>>2]=m;if(!m){if(k|0)pi(c[j>>2]|0,k)}else c[m+20>>2]=k;if(c[td+-32>>2]|0)c[l>>2]=cj(j,19,c[l>>2]|0,0)|0;break}case 202:{m=td+-8|0;k=c[m>>2]|0;if(!k){if((d[j+200>>0]|0)>=2)break a;k=td+-44|0;l=c[k>>2]|0;if(l|0)li(c[j>>2]|0,l);c[k>>2]=mj(c[j>>2]|0,147,17136+(c[td+-32>>2]<<3)|0,1)|0;break a}if((c[k>>2]|0)==1){k=k+4|0;l=c[k>>2]|0;c[k>>2]=0;k=c[m>>2]|0;if(k|0)pi(c[j>>2]|0,k);if(l|0){rd=l+4|0;c[rd>>2]=c[rd>>2]&-769|512}rd=td+-44|0;c[rd>>2]=cj(j,(c[td+-32>>2]|0)==0?53:52,c[rd>>2]|0,l)|0;break a}l=td+-44|0;k=cj(j,49,c[l>>2]|0,0)|0;c[l>>2]=k;if(!k){k=c[m>>2]|0;if(k|0)pi(c[j>>2]|0,k)}else{c[k+20>>2]=c[m>>2];k=c[l>>2]|0;if((c[j+36>>2]|0)==0?(Wm(k),ea=c[(c[j>>2]|0)+120>>2]|0,(ea|0)<(c[k+24>>2]|0)):0){c[$>>2]=ea;ad(j,41637,$)}}if(c[td+-32>>2]|0)c[l>>2]=cj(j,19,c[l>>2]|0,0)|0;break}case 203:{k=cj(j,131,0,0)|0;c[td+-20>>2]=k;l=c[td+-8>>2]|0;if(!k){if(!l)break a;ni(c[j>>2]|0,l,1);break a}c[k+20>>2]=l;rd=k+4|0;c[rd>>2]=c[rd>>2]|2099200;if((c[j+36>>2]|0)==0?(Wm(k),D=c[(c[j>>2]|0)+120>>2]|0,(D|0)<(c[k+24>>2]|0)):0){c[w>>2]=D;ad(j,41637,w)}break}case 204:{k=td+-44|0;l=cj(j,49,c[k>>2]|0,0)|0;c[k>>2]=l;m=c[td+-8>>2]|0;if(!l){if(m|0)ni(c[j>>2]|0,m,1)}else{c[l+20>>2]=m;rd=l+4|0;c[rd>>2]=c[rd>>2]|2099200;if((c[j+36>>2]|0)==0?(Wm(l),R=c[(c[j>>2]|0)+120>>2]|0,(R|0)<(c[l+24>>2]|0)):0){c[M>>2]=R;ad(j,41637,M)}}if(c[td+-32>>2]|0)c[k>>2]=cj(j,19,c[k>>2]|0,0)|0;break}case 205:{k=nj(j,0,td+-20|0,td+-8|0)|0;m=kj(j,0,k,0,0,0,0,0,0)|0;l=c[td+4>>2]|0;do if(l|0)if((k|0)==0|(m|0)==0){pi(c[j>>2]|0,l);break}else{rd=(c[k>>2]|0)+-1|0;c[k+8+(rd*72|0)+64>>2]=l;rd=k+8+(rd*72|0)+37|0;a[rd>>0]=a[rd>>0]|4;break}while(0);k=td+-44|0;l=cj(j,49,c[k>>2]|0,0)|0;c[k>>2]=l;if(!l){if(m|0)ni(c[j>>2]|0,m,1)}else{c[l+20>>2]=m;rd=l+4|0;c[rd>>2]=c[rd>>2]|2099200;if((c[j+36>>2]|0)==0?(Wm(l),fa=c[(c[j>>2]|0)+120>>2]|0,(fa|0)<(c[l+24>>2]|0)):0){c[_>>2]=fa;ad(j,41637,_)}}if(c[td+-32>>2]|0)c[k>>2]=cj(j,19,c[k>>2]|0,0)|0;break}case 206:{k=cj(j,20,0,0)|0;c[td+-32>>2]=k;l=c[td+-8>>2]|0;if(!k){if(!l)break a;ni(c[j>>2]|0,l,1);break a}c[k+20>>2]=l;rd=k+4|0;c[rd>>2]=c[rd>>2]|2099200;if((c[j+36>>2]|0)==0?(Wm(k),E=c[(c[j>>2]|0)+120>>2]|0,(E|0)<(c[k+24>>2]|0)):0){c[s>>2]=E;ad(j,41637,s)}break}case 207:{l=cj(j,149,c[td+-32>>2]|0,0)|0;i=td+-44|0;c[i>>2]=l;if(!l){k=c[td+-20>>2]|0;if(k|0)pi(c[j>>2]|0,k);k=c[td+-8>>2]|0;if(!k)break a;li(c[j>>2]|0,k);break a}m=c[td+-8>>2]|0;k=c[td+-20>>2]|0;if(m){k=lj(c[j>>2]|0,k,m)|0;l=c[i>>2]|0}c[l+20>>2]=k;k=c[i>>2]|0;if((c[j+36>>2]|0)==0?(Wm(k),Ba=c[(c[j>>2]|0)+120>>2]|0,(Ba|0)<(c[k+24>>2]|0)):0){c[ka>>2]=Ba;ad(j,41637,ka)}break}case 208:{rd=td+-44|0;qd=lj(c[j>>2]|0,c[rd>>2]|0,c[td+-20>>2]|0)|0;c[rd>>2]=qd;c[rd>>2]=lj(c[j>>2]|0,qd,c[td+4>>2]|0)|0;break}case 209:{qd=lj(c[j>>2]|0,0,c[td+-20>>2]|0)|0;rd=td+-32|0;c[rd>>2]=qd;c[rd>>2]=lj(c[j>>2]|0,qd,c[td+4>>2]|0)|0;break}case 316:{c[td+-44>>2]=c[td+-8>>2];break}case 215:{rd=td+-20|0;c[rd>>2]=lj(c[j>>2]|0,c[rd>>2]|0,c[td+4>>2]|0)|0;break}case 216:{rd=td+4|0;c[rd>>2]=lj(c[j>>2]|0,0,c[rd>>2]|0)|0;break}case 223:case 218:{c[td+-20>>2]=c[td+-8>>2];break}case 219:{h=td+-44|0;qd=nj(j,0,h,0)|0;fj(j,td+-80|0,td+-68|0,qd,c[td+-20>>2]|0,c[td+-116>>2]|0,td+-128|0,c[td+4>>2]|0,0,c[td+-92>>2]|0,0);if((d[j+200>>0]|0)>1?(q=c[j+232>>2]|0,q|0):0){i=c[q>>2]|0;m=c[j>>2]|0;na:do if(!m){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](16)|0;rd=1732;break}k=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){qd=c[14978]|0;pd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k)break a;l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0)break a}else{do if((e[m+276>>1]|0)>=16){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1732;break na}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1732;break na}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,16,0)|0;rd=1732}while(0);if((rd|0)==1732)if(!k)break a;l=k+4|0;I=l;J=I+12|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[k>>2]=i;pd=h;qd=c[pd+4>>2]|0;rd=l;c[rd>>2]=c[pd>>2];c[rd+4>>2]=qd;j=j+272|0;c[k+12>>2]=c[j>>2];c[j>>2]=k}break}case 262:case 220:{c[td+4>>2]=2;break}case 221:{c[td+16>>2]=0;break}case 224:{r=td+-44|0;s=td+-20|0;pd=c[td+-8>>2]|0;qd=c[td+4>>2]|0;t=lj(c[j>>2]|0,c[r>>2]|0,0)|0;if((pd|0)!=0|(qd|0)!=-1?(a[(c[j>>2]|0)+165>>0]|0)==0:0){qd=c[s>>2]|0;c[H>>2]=c[td+-16>>2];c[H+4>>2]=qd;ad(j,45206,H)}oa:do if(t|0){n=(c[t>>2]|0)+-1|0;m=c[j>>2]|0;o=c[s>>2]|0;p=c[td+-16>>2]|0;pa:do if(o){i=Qv(p|0,0,1,0)|0;h=L()|0;qa:do if(c[m+272>>2]|0)if(!(a[m+81>>0]|0))rd=1751;else{rd=1753;break pa}else{do if(0<0|(0==0?p>>>0<(e[m+276>>1]|0)>>>0:0)){k=m+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];q=m+284|0;c[q>>2]=(c[q>>2]|0)+1;q=l;break qa}k=m+296|0;l=c[k>>2]|0;if(!l){k=m+292|0;break}else{c[k>>2]=c[l>>2];q=m+284|0;c[q>>2]=(c[q>>2]|0)+1;q=l;break qa}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=1751}while(0);if((rd|0)==1751)q=Yd(m,i,h)|0;if(q){cw(q|0,o|0,p|0)|0;a[q+p>>0]=0;k=t+4+(n*20|0)+4|0;c[k>>2]=q;l=a[q>>0]|0;if((a[880+(l&255)>>0]|0)<0){h=l<<24>>24==91?93:l;i=0;l=1;while(1){m=a[q+l>>0]|0;if(m<<24>>24==h<<24>>24){l=l+1|0;m=q+i|0;if((a[q+l>>0]|0)!=h<<24>>24)break;a[m>>0]=h}else a[q+i>>0]=m;i=i+1|0;l=l+1|0}a[m>>0]=0}}else rd=1753}else rd=1753;while(0);if((rd|0)==1753){k=t+4+(n*20|0)+4|0;c[k>>2]=0}if((d[j+200>>0]|0)>1){i=c[k>>2]|0;m=c[j>>2]|0;ra:do if(!m){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](16)|0;rd=1786;break}k=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){qd=c[14978]|0;pd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k)break oa;l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0)break oa}else{do if((e[m+276>>1]|0)>=16){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1786;break ra}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1786;break ra}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,16,0)|0;rd=1786}while(0);if((rd|0)==1786)if(!k)break;l=k+4|0;I=l;J=I+12|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[k>>2]=i;pd=s;qd=c[pd+4>>2]|0;rd=l;c[rd>>2]=c[pd>>2];c[rd+4>>2]=qd;j=j+272|0;c[k+12>>2]=c[j>>2];c[j>>2]=k}}while(0);c[r>>2]=t;break}case 225:{r=td+-20|0;pd=c[td+-8>>2]|0;qd=c[td+4>>2]|0;s=lj(c[j>>2]|0,0,0)|0;if((pd|0)!=0|(qd|0)!=-1?(a[(c[j>>2]|0)+165>>0]|0)==0:0){qd=c[r>>2]|0;c[t>>2]=c[td+-16>>2];c[t+4>>2]=qd;ad(j,45206,t)}sa:do if(s|0){n=(c[s>>2]|0)+-1|0;m=c[j>>2]|0;o=c[r>>2]|0;p=c[td+-16>>2]|0;ta:do if(o){i=Qv(p|0,0,1,0)|0;h=L()|0;ua:do if(c[m+272>>2]|0)if(!(a[m+81>>0]|0))rd=1804;else{rd=1806;break ta}else{do if(0<0|(0==0?p>>>0<(e[m+276>>1]|0)>>>0:0)){k=m+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];q=m+284|0;c[q>>2]=(c[q>>2]|0)+1;q=l;break ua}k=m+296|0;l=c[k>>2]|0;if(!l){k=m+292|0;break}else{c[k>>2]=c[l>>2];q=m+284|0;c[q>>2]=(c[q>>2]|0)+1;q=l;break ua}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=1804}while(0);if((rd|0)==1804)q=Yd(m,i,h)|0;if(q){cw(q|0,o|0,p|0)|0;a[q+p>>0]=0;k=s+4+(n*20|0)+4|0;c[k>>2]=q;l=a[q>>0]|0;if((a[880+(l&255)>>0]|0)<0){h=l<<24>>24==91?93:l;i=0;l=1;while(1){m=a[q+l>>0]|0;if(m<<24>>24==h<<24>>24){l=l+1|0;m=q+i|0;if((a[q+l>>0]|0)!=h<<24>>24)break;a[m>>0]=h}else a[q+i>>0]=m;i=i+1|0;l=l+1|0}a[m>>0]=0}}else rd=1806}else rd=1806;while(0);if((rd|0)==1806){k=s+4+(n*20|0)+4|0;c[k>>2]=0}if((d[j+200>>0]|0)>1){i=c[k>>2]|0;m=c[j>>2]|0;va:do if(!m){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](16)|0;rd=1839;break}k=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){qd=c[14978]|0;pd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k)break sa;l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0)break sa}else{do if((e[m+276>>1]|0)>=16){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1839;break va}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=1839;break va}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,16,0)|0;rd=1839}while(0);if((rd|0)==1839)if(!k)break;l=k+4|0;I=l;J=I+12|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[k>>2]=i;pd=r;qd=c[pd+4>>2]|0;rd=l;c[rd>>2]=c[pd>>2];c[rd+4>>2]=qd;j=j+272|0;c[k+12>>2]=c[j>>2];c[j>>2]=k}}while(0);c[r>>2]=s;break}case 228:{x=c[td+4>>2]|0;o=c[td+-8>>2]|0;y=c[j>>2]|0;wa:do if(!(a[y+81>>0]|0)){xa:do if(!(a[y+165>>0]|0)){m=j+4|0;i=y+24|0;h=(c[i>>2]&1|0)==0;n=y+16|0;pd=c[(c[n>>2]|0)+12>>2]|0;a[y+78>>0]=a[pd+77>>0]|0;if((b[pd+78>>1]&1)==0?(Ca=ch(y,0,m,0)|0,(Ca|0)!=0):0)k=Ca;else rd=1846;ya:do if((rd|0)==1846){k=c[y+20>>2]|0;if((k|0)>1)do{l=k;k=k+-1|0;if((b[(c[(c[n>>2]|0)+(k<<4)+12>>2]|0)+78>>1]&1)==0?(Oa=ch(y,k,m,0)|0,Oa|0):0){k=Oa;break ya}}while((l|0)>2);if(h)c[i>>2]=c[i>>2]&-2;if(!(a[y+89>>0]|0))break xa;c[i>>2]=c[i>>2]|16;break xa}while(0);c[j+12>>2]=k;j=j+36|0;c[j>>2]=(c[j>>2]|0)+1;break wa}while(0);k=c[x+12>>2]|0;w=fi(y,c[x+16>>2]|0,k)|0;if(!w){if(!o){c[Ta>>2]=x;c[Ta+4>>2]=0;ad(j,45244,Ta)}else fl(j,k);a[j+17>>0]=1;break}pd=w+55|0;if((d[pd>>0]|d[pd+1>>0]<<8)&3){c[Va>>2]=0;ad(j,45262,Va);break}l=c[w+24>>2]|0;u=y+16|0;m=c[u>>2]|0;if(!l)v=-1e6;else{k=0;while(1)if((c[m+(k<<4)+12>>2]|0)==(l|0)){v=k;break}else k=k+1|0}n=c[w+12>>2]|0;o=c[m+(v<<4)>>2]|0;t=(v|0)==1;k=t?34855:34585;m=c[j>>2]|0;l=a[m+165>>0]|0;if(!(l<<24>>24))if((a[j+200>>0]|0)==0?(Kb=c[m+312>>2]|0,(Kb|0)!=0):0){k=Za[Kb&127](c[m+316>>2]|0,9,k,0,o,c[j+240>>2]|0)|0;if((k|0)==1){ad(j,39216,Lb);c[j+12>>2]=23;break}if((k|2|0)!=2){ad(j,39231,Mb);c[j+12>>2]=1;break}if(k|0)break;m=c[j>>2]|0;h=a[m+165>>0]|0}else h=0;else h=l;i=(v|0)==0?10:12;l=c[w>>2]|0;k=c[n>>2]|0;do if((h<<24>>24==0?(a[j+200>>0]|0)==0:0)?(Rb=c[m+312>>2]|0,Rb|0):0){k=Za[Rb&127](c[m+316>>2]|0,i,l,k,o,c[j+240>>2]|0)|0;if((k|0)==1){ad(j,39216,Sb);c[j+12>>2]=23;break wa}if((k|2|0)==2)if(!k)break;else break wa;else{ad(j,39231,Tb);c[j+12>>2]=1;break wa}}while(0);s=j+8|0;k=c[s>>2]|0;i=j+116|0;if(!k){m=c[j>>2]|0;if((c[i>>2]|0)==0?(b[m+76>>1]&8)==0:0)a[j+23>>0]=1;za:do if(c[m+272>>2]|0)if(!(a[m+81>>0]|0))rd=1897;else break wa;else{do if((e[m+276>>1]|0)>=224){k=m+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];pd=m+284|0;c[pd>>2]=(c[pd>>2]|0)+1;break za}k=m+296|0;l=c[k>>2]|0;if(!l){k=m+292|0;break}else{c[k>>2]=c[l>>2];pd=m+284|0;c[pd>>2]=(c[pd>>2]|0)+1;break za}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=1897}while(0);if((rd|0)==1897)l=Yd(m,224,0)|0;if(!l)break;I=l+104|0;J=I+120|0;do{c[I>>2]=0;I=I+4|0}while((I|0)<(J|0));c[l>>2]=m;k=m+4|0;m=c[k>>2]|0;if(m|0)c[m+4>>2]=l;c[l+8>>2]=m;c[l+4>>2]=0;c[k>>2]=l;c[l+20>>2]=381479589;c[l+12>>2]=j;c[s>>2]=l;Bi(l,61,0,1,0)|0;r=l}else r=k;q=c[i>>2]|0;q=(q|0)==0?j:q;k=q+84|0;l=c[k>>2]|0;p=1<<v;Aa:do if((((l&p|0)==0?(c[k>>2]=l|p,t):0)?(Dc=c[q>>2]|0,rc=Dc+16|0,(c[(c[rc>>2]|0)+20>>2]|0)==0):0)?(a[q+199>>0]|0)==0:0){k=Ne(c[Dc>>2]|0,0,Dc,qd,0,542)|0;if(k|0){ad(q,32157,pc);c[q+12>>2]=k;break}qd=c[qd>>2]|0;c[(c[rc>>2]|0)+20>>2]=qd;k=c[Dc+92>>2]|0;i=c[qd+4>>2]|0;c[i+4>>2]=c[qd>>2];do if(!(b[i+22>>1]&2)){h=i+32|0;n=i+36|0;o=(c[h>>2]|0)-(c[n>>2]|0)|0;do if((k+-512|0)>>>0<65025){if(k+-1&k|0)break;c[h>>2]=k;m=i+80|0;k=c[m>>2]|0;if(!k)break;l=k+-4|0;c[m>>2]=l;k=l;do if((c[14816]|0)>>>0<=k>>>0)if((c[14817]|0)>>>0>k>>>0){c[14979]=(c[14979]|0)+-1;c[l>>2]=c[14819];c[14819]=l;qd=(c[14820]|0)+1|0;c[14820]=qd;c[14821]=(qd|0)<(c[14815]|0)&1;break}else{k=Ua[c[29352>>2]&127](l)|0;rd=1917;break}else{k=Ua[c[29352>>2]&127](l)|0;rd=1917}while(0);do if((rd|0)==1917){c[14980]=(c[14980]|0)-k;if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{rd=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-rd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);c[m>>2]=0}while(0);rd=Qe(c[i>>2]|0,h,o)|0;c[n>>2]=(c[h>>2]|0)-(o&65535);if((rd|0)!=7)break;k=Dc+81|0;do if(!(a[k>>0]|0)){if(a[Dc+82>>0]|0)break;a[k>>0]=1;if((c[Dc+180>>2]|0)>0)c[Dc+264>>2]=1;k=Dc+272|0;c[k>>2]=(c[k>>2]|0)+1;k=c[Dc+236>>2]|0;if(!k)break;c[k+12>>2]=7}while(0);break Aa}while(0)}while(0);l=q+80|0;c[l>>2]=c[l>>2]|p;l=q+20|0;a[l>>0]=a[l>>0]|1;l=c[w>>2]|0;c[Oc>>2]=c[(c[u>>2]|0)+(v<<4)>>2];c[Oc+4>>2]=34585;c[Oc+8>>2]=l;yk(j,45335,Oc);l=c[w>>2]|0;m=c[(c[(c[j>>2]|0)+16>>2]|0)+(v<<4)>>2]|0;c[Gc>>2]=1;Ab(24,Oc,42737,Gc)|0;if(Qd(c[j>>2]|0,Oc,m)|0){c[Hc>>2]=m;c[Hc+4>>2]=Oc;c[Hc+8>>2]=38091;c[Hc+12>>2]=l;yk(j,42751,Hc)}c[Ic>>2]=2;Ab(24,Oc,42737,Ic)|0;if(Qd(c[j>>2]|0,Oc,m)|0){c[Kc>>2]=m;c[Kc+4>>2]=Oc;c[Kc+8>>2]=38091;c[Kc+12>>2]=l;yk(j,42751,Kc)}c[Lc>>2]=3;Ab(24,Oc,42737,Lc)|0;if(Qd(c[j>>2]|0,Oc,m)|0){c[Mc>>2]=m;c[Mc+4>>2]=Oc;c[Mc+8>>2]=38091;c[Mc+12>>2]=l;yk(j,42751,Mc)}c[Nc>>2]=4;Ab(24,Oc,42737,Nc)|0;k=c[j>>2]|0;if(Qd(k,Oc,m)|0){c[Qc>>2]=m;c[Qc+4>>2]=Oc;c[Qc+8>>2]=38091;c[Qc+12>>2]=l;yk(j,42751,Qc);k=c[j>>2]|0}i=c[s>>2]|0;k=(c[c[(c[k+16>>2]|0)+(v<<4)+12>>2]>>2]|0)+1|0;m=i+108|0;l=c[m>>2]|0;if((c[i+112>>2]|0)>(l|0)){c[m>>2]=l+1;rd=c[i+104>>2]|0;a[rd+(l*20|0)>>0]=95;b[rd+(l*20|0)+2>>1]=0;c[rd+(l*20|0)+4>>2]=v;c[rd+(l*20|0)+8>>2]=1;c[rd+(l*20|0)+12>>2]=k;c[rd+(l*20|0)+16>>2]=0;a[rd+(l*20|0)+1>>0]=0}else Bi(i,95,v,1,k)|0;il(j,c[w+44>>2]|0,v);m=c[w>>2]|0;l=r+108|0;k=c[l>>2]|0;if((c[r+112>>2]|0)>(k|0)){c[l>>2]=k+1;j=c[r+104>>2]|0;a[j+(k*20|0)>>0]=-112;b[j+(k*20|0)+2>>1]=0;c[j+(k*20|0)+4>>2]=v;c[j+(k*20|0)+8>>2]=0;c[j+(k*20|0)+12>>2]=0;c[j+(k*20|0)+16>>2]=0;a[j+(k*20|0)+1>>0]=0}else k=Bi(r,144,v,0,0)|0;if(!(a[(c[r>>2]|0)+81>>0]|0)){if((k|0)<0)k=(c[l>>2]|0)+-1|0;Ci(r,(c[r+104>>2]|0)+(k*20|0)|0,m,0)}}while(0);oi(y,x);break}case 229:{vj(j,0,c[td+4>>2]|0);break}case 230:{vj(j,td+-8|0,c[td+4>>2]|0);break}case 233:{wj(j,td+-8|0,td+4|0,0,0);break}case 234:{wj(j,td+-32|0,td+-20|0,td+4|0,0);break}case 235:{wj(j,td+-44|0,td+-32|0,td+-8|0,0);break}case 236:{wj(j,td+-32|0,td+-20|0,td+4|0,1);break}case 237:{wj(j,td+-44|0,td+-32|0,td+-8|0,1);break}case 240:{v=c[td+-32>>2]|0;w=(c[td+4>>2]|0)-v+(c[td+8>>2]|0)|0;k=c[td+-8>>2]|0;p=j+236|0;l=c[p>>2]|0;A=c[j>>2]|0;c[p>>2]=0;Ba:do if((l|0)!=0&(c[j+36>>2]|0)==0){z=c[l>>2]|0;i=c[l+20>>2]|0;if(!i)y=-1e6;else{h=c[A+16>>2]|0;m=0;while(1)if((c[h+(m<<4)+12>>2]|0)==(i|0)){y=m;break}else m=m+1|0}m=l+28|0;c[m>>2]=k;h=(k|0)==0;if(!h){i=k;do{c[i+4>>2]=l;i=c[i+36>>2]|0}while((i|0)!=0)}c[Qb>>2]=z;if(!z)i=0;else i=(Cu(z)|0)&1073741823;c[Qb+4>>2]=i;c[_c>>2]=j;x=A+16|0;q=c[x>>2]|0;c[_c+12>>2]=c[q+(y<<4)>>2];c[_c+4>>2]=c[q+(y<<4)+12>>2];c[_c+16>>2]=31419;c[_c+20>>2]=Qb;q=(y|0)==1;c[_c+8>>2]=q&1;if(!h)do{if(al(_c,c[k+8>>2]|0)|0){k=0;rd=2083;break Ba}if(bl(_c,c[k+16>>2]|0)|0){k=0;rd=2083;break Ba}n=c[k+20>>2]|0;if(n|0?(c[n>>2]|0)>0:0){i=0;h=n+4|0;while(1){if(bl(_c,c[h>>2]|0)|0){k=0;rd=2083;break Ba}i=i+1|0;if((i|0)>=(c[n>>2]|0))break;else h=h+20|0}}o=c[k+28>>2]|0;if(o|0){n=c[o>>2]|0;if(n|0?(c[n>>2]|0)>0:0){i=0;h=n+4|0;while(1){if(bl(_c,c[h>>2]|0)|0){k=0;rd=2083;break Ba}i=i+1|0;if((i|0)>=(c[n>>2]|0))break;else h=h+20|0}}if(bl(_c,c[o+4>>2]|0)|0){k=0;rd=2083;break Ba}n=c[o+8>>2]|0;if(n|0?(c[n>>2]|0)>0:0){i=0;h=n+4|0;while(1){if(bl(_c,c[h>>2]|0)|0){k=0;rd=2083;break Ba}i=i+1|0;if((i|0)>=(c[n>>2]|0))break;else h=h+20|0}}if(bl(_c,c[o+12>>2]|0)|0){k=0;rd=2083;break Ba}}k=c[k+36>>2]|0}while((k|0)!=0);if(!(bl(_c,c[l+12>>2]|0)|0)){if((d[j+200>>0]|0)<=1){k=A+165|0;if(!(a[k>>0]|0)){u=j+8|0;i=c[u>>2]|0;o=j+116|0;if(!i){n=c[j>>2]|0;if((c[o>>2]|0)==0?(b[n+76>>1]&8)==0:0)a[j+23>>0]=1;Ca:do if(c[n+272>>2]|0)if(!(a[n+81>>0]|0))rd=2e3;else{k=0;r=l;rd=2085;break Ba}else{do if((e[n+276>>1]|0)>=224){i=n+300|0;h=c[i>>2]|0;if(h|0){c[i>>2]=c[h>>2];od=n+284|0;c[od>>2]=(c[od>>2]|0)+1;break Ca}i=n+296|0;h=c[i>>2]|0;if(!h){i=n+292|0;break}else{c[i>>2]=c[h>>2];od=n+284|0;c[od>>2]=(c[od>>2]|0)+1;break Ca}}else i=n+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1;rd=2e3}while(0);if((rd|0)==2e3)h=Yd(n,224,0)|0;if(!h){k=0;r=l;rd=2085;break}I=h+104|0;J=I+120|0;do{c[I>>2]=0;I=I+4|0}while((I|0)<(J|0));c[h>>2]=n;m=n+4|0;i=c[m>>2]|0;if(i|0)c[i+4>>2]=h;c[h+8>>2]=i;c[h+4>>2]=0;c[m>>2]=h;c[h+20>>2]=381479589;c[h+12>>2]=j;c[u>>2]=h;Bi(h,61,0,1,0)|0;t=h}else t=i;s=c[o>>2]|0;s=(s|0)==0?j:s;m=s+84|0;i=c[m>>2]|0;r=1<<y;Da:do if((((i&r|0)==0?(c[m>>2]=i|r,q):0)?(Ac=c[s>>2]|0,oc=Ac+16|0,(c[(c[oc>>2]|0)+20>>2]|0)==0):0)?(a[s+199>>0]|0)==0:0){m=Ne(c[Ac>>2]|0,0,Ac,qd,0,542)|0;if(m|0){ad(s,32157,mc);c[s+12>>2]=m;break}qd=c[qd>>2]|0;c[(c[oc>>2]|0)+20>>2]=qd;m=c[Ac+92>>2]|0;n=c[qd+4>>2]|0;c[n+4>>2]=c[qd>>2];do if(!(b[n+22>>1]&2)){o=n+32|0;p=n+36|0;q=(c[o>>2]|0)-(c[p>>2]|0)|0;do if((m+-512|0)>>>0<65025){if(m+-1&m|0)break;c[o>>2]=m;h=n+80|0;m=c[h>>2]|0;if(!m)break;i=m+-4|0;c[h>>2]=i;m=i;do if((c[14816]|0)>>>0<=m>>>0)if((c[14817]|0)>>>0>m>>>0){c[14979]=(c[14979]|0)+-1;c[i>>2]=c[14819];c[14819]=i;qd=(c[14820]|0)+1|0;c[14820]=qd;c[14821]=(qd|0)<(c[14815]|0)&1;break}else{m=Ua[c[29352>>2]&127](i)|0;rd=2020;break}else{m=Ua[c[29352>>2]&127](i)|0;rd=2020}while(0);do if((rd|0)==2020){c[14980]=(c[14980]|0)-m;if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{qd=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-qd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);c[h>>2]=0}while(0);qd=Qe(c[n>>2]|0,o,q)|0;c[p>>2]=(c[o>>2]|0)-(q&65535);if((qd|0)!=7)break;m=Ac+81|0;do if(!(a[m>>0]|0)){if(a[Ac+82>>0]|0)break;a[m>>0]=1;if((c[Ac+180>>2]|0)>0)c[Ac+264>>2]=1;m=Ac+272|0;c[m>>2]=(c[m>>2]|0)+1;m=c[Ac+236>>2]|0;if(!m)break;c[m+12>>2]=7}while(0);break Da}while(0)}while(0);o=s+80|0;c[o>>2]=c[o>>2]|r;o=v;Ea:do if(v){h=Qv(w|0,0,1,0)|0;n=L()|0;Fa:do if(c[A+272>>2]|0)if(!(a[A+81>>0]|0))rd=2044;else{i=0;break Ea}else{do if(0<0|(0==0?w>>>0<(e[A+276>>1]|0)>>>0:0)){m=A+300|0;i=c[m>>2]|0;if(i|0){c[m>>2]=c[i>>2];qd=A+284|0;c[qd>>2]=(c[qd>>2]|0)+1;break Fa}m=A+296|0;i=c[m>>2]|0;if(!i){m=A+292|0;break}else{c[m>>2]=c[i>>2];qd=A+284|0;c[qd>>2]=(c[qd>>2]|0)+1;break Fa}}else m=A+288|0;while(0);c[m>>2]=(c[m>>2]|0)+1;rd=2044}while(0);if((rd|0)==2044)i=Yd(A,h,n)|0;if(i){cw(i|0,o|0,w|0)|0;a[i+w>>0]=0}else i=0}else i=0;while(0);rd=c[l+4>>2]|0;c[Wc>>2]=c[(c[x>>2]|0)+(y<<4)>>2];c[Wc+4>>2]=34585;c[Wc+8>>2]=z;c[Wc+12>>2]=rd;c[Wc+16>>2]=i;yk(j,46058,Wc);Ga:do if(i|0){if(c[A+480>>2]|0){Vd(A,i);break}m=i;do if((c[A+304>>2]|0)>>>0<=m>>>0){if((c[A+308>>2]|0)>>>0<=m>>>0)break;rd=A+300|0;c[i>>2]=c[rd>>2];c[rd>>2]=i;break Ga}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{rd=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-rd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);n=c[u>>2]|0;m=(c[c[(c[(c[j>>2]|0)+16>>2]|0)+(y<<4)+12>>2]>>2]|0)+1|0;i=n+108|0;h=c[i>>2]|0;if((c[n+112>>2]|0)>(h|0)){c[i>>2]=h+1;j=c[n+104>>2]|0;a[j+(h*20|0)>>0]=95;b[j+(h*20|0)+2>>1]=0;c[j+(h*20|0)+4>>2]=y;c[j+(h*20|0)+8>>2]=1;c[j+(h*20|0)+12>>2]=m;c[j+(h*20|0)+16>>2]=0;a[j+(h*20|0)+1>>0]=0}else Bi(n,95,y,1,m)|0;c[Xc>>2]=z;zk(t,y,bd(A,46122,Xc)|0);rd=2060}}else{c[p>>2]=l;l=0;k=A+165|0;rd=2060}if((rd|0)==2060)if(!(a[k>>0]|0)){k=0;rd=2083;break}q=ki((c[(c[x>>2]|0)+(y<<4)+12>>2]|0)+40|0,z,l)|0;if(q|0){k=A+81|0;if(a[k>>0]|0){k=0;l=q;rd=2083;break}if(a[A+82>>0]|0){k=0;l=q;rd=2083;break}a[k>>0]=1;if((c[A+180>>2]|0)>0)c[A+264>>2]=1;k=A+272|0;c[k>>2]=(c[k>>2]|0)+1;k=c[A+236>>2]|0;if(!k){k=0;l=q;rd=2083;break}c[k+12>>2]=7;k=0;l=q;rd=2083;break}h=c[l+20>>2]|0;if((h|0)==(c[l+24>>2]|0)){p=c[l+4>>2]|0;n=c[h+20>>2]|0;if(!n){m=h+12|0;k=h+16|0}else{m=a[p>>0]|0;if(!(m<<24>>24))k=0;else{k=0;i=p;do{i=i+1|0;k=G(k+(d[208+(m&255)>>0]|0)|0,-1640531535)|0;m=a[i>>0]|0}while(m<<24>>24!=0)}k=(k>>>0)%((c[h+8>>2]|0)>>>0)|0;m=n+(k<<3)|0;k=n+(k<<3)+4|0}m=c[m>>2]|0;Ha:do if(!m)k=59292;else{o=d[208+(d[p>>0]|0)>>0]|0;while(1){k=c[k>>2]|0;m=m+-1|0;h=c[k+12>>2]|0;j=a[h>>0]|0;i=(d[208+(j&255)>>0]|0)-o|0;if(!(j<<24>>24==0|(i|0)!=0)){n=p;do{h=h+1|0;n=n+1|0;j=a[h>>0]|0;i=(d[208+(j&255)>>0]|0)-(d[208+(d[n>>0]|0)>>0]|0)|0}while(!(j<<24>>24==0|(i|0)!=0))}if(!i)break Ha;if(!m){k=59292;break}}}while(0);k=(c[k+8>>2]|0)+68|0;c[l+32>>2]=c[k>>2];c[k>>2]=l;k=0;l=q;rd=2083}else{k=0;l=q;rd=2083}}else{k=0;r=l;rd=2085}}else rd=2083;while(0);if((rd|0)==2083)if(l){r=l;m=l+28|0;rd=2085}do if((rd|0)==2085){Vi(A,c[m>>2]|0);l=c[l>>2]|0;do if(l|0){if(A|0){if(c[A+480>>2]|0){Vd(A,l);break}j=l;if((c[A+304>>2]|0)>>>0<=j>>>0?(c[A+308>>2]|0)>>>0>j>>>0:0){j=A+300|0;c[l>>2]=c[j>>2];c[j>>2]=l;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{j=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);l=c[r+4>>2]|0;do if(l|0){if(A|0){if(c[A+480>>2]|0){Vd(A,l);break}j=l;if((c[A+304>>2]|0)>>>0<=j>>>0?(c[A+308>>2]|0)>>>0>j>>>0:0){j=A+300|0;c[l>>2]=c[j>>2];c[j>>2]=l;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{j=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);l=c[r+12>>2]|0;if(l|0)li(A,l);l=c[r+16>>2]|0;if(l|0){q=l+4|0;m=c[l>>2]|0;Ia:do if((c[q>>2]|0)>0){h=A+480|0;n=A+304|0;o=A+308|0;p=A+300|0;if(!A){i=0;while(1){m=c[m+(i<<3)>>2]|0;do if(m|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](m);break}else{j=Ua[c[29352>>2]&127](m)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](m);break}while(0);i=i+1|0;m=c[l>>2]|0;if((i|0)>=(c[q>>2]|0))break Ia}}i=0;do{m=c[m+(i<<3)>>2]|0;do if(m|0){if(c[h>>2]|0){Vd(A,m);break}j=m;if((c[n>>2]|0)>>>0<=j>>>0?(c[o>>2]|0)>>>0>j>>>0:0){c[m>>2]=c[p>>2];c[p>>2]=m;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](m);break}else{j=Ua[c[29352>>2]&127](m)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](m);break}}while(0);i=i+1|0;m=c[l>>2]|0}while((i|0)<(c[q>>2]|0))}while(0);Ja:do if(m){do if(A|0){i=A+480|0;if(!(c[i>>2]|0)){h=m;if((c[A+304>>2]|0)>>>0>h>>>0)break;if((c[A+308>>2]|0)>>>0<=h>>>0)break;j=A+300|0;c[m>>2]=c[j>>2];c[j>>2]=m}else Vd(A,m);m=i;rd=2140;break Ja}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](m);rd=2138;break}else{rd=Ua[c[29352>>2]&127](m)|0;c[14978]=(c[14978]|0)-rd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](m);rd=2138;break}}else rd=2138;while(0);if((rd|0)==2138)if(!A){pd=l;rd=2145}else{m=A+480|0;rd=2140}do if((rd|0)==2140){if(c[m>>2]|0){Vd(A,l);break}j=l;if((c[A+304>>2]|0)>>>0<=j>>>0?(c[A+308>>2]|0)>>>0>j>>>0:0){j=A+300|0;c[l>>2]=c[j>>2];c[j>>2]=l}else{pd=l;rd=2145}}while(0);do if((rd|0)==2145?pd|0:0)if(!(c[7324]|0)){_a[c[29344>>2]&127](pd);break}else{j=Ua[c[29352>>2]&127](pd)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](pd);break}while(0);if(!r)break}if(A|0){if(c[A+480>>2]|0){Vd(A,r);break}j=r;if((c[A+304>>2]|0)>>>0<=j>>>0?(c[A+308>>2]|0)>>>0>j>>>0:0){j=A+300|0;c[r>>2]=c[j>>2];c[j>>2]=r;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](r);break}else{j=Ua[c[29352>>2]&127](r)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](r);break}}while(0);Vi(A,k);break}case 241:{H=td+-80|0;K=td+-68|0;y=c[td+-56>>2]|0;D=c[td+-44>>2]|0;k=c[td+-40>>2]|0;E=c[td+-20>>2]|0;F=c[td+4>>2]|0;M=td+-116|0;v=c[td+-92>>2]|0;N=c[j>>2]|0;x=(c[M>>2]|0)!=0;O=td+-64|0;l=(c[O>>2]|0)==0;do if(x)if(l)if(!E){rd=2387;break}else{l=1;m=H;rd=2171;break}else{ad(j,46151,$a);rd=2387;break}else{if(!l){if(a[N+165>>0]|0){ad(j,39404,ab);rd=2387;break}l=uk(N,H)|0;if((l|0)<0){c[bb>>2]=H;ad(j,39421,bb);rd=2387;break}else m=K}else{l=d[N+164>>0]|0;m=H}if((E|0)!=0&(l|0)>-1)rd=2171;else rd=2387}while(0);Ka:do if((rd|0)==2171){B=N+81|0;if(!(a[B>>0]|0)){t=N+165|0;if((l|0)!=1&(a[t>>0]|0)!=0){i=E+12|0;h=c[i>>2]|0;do if(h|0){if(c[N+480>>2]|0){Vd(N,h);break}pd=h;if((c[N+304>>2]|0)>>>0<=pd>>>0?(c[N+308>>2]|0)>>>0>pd>>>0:0){pd=N+300|0;c[h>>2]=c[pd>>2];c[pd>>2]=h;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](h);break}else{pd=Ua[c[29352>>2]&127](h)|0;c[14978]=(c[14978]|0)-pd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](h);break}}while(0);c[i>>2]=0}s=E+8|0;h=c[s>>2]|0;if(!h)i=E+12|0;else{n=c[(c[j>>2]|0)+16>>2]|0;i=0;while(1)if((c[n+(i<<4)+12>>2]|0)==(h|0))break;else i=i+1|0;i=n+(i<<4)|0}C=E+16|0;i=$c(j,0,c[C>>2]|0,c[i>>2]|0)|0;h=c[j>>2]|0;u=E+24|0;n=c[u>>2]|0;do if(n|0){if(h|0?c[h+480>>2]|0:0){Ti(h,n);break}kd=n+32|0;pd=(c[kd>>2]|0)+-1|0;c[kd>>2]=pd;if(!pd)Ti(h,n)}while(0);c[u>>2]=i;La:do if(i){pd=i+32|0;c[pd>>2]=(c[pd>>2]|0)+1;if(a[E+45>>0]&2){q=c[E+72>>2]|0;h=c[i+8>>2]|0;Ma:do if(h|0){r=d[208+(d[q>>0]|0)>>0]|0;while(1){o=c[h>>2]|0;pd=a[o>>0]|0;n=(d[208+(pd&255)>>0]|0)-r|0;if(!(pd<<24>>24==0|(n|0)!=0)){p=q;do{o=o+1|0;p=p+1|0;pd=a[o>>0]|0;n=(d[208+(pd&255)>>0]|0)-(d[208+(d[p>>0]|0)>>0]|0)|0}while(!(pd<<24>>24==0|(n|0)!=0))}if(!n)break;h=c[h+20>>2]|0;if(!h)break Ma}c[E+76>>2]=h;break La}while(0);c[hc>>2]=q;c[hc+4>>2]=0;ad(j,41107,hc);a[j+17>>0]=1;i=0}}else i=0;while(0);if((a[t>>0]|0)==0?(i|0)!=0&(c[O>>2]|0)==0:0)A=(c[i+72>>2]|0)==(c[(c[N+16>>2]|0)+28>>2]|0)?1:l;else A=l;if((a[B>>0]|0)==0?(Zc=c[j>>2]|0,c[_c>>2]=j,Zc=c[Zc+16>>2]|0,c[_c+12>>2]=c[Zc+(A<<4)>>2],c[_c+4>>2]=c[Zc+(A<<4)+12>>2],c[_c+16>>2]=31419,c[_c+20>>2]=m,Zc=(A|0)==1,c[_c+8>>2]=Zc&1,(_k(_c,E)|0)==0):0){i=c[s>>2]|0;if(!i)l=E+12|0;else{h=c[(c[j>>2]|0)+16>>2]|0;l=0;while(1)if((c[h+(l<<4)+12>>2]|0)==(i|0))break;else l=l+1|0;l=h+(l<<4)|0}z=$c(j,0,c[C>>2]|0,c[l>>2]|0)|0;l=c[j>>2]|0;i=c[u>>2]|0;do if(i|0){if(l|0?c[l+480>>2]|0:0){Ti(l,i);break}kd=i+32|0;pd=(c[kd>>2]|0)+-1|0;c[kd>>2]=pd;if(!pd)Ti(l,i)}while(0);c[u>>2]=z;Na:do if(z|0){pd=z+32|0;c[pd>>2]=(c[pd>>2]|0)+1;Oa:do if(a[E+45>>0]&2){o=c[E+72>>2]|0;l=c[z+8>>2]|0;Pa:do if(l|0){p=d[208+(d[o>>0]|0)>>0]|0;while(1){h=c[l>>2]|0;pd=a[h>>0]|0;i=(d[208+(pd&255)>>0]|0)-p|0;if(!(pd<<24>>24==0|(i|0)!=0)){n=o;do{h=h+1|0;n=n+1|0;pd=a[h>>0]|0;i=(d[208+(pd&255)>>0]|0)-(d[208+(d[n>>0]|0)>>0]|0)|0}while(!(pd<<24>>24==0|(i|0)!=0))}if(!i)break;l=c[l+20>>2]|0;if(!l)break Pa}c[E+76>>2]=l;break Oa}while(0);c[Ec>>2]=o;c[Ec+4>>2]=0;ad(j,41107,Ec);a[j+17>>0]=1;break Na}while(0);if(c[z+56>>2]|0){ad(j,46197,Fc);rd=2387;break Ka}w=oj(N,m)|0;if(!w){rd=2387;break Ka}Qa:do if(!(tk(j,w)|0)){u=j+200|0;t=a[u>>0]|0;s=(t&255)>1;do if(!s){n=c[(c[N+16>>2]|0)+(A<<4)+12>>2]|0;o=c[n+52>>2]|0;if(!o){i=n+44|0;l=n+48|0}else{i=a[w>>0]|0;if(!(i<<24>>24))l=0;else{l=0;h=w;do{h=h+1|0;l=G(l+(d[208+(i&255)>>0]|0)|0,-1640531535)|0;i=a[h>>0]|0}while(i<<24>>24!=0)}l=(l>>>0)%((c[n+40>>2]|0)>>>0)|0;i=o+(l<<3)|0;l=o+(l<<3)+4|0}i=c[i>>2]|0;Ra:do if(!i)l=59292;else{p=d[208+(d[w>>0]|0)>>0]|0;while(1){l=c[l>>2]|0;i=i+-1|0;n=c[l+12>>2]|0;pd=a[n>>0]|0;h=(d[208+(pd&255)>>0]|0)-p|0;if(!(pd<<24>>24==0|(h|0)!=0)){o=w;do{n=n+1|0;o=o+1|0;pd=a[n>>0]|0;h=(d[208+(pd&255)>>0]|0)-(d[208+(d[o>>0]|0)>>0]|0)|0}while(!(pd<<24>>24==0|(h|0)!=0))}if(!h)break Ra;if(!i){l=59292;break}}}while(0);if(!(c[l+8>>2]|0))break;if(!v){c[Yc>>2]=m;ad(j,46238,Yc);rd=2378;break Qa}h=c[j+116>>2]|0;h=(h|0)==0?j:h;m=h+84|0;i=c[m>>2]|0;l=1<<A;if(i&l|0){rd=2378;break Qa}c[m>>2]=i|l;if(!Zc){rd=2378;break Qa}q=c[h>>2]|0;l=q+16|0;if(c[(c[l>>2]|0)+20>>2]|0){rd=2378;break Qa}if(a[h+199>>0]|0){rd=2378;break Qa}m=Ne(c[q>>2]|0,0,q,qd,0,542)|0;if(m|0){ad(h,32157,dd);c[h+12>>2]=m;rd=2378;break Qa}qd=c[qd>>2]|0;c[(c[l>>2]|0)+20>>2]=qd;l=c[q+92>>2]|0;h=c[qd+4>>2]|0;c[h+4>>2]=c[qd>>2];do if(!(b[h+22>>1]&2)){n=h+32|0;o=h+36|0;p=(c[n>>2]|0)-(c[o>>2]|0)|0;do if((l+-512|0)>>>0<65025){if(l+-1&l|0)break;c[n>>2]=l;i=h+80|0;l=c[i>>2]|0;if(!l)break;m=l+-4|0;c[i>>2]=m;l=m;do if((c[14816]|0)>>>0<=l>>>0)if((c[14817]|0)>>>0>l>>>0){c[14979]=(c[14979]|0)+-1;c[m>>2]=c[14819];c[14819]=m;qd=(c[14820]|0)+1|0;c[14820]=qd;c[14821]=(qd|0)<(c[14815]|0)&1;break}else{l=Ua[c[29352>>2]&127](m)|0;rd=2270;break}else{l=Ua[c[29352>>2]&127](m)|0;rd=2270}while(0);do if((rd|0)==2270){c[14980]=(c[14980]|0)-l;if(!(c[7324]|0)){_a[c[29344>>2]&127](m);break}else{rd=Ua[c[29352>>2]&127](m)|0;c[14978]=(c[14978]|0)-rd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](m);break}}while(0);c[i>>2]=0}while(0);rd=Qe(c[h>>2]|0,n,p)|0;c[o>>2]=(c[n>>2]|0)-(p&65535);if((rd|0)!=7)break;l=q+81|0;do if(!(a[l>>0]|0)){if(a[q+82>>0]|0)break;a[l>>0]=1;if((c[q+180>>2]|0)>0)c[q+264>>2]=1;l=q+272|0;c[l>>2]=(c[l>>2]|0)+1;l=c[q+236>>2]|0;if(!l)break;c[l+12>>2]=7}while(0);rd=2378;break Qa}while(0);rd=2378;break Qa}while(0);r=c[z>>2]|0;do if(r|0){l=a[r>>0]|0;Sa:do if(!(l<<24>>24)){l=39441;rd=2285}else{qd=l&255;l=208+qd|0;do if((qd|32|0)==115){l=a[r+1>>0]|0;if(!(l<<24>>24)){l=39442;rd=2285;break Sa}l=l&255;if((l|32|0)!=113){m=113;l=208+l|0;break}l=a[r+2>>0]|0;if(!(l<<24>>24)){l=39443;rd=2285;break Sa}l=l&255;if((l|32|0)!=108){m=108;l=208+l|0;break}l=a[r+3>>0]|0;if(!(l<<24>>24)){l=39444;rd=2285;break Sa}l=l&255;if((l|32|0)!=105){m=105;l=208+l|0;break}l=a[r+4>>0]|0;if(!(l<<24>>24)){l=39445;rd=2285;break Sa}l=l&255;if((l|32|0)!=116){m=116;l=208+l|0;break}l=a[r+5>>0]|0;if(!(l<<24>>24)){l=39446;rd=2285;break Sa}l=l&255;if((l|32|0)!=101){m=101;l=208+l|0;break}l=a[r+6>>0]|0;if(!(l<<24>>24)){l=39447;rd=2285;break Sa}if(l<<24>>24==95)break Sa;else{m=95;l=208+(l&255)|0}}else m=115;while(0);gd=d[l>>0]|0;ed=m;rd=2289}while(0);if((rd|0)==2285){gd=0;ed=a[208+(d[l>>0]|0)>>0]|0;rd=2289}if((rd|0)==2289?(gd|0)!=(ed&255|0):0)break;ad(j,46264,hd);rd=2378;break Qa}while(0);l=c[z+12>>2]|0;if((y|0)!=65&(l|0)!=0){c[id>>2]=(y|0)==33?46339:46346;c[id+4>>2]=E;c[id+8>>2]=0;ad(j,46302,id);rd=2378;break}q=(y|0)==65;if(q&(l|0)==0){c[jd>>2]=E;c[jd+4>>2]=0;ad(j,46352,jd);rd=2378;break}do if(s){h=q?33:y;if(N|0){rd=2319;break}if(!(c[7324]|0)){m=Ua[c[29340>>2]&127](36)|0;i=1;l=h;rd=2341;break}l=Ua[c[29356>>2]&127](36)|0;if((c[14985]|0)>>>0<36)c[14985]=36;i=59064;m=c[i>>2]|0;i=c[i+4>>2]|0;if((i|0)>0|(i|0)==0&m>>>0>0){qd=c[14978]|0;pd=Rv(m|0,i|0,l|0,((l|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}m=Ua[c[29340>>2]&127](l)|0;if(!m)break Qa;l=Ua[c[29352>>2]&127](m)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0<=(c[14987]|0)>>>0){q=m;i=1;break}c[14987]=l;q=m;i=1}else{m=c[z+72>>2]|0;i=c[N+16>>2]|0;if(!m)l=-1e6;else{l=0;while(1)if((c[i+(l<<4)+12>>2]|0)==(m|0))break;else l=l+1|0}p=c[i+(l<<4)>>2]|0;if(x)n=c[i+16>>2]|0;else n=p;o=(l|0)==1;h=x|o?5:7;i=c[j>>2]|0;l=a[i+165>>0]|0;do if(!((l|t)<<24>>24)){m=c[i+312>>2]|0;if(!m)break;l=Za[m&127](c[i+316>>2]|0,h,w,r,n,c[j+240>>2]|0)|0;if((l|0)==1){ad(j,39216,ld);c[j+12>>2]=23;rd=2378;break Qa}if((l|2|0)!=2){ad(j,39231,md);c[j+12>>2]=1;rd=2378;break Qa}if(l|0){rd=2378;break Qa}i=c[j>>2]|0;l=a[i+165>>0]|0}while(0);m=o?34855:34585;do if(!(l<<24>>24)){if(a[u>>0]|0)break;l=c[i+312>>2]|0;if(!l)break;l=Za[l&127](c[i+316>>2]|0,18,m,0,p,c[j+240>>2]|0)|0;if((l|0)==1){ad(j,39216,nd);c[j+12>>2]=23;rd=2378;break Qa}if((l|2|0)==2)if(!l)break;else{rd=2378;break Qa}else{ad(j,39231,od);c[j+12>>2]=1;rd=2378;break Qa}}while(0);h=q?33:y;rd=2319}while(0);Ta:do if((rd|0)==2319){if(c[N+272>>2]|0){if(a[B>>0]|0){rd=2379;break Qa}}else{do if((e[N+276>>1]|0)>=36){l=N+300|0;m=c[l>>2]|0;if(m|0){c[l>>2]=c[m>>2];i=N+284|0;c[i>>2]=(c[i>>2]|0)+1;i=0;l=h;rd=2341;break Ta}l=N+296|0;m=c[l>>2]|0;if(!m){l=N+292|0;break}else{c[l>>2]=c[m>>2];i=N+284|0;c[i>>2]=(c[i>>2]|0)+1;i=0;l=h;rd=2341;break Ta}}else l=N+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1}m=Yd(N,36,0)|0;i=0;l=h;rd=2341}while(0);if((rd|0)==2341)if(!m){rd=2378;break}else{q=m;h=l}p=q+4|0;I=p;J=I+32|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[q>>2]=w;n=c[C>>2]|0;Ua:do if(!n)i=0;else{o=(Cu(n)|0)+1|0;Va:do if(i){qd=Qv(o|0,0,-1,-1)|0;pd=L()|0;if(pd>>>0>0|(pd|0)==0&qd>>>0>2147483390){i=0;break Ua}if(!(c[7324]|0)){l=Ua[c[29340>>2]&127](o)|0;rd=2367;break}l=Ua[c[29356>>2]&127](o)|0;if((c[14985]|0)>>>0<o>>>0)c[14985]=o;i=59064;m=c[i>>2]|0;i=c[i+4>>2]|0;if((i|0)>0|(i|0)==0&m>>>0>0){qd=c[14978]|0;pd=Rv(m|0,i|0,l|0,((l|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}l=Ua[c[29340>>2]&127](l)|0;if(!l){i=0;break Ua}m=Ua[c[29352>>2]&127](l)|0;m=(c[14978]|0)+m|0;c[14978]=m;if(m>>>0>(c[14982]|0)>>>0)c[14982]=m;m=(c[14981]|0)+1|0;c[14981]=m;if(m>>>0<=(c[14987]|0)>>>0)break;c[14987]=m}else{if(c[N+272>>2]|0){if(a[B>>0]|0){i=0;break Ua}}else{do if(!(0<0|(0==0?(e[N+276>>1]|0)>>>0<o>>>0:0))){m=N+300|0;l=c[m>>2]|0;if(l|0){c[m>>2]=c[l>>2];rd=N+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=2367;break Va}m=N+296|0;l=c[m>>2]|0;if(!l){l=N+292|0;break}else{c[m>>2]=c[l>>2];rd=N+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=2367;break Va}}else l=N+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1}l=Yd(N,o,0)|0;rd=2367}while(0);if((rd|0)==2367)if(!l){i=0;break}cw(l|0,n|0,o|0)|0;i=l}while(0);c[p>>2]=i;c[q+20>>2]=c[(c[N+16>>2]|0)+(A<<4)+12>>2];c[q+24>>2]=c[z+72>>2];a[q+8>>0]=D;a[q+9>>0]=(h|0)==33?1:2;Wa:do if((d[u>>0]|0)>1){m=c[C>>2]|0;l=c[j+272>>2]|0;if(!l){m=0;l=F;break}while(1){if((c[l>>2]|0)==(m|0))break;l=c[l+12>>2]|0;if(!l){m=0;l=F;break Wa}}c[l>>2]=i;m=0;l=F}else{if(!F){m=F;l=0;break}m=F;l=bk(N,F,1,0)|0}while(0);c[q+12>>2]=l;c[q+16>>2]=k;c[j+236>>2]=q;oi(N,E);l=q;k=m;r=q;break Ka}else rd=2378;while(0);if((rd|0)==2378?N|0:0)rd=2379;do if((rd|0)==2379){if(c[N+480>>2]|0){Vd(N,w);rd=2387;break Ka}l=w;if((c[N+304>>2]|0)>>>0>l>>>0)break;if((c[N+308>>2]|0)>>>0<=l>>>0)break;rd=N+300|0;c[w>>2]=c[rd>>2];c[rd>>2]=w;rd=2387;break Ka}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](w);rd=2387;break Ka}else{rd=Ua[c[29352>>2]&127](w)|0;c[14978]=(c[14978]|0)-rd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](w);rd=2387;break Ka}}while(0);if((a[N+164>>0]|0)==1){rd=N+166|0;a[rd>>0]=a[rd>>0]|1;rd=2387}else rd=2387}else rd=2387}else rd=2387}while(0);do if((rd|0)==2387){oi(N,E);if(k){p=k+4|0;l=c[k>>2]|0;Xa:do if((c[p>>2]|0)>0){i=N+480|0;h=N+304|0;n=N+308|0;o=N+300|0;if(!N){m=0;while(1){l=c[l+(m<<3)>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{rd=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-rd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);m=m+1|0;l=c[k>>2]|0;if((m|0)>=(c[p>>2]|0))break Xa}}m=0;do{l=c[l+(m<<3)>>2]|0;do if(l|0){if(c[i>>2]|0){Vd(N,l);break}rd=l;if((c[h>>2]|0)>>>0<=rd>>>0?(c[n>>2]|0)>>>0>rd>>>0:0){c[l>>2]=c[o>>2];c[o>>2]=l;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{rd=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-rd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);m=m+1|0;l=c[k>>2]|0}while((m|0)<(c[p>>2]|0))}while(0);Ya:do if(l){do if(N|0){m=N+480|0;if(!(c[m>>2]|0)){i=l;if((c[N+304>>2]|0)>>>0>i>>>0)break;if((c[N+308>>2]|0)>>>0<=i>>>0)break;rd=N+300|0;c[l>>2]=c[rd>>2];c[rd>>2]=l}else Vd(N,l);l=m;rd=2420;break Ya}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](l);rd=2418;break}else{rd=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-rd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);rd=2418;break}}else rd=2418;while(0);if((rd|0)==2418)if(N){l=N+480|0;rd=2420}if((rd|0)==2420){if(c[l>>2]|0){Vd(N,k);l=0;k=F;r=0;break}rd=k;if((c[N+304>>2]|0)>>>0<=rd>>>0?(c[N+308>>2]|0)>>>0>rd>>>0:0){l=N+300|0;c[k>>2]=c[l>>2];c[l>>2]=k;l=0;k=F;r=0;break}}if(k)if(!(c[7324]|0)){_a[c[29344>>2]&127](k);l=0;k=F;r=0;break}else{l=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-l;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);l=0;k=F;r=0;break}else{l=0;k=F;r=0}}else{l=0;k=F;r=0}}while(0);if(k|0)li(N,k);do if(!((l|0)==0|(c[j+236>>2]|0)!=0)){Vi(N,c[l+28>>2]|0);k=c[l>>2]|0;do if(k|0){if(N|0){if(c[N+480>>2]|0){Vd(N,k);break}j=k;if((c[N+304>>2]|0)>>>0<=j>>>0?(c[N+308>>2]|0)>>>0>j>>>0:0){j=N+300|0;c[k>>2]=c[j>>2];c[j>>2]=k;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{j=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}}while(0);k=c[l+4>>2]|0;do if(k|0){if(N|0){if(c[N+480>>2]|0){Vd(N,k);break}j=k;if((c[N+304>>2]|0)>>>0<=j>>>0?(c[N+308>>2]|0)>>>0>j>>>0:0){j=N+300|0;c[k>>2]=c[j>>2];c[j>>2]=k;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{j=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}}while(0);k=c[l+12>>2]|0;if(k|0)li(N,k);k=c[l+16>>2]|0;do if(k|0){q=k+4|0;l=c[k>>2]|0;Za:do if((c[q>>2]|0)>0){h=N+480|0;n=N+304|0;o=N+308|0;p=N+300|0;if(!N){m=0;while(1){l=c[l+(m<<3)>>2]|0;do if(l|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{j=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}while(0);m=m+1|0;l=c[k>>2]|0;if((m|0)>=(c[q>>2]|0))break Za}}i=0;do{l=c[l+(i<<3)>>2]|0;_a:do if(l|0){if(c[h>>2]|0){Vd(N,l);break}m=l;do if((c[n>>2]|0)>>>0<=m>>>0){if((c[o>>2]|0)>>>0<=m>>>0)break;c[l>>2]=c[p>>2];c[p>>2]=l;break _a}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{j=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);i=i+1|0;l=c[k>>2]|0}while((i|0)<(c[q>>2]|0))}while(0);$a:do if(l){do if(N|0){m=N+480|0;if(!(c[m>>2]|0)){i=l;if((c[N+304>>2]|0)>>>0>i>>>0)break;if((c[N+308>>2]|0)>>>0<=i>>>0)break;j=N+300|0;c[l>>2]=c[j>>2];c[j>>2]=l}else Vd(N,l);l=m;rd=2487;break $a}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](l);rd=2485;break}else{rd=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-rd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);rd=2485;break}}else rd=2485;while(0);if((rd|0)==2485)if(N){l=N+480|0;rd=2487}if((rd|0)==2487){if(c[l>>2]|0){Vd(N,k);break}j=k;if((c[N+304>>2]|0)>>>0<=j>>>0?(c[N+308>>2]|0)>>>0>j>>>0:0){j=N+300|0;c[k>>2]=c[j>>2];c[j>>2]=k;break}}if(k|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{j=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}}while(0);if(r|0){if(N|0){if(c[N+480>>2]|0){Vd(N,r);break}j=r;if((c[N+304>>2]|0)>>>0<=j>>>0?(c[N+308>>2]|0)>>>0>j>>>0:0){j=N+300|0;c[r>>2]=c[j>>2];c[j>>2]=r;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](r);break}else{j=Ua[c[29352>>2]&127](r)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](r);break}}}while(0);if(!(c[O>>2]|0)){qd=H;rd=c[qd+4>>2]|0;j=M;c[j>>2]=c[qd>>2];c[j+4>>2]=rd;break a}else{qd=K;rd=c[qd+4>>2]|0;j=M;c[j>>2]=c[qd>>2];c[j+4>>2]=rd;break a}}case 242:{c[td+4>>2]=e[td+2>>1];break}case 243:{c[td+-8>>2]=65;break}case 244:{c[td+16>>2]=33;break}case 246:case 245:{c[td+4>>2]=e[td+2>>1];c[td+8>>2]=0;break}case 247:{c[td+-20>>2]=122;c[td+-16>>2]=c[td+4>>2];break}case 315:case 267:case 248:{c[td+16>>2]=0;break}case 268:case 249:{c[td+-8>>2]=c[td+4>>2];break}case 250:{rd=td+-8|0;j=td+-20|0;c[(c[(c[j>>2]|0)+40>>2]|0)+36>>2]=c[rd>>2];c[(c[j>>2]|0)+40>>2]=c[rd>>2];break}case 251:{j=c[td+-8>>2]|0;c[j+40>>2]=j;break}case 252:{pd=td+4|0;qd=c[pd+4>>2]|0;rd=td+-20|0;c[rd>>2]=c[pd>>2];c[rd+4>>2]=qd;ad(j,38526,i);break}case 253:{ad(j,38621,n);break}case 254:{ad(j,38705,o);break}case 255:{l=c[td+-20>>2]|0;m=c[td+-8>>2]|0;i=c[td+-68>>2]&255;h=td+-80|0;n=c[j>>2]|0;o=_m(j,122,td+-56|0,c[h>>2]|0,c[td+4>>2]|0)|0;if(!o)k=m;else{if((d[j+200>>0]|0)<=1){c[o+20>>2]=ek(n,l,1)|0;if(!m){k=m;m=0}else{k=m;m=bk(n,m,1,0)|0}}else{c[o+20>>2]=l;l=0;k=0}c[o+16>>2]=m;a[o+1>>0]=i}if(l|0)pi(n,l);if(k|0)li(n,k);c[h>>2]=o;break}case 256:{q=c[td+-32>>2]|0;l=c[td+-20>>2]|0;m=c[td+-68>>2]&255;r=c[td+-8>>2]|0;s=td+-80|0;t=c[j>>2]|0;u=_m(j,120,td+-44|0,c[s>>2]|0,c[td+4>>2]|0)|0;do if(!u){do if(q|0){p=q+4|0;k=c[q>>2]|0;ab:do if((c[p>>2]|0)>0){i=t+480|0;h=t+304|0;n=t+308|0;o=t+300|0;if(!t){m=0;while(1){k=c[k+(m<<3)>>2]|0;do if(k|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{j=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}while(0);m=m+1|0;k=c[q>>2]|0;if((m|0)>=(c[p>>2]|0))break ab}}m=0;do{k=c[k+(m<<3)>>2]|0;do if(k|0){if(c[i>>2]|0){Vd(t,k);break}j=k;if((c[h>>2]|0)>>>0<=j>>>0?(c[n>>2]|0)>>>0>j>>>0:0){c[k>>2]=c[o>>2];c[o>>2]=k;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{j=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}}while(0);m=m+1|0;k=c[q>>2]|0}while((m|0)<(c[p>>2]|0))}while(0);bb:do if(k){do if(t|0){m=t+480|0;if(!(c[m>>2]|0)){i=k;if((c[t+304>>2]|0)>>>0>i>>>0)break;if((c[t+308>>2]|0)>>>0<=i>>>0)break;j=t+300|0;c[k>>2]=c[j>>2];c[j>>2]=k}else Vd(t,k);k=q;rd=2569;break bb}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](k);rd=2567;break}else{rd=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-rd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);rd=2567;break}}else rd=2567;while(0);if((rd|0)==2567)if(!t)k=q;else{m=t+480|0;k=q;rd=2569}if((rd|0)==2569){if(c[m>>2]|0){Vd(t,k);break}j=k;if((c[t+304>>2]|0)>>>0<=j>>>0?(c[t+308>>2]|0)>>>0>j>>>0:0){j=t+300|0;c[k>>2]=c[j>>2];c[j>>2]=k;break}}if(k|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{j=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}}while(0);if(r){k=c[r>>2]|0;if(k|0)pi(t,k);k=c[r+4>>2]|0;if(k|0)li(t,k);k=c[r+8>>2]|0;if(k|0)pi(t,k);k=c[r+12>>2]|0;if(k|0)li(t,k);if(t|0){if(c[t+480>>2]|0){Vd(t,r);k=l;break}j=r;if((c[t+304>>2]|0)>>>0<=j>>>0?(c[t+308>>2]|0)>>>0>j>>>0:0){k=t+300|0;c[r>>2]=c[k>>2];c[k>>2]=r;k=l;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](r);k=l;break}else{k=Ua[c[29352>>2]&127](r)|0;c[14978]=(c[14978]|0)-k;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](r);k=l;break}}else k=l}else{if((d[j+200>>0]|0)>1)k=0;else{k=l;l=dk(t,l,1)|0}c[u+8>>2]=l;c[u+24>>2]=q;c[u+28>>2]=r;a[u+1>>0]=m}while(0);if(k|0)ni(t,k,1);c[s>>2]=u;break}case 257:{l=c[td+-8>>2]|0;m=td+-56|0;i=c[j>>2]|0;h=_m(j,121,td+-32|0,c[m>>2]|0,c[td+4>>2]|0)|0;if(!h)k=l;else{if((d[j+200>>0]|0)<=1)if(!l){k=l;l=0}else{k=l;l=bk(i,l,1,0)|0}else k=0;c[h+16>>2]=l;a[h+1>>0]=11}if(k|0)li(i,k);c[m>>2]=h;break}case 258:{p=c[j>>2]|0;i=c[td+-8>>2]|0;q=td+-20|0;o=c[q>>2]|0;h=c[td+4>>2]|0;cb:do if(!p){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](44)|0;rd=2630;break}k=Ua[c[29356>>2]&127](44)|0;if((c[14985]|0)>>>0<44)c[14985]=44;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){j=c[14978]|0;rd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;qd=L()|0;c[14768]=((qd|0)<0|(qd|0)==0&rd>>>0<=j>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(k){l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0){c[14987]=l;rd=2633}else rd=2633}else rd=2631}else{if(c[p+272>>2]|0){if(a[p+81>>0]|0){rd=2631;break}}else{do if((e[p+276>>1]|0)>=44){l=p+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=p+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=2630;break cb}l=p+296|0;k=c[l>>2]|0;if(!k){k=p+292|0;break}else{c[l>>2]=c[k>>2];rd=p+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=2630;break cb}}else k=p+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(p,44,0)|0;rd=2630}while(0);if((rd|0)==2630)if(!k)rd=2631;else rd=2633;if((rd|0)==2631)if(!i)k=0;else{ni(p,i,1);k=0}else if((rd|0)==2633){I=k+2|0;J=I+42|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));a[k>>0]=-125;c[k+8>>2]=i;a[k+1>>0]=11;while(1)if(!(a[880+(d[o>>0]|0)>>0]&1))break;else o=o+1|0;l=h-o|0;db:do if((l|0)<=0)if(!o)l=0;else{m=l;rd=2640}else while(1){m=l+-1|0;if(!(a[880+(d[o+m>>0]|0)>>0]&1)){m=l;rd=2640;break db}if((l|0)>1)l=m;else{rd=2640;break}}while(0);eb:do if((rd|0)==2640){h=Qv(m|0,((m|0)<0)<<31>>31|0,1,0)|0;n=L()|0;fb:do if(c[p+272>>2]|0)if(!(a[p+81>>0]|0))rd=2650;else{l=0;break eb}else{do if(!(n>>>0>0|((n|0)==0?h>>>0>(e[p+276>>1]|0)>>>0:0))){i=p+300|0;l=c[i>>2]|0;if(l|0){c[i>>2]=c[l>>2];j=p+284|0;c[j>>2]=(c[j>>2]|0)+1;break fb}i=p+296|0;l=c[i>>2]|0;if(!l){l=p+292|0;break}else{c[i>>2]=c[l>>2];j=p+284|0;c[j>>2]=(c[j>>2]|0)+1;break fb}}else l=p+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1;rd=2650}while(0);if((rd|0)==2650)l=Yd(p,h,n)|0;if(l){cw(l|0,o|0,m|0)|0;a[l+m>>0]=0;m=a[l>>0]|0;if(m<<24>>24){h=0;i=l;do{if(a[880+(m&255)>>0]&1)a[i>>0]=32;h=h+1|0;i=l+h|0;m=a[i>>0]|0}while(m<<24>>24!=0)}}else l=0}while(0);c[k+32>>2]=l}c[q>>2]=k;break}case 259:{k=cj(j,71,0,0)|0;c[td+-32>>2]=k;if(k|0)a[k+1>>0]=4;break}case 260:{k=mj(c[j>>2]|0,71,td+-8|0,1)|0;c[td+-56>>2]=k;if(k|0)a[k+1>>0]=c[td+-32>>2];break}case 261:{c[td+4>>2]=1;break}case 263:{c[td+4>>2]=3;break}case 264:{v=c[td+4>>2]|0;u=c[td+-8>>2]|0;w=c[j>>2]|0;gb:do if(!(a[w+81>>0]|0)){hb:do if(!(a[w+165>>0]|0)){i=j+4|0;h=w+24|0;n=(c[h>>2]&1|0)==0;o=w+16|0;qd=c[(c[o>>2]|0)+12>>2]|0;a[w+78>>0]=a[qd+77>>0]|0;if((b[qd+78>>1]&1)==0?(Da=ch(w,0,i,0)|0,(Da|0)!=0):0)k=Da;else rd=2670;ib:do if((rd|0)==2670){k=w+20|0;l=c[k>>2]|0;if((l|0)>1)do{m=l;l=l+-1|0;if((b[(c[(c[o>>2]|0)+(l<<4)+12>>2]|0)+78>>1]&1)==0?(Sa=ch(w,l,i,0)|0,Sa|0):0){k=Sa;break ib}}while((m|0)>2);if(n)c[h>>2]=c[h>>2]&-2;if(!(a[w+89>>0]|0))break hb;c[h>>2]=c[h>>2]|16;break hb}while(0);c[j+12>>2]=k;j=j+36|0;c[j>>2]=(c[j>>2]|0)+1;break gb}else k=w+20|0;while(0);t=c[v+12>>2]|0;s=c[v+16>>2]|0;q=c[k>>2]|0;if((q|0)>0){r=(t|0)==0;p=c[w+16>>2]|0;k=0;o=0;do{h=o^o>>>0<2;if(!r){m=c[p+(h<<4)>>2]|0;qd=a[m>>0]|0;l=(d[208+(qd&255)>>0]|0)-(d[208+(d[t>>0]|0)>>0]|0)|0;if(!(qd<<24>>24==0|(l|0)!=0)){i=t;do{m=m+1|0;i=i+1|0;qd=a[m>>0]|0;l=(d[208+(qd&255)>>0]|0)-(d[208+(d[i>>0]|0)>>0]|0)|0}while(!(qd<<24>>24==0|(l|0)!=0))}if(!l)rd=2687}else rd=2687;if((rd|0)==2687){rd=0;i=c[p+(h<<4)+12>>2]|0;h=c[i+52>>2]|0;if(!h){l=i+44|0;k=i+48|0}else{l=a[s>>0]|0;if(!(l<<24>>24))k=0;else{k=0;m=s;do{m=m+1|0;k=G(k+(d[208+(l&255)>>0]|0)|0,-1640531535)|0;l=a[m>>0]|0}while(l<<24>>24!=0)}k=(k>>>0)%((c[i+40>>2]|0)>>>0)|0;l=h+(k<<3)|0;k=h+(k<<3)+4|0}l=c[l>>2]|0;jb:do if(!l)k=59292;else{n=d[208+(d[s>>0]|0)>>0]|0;while(1){k=c[k>>2]|0;l=l+-1|0;i=c[k+12>>2]|0;qd=a[i>>0]|0;m=(d[208+(qd&255)>>0]|0)-n|0;if(!(qd<<24>>24==0|(m|0)!=0)){h=s;do{i=i+1|0;h=h+1|0;qd=a[i>>0]|0;m=(d[208+(qd&255)>>0]|0)-(d[208+(d[h>>0]|0)>>0]|0)|0}while(!(qd<<24>>24==0|(m|0)!=0))}if(!m)break jb;if(!l){k=59292;break}}}while(0);k=c[k+8>>2]|0;if(k){rd=2702;break}}o=o+1|0}while((o|0)<(q|0));if(k|0){hl(j,k);break}}if(!u){c[qc>>2]=v;c[qc+4>>2]=0;ad(j,46398,qc)}else fl(j,t);a[j+17>>0]=1}while(0);oi(w,v);break}case 265:{rd=c[td+-32>>2]|0;an(j,24,30104,rd,rd,c[td+-8>>2]|0,c[td+4>>2]|0);break}case 266:{rd=c[td+4>>2]|0;an(j,25,30144,rd,0,0,rd);break}case 269:{m=c[j>>2]|0;kb:do if(!(a[m+165>>0]|0)){i=j+4|0;h=m+24|0;n=(c[h>>2]&1|0)==0;o=m+16|0;pd=c[(c[o>>2]|0)+12>>2]|0;a[m+78>>0]=a[pd+77>>0]|0;if((b[pd+78>>1]&1)==0?(ga=ch(m,0,i,0)|0,(ga|0)!=0):0)k=ga;else rd=2715;lb:do if((rd|0)==2715){k=c[m+20>>2]|0;if((k|0)>1)do{l=k;k=k+-1|0;if((b[(c[(c[o>>2]|0)+(k<<4)+12>>2]|0)+78>>1]&1)==0?(Ga=ch(m,k,i,0)|0,Ga|0):0){k=Ga;break lb}}while((l|0)>2);if(n)c[h>>2]=c[h>>2]&-2;if(!(a[m+89>>0]|0))break kb;c[h>>2]=c[h>>2]|16;break kb}while(0);c[j+12>>2]=k;j=j+36|0;c[j>>2]=(c[j>>2]|0)+1;break a}while(0);k=c[j>>2]|0;w=k+20|0;l=c[w>>2]|0;if((l|0)>0){x=j+116|0;v=0;u=c[k+16>>2]|0;k=l;while(1){l=c[(c[u+12>>2]|0)+16>>2]|0;if(l){do{k=c[l+8>>2]|0;if((c[k+56>>2]|0)==0?(ec=c[k+8>>2]|0,ec|0):0){t=k+72|0;s=ec;do{m=c[t>>2]|0;if(!m)k=-1e6;else{i=c[(c[j>>2]|0)+16>>2]|0;k=0;while(1)if((c[i+(k<<4)+12>>2]|0)==(m|0))break;else k=k+1|0}r=c[x>>2]|0;r=(r|0)==0?j:r;m=r+84|0;i=c[m>>2]|0;q=1<<k;mb:do if((((i&q|0)==0?(c[m>>2]=i|q,(k|0)==1):0)?(fc=c[r>>2]|0,gc=fc+16|0,(c[(c[gc>>2]|0)+20>>2]|0)==0):0)?(a[r+199>>0]|0)==0:0){k=Ne(c[fc>>2]|0,0,fc,qd,0,542)|0;if(k|0){ad(r,32157,cc);c[r+12>>2]=k;break}pd=c[qd>>2]|0;c[(c[gc>>2]|0)+20>>2]=pd;k=c[fc+92>>2]|0;h=c[pd+4>>2]|0;c[h+4>>2]=c[pd>>2];do if(!(b[h+22>>1]&2)){n=h+32|0;o=h+36|0;p=(c[n>>2]|0)-(c[o>>2]|0)|0;do if((k+-512|0)>>>0<65025){if(k+-1&k|0)break;c[n>>2]=k;i=h+80|0;k=c[i>>2]|0;if(!k)break;m=k+-4|0;c[i>>2]=m;k=m;do if((c[14816]|0)>>>0<=k>>>0)if((c[14817]|0)>>>0>k>>>0){c[14979]=(c[14979]|0)+-1;c[m>>2]=c[14819];c[14819]=m;pd=(c[14820]|0)+1|0;c[14820]=pd;c[14821]=(pd|0)<(c[14815]|0)&1;break}else{k=Ua[c[29352>>2]&127](m)|0;rd=2750;break}else{k=Ua[c[29352>>2]&127](m)|0;rd=2750}while(0);do if((rd|0)==2750){rd=0;c[14980]=(c[14980]|0)-k;if(!(c[7324]|0)){_a[c[29344>>2]&127](m);break}else{pd=Ua[c[29352>>2]&127](m)|0;c[14978]=(c[14978]|0)-pd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](m);break}}while(0);c[i>>2]=0}while(0);pd=Qe(c[h>>2]|0,n,p)|0;c[o>>2]=(c[n>>2]|0)-(p&65535);if((pd|0)!=7)break;k=fc+81|0;do if(!(a[k>>0]|0)){if(a[fc+82>>0]|0)break;a[k>>0]=1;if((c[fc+180>>2]|0)>0)c[fc+264>>2]=1;k=fc+272|0;c[k>>2]=(c[k>>2]|0)+1;k=c[fc+236>>2]|0;if(!k)break;c[k+12>>2]=7}while(0);break mb}while(0)}while(0);pd=r+80|0;c[pd>>2]=c[pd>>2]|q;$k(j,s,-1);s=c[s+20>>2]|0}while((s|0)!=0)}l=c[l>>2]|0}while((l|0)!=0);k=c[w>>2]|0}v=v+1|0;if((v|0)>=(k|0))break;else u=u+16|0}}break}case 270:{l=td+-8|0;s=td+4|0;v=c[j>>2]|0;nb:do if(!(a[v+165>>0]|0)){i=j+4|0;h=v+24|0;n=(c[h>>2]&1|0)==0;o=v+16|0;pd=c[(c[o>>2]|0)+12>>2]|0;a[v+78>>0]=a[pd+77>>0]|0;if((b[pd+78>>1]&1)==0?(Ea=ch(v,0,i,0)|0,(Ea|0)!=0):0)k=Ea;else rd=2770;ob:do if((rd|0)==2770){k=c[v+20>>2]|0;if((k|0)>1)do{m=k;k=k+-1|0;if((b[(c[(c[o>>2]|0)+(k<<4)+12>>2]|0)+78>>1]&1)==0?(Pa=ch(v,k,i,0)|0,Pa|0):0){k=Pa;break ob}}while((m|0)>2);if(n)c[h>>2]=c[h>>2]&-2;if(!(a[v+89>>0]|0))break nb;c[h>>2]=c[h>>2]|16;break nb}while(0);c[j+12>>2]=k;j=j+36|0;c[j>>2]=(c[j>>2]|0)+1;break a}while(0);k=c[j>>2]|0;do if(!(c[s>>2]|0)){q=oj(k,l)|0;if(!q)break a;p=a[v+78>>0]|0;h=c[v+392>>2]|0;if(!h){m=v+384|0;k=v+388|0}else{m=a[q>>0]|0;if(!(m<<24>>24))k=0;else{k=0;i=q;do{i=i+1|0;k=G(k+(d[208+(m&255)>>0]|0)|0,-1640531535)|0;m=a[i>>0]|0}while(m<<24>>24!=0)}k=(k>>>0)%((c[v+380>>2]|0)>>>0)|0;m=h+(k<<3)|0;k=h+(k<<3)+4|0}m=c[m>>2]|0;pb:do if(!m)k=59292;else{o=d[208+(d[q>>0]|0)>>0]|0;while(1){k=c[k>>2]|0;m=m+-1|0;h=c[k+12>>2]|0;pd=a[h>>0]|0;i=(d[208+(pd&255)>>0]|0)-o|0;if(!(pd<<24>>24==0|(i|0)!=0)){n=q;do{h=h+1|0;n=n+1|0;pd=a[h>>0]|0;i=(d[208+(pd&255)>>0]|0)-(d[208+(d[n>>0]|0)>>0]|0)|0}while(!(pd<<24>>24==0|(i|0)!=0))}if(!i)break pb;if(!m){k=59292;break}}}while(0);pd=c[k+8>>2]|0;if((pd|0)==0|(pd+(((p&255)+-1|0)*20|0)|0)==0){do if(v){if(c[v+480>>2]|0){Vd(v,q);break}pd=q;if((c[v+304>>2]|0)>>>0<=pd>>>0?(c[v+308>>2]|0)>>>0>pd>>>0:0){pd=v+300|0;c[q>>2]=c[pd>>2];c[pd>>2]=q}else rd=2818}else rd=2818;while(0);do if((rd|0)==2818)if(!(c[7324]|0)){_a[c[29344>>2]&127](q);break}else{pd=Ua[c[29352>>2]&127](q)|0;c[14978]=(c[14978]|0)-pd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](q);break}while(0);k=c[j>>2]|0;if(!(c[td+8>>2]|0)){m=d[k+164>>0]|0;break}if(a[k+165>>0]|0){ad(j,39404,Vb);break a}k=uk(k,l)|0;if((k|0)>=0){l=s;m=k;break}c[Yb>>2]=l;ad(j,39421,Yb);break a}k=c[j>>2]|0;h=k+20|0;l=c[h>>2]|0;if((l|0)>0){i=0;m=c[k+16>>2]|0;while(1){k=c[(c[m+12>>2]|0)+16>>2]|0;if(!k)k=l;else{do{en(j,c[k+8>>2]|0,q);k=c[k>>2]|0}while((k|0)!=0);k=c[h>>2]|0}i=i+1|0;if((i|0)>=(k|0))break;else{m=m+16|0;l=k}}}if(v|0){if(c[v+480>>2]|0){Vd(v,q);break a}j=q;if((c[v+304>>2]|0)>>>0<=j>>>0?(c[v+308>>2]|0)>>>0>j>>>0:0){j=v+300|0;c[q>>2]=c[j>>2];c[j>>2]=q;break a}}if(!(c[7324]|0)){_a[c[29344>>2]&127](q);break a}else{j=Ua[c[29352>>2]&127](q)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](q);break a}}else{if(!(c[td+8>>2]|0)){m=d[k+164>>0]|0;break}if(a[k+165>>0]|0){ad(j,39404,Ra);break a}k=uk(k,l)|0;if((k|0)<0){c[Wa>>2]=l;ad(j,39421,Wa);break a}else{l=s;m=k}}while(0);u=oj(v,l)|0;if(u|0){k=c[(c[v+16>>2]|0)+(m<<4)>>2]|0;l=Qd(v,u,k)|0;if(!l){r=fi(v,u,k)|0;do if(!(c[v+480>>2]|0)){pd=u;if((c[v+304>>2]|0)>>>0<=pd>>>0?(c[v+308>>2]|0)>>>0>pd>>>0:0){pd=v+300|0;c[u>>2]=c[pd>>2];c[pd>>2]=u;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](u);break}else{pd=Ua[c[29352>>2]&127](u)|0;c[14978]=(c[14978]|0)-pd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](u);break}}else Vd(v,u);while(0);if(!r){ad(j,46778,dc);break a}q=c[j+116>>2]|0;q=(q|0)==0?j:q;k=q+84|0;l=c[k>>2]|0;p=1<<m;do if((((l&p|0)==0?(c[k>>2]=l|p,(m|0)==1):0)?(xc=c[q>>2]|0,lc=xc+16|0,(c[(c[lc>>2]|0)+20>>2]|0)==0):0)?(a[q+199>>0]|0)==0:0){k=Ne(c[xc>>2]|0,0,xc,qd,0,542)|0;if(k|0){ad(q,32157,jc);c[q+12>>2]=k;break}qd=c[qd>>2]|0;c[(c[lc>>2]|0)+20>>2]=qd;k=c[xc+92>>2]|0;i=c[qd+4>>2]|0;c[i+4>>2]=c[qd>>2];if(!(b[i+22>>1]&2)){h=i+32|0;n=i+36|0;o=(c[h>>2]|0)-(c[n>>2]|0)|0;do if((k+-512|0)>>>0<65025?(k+-1&k|0)==0:0){c[h>>2]=k;m=i+80|0;k=c[m>>2]|0;if(!k)break;l=k+-4|0;c[m>>2]=l;k=l;do if((c[14816]|0)>>>0<=k>>>0)if((c[14817]|0)>>>0>k>>>0){c[14979]=(c[14979]|0)+-1;c[l>>2]=c[14819];c[14819]=l;qd=(c[14820]|0)+1|0;c[14820]=qd;c[14821]=(qd|0)<(c[14815]|0)&1;break}else{k=Ua[c[29352>>2]&127](l)|0;rd=2903;break}else{k=Ua[c[29352>>2]&127](l)|0;rd=2903}while(0);do if((rd|0)==2903){c[14980]=(c[14980]|0)-k;if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{rd=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-rd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);c[m>>2]=0}while(0);rd=Qe(c[i>>2]|0,h,o)|0;c[n>>2]=(c[h>>2]|0)-(o&65535);if((rd|0)==7){k=xc+81|0;do if(!(a[k>>0]|0)){if(a[xc+82>>0]|0)break;a[k>>0]=1;if((c[xc+180>>2]|0)>0)c[xc+264>>2]=1;k=xc+272|0;c[k>>2]=(c[k>>2]|0)+1;k=c[xc+236>>2]|0;if(!k)break;c[k+12>>2]=7}while(0);break}}}while(0);rd=q+80|0;c[rd>>2]=c[rd>>2]|p;$k(j,r,-1);break a}if((c[l+56>>2]|0)==0?(r=c[l+8>>2]|0,(r|0)!=0):0){s=l+72|0;t=j+116|0;do{l=c[s>>2]|0;if(!l)k=-1e6;else{m=c[(c[j>>2]|0)+16>>2]|0;k=0;while(1)if((c[m+(k<<4)+12>>2]|0)==(l|0))break;else k=k+1|0}q=c[t>>2]|0;q=(q|0)==0?j:q;l=q+84|0;m=c[l>>2]|0;p=1<<k;qb:do if((((m&p|0)==0?(c[l>>2]=m|p,(k|0)==1):0)?(Rc=c[q>>2]|0,Sc=Rc+16|0,(c[(c[Sc>>2]|0)+20>>2]|0)==0):0)?(a[q+199>>0]|0)==0:0){k=Ne(c[Rc>>2]|0,0,Rc,qd,0,542)|0;if(k|0){ad(q,32157,Pc);c[q+12>>2]=k;break}pd=c[qd>>2]|0;c[(c[Sc>>2]|0)+20>>2]=pd;k=c[Rc+92>>2]|0;i=c[pd+4>>2]|0;c[i+4>>2]=c[pd>>2];do if(!(b[i+22>>1]&2)){h=i+32|0;n=i+36|0;o=(c[h>>2]|0)-(c[n>>2]|0)|0;do if((k+-512|0)>>>0<65025){if(k+-1&k|0)break;c[h>>2]=k;m=i+80|0;k=c[m>>2]|0;if(!k)break;l=k+-4|0;c[m>>2]=l;k=l;do if((c[14816]|0)>>>0<=k>>>0)if((c[14817]|0)>>>0>k>>>0){c[14979]=(c[14979]|0)+-1;c[l>>2]=c[14819];c[14819]=l;pd=(c[14820]|0)+1|0;c[14820]=pd;c[14821]=(pd|0)<(c[14815]|0)&1;break}else{k=Ua[c[29352>>2]&127](l)|0;rd=2856;break}else{k=Ua[c[29352>>2]&127](l)|0;rd=2856}while(0);do if((rd|0)==2856){rd=0;c[14980]=(c[14980]|0)-k;if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{pd=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-pd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);c[m>>2]=0}while(0);pd=Qe(c[i>>2]|0,h,o)|0;c[n>>2]=(c[h>>2]|0)-(o&65535);if((pd|0)!=7)break;k=Rc+81|0;do if(!(a[k>>0]|0)){if(a[Rc+82>>0]|0)break;a[k>>0]=1;if((c[Rc+180>>2]|0)>0)c[Rc+264>>2]=1;k=Rc+272|0;c[k>>2]=(c[k>>2]|0)+1;k=c[Rc+236>>2]|0;if(!k)break;c[k+12>>2]=7}while(0);break qb}while(0)}while(0);pd=q+80|0;c[pd>>2]=c[pd>>2]|p;$k(j,r,-1);r=c[r+20>>2]|0}while((r|0)!=0);if(v|0)rd=2871}else rd=2871;if((rd|0)==2871){if(c[v+480>>2]|0){Vd(v,u);break a}j=u;if((c[v+304>>2]|0)>>>0<=j>>>0?(c[v+308>>2]|0)>>>0>j>>>0:0){j=v+300|0;c[u>>2]=c[j>>2];c[j>>2]=u;break a}}if(!(c[7324]|0)){_a[c[29344>>2]&127](u);break a}else{j=Ua[c[29352>>2]&127](u)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](u);break a}}break}case 271:{xj(j,0,0);break}case 272:{xj(j,td+-8|0,td+4|0);break}case 273:{w=c[td+-32>>2]|0;i=td+4|0;x=c[j>>2]|0;y=x+24|0;z=c[y>>2]|0;do if(!(a[x+81>>0]|0)){l=c[w+8>>2]|0;if(!l)k=w+12|0;else{m=c[x+16>>2]|0;k=0;while(1)if((c[m+(k<<4)+12>>2]|0)==(l|0))break;else k=k+1|0;k=m+(k<<4)|0}s=$c(j,0,c[w+16>>2]|0,c[k>>2]|0)|0;if(s){l=c[s+72>>2]|0;if(!l)u=-1e6;else{m=c[(c[j>>2]|0)+16>>2]|0;k=0;while(1)if((c[m+(k<<4)+12>>2]|0)==(l|0)){u=k;break}else k=k+1|0}v=c[(c[x+16>>2]|0)+(u<<4)>>2]|0;c[y>>2]=c[y>>2]|2;t=oj(x,i)|0;if(t){rb:do if(!(Qd(x,t,v)|0)){if(fi(x,t,v)|0){c[ib>>2]=t;ad(j,46940,ib);rd=3010;break}if((mn(j,s)|0)==0?(tk(j,t)|0)==0:0){l=c[s>>2]|0;if(c[s+12>>2]|0){c[wb>>2]=l;ad(j,46999,wb);rd=3010;break}k=c[j>>2]|0;do if(((a[k+165>>0]|0)==0?(a[j+200>>0]|0)==0:0)?(Gb=c[k+312>>2]|0,Gb|0):0){k=Za[Gb&127](c[k+316>>2]|0,26,v,l,0,c[j+240>>2]|0)|0;if((k|0)==1){ad(j,39216,Hb);c[j+12>>2]=23;rd=3010;break rb}if((k|2|0)==2)if(!k)break;else{rd=3010;break rb}else{ad(j,39231,Ib);c[j+12>>2]=1;rd=3010;break rb}}while(0);if(!(Qk(j,s)|0)){if(!(c[s+56>>2]|0))q=0;else{k=c[s+64>>2]|0;sb:do if(!k)k=0;else while(1){if((c[k>>2]|0)==(x|0))break sb;k=c[k+24>>2]|0;if(!k){k=0;break}}while(0);q=(c[(c[c[k+8>>2]>>2]|0)+76>>2]|0)==0?0:k}r=j+8|0;k=c[r>>2]|0;h=j+116|0;tb:do if(!k){i=c[j>>2]|0;do if(!(c[h>>2]|0)){if(b[i+76>>1]&8)break;a[j+23>>0]=1}while(0);ub:do if(c[i+272>>2]|0)if(!(a[i+81>>0]|0))rd=2968;else break tb;else{do if((e[i+276>>1]|0)>=224){k=i+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];m=i+284|0;c[m>>2]=(c[m>>2]|0)+1;m=l;break ub}k=i+296|0;l=c[k>>2]|0;if(!l){k=i+292|0;break}else{c[k>>2]=c[l>>2];m=i+284|0;c[m>>2]=(c[m>>2]|0)+1;m=l;break ub}}else k=i+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=2968}while(0);if((rd|0)==2968)m=Yd(i,224,0)|0;if(!m)break;I=m+104|0;J=I+120|0;do{c[I>>2]=0;I=I+4|0}while((I|0)<(J|0));c[m>>2]=i;k=i+4|0;l=c[k>>2]|0;if(l|0)c[l+4>>2]=m;c[m+8>>2]=l;c[m+4>>2]=0;c[k>>2]=m;c[m+20>>2]=381479589;c[m+12>>2]=j;c[r>>2]=m;Bi(m,61,0,1,0)|0;p=m;rd=2973}else{p=k;rd=2973}while(0);vb:do if((rd|0)==2973){h=c[h>>2]|0;a[((h|0)==0?j:h)+21>>0]=1;h=c[s>>2]|0;m=a[h>>0]|0;if((h|0)!=(-1|0)&m<<24>>24!=0){l=h;k=0;do{i=l+1|0;if((m&255)>191){l=i;while(1){m=a[l>>0]|0;if((m&-64)<<24>>24==-128)l=l+1|0;else break}}else{l=i;m=a[i>>0]|0}k=k+1|0}while(m<<24>>24!=0&(l|0)!=(-1|0))}else k=0;n=(u|0)==1;o=n&1;c[tc>>2]=v;c[tc+4>>2]=34585;c[tc+8>>2]=v;c[tc+12>>2]=h;c[tc+16>>2]=t;c[tc+20>>2]=o;c[tc+24>>2]=h;yk(j,47026,tc);c[uc>>2]=v;c[uc+4>>2]=34585;c[uc+8>>2]=t;c[uc+12>>2]=t;c[uc+16>>2]=t;c[uc+20>>2]=k;c[uc+24>>2]=h;yk(j,47187,uc);if(Qd(x,39382,v)|0){qd=c[s>>2]|0;c[vc>>2]=v;c[vc+4>>2]=t;c[vc+8>>2]=qd;yk(j,47464,vc)}if(!n){c[wc>>2]=v;c[wc+4>>2]=h;c[wc+8>>2]=t;c[wc+12>>2]=h;c[wc+16>>2]=v;c[wc+20>>2]=t;yk(j,47522,wc)}do if(q|0){i=j+44|0;l=(c[i>>2]|0)+1|0;c[i>>2]=l;i=p+108|0;k=c[i>>2]|0;m=p+112|0;if((c[m>>2]|0)>(k|0)){c[i>>2]=k+1;qd=c[p+104>>2]|0;a[qd+(k*20|0)>>0]=110;b[qd+(k*20|0)+2>>1]=0;c[qd+(k*20|0)+4>>2]=0;c[qd+(k*20|0)+8>>2]=l;c[qd+(k*20|0)+12>>2]=0;c[qd+(k*20|0)+16>>2]=0;a[qd+(k*20|0)+1>>0]=0}else k=Bi(p,110,0,l,0)|0;if(!(a[(c[p>>2]|0)+81>>0]|0)){if((k|0)<0)k=(c[i>>2]|0)+-1|0;Ci(p,(c[p+104>>2]|0)+(k*20|0)|0,t,0)}k=c[i>>2]|0;if((c[m>>2]|0)>(k|0)){c[i>>2]=k+1;qd=c[p+104>>2]|0;a[qd+(k*20|0)>>0]=-91;b[qd+(k*20|0)+2>>1]=0;c[qd+(k*20|0)+4>>2]=l;c[qd+(k*20|0)+8>>2]=0;c[qd+(k*20|0)+12>>2]=0;c[qd+(k*20|0)+16>>2]=0;a[qd+(k*20|0)+1>>0]=0}else k=Bi(p,165,l,0,0)|0;if(a[(c[p>>2]|0)+81>>0]|0)break;if((k|0)<0)k=(c[i>>2]|0)+-1|0;l=c[p+104>>2]|0;m=l+(k*20|0)+1|0;if(!(a[m>>0]|0)){c[l+(k*20|0)+16>>2]=q;a[m>>0]=-12;qd=q+12|0;c[qd>>2]=(c[qd>>2]|0)+1;break}else{Ci(p,l+(k*20|0)|0,q,-12);break}}while(0);i=c[r>>2]|0;do if(!i){c[Jc>>2]=v;c[Jc+4>>2]=34585;c[Jc+8>>2]=v;c[Jc+12>>2]=o;yk(j,47804,Jc);if(n)break vb}else{k=(c[c[(c[(c[j>>2]|0)+16>>2]|0)+(u<<4)+12>>2]>>2]|0)+1|0;l=i+108|0;m=c[l>>2]|0;if((c[i+112>>2]|0)>(m|0)){c[l>>2]=m+1;qd=c[i+104>>2]|0;a[qd+(m*20|0)>>0]=95;b[qd+(m*20|0)+2>>1]=0;c[qd+(m*20|0)+4>>2]=u;c[qd+(m*20|0)+8>>2]=1;c[qd+(m*20|0)+12>>2]=k;c[qd+(m*20|0)+16>>2]=0;a[qd+(m*20|0)+1>>0]=0}else Bi(i,95,u,1,k)|0;zk(c[r>>2]|0,u,0);if(n){c[Tc>>2]=v;c[Tc+4>>2]=34585;c[Tc+8>>2]=v;c[Tc+12>>2]=o;yk(j,47804,Tc);break vb}else{zk(c[r>>2]|0,1,0);c[Uc>>2]=v;c[Uc+4>>2]=34585;c[Uc+8>>2]=v;c[Uc+12>>2]=o;yk(j,47804,Uc);break}}while(0);c[Vc>>2]=34585;c[Vc+4>>2]=v;yk(j,47948,Vc)}while(0);oi(x,w);if(x|0)rd=3013}else rd=3010}else rd=3010}else{c[hb>>2]=t;ad(j,46940,hb);rd=3010}while(0);if((rd|0)==3010){oi(x,w);rd=3013}if((rd|0)==3013){if(c[x+480>>2]|0){Vd(x,t);break}j=t;if((c[x+304>>2]|0)>>>0<=j>>>0?(c[x+308>>2]|0)>>>0>j>>>0:0){j=x+300|0;c[t>>2]=c[j>>2];c[j>>2]=t;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](t);break}else{j=Ua[c[29352>>2]&127](t)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](t);break}}else rd=3011}else rd=3011}else rd=3011;while(0);if((rd|0)==3011)oi(x,w);c[y>>2]=z;break}case 274:{h=td+-8|0;o=td+-4|0;c[o>>2]=(c[j+188>>2]|0)-(c[h>>2]|0)+(c[j+192>>2]|0);s=c[j>>2]|0;if((c[j+36>>2]|0)==0?(Nb=s+81|0,(a[Nb>>0]|0)==0):0){r=c[j+228>>2]|0;l=c[r+72>>2]|0;m=c[s+16>>2]|0;if(!l)t=-1e6;else{k=0;while(1)if((c[m+(k<<4)+12>>2]|0)==(l|0)){t=k;break}else k=k+1|0}p=c[m+(t<<4)>>2]|0;q=(c[r>>2]|0)+16|0;m=c[r+4>>2]|0;i=(b[r+42>>1]|0)+-1|0;l=c[m+(i<<4)+4>>2]|0;k=c[(Qd(s,q,p)|0)>>2]|0;do if(((a[s+165>>0]|0)==0?(a[j+200>>0]|0)==0:0)?(db=c[s+312>>2]|0,db|0):0){k=Za[db&127](c[s+316>>2]|0,26,p,k,0,c[j+240>>2]|0)|0;if((k|0)==1){ad(j,39216,eb);c[j+12>>2]=23;break a}if((k|2|0)==2)if(!k)break;else break a;else{ad(j,39231,fb);c[j+12>>2]=1;break a}}while(0);if(!l)l=0;else l=(a[c[l+12>>2]>>0]|0)==114?0:l;if(a[m+(i<<4)+15>>0]&1){ad(j,48091,jb);break a}if(c[r+8>>2]|0){ad(j,48123,kb);break a}if(!(0==0?(c[s+32>>2]&16384|0)==0:0)?(l|0)!=0&(c[r+16>>2]|0)!=0:0){ad(j,48150,lb);break a}k=(l|0)!=0;if(!(k|(a[m+(i<<4)+12>>0]|0)==0)){ad(j,48209,xb);break a}wb:do if(k){c[qd>>2]=0;do if(!(Uj(s,l,1,65,qd)|0)){m=c[qd>>2]|0;if(!m){ad(j,48262,Bb);break}if(!((b[m+8>>1]&9216)==0?!(c[m+24>>2]|0):0))Ag(m);k=c[m+32>>2]|0;do if(!k)rd=3059;else{if(c[k+480>>2]|0){Vd(k,m);break}l=m;if((c[k+304>>2]|0)>>>0>l>>>0){rd=3059;break}if((c[k+308>>2]|0)>>>0<=l>>>0){rd=3059;break}qd=k+300|0;c[m>>2]=c[qd>>2];c[qd>>2]=m}while(0);do if((rd|0)==3059)if(!(c[7324]|0)){_a[c[29344>>2]&127](m);break}else{qd=Ua[c[29352>>2]&127](m)|0;c[14978]=(c[14978]|0)-qd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](m);break}while(0);break wb}while(0);break a}while(0);h=c[h>>2]|0;n=c[o>>2]|0;xb:do if(h|0){m=Qv(n|0,0,1,0)|0;i=L()|0;yb:do if(c[s+272>>2]|0)if(!(a[Nb>>0]|0))rd=3075;else break xb;else{do if(0<0|(0==0?n>>>0<(e[s+276>>1]|0)>>>0:0)){k=s+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];qd=s+284|0;c[qd>>2]=(c[qd>>2]|0)+1;break yb}k=s+296|0;l=c[k>>2]|0;if(!l){k=s+292|0;break}else{c[k>>2]=c[l>>2];qd=s+284|0;c[qd>>2]=(c[qd>>2]|0)+1;break yb}}else k=s+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=3075}while(0);if((rd|0)==3075)l=Yd(s,m,i)|0;if(l|0){cw(l|0,h|0,n|0)|0;a[l+n>>0]=0;k=(c[o>>2]|0)+-1|0;m=s+24|0;i=c[m>>2]|0;if((k|0)>0){k=l+k|0;do{qd=a[k>>0]|0;if(qd<<24>>24!=59?(a[880+(qd&255)>>0]&1)==0:0)break;a[k>>0]=0;k=k+-1|0}while(k>>>0>l>>>0);k=c[m>>2]|0}else k=i;c[m>>2]=k|2;qd=c[r+52>>2]|0;c[Zb>>2]=p;c[Zb+4>>2]=34585;c[Zb+8>>2]=qd;c[Zb+12>>2]=l;c[Zb+16>>2]=qd+1;c[Zb+20>>2]=q;yk(j,48308,Zb);zb:do if(!(c[s+480>>2]|0)){k=l;do if((c[s+304>>2]|0)>>>0<=k>>>0){if((c[s+308>>2]|0)>>>0<=k>>>0)break;qd=s+300|0;c[l>>2]=c[qd>>2];c[qd>>2]=l;break zb}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{qd=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-qd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}else Vd(s,l);while(0);c[m>>2]=i}}while(0);p=j+8|0;k=c[p>>2]|0;Ab:do if(!k){m=c[j>>2]|0;if((c[j+116>>2]|0)==0?(b[m+76>>1]&8)==0:0)a[j+23>>0]=1;Bb:do if(c[m+272>>2]|0)if(!(a[m+81>>0]|0))rd=3106;else break Ab;else{do if((e[m+276>>1]|0)>=224){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];qd=m+284|0;c[qd>>2]=(c[qd>>2]|0)+1;break Bb}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];qd=m+284|0;c[qd>>2]=(c[qd>>2]|0)+1;break Bb}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=3106}while(0);if((rd|0)==3106)k=Yd(m,224,0)|0;if(k|0){I=k+104|0;J=I+120|0;do{c[I>>2]=0;I=I+4|0}while((I|0)<(J|0));c[k>>2]=m;l=m+4|0;m=c[l>>2]|0;if(m|0)c[m+4>>2]=k;c[k+8>>2]=m;c[k+4>>2]=0;c[l>>2]=k;c[k+20>>2]=381479589;c[k+12>>2]=j;c[p>>2]=k;Bi(k,61,0,1,0)|0;rd=3111}}else rd=3111;while(0);do if((rd|0)==3111){o=j+19|0;l=a[o>>0]|0;if(!(l<<24>>24)){rd=j+44|0;n=(c[rd>>2]|0)+1|0;c[rd>>2]=n}else{n=l+-1<<24>>24;a[o>>0]=n;n=c[j+148+((n&255)<<2)>>2]|0}i=k+108|0;l=c[i>>2]|0;h=k+112|0;if((c[h>>2]|0)>(l|0)){c[i>>2]=l+1;rd=c[k+104>>2]|0;a[rd+(l*20|0)>>0]=94;b[rd+(l*20|0)+2>>1]=0;c[rd+(l*20|0)+4>>2]=t;c[rd+(l*20|0)+8>>2]=n;c[rd+(l*20|0)+12>>2]=2;c[rd+(l*20|0)+16>>2]=0;a[rd+(l*20|0)+1>>0]=0}else Bi(k,94,t,n,2)|0;l=1<<t;rd=k+152|0;c[rd>>2]=c[rd>>2]|l;if((t|0)!=1?a[(c[(c[(c[k>>2]|0)+16>>2]|0)+(t<<4)+4>>2]|0)+9>>0]|0:0){rd=k+156|0;c[rd>>2]=c[rd>>2]|l}l=c[i>>2]|0;if((c[h>>2]|0)>(l|0)){c[i>>2]=l+1;rd=c[k+104>>2]|0;a[rd+(l*20|0)>>0]=83;b[rd+(l*20|0)+2>>1]=0;c[rd+(l*20|0)+4>>2]=n;c[rd+(l*20|0)+8>>2]=-2;c[rd+(l*20|0)+12>>2]=0;c[rd+(l*20|0)+16>>2]=0;a[rd+(l*20|0)+1>>0]=0}else Bi(k,83,n,-2,0)|0;l=c[i>>2]|0;m=l+2|0;if((c[h>>2]|0)>(l|0)){c[i>>2]=l+1;rd=c[k+104>>2]|0;a[rd+(l*20|0)>>0]=47;b[rd+(l*20|0)+2>>1]=0;c[rd+(l*20|0)+4>>2]=n;c[rd+(l*20|0)+8>>2]=m;c[rd+(l*20|0)+12>>2]=0;c[rd+(l*20|0)+16>>2]=0;a[rd+(l*20|0)+1>>0]=0}else Bi(k,47,n,m,0)|0;l=c[i>>2]|0;if((c[h>>2]|0)>(l|0)){c[i>>2]=l+1;rd=c[k+104>>2]|0;a[rd+(l*20|0)>>0]=95;b[rd+(l*20|0)+2>>1]=0;c[rd+(l*20|0)+4>>2]=t;c[rd+(l*20|0)+8>>2]=2;c[rd+(l*20|0)+12>>2]=3;c[rd+(l*20|0)+16>>2]=0;a[rd+(l*20|0)+1>>0]=0}else Bi(k,95,t,2,3)|0;if(!n)break;k=a[o>>0]|0;if((k&255)>=8)break;a[o>>0]=k+1<<24>>24;c[j+148+((k&255)<<2)>>2]=n}while(0);i=c[p>>2]|0;if(i|0){k=(c[c[(c[(c[j>>2]|0)+16>>2]|0)+(t<<4)+12>>2]>>2]|0)+1|0;l=i+108|0;m=c[l>>2]|0;if((c[i+112>>2]|0)>(m|0)){c[l>>2]=m+1;j=c[i+104>>2]|0;a[j+(m*20|0)>>0]=95;b[j+(m*20|0)+2>>1]=0;c[j+(m*20|0)+4>>2]=t;c[j+(m*20|0)+8>>2]=1;c[j+(m*20|0)+12>>2]=k;c[j+(m*20|0)+16>>2]=0;a[j+(m*20|0)+1>>0]=0}else Bi(i,95,t,1,k)|0;zk(c[p>>2]|0,t,0);if((t|0)!=1)zk(c[p>>2]|0,1,0)}}break}case 275:{D=j+24|0;a[D>>0]=(a[D>>0]|0)+1<<24>>24;D=c[j>>2]|0;E=D+272|0;c[E>>2]=(c[E>>2]|0)+1;F=c[td+4>>2]|0;H=D+81|0;Cb:do if(!(a[H>>0]|0)){l=c[F+8>>2]|0;if(!l)k=F+12|0;else{m=c[D+16>>2]|0;k=0;while(1)if((c[m+(k<<4)+12>>2]|0)==(l|0))break;else k=k+1|0;k=m+(k<<4)|0}C=$c(j,0,c[F+16>>2]|0,c[k>>2]|0)|0;if(C|0){if(c[C+56>>2]|0){ad(j,48417,Ia);break}if(c[C+12>>2]|0){ad(j,48451,Ja);break}if(!(mn(j,C)|0)){l=c[C+72>>2]|0;if(!l)A=-1e6;else{m=c[D+16>>2]|0;k=0;while(1)if((c[m+(k<<4)+12>>2]|0)==(l|0)){A=k;break}else k=k+1|0}B=(D|0)==0;Db:do if(B){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](80)|0;rd=3176;break}k=Ua[c[29356>>2]&127](80)|0;if((c[14985]|0)>>>0<80)c[14985]=80;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){qd=c[14978]|0;pd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k)break Cb;l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else{if(c[E>>2]|0){if(a[H>>0]|0)break Cb}else{do if((e[D+276>>1]|0)>=80){l=D+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=D+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=3176;break Db}l=D+296|0;k=c[l>>2]|0;if(!k){k=D+292|0;break}else{c[l>>2]=c[k>>2];rd=D+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=3176;break Db}}else k=D+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(D,80,0)|0;rd=3176}while(0);if((rd|0)==3176)if(!k)break;I=k;J=I+80|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));c[j+228>>2]=k;y=k+32|0;c[y>>2]=1;h=b[C+42>>1]|0;z=k+42|0;b[z>>1]=h;h=((((h<<16>>16)+-1|0)/8|0)<<7)+128|0;Eb:do if(B){j=Qv(h|0,0,-1,-1)|0;qd=L()|0;if(!(qd>>>0>0|(qd|0)==0&j>>>0>2147483390)){if(!(c[7324]|0)){l=Ua[c[29340>>2]&127](h)|0;rd=3201;break}l=Ua[c[29356>>2]&127](h)|0;if((c[14985]|0)>>>0<h>>>0)c[14985]=h;i=59064;m=c[i>>2]|0;i=c[i+4>>2]|0;if((i|0)>0|(i|0)==0&m>>>0>0){j=c[14978]|0;qd=Rv(m|0,i|0,l|0,((l|0)<0)<<31>>31|0)|0;pd=L()|0;c[14768]=((pd|0)<0|(pd|0)==0&qd>>>0<=j>>>0)&1}l=Ua[c[29340>>2]&127](l)|0;if(l){m=Ua[c[29352>>2]&127](l)|0;m=(c[14978]|0)+m|0;c[14978]=m;if(m>>>0>(c[14982]|0)>>>0)c[14982]=m;m=(c[14981]|0)+1|0;c[14981]=m;if(m>>>0>(c[14987]|0)>>>0){c[14987]=m;rd=3202}else rd=3202}else l=0}else l=0}else{if(c[E>>2]|0){if(a[H>>0]|0){l=0;break}}else{do if(!(0<0|(0==0?(e[D+276>>1]|0)>>>0<h>>>0:0))){m=D+300|0;l=c[m>>2]|0;if(l|0){c[m>>2]=c[l>>2];rd=D+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=3201;break Eb}m=D+296|0;l=c[m>>2]|0;if(!l){l=D+292|0;break}else{c[m>>2]=c[l>>2];rd=D+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=3201;break Eb}}else l=D+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1}l=Yd(D,h,0)|0;rd=3201}while(0);if((rd|0)==3201)if(!l)l=0;else rd=3202;if((rd|0)==3202)ew(l|0,0,h|0)|0;x=k+4|0;c[x>>2]=l;c[kc>>2]=c[C>>2];j=bd(D,48481,kc)|0;c[k>>2]=j;l=c[x>>2]|0;if(!((j|0)==0|(l|0)==0)){cw(l|0,c[C+4>>2]|0,b[z>>1]<<4|0)|0;if((b[z>>1]|0)>0){p=D+276|0;q=D+288|0;r=D+300|0;s=D+296|0;t=D+284|0;u=D+292|0;o=0;do{v=c[x>>2]|0;w=v+(o<<4)|0;h=c[w>>2]|0;Fb:do if(!h)l=0;else{n=(Cu(h)|0)+1|0;Gb:do if(B){j=Qv(n|0,0,-1,-1)|0;qd=L()|0;if(qd>>>0>0|(qd|0)==0&j>>>0>2147483390){l=0;break Fb}if(!(c[7324]|0)){l=Ua[c[29340>>2]&127](n)|0;rd=3229;break}l=Ua[c[29356>>2]&127](n)|0;if((c[14985]|0)>>>0<n>>>0)c[14985]=n;i=59064;m=c[i>>2]|0;i=c[i+4>>2]|0;if((i|0)>0|(i|0)==0&m>>>0>0){j=c[14978]|0;qd=Rv(m|0,i|0,l|0,((l|0)<0)<<31>>31|0)|0;pd=L()|0;c[14768]=((pd|0)<0|(pd|0)==0&qd>>>0<=j>>>0)&1}l=Ua[c[29340>>2]&127](l)|0;if(!l){l=0;break Fb}m=Ua[c[29352>>2]&127](l)|0;m=(c[14978]|0)+m|0;c[14978]=m;if(m>>>0>(c[14982]|0)>>>0)c[14982]=m;m=(c[14981]|0)+1|0;c[14981]=m;if(m>>>0<=(c[14987]|0)>>>0)break;c[14987]=m}else{if(c[E>>2]|0){if(a[H>>0]|0){l=0;break Fb}}else{do if(0<0|(0==0?(e[p>>1]|0)>>>0<n>>>0:0))l=q;else{l=c[r>>2]|0;if(l|0){c[r>>2]=c[l>>2];c[t>>2]=(c[t>>2]|0)+1;rd=3229;break Gb}l=c[s>>2]|0;if(!l){l=u;break}c[s>>2]=c[l>>2];c[t>>2]=(c[t>>2]|0)+1;rd=3229;break Gb}while(0);c[l>>2]=(c[l>>2]|0)+1}l=Yd(D,n,0)|0;rd=3229}while(0);if((rd|0)==3229){rd=0;if(!l){l=0;break}}cw(l|0,h|0,n|0)|0}while(0);c[w>>2]=l;c[v+(o<<4)+8>>2]=0;c[v+(o<<4)+4>>2]=0;o=o+1|0}while((o|0)<(b[z>>1]|0))}c[k+72>>2]=c[(c[D+16>>2]|0)+(A<<4)+12>>2];c[k+52>>2]=c[C+52>>2];c[y>>2]=1}}}}while(0);oi(D,F);break}case 276:{u=c[td+-56>>2]|0;i=td+-20|0;p=td+4|0;v=c[j>>2]|0;l=c[u+8>>2]|0;if(!l)k=u+12|0;else{m=c[v+16>>2]|0;k=0;while(1)if((c[m+(k<<4)+12>>2]|0)==(l|0))break;else k=k+1|0;k=m+(k<<4)|0}r=$c(j,0,c[u+16>>2]|0,c[k>>2]|0)|0;Hb:do if(r|0?(mn(j,r)|0)==0:0){k=(c[r+56>>2]|0)==0?((c[r+12>>2]|0)==0?0:39579):48814;if(k|0){rd=c[r>>2]|0;c[Ma>>2]=k;c[Ma+4>>2]=rd;ad(j,48828,Ma);break}l=c[r+72>>2]|0;m=c[v+16>>2]|0;if(!l)t=-1e6;else{k=0;while(1)if((c[m+(k<<4)+12>>2]|0)==(l|0)){t=k;break}else k=k+1|0}s=c[m+(t<<4)>>2]|0;k=c[r>>2]|0;l=c[j>>2]|0;do if(((a[l+165>>0]|0)==0?(a[j+200>>0]|0)==0:0)?(zb=c[l+312>>2]|0,zb|0):0){k=Za[zb&127](c[l+316>>2]|0,26,s,k,0,c[j+240>>2]|0)|0;if((k|0)==1){ad(j,39216,Cb);c[j+12>>2]=23;break Hb}if((k|2|0)==2)if(!k)break;else break Hb;else{ad(j,39231,Db);c[j+12>>2]=1;break Hb}}while(0);q=oj(v,i)|0;if(q|0){qd=b[r+42>>1]|0;o=qd<<16>>16;Ib:do if(qd<<16>>16>0){h=c[r+4>>2]|0;n=d[208+(d[q>>0]|0)>>0]|0;k=0;do{m=c[h+(k<<4)>>2]|0;qd=a[m>>0]|0;l=(d[208+(qd&255)>>0]|0)-n|0;if(!(qd<<24>>24==0|(l|0)!=0)){i=q;do{m=m+1|0;i=i+1|0;qd=a[m>>0]|0;l=(d[208+(qd&255)>>0]|0)-(d[208+(d[i>>0]|0)>>0]|0)|0}while(!(qd<<24>>24==0|(l|0)!=0))}if(!l)break Ib;k=k+1|0}while((k|0)<(o|0))}else k=0;while(0);Jb:do if((k|0)!=(o|0)){l=c[j+116>>2]|0;a[((l|0)==0?j:l)+21>>0]=1;l=oj(v,p)|0;if(!l)l=0;else{h=a[880+(d[c[p>>2]>>0]|0)>>0]&-128&255;n=c[r>>2]|0;o=(t|0)==1;p=o&1;c[Wb>>2]=s;c[Wb+4>>2]=34585;c[Wb+8>>2]=s;c[Wb+12>>2]=n;c[Wb+16>>2]=k;c[Wb+20>>2]=l;c[Wb+24>>2]=h;c[Wb+28>>2]=p;c[Wb+32>>2]=n;yk(j,48500,Wb);n=c[r>>2]|0;c[Xb>>2]=34585;c[Xb+4>>2]=s;c[Xb+8>>2]=n;c[Xb+12>>2]=k;c[Xb+16>>2]=l;c[Xb+20>>2]=h;yk(j,48694,Xb);h=j+8|0;n=c[h>>2]|0;do if(!n){c[_b>>2]=s;c[_b+4>>2]=34585;c[_b+8>>2]=s;c[_b+12>>2]=p;yk(j,47804,_b);if(o)break Jb}else{k=(c[c[(c[(c[j>>2]|0)+16>>2]|0)+(t<<4)+12>>2]>>2]|0)+1|0;m=n+108|0;i=c[m>>2]|0;if((c[n+112>>2]|0)>(i|0)){c[m>>2]=i+1;qd=c[n+104>>2]|0;a[qd+(i*20|0)>>0]=95;b[qd+(i*20|0)+2>>1]=0;c[qd+(i*20|0)+4>>2]=t;c[qd+(i*20|0)+8>>2]=1;c[qd+(i*20|0)+12>>2]=k;c[qd+(i*20|0)+16>>2]=0;a[qd+(i*20|0)+1>>0]=0}else Bi(n,95,t,1,k)|0;zk(c[h>>2]|0,t,0);if(o){c[$b>>2]=s;c[$b+4>>2]=34585;c[$b+8>>2]=s;c[$b+12>>2]=p;yk(j,47804,$b);break Jb}else{zk(c[h>>2]|0,1,0);c[ac>>2]=s;c[ac+4>>2]=34585;c[ac+8>>2]=s;c[ac+12>>2]=p;yk(j,47804,ac);break}}while(0);c[bc>>2]=34585;c[bc+4>>2]=s;yk(j,47948,bc)}}else{c[Ub>>2]=q;ad(j,31333,Ub);l=0}while(0);oi(v,u);k=(v|0)==0;do if(!k){if(c[v+480>>2]|0){Vd(v,q);break}j=q;if((c[v+304>>2]|0)>>>0<=j>>>0?(c[v+308>>2]|0)>>>0>j>>>0:0){j=v+300|0;c[q>>2]=c[j>>2];c[j>>2]=q}else rd=3281}else rd=3281;while(0);do if((rd|0)==3281)if(!(c[7324]|0)){_a[c[29344>>2]&127](q);break}else{j=Ua[c[29352>>2]&127](q)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](q);break}while(0);if(!l)break a;if(!k){if(c[v+480>>2]|0){Vd(v,l);break a}j=l;if((c[v+304>>2]|0)>>>0<=j>>>0?(c[v+308>>2]|0)>>>0>j>>>0:0){j=v+300|0;c[l>>2]=c[j>>2];c[j>>2]=l;break a}}if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break a}else{j=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break a}}}while(0);oi(v,u);break}case 277:{yj(j,0);break}case 278:{yj(j,td+4|0);break}case 279:{o=td+4|0;$i(j,td+-32|0,td+-20|0,0,0,1,c[td+-44>>2]|0);r=c[j+228>>2]|0;if(r|0){q=c[j>>2]|0;h=oj(q,o)|0;p=r+56|0;rd=c[p>>2]|0;m=(rd<<2)+8|0;i=c[j>>2]|0;if((rd+3|0)>=(c[i+116>>2]|0)){c[na>>2]=c[r>>2];ad(j,38221,na)}n=r+60|0;k=c[n>>2]|0;Kb:do if(!k){if(c[i+272>>2]|0){if(a[i+81>>0]|0){rd=3317;break}}else{do if(!(0<0|(0==0?(e[i+276>>1]|0)>>>0<m>>>0:0))){l=i+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=i+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=3316;break Kb}l=i+296|0;k=c[l>>2]|0;if(!k){k=i+292|0;break}else{c[l>>2]=c[k>>2];rd=i+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=3316;break Kb}}else k=i+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(i,m,0)|0;rd=3316}else{rd=k;if((c[i+304>>2]|0)>>>0<=rd>>>0?(c[i+308>>2]|0)>>>0>rd>>>0:0){if(!(0<0|(0==0?(e[i+276>>1]|0)>>>0<m>>>0:0))){rd=3326;break}k=Xd(i,k,m,0)|0;rd=3316;break}k=Xd(i,k,m,0)|0;rd=3316}while(0);if((rd|0)==3316)if(!k)rd=3317;else rd=3326;do if((rd|0)==3317){if(h|0){if(c[i+480>>2]|0){Vd(i,h);break}qd=h;if((c[i+304>>2]|0)>>>0<=qd>>>0?(c[i+308>>2]|0)>>>0>qd>>>0:0){qd=i+300|0;c[h>>2]=c[qd>>2];c[qd>>2]=h;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](h);break}else{qd=Ua[c[29352>>2]&127](h)|0;c[14978]=(c[14978]|0)-qd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](h);break}}}else if((rd|0)==3326){pd=c[p>>2]|0;qd=pd+1|0;c[p>>2]=qd;c[k+(pd<<2)>>2]=h;c[k+(qd<<2)>>2]=0;c[n>>2]=k}while(0);qd=c[p>>2]|0;m=(qd<<2)+8|0;i=c[j>>2]|0;if((qd+3|0)>=(c[i+116>>2]|0)){c[Eb>>2]=c[r>>2];ad(j,38221,Eb)}k=c[n>>2]|0;Lb:do if(!k){if(c[i+272>>2]|0){if(a[i+81>>0]|0)break}else{do if(!(0<0|(0==0?(e[i+276>>1]|0)>>>0<m>>>0:0))){k=i+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];Jb=i+284|0;c[Jb>>2]=(c[Jb>>2]|0)+1;Jb=l;rd=3346;break Lb}k=i+296|0;l=c[k>>2]|0;if(!l){k=i+292|0;break}else{c[k>>2]=c[l>>2];Jb=i+284|0;c[Jb>>2]=(c[Jb>>2]|0)+1;Jb=l;rd=3346;break Lb}}else k=i+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}Jb=Yd(i,m,0)|0;rd=3346}else{rd=k;if((c[i+304>>2]|0)>>>0<=rd>>>0?(c[i+308>>2]|0)>>>0>rd>>>0:0){if(!(0<0|(0==0?(e[i+276>>1]|0)>>>0<m>>>0:0))){rd=3347;break}Jb=Xd(i,k,m,0)|0;rd=3346;break}Jb=Xd(i,k,m,0)|0;rd=3346}while(0);if((rd|0)==3346?Jb|0:0){k=Jb;rd=3347}if((rd|0)==3347){pd=c[p>>2]|0;qd=pd+1|0;c[p>>2]=qd;c[k+(pd<<2)>>2]=0;c[k+(qd<<2)>>2]=0;c[n>>2]=k}i=c[r>>2]|0;Mb:do if(!i)h=0;else{h=(Cu(i)|0)+1|0;Nb:do if(!q){qd=Qv(h|0,0,-1,-1)|0;pd=L()|0;if(pd>>>0>0|(pd|0)==0&qd>>>0>2147483390){h=0;break Mb}if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](h)|0;rd=3373;break}k=Ua[c[29356>>2]&127](h)|0;if((c[14985]|0)>>>0<h>>>0)c[14985]=h;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){qd=c[14978]|0;pd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;od=L()|0;c[14768]=((od|0)<0|(od|0)==0&pd>>>0<=qd>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k){h=0;break Mb}l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0>(c[14987]|0)>>>0)c[14987]=l}else{if(c[q+272>>2]|0){if(a[q+81>>0]|0){h=0;break Mb}}else{do if(!(0<0|(0==0?(e[q+276>>1]|0)>>>0<h>>>0:0))){l=q+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=q+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=3373;break Nb}l=q+296|0;k=c[l>>2]|0;if(!k){k=q+292|0;break}else{c[l>>2]=c[k>>2];rd=q+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=3373;break Nb}}else k=q+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(q,h,0)|0;rd=3373}while(0);if((rd|0)==3373)if(!k){h=0;break}cw(k|0,i|0,h|0)|0;h=k}while(0);rd=c[p>>2]|0;m=(rd<<2)+8|0;i=c[j>>2]|0;if((rd+3|0)>=(c[i+116>>2]|0)){c[ic>>2]=c[r>>2];ad(j,38221,ic)}k=c[n>>2]|0;Ob:do if(!k){if(c[i+272>>2]|0){if(a[i+81>>0]|0){rd=3395;break}}else{do if(!(0<0|(0==0?(e[i+276>>1]|0)>>>0<m>>>0:0))){l=i+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=i+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=3394;break Ob}l=i+296|0;k=c[l>>2]|0;if(!k){k=i+292|0;break}else{c[l>>2]=c[k>>2];rd=i+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=3394;break Ob}}else k=i+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(i,m,0)|0;rd=3394}else{rd=k;if((c[i+304>>2]|0)>>>0<=rd>>>0?(c[i+308>>2]|0)>>>0>rd>>>0:0){if(!(0<0|(0==0?(e[i+276>>1]|0)>>>0<m>>>0:0))){rd=3404;break}k=Xd(i,k,m,0)|0;rd=3394;break}k=Xd(i,k,m,0)|0;rd=3394}while(0);if((rd|0)==3394)if(!k)rd=3395;else rd=3404;do if((rd|0)==3395){if(h|0){if(c[i+480>>2]|0){Vd(i,h);break}rd=h;if((c[i+304>>2]|0)>>>0<=rd>>>0?(c[i+308>>2]|0)>>>0>rd>>>0:0){rd=i+300|0;c[h>>2]=c[rd>>2];c[rd>>2]=h;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](h);break}else{rd=Ua[c[29352>>2]&127](h)|0;c[14978]=(c[14978]|0)-rd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](h);break}}}else if((rd|0)==3404){qd=c[p>>2]|0;rd=qd+1|0;c[p>>2]=rd;c[k+(qd<<2)>>2]=h;c[k+(rd<<2)>>2]=0;c[n>>2]=k}while(0);c[j+184>>2]=(c[o>>2]|0)+(c[td+8>>2]|0)-(c[j+180>>2]|0);h=c[n>>2]|0;if(h|0){m=c[r+72>>2]|0;if(!m)k=-1e6;else{l=c[q+16>>2]|0;k=0;while(1)if((c[l+(k<<4)+12>>2]|0)==(m|0))break;else k=k+1|0}i=c[r>>2]|0;l=c[h>>2]|0;m=c[j>>2]|0;k=c[(c[m+16>>2]|0)+(k<<4)>>2]|0;if(((a[m+165>>0]|0)==0?(a[j+200>>0]|0)==0:0)?(zc=c[m+312>>2]|0,zc|0):0){k=Za[zc&127](c[m+316>>2]|0,29,i,l,k,c[j+240>>2]|0)|0;if((k|0)==1){ad(j,39216,Bc);c[j+12>>2]=23;break a}if((k|2|0)!=2){ad(j,39231,Cc);c[j+12>>2]=1}}}}break}case 280:{p=j+244|0;n=c[p>>2]|0;do if(n|0?(ob=c[j+228>>2]|0,ob|0):0){o=c[j+248>>2]|0;m=c[j>>2]|0;i=Qv(o|0,((o|0)<0)<<31>>31|0,1,0)|0;h=L()|0;Pb:do if(c[m+272>>2]|0)if(!(a[m+81>>0]|0))rd=3428;else n=0;else{do if(!(h>>>0>0|((h|0)==0?i>>>0>(e[m+276>>1]|0)>>>0:0))){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=3429;break Pb}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=3429;break Pb}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=3428}while(0);if((rd|0)==3428){k=Yd(m,i,h)|0;rd=3429}if((rd|0)==3429)if(!k)n=0;else{cw(k|0,n|0,o|0)|0;a[k+o>>0]=0;n=k}o=ob+56|0;qd=c[o>>2]|0;i=(qd<<2)+8|0;h=c[j>>2]|0;if((qd+3|0)>=(c[h+116>>2]|0)){c[mb>>2]=c[ob>>2];ad(j,38221,mb)}m=ob+60|0;k=c[m>>2]|0;Qb:do if(!k){if(c[h+272>>2]|0){if(a[h+81>>0]|0)break}else{do if(!(0<0|(0==0?(e[h+276>>1]|0)>>>0<i>>>0:0))){k=h+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];Fb=h+284|0;c[Fb>>2]=(c[Fb>>2]|0)+1;Fb=l;rd=3450;break Qb}k=h+296|0;l=c[k>>2]|0;if(!l){k=h+292|0;break}else{c[k>>2]=c[l>>2];Fb=h+284|0;c[Fb>>2]=(c[Fb>>2]|0)+1;Fb=l;rd=3450;break Qb}}else k=h+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}Fb=Yd(h,i,0)|0;rd=3450}else{rd=k;if((c[h+304>>2]|0)>>>0<=rd>>>0?(c[h+308>>2]|0)>>>0>rd>>>0:0){if(!(0<0|(0==0?(e[h+276>>1]|0)>>>0<i>>>0:0))){rd=3460;break}Fb=Xd(h,k,i,0)|0;rd=3450;break}Fb=Xd(h,k,i,0)|0;rd=3450}while(0);if((rd|0)==3450?Fb|0:0){k=Fb;rd=3460}if((rd|0)==3460){qd=c[o>>2]|0;rd=qd+1|0;c[o>>2]=rd;c[k+(qd<<2)>>2]=n;c[k+(rd<<2)>>2]=0;c[m>>2]=k;break}if(n|0){if(c[h+480>>2]|0){Vd(h,n);break}rd=n;if((c[h+304>>2]|0)>>>0<=rd>>>0?(c[h+308>>2]|0)>>>0>rd>>>0:0){rd=h+300|0;c[n>>2]=c[rd>>2];c[rd>>2]=n;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](n);break}else{rd=Ua[c[29352>>2]&127](n)|0;c[14978]=(c[14978]|0)-rd;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](n);break}}}while(0);c[p>>2]=0;c[j+248>>2]=0;break}case 283:case 282:case 281:{k=j+244|0;l=c[k>>2]|0;m=c[td+4>>2]|0;if(!l){c[k>>2]=m;k=c[td+8>>2]|0}else k=m+(c[td+8>>2]|0)-l|0;c[j+248>>2]=k;break}case 285:case 284:{k=c[td+4>>2]|0;if(k|0){rd=j+264|0;c[k+4>>2]=c[rd>>2];c[rd>>2]=k;c[j+268>>2]=k}break}case 286:{rd=td+-56|0;c[rd>>2]=zj(j,0,rd,c[td+-44>>2]|0,c[td+-8>>2]|0)|0;break}case 287:{rd=td+-80|0;c[rd>>2]=zj(j,c[rd>>2]|0,td+-56|0,c[td+-44>>2]|0,c[td+-8>>2]|0)|0;break}case 314:{m=c[j>>2]|0;Rb:do if(!m){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](92)|0;rd=3591;break}k=Ua[c[29356>>2]&127](92)|0;if((c[14985]|0)>>>0<92)c[14985]=92;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){rd=c[14978]|0;qd=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;pd=L()|0;c[14768]=((pd|0)<0|(pd|0)==0&qd>>>0<=rd>>>0)&1}l=Ua[c[29340>>2]&127](k)|0;if(l){k=Ua[c[29352>>2]&127](l)|0;k=(c[14978]|0)+k|0;c[14978]=k;if(k>>>0>(c[14982]|0)>>>0)c[14982]=k;k=(c[14981]|0)+1|0;c[14981]=k;if(k>>>0>(c[14987]|0)>>>0){c[14987]=k;rd=3592}else rd=3592}else rd=3607}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0){rd=3607;break}}else{do if((e[m+276>>1]|0)>=92){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=3591;break Rb}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];rd=m+284|0;c[rd>>2]=(c[rd>>2]|0)+1;rd=3591;break Rb}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,92,0)|0;rd=3591}while(0);if((rd|0)==3591)if(!k)rd=3607;else{l=k;rd=3592}if((rd|0)==3592){I=l;J=I+92|0;do{a[I>>0]=0;I=I+1|0}while((I|0)<(J|0));i=c[j>>2]|0;o=c[td+4>>2]|0;p=c[td+8>>2]|0;Sb:do if(o){h=Qv(p|0,0,1,0)|0;n=L()|0;Tb:do if(c[i+272>>2]|0)if(!(a[i+81>>0]|0))rd=3603;else{k=0;break Sb}else{do if(0<0|(0==0?p>>>0<(e[i+276>>1]|0)>>>0:0)){m=i+300|0;k=c[m>>2]|0;if(k|0){c[m>>2]=c[k>>2];j=i+284|0;c[j>>2]=(c[j>>2]|0)+1;break Tb}m=i+296|0;k=c[m>>2]|0;if(!k){k=i+292|0;break}else{c[m>>2]=c[k>>2];j=i+284|0;c[j>>2]=(c[j>>2]|0)+1;break Tb}}else k=i+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=3603}while(0);if((rd|0)==3603)k=Yd(i,h,n)|0;if(k){cw(k|0,o|0,p|0)|0;a[k+p>>0]=0}else k=0}else k=0;while(0);c[l>>2]=k;c[l+36>>2]=c[td+-20>>2];k=l}else if((rd|0)==3607){k=c[td+-20>>2]|0;if(!k)k=0;else{li(c[j>>2]|0,k);k=0}}c[td+-20>>2]=k;break}case 289:{qd=td+4|0;rd=td+-20|0;Aj(j,c[qd>>2]|0,c[rd>>2]|0);c[(c[qd>>2]|0)+32>>2]=c[rd>>2];c[rd>>2]=c[qd>>2];break}case 290:{p=td+-8|0;if(!(c[p>>2]|0))k=0;else{m=c[j>>2]|0;n=c[td+-44>>2]|0;o=c[td+-40>>2]|0;Ub:do if(n){i=Qv(o|0,0,1,0)|0;h=L()|0;Vb:do if(c[m+272>>2]|0)if(!(a[m+81>>0]|0))rd=3483;else{k=0;break Ub}else{do if(0<0|(0==0?o>>>0<(e[m+276>>1]|0)>>>0:0)){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];j=m+284|0;c[j>>2]=(c[j>>2]|0)+1;break Vb}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];j=m+284|0;c[j>>2]=(c[j>>2]|0)+1;break Vb}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=3483}while(0);if((rd|0)==3483)k=Yd(m,i,h)|0;if(k){cw(k|0,n|0,o|0)|0;a[k+o>>0]=0}else k=0}else k=0;while(0);c[c[p>>2]>>2]=k;k=c[p>>2]|0}c[td+-44>>2]=k;break}case 291:{k=c[td+4>>2]|0;l=c[td+-20>>2]|0;m=c[td+-8>>2]|0;if(!k){if(l|0)pi(c[j>>2]|0,l);if(m|0)pi(c[j>>2]|0,m)}else{c[k+8>>2]=l;c[k+12>>2]=m}c[td+-44>>2]=k;break}case 292:{p=c[td+4>>2]|0;k=c[td+-20>>2]|0;l=c[td+-8>>2]|0;q=td+-56|0;if(!p){if(k|0)pi(c[j>>2]|0,k);if(l|0)pi(c[j>>2]|0,l)}else{c[p+8>>2]=k;c[p+12>>2]=l;m=c[j>>2]|0;n=c[q>>2]|0;o=c[td+-52>>2]|0;Wb:do if(n){i=Qv(o|0,0,1,0)|0;h=L()|0;Xb:do if(c[m+272>>2]|0)if(!(a[m+81>>0]|0))rd=3507;else{k=0;break Wb}else{do if(0<0|(0==0?o>>>0<(e[m+276>>1]|0)>>>0:0)){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];j=m+284|0;c[j>>2]=(c[j>>2]|0)+1;break Xb}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];j=m+284|0;c[j>>2]=(c[j>>2]|0)+1;break Xb}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=3507}while(0);if((rd|0)==3507)k=Yd(m,i,h)|0;if(k){cw(k|0,n|0,o|0)|0;a[k+o>>0]=0}else k=0}else k=0;while(0);c[p+4>>2]=k}c[q>>2]=p;break}case 293:{k=c[td+4>>2]|0;l=c[td+-8>>2]|0;if(!k){if(l|0)pi(c[j>>2]|0,l)}else{c[k+8>>2]=0;c[k+12>>2]=l}c[td+-32>>2]=k;break}case 294:{p=c[td+4>>2]|0;k=c[td+-8>>2]|0;q=td+-44|0;if(!p){if(k|0)pi(c[j>>2]|0,k)}else{c[p+8>>2]=0;c[p+12>>2]=k;m=c[j>>2]|0;n=c[q>>2]|0;o=c[td+-40>>2]|0;Yb:do if(n){i=Qv(o|0,0,1,0)|0;h=L()|0;Zb:do if(c[m+272>>2]|0)if(!(a[m+81>>0]|0))rd=3533;else{k=0;break Yb}else{do if(0<0|(0==0?o>>>0<(e[m+276>>1]|0)>>>0:0)){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];j=m+284|0;c[j>>2]=(c[j>>2]|0)+1;break Zb}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];j=m+284|0;c[j>>2]=(c[j>>2]|0)+1;break Zb}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=3533}while(0);if((rd|0)==3533)k=Yd(m,i,h)|0;if(k){cw(k|0,n|0,o|0)|0;a[k+o>>0]=0}else k=0}else k=0;while(0);c[p+4>>2]=k}c[q>>2]=p;break}case 313:{rd=c[td+-8>>2]|0;j=td+-44|0;c[rd+36>>2]=c[j>>2];c[j>>2]=rd;break}case 296:{p=c[td+4>>2]|0;q=td+-8|0;if(p|0){c[p+8>>2]=0;c[p+12>>2]=0;m=c[j>>2]|0;n=c[q>>2]|0;o=c[td+-4>>2]|0;_b:do if(n){i=Qv(o|0,0,1,0)|0;h=L()|0;$b:do if(c[m+272>>2]|0)if(!(a[m+81>>0]|0))rd=3552;else{k=0;break _b}else{do if(0<0|(0==0?o>>>0<(e[m+276>>1]|0)>>>0:0)){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];j=m+284|0;c[j>>2]=(c[j>>2]|0)+1;break $b}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];j=m+284|0;c[j>>2]=(c[j>>2]|0)+1;break $b}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;rd=3552}while(0);if((rd|0)==3552)k=Yd(m,i,h)|0;if(k){cw(k|0,n|0,o|0)|0;a[k+o>>0]=0}else k=0}else k=0;while(0);c[p+4>>2]=k}c[q>>2]=p;break}case 297:{c[td+16>>2]=Bj(j,0,87,0,82,0,0)|0;break}case 298:{rd=td+-20|0;c[rd>>2]=Bj(j,c[rd>>2]|0,c[td+-8>>2]|0,c[td+-4>>2]|0,82,0,a[td+4>>0]|0)|0;break}case 299:{rd=td+-56|0;c[rd>>2]=Bj(j,c[rd>>2]|0,c[td+-32>>2]|0,c[td+-28>>2]|0,c[td+-8>>2]|0,c[td+-4>>2]|0,a[td+4>>0]|0)|0;break}case 312:{c[td+-8>>2]=c[td+4>>2];break}case 311:{a[td+4>>0]=b[td+2>>1];break}case 306:case 304:case 302:{c[td+-8>>2]=e[td+-10>>1];c[td+-4>>2]=0;break}case 305:{rd=td+-8|0;j=c[rd>>2]|0;c[rd>>2]=e[td+2>>1];c[td+-4>>2]=j;break}case 307:{a[td+16>>0]=0;break}case 308:{a[td+-8>>0]=a[td+4>>0]|0;break}case 310:case 309:{a[td+-8>>0]=b[td+-10>>1];break}default:{}}while(0);j=b[17152+(g<<1)>>1]|0;sd=sd<<24>>24;g=b[11376+((b[18656+(e[td+(sd*12|0)>>1]<<1)>>1]|0)+(j&65535)<<1)>>1]|0;sd=sd+1|0;rd=td+(sd*12|0)|0;c[f>>2]=rd;b[rd>>1]=g;b[td+(sd*12|0)+2>>1]=j;f=g;Qa=ud;return f|0}
function xj(f,g,h){f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;I=Qa;Qa=Qa+64|0;B=I+48|0;A=I+40|0;s=I+32|0;r=I+24|0;q=I+16|0;p=I+8|0;u=I;F=I+52|0;G=c[f>>2]|0;a:do if(!(a[G+165>>0]|0)){n=f+4|0;o=G+24|0;k=(c[o>>2]&1|0)==0;l=G+16|0;C=c[(c[l>>2]|0)+12>>2]|0;a[G+78>>0]=a[C+77>>0]|0;if(!((b[C+78>>1]&1)==0?(i=ch(G,0,n,0)|0,(i|0)!=0):0))H=4;b:do if((H|0)==4){i=c[G+20>>2]|0;if((i|0)>1)do{j=i;i=i+-1|0;if((b[(c[(c[l>>2]|0)+(i<<4)+12>>2]|0)+78>>1]&1)==0?(m=ch(G,i,n,0)|0,m|0):0){i=m;break b}}while((j|0)>2);if(k)c[o>>2]=c[o>>2]&-2;if(!(a[G+89>>0]|0))break a;c[o>>2]=c[o>>2]|16;break a}while(0);c[f+12>>2]=i;f=f+36|0;c[f>>2]=(c[f>>2]|0)+1;Qa=I;return}while(0);c:do if(!g){n=G+20|0;if((c[n>>2]|0)>0){o=f+116|0;p=f+40|0;q=f+44|0;r=f+8|0;s=f+23|0;m=0;do{d:do if((m|0)!=1){l=c[(c[(c[f>>2]|0)+16>>2]|0)+(m<<4)+12>>2]|0;k=c[o>>2]|0;k=(k|0)==0?f:k;i=k+84|0;g=c[i>>2]|0;j=1<<m;if(!(g&j))c[i>>2]=g|j;g=k+80|0;c[g>>2]=c[g>>2]|j;g=c[p>>2]|0;c[p>>2]=g+3;fn(f,m,g,0,0);j=(c[q>>2]|0)+1|0;k=c[p>>2]|0;i=c[l+16>>2]|0;if(i|0)do{gn(f,c[i+8>>2]|0,0,g,j,k);i=c[i>>2]|0}while((i|0)!=0);i=c[r>>2]|0;if(!i){j=c[f>>2]|0;if((c[o>>2]|0)==0?(b[j+76>>1]&8)==0:0)a[s>>0]=1;e:do if(c[j+272>>2]|0)if(!(a[j+81>>0]|0))H=37;else break d;else{do if((e[j+276>>1]|0)>=224){g=j+300|0;i=c[g>>2]|0;if(i|0){c[g>>2]=c[i>>2];F=j+284|0;c[F>>2]=(c[F>>2]|0)+1;break e}g=j+296|0;i=c[g>>2]|0;if(!i){i=j+292|0;break}else{c[g>>2]=c[i>>2];F=j+284|0;c[F>>2]=(c[F>>2]|0)+1;break e}}else i=j+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1;H=37}while(0);if((H|0)==37){H=0;i=Yd(j,224,0)|0}if(!i)break;g=i+104|0;l=g+120|0;do{c[g>>2]=0;g=g+4|0}while((g|0)<(l|0));c[i>>2]=j;g=j+4|0;j=c[g>>2]|0;if(j|0)c[j+4>>2]=i;c[i+8>>2]=j;c[i+4>>2]=0;c[g>>2]=i;c[i+20>>2]=381479589;c[i+12>>2]=f;c[r>>2]=i;Bi(i,61,0,1,0)|0}g=i+108|0;j=c[g>>2]|0;if((c[i+112>>2]|0)>(j|0)){c[g>>2]=j+1;F=c[i+104>>2]|0;a[F+(j*20|0)>>0]=-114;b[F+(j*20|0)+2>>1]=0;c[F+(j*20|0)+4>>2]=m;c[F+(j*20|0)+8>>2]=0;c[F+(j*20|0)+12>>2]=0;c[F+(j*20|0)+16>>2]=0;a[F+(j*20|0)+1>>0]=0;break}else{Bi(i,142,m,0,0)|0;break}}while(0);m=m+1|0}while((m|0)<(c[n>>2]|0))}}else{j=h+4|0;do if(!(c[j>>2]|0)){C=uk(G,g)|0;i=c[f>>2]|0;if((C|0)<=-1){if(!(c[j>>2]|0)){i=d[i+164>>0]|0;break}if(a[i+165>>0]|0){ad(f,39404,r);break c}i=uk(i,g)|0;if((i|0)>=0){g=h;break}c[s>>2]=g;ad(f,39421,s);break c}p=c[(c[i+16>>2]|0)+(C<<4)+12>>2]|0;q=f+116|0;o=c[q>>2]|0;o=(o|0)==0?f:o;i=o+84|0;g=c[i>>2]|0;n=1<<C;do if((((g&n|0)==0?(c[i>>2]=g|n,(C|0)==1):0)?(x=c[o>>2]|0,t=x+16|0,(c[(c[t>>2]|0)+20>>2]|0)==0):0)?(a[o+199>>0]|0)==0:0){i=Ne(c[x>>2]|0,0,x,F,0,542)|0;if(i|0){ad(o,32157,u);c[o+12>>2]=i;break}F=c[F>>2]|0;c[(c[t>>2]|0)+20>>2]=F;i=c[x+92>>2]|0;j=c[F+4>>2]|0;c[j+4>>2]=c[F>>2];if(!(b[j+22>>1]&2)){k=j+32|0;l=j+36|0;m=(c[k>>2]|0)-(c[l>>2]|0)|0;if(((i+-512|0)>>>0<65025?(i+-1&i|0)==0:0)?(c[k>>2]=i,w=j+80|0,v=c[w>>2]|0,v|0):0){g=v+-4|0;c[w>>2]=g;i=g;do if((c[14816]|0)>>>0<=i>>>0)if((c[14817]|0)>>>0>i>>>0){c[14979]=(c[14979]|0)+-1;c[g>>2]=c[14819];c[14819]=g;F=(c[14820]|0)+1|0;c[14820]=F;c[14821]=(F|0)<(c[14815]|0)&1;break}else{i=Ua[c[29352>>2]&127](g)|0;H=63;break}else{i=Ua[c[29352>>2]&127](g)|0;H=63}while(0);do if((H|0)==63){c[14980]=(c[14980]|0)-i;if(!(c[7324]|0)){_a[c[29344>>2]&127](g);break}else{F=Ua[c[29352>>2]&127](g)|0;c[14978]=(c[14978]|0)-F;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](g);break}}while(0);c[w>>2]=0}F=Qe(c[j>>2]|0,k,m)|0;c[l>>2]=(c[k>>2]|0)-(m&65535);if((F|0)==7){i=x+81|0;do if((a[i>>0]|0)==0?(a[x+82>>0]|0)==0:0){a[i>>0]=1;if((c[x+180>>2]|0)>0)c[x+264>>2]=1;i=x+272|0;c[i>>2]=(c[i>>2]|0)+1;i=c[x+236>>2]|0;if(!i)break;c[i+12>>2]=7}while(0);break}}}while(0);k=o+80|0;c[k>>2]=c[k>>2]|n;k=f+40|0;g=c[k>>2]|0;c[k>>2]=g+3;fn(f,C,g,0,0);j=(c[f+44>>2]|0)+1|0;k=c[k>>2]|0;i=c[p+16>>2]|0;if(i|0)do{gn(f,c[i+8>>2]|0,0,g,j,k);i=c[i>>2]|0}while((i|0)!=0);k=f+8|0;i=c[k>>2]|0;if(!i){j=c[f>>2]|0;if((c[q>>2]|0)==0?(b[j+76>>1]&8)==0:0)a[f+23>>0]=1;f:do if(c[j+272>>2]|0)if(!(a[j+81>>0]|0))H=93;else break c;else{do if((e[j+276>>1]|0)>=224){g=j+300|0;i=c[g>>2]|0;if(i|0){c[g>>2]=c[i>>2];F=j+284|0;c[F>>2]=(c[F>>2]|0)+1;break f}g=j+296|0;i=c[g>>2]|0;if(!i){i=j+292|0;break}else{c[g>>2]=c[i>>2];F=j+284|0;c[F>>2]=(c[F>>2]|0)+1;break f}}else i=j+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1;H=93}while(0);if((H|0)==93)i=Yd(j,224,0)|0;if(!i)break c;g=i+104|0;l=g+120|0;do{c[g>>2]=0;g=g+4|0}while((g|0)<(l|0));c[i>>2]=j;g=j+4|0;j=c[g>>2]|0;if(j|0)c[j+4>>2]=i;c[i+8>>2]=j;c[i+4>>2]=0;c[g>>2]=i;c[i+20>>2]=381479589;c[i+12>>2]=f;c[k>>2]=i;Bi(i,61,0,1,0)|0}g=i+108|0;j=c[g>>2]|0;if((c[i+112>>2]|0)>(j|0)){c[g>>2]=j+1;F=c[i+104>>2]|0;a[F+(j*20|0)>>0]=-114;b[F+(j*20|0)+2>>1]=0;c[F+(j*20|0)+4>>2]=C;c[F+(j*20|0)+8>>2]=0;c[F+(j*20|0)+12>>2]=0;c[F+(j*20|0)+16>>2]=0;a[F+(j*20|0)+1>>0]=0;break c}else{Bi(i,142,C,0,0)|0;break c}}else{i=c[f>>2]|0;if(a[i+165>>0]|0){ad(f,39404,p);break c}i=uk(i,g)|0;if((i|0)<0){c[q>>2]=g;ad(f,39421,q);break c}else g=h}while(0);if(!(c[j>>2]|0))i=0;else i=c[(c[G+16>>2]|0)+(i<<4)>>2]|0;t=oj(G,g)|0;if(t|0){s=fi(G,t,i)|0;g:do if(!s){q=$c(f,0,t,i)|0;if(q|0){g=c[q+72>>2]|0;if(!g)s=-1e6;else{j=c[(c[f>>2]|0)+16>>2]|0;i=0;while(1)if((c[j+(i<<4)+12>>2]|0)==(g|0)){s=i;break}else i=i+1|0}r=f+116|0;p=c[r>>2]|0;p=(p|0)==0?f:p;i=p+84|0;g=c[i>>2]|0;o=1<<s;do if((((g&o|0)==0?(c[i>>2]=g|o,(s|0)==1):0)?(E=c[p>>2]|0,z=E+16|0,(c[(c[z>>2]|0)+20>>2]|0)==0):0)?(a[p+199>>0]|0)==0:0){i=Ne(c[E>>2]|0,0,E,F,0,542)|0;if(i|0){ad(p,32157,B);c[p+12>>2]=i;break}F=c[F>>2]|0;c[(c[z>>2]|0)+20>>2]=F;i=c[E+92>>2]|0;k=c[F+4>>2]|0;c[k+4>>2]=c[F>>2];if(!(b[k+22>>1]&2)){l=k+32|0;m=k+36|0;n=(c[l>>2]|0)-(c[m>>2]|0)|0;do if((i+-512|0)>>>0<65025){if(i+-1&i|0)break;c[l>>2]=i;j=k+80|0;i=c[j>>2]|0;if(!i)break;g=i+-4|0;c[j>>2]=g;i=g;do if((c[14816]|0)>>>0<=i>>>0)if((c[14817]|0)>>>0>i>>>0){c[14979]=(c[14979]|0)+-1;c[g>>2]=c[14819];c[14819]=g;F=(c[14820]|0)+1|0;c[14820]=F;c[14821]=(F|0)<(c[14815]|0)&1;break}else{i=Ua[c[29352>>2]&127](g)|0;H=187;break}else{i=Ua[c[29352>>2]&127](g)|0;H=187}while(0);do if((H|0)==187){c[14980]=(c[14980]|0)-i;if(!(c[7324]|0)){_a[c[29344>>2]&127](g);break}else{F=Ua[c[29352>>2]&127](g)|0;c[14978]=(c[14978]|0)-F;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](g);break}}while(0);c[j>>2]=0}while(0);F=Qe(c[k>>2]|0,l,n)|0;c[m>>2]=(c[l>>2]|0)-(n&65535);if((F|0)==7){i=E+81|0;do if(!(a[i>>0]|0)){if(a[E+82>>0]|0)break;a[i>>0]=1;if((c[E+180>>2]|0)>0)c[E+264>>2]=1;i=E+272|0;c[i>>2]=(c[i>>2]|0)+1;i=c[E+236>>2]|0;if(!i)break;c[i+12>>2]=7}while(0);break}}}while(0);k=p+80|0;c[k>>2]=c[k>>2]|o;k=f+40|0;i=c[k>>2]|0;c[k>>2]=i+3;fn(f,s,i,c[q>>2]|0,38087);gn(f,q,0,i,(c[f+44>>2]|0)+1|0,c[k>>2]|0);k=f+8|0;i=c[k>>2]|0;if(!i){j=c[f>>2]|0;if((c[r>>2]|0)==0?(b[j+76>>1]&8)==0:0)a[f+23>>0]=1;h:do if(c[j+272>>2]|0)if(!(a[j+81>>0]|0))H=214;else break g;else{do if((e[j+276>>1]|0)>=224){g=j+300|0;i=c[g>>2]|0;if(i|0){c[g>>2]=c[i>>2];F=j+284|0;c[F>>2]=(c[F>>2]|0)+1;break h}g=j+296|0;i=c[g>>2]|0;if(!i){i=j+292|0;break}else{c[g>>2]=c[i>>2];F=j+284|0;c[F>>2]=(c[F>>2]|0)+1;break h}}else i=j+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1;H=214}while(0);if((H|0)==214)i=Yd(j,224,0)|0;if(!i)break;g=i+104|0;l=g+120|0;do{c[g>>2]=0;g=g+4|0}while((g|0)<(l|0));c[i>>2]=j;g=j+4|0;j=c[g>>2]|0;if(j|0)c[j+4>>2]=i;c[i+8>>2]=j;c[i+4>>2]=0;c[g>>2]=i;c[i+20>>2]=381479589;c[i+12>>2]=f;c[k>>2]=i;Bi(i,61,0,1,0)|0}g=i+108|0;j=c[g>>2]|0;if((c[i+112>>2]|0)>(j|0)){c[g>>2]=j+1;F=c[i+104>>2]|0;a[F+(j*20|0)>>0]=-114;b[F+(j*20|0)+2>>1]=0;c[F+(j*20|0)+4>>2]=s;c[F+(j*20|0)+8>>2]=0;c[F+(j*20|0)+12>>2]=0;c[F+(j*20|0)+16>>2]=0;a[F+(j*20|0)+1>>0]=0;break}else{Bi(i,142,s,0,0)|0;break}}}else{q=c[s+12>>2]|0;g=c[q+72>>2]|0;if(!g)h=-1e6;else{j=c[(c[f>>2]|0)+16>>2]|0;i=0;while(1)if((c[j+(i<<4)+12>>2]|0)==(g|0)){h=i;break}else i=i+1|0}r=f+116|0;p=c[r>>2]|0;p=(p|0)==0?f:p;i=p+84|0;g=c[i>>2]|0;o=1<<h;do if((((g&o|0)==0?(c[i>>2]=g|o,(h|0)==1):0)?(D=c[p>>2]|0,y=D+16|0,(c[(c[y>>2]|0)+20>>2]|0)==0):0)?(a[p+199>>0]|0)==0:0){i=Ne(c[D>>2]|0,0,D,F,0,542)|0;if(i|0){ad(p,32157,A);c[p+12>>2]=i;break}F=c[F>>2]|0;c[(c[y>>2]|0)+20>>2]=F;i=c[D+92>>2]|0;k=c[F+4>>2]|0;c[k+4>>2]=c[F>>2];if(!(b[k+22>>1]&2)){l=k+32|0;m=k+36|0;n=(c[l>>2]|0)-(c[m>>2]|0)|0;do if((i+-512|0)>>>0<65025?(i+-1&i|0)==0:0){c[l>>2]=i;j=k+80|0;i=c[j>>2]|0;if(!i)break;g=i+-4|0;c[j>>2]=g;i=g;do if((c[14816]|0)>>>0<=i>>>0)if((c[14817]|0)>>>0>i>>>0){c[14979]=(c[14979]|0)+-1;c[g>>2]=c[14819];c[14819]=g;F=(c[14820]|0)+1|0;c[14820]=F;c[14821]=(F|0)<(c[14815]|0)&1;break}else{i=Ua[c[29352>>2]&127](g)|0;H=133;break}else{i=Ua[c[29352>>2]&127](g)|0;H=133}while(0);do if((H|0)==133){c[14980]=(c[14980]|0)-i;if(!(c[7324]|0)){_a[c[29344>>2]&127](g);break}else{F=Ua[c[29352>>2]&127](g)|0;c[14978]=(c[14978]|0)-F;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](g);break}}while(0);c[j>>2]=0}while(0);F=Qe(c[k>>2]|0,l,n)|0;c[m>>2]=(c[l>>2]|0)-(n&65535);if((F|0)==7){i=D+81|0;do if(!(a[i>>0]|0)){if(a[D+82>>0]|0)break;a[i>>0]=1;if((c[D+180>>2]|0)>0)c[D+264>>2]=1;i=D+272|0;c[i>>2]=(c[i>>2]|0)+1;i=c[D+236>>2]|0;if(!i)break;c[i+12>>2]=7}while(0);break}}}while(0);k=p+80|0;c[k>>2]=c[k>>2]|o;k=f+40|0;i=c[k>>2]|0;c[k>>2]=i+3;fn(f,h,i,c[s>>2]|0,38091);gn(f,q,s,i,(c[f+44>>2]|0)+1|0,c[k>>2]|0);k=f+8|0;i=c[k>>2]|0;if(!i){j=c[f>>2]|0;if((c[r>>2]|0)==0?(b[j+76>>1]&8)==0:0)a[f+23>>0]=1;i:do if(c[j+272>>2]|0)if(!(a[j+81>>0]|0))H=160;else break g;else{do if((e[j+276>>1]|0)>=224){g=j+300|0;i=c[g>>2]|0;if(i|0){c[g>>2]=c[i>>2];F=j+284|0;c[F>>2]=(c[F>>2]|0)+1;break i}g=j+296|0;i=c[g>>2]|0;if(!i){i=j+292|0;break}else{c[g>>2]=c[i>>2];F=j+284|0;c[F>>2]=(c[F>>2]|0)+1;break i}}else i=j+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1;H=160}while(0);if((H|0)==160)i=Yd(j,224,0)|0;if(!i)break;g=i+104|0;l=g+120|0;do{c[g>>2]=0;g=g+4|0}while((g|0)<(l|0));c[i>>2]=j;g=j+4|0;j=c[g>>2]|0;if(j|0)c[j+4>>2]=i;c[i+8>>2]=j;c[i+4>>2]=0;c[g>>2]=i;c[i+20>>2]=381479589;c[i+12>>2]=f;c[k>>2]=i;Bi(i,61,0,1,0)|0}g=i+108|0;j=c[g>>2]|0;if((c[i+112>>2]|0)>(j|0)){c[g>>2]=j+1;F=c[i+104>>2]|0;a[F+(j*20|0)>>0]=-114;b[F+(j*20|0)+2>>1]=0;c[F+(j*20|0)+4>>2]=h;c[F+(j*20|0)+8>>2]=0;c[F+(j*20|0)+12>>2]=0;c[F+(j*20|0)+16>>2]=0;a[F+(j*20|0)+1>>0]=0;break}else{Bi(i,142,h,0,0)|0;break}}while(0);if(G|0){if(c[G+480>>2]|0){Vd(G,t);break}F=t;if((c[G+304>>2]|0)>>>0<=F>>>0?(c[G+308>>2]|0)>>>0>F>>>0:0){F=G+300|0;c[t>>2]=c[F>>2];c[F>>2]=t;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](t);break}else{F=Ua[c[29352>>2]&127](t)|0;c[14978]=(c[14978]|0)-F;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](t);break}}}while(0);if(a[G+90>>0]|0){Qa=I;return}k=f+8|0;i=c[k>>2]|0;if(!i){j=c[f>>2]|0;if((c[f+116>>2]|0)==0?(b[j+76>>1]&8)==0:0)a[f+23>>0]=1;j:do if(c[j+272>>2]|0)if(!(a[j+81>>0]|0))H=246;else{Qa=I;return}else{do if((e[j+276>>1]|0)>=224){g=j+300|0;i=c[g>>2]|0;if(i|0){c[g>>2]=c[i>>2];G=j+284|0;c[G>>2]=(c[G>>2]|0)+1;break j}g=j+296|0;i=c[g>>2]|0;if(!i){i=j+292|0;break}else{c[g>>2]=c[i>>2];G=j+284|0;c[G>>2]=(c[G>>2]|0)+1;break j}}else i=j+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1;H=246}while(0);if((H|0)==246)i=Yd(j,224,0)|0;if(!i){Qa=I;return}g=i+104|0;l=g+120|0;do{c[g>>2]=0;g=g+4|0}while((g|0)<(l|0));c[i>>2]=j;g=j+4|0;j=c[g>>2]|0;if(j|0)c[j+4>>2]=i;c[i+8>>2]=j;c[i+4>>2]=0;c[g>>2]=i;c[i+20>>2]=381479589;c[i+12>>2]=f;c[k>>2]=i;Bi(i,61,0,1,0)|0}g=i+108|0;j=c[g>>2]|0;if((c[i+112>>2]|0)>(j|0)){c[g>>2]=j+1;g=c[i+104>>2]|0;a[g+(j*20|0)>>0]=-98;g=g+(j*20|0)+1|0;l=g+19|0;do{a[g>>0]=0;g=g+1|0}while((g|0)<(l|0));Qa=I;return}else{Bi(i,158,0,0,0)|0;Qa=I;return}}function yj(d,f){d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=Qa;Qa=Qa+48|0;t=w+40|0;s=w+16|0;q=w+8|0;n=w;o=d+228|0;u=c[o>>2]|0;v=c[d>>2]|0;if(!u){Qa=w;return}p=d+244|0;m=c[p>>2]|0;do if(m){l=c[d+248>>2]|0;j=Qv(l|0,((l|0)<0)<<31>>31|0,1,0)|0;k=L()|0;a:do if(c[v+272>>2]|0)if(!(a[v+81>>0]|0))r=14;else m=0;else{do if(!(k>>>0>0|((k|0)==0?j>>>0>(e[v+276>>1]|0)>>>0:0))){i=v+300|0;g=c[i>>2]|0;if(g|0){c[i>>2]=c[g>>2];r=v+284|0;c[r>>2]=(c[r>>2]|0)+1;r=15;break a}i=v+296|0;g=c[i>>2]|0;if(!g){g=v+292|0;break}else{c[i>>2]=c[g>>2];r=v+284|0;c[r>>2]=(c[r>>2]|0)+1;r=15;break a}}else g=v+288|0;while(0);c[g>>2]=(c[g>>2]|0)+1;r=14}while(0);if((r|0)==14){g=Yd(v,j,k)|0;r=15}if((r|0)==15)if(!g)m=0;else{cw(g|0,m|0,l|0)|0;a[g+l>>0]=0;m=g}g=u+56|0;l=c[g>>2]|0;j=(l<<2)+8|0;k=c[d>>2]|0;if((l+3|0)>=(c[k+116>>2]|0)){c[n>>2]=c[u>>2];ad(d,38221,n)}l=u+60|0;i=c[l>>2]|0;b:do if(!i){if(c[k+272>>2]|0){if(a[k+81>>0]|0)break}else{do if(!(0<0|(0==0?(e[k+276>>1]|0)>>>0<j>>>0:0))){i=k+300|0;h=c[i>>2]|0;if(h|0){c[i>>2]=c[h>>2];r=k+284|0;c[r>>2]=(c[r>>2]|0)+1;r=36;break b}i=k+296|0;h=c[i>>2]|0;if(!h){h=k+292|0;break}else{c[i>>2]=c[h>>2];r=k+284|0;c[r>>2]=(c[r>>2]|0)+1;r=36;break b}}else h=k+288|0;while(0);c[h>>2]=(c[h>>2]|0)+1}h=Yd(k,j,0)|0;r=36}else{r=i;if((c[k+304>>2]|0)>>>0<=r>>>0?(c[k+308>>2]|0)>>>0>r>>>0:0){if(!(0<0|(0==0?(e[k+276>>1]|0)>>>0<j>>>0:0))){h=i;r=46;break}h=Xd(k,i,j,0)|0;r=36;break}h=Xd(k,i,j,0)|0;r=36}while(0);if((r|0)==36?h|0:0)r=46;if((r|0)==46){k=c[g>>2]|0;n=k+1|0;c[g>>2]=n;c[h+(k<<2)>>2]=m;c[h+(n<<2)>>2]=0;c[l>>2]=h;break}if(m){if(c[k+480>>2]|0){Vd(k,m);break}n=m;if((c[k+304>>2]|0)>>>0<=n>>>0?(c[k+308>>2]|0)>>>0>n>>>0:0){n=k+300|0;c[m>>2]=c[n>>2];c[n>>2]=m;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](m);break}else{n=Ua[c[29352>>2]&127](m)|0;c[14978]=(c[14978]|0)-n;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](m);break}}}else g=u+56|0;while(0);c[p>>2]=0;if((c[g>>2]|0)<1){Qa=w;return}if(a[v+165>>0]|0){if(!(ki((c[u+72>>2]|0)+8|0,c[u>>2]|0,u)|0)){c[o>>2]=0;Qa=w;return}g=v+81|0;if(a[g>>0]|0){Qa=w;return}if(a[v+82>>0]|0){Qa=w;return}a[g>>0]=1;if((c[v+180>>2]|0)>0)c[v+264>>2]=1;g=v+272|0;c[g>>2]=(c[g>>2]|0)+1;g=c[v+236>>2]|0;if(!g){Qa=w;return}c[g+12>>2]=7;Qa=w;return}if(!f)g=d+180|0;else{g=d+180|0;c[d+184>>2]=(c[f>>2]|0)-(c[g>>2]|0)+(c[f+4>>2]|0)}c[q>>2]=g;j=bd(v,48861,q)|0;h=c[u+72>>2]|0;i=c[v+16>>2]|0;if(!h)m=-1e6;else{g=0;while(1)if((c[i+(g<<4)+12>>2]|0)==(h|0)){m=g;break}else g=g+1|0}p=c[u>>2]|0;q=c[d+88>>2]|0;c[s>>2]=c[i+(m<<4)>>2];c[s+4>>2]=34585;c[s+8>>2]=p;c[s+12>>2]=p;c[s+16>>2]=j;c[s+20>>2]=q;yk(d,48885,s);do if(j|0){if(c[v+480>>2]|0){Vd(v,j);break}s=j;if((c[v+304>>2]|0)>>>0<=s>>>0?(c[v+308>>2]|0)>>>0>s>>>0:0){s=v+300|0;c[j>>2]=c[s>>2];c[s>>2]=j;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](j);break}else{s=Ua[c[29352>>2]&127](j)|0;c[14978]=(c[14978]|0)-s;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](j);break}}while(0);k=d+8|0;g=c[k>>2]|0;c:do if(!g){j=c[d>>2]|0;if((c[d+116>>2]|0)==0?(b[j+76>>1]&8)==0:0)a[d+23>>0]=1;d:do if(c[j+272>>2]|0)if(!(a[j+81>>0]|0))r=78;else{l=0;break c}else{do if((e[j+276>>1]|0)>=224){g=j+300|0;h=c[g>>2]|0;if(h|0){c[g>>2]=c[h>>2];i=j+284|0;c[i>>2]=(c[i>>2]|0)+1;i=h;break d}g=j+296|0;h=c[g>>2]|0;if(!h){g=j+292|0;break}else{c[g>>2]=c[h>>2];i=j+284|0;c[i>>2]=(c[i>>2]|0)+1;i=h;break d}}else g=j+288|0;while(0);c[g>>2]=(c[g>>2]|0)+1;r=78}while(0);if((r|0)==78)i=Yd(j,224,0)|0;if(!i)l=0;else{g=i+104|0;h=g+120|0;do{c[g>>2]=0;g=g+4|0}while((g|0)<(h|0));c[i>>2]=j;g=j+4|0;h=c[g>>2]|0;if(h|0)c[h+4>>2]=i;c[i+8>>2]=h;c[i+4>>2]=0;c[g>>2]=i;c[i+20>>2]=381479589;c[i+12>>2]=d;c[k>>2]=i;Bi(i,61,0,1,0)|0;l=i}}else l=g;while(0);g=c[k>>2]|0;h=(c[c[(c[(c[d>>2]|0)+16>>2]|0)+(m<<4)+12>>2]>>2]|0)+1|0;i=g+108|0;j=c[i>>2]|0;if((c[g+112>>2]|0)>(j|0)){c[i>>2]=j+1;s=c[g+104>>2]|0;a[s+(j*20|0)>>0]=95;b[s+(j*20|0)+2>>1]=0;c[s+(j*20|0)+4>>2]=m;c[s+(j*20|0)+8>>2]=1;c[s+(j*20|0)+12>>2]=h;c[s+(j*20|0)+16>>2]=0;a[s+(j*20|0)+1>>0]=0}else Bi(g,95,m,1,h)|0;j=l+108|0;g=c[j>>2]|0;k=l+112|0;if((c[k>>2]|0)>(g|0)){c[j>>2]=g+1;h=c[l+104>>2]|0;a[h+(g*20|0)>>0]=-98;g=h+(g*20|0)+1|0;h=g+19|0;do{a[g>>0]=0;g=g+1|0}while((g|0)<(h|0))}else Bi(l,158,0,0,0)|0;c[t>>2]=c[u>>2];zk(l,m,bd(v,48973,t)|0);h=d+44|0;i=(c[h>>2]|0)+1|0;c[h>>2]=i;h=c[u>>2]|0;g=c[j>>2]|0;if((c[k>>2]|0)>(g|0)){c[j>>2]=g+1;v=c[l+104>>2]|0;a[v+(g*20|0)>>0]=110;b[v+(g*20|0)+2>>1]=0;c[v+(g*20|0)+4>>2]=0;c[v+(g*20|0)+8>>2]=i;c[v+(g*20|0)+12>>2]=0;c[v+(g*20|0)+16>>2]=0;a[v+(g*20|0)+1>>0]=0}else g=Bi(l,110,0,i,0)|0;if(!(a[(c[l>>2]|0)+81>>0]|0)){if((g|0)<0)g=(c[j>>2]|0)+-1|0;Ci(l,(c[l+104>>2]|0)+(g*20|0)|0,h,0)}g=c[j>>2]|0;if((c[k>>2]|0)>(g|0)){c[j>>2]=g+1;v=c[l+104>>2]|0;a[v+(g*20|0)>>0]=-95;b[v+(g*20|0)+2>>1]=0;c[v+(g*20|0)+4>>2]=m;c[v+(g*20|0)+8>>2]=i;c[v+(g*20|0)+12>>2]=0;c[v+(g*20|0)+16>>2]=0;a[v+(g*20|0)+1>>0]=0;Qa=w;return}else{Bi(l,161,m,i,0)|0;Qa=w;return}}function zj(b,f,g,h,i){b=b|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;s=Qa;Qa=Qa+16|0;o=s;r=c[b>>2]|0;q=oj(r,g)|0;n=(f|0)!=0;if(n&(q|0)!=0?(j=c[f>>2]|0,(j|0)>0):0){m=0;g=j;do{k=c[f+8+(m<<4)>>2]|0;l=a[q>>0]|0;j=(d[208+(l&255)>>0]|0)-(d[208+(d[k>>0]|0)>>0]|0)|0;if(!(l<<24>>24==0|(j|0)!=0)){l=q;do{l=l+1|0;k=k+1|0;t=a[l>>0]|0;j=(d[208+(t&255)>>0]|0)-(d[208+(d[k>>0]|0)>>0]|0)|0}while(!(t<<24>>24==0|(j|0)!=0))}if(!j){c[o>>2]=q;ad(b,49e3,o);g=c[f>>2]|0}m=m+1|0}while((m|0)<(g|0))}a:do if(n){g=(c[f>>2]<<4)+24|0;t=f;if((c[r+304>>2]|0)>>>0<=t>>>0?(c[r+308>>2]|0)>>>0>t>>>0:0){if(!(0<0|(0==0?(e[r+276>>1]|0)>>>0<g>>>0:0))){g=f;break}g=Xd(r,f,g,0)|0;break}g=Xd(r,f,g,0)|0}else{b:do if(!r){if(!(c[7324]|0)){g=Ua[c[29340>>2]&127](24)|0;p=39;break}k=Ua[c[29356>>2]&127](24)|0;if((c[14985]|0)>>>0<24)c[14985]=24;j=59064;g=c[j>>2]|0;j=c[j+4>>2]|0;if((j|0)>0|(j|0)==0&g>>>0>0){t=c[14978]|0;o=Rv(g|0,j|0,k|0,((k|0)<0)<<31>>31|0)|0;b=L()|0;c[14768]=((b|0)<0|(b|0)==0&o>>>0<=t>>>0)&1}g=Ua[c[29340>>2]&127](k)|0;if(!g){g=0;break a}j=Ua[c[29352>>2]&127](g)|0;j=(c[14978]|0)+j|0;c[14978]=j;if(j>>>0>(c[14982]|0)>>>0)c[14982]=j;j=(c[14981]|0)+1|0;c[14981]=j;if(j>>>0>(c[14987]|0)>>>0)c[14987]=j}else{if(c[r+272>>2]|0){if(a[r+81>>0]|0){g=0;break a}}else{do if((e[r+276>>1]|0)>=24){j=r+300|0;g=c[j>>2]|0;if(g|0){c[j>>2]=c[g>>2];p=r+284|0;c[p>>2]=(c[p>>2]|0)+1;p=39;break b}j=r+296|0;g=c[j>>2]|0;if(!g){g=r+292|0;break}else{c[j>>2]=c[g>>2];p=r+284|0;c[p>>2]=(c[p>>2]|0)+1;p=39;break b}}else g=r+288|0;while(0);c[g>>2]=(c[g>>2]|0)+1}g=Yd(r,24,0)|0;p=39}while(0);if((p|0)==39)if(!g){g=0;break}j=g;k=j+24|0;do{a[j>>0]=0;j=j+1|0}while((j|0)<(k|0))}while(0);if(!(a[r+81>>0]|0)){r=g+8|0;t=c[g>>2]|0;c[r+(t<<4)+8>>2]=i;c[r+(t<<4)+4>>2]=h;c[r+(t<<4)>>2]=q;c[r+(t<<4)+12>>2]=0;c[g>>2]=t+1;t=g;Qa=s;return t|0}if(h|0)pi(r,h);if(i|0)ni(r,i,1);if(!q){t=f;Qa=s;return t|0}if(c[r+480>>2]|0){Vd(r,q);t=f;Qa=s;return t|0}t=q;if((c[r+304>>2]|0)>>>0<=t>>>0?(c[r+308>>2]|0)>>>0>t>>>0:0){t=r+300|0;c[q>>2]=c[t>>2];c[t>>2]=q;t=f;Qa=s;return t|0}if(!(c[7324]|0)){_a[c[29344>>2]&127](q);t=f;Qa=s;return t|0}else{t=Ua[c[29352>>2]&127](q)|0;c[14978]=(c[14978]|0)-t;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](q);t=f;Qa=s;return t|0}return 0}function Aj(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;p=Qa;Qa=Qa+16|0;m=p+8|0;k=p;n=e+4|0;l=c[n>>2]|0;if(!l){Qa=p;return}o=c[b>>2]|0;a:do if(f|0){j=d[208+(d[l>>0]|0)>>0]|0;while(1){h=c[f>>2]|0;i=a[h>>0]|0;g=(d[208+(i&255)>>0]|0)-j|0;if(!(i<<24>>24==0|(g|0)!=0)){i=l;do{h=h+1|0;i=i+1|0;q=a[h>>0]|0;g=(d[208+(q&255)>>0]|0)-(d[208+(d[i>>0]|0)>>0]|0)|0}while(!(q<<24>>24==0|(g|0)!=0))}if(!g)break;f=c[f+32>>2]|0;if(!f)break a}if(!f){Qa=p;return}g=e+8|0;do if(!(c[g>>2]|0)){h=f+12|0;if(c[h>>2]|0?c[e+12>>2]|0:0){f=49047;break}if(!(a[f+19>>0]|0))f=49063;else{c[g>>2]=ek(o,c[f+8>>2]|0,0)|0;f=c[h>>2]|0;if(f|0)c[e+12>>2]=ek(o,f,0)|0;f=c[n>>2]|0;do if(f|0){if(o|0){if(c[o+480>>2]|0){Vd(o,f);break}q=f;if((c[o+304>>2]|0)>>>0<=q>>>0?(c[o+308>>2]|0)>>>0>q>>>0:0){q=o+300|0;c[f>>2]=c[q>>2];c[q>>2]=f;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](f);break}else{q=Ua[c[29352>>2]&127](f)|0;c[14978]=(c[14978]|0)-q;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](f);break}}while(0);c[n>>2]=0;Qa=p;return}}else f=49030;while(0);c[m>>2]=f;c[m+4>>2]=l;ad(b,49083,m);Qa=p;return}while(0);c[k>>2]=l;ad(b,40596,k);Qa=p;return}function Bj(d,f,g,h,i,j,k){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;r=Qa;Qa=Qa+16|0;l=r;p=(f|0)==0;q=p&1;a:do if((g|0)==82&(i|0)==85)o=4;else{if((g|0)==83)switch(i|0){case 82:case 85:{o=4;break a}default:{}}n=c[d>>2]|0;b:do if(!n){if(!(c[7324]|0)){l=Ua[c[29340>>2]&127](92)|0;o=28;break}l=Ua[c[29356>>2]&127](92)|0;if((c[14985]|0)>>>0<92)c[14985]=92;n=59064;m=c[n>>2]|0;n=c[n+4>>2]|0;if((n|0)>0|(n|0)==0&m>>>0>0){s=c[14978]|0;n=Rv(m|0,n|0,l|0,((l|0)<0)<<31>>31|0)|0;m=L()|0;c[14768]=((m|0)<0|(m|0)==0&n>>>0<=s>>>0)&1}l=Ua[c[29340>>2]&127](l)|0;if(!l)break a;m=Ua[c[29352>>2]&127](l)|0;m=(c[14978]|0)+m|0;c[14978]=m;if(m>>>0>(c[14982]|0)>>>0)c[14982]=m;m=(c[14981]|0)+1|0;c[14981]=m;if(m>>>0>(c[14987]|0)>>>0)c[14987]=m}else{if(c[n+272>>2]|0){if(a[n+81>>0]|0)break a}else{do if((e[n+276>>1]|0)>=92){m=n+300|0;l=c[m>>2]|0;if(l|0){c[m>>2]=c[l>>2];o=n+284|0;c[o>>2]=(c[o>>2]|0)+1;o=28;break b}m=n+296|0;l=c[m>>2]|0;if(!l){l=n+292|0;break}else{c[m>>2]=c[l>>2];o=n+284|0;c[o>>2]=(c[o>>2]|0)+1;o=28;break b}}else l=n+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1}l=Yd(n,92,0)|0;o=28}while(0);if((o|0)==28)if(!l)break;m=l;n=m+92|0;do{a[m>>0]=0;m=m+1|0}while((m|0)<(n|0));a[l+16>>0]=p?86:f&255;a[l+17>>0]=g;a[l+18>>0]=i;if(!(k<<24>>24))k=(b[(c[d>>2]|0)+76>>1]&2)==0?0:66;a[l+20>>0]=k;a[l+19>>0]=q;c[l+28>>2]=nn(d,j)|0;c[l+24>>2]=nn(d,h)|0;s=l;Qa=r;return s|0}while(0);if((o|0)==4)ad(d,49116,l);if(j|0)li(c[d>>2]|0,j);if(!h){s=0;Qa=r;return s|0}li(c[d>>2]|0,h);s=0;Qa=r;return s|0}function Cj(d){d=d|0;var e=0,f=0,g=0,h=0,i=0;i=d+8|0;e=c[i>>2]|0;if(e|0){i=e;return i|0}e=c[d>>2]|0;if((c[d+116>>2]|0)==0?(b[e+76>>1]&8)==0:0)a[d+23>>0]=1;h=Wd(e,224,0)|0;if(!h){i=0;return i|0}f=h+104|0;g=f+120|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));c[h>>2]=e;e=e+4|0;f=c[e>>2]|0;if(f|0)c[f+4>>2]=h;c[h+8>>2]=f;c[h+4>>2]=0;c[e>>2]=h;c[h+20>>2]=381479589;c[h+12>>2]=d;c[i>>2]=h;Bi(h,61,0,1,0)|0;i=h;return i|0}function Dj(d,e,f,g,h,i,j){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0;k=d+108|0;l=c[k>>2]|0;if((c[d+112>>2]|0)>(l|0)){c[k>>2]=l+1;k=c[d+104>>2]|0;a[k+(l*20|0)>>0]=e;b[k+(l*20|0)+2>>1]=0;c[k+(l*20|0)+4>>2]=f;c[k+(l*20|0)+8>>2]=g;c[k+(l*20|0)+12>>2]=h;c[k+(l*20|0)+16>>2]=0;a[k+(l*20|0)+1>>0]=0;ed(d,l,i,j);return l|0}else{l=Bi(d,e,f,g,h)|0;ed(d,l,i,j);return l|0}return 0}function Ej(f,g,h,i,j){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0;p=f+8|0;k=c[p>>2]|0;a:do if(!k){o=c[f>>2]|0;if((c[f+116>>2]|0)==0?(b[o+76>>1]&8)==0:0)a[f+23>>0]=1;b:do if(c[o+272>>2]|0)if(!(a[o+81>>0]|0))n=15;else{o=0;break a}else{do if((e[o+276>>1]|0)>=224){k=o+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];m=o+284|0;c[m>>2]=(c[m>>2]|0)+1;m=l;break b}k=o+296|0;l=c[k>>2]|0;if(!l){k=o+292|0;break}else{c[k>>2]=c[l>>2];m=o+284|0;c[m>>2]=(c[m>>2]|0)+1;m=l;break b}}else k=o+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;n=15}while(0);if((n|0)==15)m=Yd(o,224,0)|0;if(!m)o=0;else{k=m+104|0;l=k+120|0;do{c[k>>2]=0;k=k+4|0}while((k|0)<(l|0));c[m>>2]=o;k=o+4|0;l=c[k>>2]|0;if(l|0)c[l+4>>2]=m;c[m+8>>2]=l;c[m+4>>2]=0;c[k>>2]=m;c[m+20>>2]=381479589;c[m+12>>2]=f;c[p>>2]=m;Bi(m,61,0,1,0)|0;o=m}}else o=k;while(0);k=i+28|0;Fj(f,h,c[k>>2]|0,(j|0)==109&1,c[i>>2]|0);if(!(c[i+36>>2]&32)){m=c[k>>2]|0;n=b[i+42>>1]|0;l=o+108|0;k=c[l>>2]|0;if((c[o+112>>2]|0)>(k|0)){c[l>>2]=k+1;f=c[o+104>>2]|0;a[f+(k*20|0)>>0]=j;b[f+(k*20|0)+2>>1]=0;c[f+(k*20|0)+4>>2]=g;c[f+(k*20|0)+8>>2]=m;c[f+(k*20|0)+12>>2]=h;c[f+(k*20|0)+16>>2]=0;a[f+(k*20|0)+1>>0]=0}else k=Bi(o,j,g,m,h)|0;if(a[(c[o>>2]|0)+81>>0]|0)return;j=c[o+104>>2]|0;a[j+(k*20|0)+1>>0]=-3;c[j+(k*20|0)+16>>2]=n;return}k=c[i+8>>2]|0;c:do if(!k)k=0;else while(1){i=k+55|0;if(((d[i>>0]|d[i+1>>0]<<8)&3)==2)break c;k=c[k+20>>2]|0;if(!k){k=0;break}}while(0);l=c[k+44>>2]|0;m=o+108|0;n=c[m>>2]|0;if((c[o+112>>2]|0)>(n|0)){c[m>>2]=n+1;i=c[o+104>>2]|0;a[i+(n*20|0)>>0]=j;b[i+(n*20|0)+2>>1]=0;c[i+(n*20|0)+4>>2]=g;c[i+(n*20|0)+8>>2]=l;c[i+(n*20|0)+12>>2]=h;c[i+(n*20|0)+16>>2]=0;a[i+(n*20|0)+1>>0]=0}else Bi(o,j,g,l,h)|0;m=c[p>>2]|0;l=Gj(f,k)|0;if(!l)return;k=c[m>>2]|0;if(!(a[k+81>>0]|0)){h=c[m+104>>2]|0;j=(c[m+108>>2]|0)+-1|0;a[h+(j*20|0)+1>>0]=-9;c[h+(j*20|0)+16>>2]=l;return}if(c[k+480>>2]|0)return;j=(c[l>>2]|0)+-1|0;c[l>>2]=j;if(j|0)return;k=c[l+12>>2]|0;if(k|0){if(c[k+480>>2]|0){Vd(k,l);return}j=l;if((c[k+304>>2]|0)>>>0<=j>>>0?(c[k+308>>2]|0)>>>0>j>>>0:0){j=k+300|0;c[l>>2]=c[j>>2];c[j>>2]=l;return}}if(!(c[7324]|0)){_a[c[29344>>2]&127](l);return}else{j=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);return}}function Fj(b,d,f,g,h){b=b|0;d=d|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;l=c[b+116>>2]|0;l=(l|0)==0?b:l;if((d|0)==1)return;if(!(a[(c[(c[(c[b>>2]|0)+16>>2]|0)+(d<<4)+4>>2]|0)+9>>0]|0))return;r=l+104|0;p=c[r>>2]|0;i=l+108|0;a:do if((p|0)<=0){j=c[i>>2]|0;k=(p<<4)+16|0;n=c[l>>2]|0;m=((k|0)<0)<<31>>31;if(!j){b:do if(c[n+272>>2]|0)if(!(a[n+81>>0]|0))q=21;else{b=l;q=39;break a}else{do if(!(0<m>>>0|(0==(m|0)?(e[n+276>>1]|0)>>>0<k>>>0:0))){j=n+300|0;b=c[j>>2]|0;if(b|0){c[j>>2]=c[b>>2];p=n+284|0;c[p>>2]=(c[p>>2]|0)+1;break b}j=n+296|0;b=c[j>>2]|0;if(!b){b=n+292|0;break}else{c[j>>2]=c[b>>2];p=n+284|0;c[p>>2]=(c[p>>2]|0)+1;break b}}else b=n+288|0;while(0);c[b>>2]=(c[b>>2]|0)+1;q=21}while(0);if((q|0)==21)b=Yd(n,k,m)|0;c[i>>2]=b;if(!b)b=l;else q=37}else{b=l;o=j;j=k;q=22}}else{j=c[i>>2]|0;b=0;while(1){if((c[j+(b<<4)>>2]|0)==(d|0)?(c[j+(b<<4)+4>>2]|0)==(f|0):0)break;b=b+1|0;if((b|0)>=(p|0)){q=9;break}}if((q|0)==9){k=(p<<4)+16|0;b=l;o=j;n=c[l>>2]|0;m=((k|0)<0)<<31>>31;j=k;q=22;break}r=j+(b<<4)+8|0;a[r>>0]=(a[r>>0]|g)<<24>>24!=0&1;return}while(0);do if((q|0)==22){k=o;l=n+304|0;if(((c[l>>2]|0)>>>0<=k>>>0?(c[n+308>>2]|0)>>>0>k>>>0:0)?!(m>>>0>0|((m|0)==0?j>>>0>(e[n+276>>1]|0)>>>0:0)):0){c[i>>2]=o;b=o;i=p;q=38;break}j=Xd(n,o,j,m)|0;if(j|0){c[i>>2]=j;b=j;q=37;break}if(c[n+480>>2]|0){Vd(n,o);q=39;break}if((c[l>>2]|0)>>>0<=k>>>0?(c[n+308>>2]|0)>>>0>k>>>0:0){q=n+300|0;c[o>>2]=c[q>>2];c[q>>2]=o;q=39;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](o);q=39;break}else{q=Ua[c[29352>>2]&127](o)|0;c[14978]=(c[14978]|0)-q;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](o);q=39;break}}while(0);if((q|0)==37){i=c[r>>2]|0;q=38}else if((q|0)==39)c[i>>2]=0;if((q|0)==38){c[r>>2]=i+1;c[b+(i<<4)>>2]=d;c[b+(i<<4)+4>>2]=f;a[b+(i<<4)+8>>0]=g;c[b+(i<<4)+12>>2]=h;return}c[r>>2]=0;b=c[b>>2]|0;i=b+81|0;if(a[i>>0]|0)return;if(a[b+82>>0]|0)return;a[i>>0]=1;if((c[b+180>>2]|0)>0)c[b+264>>2]=1;r=b+272|0;c[r>>2]=(c[r>>2]|0)+1;b=c[b+236>>2]|0;if(!b)return;c[b+12>>2]=7;return}function Gj(f,g){f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;q=b[g+52>>1]|0;r=q&65535;j=b[g+50>>1]|0;s=f+36|0;if(c[s>>2]|0){t=0;return t|0}t=g+55|0;n=c[f>>2]|0;l=r*5|0;k=l+20|0;o=n+272|0;h=(c[o>>2]|0)==0;do if(!((d[t>>0]|d[t+1>>0]<<8)&8)){a:do if(!h)if(!(a[n+81>>0]|0))m=32;else{t=0;return t|0}else{do if(!(0<0|(0==0?(e[n+276>>1]|0)>>>0<k>>>0:0))){i=n+300|0;h=c[i>>2]|0;if(h|0){c[i>>2]=c[h>>2];p=n+284|0;c[p>>2]=(c[p>>2]|0)+1;break a}i=n+296|0;h=c[i>>2]|0;if(!h){h=n+292|0;break}else{c[i>>2]=c[h>>2];p=n+284|0;c[p>>2]=(c[p>>2]|0)+1;break a}}else h=n+288|0;while(0);c[h>>2]=(c[h>>2]|0)+1;m=32}while(0);if((m|0)==32)h=Yd(n,k,0)|0;if(h|0){c[h+16>>2]=h+20+(r<<2);b[h+6>>1]=q;b[h+8>>1]=q;a[h+4>>0]=a[n+78>>0]|0;c[h+12>>2]=n;c[h>>2]=1;ew(h+24|0,0,l+-4|0)|0;p=h;o=h;break}i=n+81|0;if((a[i>>0]|0)==0?(a[n+82>>0]|0)==0:0){a[i>>0]=1;if((c[n+180>>2]|0)>0)c[n+264>>2]=1;c[o>>2]=(c[o>>2]|0)+1;i=c[n+236>>2]|0;if(i){c[i+12>>2]=7;m=41}else m=41}else m=41}else{b:do if(!h)if(!(a[n+81>>0]|0))m=13;else{t=0;return t|0}else{do if(!(0<0|(0==0?(e[n+276>>1]|0)>>>0<k>>>0:0))){i=n+300|0;h=c[i>>2]|0;if(h|0){c[i>>2]=c[h>>2];p=n+284|0;c[p>>2]=(c[p>>2]|0)+1;break b}i=n+296|0;h=c[i>>2]|0;if(!h){h=n+292|0;break}else{c[i>>2]=c[h>>2];p=n+284|0;c[p>>2]=(c[p>>2]|0)+1;break b}}else h=n+288|0;while(0);c[h>>2]=(c[h>>2]|0)+1;m=13}while(0);if((m|0)==13)h=Yd(n,k,0)|0;if(h|0){c[h+16>>2]=h+20+(r<<2);b[h+6>>1]=j;b[h+8>>1]=q;a[h+4>>0]=a[n+78>>0]|0;c[h+12>>2]=n;c[h>>2]=1;ew(h+24|0,0,l+-4|0)|0;p=h;o=h;break}i=n+81|0;if((a[i>>0]|0)==0?(a[n+82>>0]|0)==0:0){a[i>>0]=1;if((c[n+180>>2]|0)>0)c[n+264>>2]=1;c[o>>2]=(c[o>>2]|0)+1;i=c[n+236>>2]|0;if(i){c[i+12>>2]=7;m=41}else m=41}else m=41}while(0);if((m|0)==41)if(!h){t=0;return t|0}else{p=h;o=0}if(q<<16>>16){n=g+32|0;l=g+28|0;m=p+16|0;k=0;do{i=c[(c[n>>2]|0)+(k<<2)>>2]|0;do if((i|0)!=34049){h=c[f>>2]|0;j=a[h+78>>0]|0;g=a[h+165>>0]|0;h=Xi(h,j,i,g&255)|0;if(!(g<<24>>24)){if(!h){h=Yi(f,j,0,i)|0;break}if(!(c[h+12>>2]|0))h=Yi(f,j,h,i)|0}}else h=0;while(0);c[p+20+(k<<2)>>2]=h;a[(c[m>>2]|0)+k>>0]=a[(c[l>>2]|0)+k>>0]|0;k=k+1|0}while((k|0)!=(r|0))}if(!(c[s>>2]|0)){t=p;return t|0}h=d[t>>0]|d[t+1>>0]<<8;if(!(h&256)){s=h|256;a[t>>0]=s;a[t+1>>0]=s>>8;c[f+12>>2]=513}t=(c[p>>2]|0)+-1|0;c[p>>2]=t;if(t|0){t=0;return t|0}h=c[p+12>>2]|0;if(h|0){if(c[h+480>>2]|0){Vd(h,o);t=0;return t|0}t=p;if((c[h+304>>2]|0)>>>0<=t>>>0?(c[h+308>>2]|0)>>>0>t>>>0:0){t=h+300|0;c[p>>2]=c[t>>2];c[t>>2]=o;t=0;return t|0}}if(!(c[7324]|0)){_a[c[29344>>2]&127](o);t=0;return t|0}else{t=Ua[c[29352>>2]&127](o)|0;c[14978]=(c[14978]|0)-t;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](o);t=0;return t|0}return 0}function Hj(f,i,j){f=f|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0;Z=Qa;Qa=Qa+208|0;m=Z+80|0;l=Z+72|0;s=Z+64|0;n=Z+56|0;t=Z+48|0;p=Z+40|0;w=Z+32|0;S=Z;R=Z+144|0;T=Z+140|0;W=Z+136|0;E=Z+84|0;M=f+8|0;Y=c[M>>2]|0;c[T>>2]=0;c[W>>2]=0;if(!Y){j=0;Qa=Z;return j|0}Q=i;a:while(1){if(!Q)v=114;else v=d[Q>>0]|0;u=v&255;switch(u<<24>>24){case -92:{X=6;break a}case -94:{X=12;break a}case -109:{X=36;break a}case -97:{X=37;break a}case -111:{X=40;break a}case 110:{X=80;break a}case 114:{X=87;break a}case -110:{X=90;break a}case -108:{X=127;break a}case -88:{X=138;break a}case 36:{X=139;break a}case -96:case 45:{X=157;break a}case 53:case 52:case 57:case 54:case 55:case 56:{l=0;k=v;X=158;break a}case 105:case 99:case 98:case 103:case 97:case 96:case 104:case 101:case 102:case 100:case 43:case 44:{X=228;break a}case -91:{X=231;break a}case 19:case 107:{X=276;break a}case -89:{X=279;break a}case 51:case 50:{X=284;break a}case -93:{X=296;break a}case -95:{X=299;break a}case -125:case 20:{X=420;break a}case -86:{X=424;break a}case 49:{X=436;break a}case 48:{X=451;break a}case 77:{X=453;break a}case -87:{X=461;break a}case -85:{X=462;break a}case 71:{X=542;break a}case -90:case 106:case -83:break;default:{X=469;break a}}Q=c[Q+12>>2]|0}b:switch(X|0){case 6:{i=c[Q+40>>2]|0;k=c[i+28>>2]|0;l=b[Q+34>>1]|0;if(!(a[i>>0]|0)){j=c[k+(l*24|0)+16>>2]|0;Qa=Z;return j|0}if(a[i+1>>0]|0){m=c[i+8>>2]|0;i=c[k+(l*24|0)+12>>2]|0;k=Y+108|0;l=c[k>>2]|0;if((c[Y+112>>2]|0)>(l|0)){c[k>>2]=l+1;Y=c[Y+104>>2]|0;a[Y+(l*20|0)>>0]=90;b[Y+(l*20|0)+2>>1]=0;c[Y+(l*20|0)+4>>2]=m;c[Y+(l*20|0)+8>>2]=i;c[Y+(l*20|0)+12>>2]=j;c[Y+(l*20|0)+16>>2]=0;a[Y+(l*20|0)+1>>0]=0;Qa=Z;return j|0}else{Bi(Y,90,m,i,j)|0;Qa=Z;return j|0}}else X=12;break}case 36:{Ij(f,Q,0,j);Qa=Z;return j|0}case 37:{i=(a[(c[Q+8>>2]|0)+4>>0]|0)==0&1;k=Y+108|0;l=c[k>>2]|0;if((c[Y+112>>2]|0)>(l|0)){c[k>>2]=l+1;Y=c[Y+104>>2]|0;a[Y+(l*20|0)>>0]=70;b[Y+(l*20|0)+2>>1]=0;c[Y+(l*20|0)+4>>2]=i;c[Y+(l*20|0)+8>>2]=j;c[Y+(l*20|0)+12>>2]=0;c[Y+(l*20|0)+16>>2]=0;a[Y+(l*20|0)+1>>0]=0;Qa=Z;return j|0}else{Bi(Y,70,i,j,0)|0;Qa=Z;return j|0}}case 40:{i=c[Q+8>>2]|0;if(!i){Qa=Z;return j|0}Jg(i,S,(Cu(i)|0)&1073741823,1)|0;l=c[Y>>2]|0;c:do if(c[l+272>>2]|0)if(!(a[l+81>>0]|0))X=51;else X=71;else{do if((e[l+276>>1]|0)>=8){i=l+300|0;k=c[i>>2]|0;if(k|0){c[i>>2]=c[k>>2];X=l+284|0;c[X>>2]=(c[X>>2]|0)+1;X=52;break c}i=l+296|0;k=c[i>>2]|0;if(!k){i=l+292|0;break}else{c[i>>2]=c[k>>2];X=l+284|0;c[X>>2]=(c[X>>2]|0)+1;X=52;break c}}else i=l+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1;X=51}while(0);if((X|0)==51){k=Yd(l,8,0)|0;X=52}do if((X|0)==52)if(k){i=S;W=c[i>>2]|0;i=c[i+4>>2]|0;m=k;f=m;a[f>>0]=W;a[f+1>>0]=W>>8;a[f+2>>0]=W>>16;a[f+3>>0]=W>>24;m=m+4|0;a[m>>0]=i;a[m+1>>0]=i>>8;a[m+2>>0]=i>>16;a[m+3>>0]=i>>24;m=Y+108|0;i=c[m>>2]|0;if((c[Y+112>>2]|0)>(i|0)){c[m>>2]=i+1;f=c[Y+104>>2]|0;a[f+(i*20|0)>>0]=-111;b[f+(i*20|0)+2>>1]=0;c[f+(i*20|0)+4>>2]=0;c[f+(i*20|0)+8>>2]=j;c[f+(i*20|0)+12>>2]=0;c[f+(i*20|0)+16>>2]=0;a[f+(i*20|0)+1>>0]=0}else i=Bi(Y,145,0,j,0)|0;l=c[Y>>2]|0;if(!(a[l+81>>0]|0)){if((i|0)<0)i=(c[m>>2]|0)+-1|0;l=c[Y+104>>2]|0;m=l+(i*20|0)+1|0;if(!(a[m>>0]|0)){c[l+(i*20|0)+16>>2]=k;a[m>>0]=-13;break}else{Ci(Y,l+(i*20|0)|0,k,-13);break}}if(l|0){if(c[l+480>>2]|0){Vd(l,k);break}Y=k;if((c[l+304>>2]|0)>>>0<=Y>>>0?(c[l+308>>2]|0)>>>0>Y>>>0:0){Y=l+300|0;c[k>>2]=c[Y>>2];c[Y>>2]=k;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{Y=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-Y;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}}else X=71;while(0);if((X|0)==71){k=Y+108|0;i=c[k>>2]|0;if((c[Y+112>>2]|0)>(i|0)){c[k>>2]=i+1;f=c[Y+104>>2]|0;a[f+(i*20|0)>>0]=-111;b[f+(i*20|0)+2>>1]=0;c[f+(i*20|0)+4>>2]=0;c[f+(i*20|0)+8>>2]=j;c[f+(i*20|0)+12>>2]=0;c[f+(i*20|0)+16>>2]=0;a[f+(i*20|0)+1>>0]=0}else i=Bi(Y,145,0,j,0)|0;if(!(a[(c[Y>>2]|0)+81>>0]|0)){if((i|0)<0)i=(c[k>>2]|0)+-1|0;k=c[Y+104>>2]|0;if(a[k+(i*20|0)+1>>0]|0)Ci(Y,k+(i*20|0)|0,0,-13)}}Qa=Z;return j|0}case 80:{l=c[Q+8>>2]|0;k=Y+108|0;i=c[k>>2]|0;if((c[Y+112>>2]|0)>(i|0)){c[k>>2]=i+1;f=c[Y+104>>2]|0;a[f+(i*20|0)>>0]=110;b[f+(i*20|0)+2>>1]=0;c[f+(i*20|0)+4>>2]=0;c[f+(i*20|0)+8>>2]=j;c[f+(i*20|0)+12>>2]=0;c[f+(i*20|0)+16>>2]=0;a[f+(i*20|0)+1>>0]=0}else i=Bi(Y,110,0,j,0)|0;if(a[(c[Y>>2]|0)+81>>0]|0){Qa=Z;return j|0}if((i|0)<0)i=(c[k>>2]|0)+-1|0;Ci(Y,(c[Y+104>>2]|0)+(i*20|0)|0,l,0);Qa=Z;return j|0}case 87:{i=Y+108|0;k=c[i>>2]|0;if((c[Y+112>>2]|0)>(k|0)){c[i>>2]=k+1;Y=c[Y+104>>2]|0;a[Y+(k*20|0)>>0]=73;b[Y+(k*20|0)+2>>1]=0;c[Y+(k*20|0)+4>>2]=0;c[Y+(k*20|0)+8>>2]=j;c[Y+(k*20|0)+12>>2]=0;c[Y+(k*20|0)+16>>2]=0;a[Y+(k*20|0)+1>>0]=0;Qa=Z;return j|0}else{Bi(Y,73,0,j,0)|0;Qa=Z;return j|0}}case 90:{q=(c[Q+8>>2]|0)+2|0;p=(Cu(q)|0)&1073741823;r=p+-1|0;k=c[Y>>2]|0;s=(r|0)/2|0;m=s+1|0;n=((m|0)<0)<<31>>31;d:do if(c[k+272>>2]|0)if(!(a[k+81>>0]|0))X=100;else{m=0;n=1}else{do if(!(0<n>>>0|(0==(n|0)?(e[k+276>>1]|0)>>>0<m>>>0:0))){i=k+300|0;l=c[i>>2]|0;if(l|0){c[i>>2]=c[l>>2];X=k+284|0;c[X>>2]=(c[X>>2]|0)+1;X=101;break d}i=k+296|0;l=c[i>>2]|0;if(!l){i=k+292|0;break}else{c[i>>2]=c[l>>2];X=k+284|0;c[X>>2]=(c[X>>2]|0)+1;X=101;break d}}else i=k+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1;X=100}while(0);if((X|0)==100){l=Yd(k,m,n)|0;X=101}if((X|0)==101){k=p+-2|0;if(!l){m=0;n=1}else{if(p>>>0>2){i=0;do{f=a[q+i>>0]|0;X=a[q+(i|1)>>0]|0;a[l+(i>>>1)>>0]=(0-(X>>>6&1)&9)+X&15|(0-(f>>>6&1)&9)+f<<4;i=i+2|0}while((i|0)<(k|0));i=r>>>1}else i=0;a[l+i>>0]=0;m=l;n=0}}l=Y+108|0;i=c[l>>2]|0;if((c[Y+112>>2]|0)>(i|0)){c[l>>2]=i+1;f=c[Y+104>>2]|0;a[f+(i*20|0)>>0]=75;b[f+(i*20|0)+2>>1]=0;c[f+(i*20|0)+4>>2]=s;c[f+(i*20|0)+8>>2]=j;c[f+(i*20|0)+12>>2]=0;c[f+(i*20|0)+16>>2]=0;a[f+(i*20|0)+1>>0]=0}else i=Bi(Y,75,s,j,0)|0;k=c[Y>>2]|0;if(!(a[k+81>>0]|0)){if((i|0)<0)i=(c[l>>2]|0)+-1|0;k=c[Y+104>>2]|0;l=k+(i*20|0)+1|0;if(a[l>>0]|0){Ci(Y,k+(i*20|0)|0,m,-7);Qa=Z;return j|0}if(n){Qa=Z;return j|0}c[k+(i*20|0)+16>>2]=m;a[l>>0]=-7;Qa=Z;return j|0}if(n){Qa=Z;return j|0}if(k|0){if(c[k+480>>2]|0){Vd(k,m);Qa=Z;return j|0}Y=m;if((c[k+304>>2]|0)>>>0<=Y>>>0?(c[k+308>>2]|0)>>>0>Y>>>0:0){Y=k+300|0;c[m>>2]=c[Y>>2];c[Y>>2]=m;Qa=Z;return j|0}}if(!(c[7324]|0)){_a[c[29344>>2]&127](m);Qa=Z;return j|0}else{Y=Ua[c[29352>>2]&127](m)|0;c[14978]=(c[14978]|0)-Y;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](m);Qa=Z;return j|0}}case 127:{l=Q+32|0;i=b[l>>1]|0;n=Y+108|0;k=c[n>>2]|0;if((c[Y+112>>2]|0)>(k|0)){c[n>>2]=k+1;X=c[Y+104>>2]|0;a[X+(k*20|0)>>0]=76;b[X+(k*20|0)+2>>1]=0;c[X+(k*20|0)+4>>2]=i;c[X+(k*20|0)+8>>2]=j;c[X+(k*20|0)+12>>2]=0;c[X+(k*20|0)+16>>2]=0;a[X+(k*20|0)+1>>0]=0}else Bi(Y,76,i,j,0)|0;if(!(a[(c[Q+8>>2]|0)+1>>0]|0)){Qa=Z;return j|0}m=c[f+216>>2]|0;k=b[l>>1]|0;e:do if(!m)i=0;else{l=c[m+4>>2]|0;i=2;while(1){if((c[m+(i<<2)>>2]|0)==(k|0))break;i=(c[m+(i+1<<2)>>2]|0)+i|0;if((i|0)>=(l|0)){i=0;break e}}i=m+(i+2<<2)|0}while(0);c[m>>2]=0;if(a[(c[Y>>2]|0)+81>>0]|0){Qa=Z;return j|0}f=c[Y+104>>2]|0;Y=(c[n>>2]|0)+-1|0;a[f+(Y*20|0)+1>>0]=-1;c[f+(Y*20|0)+16>>2]=i;Qa=Z;return j|0}case 138:{j=c[Q+28>>2]|0;Qa=Z;return j|0}case 139:{i=Hj(f,c[Q+12>>2]|0,j)|0;do if((i|0)!=(j|0)){k=Y+108|0;l=c[k>>2]|0;if((c[Y+112>>2]|0)>(l|0)){c[k>>2]=l+1;f=c[Y+104>>2]|0;a[f+(l*20|0)>>0]=79;b[f+(l*20|0)+2>>1]=0;c[f+(l*20|0)+4>>2]=i;c[f+(l*20|0)+8>>2]=j;c[f+(l*20|0)+12>>2]=0;c[f+(l*20|0)+16>>2]=0;a[f+(l*20|0)+1>>0]=0;break}else{Bi(Y,79,i,j,0)|0;break}}while(0);k=c[Q+8>>2]|0;l=a[k>>0]|0;f:do if(!(l<<24>>24))i=67;else{i=67;m=0;do{m=m<<8|d[208+(l&255)>>0];k=k+1|0;g:do if((m|0)<1685026146){if((m|0)<1667785074){switch(m|0){case 1651273570:break;default:{X=152;break g}}switch(i<<24>>24){case 69:case 67:{i=65;break g}default:{X=151;break g}}}if((m|0)<1668050786)switch(m|0){case 1667785074:{i=66;break g}default:{X=152;break g}}else switch(m|0){case 1668050786:{i=66;break g}default:{X=152;break g}}}else{if((m|0)>=1919246700){if((m|0)>=1952807028)switch(m|0){case 1952807028:{i=66;break g}default:{X=152;break g}}switch(m|0){case 1919246700:break;default:{X=152;break g}}if(i<<24>>24==67){i=69;break}else{X=151;break}}if((m|0)<1718382433){switch(m|0){case 1685026146:break;default:{X=152;break g}}if(i<<24>>24==67){i=69;break}}else{switch(m|0){case 1718382433:break;default:{X=152;break g}}if(i<<24>>24==67){i=69;break}}}while(0);if((X|0)==151)X=0;else if((X|0)==152){X=0;if((m&16777215|0)==6909556){i=68;break f}}l=a[k>>0]|0}while(l<<24>>24!=0)}while(0);i=i<<24>>24;k=Y+108|0;l=c[k>>2]|0;if((c[Y+112>>2]|0)>(l|0)){c[k>>2]=l+1;Y=c[Y+104>>2]|0;a[Y+(l*20|0)>>0]=85;b[Y+(l*20|0)+2>>1]=0;c[Y+(l*20|0)+4>>2]=j;c[Y+(l*20|0)+8>>2]=i;c[Y+(l*20|0)+12>>2]=0;c[Y+(l*20|0)+16>>2]=0;a[Y+(l*20|0)+1>>0]=0;Qa=Z;return j|0}else{Bi(Y,85,j,i,0)|0;Qa=Z;return j|0}}case 157:{l=128;k=(v|0)==45?53:52;X=158;break}case 228:{m=Jj(f,c[Q+12>>2]|0,T)|0;i=Jj(f,c[Q+16>>2]|0,W)|0;k=Y+108|0;l=c[k>>2]|0;if((c[Y+112>>2]|0)>(l|0)){c[k>>2]=l+1;Y=c[Y+104>>2]|0;a[Y+(l*20|0)>>0]=u;b[Y+(l*20|0)+2>>1]=0;c[Y+(l*20|0)+4>>2]=i;c[Y+(l*20|0)+8>>2]=m;c[Y+(l*20|0)+12>>2]=j;c[Y+(l*20|0)+16>>2]=0;a[Y+(l*20|0)+1>>0]=0;m=j;break}else{Bi(Y,v,i,m,j)|0;m=j;break}}case 231:{k=Q+12|0;i=c[k>>2]|0;switch(a[i>>0]|0){case -109:{Ij(f,i,1,j);Qa=Z;return j|0}case -111:{i=c[i+8>>2]|0;if(!i){Qa=Z;return j|0}Jg(i,S,(Cu(i)|0)&1073741823,1)|0;o=-+g[S>>3];g[S>>3]=o;l=c[Y>>2]|0;h:do if(c[l+272>>2]|0)if(!(a[l+81>>0]|0))X=244;else X=264;else{do if((e[l+276>>1]|0)>=8){i=l+300|0;k=c[i>>2]|0;if(k|0){c[i>>2]=c[k>>2];X=l+284|0;c[X>>2]=(c[X>>2]|0)+1;X=245;break h}i=l+296|0;k=c[i>>2]|0;if(!k){i=l+292|0;break}else{c[i>>2]=c[k>>2];X=l+284|0;c[X>>2]=(c[X>>2]|0)+1;X=245;break h}}else i=l+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1;X=244}while(0);if((X|0)==244){k=Yd(l,8,0)|0;X=245}do if((X|0)==245)if(k){g[h>>3]=o;a[k>>0]=a[h>>0];a[k+1>>0]=a[h+1>>0];a[k+2>>0]=a[h+2>>0];a[k+3>>0]=a[h+3>>0];a[k+4>>0]=a[h+4>>0];a[k+5>>0]=a[h+5>>0];a[k+6>>0]=a[h+6>>0];a[k+7>>0]=a[h+7>>0];m=Y+108|0;i=c[m>>2]|0;if((c[Y+112>>2]|0)>(i|0)){c[m>>2]=i+1;f=c[Y+104>>2]|0;a[f+(i*20|0)>>0]=-111;b[f+(i*20|0)+2>>1]=0;c[f+(i*20|0)+4>>2]=0;c[f+(i*20|0)+8>>2]=j;c[f+(i*20|0)+12>>2]=0;c[f+(i*20|0)+16>>2]=0;a[f+(i*20|0)+1>>0]=0}else i=Bi(Y,145,0,j,0)|0;l=c[Y>>2]|0;if(!(a[l+81>>0]|0)){if((i|0)<0)i=(c[m>>2]|0)+-1|0;l=c[Y+104>>2]|0;m=l+(i*20|0)+1|0;if(!(a[m>>0]|0)){c[l+(i*20|0)+16>>2]=k;a[m>>0]=-13;break}else{Ci(Y,l+(i*20|0)|0,k,-13);break}}if(l|0){if(c[l+480>>2]|0){Vd(l,k);break}Y=k;if((c[l+304>>2]|0)>>>0<=Y>>>0?(c[l+308>>2]|0)>>>0>Y>>>0:0){Y=l+300|0;c[k>>2]=c[Y>>2];c[Y>>2]=k;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{Y=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-Y;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}}else X=264;while(0);if((X|0)==264){k=Y+108|0;i=c[k>>2]|0;if((c[Y+112>>2]|0)>(i|0)){c[k>>2]=i+1;f=c[Y+104>>2]|0;a[f+(i*20|0)>>0]=-111;b[f+(i*20|0)+2>>1]=0;c[f+(i*20|0)+4>>2]=0;c[f+(i*20|0)+8>>2]=j;c[f+(i*20|0)+12>>2]=0;c[f+(i*20|0)+16>>2]=0;a[f+(i*20|0)+1>>0]=0}else i=Bi(Y,145,0,j,0)|0;if(!(a[(c[Y>>2]|0)+81>>0]|0)){if((i|0)<0)i=(c[k>>2]|0)+-1|0;k=c[Y+104>>2]|0;if(a[k+(i*20|0)+1>>0]|0)Ci(Y,k+(i*20|0)|0,0,-13)}}Qa=Z;return j|0}default:{a[E>>0]=-109;c[E+4>>2]=17408;c[E+8>>2]=0;m=Jj(f,E,T)|0;i=Jj(f,c[k>>2]|0,W)|0;k=Y+108|0;l=c[k>>2]|0;if((c[Y+112>>2]|0)>(l|0)){c[k>>2]=l+1;Y=c[Y+104>>2]|0;a[Y+(l*20|0)>>0]=101;b[Y+(l*20|0)+2>>1]=0;c[Y+(l*20|0)+4>>2]=i;c[Y+(l*20|0)+8>>2]=m;c[Y+(l*20|0)+12>>2]=j;c[Y+(l*20|0)+16>>2]=0;a[Y+(l*20|0)+1>>0]=0;m=j;break b}else{Bi(Y,101,i,m,j)|0;m=j;break b}}}}case 276:{i=Jj(f,c[Q+12>>2]|0,T)|0;k=Y+108|0;l=c[k>>2]|0;if((c[Y+112>>2]|0)>(l|0)){c[k>>2]=l+1;m=c[Y+104>>2]|0;a[m+(l*20|0)>>0]=u;b[m+(l*20|0)+2>>1]=0;c[m+(l*20|0)+4>>2]=i;c[m+(l*20|0)+8>>2]=j;c[m+(l*20|0)+12>>2]=0;c[m+(l*20|0)+16>>2]=0;a[m+(l*20|0)+1>>0]=0;m=j;break}else{Bi(Y,v,i,j,0)|0;m=j;break}}case 279:{l=Jj(f,c[Q+12>>2]|0,T)|0;n=(a[(c[(c[Q+16>>2]|0)+8>>2]|0)+4>>0]|0)==0;m=(n^1)&1;n=(n^(a[Q+38>>0]|0)==45)&1;k=Y+108|0;i=c[k>>2]|0;if((c[Y+112>>2]|0)>(i|0)){c[k>>2]=i+1;S=c[Y+104>>2]|0;a[S+(i*20|0)>>0]=88;b[S+(i*20|0)+2>>1]=0;c[S+(i*20|0)+4>>2]=l;c[S+(i*20|0)+8>>2]=j;c[S+(i*20|0)+12>>2]=m;c[S+(i*20|0)+16>>2]=0;a[S+(i*20|0)+1>>0]=0}else i=Bi(Y,88,l,j,m)|0;if(!(a[(c[Y>>2]|0)+81>>0]|0)){m=c[Y+104>>2]|0;a[m+(i*20|0)+1>>0]=-3;c[m+(i*20|0)+16>>2]=n;m=j}else m=j;break}case 284:{k=Y+108|0;i=c[k>>2]|0;m=Y+112|0;if((c[m>>2]|0)>(i|0)){c[k>>2]=i+1;S=c[Y+104>>2]|0;a[S+(i*20|0)>>0]=70;b[S+(i*20|0)+2>>1]=0;c[S+(i*20|0)+4>>2]=1;c[S+(i*20|0)+8>>2]=j;c[S+(i*20|0)+12>>2]=0;c[S+(i*20|0)+16>>2]=0;a[S+(i*20|0)+1>>0]=0}else Bi(Y,70,1,j,0)|0;i=Jj(f,c[Q+12>>2]|0,T)|0;l=c[k>>2]|0;if((c[m>>2]|0)>(l|0)){c[k>>2]=l+1;S=c[Y+104>>2]|0;a[S+(l*20|0)>>0]=u;b[S+(l*20|0)+2>>1]=0;c[S+(l*20|0)+4>>2]=i;c[S+(l*20|0)+8>>2]=0;c[S+(l*20|0)+12>>2]=0;c[S+(l*20|0)+16>>2]=0;a[S+(l*20|0)+1>>0]=0}else l=Bi(Y,v,i,0,0)|0;i=c[k>>2]|0;if((c[m>>2]|0)>(i|0)){c[k>>2]=i+1;S=c[Y+104>>2]|0;a[S+(i*20|0)>>0]=70;b[S+(i*20|0)+2>>1]=0;c[S+(i*20|0)+4>>2]=0;c[S+(i*20|0)+8>>2]=j;c[S+(i*20|0)+12>>2]=0;c[S+(i*20|0)+16>>2]=0;a[S+(i*20|0)+1>>0]=0}else Bi(Y,70,0,j,0)|0;k=c[k>>2]|0;if(!(a[(c[Y>>2]|0)+81>>0]|0))i=(c[Y+104>>2]|0)+(((l|0)<0?k+-1|0:l)*20|0)|0;else i=59308;c[i+8>>2]=k;m=j;break}case 296:{i=c[Q+40>>2]|0;if(!i){c[p>>2]=c[Q+8>>2];ad(f,38820,p);m=j;break}j=c[(c[i+40>>2]|0)+(b[Q+34>>1]<<4)+8>>2]|0;Qa=Z;return j|0}case 299:{x=c[f>>2]|0;k=a[x+78>>0]|0;w=Q+4|0;i=c[w>>2]|0;if(i&16777216|0){j=c[(c[Q+44>>2]|0)+52>>2]|0;Qa=Z;return j|0}do if(a[f+23>>0]|0){R=S+20|0;a[R>>0]=2;c[S+4>>2]=127;c[S+8>>2]=128;c[S+24>>2]=0;Yj(S,Q)|0;if(!(a[R>>0]|0)){i=c[w>>2]|0;break}j=Lj(f,Q,-1)|0;Qa=Z;return j|0}while(0);if((i&16384|0)==0?(r=c[Q+20>>2]|0,(r|0)!=0):0){A=r;B=c[r>>2]|0;s=1}else{A=0;B=0;s=0}i=c[Q+8>>2]|0;v=Hd(x,i,B,k,0)|0;if(v|0?(c[v+20>>2]|0)==0:0){t=v+4|0;i=c[t>>2]|0;if(i&512|0){i=f+56|0;t=c[i>>2]|0;s=t+-1|0;c[i>>2]=s;i=c[A+4>>2]|0;do if(i){if((a[i>>0]|0)!=-88){z=Hj(f,i,j)|0;X=319;break}m=c[M>>2]|0;i=c[i+28>>2]|0;k=m+108|0;l=c[k>>2]|0;if((c[m+112>>2]|0)>(l|0)){c[k>>2]=l+1;S=c[m+104>>2]|0;a[S+(l*20|0)>>0]=78;b[S+(l*20|0)+2>>1]=0;c[S+(l*20|0)+4>>2]=i;c[S+(l*20|0)+8>>2]=j;c[S+(l*20|0)+12>>2]=0;c[S+(l*20|0)+16>>2]=0;a[S+(l*20|0)+1>>0]=0;break}else{Bi(m,78,i,j,0)|0;break}}else{z=Hj(f,0,j)|0;X=319}while(0);do if(((X|0)==319?(z|0)!=(j|0):0)?(y=c[M>>2]|0,y|0):0){i=y+108|0;k=c[i>>2]|0;if((c[y+112>>2]|0)>(k|0)){c[i>>2]=k+1;S=c[y+104>>2]|0;a[S+(k*20|0)>>0]=79;b[S+(k*20|0)+2>>1]=0;c[S+(k*20|0)+4>>2]=z;c[S+(k*20|0)+8>>2]=j;c[S+(k*20|0)+12>>2]=0;c[S+(k*20|0)+16>>2]=0;a[S+(k*20|0)+1>>0]=0;break}else{Bi(y,79,z,j,0)|0;break}}while(0);if((B|0)>1){p=Y+108|0;q=Y+112|0;r=Y+104|0;n=1;do{i=c[p>>2]|0;if((c[q>>2]|0)>(i|0)){c[p>>2]=i+1;S=c[r>>2]|0;a[S+(i*20|0)>>0]=51;b[S+(i*20|0)+2>>1]=0;c[S+(i*20|0)+4>>2]=j;c[S+(i*20|0)+8>>2]=s;c[S+(i*20|0)+12>>2]=0;c[S+(i*20|0)+16>>2]=0;a[S+(i*20|0)+1>>0]=0}else Bi(Y,51,j,s,0)|0;i=c[A+4+(n*20|0)>>2]|0;do if(i){if((a[i>>0]|0)!=-88){D=Hj(f,i,j)|0;X=336;break}m=c[M>>2]|0;i=c[i+28>>2]|0;k=m+108|0;l=c[k>>2]|0;if((c[m+112>>2]|0)>(l|0)){c[k>>2]=l+1;S=c[m+104>>2]|0;a[S+(l*20|0)>>0]=78;b[S+(l*20|0)+2>>1]=0;c[S+(l*20|0)+4>>2]=i;c[S+(l*20|0)+8>>2]=j;c[S+(l*20|0)+12>>2]=0;c[S+(l*20|0)+16>>2]=0;a[S+(l*20|0)+1>>0]=0;break}else{Bi(m,78,i,j,0)|0;break}}else{D=Hj(f,0,j)|0;X=336}while(0);do if(((X|0)==336?(X=0,(D|0)!=(j|0)):0)?(C=c[M>>2]|0,C|0):0){i=C+108|0;k=c[i>>2]|0;if((c[C+112>>2]|0)>(k|0)){c[i>>2]=k+1;S=c[C+104>>2]|0;a[S+(k*20|0)>>0]=79;b[S+(k*20|0)+2>>1]=0;c[S+(k*20|0)+4>>2]=D;c[S+(k*20|0)+8>>2]=j;c[S+(k*20|0)+12>>2]=0;c[S+(k*20|0)+16>>2]=0;a[S+(k*20|0)+1>>0]=0;break}else{Bi(C,79,D,j,0)|0;break}}while(0);n=n+1|0}while((n|0)!=(B|0))}k=c[Y+12>>2]|0;i=0-t|0;if(((c[k+56>>2]|0)+(c[k+60>>2]|0)|0)<0){kk(k,Y,i);m=j;break}else{c[(c[k+64>>2]|0)+(i<<2)>>2]=c[Y+108>>2];m=j;break}}if(i&1024|0){j=Hj(f,c[A+4>>2]|0,j)|0;Qa=Z;return j|0}if((B|0)>0){m=S+20|0;p=S+4|0;q=S+8|0;r=S+24|0;i=0;n=0;l=0;do{if(l>>>0<32){k=c[A+4+(l*20|0)>>2]|0;a[m>>0]=1;c[p>>2]=127;c[q>>2]=128;c[r>>2]=0;if(!k)k=1<<l;else{Yj(S,k)|0;k=(a[m>>0]|0)==0?0:1<<l}i=k|i}if(!((n|0)!=0|(c[t>>2]&32|0)==0))n=Wi(f,c[A+4+(l*20|0)>>2]|0)|0;l=l+1|0}while((l|0)!=(B|0));u=i}else{u=0;n=0}if(s){do if(!u)if((B|0)==1){i=f+19|0;k=a[i>>0]|0;if(!(k<<24>>24)){W=f+44|0;l=(c[W>>2]|0)+1|0;c[W>>2]=l;break}else{l=k+-1<<24>>24;a[i>>0]=l;l=c[f+148+((l&255)<<2)>>2]|0;break}}else{i=f+32|0;l=c[i>>2]|0;k=f+28|0;m=c[k>>2]|0;if((m|0)<(B|0)){W=f+44|0;l=c[W>>2]|0;c[W>>2]=l+B;l=l+1|0;break}else{c[i>>2]=l+B;c[k>>2]=m-B;break}}else{W=f+44|0;l=c[W>>2]|0;c[W>>2]=l+B;l=l+1|0}while(0);i=c[t>>2]&192;i:do if(i|0){k=c[A+4>>2]|0;switch(a[k>>0]|0){case -92:case -94:break;default:break i}a[k+38>>0]=i}while(0);Mj(f,A,l,0,3);r=l}else r=0;if((B|0)>1)if(!(c[w>>2]&128))X=375;else{i=A+24|0;X=376}else if((B|0)==1)X=375;else q=v;if((X|0)==375){i=A+4|0;X=376}if((X|0)==376)q=Nj(x,v,B,c[i>>2]|0)|0;do if(c[q+4>>2]&32){if(!n)n=c[x+8>>2]|0;p=Y+108|0;i=c[p>>2]|0;k=Y+112|0;if((c[k>>2]|0)>(i|0)){c[p>>2]=i+1;l=c[Y+104>>2]|0;a[l+(i*20|0)>>0]=82;l=l+(i*20|0)+1|0;m=l+19|0;do{a[l>>0]=0;l=l+1|0}while((l|0)<(m|0))}else i=Bi(Y,82,0,0,0)|0;if(!(a[(c[Y>>2]|0)+81>>0]|0)){if((i|0)<0)i=(c[p>>2]|0)+-1|0;l=c[Y+104>>2]|0;m=l+(i*20|0)+1|0;if(a[m>>0]|0){Ci(Y,l+(i*20|0)|0,n,-2);break}if(!n)break;c[l+(i*20|0)+16>>2]=n;a[m>>0]=-2}}else{p=Y+108|0;k=Y+112|0}while(0);l=(c[f+52>>2]|0)==0?63:62;i=c[p>>2]|0;if((c[k>>2]|0)>(i|0)){c[p>>2]=i+1;X=c[Y+104>>2]|0;a[X+(i*20|0)>>0]=l;b[X+(i*20|0)+2>>1]=0;c[X+(i*20|0)+4>>2]=u;c[X+(i*20|0)+8>>2]=r;c[X+(i*20|0)+12>>2]=j;c[X+(i*20|0)+16>>2]=0;a[X+(i*20|0)+1>>0]=0}else i=Bi(Y,l,u,r,j)|0;k=c[Y>>2]|0;j:do if(!(a[k+81>>0]|0)){if((i|0)<0)i=(c[p>>2]|0)+-1|0;k=c[Y+104>>2]|0;l=k+(i*20|0)+1|0;if(a[l>>0]|0){Ci(Y,k+(i*20|0)|0,q,-8);break}if(q|0){c[k+(i*20|0)+16>>2]=q;a[l>>0]=-8}}else if(c[q+4>>2]&16|0){do if(k|0){if(c[k+480>>2]|0){Vd(k,q);break j}i=q;if((c[k+304>>2]|0)>>>0>i>>>0)break;if((c[k+308>>2]|0)>>>0<=i>>>0)break;X=k+300|0;c[q>>2]=c[X>>2];c[X>>2]=q;break j}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](q);break}else{X=Ua[c[29352>>2]&127](q)|0;c[14978]=(c[14978]|0)-X;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](q);break}}while(0);i=c[p>>2]|0;if((i|0)>0)b[(c[Y+104>>2]|0)+((i+-1|0)*20|0)+2>>1]=B&255;if(!((B|0)!=0&(u|0)==0)){Qa=Z;return j|0}if((B|0)!=1){i=f+28|0;if((c[i>>2]|0)>=(B|0)){Qa=Z;return j|0}c[i>>2]=B;c[f+32>>2]=r;Qa=Z;return j|0}if(!r){Qa=Z;return j|0}i=f+19|0;k=a[i>>0]|0;if((k&255)>=8){Qa=Z;return j|0}a[i>>0]=k+1<<24>>24;c[f+148+((k&255)<<2)>>2]=r;Qa=Z;return j|0}c[t>>2]=i;ad(f,38846,t);m=j;break}case 420:{if((v|0)==131?(k=c[c[c[Q+20>>2]>>2]>>2]|0,(k|0)!=1):0){c[n>>2]=k;c[n+4>>2]=1;ad(f,39001,n);m=j;break}j=Oj(f,Q)|0;Qa=Z;return j|0}case 424:{m=Q+12|0;i=c[m>>2]|0;if(!(c[i+28>>2]|0)){j=Oj(f,i)|0;i=c[m>>2]|0;c[i+28>>2]=j}l=c[Q+28>>2]|0;if(l){k=a[i>>0]|0;if(k<<24>>24==-88)k=a[i+38>>0]|0;switch(k<<24>>24){case -87:{k=i+20|0;X=432;break}case -125:{k=c[i+20>>2]|0;X=432;break}default:k=1}if((X|0)==432)k=c[c[k>>2]>>2]|0;if((l|0)!=(k|0)){c[s>>2]=l;c[s+4>>2]=k;ad(f,38869,s);i=c[m>>2]|0}}j=(c[i+28>>2]|0)+(b[Q+32>>1]|0)|0;Qa=Z;return j|0}case 436:{p=f+56|0;n=c[p>>2]|0;i=n+-2|0;c[p>>2]=i;p=Y+108|0;k=c[p>>2]|0;m=Y+112|0;if((c[m>>2]|0)>(k|0)){c[p>>2]=k+1;X=c[Y+104>>2]|0;a[X+(k*20|0)>>0]=73;b[X+(k*20|0)+2>>1]=0;c[X+(k*20|0)+4>>2]=0;c[X+(k*20|0)+8>>2]=j;c[X+(k*20|0)+12>>2]=0;c[X+(k*20|0)+16>>2]=0;a[X+(k*20|0)+1>>0]=0}else Bi(Y,73,0,j,0)|0;Pj(f,Q,n+-1|0,i);i=c[p>>2]|0;if((c[m>>2]|0)>(i|0)){c[p>>2]=i+1;f=c[Y+104>>2]|0;a[f+(i*20|0)>>0]=70;b[f+(i*20|0)+2>>1]=0;c[f+(i*20|0)+4>>2]=1;c[f+(i*20|0)+8>>2]=j;c[f+(i*20|0)+12>>2]=0;c[f+(i*20|0)+16>>2]=0;a[f+(i*20|0)+1>>0]=0}else Bi(Y,70,1,j,0)|0;l=Y+12|0;i=c[l>>2]|0;k=0-n|0;if(((c[i+56>>2]|0)+(c[i+60>>2]|0)|0)<0)kk(i,Y,k);else c[(c[i+64>>2]|0)+(k<<2)>>2]=c[p>>2];i=c[p>>2]|0;if((c[m>>2]|0)>(i|0)){c[p>>2]=i+1;f=c[Y+104>>2]|0;a[f+(i*20|0)>>0]=83;b[f+(i*20|0)+2>>1]=0;c[f+(i*20|0)+4>>2]=j;c[f+(i*20|0)+8>>2]=0;c[f+(i*20|0)+12>>2]=0;c[f+(i*20|0)+16>>2]=0;a[f+(i*20|0)+1>>0]=0}else Bi(Y,83,j,0,0)|0;k=c[l>>2]|0;i=1-n|0;if(((c[k+56>>2]|0)+(c[k+60>>2]|0)|0)<0){kk(k,Y,i);Qa=Z;return j|0}else{c[(c[k+64>>2]|0)+(i<<2)>>2]=c[p>>2];Qa=Z;return j|0}}case 451:{Qj(f,c[Q+12>>2]|0,c[Q+20>>2]|0,j,0,0);Qa=Z;return j|0}case 453:{m=c[Q+44>>2]|0;k=G((b[m+42>>1]|0)+1|0,c[Q+28>>2]|0)|0;i=Q+32|0;k=(b[i>>1]|0)+1+k|0;n=Y+108|0;l=c[n>>2]|0;p=Y+112|0;if((c[p>>2]|0)>(l|0)){c[n>>2]=l+1;S=c[Y+104>>2]|0;a[S+(l*20|0)>>0]=-107;b[S+(l*20|0)+2>>1]=0;c[S+(l*20|0)+4>>2]=k;c[S+(l*20|0)+8>>2]=j;c[S+(l*20|0)+12>>2]=0;c[S+(l*20|0)+16>>2]=0;a[S+(l*20|0)+1>>0]=0}else Bi(Y,149,k,j,0)|0;S=b[i>>1]|0;if(S<<16>>16>-1?(a[(c[m+4>>2]|0)+(S<<16>>16<<4)+13>>0]|0)==69:0){i=c[n>>2]|0;if((c[p>>2]|0)>(i|0)){c[n>>2]=i+1;m=c[Y+104>>2]|0;a[m+(i*20|0)>>0]=84;b[m+(i*20|0)+2>>1]=0;c[m+(i*20|0)+4>>2]=j;c[m+(i*20|0)+8>>2]=0;c[m+(i*20|0)+12>>2]=0;c[m+(i*20|0)+16>>2]=0;a[m+(i*20|0)+1>>0]=0;m=j;break}else{Bi(Y,84,j,0,0)|0;m=j;break}}else m=j;break}case 461:{ad(f,38899,l);m=j;break}case 462:{i=c[Q+28>>2]|0;l=Y+108|0;k=c[l>>2]|0;if((c[Y+112>>2]|0)>(k|0)){c[l>>2]=k+1;S=c[Y+104>>2]|0;a[S+(k*20|0)>>0]=21;b[S+(k*20|0)+2>>1]=0;c[S+(k*20|0)+4>>2]=i;c[S+(k*20|0)+8>>2]=0;c[S+(k*20|0)+12>>2]=0;c[S+(k*20|0)+16>>2]=0;a[S+(k*20|0)+1>>0]=0}else k=Bi(Y,21,i,0,0)|0;m=Hj(f,c[Q+12>>2]|0,j)|0;i=c[l>>2]|0;if(!(a[(c[Y>>2]|0)+81>>0]|0)){j=(k|0)<0?i+-1|0:k;Y=c[Y+104>>2]|0;c[Y+(j*20|0)+8>>2]=i;i=Y+(j*20|0)|0}else{c[14829]=i;i=59308}c[i+12>>2]=m;break}case 469:{C=c[Q+20>>2]|0;D=c[C>>2]|0;F=f+56|0;I=c[F>>2]|0;H=I+-1|0;c[F>>2]=H;i=c[Q+12>>2]|0;z=(i|0)!=0;if(z){l=E;m=l+52|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(m|0));k=c[i+4>>2]|0;cw(E|0,i|0,((k&16384|0)==0?((k&8192|0)==0?52:28):12)|0)|0;k=a[E>>0]|0;y=E+38|0;switch((k<<24>>24==-88?a[y>>0]|0:k)<<24>>24){case -87:{l=c[E+20>>2]|0;i=l;X=473;break}case -125:{l=c[E+20>>2]|0;i=c[l>>2]|0;X=473;break}default:X=474}k:do if((X|0)==473){x=c[i>>2]|0;if((x|0)!=1){c[T>>2]=0;if(k<<24>>24==-125){i=Oj(f,E)|0;break}Q=f+44|0;P=c[Q>>2]|0;i=P+1|0;c[Q>>2]=P+x;if((x|0)>0){r=E+20|0;s=f+23|0;t=S+20|0;u=S+4|0;v=S+8|0;w=S+24|0;k=0;while(1){l=c[l+4+(k*20|0)>>2]|0;q=k+i|0;do if(!(a[s>>0]|0))if(!l){B=Hj(f,0,q)|0;X=491}else X=485;else{a[t>>0]=2;c[u>>2]=127;c[v>>2]=128;c[w>>2]=0;if(l){Yj(S,l)|0;if(!(a[t>>0]|0)){X=485;break}}Lj(f,l,q)|0}while(0);do if((X|0)==485){X=0;if((a[l>>0]|0)!=-88){B=Hj(f,l,q)|0;X=491;break}p=c[M>>2]|0;l=c[l+28>>2]|0;m=p+108|0;n=c[m>>2]|0;if((c[p+112>>2]|0)>(n|0)){c[m>>2]=n+1;Q=c[p+104>>2]|0;a[Q+(n*20|0)>>0]=78;b[Q+(n*20|0)+2>>1]=0;c[Q+(n*20|0)+4>>2]=l;c[Q+(n*20|0)+8>>2]=q;c[Q+(n*20|0)+12>>2]=0;c[Q+(n*20|0)+16>>2]=0;a[Q+(n*20|0)+1>>0]=0;break}else{Bi(p,78,l,q,0)|0;break}}while(0);do if(((X|0)==491?(X=0,(B|0)!=(q|0)):0)?(A=c[M>>2]|0,A|0):0){l=A+108|0;m=c[l>>2]|0;if((c[A+112>>2]|0)>(m|0)){c[l>>2]=m+1;Q=c[A+104>>2]|0;a[Q+(m*20|0)>>0]=79;b[Q+(m*20|0)+2>>1]=0;c[Q+(m*20|0)+4>>2]=B;c[Q+(m*20|0)+8>>2]=q;c[Q+(m*20|0)+12>>2]=0;c[Q+(m*20|0)+16>>2]=0;a[Q+(m*20|0)+1>>0]=0;break}else{Bi(A,79,B,q,0)|0;break}}while(0);k=k+1|0;if((k|0)==(x|0))break k;l=c[r>>2]|0}}}else X=474}while(0);if((X|0)==474)i=Jj(f,E,T)|0;a[y>>0]=a[E>>0]|0;a[E>>0]=-88;c[E+28>>2]=i;l=E+4|0;c[l>>2]=c[l>>2]&-4097;l=R;m=l+52|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(m|0));a[R>>0]=53;c[R+12>>2]=E;c[T>>2]=0;i=R}else i=0;w=D+-1|0;if((D|0)>1){r=R+16|0;s=Y+108|0;t=Y+112|0;u=Y+104|0;v=Y+12|0;q=0;do{k=c[C+4+(q*20|0)>>2]|0;if(z)c[r>>2]=k;else i=k;p=c[F>>2]|0;k=p+-1|0;c[F>>2]=k;Rj(f,i,k,16);k=c[C+4+((q|1)*20|0)>>2]|0;do if(k){if((a[k>>0]|0)!=-88){K=Hj(f,k,j)|0;X=510;break}n=c[M>>2]|0;k=c[k+28>>2]|0;l=n+108|0;m=c[l>>2]|0;if((c[n+112>>2]|0)>(m|0)){c[l>>2]=m+1;S=c[n+104>>2]|0;a[S+(m*20|0)>>0]=78;b[S+(m*20|0)+2>>1]=0;c[S+(m*20|0)+4>>2]=k;c[S+(m*20|0)+8>>2]=j;c[S+(m*20|0)+12>>2]=0;c[S+(m*20|0)+16>>2]=0;a[S+(m*20|0)+1>>0]=0;break}else{Bi(n,78,k,j,0)|0;break}}else{K=Hj(f,0,j)|0;X=510}while(0);do if(((X|0)==510?(X=0,(K|0)!=(j|0)):0)?(J=c[M>>2]|0,J|0):0){k=J+108|0;l=c[k>>2]|0;if((c[J+112>>2]|0)>(l|0)){c[k>>2]=l+1;S=c[J+104>>2]|0;a[S+(l*20|0)>>0]=79;b[S+(l*20|0)+2>>1]=0;c[S+(l*20|0)+4>>2]=K;c[S+(l*20|0)+8>>2]=j;c[S+(l*20|0)+12>>2]=0;c[S+(l*20|0)+16>>2]=0;a[S+(l*20|0)+1>>0]=0;break}else{Bi(J,79,K,j,0)|0;break}}while(0);k=c[s>>2]|0;if((c[t>>2]|0)>(k|0)){c[s>>2]=k+1;S=c[u>>2]|0;a[S+(k*20|0)>>0]=11;b[S+(k*20|0)+2>>1]=0;c[S+(k*20|0)+4>>2]=0;c[S+(k*20|0)+8>>2]=H;c[S+(k*20|0)+12>>2]=0;c[S+(k*20|0)+16>>2]=0;a[S+(k*20|0)+1>>0]=0}else Bi(Y,11,0,H,0)|0;l=c[v>>2]|0;k=0-p|0;if(((c[l+56>>2]|0)+(c[l+60>>2]|0)|0)<0)kk(l,Y,k);else c[(c[l+64>>2]|0)+(k<<2)>>2]=c[s>>2];q=q+2|0}while((q|0)<(w|0))}l:do if(!(D&1)){i=Y+108|0;k=c[i>>2]|0;if((c[Y+112>>2]|0)>(k|0)){c[i>>2]=k+1;S=c[Y+104>>2]|0;a[S+(k*20|0)>>0]=73;b[S+(k*20|0)+2>>1]=0;c[S+(k*20|0)+4>>2]=0;c[S+(k*20|0)+8>>2]=j;c[S+(k*20|0)+12>>2]=0;c[S+(k*20|0)+16>>2]=0;a[S+(k*20|0)+1>>0]=0;break}else{Bi(Y,73,0,j,0)|0;break}}else{i=c[C+4+(w*20|0)>>2]|0;do if(i){if((a[i>>0]|0)!=-88){l=Hj(f,i,j)|0;break}m=c[M>>2]|0;i=c[i+28>>2]|0;k=m+108|0;l=c[k>>2]|0;if((c[m+112>>2]|0)>(l|0)){c[k>>2]=l+1;S=c[m+104>>2]|0;a[S+(l*20|0)>>0]=78;b[S+(l*20|0)+2>>1]=0;c[S+(l*20|0)+4>>2]=i;c[S+(l*20|0)+8>>2]=j;c[S+(l*20|0)+12>>2]=0;c[S+(l*20|0)+16>>2]=0;a[S+(l*20|0)+1>>0]=0;break l}else{Bi(m,78,i,j,0)|0;break l}}else l=Hj(f,0,j)|0;while(0);if((l|0)!=(j|0)?(L=c[M>>2]|0,L|0):0){i=L+108|0;k=c[i>>2]|0;if((c[L+112>>2]|0)>(k|0)){c[i>>2]=k+1;S=c[L+104>>2]|0;a[S+(k*20|0)>>0]=79;b[S+(k*20|0)+2>>1]=0;c[S+(k*20|0)+4>>2]=l;c[S+(k*20|0)+8>>2]=j;c[S+(k*20|0)+12>>2]=0;c[S+(k*20|0)+16>>2]=0;a[S+(k*20|0)+1>>0]=0;break}else{Bi(L,79,l,j,0)|0;break}}}while(0);k=c[Y+12>>2]|0;i=0-I|0;if(((c[k+56>>2]|0)+(c[k+60>>2]|0)|0)<0)kk(k,Y,i);else c[(c[k+64>>2]|0)+(i<<2)>>2]=c[Y+108>>2];m=j;break}case 542:{if(!(c[f+120>>2]|0)){ad(f,38917,m);j=0;Qa=Z;return j|0}i=a[Q+1>>0]|0;switch(i<<24>>24){case 2:{Y=c[f+116>>2]|0;a[((Y|0)==0?f:Y)+21>>0]=1;break}case 4:{l=c[Q+8>>2]|0;k=Y+108|0;i=c[k>>2]|0;if((c[Y+112>>2]|0)>(i|0)){c[k>>2]=i+1;S=c[Y+104>>2]|0;a[S+(i*20|0)>>0]=69;b[S+(i*20|0)+2>>1]=0;c[S+(i*20|0)+4>>2]=0;c[S+(i*20|0)+8>>2]=4;c[S+(i*20|0)+12>>2]=0;c[S+(i*20|0)+16>>2]=0;a[S+(i*20|0)+1>>0]=0}else i=Bi(Y,69,0,4,0)|0;if(a[(c[Y>>2]|0)+81>>0]|0){m=j;break b}if((i|0)<0)i=(c[k>>2]|0)+-1|0;Ci(Y,(c[Y+104>>2]|0)+(i*20|0)|0,l,0);m=j;break b}default:{}}Sj(f,1811,i<<24>>24,c[Q+8>>2]|0,0,0);m=j;break}}if((X|0)==12){i=c[Q+28>>2]|0;if(!(c[Q+4>>2]&8)){do if((i|0)<0){i=c[f+52>>2]|0;if((i|0)>=0){i=i+-1|0;break}j=(b[Q+32>>1]|0)-i|0;Qa=Z;return j|0}while(0);k=a[Q+38>>0]|0;Tj(Y,c[Q+44>>2]|0,i,b[Q+32>>1]|0,j);if(!(k<<24>>24)){Qa=Z;return j|0}i=c[Y+108>>2]|0;if((i|0)<=0){Qa=Z;return j|0}b[(c[Y+104>>2]|0)+((i+-1|0)*20|0)+2>>1]=k&255;Qa=Z;return j|0}m=Hj(f,c[Q+12>>2]|0,j)|0;i=b[Q+32>>1]|0;if(i<<16>>16>-1){i=a[(c[(c[Q+44>>2]|0)+4>>2]|0)+(i<<16>>16<<4)+13>>0]|0;if(i<<24>>24==65){j=m;Qa=Z;return j|0}else l=i<<24>>24}else l=68;n=Y+108|0;do if((m|0)!=(j|0)){i=c[n>>2]|0;k=Y+112|0;if((c[k>>2]|0)>(i|0)){c[n>>2]=i+1;f=c[Y+104>>2]|0;a[f+(i*20|0)>>0]=79;b[f+(i*20|0)+2>>1]=0;c[f+(i*20|0)+4>>2]=m;c[f+(i*20|0)+8>>2]=j;c[f+(i*20|0)+12>>2]=0;c[f+(i*20|0)+16>>2]=0;a[f+(i*20|0)+1>>0]=0;break}else{Bi(Y,79,m,j,0)|0;break}}else k=Y+112|0;while(0);m=38812+((l<<1)+-132)|0;i=c[n>>2]|0;if((c[k>>2]|0)>(i|0)){c[n>>2]=i+1;f=c[Y+104>>2]|0;a[f+(i*20|0)>>0]=91;b[f+(i*20|0)+2>>1]=0;c[f+(i*20|0)+4>>2]=j;c[f+(i*20|0)+8>>2]=1;c[f+(i*20|0)+12>>2]=0;c[f+(i*20|0)+16>>2]=0;a[f+(i*20|0)+1>>0]=0}else i=Bi(Y,91,j,1,0)|0;if(a[(c[Y>>2]|0)+81>>0]|0){Qa=Z;return j|0}if((i|0)<0)i=(c[n>>2]|0)+-1|0;k=c[Y+104>>2]|0;l=k+(i*20|0)+1|0;if(!(a[l>>0]|0)){c[k+(i*20|0)+16>>2]=m;a[l>>0]=-1;Qa=Z;return j|0}else{Ci(Y,k+(i*20|0)|0,m,-1);Qa=Z;return j|0}}do if((X|0)==158){N=c[Q+12>>2]|0;n=a[N>>0]|0;m=n<<24>>24==-88;if(m)i=a[N+38>>0]|0;else i=n;switch(i<<24>>24){case -87:{q=N+20|0;X=163;break}case -125:{q=c[N+20>>2]|0;X=163;break}default:{}}if((X|0)==163?(c[c[q>>2]>>2]|0)>=2:0){M=k&255;p=l&255;L=c[Q+16>>2]|0;if(m)i=a[N+38>>0]|0;else i=n;switch(i<<24>>24){case -87:{i=N+20|0;X=169;break}case -125:{i=c[N+20>>2]|0;X=169;break}default:l=1}if((X|0)==169)l=c[c[i>>2]>>2]|0;i=f+56|0;K=c[i>>2]|0;J=K+-1|0;c[i>>2]=J;i=a[L>>0]|0;if(i<<24>>24==-88)k=a[L+38>>0]|0;else k=i;switch(k<<24>>24){case -87:{k=L+20|0;X=175;break}case -125:{k=c[L+20>>2]|0;X=175;break}default:k=1}if((X|0)==175)k=c[c[k>>2]>>2]|0;if((l|0)!=(k|0)){ad(f,38899,w);m=j;break}k=M<<24>>24==55?56:M;if(n<<24>>24==-125){H=Oj(f,N)|0;i=a[L>>0]|0}else H=0;if(i<<24>>24==-125)t=Oj(f,L)|0;else t=0;u=N+38|0;v=N+20|0;w=N+28|0;x=N+20|0;y=L+38|0;z=L+20|0;A=L+28|0;B=L+20|0;C=f+19|0;D=l+-1|0;I=Y+108|0;E=Y+112|0;F=Y+104|0;s=l+-2|0;i=p|32;r=0;k=k<<24>>24==57?54:k;while(1){c[S>>2]=0;c[R>>2]=0;switch(a[N>>0]|0){case -88:{m=a[u>>0]|0;switch(m<<24>>24){case -87:{l=x;X=186;break}case -125:{l=c[v>>2]|0;X=186;break}default:l=N}do if((X|0)==186){X=0;if((c[c[l>>2]>>2]|0)>=2)if(m<<24>>24==-125){l=c[(c[c[v>>2]>>2]|0)+4+(r*20|0)>>2]|0;break}else{l=c[(c[x>>2]|0)+4+(r*20|0)>>2]|0;break}else l=N}while(0);p=(c[w>>2]|0)+r|0;break}case -125:{p=r+H|0;l=c[(c[c[v>>2]>>2]|0)+4+(r*20|0)>>2]|0;break}default:{l=c[(c[v>>2]|0)+4+(r*20|0)>>2]|0;p=Jj(f,l,S)|0}}switch(a[L>>0]|0){case -88:{n=a[y>>0]|0;switch(n<<24>>24){case -87:{m=B;X=196;break}case -125:{m=c[z>>2]|0;X=196;break}default:m=L}do if((X|0)==196){X=0;if((c[c[m>>2]>>2]|0)>=2)if(n<<24>>24==-125){m=c[(c[c[z>>2]>>2]|0)+4+(r*20|0)>>2]|0;break}else{m=c[(c[B>>2]|0)+4+(r*20|0)>>2]|0;break}else m=L}while(0);n=(c[A>>2]|0)+r|0;break}case -125:{n=r+t|0;m=c[(c[c[z>>2]>>2]|0)+4+(r*20|0)>>2]|0;break}default:{m=c[(c[z>>2]|0)+4+(r*20|0)>>2]|0;n=Jj(f,m,R)|0}}q=i&255;Kj(f,l,m,k&255,p,n,j,q);l=c[S>>2]|0;if(l|0?(O=a[C>>0]|0,(O&255)<8):0){a[C>>0]=O+1<<24>>24;c[f+148+((O&255)<<2)>>2]=l}l=c[R>>2]|0;if(l|0?(P=a[C>>0]|0,(P&255)<8):0){a[C>>0]=P+1<<24>>24;c[f+148+((P&255)<<2)>>2]=l}if((r|0)==(D|0))break;switch(k<<24>>24){case 53:{i=c[I>>2]|0;if((c[E>>2]|0)>(i|0)){c[I>>2]=i+1;Q=c[F>>2]|0;a[Q+(i*20|0)>>0]=20;b[Q+(i*20|0)+2>>1]=0;c[Q+(i*20|0)+4>>2]=j;c[Q+(i*20|0)+8>>2]=J;c[Q+(i*20|0)+12>>2]=0;c[Q+(i*20|0)+16>>2]=0;a[Q+(i*20|0)+1>>0]=0}else Bi(Y,20,j,J,0)|0;i=(q|8)&255;k=53;break}case 52:{i=c[I>>2]|0;if((c[E>>2]|0)>(i|0)){c[I>>2]=i+1;Q=c[F>>2]|0;a[Q+(i*20|0)>>0]=18;b[Q+(i*20|0)+2>>1]=0;c[Q+(i*20|0)+4>>2]=j;c[Q+(i*20|0)+8>>2]=J;c[Q+(i*20|0)+12>>2]=0;c[Q+(i*20|0)+16>>2]=0;a[Q+(i*20|0)+1>>0]=0}else Bi(Y,18,j,J,0)|0;i=(q|8)&255;k=52;break}default:{l=c[I>>2]|0;if((c[E>>2]|0)>(l|0)){c[I>>2]=l+1;Q=c[F>>2]|0;a[Q+(l*20|0)>>0]=58;b[Q+(l*20|0)+2>>1]=0;c[Q+(l*20|0)+4>>2]=0;c[Q+(l*20|0)+8>>2]=J;c[Q+(l*20|0)+12>>2]=0;c[Q+(l*20|0)+16>>2]=0;a[Q+(l*20|0)+1>>0]=0}else Bi(Y,58,0,J,0)|0;k=(r|0)==(s|0)?M:k}}r=r+1|0}k=c[Y+12>>2]|0;i=0-K|0;if(((c[k+56>>2]|0)+(c[k+60>>2]|0)|0)<0){kk(k,Y,i);m=j;break}else{c[(c[k+64>>2]|0)+(i<<2)>>2]=c[I>>2];m=j;break}}Y=Jj(f,N,T)|0;X=Q+16|0;m=Jj(f,c[X>>2]|0,W)|0;Kj(f,N,c[X>>2]|0,k,Y,m,j,l|32);m=j}while(0);i=c[T>>2]|0;if(i|0?(U=f+19|0,V=a[U>>0]|0,(V&255)<8):0){a[U>>0]=V+1<<24>>24;c[f+148+((V&255)<<2)>>2]=i}i=c[W>>2]|0;if(!i){j=m;Qa=Z;return j|0}k=f+19|0;l=a[k>>0]|0;if((l&255)>=8){j=m;Qa=Z;return j|0}a[k>>0]=l+1<<24>>24;c[f+148+((l&255)<<2)>>2]=i;j=m;Qa=Z;return j|0}function Ij(f,h,i,j){f=f|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=Qa;Qa=Qa+32|0;s=w+16|0;u=w+8|0;n=w;v=c[f+8>>2]|0;if(c[h+4>>2]&1024|0){l=c[h+8>>2]|0;l=(i|0)==0?l:0-l|0;h=v+108|0;k=c[h>>2]|0;if((c[v+112>>2]|0)>(k|0)){c[h>>2]=k+1;v=c[v+104>>2]|0;a[v+(k*20|0)>>0]=70;b[v+(k*20|0)+2>>1]=0;c[v+(k*20|0)+4>>2]=l;c[v+(k*20|0)+8>>2]=j;c[v+(k*20|0)+12>>2]=0;c[v+(k*20|0)+16>>2]=0;a[v+(k*20|0)+1>>0]=0;Qa=w;return}else{Bi(v,70,l,j,0)|0;Qa=w;return}}q=c[h+8>>2]|0;h=Td(q,n)|0;r=(i|0)!=0;do if(!((h|0)==2|(r|(h|0)!=3)^1)?(o=n,m=c[o>>2]|0,o=c[o+4>>2]|0,!(r&((m|0)==0&(o|0)==-2147483648))):0){if(r){h=(h|0)==3;m=Rv(0,0,m|0,o|0)|0;o=L()|0;m=h?0:m;o=h?-2147483648:o;c[n>>2]=m;c[n+4>>2]=o}n=c[v>>2]|0;a:do if(c[n+272>>2]|0){if(!(a[n+81>>0]|0))t=68}else{do if((e[n+276>>1]|0)>=8){h=n+300|0;l=c[h>>2]|0;if(l|0){c[h>>2]=c[l>>2];t=n+284|0;c[t>>2]=(c[t>>2]|0)+1;t=69;break a}h=n+296|0;l=c[h>>2]|0;if(!l){h=n+292|0;break}else{c[h>>2]=c[l>>2];t=n+284|0;c[t>>2]=(c[t>>2]|0)+1;t=69;break a}}else h=n+288|0;while(0);c[h>>2]=(c[h>>2]|0)+1;t=68}while(0);if((t|0)==68){l=Yd(n,8,0)|0;t=69}if((t|0)==69?l|0:0){n=l;h=n;a[h>>0]=m;a[h+1>>0]=m>>8;a[h+2>>0]=m>>16;a[h+3>>0]=m>>24;n=n+4|0;a[n>>0]=o;a[n+1>>0]=o>>8;a[n+2>>0]=o>>16;a[n+3>>0]=o>>24;n=v+108|0;h=c[n>>2]|0;if((c[v+112>>2]|0)>(h|0)){c[n>>2]=h+1;o=c[v+104>>2]|0;a[o+(h*20|0)>>0]=71;b[o+(h*20|0)+2>>1]=0;c[o+(h*20|0)+4>>2]=0;c[o+(h*20|0)+8>>2]=j;c[o+(h*20|0)+12>>2]=0;c[o+(h*20|0)+16>>2]=0;a[o+(h*20|0)+1>>0]=0}else h=Bi(v,71,0,j,0)|0;m=c[v>>2]|0;if(!(a[m+81>>0]|0)){if((h|0)<0)h=(c[n>>2]|0)+-1|0;m=c[v+104>>2]|0;n=m+(h*20|0)+1|0;if(!(a[n>>0]|0)){c[m+(h*20|0)+16>>2]=l;a[n>>0]=-14;break}else{Ci(v,m+(h*20|0)|0,l,-14);break}}if(m|0){if(c[m+480>>2]|0){Vd(m,l);break}o=l;if((c[m+304>>2]|0)>>>0<=o>>>0?(c[m+308>>2]|0)>>>0>o>>>0:0){o=m+300|0;c[l>>2]=c[o>>2];c[o>>2]=l;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{o=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-o;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}l=v+108|0;h=c[l>>2]|0;if((c[v+112>>2]|0)>(h|0)){c[l>>2]=h+1;o=c[v+104>>2]|0;a[o+(h*20|0)>>0]=71;b[o+(h*20|0)+2>>1]=0;c[o+(h*20|0)+4>>2]=0;c[o+(h*20|0)+8>>2]=j;c[o+(h*20|0)+12>>2]=0;c[o+(h*20|0)+16>>2]=0;a[o+(h*20|0)+1>>0]=0}else h=Bi(v,71,0,j,0)|0;if(!(a[(c[v>>2]|0)+81>>0]|0)){if((h|0)<0)h=(c[l>>2]|0)+-1|0;l=c[v+104>>2]|0;if(a[l+(h*20|0)+1>>0]|0)Ci(v,l+(h*20|0)|0,0,-14)}}else t=7;while(0);do if((t|0)==7?q|0:0){l=a[q>>0]|0;do if(!(l<<24>>24)){h=38972;t=9}else{h=l&255;if(l<<24>>24==48){h=a[q+1>>0]|0;if(!(h<<24>>24)){h=38973;t=9;break}h=h&255;if((h|32|0)==120)break;else k=120}else k=48;p=d[208+h>>0]|0;t=13}while(0);if((t|0)==9){p=0;k=a[208+(d[h>>0]|0)>>0]|0;t=13}if((t|0)==13?(p|0)!=(k&255|0):0){Jg(q,u,(Cu(q)|0)&1073741823,1)|0;if(i|0)g[u>>3]=-+g[u>>3];l=c[v>>2]|0;b:do if(c[l+272>>2]|0)if(!(a[l+81>>0]|0))t=27;else t=47;else{do if((e[l+276>>1]|0)>=8){h=l+300|0;k=c[h>>2]|0;if(k|0){c[h>>2]=c[k>>2];m=l+284|0;c[m>>2]=(c[m>>2]|0)+1;m=k;t=28;break b}h=l+296|0;k=c[h>>2]|0;if(!k){h=l+292|0;break}else{c[h>>2]=c[k>>2];m=l+284|0;c[m>>2]=(c[m>>2]|0)+1;m=k;t=28;break b}}else h=l+288|0;while(0);c[h>>2]=(c[h>>2]|0)+1;t=27}while(0);if((t|0)==27){m=Yd(l,8,0)|0;t=28}do if((t|0)==28)if(m){h=u;s=c[h>>2]|0;h=c[h+4>>2]|0;l=m;u=l;a[u>>0]=s;a[u+1>>0]=s>>8;a[u+2>>0]=s>>16;a[u+3>>0]=s>>24;l=l+4|0;a[l>>0]=h;a[l+1>>0]=h>>8;a[l+2>>0]=h>>16;a[l+3>>0]=h>>24;l=v+108|0;h=c[l>>2]|0;if((c[v+112>>2]|0)>(h|0)){c[l>>2]=h+1;u=c[v+104>>2]|0;a[u+(h*20|0)>>0]=-111;b[u+(h*20|0)+2>>1]=0;c[u+(h*20|0)+4>>2]=0;c[u+(h*20|0)+8>>2]=j;c[u+(h*20|0)+12>>2]=0;c[u+(h*20|0)+16>>2]=0;a[u+(h*20|0)+1>>0]=0}else h=Bi(v,145,0,j,0)|0;k=c[v>>2]|0;if(!(a[k+81>>0]|0)){if((h|0)<0)h=(c[l>>2]|0)+-1|0;k=c[v+104>>2]|0;l=k+(h*20|0)+1|0;if(!(a[l>>0]|0)){c[k+(h*20|0)+16>>2]=m;a[l>>0]=-13;break}else{Ci(v,k+(h*20|0)|0,m,-13);break}}if(k|0){if(c[k+480>>2]|0){Vd(k,m);break}v=m;if((c[k+304>>2]|0)>>>0<=v>>>0?(c[k+308>>2]|0)>>>0>v>>>0:0){v=k+300|0;c[m>>2]=c[v>>2];c[v>>2]=m;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](m);break}else{v=Ua[c[29352>>2]&127](m)|0;c[14978]=(c[14978]|0)-v;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](m);break}}else t=47;while(0);if((t|0)==47){k=v+108|0;h=c[k>>2]|0;if((c[v+112>>2]|0)>(h|0)){c[k>>2]=h+1;u=c[v+104>>2]|0;a[u+(h*20|0)>>0]=-111;b[u+(h*20|0)+2>>1]=0;c[u+(h*20|0)+4>>2]=0;c[u+(h*20|0)+8>>2]=j;c[u+(h*20|0)+12>>2]=0;c[u+(h*20|0)+16>>2]=0;a[u+(h*20|0)+1>>0]=0}else h=Bi(v,145,0,j,0)|0;if(!(a[(c[v>>2]|0)+81>>0]|0)){if((h|0)<0)h=(c[k>>2]|0)+-1|0;k=c[v+104>>2]|0;if(a[k+(h*20|0)+1>>0]|0)Ci(v,k+(h*20|0)|0,0,-13)}}break}c[s>>2]=r?34064:59952;c[s+4>>2]=q;ad(f,38975,s)}while(0);Qa=w;return}function Jj(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;i=Qa;Qa=Qa+32|0;g=i;a:do if(!d)f=0;else while(1){f=c[d+4>>2]|0;if(!(f&4096)){f=d;break a}if(!(f&262144))d=d+12|0;else d=(c[d+20>>2]|0)+4|0;d=c[d>>2]|0;if(!d){f=0;break}}while(0);if((a[b+23>>0]|0?(a[f>>0]|0)!=-88:0)?(d=g+20|0,a[d>>0]=2,c[g+4>>2]=127,c[g+8>>2]=128,c[g+24>>2]=0,Yj(g,f)|0,a[d>>0]|0):0){c[e>>2]=0;e=Lj(b,f,-1)|0;Qa=i;return e|0}g=b+19|0;d=a[g>>0]|0;if(!(d<<24>>24)){j=b+44|0;d=(c[j>>2]|0)+1|0;c[j>>2]=d}else{d=d+-1<<24>>24;a[g>>0]=d;d=c[b+148+((d&255)<<2)>>2]|0}f=Hj(b,f,d)|0;if((f|0)!=(d|0))if((d|0)!=0?(h=a[g>>0]|0,(h&255)<8):0){a[g>>0]=h+1<<24>>24;c[b+148+((h&255)<<2)>>2]=d;d=0}else d=0;c[e>>2]=d;j=f;Qa=i;return j|0}function Kj(d,e,f,g,h,i,j,k){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0,n=0;do if(!(c[e+4>>2]&256)){if(f|0?c[f+4>>2]&256|0:0){n=Wi(d,f)|0;break}l=Wi(d,e)|0;if(!l)n=Wi(d,f)|0;else n=l}else n=Wi(d,e)|0;while(0);f=Vj(f)|0;l=Vj(e)|0;if(f<<24>>24==0|l<<24>>24==0)l=(l|f)<<24>>24==0?65:(l&255)+(f&255)|0;else l=f<<24>>24>66|l<<24>>24>66?67:65;m=l|k;k=d+8|0;d=c[k>>2]|0;f=d+108|0;l=c[f>>2]|0;if((c[d+112>>2]|0)>(l|0)){c[f>>2]=l+1;e=c[d+104>>2]|0;a[e+(l*20|0)>>0]=g;b[e+(l*20|0)+2>>1]=0;c[e+(l*20|0)+4>>2]=i;c[e+(l*20|0)+8>>2]=j;c[e+(l*20|0)+12>>2]=h;c[e+(l*20|0)+16>>2]=0;a[e+(l*20|0)+1>>0]=0}else l=Bi(d,g,i,j,h)|0;do if(!(a[(c[d>>2]|0)+81>>0]|0)){if((l|0)<0)l=(c[f>>2]|0)+-1|0;f=c[d+104>>2]|0;e=f+(l*20|0)+1|0;if(a[e>>0]|0){Ci(d,f+(l*20|0)|0,n,-2);break}if(n|0){c[f+(l*20|0)+16>>2]=n;a[e>>0]=-2}}while(0);l=c[k>>2]|0;f=c[l+108>>2]|0;if((f|0)<=0)return;b[(c[l+104>>2]|0)+((f+-1|0)*20|0)+2>>1]=m&255;return}function Lj(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;j=b+68|0;h=c[j>>2]|0;i=(e|0)<0;a:do if(i&(h|0)!=0?(f=c[h>>2]|0,(f|0)>0):0){g=h+4|0;while(1){if(a[g+13>>0]&4?($j(0,c[g>>2]|0,d,-1)|0)==0:0)break;if((f|0)>1){f=f+-1|0;g=g+20|0}else break a}j=c[g+16>>2]|0;return j|0}while(0);if(!d)f=0;else f=bk(c[b>>2]|0,d,0,0)|0;g=lj(c[b>>2]|0,h,f)|0;if(g){f=(c[g>>2]|0)+-1|0;h=g+4+(f*20|0)+13|0;a[h>>0]=a[h>>0]&-5|e>>>29&4;if(i){i=b+44|0;e=(c[i>>2]|0)+1|0;c[i>>2]=e}c[g+4+(f*20|0)+16>>2]=e}c[j>>2]=g;j=e;return j|0}function Mj(d,e,f,g,h){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;F=Qa;Qa=Qa+32|0;A=F;i=h&255;D=79-(i&1)|0;y=c[d+8>>2]|0;j=c[e>>2]|0;if((j|0)<=0){Qa=F;return}w=((a[d+23>>0]|0)==0?i&253:h)&255;q=(w&4|0)==0;r=(w&2|0)==0;s=A+20|0;t=A+4|0;u=A+8|0;v=A+24|0;w=(w&8|0)==0;x=(D|0)==78;l=g+-1|0;m=y+108|0;n=y+112|0;o=y+104|0;p=D&255;k=e+4|0;h=0;i=j;while(1){g=c[k>>2]|0;do if(!q?(j=b[k+16>>1]|0,z=j&65535,j<<16>>16!=0):0){if(!w){h=h+-1|0;i=i+-1|0;break}g=l+z|0;e=h+f|0;j=c[m>>2]|0;if((c[n>>2]|0)>(j|0)){c[m>>2]=j+1;G=c[o>>2]|0;a[G+(j*20|0)>>0]=p;b[G+(j*20|0)+2>>1]=0;c[G+(j*20|0)+4>>2]=g;c[G+(j*20|0)+8>>2]=e;c[G+(j*20|0)+12>>2]=0;c[G+(j*20|0)+16>>2]=0;a[G+(j*20|0)+1>>0]=0;break}else{Bi(y,D,g,e,0)|0;break}}else E=10;while(0);a:do if((E|0)==10){E=0;do if(!r){a[s>>0]=2;c[t>>2]=127;c[u>>2]=128;c[v>>2]=0;if(g){Yj(A,g)|0;if(!(a[s>>0]|0))break}Lj(d,g,h+f|0)|0;break a}while(0);j=h+f|0;e=Hj(d,g,j)|0;if((e|0)!=(j|0)){if(x){if(!(a[(c[y>>2]|0)+81>>0]|0))g=(c[o>>2]|0)+(((c[m>>2]|0)+-1|0)*20|0)|0;else g=59308;if(((a[g>>0]|0)==78?(B=g+12|0,C=(c[B>>2]|0)+1|0,(C+(c[g+4>>2]|0)|0)==(e|0)):0)?(C+(c[g+8>>2]|0)|0)==(j|0):0){c[B>>2]=C;break}}g=c[m>>2]|0;if((c[n>>2]|0)>(g|0)){c[m>>2]=g+1;G=c[o>>2]|0;a[G+(g*20|0)>>0]=p;b[G+(g*20|0)+2>>1]=0;c[G+(g*20|0)+4>>2]=e;c[G+(g*20|0)+8>>2]=j;c[G+(g*20|0)+12>>2]=0;c[G+(g*20|0)+16>>2]=0;a[G+(g*20|0)+1>>0]=0;break}else{Bi(y,D,e,j,0)|0;break}}}while(0);h=h+1|0;if((h|0)>=(i|0))break;else k=k+20|0}Qa=F;return}function Nj(b,d,f,g){b=b|0;d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=Qa;Qa=Qa+16|0;l=n+4|0;m=n;c[l>>2]=0;c[m>>2]=0;if(!g){m=d;Qa=n;return m|0}if((a[g>>0]|0)!=-94){m=d;Qa=n;return m|0}g=c[g+44>>2]|0;if(!g){m=d;Qa=n;return m|0}if(!(c[g+56>>2]|0)){m=d;Qa=n;return m|0}g=g+64|0;while(1){g=c[g>>2]|0;if((c[g>>2]|0)==(b|0))break;else g=g+24|0}g=c[g+8>>2]|0;h=c[(c[g>>2]|0)+72>>2]|0;if(!h){m=d;Qa=n;return m|0}k=d+32|0;if(!(Ya[h&127](g,f,c[k>>2]|0,l,m)|0)){m=d;Qa=n;return m|0}g=c[k>>2]|0;if(!g)i=41;else i=((Cu(g)|0)&1073741823)+41|0;a:do if(!b){if(!(c[7324]|0)){g=Ua[c[29340>>2]&127](i)|0;j=34;break}g=Ua[c[29356>>2]&127](i)|0;if((c[14985]|0)>>>0<i>>>0)c[14985]=i;f=59064;h=c[f>>2]|0;f=c[f+4>>2]|0;if((f|0)>0|(f|0)==0&h>>>0>0){b=c[14978]|0;f=Rv(h|0,f|0,g|0,((g|0)<0)<<31>>31|0)|0;h=L()|0;c[14768]=((h|0)<0|(h|0)==0&f>>>0<=b>>>0)&1}h=Ua[c[29340>>2]&127](g)|0;if(!h){m=d;Qa=n;return m|0}g=Ua[c[29352>>2]&127](h)|0;g=(c[14978]|0)+g|0;c[14978]=g;if(g>>>0>(c[14982]|0)>>>0)c[14982]=g;g=(c[14981]|0)+1|0;c[14981]=g;if(g>>>0>(c[14987]|0)>>>0){c[14987]=g;b=h}else b=h}else{if(c[b+272>>2]|0){if(a[b+81>>0]|0){m=d;Qa=n;return m|0}}else{do if(!(0<0|(0==0?(e[b+276>>1]|0)>>>0<i>>>0:0))){h=b+300|0;g=c[h>>2]|0;if(g|0){c[h>>2]=c[g>>2];j=b+284|0;c[j>>2]=(c[j>>2]|0)+1;j=34;break a}h=b+296|0;g=c[h>>2]|0;if(!g){g=b+292|0;break}else{c[h>>2]=c[g>>2];j=b+284|0;c[j>>2]=(c[j>>2]|0)+1;j=34;break a}}else g=b+288|0;while(0);c[g>>2]=(c[g>>2]|0)+1}g=Yd(b,i,0)|0;j=34}while(0);if((j|0)==34)if(!g){m=d;Qa=n;return m|0}else b=g;ew(b+40|0,0,i+-40|0)|0;f=b;g=d;h=f+40|0;do{c[f>>2]=c[g>>2];f=f+4|0;g=g+4|0}while((f|0)<(h|0));f=b+40|0;c[b+32>>2]=f;h=c[k>>2]|0;if(!h)g=1;else g=((Cu(h)|0)&1073741823)+1|0;cw(f|0,h|0,g|0)|0;c[b+16>>2]=c[l>>2];c[b+8>>2]=c[m>>2];m=b+4|0;c[m>>2]=c[m>>2]|16;m=b;Qa=n;return m|0}function Oj(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;r=Qa;Qa=Qa+48|0;k=r+8|0;h=r;o=r+16|0;q=c[d+8>>2]|0;p=c[e+20>>2]|0;f=e+4|0;g=c[f>>2]|0;do if(!(g&32)){if(g&33554432|0){c[h>>2]=c[p+20>>2];lk(d,0,39045,h);f=c[e+48>>2]|0;g=c[e+44>>2]|0;h=q+108|0;i=c[h>>2]|0;if((c[q+112>>2]|0)>(i|0)){c[h>>2]=i+1;q=c[q+104>>2]|0;a[q+(i*20|0)>>0]=12;b[q+(i*20|0)+2>>1]=0;c[q+(i*20|0)+4>>2]=f;c[q+(i*20|0)+8>>2]=g;c[q+(i*20|0)+12>>2]=0;c[q+(i*20|0)+16>>2]=0;a[q+(i*20|0)+1>>0]=0}else Bi(q,12,f,g,0)|0;q=c[e+28>>2]|0;Qa=r;return q|0}c[f>>2]=g|33554432;i=d+44|0;f=(c[i>>2]|0)+1|0;c[i>>2]=f;c[e+48>>2]=f;i=q+108|0;g=c[i>>2]|0;j=q+112|0;if((c[j>>2]|0)>(g|0)){n=g+1|0;c[i>>2]=n;m=c[q+104>>2]|0;a[m+(g*20|0)>>0]=70;b[m+(g*20|0)+2>>1]=0;c[m+(g*20|0)+4>>2]=0;c[m+(g*20|0)+8>>2]=f;c[m+(g*20|0)+12>>2]=0;c[m+(g*20|0)+16>>2]=0;a[m+(g*20|0)+1>>0]=0;f=n}else f=(Bi(q,70,0,f,0)|0)+1|0;c[e+44>>2]=f;h=c[i>>2]|0;if((c[j>>2]|0)>(h|0)){c[i>>2]=h+1;f=c[q+104>>2]|0;a[f+(h*20|0)>>0]=17;f=f+(h*20|0)+1|0;g=f+19|0;do{a[f>>0]=0;f=f+1|0}while((f|0)<(g|0));n=h;break}else{n=Bi(q,17,0,0,0)|0;break}}else n=0;while(0);m=(n|0)!=0;f=c[p+20>>2]|0;c[k>>2]=m?59952:39084;c[k+4>>2]=f;lk(d,1,39063,k);f=(a[e>>0]|0)==-125;if(f)i=c[c[p>>2]>>2]|0;else i=1;s=d+44|0;j=c[s>>2]|0;k=j+1|0;a[o>>0]=0;l=o+4|0;c[l>>2]=k;c[o+16>>2]=0;g=o+8|0;c[g>>2]=0;h=o+12|0;c[h>>2]=0;j=j+i|0;c[s>>2]=j;do if(f){a[o>>0]=10;c[g>>2]=k;c[h>>2]=i;f=q+108|0;g=c[f>>2]|0;if((c[q+112>>2]|0)>(g|0)){c[f>>2]=g+1;s=c[q+104>>2]|0;a[s+(g*20|0)>>0]=73;b[s+(g*20|0)+2>>1]=0;c[s+(g*20|0)+4>>2]=0;c[s+(g*20|0)+8>>2]=k;c[s+(g*20|0)+12>>2]=j;c[s+(g*20|0)+16>>2]=0;a[s+(g*20|0)+1>>0]=0;break}else{Bi(q,73,0,k,j)|0;break}}else{a[o>>0]=3;g=q+108|0;f=c[g>>2]|0;if((c[q+112>>2]|0)>(f|0)){c[g>>2]=f+1;s=c[q+104>>2]|0;a[s+(f*20|0)>>0]=70;b[s+(f*20|0)+2>>1]=0;c[s+(f*20|0)+4>>2]=0;c[s+(f*20|0)+8>>2]=k;c[s+(f*20|0)+12>>2]=0;c[s+(f*20|0)+16>>2]=0;a[s+(f*20|0)+1>>0]=0;break}else{Bi(q,70,0,k,0)|0;break}}while(0);i=mj(c[d>>2]|0,147,17144,0)|0;h=p+60|0;f=c[h>>2]|0;if(!f)c[h>>2]=cj(d,141,i,0)|0;else{f=f+12|0;g=c[f>>2]|0;if(g){li(c[d>>2]|0,g);f=(c[h>>2]|0)+12|0}c[f>>2]=i}c[p+12>>2]=0;if(ij(d,p,o)|0){s=0;Qa=r;return s|0}i=c[l>>2]|0;c[e+28>>2]=i;if(!m){s=i;Qa=r;return s|0}h=q+108|0;g=c[h>>2]|0;if(!(a[(c[q>>2]|0)+81>>0]|0))f=(c[q+104>>2]|0)+(((n|0)<0?g+-1|0:n)*20|0)|0;else f=59308;c[f+8>>2]=g;f=c[e+48>>2]|0;if((c[q+112>>2]|0)>(g|0)){c[h>>2]=g+1;s=c[q+104>>2]|0;a[s+(g*20|0)>>0]=66;b[s+(g*20|0)+2>>1]=0;c[s+(g*20|0)+4>>2]=f;c[s+(g*20|0)+8>>2]=0;c[s+(g*20|0)+12>>2]=0;c[s+(g*20|0)+16>>2]=0;a[s+(g*20|0)+1>>0]=0}else Bi(q,66,f,0,0)|0;f=c[e+44>>2]|0;g=c[h>>2]|0;if(!(a[(c[q>>2]|0)+81>>0]|0))f=(c[q+104>>2]|0)+((((f|0)<1?g:f)+-1|0)*20|0)|0;else f=59308;c[f+4>>2]=g+-1;s=i;Qa=r;return s|0}function Pj(d,f,g,h){d=d|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0;U=Qa;Qa=Qa+48|0;G=U+12|0;E=U+8|0;m=U+4|0;D=U;c[E>>2]=0;c[D>>2]=0;B=f+12|0;N=c[B>>2]|0;if(mk(d,f)|0){Qa=U;return}T=nk(d,f)|0;j=c[B>>2]|0;i=a[j>>0]|0;if(i<<24>>24==-88)i=a[j+38>>0]|0;switch(i<<24>>24){case -87:{i=j+20|0;J=7;break}case -125:{i=c[j+20>>2]|0;J=7;break}default:K=1}if((J|0)==7)K=c[c[i>>2]>>2]|0;k=c[d>>2]|0;l=(K*5|0)+1|0;a:do if(!k){Q=Qv(l|0,0,-1,-1)|0;P=L()|0;if(!(P>>>0>0|(P|0)==0&Q>>>0>2147483390)){if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](l)|0;J=32;break}i=Ua[c[29356>>2]&127](l)|0;if((c[14985]|0)>>>0<l>>>0)c[14985]=l;k=59064;j=c[k>>2]|0;k=c[k+4>>2]|0;if((k|0)>0|(k|0)==0&j>>>0>0){Q=c[14978]|0;P=Rv(j|0,k|0,i|0,((i|0)<0)<<31>>31|0)|0;O=L()|0;c[14768]=((O|0)<0|(O|0)==0&P>>>0<=Q>>>0)&1}i=Ua[c[29340>>2]&127](i)|0;if(i){j=Ua[c[29352>>2]&127](i)|0;j=(c[14978]|0)+j|0;c[14978]=j;if(j>>>0>(c[14982]|0)>>>0)c[14982]=j;j=(c[14981]|0)+1|0;c[14981]=j;if(j>>>0>(c[14987]|0)>>>0){c[14987]=j;J=33}else J=33}else Q=0}else Q=0}else{if(c[k+272>>2]|0){if(a[k+81>>0]|0){Q=0;break}}else{do if(!(0<0|(0==0?(e[k+276>>1]|0)>>>0<l>>>0:0))){j=k+300|0;i=c[j>>2]|0;if(i|0){c[j>>2]=c[i>>2];J=k+284|0;c[J>>2]=(c[J>>2]|0)+1;J=32;break a}j=k+296|0;i=c[j>>2]|0;if(!i){i=k+292|0;break}else{c[j>>2]=c[i>>2];J=k+284|0;c[J>>2]=(c[J>>2]|0)+1;J=32;break a}}else i=k+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1}i=Yd(k,l,0)|0;J=32}while(0);if((J|0)==32)if(!i)Q=0;else J=33;if((J|0)==33){ew(i|0,0,l|0)|0;Q=i}i=c[d>>2]|0;if(!(a[i+81>>0]|0)){w=d+8|0;P=c[w>>2]|0;C=(g|0)==(h|0);z=ok(d,f,3,C?0:E,Q,D)|0;j=a[N>>0]|0;if(j<<24>>24==-88)i=a[N+38>>0]|0;else i=j;switch(i<<24>>24){case -87:{i=N+20|0;J=40;break}case -125:{i=c[N+20>>2]|0;J=40;break}default:J=41}do if((J|0)==40){v=c[c[i>>2]>>2]|0;if((v|0)!=1){c[m>>2]=0;if(j<<24>>24==-125){O=Oj(d,N)|0;break}O=d+44|0;M=c[O>>2]|0;n=M+1|0;c[O>>2]=M+v;if((v|0)>0){o=N+20|0;p=d+23|0;q=G+20|0;r=G+4|0;s=G+8|0;t=G+24|0;m=0;do{i=c[(c[o>>2]|0)+4+(m*20|0)>>2]|0;u=m+n|0;do if(!(a[p>>0]|0))if(!i){y=Hj(d,0,u)|0;J=58}else J=52;else{a[q>>0]=2;c[r>>2]=127;c[s>>2]=128;c[t>>2]=0;if(i){Yj(G,i)|0;if(!(a[q>>0]|0)){J=52;break}}Lj(d,i,u)|0}while(0);do if((J|0)==52){J=0;if((a[i>>0]|0)!=-88){y=Hj(d,i,u)|0;J=58;break}l=c[w>>2]|0;i=c[i+28>>2]|0;j=l+108|0;k=c[j>>2]|0;if((c[l+112>>2]|0)>(k|0)){c[j>>2]=k+1;O=c[l+104>>2]|0;a[O+(k*20|0)>>0]=78;b[O+(k*20|0)+2>>1]=0;c[O+(k*20|0)+4>>2]=i;c[O+(k*20|0)+8>>2]=u;c[O+(k*20|0)+12>>2]=0;c[O+(k*20|0)+16>>2]=0;a[O+(k*20|0)+1>>0]=0;break}else{Bi(l,78,i,u,0)|0;break}}while(0);do if(((J|0)==58?(J=0,(y|0)!=(u|0)):0)?(x=c[w>>2]|0,x|0):0){i=x+108|0;j=c[i>>2]|0;if((c[x+112>>2]|0)>(j|0)){c[i>>2]=j+1;O=c[x+104>>2]|0;a[O+(j*20|0)>>0]=79;b[O+(j*20|0)+2>>1]=0;c[O+(j*20|0)+4>>2]=y;c[O+(j*20|0)+8>>2]=u;c[O+(j*20|0)+12>>2]=0;c[O+(j*20|0)+16>>2]=0;a[O+(j*20|0)+1>>0]=0;break}else{Bi(x,79,y,u,0)|0;break}}while(0);m=m+1|0}while((m|0)!=(v|0));O=n}else O=n}else J=41}while(0);if((J|0)==41)O=Jj(d,N,m)|0;r=(K|0)>0;b:do if(r){i=0;do{if((c[Q+(i<<2)>>2]|0)!=(i|0))break b;i=i+1|0}while((i|0)<(K|0))}else i=0;while(0);if((i|0)!=(K|0)){do if((K|0)==1){i=d+19|0;j=a[i>>0]|0;if(!(j<<24>>24)){M=d+44|0;j=(c[M>>2]|0)+1|0;c[M>>2]=j;break}else{j=j+-1<<24>>24;a[i>>0]=j;j=c[d+148+((j&255)<<2)>>2]|0;break}}else{i=d+32|0;j=c[i>>2]|0;k=d+28|0;l=c[k>>2]|0;if((l|0)<(K|0)){M=d+44|0;j=c[M>>2]|0;c[M>>2]=j+K;j=j+1|0;break}else{c[i>>2]=j+K;c[k>>2]=l-K;break}}while(0);if(r){k=P+108|0;l=P+112|0;m=P+104|0;i=0;do{n=i+O|0;o=(c[Q+(i<<2)>>2]|0)+j|0;p=c[k>>2]|0;if((c[l>>2]|0)>(p|0)){c[k>>2]=p+1;M=c[m>>2]|0;a[M+(p*20|0)>>0]=78;b[M+(p*20|0)+2>>1]=0;c[M+(p*20|0)+4>>2]=n;c[M+(p*20|0)+8>>2]=o;c[M+(p*20|0)+12>>2]=0;c[M+(p*20|0)+16>>2]=0;a[M+(p*20|0)+1>>0]=0}else Bi(P,78,n,o,0)|0;i=i+1|0}while((i|0)!=(K|0));M=j}else M=j}else M=O;c:do if((z|0)==5){v=c[f+20>>2]|0;s=Wi(d,c[B>>2]|0)|0;u=d+56|0;x=c[u>>2]|0;t=x+-1|0;c[u>>2]=t;u=(h|0)!=(g|0);do if(u){i=d+19|0;j=a[i>>0]|0;if(!(j<<24>>24)){N=d+44|0;i=(c[N>>2]|0)+1|0;c[N>>2]=i}else{N=j+-1<<24>>24;a[i>>0]=N;i=c[d+148+((N&255)<<2)>>2]|0}j=P+108|0;k=c[j>>2]|0;if((c[P+112>>2]|0)>(k|0)){c[j>>2]=k+1;w=c[P+104>>2]|0;a[w+(k*20|0)>>0]=96;b[w+(k*20|0)+2>>1]=0;c[w+(k*20|0)+4>>2]=M;c[w+(k*20|0)+8>>2]=M;c[w+(k*20|0)+12>>2]=i;c[w+(k*20|0)+16>>2]=0;a[w+(k*20|0)+1>>0]=0;w=i;break}else{Bi(P,96,M,M,i)|0;w=i;break}}else w=0;while(0);if((c[v>>2]|0)>0){m=(w|0)==0;n=P+108|0;o=P+112|0;p=P+104|0;q=d+19|0;r=(s|0)==0;l=0;do{i=v+4+(l*20|0)|0;k=Jj(d,c[i>>2]|0,G)|0;d:do if(!m){i=c[i>>2]|0;j=a[i>>0]|0;if((j+91&255)<2)do{i=c[i+12>>2]|0;j=a[i>>0]|0}while((j+91&255)<2);if(j<<24>>24==-88)j=a[i+38>>0]|0;e:do switch(j<<24>>24){case -110:case -111:case 110:case -109:break d;case -94:{if(!(c[i+4>>2]&1048576)){j=c[i+44>>2]|0;if(!j)break e;i=b[i+32>>1]|0;if(i<<16>>16<=-1)break d;if(a[(c[j+4>>2]|0)+(i<<16>>16<<4)+12>>0]|0)break d}break}default:{}}while(0);i=c[n>>2]|0;if((c[o>>2]|0)>(i|0)){c[n>>2]=i+1;N=c[p>>2]|0;a[N+(i*20|0)>>0]=96;b[N+(i*20|0)+2>>1]=0;c[N+(i*20|0)+4>>2]=w;c[N+(i*20|0)+8>>2]=k;c[N+(i*20|0)+12>>2]=w;c[N+(i*20|0)+16>>2]=0;a[N+(i*20|0)+1>>0]=0;break}else{Bi(P,96,w,k,w)|0;break}}while(0);i=c[n>>2]|0;j=(c[o>>2]|0)>(i|0);if(u|(l|0)<((c[v>>2]|0)+-1|0)){if(j){c[n>>2]=i+1;N=c[p>>2]|0;a[N+(i*20|0)>>0]=53;b[N+(i*20|0)+2>>1]=0;c[N+(i*20|0)+4>>2]=M;c[N+(i*20|0)+8>>2]=t;c[N+(i*20|0)+12>>2]=k;c[N+(i*20|0)+16>>2]=0;a[N+(i*20|0)+1>>0]=0}else i=Bi(P,53,M,t,k)|0;do if(!(a[(c[P>>2]|0)+81>>0]|0)){if((i|0)<0)i=(c[n>>2]|0)+-1|0;j=c[p>>2]|0;k=j+(i*20|0)+1|0;if(a[k>>0]|0){Ci(P,j+(i*20|0)|0,s,-2);break}if(r)break;c[j+(i*20|0)+16>>2]=s;a[k>>0]=-2}while(0);i=c[n>>2]|0;if((i|0)>0)b[(c[p>>2]|0)+((i+-1|0)*20|0)+2>>1]=a[T>>0]|0}else{if(j){c[n>>2]=i+1;N=c[p>>2]|0;a[N+(i*20|0)>>0]=52;b[N+(i*20|0)+2>>1]=0;c[N+(i*20|0)+4>>2]=M;c[N+(i*20|0)+8>>2]=g;c[N+(i*20|0)+12>>2]=k;c[N+(i*20|0)+16>>2]=0;a[N+(i*20|0)+1>>0]=0}else i=Bi(P,52,M,g,k)|0;do if(!(a[(c[P>>2]|0)+81>>0]|0)){if((i|0)<0)i=(c[n>>2]|0)+-1|0;j=c[p>>2]|0;k=j+(i*20|0)+1|0;if(a[k>>0]|0){Ci(P,j+(i*20|0)|0,s,-2);break}if(r)break;c[j+(i*20|0)+16>>2]=s;a[k>>0]=-2}while(0);i=c[n>>2]|0;if((i|0)>0)b[(c[p>>2]|0)+((i+-1|0)*20|0)+2>>1]=(a[T>>0]|16)<<24>>24}i=c[G>>2]|0;if(i|0?(F=a[q>>0]|0,(F&255)<8):0){a[q>>0]=F+1<<24>>24;c[d+148+((F&255)<<2)>>2]=i}l=l+1|0}while((l|0)<(c[v>>2]|0))}l=(w|0)==0;do if(!l){j=P+108|0;i=c[j>>2]|0;k=P+112|0;if((c[k>>2]|0)>(i|0)){c[j>>2]=i+1;N=c[P+104>>2]|0;a[N+(i*20|0)>>0]=50;b[N+(i*20|0)+2>>1]=0;c[N+(i*20|0)+4>>2]=w;c[N+(i*20|0)+8>>2]=h;c[N+(i*20|0)+12>>2]=0;c[N+(i*20|0)+16>>2]=0;a[N+(i*20|0)+1>>0]=0}else Bi(P,50,w,h,0)|0;i=c[j>>2]|0;if((c[k>>2]|0)>(i|0)){c[j>>2]=i+1;h=c[P+104>>2]|0;a[h+(i*20|0)>>0]=11;b[h+(i*20|0)+2>>1]=0;c[h+(i*20|0)+4>>2]=0;c[h+(i*20|0)+8>>2]=g;c[h+(i*20|0)+12>>2]=0;c[h+(i*20|0)+16>>2]=0;a[h+(i*20|0)+1>>0]=0;break}else{Bi(P,11,0,g,0)|0;break}}while(0);j=c[P+12>>2]|0;i=0-x|0;if(((c[j+56>>2]|0)+(c[j+60>>2]|0)|0)<0)kk(j,P,i);else c[(c[j+64>>2]|0)+(i<<2)>>2]=c[P+108>>2];if(!l?(H=d+19|0,I=a[H>>0]|0,(I&255)<8):0){a[H>>0]=I+1<<24>>24;c[d+148+((I&255)<<2)>>2]=w}}else{if(C){l=g;q=0}else{l=d+56|0;q=(c[l>>2]|0)+-1|0;c[l>>2]=q;l=q}f:do if(r){n=P+108|0;o=P+112|0;p=P+104|0;m=0;while(1){i=c[B>>2]|0;k=a[i>>0]|0;if(k<<24>>24==-88)j=a[i+38>>0]|0;else j=k;switch(j<<24>>24){case -87:{j=i+20|0;J=158;break}case -125:{j=c[i+20>>2]|0;J=158;break}default:{}}do if((J|0)==158){J=0;if((c[c[j>>2]>>2]|0)>=2){if(k<<24>>24!=-125?(a[i+38>>0]|0)!=-125:0){i=c[(c[i+20>>2]|0)+4+(m*20|0)>>2]|0;break}i=c[(c[c[i+20>>2]>>2]|0)+4+(m*20|0)>>2]|0}}while(0);j=a[i>>0]|0;if((j+91&255)<2)do{i=c[i+12>>2]|0;j=a[i>>0]|0}while((j+91&255)<2);if(j<<24>>24==-88)j=a[i+38>>0]|0;g:do switch(j<<24>>24){case -110:case -111:case 110:case -109:break;case -94:{if((c[i+4>>2]&1048576|0)==0?(A=c[i+44>>2]|0,(A|0)!=0):0){i=b[i+32>>1]|0;if(i<<16>>16<=-1)break g;if(!(a[(c[A+4>>2]|0)+(i<<16>>16<<4)+12>>0]|0))J=173}else J=173;break}default:J=173}while(0);do if((J|0)==173){J=0;i=m+M|0;j=c[n>>2]|0;if((c[o>>2]|0)>(j|0)){c[n>>2]=j+1;I=c[p>>2]|0;a[I+(j*20|0)>>0]=50;b[I+(j*20|0)+2>>1]=0;c[I+(j*20|0)+4>>2]=i;c[I+(j*20|0)+8>>2]=l;c[I+(j*20|0)+12>>2]=0;c[I+(j*20|0)+16>>2]=0;a[I+(j*20|0)+1>>0]=0;break}else{Bi(P,50,i,l,0)|0;break}}while(0);m=m+1|0;if((m|0)==(K|0))break f}}while(0);do if((z|0)==1){l=c[D>>2]|0;j=P+108|0;i=c[j>>2]|0;k=P+112|0;if((c[k>>2]|0)>(i|0)){c[j>>2]=i+1;I=c[P+104>>2]|0;a[I+(i*20|0)>>0]=30;b[I+(i*20|0)+2>>1]=0;c[I+(i*20|0)+4>>2]=l;c[I+(i*20|0)+8>>2]=g;c[I+(i*20|0)+12>>2]=M;c[I+(i*20|0)+16>>2]=0;a[I+(i*20|0)+1>>0]=0}else Bi(P,30,l,g,M)|0;i=c[j>>2]|0;if((c[k>>2]|0)>(i|0)){c[j>>2]=i+1;j=c[P+104>>2]|0;a[j+(i*20|0)>>0]=11;j=j+(i*20|0)+1|0;k=j+19|0;do{a[j>>0]=0;j=j+1|0}while((j|0)<(k|0));z=l;break}else{i=Bi(P,11,0,0,0)|0;z=l;break}}else{n=P+108|0;i=c[n>>2]|0;m=P+112|0;if((c[m>>2]|0)>(i|0)){c[n>>2]=i+1;I=c[P+104>>2]|0;a[I+(i*20|0)>>0]=91;b[I+(i*20|0)+2>>1]=0;c[I+(i*20|0)+4>>2]=M;c[I+(i*20|0)+8>>2]=K;c[I+(i*20|0)+12>>2]=0;c[I+(i*20|0)+16>>2]=0;a[I+(i*20|0)+1>>0]=0}else i=Bi(P,91,M,K,0)|0;j=c[P>>2]|0;h:do if(a[j+81>>0]|0){if((K|0)!=-12)ig(j,K,T)}else{if((i|0)<0)i=(c[n>>2]|0)+-1|0;j=c[P+104>>2]|0;k=j+(i*20|0)|0;do if((K|0)<=-1){l=j+(i*20|0)+1|0;if(a[l>>0]|0)break;if((K|0)==-3){c[j+(i*20|0)+16>>2]=T;a[l>>0]=-3;break h}if(!T)break h;c[j+(i*20|0)+16>>2]=T;a[l>>0]=K;if((K|0)!=-12)break h;I=T+12|0;c[I>>2]=(c[I>>2]|0)+1;break h}while(0);Ci(P,k,T,K)}while(0);k=c[D>>2]|0;i=c[n>>2]|0;j=(c[m>>2]|0)>(i|0);if(C){if(j){c[n>>2]=i+1;h=c[P+104>>2]|0;a[h+(i*20|0)>>0]=28;b[h+(i*20|0)+2>>1]=0;c[h+(i*20|0)+4>>2]=k;c[h+(i*20|0)+8>>2]=g;c[h+(i*20|0)+12>>2]=M;c[h+(i*20|0)+16>>2]=0;a[h+(i*20|0)+1>>0]=0}else i=Bi(P,28,k,g,M)|0;if(a[(c[P>>2]|0)+81>>0]|0)break c;g=c[P+104>>2]|0;a[g+(i*20|0)+1>>0]=-3;c[g+(i*20|0)+16>>2]=K;break c}else{if(j){c[n>>2]=i+1;I=c[P+104>>2]|0;a[I+(i*20|0)>>0]=29;b[I+(i*20|0)+2>>1]=0;c[I+(i*20|0)+4>>2]=k;c[I+(i*20|0)+8>>2]=0;c[I+(i*20|0)+12>>2]=M;c[I+(i*20|0)+16>>2]=0;a[I+(i*20|0)+1>>0]=0}else i=Bi(P,29,k,0,M)|0;if(a[(c[P>>2]|0)+81>>0]|0){z=k;break}z=c[P+104>>2]|0;a[z+(i*20|0)+1>>0]=-3;c[z+(i*20|0)+16>>2]=K;z=k;break}}while(0);j=c[E>>2]|0;do if((K|0)==1&(j|0)!=0){k=P+108|0;l=c[k>>2]|0;if((c[P+112>>2]|0)>(l|0)){c[k>>2]=l+1;I=c[P+104>>2]|0;a[I+(l*20|0)>>0]=51;b[I+(l*20|0)+2>>1]=0;c[I+(l*20|0)+4>>2]=j;c[I+(l*20|0)+8>>2]=g;c[I+(l*20|0)+12>>2]=0;c[I+(l*20|0)+16>>2]=0;a[I+(l*20|0)+1>>0]=0;break}else{Bi(P,51,j,g,0)|0;break}}while(0);do if(C){j=P+108|0;k=c[j>>2]|0;if((c[P+112>>2]|0)>(k|0)){c[j>>2]=k+1;I=c[P+104>>2]|0;a[I+(k*20|0)>>0]=11;b[I+(k*20|0)+2>>1]=0;c[I+(k*20|0)+4>>2]=0;c[I+(k*20|0)+8>>2]=g;c[I+(k*20|0)+12>>2]=0;c[I+(k*20|0)+16>>2]=0;a[I+(k*20|0)+1>>0]=0;break}else{Bi(P,11,0,g,0)|0;break}}while(0);do if(q|0){k=c[P+12>>2]|0;j=~q;if(((c[k+56>>2]|0)+(c[k+60>>2]|0)|0)<0){kk(k,P,j);break}else{c[(c[k+64>>2]|0)+(j<<2)>>2]=c[P+108>>2];break}}while(0);y=P+108|0;j=c[y>>2]|0;f=P+112|0;if((c[f>>2]|0)>(j|0)){c[y>>2]=j+1;x=c[P+104>>2]|0;a[x+(j*20|0)>>0]=36;b[x+(j*20|0)+2>>1]=0;c[x+(j*20|0)+4>>2]=z;c[x+(j*20|0)+8>>2]=g;c[x+(j*20|0)+12>>2]=0;c[x+(j*20|0)+16>>2]=0;a[x+(j*20|0)+1>>0]=0;x=j}else x=Bi(P,36,z,g,0)|0;v=(K|0)>1;if(v){I=d+56|0;w=(c[I>>2]|0)+-1|0;c[I>>2]=w}else w=g;i:do if(r){p=d+19|0;q=d+44|0;r=N+38|0;s=N+20|0;t=N+20|0;u=P+104|0;o=0;while(1){j=a[p>>0]|0;if(!(j<<24>>24)){n=(c[q>>2]|0)+1|0;c[q>>2]=n}else{n=j+-1<<24>>24;a[p>>0]=n;n=c[d+148+((n&255)<<2)>>2]|0}k=a[N>>0]|0;if(k<<24>>24==-88)j=a[r>>0]|0;else j=k;switch(j<<24>>24){case -87:{j=s;J=237;break}case -125:{j=c[t>>2]|0;J=237;break}default:j=N}j:do if((J|0)==237){J=0;if((c[c[j>>2]>>2]|0)<2){j=N;break}do if(k<<24>>24!=-125){if((a[r>>0]|0)==-125)break;j=c[(c[s>>2]|0)+4+(o*20|0)>>2]|0;break j}while(0);j=c[(c[c[t>>2]>>2]|0)+4+(o*20|0)>>2]|0}while(0);m=Wi(d,j)|0;j=c[y>>2]|0;if((c[f>>2]|0)>(j|0)){c[y>>2]=j+1;I=c[u>>2]|0;a[I+(j*20|0)>>0]=90;b[I+(j*20|0)+2>>1]=0;c[I+(j*20|0)+4>>2]=z;c[I+(j*20|0)+8>>2]=o;c[I+(j*20|0)+12>>2]=n;c[I+(j*20|0)+16>>2]=0;a[I+(j*20|0)+1>>0]=0}else Bi(P,90,z,o,n)|0;k=o+M|0;j=c[y>>2]|0;if((c[f>>2]|0)>(j|0)){c[y>>2]=j+1;I=c[u>>2]|0;a[I+(j*20|0)>>0]=52;b[I+(j*20|0)+2>>1]=0;c[I+(j*20|0)+4>>2]=k;c[I+(j*20|0)+8>>2]=w;c[I+(j*20|0)+12>>2]=n;c[I+(j*20|0)+16>>2]=0;a[I+(j*20|0)+1>>0]=0}else j=Bi(P,52,k,w,n)|0;do if(!(a[(c[P>>2]|0)+81>>0]|0)){if((j|0)<0)j=(c[y>>2]|0)+-1|0;k=c[u>>2]|0;l=k+(j*20|0)+1|0;if(a[l>>0]|0){Ci(P,k+(j*20|0)|0,m,-2);break}if(!m)break;c[k+(j*20|0)+16>>2]=m;a[l>>0]=-2}while(0);do if(n|0){j=a[p>>0]|0;if((j&255)>=8)break;a[p>>0]=j+1<<24>>24;c[d+148+((j&255)<<2)>>2]=n}while(0);o=o+1|0;if((o|0)==(K|0))break i}}while(0);j=c[y>>2]|0;if((c[f>>2]|0)>(j|0)){c[y>>2]=j+1;N=c[P+104>>2]|0;a[N+(j*20|0)>>0]=11;b[N+(j*20|0)+2>>1]=0;c[N+(j*20|0)+4>>2]=0;c[N+(j*20|0)+8>>2]=h;c[N+(j*20|0)+12>>2]=0;c[N+(j*20|0)+16>>2]=0;a[N+(j*20|0)+1>>0]=0}else Bi(P,11,0,h,0)|0;do if(v){k=c[P+12>>2]|0;j=~w;if(((c[k+56>>2]|0)+(c[k+60>>2]|0)|0)<0)kk(k,P,j);else c[(c[k+64>>2]|0)+(j<<2)>>2]=c[y>>2];j=x+1|0;k=c[y>>2]|0;if((c[f>>2]|0)>(k|0)){c[y>>2]=k+1;h=c[P+104>>2]|0;a[h+(k*20|0)>>0]=5;b[h+(k*20|0)+2>>1]=0;c[h+(k*20|0)+4>>2]=z;c[h+(k*20|0)+8>>2]=j;c[h+(k*20|0)+12>>2]=0;c[h+(k*20|0)+16>>2]=0;a[h+(k*20|0)+1>>0]=0}else Bi(P,5,z,j,0)|0;j=c[y>>2]|0;if((c[f>>2]|0)>(j|0)){c[y>>2]=j+1;h=c[P+104>>2]|0;a[h+(j*20|0)>>0]=11;b[h+(j*20|0)+2>>1]=0;c[h+(j*20|0)+4>>2]=0;c[h+(j*20|0)+8>>2]=g;c[h+(j*20|0)+12>>2]=0;c[h+(j*20|0)+16>>2]=0;a[h+(j*20|0)+1>>0]=0;break}else{Bi(P,11,0,g,0)|0;break}}while(0);j=c[y>>2]|0;if(!(a[(c[P>>2]|0)+81>>0]|0))i=(c[P+104>>2]|0)+(((i|0)<0?j+-1|0:i)*20|0)|0;else i=59308;c[i+8>>2]=j}while(0);if(!((M|0)==(O|0)|(M|0)==0)?(R=d+19|0,S=a[R>>0]|0,(S&255)<8):0){a[R>>0]=S+1<<24>>24;c[d+148+((S&255)<<2)>>2]=M}i=c[d>>2]|0}do if(Q|0){if(i|0){if(c[i+480>>2]|0){Vd(i,Q);break}S=Q;if((c[i+304>>2]|0)>>>0<=S>>>0?(c[i+308>>2]|0)>>>0>S>>>0:0){S=i+300|0;c[Q>>2]=c[S>>2];c[S>>2]=Q;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](Q);break}else{S=Ua[c[29352>>2]&127](Q)|0;c[14978]=(c[14978]|0)-S;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](Q);break}}while(0);i=c[d>>2]|0;if(!T){Qa=U;return}if(i|0){if(c[i+480>>2]|0){Vd(i,T);Qa=U;return}d=T;if((c[i+304>>2]|0)>>>0<=d>>>0?(c[i+308>>2]|0)>>>0>d>>>0:0){d=i+300|0;c[T>>2]=c[d>>2];c[d>>2]=T;Qa=U;return}}if(!(c[7324]|0)){_a[c[29344>>2]&127](T);Qa=U;return}else{d=Ua[c[29352>>2]&127](T)|0;c[14978]=(c[14978]|0)-d;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](T);Qa=U;return}}function Qj(d,e,f,g,h,i){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;E=Qa;Qa=Qa+240|0;y=E+212|0;C=E+160|0;j=E+108|0;k=E+56|0;B=E+4|0;D=E;c[D>>2]=0;l=j;m=l+52|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(m|0));l=k;m=l+52|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(m|0));l=C;m=l+52|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(m|0));l=B;m=l+52|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(m|0));w=c[e+4>>2]|0;cw(B|0,e|0,((w&16384|0)==0?((w&8192|0)==0?52:28):12)|0)|0;a[C>>0]=44;c[C+12>>2]=j;c[C+16>>2]=k;a[j>>0]=57;c[j+12>>2]=B;c[j+16>>2]=c[f+4>>2];a[k>>0]=55;c[k+12>>2]=B;c[k+16>>2]=c[f+24>>2];f=a[B>>0]|0;w=B+38|0;switch((f<<24>>24==-88?a[w>>0]|0:f)<<24>>24){case -87:{j=c[B+20>>2]|0;e=j;x=4;break}case -125:{j=c[B+20>>2]|0;e=c[j>>2]|0;x=4;break}default:x=5}a:do if((x|0)==4){v=c[e>>2]|0;if((v|0)!=1){c[D>>2]=0;if(f<<24>>24==-125){e=Oj(d,B)|0;break}u=d+44|0;t=c[u>>2]|0;e=t+1|0;c[u>>2]=t+v;if((v|0)>0){o=B+20|0;p=d+23|0;q=y+20|0;r=y+4|0;s=y+8|0;t=y+24|0;u=d+8|0;f=0;while(1){j=c[j+4+(f*20|0)>>2]|0;n=f+e|0;do if(!(a[p>>0]|0))if(!j){A=Hj(d,0,n)|0;x=22}else x=16;else{a[q>>0]=2;c[r>>2]=127;c[s>>2]=128;c[t>>2]=0;if(j){Yj(y,j)|0;if(!(a[q>>0]|0)){x=16;break}}Lj(d,j,n)|0}while(0);do if((x|0)==16){x=0;if((a[j>>0]|0)!=-88){A=Hj(d,j,n)|0;x=22;break}m=c[u>>2]|0;j=c[j+28>>2]|0;k=m+108|0;l=c[k>>2]|0;if((c[m+112>>2]|0)>(l|0)){c[k>>2]=l+1;m=c[m+104>>2]|0;a[m+(l*20|0)>>0]=78;b[m+(l*20|0)+2>>1]=0;c[m+(l*20|0)+4>>2]=j;c[m+(l*20|0)+8>>2]=n;c[m+(l*20|0)+12>>2]=0;c[m+(l*20|0)+16>>2]=0;a[m+(l*20|0)+1>>0]=0;break}else{Bi(m,78,j,n,0)|0;break}}while(0);do if(((x|0)==22?(x=0,(A|0)!=(n|0)):0)?(z=c[u>>2]|0,z|0):0){j=z+108|0;k=c[j>>2]|0;if((c[z+112>>2]|0)>(k|0)){c[j>>2]=k+1;m=c[z+104>>2]|0;a[m+(k*20|0)>>0]=79;b[m+(k*20|0)+2>>1]=0;c[m+(k*20|0)+4>>2]=A;c[m+(k*20|0)+8>>2]=n;c[m+(k*20|0)+12>>2]=0;c[m+(k*20|0)+16>>2]=0;a[m+(k*20|0)+1>>0]=0;break}else{Bi(z,79,A,n,0)|0;break}}while(0);f=f+1|0;if((f|0)==(v|0))break a;j=c[o>>2]|0}}}else x=5}while(0);if((x|0)==5)e=Jj(d,B,D)|0;a[w>>0]=a[B>>0]|0;a[B>>0]=-88;c[B+28>>2]=e;e=B+4|0;f=c[e>>2]&-4097;c[e>>2]=f;if(!h){c[e>>2]=f|1;Hj(d,C,g)|0}else bb[h&127](d,C,g,i);e=c[D>>2]|0;if(!e){Qa=E;return}f=d+19|0;j=a[f>>0]|0;if((j&255)>=8){Qa=E;return}a[f>>0]=j+1<<24>>24;c[d+148+((j&255)<<2)>>2]=e;Qa=E;return}function Rj(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=Qa;Qa=Qa+16|0;m=t+8|0;p=t+4|0;s=t;o=c[d+8>>2]|0;c[p>>2]=0;c[s>>2]=0;if((e|0)==0|(o|0)==0){Qa=t;return}h=a[e>>0]|0;j=h^1;k=j&255;a:do switch(h<<24>>24){case 44:{Rj(d,c[e+12>>2]|0,f,g);Rj(d,c[e+16>>2]|0,f,g);break}case 43:{l=d+56|0;m=c[l>>2]|0;h=m+-1|0;c[l>>2]=h;rk(d,c[e+12>>2]|0,h,g^16);Rj(d,c[e+16>>2]|0,f,g);h=c[o+12>>2]|0;g=0-m|0;if(((c[h+56>>2]|0)+(c[h+60>>2]|0)|0)<0){kk(h,o,g);break a}else{c[(c[h+64>>2]|0)+(g<<2)>>2]=c[o+108>>2];break a}}case 19:{rk(d,c[e+12>>2]|0,f,g);break}case -89:{o=(a[e+38>>0]|0)==-96;h=c[e+12>>2]|0;g=o?0:16;if(o^(a[(c[(c[e+16>>2]|0)+8>>2]|0)+4>>0]|0)==0){Rj(d,h,f,g);break a}else{rk(d,h,f,g);break a}}case -96:case 45:{g=128;i=h<<24>>24==45?52:53;n=12;break}case 53:case 52:case 57:case 54:case 55:case 56:{i=k;n=12;break}case 51:case 50:{h=Jj(d,c[e+12>>2]|0,p)|0;g=o+108|0;i=c[g>>2]|0;if((c[o+112>>2]|0)>(i|0)){c[g>>2]=i+1;o=c[o+104>>2]|0;a[o+(i*20|0)>>0]=j;b[o+(i*20|0)+2>>1]=0;c[o+(i*20|0)+4>>2]=h;c[o+(i*20|0)+8>>2]=f;c[o+(i*20|0)+12>>2]=0;c[o+(i*20|0)+16>>2]=0;a[o+(i*20|0)+1>>0]=0;break a}else{Bi(o,k,h,f,0)|0;break a}}case 48:{Qj(d,c[e+12>>2]|0,c[e+20>>2]|0,f,66,g);break}case 49:{if(g|0){Pj(d,e,f,f);break a}m=d+56|0;g=c[m>>2]|0;h=g+-1|0;c[m>>2]=h;Pj(d,e,f,h);h=c[o+12>>2]|0;g=0-g|0;if(((c[h+56>>2]|0)+(c[h+60>>2]|0)|0)<0){kk(h,o,g);break a}else{c[(c[h+64>>2]|0)+(g<<2)>>2]=c[o+108>>2];break a}}default:{c[m>>2]=0;if((c[e+4>>2]&1|0)==0?(sk(e,m)|0)!=0:0)h=(c[m>>2]|0)==0&1;else h=0;n=36}}while(0);do if((n|0)==12){j=e+12|0;k=c[j>>2]|0;h=a[k>>0]|0;if(h<<24>>24==-88)h=a[k+38>>0]|0;switch(h<<24>>24){case -87:{l=k+20|0;n=17;break}case -125:{l=c[k+20>>2]|0;n=17;break}default:{}}if((n|0)==17?(c[c[l>>2]>>2]|0)>=2:0){c[m>>2]=0;if((c[e+4>>2]&1|0)==0?(sk(e,m)|0)!=0:0)h=(c[m>>2]|0)==0&1;else h=0;n=36;break}m=Jj(d,k,p)|0;e=e+16|0;o=Jj(d,c[e>>2]|0,s)|0;Kj(d,c[j>>2]|0,c[e>>2]|0,i,m,o,f,g)}while(0);do if((n|0)==36){if(h|0){h=o+108|0;g=c[h>>2]|0;if((c[o+112>>2]|0)>(g|0)){c[h>>2]=g+1;o=c[o+104>>2]|0;a[o+(g*20|0)>>0]=11;b[o+(g*20|0)+2>>1]=0;c[o+(g*20|0)+4>>2]=0;c[o+(g*20|0)+8>>2]=f;c[o+(g*20|0)+12>>2]=0;c[o+(g*20|0)+16>>2]=0;a[o+(g*20|0)+1>>0]=0;break}else{Bi(o,11,0,f,0)|0;break}}c[m>>2]=0;if((c[e+4>>2]&1|0)==0?(sk(e,m)|0)!=0:0){if(c[m>>2]|0)break}else n=42;j=Jj(d,e,p)|0;h=(g|0)!=0&1;g=o+108|0;i=c[g>>2]|0;if((c[o+112>>2]|0)>(i|0)){c[g>>2]=i+1;o=c[o+104>>2]|0;a[o+(i*20|0)>>0]=20;b[o+(i*20|0)+2>>1]=0;c[o+(i*20|0)+4>>2]=j;c[o+(i*20|0)+8>>2]=f;c[o+(i*20|0)+12>>2]=h;c[o+(i*20|0)+16>>2]=0;a[o+(i*20|0)+1>>0]=0;break}else{Bi(o,20,j,f,h)|0;break}}while(0);h=c[p>>2]|0;if(h|0?(q=d+19|0,r=a[q>>0]|0,(r&255)<8):0){a[q>>0]=r+1<<24>>24;c[d+148+((r&255)<<2)>>2]=h}h=c[s>>2]|0;if(!h){Qa=t;return}g=d+19|0;i=a[g>>0]|0;if((i&255)>=8){Qa=t;return}a[g>>0]=i+1<<24>>24;c[d+148+((i&255)<<2)>>2]=h;Qa=t;return}function Sj(d,f,g,h,i,j){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0;p=d+8|0;k=c[p>>2]|0;a:do if(!k){o=c[d>>2]|0;if((c[d+116>>2]|0)==0?(b[o+76>>1]&8)==0:0)a[d+23>>0]=1;b:do if(c[o+272>>2]|0)if(!(a[o+81>>0]|0))n=15;else{p=0;break a}else{do if((e[o+276>>1]|0)>=224){k=o+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];m=o+284|0;c[m>>2]=(c[m>>2]|0)+1;m=l;break b}k=o+296|0;l=c[k>>2]|0;if(!l){k=o+292|0;break}else{c[k>>2]=c[l>>2];m=o+284|0;c[m>>2]=(c[m>>2]|0)+1;m=l;break b}}else k=o+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;n=15}while(0);if((n|0)==15)m=Yd(o,224,0)|0;if(!m)p=0;else{k=m+104|0;l=k+120|0;do{c[k>>2]=0;k=k+4|0}while((k|0)<(l|0));c[m>>2]=o;k=o+4|0;l=c[k>>2]|0;if(l|0)c[l+4>>2]=m;c[m+8>>2]=l;c[m+4>>2]=0;c[k>>2]=m;c[m+20>>2]=381479589;c[m+12>>2]=d;c[p>>2]=m;Bi(m,61,0,1,0)|0;p=m}}else p=k;while(0);if((g|0)==2){o=c[d+116>>2]|0;a[((o|0)==0?d:o)+21>>0]=1}n=i<<24>>24;o=p+108|0;k=c[o>>2]|0;if((c[p+112>>2]|0)>(k|0)){c[o>>2]=k+1;d=c[p+104>>2]|0;a[d+(k*20|0)>>0]=69;b[d+(k*20|0)+2>>1]=0;c[d+(k*20|0)+4>>2]=f;c[d+(k*20|0)+8>>2]=g;c[d+(k*20|0)+12>>2]=0;c[d+(k*20|0)+16>>2]=0;a[d+(k*20|0)+1>>0]=0}else k=Bi(p,69,f,g,0)|0;l=c[p>>2]|0;do if(a[l+81>>0]|0){if(i<<24>>24!=-12)ig(l,n,h)}else{if((k|0)<0)k=(c[o>>2]|0)+-1|0;l=c[p+104>>2]|0;m=l+(k*20|0)|0;if(i<<24>>24<=-1?(q=l+(k*20|0)+1|0,(a[q>>0]|0)==0):0){if(i<<24>>24==-3){c[l+(k*20|0)+16>>2]=h;a[q>>0]=-3;break}if(!h)break;c[l+(k*20|0)+16>>2]=h;a[q>>0]=i;if(i<<24>>24!=-12)break;q=h+12|0;c[q>>2]=(c[q>>2]|0)+1;break}Ci(p,m,h,n)}while(0);k=c[o>>2]|0;if((k|0)<=0)return;b[(c[p+104>>2]|0)+((k+-1|0)*20|0)+2>>1]=j&255;return}function Tj(e,f,g,h,i){e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=Qa;Qa=Qa+16|0;p=r;if(!f){j=e+108|0;k=c[j>>2]|0;if((c[e+112>>2]|0)>(k|0)){c[j>>2]=k+1;e=c[e+104>>2]|0;a[e+(k*20|0)>>0]=90;b[e+(k*20|0)+2>>1]=0;c[e+(k*20|0)+4>>2]=g;c[e+(k*20|0)+8>>2]=h;c[e+(k*20|0)+12>>2]=i;c[e+(k*20|0)+16>>2]=0;a[e+(k*20|0)+1>>0]=0;Qa=r;return}else{Bi(e,90,g,h,i)|0;Qa=r;return}}do if((h|0)>=0?(b[f+40>>1]|0)!=(h|0):0){m=(c[f+56>>2]|0)!=0;n=m?164:90;if(m|(c[f+36>>2]&32|0)==0)j=h;else{j=c[f+8>>2]|0;a:do if(!j)j=0;else while(1){m=j+55|0;if(((d[m>>0]|d[m+1>>0]<<8)&3)==2)break a;j=c[j+20>>2]|0;if(!j){j=0;break}}while(0);m=h&65535;k=b[j+52>>1]|0;b:do if(!(k<<16>>16))j=-1;else{l=c[j+4>>2]|0;k=k&65535;j=0;while(1){if((b[l+(j<<1)>>1]|0)==m<<16>>16)break b;j=j+1|0;if(j>>>0>=k>>>0){j=-1;break}}}while(0);j=j<<16>>16}k=e+108|0;l=c[k>>2]|0;if((c[e+112>>2]|0)>(l|0)){c[k>>2]=l+1;m=c[e+104>>2]|0;a[m+(l*20|0)>>0]=n;b[m+(l*20|0)+2>>1]=0;c[m+(l*20|0)+4>>2]=g;c[m+(l*20|0)+8>>2]=j;c[m+(l*20|0)+12>>2]=i;c[m+(l*20|0)+16>>2]=0;a[m+(l*20|0)+1>>0]=0;break}else{Bi(e,n,g,j,i)|0;break}}else o=7;while(0);do if((o|0)==7){j=e+108|0;k=c[j>>2]|0;if((c[e+112>>2]|0)>(k|0)){c[j>>2]=k+1;o=c[e+104>>2]|0;a[o+(k*20|0)>>0]=-128;b[o+(k*20|0)+2>>1]=0;c[o+(k*20|0)+4>>2]=g;c[o+(k*20|0)+8>>2]=i;c[o+(k*20|0)+12>>2]=0;c[o+(k*20|0)+16>>2]=0;a[o+(k*20|0)+1>>0]=0;break}else{Bi(e,128,g,i,0)|0;break}}while(0);if((h|0)<=-1){Qa=r;return}if(!(c[f+12>>2]|0)){c[p>>2]=0;m=c[e>>2]|0;j=f+4|0;k=c[j>>2]|0;l=c[k+(h<<4)+4>>2]|0;do if(l|0?(Uj(m,l,a[m+78>>0]|0,a[k+(h<<4)+13>>0]|0,p)|0,q=c[p>>2]|0,q|0):0){k=c[e>>2]|0;if(!(a[k+81>>0]|0)){g=c[e+104>>2]|0;p=(c[e+108>>2]|0)+-1|0;a[g+(p*20|0)+1>>0]=-11;c[g+(p*20|0)+16>>2]=q;break}else{ig(k,-11,q);break}}while(0)}else j=f+4|0;if((a[(c[j>>2]|0)+(h<<4)+13>>0]|0)!=69){Qa=r;return}j=e+108|0;k=c[j>>2]|0;if((c[e+112>>2]|0)>(k|0)){c[j>>2]=k+1;e=c[e+104>>2]|0;a[e+(k*20|0)>>0]=84;b[e+(k*20|0)+2>>1]=0;c[e+(k*20|0)+4>>2]=i;c[e+(k*20|0)+8>>2]=0;c[e+(k*20|0)+12>>2]=0;c[e+(k*20|0)+16>>2]=0;a[e+(k*20|0)+1>>0]=0;Qa=r;return}else{Bi(e,84,i,0,0)|0;Qa=r;return}}function Uj(f,i,j,k,l){f=f|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0.0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;H=Qa;Qa=Qa+32|0;u=H+16|0;D=H+8|0;E=H;F=H+24|0;c[F>>2]=0;p=i;a:while(1){i=a[p>>0]|0;switch(i<<24>>24){case -90:case -83:break;default:break a}p=c[p+12>>2]|0}if(i<<24>>24==-88)i=d[p+38>>0]|0;else i=i&255;b:do switch((i&255)<<24>>24){case 36:{i=c[p+8>>2]|0;n=a[i>>0]|0;c:do if(!(n<<24>>24))m=67;else{m=67;o=0;do{o=o<<8|d[208+(n&255)>>0];i=i+1|0;d:do if((o|0)<1685026146){if((o|0)<1667785074){switch(o|0){case 1651273570:break;default:{G=16;break d}}switch(m<<24>>24){case 69:case 67:{m=65;break d}default:{G=15;break d}}}if((o|0)<1668050786)switch(o|0){case 1667785074:{m=66;break d}default:{G=16;break d}}else switch(o|0){case 1668050786:{m=66;break d}default:{G=16;break d}}}else{if((o|0)>=1919246700){if((o|0)>=1952807028)switch(o|0){case 1952807028:{m=66;break d}default:{G=16;break d}}switch(o|0){case 1919246700:break;default:{G=16;break d}}if(m<<24>>24==67){m=69;break}else{G=15;break}}if((o|0)<1718382433){switch(o|0){case 1685026146:break;default:{G=16;break d}}if(m<<24>>24==67){m=69;break}}else{switch(o|0){case 1718382433:break;default:{G=16;break d}}if(m<<24>>24==67){m=69;break}}}while(0);if((G|0)==15)G=0;else if((G|0)==16){G=0;if((o&16777215|0)==6909556){m=68;break c}}n=a[i>>0]|0}while(n<<24>>24!=0)}while(0);s=Uj(f,c[p+12>>2]|0,j,m,l)|0;i=c[l>>2]|0;if(!i){l=s;Qa=H;return l|0}Qg(i,m,1);r=c[l>>2]|0;if(k<<24>>24<=66){if(k<<24>>24!=66){l=s;Qa=H;return l|0}m=r+8|0;i=b[m>>1]|0;l=i&65535;if(!((l&2|0)!=0|(l&12|0)==0)){Fg(r,1,1)|0;i=b[m>>1]|0}b[m>>1]=i&-13;l=s;Qa=H;return l|0}p=r+8|0;n=b[p>>1]|0;i=n&65535;if(i&4|0){l=s;Qa=H;return l|0}if(i&8|0){q=+g[r>>3];i=Kg(q)|0;m=L()|0;l=Qv(i|0,m|0,1,-2147483648)|0;G=L()|0;if(!((G>>>0>0|(G|0)==0&l>>>0>1)&q==+(i>>>0)+4294967296.0*+(m|0))){l=s;Qa=H;return l|0}l=r;c[l>>2]=i;c[l+4>>2]=m;b[p>>1]=n&15904|4;l=s;Qa=H;return l|0}if(!(i&2)){l=s;Qa=H;return l|0}i=a[r+10>>0]|0;m=r+16|0;n=r+12|0;if(Jg(c[m>>2]|0,D,c[n>>2]|0,i)|0){if(Mg(c[m>>2]|0,E,c[n>>2]|0,i)|0){q=+g[D>>3];g[r>>3]=q;m=b[p>>1]|0;i=m|8;b[p>>1]=i;n=Kg(q)|0;o=L()|0;l=Qv(n|0,o|0,1,-2147483648)|0;f=L()|0;if((f>>>0>0|(f|0)==0&l>>>0>1)&q==+(n>>>0)+4294967296.0*+(o|0)){i=r;c[i>>2]=n;c[i+4>>2]=o;i=m&15904;G=28}}else{l=E;G=c[l+4>>2]|0;i=r;c[i>>2]=c[l>>2];c[i+4>>2]=G;i=b[p>>1]|0;G=28}if((G|0)==28){i=i|4;b[p>>1]=i}b[p>>1]=i&-3}l=s;Qa=H;return l|0}case -91:{i=c[p+12>>2]|0;m=a[i>>0]|0;switch(m<<24>>24){case -111:case -109:break;default:{G=107;break b}}t=34064;p=i;s=m&255;o=-1;r=-1;G=39;break}default:{t=59952;s=i;o=1;r=0;G=39}}while(0);e:do if((G|0)==39){f:do switch(s|0){case 110:case 145:case 147:{g:do if(!f){if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](40)|0;G=64;break}i=Ua[c[29356>>2]&127](40)|0;if((c[14985]|0)>>>0<40)c[14985]=40;n=59064;m=c[n>>2]|0;n=c[n+4>>2]|0;if((n|0)>0|(n|0)==0&m>>>0>0){C=c[14978]|0;B=Rv(m|0,n|0,i|0,((i|0)<0)<<31>>31|0)|0;n=L()|0;c[14768]=((n|0)<0|(n|0)==0&B>>>0<=C>>>0)&1}m=Ua[c[29340>>2]&127](i)|0;if(m){i=Ua[c[29352>>2]&127](m)|0;i=(c[14978]|0)+i|0;c[14978]=i;if(i>>>0>(c[14982]|0)>>>0)c[14982]=i;i=(c[14981]|0)+1|0;c[14981]=i;if(i>>>0>(c[14987]|0)>>>0){c[14987]=i;C=m}else C=m}else G=65}else{if(c[f+272>>2]|0){if(a[f+81>>0]|0){G=65;break}}else{do if((e[f+276>>1]|0)>=40){m=f+300|0;i=c[m>>2]|0;if(i|0){c[m>>2]=c[i>>2];G=f+284|0;c[G>>2]=(c[G>>2]|0)+1;G=64;break g}m=f+296|0;i=c[m>>2]|0;if(!i){i=f+292|0;break}else{c[m>>2]=c[i>>2];G=f+284|0;c[G>>2]=(c[G>>2]|0)+1;G=64;break g}}else i=f+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1}i=Yd(f,40,0)|0;G=64}while(0);if((G|0)==64)if(!i)G=65;else C=i;if((G|0)==65){c[F>>2]=0;n=0;m=0;break f}m=C;n=m+40|0;do{a[m>>0]=0;m=m+1|0}while((m|0)<(n|0));B=C+8|0;b[B>>1]=1;c[C+32>>2]=f;c[F>>2]=C;i=C;if(!(c[p+4>>2]&1024)){m=c[p+8>>2]|0;c[u>>2]=t;c[u+4>>2]=m;m=bd(f,38967,u)|0;if(!m){n=C;m=C;break f}wc(C,m,-1,1,116)|0}else{u=c[p+8>>2]|0;u=Wv(o|0,r|0,u|0,((u|0)<0)<<31>>31|0)|0;F=L()|0;f=C;c[f>>2]=u;c[f+4>>2]=F;b[B>>1]=4}do if(k<<24>>24==65&(s|2|0)==147){o=b[B>>1]|0;m=o&65535;if(!(m&4)){if(m&8|0){q=+g[C>>3];m=Kg(q)|0;n=L()|0;f=Qv(m|0,n|0,1,-2147483648)|0;F=L()|0;if(!((F>>>0>0|(F|0)==0&f>>>0>1)&q==+(m>>>0)+4294967296.0*+(n|0)))break;f=C;c[f>>2]=m;c[f+4>>2]=n;b[B>>1]=o&15904|4;break}if(m&2|0?(v=a[C+10>>0]|0,w=C+16|0,x=C+12|0,Jg(c[w>>2]|0,D,c[x>>2]|0,v)|0):0){if(Mg(c[w>>2]|0,E,c[x>>2]|0,v)|0){q=+g[D>>3];g[C>>3]=q;n=b[B>>1]|0;m=n|8;b[B>>1]=m;o=Kg(q)|0;p=L()|0;f=Qv(o|0,p|0,1,-2147483648)|0;F=L()|0;if((F>>>0>0|(F|0)==0&f>>>0>1)&q==+(o>>>0)+4294967296.0*+(p|0)){m=C;c[m>>2]=o;c[m+4>>2]=p;m=n&15904;G=79}}else{f=E;G=c[f+4>>2]|0;m=C;c[m>>2]=c[f>>2];c[m+4>>2]=G;m=b[B>>1]|0;G=79}if((G|0)==79){m=m|4;b[B>>1]=m}b[B>>1]=m&-3}}}else{if(k<<24>>24<=66){if(k<<24>>24!=66)break;m=b[B>>1]|0;f=m&65535;if(!((f&2|0)!=0|(f&12|0)==0)){Fg(C,1,1)|0;m=b[B>>1]|0}b[B>>1]=m&-13;break}o=b[B>>1]|0;m=o&65535;if(!(m&4)){if(m&8|0){q=+g[C>>3];m=Kg(q)|0;n=L()|0;f=Qv(m|0,n|0,1,-2147483648)|0;F=L()|0;if(!((F>>>0>0|(F|0)==0&f>>>0>1)&q==+(m>>>0)+4294967296.0*+(n|0)))break;f=C;c[f>>2]=m;c[f+4>>2]=n;b[B>>1]=o&15904|4;break}if(m&2|0?(y=a[C+10>>0]|0,z=C+16|0,A=C+12|0,Jg(c[z>>2]|0,D,c[A>>2]|0,y)|0):0){if(Mg(c[z>>2]|0,E,c[A>>2]|0,y)|0){q=+g[D>>3];g[C>>3]=q;n=b[B>>1]|0;m=n|8;b[B>>1]=m;o=Kg(q)|0;p=L()|0;f=Qv(o|0,p|0,1,-2147483648)|0;F=L()|0;if((F>>>0>0|(F|0)==0&f>>>0>1)&q==+(o>>>0)+4294967296.0*+(p|0)){m=C;c[m>>2]=o;c[m+4>>2]=p;m=n&15904;G=93}}else{f=E;G=c[f+4>>2]|0;m=C;c[m>>2]=c[f>>2];c[m+4>>2]=G;m=b[B>>1]|0;G=93}if((G|0)==93){m=m|4;b[B>>1]=m}b[B>>1]=m&-3}}}while(0);m=b[B>>1]|0;n=m&65535;if(n&12){m=n&65533;b[B>>1]=m}if(j<<24>>24==1|(m&2)==0){m=0;break e}if((a[C+10>>0]|0)==j<<24>>24){m=0;break e}m=Gg(C,j)|0;break e}case 165:{i=c[p+12>>2]|0;G=107;break e}case 114:{h:do if(!f){if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](40)|0;G=154;break}i=Ua[c[29356>>2]&127](40)|0;if((c[14985]|0)>>>0<40)c[14985]=40;n=59064;m=c[n>>2]|0;n=c[n+4>>2]|0;if((n|0)>0|(n|0)==0&m>>>0>0){G=c[14978]|0;j=Rv(m|0,n|0,i|0,((i|0)<0)<<31>>31|0)|0;E=L()|0;c[14768]=((E|0)<0|(E|0)==0&j>>>0<=G>>>0)&1}i=Ua[c[29340>>2]&127](i)|0;if(i){m=Ua[c[29352>>2]&127](i)|0;m=(c[14978]|0)+m|0;c[14978]=m;if(m>>>0>(c[14982]|0)>>>0)c[14982]=m;m=(c[14981]|0)+1|0;c[14981]=m;if(m>>>0>(c[14987]|0)>>>0){c[14987]=m;G=156}else G=156}else G=155}else{if(c[f+272>>2]|0){if(a[f+81>>0]|0){G=155;break}}else{do if((e[f+276>>1]|0)>=40){m=f+300|0;i=c[m>>2]|0;if(i|0){c[m>>2]=c[i>>2];G=f+284|0;c[G>>2]=(c[G>>2]|0)+1;G=154;break h}m=f+296|0;i=c[m>>2]|0;if(!i){i=f+292|0;break}else{c[m>>2]=c[i>>2];G=f+284|0;c[G>>2]=(c[G>>2]|0)+1;G=154;break h}}else i=f+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1}i=Yd(f,40,0)|0;G=154}while(0);if((G|0)==154)if(!i)G=155;else G=156;if((G|0)==155){c[F>>2]=0;n=0;m=0;break f}else if((G|0)==156){m=i;n=m+40|0;do{a[m>>0]=0;m=m+1|0}while((m|0)<(n|0));b[i+8>>1]=1;c[i+32>>2]=f;c[F>>2]=i;mh(i);m=0;break e}break}case 146:{i:do if(!f){if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](40)|0;G=180;break}i=Ua[c[29356>>2]&127](40)|0;if((c[14985]|0)>>>0<40)c[14985]=40;n=59064;m=c[n>>2]|0;n=c[n+4>>2]|0;if((n|0)>0|(n|0)==0&m>>>0>0){j=c[14978]|0;E=Rv(m|0,n|0,i|0,((i|0)<0)<<31>>31|0)|0;D=L()|0;c[14768]=((D|0)<0|(D|0)==0&E>>>0<=j>>>0)&1}m=Ua[c[29340>>2]&127](i)|0;if(m){i=Ua[c[29352>>2]&127](m)|0;i=(c[14978]|0)+i|0;c[14978]=i;if(i>>>0>(c[14982]|0)>>>0)c[14982]=i;i=(c[14981]|0)+1|0;c[14981]=i;if(i>>>0>(c[14987]|0)>>>0){c[14987]=i;v=m}else v=m}else G=181}else{if(c[f+272>>2]|0){if(a[f+81>>0]|0){G=181;break}}else{do if((e[f+276>>1]|0)>=40){m=f+300|0;i=c[m>>2]|0;if(i|0){c[m>>2]=c[i>>2];G=f+284|0;c[G>>2]=(c[G>>2]|0)+1;G=180;break i}m=f+296|0;i=c[m>>2]|0;if(!i){i=f+292|0;break}else{c[m>>2]=c[i>>2];G=f+284|0;c[G>>2]=(c[G>>2]|0)+1;G=180;break i}}else i=f+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1}i=Yd(f,40,0)|0;G=180}while(0);if((G|0)==180)if(!i)G=181;else v=i;if((G|0)==181){c[F>>2]=0;n=0;m=0;break f}m=v;n=m+40|0;do{a[m>>0]=0;m=m+1|0}while((m|0)<(n|0));b[v+8>>1]=1;c[v+32>>2]=f;c[F>>2]=v;i=v;s=(c[p+8>>2]|0)+2|0;r=(Cu(s)|0)&1073741823;t=r+-1|0;u=(t|0)/2|0;o=u+1|0;p=((o|0)<0)<<31>>31;j:do if(c[f+272>>2]|0)if(!(a[f+81>>0]|0))G=192;else m=0;else{do if(!(0<p>>>0|(0==(p|0)?(e[f+276>>1]|0)>>>0<o>>>0:0))){n=f+300|0;m=c[n>>2]|0;if(m|0){c[n>>2]=c[m>>2];G=f+284|0;c[G>>2]=(c[G>>2]|0)+1;G=193;break j}n=f+296|0;m=c[n>>2]|0;if(!m){m=f+292|0;break}else{c[n>>2]=c[m>>2];G=f+284|0;c[G>>2]=(c[G>>2]|0)+1;G=193;break j}}else m=f+288|0;while(0);c[m>>2]=(c[m>>2]|0)+1;G=192}while(0);if((G|0)==192){m=Yd(f,o,p)|0;G=193}if((G|0)==193){o=r+-2|0;if(!m)m=0;else{if(r>>>0>2){n=0;do{f=a[s+n>>0]|0;j=a[s+(n|1)>>0]|0;a[m+(n>>>1)>>0]=(0-(j>>>6&1)&9)+j&15|(0-(f>>>6&1)&9)+f<<4;n=n+2|0}while((n|0)<(o|0));n=t>>>1}else n=0;a[m+n>>0]=0}}wc(v,m,u,0,116)|0;m=0;break e}case 159:{k:do if(!f){if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](40)|0;G=223;break}i=Ua[c[29356>>2]&127](40)|0;if((c[14985]|0)>>>0<40)c[14985]=40;n=59064;m=c[n>>2]|0;n=c[n+4>>2]|0;if((n|0)>0|(n|0)==0&m>>>0>0){G=c[14978]|0;j=Rv(m|0,n|0,i|0,((i|0)<0)<<31>>31|0)|0;E=L()|0;c[14768]=((E|0)<0|(E|0)==0&j>>>0<=G>>>0)&1}i=Ua[c[29340>>2]&127](i)|0;if(i){m=Ua[c[29352>>2]&127](i)|0;m=(c[14978]|0)+m|0;c[14978]=m;if(m>>>0>(c[14982]|0)>>>0)c[14982]=m;m=(c[14981]|0)+1|0;c[14981]=m;if(m>>>0>(c[14987]|0)>>>0){c[14987]=m;G=225}else G=225}else G=224}else{if(c[f+272>>2]|0){if(a[f+81>>0]|0){G=224;break}}else{do if((e[f+276>>1]|0)>=40){m=f+300|0;i=c[m>>2]|0;if(i|0){c[m>>2]=c[i>>2];G=f+284|0;c[G>>2]=(c[G>>2]|0)+1;G=223;break k}m=f+296|0;i=c[m>>2]|0;if(!i){i=f+292|0;break}else{c[m>>2]=c[i>>2];G=f+284|0;c[G>>2]=(c[G>>2]|0)+1;G=223;break k}}else i=f+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1}i=Yd(f,40,0)|0;G=223}while(0);if((G|0)==223)if(!i)G=224;else G=225;if((G|0)==224){c[F>>2]=0;m=0;i=0;break e}else if((G|0)==225){m=i;n=m+40|0;do{a[m>>0]=0;m=m+1|0}while((m|0)<(n|0));c[i+32>>2]=f;c[F>>2]=i;b[i+8>>1]=4;m=i;c[m>>2]=(a[(c[p+8>>2]|0)+4>>0]|0)==0&1;c[m+4>>2]=0;m=0;break e}break}default:{m=0;i=0;break e}}while(0);i=f+81|0;if((a[i>>0]|0)==0?(a[f+82>>0]|0)==0:0){a[i>>0]=1;if((c[f+180>>2]|0)>0)c[f+264>>2]=1;i=f+272|0;c[i>>2]=(c[i>>2]|0)+1;i=c[f+236>>2]|0;if(i|0)c[i+12>>2]=7}if(!n){l=7;Qa=H;return l|0}if(!((b[n+8>>1]&9216)==0?!(c[n+24>>2]|0):0))Ag(n);i=c[n+32>>2]|0;if(i|0){if(c[i+480>>2]|0){Vd(i,m);l=7;Qa=H;return l|0}l=n;if((c[i+304>>2]|0)>>>0<=l>>>0?(c[i+308>>2]|0)>>>0>l>>>0:0){l=i+300|0;c[n>>2]=c[l>>2];c[l>>2]=m;l=7;Qa=H;return l|0}}if(!(c[7324]|0)){_a[c[29344>>2]&127](m);l=7;Qa=H;return l|0}else{l=Ua[c[29352>>2]&127](m)|0;c[14978]=(c[14978]|0)-l;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](m);l=7;Qa=H;return l|0}}while(0);do if((G|0)==107){f=(Uj(f,i,j,k,F)|0)==0;p=c[F>>2]|0;s=p;if(f&(p|0)!=0){mh(p);r=p+8|0;i=b[r>>1]|0;do if(!(i&8)){n=p;m=c[n>>2]|0;n=c[n+4>>2]|0;if((m|0)==0&(n|0)==-2147483648){g[p>>3]=9223372036854775808.0;i=i&15904|8;b[r>>1]=i;q=9223372036854775808.0;break}else{F=Rv(0,0,m|0,n|0)|0;f=L()|0;C=p;c[C>>2]=F;c[C+4>>2]=f;c[h>>2]=F;c[h+4>>2]=f;q=+g[h>>3];break}}else{q=-+g[p>>3];g[p>>3]=q}while(0);if(k<<24>>24<=66){if(k<<24>>24!=66){m=0;i=s;break}G=i&65535;if(!((G&2|0)!=0|(G&12|0)==0)){Fg(p,j,1)|0;i=b[r>>1]|0}b[r>>1]=i&-13;m=0;i=s;break}m=i&65535;if(!(m&4)){if(m&8|0){m=Kg(q)|0;n=L()|0;G=Qv(m|0,n|0,1,-2147483648)|0;f=L()|0;if(!((f>>>0>0|(f|0)==0&G>>>0>1)&q==+(m>>>0)+4294967296.0*+(n|0))){m=0;i=s;break}G=p;c[G>>2]=m;c[G+4>>2]=n;b[r>>1]=i&15904|4;m=0;i=s;break}if(m&2){i=a[p+10>>0]|0;m=p+16|0;n=p+12|0;if(Jg(c[m>>2]|0,D,c[n>>2]|0,i)|0){if(Mg(c[m>>2]|0,E,c[n>>2]|0,i)|0){q=+g[D>>3];g[p>>3]=q;m=b[r>>1]|0;i=m|8;b[r>>1]=i;n=Kg(q)|0;o=L()|0;f=Qv(n|0,o|0,1,-2147483648)|0;j=L()|0;if((j>>>0>0|(j|0)==0&f>>>0>1)&q==+(n>>>0)+4294967296.0*+(o|0)){i=p;c[i>>2]=n;c[i+4>>2]=o;i=m&15904;G=122}}else{f=E;G=c[f+4>>2]|0;i=p;c[i>>2]=c[f>>2];c[i+4>>2]=G;i=b[r>>1]|0;G=122}if((G|0)==122){i=i|4;b[r>>1]=i}b[r>>1]=i&-3}m=0;i=s}else{m=0;i=s}}else{m=0;i=s}}else{m=0;i=s}}while(0);c[l>>2]=i;l=m;Qa=H;return l|0}function Vj(e){e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;a:while(1){f=c[e+4>>2]|0;if(f&4096)do{if(!(f&262144))e=e+12|0;else e=(c[e+20>>2]|0)+4|0;e=c[e>>2]|0;f=c[e+4>>2]|0}while((f&4096|0)!=0);if(f&512|0){g=0;k=31;break}f=a[e>>0]|0;if(f<<24>>24==-125)e=(c[c[e+20>>2]>>2]|0)+4|0;else{if(f<<24>>24==-88)f=d[e+38>>0]|0;else f=f&255;switch((f&255)<<24>>24){case 36:{k=15;break a}case -94:case -92:{k=26;break a}case -86:break;default:break a}e=(c[c[(c[e+12>>2]|0)+20>>2]>>2]|0)+4+((b[e+32>>1]|0)*20|0)|0}e=c[e>>2]|0}if((k|0)==15){f=c[e+8>>2]|0;g=a[f>>0]|0;if(!(g<<24>>24)){k=67;return k|0}h=67;i=0;while(1){i=i<<8|d[208+(g&255)>>0];f=f+1|0;b:do if((i|0)<1685026146){if((i|0)<1667785074){switch(i|0){case 1651273570:break;default:{k=24;break b}}switch(h<<24>>24){case 69:case 67:{j=65;break b}default:{k=23;break b}}}if((i|0)<1668050786)switch(i|0){case 1667785074:{j=66;break b}default:{k=24;break b}}else switch(i|0){case 1668050786:{j=66;break b}default:{k=24;break b}}}else{if((i|0)>=1919246700){if((i|0)>=1952807028)switch(i|0){case 1952807028:{j=66;break b}default:{k=24;break b}}switch(i|0){case 1919246700:break;default:{k=24;break b}}if(h<<24>>24==67){j=69;break}else{k=23;break}}if((i|0)<1718382433){switch(i|0){case 1685026146:break;default:{k=24;break b}}if(h<<24>>24==67){j=69;break}}else{switch(i|0){case 1718382433:break;default:{k=24;break b}}if(h<<24>>24==67){j=69;break}}j=h}while(0);if((k|0)==23){k=0;j=h}else if((k|0)==24){k=0;if((i&16777215|0)==6909556){g=68;k=31;break}else j=h}g=a[f>>0]|0;if(!(g<<24>>24)){g=j;k=31;break}else h=j}if((k|0)==31)return g|0}else if((k|0)==26){f=c[e+44>>2]|0;if(f|0){e=b[e+32>>1]|0;if(e<<16>>16<=-1){k=68;return k|0}k=a[(c[f+4>>2]|0)+(e<<16>>16<<4)+13>>0]|0;return k|0}}else if((k|0)==31)return g|0;k=a[e+1>>0]|0;return k|0}function Wj(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;l=b+20|0;m=a[l>>0]|0;n=m<<24>>24==2;if(n?c[e+4>>2]&1|0:0){a[l>>0]=0;n=2;return n|0}a:do switch(a[e>>0]|0){case -95:{if((m&255)>3){n=0;return n|0}if(c[e+4>>2]&524288|0){n=0;return n|0}a[l>>0]=0;n=2;return n|0}case 59:{if(!(c[e+4>>2]&67108864)){g=c[e+8>>2]|0;k=a[g>>0]|0;j=d[208+(k&255)>>0]|0;f=j+-116|0;k=k<<24>>24==0;if(!(k|(f|0)!=0)){h=41806;i=g;do{i=i+1|0;h=h+1|0;o=a[i>>0]|0;f=(d[208+(o&255)>>0]|0)-(d[208+(d[h>>0]|0)>>0]|0)|0}while(!(o<<24>>24==0|(f|0)!=0))}if(f|0){f=j+-102|0;if(!(k|(f|0)!=0)){h=41811;do{g=g+1|0;h=h+1|0;o=a[g>>0]|0;f=(d[208+(o&255)>>0]|0)-(d[208+(d[h>>0]|0)>>0]|0)|0}while(!(o<<24>>24==0|(f|0)!=0))}if(f|0){f=18;break a}}a[e>>0]=-97;o=1;return o|0}else f=18;break}case -92:case -93:case -94:{f=18;break}case -88:case -85:break;case -108:switch(m<<24>>24){case 5:{a[e>>0]=114;o=0;return o|0}case 4:{a[l>>0]=0;o=2;return o|0}default:{o=0;return o|0}}default:{o=0;return o|0}}while(0);do if((f|0)==18){if(c[e+4>>2]&8|0){if(n)break;else f=0;return f|0}if(m<<24>>24==3?(c[e+28>>2]|0)==(c[b+24>>2]|0):0){o=0;return o|0}}while(0);a[l>>0]=0;o=2;return o|0}function Xj(b,c){b=b|0;c=c|0;a[b+20>>0]=0;return 2}function Yj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;f=b+4|0;e=Va[c[f>>2]&255](b,d)|0;a:do if(!e){p=d;while(1){if(c[p+4>>2]&8404992|0){g=0;d=56;break}d=c[p+12>>2]|0;if(d|0?Yj(b,d)|0:0){g=2;d=56;break}e=c[p+16>>2]|0;if(!e){d=9;break}d=Va[c[f>>2]&255](b,e)|0;if(!d)p=e;else{q=d;break a}}if((d|0)==9){k=p+4|0;b:do if(!(c[k>>2]&2048)){d=c[p+20>>2]|0;if(d|0?(i=c[d>>2]|0,(i|0)>0):0){f=d+4|0;d=i;while(1){e=c[f>>2]|0;if(e|0?Yj(b,e)|0:0){g=2;break}if((d|0)>1){f=f+20|0;d=d+-1|0}else break b}return g|0}}else{e=c[p+20>>2]|0;if(e|0?(m=b+8|0,h=c[m>>2]|0,h|0):0){j=b+12|0;d=Va[h&255](b,e)|0;c:do if(!d){d:while(1){if(_j(b,e)|0){g=2;d=56;break}d=c[e+32>>2]|0;f=c[d>>2]|0;if((f|0)>0){i=d+8|0;while(1){d=c[i+20>>2]|0;if(d|0?Zj(b,d)|0:0){g=2;d=56;break d}if((a[i+37>>0]&4?(n=c[i+64>>2]|0,n|0):0)?(o=c[n>>2]|0,(o|0)>0):0){d=n+4|0;g=o;while(1){h=c[d>>2]|0;if(h|0?Yj(b,h)|0:0){g=2;d=56;break d}if((g|0)>1){d=d+20|0;g=g+-1|0}else break}}if((f|0)>1){i=i+72|0;f=f+-1|0}else break}}d=c[j>>2]|0;if(d|0)$a[d&127](b,e);e=c[e+52>>2]|0;if(!e)break b;d=Va[c[m>>2]&255](b,e)|0;if(d|0){l=d;break c}}if((d|0)==56)return g|0}else l=d;while(0);if(l&2|0){s=2;return s|0}}}while(0);if(!(c[k>>2]&16777216)){s=0;return s|0}d=c[p+44>>2]|0;if(!d){s=0;return s|0}e:while(1){e=c[d+12>>2]|0;if(e|0?(s=c[e>>2]|0,(s|0)>0):0){e=e+4|0;f=s;while(1){g=c[e>>2]|0;if(g|0?Yj(b,g)|0:0){g=2;d=56;break e}if((f|0)>1){e=e+20|0;f=f+-1|0}else break}}e=c[d+8>>2]|0;if(e|0?(r=c[e>>2]|0,(r|0)>0):0){e=e+4|0;f=r;while(1){g=c[e>>2]|0;if(g|0?Yj(b,g)|0:0){g=2;d=56;break e}if((f|0)>1){e=e+20|0;f=f+-1|0}else break}}e=c[d+36>>2]|0;if(e|0?Yj(b,e)|0:0){g=2;d=56;break}d=c[d+32>>2]|0;if(!d){g=0;d=56;break}}if((d|0)==56)return g|0}else if((d|0)==56)return g|0}else q=e;while(0);s=q&2;return s|0}function Zj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;if(!d){m=0;return m|0}l=b+8|0;e=c[l>>2]|0;if(!e){m=0;return m|0}m=b+12|0;e=Va[e&255](b,d)|0;a:do if(!e){b:while(1){if(_j(b,d)|0){e=2;d=23;break}e=c[d+32>>2]|0;f=c[e>>2]|0;if((f|0)>0){i=e+8|0;while(1){e=c[i+20>>2]|0;if(e|0?Zj(b,e)|0:0){e=2;d=23;break b}if((a[i+37>>0]&4?(j=c[i+64>>2]|0,j|0):0)?(k=c[j>>2]|0,(k|0)>0):0){e=j+4|0;g=k;while(1){h=c[e>>2]|0;if(h|0?Yj(b,h)|0:0){e=2;d=23;break b}if((g|0)>1){e=e+20|0;g=g+-1|0}else break}}if((f|0)>1){i=i+72|0;f=f+-1|0}else break}}e=c[m>>2]|0;if(e|0)$a[e&127](b,d);d=c[d+52>>2]|0;if(!d){e=0;d=23;break}e=Va[c[l>>2]&255](b,d)|0;if(e|0)break a}if((d|0)==23)return e|0}while(0);m=e&2;return m|0}function _j(a,b){a=a|0;b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=c[b>>2]|0;a:do if(e|0?(f=c[e>>2]|0,(f|0)>0):0){g=e+4|0;e=f;while(1){f=c[g>>2]|0;if(f|0?Yj(a,f)|0:0){e=2;break}if((e|0)>1){g=g+20|0;e=e+-1|0}else break a}return e|0}while(0);e=c[b+36>>2]|0;if(e|0?Yj(a,e)|0:0){k=2;return k|0}e=c[b+40>>2]|0;b:do if(e|0?(h=c[e>>2]|0,(h|0)>0):0){g=e+4|0;e=h;while(1){f=c[g>>2]|0;if(f|0?Yj(a,f)|0:0){e=2;break}if((e|0)>1){g=g+20|0;e=e+-1|0}else break b}return e|0}while(0);e=c[b+44>>2]|0;if(e|0?Yj(a,e)|0:0){k=2;return k|0}e=c[b+48>>2]|0;c:do if(e|0?(i=c[e>>2]|0,(i|0)>0):0){g=e+4|0;e=i;while(1){f=c[g>>2]|0;if(f|0?Yj(a,f)|0:0){e=2;break}if((e|0)>1){g=g+20|0;e=e+-1|0}else break c}return e|0}while(0);e=c[b+60>>2]|0;if(e|0?Yj(a,e)|0:0){k=2;return k|0}e=c[a>>2]|0;if(!e){k=0;return k|0}if((d[e+200>>0]|0)<=1){k=0;return k|0}e=c[b+72>>2]|0;if(!e){k=0;return k|0}d:while(1){f=c[e+12>>2]|0;if(f|0?(j=c[f>>2]|0,(j|0)>0):0){f=f+4|0;g=j;while(1){h=c[f>>2]|0;if(h|0?Yj(a,h)|0:0){e=2;f=44;break d}if((g|0)>1){f=f+20|0;g=g+-1|0}else break}}f=c[e+8>>2]|0;if(f|0?(k=c[f>>2]|0,(k|0)>0):0){f=f+4|0;g=k;while(1){h=c[f>>2]|0;if(h|0?Yj(a,h)|0:0){e=2;f=44;break d}if((g|0)>1){f=f+20|0;g=g+-1|0}else break}}f=c[e+36>>2]|0;if(f|0?Yj(a,f)|0:0){e=2;f=44;break}e=c[e+32>>2]|0;if(!e){e=0;f=44;break}}if((f|0)==44)return e|0;return 0}function $j(f,g,h,i){f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=Qa;Qa=Qa+16|0;j=t;if((g|0)==0|(h|0)==0){i=(h|0)==(g|0)?0:2;Qa=t;return i|0}do if(f|0?(a[g>>0]|0)==-108:0){c[j>>2]=0;Uj(c[f>>2]|0,h,1,65,j)|0;s=c[j>>2]|0;if(!s)break;n=b[g+32>>1]|0;j=n<<16>>16;o=c[f+8>>2]|0;n=n<<16>>16>31;k=o+208|0;o=o+208|0;c[(n?o:k)>>2]=c[(n?o:k)>>2]|(n?-2147483648:1<<j+-1);k=c[f+220>>2]|0;a:do if((k|0)!=0?(o=c[k+100>>2]|0,q=j+-1|0,p=o+(q*40|0)|0,q=o+(q*40|0)+8|0,(b[q>>1]&1)==0):0){n=c[k>>2]|0;b:do if(!n){if(!(c[7324]|0)){j=Ua[c[29340>>2]&127](40)|0;r=32;break}j=Ua[c[29356>>2]&127](40)|0;if((c[14985]|0)>>>0<40)c[14985]=40;l=59064;k=c[l>>2]|0;l=c[l+4>>2]|0;if((l|0)>0|(l|0)==0&k>>>0>0){o=c[14978]|0;m=Rv(k|0,l|0,j|0,((j|0)<0)<<31>>31|0)|0;l=L()|0;c[14768]=((l|0)<0|(l|0)==0&m>>>0<=o>>>0)&1}k=Ua[c[29340>>2]&127](j)|0;if(!k){n=0;l=0;m=0;k=1;break a}j=Ua[c[29352>>2]&127](k)|0;j=(c[14978]|0)+j|0;c[14978]=j;if(j>>>0>(c[14982]|0)>>>0)c[14982]=j;j=(c[14981]|0)+1|0;c[14981]=j;if(j>>>0>(c[14987]|0)>>>0){c[14987]=j;o=k}else o=k}else{if(c[n+272>>2]|0){if(a[n+81>>0]|0){n=0;l=0;m=0;k=1;break a}}else{do if((e[n+276>>1]|0)>=40){k=n+300|0;j=c[k>>2]|0;if(j|0){c[k>>2]=c[j>>2];r=n+284|0;c[r>>2]=(c[r>>2]|0)+1;r=32;break b}k=n+296|0;j=c[k>>2]|0;if(!j){j=n+292|0;break}else{c[k>>2]=c[j>>2];r=n+284|0;c[r>>2]=(c[r>>2]|0)+1;r=32;break b}}else j=n+288|0;while(0);c[j>>2]=(c[j>>2]|0)+1}j=Yd(n,40,0)|0;r=32}while(0);if((r|0)==32)if(!j){n=0;l=0;m=0;k=1;break}else o=j;j=o;k=j+40|0;do{a[j>>0]=0;j=j+1|0}while((j|0)<(k|0));m=o+8|0;b[m>>1]=1;c[o+32>>2]=n;c[o>>2]=c[p>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[o+12>>2]=c[p+12>>2];c[o+16>>2]=c[p+16>>2];j=b[m>>1]&-1025;b[m>>1]=j;j=j&65535;c:do if(j&18|0?(b[q>>1]&2048)==0:0){k=(j|4096)&65535;b[m>>1]=k;do if(j&16384){l=o+12|0;j=(c[o>>2]|0)+(c[l>>2]|0)|0;if((j|0)<1)if(!(k&16)){r=41;break}else j=1;if(Cg(o,j,1)|0)break c;q=o+16|0;ew((c[q>>2]|0)+(c[l>>2]|0)|0,0,c[o>>2]|0)|0;c[l>>2]=(c[l>>2]|0)+(c[o>>2]|0);j=b[m>>1]&-16897;b[m>>1]=j;if(!((c[o+24>>2]|0)!=0?(c[q>>2]|0)==(c[o+20>>2]|0):0))r=41}else r=41;while(0);if((r|0)==41){if(Hg(o)|0)break;j=b[m>>1]|0}b[m>>1]=j&-4097}while(0);j=b[m>>1]|0;do if((j&15|16)<<16>>16==18){if((j&514)==514){if(!((j&1)==0&(a[o+10>>0]|0)!=1))break}else if(j&1)break;Eg(o,1)|0}while(0);n=(Rg(o,s,0)|0)==0&1;l=o;m=o;k=0}else{n=0;l=0;m=0;k=1}while(0);if(!((b[s+8>>1]&9216)==0?!(c[s+24>>2]|0):0))Ag(s);j=c[s+32>>2]|0;do if(j){if(c[j+480>>2]|0){Vd(j,s);break}q=s;if((c[j+304>>2]|0)>>>0<=q>>>0?(c[j+308>>2]|0)>>>0>q>>>0:0){q=j+300|0;c[s>>2]=c[q>>2];c[q>>2]=s}else r=59}else r=59;while(0);do if((r|0)==59)if(!(c[7324]|0)){_a[c[29344>>2]&127](s);break}else{r=Ua[c[29352>>2]&127](s)|0;c[14978]=(c[14978]|0)-r;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](s);break}while(0);do if(!k){if(!((b[l+8>>1]&9216)==0?!(c[l+24>>2]|0):0))Ag(l);j=c[l+32>>2]|0;if(j|0){if(c[j+480>>2]|0){Vd(j,m);break}s=m;if((c[j+304>>2]|0)>>>0<=s>>>0?(c[j+308>>2]|0)>>>0>s>>>0:0){s=j+300|0;c[m>>2]=c[s>>2];c[s>>2]=m;break}}if(m|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](m);break}else{s=Ua[c[29352>>2]&127](m)|0;c[14978]=(c[14978]|0)-s;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](m);break}}while(0);if(n|0){i=0;Qa=t;return i|0}}while(0);o=g+4|0;p=c[o>>2]|0;n=h+4|0;k=c[n>>2]|0;q=k|p;if(q&1024|0){if(p&1024&k|0?(c[g+8>>2]|0)==(c[h+8>>2]|0):0){i=0;Qa=t;return i|0}i=2;Qa=t;return i|0}m=a[g>>0]|0;j=a[h>>0]|0;if(m<<24>>24==71?1:m<<24>>24!=j<<24>>24){do if(m<<24>>24==106)if(($j(f,c[g+12>>2]|0,h,i)|0)<2){i=1;Qa=t;return i|0}else{j=a[h>>0]|0;break}while(0);if(j<<24>>24==106?($j(f,g,c[h+12>>2]|0,i)|0)<2:0){i=1;Qa=t;return i|0}i=2;Qa=t;return i|0}d:do switch(m<<24>>24){case -92:case -94:{j=p;break}default:{l=c[g+8>>2]|0;if(!l)j=p;else switch(m<<24>>24){case -95:{m=c[h+8>>2]|0;s=a[l>>0]|0;j=(d[208+(s&255)>>0]|0)-(d[208+(d[m>>0]|0)>>0]|0)|0;if(!(s<<24>>24==0|(j|0)!=0))do{l=l+1|0;m=m+1|0;s=a[l>>0]|0;j=(d[208+(s&255)>>0]|0)-(d[208+(d[m>>0]|0)>>0]|0)|0}while(!(s<<24>>24==0|(j|0)!=0));if(j|0){i=2;Qa=t;return i|0}if(!(p&16777216)){j=p;break d}if(!(ak(f,c[g+44>>2]|0,c[h+44>>2]|0)|0)){k=c[n>>2]|0;j=c[o>>2]|0;break d}else{i=2;Qa=t;return i|0}}case 106:{m=c[h+8>>2]|0;if(!m){i=2;Qa=t;return i|0}s=a[l>>0]|0;j=(d[208+(s&255)>>0]|0)-(d[208+(d[m>>0]|0)>>0]|0)|0;if(!(s<<24>>24==0|(j|0)!=0))do{l=l+1|0;m=m+1|0;s=a[l>>0]|0;j=(d[208+(s&255)>>0]|0)-(d[208+(d[m>>0]|0)>>0]|0)|0}while(!(s<<24>>24==0|(j|0)!=0));if(!j){j=p;break d}else j=2;Qa=t;return j|0}case 114:{i=0;Qa=t;return i|0}default:{j=c[h+8>>2]|0;if(!j){j=p;break d}if(!(zu(l,j)|0)){j=p;break d}else j=2;Qa=t;return j|0}}}}while(0);if((k^j)&2|0){i=2;Qa=t;return i|0}e:do if(!(q&16384)){if(q&2048|0){i=2;Qa=t;return i|0}if((q&8|0)==0?$j(f,c[g+12>>2]|0,c[h+12>>2]|0,i)|0:0){i=2;Qa=t;return i|0}if($j(f,c[g+16>>2]|0,c[h+16>>2]|0,i)|0){i=2;Qa=t;return i|0}l=c[g+20>>2]|0;m=c[h+20>>2]|0;j=(l|0)==0;k=(m|0)==0;f:do if(!(j&k)){if(j|k){i=2;Qa=t;return i|0}j=c[l>>2]|0;if((j|0)!=(c[m>>2]|0)){i=2;Qa=t;return i|0}if((j|0)>0){j=0;while(1){if((a[l+4+(j*20|0)+12>>0]|0)!=(a[m+4+(j*20|0)+12>>0]|0)){j=2;r=125;break}if($j(0,c[l+4+(j*20|0)>>2]|0,c[m+4+(j*20|0)>>2]|0,i)|0){j=2;r=125;break}j=j+1|0;if((j|0)>=(c[l>>2]|0))break f}if((r|0)==125){Qa=t;return j|0}}}while(0);switch(a[g>>0]|0){case -97:case 110:break e;default:{}}if(!(q&8192)){if((b[g+32>>1]|0)!=(b[h+32>>1]|0)){i=2;Qa=t;return i|0}g=c[g+28>>2]|0;h=c[h+28>>2]|0;if((g|0)!=(h|0)?(g|0)!=(i|0)|(h|0)>-1:0){i=2;Qa=t;return i|0}}}while(0);i=0;Qa=t;return i|0}function ak(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;if((a[d+16>>0]|0)!=(a[e+16>>0]|0)){e=1;return e|0}if((a[d+17>>0]|0)!=(a[e+17>>0]|0)){e=1;return e|0}if((a[d+18>>0]|0)!=(a[e+18>>0]|0)){e=1;return e|0}if((a[d+20>>0]|0)!=(a[e+20>>0]|0)){e=1;return e|0}if($j(b,c[d+24>>2]|0,c[e+24>>2]|0,-1)|0){e=1;return e|0}if($j(b,c[d+28>>2]|0,c[e+28>>2]|0,-1)|0){e=1;return e|0}g=c[d+8>>2]|0;h=c[e+8>>2]|0;b=(g|0)==0;f=(h|0)==0;a:do if(!(b&f)){if(b|f){e=1;return e|0}b=c[g>>2]|0;if((b|0)!=(c[h>>2]|0)){e=1;return e|0}if((b|0)>0){b=0;while(1){if((a[g+4+(b*20|0)+12>>0]|0)!=(a[h+4+(b*20|0)+12>>0]|0)){b=1;f=23;break}if($j(0,c[g+4+(b*20|0)>>2]|0,c[h+4+(b*20|0)>>2]|0,-1)|0){b=1;f=23;break}b=b+1|0;if((b|0)>=(c[g>>2]|0))break a}if((f|0)==23)return b|0}}while(0);h=c[d+12>>2]|0;g=c[e+12>>2]|0;b=(h|0)==0;f=(g|0)==0;if(b&f){e=0;return e|0}if(b|f){e=1;return e|0}b=c[h>>2]|0;if((b|0)!=(c[g>>2]|0)){e=1;return e|0}if((b|0)<=0){e=0;return e|0}b=0;while(1){if((a[h+4+(b*20|0)+12>>0]|0)!=(a[g+4+(b*20|0)+12>>0]|0)){b=1;f=23;break}if($j(0,c[h+4+(b*20|0)>>2]|0,c[g+4+(b*20|0)>>2]|0,-1)|0){b=1;f=23;break}b=b+1|0;if((b|0)>=(c[h>>2]|0)){b=0;f=23;break}}if((f|0)==23)return b|0;return 0}function bk(b,d,f,g){b=b|0;d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=Qa;Qa=Qa+16|0;r=t;s=(g|0)!=0;a:do if(s){m=134217728;q=c[g>>2]|0}else{j=ck(d,f)|0;k=((j|0)<0)<<31>>31;if(c[b+272>>2]|0){if(a[b+81>>0]|0){c[r>>2]=0;b=0;Qa=t;return b|0}}else{do if(!(0<k>>>0|(0==(k|0)?(e[b+276>>1]|0)>>>0<j>>>0:0))){h=b+300|0;i=c[h>>2]|0;if(i|0){c[h>>2]=c[i>>2];m=b+284|0;c[m>>2]=(c[m>>2]|0)+1;m=0;q=i;break a}h=b+296|0;i=c[h>>2]|0;if(!i){h=b+292|0;break}else{c[h>>2]=c[i>>2];m=b+284|0;c[m>>2]=(c[m>>2]|0)+1;m=0;q=i;break a}}else h=b+288|0;while(0);c[h>>2]=(c[h>>2]|0)+1}m=0;q=Yd(b,j,k)|0}while(0);c[r>>2]=q;if(!q){b=q;Qa=t;return b|0}n=(f|0)==0;if((!n?(a[d>>0]|0)!=-86:0)?(c[d+4>>2]&16777216|0)==0:0)if(!(c[d+12>>2]|0))j=(c[d+20>>2]|0)==0?16396:8220;else j=8220;else j=52;k=j&60;o=d+4|0;h=c[o>>2]|0;if((h&1024|0)==0?(l=c[d+8>>2]|0,(l|0)!=0):0)i=((Cu(l)|0)&1073741823)+1|0;else i=0;if(n){h=(h&16384|0)==0?((h&8192|0)==0?52:28):12;cw(q|0,d|0,h|0)|0;if(h>>>0<52)ew(q+h|0,0,52-h|0)|0}else cw(q|0,d|0,k|0)|0;l=q+4|0;h=j&24576|m|c[l>>2]&-134307841;c[l>>2]=h;if(i){h=q+k|0;c[q+8>>2]=h;cw(h|0,c[d+8>>2]|0,i|0)|0;h=c[l>>2]|0}i=c[o>>2]|0;do if(!((h|i)&8404992)){h=d+20|0;if(!(i&2048)){c[q+20>>2]=ek(b,c[h>>2]|0,f)|0;break}else{c[q+20>>2]=dk(b,c[h>>2]|0,f)|0;break}}while(0);j=c[l>>2]|0;if(!(j&16801792)){if(c[o>>2]&8404992|0){b=q;Qa=t;return b|0}h=d+12|0;if((a[q>>0]|0)==-86)c[q+12>>2]=c[h>>2];else{h=c[h>>2]|0;if(!h)h=0;else h=bk(b,h,0,0)|0;c[q+12>>2]=h}h=c[d+16>>2]|0;if(!h)h=0;else h=bk(b,h,0,0)|0;c[q+16>>2]=h;b=q;Qa=t;return b|0}if((!n?(a[d>>0]|0)!=-86:0)?(c[o>>2]&16777216|0)==0:0)if(!(c[d+12>>2]|0))i=(c[d+20>>2]|0)==0?12:28;else i=28;else i=52;h=c[o>>2]|0;if((h&1024|0)==0?(p=c[d+8>>2]|0,(p|0)!=0):0)i=((Cu(p)|0)&1073741823)+(i|1)|0;c[r>>2]=q+(i+7&-8);if(!(j&8404992)){h=c[d+12>>2]|0;if(!h)h=0;else h=bk(b,h,1,r)|0;c[q+12>>2]=h;h=c[d+16>>2]|0;if(!h)h=0;else h=bk(b,h,1,r)|0;c[q+16>>2]=h;h=c[o>>2]|0}if(h&16777216|0)c[q+44>>2]=fk(b,q,c[d+44>>2]|0)|0;if(!s){b=q;Qa=t;return b|0}c[g>>2]=c[r>>2];b=q;Qa=t;return b|0}function ck(b,d){b=b|0;d=d|0;var e=0,f=0;if(!b){d=0;return d|0}if(((d|0)!=0?(a[b>>0]|0)!=-86:0)?(c[b+4>>2]&16777216|0)==0:0)if(!(c[b+12>>2]|0))e=(c[b+20>>2]|0)==0?12:28;else e=28;else e=52;if((c[b+4>>2]&1024|0)==0?(f=c[b+8>>2]|0,(f|0)!=0):0)e=((Cu(f)|0)&1073741823)+(e|1)|0;e=e+7&-8;if(!(d&1)){d=e;return d|0}else{f=ck(c[b+12>>2]|0,d)|0;return f+e+(ck(c[b+16>>2]|0,d)|0)|0}return 0}function dk(d,f,g){d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;G=Qa;Qa=Qa+32|0;A=G+4|0;B=G;c[B>>2]=0;C=d+81|0;if(!f){F=0;Qa=G;return F|0}D=d+272|0;E=d+276|0;F=d+288|0;s=d+300|0;t=d+296|0;u=d+284|0;v=d+292|0;w=A+4|0;x=A+8|0;y=A+12|0;z=A+24|0;j=0;r=B;a:while(1){do if(c[D>>2]|0)if(!(a[C>>0]|0))q=11;else break a;else{if((e[E>>1]|0)>=76){h=c[s>>2]|0;if(h|0){c[s>>2]=c[h>>2];c[u>>2]=(c[u>>2]|0)+1;break}h=c[t>>2]|0;if(!h)h=v;else{c[t>>2]=c[h>>2];c[u>>2]=(c[u>>2]|0)+1;break}}else h=F;c[h>>2]=(c[h>>2]|0)+1;q=11}while(0);if((q|0)==11){q=0;h=Yd(d,76,0)|0}if(!h)break;c[h>>2]=ek(d,c[f>>2]|0,g)|0;c[h+32>>2]=gk(d,c[f+32>>2]|0,g)|0;i=c[f+36>>2]|0;if(!i)i=0;else i=bk(d,i,g,0)|0;c[h+36>>2]=i;c[h+40>>2]=ek(d,c[f+40>>2]|0,g)|0;i=c[f+44>>2]|0;if(!i)i=0;else i=bk(d,i,g,0)|0;c[h+44>>2]=i;c[h+48>>2]=ek(d,c[f+48>>2]|0,g)|0;a[h+4>>0]=a[f+4>>0]|0;c[h+56>>2]=j;p=r;r=h+52|0;c[r>>2]=0;i=c[f+60>>2]|0;if(!i)i=0;else i=bk(d,i,g,0)|0;c[h+60>>2]=i;c[h+12>>2]=0;c[h+16>>2]=0;c[h+8>>2]=c[f+8>>2]&-33;c[h+24>>2]=-1;c[h+28>>2]=-1;b[h+6>>1]=b[f+6>>1]|0;o=c[f+64>>2]|0;b:do if(o){j=c[o>>2]<<4|8;do if(c[D>>2]|0)if(!(a[C>>0]|0))q=28;else{i=0;break b}else{if(!(0<0|(0==0?(e[E>>1]|0)>>>0<j>>>0:0))){i=c[s>>2]|0;if(i|0){c[s>>2]=c[i>>2];c[u>>2]=(c[u>>2]|0)+1;break}i=c[t>>2]|0;if(!i)i=v;else{c[t>>2]=c[i>>2];c[u>>2]=(c[u>>2]|0)+1;break}}else i=F;c[i>>2]=(c[i>>2]|0)+1;q=28}while(0);if((q|0)==28){q=0;i=Yd(d,j,0)|0}if(i){ew(i|0,0,j|0)|0;c[i>>2]=c[o>>2];if((c[o>>2]|0)>0){n=i+8|0;m=0;do{c[n+(m<<4)+8>>2]=dk(d,c[o+8+(m<<4)+8>>2]|0,0)|0;c[n+(m<<4)+4>>2]=ek(d,c[o+8+(m<<4)+4>>2]|0,0)|0;k=c[o+8+(m<<4)>>2]|0;c:do if(k){l=(Cu(k)|0)+1|0;d:do if(c[D>>2]|0)if(!(a[C>>0]|0))q=41;else{j=0;break c}else{do if(0<0|(0==0?(e[E>>1]|0)>>>0<l>>>0:0))j=F;else{j=c[s>>2]|0;if(j|0){c[s>>2]=c[j>>2];c[u>>2]=(c[u>>2]|0)+1;break d}j=c[t>>2]|0;if(!j){j=v;break}c[t>>2]=c[j>>2];c[u>>2]=(c[u>>2]|0)+1;break d}while(0);c[j>>2]=(c[j>>2]|0)+1;q=41}while(0);if((q|0)==41){q=0;j=Yd(d,l,0)|0}if(j)cw(j|0,k|0,l|0)|0;else j=0}else j=0;while(0);c[n+(m<<4)>>2]=j;m=m+1|0}while((m|0)<(c[o>>2]|0))}}else i=0}else i=0;while(0);c[h+64>>2]=i;c[h+68>>2]=0;i=c[f+72>>2]|0;c[A>>2]=0;if(!i)i=0;else{k=A;while(1){j=fk(d,0,i)|0;c[k>>2]=j;if(!j)break;i=c[i+32>>2]|0;if(!i)break;else k=j+32|0}i=c[A>>2]|0}c[h+72>>2]=i;if(c[f+68>>2]|0){c[w>>2]=137;c[x>>2]=138;c[y>>2]=0;c[A>>2]=0;c[z>>2]=h;Zj(A,h)|0}c[h+20>>2]=c[f+20>>2];c[p>>2]=h;f=c[f+52>>2]|0;if(!f)break;else j=h}F=c[B>>2]|0;Qa=G;return F|0}function ek(d,f,g){d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;if(!f){A=0;return A|0}A=(d|0)==0;if((!A?(h=f,(c[d+304>>2]|0)>>>0<=h>>>0):0)?(c[d+308>>2]|0)>>>0>h>>>0:0)j=e[d+276>>1]|0;else j=Ua[c[29352>>2]&127](f)|0;k=((j|0)<0)<<31>>31;z=d+272|0;a:do if(c[z>>2]|0)if(!(a[d+81>>0]|0))y=17;else{A=0;return A|0}else{do if(!(0<k>>>0|(0==(k|0)?(e[d+276>>1]|0)>>>0<j>>>0:0))){i=d+300|0;h=c[i>>2]|0;if(h|0){c[i>>2]=c[h>>2];x=d+284|0;c[x>>2]=(c[x>>2]|0)+1;break a}i=d+296|0;h=c[i>>2]|0;if(!h){h=d+292|0;break}else{c[i>>2]=c[h>>2];x=d+284|0;c[x>>2]=(c[x>>2]|0)+1;break a}}else h=d+288|0;while(0);c[h>>2]=(c[h>>2]|0)+1;y=17}while(0);if((y|0)==17)h=Yd(d,j,k)|0;if(!h){A=0;return A|0}c[h>>2]=c[f>>2];if((c[f>>2]|0)<=0){A=h;return A|0}r=d+276|0;s=d+81|0;t=d+288|0;u=d+300|0;v=d+296|0;w=d+284|0;x=d+292|0;o=h+4|0;i=0;p=0;q=f+4|0;while(1){j=c[q>>2]|0;do if(j){k=bk(d,j,g,0)|0;c[o>>2]=k;if(!((k|0)==0|(a[j>>0]|0)!=-86))if(!(b[k+32>>1]|0)){n=c[k+16>>2]|0;c[k+12>>2]=n;break}else{c[k+12>>2]=i;n=i;break}else n=i}else{c[o>>2]=0;n=i}while(0);l=c[q+4>>2]|0;b:do if(!l)i=0;else{m=(Cu(l)|0)+1|0;do if(A){k=Qv(m|0,0,-1,-1)|0;j=L()|0;if(j>>>0>0|(j|0)==0&k>>>0>2147483390){i=0;break b}if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](m)|0;y=50;break}i=Ua[c[29356>>2]&127](m)|0;if((c[14985]|0)>>>0<m>>>0)c[14985]=m;k=59064;j=c[k>>2]|0;k=c[k+4>>2]|0;if((k|0)>0|(k|0)==0&j>>>0>0){B=c[14978]|0;k=Rv(j|0,k|0,i|0,((i|0)<0)<<31>>31|0)|0;j=L()|0;c[14768]=((j|0)<0|(j|0)==0&k>>>0<=B>>>0)&1}i=Ua[c[29340>>2]&127](i)|0;if(!i){i=0;break b}j=Ua[c[29352>>2]&127](i)|0;j=(c[14978]|0)+j|0;c[14978]=j;if(j>>>0>(c[14982]|0)>>>0)c[14982]=j;j=(c[14981]|0)+1|0;c[14981]=j;if(j>>>0>(c[14987]|0)>>>0)c[14987]=j}else{if(c[z>>2]|0){if(a[s>>0]|0){i=0;break b}}else{if(!(0<0|(0==0?(e[r>>1]|0)>>>0<m>>>0:0))){i=c[u>>2]|0;if(i|0){c[u>>2]=c[i>>2];c[w>>2]=(c[w>>2]|0)+1;y=50;break}i=c[v>>2]|0;if(!i)i=x;else{c[v>>2]=c[i>>2];c[w>>2]=(c[w>>2]|0)+1;y=50;break}}else i=t;c[i>>2]=(c[i>>2]|0)+1}i=Yd(d,m,0)|0;y=50}while(0);if((y|0)==50){y=0;if(!i){i=0;break}}cw(i|0,l|0,m|0)|0}while(0);c[o+4>>2]=i;l=c[q+8>>2]|0;c:do if(!l)i=0;else{m=(Cu(l)|0)+1|0;do if(A){B=Qv(m|0,0,-1,-1)|0;k=L()|0;if(k>>>0>0|(k|0)==0&B>>>0>2147483390){i=0;break c}if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](m)|0;y=75;break}i=Ua[c[29356>>2]&127](m)|0;if((c[14985]|0)>>>0<m>>>0)c[14985]=m;k=59064;j=c[k>>2]|0;k=c[k+4>>2]|0;if((k|0)>0|(k|0)==0&j>>>0>0){B=c[14978]|0;k=Rv(j|0,k|0,i|0,((i|0)<0)<<31>>31|0)|0;j=L()|0;c[14768]=((j|0)<0|(j|0)==0&k>>>0<=B>>>0)&1}i=Ua[c[29340>>2]&127](i)|0;if(!i){i=0;break c}j=Ua[c[29352>>2]&127](i)|0;j=(c[14978]|0)+j|0;c[14978]=j;if(j>>>0>(c[14982]|0)>>>0)c[14982]=j;j=(c[14981]|0)+1|0;c[14981]=j;if(j>>>0>(c[14987]|0)>>>0)c[14987]=j}else{if(c[z>>2]|0){if(a[s>>0]|0){i=0;break c}}else{if(!(0<0|(0==0?(e[r>>1]|0)>>>0<m>>>0:0))){i=c[u>>2]|0;if(i|0){c[u>>2]=c[i>>2];c[w>>2]=(c[w>>2]|0)+1;y=75;break}i=c[v>>2]|0;if(!i)i=x;else{c[v>>2]=c[i>>2];c[w>>2]=(c[w>>2]|0)+1;y=75;break}}else i=t;c[i>>2]=(c[i>>2]|0)+1}i=Yd(d,m,0)|0;y=75}while(0);if((y|0)==75){y=0;if(!i){i=0;break}}cw(i|0,l|0,m|0)|0}while(0);c[o+8>>2]=i;a[o+12>>0]=a[q+12>>0]|0;B=o+13|0;l=a[B>>0]|0;a[B>>0]=l&-2;m=q+13|0;l=a[m>>0]&2|l&-4;a[B>>0]=l;a[B>>0]=l&-10|a[m>>0]&8;c[o+16>>2]=c[q+16>>2];p=p+1|0;if((p|0)>=(c[f>>2]|0))break;else{o=o+20|0;i=n;q=q+20|0}}return h|0}function fk(b,d,f){b=b|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;if(!f){d=0;return d|0}j=(b|0)==0;a:do if(j){if(!(c[7324]|0)){g=Ua[c[29340>>2]&127](92)|0;m=25;break}g=Ua[c[29356>>2]&127](92)|0;if((c[14985]|0)>>>0<92)c[14985]=92;i=59064;h=c[i>>2]|0;i=c[i+4>>2]|0;if((i|0)>0|(i|0)==0&h>>>0>0){l=c[14978]|0;k=Rv(h|0,i|0,g|0,((g|0)<0)<<31>>31|0)|0;i=L()|0;c[14768]=((i|0)<0|(i|0)==0&k>>>0<=l>>>0)&1}h=Ua[c[29340>>2]&127](g)|0;if(!h){d=0;return d|0}g=Ua[c[29352>>2]&127](h)|0;g=(c[14978]|0)+g|0;c[14978]=g;if(g>>>0>(c[14982]|0)>>>0)c[14982]=g;g=(c[14981]|0)+1|0;c[14981]=g;if(g>>>0>(c[14987]|0)>>>0)c[14987]=g}else{if(c[b+272>>2]|0){if(a[b+81>>0]|0){d=0;return d|0}}else{do if((e[b+276>>1]|0)>=92){h=b+300|0;g=c[h>>2]|0;if(g|0){c[h>>2]=c[g>>2];m=b+284|0;c[m>>2]=(c[m>>2]|0)+1;m=25;break a}h=b+296|0;g=c[h>>2]|0;if(!g){g=b+292|0;break}else{c[h>>2]=c[g>>2];m=b+284|0;c[m>>2]=(c[m>>2]|0)+1;m=25;break a}}else g=b+288|0;while(0);c[g>>2]=(c[g>>2]|0)+1}g=Yd(b,92,0)|0;m=25}while(0);if((m|0)==25)if(!g){d=0;return d|0}else h=g;g=h;i=g+92|0;do{a[g>>0]=0;g=g+1|0}while((g|0)<(i|0));k=c[f>>2]|0;b:do if(!k)g=0;else{l=(Cu(k)|0)+1|0;c:do if(j){j=Qv(l|0,0,-1,-1)|0;i=L()|0;if(i>>>0>0|(i|0)==0&j>>>0>2147483390){g=0;break b}if(!(c[7324]|0)){g=Ua[c[29340>>2]&127](l)|0;m=51;break}g=Ua[c[29356>>2]&127](l)|0;if((c[14985]|0)>>>0<l>>>0)c[14985]=l;j=59064;i=c[j>>2]|0;j=c[j+4>>2]|0;if((j|0)>0|(j|0)==0&i>>>0>0){n=c[14978]|0;j=Rv(i|0,j|0,g|0,((g|0)<0)<<31>>31|0)|0;i=L()|0;c[14768]=((i|0)<0|(i|0)==0&j>>>0<=n>>>0)&1}g=Ua[c[29340>>2]&127](g)|0;if(!g){g=0;break b}i=Ua[c[29352>>2]&127](g)|0;i=(c[14978]|0)+i|0;c[14978]=i;if(i>>>0>(c[14982]|0)>>>0)c[14982]=i;i=(c[14981]|0)+1|0;c[14981]=i;if(i>>>0>(c[14987]|0)>>>0)c[14987]=i}else{if(c[b+272>>2]|0){if(a[b+81>>0]|0){g=0;break b}}else{do if(!(0<0|(0==0?(e[b+276>>1]|0)>>>0<l>>>0:0))){i=b+300|0;g=c[i>>2]|0;if(g|0){c[i>>2]=c[g>>2];m=b+284|0;c[m>>2]=(c[m>>2]|0)+1;m=51;break c}i=b+296|0;g=c[i>>2]|0;if(!g){g=b+292|0;break}else{c[i>>2]=c[g>>2];m=b+284|0;c[m>>2]=(c[m>>2]|0)+1;m=51;break c}}else g=b+288|0;while(0);c[g>>2]=(c[g>>2]|0)+1}g=Yd(b,l,0)|0;m=51}while(0);if((m|0)==51)if(!g){g=0;break}cw(g|0,k|0,l|0)|0}while(0);c[h>>2]=g;g=c[f+36>>2]|0;if(!g)g=0;else g=bk(b,g,0,0)|0;c[h+36>>2]=g;c[h+40>>2]=c[f+40>>2];c[h+8>>2]=ek(b,c[f+8>>2]|0,0)|0;c[h+12>>2]=ek(b,c[f+12>>2]|0,0)|0;a[h+16>>0]=a[f+16>>0]|0;a[h+18>>0]=a[f+18>>0]|0;a[h+17>>0]=a[f+17>>0]|0;a[h+20>>0]=a[f+20>>0]|0;g=c[f+24>>2]|0;if(!g)g=0;else g=bk(b,g,0,0)|0;c[h+24>>2]=g;g=c[f+28>>2]|0;if(!g)g=0;else g=bk(b,g,0,0)|0;c[h+28>>2]=g;c[h+68>>2]=d;n=h;return n|0}function gk(b,d,f){b=b|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;if(!d){f=0;return f|0}i=c[d>>2]|0;v=(i|0)>0;i=(i*72|0)+8|0;j=v?i:80;i=v?((i|0)<0)<<31>>31:0;v=b+272|0;a:do if(c[v>>2]|0)if(!(a[b+81>>0]|0))u=12;else{f=0;return f|0}else{do if(!(i>>>0>0|((i|0)==0?j>>>0>(e[b+276>>1]|0)>>>0:0))){h=b+300|0;g=c[h>>2]|0;if(g|0){c[h>>2]=c[g>>2];t=b+284|0;c[t>>2]=(c[t>>2]|0)+1;break a}h=b+296|0;g=c[h>>2]|0;if(!g){g=b+292|0;break}else{c[h>>2]=c[g>>2];t=b+284|0;c[t>>2]=(c[t>>2]|0)+1;break a}}else g=b+288|0;while(0);c[g>>2]=(c[g>>2]|0)+1;u=12}while(0);if((u|0)==12)g=Yd(b,j,i)|0;if(!g){f=0;return f|0}t=c[d>>2]|0;c[g+4>>2]=t;c[g>>2]=t;if((c[d>>2]|0)<=0){f=g;return f|0}m=g+8|0;n=b+276|0;o=b+81|0;p=b+288|0;q=b+300|0;r=b+296|0;s=b+284|0;t=b+292|0;l=0;do{c[m+(l*72|0)>>2]=c[d+8+(l*72|0)>>2];i=c[d+8+(l*72|0)+4>>2]|0;b:do if(i){j=(Cu(i)|0)+1|0;do if(c[v>>2]|0)if(!(a[o>>0]|0))u=25;else{h=0;break b}else{if(!(0<0|(0==0?(e[n>>1]|0)>>>0<j>>>0:0))){h=c[q>>2]|0;if(h|0){c[q>>2]=c[h>>2];c[s>>2]=(c[s>>2]|0)+1;break}h=c[r>>2]|0;if(!h)h=t;else{c[r>>2]=c[h>>2];c[s>>2]=(c[s>>2]|0)+1;break}}else h=p;c[h>>2]=(c[h>>2]|0)+1;u=25}while(0);if((u|0)==25){u=0;h=Yd(b,j,0)|0}if(h)cw(h|0,i|0,j|0)|0;else h=0}else h=0;while(0);c[m+(l*72|0)+4>>2]=h;i=c[d+8+(l*72|0)+8>>2]|0;c:do if(i){j=(Cu(i)|0)+1|0;do if(c[v>>2]|0)if(!(a[o>>0]|0))u=37;else{h=0;break c}else{if(!(0<0|(0==0?(e[n>>1]|0)>>>0<j>>>0:0))){h=c[q>>2]|0;if(h|0){c[q>>2]=c[h>>2];c[s>>2]=(c[s>>2]|0)+1;break}h=c[r>>2]|0;if(!h)h=t;else{c[r>>2]=c[h>>2];c[s>>2]=(c[s>>2]|0)+1;break}}else h=p;c[h>>2]=(c[h>>2]|0)+1;u=37}while(0);if((u|0)==37){u=0;h=Yd(b,j,0)|0}if(h)cw(h|0,i|0,j|0)|0;else h=0}else h=0;while(0);c[m+(l*72|0)+8>>2]=h;i=c[d+8+(l*72|0)+12>>2]|0;d:do if(i){j=(Cu(i)|0)+1|0;do if(c[v>>2]|0)if(!(a[o>>0]|0))u=49;else{h=0;break d}else{if(!(0<0|(0==0?(e[n>>1]|0)>>>0<j>>>0:0))){h=c[q>>2]|0;if(h|0){c[q>>2]=c[h>>2];c[s>>2]=(c[s>>2]|0)+1;break}h=c[r>>2]|0;if(!h)h=t;else{c[r>>2]=c[h>>2];c[s>>2]=(c[s>>2]|0)+1;break}}else h=p;c[h>>2]=(c[h>>2]|0)+1;u=49}while(0);if((u|0)==49){u=0;h=Yd(b,j,0)|0}if(h)cw(h|0,i|0,j|0)|0;else h=0}else h=0;while(0);c[m+(l*72|0)+12>>2]=h;c[m+(l*72|0)+36>>2]=c[d+8+(l*72|0)+36>>2];c[m+(l*72|0)+40>>2]=c[d+8+(l*72|0)+40>>2];c[m+(l*72|0)+24>>2]=c[d+8+(l*72|0)+24>>2];c[m+(l*72|0)+28>>2]=c[d+8+(l*72|0)+28>>2];k=m+(l*72|0)+37|0;h=a[k>>0]|0;if(h&2){i=c[d+8+(l*72|0)+64>>2]|0;e:do if(i){j=(Cu(i)|0)+1|0;do if(c[v>>2]|0)if(!(a[o>>0]|0))u=62;else{h=0;break e}else{if(!(0<0|(0==0?(e[n>>1]|0)>>>0<j>>>0:0))){h=c[q>>2]|0;if(h|0){c[q>>2]=c[h>>2];c[s>>2]=(c[s>>2]|0)+1;break}h=c[r>>2]|0;if(!h)h=t;else{c[r>>2]=c[h>>2];c[s>>2]=(c[s>>2]|0)+1;break}}else h=p;c[h>>2]=(c[h>>2]|0)+1;u=62}while(0);if((u|0)==62){u=0;h=Yd(b,j,0)|0}if(h)cw(h|0,i|0,j|0)|0;else h=0}else h=0;while(0);c[m+(l*72|0)+64>>2]=h;h=a[k>>0]|0}c[m+(l*72|0)+68>>2]=c[d+8+(l*72|0)+68>>2];if(h&4)c[m+(l*72|0)+64>>2]=ek(b,c[d+8+(l*72|0)+64>>2]|0,f)|0;h=c[d+8+(l*72|0)+16>>2]|0;c[m+(l*72|0)+16>>2]=h;if(h|0){k=h+32|0;c[k>>2]=(c[k>>2]|0)+1}c[m+(l*72|0)+20>>2]=dk(b,c[d+8+(l*72|0)+20>>2]|0,f)|0;h=c[d+8+(l*72|0)+44>>2]|0;if(!h)h=0;else h=bk(b,h,f,0)|0;c[m+(l*72|0)+44>>2]=h;c[m+(l*72|0)+48>>2]=hk(b,c[d+8+(l*72|0)+48>>2]|0)|0;i=d+8+(l*72|0)+56|0;j=c[i+4>>2]|0;k=m+(l*72|0)+56|0;c[k>>2]=c[i>>2];c[k+4>>2]=j;l=l+1|0}while((l|0)<(c[d>>2]|0));return g|0}function hk(b,d){b=b|0;d=d|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;if(!d){v=0;return v|0}v=b+272|0;a:do if(c[v>>2]|0)if(!(a[b+81>>0]|0))t=12;else{v=0;return v|0}else{do if((e[b+276>>1]|0)>=8){g=b+300|0;f=c[g>>2]|0;if(f|0){c[g>>2]=c[f>>2];u=b+284|0;c[u>>2]=(c[u>>2]|0)+1;break a}g=b+296|0;f=c[g>>2]|0;if(!f){f=b+292|0;break}else{c[g>>2]=c[f>>2];u=b+284|0;c[u>>2]=(c[u>>2]|0)+1;break a}}else f=b+288|0;while(0);c[f>>2]=(c[f>>2]|0)+1;t=12}while(0);if((t|0)==12)f=Yd(b,8,0)|0;if(!f){v=0;return v|0}u=d+4|0;c[f+4>>2]=c[u>>2];i=c[u>>2]<<3;b:do if(c[v>>2]|0)if(!(a[b+81>>0]|0))t=25;else c[f>>2]=0;else{do if(!(0<0|(0==0?(e[b+276>>1]|0)>>>0<i>>>0:0))){g=b+300|0;h=c[g>>2]|0;if(h|0){c[g>>2]=c[h>>2];t=b+284|0;c[t>>2]=(c[t>>2]|0)+1;t=26;break b}g=b+296|0;h=c[g>>2]|0;if(!h){g=b+292|0;break}else{c[g>>2]=c[h>>2];t=b+284|0;c[t>>2]=(c[t>>2]|0)+1;t=26;break b}}else g=b+288|0;while(0);c[g>>2]=(c[g>>2]|0)+1;t=25}while(0);if((t|0)==25){h=Yd(b,i,0)|0;t=26}if((t|0)==26?(c[f>>2]=h,h|0):0){if((c[u>>2]|0)<=0){v=f;return v|0}n=b+276|0;o=b+81|0;p=b+288|0;q=b+300|0;r=b+296|0;s=b+284|0;m=b+292|0;g=0;while(1){l=c[d>>2]|0;j=c[l+(g<<3)>>2]|0;c:do if(j){k=(Cu(j)|0)+1|0;do if(c[v>>2]|0)if(!(a[o>>0]|0))t=46;else{i=0;break c}else{if(!(0<0|(0==0?(e[n>>1]|0)>>>0<k>>>0:0))){i=c[q>>2]|0;if(i|0){c[q>>2]=c[i>>2];c[s>>2]=(c[s>>2]|0)+1;break}i=c[r>>2]|0;if(!i)i=m;else{c[r>>2]=c[i>>2];c[s>>2]=(c[s>>2]|0)+1;break}}else i=p;c[i>>2]=(c[i>>2]|0)+1;t=46}while(0);if((t|0)==46){t=0;i=Yd(b,k,0)|0}if(i)cw(i|0,j|0,k|0)|0;else i=0}else i=0;while(0);c[h+(g<<3)>>2]=i;c[h+(g<<3)+4>>2]=c[l+(g<<3)+4>>2];g=g+1|0;if((g|0)>=(c[u>>2]|0))break;h=c[f>>2]|0}return f|0}if(c[b+480>>2]|0){Vd(b,f);v=0;return v|0}v=f;if((c[b+304>>2]|0)>>>0<=v>>>0?(c[b+308>>2]|0)>>>0>v>>>0:0){v=b+300|0;c[f>>2]=c[v>>2];c[v>>2]=f;v=0;return v|0}if(!(c[7324]|0)){_a[c[29344>>2]&127](f);v=0;return v|0}else{v=Ua[c[29352>>2]&127](f)|0;c[14978]=(c[14978]|0)-v;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](f);v=0;return v|0}return 0}function ik(b,d){b=b|0;d=d|0;var e=0;if((a[d>>0]|0)!=-95)return 0;d=d+44|0;e=c[d>>2]|0;if(!e)return 0;b=b+24|0;c[e+32>>2]=c[(c[b>>2]|0)+68>>2];c[(c[b>>2]|0)+68>>2]=c[d>>2];return 0}function jk(a,b){a=a|0;b=b|0;return (c[a+24>>2]|0)!=(b|0)|0}function kk(b,d,f){b=b|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=10-(c[b+56>>2]|0)|0;l=c[b>>2]|0;m=b+64|0;j=c[m>>2]|0;k=n<<2;a:do if(!j){b:do if(c[l+272>>2]|0)if(!(a[l+81>>0]|0))i=12;else{i=28;break a}else{do if(!(0<0|(0==0?(e[l+276>>1]|0)>>>0<k>>>0:0))){g=l+300|0;h=c[g>>2]|0;if(h|0){c[g>>2]=c[h>>2];l=l+284|0;c[l>>2]=(c[l>>2]|0)+1;break b}g=l+296|0;h=c[g>>2]|0;if(!h){g=l+292|0;break}else{c[g>>2]=c[h>>2];l=l+284|0;c[l>>2]=(c[l>>2]|0)+1;break b}}else g=l+288|0;while(0);c[g>>2]=(c[g>>2]|0)+1;i=12}while(0);if((i|0)==12)h=Yd(l,k,0)|0;c[m>>2]=h;g=b+60|0;if(h)i=30}else{g=j;i=l+304|0;if(((c[i>>2]|0)>>>0<=g>>>0?(c[l+308>>2]|0)>>>0>g>>>0:0)?!(0<0|(0==0?(e[l+276>>1]|0)>>>0<k>>>0:0)):0){h=j;g=b+60|0;i=30;break}h=Xd(l,j,k,0)|0;if(h|0){c[m>>2]=h;g=b+60|0;i=30;break}if(c[l+480>>2]|0){Vd(l,j);i=28;break}if((c[i>>2]|0)>>>0<=g>>>0?(c[l+308>>2]|0)>>>0>g>>>0:0){i=l+300|0;c[j>>2]=c[i>>2];c[i>>2]=j;i=28;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](j);i=28;break}else{i=Ua[c[29352>>2]&127](j)|0;c[14978]=(c[14978]|0)-i;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](j);i=28;break}}while(0);if((i|0)==28){c[m>>2]=0;g=b+60|0}else if((i|0)==30){c[g>>2]=n;c[h+(f<<2)>>2]=c[d+108>>2];return}c[g>>2]=0;return}function lk(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;h=Qa;Qa=Qa+16|0;g=h;if((a[b+199>>0]|0)!=2){Qa=h;return}c[g>>2]=f;f=Ke(c[b>>2]|0,e,g)|0;i=c[b+8>>2]|0;g=c[i+108>>2]|0;e=b+212|0;Dj(i,171,g,c[e>>2]|0,0,f,-7)|0;if(d<<24>>24)c[e>>2]=g;Qa=h;return}function mk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;l=Qa;Qa=Qa+32|0;i=l+16|0;h=l+8|0;k=l;g=c[d+12>>2]|0;e=a[g>>0]|0;if(e<<24>>24==-88)e=a[g+38>>0]|0;switch(e<<24>>24){case -87:{e=g+20|0;j=6;break}case -125:{e=c[g+20>>2]|0;j=6;break}default:f=1}if((j|0)==6)f=c[c[e>>2]>>2]|0;if(c[d+4>>2]&2048|0){e=c[c[c[d+20>>2]>>2]>>2]|0;if((f|0)==(e|0)){k=0;Qa=l;return k|0}c[k>>2]=e;c[k+4>>2]=f;ad(b,39001,k);k=1;Qa=l;return k|0}if((f|0)==1){k=0;Qa=l;return k|0}if(!(c[g+4>>2]&2048)){ad(b,38899,i);k=1;Qa=l;return k|0}else{c[h>>2]=c[c[c[g+20>>2]>>2]>>2];c[h+4>>2]=1;ad(b,39001,h);k=1;Qa=l;return k|0}return 0}function nk(b,d){b=b|0;d=d|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=c[d+12>>2]|0;f=a[n>>0]|0;if(f<<24>>24==-88)f=a[n+38>>0]|0;switch(f<<24>>24){case -87:{f=n+20|0;l=6;break}case -125:{f=c[n+20>>2]|0;l=6;break}default:m=1}if((l|0)==6)m=c[c[f>>2]>>2]|0;if(!(c[d+4>>2]&2048))k=0;else k=c[d+20>>2]|0;b=c[b>>2]|0;h=m+1|0;g=((h|0)<0)<<31>>31;a:do if(!b){j=Qv(h|0,g|0,-1,-1)|0;i=L()|0;if(i>>>0>0|(i|0)==0&j>>>0>2147483390){n=0;return n|0}if(!(c[7324]|0)){f=Ua[c[29340>>2]&127](h)|0;l=33;break}b=Ua[c[29356>>2]&127](h)|0;if((c[14985]|0)>>>0<h>>>0)c[14985]=h;d=59064;f=c[d>>2]|0;d=c[d+4>>2]|0;if((d|0)>0|(d|0)==0&f>>>0>0){j=c[14978]|0;i=Rv(f|0,d|0,b|0,((b|0)<0)<<31>>31|0)|0;h=L()|0;c[14768]=((h|0)<0|(h|0)==0&i>>>0<=j>>>0)&1}f=Ua[c[29340>>2]&127](b)|0;if(!f){n=0;return n|0}d=Ua[c[29352>>2]&127](f)|0;d=(c[14978]|0)+d|0;c[14978]=d;if(d>>>0>(c[14982]|0)>>>0)c[14982]=d;d=(c[14981]|0)+1|0;c[14981]=d;if(d>>>0>(c[14987]|0)>>>0)c[14987]=d}else{if(c[b+272>>2]|0){if(a[b+81>>0]|0){n=0;return n|0}}else{do if(!(0<g>>>0|(0==(g|0)?(e[b+276>>1]|0)>>>0<h>>>0:0))){d=b+300|0;f=c[d>>2]|0;if(f|0){c[d>>2]=c[f>>2];l=b+284|0;c[l>>2]=(c[l>>2]|0)+1;l=33;break a}d=b+296|0;f=c[d>>2]|0;if(!f){f=b+292|0;break}else{c[d>>2]=c[f>>2];l=b+284|0;c[l>>2]=(c[l>>2]|0)+1;l=33;break a}}else f=b+288|0;while(0);c[f>>2]=(c[f>>2]|0)+1}f=Yd(b,h,g)|0;l=33}while(0);if((l|0)==33)if(!f){n=0;return n|0}b:do if((m|0)>0){h=n+38|0;i=n+20|0;j=n+20|0;if(!k){g=0;while(1){b=a[n>>0]|0;if(b<<24>>24==-88)d=a[h>>0]|0;else d=b;switch(d<<24>>24){case -87:{d=i;l=42;break}case -125:{d=c[j>>2]|0;l=42;break}default:d=n}do if((l|0)==42){l=0;if((c[c[d>>2]>>2]|0)<2)d=n;else{if(b<<24>>24!=-125?(a[h>>0]|0)!=-125:0){d=c[(c[i>>2]|0)+4+(g*20|0)>>2]|0;break}d=c[(c[c[j>>2]>>2]|0)+4+(g*20|0)>>2]|0}}while(0);a[f+g>>0]=Vj(d)|0;g=g+1|0;if((g|0)==(m|0))break b}}g=0;while(1){b=a[n>>0]|0;if(b<<24>>24==-88)d=a[h>>0]|0;else d=b;switch(d<<24>>24){case -87:{d=i;l=52;break}case -125:{d=c[j>>2]|0;l=52;break}default:d=n}do if((l|0)==52){l=0;if((c[c[d>>2]>>2]|0)<2)d=n;else{if(b<<24>>24!=-125?(a[h>>0]|0)!=-125:0){d=c[(c[i>>2]|0)+4+(g*20|0)>>2]|0;break}d=c[(c[c[j>>2]>>2]|0)+4+(g*20|0)>>2]|0}}while(0);d=Vj(d)|0;b=Vj(c[(c[k>>2]|0)+4+(g*20|0)>>2]|0)|0;if(d<<24>>24==0|b<<24>>24==0)d=(b|d)<<24>>24==0?65:(b&255)+(d&255)&255;else d=d<<24>>24>66|b<<24>>24>66?67:65;a[f+g>>0]=d;g=g+1|0;if((g|0)==(m|0))break b}}while(0);a[f+m>>0]=0;n=f;return n|0}
function em(f,g,h,i,j){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;m=c[j>>2]|0;l=c[m+12>>2]|0;k=a[l>>0]|0;if(k<<24>>24==-88)k=a[l+38>>0]|0;switch(k<<24>>24){case -87:{k=l+20|0;v=6;break}case -125:{k=c[l+20>>2]|0;v=6;break}default:k=1}if((v|0)==6)k=c[c[k>>2]>>2]|0;r=(e[h+52>>1]|0)-i|0;r=(k|0)<(r|0)?k:r;s=h+28|0;if((r|0)<=1){v=1;return v|0}t=h+4|0;u=h+12|0;q=h+32|0;k=1;while(1){o=c[(c[l+20>>2]|0)+4+(k*20|0)>>2]|0;p=c[m+16>>2]|0;l=p+20|0;if(c[p+4>>2]&2048)l=c[l>>2]|0;n=c[(c[l>>2]|0)+4+(k*20|0)>>2]|0;if((a[o>>0]|0)!=-94){v=36;break}if((c[o+28>>2]|0)!=(g|0)){v=36;break}h=b[o+32>>1]|0;p=k+i|0;if(h<<16>>16!=(b[(c[t>>2]|0)+(p<<1)>>1]|0)){v=36;break}m=c[s>>2]|0;if((a[m+p>>0]|0)!=(a[m+i>>0]|0)){v=36;break}l=Vj(o)|0;m=Vj(n)|0;if(l<<24>>24==0|m<<24>>24==0)m=(m|l)<<24>>24==0?65:(m&255)+(l&255)&255;else m=l<<24>>24>66|m<<24>>24>66?67:65;if(h<<16>>16>-1)l=a[(c[(c[u>>2]|0)+4>>2]|0)+(h<<16>>16<<4)+13>>0]|0;else l=68;if(m<<24>>24!=l<<24>>24){v=36;break}do if(!(c[o+4>>2]&256)){if(n|0?c[n+4>>2]&256|0:0){l=Wi(f,n)|0;v=29;break}l=Wi(f,o)|0;if(!l){l=Wi(f,n)|0;v=29}}else{l=Wi(f,o)|0;v=29}while(0);if((v|0)==29){v=0;if(!l){v=36;break}}m=c[l>>2]|0;h=c[(c[q>>2]|0)+(p<<2)>>2]|0;p=a[m>>0]|0;l=(d[208+(p&255)>>0]|0)-(d[208+(d[h>>0]|0)>>0]|0)|0;if(!(p<<24>>24==0|(l|0)!=0))do{m=m+1|0;h=h+1|0;p=a[m>>0]|0;l=(d[208+(p&255)>>0]|0)-(d[208+(d[h>>0]|0)>>0]|0)|0}while(!(p<<24>>24==0|(l|0)!=0));if(l|0){v=36;break}k=k+1|0;if((k|0)>=(r|0)){v=36;break}m=c[j>>2]|0;l=c[m+12>>2]|0}if((v|0)==36)return k|0;return 0}function fm(f,g,h,i,j,k,l){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0;eb=Qa;Qa=Qa+96|0;$a=eb;ab=j&65535;if(j<<16>>16?b[(c[c[f>>2]>>2]|0)+76>>1]&64:0){db=0;Qa=eb;return db|0}Ea=c[g>>2]|0;j=Ea&65535;if(j>>>0>63){db=0;Qa=eb;return db|0}Fa=aw(1,0,j|0)|0;Fa=Qv(Fa|0,L()|0,-1,-1)|0;Ga=L()|0;i=i&65535;Ca=i&2048;Ba=(Ca|0)==0;Ca=Ca>>>11&65535|386;a:do if(!((Fa|0)==0&(Ga|0)==0)){ba=h+24|0;ca=f+4|0;da=(j|0)==0;ea=f+80|0;fa=Ca&65535;ga=$a+4|0;ha=$a+12|0;ia=$a+16|0;ja=$a+8|0;ka=$a+20|0;la=$a+24|0;ma=$a+28|0;na=$a+17|0;oa=$a+18|0;pa=$a+72|0;qa=$a+20|0;ra=$a+4|0;sa=$a+8|0;ta=$a+24|0;ua=f+488|0;xa=(j|0)!=0;ya=(i&192|0)==0;X=(i&64|0)==0;C=1;m=0;W=0;S=0;T=0;i=0;h=0;A=0;B=0;b:while(1){if(!W){U=i;V=h}else{V=m+8|0;U=c[V>>2]|i;V=c[V+4>>2]|h}if(W>>>0<ab>>>0){i=c[(c[ba>>2]|0)+(W<<2)>>2]|0;if(Ba){Na=i;za=10}else{r=C;s=i;q=B;p=A;o=S;n=T}}else{Na=k;za=10}if((za|0)==10){za=0;z=Na+36|0;i=c[z>>2]|0;P=Na+24|0;if(i&1024|0){za=11;break}Q=Na+30|0;b[Q>>1]=0;R=c[(c[ca>>2]|0)+8+((d[Na+16>>0]|0)*72|0)+40>>2]|0;if(da){o=A;p=B}else{v=~U;w=~V;x=Na+40|0;y=Na+48|0;u=0;h=A;m=B;do{s=aw(1,0,u|0)|0;t=L()|0;c:do if((s&h|0)==0&(t&m|0)==0){r=g+4+(u*20|0)|0;i=c[r>>2]|0;n=c[i+4>>2]|0;if(n&4096)do{if(!(n&262144))i=i+12|0;else i=(c[i+20>>2]|0)+4|0;i=c[i>>2]|0;n=c[i+4>>2]|0}while((n&4096|0)!=0);if((a[i>>0]|0)==-94?(c[i+28>>2]|0)==(R|0):0){q=i+32|0;i=b[q>>1]|0;c[$a>>2]=ea;c[ga>>2]=ea;c[ha>>2]=0;a[ia>>0]=0;c[ja>>2]=0;c[ka>>2]=fa;c[la>>2]=0;c[ma>>2]=R;a[na>>0]=1;a[oa>>0]=1;if(i<<16>>16!=-2?(b[pa>>1]=i,Ra=Rl($a)|0,Ra|0):0){o=0;p=Ra;while(1){n=p+32|0;i=c[n>>2]|0;n=c[n+4>>2]|0;if((i&v|0)==0&(n&w|0)==0){if((i|0)==0&(n|0)==0?(Sa=b[p+12>>1]|0,Sa&130):0){za=29;break}Ka=(o|0)==0?p:o}else Ka=o;i=Rl($a)|0;if(!i){za=33;break}else{o=Ka;p=i}}if((za|0)==29){za=0;Ha=p;Ta=Sa}else if((za|0)==33){za=0;if(!Ka)break;Ha=Ka;Ta=b[Ka+12>>1]|0}d:do if(Ta<<16>>16==1){i=b[x>>1]|0;if(!(i<<16>>16))break c;o=c[y>>2]|0;n=i&65535;i=0;while(1){if((Ha|0)==(c[o+(i<<2)>>2]|0))break d;i=i+1|0;if(i>>>0>=n>>>0)break c}}while(0);do if(Ta&130){if((b[q>>1]|0)<=-1)break;p=c[f>>2]|0;o=c[Ha>>2]|0;i=Wi(p,c[r>>2]|0)|0;if(!i)n=c[(c[p>>2]|0)+8>>2]|0;else n=i;i=Wi(p,o)|0;if(!i)i=c[(c[p>>2]|0)+8>>2]|0;n=c[n>>2]|0;o=c[i>>2]|0;O=a[n>>0]|0;i=(d[208+(O&255)>>0]|0)-(d[208+(d[o>>0]|0)>>0]|0)|0;if(!(O<<24>>24==0|(i|0)!=0))do{n=n+1|0;o=o+1|0;O=a[n>>0]|0;i=(d[208+(O&255)>>0]|0)-(d[208+(d[o>>0]|0)>>0]|0)|0}while(!(O<<24>>24==0|(i|0)!=0));if(i|0)break c}while(0);h=s|h;m=t|m;break}}}while(0);u=u+1|0}while((u|0)!=(j|0));i=c[z>>2]|0;o=h;p=m}do if(!(i&4096)){if(!(i&256)){m=c[Na+32>>2]|0;if(!m){bb=0;za=135;break b}O=m+55|0;if((d[O>>0]|d[O+1>>0]<<8)&4){bb=0;za=135;break b}h=b[m+52>>1]|0;i=(a[m+54>>0]|0)!=0&1;if(!(h<<16>>16)){La=i;Va=o;Wa=p;za=117;break}else{n=m;O=b[m+50>>1]|0;N=h&65535}}else{n=0;O=0;i=C;N=1}F=Na+42|0;G=(n|0)==0;H=Na+48|0;I=n+4|0;J=n+28|0;K=n+12|0;M=n+40|0;C=n+32|0;D=aw(1,0,W|0)|0;E=L()|0;h=0;y=0;A=0;B=0;z=o;x=p;e:while(1){o=e[P>>1]|0;q=B>>>0<o>>>0;f:do if(q?B>>>0>=(e[F>>1]|0)>>>0:0){p=c[H>>2]|0;m=c[p+(B<<2)>>2]|0;w=b[m+12>>1]|0;n=w&65535;if((w&Ca)<<16>>16){Aa=h;Y=y;Z=A;$=(n&256|0)==0?i:0;aa=B+1|0;va=z;wa=x;break}if((n&1|0)!=0?(Ua=c[m>>2]|0,Oa=B+1|0,Oa>>>0<o>>>0):0){m=Oa;while(1){if((c[c[p+(m<<2)>>2]>>2]|0)==(Ua|0)){Da=0;za=68;break f}m=m+1|0;if(m>>>0>=o>>>0){Da=1;za=68;break}}}else{Da=1;za=68}}else{Da=1;za=68}while(0);if((za|0)==68){za=0;if(!G){o=b[(c[I>>2]|0)+(B<<1)>>1]|0;m=a[(c[J>>2]|0)+B>>0]|0;n=c[K>>2]|0;o=o<<16>>16==(b[n+40>>1]|0)?-1:o<<16>>16;if(q|(i<<24>>24==0|(o|0)<0)){u=o;_=i}else{u=o;_=(a[(c[n+4>>2]|0)+(o<<4)+12>>0]|0)==0?0:i}}else{m=0;u=-1;_=i}if(!(xa&Da<<24>>24!=0)){za=114;break}s=(u|0)>-2;t=(u|0)==-1;i=0;n=1;g:while(1){v=aw(1,0,i|0)|0;w=L()|0;do if((v&z|0)==0&(w&x|0)==0){r=g+4+(i*20|0)|0;o=c[r>>2]|0;h:do if(!o)o=0;else while(1){p=c[o+4>>2]|0;if(!(p&4096))break h;if(!(p&262144))o=o+12|0;else o=(c[o+20>>2]|0)+4|0;o=c[o>>2]|0;if(!o){o=0;break}}while(0);n=ya?0:n;if(s){if((a[o>>0]|0)!=-94)break;if((c[o+28>>2]|0)!=(R|0))break;if((u|0)!=(b[o+32>>1]|0))break}else{p=c[(c[M>>2]|0)+4+(B*20|0)>>2]|0;i:do if(!o)o=0;else while(1){q=c[o+4>>2]|0;if(!(q&4096))break i;if(!(q&262144))o=o+12|0;else o=(c[o+20>>2]|0)+4|0;o=c[o>>2]|0;if(!o){o=0;break}}while(0);j:do if(!p)p=0;else while(1){q=c[p+4>>2]|0;if(!(q&4096))break j;if(!(q&262144))p=p+12|0;else p=(c[p+20>>2]|0)+4|0;p=c[p>>2]|0;if(!p){p=0;break}}while(0);if($j(0,o,p,R)|0)break}if(t){n=-1;break g}p=c[f>>2]|0;o=Wi(p,c[r>>2]|0)|0;if(!o)o=c[(c[p>>2]|0)+8>>2]|0;p=c[o>>2]|0;q=c[(c[C>>2]|0)+(B<<2)>>2]|0;r=a[p>>0]|0;o=(d[208+(r&255)>>0]|0)-(d[208+(d[q>>0]|0)>>0]|0)|0;if(!(r<<24>>24==0|(o|0)!=0))do{p=p+1|0;q=q+1|0;r=a[p>>0]|0;o=(d[208+(r&255)>>0]|0)-(d[208+(d[q>>0]|0)>>0]|0)|0}while(!(r<<24>>24==0|(o|0)!=0));if(!o){n=u;break g}}while(0);i=i+1|0;if(!(i>>>0<j>>>0&n<<24>>24!=0)){za=114;break e}}o=B+1|0;b[Q>>1]=o;do if(X){if(h<<24>>24)if((m^y)<<24>>24==(a[g+4+(i*20|0)+12>>0]|0)){i=y;break}else{za=114;break e}i=a[g+4+(i*20|0)+12>>0]^m;if(!(i<<24>>24)){h=1;i=0;break}wa=l;Aa=c[wa+4>>2]|E;h=l;c[h>>2]=c[wa>>2]|D;c[h+4>>2]=Aa;h=1}else i=y;while(0);Aa=h;Y=i;Z=(n|0)==-1?1:A;$=_;aa=o;va=v|z;wa=w|x}if(aa>>>0<N>>>0){h=Aa;y=Y;A=Z;B=aa;i=$;z=va;x=wa}else{Ja=Z;Pa=$;Xa=va;Ya=wa;break}}if((za|0)==114){za=0;Ja=A;Pa=(B|0)==0|B>>>0<(O&65535)>>>0?0:_;Xa=z;Ya=x}if(!(Ja<<24>>24)){La=Pa;Va=Xa;Wa=Ya;za=117}else{Ma=1;Za=Xa;_a=Ya}}else{La=C;Va=o;Wa=p;za=117}while(0);if((za|0)==117){za=0;if(!(La<<24>>24)){Ia=0;cb=Va;db=Wa;break a}else{Ma=La;Za=Va;_a=Wa}}v=Na+8|0;u=c[v>>2]|S;v=c[v+4>>2]|T;if(da){r=Ma;s=Na;q=_a;p=Za;o=u;n=v}else{s=~u;t=~v;r=0;q=Za;i=_a;while(1){o=aw(1,0,r|0)|0;p=L()|0;do if((o&q|0)==0&(p&i|0)==0){m=c[g+4+(r*20|0)>>2]|0;if(m){n=Nl(ua,m)|0;h=L()|0;if((n|0)==0&(h|0)==0){a[qa>>0]=1;c[ra>>2]=127;c[sa>>2]=128;c[ta>>2]=0;Yj($a,m)|0;if(!(a[qa>>0]|0)){h=q;break}else{n=0;h=0}}}else{n=0;h=0}T=(n&s|0)==0&(h&t|0)==0;h=(T?o:0)|q;i=(T?p:0)|i}else h=q;while(0);r=r+1|0;if((r|0)==(j|0)){r=Ma;s=Na;q=i;p=h;o=u;n=v;break}else q=h}}}if(W>>>0>=ab>>>0|(q>>>0>Ga>>>0|(q|0)==(Ga|0)&p>>>0>=Fa>>>0|r<<24>>24==0)){Ia=r;cb=p;db=q;break a}else{C=r;m=s;W=W+1|0;S=o;T=n;i=U;h=V;A=p;B=q}}if((za|0)==11){db=(a[P+5>>0]|0)==0;Ia=C;cb=db?A:Fa;db=db?B:Ga;break}else if((za|0)==135){Qa=eb;return bb|0}}else{Ia=1;cb=0;db=0}while(0);if((cb|0)==(Fa|0)&(db|0)==(Ga|0)){db=Ea&255;Qa=eb;return db|0}if(Ia<<24>>24){db=-1;Qa=eb;return db|0}if(j>>>0<=1){db=0;Qa=eb;return db|0}while(1){i=j;j=j+-1|0;$a=aw(1,0,j|0)|0;$a=Qv($a|0,L()|0,-1,-1)|0;ab=L()|0;if(($a&cb|0)==($a|0)&(ab&db|0)==(ab|0))break;if((i|0)<=2){bb=0;za=135;break}}if((za|0)==135){Qa=eb;return bb|0}db=j&255;Qa=eb;return db|0}function gm(d,e,f,g,h,i){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;do if(h|0){h=d+16|0;j=c[h>>2]|0;k=j+5|0;if(k>>>0<(c[d+8>>2]|0)>>>0){c[h>>2]=k;s=(c[d+4>>2]|0)+j|0;a[s>>0]=a[43977]|0;a[s+1>>0]=a[43978]|0;a[s+2>>0]=a[43979]|0;a[s+3>>0]=a[43980]|0;a[s+4>>0]=a[43981]|0;break}else{ub(d,43977,5);break}}while(0);s=(f|0)>1;do if(s){h=d+16|0;j=c[h>>2]|0;k=j+1|0;if(k>>>0<(c[d+8>>2]|0)>>>0){c[h>>2]=k;a[(c[d+4>>2]|0)+j>>0]=40;break}else{ub(d,44003,1);break}}else if((f|0)!=1){h=d+16|0;j=c[h>>2]|0;k=j+1|0;if(k>>>0<(c[d+8>>2]|0)>>>0){c[h>>2]=k;a[(c[d+4>>2]|0)+j>>0]=a[i>>0]|0;return}else{ub(d,i,1);return}}while(0);o=e+4|0;q=d+16|0;r=d+8|0;m=e+12|0;n=d+4|0;l=0;do{do if(l|0){h=c[q>>2]|0;j=h+1|0;if(j>>>0<(c[r>>2]|0)>>>0){c[q>>2]=j;a[(c[n>>2]|0)+h>>0]=44;break}else{ub(d,41685,1);break}}while(0);h=b[(c[o>>2]|0)+(l+g<<1)>>1]|0;switch(h<<16>>16){case -2:{h=43996;p=21;break}case -1:{h=38132;p=21;break}default:{h=c[(c[(c[m>>2]|0)+4>>2]|0)+(h<<16>>16<<4)>>2]|0;if(!h){e=0;h=0}else p=21}}if((p|0)==21){p=0;e=(Cu(h)|0)&1073741823}j=c[q>>2]|0;k=j+e|0;if(k>>>0<(c[r>>2]|0)>>>0){if(e|0){c[q>>2]=k;cw((c[n>>2]|0)+j|0,h|0,e|0)|0}}else ub(d,h,e);l=l+1|0}while((l|0)!=(f|0));h=c[q>>2]|0;j=h+1|0;k=j>>>0<(c[r>>2]|0)>>>0;do if(s){if(k){c[q>>2]=j;a[(c[d+4>>2]|0)+h>>0]=41}else ub(d,34066,1);h=c[q>>2]|0;j=h+1|0;if(j>>>0<(c[r>>2]|0)>>>0){c[q>>2]=j;a[(c[d+4>>2]|0)+h>>0]=a[i>>0]|0}else ub(d,i,1);h=c[q>>2]|0;j=h+1|0;if(j>>>0<(c[r>>2]|0)>>>0){c[q>>2]=j;a[(c[d+4>>2]|0)+h>>0]=40;break}else{ub(d,44003,1);break}}else if(k){c[q>>2]=j;a[(c[d+4>>2]|0)+h>>0]=a[i>>0]|0;break}else{ub(d,i,1);break}while(0);e=d+4|0;k=0;do{do if(k|0){h=c[q>>2]|0;j=h+1|0;if(j>>>0<(c[r>>2]|0)>>>0){c[q>>2]=j;a[(c[e>>2]|0)+h>>0]=44;break}else{ub(d,41685,1);break}}while(0);h=c[q>>2]|0;j=h+1|0;if(j>>>0<(c[r>>2]|0)>>>0){c[q>>2]=j;a[(c[e>>2]|0)+h>>0]=63}else ub(d,35133,1);k=k+1|0}while((k|0)!=(f|0));if(!s)return;h=c[q>>2]|0;j=h+1|0;if(j>>>0<(c[r>>2]|0)>>>0){c[q>>2]=j;a[(c[d+4>>2]|0)+h>>0]=41;return}else{ub(d,34066,1);return}}function hm(d,f,g,h,i,j){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,M=0;M=Qa;Qa=Qa+16|0;J=M;y=c[f>>2]|0;K=c[d+8>>2]|0;a:do switch(a[y>>0]|0){case 45:case 53:{j=Hj(d,c[y+16>>2]|0,j)|0;break}case 50:{k=K+108|0;i=c[k>>2]|0;if((c[K+112>>2]|0)>(i|0)){c[k>>2]=i+1;K=c[K+104>>2]|0;a[K+(i*20|0)>>0]=73;b[K+(i*20|0)+2>>1]=0;c[K+(i*20|0)+4>>2]=0;c[K+(i*20|0)+8>>2]=j;c[K+(i*20|0)+12>>2]=0;c[K+(i*20|0)+16>>2]=0;a[K+(i*20|0)+1>>0]=0;break a}else{Bi(K,73,0,j,0)|0;break a}}default:{D=c[g+64>>2]|0;H=D+36|0;if((c[H>>2]&1024|0)==0?(k=c[D+32>>2]|0,(k|0)!=0):0)i=(a[(c[k+28>>2]|0)+h>>0]|0)==0?i:(i|0)==0&1;G=(h|0)>0;b:do if(G){l=c[D+48>>2]|0;k=0;while(1){F=c[l+(k<<2)>>2]|0;if(F|0?(c[F>>2]|0)==(y|0):0)break;k=k+1|0;if((k|0)>=(h|0))break b}jm(g,f);g=j;Qa=M;return g|0}while(0);F=D+40|0;m=e[F>>1]|0;if((m|0)>(h|0)){n=c[D+48>>2]|0;k=0;l=h;do{k=k+((c[c[n+(l<<2)>>2]>>2]|0)==(y|0)&1)|0;l=l+1|0}while((l|0)<(m|0));C=k}else C=0;c[J>>2]=0;if((c[y+4>>2]&2048|0)!=0?(c[c[c[y+20>>2]>>2]>>2]|0)!=1:0){A=c[d>>2]|0;B=bk(A,y,0,0)|0;u=A+81|0;if(!(a[u>>0]|0)){s=B+20|0;q=c[c[s>>2]>>2]|0;t=B+12|0;r=c[(c[t>>2]|0)+20>>2]|0;m=b[F>>1]|0;if((m&65535|0)>(h|0)){p=D+48|0;k=0;o=h;l=0;do{n=c[(c[p>>2]|0)+(o<<2)>>2]|0;if((c[n>>2]|0)==(y|0)?(v=(c[n+24>>2]|0)+-1|0,w=q+4+(v*20|0)|0,x=c[w>>2]|0,(x|0)!=0):0){l=lj(c[d>>2]|0,l,x)|0;c[w>>2]=0;m=r+4+(v*20|0)|0;k=lj(c[d>>2]|0,k,c[m>>2]|0)|0;c[m>>2]=0;m=b[F>>1]|0}o=o+1|0}while((o|0)<(m&65535|0))}else{l=0;k=0}if(q|0)pi(A,q);if(r|0)pi(A,r);c[(c[t>>2]|0)+20>>2]=k;c[c[s>>2]>>2]=l;if(k|0?(c[k>>2]|0)==1:0){l=k+4|0;k=c[l>>2]|0;c[l>>2]=0;l=c[t>>2]|0;if(l|0)li(A,l);c[t>>2]=k}l=c[(c[s>>2]|0)+48>>2]|0;if(l|0?(z=c[l>>2]|0,(z|0)>0):0){k=0;do{b[l+4+(k*20|0)+16>>1]=0;k=k+1|0}while((k|0)!=(z|0))}if(!(a[u>>0]|0)){m=c[d>>2]|0;n=C<<2;c:do if(!m){z=Qv(n|0,0,-1,-1)|0;y=L()|0;if(y>>>0>0|(y|0)==0&z>>>0>2147483390)k=0;else{if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](n)|0;E=66;break}k=Ua[c[29356>>2]&127](n)|0;if((c[14985]|0)>>>0<n>>>0)c[14985]=n;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){z=c[14978]|0;y=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;x=L()|0;c[14768]=((x|0)<0|(x|0)==0&y>>>0<=z>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k){k=0;break}l=Ua[c[29352>>2]&127](k)|0;l=(c[14978]|0)+l|0;c[14978]=l;if(l>>>0>(c[14982]|0)>>>0)c[14982]=l;l=(c[14981]|0)+1|0;c[14981]=l;if(l>>>0<=(c[14987]|0)>>>0){E=67;break}c[14987]=l;E=67}}else{if(c[m+272>>2]|0){if(a[m+81>>0]|0){k=0;break}}else{do if(!(0<0|(0==0?(e[m+276>>1]|0)>>>0<n>>>0:0))){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];E=m+284|0;c[E>>2]=(c[E>>2]|0)+1;E=66;break c}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];E=m+284|0;c[E>>2]=(c[E>>2]|0)+1;E=66;break c}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1}k=Yd(m,n,0)|0;E=66}while(0);if((E|0)==66)if(!k)k=0;else E=67;if((E|0)==67)ew(k|0,0,n|0)|0;m=ok(d,B,4,0,k,J)|0;n=c[J>>2]|0;c[(c[f>>2]|0)+28>>2]=n;l=k}else{l=0;m=5;n=0;k=0}}else{l=0;m=5;n=0;k=0}if(B|0)li(A,B);y=c[f>>2]|0;B=k}else{m=ok(d,y,4,0,0,J)|0;l=0;n=c[J>>2]|0;B=0}x=(((m|0)==4?(i|0)==0&1:i)|0)!=0;k=x?32:36;z=K+108|0;i=c[z>>2]|0;A=K+112|0;if((c[A>>2]|0)>(i|0)){c[z>>2]=i+1;w=c[K+104>>2]|0;a[w+(i*20|0)>>0]=k;b[w+(i*20|0)+2>>1]=0;c[w+(i*20|0)+4>>2]=n;c[w+(i*20|0)+8>>2]=0;c[w+(i*20|0)+12>>2]=0;c[w+(i*20|0)+16>>2]=0;a[w+(i*20|0)+1>>0]=0}else Bi(K,k,n,0,0)|0;c[H>>2]=c[H>>2]|2048;t=g+56|0;k=c[t>>2]|0;if(!k){w=d+56|0;k=(c[w>>2]|0)+-1|0;c[w>>2]=k;c[g+16>>2]=k;k=c[t>>2]|0}q=k+C|0;c[t>>2]=q;r=c[d>>2]|0;s=g+60|0;i=c[s>>2]|0;q=q*20|0;d:do if(!i){e:do if(c[r+272>>2]|0)if(!(a[r+81>>0]|0))E=88;else{E=126;break d}else{do if(!(0<0|(0==0?(e[r+276>>1]|0)>>>0<q>>>0:0))){n=r+300|0;i=c[n>>2]|0;if(i|0){c[n>>2]=c[i>>2];C=r+284|0;c[C>>2]=(c[C>>2]|0)+1;break e}n=r+296|0;i=c[n>>2]|0;if(!i){i=r+292|0;break}else{c[n>>2]=c[i>>2];C=r+284|0;c[C>>2]=(c[C>>2]|0)+1;break e}}else i=r+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1;E=88}while(0);if((E|0)==88)i=Yd(r,q,0)|0;c[s>>2]=i;if(!i)E=127;else E=103}else{o=i;p=r+304|0;if(((c[p>>2]|0)>>>0<=o>>>0?(c[r+308>>2]|0)>>>0>o>>>0:0)?!(0<0|(0==0?(e[r+276>>1]|0)>>>0<q>>>0:0)):0){E=103;break}n=Xd(r,i,q,0)|0;if(n|0){c[s>>2]=n;i=n;E=103;break}if(c[r+480>>2]|0){Vd(r,i);E=126;break}if((c[p>>2]|0)>>>0<=o>>>0?(c[r+308>>2]|0)>>>0>o>>>0:0){E=r+300|0;c[i>>2]=c[E>>2];c[E>>2]=i;E=126;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](i);E=126;break}else{E=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-E;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);E=126;break}}while(0);if((E|0)==103){n=b[F>>1]|0;if((n&65535|0)>(h|0)){v=D+48|0;w=j-h|0;s=(m|0)==1;t=(l|0)==0;u=K+104|0;r=x?4:5;o=0;m=i+(k*20|0)|0;q=h;i=n;while(1){if((c[c[(c[v>>2]|0)+(q<<2)>>2]>>2]|0)==(y|0)){p=w+q|0;do if(s){n=c[J>>2]|0;k=c[z>>2]|0;if((c[A>>2]|0)>(k|0)){c[z>>2]=k+1;i=c[u>>2]|0;a[i+(k*20|0)>>0]=-128;b[i+(k*20|0)+2>>1]=0;c[i+(k*20|0)+4>>2]=n;c[i+(k*20|0)+8>>2]=p;c[i+(k*20|0)+12>>2]=0;c[i+(k*20|0)+16>>2]=0;a[i+(k*20|0)+1>>0]=0;i=k;k=o;break}else{i=Bi(K,128,n,p,0)|0;k=o;break}}else{if(t){k=o;n=0}else{k=o+1|0;n=c[l+(o<<2)>>2]|0}o=c[J>>2]|0;i=c[z>>2]|0;if((c[A>>2]|0)>(i|0)){c[z>>2]=i+1;D=c[u>>2]|0;a[D+(i*20|0)>>0]=90;b[D+(i*20|0)+2>>1]=0;c[D+(i*20|0)+4>>2]=o;c[D+(i*20|0)+8>>2]=n;c[D+(i*20|0)+12>>2]=p;c[D+(i*20|0)+16>>2]=0;a[D+(i*20|0)+1>>0]=0;n=o;break}else{i=Bi(K,90,o,n,p)|0;n=o;break}}while(0);c[m+4>>2]=i;i=c[z>>2]|0;if((c[A>>2]|0)>(i|0)){c[z>>2]=i+1;D=c[u>>2]|0;a[D+(i*20|0)>>0]=50;b[D+(i*20|0)+2>>1]=0;c[D+(i*20|0)+4>>2]=p;c[D+(i*20|0)+8>>2]=0;c[D+(i*20|0)+12>>2]=0;c[D+(i*20|0)+16>>2]=0;a[D+(i*20|0)+1>>0]=0}else Bi(K,50,p,0,0)|0;do if((q|0)==(h|0)){c[m>>2]=n;a[m+16>>0]=r;if(G?(I=c[H>>2]|0,(I&1024|0)==0):0){c[m+8>>2]=w;c[m+12>>2]=h;c[H>>2]=I|262144;break}c[m+12>>2]=0}else a[m+16>>0]=-86;while(0);m=m+20|0;i=b[F>>1]|0}else k=o;q=q+1|0;if((q|0)>=(i&65535|0))break;else o=k}}}else if((E|0)==126){c[s>>2]=0;E=127}if((E|0)==127)c[t>>2]=0;k=c[d>>2]|0;do if(B|0){if(k|0){if(c[k+480>>2]|0){Vd(k,B);break}K=B;if((c[k+304>>2]|0)>>>0<=K>>>0?(c[k+308>>2]|0)>>>0>K>>>0:0){K=k+300|0;c[B>>2]=c[K>>2];c[K>>2]=B;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](B);break}else{K=Ua[c[29352>>2]&127](B)|0;c[14978]=(c[14978]|0)-K;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](B);break}}while(0)}}while(0);jm(g,f);g=j;Qa=M;return g|0}function im(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if(!e){k=Hj(d,0,f)|0;if((k|0)==(f|0))return;h=c[d+8>>2]|0;if(!h)return;i=h+108|0;j=c[i>>2]|0;if((c[h+112>>2]|0)>(j|0)){c[i>>2]=j+1;d=c[h+104>>2]|0;a[d+(j*20|0)>>0]=79;b[d+(j*20|0)+2>>1]=0;c[d+(j*20|0)+4>>2]=k;c[d+(j*20|0)+8>>2]=f;c[d+(j*20|0)+12>>2]=0;c[d+(j*20|0)+16>>2]=0;a[d+(j*20|0)+1>>0]=0;return}else{Bi(h,79,k,f,0)|0;return}}h=a[e>>0]|0;j=h<<24>>24==-88;if(j)h=a[e+38>>0]|0;switch(h<<24>>24){case -87:{i=e+20|0;q=7;break}case -125:{i=c[e+20>>2]|0;q=7;break}default:{}}if((q|0)==7?(c[c[i>>2]>>2]|0)>=2:0){if(c[e+4>>2]&2048|0){l=c[d+8>>2]|0;k=Oj(d,e)|0;h=g+-1|0;i=l+108|0;j=c[i>>2]|0;if((c[l+112>>2]|0)>(j|0)){c[i>>2]=j+1;d=c[l+104>>2]|0;a[d+(j*20|0)>>0]=78;b[d+(j*20|0)+2>>1]=0;c[d+(j*20|0)+4>>2]=k;c[d+(j*20|0)+8>>2]=f;c[d+(j*20|0)+12>>2]=h;c[d+(j*20|0)+16>>2]=0;a[d+(j*20|0)+1>>0]=0;return}else{Bi(l,78,k,f,h)|0;return}}e=c[e+20>>2]|0;if((g|0)<=0)return;m=d+8|0;l=0;do{h=c[e+4+(l*20|0)>>2]|0;n=l+f|0;do if(h){if((a[h>>0]|0)!=-88){p=Hj(d,h,n)|0;q=21;break}k=c[m>>2]|0;h=c[h+28>>2]|0;i=k+108|0;j=c[i>>2]|0;if((c[k+112>>2]|0)>(j|0)){c[i>>2]=j+1;k=c[k+104>>2]|0;a[k+(j*20|0)>>0]=78;b[k+(j*20|0)+2>>1]=0;c[k+(j*20|0)+4>>2]=h;c[k+(j*20|0)+8>>2]=n;c[k+(j*20|0)+12>>2]=0;c[k+(j*20|0)+16>>2]=0;a[k+(j*20|0)+1>>0]=0;break}else{Bi(k,78,h,n,0)|0;break}}else{p=Hj(d,0,n)|0;q=21}while(0);do if(((q|0)==21?(q=0,(p|0)!=(n|0)):0)?(o=c[m>>2]|0,o|0):0){h=o+108|0;i=c[h>>2]|0;if((c[o+112>>2]|0)>(i|0)){c[h>>2]=i+1;k=c[o+104>>2]|0;a[k+(i*20|0)>>0]=79;b[k+(i*20|0)+2>>1]=0;c[k+(i*20|0)+4>>2]=p;c[k+(i*20|0)+8>>2]=n;c[k+(i*20|0)+12>>2]=0;c[k+(i*20|0)+16>>2]=0;a[k+(i*20|0)+1>>0]=0;break}else{Bi(o,79,p,n,0)|0;break}}while(0);l=l+1|0}while((l|0)!=(g|0));return}if(j){k=c[d+8>>2]|0;h=c[e+28>>2]|0;i=k+108|0;j=c[i>>2]|0;if((c[k+112>>2]|0)>(j|0)){c[i>>2]=j+1;d=c[k+104>>2]|0;a[d+(j*20|0)>>0]=78;b[d+(j*20|0)+2>>1]=0;c[d+(j*20|0)+4>>2]=h;c[d+(j*20|0)+8>>2]=f;c[d+(j*20|0)+12>>2]=0;c[d+(j*20|0)+16>>2]=0;a[d+(j*20|0)+1>>0]=0;return}else{Bi(k,78,h,f,0)|0;return}}k=Hj(d,e,f)|0;if((k|0)==(f|0))return;h=c[d+8>>2]|0;if(!h)return;i=h+108|0;j=c[i>>2]|0;if((c[h+112>>2]|0)>(j|0)){c[i>>2]=j+1;d=c[h+104>>2]|0;a[d+(j*20|0)>>0]=79;b[d+(j*20|0)+2>>1]=0;c[d+(j*20|0)+4>>2]=k;c[d+(j*20|0)+8>>2]=f;c[d+(j*20|0)+12>>2]=0;c[d+(j*20|0)+16>>2]=0;a[d+(j*20|0)+1>>0]=0;return}else{Bi(h,79,k,f,0)|0;return}}function jm(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;h=e+10|0;g=b[h>>1]|0;if(g&4)return;q=d+72|0;if(!(c[d>>2]|0)){m=q;l=c[m>>2]|0;m=c[m+4>>2]|0;f=e;k=0;i=g;n=h;while(1){j=f+40|0;if(!((c[j>>2]&l|0)==0?(c[j+4>>2]&m|0)==0:0)){d=22;break}if((k|0)!=0?(o=i&65535,(o&1024|0)!=0):0)d=(o|512)&65535;else d=i|4;b[n>>1]=d;j=c[f+16>>2]|0;if((j|0)<0){d=22;break}d=c[(c[f+4>>2]|0)+20>>2]|0;i=d+(j*48|0)+14|0;n=(a[i>>0]|0)+-1<<24>>24;a[i>>0]=n;if(n<<24>>24){d=22;break}n=d+(j*48|0)+10|0;i=b[n>>1]|0;if(i&4){d=22;break}else{f=d+(j*48|0)|0;k=k+1|0}}if((d|0)==22)return}i=0;while(1){if(!(c[(c[e>>2]|0)+4>>2]&1)){d=22;break}o=q;n=e+40|0;if(!((c[n>>2]&c[o>>2]|0)==0?(c[n+4>>2]&c[o+4>>2]|0)==0:0)){d=22;break}if((i|0)!=0?(p=g&65535,(p&1024|0)!=0):0)d=(p|512)&65535;else d=g|4;b[h>>1]=d;f=c[e+16>>2]|0;if((f|0)<0){d=22;break}d=c[(c[e+4>>2]|0)+20>>2]|0;n=d+(f*48|0)+14|0;o=(a[n>>0]|0)+-1<<24>>24;a[n>>0]=o;if(o<<24>>24){d=22;break}h=d+(f*48|0)+10|0;g=b[h>>1]|0;if(g&4){d=22;break}else{e=d+(f*48|0)|0;i=i+1|0}}if((d|0)==22)return}function km(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;if((a[d>>0]|0)==44)do{km(c[d+12>>2]|0,e,f);d=c[d+16>>2]|0}while((a[d>>0]|0)==44);i=f+12|0;if((c[i>>2]|0)<=0)return;f=c[f+20>>2]|0;g=0;while(1){h=f+10|0;if((b[h>>1]&4)==0?($j(0,c[f>>2]|0,d,e)|0)==0:0)b[h>>1]=b[h>>1]|4;g=g+1|0;if((g|0)>=(c[i>>2]|0))break;else f=f+48|0}return}function lm(d,e){d=d|0;e=e|0;d=c[d+24>>2]|0;if($j(0,e,c[d>>2]|0,c[d+4>>2]|0)|0){e=0;return e|0}a[e>>0]=-94;c[e+28>>2]=c[d+8>>2];b[e+32>>1]=c[d+12>>2];c[e+44>>2]=0;e=1;return e|0}function mm(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=c[c[c[a>>2]>>2]>>2]|0;d=c[a+12>>2]|0;o=a+20|0;if((d|0)>0){p=(q|0)==0;i=q+480|0;j=q+304|0;k=q+308|0;l=q+300|0;h=c[o>>2]|0;while(1){g=d;d=d+-1|0;f=h+10|0;e=b[f>>1]|0;if((e&1)!=0?(m=c[h>>2]|0,(m|0)!=0):0){li(q,m);e=b[f>>1]|0}e=e&65535;do if(!(e&16)){if(e&32|0?(n=c[h+28>>2]|0,mm(n),n|0):0){if(!p){if(c[i>>2]|0){Vd(q,n);break}f=n;if((c[j>>2]|0)>>>0<=f>>>0?(c[k>>2]|0)>>>0>f>>>0:0){c[n>>2]=c[l>>2];c[l>>2]=n;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](n);break}else{f=Ua[c[29352>>2]&127](n)|0;c[14978]=(c[14978]|0)-f;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](n);break}}}else{e=c[h+28>>2]|0;mm(e);if(e|0){if(!p){if(c[i>>2]|0){Vd(q,e);break}f=e;if((c[j>>2]|0)>>>0<=f>>>0?(c[k>>2]|0)>>>0>f>>>0:0){c[e>>2]=c[l>>2];c[l>>2]=e;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](e);break}else{f=Ua[c[29352>>2]&127](e)|0;c[14978]=(c[14978]|0)-f;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](e);break}}}while(0);if((g|0)<=1)break;else h=h+48|0}}d=c[o>>2]|0;if((d|0)==(a+24|0))return;if(!d)return;if(q|0){if(c[q+480>>2]|0){Vd(q,d);return}a=d;if((c[q+304>>2]|0)>>>0<=a>>>0?(c[q+308>>2]|0)>>>0>a>>>0:0){q=q+300|0;c[d>>2]=c[q>>2];c[q>>2]=d;return}}if(!(c[7324]|0)){_a[c[29344>>2]&127](d);return}else{q=Ua[c[29352>>2]&127](d)|0;c[14978]=(c[14978]|0)-q;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](d);return}}function nm(d,f,g){d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=d+8|0;h=c[l>>2]|0;a:do if(!h){k=c[d>>2]|0;if((c[d+116>>2]|0)==0?(b[k+76>>1]&8)==0:0)a[d+23>>0]=1;b:do if(c[k+272>>2]|0)if(!(a[k+81>>0]|0))j=15;else{h=0;break a}else{do if((e[k+276>>1]|0)>=224){i=k+300|0;h=c[i>>2]|0;if(h|0){c[i>>2]=c[h>>2];p=k+284|0;c[p>>2]=(c[p>>2]|0)+1;break b}i=k+296|0;h=c[i>>2]|0;if(!h){h=k+292|0;break}else{c[i>>2]=c[h>>2];p=k+284|0;c[p>>2]=(c[p>>2]|0)+1;break b}}else h=k+288|0;while(0);c[h>>2]=(c[h>>2]|0)+1;j=15}while(0);if((j|0)==15)h=Yd(k,224,0)|0;if(!h)h=0;else{i=h+104|0;j=i+120|0;do{c[i>>2]=0;i=i+4|0}while((i|0)<(j|0));c[h>>2]=k;i=k+4|0;j=c[i>>2]|0;if(j|0)c[j+4>>2]=h;c[h+8>>2]=j;c[h+4>>2]=0;c[i>>2]=h;c[h+20>>2]=381479589;c[h+12>>2]=d;c[l>>2]=h;Bi(h,61,0,1,0)|0}}while(0);p=d+19|0;i=a[p>>0]|0;if(!(i<<24>>24)){n=d+44|0;o=(c[n>>2]|0)+1|0;c[n>>2]=o}else{o=i+-1<<24>>24;a[p>>0]=o;o=c[d+148+((o&255)<<2)>>2]|0}m=h+108|0;i=c[m>>2]|0;n=h+112|0;if((c[n>>2]|0)>(i|0)){c[m>>2]=i+1;l=c[h+104>>2]|0;a[l+(i*20|0)>>0]=70;b[l+(i*20|0)+2>>1]=0;c[l+(i*20|0)+4>>2]=0;c[l+(i*20|0)+8>>2]=o;c[l+(i*20|0)+12>>2]=0;c[l+(i*20|0)+16>>2]=0;a[l+(i*20|0)+1>>0]=0}else Bi(h,70,0,o,0)|0;do if((g|0)>2){i=a[p>>0]|0;if(!(i<<24>>24)){k=d+44|0;l=(c[k>>2]|0)+1|0;c[k>>2]=l}else{l=i+-1<<24>>24;a[p>>0]=l;l=c[d+148+((l&255)<<2)>>2]|0}i=c[m>>2]|0;if((c[n>>2]|0)>(i|0)){c[m>>2]=i+1;k=c[h+104>>2]|0;a[k+(i*20|0)>>0]=110;b[k+(i*20|0)+2>>1]=0;c[k+(i*20|0)+4>>2]=0;c[k+(i*20|0)+8>>2]=l;c[k+(i*20|0)+12>>2]=0;c[k+(i*20|0)+16>>2]=0;a[k+(i*20|0)+1>>0]=0}else i=Bi(h,110,0,l,0)|0;do if(!(a[(c[h>>2]|0)+81>>0]|0)){if((i|0)<0)i=(c[m>>2]|0)+-1|0;j=c[h+104>>2]|0;k=j+(i*20|0)+1|0;if(!(a[k>>0]|0)){c[j+(i*20|0)+16>>2]=59952;a[k>>0]=-1;break}else{Ci(h,j+(i*20|0)|0,59952,-1);break}}while(0);i=c[m>>2]|0;j=i+2|0;if((c[n>>2]|0)>(i|0)){c[m>>2]=i+1;k=c[h+104>>2]|0;a[k+(i*20|0)>>0]=57;b[k+(i*20|0)+2>>1]=0;c[k+(i*20|0)+4>>2]=l;c[k+(i*20|0)+8>>2]=j;c[k+(i*20|0)+12>>2]=f;c[k+(i*20|0)+16>>2]=0;a[k+(i*20|0)+1>>0]=0}else Bi(h,57,l,j,f)|0;i=c[m>>2]|0;if((i|0)>0)b[(c[h+104>>2]|0)+((i+-1|0)*20|0)+2>>1]=83}else{i=c[m>>2]|0;j=i+2|0;if((c[n>>2]|0)>(i|0)){c[m>>2]=i+1;l=c[h+104>>2]|0;a[l+(i*20|0)>>0]=15;b[l+(i*20|0)+2>>1]=0;c[l+(i*20|0)+4>>2]=f;c[l+(i*20|0)+8>>2]=j;c[l+(i*20|0)+12>>2]=0;c[l+(i*20|0)+16>>2]=0;a[l+(i*20|0)+1>>0]=0;break}else{Bi(h,15,f,j,0)|0;break}}while(0);j=c[18208+(g<<2)>>2]|0;i=c[m>>2]|0;k=i+2|0;if((c[n>>2]|0)>(i|0)){c[m>>2]=i+1;l=c[h+104>>2]|0;a[l+(i*20|0)>>0]=j;b[l+(i*20|0)+2>>1]=0;c[l+(i*20|0)+4>>2]=o;c[l+(i*20|0)+8>>2]=k;c[l+(i*20|0)+12>>2]=f;c[l+(i*20|0)+16>>2]=0;a[l+(i*20|0)+1>>0]=0}else Bi(h,j,o,k,f)|0;i=c[d+116>>2]|0;a[((i|0)==0?d:i)+21>>0]=1;i=c[m>>2]|0;if((c[n>>2]|0)>(i|0)){c[m>>2]=i+1;f=c[h+104>>2]|0;a[f+(i*20|0)>>0]=69;b[f+(i*20|0)+2>>1]=0;c[f+(i*20|0)+4>>2]=1;c[f+(i*20|0)+8>>2]=2;c[f+(i*20|0)+12>>2]=0;c[f+(i*20|0)+16>>2]=0;a[f+(i*20|0)+1>>0]=0}else Bi(h,69,1,2,0)|0;if(!(a[(c[h>>2]|0)+81>>0]|0)){n=c[18176+(g<<2)>>2]|0;f=c[h+104>>2]|0;g=(c[m>>2]|0)+-1|0;a[f+(g*20|0)+1>>0]=-1;c[f+(g*20|0)+16>>2]=n}if(!o)return;h=a[p>>0]|0;if((h&255)>=8)return;a[p>>0]=h+1<<24>>24;c[d+148+((h&255)<<2)>>2]=o;return}function om(d,f,g){d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;l=d+8|0;h=c[l>>2]|0;a:do if(!h){k=c[d>>2]|0;if((c[d+116>>2]|0)==0?(b[k+76>>1]&8)==0:0)a[d+23>>0]=1;b:do if(c[k+272>>2]|0)if(!(a[k+81>>0]|0))q=15;else{h=0;break a}else{do if((e[k+276>>1]|0)>=224){i=k+300|0;h=c[i>>2]|0;if(h|0){c[i>>2]=c[h>>2];p=k+284|0;c[p>>2]=(c[p>>2]|0)+1;break b}i=k+296|0;h=c[i>>2]|0;if(!h){h=k+292|0;break}else{c[i>>2]=c[h>>2];p=k+284|0;c[p>>2]=(c[p>>2]|0)+1;break b}}else h=k+288|0;while(0);c[h>>2]=(c[h>>2]|0)+1;q=15}while(0);if((q|0)==15)h=Yd(k,224,0)|0;if(!h)h=0;else{i=h+104|0;j=i+120|0;do{c[i>>2]=0;i=i+4|0}while((i|0)<(j|0));c[h>>2]=k;i=k+4|0;j=c[i>>2]|0;if(j|0)c[j+4>>2]=h;c[h+8>>2]=j;c[h+4>>2]=0;c[i>>2]=h;c[h+20>>2]=381479589;c[h+12>>2]=d;c[l>>2]=h;Bi(h,61,0,1,0)|0}}while(0);if(!f)return;n=f+84|0;o=h+108|0;p=h+112|0;g=(g|0)==0;m=h+104|0;do{if(((c[n>>2]|0)==0?(c[(c[f+40>>2]|0)+4>>2]&4096|0)!=0:0)?(a[f+17>>0]|0)!=87:0){d=f+52|0;i=c[d>>2]|0;j=c[o>>2]|0;if((c[p>>2]|0)>(j|0)){c[o>>2]=j+1;l=c[m>>2]|0;a[l+(j*20|0)>>0]=73;b[l+(j*20|0)+2>>1]=0;c[l+(j*20|0)+4>>2]=0;c[l+(j*20|0)+8>>2]=i;c[l+(j*20|0)+12>>2]=0;c[l+(j*20|0)+16>>2]=0;a[l+(j*20|0)+1>>0]=0}else Bi(h,73,0,i,0)|0;i=f+56|0;j=c[i>>2]|0;k=c[o>>2]|0;if((c[p>>2]|0)>(k|0)){c[o>>2]=k+1;l=c[m>>2]|0;a[l+(k*20|0)>>0]=32;b[l+(k*20|0)+2>>1]=0;c[l+(k*20|0)+4>>2]=j;c[l+(k*20|0)+8>>2]=0;c[l+(k*20|0)+12>>2]=0;c[l+(k*20|0)+16>>2]=0;a[l+(k*20|0)+1>>0]=0}else Bi(h,32,j,0,0)|0;k=c[i>>2]|0;i=c[d>>2]|0;j=c[o>>2]|0;if((c[p>>2]|0)>(j|0)){c[o>>2]=j+1;l=c[m>>2]|0;a[l+(j*20|0)>>0]=90;b[l+(j*20|0)+2>>1]=0;c[l+(j*20|0)+4>>2]=k;c[l+(j*20|0)+8>>2]=0;c[l+(j*20|0)+12>>2]=i;c[l+(j*20|0)+16>>2]=0;a[l+(j*20|0)+1>>0]=0}else Bi(h,90,k,0,i)|0;j=c[o>>2]|0;if(!(a[(c[h>>2]|0)+81>>0]|0))i=(c[m>>2]|0)+((((j|0)<2?-1:-2)+j|0)*20|0)|0;else i=59308;c[i+8>>2]=j}else q=37;do if((q|0)==37?(q=0,(c[f+60>>2]|0)==0):0){i=c[(c[f+68>>2]|0)+20>>2]|0;if(!i)d=0;else d=c[i>>2]|0;l=f+48|0;k=c[l>>2]|0;if(g){i=c[f+52>>2]|0;j=c[o>>2]|0;if((c[p>>2]|0)>(j|0)){c[o>>2]=j+1;l=c[m>>2]|0;a[l+(j*20|0)>>0]=-100;b[l+(j*20|0)+2>>1]=0;c[l+(j*20|0)+4>>2]=k;c[l+(j*20|0)+8>>2]=d;c[l+(j*20|0)+12>>2]=i;c[l+(j*20|0)+16>>2]=0;a[l+(j*20|0)+1>>0]=0}else Bi(h,156,k,d,i)|0;i=c[f+40>>2]|0;j=c[h>>2]|0;if(!(a[j+81>>0]|0)){d=c[m>>2]|0;l=(c[o>>2]|0)+-1|0;a[d+(l*20|0)+1>>0]=-8;c[d+(l*20|0)+16>>2]=i;break}if(!(c[i+4>>2]&16))break;if(j|0){if(c[j+480>>2]|0){Vd(j,i);break}l=i;if((c[j+304>>2]|0)>>>0<=l>>>0?(c[j+308>>2]|0)>>>0>l>>>0:0){l=j+300|0;c[i>>2]=c[l>>2];c[l>>2]=i;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{l=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-l;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}i=c[o>>2]|0;if((c[p>>2]|0)>(i|0)){c[o>>2]=i+1;j=c[m>>2]|0;a[j+(i*20|0)>>0]=-99;b[j+(i*20|0)+2>>1]=0;c[j+(i*20|0)+4>>2]=k;c[j+(i*20|0)+8>>2]=d;c[j+(i*20|0)+12>>2]=0;c[j+(i*20|0)+16>>2]=0;a[j+(i*20|0)+1>>0]=0}else Bi(h,157,k,d,0)|0;i=c[f+40>>2]|0;j=c[h>>2]|0;do if(a[j+81>>0]|0){if(c[i+4>>2]&16|0){if(j|0){if(c[j+480>>2]|0){Vd(j,i);break}d=i;if((c[j+304>>2]|0)>>>0<=d>>>0?(c[j+308>>2]|0)>>>0>d>>>0:0){d=j+300|0;c[i>>2]=c[d>>2];c[d>>2]=i;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{d=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-d;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}}else{k=c[m>>2]|0;d=(c[o>>2]|0)+-1|0;a[k+(d*20|0)+1>>0]=-8;c[k+(d*20|0)+16>>2]=i}while(0);i=c[l>>2]|0;j=c[f+52>>2]|0;k=c[o>>2]|0;if((c[p>>2]|0)>(k|0)){c[o>>2]=k+1;d=c[m>>2]|0;a[d+(k*20|0)>>0]=78;b[d+(k*20|0)+2>>1]=0;c[d+(k*20|0)+4>>2]=i;c[d+(k*20|0)+8>>2]=j;c[d+(k*20|0)+12>>2]=0;c[d+(k*20|0)+16>>2]=0;a[d+(k*20|0)+1>>0]=0}else Bi(h,78,i,j,0)|0;i=c[l>>2]|0;j=c[o>>2]|0;if((c[p>>2]|0)>(j|0)){c[o>>2]=j+1;l=c[m>>2]|0;a[l+(j*20|0)>>0]=73;b[l+(j*20|0)+2>>1]=0;c[l+(j*20|0)+4>>2]=0;c[l+(j*20|0)+8>>2]=i;c[l+(j*20|0)+12>>2]=0;c[l+(j*20|0)+16>>2]=0;a[l+(j*20|0)+1>>0]=0;break}else{Bi(h,73,0,i,0)|0;break}}while(0);f=c[f+32>>2]|0}while((f|0)!=0);return}function pm(d){d=d|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0;J=d+4|0;K=c[J>>2]|0;M=c[d+8>>2]|0;l=K+84|0;L=c[d>>2]|0;do if(!(c[l>>2]|0)){if(!K){j=M+108|0;h=M+112|0;break}s=L+56|0;t=L+19|0;u=L+44|0;j=M+108|0;h=M+112|0;v=M+104|0;w=K+44|0;x=M+12|0;r=K;do{o=(c[r+40>>2]|0)+32|0;f=c[o>>2]|0;if((f|0)==43457|(f|0)==43467){m=c[r+56>>2]|0;p=c[s>>2]|0;k=p+-1|0;c[s>>2]=k;f=a[t>>0]|0;if(!(f<<24>>24)){n=(c[u>>2]|0)+1|0;c[u>>2]=n}else{n=f+-1<<24>>24;a[t>>0]=n;n=c[L+148+((n&255)<<2)>>2]|0}l=r+52|0;f=c[l>>2]|0;g=c[j>>2]|0;if((c[h>>2]|0)>(g|0)){c[j>>2]=g+1;K=c[v>>2]|0;a[K+(g*20|0)>>0]=73;b[K+(g*20|0)+2>>1]=0;c[K+(g*20|0)+4>>2]=0;c[K+(g*20|0)+8>>2]=f;c[K+(g*20|0)+12>>2]=0;c[K+(g*20|0)+16>>2]=0;a[K+(g*20|0)+1>>0]=0}else Bi(M,73,0,f,0)|0;do if((c[o>>2]|0)!=43457){f=c[j>>2]|0;if((c[h>>2]|0)>(f|0)){c[j>>2]=f+1;K=c[v>>2]|0;a[K+(f*20|0)>>0]=70;b[K+(f*20|0)+2>>1]=0;c[K+(f*20|0)+4>>2]=1;c[K+(f*20|0)+8>>2]=n;c[K+(f*20|0)+12>>2]=0;c[K+(f*20|0)+16>>2]=0;a[K+(f*20|0)+1>>0]=0;break}else{Bi(M,70,1,n,0)|0;break}}else{f=c[w>>2]|0;g=(c[r+76>>2]|0)+1|0;i=c[j>>2]|0;if((c[h>>2]|0)>(i|0)){c[j>>2]=i+1;K=c[v>>2]|0;a[K+(i*20|0)>>0]=90;b[K+(i*20|0)+2>>1]=0;c[K+(i*20|0)+4>>2]=f;c[K+(i*20|0)+8>>2]=g;c[K+(i*20|0)+12>>2]=n;c[K+(i*20|0)+16>>2]=0;a[K+(i*20|0)+1>>0]=0}else Bi(M,90,f,g,n)|0;nm(L,n,2)}while(0);f=r+60|0;g=c[f>>2]|0;i=c[j>>2]|0;if((c[h>>2]|0)>(i|0)){c[j>>2]=i+1;K=c[v>>2]|0;a[K+(i*20|0)>>0]=100;b[K+(i*20|0)+2>>1]=0;c[K+(i*20|0)+4>>2]=n;c[K+(i*20|0)+8>>2]=g;c[K+(i*20|0)+12>>2]=n;c[K+(i*20|0)+16>>2]=0;a[K+(i*20|0)+1>>0]=0}else Bi(M,100,n,g,n)|0;f=(c[f>>2]|0)+1|0;g=c[j>>2]|0;if((c[h>>2]|0)>(g|0)){c[j>>2]=g+1;K=c[v>>2]|0;a[K+(g*20|0)>>0]=54;b[K+(g*20|0)+2>>1]=0;c[K+(g*20|0)+4>>2]=f;c[K+(g*20|0)+8>>2]=k;c[K+(g*20|0)+12>>2]=n;c[K+(g*20|0)+16>>2]=0;a[K+(g*20|0)+1>>0]=0}else Bi(M,54,f,k,n)|0;f=c[j>>2]|0;if((c[h>>2]|0)>(f|0)){c[j>>2]=f+1;K=c[v>>2]|0;a[K+(f*20|0)>>0]=30;b[K+(f*20|0)+2>>1]=0;c[K+(f*20|0)+4>>2]=m;c[K+(f*20|0)+8>>2]=0;c[K+(f*20|0)+12>>2]=n;c[K+(f*20|0)+16>>2]=0;a[K+(f*20|0)+1>>0]=0}else Bi(M,30,m,0,n)|0;i=c[r+76>>2]|0;f=c[l>>2]|0;g=c[j>>2]|0;if((c[h>>2]|0)>(g|0)){c[j>>2]=g+1;K=c[v>>2]|0;a[K+(g*20|0)>>0]=90;b[K+(g*20|0)+2>>1]=0;c[K+(g*20|0)+4>>2]=m;c[K+(g*20|0)+8>>2]=i;c[K+(g*20|0)+12>>2]=f;c[K+(g*20|0)+16>>2]=0;a[K+(g*20|0)+1>>0]=0}else Bi(M,90,m,i,f)|0;g=c[x>>2]|0;f=0-p|0;if(((c[g+56>>2]|0)+(c[g+60>>2]|0)|0)<0)kk(g,M,f);else c[(c[g+64>>2]|0)+(f<<2)>>2]=c[j>>2];if(n|0?(y=a[t>>0]|0,(y&255)<8):0){a[t>>0]=y+1<<24>>24;c[L+148+((y&255)<<2)>>2]=n}}else if((f|0)==40587|(f|0)==40592){k=c[c[(c[r+68>>2]|0)+20>>2]>>2]|0;n=c[r+56>>2]|0;q=c[s>>2]|0;m=q+-1|0;c[s>>2]=m;f=a[t>>0]|0;if(!(f<<24>>24)){p=(c[u>>2]|0)+1|0;c[u>>2]=p}else{p=f+-1<<24>>24;a[t>>0]=p;p=c[L+148+((p&255)<<2)>>2]|0}l=c[w>>2]|0;do if((k|0)<3){f=c[r+52>>2]|0;g=c[j>>2]|0;if((c[h>>2]|0)>(g|0)){c[j>>2]=g+1;K=c[v>>2]|0;a[K+(g*20|0)>>0]=73;b[K+(g*20|0)+2>>1]=0;c[K+(g*20|0)+4>>2]=0;c[K+(g*20|0)+8>>2]=f;c[K+(g*20|0)+12>>2]=0;c[K+(g*20|0)+16>>2]=0;a[K+(g*20|0)+1>>0]=0;break}else{Bi(M,73,0,f,0)|0;break}}else{f=(c[r+76>>2]|0)+2|0;g=c[r+52>>2]|0;i=c[j>>2]|0;if((c[h>>2]|0)>(i|0)){c[j>>2]=i+1;K=c[v>>2]|0;a[K+(i*20|0)>>0]=90;b[K+(i*20|0)+2>>1]=0;c[K+(i*20|0)+4>>2]=l;c[K+(i*20|0)+8>>2]=f;c[K+(i*20|0)+12>>2]=g;c[K+(i*20|0)+16>>2]=0;a[K+(i*20|0)+1>>0]=0;break}else{Bi(M,90,l,f,g)|0;break}}while(0);f=c[j>>2]|0;if((c[h>>2]|0)>(f|0)){c[j>>2]=f+1;K=c[v>>2]|0;a[K+(f*20|0)>>0]=-128;b[K+(f*20|0)+2>>1]=0;c[K+(f*20|0)+4>>2]=l;c[K+(f*20|0)+8>>2]=p;c[K+(f*20|0)+12>>2]=0;c[K+(f*20|0)+16>>2]=0;a[K+(f*20|0)+1>>0]=0}else Bi(M,128,l,p,0)|0;f=(c[o>>2]|0)==40587;do if((k|0)<2){f=f?1:-1;g=c[j>>2]|0;if((c[h>>2]|0)>(g|0)){c[j>>2]=g+1;K=c[v>>2]|0;a[K+(g*20|0)>>0]=83;b[K+(g*20|0)+2>>1]=0;c[K+(g*20|0)+4>>2]=p;c[K+(g*20|0)+8>>2]=f;c[K+(g*20|0)+12>>2]=0;c[K+(g*20|0)+16>>2]=0;a[K+(g*20|0)+1>>0]=0;break}else{Bi(M,83,p,f,0)|0;break}}else{k=f?100:101;f=a[t>>0]|0;if(!(f<<24>>24)){i=(c[u>>2]|0)+1|0;c[u>>2]=i}else{i=f+-1<<24>>24;a[t>>0]=i;i=c[L+148+((i&255)<<2)>>2]|0}f=(c[r+76>>2]|0)+1|0;g=c[j>>2]|0;if((c[h>>2]|0)>(g|0)){c[j>>2]=g+1;K=c[v>>2]|0;a[K+(g*20|0)>>0]=90;b[K+(g*20|0)+2>>1]=0;c[K+(g*20|0)+4>>2]=l;c[K+(g*20|0)+8>>2]=f;c[K+(g*20|0)+12>>2]=i;c[K+(g*20|0)+16>>2]=0;a[K+(g*20|0)+1>>0]=0}else Bi(M,90,l,f,i)|0;f=c[j>>2]|0;if((c[h>>2]|0)>(f|0)){c[j>>2]=f+1;K=c[v>>2]|0;a[K+(f*20|0)>>0]=k;b[K+(f*20|0)+2>>1]=0;c[K+(f*20|0)+4>>2]=i;c[K+(f*20|0)+8>>2]=p;c[K+(f*20|0)+12>>2]=p;c[K+(f*20|0)+16>>2]=0;a[K+(f*20|0)+1>>0]=0}else Bi(M,k,i,p,p)|0;if(i|0?(z=a[t>>0]|0,(z&255)<8):0){a[t>>0]=z+1<<24>>24;c[L+148+((z&255)<<2)>>2]=i}}while(0);f=c[j>>2]|0;if((c[h>>2]|0)>(f|0)){c[j>>2]=f+1;K=c[v>>2]|0;a[K+(f*20|0)>>0]=30;b[K+(f*20|0)+2>>1]=0;c[K+(f*20|0)+4>>2]=n;c[K+(f*20|0)+8>>2]=m;c[K+(f*20|0)+12>>2]=p;c[K+(f*20|0)+16>>2]=0;a[K+(f*20|0)+1>>0]=0}else Bi(M,30,n,m,p)|0;f=c[r+76>>2]|0;g=c[r+52>>2]|0;i=c[j>>2]|0;if((c[h>>2]|0)>(i|0)){c[j>>2]=i+1;K=c[v>>2]|0;a[K+(i*20|0)>>0]=90;b[K+(i*20|0)+2>>1]=0;c[K+(i*20|0)+4>>2]=n;c[K+(i*20|0)+8>>2]=f;c[K+(i*20|0)+12>>2]=g;c[K+(i*20|0)+16>>2]=0;a[K+(i*20|0)+1>>0]=0}else Bi(M,90,n,f,g)|0;g=c[x>>2]|0;f=0-q|0;if(((c[g+56>>2]|0)+(c[g+60>>2]|0)|0)<0)kk(g,M,f);else c[(c[g+64>>2]|0)+(f<<2)>>2]=c[j>>2];if(p|0?(A=a[t>>0]|0,(A&255)<8):0){a[t>>0]=A+1<<24>>24;c[L+148+((A&255)<<2)>>2]=p}}r=c[r+32>>2]|0}while((r|0)!=0)}else{C=c[K+56>>2]|0;n=K+12|0;f=c[n>>2]|0;if(!f)E=0;else E=c[f>>2]|0;D=L+56|0;A=c[D>>2]|0;y=A+-1|0;m=A+-2|0;c[D>>2]=m;D=L+19|0;f=a[D>>0]|0;do if(f<<24>>24){B=f+-1<<24>>24;a[D>>0]=B;g=c[L+148+((B&255)<<2)>>2]|0;if(!(B<<24>>24)){h=L+44|0;f=h;h=c[h>>2]|0;t=8;break}else{f=f+-2<<24>>24;a[D>>0]=f;B=c[L+148+((f&255)<<2)>>2]|0;break}}else{f=L+44|0;h=(c[f>>2]|0)+1|0;c[f>>2]=h;g=h;t=8}while(0);if((t|0)==8){B=h+1|0;c[f>>2]=B;f=0}z=(E|0)!=0;a:do if(z)if((E|0)!=1){j=L+32|0;h=c[j>>2]|0;k=L+28|0;f=c[k>>2]|0;if((f|0)<(E|0)){x=L+44|0;i=c[x>>2]|0;c[x>>2]=i+E;i=i+1|0}else{x=h+E|0;c[j>>2]=x;f=f-E|0;c[k>>2]=f;i=h;h=x}if((f|0)<(E|0)){w=L+44|0;x=c[w>>2]|0;c[w>>2]=x+E;w=i;x=x+1|0;break}else{c[j>>2]=h+E;c[k>>2]=f-E;w=i;x=h;break}}else{do if(f<<24>>24){x=f+-1<<24>>24;a[D>>0]=x;h=c[L+148+((x&255)<<2)>>2]|0;if(!(x<<24>>24)){i=L+44|0;f=i;i=c[i>>2]|0;break}else{x=f+-2<<24>>24;a[D>>0]=x;w=h;x=c[L+148+((x&255)<<2)>>2]|0;break a}}else{f=L+44|0;i=(c[f>>2]|0)+1|0;c[f>>2]=i;h=i}while(0);x=i+1|0;c[f>>2]=x;w=h;break}else{w=0;x=0}while(0);k=K+44|0;f=c[k>>2]|0;j=M+108|0;i=c[j>>2]|0;h=M+112|0;if((c[h>>2]|0)>(i|0)){c[j>>2]=i+1;v=M+104|0;u=c[v>>2]|0;a[u+(i*20|0)>>0]=-128;b[u+(i*20|0)+2>>1]=0;c[u+(i*20|0)+4>>2]=f;c[u+(i*20|0)+8>>2]=g;c[u+(i*20|0)+12>>2]=0;c[u+(i*20|0)+16>>2]=0;a[u+(i*20|0)+1>>0]=0}else{Bi(M,128,f,g,0)|0;v=M+104|0}tm(d,c[k>>2]|0,w);f=K;do{i=c[f+48>>2]|0;k=c[j>>2]|0;if((c[h>>2]|0)>(k|0)){c[j>>2]=k+1;u=c[v>>2]|0;a[u+(k*20|0)>>0]=73;b[u+(k*20|0)+2>>1]=0;c[u+(k*20|0)+4>>2]=0;c[u+(k*20|0)+8>>2]=i;c[u+(k*20|0)+12>>2]=0;c[u+(k*20|0)+16>>2]=0;a[u+(k*20|0)+1>>0]=0}else Bi(M,73,0,i,0)|0;f=c[f+32>>2]|0}while((f|0)!=0);f=c[l>>2]|0;i=c[j>>2]|0;if((c[h>>2]|0)>(i|0)){c[j>>2]=i+1;u=c[v>>2]|0;a[u+(i*20|0)>>0]=24;b[u+(i*20|0)+2>>1]=0;c[u+(i*20|0)+4>>2]=C;c[u+(i*20|0)+8>>2]=m;c[u+(i*20|0)+12>>2]=f;c[u+(i*20|0)+16>>2]=0;a[u+(i*20|0)+1>>0]=0}else Bi(M,24,C,m,f)|0;u=c[j>>2]|0;if((c[h>>2]|0)>(u|0)){c[j>>2]=u+1;s=c[v>>2]|0;a[s+(u*20|0)>>0]=-128;b[s+(u*20|0)+2>>1]=0;c[s+(u*20|0)+4>>2]=C;c[s+(u*20|0)+8>>2]=B;c[s+(u*20|0)+12>>2]=0;c[s+(u*20|0)+16>>2]=0;a[s+(u*20|0)+1>>0]=0}else Bi(M,128,C,B,0)|0;f=c[K+88>>2]|0;i=c[j>>2]|0;if((c[h>>2]|0)>(i|0)){c[j>>2]=i+1;s=c[v>>2]|0;a[s+(i*20|0)>>0]=54;b[s+(i*20|0)+2>>1]=0;c[s+(i*20|0)+4>>2]=f;c[s+(i*20|0)+8>>2]=m;c[s+(i*20|0)+12>>2]=B;c[s+(i*20|0)+16>>2]=0;a[s+(i*20|0)+1>>0]=0}else Bi(M,54,f,m,B)|0;s=K+20|0;f=a[s>>0]|0;b:do switch(f<<24>>24){case 82:{f=c[j>>2]|0;if((c[h>>2]|0)>(f|0)){c[j>>2]=f+1;t=c[v>>2]|0;a[t+(f*20|0)>>0]=53;b[t+(f*20|0)+2>>1]=0;c[t+(f*20|0)+4>>2]=g;c[t+(f*20|0)+8>>2]=y;c[t+(f*20|0)+12>>2]=B;c[t+(f*20|0)+16>>2]=0;a[t+(f*20|0)+1>>0]=0;break b}else{Bi(M,53,g,y,B)|0;break b}}case 66:break;default:{p=c[n>>2]|0;if(!p){k=0;l=0}else{q=c[L>>2]|0;r=c[p>>2]|0;m=r+1|0;n=m*5|0;k=n+20|0;l=q+272|0;c:do if(c[l>>2]|0)if(!(a[q+81>>0]|0))t=56;else{f=0;i=0}else{do if(!(0<0|(0==0?(e[q+276>>1]|0)>>>0<k>>>0:0))){f=q+300|0;i=c[f>>2]|0;if(i|0){c[f>>2]=c[i>>2];o=q+284|0;c[o>>2]=(c[o>>2]|0)+1;o=i;t=57;break c}f=q+296|0;i=c[f>>2]|0;if(!i){f=q+292|0;break}else{c[f>>2]=c[i>>2];o=q+284|0;c[o>>2]=(c[o>>2]|0)+1;o=i;t=57;break c}}else f=q+288|0;while(0);c[f>>2]=(c[f>>2]|0)+1;t=56}while(0);if((t|0)==56){o=Yd(q,k,0)|0;t=57}d:do if((t|0)==57){if(o|0){l=o+16|0;c[l>>2]=o+20+(m<<2);b[o+6>>1]=r;b[o+8>>1]=m;a[o+4>>0]=a[q+78>>0]|0;c[o+12>>2]=q;c[o>>2]=1;ew(o+24|0,0,n+-4|0)|0;if((r|0)<=0){f=o;i=o;break}i=p+4|0;k=0;while(1){f=Wi(L,c[i>>2]|0)|0;if(!f)f=c[(c[L>>2]|0)+8>>2]|0;c[o+20+(k<<2)>>2]=f;a[(c[l>>2]|0)+k>>0]=a[i+12>>0]|0;k=k+1|0;if((k|0)==(r|0)){f=o;i=o;break d}else i=i+20|0}}f=q+81|0;if((a[f>>0]|0)==0?(a[q+82>>0]|0)==0:0){a[f>>0]=1;if((c[q+180>>2]|0)>0)c[q+264>>2]=1;c[l>>2]=(c[l>>2]|0)+1;f=c[q+236>>2]|0;if(f){c[f+12>>2]=7;f=o;i=0}else{f=o;i=0}}else{f=o;i=0}}while(0);k=f;f=a[s>>0]|0;l=i}do if(f<<24>>24==91){f=c[j>>2]|0;if((c[h>>2]|0)>(f|0)){c[j>>2]=f+1;m=c[v>>2]|0;a[m+(f*20|0)>>0]=53;b[m+(f*20|0)+2>>1]=0;c[m+(f*20|0)+4>>2]=g;c[m+(f*20|0)+8>>2]=0;c[m+(f*20|0)+12>>2]=B;c[m+(f*20|0)+16>>2]=0;a[m+(f*20|0)+1>>0]=0;m=f;break}else{m=Bi(M,53,g,0,B)|0;break}}else m=0;while(0);do if(!k){f=c[j>>2]|0;if((c[h>>2]|0)>(f|0)){c[j>>2]=f+1;t=c[v>>2]|0;a[t+(f*20|0)>>0]=11;b[t+(f*20|0)+2>>1]=0;c[t+(f*20|0)+4>>2]=0;c[t+(f*20|0)+8>>2]=y;c[t+(f*20|0)+12>>2]=0;c[t+(f*20|0)+16>>2]=0;a[t+(f*20|0)+1>>0]=0;break}else{Bi(M,11,0,y,0)|0;break}}else{tm(d,C,x);f=c[j>>2]|0;if((c[h>>2]|0)>(f|0)){c[j>>2]=f+1;t=c[v>>2]|0;a[t+(f*20|0)>>0]=87;b[t+(f*20|0)+2>>1]=0;c[t+(f*20|0)+4>>2]=x;c[t+(f*20|0)+8>>2]=w;c[t+(f*20|0)+12>>2]=E;c[t+(f*20|0)+16>>2]=0;a[t+(f*20|0)+1>>0]=0}else Bi(M,87,x,w,E)|0;f=c[M>>2]|0;e:do if(a[f+81>>0]|0){if(!((l|0)==0|(c[f+480>>2]|0)!=0)?(t=(c[l>>2]|0)+-1|0,c[l>>2]=t,(t|0)==0):0){f=c[l+12>>2]|0;do if(f|0){if(c[f+480>>2]|0){Vd(f,l);break e}i=l;if((c[f+304>>2]|0)>>>0>i>>>0)break;if((c[f+308>>2]|0)>>>0<=i>>>0)break;t=f+300|0;c[l>>2]=c[t>>2];c[t>>2]=l;break e}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{t=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-t;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}}else{s=c[v>>2]|0;t=(c[j>>2]|0)+-1|0;a[s+(t*20|0)+1>>0]=-9;c[s+(t*20|0)+16>>2]=l}while(0);f=c[j>>2]|0;i=f+1|0;if((c[h>>2]|0)>(f|0)){c[j>>2]=i;t=c[v>>2]|0;a[t+(f*20|0)>>0]=16;b[t+(f*20|0)+2>>1]=0;c[t+(f*20|0)+4>>2]=i;c[t+(f*20|0)+8>>2]=y;c[t+(f*20|0)+12>>2]=i;c[t+(f*20|0)+16>>2]=0;a[t+(f*20|0)+1>>0]=0;break}else{Bi(M,16,i,y,i)|0;break}}while(0);if(m|0){i=c[j>>2]|0;if(!(a[(c[M>>2]|0)+81>>0]|0))f=(c[v>>2]|0)+(((m|0)<0?i+-1|0:m)*20|0)|0;else f=59308;c[f+8>>2]=i}}}while(0);um(L,K,C,0,c[d+20>>2]|0);i=c[M+12>>2]|0;f=0-A|0;if(((c[i+56>>2]|0)+(c[i+60>>2]|0)|0)<0)kk(i,M,f);else c[(c[i+64>>2]|0)+(f<<2)>>2]=c[j>>2];f=c[j>>2]|0;if((c[h>>2]|0)>(f|0)){c[j>>2]=f+1;K=c[v>>2]|0;a[K+(f*20|0)>>0]=5;b[K+(f*20|0)+2>>1]=0;c[K+(f*20|0)+4>>2]=C;c[K+(f*20|0)+8>>2]=u;c[K+(f*20|0)+12>>2]=0;c[K+(f*20|0)+16>>2]=0;a[K+(f*20|0)+1>>0]=0}else Bi(M,5,C,u,0)|0;i=c[j>>2]|0;if(!(a[(c[M>>2]|0)+81>>0]|0)){f=c[v>>2]|0;c[f+((((u|0)<1?i:u)+-1|0)*20|0)+8>>2]=i;f=f+(((u|0)<-1?i+-1|0:u+1|0)*20|0)|0}else{c[14829]=i;f=59308}c[f+8>>2]=i;if(B|0?(F=a[D>>0]|0,(F&255)<8):0){a[D>>0]=F+1<<24>>24;c[L+148+((F&255)<<2)>>2]=B}if(g|0?(G=a[D>>0]|0,(G&255)<8):0){a[D>>0]=G+1<<24>>24;c[L+148+((G&255)<<2)>>2]=g}do if(z){if((E|0)!=1){f=L+28|0;if((c[f>>2]|0)>=(E|0))break;c[f>>2]=E;c[L+32>>2]=x;break}if(x|0?(H=a[D>>0]|0,(H&255)<8):0){a[D>>0]=H+1<<24>>24;c[L+148+((H&255)<<2)>>2]=x}if(w|0?(I=a[D>>0]|0,(I&255)<8):0){a[D>>0]=I+1<<24>>24;c[L+148+((I&255)<<2)>>2]=w}}while(0);om(c[d>>2]|0,c[J>>2]|0,1)}while(0);i=c[d+12>>2]|0;f=c[d+16>>2]|0;g=c[j>>2]|0;if((c[h>>2]|0)>(g|0)){c[j>>2]=g+1;M=c[M+104>>2]|0;a[M+(g*20|0)>>0]=12;b[M+(g*20|0)+2>>1]=0;c[M+(g*20|0)+4>>2]=i;c[M+(g*20|0)+8>>2]=f;c[M+(g*20|0)+12>>2]=0;c[M+(g*20|0)+16>>2]=0;a[M+(g*20|0)+1>>0]=0;return}else{Bi(M,12,i,f,0)|0;return}}function qm(d,f,g,h,i){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;n=d+8|0;j=c[n>>2]|0;a:do if(!j){m=c[d>>2]|0;if((c[d+116>>2]|0)==0?(b[m+76>>1]&8)==0:0)a[d+23>>0]=1;b:do if(c[m+272>>2]|0)if(!(a[m+81>>0]|0))r=15;else{t=0;break a}else{do if((e[m+276>>1]|0)>=224){j=m+300|0;k=c[j>>2]|0;if(k|0){c[j>>2]=c[k>>2];t=m+284|0;c[t>>2]=(c[t>>2]|0)+1;break b}j=m+296|0;k=c[j>>2]|0;if(!k){j=m+292|0;break}else{c[j>>2]=c[k>>2];t=m+284|0;c[t>>2]=(c[t>>2]|0)+1;break b}}else j=m+288|0;while(0);c[j>>2]=(c[j>>2]|0)+1;r=15}while(0);if((r|0)==15)k=Yd(m,224,0)|0;if(!k)t=0;else{j=k+104|0;l=j+120|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(l|0));c[k>>2]=m;j=m+4|0;l=c[j>>2]|0;if(l|0)c[l+4>>2]=k;c[k+8>>2]=l;c[k+4>>2]=0;c[j>>2]=k;c[k+20>>2]=381479589;c[k+12>>2]=d;c[n>>2]=k;Bi(k,61,0,1,0)|0;t=k}}else t=j;while(0);if(!f){j=t+108|0;k=c[j>>2]|0;if((c[t+112>>2]|0)>(k|0)){c[j>>2]=k+1;h=c[t+104>>2]|0;a[h+(k*20|0)>>0]=11;b[h+(k*20|0)+2>>1]=0;c[h+(k*20|0)+4>>2]=0;c[h+(k*20|0)+8>>2]=i;c[h+(k*20|0)+12>>2]=0;c[h+(k*20|0)+16>>2]=0;a[h+(k*20|0)+1>>0]=0;return}else{Bi(t,11,0,i,0)|0;return}}s=c[f>>2]|0;o=c[d>>2]|0;m=s+1|0;n=m*5|0;l=n+20|0;p=o+272|0;c:do if(c[p>>2]|0)if(!(a[o+81>>0]|0))r=31;else{l=0;k=1}else{do if(!(0<0|(0==0?(e[o+276>>1]|0)>>>0<l>>>0:0))){j=o+300|0;k=c[j>>2]|0;if(k|0){c[j>>2]=c[k>>2];q=o+284|0;c[q>>2]=(c[q>>2]|0)+1;q=k;r=32;break c}j=o+296|0;k=c[j>>2]|0;if(!k){j=o+292|0;break}else{c[j>>2]=c[k>>2];q=o+284|0;c[q>>2]=(c[q>>2]|0)+1;q=k;r=32;break c}}else j=o+288|0;while(0);c[j>>2]=(c[j>>2]|0)+1;r=31}while(0);if((r|0)==31){q=Yd(o,l,0)|0;r=32}if((r|0)==32){if(!q){j=o+81|0;if((a[j>>0]|0)==0?(a[o+82>>0]|0)==0:0){a[j>>0]=1;if((c[o+180>>2]|0)>0)c[o+264>>2]=1;c[p>>2]=(c[p>>2]|0)+1;j=c[o+236>>2]|0;if(j){c[j+12>>2]=7;l=0;k=1}else{l=0;k=1}}else{l=0;k=1}}else{c[q+16>>2]=q+20+(m<<2);b[q+6>>1]=s;b[q+8>>1]=m;a[q+4>>0]=a[o+78>>0]|0;c[q+12>>2]=o;c[q>>2]=1;ew(q+24|0,0,n+-4|0)|0;l=q;k=0}if((s|0)>0&(q|0)!=0){o=q+16|0;m=f+4|0;n=0;while(1){j=Wi(d,c[m>>2]|0)|0;if(!j)j=c[(c[d>>2]|0)+8>>2]|0;c[q+20+(n<<2)>>2]=j;a[(c[o>>2]|0)+n>>0]=a[m+12>>0]|0;n=n+1|0;if((n|0)==(s|0))break;else m=m+20|0}}}m=t+108|0;j=c[m>>2]|0;n=t+112|0;if((c[n>>2]|0)>(j|0)){c[m>>2]=j+1;d=c[t+104>>2]|0;a[d+(j*20|0)>>0]=87;b[d+(j*20|0)+2>>1]=0;c[d+(j*20|0)+4>>2]=h;c[d+(j*20|0)+8>>2]=g;c[d+(j*20|0)+12>>2]=s;c[d+(j*20|0)+16>>2]=0;a[d+(j*20|0)+1>>0]=0}else Bi(t,87,h,g,s)|0;j=c[t>>2]|0;do if(a[j+81>>0]|0){if(!(k|(c[j+480>>2]|0)!=0)?(d=(c[l>>2]|0)+-1|0,c[l>>2]=d,(d|0)==0):0){j=c[l+12>>2]|0;if(j|0){if(c[j+480>>2]|0){Vd(j,l);break}d=l;if((c[j+304>>2]|0)>>>0<=d>>>0?(c[j+308>>2]|0)>>>0>d>>>0:0){d=j+300|0;c[l>>2]=c[d>>2];c[d>>2]=l;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{d=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-d;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}}else{f=c[t+104>>2]|0;d=(c[m>>2]|0)+-1|0;a[f+(d*20|0)+1>>0]=-9;c[f+(d*20|0)+16>>2]=l}while(0);j=c[m>>2]|0;k=j+1|0;if((c[n>>2]|0)>(j|0)){c[m>>2]=k;d=c[t+104>>2]|0;a[d+(j*20|0)>>0]=16;b[d+(j*20|0)+2>>1]=0;c[d+(j*20|0)+4>>2]=k;c[d+(j*20|0)+8>>2]=i;c[d+(j*20|0)+12>>2]=k;c[d+(j*20|0)+16>>2]=0;a[d+(j*20|0)+1>>0]=0}else Bi(t,16,k,i,k)|0;j=s+-1|0;k=c[m>>2]|0;if((c[n>>2]|0)>(k|0)){c[m>>2]=k+1;i=c[t+104>>2]|0;a[i+(k*20|0)>>0]=78;b[i+(k*20|0)+2>>1]=0;c[i+(k*20|0)+4>>2]=g;c[i+(k*20|0)+8>>2]=h;c[i+(k*20|0)+12>>2]=j;c[i+(k*20|0)+16>>2]=0;a[i+(k*20|0)+1>>0]=0;return}else{Bi(t,78,g,h,j)|0;return}}function rm(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;y=c[d>>2]|0;l=d+4|0;u=c[l>>2]|0;A=c[d+8>>2]|0;h=a[u+16>>0]|0;s=h<<24>>24!=76;m=y+56|0;z=c[m>>2]|0;i=z+-1|0;c[m>>2]=i;m=(e|0)==2;if(m?(a[u+17>>0]|0)==87:0){A=0;return A|0}do if((f|0)>0){k=A+108|0;j=c[k>>2]|0;if(h<<24>>24!=86)if((c[A+112>>2]|0)>(j|0)){c[k>>2]=j+1;n=c[A+104>>2]|0;a[n+(j*20|0)>>0]=47;b[n+(j*20|0)+2>>1]=0;c[n+(j*20|0)+4>>2]=f;c[n+(j*20|0)+8>>2]=0;c[n+(j*20|0)+12>>2]=1;c[n+(j*20|0)+16>>2]=0;a[n+(j*20|0)+1>>0]=0;n=0;f=j;r=14;break}else{n=0;f=Bi(A,47,f,0,1)|0;r=14;break}if(!m){sm(d,54,c[d+44>>2]|0,f,c[d+36>>2]|0,i);n=j;f=0;r=14;break}if((a[u+17>>0]|0)==83)sm(d,55,c[d+36>>2]|0,f,c[d+28>>2]|0,i);else sm(d,57,c[d+28>>2]|0,f,c[d+36>>2]|0,i);l=0;m=k;k=c[k>>2]|0;r=19}else{n=0;f=0;r=14}while(0);do if((r|0)==14){if((e|0)==1){if(!(c[u+84>>2]|0))om(c[d>>2]|0,c[l>>2]|0,0);j=A+108|0;p=c[j>>2]|0;t=c[d+36>>2]|0;q=c[d+40>>2]|0;pm(d);v=f;break}o=A+108|0;k=c[o>>2]|0;if(!m){h=c[d+44>>2]|0;j=c[d+48>>2]|0;if(!(c[u+84>>2]|0)){um(y,u,h,0,c[d+20>>2]|0);t=h;q=j;v=f;p=k;j=o;break}i=c[u+88>>2]|0;if((c[A+112>>2]|0)>(k|0)){c[o>>2]=k+1;t=c[A+104>>2]|0;a[t+(k*20|0)>>0]=83;b[t+(k*20|0)+2>>1]=0;c[t+(k*20|0)+4>>2]=i;c[t+(k*20|0)+8>>2]=1;c[t+(k*20|0)+12>>2]=0;c[t+(k*20|0)+16>>2]=0;a[t+(k*20|0)+1>>0]=0;t=h;q=j;v=f;p=k;j=o;break}else{Bi(A,83,i,1,0)|0;t=h;q=j;v=f;p=k;j=o;break}}else{j=n;l=f;m=o;r=19}}while(0);do if((r|0)==19){h=c[d+28>>2]|0;f=c[d+32>>2]|0;i=c[u+84>>2]|0;if(!i){um(y,u,h,1,c[d+20>>2]|0);t=h;n=j;q=f;v=l;p=k;j=m;break}if((c[A+112>>2]|0)>(k|0)){c[A+108>>2]=k+1;t=c[A+104>>2]|0;a[t+(k*20|0)>>0]=83;b[t+(k*20|0)+2>>1]=0;c[t+(k*20|0)+4>>2]=i;c[t+(k*20|0)+8>>2]=1;c[t+(k*20|0)+12>>2]=0;c[t+(k*20|0)+16>>2]=0;a[t+(k*20|0)+1>>0]=0;t=h;n=j;q=f;v=l;p=k;j=m;break}else{Bi(A,83,i,1,0)|0;t=h;n=j;q=f;v=l;p=k;j=m;break}}while(0);if((c[d+24>>2]|0)==(e|0)){h=A+108|0;i=c[h>>2]|0;if((c[A+112>>2]|0)>(i|0)){c[h>>2]=i+1;e=c[A+104>>2]|0;a[e+(i*20|0)>>0]=123;b[e+(i*20|0)+2>>1]=0;c[e+(i*20|0)+4>>2]=t;c[e+(i*20|0)+8>>2]=0;c[e+(i*20|0)+12>>2]=0;c[e+(i*20|0)+16>>2]=0;a[e+(i*20|0)+1>>0]=0}else Bi(A,123,t,0,0)|0;h=c[h>>2]|0;if((h|0)>0)b[(c[A+104>>2]|0)+((h+-1|0)*20|0)+2>>1]=2}h=c[j>>2]|0;do if(!g){h=(s?2:1)+h|0;f=A+108|0;i=c[f>>2]|0;k=A+112|0;if((c[k>>2]|0)>(i|0)){c[f>>2]=i+1;g=c[A+104>>2]|0;a[g+(i*20|0)>>0]=5;b[g+(i*20|0)+2>>1]=0;c[g+(i*20|0)+4>>2]=t;c[g+(i*20|0)+8>>2]=h;c[g+(i*20|0)+12>>2]=0;c[g+(i*20|0)+16>>2]=0;a[g+(i*20|0)+1>>0]=0}else Bi(A,5,t,h,0)|0;if(s){j=c[f>>2]|0;if((c[k>>2]|0)>(j|0)){c[f>>2]=j+1;i=c[A+104>>2]|0;a[i+(j*20|0)>>0]=11;i=i+(j*20|0)+1|0;f=i+19|0;do{a[i>>0]=0;i=i+1|0}while((i|0)<(f|0));f=0;r=50;break}else{f=0;j=Bi(A,11,0,0,0)|0;r=50;break}}else{f=0;j=0}}else{h=h+2|0;j=A+108|0;i=c[j>>2]|0;f=A+112|0;if((c[f>>2]|0)>(i|0)){c[j>>2]=i+1;g=c[A+104>>2]|0;a[g+(i*20|0)>>0]=5;b[g+(i*20|0)+2>>1]=0;c[g+(i*20|0)+4>>2]=t;c[g+(i*20|0)+8>>2]=h;c[g+(i*20|0)+12>>2]=0;c[g+(i*20|0)+16>>2]=0;a[g+(i*20|0)+1>>0]=0}else Bi(A,5,t,h,0)|0;h=c[j>>2]|0;if((c[f>>2]|0)>(h|0)){c[j>>2]=h+1;i=c[A+104>>2]|0;a[i+(h*20|0)>>0]=11;i=i+(h*20|0)+1|0;f=i+19|0;do{a[i>>0]=0;i=i+1|0}while((i|0)<(f|0))}else h=Bi(A,11,0,0,0)|0;if(s){f=h;j=0;r=50}else{f=h;j=0}}while(0);do if((r|0)==50){o=u+12|0;h=c[o>>2]|0;a:do if(!h){k=0;i=0}else{i=c[h>>2]|0;switch(i|0){case 0:{k=i;break a}case 1:{h=y+19|0;i=a[h>>0]|0;if(!(i<<24>>24)){i=y+44|0;k=(c[i>>2]|0)+1|0;c[i>>2]=k;i=1;break a}else{k=i+-1<<24>>24;a[h>>0]=k;k=c[y+148+((k&255)<<2)>>2]|0;i=1;break a}}default:{h=y+32|0;k=c[h>>2]|0;l=y+28|0;m=c[l>>2]|0;if((m|0)<(i|0)){u=y+44|0;k=c[u>>2]|0;c[u>>2]=k+i;k=k+1|0;break a}else{c[h>>2]=k+i;c[l>>2]=m-i;break a}}}}while(0);tm(d,t,k);qm(y,c[o>>2]|0,k,q,p);if((i|0)!=1){h=y+28|0;if((c[h>>2]|0)>=(i|0))break;c[h>>2]=i;c[y+32>>2]=k;break}if((k|0)!=0?(w=y+19|0,x=a[w>>0]|0,(x&255)<8):0){a[w>>0]=x+1<<24>>24;c[y+148+((x&255)<<2)>>2]=k}}while(0);do if(n|0){h=A+108|0;i=c[h>>2]|0;if((c[A+112>>2]|0)>(i|0)){c[h>>2]=i+1;y=c[A+104>>2]|0;a[y+(i*20|0)>>0]=11;b[y+(i*20|0)+2>>1]=0;c[y+(i*20|0)+4>>2]=0;c[y+(i*20|0)+8>>2]=n;c[y+(i*20|0)+12>>2]=0;c[y+(i*20|0)+16>>2]=0;a[y+(i*20|0)+1>>0]=0;break}else{Bi(A,11,0,n,0)|0;break}}while(0);i=c[A+12>>2]|0;h=0-z|0;if(((c[i+56>>2]|0)+(c[i+60>>2]|0)|0)<0)kk(i,A,h);else c[(c[i+64>>2]|0)+(h<<2)>>2]=c[A+108>>2];if(j|0){i=c[A+108>>2]|0;if(!(a[(c[A>>2]|0)+81>>0]|0))h=(c[A+104>>2]|0)+(((j|0)<0?i+-1|0:j)*20|0)|0;else h=59308;c[h+8>>2]=i}if(!v){A=f;return A|0}i=c[A+108>>2]|0;if(!(a[(c[A>>2]|0)+81>>0]|0))h=(c[A+104>>2]|0)+(((v|0)<0?i+-1|0:v)*20|0)|0;else h=59308;c[h+8>>2]=i;A=f;return A|0}function sm(d,f,g,h,i,j){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=c[d>>2]|0;o=w+8|0;k=c[o>>2]|0;a:do if(!k){n=c[w>>2]|0;if((c[w+116>>2]|0)==0?(b[n+76>>1]&8)==0:0)a[w+23>>0]=1;b:do if(c[n+272>>2]|0)if(!(a[n+81>>0]|0))p=15;else{t=0;break a}else{do if((e[n+276>>1]|0)>=224){k=n+300|0;l=c[k>>2]|0;if(l|0){c[k>>2]=c[l>>2];u=n+284|0;c[u>>2]=(c[u>>2]|0)+1;break b}k=n+296|0;l=c[k>>2]|0;if(!l){k=n+292|0;break}else{c[k>>2]=c[l>>2];u=n+284|0;c[u>>2]=(c[u>>2]|0)+1;break b}}else k=n+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;p=15}while(0);if((p|0)==15)l=Yd(n,224,0)|0;if(!l)t=0;else{k=l+104|0;m=k+120|0;do{c[k>>2]=0;k=k+4|0}while((k|0)<(m|0));c[l>>2]=n;k=n+4|0;m=c[k>>2]|0;if(m|0)c[m+4>>2]=l;c[l+8>>2]=m;c[l+4>>2]=0;c[k>>2]=l;c[l+20>>2]=381479589;c[l+12>>2]=w;c[o>>2]=l;Bi(l,61,0,1,0)|0;t=l}}else t=k;while(0);u=w+19|0;l=a[u>>0]|0;if(l<<24>>24){s=l+-1<<24>>24;a[u>>0]=s;k=c[w+148+((s&255)<<2)>>2]|0;if(!(s<<24>>24))p=23;else{s=l+-2<<24>>24;a[u>>0]=s;q=w+44|0;r=k;s=c[w+148+((s&255)<<2)>>2]|0;l=q;k=c[q>>2]|0}}else{p=w+44|0;k=(c[p>>2]|0)+1|0;c[p>>2]=k;p=23}if((p|0)==23){l=w+44|0;q=(c[l>>2]|0)+1|0;c[l>>2]=q;r=k;s=q;k=q}p=k+1|0;c[l>>2]=p;n=(a[(c[(c[d+4>>2]|0)+12>>2]|0)+16>>0]|0)==0;q=n?100:101;f=n?f:(f|0)==57?55:(f|0)==54?56:57;tm(d,g,r);tm(d,i,s);n=t+108|0;k=c[n>>2]|0;o=t+112|0;if((c[o>>2]|0)>(k|0)){c[n>>2]=k+1;i=c[t+104>>2]|0;a[i+(k*20|0)>>0]=110;b[i+(k*20|0)+2>>1]=0;c[i+(k*20|0)+4>>2]=0;c[i+(k*20|0)+8>>2]=p;c[i+(k*20|0)+12>>2]=0;c[i+(k*20|0)+16>>2]=0;a[i+(k*20|0)+1>>0]=0}else k=Bi(t,110,0,p,0)|0;do if(!(a[(c[t>>2]|0)+81>>0]|0)){if((k|0)<0)k=(c[n>>2]|0)+-1|0;l=c[t+104>>2]|0;m=l+(k*20|0)+1|0;if(!(a[m>>0]|0)){c[l+(k*20|0)+16>>2]=59952;a[m>>0]=-1;break}else{Ci(t,l+(k*20|0)|0,59952,-1);break}}while(0);k=c[n>>2]|0;if((c[o>>2]|0)>(k|0)){c[n>>2]=k+1;i=c[t+104>>2]|0;a[i+(k*20|0)>>0]=57;b[i+(k*20|0)+2>>1]=0;c[i+(k*20|0)+4>>2]=p;c[i+(k*20|0)+8>>2]=0;c[i+(k*20|0)+12>>2]=r;c[i+(k*20|0)+16>>2]=0;a[i+(k*20|0)+1>>0]=0}else k=Bi(t,57,p,0,r)|0;l=c[n>>2]|0;if((c[o>>2]|0)>(l|0)){c[n>>2]=l+1;i=c[t+104>>2]|0;a[i+(l*20|0)>>0]=q;b[i+(l*20|0)+2>>1]=0;c[i+(l*20|0)+4>>2]=h;c[i+(l*20|0)+8>>2]=r;c[i+(l*20|0)+12>>2]=r;c[i+(l*20|0)+16>>2]=0;a[i+(l*20|0)+1>>0]=0}else Bi(t,q,h,r,r)|0;l=c[n>>2]|0;if(!(a[(c[t>>2]|0)+81>>0]|0))k=(c[t+104>>2]|0)+(((k|0)<0?l+-1|0:k)*20|0)|0;else k=59308;c[k+8>>2]=l;if((c[o>>2]|0)>(l|0)){c[n>>2]=l+1;h=c[t+104>>2]|0;a[h+(l*20|0)>>0]=f;b[h+(l*20|0)+2>>1]=0;c[h+(l*20|0)+4>>2]=s;c[h+(l*20|0)+8>>2]=j;c[h+(l*20|0)+12>>2]=r;c[h+(l*20|0)+16>>2]=0;a[h+(l*20|0)+1>>0]=0}else Bi(t,f,s,j,r)|0;k=c[n>>2]|0;if((k|0)>0)b[(c[t+104>>2]|0)+((k+-1|0)*20|0)+2>>1]=128;if(r|0?(v=a[u>>0]|0,(v&255)<8):0){a[u>>0]=v+1<<24>>24;c[w+148+((v&255)<<2)>>2]=r}if(!s)return;k=a[u>>0]|0;if((k&255)>=8)return;a[u>>0]=k+1<<24>>24;c[w+148+((k&255)<<2)>>2]=s;return}function tm(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;g=c[d+4>>2]|0;o=c[g+12>>2]|0;if(!o)return;n=Cj(c[d>>2]|0)|0;d=c[g+8>>2]|0;if(!d)d=0;else d=c[d>>2]|0;g=d+(c[g+72>>2]|0)|0;if((c[o>>2]|0)<=0)return;h=n+108|0;i=n+112|0;j=n+104|0;d=0;do{k=g+d|0;l=d+f|0;m=c[h>>2]|0;if((c[i>>2]|0)>(m|0)){c[h>>2]=m+1;p=c[j>>2]|0;a[p+(m*20|0)>>0]=90;b[p+(m*20|0)+2>>1]=0;c[p+(m*20|0)+4>>2]=e;c[p+(m*20|0)+8>>2]=k;c[p+(m*20|0)+12>>2]=l;c[p+(m*20|0)+16>>2]=0;a[p+(m*20|0)+1>>0]=0}else Bi(n,90,e,k,l)|0;d=d+1|0}while((d|0)<(c[o>>2]|0));return}function um(d,f,g,h,i){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;m=d+8|0;j=c[m>>2]|0;a:do if(!j){l=c[d>>2]|0;if((c[d+116>>2]|0)==0?(b[l+76>>1]&8)==0:0)a[d+23>>0]=1;b:do if(c[l+272>>2]|0)if(!(a[l+81>>0]|0))F=15;else{j=0;break a}else{do if((e[l+276>>1]|0)>=224){k=l+300|0;j=c[k>>2]|0;if(j|0){c[k>>2]=c[j>>2];E=l+284|0;c[E>>2]=(c[E>>2]|0)+1;break b}k=l+296|0;j=c[k>>2]|0;if(!j){j=l+292|0;break}else{c[k>>2]=c[j>>2];E=l+284|0;c[E>>2]=(c[E>>2]|0)+1;break b}}else j=l+288|0;while(0);c[j>>2]=(c[j>>2]|0)+1;F=15}while(0);if((F|0)==15)j=Yd(l,224,0)|0;if(!j)j=0;else{n=j+104|0;o=n+120|0;do{c[n>>2]=0;n=n+4|0}while((n|0)<(o|0));c[j>>2]=l;k=l+4|0;l=c[k>>2]|0;if(l|0)c[l+4>>2]=j;c[j+8>>2]=l;c[j+4>>2]=0;c[k>>2]=j;c[j+20>>2]=381479589;c[j+12>>2]=d;c[m>>2]=j;Bi(j,61,0,1,0)|0}}while(0);if(!f)return;t=f+84|0;u=j+108|0;v=j+112|0;w=f+44|0;x=j+104|0;y=1-h|0;z=(h|0)==0;A=d+19|0;B=z?154:153;C=d+44|0;D=B&255;E=i+1|0;s=f;do{r=c[s+40>>2]|0;q=s+68|0;k=c[(c[q>>2]|0)+20>>2]|0;if(k){o=c[k>>2]|0;if((o|0)>0){f=r+32|0;p=s+76|0;n=0;do{do if((n|0)==1?(c[f>>2]|0)==43457:0){k=c[w>>2]|0;l=(c[p>>2]|0)+1|0;m=c[u>>2]|0;if((c[v>>2]|0)>(m|0)){c[u>>2]=m+1;H=c[x>>2]|0;a[H+(m*20|0)>>0]=90;b[H+(m*20|0)+2>>1]=0;c[H+(m*20|0)+4>>2]=k;c[H+(m*20|0)+8>>2]=l;c[H+(m*20|0)+12>>2]=E;c[H+(m*20|0)+16>>2]=0;a[H+(m*20|0)+1>>0]=0;break}else{Bi(j,90,k,l,E)|0;break}}else F=27;while(0);do if((F|0)==27){F=0;k=(c[p>>2]|0)+n|0;l=n+i|0;m=c[u>>2]|0;if((c[v>>2]|0)>(m|0)){c[u>>2]=m+1;H=c[x>>2]|0;a[H+(m*20|0)>>0]=90;b[H+(m*20|0)+2>>1]=0;c[H+(m*20|0)+4>>2]=g;c[H+(m*20|0)+8>>2]=k;c[H+(m*20|0)+12>>2]=l;c[H+(m*20|0)+16>>2]=0;a[H+(m*20|0)+1>>0]=0;break}else{Bi(j,90,g,k,l)|0;break}}while(0);n=n+1|0}while((n|0)!=(o|0));p=o}else p=o}else p=0;if(((c[t>>2]|0)==0?(c[r+4>>2]&4096|0)!=0:0)?(a[s+17>>0]|0)!=87:0){k=c[u>>2]|0;if((c[v>>2]|0)>(k|0)){c[u>>2]=k+1;H=c[x>>2]|0;a[H+(k*20|0)>>0]=50;b[H+(k*20|0)+2>>1]=0;c[H+(k*20|0)+4>>2]=i;c[H+(k*20|0)+8>>2]=0;c[H+(k*20|0)+12>>2]=0;c[H+(k*20|0)+16>>2]=0;a[H+(k*20|0)+1>>0]=0}else k=Bi(j,50,i,0,0)|0;do if(z){o=s+60|0;l=(c[o>>2]|0)+1|0;m=c[u>>2]|0;if((c[v>>2]|0)>(m|0)){c[u>>2]=m+1;H=c[x>>2]|0;a[H+(m*20|0)>>0]=83;b[H+(m*20|0)+2>>1]=0;c[H+(m*20|0)+4>>2]=l;c[H+(m*20|0)+8>>2]=1;c[H+(m*20|0)+12>>2]=0;c[H+(m*20|0)+16>>2]=0;a[H+(m*20|0)+1>>0]=0}else Bi(j,83,l,1,0)|0;l=c[o>>2]|0;m=c[u>>2]|0;if((c[v>>2]|0)>(m|0)){c[u>>2]=m+1;H=c[x>>2]|0;a[H+(m*20|0)>>0]=79;b[H+(m*20|0)+2>>1]=0;c[H+(m*20|0)+4>>2]=i;c[H+(m*20|0)+8>>2]=l;c[H+(m*20|0)+12>>2]=0;c[H+(m*20|0)+16>>2]=0;a[H+(m*20|0)+1>>0]=0}else Bi(j,79,i,l,0)|0;l=c[o>>2]|0;m=l+2|0;n=c[u>>2]|0;if((c[v>>2]|0)>(n|0)){c[u>>2]=n+1;H=c[x>>2]|0;a[H+(n*20|0)>>0]=92;b[H+(n*20|0)+2>>1]=0;c[H+(n*20|0)+4>>2]=l;c[H+(n*20|0)+8>>2]=2;c[H+(n*20|0)+12>>2]=m;c[H+(n*20|0)+16>>2]=0;a[H+(n*20|0)+1>>0]=0}else Bi(j,92,l,2,m)|0;n=c[s+56>>2]|0;l=(c[o>>2]|0)+2|0;m=c[u>>2]|0;if((c[v>>2]|0)>(m|0)){c[u>>2]=m+1;H=c[x>>2]|0;a[H+(m*20|0)>>0]=-124;b[H+(m*20|0)+2>>1]=0;c[H+(m*20|0)+4>>2]=n;c[H+(m*20|0)+8>>2]=l;c[H+(m*20|0)+12>>2]=0;c[H+(m*20|0)+16>>2]=0;a[H+(m*20|0)+1>>0]=0;break}else{Bi(j,132,n,l,0)|0;break}}else{n=s+56|0;m=c[n>>2]|0;l=c[u>>2]|0;if((c[v>>2]|0)>(l|0)){c[u>>2]=l+1;H=c[x>>2]|0;a[H+(l*20|0)>>0]=24;b[H+(l*20|0)+2>>1]=0;c[H+(l*20|0)+4>>2]=m;c[H+(l*20|0)+8>>2]=0;c[H+(l*20|0)+12>>2]=i;c[H+(l*20|0)+16>>2]=0;a[H+(l*20|0)+1>>0]=0}else l=Bi(j,24,m,0,i)|0;if(!(a[(c[j>>2]|0)+81>>0]|0)){H=c[x>>2]|0;a[H+(l*20|0)+1>>0]=-3;c[H+(l*20|0)+16>>2]=1}l=c[n>>2]|0;m=c[u>>2]|0;if((c[v>>2]|0)>(m|0)){c[u>>2]=m+1;H=c[x>>2]|0;a[H+(m*20|0)>>0]=123;b[H+(m*20|0)+2>>1]=0;c[H+(m*20|0)+4>>2]=l;c[H+(m*20|0)+8>>2]=0;c[H+(m*20|0)+12>>2]=0;c[H+(m*20|0)+16>>2]=0;a[H+(m*20|0)+1>>0]=0}else Bi(j,123,l,0,0)|0;m=c[u>>2]|0;if(!(a[(c[j>>2]|0)+81>>0]|0))l=(c[x>>2]|0)+((((m|0)<2?-1:-2)+m|0)*20|0)|0;else l=59308;c[l+8>>2]=m}while(0);l=c[u>>2]|0;if(!(a[(c[j>>2]|0)+81>>0]|0))k=(c[x>>2]|0)+(((k|0)<0?l+-1|0:k)*20|0)|0;else k=59308;c[k+8>>2]=l}else F=67;do if((F|0)==67){F=0;k=c[s+60>>2]|0;if(k|0){k=y+k|0;l=c[u>>2]|0;if((c[v>>2]|0)>(l|0)){c[u>>2]=l+1;H=c[x>>2]|0;a[H+(l*20|0)>>0]=83;b[H+(l*20|0)+2>>1]=0;c[H+(l*20|0)+4>>2]=k;c[H+(l*20|0)+8>>2]=1;c[H+(l*20|0)+12>>2]=0;c[H+(l*20|0)+16>>2]=0;a[H+(l*20|0)+1>>0]=0;break}else{Bi(j,83,k,1,0)|0;break}}if((c[r+16>>2]|0)!=110){if(c[s+36>>2]|0){k=a[A>>0]|0;if(!(k<<24>>24)){m=(c[C>>2]|0)+1|0;c[C>>2]=m}else{m=k+-1<<24>>24;a[A>>0]=m;m=c[d+148+((m&255)<<2)>>2]|0}k=(c[s+76>>2]|0)+p|0;l=c[u>>2]|0;if((c[v>>2]|0)>(l|0)){c[u>>2]=l+1;H=c[x>>2]|0;a[H+(l*20|0)>>0]=90;b[H+(l*20|0)+2>>1]=0;c[H+(l*20|0)+4>>2]=g;c[H+(l*20|0)+8>>2]=k;c[H+(l*20|0)+12>>2]=m;c[H+(l*20|0)+16>>2]=0;a[H+(l*20|0)+1>>0]=0}else Bi(j,90,g,k,m)|0;k=c[u>>2]|0;if((c[v>>2]|0)>(k|0)){c[u>>2]=k+1;H=c[x>>2]|0;a[H+(k*20|0)>>0]=20;b[H+(k*20|0)+2>>1]=0;c[H+(k*20|0)+4>>2]=m;c[H+(k*20|0)+8>>2]=0;c[H+(k*20|0)+12>>2]=1;c[H+(k*20|0)+16>>2]=0;a[H+(k*20|0)+1>>0]=0}else k=Bi(j,20,m,0,1)|0;if((m|0)!=0?(G=a[A>>0]|0,(G&255)<8):0){a[A>>0]=G+1<<24>>24;c[d+148+((G&255)<<2)>>2]=m;f=k}else f=k}else f=0;do if(c[r+4>>2]&32|0){k=Wi(d,c[(c[(c[q>>2]|0)+20>>2]|0)+4>>2]|0)|0;if(!k)k=c[(c[d>>2]|0)+8>>2]|0;l=c[u>>2]|0;if((c[v>>2]|0)>(l|0)){c[u>>2]=l+1;n=c[x>>2]|0;a[n+(l*20|0)>>0]=82;n=n+(l*20|0)+1|0;o=n+19|0;do{a[n>>0]=0;n=n+1|0}while((n|0)<(o|0))}else l=Bi(j,82,0,0,0)|0;if(!(a[(c[j>>2]|0)+81>>0]|0)){if((l|0)<0)l=(c[u>>2]|0)+-1|0;m=c[x>>2]|0;n=m+(l*20|0)+1|0;if(a[n>>0]|0){Ci(j,m+(l*20|0)|0,k,-2);break}if(k|0){c[m+(l*20|0)+16>>2]=k;a[n>>0]=-2}}}while(0);k=c[s+48>>2]|0;l=c[u>>2]|0;if((c[v>>2]|0)>(l|0)){c[u>>2]=l+1;H=c[x>>2]|0;a[H+(l*20|0)>>0]=D;b[H+(l*20|0)+2>>1]=0;c[H+(l*20|0)+4>>2]=h;c[H+(l*20|0)+8>>2]=i;c[H+(l*20|0)+12>>2]=k;c[H+(l*20|0)+16>>2]=0;a[H+(l*20|0)+1>>0]=0}else Bi(j,B,h,i,k)|0;k=c[j>>2]|0;do if(a[k+81>>0]|0){if(c[r+4>>2]&16|0){if(k|0){if(c[k+480>>2]|0){Vd(k,r);break}H=r;if((c[k+304>>2]|0)>>>0<=H>>>0?(c[k+308>>2]|0)>>>0>H>>>0:0){H=k+300|0;c[r>>2]=c[H>>2];c[H>>2]=r;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](r);break}else{H=Ua[c[29352>>2]&127](r)|0;c[14978]=(c[14978]|0)-H;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](r);break}}}else{q=c[x>>2]|0;H=(c[u>>2]|0)+-1|0;a[q+(H*20|0)+1>>0]=-8;c[q+(H*20|0)+16>>2]=r}while(0);l=c[u>>2]|0;if((l|0)>0)b[(c[x>>2]|0)+((l+-1|0)*20|0)+2>>1]=p&255;if(f|0){if(!(a[(c[j>>2]|0)+81>>0]|0))k=(c[x>>2]|0)+(((f|0)<0?l+-1|0:f)*20|0)|0;else k=59308;c[k+8>>2]=l}}}while(0);s=c[s+32>>2]|0}while((s|0)!=0);return}function vm(a,b,c){a=a|0;b=b|0;c=c|0;return}function wm(d,e,f,g,h){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0;m=c[d+8>>2]|0;n=d+19|0;i=a[n>>0]|0;if(!(i<<24>>24)){k=d+44|0;l=(c[k>>2]|0)+1|0;c[k>>2]=l}else{l=i+-1<<24>>24;a[n>>0]=l;l=c[d+148+((l&255)<<2)>>2]|0}k=m+108|0;i=c[k>>2]|0;j=m+112|0;if((c[j>>2]|0)>(i|0)){c[k>>2]=i+1;o=c[m+104>>2]|0;a[o+(i*20|0)>>0]=29;b[o+(i*20|0)+2>>1]=0;c[o+(i*20|0)+4>>2]=e;c[o+(i*20|0)+8>>2]=f;c[o+(i*20|0)+12>>2]=h;c[o+(i*20|0)+16>>2]=0;a[o+(i*20|0)+1>>0]=0}else i=Bi(m,29,e,f,h)|0;if(!(a[(c[m>>2]|0)+81>>0]|0)){o=c[m+104>>2]|0;a[o+(i*20|0)+1>>0]=-3;c[o+(i*20|0)+16>>2]=g}i=c[k>>2]|0;if((c[j>>2]|0)>(i|0)){c[k>>2]=i+1;o=c[m+104>>2]|0;a[o+(i*20|0)>>0]=92;b[o+(i*20|0)+2>>1]=0;c[o+(i*20|0)+4>>2]=h;c[o+(i*20|0)+8>>2]=g;c[o+(i*20|0)+12>>2]=l;c[o+(i*20|0)+16>>2]=0;a[o+(i*20|0)+1>>0]=0}else Bi(m,92,h,g,l)|0;i=c[k>>2]|0;if((c[j>>2]|0)>(i|0)){c[k>>2]=i+1;o=c[m+104>>2]|0;a[o+(i*20|0)>>0]=-124;b[o+(i*20|0)+2>>1]=0;c[o+(i*20|0)+4>>2]=e;c[o+(i*20|0)+8>>2]=l;c[o+(i*20|0)+12>>2]=h;c[o+(i*20|0)+16>>2]=0;a[o+(i*20|0)+1>>0]=0}else i=Bi(m,132,e,l,h)|0;if(!(a[(c[m>>2]|0)+81>>0]|0)){o=c[m+104>>2]|0;a[o+(i*20|0)+1>>0]=-3;c[o+(i*20|0)+16>>2]=g}i=c[k>>2]|0;if((i|0)>0)b[(c[m+104>>2]|0)+((i+-1|0)*20|0)+2>>1]=16;if(!l)return;i=a[n>>0]|0;if((i&255)>=8)return;a[n>>0]=i+1<<24>>24;c[d+148+((i&255)<<2)>>2]=l;return}function xm(d,f,g,h,i,j,k){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;E=d+8|0;J=c[E>>2]|0;F=f+32|0;n=a[F>>0]&1;p=n<<24>>24==0;n=(n^1)&255;l=c[f>>2]|0;C=c[l>>2]|0;H=C+n+j|0;D=f+4|0;I=c[D>>2]|0;o=(k|0)==0;if(o){B=d+44|0;G=c[B>>2]|0;c[B>>2]=G+H;G=G+1|0}else G=h-k|0;k=c[g+16>>2]|0;if(!k)B=c[g+12>>2]|0;else B=k+1|0;z=d+56|0;y=(c[z>>2]|0)+-1|0;c[z>>2]=y;A=f+24|0;c[A>>2]=y;Mj(d,l,G,i,(i|0)==0?1:5);do if(p){k=c[f+8>>2]|0;l=G+C|0;i=J+108|0;m=c[i>>2]|0;if((c[J+112>>2]|0)>(m|0)){c[i>>2]=m+1;y=c[J+104>>2]|0;a[y+(m*20|0)>>0]=120;b[y+(m*20|0)+2>>1]=0;c[y+(m*20|0)+4>>2]=k;c[y+(m*20|0)+8>>2]=l;c[y+(m*20|0)+12>>2]=0;c[y+(m*20|0)+16>>2]=0;a[y+(m*20|0)+1>>0]=0;break}else{Bi(J,120,k,l,0)|0;break}}while(0);do if((j|0)>0&o){l=G+C+n|0;k=c[E>>2]|0;i=k+108|0;m=c[i>>2]|0;if((c[k+112>>2]|0)>(m|0)){c[i>>2]=m+1;y=c[k+104>>2]|0;a[y+(m*20|0)>>0]=77;b[y+(m*20|0)+2>>1]=0;c[y+(m*20|0)+4>>2]=h;c[y+(m*20|0)+8>>2]=l;c[y+(m*20|0)+12>>2]=j;c[y+(m*20|0)+16>>2]=0;a[y+(m*20|0)+1>>0]=0;break}else{Bi(k,77,h,l,j)|0;break}}while(0);if((I|0)>0){l=c[D>>2]|0;n=c[E>>2]|0;w=d+44|0;o=(c[w>>2]|0)+1|0;c[w>>2]=o;k=c[f+36>>2]|0;if(k|0)Mj(d,c[g>>2]|0,c[k>>2]|0,0,a[k+4>>0]|0);m=l+G|0;k=H-l|0;l=n+108|0;i=c[l>>2]|0;if((c[n+112>>2]|0)>(i|0)){c[l>>2]=i+1;y=c[n+104>>2]|0;a[y+(i*20|0)>>0]=92;b[y+(i*20|0)+2>>1]=0;c[y+(i*20|0)+4>>2]=m;c[y+(i*20|0)+8>>2]=k;c[y+(i*20|0)+12>>2]=o;c[y+(i*20|0)+16>>2]=0;a[y+(i*20|0)+1>>0]=0}else Bi(n,92,m,k,o)|0;v=c[w>>2]|0;y=v+1|0;n=c[D>>2]|0;c[w>>2]=n+v;do if(p){k=G+C|0;m=J+108|0;l=c[m>>2]|0;i=J+112|0;if((c[i>>2]|0)>(l|0)){c[m>>2]=l+1;u=c[J+104>>2]|0;a[u+(l*20|0)>>0]=20;b[u+(l*20|0)+2>>1]=0;c[u+(l*20|0)+4>>2]=k;c[u+(l*20|0)+8>>2]=0;c[u+(l*20|0)+12>>2]=0;c[u+(l*20|0)+16>>2]=0;a[u+(l*20|0)+1>>0]=0;u=l;v=m;break}else{u=Bi(J,20,k,0,0)|0;v=m;break}}else{k=c[f+8>>2]|0;m=J+108|0;l=c[m>>2]|0;i=J+112|0;if((c[i>>2]|0)>(l|0)){c[m>>2]=l+1;u=c[J+104>>2]|0;a[u+(l*20|0)>>0]=115;b[u+(l*20|0)+2>>1]=0;c[u+(l*20|0)+4>>2]=k;c[u+(l*20|0)+8>>2]=0;c[u+(l*20|0)+12>>2]=0;c[u+(l*20|0)+16>>2]=0;a[u+(l*20|0)+1>>0]=0;u=l;v=m;break}else{u=Bi(J,115,k,0,0)|0;v=m;break}}while(0);k=c[D>>2]|0;l=c[v>>2]|0;if((c[i>>2]|0)>(l|0)){c[v>>2]=l+1;t=c[J+104>>2]|0;a[t+(l*20|0)>>0]=87;b[t+(l*20|0)+2>>1]=0;c[t+(l*20|0)+4>>2]=y;c[t+(l*20|0)+8>>2]=G;c[t+(l*20|0)+12>>2]=k;c[t+(l*20|0)+16>>2]=0;a[t+(l*20|0)+1>>0]=0}else Bi(J,87,y,G,k)|0;k=c[f+20>>2]|0;if((k|0)<0)k=(c[v>>2]|0)+-1|0;if(!(a[(c[J>>2]|0)+81>>0]|0))k=(c[J+104>>2]|0)+(k*20|0)|0;else k=59308;if(a[(c[d>>2]|0)+81>>0]|0)return;c[k+8>>2]=H-n;t=k+16|0;n=c[t>>2]|0;h=n+6|0;ew(c[n+16>>2]|0,0,e[h>>1]|0)|0;k=c[J>>2]|0;a:do if(!(a[k+81>>0]|0)){k=(c[v>>2]|0)+-1|0;l=c[J+104>>2]|0;m=l+(k*20|0)+1|0;if(a[m>>0]|0){Ci(J,l+(k*20|0)|0,n,-9);break}if(n|0){c[l+(k*20|0)+16>>2]=n;a[m>>0]=-9}}else if(!((n|0)==0|(c[k+480>>2]|0)!=0)?(s=(c[n>>2]|0)+-1|0,c[n>>2]=s,(s|0)==0):0){k=c[n+12>>2]|0;do if(k|0){if(c[k+480>>2]|0){Vd(k,n);break a}l=n;if((c[k+304>>2]|0)>>>0>l>>>0)break;if((c[k+308>>2]|0)>>>0<=l>>>0)break;s=k+300|0;c[n>>2]=c[s>>2];c[s>>2]=n;break a}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](n);break}else{s=Ua[c[29352>>2]&127](n)|0;c[14978]=(c[14978]|0)-s;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](n);break}}while(0);r=c[f>>2]|0;q=c[d>>2]|0;s=c[r>>2]|0;p=s-I|0;n=p+((e[n+8>>1]|0)-(e[h>>1]|0))|0;h=n*5|0;m=h+20|0;j=q+272|0;b:do if(c[j>>2]|0)if(!(a[q+81>>0]|0))x=62;else k=0;else{do if(!(0<0|(0==0?(e[q+276>>1]|0)>>>0<m>>>0:0))){l=q+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];x=q+284|0;c[x>>2]=(c[x>>2]|0)+1;x=63;break b}l=q+296|0;k=c[l>>2]|0;if(!k){k=q+292|0;break}else{c[l>>2]=c[k>>2];x=q+284|0;c[x>>2]=(c[x>>2]|0)+1;x=63;break b}}else k=q+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;x=62}while(0);if((x|0)==62){k=Yd(q,m,0)|0;x=63}if((x|0)==63){do if(!k){l=q+81|0;if((a[l>>0]|0)==0?(a[q+82>>0]|0)==0:0){a[l>>0]=1;if((c[q+180>>2]|0)>0)c[q+264>>2]=1;c[j>>2]=(c[j>>2]|0)+1;l=c[q+236>>2]|0;if(!l)break;c[l+12>>2]=7}}else{c[k+16>>2]=k+20+(n<<2);b[k+6>>1]=p;b[k+8>>1]=n;a[k+4>>0]=a[q+78>>0]|0;c[k+12>>2]=q;c[k>>2]=1;ew(k+24|0,0,h+-4|0)|0}while(0);if((s|0)>(I|0)&(k|0)!=0){h=k+16|0;m=r+4+(I*20|0)|0;n=I;while(1){l=Wi(d,c[m>>2]|0)|0;if(!l)l=c[(c[d>>2]|0)+8>>2]|0;x=n-I|0;c[k+20+(x<<2)>>2]=l;a[(c[h>>2]|0)+x>>0]=a[m+12>>0]|0;n=n+1|0;if((n|0)==(s|0))break;else m=m+20|0}}}c[t>>2]=k;n=c[v>>2]|0;k=n+1|0;if((c[i>>2]|0)>(n|0)){c[v>>2]=k;x=c[J+104>>2]|0;a[x+(n*20|0)>>0]=16;b[x+(n*20|0)+2>>1]=0;c[x+(n*20|0)+4>>2]=k;c[x+(n*20|0)+8>>2]=0;c[x+(n*20|0)+12>>2]=k;c[x+(n*20|0)+16>>2]=0;a[x+(n*20|0)+1>>0]=0}else Bi(J,16,k,0,k)|0;m=(c[z>>2]|0)+-1|0;c[z>>2]=m;c[f+16>>2]=m;l=(c[w>>2]|0)+1|0;c[w>>2]=l;c[f+12>>2]=l;k=c[v>>2]|0;if((c[i>>2]|0)>(k|0)){c[v>>2]=k+1;z=c[J+104>>2]|0;a[z+(k*20|0)>>0]=12;b[z+(k*20|0)+2>>1]=0;c[z+(k*20|0)+4>>2]=l;c[z+(k*20|0)+8>>2]=m;c[z+(k*20|0)+12>>2]=0;c[z+(k*20|0)+16>>2]=0;a[z+(k*20|0)+1>>0]=0}else Bi(J,12,l,m,0)|0;k=c[f+8>>2]|0;l=c[v>>2]|0;if((c[i>>2]|0)>(l|0)){c[v>>2]=l+1;z=c[J+104>>2]|0;a[z+(l*20|0)>>0]=-118;b[z+(l*20|0)+2>>1]=0;c[z+(l*20|0)+4>>2]=k;c[z+(l*20|0)+8>>2]=0;c[z+(l*20|0)+12>>2]=0;c[z+(l*20|0)+16>>2]=0;a[z+(l*20|0)+1>>0]=0}else Bi(J,138,k,0,0)|0;do if(B|0){k=c[A>>2]|0;l=c[v>>2]|0;if((c[i>>2]|0)>(l|0)){c[v>>2]=l+1;A=c[J+104>>2]|0;a[A+(l*20|0)>>0]=20;b[A+(l*20|0)+2>>1]=0;c[A+(l*20|0)+4>>2]=B;c[A+(l*20|0)+8>>2]=k;c[A+(l*20|0)+12>>2]=0;c[A+(l*20|0)+16>>2]=0;a[A+(l*20|0)+1>>0]=0;break}else{Bi(J,20,B,k,0)|0;break}}while(0);l=c[v>>2]|0;if(!(a[(c[J>>2]|0)+81>>0]|0))k=(c[J+104>>2]|0)+(((u|0)<0?l+-1|0:u)*20|0)|0;else k=59308;c[k+8>>2]=l;l=c[D>>2]|0;k=c[E>>2]|0;i=k+108|0;m=c[i>>2]|0;if((c[k+112>>2]|0)>(m|0)){c[i>>2]=m+1;A=c[k+104>>2]|0;a[A+(m*20|0)>>0]=77;b[A+(m*20|0)+2>>1]=0;c[A+(m*20|0)+4>>2]=G;c[A+(m*20|0)+8>>2]=y;c[A+(m*20|0)+12>>2]=l;c[A+(m*20|0)+16>>2]=0;a[A+(m*20|0)+1>>0]=0}else Bi(k,77,G,y,l)|0;l=c[v>>2]|0;if(!(a[(c[J>>2]|0)+81>>0]|0))k=(c[J+104>>2]|0)+(((n|0)<0?l+-1|0:n)*20|0)|0;else k=59308;c[k+8>>2]=l}else o=0;do if(B){m=c[f+8>>2]|0;i=J+108|0;k=c[i>>2]|0;l=k+4|0;n=J+112|0;if((c[n>>2]|0)>(k|0)){c[i>>2]=k+1;A=c[J+104>>2]|0;a[A+(k*20|0)>>0]=48;b[A+(k*20|0)+2>>1]=0;c[A+(k*20|0)+4>>2]=B;c[A+(k*20|0)+8>>2]=l;c[A+(k*20|0)+12>>2]=0;c[A+(k*20|0)+16>>2]=0;a[A+(k*20|0)+1>>0]=0}else Bi(J,48,B,l,0)|0;k=c[i>>2]|0;if((c[n>>2]|0)>(k|0)){c[i>>2]=k+1;B=c[J+104>>2]|0;a[B+(k*20|0)>>0]=32;b[B+(k*20|0)+2>>1]=0;c[B+(k*20|0)+4>>2]=m;c[B+(k*20|0)+8>>2]=0;c[B+(k*20|0)+12>>2]=0;c[B+(k*20|0)+16>>2]=0;a[B+(k*20|0)+1>>0]=0}else Bi(J,32,m,0,0)|0;l=G+I|0;k=c[i>>2]|0;if((c[n>>2]|0)>(k|0)){c[i>>2]=k+1;B=c[J+104>>2]|0;a[B+(k*20|0)>>0]=37;b[B+(k*20|0)+2>>1]=0;c[B+(k*20|0)+4>>2]=m;c[B+(k*20|0)+8>>2]=0;c[B+(k*20|0)+12>>2]=l;c[B+(k*20|0)+16>>2]=0;a[B+(k*20|0)+1>>0]=0}else k=Bi(J,37,m,0,l)|0;if(!(a[(c[J>>2]|0)+81>>0]|0)){B=c[J+104>>2]|0;a[B+(k*20|0)+1>>0]=-3;c[B+(k*20|0)+16>>2]=C-I}l=c[i>>2]|0;if((c[n>>2]|0)>(l|0)){c[i>>2]=l+1;C=c[J+104>>2]|0;a[C+(l*20|0)>>0]=123;b[C+(l*20|0)+2>>1]=0;c[C+(l*20|0)+4>>2]=m;c[C+(l*20|0)+8>>2]=0;c[C+(l*20|0)+12>>2]=0;c[C+(l*20|0)+16>>2]=0;a[C+(l*20|0)+1>>0]=0;break}else{Bi(J,123,m,0,0)|0;break}}else k=0;while(0);do if(!o){i=c[D>>2]|0;h=c[E>>2]|0;l=d+44|0;o=(c[l>>2]|0)+1|0;c[l>>2]=o;l=c[f+36>>2]|0;if(l|0)Mj(d,c[g>>2]|0,c[l>>2]|0,0,a[l+4>>0]|0);n=i+G|0;l=H-i|0;i=h+108|0;m=c[i>>2]|0;if((c[h+112>>2]|0)>(m|0)){c[i>>2]=m+1;g=c[h+104>>2]|0;a[g+(m*20|0)>>0]=92;b[g+(m*20|0)+2>>1]=0;c[g+(m*20|0)+4>>2]=n;c[g+(m*20|0)+8>>2]=l;c[g+(m*20|0)+12>>2]=o;c[g+(m*20|0)+16>>2]=0;a[g+(m*20|0)+1>>0]=0;break}else{Bi(h,92,n,l,o)|0;break}}while(0);m=132-(a[F>>0]&1)|0;n=c[f+8>>2]|0;i=G+I|0;h=J+108|0;l=c[h>>2]|0;if((c[J+112>>2]|0)>(l|0)){c[h>>2]=l+1;G=c[J+104>>2]|0;a[G+(l*20|0)>>0]=m;b[G+(l*20|0)+2>>1]=0;c[G+(l*20|0)+4>>2]=n;c[G+(l*20|0)+8>>2]=o;c[G+(l*20|0)+12>>2]=i;c[G+(l*20|0)+16>>2]=0;a[G+(l*20|0)+1>>0]=0}else l=Bi(J,m,n,o,i)|0;if(!(a[(c[J>>2]|0)+81>>0]|0)){G=c[J+104>>2]|0;a[G+(l*20|0)+1>>0]=-3;c[G+(l*20|0)+16>>2]=H-I}if(!k)return;l=c[f+28>>2]|0;if(!l){l=c[h>>2]|0;if(!(a[(c[J>>2]|0)+81>>0]|0))k=(c[J+104>>2]|0)+(((k|0)<0?l+-1|0:k)*20|0)|0;else k=59308;c[k+8>>2]=l;return}if((k|0)<0)k=(c[h>>2]|0)+-1|0;if(!(a[(c[J>>2]|0)+81>>0]|0))k=(c[J+104>>2]|0)+(k*20|0)|0;else k=59308;c[k+8>>2]=l;return}function ym(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=Qa;Qa=Qa+64|0;l=m;if((a[d>>0]|0)==44){l=0;Qa=m;return l|0}e=c[b+24>>2]|0;j=c[b>>2]|0;i=c[e+40>>2]|0;k=l+20|0;a[k>>0]=1;c[l+4>>2]=149;c[l+8>>2]=0;c[l+24>>2]=i;c[l>>2]=j;Yj(l,d)|0;if(!(a[k>>0]|0)){l=1;Qa=m;return l|0}j=c[c[b>>2]>>2]|0;k=mj(j,147,17144,0)|0;if(!k){l=1;Qa=m;return l|0}e=e+36|0;f=c[e>>2]|0;g=l;h=k;i=g+52|0;do{c[g>>2]=c[h>>2];g=g+4|0;h=h+4|0}while((g|0)<(i|0));g=k;h=d;i=g+52|0;do{c[g>>2]=c[h>>2];g=g+4|0;h=h+4|0}while((g|0)<(i|0));g=d;h=l;i=g+52|0;do{c[g>>2]=c[h>>2];g=g+4|0;h=h+4|0}while((g|0)<(i|0));c[e>>2]=Vk(j,f,k)|0;a[b+20>>0]=1;l=1;Qa=m;return l|0}function zm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;h=c[b+24>>2]|0;a:do if((c[h>>2]|0)>0){g=0;while(1){e=c[h+4+(g*20|0)>>2]|0;if(($j(0,d,e,-1)|0)<2){f=c[b>>2]|0;e=Wi(f,e)|0;if(!e){e=c[(c[f>>2]|0)+8>>2]|0;if(!e){e=1;f=12;break}}if((c[e+12>>2]|0)==78?(c[e+8>>2]|0)==0:0){e=1;f=12;break}}g=g+1|0;if((g|0)>=(c[h>>2]|0))break a}if((f|0)==12)return e|0}while(0);if(!(c[d+4>>2]&2048)){d=Wj(b,d)|0;return d|0}else{a[b+20>>0]=0;d=2;return d|0}return 0}function Am(f,g){f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;h=c[f+24>>2]|0;s=c[h>>2]|0;j=c[h+4>>2]|0;t=c[h+8>>2]|0;switch(a[g>>0]|0){case -94:case -92:{if(!j){t=1;return t|0}i=c[j>>2]|0;if((i|0)<=0){t=1;return t|0}o=g+28|0;l=c[o>>2]|0;h=0;f=j+8|0;while(1){if((l|0)==(c[f+40>>2]|0))break;h=h+1|0;if((h|0)>=(i|0)){f=1;r=80;break}else f=f+72|0}if((r|0)==80)return f|0;j=t+28|0;n=t+32|0;p=c[n>>2]|0;a:do if((p|0)>0){k=c[j>>2]|0;i=g+32|0;h=k;f=0;while(1){if((c[h+4>>2]|0)==(l|0)?(c[h+8>>2]|0)==(b[i>>1]|0):0)break a;f=f+1|0;if((f|0)>=(p|0))break;else h=h+24|0}m=j;f=k;r=13}else{m=j;f=c[j>>2]|0;r=13}while(0);b:do if((r|0)==13){l=c[s>>2]|0;h=((p|0)<0)<<31>>31;k=Qv(p|0,h|0,-1,-1)|0;c:do if((k&p|0)==0&((L()|0)&h|0)==0){i=(p|0)==0;j=Wv(p|0,h|0,48,0)|0;k=L()|0;j=i?24:j;k=i?0:k;d:do if(!f){if(c[l+272>>2]|0){if(a[l+81>>0]|0){f=0;break}}else{do if(!(k>>>0>0|((k|0)==0?j>>>0>(e[l+276>>1]|0)>>>0:0))){i=l+300|0;h=c[i>>2]|0;if(h|0){c[i>>2]=c[h>>2];r=l+284|0;c[r>>2]=(c[r>>2]|0)+1;r=31;break d}i=l+296|0;h=c[i>>2]|0;if(!h){h=l+292|0;break}else{c[i>>2]=c[h>>2];r=l+284|0;c[r>>2]=(c[r>>2]|0)+1;r=31;break d}}else h=l+288|0;while(0);c[h>>2]=(c[h>>2]|0)+1}h=Yd(l,j,k)|0;r=31}else{r=f;if((c[l+304>>2]|0)>>>0<=r>>>0?(c[l+308>>2]|0)>>>0>r>>>0:0){if(!(k>>>0>0|((k|0)==0?j>>>0>(e[l+276>>1]|0)>>>0:0)))break c;h=Xd(l,f,j,k)|0;r=31;break}h=Xd(l,f,j,k)|0;r=31}while(0);if((r|0)==31)if(h){f=h;break}c[m>>2]=f;f=-1;break b}while(0);h=f+(p*24|0)|0;j=h+24|0;do{a[h>>0]=0;h=h+1|0}while((h|0)<(j|0));c[n>>2]=(c[n>>2]|0)+1;c[m>>2]=f;if((p|0)>-1){c[f+(p*24|0)>>2]=c[g+44>>2];j=c[o>>2]|0;c[f+(p*24|0)+4>>2]=j;k=b[g+32>>1]|0;c[f+(p*24|0)+8>>2]=k<<16>>16;s=s+44|0;i=(c[s>>2]|0)+1|0;c[s>>2]=i;c[f+(p*24|0)+16>>2]=i;i=f+(p*24|0)+12|0;c[i>>2]=-1;c[f+(p*24|0)+20>>2]=g;f=c[t+24>>2]|0;e:do if(f|0?(q=c[f>>2]|0,(q|0)>0):0){h=f+4|0;f=0;while(1){s=c[h>>2]|0;if(((a[s>>0]|0)==-94?(c[s+28>>2]|0)==(j|0):0)?(b[s+32>>1]|0)==k<<16>>16:0)break;f=f+1|0;if((f|0)<(q|0))h=h+20|0;else break e}c[i>>2]=f;f=p;break b}while(0);s=t+12|0;f=c[s>>2]|0;c[s>>2]=f+1;c[i>>2]=f;f=p}else f=p}while(0);c[g+40>>2]=t;a[g>>0]=-92;b[g+34>>1]=f;t=1;return t|0}case -93:{if(b[h+24>>1]&8){t=0;return t|0}if((c[f+16>>2]|0)!=(d[g+38>>0]|0)){t=0;return t|0}p=t+40|0;o=t+44|0;h=c[o>>2]|0;f:do if((h|0)>0){h=c[p>>2]|0;f=0;while(1){if(!($j(0,c[h>>2]|0,g,-1)|0))break;f=f+1|0;i=c[o>>2]|0;if((f|0)<(i|0))h=h+16|0;else break f}i=c[o>>2]|0}else{f=0;i=h}while(0);g:do if((f|0)>=(i|0)){m=c[s>>2]|0;n=a[m+78>>0]|0;f=c[p>>2]|0;h=((i|0)<0)<<31>>31;q=Qv(i|0,h|0,-1,-1)|0;h:do if((q&i|0)==0&((L()|0)&h|0)==0){q=(i|0)==0;k=aw(i|0,h|0,5)|0;l=L()|0;k=q?16:k;l=q?0:l;i:do if(!f){if(c[m+272>>2]|0){if(a[m+81>>0]|0){f=0;break}}else{do if(!(l>>>0>0|((l|0)==0?k>>>0>(e[m+276>>1]|0)>>>0:0))){j=m+300|0;h=c[j>>2]|0;if(h|0){c[j>>2]=c[h>>2];r=m+284|0;c[r>>2]=(c[r>>2]|0)+1;r=71;break i}j=m+296|0;h=c[j>>2]|0;if(!h){h=m+292|0;break}else{c[j>>2]=c[h>>2];r=m+284|0;c[r>>2]=(c[r>>2]|0)+1;r=71;break i}}else h=m+288|0;while(0);c[h>>2]=(c[h>>2]|0)+1}h=Yd(m,k,l)|0;r=71}else{r=f;if((c[m+304>>2]|0)>>>0<=r>>>0?(c[m+308>>2]|0)>>>0>r>>>0:0){if(!(l>>>0>0|((l|0)==0?k>>>0>(e[m+276>>1]|0)>>>0:0)))break h;h=Xd(m,f,k,l)|0;r=71;break}h=Xd(m,f,k,l)|0;r=71}while(0);if((r|0)==71)if(h){f=h;break}c[p>>2]=f;f=-1;break g}while(0);h=f+(i<<4)|0;j=h+16|0;do{a[h>>0]=0;h=h+1|0}while((h|0)<(j|0));c[o>>2]=(c[o>>2]|0)+1;c[p>>2]=f;if((i|0)>-1){c[f+(i<<4)>>2]=g;r=s+44|0;h=(c[r>>2]|0)+1|0;c[r>>2]=h;c[f+(i<<4)+8>>2]=h;h=c[g+20>>2]|0;if(!h)h=0;else h=c[h>>2]|0;c[f+(i<<4)+4>>2]=Hd(c[s>>2]|0,c[g+8>>2]|0,h,n,0)|0;if(!(c[g+4>>2]&2)){c[f+(i<<4)+12>>2]=-1;f=i;break}else{r=s+40|0;s=c[r>>2]|0;c[r>>2]=s+1;c[f+(i<<4)+12>>2]=s;f=i;break}}else f=i}while(0);b[g+34>>1]=f;c[g+40>>2]=t;t=1;return t|0}default:{t=0;return t|0}}return 0}function Bm(a,b){a=a|0;b=b|0;b=a+16|0;c[b>>2]=(c[b>>2]|0)+1;return 0}function Cm(a,b){a=a|0;b=b|0;b=a+16|0;c[b>>2]=(c[b>>2]|0)+-1;return}function Dm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;l=Qa;Qa=Qa+16|0;j=l+8|0;i=l;do if(!(c[d+56>>2]|0)){f=c[d+36>>2]|0;if(f&1025|0){g=c[b>>2]|0;h=c[g+32>>2]|0;if(f&1|0){if((h&268435457|0)==1&0==0)break;if(!(a[b+18>>0]|0)){k=12;break}else break}if((!((h&268435456|0)==0&0==0)?(c[g+352>>2]|0)==0:0)?(c[g+180>>2]|0)==0:0)k=12}}else{g=c[b>>2]|0;f=d+64|0;while(1){f=c[f>>2]|0;if((c[f>>2]|0)==(g|0))break;else f=f+24|0}if(!(c[(c[c[f+4>>2]>>2]|0)+52>>2]|0))k=12}while(0);if((k|0)==12){c[i>>2]=c[d>>2];ad(b,44627,i);k=1;Qa=l;return k|0}if(e|0){k=0;Qa=l;return k|0}if(!(c[d+12>>2]|0)){k=0;Qa=l;return k|0}c[j>>2]=c[d>>2];ad(b,44656,j);k=1;Qa=l;return k|0}function Em(b,d,f,g){b=b|0;d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;q=Qa;Qa=Qa+32|0;o=q;p=c[b>>2]|0;j=c[d+72>>2]|0;if(!j)k=-1e6;else{i=c[p+16>>2]|0;h=0;while(1)if((c[i+(h<<4)+12>>2]|0)==(j|0)){k=h;break}else h=h+1|0}if(!f)m=0;else m=bk(p,f,0,0)|0;n=nj(b,0,0,0)|0;if(!n)h=kj(b,0,0,m,0,0,0,131072,0)|0;else{f=c[d>>2]|0;a:do if(!f)h=0;else{d=(Cu(f)|0)+1|0;b:do if(!p){j=Qv(d|0,0,-1,-1)|0;i=L()|0;if(i>>>0>0|(i|0)==0&j>>>0>2147483390){h=0;break a}if(!(c[7324]|0)){h=Ua[c[29340>>2]&127](d)|0;l=32;break}h=Ua[c[29356>>2]&127](d)|0;if((c[14985]|0)>>>0<d>>>0)c[14985]=d;j=59064;i=c[j>>2]|0;j=c[j+4>>2]|0;if((j|0)>0|(j|0)==0&i>>>0>0){r=c[14978]|0;j=Rv(i|0,j|0,h|0,((h|0)<0)<<31>>31|0)|0;i=L()|0;c[14768]=((i|0)<0|(i|0)==0&j>>>0<=r>>>0)&1}h=Ua[c[29340>>2]&127](h)|0;if(!h){h=0;break a}i=Ua[c[29352>>2]&127](h)|0;i=(c[14978]|0)+i|0;c[14978]=i;if(i>>>0>(c[14982]|0)>>>0)c[14982]=i;i=(c[14981]|0)+1|0;c[14981]=i;if(i>>>0>(c[14987]|0)>>>0)c[14987]=i}else{if(c[p+272>>2]|0){if(a[p+81>>0]|0){h=0;break a}}else{do if(!(0<0|(0==0?(e[p+276>>1]|0)>>>0<d>>>0:0))){i=p+300|0;h=c[i>>2]|0;if(h|0){c[i>>2]=c[h>>2];l=p+284|0;c[l>>2]=(c[l>>2]|0)+1;l=32;break b}i=p+296|0;h=c[i>>2]|0;if(!h){h=p+292|0;break}else{c[i>>2]=c[h>>2];l=p+284|0;c[l>>2]=(c[l>>2]|0)+1;l=32;break b}}else h=p+288|0;while(0);c[h>>2]=(c[h>>2]|0)+1}h=Yd(p,d,0)|0;l=32}while(0);if((l|0)==32)if(!h){h=0;break}cw(h|0,f|0,d|0)|0}while(0);c[n+16>>2]=h;j=c[(c[p+16>>2]|0)+(k<<4)>>2]|0;c:do if(j){f=(Cu(j)|0)+1|0;d:do if(c[p+272>>2]|0)if(!(a[p+81>>0]|0))l=45;else{h=0;break c}else{do if(!(0<0|(0==0?(e[p+276>>1]|0)>>>0<f>>>0:0))){i=p+300|0;h=c[i>>2]|0;if(h|0){c[i>>2]=c[h>>2];r=p+284|0;c[r>>2]=(c[r>>2]|0)+1;break d}i=p+296|0;h=c[i>>2]|0;if(!h){h=p+292|0;break}else{c[i>>2]=c[h>>2];r=p+284|0;c[r>>2]=(c[r>>2]|0)+1;break d}}else h=p+288|0;while(0);c[h>>2]=(c[h>>2]|0)+1;l=45}while(0);if((l|0)==45)h=Yd(p,f,0)|0;if(h)cw(h|0,j|0,f|0)|0;else h=0}else h=0;while(0);c[n+12>>2]=h;h=kj(b,0,n,m,0,0,0,131072,0)|0}a[o>>0]=12;c[o+4>>2]=g;c[o+16>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;ij(b,h,o)|0;if(!h){Qa=q;return}ni(p,h,1);Qa=q;return}function Fm(f,g,h,i,j,k,l,m){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;if(c[g+56>>2]|0){f=0;return f|0}q=c[f>>2]|0;o=c[g+72>>2]|0;if(!o)y=-1e6;else{p=c[q+16>>2]|0;n=0;while(1)if((c[p+(n<<4)+12>>2]|0)==(o|0)){y=n;break}else n=n+1|0}z=f+8|0;n=c[z>>2]|0;a:do if(!n){if((c[f+116>>2]|0)==0?(b[q+76>>1]&8)==0:0)a[f+23>>0]=1;b:do if(c[q+272>>2]|0)if(!(a[q+81>>0]|0))r=19;else{n=0;break a}else{do if((e[q+276>>1]|0)>=224){o=q+300|0;n=c[o>>2]|0;if(n|0){c[o>>2]=c[n>>2];x=q+284|0;c[x>>2]=(c[x>>2]|0)+1;break b}o=q+296|0;n=c[o>>2]|0;if(!n){n=q+292|0;break}else{c[o>>2]=c[n>>2];x=q+284|0;c[x>>2]=(c[x>>2]|0)+1;break b}}else n=q+288|0;while(0);c[n>>2]=(c[n>>2]|0)+1;r=19}while(0);if((r|0)==19)n=Yd(q,224,0)|0;if(!n)n=0;else{o=n+104|0;p=o+120|0;do{c[o>>2]=0;o=o+4|0}while((o|0)<(p|0));c[n>>2]=q;o=q+4|0;p=c[o>>2]|0;if(p|0)c[p+4>>2]=n;c[n+8>>2]=p;c[n+4>>2]=0;c[o>>2]=n;c[n+20>>2]=381479589;c[n+12>>2]=f;c[z>>2]=n;Bi(n,61,0,1,0)|0}}while(0);if((j|0)<0)p=c[f+40>>2]|0;else p=j;o=p+1|0;q=(l|0)!=0;if(q)c[l>>2]=p;x=g+36|0;do if(!(c[x>>2]&32)){if(k|0?(a[k>>0]|0)==0:0){r=32;break}Ej(f,p,y,g,h)}else r=32;while(0);if((r|0)==32)Fj(f,y,c[g+28>>2]|0,(h|0)==109&1,c[g>>2]|0);if(m|0)c[m>>2]=o;p=c[g+8>>2]|0;if(!p)p=0;else{m=q^1;s=(k|0)==0;t=n+108|0;u=n+112|0;v=n+104|0;w=h&255;r=p;p=0;while(1){g=o+1|0;j=r+55|0;if(((d[j>>0]|d[j+1>>0]<<8)&3)==2){q=(c[x>>2]&32|0)==0;if(q|m)j=q?i:0;else{c[l>>2]=o;j=0}}else j=i;if(!(!s?!(a[k+(p+1)>>0]|0):0)){q=c[r+44>>2]|0;i=c[t>>2]|0;if((c[u>>2]|0)>(i|0)){c[t>>2]=i+1;A=c[v>>2]|0;a[A+(i*20|0)>>0]=w;b[A+(i*20|0)+2>>1]=0;c[A+(i*20|0)+4>>2]=o;c[A+(i*20|0)+8>>2]=q;c[A+(i*20|0)+12>>2]=y;c[A+(i*20|0)+16>>2]=0;a[A+(i*20|0)+1>>0]=0}else Bi(n,h,o,q,y)|0;o=c[z>>2]|0;i=Gj(f,r)|0;c:do if(i|0){q=c[o>>2]|0;if(!(a[q+81>>0]|0)){q=c[o+104>>2]|0;A=(c[o+108>>2]|0)+-1|0;a[q+(A*20|0)+1>>0]=-9;c[q+(A*20|0)+16>>2]=i;break}if((c[q+480>>2]|0)==0?(A=(c[i>>2]|0)+-1|0,c[i>>2]=A,(A|0)==0):0){o=c[i+12>>2]|0;do if(o|0){if(c[o+480>>2]|0){Vd(o,i);break c}q=i;if((c[o+304>>2]|0)>>>0>q>>>0)break;if((c[o+308>>2]|0)>>>0<=q>>>0)break;A=o+300|0;c[i>>2]=c[A>>2];c[A>>2]=i;break c}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{A=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-A;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}}while(0);o=c[t>>2]|0;if((o|0)>0)b[(c[v>>2]|0)+((o+-1|0)*20|0)+2>>1]=j&255}p=p+1|0;r=c[r+20>>2]|0;if(!r){o=g;break}else{i=j;o=g}}}n=f+40|0;if((o|0)<=(c[n>>2]|0)){A=p;return A|0}c[n>>2]=o;A=p;return A|0}function Gm(f,g,h,i,j,k,l,m,n,o,p){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;var q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,H=0,I=0,J=0,K=0,M=0,N=0,O=0,P=0,Q=0;N=f+8|0;Q=c[N>>2]|0;I=f+56|0;P=c[I>>2]|0;O=P+-1|0;c[I>>2]=O;I=(c[g+36>>2]&32|0)==0?31:28;J=o<<24>>24==0;if(J){r=Q+108|0;q=c[r>>2]|0;if((c[Q+112>>2]|0)>(q|0)){c[r>>2]=q+1;M=c[Q+104>>2]|0;a[M+(q*20|0)>>0]=I;b[M+(q*20|0)+2>>1]=0;c[M+(q*20|0)+4>>2]=i;c[M+(q*20|0)+8>>2]=O;c[M+(q*20|0)+12>>2]=k;c[M+(q*20|0)+16>>2]=0;a[M+(q*20|0)+1>>0]=0}else q=Bi(Q,I&255,i,O,k)|0;if(!(a[(c[Q>>2]|0)+81>>0]|0)){M=c[Q+104>>2]|0;a[M+(q*20|0)+1>>0]=-3;c[M+(q*20|0)+16>>2]=l<<16>>16}}if(!(0==0?(c[(c[f>>2]|0)+32>>2]&16384|0)==0:0)){w=c[g>>2]|0;t=c[g+72>>2]|0;u=c[t+68>>2]|0;if(!u){r=t+60|0;q=t+64|0}else{r=a[w>>0]|0;if(!(r<<24>>24))q=0;else{q=0;s=w;do{s=s+1|0;q=G(q+(d[208+(r&255)>>0]|0)|0,-1640531535)|0;r=a[s>>0]|0}while(r<<24>>24!=0)}q=(q>>>0)%((c[t+56>>2]|0)>>>0)|0;r=u+(q<<3)|0;q=u+(q<<3)+4|0}r=c[r>>2]|0;a:do if(!r)q=59292;else{v=d[208+(d[w>>0]|0)>>0]|0;while(1){q=c[q>>2]|0;r=r+-1|0;t=c[q+12>>2]|0;M=a[t>>0]|0;s=(d[208+(M&255)>>0]|0)-v|0;if(!(M<<24>>24==0|(s|0)!=0)){u=w;do{t=t+1|0;u=u+1|0;M=a[t>>0]|0;s=(d[208+(M&255)>>0]|0)-(d[208+(d[u>>0]|0)>>0]|0)|0}while(!(M<<24>>24==0|(s|0)!=0))}if(!s)break a;if(!r){q=59292;break}}}while(0);if(!(c[q+8>>2]|0)){q=(c[g+16>>2]|0)!=0&1;M=23}else M=24}else{q=0;M=23}if((M|0)==23)if((h|0)!=0|(q|0)!=0)M=24;else F=0;if((M|0)==24){H=n&255;u=(h|0)==0;if(u)q=0;else{t=f+116|0;q=0;s=h;do{do if((a[s+8>>0]|0)==121?(a[s+9>>0]&3)!=0:0){r=c[t>>2]|0;r=c[((r|0)==0?f:r)+260>>2]|0;b:do if(!r)M=33;else while(1){if((c[r>>2]|0)==(s|0)?(c[r+12>>2]|0)==(H|0):0)break b;r=c[r+4>>2]|0;if(!r){M=33;break}}while(0);if((M|0)==33){M=0;r=Lm(f,s,g,H)|0;if(!r)break}q=c[r+16>>2]|q}while(0);s=c[s+32>>2]|0}while((s|0)!=0)}s=Im(f,g)|0|q;C=f+44|0;F=(c[C>>2]|0)+1|0;t=g+42|0;c[C>>2]=F+(b[t>>1]|0);D=Q+108|0;q=c[D>>2]|0;E=Q+112|0;if((c[E>>2]|0)>(q|0)){c[D>>2]=q+1;B=c[Q+104>>2]|0;a[B+(q*20|0)>>0]=78;b[B+(q*20|0)+2>>1]=0;c[B+(q*20|0)+4>>2]=k;c[B+(q*20|0)+8>>2]=F;c[B+(q*20|0)+12>>2]=0;c[B+(q*20|0)+16>>2]=0;a[B+(q*20|0)+1>>0]=0}else Bi(Q,78,k,F,0)|0;q=b[t>>1]|0;c:do if(q<<16>>16>0){if((s|0)==-1){q=0;while(1){B=q;q=q+1|0;Tj(Q,g,i,B,q+F|0);if((q|0)>=(b[t>>1]|0))break c}}r=0;do{if(r>>>0<32?(1<<r&s|0)!=0:0){Tj(Q,g,i,r,r+1+F|0);q=b[t>>1]|0}r=r+1|0}while((r|0)<(q<<16>>16|0))}while(0);A=c[D>>2]|0;if(u)q=A;else{y=f+116|0;z=f+23|0;x=h;do{do if((a[x+8>>0]|0)==121?(a[x+9>>0]|0)==1:0){q=c[N>>2]|0;d:do if(!q){s=c[f>>2]|0;if((c[y>>2]|0)==0?(b[s+76>>1]&8)==0:0)a[z>>0]=1;e:do if(c[s+272>>2]|0)if(!(a[s+81>>0]|0))M=66;else{q=0;break d}else{do if((e[s+276>>1]|0)>=224){r=s+300|0;q=c[r>>2]|0;if(q|0){c[r>>2]=c[q>>2];B=s+284|0;c[B>>2]=(c[B>>2]|0)+1;break e}r=s+296|0;q=c[r>>2]|0;if(!q){q=s+292|0;break}else{c[r>>2]=c[q>>2];B=s+284|0;c[B>>2]=(c[B>>2]|0)+1;break e}}else q=s+288|0;while(0);c[q>>2]=(c[q>>2]|0)+1;M=66}while(0);if((M|0)==66){M=0;q=Yd(s,224,0)|0}if(!q)q=0;else{v=q+104|0;B=v+120|0;do{c[v>>2]=0;v=v+4|0}while((v|0)<(B|0));c[q>>2]=s;r=s+4|0;s=c[r>>2]|0;if(s|0)c[s+4>>2]=q;c[q+8>>2]=s;c[q+4>>2]=0;c[r>>2]=q;c[q+20>>2]=381479589;c[q+12>>2]=f;c[N>>2]=q;Bi(q,61,0,1,0)|0}}while(0);r=c[y>>2]|0;r=c[((r|0)==0?f:r)+260>>2]|0;f:do if(!r)M=76;else while(1){if((c[r>>2]|0)==(x|0)?(c[r+12>>2]|0)==(H|0):0)break f;r=c[r+4>>2]|0;if(!r){M=76;break}}while(0);if((M|0)==76){M=0;r=Lm(f,x,g,H)|0;if(!r)break}if(!(c[x>>2]|0))w=0;else{w=(c[f>>2]|0)+32|0;w=$v(c[w>>2]|0,c[w+4>>2]|0,13)|0;L()|0;w=w&1^1}s=(c[C>>2]|0)+1|0;c[C>>2]=s;u=c[r+8>>2]|0;v=q+108|0;r=c[v>>2]|0;if((c[q+112>>2]|0)>(r|0)){c[v>>2]=r+1;B=c[q+104>>2]|0;a[B+(r*20|0)>>0]=45;b[B+(r*20|0)+2>>1]=0;c[B+(r*20|0)+4>>2]=F;c[B+(r*20|0)+8>>2]=O;c[B+(r*20|0)+12>>2]=s;c[B+(r*20|0)+16>>2]=0;a[B+(r*20|0)+1>>0]=0}else r=Bi(q,45,F,O,s)|0;do if(!(a[(c[q>>2]|0)+81>>0]|0)){if((r|0)<0)r=(c[v>>2]|0)+-1|0;s=c[q+104>>2]|0;t=s+(r*20|0)+1|0;if(a[t>>0]|0){Ci(q,s+(r*20|0)|0,u,-4);break}if(!u)break;c[s+(r*20|0)+16>>2]=u;a[t>>0]=-4}while(0);r=c[v>>2]|0;if((r|0)>0)b[(c[q+104>>2]|0)+((r+-1|0)*20|0)+2>>1]=w}while(0);x=c[x+32>>2]|0}while((x|0)!=0);q=c[D>>2]|0}if((A|0)<(q|0)){if((c[E>>2]|0)>(q|0)){c[D>>2]=q+1;H=c[Q+104>>2]|0;a[H+(q*20|0)>>0]=I;b[H+(q*20|0)+2>>1]=0;c[H+(q*20|0)+4>>2]=i;c[H+(q*20|0)+8>>2]=O;c[H+(q*20|0)+12>>2]=k;c[H+(q*20|0)+16>>2]=0;a[H+(q*20|0)+1>>0]=0}else q=Bi(Q,I&255,i,O,k)|0;if(!(a[(c[Q>>2]|0)+81>>0]|0)){k=c[Q+104>>2]|0;a[k+(q*20|0)+1>>0]=-3;c[k+(q*20|0)+16>>2]=l<<16>>16;q=-1}else q=-1}else q=p;Jm(f,g,F,0,0,0);p=q}if(!(c[g+12>>2]|0)){Km(f,g,i,j,0,p);q=m<<24>>24!=0&1;t=Q+108|0;r=c[t>>2]|0;u=Q+112|0;if((c[u>>2]|0)>(r|0)){c[t>>2]=r+1;m=c[Q+104>>2]|0;a[m+(r*20|0)>>0]=123;b[m+(r*20|0)+2>>1]=0;c[m+(r*20|0)+4>>2]=i;c[m+(r*20|0)+8>>2]=q;c[m+(r*20|0)+12>>2]=0;c[m+(r*20|0)+16>>2]=0;a[m+(r*20|0)+1>>0]=0}else Bi(Q,123,i,q,0)|0;if(a[f+18>>0]|0){r=c[g>>2]|0;if(r|0){m=a[r>>0]|0;q=(d[208+(m&255)>>0]|0)+-115|0;if(!(m<<24>>24==0|(q|0)!=0)){s=35174;do{r=r+1|0;s=s+1|0;m=a[r>>0]|0;q=(d[208+(m&255)>>0]|0)-(d[208+(d[s>>0]|0)>>0]|0)|0}while(!(m<<24>>24==0|(q|0)!=0))}if(!q)M=110}}else M=110;if((M|0)==110?(a[(c[Q>>2]|0)+81>>0]|0)==0:0){j=c[Q+104>>2]|0;m=(c[t>>2]|0)+-1|0;a[j+(m*20|0)+1>>0]=-6;c[j+(m*20|0)+16>>2]=g}if(!J?(K=c[t>>2]|0,(K|0)>0):0)b[(c[Q+104>>2]|0)+((K+-1|0)*20|0)+2>>1]=4;do if(!((p|0)<0|(p|0)==(i|0))){q=c[t>>2]|0;if((c[u>>2]|0)>(q|0)){c[t>>2]=q+1;K=c[Q+104>>2]|0;a[K+(q*20|0)>>0]=123;b[K+(q*20|0)+2>>1]=0;c[K+(q*20|0)+4>>2]=p;c[K+(q*20|0)+8>>2]=0;c[K+(q*20|0)+12>>2]=0;c[K+(q*20|0)+16>>2]=0;a[K+(q*20|0)+1>>0]=0;break}else{Bi(Q,123,p,0,0)|0;break}}while(0);q=c[t>>2]|0;if((q|0)>0)b[(c[Q+104>>2]|0)+((q+-1|0)*20|0)+2>>1]=o<<24>>24==2?2:0}if(!(0==0?(c[(c[f>>2]|0)+32>>2]&16384|0)==0:0)){v=c[g>>2]|0;t=c[g+72>>2]|0;u=c[t+68>>2]|0;if(!u){r=t+60|0;q=t+64|0}else{r=a[v>>0]|0;if(!(r<<24>>24))q=0;else{q=0;s=v;do{s=s+1|0;q=G(q+(d[208+(r&255)>>0]|0)|0,-1640531535)|0;r=a[s>>0]|0}while(r<<24>>24!=0)}q=(q>>>0)%((c[t+56>>2]|0)>>>0)|0;r=u+(q<<3)|0;q=u+(q<<3)+4|0}r=c[r>>2]|0;g:do if(!r)q=59292;else{p=d[208+(d[v>>0]|0)>>0]|0;while(1){q=c[q>>2]|0;r=r+-1|0;t=c[q+12>>2]|0;o=a[t>>0]|0;s=(d[208+(o&255)>>0]|0)-p|0;if(!(o<<24>>24==0|(s|0)!=0)){u=v;do{t=t+1|0;u=u+1|0;o=a[t>>0]|0;s=(d[208+(o&255)>>0]|0)-(d[208+(d[u>>0]|0)>>0]|0)|0}while(!(o<<24>>24==0|(s|0)!=0))}if(!s)break g;if(!r){q=59292;break}}}while(0);q=c[q+8>>2]|0;if(q|0){x=f+116|0;y=f+23|0;z=f+44|0;do{u=Pm(f,g,q,0)|0;do if(u|0){r=c[N>>2]|0;h:do if(!r){t=c[f>>2]|0;if((c[x>>2]|0)==0?(b[t+76>>1]&8)==0:0)a[y>>0]=1;i:do if(c[t+272>>2]|0)if(!(a[t+81>>0]|0))M=152;else{r=0;break h}else{do if((e[t+276>>1]|0)>=224){s=t+300|0;r=c[s>>2]|0;if(r|0){c[s>>2]=c[r>>2];o=t+284|0;c[o>>2]=(c[o>>2]|0)+1;break i}s=t+296|0;r=c[s>>2]|0;if(!r){r=t+292|0;break}else{c[s>>2]=c[r>>2];o=t+284|0;c[o>>2]=(c[o>>2]|0)+1;break i}}else r=t+288|0;while(0);c[r>>2]=(c[r>>2]|0)+1;M=152}while(0);if((M|0)==152){M=0;r=Yd(t,224,0)|0}if(!r)r=0;else{v=r+104|0;B=v+120|0;do{c[v>>2]=0;v=v+4|0}while((v|0)<(B|0));c[r>>2]=t;s=t+4|0;t=c[s>>2]|0;if(t|0)c[t+4>>2]=r;c[r+8>>2]=t;c[r+4>>2]=0;c[s>>2]=r;c[r+20>>2]=381479589;c[r+12>>2]=f;c[N>>2]=r;Bi(r,61,0,1,0)|0}}while(0);s=c[x>>2]|0;s=c[((s|0)==0?f:s)+260>>2]|0;j:do if(!s)M=162;else while(1){if((c[s>>2]|0)==(u|0)?(c[s+12>>2]|0)==2:0)break j;s=c[s+4>>2]|0;if(!s){M=162;break}}while(0);if((M|0)==162){M=0;s=Lm(f,u,g,2)|0;if(!s)break}if(!(c[u>>2]|0))w=0;else{w=(c[f>>2]|0)+32|0;w=$v(c[w>>2]|0,c[w+4>>2]|0,13)|0;L()|0;w=w&1^1}t=(c[z>>2]|0)+1|0;c[z>>2]=t;p=c[s+8>>2]|0;v=r+108|0;s=c[v>>2]|0;if((c[r+112>>2]|0)>(s|0)){c[v>>2]=s+1;o=c[r+104>>2]|0;a[o+(s*20|0)>>0]=45;b[o+(s*20|0)+2>>1]=0;c[o+(s*20|0)+4>>2]=F;c[o+(s*20|0)+8>>2]=0;c[o+(s*20|0)+12>>2]=t;c[o+(s*20|0)+16>>2]=0;a[o+(s*20|0)+1>>0]=0}else s=Bi(r,45,F,0,t)|0;do if(!(a[(c[r>>2]|0)+81>>0]|0)){if((s|0)<0)s=(c[v>>2]|0)+-1|0;t=c[r+104>>2]|0;u=t+(s*20|0)+1|0;if(a[u>>0]|0){Ci(r,t+(s*20|0)|0,p,-4);break}if(p|0){c[t+(s*20|0)+16>>2]=p;a[u>>0]=-4}}while(0);s=c[v>>2]|0;if((s|0)>0)b[(c[r+104>>2]|0)+((s+-1|0)*20|0)+2>>1]=w}while(0);q=c[q+12>>2]|0}while((q|0)!=0)}}x=n&255;if(h|0){y=f+116|0;z=f+23|0;A=f+44|0;w=h;do{do if((a[w+8>>0]|0)==121?(a[w+9>>0]|0)==2:0){q=c[N>>2]|0;k:do if(!q){s=c[f>>2]|0;if((c[y>>2]|0)==0?(b[s+76>>1]&8)==0:0)a[z>>0]=1;l:do if(c[s+272>>2]|0)if(!(a[s+81>>0]|0))M=196;else{q=0;break k}else{do if((e[s+276>>1]|0)>=224){r=s+300|0;q=c[r>>2]|0;if(q|0){c[r>>2]=c[q>>2];h=s+284|0;c[h>>2]=(c[h>>2]|0)+1;break l}r=s+296|0;q=c[r>>2]|0;if(!q){q=s+292|0;break}else{c[r>>2]=c[q>>2];h=s+284|0;c[h>>2]=(c[h>>2]|0)+1;break l}}else q=s+288|0;while(0);c[q>>2]=(c[q>>2]|0)+1;M=196}while(0);if((M|0)==196){M=0;q=Yd(s,224,0)|0}if(!q)q=0;else{v=q+104|0;B=v+120|0;do{c[v>>2]=0;v=v+4|0}while((v|0)<(B|0));c[q>>2]=s;r=s+4|0;s=c[r>>2]|0;if(s|0)c[s+4>>2]=q;c[q+8>>2]=s;c[q+4>>2]=0;c[r>>2]=q;c[q+20>>2]=381479589;c[q+12>>2]=f;c[N>>2]=q;Bi(q,61,0,1,0)|0}}while(0);r=c[y>>2]|0;r=c[((r|0)==0?f:r)+260>>2]|0;m:do if(!r)M=206;else while(1){if((c[r>>2]|0)==(w|0)?(c[r+12>>2]|0)==(x|0):0)break m;r=c[r+4>>2]|0;if(!r){M=206;break}}while(0);if((M|0)==206){M=0;r=Lm(f,w,g,x)|0;if(!r)break}if(!(c[w>>2]|0))v=0;else{v=(c[f>>2]|0)+32|0;v=$v(c[v>>2]|0,c[v+4>>2]|0,13)|0;L()|0;v=v&1^1}s=(c[A>>2]|0)+1|0;c[A>>2]=s;u=c[r+8>>2]|0;p=q+108|0;r=c[p>>2]|0;if((c[q+112>>2]|0)>(r|0)){c[p>>2]=r+1;h=c[q+104>>2]|0;a[h+(r*20|0)>>0]=45;b[h+(r*20|0)+2>>1]=0;c[h+(r*20|0)+4>>2]=F;c[h+(r*20|0)+8>>2]=O;c[h+(r*20|0)+12>>2]=s;c[h+(r*20|0)+16>>2]=0;a[h+(r*20|0)+1>>0]=0}else r=Bi(q,45,F,O,s)|0;do if(!(a[(c[q>>2]|0)+81>>0]|0)){if((r|0)<0)r=(c[p>>2]|0)+-1|0;s=c[q+104>>2]|0;t=s+(r*20|0)+1|0;if(a[t>>0]|0){Ci(q,s+(r*20|0)|0,u,-4);break}if(u|0){c[s+(r*20|0)+16>>2]=u;a[t>>0]=-4}}while(0);r=c[p>>2]|0;if((r|0)>0)b[(c[q+104>>2]|0)+((r+-1|0)*20|0)+2>>1]=v}while(0);w=c[w+32>>2]|0}while((w|0)!=0)}r=c[Q+12>>2]|0;q=0-P|0;if(((c[r+56>>2]|0)+(c[r+60>>2]|0)|0)<0){kk(r,Q,q);return}else{c[(c[r+64>>2]|0)+(q<<2)>>2]=c[Q+108>>2];return}}function Hm(e,f,g,h){e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;t=c[f+20>>2]|0;if((t|0)<=0){v=0;return v|0}q=b[e+42>>1]|0;u=q<<16>>16>0;s=e+4|0;r=e+40|0;n=(h|0)==0;o=q<<16>>16;p=q<<16>>16;q=q<<16>>16;m=0;a:while(1){l=c[f+36+(m<<3)+4>>2]|0;b:do if(u){k=(l|0)==0;if(!n){j=0;while(1){if(!((c[g+(j<<2)>>2]|0)<=-1?(j|0)!=(b[r>>1]|0):0))v=8;do if((v|0)==8){v=0;e=c[s>>2]|0;if(k)if(!(a[e+(j<<4)+15>>0]&1))break;else{e=1;v=28;break a}h=c[e+(j<<4)>>2]|0;i=a[h>>0]|0;e=(d[208+(i&255)>>0]|0)-(d[208+(d[l>>0]|0)>>0]|0)|0;if(!(i<<24>>24==0|(e|0)!=0)){i=l;do{h=h+1|0;i=i+1|0;w=a[h>>0]|0;e=(d[208+(w&255)>>0]|0)-(d[208+(d[i>>0]|0)>>0]|0)|0}while(!(w<<24>>24==0|(e|0)!=0))}if(!e){e=1;v=28;break a}}while(0);j=j+1|0;if((j|0)>=(o|0))break b}}if(k){e=0;while(1){if((c[g+(e<<2)>>2]|0)>-1?a[(c[s>>2]|0)+(e<<4)+15>>0]&1:0){e=1;v=28;break a}e=e+1|0;if((e|0)>=(p|0))break b}}j=0;do{if((c[g+(j<<2)>>2]|0)>-1){h=c[(c[s>>2]|0)+(j<<4)>>2]|0;w=a[h>>0]|0;e=(d[208+(w&255)>>0]|0)-(d[208+(d[l>>0]|0)>>0]|0)|0;if(!(w<<24>>24==0|(e|0)!=0)){i=l;do{h=h+1|0;i=i+1|0;w=a[h>>0]|0;e=(d[208+(w&255)>>0]|0)-(d[208+(d[i>>0]|0)>>0]|0)|0}while(!(w<<24>>24==0|(e|0)!=0))}if(!e){e=1;v=28;break a}}j=j+1|0}while((j|0)<(q|0))}while(0);m=m+1|0;if((m|0)>=(t|0)){e=0;v=28;break}}if((v|0)==28)return e|0;return 0}function Im(e,f){e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;q=Qa;Qa=Qa+16|0;o=q;if(0==0?(c[(c[e>>2]|0)+32>>2]&16384|0)==0:0){p=0;Qa=q;return p|0}g=c[f+16>>2]|0;if(!g)g=0;else{j=g;g=0;do{i=c[j+20>>2]|0;if((i|0)>0){h=0;do{n=c[j+36+(h<<3)>>2]|0;g=((n|0)>31?-1:1<<n)|g;h=h+1|0}while((h|0)<(i|0))}j=c[j+4>>2]|0}while((j|0)!=0)}n=c[f>>2]|0;k=c[f+72>>2]|0;l=c[k+68>>2]|0;if(!l){i=k+60|0;h=k+64|0}else{i=a[n>>0]|0;if(!(i<<24>>24))h=0;else{h=0;j=n;do{j=j+1|0;h=G(h+(d[208+(i&255)>>0]|0)|0,-1640531535)|0;i=a[j>>0]|0}while(i<<24>>24!=0)}h=(h>>>0)%((c[k+56>>2]|0)>>>0)|0;i=l+(h<<3)|0;h=l+(h<<3)+4|0}i=c[i>>2]|0;a:do if(!i)h=59292;else{m=d[208+(d[n>>0]|0)>>0]|0;while(1){h=c[h>>2]|0;i=i+-1|0;k=c[h+12>>2]|0;l=a[k>>0]|0;j=(d[208+(l&255)>>0]|0)-m|0;if(!(l<<24>>24==0|(j|0)!=0)){l=n;do{k=k+1|0;l=l+1|0;r=a[k>>0]|0;j=(d[208+(r&255)>>0]|0)-(d[208+(d[l>>0]|0)>>0]|0)|0}while(!(r<<24>>24==0|(j|0)!=0))}if(!j)break a;if(!i){h=59292;break}}}while(0);h=c[h+8>>2]|0;if(!h){r=g;Qa=q;return r|0}do{c[o>>2]=0;Mm(e,f,h,o,0)|0;i=c[o>>2]|0;if((i|0)!=0?(p=b[i+50>>1]|0,p<<16>>16!=0):0){j=c[i+4>>2]|0;k=p&65535;i=0;do{r=b[j+(i<<1)>>1]|0;g=(r<<16>>16>31?-1:1<<(r<<16>>16))|g;i=i+1|0}while(i>>>0<k>>>0)}h=c[h+12>>2]|0}while((h|0)!=0);Qa=q;return g|0}function Jm(f,g,h,i,j,k){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0;_=Qa;Qa=Qa+16|0;X=_+8|0;Y=_+4|0;S=_;Z=c[f>>2]|0;R=f+146|0;V=a[R>>0]|0;W=Z+32|0;if((c[W>>2]&16384|0)==0&0==0){Qa=_;return}T=g+72|0;p=c[T>>2]|0;m=c[Z+16>>2]|0;if(!p)l=-1e6;else{l=0;while(1)if((c[m+(l<<4)+12>>2]|0)==(p|0))break;else l=l+1|0}Q=c[m+(l<<4)>>2]|0;m=c[g+16>>2]|0;do if(!m)l=g;else{x=(j|0)==0;y=V<<24>>24==0;z=g+40|0;A=(k|0)==0;B=Z+81|0;C=f+8|0;D=f+40|0;E=(h|0)==0;F=Z+312|0;H=f+116|0;I=(i|0)==0;J=h+1|0;K=f+23|0;L=(Z|0)==0;M=Z+480|0;N=Z+304|0;O=Z+308|0;P=Z+300|0;a:while(1){c[X>>2]=0;c[Y>>2]=0;b:do if(!x){p=c[g>>2]|0;n=c[m+8>>2]|0;if(p){if(n|0){U=a[p>>0]|0;o=(d[208+(U&255)>>0]|0)-(d[208+(d[n>>0]|0)>>0]|0)|0;if(U<<24>>24==0|(o|0)!=0)U=16;else{q=n;do{p=p+1|0;q=q+1|0;U=a[p>>0]|0;o=(d[208+(U&255)>>0]|0)-(d[208+(d[q>>0]|0)>>0]|0)|0}while(!(U<<24>>24==0|(o|0)!=0));U=16}}}else{o=((n|0)!=0)<<31>>31;U=16}if((U|0)==16?(U=0,(o|0)==0):0){U=26;break}r=c[m+20>>2]|0;if((r|0)>0){if(A){p=0;while(1){if((c[j+(c[m+36+(p<<3)>>2]<<2)>>2]|0)>-1){U=26;break b}p=p+1|0;if((p|0)>=(r|0))break b}}p=0;do{q=c[m+36+(p<<3)>>2]|0;if((c[j+(q<<2)>>2]|0)>-1){U=26;break b}p=p+1|0;if((q|0)==(b[z>>1]|0)){U=26;break b}}while((p|0)<(r|0))}}else{n=c[m+8>>2]|0;U=26}while(0);c:do if((U|0)==26){U=0;if(!(a[R>>0]|0))w=$c(f,0,n,Q)|0;else w=Qd(Z,n,Q)|0;n=(w|0)==0;if(!n?(Mm(f,w,m,X,Y)|0)==0:0){n=c[Y>>2]|0;if(!n){c[S>>2]=c[m+36>>2];n=S}u=m+20|0;if((c[u>>2]|0)>0){v=w+4|0;r=c[X>>2]|0;s=w+40|0;t=r+4|0;if(!r){q=0;r=0;do{p=n+(r<<2)|0;if((c[p>>2]|0)==(b[z>>1]|0))c[p>>2]=-1;if(c[F>>2]|0)q=(Gk(f,c[w>>2]|0,c[(c[v>>2]|0)+(b[s>>1]<<4)>>2]|0,l)|0)==2&1;r=r+1|0}while((r|0)<(c[u>>2]|0));p=w}else{q=0;r=0;do{p=n+(r<<2)|0;if((c[p>>2]|0)==(b[z>>1]|0))c[p>>2]=-1;if(c[F>>2]|0)q=(Gk(f,c[w>>2]|0,c[(c[v>>2]|0)+(b[(c[t>>2]|0)+(r<<1)>>1]<<4)>>2]|0,l)|0)==2&1;r=r+1|0}while((r|0)<(c[u>>2]|0));p=w}}else{q=0;p=w}Fj(f,l,c[w+28>>2]|0,0,c[p>>2]|0);c[D>>2]=(c[D>>2]|0)+1;if(!E)Nm(f,l,w,c[X>>2]|0,m,n,h,-1,q);do if(!I){p=c[H>>2]|0;p=c[((p|0)==0?f:p)+260>>2]|0;if(p|0){p=c[p>>2]|0;if((p|0)==(c[m+28>>2]|0)?(a[m+25>>0]|0)==8:0)break;if((p|0)==(c[m+32>>2]|0)?(a[m+26>>0]|0)==8:0)break}Nm(f,l,w,c[X>>2]|0,m,n,i,1,q)}while(0);n=c[Y>>2]|0;if(!n)break;do if(!L){if(c[M>>2]|0){Vd(Z,n);break c}p=n;if((c[N>>2]|0)>>>0<=p>>>0){if((c[O>>2]|0)>>>0<=p>>>0)break;c[n>>2]=c[P>>2];c[P>>2]=n;break c}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](n);break}else{w=Ua[c[29352>>2]&127](n)|0;c[14978]=(c[14978]|0)-w;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](n);break}}if(y)break a;if(a[B>>0]|0)break a;if(n){n=c[C>>2]|0;d:do if(!n){r=c[f>>2]|0;if((c[H>>2]|0)==0?(b[r+76>>1]&8)==0:0)a[K>>0]=1;e:do if(c[r+272>>2]|0)if(!(a[r+81>>0]|0))U=48;else{n=0;break d}else{do if((e[r+276>>1]|0)>=224){p=r+300|0;n=c[p>>2]|0;if(n|0){c[p>>2]=c[n>>2];w=r+284|0;c[w>>2]=(c[w>>2]|0)+1;break e}p=r+296|0;n=c[p>>2]|0;if(!n){n=r+292|0;break}else{c[p>>2]=c[n>>2];w=r+284|0;c[w>>2]=(c[w>>2]|0)+1;break e}}else n=r+288|0;while(0);c[n>>2]=(c[n>>2]|0)+1;U=48}while(0);if((U|0)==48){U=0;n=Yd(r,224,0)|0}if(!n)n=0;else{p=n+104|0;q=p+120|0;do{c[p>>2]=0;p=p+4|0}while((p|0)<(q|0));c[n>>2]=r;p=r+4|0;q=c[p>>2]|0;if(q|0)c[q+4>>2]=n;c[n+8>>2]=q;c[n+4>>2]=0;c[p>>2]=n;c[n+20>>2]=381479589;c[n+12>>2]=f;c[C>>2]=n;Bi(n,61,0,1,0)|0}}while(0);v=n+108|0;q=c[v>>2]|0;s=m+20|0;u=c[s>>2]|0;t=q+1+u|0;w=n+112|0;if((u|0)>0){u=n+104|0;r=0;do{p=J+(c[m+36+(r<<3)>>2]|0)|0;if((c[w>>2]|0)>(q|0)){c[v>>2]=q+1;$=c[u>>2]|0;a[$+(q*20|0)>>0]=50;b[$+(q*20|0)+2>>1]=0;c[$+(q*20|0)+4>>2]=p;c[$+(q*20|0)+8>>2]=t;c[$+(q*20|0)+12>>2]=0;c[$+(q*20|0)+16>>2]=0;a[$+(q*20|0)+1>>0]=0}else Bi(n,50,p,t,0)|0;r=r+1|0;q=c[v>>2]|0}while((r|0)<(c[s>>2]|0))}p=d[m+24>>0]|0;if((c[w>>2]|0)>(q|0)){c[v>>2]=q+1;$=c[n+104>>2]|0;a[$+(q*20|0)>>0]=-106;b[$+(q*20|0)+2>>1]=0;c[$+(q*20|0)+4>>2]=p;c[$+(q*20|0)+8>>2]=-1;c[$+(q*20|0)+12>>2]=0;c[$+(q*20|0)+16>>2]=0;a[$+(q*20|0)+1>>0]=0;break}else{Bi(n,150,p,-1,0)|0;break}}}while(0);m=c[m+4>>2]|0;if(!m){U=100;break}}if((U|0)==100){l=g;p=c[T>>2]|0;break}Qa=_;return}while(0);r=c[l>>2]|0;o=c[p+68>>2]|0;if(!o){m=p+60|0;l=p+64|0}else{m=a[r>>0]|0;if(!(m<<24>>24))l=0;else{l=0;n=r;do{n=n+1|0;l=G(l+(d[208+(m&255)>>0]|0)|0,-1640531535)|0;m=a[n>>0]|0}while(m<<24>>24!=0)}l=(l>>>0)%((c[p+56>>2]|0)>>>0)|0;m=o+(l<<3)|0;l=o+(l<<3)+4|0}m=c[m>>2]|0;f:do if(!m)l=59292;else{q=d[208+(d[r>>0]|0)>>0]|0;while(1){l=c[l>>2]|0;m=m+-1|0;o=c[l+12>>2]|0;$=a[o>>0]|0;n=(d[208+($&255)>>0]|0)-q|0;if(!($<<24>>24==0|(n|0)!=0)){p=r;do{o=o+1|0;p=p+1|0;$=a[o>>0]|0;n=(d[208+($&255)>>0]|0)-(d[208+(d[p>>0]|0)>>0]|0)|0}while(!($<<24>>24==0|(n|0)!=0))}if(!n)break f;if(!m){l=59292;break}}}while(0);l=c[l+8>>2]|0;if(!l){Qa=_;return}B=(j|0)!=0;C=f+116|0;p=V<<24>>24==0;q=f+20|0;r=f+40|0;s=(i|0)==0;t=Z+81|0;u=(Z|0)==0;v=(h|0)==0;w=Z+480|0;x=B&1;y=Z+304|0;z=Z+308|0;A=Z+300|0;g:while(1){c[X>>2]=0;c[Y>>2]=0;if(B?(Hm(g,l,j,k)|0)==0:0)U=142;else U=118;do if((U|0)==118){U=0;o=l+24|0;if((((a[o>>0]|0)==0?(c[W>>2]&524288|0)==0&0==0:0)?(c[C>>2]|0)==0:0)?(a[q>>0]|0)==0:0){U=142;break}if(Mm(f,g,l,X,Y)|0){if(p){U=124;break g}if(!(a[t>>0]|0))break;else{U=145;break g}}m=nj(f,0,0,0)|0;if(m|0){$=c[l>>2]|0;c[m+24>>2]=$;n=m+16|0;c[n>>2]=c[$>>2];$=$+32|0;c[$>>2]=(c[$>>2]|0)+1;$=c[r>>2]|0;c[r>>2]=$+1;c[m+48>>2]=$;if(!s)Om(f,m,g,c[X>>2]|0,l,c[Y>>2]|0,i,-1);if(!v?($=a[l+25+x>>0]|0,Om(f,m,g,c[X>>2]|0,l,c[Y>>2]|0,h,1),($|2)<<24>>24!=10&(a[o>>0]|0)==0):0){$=c[C>>2]|0;a[(($|0)==0?f:$)+21>>0]=1}c[n>>2]=0;oi(Z,m)}m=c[Y>>2]|0;if(m){if(!u){if(c[w>>2]|0){Vd(Z,m);U=142;break}$=m;if((c[y>>2]|0)>>>0<=$>>>0?(c[z>>2]|0)>>>0>$>>>0:0){c[m>>2]=c[A>>2];c[A>>2]=m;U=142;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](m);U=142;break}else{U=Ua[c[29352>>2]&127](m)|0;c[14978]=(c[14978]|0)-U;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](m);U=142;break}}else U=142}while(0);l=c[l+12>>2]|0;if(!l){U=145;break}}if((U|0)==124){Qa=_;return}else if((U|0)==145){Qa=_;return}}function Km(f,g,h,i,j,k){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;z=Qa;Qa=Qa+16|0;w=z;x=f+8|0;y=c[x>>2]|0;n=c[g+8>>2]|0;a:do if(!(c[g+36>>2]&32))g=0;else{if(!n){Qa=z;return}g=n;while(1){v=g+55|0;if(((d[v>>0]|d[v+1>>0]<<8)&3)==2)break a;g=c[g+20>>2]|0;if(!g){g=0;break}}}while(0);if(!n){Qa=z;return}t=y+108|0;u=y+112|0;v=y+104|0;if(!j){l=-1;m=0;p=n;q=0;while(1){do if((p|0)!=(g|0)?(r=q+i|0,(r|0)!=(k|0)):0){l=cl(f,p,h,0,1,w,m,l)|0;m=p+55|0;m=e[(((d[m>>0]|d[m+1>>0]<<8)&8)==0?p+52|0:p+50|0)>>1]|0;n=c[t>>2]|0;if((c[u>>2]|0)>(n|0)){c[t>>2]=n+1;s=c[v>>2]|0;a[s+(n*20|0)>>0]=-123;b[s+(n*20|0)+2>>1]=0;c[s+(n*20|0)+4>>2]=r;c[s+(n*20|0)+8>>2]=l;c[s+(n*20|0)+12>>2]=m;c[s+(n*20|0)+16>>2]=0;a[s+(n*20|0)+1>>0]=0}else Bi(y,133,r,l,m)|0;m=c[w>>2]|0;if(m){n=c[x>>2]|0;o=c[n+12>>2]|0;m=~m;if(((c[o+56>>2]|0)+(c[o+60>>2]|0)|0)<0){kk(o,n,m);m=p;break}else{c[(c[o+64>>2]|0)+(m<<2)>>2]=c[n+108>>2];m=p;break}}else m=p}while(0);p=c[p+20>>2]|0;if(!p)break;else q=q+1|0}Qa=z;return}else{l=-1;m=0;p=n;q=0;while(1){do if(!((p|0)==(g|0)?1:(c[j+(q<<2)>>2]|0)==0)?(s=q+i|0,(s|0)!=(k|0)):0){l=cl(f,p,h,0,1,w,m,l)|0;m=p+55|0;m=e[(((d[m>>0]|d[m+1>>0]<<8)&8)==0?p+52|0:p+50|0)>>1]|0;n=c[t>>2]|0;if((c[u>>2]|0)>(n|0)){c[t>>2]=n+1;r=c[v>>2]|0;a[r+(n*20|0)>>0]=-123;b[r+(n*20|0)+2>>1]=0;c[r+(n*20|0)+4>>2]=s;c[r+(n*20|0)+8>>2]=l;c[r+(n*20|0)+12>>2]=m;c[r+(n*20|0)+16>>2]=0;a[r+(n*20|0)+1>>0]=0}else Bi(y,133,s,l,m)|0;m=c[w>>2]|0;if(m){n=c[x>>2]|0;o=c[n+12>>2]|0;m=~m;if(((c[o+56>>2]|0)+(c[o+60>>2]|0)|0)<0){kk(o,n,m);m=p;break}else{c[(c[o+64>>2]|0)+(m<<2)>>2]=c[n+108>>2];m=p;break}}else m=p}while(0);p=c[p+20>>2]|0;if(!p)break;else q=q+1|0}Qa=z;return}}function Lm(f,g,h,i){f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0;$=Qa;Qa=Qa+96|0;X=$+16|0;q=$+8|0;p=$;W=$+56|0;r=$+24|0;Y=c[f+116>>2]|0;Y=(Y|0)==0?f:Y;_=c[f>>2]|0;m=(_|0)==0;a:do if(m){if(!(c[7324]|0)){j=Ua[c[29340>>2]&127](24)|0;P=24;break}j=Ua[c[29356>>2]&127](24)|0;if((c[14985]|0)>>>0<24)c[14985]=24;l=59064;k=c[l>>2]|0;l=c[l+4>>2]|0;if((l|0)>0|(l|0)==0&k>>>0>0){Z=c[14978]|0;U=Rv(k|0,l|0,j|0,((j|0)<0)<<31>>31|0)|0;T=L()|0;c[14768]=((T|0)<0|(T|0)==0&U>>>0<=Z>>>0)&1}k=Ua[c[29340>>2]&127](j)|0;if(!k){_=0;Qa=$;return _|0}j=Ua[c[29352>>2]&127](k)|0;j=(c[14978]|0)+j|0;c[14978]=j;if(j>>>0>(c[14982]|0)>>>0)c[14982]=j;j=(c[14981]|0)+1|0;c[14981]=j;if(j>>>0>(c[14987]|0)>>>0){c[14987]=j;Z=k}else Z=k}else{if(c[_+272>>2]|0){if(a[_+81>>0]|0){_=0;Qa=$;return _|0}}else{do if((e[_+276>>1]|0)>=24){k=_+300|0;j=c[k>>2]|0;if(j|0){c[k>>2]=c[j>>2];P=_+284|0;c[P>>2]=(c[P>>2]|0)+1;P=24;break a}k=_+296|0;j=c[k>>2]|0;if(!j){j=_+292|0;break}else{c[k>>2]=c[j>>2];P=_+284|0;c[P>>2]=(c[P>>2]|0)+1;P=24;break a}}else j=_+288|0;while(0);c[j>>2]=(c[j>>2]|0)+1}j=Yd(_,24,0)|0;P=24}while(0);if((P|0)==24)if(!j){_=0;Qa=$;return _|0}else Z=j;l=Z;n=l+24|0;do{a[l>>0]=0;l=l+1|0}while((l|0)<(n|0));U=Y+260|0;c[Z+4>>2]=c[U>>2];c[U>>2]=Z;b:do if(m){if(!(c[7324]|0)){j=Ua[c[29340>>2]&127](28)|0;P=48;break}j=Ua[c[29356>>2]&127](28)|0;if((c[14985]|0)>>>0<28)c[14985]=28;l=59064;k=c[l>>2]|0;l=c[l+4>>2]|0;if((l|0)>0|(l|0)==0&k>>>0>0){U=c[14978]|0;T=Rv(k|0,l|0,j|0,((j|0)<0)<<31>>31|0)|0;S=L()|0;c[14768]=((S|0)<0|(S|0)==0&T>>>0<=U>>>0)&1}k=Ua[c[29340>>2]&127](j)|0;if(k){j=Ua[c[29352>>2]&127](k)|0;j=(c[14978]|0)+j|0;c[14978]=j;if(j>>>0>(c[14982]|0)>>>0)c[14982]=j;j=(c[14981]|0)+1|0;c[14981]=j;if(j>>>0>(c[14987]|0)>>>0){c[14987]=j;Q=k}else Q=k}else P=49}else{if(c[_+272>>2]|0){if(a[_+81>>0]|0){P=49;break}}else{do if((e[_+276>>1]|0)>=28){k=_+300|0;j=c[k>>2]|0;if(j|0){c[k>>2]=c[j>>2];P=_+284|0;c[P>>2]=(c[P>>2]|0)+1;P=48;break b}k=_+296|0;j=c[k>>2]|0;if(!j){j=_+292|0;break}else{c[k>>2]=c[j>>2];P=_+284|0;c[P>>2]=(c[P>>2]|0)+1;P=48;break b}}else j=_+288|0;while(0);c[j>>2]=(c[j>>2]|0)+1}j=Yd(_,28,0)|0;P=48}while(0);if((P|0)==48)if(!j)P=49;else Q=j;if((P|0)==49){c[Z+8>>2]=0;_=0;Qa=$;return _|0}l=Q;n=l+24|0;do{a[l>>0]=0;l=l+1|0}while((l|0)<(n|0));c[Z+8>>2]=Q;R=(c[Y+8>>2]|0)+212|0;c[Q+24>>2]=c[R>>2];c[R>>2]=Q;c[Z>>2]=g;c[Z+12>>2]=i;R=Z+16|0;c[R>>2]=-1;S=Z+20|0;c[S>>2]=-1;c:do if(m){if(!(c[7324]|0)){j=Ua[c[29340>>2]&127](276)|0;P=73;break}j=Ua[c[29356>>2]&127](276)|0;if((c[14985]|0)>>>0<276)c[14985]=276;l=59064;k=c[l>>2]|0;l=c[l+4>>2]|0;if((l|0)>0|(l|0)==0&k>>>0>0){U=c[14978]|0;T=Rv(k|0,l|0,j|0,((j|0)<0)<<31>>31|0)|0;O=L()|0;c[14768]=((O|0)<0|(O|0)==0&T>>>0<=U>>>0)&1}k=Ua[c[29340>>2]&127](j)|0;if(!k){_=0;Qa=$;return _|0}j=Ua[c[29352>>2]&127](k)|0;j=(c[14978]|0)+j|0;c[14978]=j;if(j>>>0>(c[14982]|0)>>>0)c[14982]=j;j=(c[14981]|0)+1|0;c[14981]=j;if(j>>>0>(c[14987]|0)>>>0){c[14987]=j;U=k}else U=k}else{if(c[_+272>>2]|0){if(a[_+81>>0]|0){_=0;Qa=$;return _|0}}else{do if((e[_+276>>1]|0)>=276){k=_+300|0;j=c[k>>2]|0;if(j|0){c[k>>2]=c[j>>2];P=_+284|0;c[P>>2]=(c[P>>2]|0)+1;P=73;break c}k=_+296|0;j=c[k>>2]|0;if(!j){j=_+292|0;break}else{c[k>>2]=c[j>>2];P=_+284|0;c[P>>2]=(c[P>>2]|0)+1;P=73;break c}}else j=_+288|0;while(0);c[j>>2]=(c[j>>2]|0)+1}j=Yd(_,276,0)|0;P=73}while(0);if((P|0)==73)if(!j){_=0;Qa=$;return _|0}else U=j;O=U+4|0;ew(O|0,0,272)|0;k=r+4|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;c[k+24>>2]=0;c[r>>2]=U;c[U>>2]=_;c[U+120>>2]=h;c[U+116>>2]=Y;k=c[g>>2]|0;c[U+240>>2]=k;a[U+144>>0]=a[g+8>>0]|0;c[U+132>>2]=c[f+132>>2];a[U+25>>0]=a[f+25>>0]|0;o=U+8|0;j=c[o>>2]|0;T=U;d:do if(!j){e:do if(c[_+272>>2]|0)if(!(a[_+81>>0]|0))P=86;else k=_;else{do if((e[_+276>>1]|0)>=224){j=_+300|0;k=c[j>>2]|0;if(k|0){c[j>>2]=c[k>>2];P=_+284|0;c[P>>2]=(c[P>>2]|0)+1;P=87;break e}j=_+296|0;k=c[j>>2]|0;if(!k){j=_+292|0;break}else{c[j>>2]=c[k>>2];P=_+284|0;c[P>>2]=(c[P>>2]|0)+1;P=87;break e}}else j=_+288|0;while(0);c[j>>2]=(c[j>>2]|0)+1;P=86}while(0);if((P|0)==86){k=Yd(_,224,0)|0;P=87}do if((P|0)==87){if(k|0){l=k+104|0;n=l+120|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(n|0));c[k>>2]=_;j=_+4|0;l=c[j>>2]|0;if(l|0)c[l+4>>2]=k;c[k+8>>2]=l;c[k+4>>2]=0;c[j>>2]=k;c[k+20>>2]=381479589;c[k+12>>2]=U;c[o>>2]=k;Bi(k,61,0,1,0)|0;N=k;j=c[g>>2]|0;P=91;break d}j=c[U>>2]|0;k=c[U+64>>2]|0;if(k){if(j|0){if(c[j+480>>2]|0){Vd(j,k);k=j;break}Y=k;if((c[j+304>>2]|0)>>>0<=Y>>>0?(c[j+308>>2]|0)>>>0>Y>>>0:0){Y=j+300|0;c[k>>2]=c[Y>>2];c[Y>>2]=k;k=j;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](k);k=j;break}else{Y=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-Y;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);k=j;break}}else k=j}while(0);j=c[U+68>>2]|0;if(j|0)pi(k,j);j=U+24|0;if(k){Y=k+272|0;c[Y>>2]=(c[Y>>2]|0)-(d[j>>0]|0)}}else{N=j;j=k;P=91}while(0);if((P|0)==91){do if(j|0){c[p>>2]=j;m=bd(_,44694,p)|0;j=c[N>>2]|0;if(!(a[j+81>>0]|0)){j=(c[N+108>>2]|0)+-1|0;k=c[N+104>>2]|0;l=k+(j*20|0)+1|0;if(a[l>>0]|0){Ci(N,k+(j*20|0)|0,m,-7);break}if(!m)break;c[k+(j*20|0)+16>>2]=m;a[l>>0]=-7;break}if(m|0){if(j|0){if(c[j+480>>2]|0){Vd(j,m);break}M=m;if((c[j+304>>2]|0)>>>0<=M>>>0?(c[j+308>>2]|0)>>>0>M>>>0:0){M=j+300|0;c[m>>2]=c[M>>2];c[M>>2]=m;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](m);break}else{M=Ua[c[29352>>2]&127](m)|0;c[14978]=(c[14978]|0)-M;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](m);break}}}while(0);j=c[g+12>>2]|0;do if(!j)j=0;else{h=bk(_,j,0,0)|0;n=(h|0)==0;do if(n)P=115;else{k=r+24|0;l=e[k>>1]|0;b[k>>1]=l&28655;c[W>>2]=T;c[W+4>>2]=125;c[W+8>>2]=126;c[W+12>>2]=0;c[W+24>>2]=r;m=h+24|0;j=U+208|0;M=(c[j>>2]|0)+(c[m>>2]|0)|0;c[j>>2]=M;j=c[(c[U>>2]|0)+120>>2]|0;if((j|0)>=(M|0)){Yj(W,h)|0;j=c[W>>2]|0;M=j+208|0;c[M>>2]=(c[M>>2]|0)-(c[m>>2]|0);M=b[k>>1]|0;K=h+4|0;c[K>>2]=c[K>>2]|M&-32752&65535;b[k>>1]=l&36880|M&65535;if((c[r+20>>2]|0)<=0)if((c[j+36>>2]|0)<1){P=115;break}else{j=0;break}}else{c[q>>2]=j;ad(U,41637,q)}j=0}while(0);if((P|0)==115){if(!(a[_+81>>0]|0)){M=U+56|0;j=(c[M>>2]|0)+-1|0;c[M>>2]=j;Rj(U,h,j,16)}else j=0;if(n)break}li(_,h)}while(0);I=c[o>>2]|0;J=c[U>>2]|0;k=c[g+28>>2]|0;f:do if(k|0){K=(i|0)==11;M=U+145|0;u=i&255;v=I+108|0;w=I+112|0;x=W+4|0;y=I+104|0;z=(J|0)==0;A=J+272|0;B=J+276|0;C=J+81|0;D=J+288|0;E=J+300|0;F=J+296|0;G=J+284|0;H=J+292|0;while(1){if(K)l=d[k+1>>0]|0;else l=u;a[M>>0]=l;l=c[k+32>>2]|0;g:do if(l|0){c[X>>2]=l;h=bd(J,34793,X)|0;l=c[v>>2]|0;if((c[w>>2]|0)>(l|0)){c[v>>2]=l+1;t=c[y>>2]|0;a[t+(l*20|0)>>0]=-88;b[t+(l*20|0)+2>>1]=0;c[t+(l*20|0)+4>>2]=2147483647;c[t+(l*20|0)+8>>2]=1;c[t+(l*20|0)+12>>2]=0;c[t+(l*20|0)+16>>2]=0;a[t+(l*20|0)+1>>0]=0}else l=Bi(I,168,2147483647,1,0)|0;m=c[I>>2]|0;if(!(a[m+81>>0]|0)){if((l|0)<0)l=(c[v>>2]|0)+-1|0;m=c[y>>2]|0;n=m+(l*20|0)+1|0;if(a[n>>0]|0){Ci(I,m+(l*20|0)|0,h,-7);break}if(!h)break;c[m+(l*20|0)+16>>2]=h;a[n>>0]=-7;break}if(h|0){do if(m|0){if(c[m+480>>2]|0){Vd(m,h);break g}l=h;if((c[m+304>>2]|0)>>>0<=l>>>0){if((c[m+308>>2]|0)>>>0<=l>>>0)break;t=m+300|0;c[h>>2]=c[t>>2];c[t>>2]=h;break g}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](h);break}else{t=Ua[c[29352>>2]&127](h)|0;c[14978]=(c[14978]|0)-t;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](h);break}}}while(0);switch(a[k>>0]|0){case 122:{p=c[U>>2]|0;q=nj(U,0,0,0)|0;if(q|0){h=c[k+12>>2]|0;h:do if(!h)l=0;else{o=(Cu(h)|0)+1|0;i:do if(!p){t=Qv(o|0,0,-1,-1)|0;s=L()|0;if(s>>>0>0|(s|0)==0&t>>>0>2147483390){l=0;break h}if(!(c[7324]|0)){l=Ua[c[29340>>2]&127](o)|0;P=171;break}l=Ua[c[29356>>2]&127](o)|0;if((c[14985]|0)>>>0<o>>>0)c[14985]=o;n=59064;m=c[n>>2]|0;n=c[n+4>>2]|0;if((n|0)>0|(n|0)==0&m>>>0>0){t=c[14978]|0;s=Rv(m|0,n|0,l|0,((l|0)<0)<<31>>31|0)|0;i=L()|0;c[14768]=((i|0)<0|(i|0)==0&s>>>0<=t>>>0)&1}l=Ua[c[29340>>2]&127](l)|0;if(!l){l=0;break h}m=Ua[c[29352>>2]&127](l)|0;m=(c[14978]|0)+m|0;c[14978]=m;if(m>>>0>(c[14982]|0)>>>0)c[14982]=m;m=(c[14981]|0)+1|0;c[14981]=m;if(m>>>0<=(c[14987]|0)>>>0)break;c[14987]=m}else{if(c[p+272>>2]|0){if(a[p+81>>0]|0){l=0;break h}}else{do if(!(0<0|(0==0?(e[p+276>>1]|0)>>>0<o>>>0:0))){m=p+300|0;l=c[m>>2]|0;if(l|0){c[m>>2]=c[l>>2];P=p+284|0;c[P>>2]=(c[P>>2]|0)+1;P=171;break i}m=p+296|0;l=c[m>>2]|0;if(!l){l=p+292|0;break}else{c[m>>2]=c[l>>2];P=p+284|0;c[P>>2]=(c[P>>2]|0)+1;P=171;break i}}else l=p+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1}l=Yd(p,o,0)|0;P=171}while(0);if((P|0)==171){P=0;if(!l){l=0;break}}cw(l|0,h|0,o|0)|0}while(0);c[q+8+(((c[q>>2]|0)+-1|0)*72|0)+8>>2]=l;m=c[(c[k+4>>2]|0)+20>>2]|0;if(!m)l=-1e6;else{n=c[p+16>>2]|0;l=0;while(1)if((c[n+(l<<4)+12>>2]|0)==(m|0))break;else l=l+1|0}if((l|0)==0|(l|0)>1){n=c[(c[p+16>>2]|0)+(l<<4)>>2]|0;j:do if(!n)l=0;else{h=(Cu(n)|0)+1|0;k:do if(c[p+272>>2]|0)if(!(a[p+81>>0]|0))P=188;else{l=0;break j}else{do if(!(0<0|(0==0?(e[p+276>>1]|0)>>>0<h>>>0:0))){m=p+300|0;l=c[m>>2]|0;if(l|0){c[m>>2]=c[l>>2];t=p+284|0;c[t>>2]=(c[t>>2]|0)+1;break k}m=p+296|0;l=c[m>>2]|0;if(!l){l=p+292|0;break}else{c[m>>2]=c[l>>2];t=p+284|0;c[t>>2]=(c[t>>2]|0)+1;break k}}else l=p+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1;P=188}while(0);if((P|0)==188){P=0;l=Yd(p,h,0)|0}if(!l){l=0;break}cw(l|0,n|0,h|0)|0}while(0);c[q+8+(((c[q>>2]|0)+-1|0)*72|0)+4>>2]=l}}m=ek(J,c[k+20>>2]|0,0)|0;l=c[k+16>>2]|0;if(!l)l=0;else l=bk(J,l,0,0)|0;rj(U,q,m,l,d[M>>0]|0,0);break}case 120:{p=c[U>>2]|0;t=nj(U,0,0,0)|0;if(t|0){h=c[k+12>>2]|0;l:do if(!h)l=0;else{o=(Cu(h)|0)+1|0;m:do if(!p){s=Qv(o|0,0,-1,-1)|0;i=L()|0;if(i>>>0>0|(i|0)==0&s>>>0>2147483390){l=0;break l}if(!(c[7324]|0)){l=Ua[c[29340>>2]&127](o)|0;P=221;break}l=Ua[c[29356>>2]&127](o)|0;if((c[14985]|0)>>>0<o>>>0)c[14985]=o;n=59064;m=c[n>>2]|0;n=c[n+4>>2]|0;if((n|0)>0|(n|0)==0&m>>>0>0){s=c[14978]|0;i=Rv(m|0,n|0,l|0,((l|0)<0)<<31>>31|0)|0;r=L()|0;c[14768]=((r|0)<0|(r|0)==0&i>>>0<=s>>>0)&1}l=Ua[c[29340>>2]&127](l)|0;if(!l){l=0;break l}m=Ua[c[29352>>2]&127](l)|0;m=(c[14978]|0)+m|0;c[14978]=m;if(m>>>0>(c[14982]|0)>>>0)c[14982]=m;m=(c[14981]|0)+1|0;c[14981]=m;if(m>>>0<=(c[14987]|0)>>>0)break;c[14987]=m}else{if(c[p+272>>2]|0){if(a[p+81>>0]|0){l=0;break l}}else{do if(!(0<0|(0==0?(e[p+276>>1]|0)>>>0<o>>>0:0))){m=p+300|0;l=c[m>>2]|0;if(l|0){c[m>>2]=c[l>>2];P=p+284|0;c[P>>2]=(c[P>>2]|0)+1;P=221;break m}m=p+296|0;l=c[m>>2]|0;if(!l){l=p+292|0;break}else{c[m>>2]=c[l>>2];P=p+284|0;c[P>>2]=(c[P>>2]|0)+1;P=221;break m}}else l=p+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1}l=Yd(p,o,0)|0;P=221}while(0);if((P|0)==221){P=0;if(!l){l=0;break}}cw(l|0,h|0,o|0)|0}while(0);c[t+8+(((c[t>>2]|0)+-1|0)*72|0)+8>>2]=l;m=c[(c[k+4>>2]|0)+20>>2]|0;if(!m)l=-1e6;else{n=c[p+16>>2]|0;l=0;while(1)if((c[n+(l<<4)+12>>2]|0)==(m|0))break;else l=l+1|0}if((l|0)==0|(l|0)>1){n=c[(c[p+16>>2]|0)+(l<<4)>>2]|0;n:do if(!n)l=0;else{h=(Cu(n)|0)+1|0;o:do if(c[p+272>>2]|0)if(!(a[p+81>>0]|0))P=238;else{l=0;break n}else{do if(!(0<0|(0==0?(e[p+276>>1]|0)>>>0<h>>>0:0))){m=p+300|0;l=c[m>>2]|0;if(l|0){c[m>>2]=c[l>>2];s=p+284|0;c[s>>2]=(c[s>>2]|0)+1;break o}m=p+296|0;l=c[m>>2]|0;if(!l){l=p+292|0;break}else{c[m>>2]=c[l>>2];s=p+284|0;c[s>>2]=(c[s>>2]|0)+1;break o}}else l=p+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1;P=238}while(0);if((P|0)==238){P=0;l=Yd(p,h,0)|0}if(!l){l=0;break}cw(l|0,n|0,h|0)|0}while(0);c[t+8+(((c[t>>2]|0)+-1|0)*72|0)+4>>2]=l}}r=dk(J,c[k+8>>2]|0,0)|0;i=hk(J,c[k+24>>2]|0)|0;s=d[M>>0]|0;m=c[k+28>>2]|0;do if(!m)l=0;else{q=ek(J,c[m>>2]|0,0)|0;l=c[m+4>>2]|0;if(!l)p=0;else p=bk(J,l,0,0)|0;o=ek(J,c[m+8>>2]|0,0)|0;l=c[m+12>>2]|0;if(!l)h=0;else h=bk(J,l,0,0)|0;p:do if(z){if(!(c[7324]|0)){V=Ua[c[29340>>2]&127](36)|0;P=268;break}l=Ua[c[29356>>2]&127](36)|0;if((c[14985]|0)>>>0<36)c[14985]=36;n=59064;m=c[n>>2]|0;n=c[n+4>>2]|0;if((n|0)>0|(n|0)==0&m>>>0>0){aa=c[14978]|0;n=Rv(m|0,n|0,l|0,((l|0)<0)<<31>>31|0)|0;m=L()|0;c[14768]=((m|0)<0|(m|0)==0&n>>>0<=aa>>>0)&1}l=Ua[c[29340>>2]&127](l)|0;if(!l)break;m=Ua[c[29352>>2]&127](l)|0;m=(c[14978]|0)+m|0;c[14978]=m;if(m>>>0>(c[14982]|0)>>>0)c[14982]=m;m=(c[14981]|0)+1|0;c[14981]=m;if(m>>>0<=(c[14987]|0)>>>0){P=277;break}c[14987]=m;P=277}else{if(c[A>>2]|0){if(a[C>>0]|0)break}else{do if((e[B>>1]|0)<36)l=D;else{l=c[E>>2]|0;if(l|0){c[E>>2]=c[l>>2];c[G>>2]=(c[G>>2]|0)+1;V=l;P=268;break p}l=c[F>>2]|0;if(!l){l=H;break}c[F>>2]=c[l>>2];c[G>>2]=(c[G>>2]|0)+1;V=l;P=268;break p}while(0);c[l>>2]=(c[l>>2]|0)+1}V=Yd(J,36,0)|0;P=268}while(0);if((P|0)==268?(P=0,V|0):0){l=V;P=277}if((P|0)==277){P=0;c[l>>2]=q;c[l+4>>2]=p;c[l+8>>2]=o;c[l+12>>2]=h;c[l+16>>2]=0;break}if(q|0)pi(J,q);if(p|0)li(J,p);if(o|0)pi(J,o);if(!h){l=0;break}li(J,h);l=0}while(0);tj(U,t,r,i,s,l);break}case 121:{p=c[U>>2]|0;q=nj(U,0,0,0)|0;if(q|0){h=c[k+12>>2]|0;q:do if(!h)l=0;else{o=(Cu(h)|0)+1|0;r:do if(!p){aa=Qv(o|0,0,-1,-1)|0;t=L()|0;if(t>>>0>0|(t|0)==0&aa>>>0>2147483390){l=0;break q}if(!(c[7324]|0)){l=Ua[c[29340>>2]&127](o)|0;P=305;break}l=Ua[c[29356>>2]&127](o)|0;if((c[14985]|0)>>>0<o>>>0)c[14985]=o;n=59064;m=c[n>>2]|0;n=c[n+4>>2]|0;if((n|0)>0|(n|0)==0&m>>>0>0){aa=c[14978]|0;t=Rv(m|0,n|0,l|0,((l|0)<0)<<31>>31|0)|0;s=L()|0;c[14768]=((s|0)<0|(s|0)==0&t>>>0<=aa>>>0)&1}l=Ua[c[29340>>2]&127](l)|0;if(!l){l=0;break q}m=Ua[c[29352>>2]&127](l)|0;m=(c[14978]|0)+m|0;c[14978]=m;if(m>>>0>(c[14982]|0)>>>0)c[14982]=m;m=(c[14981]|0)+1|0;c[14981]=m;if(m>>>0<=(c[14987]|0)>>>0)break;c[14987]=m}else{if(c[p+272>>2]|0){if(a[p+81>>0]|0){l=0;break q}}else{do if(!(0<0|(0==0?(e[p+276>>1]|0)>>>0<o>>>0:0))){m=p+300|0;l=c[m>>2]|0;if(l|0){c[m>>2]=c[l>>2];P=p+284|0;c[P>>2]=(c[P>>2]|0)+1;P=305;break r}m=p+296|0;l=c[m>>2]|0;if(!l){l=p+292|0;break}else{c[m>>2]=c[l>>2];P=p+284|0;c[P>>2]=(c[P>>2]|0)+1;P=305;break r}}else l=p+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1}l=Yd(p,o,0)|0;P=305}while(0);if((P|0)==305){P=0;if(!l){l=0;break}}cw(l|0,h|0,o|0)|0}while(0);c[q+8+(((c[q>>2]|0)+-1|0)*72|0)+8>>2]=l;m=c[(c[k+4>>2]|0)+20>>2]|0;if(!m)l=-1e6;else{n=c[p+16>>2]|0;l=0;while(1)if((c[n+(l<<4)+12>>2]|0)==(m|0))break;else l=l+1|0}if((l|0)==0|(l|0)>1){n=c[(c[p+16>>2]|0)+(l<<4)>>2]|0;s:do if(!n)l=0;else{h=(Cu(n)|0)+1|0;t:do if(c[p+272>>2]|0)if(!(a[p+81>>0]|0))P=322;else{l=0;break s}else{do if(!(0<0|(0==0?(e[p+276>>1]|0)>>>0<h>>>0:0))){m=p+300|0;l=c[m>>2]|0;if(l|0){c[m>>2]=c[l>>2];aa=p+284|0;c[aa>>2]=(c[aa>>2]|0)+1;break t}m=p+296|0;l=c[m>>2]|0;if(!l){l=p+292|0;break}else{c[m>>2]=c[l>>2];aa=p+284|0;c[aa>>2]=(c[aa>>2]|0)+1;break t}}else l=p+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1;P=322}while(0);if((P|0)==322){P=0;l=Yd(p,h,0)|0}if(!l){l=0;break}cw(l|0,n|0,h|0)|0}while(0);c[q+8+(((c[q>>2]|0)+-1|0)*72|0)+4>>2]=l}}l=c[k+16>>2]|0;if(!l)l=0;else l=bk(J,l,0,0)|0;qj(U,q,l);break}default:{l=dk(J,c[k+8>>2]|0,0)|0;a[W>>0]=4;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;c[x+12>>2]=0;ij(U,l,W)|0;if(l|0)ni(J,l,1)}}do if((a[k>>0]|0)!=-125){l=c[v>>2]|0;if((c[w>>2]|0)>(l|0)){c[v>>2]=l+1;n=c[y>>2]|0;a[n+(l*20|0)>>0]=124;l=n+(l*20|0)+1|0;n=l+19|0;do{a[l>>0]=0;l=l+1|0}while((l|0)<(n|0));break}else{Bi(I,124,0,0,0)|0;break}}while(0);k=c[k+36>>2]|0;if(!k)break f}}while(0);do if(j|0){k=c[N+12>>2]|0;j=~j;if(((c[k+56>>2]|0)+(c[k+60>>2]|0)|0)<0){kk(k,N,j);break}else{c[(c[k+64>>2]|0)+(j<<2)>>2]=c[N+108>>2];break}}while(0);m=N+108|0;j=c[m>>2]|0;if((c[N+112>>2]|0)>(j|0)){c[m>>2]=j+1;l=c[N+104>>2]|0;a[l+(j*20|0)>>0]=69;l=l+(j*20|0)+1|0;n=l+19|0;do{a[l>>0]=0;l=l+1|0}while((l|0)<(n|0))}else Bi(N,69,0,0,0)|0;l=f+36|0;do if(c[l>>2]|0){k=c[U>>2]|0;j=c[O>>2]|0;if(j|0){if(k|0){if(c[k+480>>2]|0){Vd(k,j);break}aa=j;if((c[k+304>>2]|0)>>>0<=aa>>>0?(c[k+308>>2]|0)>>>0>aa>>>0:0){aa=k+300|0;c[j>>2]=c[aa>>2];c[aa>>2]=j;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](j);break}else{aa=Ua[c[29352>>2]&127](j)|0;c[14978]=(c[14978]|0)-aa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](j);break}}}else{c[f+4>>2]=c[O>>2];c[l>>2]=c[U+36>>2];c[f+12>>2]=c[U+12>>2]}while(0);if((a[_+81>>0]|0)==0?(c[l>>2]|0)==0:0){f=N+104|0;aa=c[f>>2]|0;Di(N,Y+96|0);c[Q+4>>2]=c[m>>2];c[f>>2]=0;c[Q>>2]=aa}c[Q+8>>2]=c[U+44>>2];c[Q+12>>2]=c[U+40>>2];c[Q+20>>2]=g;c[R>>2]=c[U+136>>2];c[S>>2]=c[U+140>>2];l=c[N>>2]|0;ib(l,N);m=c[N+4>>2]|0;k=N+8|0;j=c[k>>2]|0;if(!m)c[l+4>>2]=j;else{c[m+8>>2]=j;j=c[k>>2]|0}if(j|0)c[j+4>>2]=m;c[N+20>>2]=1443283912;c[N>>2]=0;do if(l){if(c[l+480>>2]|0){Vd(l,N);break}aa=N;if((c[l+304>>2]|0)>>>0<=aa>>>0?(c[l+308>>2]|0)>>>0>aa>>>0:0){aa=l+300|0;c[N>>2]=c[aa>>2];c[aa>>2]=N}else P=370}else P=370;while(0);do if((P|0)==370)if(!(c[7324]|0)){_a[c[29344>>2]&127](N);break}else{aa=Ua[c[29352>>2]&127](N)|0;c[14978]=(c[14978]|0)-aa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](N);break}while(0);l=c[U>>2]|0;j=c[U+64>>2]|0;u:do if(j|0){do if(l|0){if(c[l+480>>2]|0){Vd(l,j);break u}k=j;if((c[l+304>>2]|0)>>>0>k>>>0)break;if((c[l+308>>2]|0)>>>0<=k>>>0)break;aa=l+300|0;c[j>>2]=c[aa>>2];c[aa>>2]=j;break u}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](j);break}else{aa=Ua[c[29352>>2]&127](j)|0;c[14978]=(c[14978]|0)-aa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](j);break}}while(0);j=c[U+68>>2]|0;if(j|0)pi(l,j);j=U+24|0;if(l){aa=l+272|0;c[aa>>2]=(c[aa>>2]|0)-(d[j>>0]|0)}}a[j>>0]=0;if(c[_+480>>2]|0){Vd(_,U);aa=Z;Qa=$;return aa|0}if((c[_+304>>2]|0)>>>0<=T>>>0?(c[_+308>>2]|0)>>>0>T>>>0:0){aa=_+300|0;c[U>>2]=c[aa>>2];c[aa>>2]=U;aa=Z;Qa=$;return aa|0}if(!(c[7324]|0)){_a[c[29344>>2]&127](U);aa=Z;Qa=$;return aa|0}else{aa=Ua[c[29352>>2]&127](U)|0;c[14978]=(c[14978]|0)-aa;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](U);aa=Z;Qa=$;return aa|0}return 0}function Mm(f,g,h,i,j){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;B=Qa;Qa=Qa+16|0;z=B;A=c[h+20>>2]|0;o=c[h+40>>2]|0;do if((A|0)==1){x=b[g+40>>1]|0;k=x<<16>>16;if(x<<16>>16>-1){if(!o){A=0;Qa=B;return A|0}l=c[(c[g+4>>2]|0)+(k<<4)>>2]|0;x=a[l>>0]|0;k=(d[208+(x&255)>>0]|0)-(d[208+(d[o>>0]|0)>>0]|0)|0;if(!(x<<24>>24==0|(k|0)!=0)){m=o;do{l=l+1|0;m=m+1|0;x=a[l>>0]|0;k=(d[208+(x&255)>>0]|0)-(d[208+(d[m>>0]|0)>>0]|0)|0}while(!(x<<24>>24==0|(k|0)!=0))}if(!k){A=0;Qa=B;return A|0}else{x=0;w=0}}else{x=0;w=0}}else if(j){m=c[f>>2]|0;n=A<<2;a:do if(c[m+272>>2]|0)if(!(a[m+81>>0]|0))y=19;else{A=1;Qa=B;return A|0}else{do if(!(0<0|(0==0?(e[m+276>>1]|0)>>>0<n>>>0:0))){l=m+300|0;k=c[l>>2]|0;if(k|0){c[l>>2]=c[k>>2];x=m+284|0;c[x>>2]=(c[x>>2]|0)+1;break a}l=m+296|0;k=c[l>>2]|0;if(!k){k=m+292|0;break}else{c[l>>2]=c[k>>2];x=m+284|0;c[x>>2]=(c[x>>2]|0)+1;break a}}else k=m+288|0;while(0);c[k>>2]=(c[k>>2]|0)+1;y=19}while(0);if((y|0)==19)k=Yd(m,n,0)|0;if(!k){A=1;Qa=B;return A|0}else{c[j>>2]=k;x=k;w=k;break}}else{x=0;w=0}while(0);k=c[g+8>>2]|0;b:do if(k|0){u=(o|0)==0;v=(A|0)>0;s=g+4|0;t=(x|0)==0;r=k;c:while(1){do if(((A|0)==(e[r+50>>1]|0)?a[r+54>>0]|0:0)?(c[r+36>>2]|0)==0:0){if(u){q=r+55|0;if(((d[q>>0]|d[q+1>>0]<<8)&3)==2){y=29;break c}else break}d:do if(v){q=r+32|0;p=c[r+4>>2]|0;k=0;do{g=b[p+(k<<1)>>1]|0;j=g<<16>>16;if(g<<16>>16<0)break d;o=c[s>>2]|0;n=c[o+(j<<4)+8>>2]|0;n=(n|0)==0?34049:n;m=c[(c[q>>2]|0)+(k<<2)>>2]|0;g=a[m>>0]|0;l=(d[208+(g&255)>>0]|0)-(d[208+(d[n>>0]|0)>>0]|0)|0;if(!(g<<24>>24==0|(l|0)!=0))do{m=m+1|0;n=n+1|0;g=a[m>>0]|0;l=(d[208+(g&255)>>0]|0)-(d[208+(d[n>>0]|0)>>0]|0)|0}while(!(g<<24>>24==0|(l|0)!=0));if(l|0)break d;o=c[o+(j<<4)>>2]|0;g=d[208+(d[o>>0]|0)>>0]|0;l=0;do{n=c[h+36+(l<<3)+4>>2]|0;j=a[n>>0]|0;m=(d[208+(j&255)>>0]|0)-g|0;if(!(j<<24>>24==0|(m|0)!=0)){j=o;do{n=n+1|0;j=j+1|0;C=a[n>>0]|0;m=(d[208+(C&255)>>0]|0)-(d[208+(d[j>>0]|0)>>0]|0)|0}while(!(C<<24>>24==0|(m|0)!=0))}if(!m){y=45;break}l=l+1|0}while((l|0)<(A|0));if((y|0)==45){y=0;if(!t)c[x+(k<<2)>>2]=c[h+36+(l<<3)>>2]}if((l|0)==(A|0))break d;k=k+1|0}while((k|0)<(A|0))}else k=0;while(0);if((k|0)==(A|0))break c}while(0);k=c[r+20>>2]|0;if(!k)break b;else r=k}if((y|0)==29?(x|0)!=0&v:0){k=0;do{c[x+(k<<2)>>2]=c[h+36+(k<<3)>>2];k=k+1|0}while((k|0)!=(A|0))}c[i>>2]=r;C=0;Qa=B;return C|0}while(0);if(!(a[f+146>>0]|0)){C=c[h+8>>2]|0;c[z>>2]=c[c[h>>2]>>2];c[z+4>>2]=C;ad(f,44708,z)}k=c[f>>2]|0;if(!w){C=1;Qa=B;return C|0}if(k|0){if(c[k+480>>2]|0){Vd(k,w);C=1;Qa=B;return C|0}C=w;if((c[k+304>>2]|0)>>>0<=C>>>0?(c[k+308>>2]|0)>>>0>C>>>0:0){C=k+300|0;c[w>>2]=c[C>>2];c[C>>2]=w;C=1;Qa=B;return C|0}}if(!(c[7324]|0)){_a[c[29344>>2]&127](w);C=1;Qa=B;return C|0}else{C=Ua[c[29352>>2]&127](w)|0;c[14978]=(c[14978]|0)-C;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](w);C=1;Qa=B;return C|0}return 0}function Nm(f,g,h,i,j,k,l,m,n){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0;A=f+8|0;o=c[A>>2]|0;a:do if(!o){r=c[f>>2]|0;if((c[f+116>>2]|0)==0?(b[r+76>>1]&8)==0:0)a[f+23>>0]=1;b:do if(c[r+272>>2]|0)if(!(a[r+81>>0]|0))L=15;else{J=0;break a}else{do if((e[r+276>>1]|0)>=224){o=r+300|0;p=c[o>>2]|0;if(p|0){c[o>>2]=c[p>>2];K=r+284|0;c[K>>2]=(c[K>>2]|0)+1;break b}o=r+296|0;p=c[o>>2]|0;if(!p){o=r+292|0;break}else{c[o>>2]=c[p>>2];K=r+284|0;c[K>>2]=(c[K>>2]|0)+1;break b}}else o=r+288|0;while(0);c[o>>2]=(c[o>>2]|0)+1;L=15}while(0);if((L|0)==15)p=Yd(r,224,0)|0;if(!p)J=0;else{o=p+104|0;q=o+120|0;do{c[o>>2]=0;o=o+4|0}while((o|0)<(q|0));c[p>>2]=r;o=r+4|0;q=c[o>>2]|0;if(q|0)c[q+4>>2]=p;c[p+8>>2]=q;c[p+4>>2]=0;c[o>>2]=p;c[p+20>>2]=381479589;c[p+12>>2]=f;c[A>>2]=p;Bi(p,61,0,1,0)|0;J=p}}else J=o;while(0);K=(c[f+40>>2]|0)+-1|0;D=f+56|0;I=c[D>>2]|0;H=I+-1|0;c[D>>2]=H;do if((m|0)<0){o=d[j+24>>0]|0;p=J+108|0;q=c[p>>2]|0;if((c[J+112>>2]|0)>(q|0)){c[p>>2]=q+1;D=c[J+104>>2]|0;a[D+(q*20|0)>>0]=46;b[D+(q*20|0)+2>>1]=0;c[D+(q*20|0)+4>>2]=o;c[D+(q*20|0)+8>>2]=H;c[D+(q*20|0)+12>>2]=0;c[D+(q*20|0)+16>>2]=0;a[D+(q*20|0)+1>>0]=0;break}else{Bi(J,46,o,H,0)|0;break}}while(0);v=j+20|0;o=c[v>>2]|0;if((o|0)>0){r=l+1|0;s=J+108|0;t=J+112|0;u=J+104|0;q=0;do{o=r+(c[k+(q<<2)>>2]|0)|0;p=c[s>>2]|0;if((c[t>>2]|0)>(p|0)){c[s>>2]=p+1;D=c[u>>2]|0;a[D+(p*20|0)>>0]=50;b[D+(p*20|0)+2>>1]=0;c[D+(p*20|0)+4>>2]=o;c[D+(p*20|0)+8>>2]=H;c[D+(p*20|0)+12>>2]=0;c[D+(p*20|0)+16>>2]=0;a[D+(p*20|0)+1>>0]=0}else Bi(J,50,o,H,0)|0;q=q+1|0;o=c[v>>2]|0}while((q|0)<(o|0));D=o}else D=o;do if(!n){if(!i){u=f+19|0;o=a[u>>0]|0;if(!(o<<24>>24)){G=f+44|0;t=(c[G>>2]|0)+1|0;c[G>>2]=t}else{t=o+-1<<24>>24;a[u>>0]=t;t=c[f+148+((t&255)<<2)>>2]|0}o=l+1+(c[k>>2]|0)|0;r=J+108|0;p=c[r>>2]|0;s=J+112|0;if((c[s>>2]|0)>(p|0)){c[r>>2]=p+1;G=c[J+104>>2]|0;a[G+(p*20|0)>>0]=79;b[G+(p*20|0)+2>>1]=0;c[G+(p*20|0)+4>>2]=o;c[G+(p*20|0)+8>>2]=t;c[G+(p*20|0)+12>>2]=0;c[G+(p*20|0)+16>>2]=0;a[G+(p*20|0)+1>>0]=0}else Bi(J,79,o,t,0)|0;o=c[r>>2]|0;if((c[s>>2]|0)>(o|0)){c[r>>2]=o+1;q=c[J+104>>2]|0;a[q+(o*20|0)>>0]=15;b[q+(o*20|0)+2>>1]=0;c[q+(o*20|0)+4>>2]=t;c[q+(o*20|0)+8>>2]=0;c[q+(o*20|0)+12>>2]=0;c[q+(o*20|0)+16>>2]=0;a[q+(o*20|0)+1>>0]=0;q=o}else q=Bi(J,15,t,0,0)|0;if((m|0)==1?(c[j>>2]|0)==(h|0):0){o=c[r>>2]|0;if((c[s>>2]|0)>(o|0)){c[r>>2]=o+1;G=c[J+104>>2]|0;a[G+(o*20|0)>>0]=53;b[G+(o*20|0)+2>>1]=0;c[G+(o*20|0)+4>>2]=l;c[G+(o*20|0)+8>>2]=H;c[G+(o*20|0)+12>>2]=t;c[G+(o*20|0)+16>>2]=0;a[G+(o*20|0)+1>>0]=0}else Bi(J,53,l,H,t)|0;o=c[r>>2]|0;if((o|0)>0)b[(c[J+104>>2]|0)+((o+-1|0)*20|0)+2>>1]=144}Ej(f,K,g,h,108);o=c[r>>2]|0;if((c[s>>2]|0)>(o|0)){c[r>>2]=o+1;l=c[J+104>>2]|0;a[l+(o*20|0)>>0]=31;b[l+(o*20|0)+2>>1]=0;c[l+(o*20|0)+4>>2]=K;c[l+(o*20|0)+8>>2]=0;c[l+(o*20|0)+12>>2]=t;c[l+(o*20|0)+16>>2]=0;a[l+(o*20|0)+1>>0]=0}else Bi(J,31,K,0,t)|0;o=c[r>>2]|0;if((c[s>>2]|0)>(o|0)){c[r>>2]=o+1;l=c[J+104>>2]|0;a[l+(o*20|0)>>0]=11;b[l+(o*20|0)+2>>1]=0;c[l+(o*20|0)+4>>2]=0;c[l+(o*20|0)+8>>2]=H;c[l+(o*20|0)+12>>2]=0;c[l+(o*20|0)+16>>2]=0;a[l+(o*20|0)+1>>0]=0}else Bi(J,11,0,H,0)|0;p=c[r>>2]|0;if(!(a[(c[J>>2]|0)+81>>0]|0)){o=c[J+104>>2]|0;c[o+((((p|0)<2?-1:-2)+p|0)*20|0)+8>>2]=p;o=o+(((q|0)<0?p+-1|0:q)*20|0)|0}else{c[14829]=p;o=59308}c[o+8>>2]=p;if(!t)break;o=a[u>>0]|0;if((o&255)>=8)break;a[u>>0]=o+1<<24>>24;c[f+148+((o&255)<<2)>>2]=t;break}C=(D|0)==1;do if(C){o=f+19|0;p=a[o>>0]|0;if(!(p<<24>>24)){z=f+44|0;B=(c[z>>2]|0)+1|0;c[z>>2]=B;break}else{B=p+-1<<24>>24;a[o>>0]=B;B=c[f+148+((B&255)<<2)>>2]|0;break}}else{o=f+32|0;p=c[o>>2]|0;q=f+28|0;r=c[q>>2]|0;if((r|0)<(D|0)){z=f+44|0;B=c[z>>2]|0;c[z>>2]=B+D;B=B+1|0;break}else{c[o>>2]=p+D;c[q>>2]=r-D;B=p;break}}while(0);z=f+19|0;o=a[z>>0]|0;if(!(o<<24>>24)){x=f+44|0;y=(c[x>>2]|0)+1|0;c[x>>2]=y}else{y=o+-1<<24>>24;a[z>>0]=y;y=c[f+148+((y&255)<<2)>>2]|0}o=c[i+44>>2]|0;w=J+108|0;p=c[w>>2]|0;x=J+112|0;if((c[x>>2]|0)>(p|0)){c[w>>2]=p+1;n=c[J+104>>2]|0;a[n+(p*20|0)>>0]=108;b[n+(p*20|0)+2>>1]=0;c[n+(p*20|0)+4>>2]=K;c[n+(p*20|0)+8>>2]=o;c[n+(p*20|0)+12>>2]=g;c[n+(p*20|0)+16>>2]=0;a[n+(p*20|0)+1>>0]=0}else Bi(J,108,K,o,g)|0;o=c[A>>2]|0;q=Gj(f,i)|0;do if(q|0){p=c[o>>2]|0;if(!(a[p+81>>0]|0)){A=c[o+104>>2]|0;g=(c[o+108>>2]|0)+-1|0;a[A+(g*20|0)+1>>0]=-9;c[A+(g*20|0)+16>>2]=q;break}if((c[p+480>>2]|0)==0?(g=(c[q>>2]|0)+-1|0,c[q>>2]=g,(g|0)==0):0){o=c[q+12>>2]|0;if(o|0){if(c[o+480>>2]|0){Vd(o,q);break}g=q;if((c[o+304>>2]|0)>>>0<=g>>>0?(c[o+308>>2]|0)>>>0>g>>>0:0){g=o+300|0;c[q>>2]=c[g>>2];c[g>>2]=q;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](q);break}else{g=Ua[c[29352>>2]&127](q)|0;c[14978]=(c[14978]|0)-g;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](q);break}}}while(0);u=(D|0)>0;if(u){p=l+1|0;q=J+104|0;o=0;do{r=p+(c[k+(o<<2)>>2]|0)|0;s=o+B|0;t=c[w>>2]|0;if((c[x>>2]|0)>(t|0)){c[w>>2]=t+1;g=c[q>>2]|0;a[g+(t*20|0)>>0]=78;b[g+(t*20|0)+2>>1]=0;c[g+(t*20|0)+4>>2]=r;c[g+(t*20|0)+8>>2]=s;c[g+(t*20|0)+12>>2]=0;c[g+(t*20|0)+16>>2]=0;a[g+(t*20|0)+1>>0]=0}else Bi(J,78,r,s,0)|0;o=o+1|0}while((o|0)!=(D|0))}do if((m|0)==1?(c[j>>2]|0)==(h|0):0){o=c[w>>2]|0;n=D+1+o|0;if(u){u=l+1|0;v=i+4|0;s=h+40|0;t=J+104|0;r=0;do{p=u+(c[k+(r<<2)>>2]|0)|0;q=b[(c[v>>2]|0)+(r<<1)>>1]|0;q=(q<<16>>16==(b[s>>1]|0)?0:(q<<16>>16)+1|0)+l|0;if((c[x>>2]|0)>(o|0)){c[w>>2]=o+1;h=c[t>>2]|0;a[h+(o*20|0)>>0]=52;b[h+(o*20|0)+2>>1]=0;c[h+(o*20|0)+4>>2]=p;c[h+(o*20|0)+8>>2]=n;c[h+(o*20|0)+12>>2]=q;c[h+(o*20|0)+16>>2]=0;a[h+(o*20|0)+1>>0]=0}else Bi(J,52,p,n,q)|0;o=c[w>>2]|0;if((o|0)>0)b[(c[t>>2]|0)+((o+-1|0)*20|0)+2>>1]=16;r=r+1|0}while((r|0)!=(D|0))}if((c[x>>2]|0)>(o|0)){c[w>>2]=o+1;l=c[J+104>>2]|0;a[l+(o*20|0)>>0]=11;b[l+(o*20|0)+2>>1]=0;c[l+(o*20|0)+4>>2]=0;c[l+(o*20|0)+8>>2]=H;c[l+(o*20|0)+12>>2]=0;c[l+(o*20|0)+16>>2]=0;a[l+(o*20|0)+1>>0]=0;break}else{Bi(J,11,0,H,0)|0;break}}while(0);r=el(c[f>>2]|0,i)|0;o=c[w>>2]|0;if((c[x>>2]|0)>(o|0)){c[w>>2]=o+1;l=c[J+104>>2]|0;a[l+(o*20|0)>>0]=92;b[l+(o*20|0)+2>>1]=0;c[l+(o*20|0)+4>>2]=B;c[l+(o*20|0)+8>>2]=D;c[l+(o*20|0)+12>>2]=y;c[l+(o*20|0)+16>>2]=0;a[l+(o*20|0)+1>>0]=0}else o=Bi(J,92,B,D,y)|0;p=c[J>>2]|0;do if(a[p+81>>0]|0){if((D|0)!=-12)ig(p,D,r)}else{if((o|0)<0)o=(c[w>>2]|0)+-1|0;p=c[J+104>>2]|0;q=p+(o*20|0)|0;if((D|0)<=-1?(E=p+(o*20|0)+1|0,(a[E>>0]|0)==0):0){if((D|0)==-3){c[p+(o*20|0)+16>>2]=r;a[E>>0]=-3;break}if(!r)break;c[p+(o*20|0)+16>>2]=r;a[E>>0]=D;if((D|0)!=-12)break;l=r+12|0;c[l>>2]=(c[l>>2]|0)+1;break}Ci(J,q,r,D)}while(0);o=c[w>>2]|0;if((c[x>>2]|0)>(o|0)){c[w>>2]=o+1;l=c[J+104>>2]|0;a[l+(o*20|0)>>0]=29;b[l+(o*20|0)+2>>1]=0;c[l+(o*20|0)+4>>2]=K;c[l+(o*20|0)+8>>2]=H;c[l+(o*20|0)+12>>2]=y;c[l+(o*20|0)+16>>2]=0;a[l+(o*20|0)+1>>0]=0}else o=Bi(J,29,K,H,y)|0;if(!(a[(c[J>>2]|0)+81>>0]|0)){H=c[J+104>>2]|0;a[H+(o*20|0)+1>>0]=-3;c[H+(o*20|0)+16>>2]=0}if(y|0?(F=a[z>>0]|0,(F&255)<8):0){a[z>>0]=F+1<<24>>24;c[f+148+((F&255)<<2)>>2]=y}if(!C){o=f+28|0;if((c[o>>2]|0)>=(D|0))break;c[o>>2]=D;c[f+32>>2]=B;break}if(B|0?(G=a[z>>0]|0,(G&255)<8):0){a[z>>0]=G+1<<24>>24;c[f+148+((G&255)<<2)>>2]=B}}while(0);o=a[j+24>>0]|0;p=o<<24>>24==0;do if(p){if(((0==0?(c[(c[f>>2]|0)+32>>2]&524288|0)==0:0)?(c[f+116>>2]|0)==0:0)?(a[f+20>>0]|0)==0:0){Sj(f,787,2,0,-1,4);break}if(!((m|0)<1|p^1)){L=c[f+116>>2]|0;a[((L|0)==0?f:L)+21>>0]=1;L=141}else L=141}else L=141;while(0);do if((L|0)==141){o=o&255;p=J+108|0;q=c[p>>2]|0;if((c[J+112>>2]|0)>(q|0)){c[p>>2]=q+1;f=c[J+104>>2]|0;a[f+(q*20|0)>>0]=-106;b[f+(q*20|0)+2>>1]=0;c[f+(q*20|0)+4>>2]=o;c[f+(q*20|0)+8>>2]=m;c[f+(q*20|0)+12>>2]=0;c[f+(q*20|0)+16>>2]=0;a[f+(q*20|0)+1>>0]=0;break}else{Bi(J,150,o,m,0)|0;break}}while(0);p=c[J+12>>2]|0;o=0-I|0;if(((c[p+56>>2]|0)+(c[p+60>>2]|0)|0)<0){kk(p,J,o);o=J+108|0}else{m=J+108|0;c[(c[p+64>>2]|0)+(o<<2)>>2]=c[m>>2];o=m}p=c[o>>2]|0;if((c[J+112>>2]|0)>(p|0)){c[o>>2]=p+1;m=c[J+104>>2]|0;a[m+(p*20|0)>>0]=117;b[m+(p*20|0)+2>>1]=0;c[m+(p*20|0)+4>>2]=K;c[m+(p*20|0)+8>>2]=0;c[m+(p*20|0)+12>>2]=0;c[m+(p*20|0)+16>>2]=0;a[m+(p*20|0)+1>>0]=0;return}else{Bi(J,117,K,0,0)|0;return}}function Om(f,g,h,i,j,k,l,m){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0;P=Qa;Qa=Qa+80|0;N=P;M=P+40|0;L=P+8|0;O=c[f>>2]|0;q=f+8|0;n=c[q>>2]|0;a:do if(!n){if((c[f+116>>2]|0)==0?(b[O+76>>1]&8)==0:0)a[f+23>>0]=1;b:do if(c[O+272>>2]|0)if(!(a[O+81>>0]|0))p=15;else{K=0;break a}else{do if((e[O+276>>1]|0)>=224){n=O+300|0;o=c[n>>2]|0;if(o|0){c[n>>2]=c[o>>2];K=O+284|0;c[K>>2]=(c[K>>2]|0)+1;break b}n=O+296|0;o=c[n>>2]|0;if(!o){n=O+292|0;break}else{c[n>>2]=c[o>>2];K=O+284|0;c[K>>2]=(c[K>>2]|0)+1;break b}}else n=O+288|0;while(0);c[n>>2]=(c[n>>2]|0)+1;p=15}while(0);if((p|0)==15)o=Yd(O,224,0)|0;if(!o)K=0;else{n=o+104|0;p=n+120|0;do{c[n>>2]=0;n=n+4|0}while((n|0)<(p|0));c[o>>2]=O;n=O+4|0;p=c[n>>2]|0;if(p|0)c[p+4>>2]=o;c[o+8>>2]=p;c[o+4>>2]=0;c[n>>2]=o;c[o+20>>2]=381479589;c[o+12>>2]=f;c[q>>2]=o;Bi(o,61,0,1,0)|0;K=o}}else K=n;while(0);do if((m|0)<0){n=d[j+24>>0]|0;o=K+108|0;p=c[o>>2]|0;if((c[K+112>>2]|0)>(p|0)){c[o>>2]=p+1;H=c[K+104>>2]|0;a[H+(p*20|0)>>0]=46;b[H+(p*20|0)+2>>1]=0;c[H+(p*20|0)+4>>2]=n;c[H+(p*20|0)+8>>2]=0;c[H+(p*20|0)+12>>2]=0;c[H+(p*20|0)+16>>2]=0;a[H+(p*20|0)+1>>0]=0;H=p;break}else{H=Bi(K,46,n,0,0)|0;break}}else H=0;while(0);t=j+20|0;if((c[t>>2]|0)>0){u=(i|0)==0;v=M+4|0;w=i+4|0;x=(k|0)==0;y=j+36|0;z=M+4|0;A=h+40|0;B=h+4|0;C=l+1|0;D=M+4|0;E=M+4|0;r=0;s=0;do{if(u)o=-1;else o=b[(c[w>>2]|0)+(s<<1)>>1]|0;p=o&65535;q=c[f>>2]|0;c[M>>2]=0;c[v>>2]=0;n=mj(q,168,M,0)|0;do if(!n)n=0;else{if(p<<16>>16>-1?(b[A>>1]|0)!=p<<16>>16:0){p=c[B>>2]|0;c[n+28>>2]=C+o;a[n+1>>0]=a[p+(o<<4)+13>>0]|0;o=c[p+(o<<4)+8>>2]|0;if(o|0){c[M>>2]=o;q=(Cu(o)|0)&1073741823;c[D>>2]=q;if((q|0)!=0?(F=mj(c[f>>2]|0,106,M,0)|0,(F|0)!=0):0){c[F+12>>2]=n;n=F+4|0;c[n>>2]=c[n>>2]|4352;n=F}break}o=c[c[q+8>>2]>>2]|0;c[M>>2]=o;if(o){q=(Cu(o)|0)&1073741823;c[E>>2]=q;if((q|0)!=0?(G=mj(c[f>>2]|0,106,M,0)|0,(G|0)!=0):0){c[G+12>>2]=n;n=G+4|0;c[n>>2]=c[n>>2]|4352;n=G}}else c[E>>2]=0;break}c[n+28>>2]=l;a[n+1>>0]=68}while(0);o=c[(c[(c[j>>2]|0)+4>>2]|0)+(c[(x?y:k+(s<<2)|0)>>2]<<16>>16<<4)>>2]|0;c[M>>2]=o;if(!o)o=0;else o=(Cu(o)|0)&1073741823;c[z>>2]=o;r=Vk(O,r,cj(f,53,n,mj(O,59,M,0)|0)|0)|0;s=s+1|0}while((s|0)<(c[t>>2]|0));n=j}else{r=0;n=j}if((m|0)>0?(c[n>>2]|0)==(h|0):0){if(!(c[h+36>>2]&32)){n=c[f>>2]|0;c[M>>2]=0;c[M+4>>2]=0;n=mj(n,168,M,0)|0;if(!n)n=0;else{c[n+28>>2]=l;a[n+1>>0]=68}o=c[g+48>>2]|0;c[M>>2]=0;c[M+4>>2]=0;p=mj(O,162,M,0)|0;if(p|0){c[p+44>>2]=h;c[p+28>>2]=o;b[p+32>>1]=-1}n=cj(f,52,n,p)|0}else{C=i+50|0;if(!(b[C>>1]|0))n=0;else{y=i+4|0;z=M+4|0;A=h+4|0;B=M+4|0;u=h+40|0;v=l+1|0;w=M+4|0;x=M+4|0;n=0;t=0;do{p=b[(c[y>>2]|0)+(t<<1)>>1]|0;q=c[f>>2]|0;c[M>>2]=0;c[z>>2]=0;o=mj(q,168,M,0)|0;s=p<<16>>16;do if(!o)p=0;else{if(p<<16>>16>-1?(b[u>>1]|0)!=p<<16>>16:0){p=c[A>>2]|0;c[o+28>>2]=v+s;a[o+1>>0]=a[p+(s<<4)+13>>0]|0;p=c[p+(s<<4)+8>>2]|0;if(p|0){c[M>>2]=p;h=(Cu(p)|0)&1073741823;c[w>>2]=h;if((h|0)!=0?(I=mj(c[f>>2]|0,106,M,0)|0,(I|0)!=0):0){c[I+12>>2]=o;o=I+4|0;c[o>>2]=c[o>>2]|4352;o=I}p=o;break}p=c[c[q+8>>2]>>2]|0;c[M>>2]=p;if(p){h=(Cu(p)|0)&1073741823;c[x>>2]=h;if((h|0)!=0?(J=mj(c[f>>2]|0,106,M,0)|0,(J|0)!=0):0){c[J+12>>2]=o;o=J+4|0;c[o>>2]=c[o>>2]|4352;o=J}}else c[x>>2]=0;p=o;break}c[o+28>>2]=l;a[o+1>>0]=68;p=o}while(0);o=c[(c[A>>2]|0)+(s<<4)>>2]|0;c[M>>2]=o;if(!o)o=0;else o=(Cu(o)|0)&1073741823;c[B>>2]=o;n=Vk(O,n,cj(f,45,p,mj(O,59,M,0)|0)|0)|0;t=t+1|0}while(t>>>0<(e[C>>1]|0)>>>0)}n=cj(f,19,n,0)|0}r=Vk(O,r,n)|0}s=L+8|0;c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;c[s+12>>2]=0;c[s+16>>2]=0;c[s+20>>2]=0;c[L+4>>2]=g;c[L>>2]=f;s=(r|0)==0;do if(!s){p=L+24|0;b[p>>1]=0;c[M>>2]=f;c[M+4>>2]=125;c[M+8>>2]=126;c[M+12>>2]=0;c[M+24>>2]=L;n=r+24|0;o=f+208|0;L=(c[o>>2]|0)+(c[n>>2]|0)|0;c[o>>2]=L;o=c[(c[f>>2]|0)+120>>2]|0;if((o|0)<(L|0)){c[N>>2]=o;ad(f,41637,N);break}else{Yj(M,r)|0;N=(c[M>>2]|0)+208|0;c[N>>2]=(c[N>>2]|0)-(c[n>>2]|0);N=r+4|0;c[N>>2]=c[N>>2]|b[p>>1]&-32752&65535;break}}while(0);if(!(c[f+36>>2]|0)){q=ol(f,g,r,0,0,0,0)|0;n=d[j+24>>0]|0;o=K+108|0;p=c[o>>2]|0;if((c[K+112>>2]|0)>(p|0)){c[o>>2]=p+1;j=c[K+104>>2]|0;a[j+(p*20|0)>>0]=-106;b[j+(p*20|0)+2>>1]=0;c[j+(p*20|0)+4>>2]=n;c[j+(p*20|0)+8>>2]=m;c[j+(p*20|0)+12>>2]=0;c[j+(p*20|0)+16>>2]=0;a[j+(p*20|0)+1>>0]=0}else Bi(K,150,n,m,0)|0;if(q|0)ql(q)}if(!s)li(O,r);if(!H){Qa=P;return}o=c[K+108>>2]|0;if(!(a[(c[K>>2]|0)+81>>0]|0))n=(c[K+104>>2]|0)+(((H|0)<0?o+-1|0:H)*20|0)|0;else n=59308;c[n+8>>2]=o;Qa=P;return}function Pm(f,g,h,i){f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0;aa=Qa;Qa=Qa+48|0;V=aa+16|0;Q=aa+36|0;T=aa+32|0;W=aa+8|0;R=aa;S=aa+24|0;$=c[f>>2]|0;_=(i|0)!=0;i=_&1;Y=a[h+25+i>>0]|0;U=Y<<24>>24==7;if(U?!(0==0?(c[$+32>>2]&524288|0)==0:0):0){$=0;Qa=aa;return $|0}Z=h+28+(i<<2)|0;i=c[Z>>2]|0;if(Y<<24>>24==0|(i|0)!=0){$=i;Qa=aa;return $|0}c[Q>>2]=0;c[T>>2]=0;a:do if(!(Mm(f,g,h,Q,T)|0)){u=h+20|0;if((c[u>>2]|0)>0){w=29616;v=c[w>>2]|0;w=c[w+4>>2]|0;y=29624;x=c[y>>2]|0;y=c[y+4>>2]|0;z=h+36|0;A=g+4|0;B=g+40|0;C=S+4|0;D=R+4|0;P=Y<<24>>24!=7&(_|Y<<24>>24!=10);E=$+272|0;F=$+276|0;G=$+81|0;H=$+288|0;I=$+300|0;J=f+200|0;K=$+296|0;M=$+284|0;N=$+292|0;O=f+272|0;s=0;t=0;m=0;j=0;while(1){k=V;c[k>>2]=v;c[k+4>>2]=w;k=W;c[k>>2]=x;c[k+4>>2]=y;k=c[T>>2]|0;k=c[((k|0)==0?z:k+(t<<2)|0)>>2]|0;i=c[Q>>2]|0;if(!i)i=B;else i=(c[i+4>>2]|0)+(t<<1)|0;i=c[(c[A>>2]|0)+(b[i>>1]<<4)>>2]|0;c[S>>2]=i;if(!i)i=0;else i=(Cu(i)|0)&1073741823;c[C>>2]=i;i=c[(c[(c[h>>2]|0)+4>>2]|0)+(k<<4)>>2]|0;c[R>>2]=i;if(!i)i=0;else i=(Cu(i)|0)&1073741823;c[D>>2]=i;r=mj($,59,V,0)|0;r=cj(f,134,r,mj($,59,S,0)|0)|0;j=Vk($,j,cj(f,53,r,mj($,59,R,0)|0)|0)|0;if(_){q=mj($,59,V,0)|0;q=cj(f,134,q,mj($,59,S,0)|0)|0;r=mj($,59,W,0)|0;s=Vk($,s,cj(f,45,q,cj(f,134,r,mj($,59,S,0)|0)|0)|0)|0}b:do if(P){c:do switch(Y<<24>>24){case 10:{i=cj(f,134,mj($,59,W,0)|0,mj($,59,S,0)|0)|0;break}case 9:{i=c[(c[(c[h>>2]|0)+4>>2]|0)+(k<<4)+4>>2]|0;if(i|0){i=bk($,i,0,0)|0;break c}d:do if(c[E>>2]|0)if(!(a[G>>0]|0))X=28;else{i=0;break c}else{do if((e[F>>1]|0)<52)i=H;else{i=c[I>>2]|0;if(i|0){c[I>>2]=c[i>>2];c[M>>2]=(c[M>>2]|0)+1;break d}i=c[K>>2]|0;if(!i){i=N;break}c[K>>2]=c[i>>2];c[M>>2]=(c[M>>2]|0)+1;break d}while(0);c[i>>2]=(c[i>>2]|0)+1;X=28}while(0);if((X|0)==28){X=0;i=Yd($,52,0)|0}if(i){k=i;l=k+52|0;do{c[k>>2]=0;k=k+4|0}while((k|0)<(l|0));a[i>>0]=114;b[i+34>>1]=-1;c[i+24>>2]=1}break}default:{do if(c[E>>2]|0)if(!(a[G>>0]|0))X=39;else{i=0;break c}else{if((e[F>>1]|0)>=52){i=c[I>>2]|0;if(i|0){c[I>>2]=c[i>>2];c[M>>2]=(c[M>>2]|0)+1;break}i=c[K>>2]|0;if(!i)i=N;else{c[K>>2]=c[i>>2];c[M>>2]=(c[M>>2]|0)+1;break}}else i=H;c[i>>2]=(c[i>>2]|0)+1;X=39}while(0);if((X|0)==39){X=0;i=Yd($,52,0)|0}if(i){k=i;l=k+52|0;do{c[k>>2]=0;k=k+4|0}while((k|0)<(l|0));a[i>>0]=114;b[i+34>>1]=-1;c[i+24>>2]=1}}}while(0);r=lj(c[f>>2]|0,m,i)|0;if(r){q=(c[r>>2]|0)+-1|0;l=c[f>>2]|0;o=c[R>>2]|0;p=c[D>>2]|0;e:do if(o){m=Qv(p|0,0,1,0)|0;n=L()|0;f:do if(c[l+272>>2]|0)if(!(a[l+81>>0]|0))X=54;else{m=0;break e}else{do if(0<0|(0==0?p>>>0<(e[l+276>>1]|0)>>>0:0)){k=l+300|0;i=c[k>>2]|0;if(i|0){c[k>>2]=c[i>>2];n=l+284|0;c[n>>2]=(c[n>>2]|0)+1;break f}k=l+296|0;i=c[k>>2]|0;if(!i){i=l+292|0;break}else{c[k>>2]=c[i>>2];n=l+284|0;c[n>>2]=(c[n>>2]|0)+1;break f}}else i=l+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1;X=54}while(0);if((X|0)==54){X=0;i=Yd(l,m,n)|0}if(i){cw(i|0,o|0,p|0)|0;a[i+p>>0]=0;m=i}else m=0}else m=0;while(0);c[r+4+(q*20|0)+4>>2]=m;if((d[J>>0]|0)>1){l=c[f>>2]|0;g:do if(!l){if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](16)|0;X=81;break}i=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;l=59064;k=c[l>>2]|0;l=c[l+4>>2]|0;if((l|0)>0|(l|0)==0&k>>>0>0){q=c[14978]|0;p=Rv(k|0,l|0,i|0,((i|0)<0)<<31>>31|0)|0;o=L()|0;c[14768]=((o|0)<0|(o|0)==0&p>>>0<=q>>>0)&1}i=Ua[c[29340>>2]&127](i)|0;if(!i){i=r;break b}k=Ua[c[29352>>2]&127](i)|0;k=(c[14978]|0)+k|0;c[14978]=k;if(k>>>0>(c[14982]|0)>>>0)c[14982]=k;k=(c[14981]|0)+1|0;c[14981]=k;if(k>>>0<=(c[14987]|0)>>>0)break;c[14987]=k}else{if(c[l+272>>2]|0){if(a[l+81>>0]|0){i=r;break b}}else{do if((e[l+276>>1]|0)>=16){k=l+300|0;i=c[k>>2]|0;if(i|0){c[k>>2]=c[i>>2];X=l+284|0;c[X>>2]=(c[X>>2]|0)+1;X=81;break g}k=l+296|0;i=c[k>>2]|0;if(!i){i=l+292|0;break}else{c[k>>2]=c[i>>2];X=l+284|0;c[X>>2]=(c[X>>2]|0)+1;X=81;break g}}else i=l+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1}i=Yd(l,16,0)|0;X=81}while(0);if((X|0)==81){X=0;if(!i){i=r;break}}o=i+4|0;p=o;a[p>>0]=0;a[p+1>>0]=0;a[p+2>>0]=0;a[p+3>>0]=0;o=o+4|0;a[o>>0]=0;a[o+1>>0]=0;a[o+2>>0]=0;a[o+3>>0]=0;c[i>>2]=m;o=R;p=c[o+4>>2]|0;q=i+4|0;c[q>>2]=c[o>>2];c[q+4>>2]=p;c[i+12>>2]=c[O>>2];c[O>>2]=i;i=r}else i=r}else i=0}else i=m;while(0);t=t+1|0;if((t|0)>=(c[u>>2]|0)){t=i;break}else m=i}}else{s=0;t=0;j=0}i=c[T>>2]|0;do if(i|0){if($|0){if(c[$+480>>2]|0){Vd($,i);break}T=i;if((c[$+304>>2]|0)>>>0<=T>>>0?(c[$+308>>2]|0)>>>0>T>>>0:0){T=$+300|0;c[i>>2]=c[T>>2];c[T>>2]=i;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{T=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-T;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);o=c[c[h>>2]>>2]|0;if(!o)n=0;else n=(Cu(o)|0)&1073741823;if(U){c[W>>2]=o;c[W+4>>2]=n;c[V>>2]=32436;c[V+4>>2]=29;i=mj($,71,V,0)|0;if(!i)i=lj(c[f>>2]|0,0,0)|0;else{a[i+1>>0]=2;i=lj(c[f>>2]|0,0,i)|0}r=kj(f,i,nj(f,0,W,0)|0,j,0,0,0,0,0)|0;p=0}else{r=0;p=j}q=$+272|0;i=(c[q>>2]|0)+1|0;c[q>>2]=i;m=n+81|0;h:do if(!$){if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](m)|0;X=124;break}i=Ua[c[29356>>2]&127](m)|0;if((c[14985]|0)>>>0<m>>>0)c[14985]=m;k=59064;j=c[k>>2]|0;k=c[k+4>>2]|0;if((k|0)>0|(k|0)==0&j>>>0>0){W=c[14978]|0;V=Rv(j|0,k|0,i|0,((i|0)<0)<<31>>31|0)|0;U=L()|0;c[14768]=((U|0)<0|(U|0)==0&V>>>0<=W>>>0)&1}j=Ua[c[29340>>2]&127](i)|0;if(j){i=Ua[c[29352>>2]&127](j)|0;i=(c[14978]|0)+i|0;c[14978]=i;if(i>>>0>(c[14982]|0)>>>0)c[14982]=i;i=(c[14981]|0)+1|0;c[14981]=i;if(i>>>0>(c[14987]|0)>>>0){c[14987]=i;l=j;X=125}else{l=j;X=125}}else{m=0;k=0;i=s;l=0}}else{if(i){if(a[$+81>>0]|0){m=0;k=0;i=s;l=0;break}}else{do if(!(0<0|(0==0?(e[$+276>>1]|0)>>>0<m>>>0:0))){j=$+300|0;i=c[j>>2]|0;if(i|0){c[j>>2]=c[i>>2];X=$+284|0;c[X>>2]=(c[X>>2]|0)+1;X=124;break h}j=$+296|0;i=c[j>>2]|0;if(!i){i=$+292|0;break}else{c[j>>2]=c[i>>2];X=$+284|0;c[X>>2]=(c[X>>2]|0)+1;X=124;break h}}else i=$+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1}i=Yd($,m,0)|0;X=124}while(0);if((X|0)==124)if(!i){m=0;k=0;i=s;l=0}else{l=i;X=125}if((X|0)==125){ew(l|0,0,m|0)|0;k=l+36|0;c[l+28>>2]=k;W=l+80|0;c[l+48>>2]=W;cw(W|0,o|0,n|0)|0;if(!p)i=0;else i=bk($,p,1,0)|0;c[l+52>>2]=i;c[l+56>>2]=ek($,t,1)|0;c[l+44>>2]=dk($,r,1)|0;if(!s){m=l;i=0}else{j=cj(f,19,s,0)|0;if(!j)i=0;else i=bk($,j,1,0)|0;c[l+12>>2]=i;m=l;i=j}}c[q>>2]=(c[q>>2]|0)+-1;if(p|0)li($,p);if(i|0)li($,i);if(t|0)pi($,t);if(r|0)ni($,r,1);if((a[$+81>>0]|0)!=1){switch(Y<<24>>24){case 7:{i=-125;break}case 10:{if(_)X=159;else i=121;break}default:X=159}if((X|0)==159)i=122;a[k>>0]=i;c[k+4>>2]=m;$=c[g+72>>2]|0;c[m+20>>2]=$;c[m+24>>2]=$;c[Z>>2]=m;a[m+8>>0]=_?122:121;$=l;Qa=aa;return $|0}if(l|0){j=c[l+28>>2]|0;i=c[j+16>>2]|0;if(i|0)li($,i);i=c[j+20>>2]|0;if(i|0)pi($,i);i=c[j+8>>2]|0;if(i|0)ni($,i,1);i=c[l+12>>2]|0;if(i|0)li($,i);if(c[$+480>>2]|0){Vd($,m);break}i=l;do if((c[$+304>>2]|0)>>>0<=i>>>0){if((c[$+308>>2]|0)>>>0<=i>>>0)break;$=$+300|0;c[l>>2]=c[$>>2];c[$>>2]=l;break a}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](m);break}else{$=Ua[c[29352>>2]&127](m)|0;c[14978]=(c[14978]|0)-$;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](m);break}}}while(0);$=0;Qa=aa;return $|0}
function Qm(d){d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;p=c[d+8>>2]|0;e=c[d+112>>2]|0;if(!e)return;r=(c[d>>2]|0)+16|0;s=d+19|0;t=d+44|0;n=p+108|0;u=p+112|0;o=p+104|0;while(1){j=c[r>>2]|0;k=e+8|0;l=c[k>>2]|0;m=c[e+12>>2]|0;f=a[s>>0]|0;if(!(f<<24>>24)){i=(c[t>>2]|0)+1|0;c[t>>2]=i}else{i=f+-1<<24>>24;a[s>>0]=i;i=c[d+148+((i&255)<<2)>>2]|0}g=m+2|0;f=c[n>>2]|0;h=f+7|0;if((c[u>>2]|0)>(f|0)){c[n>>2]=f+1;v=c[o>>2]|0;a[v+(f*20|0)>>0]=55;b[v+(f*20|0)+2>>1]=0;c[v+(f*20|0)+4>>2]=g;c[v+(f*20|0)+8>>2]=h;c[v+(f*20|0)+12>>2]=m;c[v+(f*20|0)+16>>2]=0;a[v+(f*20|0)+1>>0]=0}else Bi(p,55,g,h,m)|0;Ej(d,0,c[k>>2]|0,c[(c[j+(l<<4)+12>>2]|0)+72>>2]|0,109);f=cd(p,5,18320)|0;if(!f){e=14;break}v=m+1|0;c[f+4>>2]=v;c[f+28>>2]=v;c[f+44>>2]=m+-1;c[f+52>>2]=i;c[f+68>>2]=i;c[f+72>>2]=v;b[f+62>>1]=8;if(i|0?(q=a[s>>0]|0,(q&255)<8):0){a[s>>0]=q+1<<24>>24;c[d+148+((q&255)<<2)>>2]=i}e=c[e>>2]|0;if(!e){e=14;break}}if((e|0)==14)return}function Rm(f,g,h,i,j,k,l,m,n,o,p,q,r){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;r=r|0;var s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0;Ja=Qa;Qa=Qa+48|0;T=Ja+16|0;S=Ja+8|0;P=Ja;Q=Ja+20|0;Ha=(l|0)!=0;U=c[f>>2]|0;Ia=f+8|0;s=c[Ia>>2]|0;a:do if(!s){if((c[f+116>>2]|0)==0?(b[U+76>>1]&8)==0:0)a[f+23>>0]=1;b:do if(c[U+272>>2]|0)if(!(a[U+81>>0]|0))Ca=15;else{Ga=0;break a}else{do if((e[U+276>>1]|0)>=224){s=U+300|0;t=c[s>>2]|0;if(t|0){c[s>>2]=c[t>>2];Ga=U+284|0;c[Ga>>2]=(c[Ga>>2]|0)+1;break b}s=U+296|0;t=c[s>>2]|0;if(!t){s=U+292|0;break}else{c[s>>2]=c[t>>2];Ga=U+284|0;c[Ga>>2]=(c[Ga>>2]|0)+1;break b}}else s=U+288|0;while(0);c[s>>2]=(c[s>>2]|0)+1;Ca=15}while(0);if((Ca|0)==15)t=Yd(U,224,0)|0;if(!t)Ga=0;else{y=t+104|0;z=y+120|0;do{c[y>>2]=0;y=y+4|0}while((y|0)<(z|0));c[t>>2]=U;s=U+4|0;u=c[s>>2]|0;if(u|0)c[u+4>>2]=t;c[t+8>>2]=u;c[t+4>>2]=0;c[s>>2]=t;c[t+20>>2]=381479589;c[t+12>>2]=f;c[Ia>>2]=t;Bi(t,61,0,1,0)|0;Ga=t}}else Ga=s;while(0);t=b[g+42>>1]|0;M=t<<16>>16;Fa=g+36|0;if(!(c[Fa>>2]&32)){Ea=0;Da=1}else{s=g+8|0;while(1){s=c[s>>2]|0;Ea=s+55|0;if(((d[Ea>>0]|d[Ea+1>>0]<<8)&3)==2)break;else s=s+20|0}Ea=s;Da=e[s+50>>1]|0}if(t<<16>>16>0){A=g+40|0;B=(q|0)==0;C=g+4|0;D=n<<24>>24==11;E=k+1|0;F=Ga+108|0;H=Ga+112|0;I=f+56|0;J=f+116|0;K=Ga+104|0;L=Ga+12|0;z=0;do{c:do if((z|0)!=(b[A>>1]|0)){if(!B?(c[q+(z<<2)>>2]|0)<0:0)break;u=c[C>>2]|0;s=a[u+(z<<4)+12>>0]|0;if(s<<24>>24){Ba=D?(s<<24>>24==11?2:s):n;s=Ba&255;if(Ba<<24>>24==5)s=(c[u+(z<<4)+4>>2]|0)==0?2:s;switch((s&255)<<24>>24){case 5:{Ca=33;break}case 2:{t=0;Ca=51;break}case 3:case 1:{t=0;break}default:{s=z+E|0;t=c[F>>2]|0;if((c[H>>2]|0)>(t|0)){c[F>>2]=t+1;Ba=c[K>>2]|0;a[Ba+(t*20|0)>>0]=50;b[Ba+(t*20|0)+2>>1]=0;c[Ba+(t*20|0)+4>>2]=s;c[Ba+(t*20|0)+8>>2]=o;c[Ba+(t*20|0)+12>>2]=0;c[Ba+(t*20|0)+16>>2]=0;a[Ba+(t*20|0)+1>>0]=0;break c}else{Bi(Ga,50,s,o,0)|0;break c}}}do if((Ca|0)==33){Ca=0;t=(c[I>>2]|0)+-1|0;c[I>>2]=t;y=z+E|0;s=c[F>>2]|0;if((c[H>>2]|0)>(s|0)){c[F>>2]=s+1;Ba=c[K>>2]|0;a[Ba+(s*20|0)>>0]=51;b[Ba+(s*20|0)+2>>1]=0;c[Ba+(s*20|0)+4>>2]=y;c[Ba+(s*20|0)+8>>2]=t;c[Ba+(s*20|0)+12>>2]=0;c[Ba+(s*20|0)+16>>2]=0;a[Ba+(s*20|0)+1>>0]=0}else Bi(Ga,51,y,t,0)|0;s=c[(c[C>>2]|0)+(z<<4)+4>>2]|0;do if(s){if((a[s>>0]|0)!=-88){O=Hj(f,s,y)|0;Ca=43;break}w=c[Ia>>2]|0;s=c[s+28>>2]|0;u=w+108|0;v=c[u>>2]|0;if((c[w+112>>2]|0)>(v|0)){c[u>>2]=v+1;Ba=c[w+104>>2]|0;a[Ba+(v*20|0)>>0]=78;b[Ba+(v*20|0)+2>>1]=0;c[Ba+(v*20|0)+4>>2]=s;c[Ba+(v*20|0)+8>>2]=y;c[Ba+(v*20|0)+12>>2]=0;c[Ba+(v*20|0)+16>>2]=0;a[Ba+(v*20|0)+1>>0]=0;break}else{Bi(w,78,s,y,0)|0;break}}else{O=Hj(f,0,y)|0;Ca=43}while(0);do if(((Ca|0)==43?(0,(O|0)!=(y|0)):0)?(N=c[Ia>>2]|0,N|0):0){s=N+108|0;u=c[s>>2]|0;if((c[N+112>>2]|0)>(u|0)){c[s>>2]=u+1;Ca=c[N+104>>2]|0;a[Ca+(u*20|0)>>0]=79;b[Ca+(u*20|0)+2>>1]=0;c[Ca+(u*20|0)+4>>2]=O;c[Ca+(u*20|0)+8>>2]=y;c[Ca+(u*20|0)+12>>2]=0;c[Ca+(u*20|0)+16>>2]=0;a[Ca+(u*20|0)+1>>0]=0;break}else{Bi(N,79,O,y,0)|0;break}}while(0);s=c[F>>2]|0;if((c[H>>2]|0)>(s|0)){c[F>>2]=s+1;Ca=c[K>>2]|0;a[Ca+(s*20|0)>>0]=51;b[Ca+(s*20|0)+2>>1]=0;c[Ca+(s*20|0)+4>>2]=y;c[Ca+(s*20|0)+8>>2]=t;c[Ca+(s*20|0)+12>>2]=0;c[Ca+(s*20|0)+16>>2]=0;a[Ca+(s*20|0)+1>>0]=0;s=2;Ca=51;break}else{Bi(Ga,51,y,t,0)|0;s=2;Ca=51;break}}while(0);if((Ca|0)==51){Ca=0;u=c[J>>2]|0;a[((u|0)==0?f:u)+21>>0]=1;u=c[C>>2]|0}w=c[u+(z<<4)>>2]|0;c[P>>2]=c[g>>2];c[P+4>>2]=w;w=bd(U,40358,P)|0;u=z+E|0;v=c[F>>2]|0;if((c[H>>2]|0)>(v|0)){c[F>>2]=v+1;Ba=c[K>>2]|0;a[Ba+(v*20|0)>>0]=68;b[Ba+(v*20|0)+2>>1]=0;c[Ba+(v*20|0)+4>>2]=1299;c[Ba+(v*20|0)+8>>2]=s;c[Ba+(v*20|0)+12>>2]=u;c[Ba+(v*20|0)+16>>2]=0;a[Ba+(v*20|0)+1>>0]=0}else Bi(Ga,68,1299,s,u)|0;s=c[Ga>>2]|0;do if(a[s+81>>0]|0){if(w|0){if(s|0){if(c[s+480>>2]|0){Vd(s,w);break}Ba=w;if((c[s+304>>2]|0)>>>0<=Ba>>>0?(c[s+308>>2]|0)>>>0>Ba>>>0:0){Ba=s+300|0;c[w>>2]=c[Ba>>2];c[Ba>>2]=w;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](w);break}else{Ba=Ua[c[29352>>2]&127](w)|0;c[14978]=(c[14978]|0)-Ba;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](w);break}}}else{Aa=c[K>>2]|0;Ba=(c[F>>2]|0)+-1|0;a[Aa+(Ba*20|0)+1>>0]=-7;c[Aa+(Ba*20|0)+16>>2]=w}while(0);u=c[F>>2]|0;if((u|0)>0)b[(c[K>>2]|0)+((u+-1|0)*20|0)+2>>1]=1;if(t|0){v=c[L>>2]|0;s=~t;if(((c[v+56>>2]|0)+(c[v+60>>2]|0)|0)<0){kk(v,Ga,s);break}else{c[(c[v+64>>2]|0)+(s<<2)>>2]=u;break}}}}while(0);z=z+1|0}while((z|0)!=(M|0))}B=c[g+24>>2]|0;if(B|0?(0==0?(c[U+32>>2]&512|0)==0:0):0){C=f+52|0;c[C>>2]=~k;t=n<<24>>24==11?2:n&255;d:do if((c[B>>2]|0)>0){D=f+56|0;y=Q+20|0;z=Q+4|0;A=Q+24|0;E=Ga+108|0;F=Ga+112|0;H=Ga+12|0;I=Ga+104|0;if(!q){w=0;while(1){Aa=c[B+4+(w*20|0)>>2]|0;v=c[D>>2]|0;Ba=v+-1|0;c[D>>2]=Ba;rk(f,Aa,Ba,16);do if((t|0)==4){s=c[E>>2]|0;if((c[F>>2]|0)>(s|0)){c[E>>2]=s+1;t=c[I>>2]|0;a[t+(s*20|0)>>0]=11;b[t+(s*20|0)+2>>1]=0;c[t+(s*20|0)+4>>2]=0;c[t+(s*20|0)+8>>2]=o;c[t+(s*20|0)+12>>2]=0;c[t+(s*20|0)+16>>2]=0;a[t+(s*20|0)+1>>0]=0;t=4;break}else{Bi(Ga,11,0,o,0)|0;t=4;break}}else{s=c[B+4+(w*20|0)+4>>2]|0;if(!s)s=c[g>>2]|0;t=(t|0)==5?2:t;Sj(f,275,t,s,0,3)}while(0);u=c[H>>2]|0;s=0-v|0;if(((c[u+56>>2]|0)+(c[u+60>>2]|0)|0)<0)kk(u,Ga,s);else c[(c[u+64>>2]|0)+(s<<2)>>2]=c[E>>2];w=w+1|0;if((w|0)>=(c[B>>2]|0))break d}}if(!(m<<24>>24)){w=0;do{s=c[B+4+(w*20|0)>>2]|0;c[Q>>2]=0;c[Q+4>>2]=0;c[Q+8>>2]=0;c[Q+12>>2]=0;c[Q+16>>2]=0;c[Q+20>>2]=0;c[z>>2]=136;c[A>>2]=q;do if((s|0)!=0?(Yj(Q,s)|0,(a[y>>0]&-3)<<24>>24!=0):0){v=c[D>>2]|0;Ba=v+-1|0;c[D>>2]=Ba;rk(f,s,Ba,16);do if((t|0)==4){s=c[E>>2]|0;if((c[F>>2]|0)>(s|0)){c[E>>2]=s+1;t=c[I>>2]|0;a[t+(s*20|0)>>0]=11;b[t+(s*20|0)+2>>1]=0;c[t+(s*20|0)+4>>2]=0;c[t+(s*20|0)+8>>2]=o;c[t+(s*20|0)+12>>2]=0;c[t+(s*20|0)+16>>2]=0;a[t+(s*20|0)+1>>0]=0;t=4;break}else{Bi(Ga,11,0,o,0)|0;t=4;break}}else{s=c[B+4+(w*20|0)+4>>2]|0;if(!s)s=c[g>>2]|0;t=(t|0)==5?2:t;Sj(f,275,t,s,0,3)}while(0);u=c[H>>2]|0;s=0-v|0;if(((c[u+56>>2]|0)+(c[u+60>>2]|0)|0)<0){kk(u,Ga,s);break}else{c[(c[u+64>>2]|0)+(s<<2)>>2]=c[E>>2];break}}while(0);w=w+1|0}while((w|0)<(c[B>>2]|0))}else{w=0;do{s=c[B+4+(w*20|0)>>2]|0;c[Q>>2]=0;c[Q+4>>2]=0;c[Q+8>>2]=0;c[Q+12>>2]=0;c[Q+16>>2]=0;c[Q+20>>2]=0;c[z>>2]=136;c[A>>2]=q;do if((s|0)!=0?(Yj(Q,s)|0,(a[y>>0]|0)!=0):0){v=c[D>>2]|0;Ba=v+-1|0;c[D>>2]=Ba;rk(f,s,Ba,16);do if((t|0)==4){s=c[E>>2]|0;if((c[F>>2]|0)>(s|0)){c[E>>2]=s+1;t=c[I>>2]|0;a[t+(s*20|0)>>0]=11;b[t+(s*20|0)+2>>1]=0;c[t+(s*20|0)+4>>2]=0;c[t+(s*20|0)+8>>2]=o;c[t+(s*20|0)+12>>2]=0;c[t+(s*20|0)+16>>2]=0;a[t+(s*20|0)+1>>0]=0;t=4;break}else{Bi(Ga,11,0,o,0)|0;t=4;break}}else{s=c[B+4+(w*20|0)+4>>2]|0;if(!s)s=c[g>>2]|0;t=(t|0)==5?2:t;Sj(f,275,t,s,0,3)}while(0);u=c[H>>2]|0;s=0-v|0;if(((c[u+56>>2]|0)+(c[u+60>>2]|0)|0)<0){kk(u,Ga,s);break}else{c[(c[u+64>>2]|0)+(s<<2)>>2]=c[E>>2];break}}while(0);w=w+1|0}while((w|0)<(c[B>>2]|0))}}while(0);c[C>>2]=0}do if(r)if(c[r>>2]|0){t=c[r+16>>2]|0;if(t){s=Ga+108|0;u=c[s>>2]|0;if((c[Ga+112>>2]|0)>(u|0)){c[s>>2]=u+1;y=c[Ga+104>>2]|0;a[y+(u*20|0)>>0]=11;y=y+(u*20|0)+1|0;z=y+19|0;do{a[y>>0]=0;y=y+1|0}while((y|0)<(z|0));Ba=t;Aa=u;break}else{Ba=t;Aa=Bi(Ga,11,0,0,0)|0;break}}else{Ba=0;Aa=0}}else{n=4;r=0;Ba=0;Aa=0}else{r=0;Ba=0;Aa=0}while(0);if(m<<24>>24!=0&(Ea|0)==0){t=f+56|0;D=c[t>>2]|0;v=D+-1|0;c[t>>2]=v;t=a[g+48>>0]|0;s=n&255;t=n<<24>>24==11?(t<<24>>24==11?2:t&255):s;if((r|0)!=0?(c[r+16>>2]|0)==0:0){E=0;t=(c[r+8>>2]|0)==0?4:6}else Ca=135;do if((Ca|0)==135)if(!((t|0)!=5|(t|0)==(s|0)))if(c[g+8>>2]|0){s=Ga+108|0;t=c[s>>2]|0;if((c[Ga+112>>2]|0)>(t|0)){u=t+1|0;c[s>>2]=u;y=c[Ga+104>>2]|0;a[y+(t*20|0)>>0]=11;y=y+(t*20|0)+1|0;z=y+19|0;do{a[y>>0]=0;y=y+1|0}while((y|0)<(z|0));E=u;t=5;break}else{E=(Bi(Ga,11,0,0,0)|0)+1|0;t=5;break}}else{E=0;t=5}else E=0;while(0);C=Ga+108|0;s=c[C>>2]|0;B=Ga+112|0;if(Ha){if((c[B>>2]|0)>(s|0)){c[C>>2]=s+1;za=c[Ga+104>>2]|0;a[za+(s*20|0)>>0]=53;b[za+(s*20|0)+2>>1]=0;c[za+(s*20|0)+4>>2]=k;c[za+(s*20|0)+8>>2]=v;c[za+(s*20|0)+12>>2]=l;c[za+(s*20|0)+16>>2]=0;a[za+(s*20|0)+1>>0]=0}else Bi(Ga,53,k,v,l)|0;s=c[C>>2]|0;if((s|0)>0)b[(c[Ga+104>>2]|0)+((s+-1|0)*20|0)+2>>1]=144}if((c[B>>2]|0)>(s|0)){c[C>>2]=s+1;za=c[Ga+104>>2]|0;a[za+(s*20|0)>>0]=31;b[za+(s*20|0)+2>>1]=0;c[za+(s*20|0)+4>>2]=i;c[za+(s*20|0)+8>>2]=v;c[za+(s*20|0)+12>>2]=k;c[za+(s*20|0)+16>>2]=0;a[za+(s*20|0)+1>>0]=0}else Bi(Ga,31,i,v,k)|0;e:do switch(t|0){case 3:case 2:case 1:{Ca=151;break}case 5:{s=c[f>>2]|0;A=c[s+32>>2]|0;do if(!((0==0?(c[U+32>>2]&8192|0)==0:0)|(A&262144|0)==0&0==0)?(R=c[(c[s+16>>2]|0)+28>>2]|0,(a[f+146>>0]|0)==0):0){z=c[g+72>>2]|0;if((z|0)!=(R|0)?(x=c[R+48>>2]|0,(x|0)!=0):0){y=g+68|0;s=0;do{w=c[x+8>>2]|0;do if((c[w+24>>2]|0)==(z|0)){u=c[w+4>>2]|0;v=c[g>>2]|0;za=a[u>>0]|0;t=(d[208+(za&255)>>0]|0)-(d[208+(d[v>>0]|0)>>0]|0)|0;if(!(za<<24>>24==0|(t|0)!=0))do{u=u+1|0;v=v+1|0;za=a[u>>0]|0;t=(d[208+(za&255)>>0]|0)-(d[208+(d[v>>0]|0)>>0]|0)|0}while(!(za<<24>>24==0|(t|0)!=0));if(t|0)break;if(!s)s=c[y>>2]|0;c[w+32>>2]=s;s=w}while(0);x=c[x>>2]|0}while((x|0)!=0);if(!s)Ca=170}else Ca=170;if((Ca|0)==170){s=c[g+68>>2]|0;if(!s){Ca=176;break}}t=0;u=s;do{if((a[u+8>>0]|0)==121)t=t|d[u+9>>0];u=c[u+32>>2]|0}while((u|0)!=0);if((s|0)==0|(t|0)==0)Ca=176}else Ca=176;while(0);do if((Ca|0)==176){if(!((A&16384|0)==0&0==0)){y=c[g>>2]|0;v=c[g+72>>2]|0;w=c[v+68>>2]|0;if(!w){t=v+60|0;s=v+64|0}else{t=a[y>>0]|0;if(!(t<<24>>24))s=0;else{s=0;u=y;do{u=u+1|0;s=G(s+(d[208+(t&255)>>0]|0)|0,-1640531535)|0;t=a[u>>0]|0}while(t<<24>>24!=0)}s=(s>>>0)%((c[v+56>>2]|0)>>>0)|0;t=w+(s<<3)|0;s=w+(s<<3)+4|0}t=c[t>>2]|0;f:do if(!t)s=59292;else{x=d[208+(d[y>>0]|0)>>0]|0;while(1){s=c[s>>2]|0;t=t+-1|0;v=c[s+12>>2]|0;za=a[v>>0]|0;u=(d[208+(za&255)>>0]|0)-x|0;if(!(za<<24>>24==0|(u|0)!=0)){w=y;do{v=v+1|0;w=w+1|0;za=a[v>>0]|0;u=(d[208+(za&255)>>0]|0)-(d[208+(d[w>>0]|0)>>0]|0)|0}while(!(za<<24>>24==0|(u|0)!=0))}if(!u)break f;if(!t){s=59292;break}}}while(0);if(c[s+8>>2]|0){s=0;break}if(c[g+16>>2]|0){s=0;break}}if(!(c[g+8>>2]|0)){u=1;break e}u=c[f+116>>2]|0;a[((u|0)==0?f:u)+20>>0]=1;Km(f,g,i,j,0,-1);u=1;break e}while(0);u=c[f+116>>2]|0;a[((u|0)==0?f:u)+20>>0]=1;Gm(f,g,s,i,j,k,1,0,5,1,-1);u=1;break}case 6:{za=r+8|0;Ca=r+12|0;rj(f,gk(c[f>>2]|0,c[r+20>>2]|0,0)|0,c[za>>2]|0,c[Ca>>2]|0,2,r);c[za>>2]=0;c[Ca>>2]=0;Ca=196;break}case 4:{Ca=196;break}default:{t=2;Ca=151}}while(0);do if((Ca|0)==151){s=b[g+40>>1]|0;v=c[f>>2]|0;u=c[g>>2]|0;if(s<<16>>16>-1){s=c[(c[g+4>>2]|0)+(s<<16>>16<<4)>>2]|0;c[S>>2]=u;c[S+4>>2]=s;u=1555;s=bd(v,40358,S)|0}else{c[T>>2]=u;u=2579;s=bd(v,44808,T)|0}Sj(f,u,t,s,-7,2);u=0}else if((Ca|0)==196){s=c[C>>2]|0;if((c[B>>2]|0)>(s|0)){c[C>>2]=s+1;u=c[Ga+104>>2]|0;a[u+(s*20|0)>>0]=11;b[u+(s*20|0)+2>>1]=0;c[u+(s*20|0)+4>>2]=0;c[u+(s*20|0)+8>>2]=o;c[u+(s*20|0)+12>>2]=0;c[u+(s*20|0)+16>>2]=0;a[u+(s*20|0)+1>>0]=0;u=0;break}else{Bi(Ga,11,0,o,0)|0;u=0;break}}while(0);t=c[Ga+12>>2]|0;s=0-D|0;if(((c[t+56>>2]|0)+(c[t+60>>2]|0)|0)<0)kk(t,Ga,s);else c[(c[t+64>>2]|0)+(s<<2)>>2]=c[C>>2];if(!E){v=0;za=0}else{v=c[C>>2]|0;if((c[B>>2]|0)>(v|0)){c[C>>2]=v+1;y=c[Ga+104>>2]|0;a[y+(v*20|0)>>0]=11;y=y+(v*20|0)+1|0;z=y+19|0;do{a[y>>0]=0;y=y+1|0}while((y|0)<(z|0))}else v=Bi(Ga,11,0,0,0)|0;t=c[C>>2]|0;if(!(a[(c[Ga>>2]|0)+81>>0]|0))s=(c[Ga+104>>2]|0)+((((E|0)<1?t:E)+-1|0)*20|0)|0;else s=59308;c[s+8>>2]=t;za=E}}else{u=0;v=0;za=0}na=g+8|0;s=c[na>>2]|0;if(s){oa=Aa+1|0;pa=Ga+108|0;qa=Ga+112|0;ra=(Ba|0)==0;sa=f+56|0;ta=Ga+104|0;ua=k+1|0;va=(Aa|0)<0;wa=g+40|0;xa=~k;ya=f+52|0;ja=m<<24>>24==0;ka=Ga+12|0;la=n<<24>>24==11;ma=r+8|0;U=U+32|0;V=g+16|0;T=f+146|0;W=(Da|0)==1;m=g+72|0;X=f+19|0;Y=f+32|0;Z=f+28|0;_=g+68|0;$=r+28|0;aa=f+44|0;ba=Ea+50|0;ca=Da&65535;da=f+116|0;ea=r+20|0;fa=r+12|0;ga=Ea+4|0;ha=Ea+32|0;ia=l+1|0;S=0;w=0;t=0;while(1){H=h+(S<<2)|0;g:do if(c[H>>2]|0){Q=(Ba|0)==(s|0);if(Q){w=c[pa>>2]|0;if((c[qa>>2]|0)>(w|0)){c[pa>>2]=w+1;y=c[ta>>2]|0;a[y+(w*20|0)>>0]=11;y=y+(w*20|0)+1|0;z=y+19|0;do{a[y>>0]=0;y=y+1|0}while((y|0)<(z|0));y=w}else y=Bi(Ga,11,0,0,0)|0;x=c[pa>>2]|0;if(!(a[(c[Ga>>2]|0)+81>>0]|0))w=(c[ta>>2]|0)+((va?x+-1|0:Aa)*20|0)|0;else w=59308;c[w+8>>2]=x;q=oa}else{q=(c[sa>>2]|0)+-1|0;c[sa>>2]=q;y=w}if((ra|Q)&t<<24>>24==0){xk(Ga,g,ua);R=1}else R=t;O=S+j|0;t=s+36|0;if(c[t>>2]|0){w=c[H>>2]|0;x=c[pa>>2]|0;if((c[qa>>2]|0)>(x|0)){c[pa>>2]=x+1;P=c[ta>>2]|0;a[P+(x*20|0)>>0]=73;b[P+(x*20|0)+2>>1]=0;c[P+(x*20|0)+4>>2]=0;c[P+(x*20|0)+8>>2]=w;c[P+(x*20|0)+12>>2]=0;c[P+(x*20|0)+16>>2]=0;a[P+(x*20|0)+1>>0]=0}else Bi(Ga,73,0,w,0)|0;c[ya>>2]=xa;t=c[t>>2]|0;w=c[f>>2]|0;if(!t)t=0;else t=bk(w,t,0,0)|0;if(!(a[w+81>>0]|0))Rj(f,t,q,16);if(t|0)li(w,t);c[ya>>2]=0}t=c[H>>2]|0;P=t+1|0;N=s+52|0;if(!(b[N>>1]|0))x=0;else{E=s+4|0;F=s+40|0;D=0;do{t=b[(c[E>>2]|0)+(D<<1)>>1]|0;switch(t<<16>>16){case -2:{c[ya>>2]=xa;t=c[(c[F>>2]|0)+4+(D*20|0)>>2]|0;A=D+P|0;C=c[f>>2]|0;if(!t)B=0;else B=bk(C,t,0,0)|0;h:do if(!(a[C+81>>0]|0)){do if(B){if((a[B>>0]|0)!=-88){z=Hj(f,B,A)|0;break}t=c[Ia>>2]|0;w=c[B+28>>2]|0;x=t+108|0;z=c[x>>2]|0;if((c[t+112>>2]|0)>(z|0)){c[x>>2]=z+1;Ca=c[t+104>>2]|0;a[Ca+(z*20|0)>>0]=78;b[Ca+(z*20|0)+2>>1]=0;c[Ca+(z*20|0)+4>>2]=w;c[Ca+(z*20|0)+8>>2]=A;c[Ca+(z*20|0)+12>>2]=0;c[Ca+(z*20|0)+16>>2]=0;a[Ca+(z*20|0)+1>>0]=0;Ca=252;break h}else{Bi(t,78,w,A,0)|0;Ca=252;break h}}else z=Hj(f,0,A)|0;while(0);if((z|0)==(A|0)){Ca=251;break}t=c[Ia>>2]|0;if(!t){Ca=251;break}w=t+108|0;x=c[w>>2]|0;if((c[t+112>>2]|0)>(x|0)){c[w>>2]=x+1;Ca=c[t+104>>2]|0;a[Ca+(x*20|0)>>0]=79;b[Ca+(x*20|0)+2>>1]=0;c[Ca+(x*20|0)+4>>2]=z;c[Ca+(x*20|0)+8>>2]=A;c[Ca+(x*20|0)+12>>2]=0;c[Ca+(x*20|0)+16>>2]=0;a[Ca+(x*20|0)+1>>0]=0;Ca=251;break}else{Bi(t,79,z,A,0)|0;Ca=251;break}}else Ca=251;while(0);if((Ca|0)==251?(Ca=0,B|0):0)Ca=252;if((Ca|0)==252){Ca=0;li(C,B)}c[ya>>2]=0;break}case -1:{z=k;Ca=255;break}default:{z=t<<16>>16==(b[wa>>1]|0)?k:ua+(t<<16>>16)|0;Ca=255}}do if((Ca|0)==255){Ca=0;x=((t&65535)>>>15)+79<<16>>16;t=D+P|0;w=c[pa>>2]|0;if((c[qa>>2]|0)>(w|0)){c[pa>>2]=w+1;M=c[ta>>2]|0;a[M+(w*20|0)>>0]=x;b[M+(w*20|0)+2>>1]=0;c[M+(w*20|0)+4>>2]=z;c[M+(w*20|0)+8>>2]=t;c[M+(w*20|0)+12>>2]=0;c[M+(w*20|0)+16>>2]=0;a[M+(w*20|0)+1>>0]=0;break}else{Bi(Ga,x&65535,z,t,0)|0;break}}while(0);D=D+1|0;t=b[N>>1]|0}while(D>>>0<(t&65535)>>>0);x=t&65535;t=c[H>>2]|0}w=c[pa>>2]|0;if((c[qa>>2]|0)>(w|0)){c[pa>>2]=w+1;M=c[ta>>2]|0;a[M+(w*20|0)>>0]=92;b[M+(w*20|0)+2>>1]=0;c[M+(w*20|0)+4>>2]=P;c[M+(w*20|0)+8>>2]=x;c[M+(w*20|0)+12>>2]=t;c[M+(w*20|0)+16>>2]=0;a[M+(w*20|0)+1>>0]=0}else Bi(Ga,92,P,x,t)|0;F=(Ea|0)==(s|0);if(ja&(Ha&F)){w=c[ka>>2]|0;t=~q;if(((c[w+56>>2]|0)+(c[w+60>>2]|0)|0)<0){kk(w,Ga,t);w=y;t=R;break}else{c[(c[w+64>>2]|0)+(t<<2)>>2]=c[pa>>2];w=y;t=R;break}}t=a[s+54>>0]|0;if(!(t<<24>>24)){w=c[ka>>2]|0;t=~q;if(((c[w+56>>2]|0)+(c[w+60>>2]|0)|0)<0){kk(w,Ga,t);w=y;t=R;break}else{c[(c[w+64>>2]|0)+(t<<2)>>2]=c[pa>>2];w=y;t=R;break}}if(Q)E=(c[ma>>2]|0)==0?4:6;else E=(la?(t<<24>>24==11?2:t):n)&255;i:do if(!S){if(!(F&(E|0)==5&(c[s+20>>2]|0)==0))break;D=c[U>>2]|0;do if(!((D&8192|0)==0&0==0)){t=c[f>>2]|0;if(0==0?(c[t+32>>2]&262144|0)==0:0)break;t=c[(c[t+16>>2]|0)+28>>2]|0;if(a[T>>0]|0)break;C=c[m>>2]|0;do if((C|0)!=(t|0)){t=c[t+48>>2]|0;if(!t){Ca=291;break}B=t;t=0;do{A=c[B+8>>2]|0;do if((c[A+24>>2]|0)==(C|0)){x=c[A+4>>2]|0;z=c[g>>2]|0;M=a[x>>0]|0;w=(d[208+(M&255)>>0]|0)-(d[208+(d[z>>0]|0)>>0]|0)|0;if(!(M<<24>>24==0|(w|0)!=0))do{x=x+1|0;z=z+1|0;M=a[x>>0]|0;w=(d[208+(M&255)>>0]|0)-(d[208+(d[z>>0]|0)>>0]|0)|0}while(!(M<<24>>24==0|(w|0)!=0));if(w|0)break;if(!t)t=c[_>>2]|0;c[A+32>>2]=t;t=A}while(0);B=c[B>>2]|0}while((B|0)!=0);if(!t)Ca=291}else Ca=291;while(0);if((Ca|0)==291){Ca=0;t=c[_>>2]|0;if(!t)break}w=0;x=t;do{if((a[x+8>>0]|0)==121)w=w|d[x+9>>0];x=c[x+32>>2]|0}while((x|0)!=0);if(!((t|0)==0|(w|0)==0))break i}while(0);if(!((D&16384|0)==0&0==0)){if(c[V>>2]|0)break;C=c[g>>2]|0;z=c[m>>2]|0;A=c[z+68>>2]|0;if(!A){w=z+60|0;t=z+64|0}else{w=a[C>>0]|0;if(!(w<<24>>24))t=0;else{t=0;x=C;do{x=x+1|0;t=G(t+(d[208+(w&255)>>0]|0)|0,-1640531535)|0;w=a[x>>0]|0}while(w<<24>>24!=0)}t=(t>>>0)%((c[z+56>>2]|0)>>>0)|0;w=A+(t<<3)|0;t=A+(t<<3)+4|0}w=c[w>>2]|0;j:do if(!w)t=59292;else{B=d[208+(d[C>>0]|0)>>0]|0;while(1){t=c[t>>2]|0;w=w+-1|0;z=c[t+12>>2]|0;M=a[z>>0]|0;x=(d[208+(M&255)>>0]|0)-B|0;if(!(M<<24>>24==0|(x|0)!=0)){A=C;do{z=z+1|0;A=A+1|0;M=a[z>>0]|0;x=(d[208+(M&255)>>0]|0)-(d[208+(d[A>>0]|0)>>0]|0)|0}while(!(M<<24>>24==0|(x|0)!=0))}if(!x)break j;if(!w){t=59292;break}}}while(0);if(c[t+8>>2]|0)break}w=c[ka>>2]|0;t=~q;if(((c[w+56>>2]|0)+(c[w+60>>2]|0)|0)<0){kk(w,Ga,t);w=y;t=R;break g}else{c[(c[w+64>>2]|0)+(t<<2)>>2]=c[pa>>2];w=y;t=R;break g}}while(0);w=e[s+50>>1]|0;t=c[pa>>2]|0;if((c[qa>>2]|0)>(t|0)){c[pa>>2]=t+1;M=c[ta>>2]|0;a[M+(t*20|0)>>0]=27;b[M+(t*20|0)+2>>1]=0;c[M+(t*20|0)+4>>2]=O;c[M+(t*20|0)+8>>2]=q;c[M+(t*20|0)+12>>2]=P;c[M+(t*20|0)+16>>2]=0;a[M+(t*20|0)+1>>0]=0}else t=Bi(Ga,27,O,q,P)|0;if(!(a[(c[Ga>>2]|0)+81>>0]|0)){M=c[ta>>2]|0;a[M+(t*20|0)+1>>0]=-3;c[M+(t*20|0)+16>>2]=w}do if(!F)if(W){t=a[X>>0]|0;if(!(t<<24>>24)){M=(c[aa>>2]|0)+1|0;c[aa>>2]=M;break}else{M=t+-1<<24>>24;a[X>>0]=M;M=c[f+148+((M&255)<<2)>>2]|0;break}}else{t=c[Y>>2]|0;w=c[Z>>2]|0;if((w|0)<(Da|0)){M=c[aa>>2]|0;c[aa>>2]=M+Da;M=M+1|0;break}else{c[Y>>2]=t+Da;c[Z>>2]=w-Da;M=t;break}}else M=P;while(0);do if(Ha|(E|0)==5){if(!(c[Fa>>2]&32)){t=c[pa>>2]|0;if((c[qa>>2]|0)>(t|0)){c[pa>>2]=t+1;L=c[ta>>2]|0;a[L+(t*20|0)>>0]=-121;b[L+(t*20|0)+2>>1]=0;c[L+(t*20|0)+4>>2]=O;c[L+(t*20|0)+8>>2]=M;c[L+(t*20|0)+12>>2]=0;c[L+(t*20|0)+16>>2]=0;a[L+(t*20|0)+1>>0]=0}else Bi(Ga,135,O,M,0)|0;if(!Ha)break;t=c[pa>>2]|0;if((c[qa>>2]|0)>(t|0)){c[pa>>2]=t+1;L=c[ta>>2]|0;a[L+(t*20|0)>>0]=53;b[L+(t*20|0)+2>>1]=0;c[L+(t*20|0)+4>>2]=M;c[L+(t*20|0)+8>>2]=q;c[L+(t*20|0)+12>>2]=l;c[L+(t*20|0)+16>>2]=0;a[L+(t*20|0)+1>>0]=0}else Bi(Ga,53,M,q,l)|0;t=c[pa>>2]|0;if((t|0)<=0)break;b[(c[ta>>2]|0)+((t+-1|0)*20|0)+2>>1]=144;break}do if(!F){if(!(b[ba>>1]|0))break;B=s+4|0;A=0;do{x=b[(c[ga>>2]|0)+(A<<1)>>1]|0;t=b[N>>1]|0;k:do if(!(t<<16>>16))t=-1;else{z=c[B>>2]|0;w=t&65535;t=0;while(1){if((b[z+(t<<1)>>1]|0)==x<<16>>16)break k;t=t+1|0;if(t>>>0>=w>>>0){t=-1;break}}}while(0);t=t<<16>>16;w=A+M|0;x=c[pa>>2]|0;if((c[qa>>2]|0)>(x|0)){c[pa>>2]=x+1;L=c[ta>>2]|0;a[L+(x*20|0)>>0]=90;b[L+(x*20|0)+2>>1]=0;c[L+(x*20|0)+4>>2]=O;c[L+(x*20|0)+8>>2]=t;c[L+(x*20|0)+12>>2]=w;c[L+(x*20|0)+16>>2]=0;a[L+(x*20|0)+1>>0]=0}else Bi(Ga,90,O,t,w)|0;A=A+1|0}while(A>>>0<(e[ba>>1]|0)>>>0)}while(0);if(!Ha)break;D=s+55|0;D=((d[D>>0]|d[D+1>>0]<<8)&3)==2?P:M;t=b[ba>>1]|0;if(!(t<<16>>16))break;C=52;A=(c[pa>>2]|0)+(t&65535)|0;B=0;do{t=c[(c[ha>>2]|0)+(B<<2)>>2]|0;x=c[f>>2]|0;w=a[x+78>>0]|0;L=a[x+165>>0]|0;x=Xi(x,w,t,L&255)|0;do if(!(L<<24>>24)){if(!x){x=Yi(f,w,0,t)|0;break}if(c[x+12>>2]|0)break;x=Yi(f,w,x,t)|0}while(0);w=(B|0)==((e[ba>>1]|0)+-1|0);A=w?q:A;C=w?53:C;w=ia+(b[(c[ga>>2]|0)+(B<<1)>>1]|0)|0;z=B+D|0;t=c[pa>>2]|0;if((c[qa>>2]|0)>(t|0)){c[pa>>2]=t+1;L=c[ta>>2]|0;a[L+(t*20|0)>>0]=C;b[L+(t*20|0)+2>>1]=0;c[L+(t*20|0)+4>>2]=w;c[L+(t*20|0)+8>>2]=A;c[L+(t*20|0)+12>>2]=z;c[L+(t*20|0)+16>>2]=0;a[L+(t*20|0)+1>>0]=0}else t=Bi(Ga,C,w,A,z)|0;do if(!(a[(c[Ga>>2]|0)+81>>0]|0)){if((t|0)<0)t=(c[pa>>2]|0)+-1|0;w=c[ta>>2]|0;z=w+(t*20|0)+1|0;if(a[z>>0]|0){Ci(Ga,w+(t*20|0)|0,x,-2);break}if(!x)break;c[w+(t*20|0)+16>>2]=x;a[z>>0]=-2}while(0);t=c[pa>>2]|0;if((t|0)>0)b[(c[ta>>2]|0)+((t+-1|0)*20|0)+2>>1]=144;B=B+1|0}while(B>>>0<(e[ba>>1]|0)>>>0)}while(0);switch((E&255)<<24>>24){case 3:case 2:case 1:{dl(f,E,s);break}case 6:{K=c[Ia>>2]|0;L=c[f>>2]|0;J=c[$>>2]|0;do if((J|0)!=(O|0)){if(!(c[Fa>>2]&32)){t=a[X>>0]|0;if(!(t<<24>>24)){z=(c[aa>>2]|0)+1|0;c[aa>>2]=z}else{z=t+-1<<24>>24;a[X>>0]=z;z=c[f+148+((z&255)<<2)>>2]|0}w=K+108|0;t=c[w>>2]|0;x=K+112|0;if((c[x>>2]|0)>(t|0)){c[w>>2]=t+1;Ca=c[K+104>>2]|0;a[Ca+(t*20|0)>>0]=-121;b[Ca+(t*20|0)+2>>1]=0;c[Ca+(t*20|0)+4>>2]=O;c[Ca+(t*20|0)+8>>2]=z;c[Ca+(t*20|0)+12>>2]=0;c[Ca+(t*20|0)+16>>2]=0;a[Ca+(t*20|0)+1>>0]=0}else Bi(K,135,O,z,0)|0;t=c[w>>2]|0;if((c[x>>2]|0)>(t|0)){c[w>>2]=t+1;Ca=c[K+104>>2]|0;a[Ca+(t*20|0)>>0]=30;b[Ca+(t*20|0)+2>>1]=0;c[Ca+(t*20|0)+4>>2]=J;c[Ca+(t*20|0)+8>>2]=0;c[Ca+(t*20|0)+12>>2]=z;c[Ca+(t*20|0)+16>>2]=0;a[Ca+(t*20|0)+1>>0]=0}else Bi(K,30,J,0,z)|0;if(!z)break;t=a[X>>0]|0;if((t&255)>=8)break;a[X>>0]=t+1<<24>>24;c[f+148+((t&255)<<2)>>2]=z;break}t=c[na>>2]|0;l:do if(!t)t=0;else while(1){Ca=t+55|0;if(((d[Ca>>0]|d[Ca+1>>0]<<8)&3)==2)break l;t=c[t+20>>2]|0;if(!t){t=0;break}}while(0);Ca=b[t+50>>1]|0;I=Ca&65535;F=c[aa>>2]|0;H=F+1|0;c[aa>>2]=F+I;if(!(Ca<<16>>16)){A=K+108|0;w=K+112|0}else{D=t+4|0;A=K+108|0;w=K+112|0;E=s+4|0;F=K+104|0;C=0;do{z=b[(c[D>>2]|0)+(C<<1)>>1]|0;t=b[N>>1]|0;m:do if(!(t<<16>>16))t=-1;else{B=c[E>>2]|0;x=t&65535;t=0;while(1){if((b[B+(t<<1)>>1]|0)==z<<16>>16)break m;t=t+1|0;if(t>>>0>=x>>>0){t=-1;break}}}while(0);t=t<<16>>16;x=C+H|0;z=c[A>>2]|0;if((c[w>>2]|0)>(z|0)){c[A>>2]=z+1;Ca=c[F>>2]|0;a[Ca+(z*20|0)>>0]=90;b[Ca+(z*20|0)+2>>1]=0;c[Ca+(z*20|0)+4>>2]=O;c[Ca+(z*20|0)+8>>2]=t;c[Ca+(z*20|0)+12>>2]=x;c[Ca+(z*20|0)+16>>2]=0;a[Ca+(z*20|0)+1>>0]=0}else Bi(K,90,O,t,x)|0;C=C+1|0}while((C|0)!=(I|0))}t=c[A>>2]|0;if((c[w>>2]|0)>(t|0)){c[A>>2]=t+1;z=c[K+104>>2]|0;a[z+(t*20|0)>>0]=29;b[z+(t*20|0)+2>>1]=0;c[z+(t*20|0)+4>>2]=J;c[z+(t*20|0)+8>>2]=0;c[z+(t*20|0)+12>>2]=H;c[z+(t*20|0)+16>>2]=0;a[z+(t*20|0)+1>>0]=0;z=t}else z=Bi(K,29,J,0,H)|0;if(!(a[(c[K>>2]|0)+81>>0]|0)){Ca=c[K+104>>2]|0;a[Ca+(z*20|0)+1>>0]=-3;c[Ca+(z*20|0)+16>>2]=I}t=c[A>>2]|0;if((c[w>>2]|0)>(t|0)){c[A>>2]=t+1;Ca=c[K+104>>2]|0;a[Ca+(t*20|0)>>0]=69;b[Ca+(t*20|0)+2>>1]=0;c[Ca+(t*20|0)+4>>2]=11;c[Ca+(t*20|0)+8>>2]=2;c[Ca+(t*20|0)+12>>2]=0;c[Ca+(t*20|0)+16>>2]=0;a[Ca+(t*20|0)+1>>0]=0}else t=Bi(K,69,11,2,0)|0;do if(!(a[(c[K>>2]|0)+81>>0]|0)){if((t|0)<0)t=(c[A>>2]|0)+-1|0;w=c[K+104>>2]|0;x=w+(t*20|0)+1|0;if(!(a[x>>0]|0)){c[w+(t*20|0)+16>>2]=39404;a[x>>0]=-1;break}else{Ci(K,w+(t*20|0)|0,39404,-1);break}}while(0);w=c[A>>2]|0;if(!(a[(c[K>>2]|0)+81>>0]|0))t=(c[K+104>>2]|0)+(((z|0)<0?w+-1|0:z)*20|0)|0;else t=59308;c[t+8>>2]=w}while(0);rj(f,gk(L,c[ea>>2]|0,0)|0,c[ma>>2]|0,c[fa>>2]|0,2,r);c[ma>>2]=0;c[fa>>2]=0;Ca=421;break}case 4:{Ca=421;break}default:{t=c[f>>2]|0;C=c[t+32>>2]|0;do if(!((c[U>>2]&8192|0)==0&0==0|(C&262144|0)==0&0==0)){t=c[(c[t+16>>2]|0)+28>>2]|0;if(a[T>>0]|0){Ca=445;break}B=c[m>>2]|0;do if((B|0)!=(t|0)){t=c[t+48>>2]|0;if(!t){Ca=439;break}A=t;t=0;do{z=c[A+8>>2]|0;do if((c[z+24>>2]|0)==(B|0)){w=c[z+4>>2]|0;x=c[g>>2]|0;N=a[w>>0]|0;u=(d[208+(N&255)>>0]|0)-(d[208+(d[x>>0]|0)>>0]|0)|0;if(!(N<<24>>24==0|(u|0)!=0))do{w=w+1|0;x=x+1|0;N=a[w>>0]|0;u=(d[208+(N&255)>>0]|0)-(d[208+(d[x>>0]|0)>>0]|0)|0}while(!(N<<24>>24==0|(u|0)!=0));if(u|0)break;if(!t)t=c[_>>2]|0;c[z+32>>2]=t;t=z}while(0);A=c[A>>2]|0}while((A|0)!=0);if(!t)Ca=439}else Ca=439;while(0);if((Ca|0)==439){t=c[_>>2]|0;if(!t){Ca=445;break}}u=0;w=t;do{if((a[w+8>>0]|0)==121)u=u|d[w+9>>0];w=c[w+32>>2]|0}while((w|0)!=0);if(!((t|0)==0|(u|0)==0))Ca=461;else Ca=445}else Ca=445;while(0);do if((Ca|0)==445){Ca=0;if((C&16384|0)==0&0==0){t=0;break}B=c[g>>2]|0;x=c[m>>2]|0;z=c[x+68>>2]|0;if(!z){u=x+60|0;t=x+64|0}else{u=a[B>>0]|0;if(!(u<<24>>24))t=0;else{t=0;w=B;do{w=w+1|0;t=G(t+(d[208+(u&255)>>0]|0)|0,-1640531535)|0;u=a[w>>0]|0}while(u<<24>>24!=0)}t=(t>>>0)%((c[x+56>>2]|0)>>>0)|0;u=z+(t<<3)|0;t=z+(t<<3)+4|0}u=c[u>>2]|0;n:do if(!u)t=59292;else{A=d[208+(d[B>>0]|0)>>0]|0;while(1){t=c[t>>2]|0;u=u+-1|0;x=c[t+12>>2]|0;N=a[x>>0]|0;w=(d[208+(N&255)>>0]|0)-A|0;if(!(N<<24>>24==0|(w|0)!=0)){z=B;do{x=x+1|0;z=z+1|0;N=a[x>>0]|0;w=(d[208+(N&255)>>0]|0)-(d[208+(d[z>>0]|0)>>0]|0)|0}while(!(N<<24>>24==0|(w|0)!=0))}if(!w)break n;if(!u){t=59292;break}}}while(0);if(c[t+8>>2]|0){t=0;Ca=461;break}if(!(c[V>>2]|0))t=0;else{t=0;Ca=461}}while(0);if((Ca|0)==461){Ca=0;N=c[da>>2]|0;a[((N|0)==0?f:N)+20>>0]=1}Gm(f,g,t,i,j,M,ca,0,5,F&1,O);u=1}}do if((Ca|0)==421){Ca=0;t=c[pa>>2]|0;if((c[qa>>2]|0)>(t|0)){c[pa>>2]=t+1;O=c[ta>>2]|0;a[O+(t*20|0)>>0]=11;b[O+(t*20|0)+2>>1]=0;c[O+(t*20|0)+4>>2]=0;c[O+(t*20|0)+8>>2]=o;c[O+(t*20|0)+12>>2]=0;c[O+(t*20|0)+16>>2]=0;a[O+(t*20|0)+1>>0]=0;break}else{Bi(Ga,11,0,o,0)|0;break}}while(0);do if(!Q){w=c[ka>>2]|0;t=~q;if(((c[w+56>>2]|0)+(c[w+60>>2]|0)|0)<0){kk(w,Ga,t);break}else{c[(c[w+64>>2]|0)+(t<<2)>>2]=c[pa>>2];break}}else{t=c[pa>>2]|0;if((c[qa>>2]|0)>(t|0)){c[pa>>2]=t+1;Q=c[ta>>2]|0;a[Q+(t*20|0)>>0]=11;b[Q+(t*20|0)+2>>1]=0;c[Q+(t*20|0)+4>>2]=0;c[Q+(t*20|0)+8>>2]=oa;c[Q+(t*20|0)+12>>2]=0;c[Q+(t*20|0)+16>>2]=0;a[Q+(t*20|0)+1>>0]=0}else Bi(Ga,11,0,oa,0)|0;w=c[pa>>2]|0;if(!(a[(c[Ga>>2]|0)+81>>0]|0))t=(c[ta>>2]|0)+(((y|0)<0?w+-1|0:y)*20|0)|0;else t=59308;c[t+8>>2]=w}while(0);if((M|0)==(P|0)){w=y;t=R;break}if(!W){if((c[Z>>2]|0)>=(Da|0)){w=y;t=R;break}c[Z>>2]=Da;c[Y>>2]=M;w=y;t=R;break}if(!M){w=y;t=R;break}t=a[X>>0]|0;if((t&255)>=8){w=y;t=R;break}a[X>>0]=t+1<<24>>24;c[f+148+((t&255)<<2)>>2]=M;w=y;t=R}while(0);s=c[s+20>>2]|0;if(!s)break;else S=S+1|0}}if(!za){c[p>>2]=u;Qa=Ja;return}s=Ga+108|0;t=c[s>>2]|0;if((c[Ga+112>>2]|0)>(t|0)){c[s>>2]=t+1;o=c[Ga+104>>2]|0;a[o+(t*20|0)>>0]=11;b[o+(t*20|0)+2>>1]=0;c[o+(t*20|0)+4>>2]=0;c[o+(t*20|0)+8>>2]=za;c[o+(t*20|0)+12>>2]=0;c[o+(t*20|0)+16>>2]=0;a[o+(t*20|0)+1>>0]=0}else Bi(Ga,11,0,za,0)|0;t=c[s>>2]|0;if(!(a[(c[Ga>>2]|0)+81>>0]|0))s=(c[Ga+104>>2]|0)+(((v|0)<0?t+-1|0:v)*20|0)|0;else s=59308;c[s+8>>2]=t;c[p>>2]=u;Qa=Ja;return}function Sm(f,g,h,i,j,k,l,m,n){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;t=f+8|0;o=c[t>>2]|0;a:do if(!o){s=c[f>>2]|0;if((c[f+116>>2]|0)==0?(b[s+76>>1]&8)==0:0)a[f+23>>0]=1;b:do if(c[s+272>>2]|0)if(!(a[s+81>>0]|0))r=15;else{C=0;break a}else{do if((e[s+276>>1]|0)>=224){o=s+300|0;p=c[o>>2]|0;if(p|0){c[o>>2]=c[p>>2];q=s+284|0;c[q>>2]=(c[q>>2]|0)+1;q=p;break b}o=s+296|0;p=c[o>>2]|0;if(!p){o=s+292|0;break}else{c[o>>2]=c[p>>2];q=s+284|0;c[q>>2]=(c[q>>2]|0)+1;q=p;break b}}else o=s+288|0;while(0);c[o>>2]=(c[o>>2]|0)+1;r=15}while(0);if((r|0)==15)q=Yd(s,224,0)|0;if(!q)C=0;else{o=q+104|0;p=o+120|0;do{c[o>>2]=0;o=o+4|0}while((o|0)<(p|0));c[q>>2]=s;o=s+4|0;p=c[o>>2]|0;if(p|0)c[p+4>>2]=q;c[q+8>>2]=p;c[q+4>>2]=0;c[o>>2]=q;c[q+20>>2]=381479589;c[q+12>>2]=f;c[t>>2]=q;Bi(q,61,0,1,0)|0;C=q}}else C=o;while(0);p=c[g+8>>2]|0;if(!p){u=0;o=g+36|0}else{y=(n|0)==0?0:16;x=C+108|0;z=C+112|0;o=g+36|0;A=C+104|0;B=(l&2|(y|1)&255)&255;w=0;u=0;while(1){t=k+(w<<2)|0;s=c[t>>2]|0;if(s){do if(c[p+36>>2]|0){q=c[x>>2]|0;r=q+2|0;if((c[z>>2]|0)>(q|0)){c[x>>2]=q+1;v=c[A>>2]|0;a[v+(q*20|0)>>0]=50;b[v+(q*20|0)+2>>1]=0;c[v+(q*20|0)+4>>2]=s;c[v+(q*20|0)+8>>2]=r;c[v+(q*20|0)+12>>2]=0;c[v+(q*20|0)+16>>2]=0;a[v+(q*20|0)+1>>0]=0;break}else{Bi(C,50,s,r,0)|0;break}}while(0);q=p+55|0;q=d[q>>0]|d[q+1>>0]<<8;if((q&3)==2)v=(c[o>>2]&32|0)==0?y:B;else v=y;u=w+i|0;s=c[t>>2]|0;t=s+1|0;r=e[((q&8)==0?p+52|0:p+50|0)>>1]|0;q=c[x>>2]|0;if((c[z>>2]|0)>(q|0)){c[x>>2]=q+1;D=c[A>>2]|0;a[D+(q*20|0)>>0]=-124;b[D+(q*20|0)+2>>1]=0;c[D+(q*20|0)+4>>2]=u;c[D+(q*20|0)+8>>2]=s;c[D+(q*20|0)+12>>2]=t;c[D+(q*20|0)+16>>2]=0;a[D+(q*20|0)+1>>0]=0}else q=Bi(C,132,u,s,t)|0;if(!(a[(c[C>>2]|0)+81>>0]|0)){D=c[A>>2]|0;a[D+(q*20|0)+1>>0]=-3;c[D+(q*20|0)+16>>2]=r}q=c[x>>2]|0;if((q|0)>0){b[(c[A>>2]|0)+((q+-1|0)*20|0)+2>>1]=v&255;u=1}else u=1}p=c[p+20>>2]|0;if(!p)break;else w=w+1|0}}if(c[o>>2]&32|0)return;q=j+1|0;o=f+19|0;p=a[o>>0]|0;if(!(p<<24>>24)){D=f+44|0;r=(c[D>>2]|0)+1|0;c[D>>2]=r}else{r=p+-1<<24>>24;a[o>>0]=r;r=c[f+148+((r&255)<<2)>>2]|0}o=b[g+42>>1]|0;s=C+108|0;p=c[s>>2]|0;t=C+112|0;if((c[t>>2]|0)>(p|0)){c[s>>2]=p+1;D=c[C+104>>2]|0;a[D+(p*20|0)>>0]=92;b[D+(p*20|0)+2>>1]=0;c[D+(p*20|0)+4>>2]=q;c[D+(p*20|0)+8>>2]=o;c[D+(p*20|0)+12>>2]=r;c[D+(p*20|0)+16>>2]=0;a[D+(p*20|0)+1>>0]=0}else Bi(C,92,q,o,r)|0;if(!(u<<24>>24))xk(C,g,0);q=f+18|0;p=(a[q>>0]|0)==0?((l|0)==0?33:(l|1)&255):0;p=(m|0)==0?p:p|8;p=(n|0)==0?p:p|16;o=c[s>>2]|0;if((c[t>>2]|0)>(o|0)){c[s>>2]=o+1;D=c[C+104>>2]|0;a[D+(o*20|0)>>0]=122;b[D+(o*20|0)+2>>1]=0;c[D+(o*20|0)+4>>2]=h;c[D+(o*20|0)+8>>2]=r;c[D+(o*20|0)+12>>2]=j;c[D+(o*20|0)+16>>2]=0;a[D+(o*20|0)+1>>0]=0}else Bi(C,122,h,r,j)|0;if((a[q>>0]|0)==0?(a[(c[C>>2]|0)+81>>0]|0)==0:0){j=c[C+104>>2]|0;D=(c[s>>2]|0)+-1|0;a[j+(D*20|0)+1>>0]=-6;c[j+(D*20|0)+16>>2]=g}o=c[s>>2]|0;if((o|0)<=0)return;b[(c[C+104>>2]|0)+((o+-1|0)*20|0)+2>>1]=p&255;return}function Tm(d,e){d=d|0;e=e|0;if((a[e>>0]|0)!=-94)return 0;e=b[e+32>>1]|0;if(e<<16>>16<=-1){d=d+20|0;a[d>>0]=a[d>>0]|2;return 0}if((c[(c[d+24>>2]|0)+(e<<16>>16<<2)>>2]|0)<=-1)return 0;d=d+20|0;a[d>>0]=a[d>>0]|1;return 0}function Um(d,f,g){d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;if(!(c[g+36>>2]&8)){l=0;return l|0}j=c[d>>2]|0;if(c[j+24>>2]&4|0){l=0;return l|0}k=c[d+116>>2]|0;k=(k|0)==0?d:k;i=c[(c[(c[j+16>>2]|0)+(f<<4)+12>>2]|0)+72>>2]|0;if(((i|0?(c[i+36>>2]&32|0)==0:0)?(c[i+56>>2]|0)==0:0)?(b[i+42>>1]|0)==2:0){i=k+112|0;d=c[i>>2]|0;a:do if(!d)l=12;else while(1){if((c[d+4>>2]|0)==(g|0))break a;d=c[d>>2]|0;if(!d){l=12;break}}while(0);do if((l|0)==12){b:do if(c[j+272>>2]|0)if(!(a[j+81>>0]|0))l=22;else{l=0;return l|0}else{do if((e[j+276>>1]|0)>=16){h=j+300|0;d=c[h>>2]|0;if(d|0){c[h>>2]=c[d>>2];j=j+284|0;c[j>>2]=(c[j>>2]|0)+1;break b}h=j+296|0;d=c[h>>2]|0;if(!d){d=j+292|0;break}else{c[h>>2]=c[d>>2];j=j+284|0;c[j>>2]=(c[j>>2]|0)+1;break b}}else d=j+288|0;while(0);c[d>>2]=(c[d>>2]|0)+1;l=22}while(0);if((l|0)==22)d=Yd(j,16,0)|0;if(!d){l=0;return l|0}else{c[d>>2]=c[i>>2];c[i>>2]=d;c[d+4>>2]=g;c[d+8>>2]=f;l=k+44|0;k=c[l>>2]|0;c[d+12>>2]=k+2;c[l>>2]=k+4;break}}while(0);l=c[d+12>>2]|0;return l|0}l=d+36|0;c[l>>2]=(c[l>>2]|0)+1;c[d+12>>2]=523;l=0;return l|0}function Vm(f,g){f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;h=b[f+50>>1]|0;t=g+50|0;if(h<<16>>16!=(b[t>>1]|0)){g=0;return g|0}if((a[f+54>>0]|0)!=(a[g+54>>0]|0)){g=0;return g|0}a:do if(h<<16>>16){l=g+4|0;m=f+4|0;n=g+40|0;o=f+40|0;p=g+28|0;q=f+28|0;r=g+32|0;s=f+32|0;k=0;while(1){h=b[(c[l>>2]|0)+(k<<1)>>1]|0;if(h<<16>>16!=(b[(c[m>>2]|0)+(k<<1)>>1]|0)){h=0;i=18;break}if(h<<16>>16==-2?$j(0,c[(c[n>>2]|0)+4+(k*20|0)>>2]|0,c[(c[o>>2]|0)+4+(k*20|0)>>2]|0,-1)|0:0){h=0;i=18;break}if((a[(c[p>>2]|0)+k>>0]|0)!=(a[(c[q>>2]|0)+k>>0]|0)){h=0;i=18;break}i=c[(c[r>>2]|0)+(k<<2)>>2]|0;j=c[(c[s>>2]|0)+(k<<2)>>2]|0;if(i){if(!j){h=0;i=18;break}u=a[i>>0]|0;h=(d[208+(u&255)>>0]|0)-(d[208+(d[j>>0]|0)>>0]|0)|0;if(!(u<<24>>24==0|(h|0)!=0))do{i=i+1|0;j=j+1|0;u=a[i>>0]|0;h=(d[208+(u&255)>>0]|0)-(d[208+(d[j>>0]|0)>>0]|0)|0}while(!(u<<24>>24==0|(h|0)!=0))}else h=((j|0)!=0)<<31>>31;k=k+1|0;if(h|0){h=0;i=18;break}if(k>>>0>=(e[t>>1]|0)>>>0)break a}if((i|0)==18)return h|0}while(0);u=($j(0,c[g+36>>2]|0,c[f+36>>2]|0,-1)|0)==0&1;return u|0}function Wm(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;b=c[a+12>>2]|0;if(!b)b=0;else{b=c[b+24>>2]|0;b=(b|0)>0?b:0}d=c[a+16>>2]|0;if(d){k=c[d+24>>2]|0;b=(k|0)>(b|0)?k:b}j=a+4|0;k=c[j>>2]|0;d=a+20|0;if(!(k&2048)){h=c[d>>2]|0;if(!h){m=b;m=m+1|0;a=a+24|0;c[a>>2]=m;return}i=c[h>>2]|0;g=(i|0)>0;if(g){f=0;e=i;while(1){d=c[h+4+(f*20|0)>>2]|0;if(!d)d=e;else{m=c[d+24>>2]|0;d=(m|0)>(b|0);b=d?m:b;d=d?i:e}f=f+1|0;if((f|0)>=(d|0))break;else e=d}if(g){d=0;e=0;do{d=c[(c[h+4+(e*20|0)>>2]|0)+4>>2]|d;e=e+1|0}while((e|0)!=(i|0));d=d&2097412}else d=0}else d=0;c[j>>2]=d|k;m=b;m=m+1|0;a=a+24|0;c[a>>2]=m;return}d=c[d>>2]|0;if(!d){m=b;m=m+1|0;a=a+24|0;c[a>>2]=m;return}do{e=c[d+36>>2]|0;if(e){k=c[e+24>>2]|0;b=(k|0)>(b|0)?k:b}e=c[d+44>>2]|0;if(e){k=c[e+24>>2]|0;b=(k|0)>(b|0)?k:b}e=c[d+60>>2]|0;if(e){k=c[e+24>>2]|0;b=(k|0)>(b|0)?k:b}h=c[d>>2]|0;if((h|0)!=0?(i=c[h>>2]|0,(i|0)>0):0){g=0;f=i;while(1){e=c[h+4+(g*20|0)>>2]|0;if(!e)e=f;else{k=c[e+24>>2]|0;e=(k|0)>(b|0);b=e?k:b;e=e?i:f}g=g+1|0;if((g|0)>=(e|0))break;else f=e}}h=c[d+40>>2]|0;if((h|0)!=0?(l=c[h>>2]|0,(l|0)>0):0){g=0;f=l;while(1){e=c[h+4+(g*20|0)>>2]|0;if(!e)e=f;else{k=c[e+24>>2]|0;e=(k|0)>(b|0);b=e?k:b;e=e?l:f}g=g+1|0;if((g|0)>=(e|0))break;else f=e}}h=c[d+48>>2]|0;if((h|0)!=0?(m=c[h>>2]|0,(m|0)>0):0){g=0;f=m;while(1){e=c[h+4+(g*20|0)>>2]|0;if(!e)e=f;else{k=c[e+24>>2]|0;e=(k|0)>(b|0);b=e?k:b;e=e?m:f}g=g+1|0;if((g|0)>=(e|0))break;else f=e}}d=c[d+52>>2]|0}while((d|0)!=0);m=b+1|0;a=a+24|0;c[a>>2]=m;return}function Xm(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0;i=Qa;Qa=Qa+16|0;g=i;a:do if(((d[b>>0]|0)+-48|0)>>>0<10){c[g>>2]=0;gi(b,g)|0;f=c[g>>2]&255}else{h=Cu(b)|0;g=(h&1073741823|0)==2;b:do if(!e){if(g){if(!(Gb(18544,b,2)|0)){f=0;break}if(!(Gb(18545,b,2)|0)){f=1;break}else break a}switch(h&1073741823|0){case 3:{if(!(Gb(18546,b,3)|0)){f=2;break b}if(!(Gb(18553,b,3)|0)){f=4;break b}else break a}case 5:{if(!(Gb(18548,b,5)|0)){f=3;break b}if(!(Gb(18559,b,5)|0)){f=6;break b}else break a}case 4:{if(!(Gb(18556,b,4)|0)){f=5;break b}if(!(Gb(18564,b,4)|0)){f=7;break b}else break a}default:break a}}else{if(g){if(!(Gb(18544,b,2)|0)){f=0;break}if(!(Gb(18545,b,2)|0)){f=1;break}else break a}switch(h&1073741823|0){case 3:{if(!(Gb(18546,b,3)|0)){f=2;break b}if(!(Gb(18553,b,3)|0)){f=4;break b}else break a}case 5:if(!(Gb(18548,b,5)|0)){f=3;break b}else break a;case 4:if(!(Gb(18556,b,4)|0)){f=5;break b}else break a;default:break a}}while(0);f=a[45920+f>>0]|0}while(0);Qa=i;return f|0}function Ym(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;i=Qa;Qa=Qa+16|0;g=i;c[g>>2]=f;f=0;a:while(1){switch(a[e+f>>0]|0){case 0:break a;case 115:{k=(c[g>>2]|0)+(4-1)&~(4-1);j=c[k>>2]|0;c[g>>2]=k+4;Dj(b,(j|0)==0?73:110,0,f+d|0,0,j,0)|0;break}case 105:{j=(c[g>>2]|0)+(4-1)&~(4-1);k=c[j>>2]|0;c[g>>2]=j+4;Ai(b,70,k,f+d|0)|0;break}default:{h=7;break a}}f=f+1|0}if((h|0)==7){Qa=i;return}Ai(b,81,d,f)|0;Qa=i;return}function Zm(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;k=c[(c[e>>2]|0)+32>>2]|0;o=c[(c[e+4>>2]|0)+8>>2]|0;h=c[g>>2]|0;do if(h){i=b[h+8>>1]|0;if((i&514)==514?(a[h+10>>0]|0)==1:0){n=c[h+16>>2]|0;break}if(!(i&1))n=Eg(h,1)|0;else n=0}else n=0;while(0);h=c[g+4>>2]|0;do if(h){i=b[h+8>>1]|0;if((i&514)==514?(a[h+10>>0]|0)==1:0){m=c[h+16>>2]|0;break}if(!(i&1))m=Eg(h,1)|0;else m=0}else m=0;while(0);j=c[g>>2]|0;h=b[j+8>>1]|0;if((h&2)!=0?(a[j+10>>0]|0)==1:0)h=c[j+12>>2]|0;else l=16;do if((l|0)==16){i=h&65535;if(!(i&16)){if(i&1|0){h=0;break}h=Dg(j,1)|0;break}else{h=c[j+12>>2]|0;if(!(i&16384))break;h=(c[j>>2]|0)+h|0;break}}while(0);if((h|0)>(c[k+140>>2]|0)){c[e+20>>2]=1;wc(c[e>>2]|0,45980,-1,1,-1)|0;return}do if((f|0)==3){h=c[g+8>>2]|0;if(!h)return;i=b[h+8>>1]|0;if((i&514)==514?(a[h+10>>0]|0)==1:0)g=c[h+16>>2]|0;else l=28;do if((l|0)==28)if(!(i&1)){g=Eg(h,1)|0;break}else return;while(0);if(!g)return;k=a[g>>0]|0;if((g|0)!=(-1|0)&k<<24>>24!=0){h=g;f=0;j=k;while(1){i=h+1|0;if((j&255)>191){h=i;while(1){j=a[h>>0]|0;if((j&-64)<<24>>24==-128)h=h+1|0;else break}}else{h=i;j=a[i>>0]|0}if(j<<24>>24!=0&(h|0)!=(-1|0))f=f+1|0;else break}if(!f){j=g+1|0;h=k&255;if((k&255)<=191)break;h=d[2736+(h+-192)>>0]|0;i=a[j>>0]|0;if((i&-64)<<24>>24==-128)do{j=j+1|0;h=h<<6|i&63;i=a[j>>0]|0}while((i&-64)<<24>>24==-128);h=(h&-2|0)==65534|(h>>>0<128|(h&-2048|0)==55296)?65533:h;break}}c[e+20>>2]=1;wc(c[e>>2]|0,46013,-1,1,-1)|0;return}else h=d[o+2>>0]|0;while(0);if(!((n|0)!=0&(m|0)!=0))return;i=(kd(n,m,o,h)|0)==0;h=c[e>>2]|0;i=i&1;j=h+8|0;if(!(b[j>>1]&9216)){o=h;c[o>>2]=i;c[o+4>>2]=0;b[j>>1]=4;return}else{Ng(h,i,0);return}}function _m(b,f,g,h,i){b=b|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;p=c[b>>2]|0;o=g+4|0;m=(c[o>>2]|0)+45|0;a:do if(!p){r=Qv(m|0,0,-1,-1)|0;n=L()|0;if(n>>>0>0|(n|0)==0&r>>>0>2147483390){g=0;return g|0}if(!(c[7324]|0)){j=Ua[c[29340>>2]&127](m)|0;q=25;break}j=Ua[c[29356>>2]&127](m)|0;if((c[14985]|0)>>>0<m>>>0)c[14985]=m;l=59064;k=c[l>>2]|0;l=c[l+4>>2]|0;if((l|0)>0|(l|0)==0&k>>>0>0){r=c[14978]|0;n=Rv(k|0,l|0,j|0,((j|0)<0)<<31>>31|0)|0;l=L()|0;c[14768]=((l|0)<0|(l|0)==0&n>>>0<=r>>>0)&1}k=Ua[c[29340>>2]&127](j)|0;if(!k){g=0;return g|0}j=Ua[c[29352>>2]&127](k)|0;j=(c[14978]|0)+j|0;c[14978]=j;if(j>>>0>(c[14982]|0)>>>0)c[14982]=j;j=(c[14981]|0)+1|0;c[14981]=j;if(j>>>0>(c[14987]|0)>>>0){c[14987]=j;r=k}else r=k}else{if(c[p+272>>2]|0){if(a[p+81>>0]|0){g=0;return g|0}}else{do if(!(0<0|(0==0?(e[p+276>>1]|0)>>>0<m>>>0:0))){k=p+300|0;j=c[k>>2]|0;if(j|0){c[k>>2]=c[j>>2];q=p+284|0;c[q>>2]=(c[q>>2]|0)+1;q=25;break a}k=p+296|0;j=c[k>>2]|0;if(!j){j=p+292|0;break}else{c[k>>2]=c[j>>2];q=p+284|0;c[q>>2]=(c[q>>2]|0)+1;q=25;break a}}else j=p+288|0;while(0);c[j>>2]=(c[j>>2]|0)+1}j=Yd(p,m,0)|0;q=25}while(0);if((q|0)==25)if(!j){g=0;return g|0}else r=j;ew(r|0,0,m|0)|0;n=r+44|0;cw(n|0,c[g>>2]|0,c[o>>2]|0)|0;j=a[n>>0]|0;if((a[880+(j&255)>>0]|0)<0){m=j<<24>>24==91?93:j;l=0;j=1;while(1){k=a[n+j>>0]|0;if(k<<24>>24==m<<24>>24){j=j+1|0;k=n+l|0;if((a[n+j>>0]|0)!=m<<24>>24)break;a[k>>0]=m}else a[n+l>>0]=k;l=l+1|0;j=j+1|0}a[k>>0]=0}o=r+12|0;c[o>>2]=n;a[r>>0]=f;while(1)if(!(a[880+(d[h>>0]|0)>>0]&1))break;else h=h+1|0;j=i-h|0;b:do if((j|0)<=0)if(!h)j=0;else{k=j;q=41}else while(1){k=j+-1|0;if(!(a[880+(d[h+k>>0]|0)>>0]&1)){k=j;q=41;break b}if((j|0)>1)j=k;else{q=41;break}}while(0);c:do if((q|0)==41){m=Qv(k|0,((k|0)<0)<<31>>31|0,1,0)|0;n=L()|0;d:do if(c[p+272>>2]|0)if(!(a[p+81>>0]|0))q=51;else{j=0;break c}else{do if(!(n>>>0>0|((n|0)==0?m>>>0>(e[p+276>>1]|0)>>>0:0))){l=p+300|0;j=c[l>>2]|0;if(j|0){c[l>>2]=c[j>>2];p=p+284|0;c[p>>2]=(c[p>>2]|0)+1;break d}l=p+296|0;j=c[l>>2]|0;if(!j){j=p+292|0;break}else{c[l>>2]=c[j>>2];p=p+284|0;c[p>>2]=(c[p>>2]|0)+1;break d}}else j=p+288|0;while(0);c[j>>2]=(c[j>>2]|0)+1;q=51}while(0);if((q|0)==51)j=Yd(p,m,n)|0;if(j){cw(j|0,h|0,k|0)|0;a[j+k>>0]=0;k=a[j>>0]|0;if(k<<24>>24){m=0;l=j;do{if(a[880+(k&255)>>0]&1)a[l>>0]=32;m=m+1|0;l=j+m|0;k=a[l>>0]|0}while(k<<24>>24!=0)}}else j=0}while(0);c[r+32>>2]=j;if((d[b+200>>0]|0)<=1){g=r;return g|0}m=c[o>>2]|0;l=c[b>>2]|0;e:do if(!l){if(!(c[7324]|0)){j=Ua[c[29340>>2]&127](16)|0;q=82;break}j=Ua[c[29356>>2]&127](16)|0;if((c[14985]|0)>>>0<16)c[14985]=16;l=59064;k=c[l>>2]|0;l=c[l+4>>2]|0;if((l|0)>0|(l|0)==0&k>>>0>0){p=c[14978]|0;i=Rv(k|0,l|0,j|0,((j|0)<0)<<31>>31|0)|0;f=L()|0;c[14768]=((f|0)<0|(f|0)==0&i>>>0<=p>>>0)&1}j=Ua[c[29340>>2]&127](j)|0;if(!j){g=r;return g|0}k=Ua[c[29352>>2]&127](j)|0;k=(c[14978]|0)+k|0;c[14978]=k;if(k>>>0>(c[14982]|0)>>>0)c[14982]=k;k=(c[14981]|0)+1|0;c[14981]=k;if(k>>>0>(c[14987]|0)>>>0)c[14987]=k}else{if(c[l+272>>2]|0){if(a[l+81>>0]|0){g=r;return g|0}}else{do if((e[l+276>>1]|0)>=16){k=l+300|0;j=c[k>>2]|0;if(j|0){c[k>>2]=c[j>>2];q=l+284|0;c[q>>2]=(c[q>>2]|0)+1;q=82;break e}k=l+296|0;j=c[k>>2]|0;if(!j){j=l+292|0;break}else{c[k>>2]=c[j>>2];q=l+284|0;c[q>>2]=(c[q>>2]|0)+1;q=82;break e}}else j=l+288|0;while(0);c[j>>2]=(c[j>>2]|0)+1}j=Yd(l,16,0)|0;q=82}while(0);if((q|0)==82)if(!j){g=r;return g|0}k=j+4|0;l=k+12|0;do{a[k>>0]=0;k=k+1|0}while((k|0)<(l|0));c[j>>2]=m;p=g;q=c[p+4>>2]|0;g=j+4|0;c[g>>2]=c[p>>2];c[g+4>>2]=q;g=b+272|0;c[j+12>>2]=c[g>>2];c[g>>2]=j;g=r;return g|0}function $m(f,g,h){f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;H=Qa;Qa=Qa+64|0;D=H+40|0;E=H+32|0;w=H+24|0;v=H+16|0;n=H+8|0;k=H;x=H+60|0;t=H+56|0;r=H+52|0;F=H+48|0;s=H+44|0;G=c[(c[f>>2]|0)+32>>2]|0;c[x>>2]=0;c[t>>2]=0;c[F>>2]=0;g=c[h>>2]|0;do if(g){i=b[g+8>>1]|0;if((i&514)==514?(a[g+10>>0]|0)==1:0){j=c[g+16>>2]|0;break}if(!(i&1))j=Eg(g,1)|0;else j=0}else j=0;while(0);g=c[h+4>>2]|0;do if(g){i=b[g+8>>1]|0;if((i&514)==514?(a[g+10>>0]|0)==1:0){g=c[g+16>>2]|0;break}if(!(i&1))g=Eg(g,1)|0;else g=0}else g=0;while(0);A=(j|0)==0?59952:j;u=(g|0)==0?59952:g;z=G+20|0;m=c[z>>2]|0;g=c[G+136>>2]|0;a:do if((m|0)<(g+2|0)){y=G+16|0;l=c[y>>2]|0;b:do if((m|0)>0){k=d[208+(d[u>>0]|0)>>0]|0;h=0;while(1){i=c[l+(h<<4)>>2]|0;q=a[i>>0]|0;g=(d[208+(q&255)>>0]|0)-k|0;if(!(q<<24>>24==0|(g|0)!=0)){j=u;do{i=i+1|0;j=j+1|0;q=a[i>>0]|0;g=(d[208+(q&255)>>0]|0)-(d[208+(d[j>>0]|0)>>0]|0)|0}while(!(q<<24>>24==0|(g|0)!=0))}h=h+1|0;if(!g)break;if((h|0)>=(m|0))break b}c[n>>2]=u;i=bd(G,46469,n)|0;c[F>>2]=i;g=0;C=142;break a}while(0);c:do if((l|0)==(G+412|0)){d:do if(c[G+272>>2]|0)if(!(a[G+81>>0]|0))C=34;else{Qa=H;return}else{do if((e[G+276>>1]|0)>=48){i=G+300|0;g=c[i>>2]|0;if(g|0){c[i>>2]=c[g>>2];q=G+284|0;c[q>>2]=(c[q>>2]|0)+1;break d}i=G+296|0;g=c[i>>2]|0;if(!g){g=G+292|0;break}else{c[i>>2]=c[g>>2];q=G+284|0;c[q>>2]=(c[q>>2]|0)+1;break d}}else g=G+288|0;while(0);c[g>>2]=(c[g>>2]|0)+1;C=34}while(0);if((C|0)==34)g=Yd(G,48,0)|0;if(!g){Qa=H;return}else{p=c[y>>2]|0;c[g>>2]=c[p>>2];c[g+4>>2]=c[p+4>>2];c[g+8>>2]=c[p+8>>2];c[g+12>>2]=c[p+12>>2];c[g+16>>2]=c[p+16>>2];c[g+20>>2]=c[p+20>>2];c[g+24>>2]=c[p+24>>2];c[g+28>>2]=c[p+28>>2];p=g;break}}else{j=(m<<4)+16|0;e:do if(!l){if(c[G+272>>2]|0){if(a[G+81>>0]|0){Qa=H;return}}else{do if(!(0<0|(0==0?(e[G+276>>1]|0)>>>0<j>>>0:0))){i=G+300|0;g=c[i>>2]|0;if(g|0){c[i>>2]=c[g>>2];q=G+284|0;c[q>>2]=(c[q>>2]|0)+1;break e}i=G+296|0;g=c[i>>2]|0;if(!g){g=G+292|0;break}else{c[i>>2]=c[g>>2];q=G+284|0;c[q>>2]=(c[q>>2]|0)+1;break e}}else g=G+288|0;while(0);c[g>>2]=(c[g>>2]|0)+1}g=Yd(G,j,0)|0}else{q=l;if((c[G+304>>2]|0)>>>0<=q>>>0?(c[G+308>>2]|0)>>>0>q>>>0:0){if(!(0<0|(0==0?(e[G+276>>1]|0)>>>0<j>>>0:0))){p=l;break c}g=Xd(G,l,j,0)|0;break}g=Xd(G,l,j,0)|0}while(0);if(!g){Qa=H;return}else p=g}while(0);c[y>>2]=p;q=c[z>>2]|0;o=p+(q<<4)|0;c[o>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;c[r>>2]=c[G+60>>2];switch(bn(c[(c[G>>2]|0)+16>>2]|0,A,r,s,x,t)|0){case 0:{g=c[r>>2]|256;c[r>>2]=g;k=p+(q<<4)+4|0;g=Ne(c[s>>2]|0,c[x>>2]|0,G,k,0,g)|0;c[z>>2]=(c[z>>2]|0)+1;h=(Cu(u)|0)+1|0;r=G+272|0;f:do if(c[r>>2]|0)if(!(a[G+81>>0]|0))C=76;else i=0;else{do if(!(0<0|(0==0?(e[G+276>>1]|0)>>>0<h>>>0:0))){j=G+300|0;i=c[j>>2]|0;if(i|0){c[j>>2]=c[i>>2];C=G+284|0;c[C>>2]=(c[C>>2]|0)+1;C=77;break f}j=G+296|0;i=c[j>>2]|0;if(!i){i=G+292|0;break}else{c[j>>2]=c[i>>2];C=G+284|0;c[C>>2]=(c[C>>2]|0)+1;C=77;break f}}else i=G+288|0;while(0);c[i>>2]=(c[i>>2]|0)+1;C=76}while(0);if((C|0)==76){i=Yd(G,h,0)|0;C=77}if((C|0)==77)if(!i)i=0;else cw(i|0,u|0,h|0)|0;c[o>>2]=i;a[G+89>>0]=0;switch(g|0){case 19:{c[F>>2]=bd(G,46499,v)|0;g=1;C=98;break}case 0:{g=cn(G,c[k>>2]|0)|0;c[p+(q<<4)+12>>2]=g;if(g)if((a[g+76>>0]|0)!=0?(a[g+77>>0]|0)!=(a[G+78>>0]|0):0){c[F>>2]=bd(G,34948,w)|0;g=1}else g=0;else g=7;j=c[k>>2]|0;k=c[j>>2]|0;h=c[j+4>>2]|0;l=h+4|0;c[l>>2]=k;m=c[h>>2]|0;i=a[G+83>>0]|0;n=(a[m+12>>0]|0)==0;do if(n){w=c[m+216>>2]|0;if(w|0?(a[w+43>>0]|0)==2:0)break;a[m+4>>0]=i}while(0);i=c[(c[y>>2]|0)+4>>2]|0;if(!i)i=0;else{w=c[i+4>>2]|0;c[w+4>>2]=c[i>>2];i=(e[w+22>>1]|0)>>>2&3}if(j|0){c[l>>2]=k;w=h+22|0;b[w>>1]=i<<2|b[w>>1]&-13&65535}h=c[G+32>>2]|0;c[l>>2]=k;j=n^1;a[m+7>>0]=j&1;a[m+8>>0]=n&1;a[m+9>>0]=0;do if(n){i=m+10|0;if(!(h&8)){a[i>>0]=2;i=2;break}else{a[i>>0]=3;i=3;break}}else{a[m+10>>0]=0;i=0}while(0);w=(i<<2|(n?i:0))&255;a[m+11>>0]=(h&16|0)==0|j?w:w|12;w=m+20|0;v=d[w>>0]|0;a[w>>0]=(h&32|0)==0?v|1:v&254;a[p+(q<<4)+8>>0]=3;if(!g)g=(c[o>>2]|0)==0?7:0;break}default:C=98}if((C|0)==98)a[p+(q<<4)+8>>0]=3;i=c[x>>2]|0;do if(i|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{x=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-x;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}while(0);g:do if(!g){g=c[z>>2]|0;h=c[y>>2]|0;if((g|0)>0){i=0;do{j=c[h+(i<<4)+4>>2]|0;if(j|0)c[(c[j+4>>2]|0)+4>>2]=c[j>>2];i=i+1|0}while((i|0)!=(g|0))}a[G+164>>0]=0;j=G+24|0;k=c[j>>2]|0;c[j>>2]=k&-17;k=(k&1|0)==0;x=c[h+12>>2]|0;a[G+78>>0]=a[x+77>>0]|0;if(!(b[x+78>>1]&1)){g=ch(G,0,F,0)|0;if(g|0)break;g=c[z>>2]|0}if((g|0)>1)do{i=g;g=g+-1|0;if((b[(c[(c[y>>2]|0)+(g<<4)+12>>2]|0)+78>>1]&1)==0?(B=ch(G,g,F,0)|0,B|0):0){g=B;break g}}while((i|0)>2);if(!k){Qa=H;return}c[j>>2]=c[j>>2]&-2;Qa=H;return}while(0);i=(c[z>>2]|0)+-1|0;j=c[(c[y>>2]|0)+(i<<4)+4>>2]|0;if(j|0){sg(j);B=c[y>>2]|0;c[B+(i<<4)+4>>2]=0;c[B+(i<<4)+12>>2]=0}Zb(G);c[z>>2]=i;if((g|0)<3082)switch(g|0){case 7:break;default:C=140}else switch(g|0){case 3082:break;default:C=140}if((C|0)==140){i=c[F>>2]|0;if(i|0){C=143;break a}c[D>>2]=A;i=bd(G,46528,D)|0;c[F>>2]=i;C=142;break a}i=G+81|0;if((a[i>>0]|0)==0?(a[G+82>>0]|0)==0:0){a[i>>0]=1;if((c[G+180>>2]|0)>0)c[G+264>>2]=1;c[r>>2]=(c[r>>2]|0)+1;i=c[G+236>>2]|0;if(i|0)c[i+12>>2]=7}i=c[F>>2]|0;do if(i|0){if(c[G+480>>2]|0){Vd(G,i);break}D=i;if((c[G+304>>2]|0)>>>0<=D>>>0?(c[G+308>>2]|0)>>>0>D>>>0:0){D=G+300|0;c[i>>2]=c[D>>2];c[D>>2]=i;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{D=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-D;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);i=bd(G,34831,E)|0;c[F>>2]=i;C=142;break a}case 7:{g=G+81|0;if((a[g>>0]|0)==0?(a[G+82>>0]|0)==0:0){a[g>>0]=1;if((c[G+180>>2]|0)>0)c[G+264>>2]=1;g=G+272|0;c[g>>2]=(c[g>>2]|0)+1;g=c[G+236>>2]|0;if(g|0)c[g+12>>2]=7}break}default:{}}g=c[t>>2]|0;c[f+20>>2]=1;wc(c[f>>2]|0,g,-1,1,-1)|0;if(!g){Qa=H;return}if(!(c[7324]|0)){_a[c[29344>>2]&127](g);Qa=H;return}else{f=Ua[c[29352>>2]&127](g)|0;c[14978]=(c[14978]|0)-f;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](g);Qa=H;return}}else{c[k>>2]=g;i=bd(G,46432,k)|0;c[F>>2]=i;g=0;C=142}while(0);if((C|0)==142)if(i)C=143;do if((C|0)==143){c[f+20>>2]=1;wc(c[f>>2]|0,i,-1,1,-1)|0;i=c[F>>2]|0;if(i){if(G|0){if(c[G+480>>2]|0){Vd(G,i);break}F=i;if((c[G+304>>2]|0)>>>0<=F>>>0?(c[G+308>>2]|0)>>>0>F>>>0:0){G=G+300|0;c[i>>2]=c[G>>2];c[G>>2]=i;break}}if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{G=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-G;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}}while(0);if(!g){Qa=H;return}c[f+20>>2]=g;i=c[f>>2]|0;if(!(b[i+8>>1]&1)){Qa=H;return}switch(g|0){case 516:{g=50738;break}case 100:{g=50760;break}case 101:{g=50782;break}default:{g=g&255;if(g>>>0<29?(520028155>>>g&1|0)!=0:0)g=c[22960+(g<<2)>>2]|0;else g=50724}}wc(i,g,-1,1,0)|0;Qa=H;return}function an(f,g,h,i,j,k,l){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;J=Qa;Qa=Qa+112|0;x=J+32|0;w=J+24|0;t=J+16|0;r=J+8|0;n=J;s=J+72|0;u=J+40|0;I=c[f>>2]|0;a:do if(!(c[f+36>>2]|0)){z=u+4|0;c[z>>2]=0;c[z+4>>2]=0;c[z+8>>2]=0;c[z+12>>2]=0;c[z+16>>2]=0;c[z+20>>2]=0;c[z+24>>2]=0;c[u>>2]=f;z=(j|0)==0;m=f;do if(z)m=0;else{if((a[j>>0]|0)==59){a[j>>0]=110;m=0;break}p=u+24|0;b[p>>1]=0;c[s>>2]=m;c[s+4>>2]=125;c[s+8>>2]=126;c[s+12>>2]=0;c[s+24>>2]=u;o=j+24|0;m=f+208|0;A=(c[m>>2]|0)+(c[o>>2]|0)|0;c[m>>2]=A;m=c[I+120>>2]|0;if((m|0)>=(A|0)){Yj(s,j)|0;n=c[s>>2]|0;m=n+208|0;c[m>>2]=(c[m>>2]|0)-(c[o>>2]|0);m=b[p>>1]|0;A=j+4|0;c[A>>2]=c[A>>2]|m&-32752&65535;if((c[u+20>>2]|0)<=0)if((c[n+36>>2]|0)<1)break;else{F=121;break a}}else{c[n>>2]=m;ad(f,41637,n)}F=121;break a}while(0);A=(k|0)==0;do if(!A){if((a[k>>0]|0)==59){a[k>>0]=110;break}q=u+24|0;o=m&65535;b[q>>1]=o&28655;m=c[u>>2]|0;c[s>>2]=m;c[s+4>>2]=125;c[s+8>>2]=126;c[s+12>>2]=0;c[s+24>>2]=u;p=k+24|0;n=m+208|0;y=(c[n>>2]|0)+(c[p>>2]|0)|0;c[n>>2]=y;n=c[(c[m>>2]|0)+120>>2]|0;if((n|0)>=(y|0)){Yj(s,k)|0;n=c[s>>2]|0;m=n+208|0;c[m>>2]=(c[m>>2]|0)-(c[p>>2]|0);m=b[q>>1]|0;y=k+4|0;c[y>>2]=c[y>>2]|m&-32752&65535;m=(o&36880|m&65535)&65535;b[q>>1]=m;if((c[u+20>>2]|0)<=0)if((c[n+36>>2]|0)<1)break;else{F=120;break a}}else{c[r>>2]=n;ad(m,41637,r)}F=120;break a}while(0);y=(l|0)==0;do if(!y){if((a[l>>0]|0)==59){a[l>>0]=110;break}q=u+24|0;p=m&65535;b[q>>1]=p&28655;m=c[u>>2]|0;c[s>>2]=m;c[s+4>>2]=125;c[s+8>>2]=126;c[s+12>>2]=0;c[s+24>>2]=u;o=l+24|0;n=m+208|0;r=(c[n>>2]|0)+(c[o>>2]|0)|0;c[n>>2]=r;n=c[(c[m>>2]|0)+120>>2]|0;if((n|0)>=(r|0)){Yj(s,l)|0;m=c[s>>2]|0;t=m+208|0;c[t>>2]=(c[t>>2]|0)-(c[o>>2]|0);t=b[q>>1]|0;s=l+4|0;c[s>>2]=c[s>>2]|t&-32752&65535;b[q>>1]=p&36880|t&65535;if((c[u+20>>2]|0)<=0)if((c[m+36>>2]|0)<1)break;else{F=120;break a}}else{c[t>>2]=n;ad(m,41637,t)}F=120;break a}while(0);do if(i|0){if((a[i>>0]|0)==110)m=c[i+8>>2]|0;else m=0;n=c[f>>2]|0;if(((a[n+165>>0]|0)==0?(a[f+200>>0]|0)==0:0)?(v=c[n+312>>2]|0,v|0):0){m=Za[v&127](c[n+316>>2]|0,g,m,0,0,c[f+240>>2]|0)|0;if((m|0)==1){ad(f,39216,w);c[f+12>>2]=23;F=120;break a}if((m|2|0)==2)if(!m)break;else{F=120;break a}else{ad(f,39231,x);c[f+12>>2]=1;F=120;break a}}}while(0);s=f+8|0;m=c[s>>2]|0;b:do if(!m){p=c[f>>2]|0;if((c[f+116>>2]|0)==0?(b[p+76>>1]&8)==0:0)a[f+23>>0]=1;c:do if(c[p+272>>2]|0)if(!(a[p+81>>0]|0))F=51;else{t=0;break b}else{do if((e[p+276>>1]|0)>=224){m=p+300|0;n=c[m>>2]|0;if(n|0){c[m>>2]=c[n>>2];x=p+284|0;c[x>>2]=(c[x>>2]|0)+1;break c}m=p+296|0;n=c[m>>2]|0;if(!n){m=p+292|0;break}else{c[m>>2]=c[n>>2];x=p+284|0;c[x>>2]=(c[x>>2]|0)+1;break c}}else m=p+288|0;while(0);c[m>>2]=(c[m>>2]|0)+1;F=51}while(0);if((F|0)==51)n=Yd(p,224,0)|0;if(!n)t=0;else{m=n+104|0;o=m+120|0;do{c[m>>2]=0;m=m+4|0}while((m|0)<(o|0));c[n>>2]=p;m=p+4|0;o=c[m>>2]|0;if(o|0)c[o+4>>2]=n;c[n+8>>2]=o;c[n+4>>2]=0;c[m>>2]=n;c[n+20>>2]=381479589;c[n+12>>2]=f;c[s>>2]=n;Bi(n,61,0,1,0)|0;t=n}}else t=m;while(0);n=f+32|0;o=c[n>>2]|0;m=f+28|0;p=c[m>>2]|0;if((p|0)<4){m=f+44|0;n=c[m>>2]|0;r=n+1|0;n=n+4|0}else{c[n>>2]=o+4;r=o;n=p+-4|0}c[m>>2]=n;do if(!z){if((a[j>>0]|0)!=-88){C=Hj(f,j,r)|0;F=66;break}m=c[s>>2]|0;n=c[j+28>>2]|0;o=m+108|0;p=c[o>>2]|0;if((c[m+112>>2]|0)>(p|0)){c[o>>2]=p+1;z=c[m+104>>2]|0;a[z+(p*20|0)>>0]=78;b[z+(p*20|0)+2>>1]=0;c[z+(p*20|0)+4>>2]=n;c[z+(p*20|0)+8>>2]=r;c[z+(p*20|0)+12>>2]=0;c[z+(p*20|0)+16>>2]=0;a[z+(p*20|0)+1>>0]=0;break}else{Bi(m,78,n,r,0)|0;break}}else{C=Hj(f,0,r)|0;F=66}while(0);do if(((F|0)==66?(C|0)!=(r|0):0)?(B=c[s>>2]|0,B|0):0){m=B+108|0;n=c[m>>2]|0;if((c[B+112>>2]|0)>(n|0)){c[m>>2]=n+1;B=c[B+104>>2]|0;a[B+(n*20|0)>>0]=79;b[B+(n*20|0)+2>>1]=0;c[B+(n*20|0)+4>>2]=C;c[B+(n*20|0)+8>>2]=r;c[B+(n*20|0)+12>>2]=0;c[B+(n*20|0)+16>>2]=0;a[B+(n*20|0)+1>>0]=0;break}else{Bi(B,79,C,r,0)|0;break}}while(0);q=r+1|0;do if(!A){if((a[k>>0]|0)!=-88){E=Hj(f,k,q)|0;F=78;break}m=c[s>>2]|0;n=c[k+28>>2]|0;o=m+108|0;p=c[o>>2]|0;if((c[m+112>>2]|0)>(p|0)){c[o>>2]=p+1;C=c[m+104>>2]|0;a[C+(p*20|0)>>0]=78;b[C+(p*20|0)+2>>1]=0;c[C+(p*20|0)+4>>2]=n;c[C+(p*20|0)+8>>2]=q;c[C+(p*20|0)+12>>2]=0;c[C+(p*20|0)+16>>2]=0;a[C+(p*20|0)+1>>0]=0;break}else{Bi(m,78,n,q,0)|0;break}}else{E=Hj(f,0,q)|0;F=78}while(0);do if(((F|0)==78?(E|0)!=(q|0):0)?(D=c[s>>2]|0,D|0):0){m=D+108|0;n=c[m>>2]|0;if((c[D+112>>2]|0)>(n|0)){c[m>>2]=n+1;D=c[D+104>>2]|0;a[D+(n*20|0)>>0]=79;b[D+(n*20|0)+2>>1]=0;c[D+(n*20|0)+4>>2]=E;c[D+(n*20|0)+8>>2]=q;c[D+(n*20|0)+12>>2]=0;c[D+(n*20|0)+16>>2]=0;a[D+(n*20|0)+1>>0]=0;break}else{Bi(D,79,E,q,0)|0;break}}while(0);q=r+2|0;do if(!y){if((a[l>>0]|0)!=-88){H=Hj(f,l,q)|0;F=90;break}m=c[s>>2]|0;n=c[l+28>>2]|0;o=m+108|0;p=c[o>>2]|0;if((c[m+112>>2]|0)>(p|0)){c[o>>2]=p+1;f=c[m+104>>2]|0;a[f+(p*20|0)>>0]=78;b[f+(p*20|0)+2>>1]=0;c[f+(p*20|0)+4>>2]=n;c[f+(p*20|0)+8>>2]=q;c[f+(p*20|0)+12>>2]=0;c[f+(p*20|0)+16>>2]=0;a[f+(p*20|0)+1>>0]=0;break}else{Bi(m,78,n,q,0)|0;break}}else{H=Hj(f,0,q)|0;F=90}while(0);do if(((F|0)==90?(H|0)!=(q|0):0)?(G=c[s>>2]|0,G|0):0){m=G+108|0;n=c[m>>2]|0;if((c[G+112>>2]|0)>(n|0)){c[m>>2]=n+1;G=c[G+104>>2]|0;a[G+(n*20|0)>>0]=79;b[G+(n*20|0)+2>>1]=0;c[G+(n*20|0)+4>>2]=H;c[G+(n*20|0)+8>>2]=q;c[G+(n*20|0)+12>>2]=0;c[G+(n*20|0)+16>>2]=0;a[G+(n*20|0)+1>>0]=0;break}else{Bi(G,79,H,q,0)|0;break}}while(0);if(t){n=r+3|0;o=n-(a[h>>0]|0)|0;p=t+108|0;m=c[p>>2]|0;q=t+112|0;if((c[q>>2]|0)>(m|0)){c[p>>2]=m+1;H=c[t+104>>2]|0;a[H+(m*20|0)>>0]=63;b[H+(m*20|0)+2>>1]=0;c[H+(m*20|0)+4>>2]=0;c[H+(m*20|0)+8>>2]=o;c[H+(m*20|0)+12>>2]=n;c[H+(m*20|0)+16>>2]=0;a[H+(m*20|0)+1>>0]=0}else m=Bi(t,63,0,o,n)|0;n=c[t>>2]|0;d:do if(!(a[n+81>>0]|0)){if((m|0)<0)m=(c[p>>2]|0)+-1|0;n=c[t+104>>2]|0;o=n+(m*20|0)+1|0;if(!(a[o>>0]|0)){c[n+(m*20|0)+16>>2]=h;a[o>>0]=-8;break}else{Ci(t,n+(m*20|0)|0,h,-8);break}}else if(c[h+4>>2]&16|0){do if(n|0){if(c[n+480>>2]|0){Vd(n,h);break d}m=h;if((c[n+304>>2]|0)>>>0<=m>>>0){if((c[n+308>>2]|0)>>>0<=m>>>0)break;H=n+300|0;c[h>>2]=c[H>>2];c[H>>2]=h;break d}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](h);break}else{H=Ua[c[29352>>2]&127](h)|0;c[14978]=(c[14978]|0)-H;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](h);break}}while(0);n=c[p>>2]|0;if((n|0)>0)b[(c[t+104>>2]|0)+((n+-1|0)*20|0)+2>>1]=d[h>>0]|0;m=(g|0)==24&1;if((c[q>>2]|0)>(n|0)){c[p>>2]=n+1;F=c[t+104>>2]|0;a[F+(n*20|0)>>0]=-98;b[F+(n*20|0)+2>>1]=0;c[F+(n*20|0)+4>>2]=m;c[F+(n*20|0)+8>>2]=0;c[F+(n*20|0)+12>>2]=0;c[F+(n*20|0)+16>>2]=0;a[F+(n*20|0)+1>>0]=0;F=120;break}else{Bi(t,158,m,0,0)|0;F=120;break}}else F=120}else F=120;while(0);if((F|0)==120?j|0:0)F=121;if((F|0)==121)li(I,j);if(k|0)li(I,k);if(!l){Qa=J;return}li(I,l);Qa=J;return}function bn(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=Qa;Qa=Qa+32|0;v=w+24|0;t=w+16|0;s=w+8|0;n=w;j=c[e>>2]|0;a:do if(d){i=(Cu(d)|0)&1073741823;if(i>>>0>4&(c[7327]|j&64|0)!=0?(Ju(d,46556,5)|0)==0:0){j=j|64;k=0;l=i+2|0;m=0;do{l=Qv(l|0,m|0,(a[d+k>>0]|0)==38|0,0)|0;m=L()|0;k=k+1|0}while((k|0)!=(i|0));k=nb(l,m)|0;if(!k){g=7;Qa=w;return g|0}b:do if((a[d+5>>0]|0)==47?(a[d+6>>0]|0)==47:0){l=7;c:while(1){switch(a[d+l>>0]|0){case 0:case 47:break c;default:{}}l=l+1|0}switch(l&2147483647|0){case 7:{l=7;break b}case 16:{i=d+7|0;if(!(Ju(46562,i,9)|0)){l=16;break b}break}default:i=d+7|0}c[n>>2]=l+-7;c[n+4>>2]=i;l=k;i=1;k=zb(46572,n)|0;u=86;break a}else l=5;while(0);i=0;n=0;d:while(1){p=k+(i+-1)|0;e:while(1){m=a[d+l>>0]|0;switch(m<<24>>24){case 0:case 35:break d;default:{}}o=l+1|0;f:do if((m<<24>>24==37?(q=a[d+o>>0]|0,(a[880+(q&255)>>0]&8)!=0):0)?(r=a[d+(l+2)>>0]|0,(a[880+(r&255)>>0]&8)!=0):0){m=q<<24>>24;l=l+3|0;o=r<<24>>24;m=(0-(o>>>6&1)&9)+o&15|(0-(m>>>6&1)&9)+m<<4&240;if(m|0){u=37;break e}switch(n|0){case 0:while(1){switch(a[d+l>>0]|0){case 63:case 35:case 0:break f;default:{}}l=l+1|0}case 1:while(1){switch(a[d+l>>0]|0){case 38:case 61:case 35:case 0:break f;default:{}}l=l+1|0}case 2:while(1){switch(a[d+l>>0]|0){case 38:case 35:case 0:break f;default:{}}l=l+1|0}default:while(1){switch(a[d+l>>0]|0){case 35:case 0:break f;default:{}}l=l+1|0}}}else u=38;while(0);g:do if((u|0)==38){u=0;switch(n|0){case 0:{u=47;break e}case 2:{u=48;break e}case 1:break;default:{l=o;break e}}switch(m<<24>>24){case 38:case 61:break;default:{n=1;l=o;break e}}if(a[p>>0]|0){u=45;break e}l=o;while(1){switch(a[d+l>>0]|0){case 35:case 0:break g;default:{}}if((a[d+(l+-1)>>0]|0)==38)break g;l=l+1|0}}while(0)}if((u|0)==37){u=0;m=m&255}else if((u|0)==45){u=0;if(m<<24>>24==38){a[k+i>>0]=0;m=0;i=i+1|0;n=1;l=o}else{m=0;n=2;l=o}}else if((u|0)==47){u=0;if(m<<24>>24==63)u=49;else{n=0;l=o}}else if((u|0)==48){u=0;if(m<<24>>24==38)u=49;else{n=2;l=o}}if((u|0)==49){u=0;m=0;n=1;l=o}a[k+i>>0]=m;i=i+1|0}if((n|0)==1){a[k+i>>0]=0;i=i+1|0}a[k+i>>0]=0;a[k+(i+1)>>0]=0;i=k+(((Cu(k)|0)&1073741823)+1)|0;if(a[i>>0]|0){r=b;b=i;h:while(1){i:do if(!b){i=1;l=(Cu(1)|0)&1073741823;u=71}else{d=Cu(b)|0;i=b+((d&1073741823)+1)|0;l=(Cu(i)|0)&1073741823;switch(d&1073741823|0){case 3:if(!(Ju(46600,b,3)|0)){m=i;break i}else{u=71;break i}case 5:{if(!(Ju(46604,b,5)|0)){o=393216;p=-393217;q=46604;n=18576}else{u=71;break i}break}case 4:{if(!(Ju(58212,b,4)|0)){o=j&135;p=-136;q=31701;n=18608}else{u=71;break i}break}default:{u=71;break i}}b=c[n>>2]|0;if(!b){u=67;break h}m=0;while(1){if((l|0)==((Cu(b)|0)&1073741823|0)?(Ju(i,b,l)|0)==0:0)break;m=m+1|0;b=c[n+(m<<3)>>2]|0;if(!b){u=67;break h}}b=c[n+(m<<3)+4>>2]|0;if(!b){u=67;break h}if((b&-129|0)>(o|0)){u=69;break h}j=b|p&j;u=71}while(0);if((u|0)==71){u=0;m=r}b=i+(l+1)|0;if(!(a[b>>0]|0)){b=m;u=77;break a}else r=m}if((u|0)==67){c[s>>2]=q;c[s+4>>2]=i;l=k;i=1;k=zb(46635,s)|0;u=86;break}else if((u|0)==69){c[t>>2]=q;c[t+4>>2]=i;l=k;i=3;k=zb(46655,t)|0;u=86;break}}else u=77}else u=73}else{i=0;u=73}while(0);if((u|0)==73){k=nb(i+2|0,0)|0;if(!k){g=7;Qa=w;return g|0}if(i|0)cw(k|0,d|0,i|0)|0;a[k+i>>0]=0;a[k+(i+1)>>0]=0;j=j&-65;u=77}j:do if((u|0)==77){k:do if(!(kb()|0)){i=c[14770]|0;l=(i|0)==0;if((b|0)==0|l){c[f>>2]=i;if(l)break;else{i=0;break j}}while(1){if(!(zu(b,c[i+16>>2]|0)|0))break;i=c[i+12>>2]|0;if(!i){u=83;break k}}c[f>>2]=i;i=0;break j}else u=83;while(0);if((u|0)==83)c[f>>2]=0;c[v>>2]=b;l=k;i=1;k=zb(46679,v)|0;u=86}while(0);do if((u|0)==86){c[h>>2]=k;if(l)if(!(c[7324]|0)){_a[c[29344>>2]&127](l);k=0;break}else{k=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-k;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);k=0;break}else k=0}while(0);c[e>>2]=j;c[g>>2]=k;g=i;Qa=w;return g|0}function cn(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;do if(d){i=c[d+4>>2]|0;c[i+4>>2]=c[d>>2];h=i+48|0;d=c[h>>2]|0;if(!d){if(!(c[7324]|0)){d=Ua[c[29340>>2]&127](84)|0;if(!d)g=26;else g=27}else{d=Ua[c[29356>>2]&127](84)|0;if((c[14985]|0)>>>0<84)c[14985]=84;f=59064;e=c[f>>2]|0;f=c[f+4>>2]|0;if((f|0)>0|(f|0)==0&e>>>0>0){g=c[14978]|0;f=Rv(e|0,f|0,d|0,((d|0)<0)<<31>>31|0)|0;e=L()|0;c[14768]=((e|0)<0|(e|0)==0&f>>>0<=g>>>0)&1}d=Ua[c[29340>>2]&127](d)|0;if(d){e=Ua[c[29352>>2]&127](d)|0;e=(c[14978]|0)+e|0;c[14978]=e;if(e>>>0>(c[14982]|0)>>>0)c[14982]=e;e=(c[14981]|0)+1|0;c[14981]=e;if(e>>>0>(c[14987]|0)>>>0){c[14987]=e;g=27}else g=27}else g=26}if((g|0)==26){c[h>>2]=0;c[i+52>>2]=95;break}else if((g|0)==27){f=d;g=f+84|0;do{a[f>>0]=0;f=f+1|0}while((f|0)<(g|0));c[h>>2]=d;c[i+52>>2]=95;g=34;break}}else g=34}else{if(!(c[7324]|0)){d=Ua[c[29340>>2]&127](84)|0;if(!d)break}else{d=Ua[c[29356>>2]&127](84)|0;if((c[14985]|0)>>>0<84)c[14985]=84;f=59064;e=c[f>>2]|0;f=c[f+4>>2]|0;if((f|0)>0|(f|0)==0&e>>>0>0){i=c[14978]|0;h=Rv(e|0,f|0,d|0,((d|0)<0)<<31>>31|0)|0;f=L()|0;c[14768]=((f|0)<0|(f|0)==0&h>>>0<=i>>>0)&1}e=Ua[c[29340>>2]&127](d)|0;if(!e)break;d=Ua[c[29352>>2]&127](e)|0;d=(c[14978]|0)+d|0;c[14978]=d;if(d>>>0>(c[14982]|0)>>>0)c[14982]=d;d=(c[14981]|0)+1|0;c[14981]=d;if(d>>>0>(c[14987]|0)>>>0){c[14987]=d;d=e}else d=e}f=d;g=f+84|0;do{a[f>>0]=0;f=f+1|0}while((f|0)<(g|0));g=34}while(0);if((g|0)==34){if(a[d+76>>0]|0){b=d;return b|0}e=d+77|0;f=d+8|0;g=f+64|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));a[e>>0]=1;b=d;return b|0}d=b+81|0;if(a[d>>0]|0){b=0;return b|0}if(a[b+82>>0]|0){b=0;return b|0}a[d>>0]=1;if((c[b+180>>2]|0)>0)c[b+264>>2]=1;d=b+272|0;c[d>>2]=(c[d>>2]|0)+1;d=c[b+236>>2]|0;if(!d){b=0;return b|0}c[d+12>>2]=7;b=0;return b|0}function dn(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;w=Qa;Qa=Qa+160|0;r=w+144|0;q=w+136|0;p=w+128|0;o=w;f=c[g>>2]|0;do if(f){g=b[f+8>>1]|0;if((g&514)==514?(a[f+10>>0]|0)==1:0){f=c[f+16>>2]|0;break}if(!(g&1))f=Eg(f,1)|0;else f=0}else f=0;while(0);v=c[(c[e>>2]|0)+32>>2]|0;n=(f|0)==0?59952:f;t=v+20|0;l=c[t>>2]|0;a:do if((l|0)>0){u=v+16|0;m=c[u>>2]|0;f=0;while(1){j=m+(f<<4)+4|0;k=c[j>>2]|0;if(k|0){h=c[m+(f<<4)>>2]|0;i=a[h>>0]|0;g=(d[208+(i&255)>>0]|0)-(d[208+(d[n>>0]|0)>>0]|0)|0;if(!(i<<24>>24==0|(g|0)!=0)){i=n;do{h=h+1|0;i=i+1|0;x=a[h>>0]|0;g=(d[208+(x&255)>>0]|0)-(d[208+(d[i>>0]|0)>>0]|0)|0}while(!(x<<24>>24==0|(g|0)!=0))}if(!g)break}f=f+1|0;if((f|0)>=(l|0)){s=15;break a}}if(f>>>0<2){c[q>>2]=n;Ab(128,o,46730,q)|0;break}if((a[k+8>>0]|0)==0?(c[k+16>>2]|0)==0:0){sg(k);c[j>>2]=0;c[m+(f<<4)+12>>2]=0;if((c[t>>2]|0)>2){j=v+480|0;k=v+304|0;l=v+308|0;m=v+300|0;i=2;f=2;do{g=c[u>>2]|0;h=g+(i<<4)|0;if(!(c[g+(i<<4)+4>>2]|0)){g=c[h>>2]|0;do if(g|0){if(c[j>>2]|0){Vd(v,g);break}x=g;if((c[k>>2]|0)>>>0<=x>>>0?(c[l>>2]|0)>>>0>x>>>0:0){c[g>>2]=c[m>>2];c[m>>2]=g;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](g);break}else{x=Ua[c[29352>>2]&127](g)|0;c[14978]=(c[14978]|0)-x;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](g);break}}while(0);c[h>>2]=0}else{if((f|0)<(i|0)){x=g+(f<<4)|0;c[x>>2]=c[h>>2];c[x+4>>2]=c[h+4>>2];c[x+8>>2]=c[h+8>>2];c[x+12>>2]=c[h+12>>2]}f=f+1|0}i=i+1|0}while((i|0)<(c[t>>2]|0));c[t>>2]=f;if((f|0)>=3){Qa=w;return}}else c[t>>2]=2;f=c[u>>2]|0;g=v+412|0;if((f|0)==(g|0)){Qa=w;return};c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];c[g+16>>2]=c[f+16>>2];c[g+20>>2]=c[f+20>>2];c[g+24>>2]=c[f+24>>2];c[g+28>>2]=c[f+28>>2];do if(f|0){if(c[v+480>>2]|0){Vd(v,f);break}x=f;if((c[v+304>>2]|0)>>>0<=x>>>0?(c[v+308>>2]|0)>>>0>x>>>0:0){x=v+300|0;c[f>>2]=c[x>>2];c[x>>2]=f;break}if(!(c[7324]|0)){_a[c[29344>>2]&127](f);break}else{x=Ua[c[29352>>2]&127](f)|0;c[14978]=(c[14978]|0)-x;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](f);break}}while(0);c[u>>2]=g;Qa=w;return}c[r>>2]=n;Ab(128,o,46756,r)|0}else s=15;while(0);if((s|0)==15){c[p>>2]=n;Ab(128,o,46709,p)|0}c[e+20>>2]=1;wc(c[e>>2]|0,o,-1,1,-1)|0;Qa=w;return}function en(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if(c[f+56>>2]|0)return;h=c[f+8>>2]|0;if(!h)return;p=f+72|0;o=e+116|0;if(!g){do{i=c[p>>2]|0;if(!i)f=-1e6;else{j=c[(c[e>>2]|0)+16>>2]|0;f=0;while(1)if((c[j+(f<<4)+12>>2]|0)==(i|0))break;else f=f+1|0}l=c[o>>2]|0;l=(l|0)==0?e:l;i=l+84|0;j=c[i>>2]|0;k=1<<f;if((j&k|0)==0?(c[i>>2]=j|k,(f|0)==1):0)Me(l)|0;g=l+80|0;c[g>>2]=c[g>>2]|k;$k(e,h,-1);h=c[h+20>>2]|0}while((h|0)!=0);return}do{f=b[h+52>>1]|0;a:do if(f<<16>>16){m=c[h+4>>2]|0;n=h+32|0;l=f&65535;k=0;while(1){if((b[m+(k<<1)>>1]|0)>-1){i=c[(c[n>>2]|0)+(k<<2)>>2]|0;j=a[i>>0]|0;f=(d[208+(j&255)>>0]|0)-(d[208+(d[g>>0]|0)>>0]|0)|0;if(!(j<<24>>24==0|(f|0)!=0)){j=g;do{i=i+1|0;j=j+1|0;q=a[i>>0]|0;f=(d[208+(q&255)>>0]|0)-(d[208+(d[j>>0]|0)>>0]|0)|0}while(!(q<<24>>24==0|(f|0)!=0))}if(!f)break}k=k+1|0;if(k>>>0>=l>>>0)break a}i=c[p>>2]|0;if(!i)f=-1e6;else{j=c[(c[e>>2]|0)+16>>2]|0;f=0;while(1)if((c[j+(f<<4)+12>>2]|0)==(i|0))break;else f=f+1|0}l=c[o>>2]|0;l=(l|0)==0?e:l;i=l+84|0;j=c[i>>2]|0;k=1<<f;if((j&k|0)==0?(c[i>>2]=j|k,(f|0)==1):0)Me(l)|0;q=l+80|0;c[q>>2]=c[q>>2]|k;$k(e,h,-1)}while(0);h=c[h+20>>2]|0}while((h|0)!=0);return}function fn(d,f,g,h,i){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;A=Qa;Qa=Qa+96|0;t=A+64|0;r=A+48|0;q=A+32|0;p=A+16|0;o=A;y=A+80|0;z=A+92|0;x=c[d>>2]|0;m=d+8|0;j=c[m>>2]|0;do if(!j){if((c[d+116>>2]|0)==0?(b[x+76>>1]&8)==0:0)a[d+23>>0]=1;a:do if(c[x+272>>2]|0){if(!(a[x+81>>0]|0))l=15}else{do if((e[x+276>>1]|0)>=224){j=x+300|0;k=c[j>>2]|0;if(k|0){c[j>>2]=c[k>>2];l=x+284|0;c[l>>2]=(c[l>>2]|0)+1;l=16;break a}j=x+296|0;k=c[j>>2]|0;if(!k){j=x+292|0;break}else{c[j>>2]=c[k>>2];l=x+284|0;c[l>>2]=(c[l>>2]|0)+1;l=16;break a}}else j=x+288|0;while(0);c[j>>2]=(c[j>>2]|0)+1;l=15}while(0);if((l|0)==15){k=Yd(x,224,0)|0;l=16}if((l|0)==16?k|0:0){j=k+104|0;l=j+120|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(l|0));c[k>>2]=x;j=x+4|0;l=c[j>>2]|0;if(l|0)c[l+4>>2]=k;c[k+8>>2]=l;c[k+4>>2]=0;c[j>>2]=k;c[k+20>>2]=381479589;c[k+12>>2]=d;c[m>>2]=k;Bi(k,61,0,1,0)|0;u=k;break}Qa=A;return}else u=j;while(0);n=(c[x+16>>2]|0)+(f<<4)|0;j=d+92|0;v=u+108|0;s=u+112|0;w=u+104|0;k=c[n>>2]|0;l=Qd(x,35174,k)|0;m=(l|0)==0;do if(!h){do if(!m){k=c[l+28>>2]|0;c[y>>2]=k;a[z>>0]=0;Fj(d,f,k,1,35174);j=c[v>>2]|0;if((c[s>>2]|0)>(j|0)){c[v>>2]=j+1;l=c[w>>2]|0;a[l+(j*20|0)>>0]=-119;b[l+(j*20|0)+2>>1]=0;c[l+(j*20|0)+4>>2]=k;c[l+(j*20|0)+8>>2]=f;c[l+(j*20|0)+12>>2]=0;c[l+(j*20|0)+16>>2]=0;a[l+(j*20|0)+1>>0]=0;l=0;break}else{Bi(u,137,k,f,0)|0;l=0;break}}else{c[o>>2]=k;c[o+4>>2]=35174;c[o+8>>2]=46824;yk(d,46863,o);k=c[j>>2]|0;c[y>>2]=k;a[z>>0]=16;l=16}while(0);j=Qd(x,46837,c[n>>2]|0)|0;do if(j|0){j=c[j+28>>2]|0;c[y+4>>2]=j;a[z+1>>0]=0;Fj(d,f,j,1,46837);m=c[v>>2]|0;if((c[s>>2]|0)>(m|0)){c[v>>2]=m+1;t=c[w>>2]|0;a[t+(m*20|0)>>0]=-119;b[t+(m*20|0)+2>>1]=0;c[t+(m*20|0)+4>>2]=j;c[t+(m*20|0)+8>>2]=f;c[t+(m*20|0)+12>>2]=0;c[t+(m*20|0)+16>>2]=0;a[t+(m*20|0)+1>>0]=0;break}else{Bi(u,137,j,f,0)|0;break}}while(0);j=Qd(x,46850,c[n>>2]|0)|0;if(j){m=c[j+28>>2]|0;c[y+8>>2]=m;a[z+2>>0]=0;Fj(d,f,m,1,46850);j=c[v>>2]|0;if((c[s>>2]|0)>(j|0)){c[v>>2]=j+1;z=c[w>>2]|0;a[z+(j*20|0)>>0]=-119;b[z+(j*20|0)+2>>1]=0;c[z+(j*20|0)+4>>2]=m;c[z+(j*20|0)+8>>2]=f;c[z+(j*20|0)+12>>2]=0;c[z+(j*20|0)+16>>2]=0;a[z+(j*20|0)+1>>0]=0;break}else{Bi(u,137,m,f,0)|0;break}}}else{if(m){c[p>>2]=k;c[p+4>>2]=35174;c[p+8>>2]=46824;yk(d,46863,p);k=c[j>>2]|0;c[y>>2]=k;a[z>>0]=16;l=16}else{k=c[l+28>>2]|0;c[y>>2]=k;a[z>>0]=0;Fj(d,f,k,1,35174);c[q>>2]=c[n>>2];c[q+4>>2]=35174;c[q+8>>2]=i;c[q+12>>2]=h;yk(d,42751,q);l=0}j=c[n>>2]|0;m=Qd(x,46837,j)|0;if(m){j=c[m+28>>2]|0;c[y+4>>2]=j;a[z+1>>0]=0;Fj(d,f,j,1,46837);c[r>>2]=c[n>>2];c[r+4>>2]=46837;c[r+8>>2]=i;c[r+12>>2]=h;yk(d,42751,r);j=c[n>>2]|0}j=Qd(x,46850,j)|0;if(j){x=c[j+28>>2]|0;c[y+8>>2]=x;a[z+2>>0]=0;Fj(d,f,x,1,46850);c[t>>2]=c[n>>2];c[t+4>>2]=46850;c[t+8>>2]=i;c[t+12>>2]=h;yk(d,42751,t)}}while(0);j=c[v>>2]|0;if((c[s>>2]|0)>(j|0)){c[v>>2]=j+1;z=c[w>>2]|0;a[z+(j*20|0)>>0]=109;b[z+(j*20|0)+2>>1]=0;c[z+(j*20|0)+4>>2]=g;c[z+(j*20|0)+8>>2]=k;c[z+(j*20|0)+12>>2]=f;c[z+(j*20|0)+16>>2]=0;a[z+(j*20|0)+1>>0]=0}else j=Bi(u,109,g,k,f)|0;if(!(a[(c[u>>2]|0)+81>>0]|0)){g=c[w>>2]|0;a[g+(j*20|0)+1>>0]=-3;c[g+(j*20|0)+16>>2]=3}j=c[v>>2]|0;if((j|0)<=0){Qa=A;return}b[(c[w>>2]|0)+((j+-1|0)*20|0)+2>>1]=l&255;Qa=A;return}function gn(f,g,h,i,j,k){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0;fa=Qa;Qa=Qa+16|0;t=fa+8|0;s=fa;Z=c[f>>2]|0;_=j+1|0;$=j+2|0;ea=j+3|0;da=j+4|0;ca=j+5|0;ba=j+6|0;W=j+7|0;X=f+44|0;Y=c[X>>2]|0;c[X>>2]=(Y|0)>(W|0)?Y:W;Y=f+8|0;l=c[Y>>2]|0;if(!l){if((c[f+116>>2]|0)==0?(b[Z+76>>1]&8)==0:0)a[f+23>>0]=1;a:do if(c[Z+272>>2]|0)if(!(a[Z+81>>0]|0))V=15;else{Qa=fa;return}else{do if((e[Z+276>>1]|0)>=224){l=Z+300|0;m=c[l>>2]|0;if(m|0){c[l>>2]=c[m>>2];aa=Z+284|0;c[aa>>2]=(c[aa>>2]|0)+1;break a}l=Z+296|0;m=c[l>>2]|0;if(!m){l=Z+292|0;break}else{c[l>>2]=c[m>>2];aa=Z+284|0;c[aa>>2]=(c[aa>>2]|0)+1;break a}}else l=Z+288|0;while(0);c[l>>2]=(c[l>>2]|0)+1;V=15}while(0);if((V|0)==15)m=Yd(Z,224,0)|0;if(!m){Qa=fa;return}o=m+104|0;p=o+120|0;do{c[o>>2]=0;o=o+4|0}while((o|0)<(p|0));c[m>>2]=Z;l=Z+4|0;n=c[l>>2]|0;if(n|0)c[n+4>>2]=m;c[m+8>>2]=n;c[m+4>>2]=0;c[l>>2]=m;c[m+20>>2]=381479589;c[m+12>>2]=f;c[Y>>2]=m;Bi(m,61,0,1,0)|0;aa=m}else aa=l;if((g|0)==0|(aa|0)==0){Qa=fa;return}q=g+28|0;m=c[q>>2]|0;if(!m){Qa=fa;return}l=c[g>>2]|0;if(!(kd(46886,l,31415,92)|0)){Qa=fa;return}o=c[g+72>>2]|0;p=c[Z+16>>2]|0;if(!o)n=-1e6;else{n=0;while(1)if((c[p+(n<<4)+12>>2]|0)==(o|0))break;else n=n+1|0}o=c[p+(n<<4)>>2]|0;p=c[f>>2]|0;do if(((a[p+165>>0]|0)==0?(a[f+200>>0]|0)==0:0)?(r=c[p+312>>2]|0,(r|0)!=0):0){l=Za[r&127](c[p+316>>2]|0,28,l,0,o,c[f+240>>2]|0)|0;if((l|0)==1){ad(f,39216,s);c[f+12>>2]=23;Qa=fa;return}if((l|2|0)!=2){ad(f,39231,t);c[f+12>>2]=1;Qa=fa;return}if(!l){m=c[q>>2]|0;l=c[g>>2]|0;break}else{Qa=fa;return}}while(0);Fj(f,n,m,0,l);S=k+1|0;T=k+2|0;m=f+40|0;l=c[m>>2]|0;c[m>>2]=(l|0)>(T|0)?l:T;Ej(f,k,n,g,108);m=c[g>>2]|0;T=aa+108|0;l=c[T>>2]|0;U=aa+112|0;if((c[U>>2]|0)>(l|0)){c[T>>2]=l+1;R=c[aa+104>>2]|0;a[R+(l*20|0)>>0]=110;b[R+(l*20|0)+2>>1]=0;c[R+(l*20|0)+4>>2]=0;c[R+(l*20|0)+8>>2]=da;c[R+(l*20|0)+12>>2]=0;c[R+(l*20|0)+16>>2]=0;a[R+(l*20|0)+1>>0]=0}else l=Bi(aa,110,0,da,0)|0;if(!(a[(c[aa>>2]|0)+81>>0]|0)){if((l|0)<0)l=(c[T>>2]|0)+-1|0;Ci(aa,(c[aa+104>>2]|0)+(l*20|0)|0,m,0)}m=c[g+8>>2]|0;R=(h|0)==0;if(!m)l=1;else{B=g+36|0;C=aa+104|0;D=f+56|0;E=Z+272|0;F=Z+276|0;G=Z+81|0;H=Z+288|0;I=Z+300|0;J=Z+296|0;K=Z+284|0;L=Z+292|0;M=aa+12|0;N=(Z|0)==0;O=Z+480|0;P=Z+304|0;Q=Z+308|0;l=1;do{b:do if(R|(m|0)==(h|0)){l=(c[m+36>>2]|0)==0?0:l;o=m+55|0;o=d[o>>0]|d[o+1>>0]<<8;if(!((c[B>>2]&32|0)!=0&(o&3)==2)){q=e[m+52>>1]|0;p=c[m>>2]|0;if(!(o&8))t=q;else t=e[m+50>>1]|0}else{q=e[m+50>>1]|0;t=q;p=c[g>>2]|0}A=t+-1|0;o=c[T>>2]|0;if((c[U>>2]|0)>(o|0)){c[T>>2]=o+1;z=c[C>>2]|0;a[z+(o*20|0)>>0]=110;b[z+(o*20|0)+2>>1]=0;c[z+(o*20|0)+4>>2]=0;c[z+(o*20|0)+8>>2]=ca;c[z+(o*20|0)+12>>2]=0;c[z+(o*20|0)+16>>2]=0;a[z+(o*20|0)+1>>0]=0}else o=Bi(aa,110,0,ca,0)|0;if(!(a[(c[aa>>2]|0)+81>>0]|0)){if((o|0)<0)o=(c[T>>2]|0)+-1|0;Ci(aa,(c[C>>2]|0)+(o*20|0)|0,p,0)}p=c[X>>2]|0;o=A+W|0;c[X>>2]=(p|0)>(o|0)?p:o;o=c[m+44>>2]|0;p=c[T>>2]|0;if((c[U>>2]|0)>(p|0)){c[T>>2]=p+1;z=c[C>>2]|0;a[z+(p*20|0)>>0]=108;b[z+(p*20|0)+2>>1]=0;c[z+(p*20|0)+4>>2]=S;c[z+(p*20|0)+8>>2]=o;c[z+(p*20|0)+12>>2]=n;c[z+(p*20|0)+16>>2]=0;a[z+(p*20|0)+1>>0]=0}else Bi(aa,108,S,o,n)|0;o=c[Y>>2]|0;r=Gj(f,m)|0;c:do if(r|0){p=c[o>>2]|0;if(!(a[p+81>>0]|0)){y=c[o+104>>2]|0;z=(c[o+108>>2]|0)+-1|0;a[y+(z*20|0)+1>>0]=-9;c[y+(z*20|0)+16>>2]=r;break}if(c[p+480>>2]|0)break;z=(c[r>>2]|0)+-1|0;c[r>>2]=z;if(z|0)break;o=c[r+12>>2]|0;do if(o|0){if(c[o+480>>2]|0){Vd(o,r);break c}p=r;if((c[o+304>>2]|0)>>>0>p>>>0)break;if((c[o+308>>2]|0)>>>0<=p>>>0)break;z=o+300|0;c[r>>2]=c[z>>2];c[z>>2]=r;break c}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](r);break}else{z=Ua[c[29352>>2]&127](r)|0;c[14978]=(c[14978]|0)-z;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](r);break}}while(0);o=c[T>>2]|0;if((c[U>>2]|0)>(o|0)){c[T>>2]=o+1;z=c[C>>2]|0;a[z+(o*20|0)>>0]=70;b[z+(o*20|0)+2>>1]=0;c[z+(o*20|0)+4>>2]=q;c[z+(o*20|0)+8>>2]=$;c[z+(o*20|0)+12>>2]=0;c[z+(o*20|0)+16>>2]=0;a[z+(o*20|0)+1>>0]=0}else Bi(aa,70,q,$,0)|0;s=m+50|0;o=e[s>>1]|0;p=c[T>>2]|0;if((c[U>>2]|0)>(p|0)){c[T>>2]=p+1;z=c[C>>2]|0;a[z+(p*20|0)>>0]=70;b[z+(p*20|0)+2>>1]=0;c[z+(p*20|0)+4>>2]=o;c[z+(p*20|0)+8>>2]=ea;c[z+(p*20|0)+12>>2]=0;c[z+(p*20|0)+16>>2]=0;a[z+(p*20|0)+1>>0]=0}else Bi(aa,70,o,ea,0)|0;o=c[T>>2]|0;if((c[U>>2]|0)>(o|0)){c[T>>2]=o+1;z=c[C>>2]|0;a[z+(o*20|0)>>0]=63;b[z+(o*20|0)+2>>1]=0;c[z+(o*20|0)+4>>2]=0;c[z+(o*20|0)+8>>2]=$;c[z+(o*20|0)+12>>2]=_;c[z+(o*20|0)+16>>2]=0;a[z+(o*20|0)+1>>0]=0}else o=Bi(aa,63,0,$,_)|0;do if(!(a[(c[aa>>2]|0)+81>>0]|0)){if((o|0)<0)o=(c[T>>2]|0)+-1|0;p=c[C>>2]|0;q=p+(o*20|0)+1|0;if(!(a[q>>0]|0)){c[p+(o*20|0)+16>>2]=30184;a[q>>0]=-8;break}else{Ci(aa,p+(o*20|0)|0,30184,-8);break}}while(0);o=c[T>>2]|0;if((o|0)>0)b[(c[C>>2]|0)+((o+-1|0)*20|0)+2>>1]=2;if((c[U>>2]|0)>(o|0)){c[T>>2]=o+1;z=c[C>>2]|0;a[z+(o*20|0)>>0]=36;b[z+(o*20|0)+2>>1]=0;c[z+(o*20|0)+4>>2]=S;c[z+(o*20|0)+8>>2]=0;c[z+(o*20|0)+12>>2]=0;c[z+(o*20|0)+16>>2]=0;a[z+(o*20|0)+1>>0]=0;z=o}else z=Bi(aa,36,S,0,0)|0;o=c[T>>2]|0;if((c[U>>2]|0)>(o|0)){c[T>>2]=o+1;y=c[C>>2]|0;a[y+(o*20|0)>>0]=70;b[y+(o*20|0)+2>>1]=0;c[y+(o*20|0)+4>>2]=0;c[y+(o*20|0)+8>>2]=$;c[y+(o*20|0)+12>>2]=0;c[y+(o*20|0)+16>>2]=0;a[y+(o*20|0)+1>>0]=0}else Bi(aa,70,0,$,0)|0;o=c[T>>2]|0;d:do if(t>>>0>1){y=c[D>>2]|0;w=y+-1|0;c[D>>2]=w;p=A<<2;e:do if(c[E>>2]|0)if(!(a[G>>0]|0))V=105;else break b;else{do if(0<0|(0==0?(e[F>>1]|0)>>>0<p>>>0:0))o=H;else{o=c[I>>2]|0;if(o|0){c[I>>2]=c[o>>2];c[K>>2]=(c[K>>2]|0)+1;x=o;break e}o=c[J>>2]|0;if(!o){o=L;break}c[J>>2]=c[o>>2];c[K>>2]=(c[K>>2]|0)+1;x=o;break e}while(0);c[o>>2]=(c[o>>2]|0)+1;V=105}while(0);if((V|0)==105){V=0;x=Yd(Z,p,0)|0}if(!x)break b;o=c[T>>2]|0;if((c[U>>2]|0)>(o|0)){c[T>>2]=o+1;p=c[C>>2]|0;a[p+(o*20|0)>>0]=11;o=p+(o*20|0)+1|0;p=o+19|0;do{a[o>>0]=0;o=o+1|0}while((o|0)<(p|0))}else Bi(aa,11,0,0,0)|0;r=c[T>>2]|0;do if((A|0)==1){if((b[s>>1]|0)!=1)break;if(!(a[m+54>>0]|0))break;if((c[U>>2]|0)>(r|0)){c[T>>2]=r+1;v=c[C>>2]|0;a[v+(r*20|0)>>0]=51;b[v+(r*20|0)+2>>1]=0;c[v+(r*20|0)+4>>2]=W;c[v+(r*20|0)+8>>2]=w;c[v+(r*20|0)+12>>2]=0;c[v+(r*20|0)+16>>2]=0;a[v+(r*20|0)+1>>0]=0;break}else{Bi(aa,51,W,w,0)|0;break}}while(0);v=m+32|0;u=0;do{o=c[(c[v>>2]|0)+(u<<2)>>2]|0;q=c[f>>2]|0;p=a[q+78>>0]|0;t=a[q+165>>0]|0;q=Xi(q,p,o,t&255)|0;do if(!(t<<24>>24)){if(!q){q=Yi(f,p,0,o)|0;break}if(c[q+12>>2]|0)break;q=Yi(f,p,q,o)|0}while(0);o=c[T>>2]|0;if((c[U>>2]|0)>(o|0)){c[T>>2]=o+1;t=c[C>>2]|0;a[t+(o*20|0)>>0]=70;b[t+(o*20|0)+2>>1]=0;c[t+(o*20|0)+4>>2]=u;c[t+(o*20|0)+8>>2]=$;c[t+(o*20|0)+12>>2]=0;c[t+(o*20|0)+16>>2]=0;a[t+(o*20|0)+1>>0]=0}else Bi(aa,70,u,$,0)|0;o=c[T>>2]|0;if((c[U>>2]|0)>(o|0)){c[T>>2]=o+1;t=c[C>>2]|0;a[t+(o*20|0)>>0]=90;b[t+(o*20|0)+2>>1]=0;c[t+(o*20|0)+4>>2]=S;c[t+(o*20|0)+8>>2]=u;c[t+(o*20|0)+12>>2]=ea;c[t+(o*20|0)+16>>2]=0;a[t+(o*20|0)+1>>0]=0}else Bi(aa,90,S,u,ea)|0;o=u+W|0;p=c[T>>2]|0;if((c[U>>2]|0)>(p|0)){c[T>>2]=p+1;t=c[C>>2]|0;a[t+(p*20|0)>>0]=52;b[t+(p*20|0)+2>>1]=0;c[t+(p*20|0)+4>>2]=ea;c[t+(p*20|0)+8>>2]=0;c[t+(p*20|0)+12>>2]=o;c[t+(p*20|0)+16>>2]=0;a[t+(p*20|0)+1>>0]=0}else p=Bi(aa,52,ea,0,o)|0;do if(!(a[(c[aa>>2]|0)+81>>0]|0)){if((p|0)<0)o=(c[T>>2]|0)+-1|0;else o=p;s=c[C>>2]|0;t=s+(o*20|0)+1|0;if(a[t>>0]|0){Ci(aa,s+(o*20|0)|0,q,-2);break}if(!q)break;c[s+(o*20|0)+16>>2]=q;a[t>>0]=-2}while(0);c[x+(u<<2)>>2]=p;o=c[T>>2]|0;if((o|0)>0)b[(c[C>>2]|0)+((o+-1|0)*20|0)+2>>1]=128;u=u+1|0}while((u|0)<(A|0));if((c[U>>2]|0)>(o|0)){c[T>>2]=o+1;v=c[C>>2]|0;a[v+(o*20|0)>>0]=70;b[v+(o*20|0)+2>>1]=0;c[v+(o*20|0)+4>>2]=A;c[v+(o*20|0)+8>>2]=$;c[v+(o*20|0)+12>>2]=0;c[v+(o*20|0)+16>>2]=0;a[v+(o*20|0)+1>>0]=0}else Bi(aa,70,A,$,0)|0;o=c[T>>2]|0;if((c[U>>2]|0)>(o|0)){c[T>>2]=o+1;v=c[C>>2]|0;a[v+(o*20|0)>>0]=11;b[v+(o*20|0)+2>>1]=0;c[v+(o*20|0)+4>>2]=0;c[v+(o*20|0)+8>>2]=w;c[v+(o*20|0)+12>>2]=0;c[v+(o*20|0)+16>>2]=0;a[v+(o*20|0)+1>>0]=0}else Bi(aa,11,0,w,0)|0;q=c[T>>2]|0;p=a[(c[aa>>2]|0)+81>>0]|0;if(!(p<<24>>24))o=(c[C>>2]|0)+((((r|0)<1?q:r)+-1|0)*20|0)|0;else o=59308;c[o+8>>2]=q;o=0;s=q;while(1){q=c[x+(o<<2)>>2]|0;if(!(p<<24>>24))p=(c[C>>2]|0)+(((q|0)<0?s+-1|0:q)*20|0)|0;else p=59308;c[p+8>>2]=s;p=o+W|0;if((c[U>>2]|0)>(s|0)){c[T>>2]=s+1;w=c[C>>2]|0;a[w+(s*20|0)>>0]=90;b[w+(s*20|0)+2>>1]=0;c[w+(s*20|0)+4>>2]=S;c[w+(s*20|0)+8>>2]=o;c[w+(s*20|0)+12>>2]=p;c[w+(s*20|0)+16>>2]=0;a[w+(s*20|0)+1>>0]=0}else Bi(aa,90,S,o,p)|0;o=o+1|0;if((o|0)>=(A|0))break;p=a[(c[aa>>2]|0)+81>>0]|0;s=c[T>>2]|0}p=c[M>>2]|0;o=0-y|0;if(((c[p+56>>2]|0)+(c[p+60>>2]|0)|0)<0)kk(p,aa,o);else c[(c[p+64>>2]|0)+(o<<2)>>2]=c[T>>2];do if(!N){if(c[O>>2]|0){Vd(Z,x);break d}o=x;if((c[P>>2]|0)>>>0>o>>>0)break;if((c[Q>>2]|0)>>>0<=o>>>0)break;c[x>>2]=c[I>>2];c[I>>2]=x;break d}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](x);break}else{A=Ua[c[29352>>2]&127](x)|0;c[14978]=(c[14978]|0)-A;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](x);break}}else r=o;while(0);o=c[T>>2]|0;if((c[U>>2]|0)>(o|0)){c[T>>2]=o+1;A=c[C>>2]|0;a[A+(o*20|0)>>0]=63;b[A+(o*20|0)+2>>1]=0;c[A+(o*20|0)+4>>2]=1;c[A+(o*20|0)+8>>2]=_;c[A+(o*20|0)+12>>2]=ea;c[A+(o*20|0)+16>>2]=0;a[A+(o*20|0)+1>>0]=0}else o=Bi(aa,63,1,_,ea)|0;do if(!(a[(c[aa>>2]|0)+81>>0]|0)){if((o|0)<0)o=(c[T>>2]|0)+-1|0;p=c[C>>2]|0;q=p+(o*20|0)+1|0;if(!(a[q>>0]|0)){c[p+(o*20|0)+16>>2]=30224;a[q>>0]=-8;break}else{Ci(aa,p+(o*20|0)|0,30224,-8);break}}while(0);o=c[T>>2]|0;if((o|0)>0)b[(c[C>>2]|0)+((o+-1|0)*20|0)+2>>1]=2;if((c[U>>2]|0)>(o|0)){c[T>>2]=o+1;A=c[C>>2]|0;a[A+(o*20|0)>>0]=5;b[A+(o*20|0)+2>>1]=0;c[A+(o*20|0)+4>>2]=S;c[A+(o*20|0)+8>>2]=r;c[A+(o*20|0)+12>>2]=0;c[A+(o*20|0)+16>>2]=0;a[A+(o*20|0)+1>>0]=0}else Bi(aa,5,S,r,0)|0;o=c[T>>2]|0;if((c[U>>2]|0)>(o|0)){c[T>>2]=o+1;A=c[C>>2]|0;a[A+(o*20|0)>>0]=63;b[A+(o*20|0)+2>>1]=0;c[A+(o*20|0)+4>>2]=0;c[A+(o*20|0)+8>>2]=_;c[A+(o*20|0)+12>>2]=ba;c[A+(o*20|0)+16>>2]=0;a[A+(o*20|0)+1>>0]=0}else o=Bi(aa,63,0,_,ba)|0;do if(!(a[(c[aa>>2]|0)+81>>0]|0)){if((o|0)<0)o=(c[T>>2]|0)+-1|0;p=c[C>>2]|0;q=p+(o*20|0)+1|0;if(!(a[q>>0]|0)){c[p+(o*20|0)+16>>2]=30264;a[q>>0]=-8;break}else{Ci(aa,p+(o*20|0)|0,30264,-8);break}}while(0);o=c[T>>2]|0;if((o|0)>0)b[(c[C>>2]|0)+((o+-1|0)*20|0)+2>>1]=1;if((c[U>>2]|0)>(o|0)){c[T>>2]=o+1;A=c[C>>2]|0;a[A+(o*20|0)>>0]=92;b[A+(o*20|0)+2>>1]=0;c[A+(o*20|0)+4>>2]=da;c[A+(o*20|0)+8>>2]=3;c[A+(o*20|0)+12>>2]=ea;c[A+(o*20|0)+16>>2]=0;a[A+(o*20|0)+1>>0]=0}else o=Bi(aa,92,da,3,ea)|0;if(!(a[(c[aa>>2]|0)+81>>0]|0)){if((o|0)<0)o=(c[T>>2]|0)+-1|0;Ci(aa,(c[C>>2]|0)+(o*20|0)|0,46896,0)}o=c[T>>2]|0;if((c[U>>2]|0)>(o|0)){c[T>>2]=o+1;A=c[C>>2]|0;a[A+(o*20|0)>>0]=121;b[A+(o*20|0)+2>>1]=0;c[A+(o*20|0)+4>>2]=i;c[A+(o*20|0)+8>>2]=j;c[A+(o*20|0)+12>>2]=0;c[A+(o*20|0)+16>>2]=0;a[A+(o*20|0)+1>>0]=0}else Bi(aa,121,i,j,0)|0;o=c[T>>2]|0;if((c[U>>2]|0)>(o|0)){c[T>>2]=o+1;A=c[C>>2]|0;a[A+(o*20|0)>>0]=122;b[A+(o*20|0)+2>>1]=0;c[A+(o*20|0)+4>>2]=i;c[A+(o*20|0)+8>>2]=ea;c[A+(o*20|0)+12>>2]=j;c[A+(o*20|0)+16>>2]=0;a[A+(o*20|0)+1>>0]=0}else Bi(aa,122,i,ea,j)|0;p=c[T>>2]|0;if((p|0)>0)b[(c[C>>2]|0)+((p+-1|0)*20|0)+2>>1]=8;if(!(a[(c[aa>>2]|0)+81>>0]|0))o=(c[C>>2]|0)+(((z|0)<0?p+-1|0:z)*20|0)|0;else o=59308;c[o+8>>2]=p}while(0);m=c[m+20>>2]|0}while((m|0)!=0)}if(l<<24>>24==0|R^1){Qa=fa;return}l=c[T>>2]|0;if((c[U>>2]|0)>(l|0)){c[T>>2]=l+1;$=c[aa+104>>2]|0;a[$+(l*20|0)>>0]=93;b[$+(l*20|0)+2>>1]=0;c[$+(l*20|0)+4>>2]=k;c[$+(l*20|0)+8>>2]=ba;c[$+(l*20|0)+12>>2]=0;c[$+(l*20|0)+16>>2]=0;a[$+(l*20|0)+1>>0]=0}else Bi(aa,93,k,ba,0)|0;l=c[T>>2]|0;if((c[U>>2]|0)>(l|0)){c[T>>2]=l+1;n=c[aa+104>>2]|0;a[n+(l*20|0)>>0]=20;b[n+(l*20|0)+2>>1]=0;c[n+(l*20|0)+4>>2]=ba;c[n+(l*20|0)+8>>2]=0;c[n+(l*20|0)+12>>2]=0;c[n+(l*20|0)+16>>2]=0;a[n+(l*20|0)+1>>0]=0;n=l}else n=Bi(aa,20,ba,0,0)|0;l=c[T>>2]|0;if((c[U>>2]|0)>(l|0)){c[T>>2]=l+1;ba=c[aa+104>>2]|0;a[ba+(l*20|0)>>0]=73;b[ba+(l*20|0)+2>>1]=0;c[ba+(l*20|0)+4>>2]=0;c[ba+(l*20|0)+8>>2]=ca;c[ba+(l*20|0)+12>>2]=0;c[ba+(l*20|0)+16>>2]=0;a[ba+(l*20|0)+1>>0]=0}else Bi(aa,73,0,ca,0)|0;l=c[T>>2]|0;if((c[U>>2]|0)>(l|0)){c[T>>2]=l+1;ca=c[aa+104>>2]|0;a[ca+(l*20|0)>>0]=92;b[ca+(l*20|0)+2>>1]=0;c[ca+(l*20|0)+4>>2]=da;c[ca+(l*20|0)+8>>2]=3;c[ca+(l*20|0)+12>>2]=ea;c[ca+(l*20|0)+16>>2]=0;a[ca+(l*20|0)+1>>0]=0}else l=Bi(aa,92,da,3,ea)|0;if(!(a[(c[aa>>2]|0)+81>>0]|0)){if((l|0)<0)l=(c[T>>2]|0)+-1|0;Ci(aa,(c[aa+104>>2]|0)+(l*20|0)|0,46896,0)}l=c[T>>2]|0;if((c[U>>2]|0)>(l|0)){c[T>>2]=l+1;da=c[aa+104>>2]|0;a[da+(l*20|0)>>0]=121;b[da+(l*20|0)+2>>1]=0;c[da+(l*20|0)+4>>2]=i;c[da+(l*20|0)+8>>2]=j;c[da+(l*20|0)+12>>2]=0;c[da+(l*20|0)+16>>2]=0;a[da+(l*20|0)+1>>0]=0}else Bi(aa,121,i,j,0)|0;l=c[T>>2]|0;if((c[U>>2]|0)>(l|0)){c[T>>2]=l+1;da=c[aa+104>>2]|0;a[da+(l*20|0)>>0]=122;b[da+(l*20|0)+2>>1]=0;c[da+(l*20|0)+4>>2]=i;c[da+(l*20|0)+8>>2]=ea;c[da+(l*20|0)+12>>2]=j;c[da+(l*20|0)+16>>2]=0;a[da+(l*20|0)+1>>0]=0}else Bi(aa,122,i,ea,j)|0;m=c[T>>2]|0;if((m|0)>0)b[(c[aa+104>>2]|0)+((m+-1|0)*20|0)+2>>1]=8;if(!(a[(c[aa>>2]|0)+81>>0]|0))l=(c[aa+104>>2]|0)+(((n|0)<0?m+-1|0:n)*20|0)|0;else l=59308;c[l+8>>2]=m;Qa=fa;return}function hn(d,f,h){d=d|0;f=f|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=c[h>>2]|0;i=e[f+8>>1]|0;do if(!(i&4)){if(i&8|0){o=Kg(+g[f>>3])|0;L()|0;break}if(!(i&18))o=0;else{o=Lg(a[f+10>>0]|0,c[f+12>>2]|0,c[f+16>>2]|0)|0;L()|0}}else o=c[f>>2]|0;while(0);p=o+1&-2;f=c[h+4>>2]|0;i=e[f+8>>1]|0;do if(!(i&4)){if(i&8|0){l=Kg(+g[f>>3])|0;L()|0;break}if(!(i&18))l=0;else{l=Lg(a[f+10>>0]|0,c[f+12>>2]|0,c[f+16>>2]|0)|0;L()|0}}else l=c[f>>2]|0;while(0);m=(p<<3)+60|0;n=c[(c[d>>2]|0)+32>>2]|0;h=((m|0)<0)<<31>>31;a:do if(!n){h=Qv(m|0,h|0,-1,-1)|0;i=L()|0;if(!(i>>>0>0|(i|0)==0&h>>>0>2147483390)){if(!(c[7324]|0)){j=Ua[c[29340>>2]&127](m)|0;k=37;break}h=Ua[c[29356>>2]&127](m)|0;if((c[14985]|0)>>>0<m>>>0)c[14985]=m;i=59064;f=c[i>>2]|0;i=c[i+4>>2]|0;if((i|0)>0|(i|0)==0&f>>>0>0){q=c[14978]|0;i=Rv(f|0,i|0,h|0,((h|0)<0)<<31>>31|0)|0;f=L()|0;c[14768]=((f|0)<0|(f|0)==0&i>>>0<=q>>>0)&1}f=Ua[c[29340>>2]&127](h)|0;if(f|0){i=Ua[c[29352>>2]&127](f)|0;i=(c[14978]|0)+i|0;c[14978]=i;if(i>>>0>(c[14982]|0)>>>0)c[14982]=i;i=(c[14981]|0)+1|0;c[14981]=i;if(i>>>0>(c[14987]|0)>>>0){c[14987]=i;k=47}else k=47}}}else{if(c[n+272>>2]|0){if(a[n+81>>0]|0)break}else{do if(!(0<h>>>0|(0==(h|0)?(e[n+276>>1]|0)>>>0<m>>>0:0))){f=n+300|0;i=c[f>>2]|0;if(i|0){c[f>>2]=c[i>>2];j=n+284|0;c[j>>2]=(c[j>>2]|0)+1;j=i;k=37;break a}f=n+296|0;i=c[f>>2]|0;if(!i){f=n+292|0;break}else{c[f>>2]=c[i>>2];j=n+284|0;c[j>>2]=(c[j>>2]|0)+1;j=i;k=37;break a}}else f=n+288|0;while(0);c[f>>2]=(c[f>>2]|0)+1}j=Yd(n,m,h)|0;k=37}while(0);if((k|0)==37?j|0:0){f=j;k=47}if((k|0)==47){ew(f|0,0,m|0)|0;c[f+56>>2]=n;c[f>>2]=0;c[f+8>>2]=o;c[f+12>>2]=l;q=f+60|0;c[f+24>>2]=q;c[f+20>>2]=q+(p<<2);if((wc(c[d>>2]|0,f,60,0,96)|0)!=18)return;c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;return}f=c[d>>2]|0;i=f+8|0;if(!(b[i>>1]&9216))b[i>>1]=1;else{Bg(f);f=c[d>>2]|0}c[d+20>>2]=7;f=c[f+32>>2]|0;i=f+81|0;if(a[i>>0]|0)return;if(a[f+82>>0]|0)return;a[i>>0]=1;if((c[f+180>>2]|0)>0)c[f+264>>2]=1;q=f+272|0;c[q>>2]=(c[q>>2]|0)+1;f=c[f+236>>2]|0;if(!f)return;c[f+12>>2]=7;return}function jn(a){a=a|0;var b=0,d=0;b=c[a+56>>2]|0;if(!a)return;if(b|0){if(c[b+480>>2]|0){Vd(b,a);return}d=a;if((c[b+304>>2]|0)>>>0<=d>>>0?(c[b+308>>2]|0)>>>0>d>>>0:0){d=b+300|0;c[a>>2]=c[d>>2];c[d>>2]=a;return}}if(!(c[7324]|0)){_a[c[29344>>2]&127](a);return}else{d=Ua[c[29352>>2]&127](a)|0;c[14978]=(c[14978]|0)-d;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](a);return}}function kn(b,d,f){b=b|0;d=d|0;f=f|0;var h=0,i=0,j=0;j=kc(c[f>>2]|0)|0;b=c[f+4>>2]|0;d=e[b+8>>1]|0;do if(!(d&4)){if(d&8|0){i=Kg(+g[b>>3])|0;L()|0;break}if(!(d&18))i=0;else{i=Lg(a[b+10>>0]|0,c[b+12>>2]|0,c[b+16>>2]|0)|0;L()|0}}else i=c[b>>2]|0;while(0);if(!(c[j>>2]|0)){d=j+8|0;if((c[d>>2]|0)<=0){i=c[j>>2]|0;i=i+1|0;c[j>>2]=i;return}f=c[j+20>>2]|0;b=0;do{c[f+(b<<2)>>2]=1;b=b+1|0}while((b|0)<(c[d>>2]|0));i=c[j>>2]|0;i=i+1|0;c[j>>2]=i;return}if((i|0)>0){d=c[j+20>>2]|0;b=0;do{h=d+(b<<2)|0;c[h>>2]=(c[h>>2]|0)+1;b=b+1|0}while((b|0)!=(i|0))}d=j+8|0;if((i|0)>=(c[d>>2]|0)){i=c[j>>2]|0;i=i+1|0;c[j>>2]=i;return}f=c[j+24>>2]|0;h=c[j+20>>2]|0;b=i;do{i=f+(b<<2)|0;c[i>>2]=(c[i>>2]|0)+1;c[h+(b<<2)>>2]=1;b=b+1|0}while((b|0)<(c[d>>2]|0));i=c[j>>2]|0;i=i+1|0;c[j>>2]=i;return}function ln(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;m=Qa;Qa=Qa+16|0;l=m+8|0;i=m;j=kc(c[f>>2]|0)|0;k=j+12|0;h=((c[k>>2]|0)*25|0)+25|0;g=Qv(h|0,((h|0)<0)<<31>>31|0,-1,-1)|0;f=L()|0;do if(!(f>>>0>0|(f|0)==0&g>>>0>2147483390)){if(!(c[7324]|0)){e=Ua[c[29340>>2]&127](h)|0;if(!e)break}else{e=Ua[c[29356>>2]&127](h)|0;if((c[14985]|0)>>>0<h>>>0)c[14985]=h;g=59064;f=c[g>>2]|0;g=c[g+4>>2]|0;if((g|0)>0|(g|0)==0&f>>>0>0){n=c[14978]|0;g=Rv(f|0,g|0,e|0,((e|0)<0)<<31>>31|0)|0;f=L()|0;c[14768]=((f|0)<0|(f|0)==0&g>>>0<=n>>>0)&1}e=Ua[c[29340>>2]&127](e)|0;if(!e)break;f=Ua[c[29352>>2]&127](e)|0;f=(c[14978]|0)+f|0;c[14978]=f;if(f>>>0>(c[14982]|0)>>>0)c[14982]=f;f=(c[14981]|0)+1|0;c[14981]=f;if(f>>>0>(c[14987]|0)>>>0)c[14987]=f}ew(e|0,0,h|0)|0;n=i;c[n>>2]=c[j>>2];c[n+4>>2]=0;Ab(24,e,46929,i)|0;if((c[k>>2]|0)>0){i=j+24|0;g=0;h=e+((Cu(e)|0)&1073741823)|0;while(1){o=(c[(c[i>>2]|0)+(g<<2)>>2]|0)+1|0;f=c[j>>2]|0;n=Qv(o|0,0,-1,-1)|0;f=Qv(n|0,L()|0,f|0,0)|0;o=Yv(f|0,L()|0,o|0,0)|0;f=L()|0;n=l;c[n>>2]=o;c[n+4>>2]=f;Ab(24,h,46934,l)|0;if(!h)f=0;else f=(Cu(h)|0)&1073741823;g=g+1|0;if((g|0)>=(c[k>>2]|0))break;else h=h+f|0}}if((wc(c[d>>2]|0,e,-1,1,90)|0)!=18){Qa=m;return}c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;Qa=m;return}while(0);e=c[d>>2]|0;f=e+8|0;if(!(b[f>>1]&9216))b[f>>1]=1;else{Bg(e);e=c[d>>2]|0}c[d+20>>2]=7;e=c[e+32>>2]|0;f=e+81|0;if(a[f>>0]|0){Qa=m;return}if(a[e+82>>0]|0){Qa=m;return}a[f>>0]=1;if((c[e+180>>2]|0)>0)c[e+264>>2]=1;o=e+272|0;c[o>>2]=(c[o>>2]|0)+1;e=c[e+236>>2]|0;if(!e){Qa=m;return}c[e+12>>2]=7;Qa=m;return}function mn(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;l=Qa;Qa=Qa+16|0;k=l;j=c[e>>2]|0;a:do if(j){f=a[j>>0]|0;do if(!(f<<24>>24)){f=39441;i=3}else{h=f&255;f=208+h|0;if((h|32|0)==115){f=a[j+1>>0]|0;if(!(f<<24>>24)){f=39442;i=3;break}h=f&255;f=208+h|0;if((h|32|0)==113){f=a[j+2>>0]|0;if(!(f<<24>>24)){f=39443;i=3;break}h=f&255;f=208+h|0;if((h|32|0)==108){f=a[j+3>>0]|0;if(!(f<<24>>24)){f=39444;i=3;break}h=f&255;f=208+h|0;if((h|32|0)==105){f=a[j+4>>0]|0;if(!(f<<24>>24)){f=39445;i=3;break}h=f&255;f=208+h|0;if((h|32|0)==116){f=a[j+5>>0]|0;if(!(f<<24>>24)){f=39446;i=3;break}h=f&255;f=208+h|0;if((h|32|0)==101){f=a[j+6>>0]|0;if(!(f<<24>>24)){f=39447;i=3;break}if(f<<24>>24==95)break a;else{h=95;f=208+(f&255)|0}}else h=101}else h=116}else h=105}else h=108}else h=113}else h=115;g=d[f>>0]|0;f=h}while(0);if((i|0)==3){g=0;f=a[208+(d[f>>0]|0)>>0]|0}if((g|0)!=(f&255|0))i=8}else i=8;while(0);if((i|0)==8){if(!(c[e+36>>2]&1024)){k=0;Qa=l;return k|0}f=c[b>>2]|0;if(0==0?(c[f+32>>2]&268435456|0)==0:0){k=0;Qa=l;return k|0}if(c[f+180>>2]|0){k=0;Qa=l;return k|0}}c[k>>2]=j;ad(b,47776,k);k=1;Qa=l;return k|0}function nn(f,g){f=f|0;g=g|0;var h=0,i=0,j=0,k=0;k=Qa;Qa=Qa+32|0;h=k;i=h+20|0;a[i>>0]=1;c[h+4>>2]=127;c[h+8>>2]=128;c[h+24>>2]=0;if(!g){j=0;Qa=k;return j|0}Yj(h,g)|0;if(a[i>>0]|0){j=g;Qa=k;return j|0}if((d[f+200>>0]|0)>1){i=h+8|0;c[i>>2]=0;c[i+4>>2]=0;c[i+8>>2]=0;c[i+12>>2]=0;c[i+16>>2]=0;c[h>>2]=f;c[h+4>>2]=124;Yj(h,g)|0}li(c[f>>2]|0,g);g=c[f>>2]|0;a:do if(c[g+272>>2]|0)if(!(a[g+81>>0]|0))j=15;else{j=0;Qa=k;return j|0}else{do if((e[g+276>>1]|0)>=52){f=g+300|0;h=c[f>>2]|0;if(h|0){c[f>>2]=c[h>>2];i=g+284|0;c[i>>2]=(c[i>>2]|0)+1;break a}f=g+296|0;h=c[f>>2]|0;if(!h){f=g+292|0;break}else{c[f>>2]=c[h>>2];i=g+284|0;c[i>>2]=(c[i>>2]|0)+1;break a}}else f=g+288|0;while(0);c[f>>2]=(c[f>>2]|0)+1;j=15}while(0);if((j|0)==15)h=Yd(g,52,0)|0;if(!h){j=h;Qa=k;return j|0}f=h;g=f+52|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));a[h>>0]=114;b[h+34>>1]=-1;c[h+24>>2]=1;j=h;Qa=k;return j|0}function on(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0;e=c[f>>2]|0;if(!e)return;f=b[e+8>>1]|0;if((f&514)==514?(a[e+10>>0]|0)==1:0)e=c[e+16>>2]|0;else g=5;do if((g|0)==5)if(!(f&1)){e=Eg(e,1)|0;break}else return;while(0);if(!e)return;h=Ud(e)|0;e=c[d>>2]|0;f=((h|0)<0)<<31>>31;g=e+8|0;if(!(b[g>>1]&9216)){d=e;c[d>>2]=h;c[d+4>>2]=f;b[g>>1]=4;return}else{Ng(e,h,f);return}}function pn(b,d,f){b=b|0;d=d|0;f=f|0;d=c[f>>2]|0;f=e[d+8>>1]|0;do if(!(f&4)){if(f&8|0){d=Kg(+g[d>>3])|0;L()|0;f=7;break}if(!(f&18)){d=26464;f=8}else{d=Lg(a[d+10>>0]|0,c[d+12>>2]|0,c[d+16>>2]|0)|0;L()|0;f=7}}else{d=c[d>>2]|0;f=7}while(0);if((f|0)==7)if(d>>>0<7){d=26464+(d<<2)|0;f=8}else d=0;if((f|0)==8)d=c[d>>2]|0;if((wc(c[b>>2]|0,d,-1,1,0)|0)!=18)return;c[b+20>>2]=18;wc(c[b>>2]|0,31223,-1,1,0)|0;return}function qn(a,b,d){a=a|0;b=b|0;d=d|0;if((wc(c[a>>2]|0,31142,-1,1,0)|0)!=18)return;c[a+20>>2]=18;wc(c[a>>2]|0,31223,-1,1,0)|0;return}function rn(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;h=c[g>>2]|0;i=b[h+8>>1]|0;if((h|0)==0|(-1431655766>>>(i&31)&1|0)!=0)return;if((i&514)==514?(a[h+10>>0]|0)==1:0)i=c[h+16>>2]|0;else q=5;do if((q|0)==5)if(!(i&1)){i=Eg(h,1)|0;break}else return;while(0);if(!i)return;k=c[g>>2]|0;h=b[k+8>>1]|0;if((h&2)!=0?(a[k+10>>0]|0)==1:0)h=c[k+12>>2]|0;else q=11;do if((q|0)==11){j=h&65535;if(!(j&16)){if(j&1|0){h=0;break}h=Dg(k,1)|0;break}else{h=c[k+12>>2]|0;if(!(j&16384))break;h=(c[k>>2]|0)+h|0;break}}while(0);a:do if((f|0)!=1){j=c[g+4>>2]|0;if(!j)return;k=b[j+8>>1]|0;if((k&514)==514?(a[j+10>>0]|0)==1:0)p=c[j+16>>2]|0;else q=21;do if((q|0)==21)if(!(k&1)){p=Eg(j,1)|0;break}else return;while(0);if(!p)return;k=a[p>>0]|0;if(k<<24>>24){j=p;l=0;do{f=j+1|0;if((k&255)>191){j=f;while(1){k=a[j>>0]|0;if((k&-64)<<24>>24==-128)j=j+1|0;else break}}else{j=f;k=a[f>>0]|0}l=l+1|0}while(k<<24>>24!=0);f=Wv(l|0,0,5,0)|0;j=L()|0;k=c[e>>2]|0;o=c[(c[k+32>>2]|0)+108>>2]|0;n=((o|0)<0)<<31>>31;if((j|0)>(n|0)|(j|0)==(n|0)&f>>>0>o>>>0){c[e+20>>2]=18;wc(k,31223,-1,1,0)|0;return}o=Qv(f|0,j|0,-1,-1)|0;n=L()|0;do if(!(n>>>0>0|(n|0)==0&o>>>0>2147483390)){if(!(c[7324]|0)){j=Ua[c[29340>>2]&127](f)|0;if(!j)break}else{g=Ua[c[29356>>2]&127](f)|0;if((c[14985]|0)>>>0<f>>>0)c[14985]=f;k=59064;j=c[k>>2]|0;k=c[k+4>>2]|0;if((k|0)>0|(k|0)==0&j>>>0>0){o=c[14978]|0;n=Rv(j|0,k|0,g|0,((g|0)<0)<<31>>31|0)|0;m=L()|0;c[14768]=((m|0)<0|(m|0)==0&n>>>0<=o>>>0)&1}j=Ua[c[29340>>2]&127](g)|0;if(!j)break;k=Ua[c[29352>>2]&127](j)|0;k=(c[14978]|0)+k|0;c[14978]=k;if(k>>>0>(c[14982]|0)>>>0)c[14982]=k;k=(c[14981]|0)+1|0;c[14981]=k;if(k>>>0>(c[14987]|0)>>>0)c[14987]=k}m=j+(l<<2)|0;if(!(a[p>>0]|0))break a;g=0;k=p;while(1){c[j+(g<<2)>>2]=k;f=k+1|0;l=k;if((d[k>>0]|0)>191){k=f;while(1)if((a[k>>0]&-64)<<24>>24==-128)k=k+1|0;else break}else k=f;a[m+g>>0]=k-l;f=g+1|0;if(!(a[k>>0]|0)){o=j;n=j;q=60;break a}else g=f}}while(0);h=c[e>>2]|0;i=h+8|0;if(!(b[i>>1]&9216))b[i>>1]=1;else{Bg(h);h=c[e>>2]|0}c[e+20>>2]=7;h=c[h+32>>2]|0;i=h+81|0;if(a[i>>0]|0)return;if(a[h+82>>0]|0)return;a[i>>0]=1;if((c[h+180>>2]|0)>0)c[h+264>>2]=1;e=h+272|0;c[e>>2]=(c[e>>2]|0)+1;h=c[h+236>>2]|0;if(!h)return;c[h+12>>2]=7;return}}else{p=0;o=30304;m=49513;f=1;n=30304;q=60}while(0);do if((q|0)==60){l=c[(c[e+4>>2]|0)+8>>2]|0;b:do if((l&1|0)!=0&(h|0)>0)do{j=0;while(1){k=a[m+j>>0]|0;g=k&255;if((h|0)>=(g|0)?(Ju(i,c[o+(j<<2)>>2]|0,g)|0)==0:0)break;j=j+1|0;if(j>>>0>=f>>>0){q=67;break b}}g=k&255;i=i+g|0;h=h-g|0}while((h|0)>0);else q=67;while(0);c:do if((q|0)==67)if((l&2|0)!=0&(h|0)>0)while(1){j=0;while(1){k=d[m+j>>0]|0;if((h|0)>=(k|0)?(r=h-k|0,(Ju(i+r|0,c[o+(j<<2)>>2]|0,k)|0)==0):0)break;j=j+1|0;if(j>>>0>=f>>>0)break c}if((r|0)>0)h=r;else{h=r;break}}while(0);if(!((n|0)==0|(p|0)==0))if(!(c[7324]|0)){_a[c[29344>>2]&127](n);break}else{r=Ua[c[29352>>2]&127](n)|0;c[14978]=(c[14978]|0)-r;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](n);break}}while(0);if((wc(c[e>>2]|0,i,h,1,-1)|0)!=18)return;c[e+20>>2]=18;wc(c[e>>2]|0,31223,-1,1,0)|0;return}function sn(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;j=((c[(c[a+4>>2]|0)+8>>2]|0)!=0)<<31>>31;i=c[(c[(c[a+12>>2]|0)+104>>2]|0)+(((c[a+16>>2]|0)+-1|0)*20|0)+16>>2]|0;f=c[e>>2]|0;if(-1431655766>>>(b[f+8>>1]&31)&1|0)return;do if((d|0)>1){h=0;f=1;while(1){g=c[e+(f<<2)>>2]|0;if(-1431655766>>>(b[g+8>>1]&31)&1|0){g=8;break}g=((Rg(c[e+(h<<2)>>2]|0,g,i)|0)^j|0)>-1;h=g?f:h;f=f+1|0;if((f|0)>=(d|0)){g=6;break}}if((g|0)==6){f=c[e+(h<<2)>>2]|0;break}else if((g|0)==8)return}while(0);Bc(a,f);return}function tn(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;g=c[f>>2]|0;e=c[d+8>>2]|0;if(!(b[e+8>>1]&8192))i=Gc(d,40)|0;else i=c[e+16>>2]|0;if(!i)return;h=g+8|0;j=i+8|0;e=(b[j>>1]|0)!=0;if(-1431655766>>>(b[h>>1]&31)&1|0){if(!e)return;c[d+20>>2]=-1;a[d+24>>0]=1;return}if(!e){c[i+32>>2]=c[(c[d>>2]|0)+32>>2];c[i>>2]=c[g>>2];c[i+4>>2]=c[g+4>>2];c[i+8>>2]=c[g+8>>2];c[i+12>>2]=c[g+12>>2];c[i+16>>2]=c[g+16>>2];f=b[j>>1]&-1025;b[j>>1]=f;f=f&65535;if(!(f&18))return;if(b[h>>1]&2048)return;e=(f|4096)&65535;b[j>>1]=e;do if(f&16384){g=i+12|0;f=(c[i>>2]|0)+(c[g>>2]|0)|0;if((f|0)<1)if(!(e&16))break;else e=1;else e=f;if(!(Cg(i,e,1)|0)){ew((c[i+16>>2]|0)+(c[g>>2]|0)|0,0,c[i>>2]|0)|0;c[g>>2]=(c[g>>2]|0)+(c[i>>2]|0);e=b[j>>1]&-16897;b[j>>1]=e;break}else return}while(0);if(!((c[i+24>>2]|0)!=0?(c[i+16>>2]|0)==(c[i+20>>2]|0):0))k=49;do if((k|0)==49)if(!(Hg(i)|0)){e=b[j>>1]|0;break}else return;while(0);b[j>>1]=e&-4097;return}e=(c[(c[d+4>>2]|0)+8>>2]|0)!=0;f=Rg(i,g,c[(c[(c[d+12>>2]|0)+104>>2]|0)+(((c[d+16>>2]|0)+-1|0)*20|0)+16>>2]|0)|0;if(e&(f|0)<0){if(b[j>>1]&9216)Bg(i);c[i>>2]=c[g>>2];c[i+4>>2]=c[g+4>>2];c[i+8>>2]=c[g+8>>2];c[i+12>>2]=c[g+12>>2];c[i+16>>2]=c[g+16>>2];f=b[j>>1]&-1025;b[j>>1]=f;f=f&65535;if(!(f&18))return;if(b[h>>1]&2048)return;e=(f|4096)&65535;b[j>>1]=e;do if(f&16384){g=i+12|0;f=(c[i>>2]|0)+(c[g>>2]|0)|0;if((f|0)<1)if(!(e&16))break;else e=1;else e=f;if(!(Cg(i,e,1)|0)){ew((c[i+16>>2]|0)+(c[g>>2]|0)|0,0,c[i>>2]|0)|0;c[g>>2]=(c[g>>2]|0)+(c[i>>2]|0);e=b[j>>1]&-16897;b[j>>1]=e;break}else return}while(0);if(!((c[i+24>>2]|0)!=0?(c[i+16>>2]|0)==(c[i+20>>2]|0):0))k=22;do if((k|0)==22)if(!(Hg(i)|0)){e=b[j>>1]|0;break}else return;while(0);b[j>>1]=e&-4097;return}if(!((f|0)>0&(e^1))){c[d+20>>2]=-1;a[d+24>>0]=1;return}if(b[j>>1]&9216)Bg(i);c[i>>2]=c[g>>2];c[i+4>>2]=c[g+4>>2];c[i+8>>2]=c[g+8>>2];c[i+12>>2]=c[g+12>>2];c[i+16>>2]=c[g+16>>2];f=b[j>>1]&-1025;b[j>>1]=f;f=f&65535;if(!(f&18))return;if(b[h>>1]&2048)return;e=(f|4096)&65535;b[j>>1]=e;do if(f&16384){g=i+12|0;f=(c[i>>2]|0)+(c[g>>2]|0)|0;if((f|0)<1)if(!(e&16))break;else e=1;else e=f;if(!(Cg(i,e,1)|0)){ew((c[i+16>>2]|0)+(c[g>>2]|0)|0,0,c[i>>2]|0)|0;c[g>>2]=(c[g>>2]|0)+(c[i>>2]|0);e=b[j>>1]&-16897;b[j>>1]=e;break}else return}while(0);if(!((c[i+24>>2]|0)!=0?(c[i+16>>2]|0)==(c[i+20>>2]|0):0))k=36;do if((k|0)==36)if(!(Hg(i)|0)){e=b[j>>1]|0;break}else return;while(0);b[j>>1]=e&-4097;return}function un(a){a=a|0;var d=0,e=0,f=0;d=c[a+8>>2]|0;if(!(b[d+8>>1]&8192))d=Gc(a,0)|0;else d=c[d+16>>2]|0;if(!d)return;e=d+8|0;if(!((b[e>>1]|0)!=0?(Bc(a,d),(b[e>>1]&9216)!=0):0))f=7;if((f|0)==7?(c[d+24>>2]|0)==0:0)return;Ag(d);return}function vn(a){a=a|0;var d=0;d=c[a+8>>2]|0;if(!(b[d+8>>1]&8192))d=Gc(a,0)|0;else d=c[d+16>>2]|0;if(!d)return;if(!(b[d+8>>1]|0))return;Bc(a,d);return}function wn(a,e,f){a=a|0;e=e|0;f=f|0;if((wc(c[a>>2]|0,c[21712+((d[816+(b[(c[f>>2]|0)+8>>1]&31)>>0]|0)+-1<<2)>>2]|0,-1,1,0)|0)!=18)return;c[a+20>>2]=18;wc(c[a>>2]|0,31223,-1,1,0)|0;return}function xn(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;g=c[f>>2]|0;e=b[g+8>>1]|0;switch(a[816+(e&31)>>0]|0){case 2:case 1:case 4:{if((e&2)!=0?(a[g+10>>0]|0)==1:0)f=c[g+12>>2]|0;else i=5;do if((i|0)==5){e=e&65535;if(!(e&16)){if(e&1|0){f=0;break}f=Dg(g,1)|0;break}else{f=c[g+12>>2]|0;if(!(e&16384))break;f=(c[g>>2]|0)+f|0;break}}while(0);e=c[d>>2]|0;g=((f|0)<0)<<31>>31;h=e+8|0;if(!(b[h>>1]&9216)){d=e;c[d>>2]=f;c[d+4>>2]=g;b[h>>1]=4;return}else{Ng(e,f,g);return}}case 3:{if(!g)return;if((e&514)==514?(a[g+10>>0]|0)==1:0)h=c[g+16>>2]|0;else i=17;do if((i|0)==17)if(!(e&1)){h=Eg(g,1)|0;break}else return;while(0);if(!h)return;g=a[h>>0]|0;if(!(g<<24>>24)){f=h;e=h}else{e=h;f=h;do{f=f+1|0;h=a[f>>0]|0;if((g&255)>191&(h&-64)<<24>>24==-128)do{f=f+1|0;e=e+1|0;g=a[f>>0]|0}while((g&-64)<<24>>24==-128);else g=h}while(g<<24>>24!=0)}h=f-e|0;e=c[d>>2]|0;f=((h|0)<0)<<31>>31;g=e+8|0;if(!(b[g>>1]&9216)){d=e;c[d>>2]=h;c[d+4>>2]=f;b[g>>1]=4;return}else{Ng(e,h,f);return}}default:{e=c[d>>2]|0;f=e+8|0;if(!(b[f>>1]&9216)){b[f>>1]=1;return}else{Bg(e);return}}}}function yn(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;g=c[f>>2]|0;e=b[g+8>>1]|0;m=e&31;n=f+4|0;i=c[n>>2]|0;j=b[i+8>>1]|0;l=j&31;if((-1431655766>>>l|-1431655766>>>m)&1|0)return;if((e&2)!=0?(a[g+10>>0]|0)==1:0){h=c[g+12>>2]|0;e=j}else k=5;do if((k|0)==5){e=e&65535;if(!(e&16)){if(e&1|0){h=0;e=j;break}h=Dg(g,1)|0;i=c[n>>2]|0;e=b[i+8>>1]|0;break}else{h=c[g+12>>2]|0;if(!(e&16384)){e=j;break}h=(c[g>>2]|0)+h|0;e=j;break}}while(0);if((e&2)!=0?(a[i+10>>0]|0)==1:0){o=c[i+12>>2]|0;k=18}else k=13;do if((k|0)==13){g=e&65535;if(!(g&16)){if(g&1|0){e=1;i=0;break}o=Dg(i,1)|0;k=18;break}else{e=c[i+12>>2]|0;if(!(g&16384)){o=e;k=18;break}o=(c[i>>2]|0)+e|0;k=18;break}}while(0);a:do if((k|0)==18)if((o|0)>0){g=c[f>>2]|0;do if(!((m|16|0)==16&(l|16|0)==16)){do if(g){e=b[g+8>>1]|0;if((e&514)==514?(a[g+10>>0]|0)==1:0){g=c[g+16>>2]|0;break}if(!(e&1))g=Eg(g,1)|0;else g=0}else g=0;while(0);i=c[n>>2]|0;if(!i)return;e=b[i+8>>1]|0;if((e&514)==514?(a[i+10>>0]|0)==1:0){e=1;k=c[i+16>>2]|0;break}if(!(e&1)){e=1;k=Eg(i,1)|0;break}else return}else{g=kc(g)|0;e=0;k=kc(c[n>>2]|0)|0}while(0);if(!k)return;if((h|0)!=0&(g|0)==0)return;l=a[k>>0]|0;if((o|0)>(h|0)){e=0;i=0}else{b:do if(!e){e=1;while(1){if((a[g>>0]|0)==l<<24>>24?(Ju(g,k,o)|0)==0:0)break b;if((o|0)<(h|0)){e=e+1|0;h=h+-1|0;g=g+1|0}else{e=0;i=0;break a}}}else{e=1;j=g;g=a[g>>0]|0;while(1){if(g<<24>>24==l<<24>>24?(Ju(j,k,o)|0)==0:0)break b;while(1){i=h+-1|0;j=j+1|0;g=a[j>>0]|0;if((g&-64)<<24>>24!=-128)break;else h=i}if((o|0)<(h|0)){e=e+1|0;h=i}else{e=0;i=0;break a}}}while(0);i=0}}else{e=1;i=0}while(0);g=c[d>>2]|0;h=g+8|0;if(!(b[h>>1]&9216)){d=g;c[d>>2]=e;c[d+4>>2]=i;b[h>>1]=4;return}else{Ng(g,e,i);return}}function zn(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=Qa;Qa=Qa+48|0;l=n;k=n+32|0;m=n+8|0;j=c[(c[d>>2]|0)+32>>2]|0;if((e|0)<=0){Qa=n;return}h=c[f>>2]|0;if(!h){Qa=n;return}g=b[h+8>>1]|0;if((g&514)==514?(a[h+10>>0]|0)==1:0)g=c[h+16>>2]|0;else i=6;do if((i|0)==6)if(!(g&1)){g=Eg(h,1)|0;break}else{Qa=n;return}while(0);if(!g){Qa=n;return}c[k>>2]=e+-1;c[k+4>>2]=0;c[k+8>>2]=f+4;h=c[j+108>>2]|0;i=m+4|0;c[i>>2]=0;c[m>>2]=j;c[m+8>>2]=0;e=m+12|0;c[e>>2]=h;h=m+16|0;c[h>>2]=0;a[m+20>>0]=0;f=m+21|0;a[f>>0]=2;c[l>>2]=k;Cb(m,g,l);h=c[h>>2]|0;g=c[i>>2]|0;if(((g|0)!=0?(a[g+h>>0]=0,(c[e>>2]|0)!=0):0)?(a[f>>0]&4)==0:0)g=Zd(m)|0;else g=c[i>>2]|0;if((wc(c[d>>2]|0,g,h,1,116)|0)!=18){Qa=n;return}c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;Qa=n;return}function An(e,f,g){e=e|0;f=f|0;g=g|0;var h=0;f=c[g>>2]|0;if(!f)return;g=b[f+8>>1]|0;if((g&514)==514?(a[f+10>>0]|0)==1:0)f=c[f+16>>2]|0;else h=5;do if((h|0)==5)if(!(g&1)){f=Eg(f,1)|0;break}else return;while(0);if(!f)return;g=a[f>>0]|0;if(!(g<<24>>24))return;h=f+1|0;f=g&255;if((g&255)>191){f=d[2736+(f+-192)>>0]|0;g=a[h>>0]|0;if((g&-64)<<24>>24==-128)do{h=h+1|0;f=f<<6|g&63;g=a[h>>0]|0}while((g&-64)<<24>>24==-128);f=(f&-2|0)==65534|(f>>>0<128|(f&-2048|0)==55296)?65533:f}g=c[e>>2]|0;h=((f|0)<0)<<31>>31;e=g+8|0;if(!(b[e>>1]&9216)){c[g>>2]=f;c[g+4>>2]=h;b[e>>1]=4;return}else{Ng(g,f,h);return}}function Bn(d,f,h){d=d|0;f=f|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=f<<2|1;q=nb(q,((q|0)<0)<<31>>31)|0;if(!q){i=c[d>>2]|0;j=i+8|0;if(!(b[j>>1]&9216))b[j>>1]=1;else{Bg(i);i=c[d>>2]|0}c[d+20>>2]=7;i=c[i+32>>2]|0;j=i+81|0;if(a[j>>0]|0)return;if(a[i+82>>0]|0)return;a[j>>0]=1;if((c[i+180>>2]|0)>0)c[i+264>>2]=1;d=i+272|0;c[d>>2]=(c[d>>2]|0)+1;i=c[i+236>>2]|0;if(!i)return;c[i+12>>2]=7;return}if((f|0)>0){o=0;i=q;do{j=c[h+(o<<2)>>2]|0;k=e[j+8>>1]|0;do if(!(k&4)){if(k&8|0){k=Kg(+g[j>>3])|0;j=L()|0;p=19;break}if(!(k&18)){n=i;m=1;j=0}else{k=Lg(a[j+10>>0]|0,c[j+12>>2]|0,c[j+16>>2]|0)|0;j=L()|0;p=19}}else{k=j;j=c[k+4>>2]|0;k=c[k>>2]|0;p=19}while(0);do if((p|0)==19){p=0;l=k&2097151;if(!(j>>>0>0|(j|0)==0&k>>>0>1114111)){if(l>>>0<128){n=i;m=1;j=l;break}if(l>>>0<2048){a[i>>0]=k>>>6&31|192;n=i+1|0;m=2;j=k&63|128;break}if(l>>>0<65536)j=l;else{a[i>>0]=l>>>18|240;a[i+1>>0]=k>>>12&63|128;a[i+2>>0]=k>>>6&63|128;n=i+3|0;m=4;j=k&63|128;break}}else j=65533;a[i>>0]=j>>>12&15|224;a[i+1>>0]=j>>>6&63|128;n=i+2|0;m=3;j=j&63|128}while(0);i=i+m|0;a[n>>0]=j;o=o+1|0}while((o|0)!=(f|0))}else i=q;i=i-q|0;if((i|0)>=0){if((wc(c[d>>2]|0,q,i,1,90)|0)!=18)return;c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;return}do if(90!=-1)if(!(c[7324]|0)){_a[c[29344>>2]&127](q);break}else{p=Ua[c[29352>>2]&127](q)|0;c[14978]=(c[14978]|0)-p;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](q);break}while(0);if(!d)return;c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;return}function Cn(d,e,f){d=d|0;e=e|0;f=f|0;var h=0.0,i=0,j=0,k=0,l=0;l=Qa;Qa=Qa+16|0;i=l+8|0;j=l;f=c[f>>2]|0;e=b[f+8>>1]|0;switch(a[816+(e&31)>>0]|0){case 1:{e=e&65535;do if(!(e&4)){if(e&8|0){e=Kg(+g[f>>3])|0;f=L()|0;k=8;break}if(!(e&18)){e=0;j=0}else{e=Lg(a[f+10>>0]|0,c[f+12>>2]|0,c[f+16>>2]|0)|0;f=L()|0;k=8}}else{e=f;f=c[e+4>>2]|0;e=c[e>>2]|0;k=8}while(0);do if((k|0)==8)if((f|0)<0){if(!((e|0)==0&(f|0)==-2147483648)){e=Rv(0,0,e|0,f|0)|0;j=L()|0;break}c[d+20>>2]=1;wc(c[d>>2]|0,49524,-1,1,-1)|0;Qa=l;return}else j=f;while(0);f=c[d>>2]|0;i=f+8|0;if(!(b[i>>1]&9216)){d=f;c[d>>2]=e;c[d+4>>2]=j;b[i>>1]=4;Qa=l;return}else{Ng(f,e,j);Qa=l;return}}case 5:{e=c[d>>2]|0;f=e+8|0;if(!(b[f>>1]&9216)){b[f>>1]=1;Qa=l;return}else{Bg(e);Qa=l;return}}default:{e=e&65535;do if(!(e&8)){if(e&4|0){k=f;h=+((c[k>>2]|0)>>>0)+4294967296.0*+(c[k+4>>2]|0);break}if(!(e&18))h=0.0;else h=+Ig(a[f+10>>0]|0,c[f+12>>2]|0,c[f+16>>2]|0)}else h=+g[f>>3];while(0);h=h<0.0?-h:h;e=c[d>>2]|0;f=e+8|0;if(!(b[f>>1]&9216))b[f>>1]=1;else Bg(e);g[i>>3]=h;g[j>>3]=+g[i>>3];if(!(+g[i>>3]==+g[j>>3])){Qa=l;return}g[e>>3]=h;b[f>>1]=8;Qa=l;return}}}function Dn(d,e,f){d=d|0;e=e|0;f=f|0;var h=0,i=0.0,j=0,k=0,l=0,m=0,n=0;n=Qa;Qa=Qa+48|0;j=n+24|0;l=n+16|0;m=n+8|0;k=n;a:do if((e|0)==2){h=c[f+4>>2]|0;e=b[h+8>>1]|0;if(-1431655766>>>(e&31)&1|0){Qa=n;return}e=e&65535;do if(!(e&4)){if(e&8|0){e=Kg(+g[h>>3])|0;L()|0;break}if(!(e&18)){e=0;break a}e=Lg(a[h+10>>0]|0,c[h+12>>2]|0,c[h+16>>2]|0)|0;L()|0}else e=c[h>>2]|0;while(0);if((e|0)<30){if((e|0)<=0){e=0;break}}else e=30}else e=0;while(0);f=c[f>>2]|0;h=b[f+8>>1]|0;if(-1431655766>>>(h&31)&1|0){Qa=n;return}h=h&65535;do if(!(h&8)){if(h&4|0){i=+((c[f>>2]|0)>>>0)+4294967296.0*+(c[f+4>>2]|0);break}if(!(h&18))i=0.0;else i=+Ig(a[f+10>>0]|0,c[f+12>>2]|0,c[f+16>>2]|0)}else i=+g[f>>3];while(0);g[k>>3]=i;h=(e|0)==0;do if(i<9223372036854775808.0&(h&i>=0.0)){i=i+.5;g[k>>3]=+(~~i>>>0>>>0)+4294967296.0*+((+t(i)>=1.0?(i>0.0?~~+H(+s(i/4294967296.0),4294967295.0)>>>0:~~+F((i-+(~~i>>>0))/4294967296.0)>>>0):0)|0)}else{if(i>-9223372036854775808.0&(h&i<0.0)){i=.5-i;g[k>>3]=-(+(~~i>>>0>>>0)+4294967296.0*+((+t(i)>=1.0?(i>0.0?~~+H(+s(i/4294967296.0),4294967295.0)>>>0:~~+F((i-+(~~i>>>0))/4294967296.0)>>>0):0)|0));break}c[j>>2]=e;g[j+8>>3]=i;e=zb(49541,j)|0;if(e|0){Jg(e,k,(Cu(e)|0)&1073741823,1)|0;if(!(c[7324]|0)){_a[c[29344>>2]&127](e);break}else{j=Ua[c[29352>>2]&127](e)|0;c[14978]=(c[14978]|0)-j;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](e);break}}e=c[d>>2]|0;h=e+8|0;if(!(b[h>>1]&9216))b[h>>1]=1;else{Bg(e);e=c[d>>2]|0}c[d+20>>2]=7;e=c[e+32>>2]|0;h=e+81|0;if(a[h>>0]|0){Qa=n;return}if(a[e+82>>0]|0){Qa=n;return}a[h>>0]=1;if((c[e+180>>2]|0)>0)c[e+264>>2]=1;d=e+272|0;c[d>>2]=(c[d>>2]|0)+1;e=c[e+236>>2]|0;if(!e){Qa=n;return}c[e+12>>2]=7;Qa=n;return}while(0);i=+g[k>>3];e=c[d>>2]|0;h=e+8|0;if(!(b[h>>1]&9216))b[h>>1]=1;else Bg(e);g[l>>3]=i;g[m>>3]=+g[l>>3];if(!(+g[l>>3]==+g[m>>3])){Qa=n;return}g[e>>3]=i;b[h>>1]=8;Qa=n;return}function En(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;g=c[f>>2]|0;e=b[g+8>>1]|0;if((e&514)==514?(a[g+10>>0]|0)==1:0){j=c[g+16>>2]|0;f=g}else if(!(e&1)){j=Eg(g,1)|0;f=c[f>>2]|0}else{j=0;f=g}e=b[f+8>>1]|0;if((e&2)!=0?(a[f+10>>0]|0)==1:0)i=c[f+12>>2]|0;else h=9;do if((h|0)==9){e=e&65535;if(!(e&16)){if(e&1|0){i=0;break}i=Dg(f,1)|0;break}else{g=c[f+12>>2]|0;if(!(e&16384)){i=g;break}i=(c[f>>2]|0)+g|0;break}}while(0);if(!j)return;g=Qv(i|0,((i|0)<0)<<31>>31|0,1,0)|0;L()|0;e=c[d>>2]|0;if((i|0)>=(c[(c[e+32>>2]|0)+108>>2]|0)){c[d+20>>2]=18;wc(e,31223,-1,1,0)|0;return}do if(i>>>0<=2147483390){if(!(c[7324]|0)){e=Ua[c[29340>>2]&127](g)|0;if(!e)break}else{f=Ua[c[29356>>2]&127](g)|0;if((c[14985]|0)>>>0<g>>>0)c[14985]=g;g=59064;e=c[g>>2]|0;g=c[g+4>>2]|0;if((g|0)>0|(g|0)==0&e>>>0>0){h=c[14978]|0;g=Rv(e|0,g|0,f|0,((f|0)<0)<<31>>31|0)|0;e=L()|0;c[14768]=((e|0)<0|(e|0)==0&g>>>0<=h>>>0)&1}e=Ua[c[29340>>2]&127](f)|0;if(!e)break;g=Ua[c[29352>>2]&127](e)|0;g=(c[14978]|0)+g|0;c[14978]=g;if(g>>>0>(c[14982]|0)>>>0)c[14982]=g;g=(c[14981]|0)+1|0;c[14981]=g;if(g>>>0>(c[14987]|0)>>>0)c[14987]=g}if((i|0)>0){g=0;do{h=a[j+g>>0]|0;a[e+g>>0]=h&~(a[880+(h&255)>>0]&32);g=g+1|0}while((g|0)!=(i|0))}if((wc(c[d>>2]|0,e,i,1,90)|0)!=18)return;c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;return}while(0);e=c[d>>2]|0;g=e+8|0;if(!(b[g>>1]&9216))b[g>>1]=1;else{Bg(e);e=c[d>>2]|0}c[d+20>>2]=7;e=c[e+32>>2]|0;g=e+81|0;if(a[g>>0]|0)return;if(a[e+82>>0]|0)return;a[g>>0]=1;if((c[e+180>>2]|0)>0)c[e+264>>2]=1;d=e+272|0;c[d>>2]=(c[d>>2]|0)+1;e=c[e+236>>2]|0;if(!e)return;c[e+12>>2]=7;return}function Fn(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0;h=c[g>>2]|0;f=b[h+8>>1]|0;if((f&514)==514?(a[h+10>>0]|0)==1:0){k=c[h+16>>2]|0;g=h}else if(!(f&1)){k=Eg(h,1)|0;g=c[g>>2]|0}else{k=0;g=h}f=b[g+8>>1]|0;if((f&2)!=0?(a[g+10>>0]|0)==1:0)j=c[g+12>>2]|0;else i=9;do if((i|0)==9){f=f&65535;if(!(f&16)){if(f&1|0){j=0;break}j=Dg(g,1)|0;break}else{h=c[g+12>>2]|0;if(!(f&16384)){j=h;break}j=(c[g>>2]|0)+h|0;break}}while(0);if(!k)return;h=Qv(j|0,((j|0)<0)<<31>>31|0,1,0)|0;L()|0;f=c[e>>2]|0;if((j|0)>=(c[(c[f+32>>2]|0)+108>>2]|0)){c[e+20>>2]=18;wc(f,31223,-1,1,0)|0;return}do if(j>>>0<=2147483390){if(!(c[7324]|0)){f=Ua[c[29340>>2]&127](h)|0;if(!f)break}else{g=Ua[c[29356>>2]&127](h)|0;if((c[14985]|0)>>>0<h>>>0)c[14985]=h;h=59064;f=c[h>>2]|0;h=c[h+4>>2]|0;if((h|0)>0|(h|0)==0&f>>>0>0){i=c[14978]|0;h=Rv(f|0,h|0,g|0,((g|0)<0)<<31>>31|0)|0;f=L()|0;c[14768]=((f|0)<0|(f|0)==0&h>>>0<=i>>>0)&1}f=Ua[c[29340>>2]&127](g)|0;if(!f)break;h=Ua[c[29352>>2]&127](f)|0;h=(c[14978]|0)+h|0;c[14978]=h;if(h>>>0>(c[14982]|0)>>>0)c[14982]=h;h=(c[14981]|0)+1|0;c[14981]=h;if(h>>>0>(c[14987]|0)>>>0)c[14987]=h}if((j|0)>0){h=0;do{a[f+h>>0]=a[208+(d[k+h>>0]|0)>>0]|0;h=h+1|0}while((h|0)!=(j|0))}if((wc(c[e>>2]|0,f,j,1,90)|0)!=18)return;c[e+20>>2]=18;wc(c[e>>2]|0,31223,-1,1,0)|0;return}while(0);f=c[e>>2]|0;h=f+8|0;if(!(b[h>>1]&9216))b[h>>1]=1;else{Bg(f);f=c[e>>2]|0}c[e+20>>2]=7;f=c[f+32>>2]|0;h=f+81|0;if(a[h>>0]|0)return;if(a[f+82>>0]|0)return;a[h>>0]=1;if((c[f+180>>2]|0)>0)c[f+264>>2]=1;e=f+272|0;c[e>>2]=(c[e>>2]|0)+1;f=c[f+236>>2]|0;if(!f)return;c[f+12>>2]=7;return}function Gn(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;l=kc(c[g>>2]|0)|0;h=c[g>>2]|0;f=b[h+8>>1]|0;if((f&2)!=0?(a[h+10>>0]|0)==1:0)g=c[h+12>>2]|0;else i=4;do if((i|0)==4){f=f&65535;if(!(f&16)){if(f&1|0){g=0;break}g=Dg(h,1)|0;break}else{g=c[h+12>>2]|0;if(!(f&16384))break;g=(c[h>>2]|0)+g|0;break}}while(0);i=aw(g|0,((g|0)<0)<<31>>31|0,1)|0;f=L()|0;i=i|1;h=c[e>>2]|0;k=c[(c[h+32>>2]|0)+108>>2]|0;j=((k|0)<0)<<31>>31;if((f|0)>(j|0)|(f|0)==(j|0)&i>>>0>k>>>0){c[e+20>>2]=18;wc(h,31223,-1,1,0)|0;return}k=Qv(i|0,f|0,-1,-1)|0;j=L()|0;do if(!(j>>>0>0|(j|0)==0&k>>>0>2147483390)){if(!(c[7324]|0)){f=Ua[c[29340>>2]&127](i)|0;if(!f)break;else h=f}else{j=Ua[c[29356>>2]&127](i)|0;if((c[14985]|0)>>>0<i>>>0)c[14985]=i;h=59064;f=c[h>>2]|0;h=c[h+4>>2]|0;if((h|0)>0|(h|0)==0&f>>>0>0){k=c[14978]|0;i=Rv(f|0,h|0,j|0,((j|0)<0)<<31>>31|0)|0;h=L()|0;c[14768]=((h|0)<0|(h|0)==0&i>>>0<=k>>>0)&1}h=Ua[c[29340>>2]&127](j)|0;if(!h)break;f=Ua[c[29352>>2]&127](h)|0;f=(c[14978]|0)+f|0;c[14978]=f;if(f>>>0>(c[14982]|0)>>>0)c[14982]=f;f=(c[14981]|0)+1|0;c[14981]=f;if(f>>>0>(c[14987]|0)>>>0)c[14987]=f}k=g<<1;if((g|0)>0){j=h;f=l;i=0;while(1){l=d[f>>0]|0;a[j>>0]=a[21744+(l>>>4)>>0]|0;a[j+1>>0]=a[21744+(l&15)>>0]|0;i=i+1|0;if((i|0)==(g|0))break;else{j=j+2|0;f=f+1|0}}f=h+k|0}else f=h;a[f>>0]=0;if((wc(c[e>>2]|0,h,k,1,90)|0)!=18)return;c[e+20>>2]=18;wc(c[e>>2]|0,31223,-1,1,0)|0;return}while(0);f=c[e>>2]|0;g=f+8|0;if(!(b[g>>1]&9216))b[g>>1]=1;else{Bg(f);f=c[e>>2]|0}c[e+20>>2]=7;f=c[f+32>>2]|0;g=f+81|0;if(a[g>>0]|0)return;if(a[f+82>>0]|0)return;a[g>>0]=1;if((c[f+180>>2]|0)>0)c[f+264>>2]=1;e=f+272|0;c[e>>2]=(c[e>>2]|0)+1;f=c[f+236>>2]|0;if(!f)return;c[f+12>>2]=7;return}function Hn(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0,h=0;h=Qa;Qa=Qa+16|0;d=h;Db(8,d);f=d;e=c[f>>2]|0;f=c[f+4>>2]|0;if((f|0)<0){g=Rv(0,0,e|0,f&2147483647|0)|0;f=L()|0;e=d;c[e>>2]=g;c[e+4>>2]=f}else g=e;d=c[a>>2]|0;e=d+8|0;if(!(b[e>>1]&9216)){a=d;c[a>>2]=g;c[a+4>>2]=f;b[e>>1]=4;Qa=h;return}else{Ng(d,g,f);Qa=h;return}}function In(d,f,h){d=d|0;f=f|0;h=h|0;var i=0,j=0,k=0;f=c[h>>2]|0;h=e[f+8>>1]|0;do if(!(h&4)){if(h&8|0){h=Kg(+g[f>>3])|0;f=L()|0;j=7;break}if(!(h&18)){i=0;f=1}else{h=Lg(a[f+10>>0]|0,c[f+12>>2]|0,c[f+16>>2]|0)|0;f=L()|0;j=7}}else{h=f;f=c[h+4>>2]|0;h=c[h>>2]|0;j=7}while(0);if((j|0)==7){j=(f|0)>0|(f|0)==0&h>>>0>1;i=j?f:0;f=j?h:1}h=c[d>>2]|0;j=c[(c[h+32>>2]|0)+108>>2]|0;k=((j|0)<0)<<31>>31;if((i|0)>(k|0)|(i|0)==(k|0)&f>>>0>j>>>0){c[d+20>>2]=18;wc(h,31223,-1,1,0)|0;return}k=Qv(f|0,i|0,-1,-1)|0;j=L()|0;do if(!(j>>>0>0|(j|0)==0&k>>>0>2147483390)){if(!(c[7324]|0)){h=Ua[c[29340>>2]&127](f)|0;if(!h)break}else{h=Ua[c[29356>>2]&127](f)|0;if((c[14985]|0)>>>0<f>>>0)c[14985]=f;j=59064;i=c[j>>2]|0;j=c[j+4>>2]|0;if((j|0)>0|(j|0)==0&i>>>0>0){k=c[14978]|0;j=Rv(i|0,j|0,h|0,((h|0)<0)<<31>>31|0)|0;i=L()|0;c[14768]=((i|0)<0|(i|0)==0&j>>>0<=k>>>0)&1}h=Ua[c[29340>>2]&127](h)|0;if(!h)break;i=Ua[c[29352>>2]&127](h)|0;i=(c[14978]|0)+i|0;c[14978]=i;if(i>>>0>(c[14982]|0)>>>0)c[14982]=i;i=(c[14981]|0)+1|0;c[14981]=i;if(i>>>0>(c[14987]|0)>>>0)c[14987]=i}Db(f,h);if((wc(c[d>>2]|0,h,f,0,90)|0)!=18)return;c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;return}while(0);f=c[d>>2]|0;h=f+8|0;if(!(b[h>>1]&9216))b[h>>1]=1;else{Bg(f);f=c[d>>2]|0}c[d+20>>2]=7;f=c[f+32>>2]|0;h=f+81|0;if(a[h>>0]|0)return;if(a[f+82>>0]|0)return;a[h>>0]=1;if((c[f+180>>2]|0)>0)c[f+264>>2]=1;k=f+272|0;c[k>>2]=(c[k>>2]|0)+1;f=c[f+236>>2]|0;if(!f)return;c[f+12>>2]=7;return}function Jn(a,b,d){a=a|0;b=b|0;d=d|0;if(!(Rg(c[d>>2]|0,c[d+4>>2]|0,c[(c[(c[a+12>>2]|0)+104>>2]|0)+(((c[a+16>>2]|0)+-1|0)*20|0)+16>>2]|0)|0))return;Bc(a,c[d>>2]|0);return}function Kn(a,b,d){a=a|0;b=b|0;d=d|0;if((wc(c[a>>2]|0,31497,-1,1,0)|0)!=18)return;c[a+20>>2]=18;wc(c[a>>2]|0,31223,-1,1,0)|0;return}function Ln(d,f,h){d=d|0;f=f|0;h=h|0;var i=0,j=0,k=0;k=Qa;Qa=Qa+16|0;j=k;d=c[h>>2]|0;f=e[d+8>>1]|0;do if(!(f&4)){if(f&8|0){i=Kg(+g[d>>3])|0;L()|0;break}if(!(f&18))i=0;else{i=Lg(a[d+10>>0]|0,c[d+12>>2]|0,c[d+16>>2]|0)|0;L()|0}}else i=c[d>>2]|0;while(0);d=c[h+4>>2]|0;do if(d){f=b[d+8>>1]|0;if((f&514)==514?(a[d+10>>0]|0)==1:0){d=c[d+16>>2]|0;break}if(!(f&1))d=Eg(d,1)|0;else d=0}else d=0;while(0);c[j>>2]=d;Bb(i,31408,j);Qa=k;return}function Mn(e,f,h){e=e|0;f=f|0;h=h|0;var i=0,j=0.0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=Qa;Qa=Qa+80|0;n=q+72|0;m=q+64|0;k=q+56|0;l=q;i=c[h>>2]|0;f=b[i+8>>1]|0;switch(a[816+(f&31)>>0]|0){case 2:{f=f&65535;do if(!(f&8)){if(f&4|0){p=i;j=+((c[p>>2]|0)>>>0)+4294967296.0*+(c[p+4>>2]|0);break}if(!(f&18))j=0.0;else j=+Ig(a[i+10>>0]|0,c[i+12>>2]|0,c[i+16>>2]|0)}else j=+g[i>>3];while(0);g[m>>3]=j;Ab(50,l,32529,m)|0;Jg(l,k,20,1)|0;if(j!=+g[k>>3]){g[n>>3]=j;Ab(50,l,49546,n)|0}if((wc(c[e>>2]|0,l,-1,1,-1)|0)==18){c[e+20>>2]=18;wc(c[e>>2]|0,31223,-1,1,0)|0}Qa=q;return}case 1:{Bc(e,i);Qa=q;return}case 4:{m=kc(i)|0;h=c[h>>2]|0;f=b[h+8>>1]|0;if((f&2)!=0?(a[h+10>>0]|0)==1:0)l=c[h+12>>2]|0;else o=17;do if((o|0)==17){f=f&65535;if(!(f&16)){if(f&1|0){l=0;break}l=Dg(h,1)|0;break}else{i=c[h+12>>2]|0;if(!(f&16384)){l=i;break}l=(c[h>>2]|0)+i|0;break}}while(0);f=aw(l|0,((l|0)<0)<<31>>31|0,1)|0;i=L()|0;k=Qv(f|0,i|0,4,0)|0;n=L()|0;h=c[e>>2]|0;p=c[(c[h+32>>2]|0)+108>>2]|0;o=((p|0)<0)<<31>>31;if((n|0)>(o|0)|(n|0)==(o|0)&k>>>0>p>>>0){c[e+20>>2]=18;wc(h,31223,-1,1,0)|0;Qa=q;return}p=Qv(f|0,i|0,3,0)|0;o=L()|0;do if(!(o>>>0>0|(o|0)==0&p>>>0>2147483390)){if(!(c[7324]|0)){f=Ua[c[29340>>2]&127](k)|0;if(!f)break}else{h=Ua[c[29356>>2]&127](k)|0;if((c[14985]|0)>>>0<k>>>0)c[14985]=k;i=59064;f=c[i>>2]|0;i=c[i+4>>2]|0;if((i|0)>0|(i|0)==0&f>>>0>0){p=c[14978]|0;o=Rv(f|0,i|0,h|0,((h|0)<0)<<31>>31|0)|0;n=L()|0;c[14768]=((n|0)<0|(n|0)==0&o>>>0<=p>>>0)&1}f=Ua[c[29340>>2]&127](h)|0;if(!f)break;i=Ua[c[29352>>2]&127](f)|0;i=(c[14978]|0)+i|0;c[14978]=i;if(i>>>0>(c[14982]|0)>>>0)c[14982]=i;i=(c[14981]|0)+1|0;c[14981]=i;if(i>>>0>(c[14987]|0)>>>0)c[14987]=i}if((l|0)>0){i=0;do{o=m+i|0;p=i<<1;a[f+(p+2)>>0]=a[21744+((d[o>>0]|0)>>>4)>>0]|0;a[f+(p+3)>>0]=a[21744+(a[o>>0]&15)>>0]|0;i=i+1|0}while((i|0)!=(l|0))}p=l<<1;a[f+(p+2)>>0]=39;a[f+(p+3)>>0]=0;a[f>>0]=88;a[f+1>>0]=39;if((wc(c[e>>2]|0,f,-1,1,-1)|0)==18){c[e+20>>2]=18;wc(c[e>>2]|0,31223,-1,1,0)|0}if(!(c[7324]|0)){_a[c[29344>>2]&127](f);Qa=q;return}else{e=Ua[c[29352>>2]&127](f)|0;c[14978]=(c[14978]|0)-e;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](f);Qa=q;return}}while(0);f=c[e>>2]|0;i=f+8|0;if(!(b[i>>1]&9216))b[i>>1]=1;else{Bg(f);f=c[e>>2]|0}c[e+20>>2]=7;f=c[f+32>>2]|0;i=f+81|0;if(a[i>>0]|0){Qa=q;return}if(a[f+82>>0]|0){Qa=q;return}a[i>>0]=1;if((c[f+180>>2]|0)>0)c[f+264>>2]=1;e=f+272|0;c[e>>2]=(c[e>>2]|0)+1;f=c[f+236>>2]|0;if(!f){Qa=q;return}c[f+12>>2]=7;Qa=q;return}case 3:{if(!i){Qa=q;return}if((f&514)==514?(a[i+10>>0]|0)==1:0)p=c[i+16>>2]|0;else o=57;do if((o|0)==57)if(!(f&1)){p=Eg(i,1)|0;break}else{Qa=q;return}while(0);if(!p){Qa=q;return}h=0;f=0;i=0;a:while(1){switch(a[p+h>>0]|0){case 0:break a;case 39:{f=Qv(f|0,i|0,1,0)|0;i=L()|0;break}default:{}}h=h+1|0}f=Qv(f|0,i|0,h|0,0)|0;i=L()|0;k=Qv(f|0,i|0,3,0)|0;m=L()|0;h=c[e>>2]|0;o=c[(c[h+32>>2]|0)+108>>2]|0;n=((o|0)<0)<<31>>31;if((m|0)>(n|0)|(m|0)==(n|0)&k>>>0>o>>>0){c[e+20>>2]=18;wc(h,31223,-1,1,0)|0;Qa=q;return}o=Qv(f|0,i|0,2,0)|0;n=L()|0;do if(!(n>>>0>0|(n|0)==0&o>>>0>2147483390)){if(!(c[7324]|0)){f=Ua[c[29340>>2]&127](k)|0;if(!f)break}else{h=Ua[c[29356>>2]&127](k)|0;if((c[14985]|0)>>>0<k>>>0)c[14985]=k;i=59064;f=c[i>>2]|0;i=c[i+4>>2]|0;if((i|0)>0|(i|0)==0&f>>>0>0){o=c[14978]|0;n=Rv(f|0,i|0,h|0,((h|0)<0)<<31>>31|0)|0;m=L()|0;c[14768]=((m|0)<0|(m|0)==0&n>>>0<=o>>>0)&1}f=Ua[c[29340>>2]&127](h)|0;if(!f)break;i=Ua[c[29352>>2]&127](f)|0;i=(c[14978]|0)+i|0;c[14978]=i;if(i>>>0>(c[14982]|0)>>>0)c[14982]=i;i=(c[14981]|0)+1|0;c[14981]=i;if(i>>>0>(c[14987]|0)>>>0)c[14987]=i}a[f>>0]=39;i=a[p>>0]|0;h=f+1|0;if(!(i<<24>>24))i=2;else{k=1;n=0;m=i;l=p;i=2;do{a[h>>0]=m;if((a[l>>0]|0)==39){a[f+i>>0]=39;k=k+2|0}else k=i;n=n+1|0;l=p+n|0;m=a[l>>0]|0;i=k+1|0;h=f+k|0}while(m<<24>>24!=0)}a[h>>0]=39;a[f+i>>0]=0;if((wc(c[e>>2]|0,f,i,1,90)|0)!=18){Qa=q;return}c[e+20>>2]=18;wc(c[e>>2]|0,31223,-1,1,0)|0;Qa=q;return}while(0);f=c[e>>2]|0;i=f+8|0;if(!(b[i>>1]&9216))b[i>>1]=1;else{Bg(f);f=c[e>>2]|0}c[e+20>>2]=7;f=c[f+32>>2]|0;i=f+81|0;if(a[i>>0]|0){Qa=q;return}if(a[f+82>>0]|0){Qa=q;return}a[i>>0]=1;if((c[f+180>>2]|0)>0)c[f+264>>2]=1;e=f+272|0;c[e>>2]=(c[e>>2]|0)+1;f=c[f+236>>2]|0;if(!f){Qa=q;return}c[f+12>>2]=7;Qa=q;return}default:{if((wc(c[e>>2]|0,31171,4,1,0)|0)!=18){Qa=q;return}c[e+20>>2]=18;wc(c[e>>2]|0,31223,-1,1,0)|0;Qa=q;return}}}function Nn(a,d,e){a=a|0;d=d|0;e=e|0;var f=0;e=c[a>>2]|0;a=(c[e+32>>2]|0)+40|0;f=c[a>>2]|0;a=c[a+4>>2]|0;d=e+8|0;if(!(b[d>>1]&9216)){c[e>>2]=f;c[e+4>>2]=a;b[d>>1]=4;return}else{Ng(e,f,a);return}}function On(a,d,e){a=a|0;d=d|0;e=e|0;var f=0;d=c[a>>2]|0;e=c[(c[d+32>>2]|0)+100>>2]|0;f=((e|0)<0)<<31>>31;a=d+8|0;if(!(b[a>>1]&9216)){c[d>>2]=e;c[d+4>>2]=f;b[a>>1]=4;return}else{Ng(d,e,f);return}}function Pn(a,d,e){a=a|0;d=d|0;e=e|0;var f=0;d=c[a>>2]|0;e=c[(c[d+32>>2]|0)+104>>2]|0;f=((e|0)<0)<<31>>31;a=d+8|0;if(!(b[a>>1]&9216)){c[d>>2]=e;c[d+4>>2]=f;b[a>>1]=4;return}else{Ng(d,e,f);return}}function Qn(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;i=c[(c[d>>2]|0)+32>>2]|0;e=c[f>>2]|0;if(!e)return;g=b[e+8>>1]|0;if((g&514)==514?(a[e+10>>0]|0)==1:0)A=c[e+16>>2]|0;else B=5;do if((B|0)==5)if(!(g&1)){A=Eg(e,1)|0;break}else return;while(0);if(!A)return;h=c[f>>2]|0;e=b[h+8>>1]|0;if((e&2)!=0?(a[h+10>>0]|0)==1:0)z=c[h+12>>2]|0;else B=11;do if((B|0)==11){e=e&65535;if(!(e&16)){if(e&1|0){z=0;break}z=Dg(h,1)|0;break}else{g=c[h+12>>2]|0;if(!(e&16384)){z=g;break}z=(c[h>>2]|0)+g|0;break}}while(0);h=f+4|0;e=c[h>>2]|0;if(!e)return;g=b[e+8>>1]|0;if((g&514)==514?(a[e+10>>0]|0)==1:0)y=c[e+16>>2]|0;else B=20;do if((B|0)==20)if(!(g&1)){y=Eg(e,1)|0;break}else return;while(0);if(!y)return;if(!(a[y>>0]|0)){Bc(d,c[f>>2]|0);return}h=c[h>>2]|0;e=b[h+8>>1]|0;if((e&2)!=0?(a[h+10>>0]|0)==1:0)x=c[h+12>>2]|0;else B=28;do if((B|0)==28){e=e&65535;if(!(e&16)){if(e&1|0){x=0;break}x=Dg(h,1)|0;break}else{g=c[h+12>>2]|0;if(!(e&16384)){x=g;break}x=(c[h>>2]|0)+g|0;break}}while(0);h=f+8|0;e=c[h>>2]|0;if(!e)return;g=b[e+8>>1]|0;if((g&514)==514?(a[e+10>>0]|0)==1:0)w=c[e+16>>2]|0;else B=37;do if((B|0)==37)if(!(g&1)){w=Eg(e,1)|0;break}else return;while(0);if(!w)return;h=c[h>>2]|0;e=b[h+8>>1]|0;if((e&2)!=0?(a[h+10>>0]|0)==1:0)v=c[h+12>>2]|0;else B=43;do if((B|0)==43){e=e&65535;if(!(e&16)){if(e&1|0){v=0;break}v=Dg(h,1)|0;break}else{g=c[h+12>>2]|0;if(!(e&16384)){v=g;break}v=(c[h>>2]|0)+g|0;break}}while(0);k=z+1|0;j=((k|0)<0)<<31>>31;e=c[d>>2]|0;if((c[(c[e+32>>2]|0)+108>>2]|0)<=(z|0)){c[d+20>>2]=18;wc(e,31223,-1,1,0)|0;return}u=Qv(k|0,j|0,-1,-1)|0;t=L()|0;a:do if(!(t>>>0>0|(t|0)==0&u>>>0>2147483390)){do if(!(c[7324]|0)){h=Ua[c[29340>>2]&127](k)|0;if(!h)break a}else{e=Ua[c[29356>>2]&127](k)|0;if((c[14985]|0)>>>0<k>>>0)c[14985]=k;h=59064;g=c[h>>2]|0;h=c[h+4>>2]|0;if((h|0)>0|(h|0)==0&g>>>0>0){u=c[14978]|0;t=Rv(g|0,h|0,e|0,((e|0)<0)<<31>>31|0)|0;s=L()|0;c[14768]=((s|0)<0|(s|0)==0&t>>>0<=u>>>0)&1}h=Ua[c[29340>>2]&127](e)|0;if(!h)break a;e=Ua[c[29352>>2]&127](h)|0;e=(c[14978]|0)+e|0;c[14978]=e;if(e>>>0>(c[14982]|0)>>>0)c[14982]=e;e=(c[14981]|0)+1|0;c[14981]=e;if(e>>>0<=(c[14987]|0)>>>0)break;c[14987]=e}while(0);u=z-x|0;b:do if((u|0)>=0){r=v-x|0;s=((r|0)<0)<<31>>31;o=i+108|0;t=x+-1|0;p=~z;q=((p|0)<0)<<31>>31;if((v|0)<=(x|0)){g=0;e=0;while(1){f=A+e|0;i=a[f>>0]|0;do if(i<<24>>24==(a[y>>0]|0)){if(Ju(f,y,x)|0){B=86;break}cw(h+g|0,w|0,v|0)|0;g=g+v|0;f=t+e|0}else B=86;while(0);if((B|0)==86){B=0;a[h+g>>0]=i;g=g+1|0;f=e}e=f+1|0;if((f|0)>=(u|0))break b}}n=0;g=0;e=0;c:while(1){f=A+e|0;i=a[f>>0]|0;do if(i<<24>>24==(a[y>>0]|0)){if(Ju(f,y,x)|0){B=77;break}j=Qv(k|0,j|0,r|0,s|0)|0;l=L()|0;k=Qv(j|0,l|0,-1,-1)|0;f=L()|0;m=c[o>>2]|0;i=((m|0)<0)<<31>>31;if((f|0)>(i|0)|(f|0)==(i|0)&k>>>0>m>>>0){B=87;break c}i=n+1|0;if(!(i&n)){if(kb()|0)break c;n=_v(0,j|0,32)|0;f=L()|0;m=Qv(j|0,l|0,p|0,q|0)|0;f=Qv(m|0,L()|0,n|0,f|0)|0;f=qb(h,f,L()|0)|0;if(!f)break c;else h=f}cw(h+g|0,w|0,v|0)|0;g=g+v|0;m=t+e|0;f=i;k=j;i=l}else B=77;while(0);if((B|0)==77){B=0;a[h+g>>0]=i;g=g+1|0;m=e;f=n;i=j}e=m+1|0;if((m|0)<(u|0)){n=f;j=i}else break b}if((B|0)==87){c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;if(!h)return;if(!(c[7324]|0)){_a[c[29344>>2]&127](h);return}else{d=Ua[c[29352>>2]&127](h)|0;c[14978]=(c[14978]|0)-d;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](h);return}}e=c[d>>2]|0;g=e+8|0;if(!(b[g>>1]&9216))b[g>>1]=1;else{Bg(e);e=c[d>>2]|0}c[d+20>>2]=7;e=c[e+32>>2]|0;g=e+81|0;do if(!(a[g>>0]|0)){if(a[e+82>>0]|0)break;a[g>>0]=1;if((c[e+180>>2]|0)>0)c[e+264>>2]=1;d=e+272|0;c[d>>2]=(c[d>>2]|0)+1;e=c[e+236>>2]|0;if(!e)break;c[e+12>>2]=7}while(0);if(!h)return;if(!(c[7324]|0)){_a[c[29344>>2]&127](h);return}else{d=Ua[c[29352>>2]&127](h)|0;c[14978]=(c[14978]|0)-d;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](h);return}}else{g=0;e=0}while(0);B=z-e|0;cw(h+g|0,A+e|0,B|0)|0;B=g+B|0;a[h+B>>0]=0;if((wc(c[d>>2]|0,h,B,1,90)|0)!=18)return;c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;return}while(0);e=c[d>>2]|0;g=e+8|0;if(!(b[g>>1]&9216))b[g>>1]=1;else{Bg(e);e=c[d>>2]|0}c[d+20>>2]=7;e=c[e+32>>2]|0;g=e+81|0;if(a[g>>0]|0)return;if(a[e+82>>0]|0)return;a[g>>0]=1;if((c[e+180>>2]|0)>0)c[e+264>>2]=1;d=e+272|0;c[d>>2]=(c[d>>2]|0)+1;e=c[e+236>>2]|0;if(!e)return;c[e+12>>2]=7;return}function Rn(d,f,h){d=d|0;f=f|0;h=h|0;var i=0,j=0,k=0;f=c[h>>2]|0;h=e[f+8>>1]|0;do if(!(h&4)){if(h&8|0){h=Kg(+g[f>>3])|0;f=L()|0;j=7;break}if(!(h&18)){f=0;i=0}else{h=Lg(a[f+10>>0]|0,c[f+12>>2]|0,c[f+16>>2]|0)|0;f=L()|0;j=7}}else{h=f;f=c[h+4>>2]|0;h=c[h>>2]|0;j=7}while(0);if((j|0)==7){i=(f|0)>0|(f|0)==0&h>>>0>0;f=i?f:0;i=i?h:0}h=c[d>>2]|0;j=c[(c[h+32>>2]|0)+108>>2]|0;k=((j|0)<0)<<31>>31;if(f>>>0>k>>>0|(f|0)==(k|0)&i>>>0>j>>>0){c[d+20>>2]=18;if(!(b[h+8>>1]&1))return;wc(h,31223,-1,1,0)|0;return}f=h+8|0;if(!((b[f>>1]&9216)==0?!(c[h+24>>2]|0):0))Ag(h);b[f>>1]=16400;c[h+12>>2]=0;c[h>>2]=(i|0)>0?i:0;a[h+10>>0]=1;c[h+16>>2]=0;return}function Sn(d,f,h){d=d|0;f=f|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;k=c[h+4>>2]|0;i=b[k+8>>1]|0;if(-1431655766>>>(i&31)&1|0)return;n=(f|0)==3;if(n?-1431655766>>>(b[(c[h+8>>2]|0)+8>>1]&31)&1|0:0)return;j=c[h>>2]|0;l=b[j+8>>1]&15;f=i&65535;do if(!(f&4)){if(f&8|0){r=Kg(+g[k>>3])|0;L()|0;break}if(!(f&18))r=0;else{r=Lg(a[k+10>>0]|0,c[k+12>>2]|0,c[k+16>>2]|0)|0;L()|0;j=c[h>>2]|0}}else r=c[k>>2]|0;while(0);q=((r|0)<0)<<31>>31;t=(l|16)<<16>>16==16;if(t){f=b[j+8>>1]|0;if((f&2)!=0?(a[j+10>>0]|0)==1:0){i=c[j+12>>2]|0;f=j}else s=14;do if((s|0)==14){f=f&65535;if(!(f&16)){if(f&1|0){i=0;f=j;break}i=Dg(j,1)|0;f=c[h>>2]|0;break}else{i=c[j+12>>2]|0;if(!(f&16384)){f=j;break}i=(c[j>>2]|0)+i|0;f=j;break}}while(0);f=kc(f)|0;if(!f)return;else{p=f;o=i}}else{if(!j)return;f=b[j+8>>1]|0;if((f&514)==514?(a[j+10>>0]|0)==1:0)l=c[j+16>>2]|0;else s=24;do if((s|0)==24)if(!(f&1)){l=Eg(j,1)|0;break}else return;while(0);if(!l)return;if((r|0)<0?(m=a[l>>0]|0,m<<24>>24!=0):0){k=0;f=l;j=m;while(1){i=f+1|0;if((j&255)>191){f=i;while(1){j=a[f>>0]|0;if((j&-64)<<24>>24==-128)f=f+1|0;else break}}else{f=i;j=a[i>>0]|0}i=k+1|0;if(!(j<<24>>24)){p=l;o=i;break}else k=i}}else{p=l;o=0}}if(n){f=c[h+8>>2]|0;i=e[f+8>>1]|0;do if(!(i&4)){if(i&8|0){f=Kg(+g[f>>3])|0;L()|0;s=42;break}if(!(i&18)){i=0;f=0;j=0}else{f=Lg(a[f+10>>0]|0,c[f+12>>2]|0,c[f+16>>2]|0)|0;L()|0;s=42}}else{f=c[f>>2]|0;s=42}while(0);if((s|0)==42){j=((f|0)<0)<<31>>31;h=(f|0)<0;n=Rv(0,0,f|0,j|0)|0;s=L()|0;i=f;f=h?n:f;j=h?s:j}l=i>>>31;i=j}else{i=c[(c[(c[d>>2]|0)+32>>2]|0)+108>>2]|0;l=0;f=i;i=((i|0)<0)<<31>>31}do if((r|0)>=0)if(!r){j=((i|0)>0|(i|0)==0&f>>>0>0)<<31>>31;f=Qv(f|0,i|0,j|0,((j|0)<0)<<31>>31|0)|0;j=0;k=0;i=L()|0;break}else{j=Qv(r|0,q|0,-1,-1)|0;k=L()|0;break}else{j=Qv(o|0,((o|0)<0)<<31>>31|0,r|0,q|0)|0;k=L()|0;q=(k|0)<0;h=Qv(f|0,i|0,j|0,k|0)|0;s=L()|0;r=(s|0)>0|(s|0)==0&h>>>0>0;j=q?0:j;k=q?0:k;f=q?(r?h:0):f;i=q?(r?s:0):i}while(0);r=(l|0)==0;m=Rv(j|0,k|0,f|0,i|0)|0;l=L()|0;s=(l|0)<0;m=r?j:s?0:m;l=r?k:s?0:l;n=r?f:s?j:f;k=r?i:s?k:i;if(t){r=Qv(m|0,l|0,n|0,k|0)|0;t=L()|0;f=((o|0)<0)<<31>>31;r=(t|0)>(f|0)|(t|0)==(f|0)&r>>>0>o>>>0;f=Rv(o|0,f|0,m|0,l|0)|0;t=L()|0;s=(t|0)>0|(t|0)==0&f>>>0>0;f=r?(s?f:0):n;t=r?(s?t:0):k;if(t>>>0>0|(t|0)==0&f>>>0>2147483647){if(!d)return;c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;return}else{if((wc(c[d>>2]|0,p+m|0,f,0,-1)|0)!=18)return;c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;return}}i=a[p>>0]|0;if(((m|0)!=0|(l|0)!=0)&i<<24>>24!=0){f=p;do{j=f+1|0;if((i&255)>191){f=j;while(1){i=a[f>>0]|0;if((i&-64)<<24>>24==-128)f=f+1|0;else break}}else{f=j;i=a[j>>0]|0}m=Qv(m|0,l|0,-1,-1)|0;l=L()|0}while(((m|0)!=0|(l|0)!=0)&i<<24>>24!=0);m=f}else m=p;if(i<<24>>24!=0&((n|0)!=0|(k|0)!=0)){f=m;l=n;do{j=f+1|0;if((i&255)>191){f=j;while(1){i=a[f>>0]|0;if((i&-64)<<24>>24==-128)f=f+1|0;else break}}else{f=j;i=a[j>>0]|0}l=Qv(l|0,k|0,-1,-1)|0;k=L()|0}while(i<<24>>24!=0&((l|0)!=0|(k|0)!=0))}else f=m;f=f-m|0;if((f|0)<0){if(!d)return;c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;return}else{if((wc(c[d>>2]|0,m,f,1,-1)|0)!=18)return;c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;return}}function Tn(f,h,i){f=f|0;h=h|0;i=i|0;var j=0.0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;q=Qa;Qa=Qa+16|0;n=q+8|0;o=q;h=c[f+8>>2]|0;if(!(b[h+8>>1]&8192))p=Gc(f,32)|0;else p=c[h+16>>2]|0;l=c[i>>2]|0;m=l+8|0;f=b[m>>1]&31;k=d[816+f>>0]|0;if((f|16|0)==18){h=a[l+10>>0]|0;f=l+16|0;k=l+12|0;if(!(Jg(c[f>>2]|0,n,c[k>>2]|0,h)|0))h=b[m>>1]|0;else{if(!(Mg(c[f>>2]|0,o,c[k>>2]|0,h)|0)){n=o;o=c[n+4>>2]|0;h=l;c[h>>2]=c[n>>2];c[h+4>>2]=o;h=4}else{g[l>>3]=+g[n>>3];h=8}h=b[m>>1]&-3|h;b[m>>1]=h}k=d[816+(h&31)>>0]|0}if(!((p|0)!=0&(k|0)!=5)){Qa=q;return}h=p+16|0;o=h;o=Qv(c[o>>2]|0,c[o+4>>2]|0,1,0)|0;f=L()|0;c[h>>2]=o;c[h+4>>2]=f;h=c[i>>2]|0;f=e[h+8>>1]|0;if((k|0)!=1){do if(!(f&8)){if(f&4|0){i=h;j=+((c[i>>2]|0)>>>0)+4294967296.0*+(c[i+4>>2]|0);break}if(!(f&18))j=0.0;else j=+Ig(a[h+10>>0]|0,c[h+12>>2]|0,c[h+16>>2]|0)}else j=+g[h>>3];while(0);g[p>>3]=j+ +g[p>>3];a[p+25>>0]=1;Qa=q;return}do if(!(f&4)){if(f&8|0){m=Kg(+g[h>>3])|0;n=L()|0;break}if(!(f&18)){m=0;n=0}else{m=Lg(a[h+10>>0]|0,c[h+12>>2]|0,c[h+16>>2]|0)|0;n=L()|0}}else{n=h;m=c[n>>2]|0;n=c[n+4>>2]|0}while(0);g[p>>3]=+g[p>>3]+(+(m>>>0)+4294967296.0*+(n|0));o=p+25|0;i=p+24|0;if((a[i>>0]|a[o>>0])<<24>>24){Qa=q;return}h=p+8|0;k=h;f=c[k>>2]|0;k=c[k+4>>2]|0;if((n|0)>-1|(n|0)==-1&m>>>0>4294967295){p=Rv(-1,2147483647,f|0,k|0)|0;l=L()|0;if(((k|0)>0|(k|0)==0&f>>>0>0)&((l|0)<(n|0)|(l|0)==(n|0)&p>>>0<m>>>0))l=26;else l=25}else if((k|0)<0?(l=Rv(1,-2147483648,f|0,k|0)|0,s=L()|0,p=Qv(m|0,n|0,1,0)|0,r=L()|0,(s|0)>(r|0)|(s|0)==(r|0)&l>>>0>p>>>0):0)l=26;else l=25;if((l|0)==25){p=Qv(f|0,k|0,m|0,n|0)|0;r=L()|0;s=h;c[s>>2]=p;c[s+4>>2]=r;Qa=q;return}else if((l|0)==26){a[i>>0]=1;a[o>>0]=1;Qa=q;return}}function Un(d){d=d|0;var e=0,f=0,h=0,i=0.0,j=0,k=0,l=0;j=Qa;Qa=Qa+16|0;f=j+8|0;h=j;e=c[d+8>>2]|0;if(!(b[e+8>>1]&8192))e=Gc(d,0)|0;else e=c[e+16>>2]|0;if(!e){Qa=j;return}k=e+16|0;l=c[k+4>>2]|0;if(!((l|0)>0|(l|0)==0&(c[k>>2]|0)>>>0>0)){Qa=j;return}if(a[e+24>>0]|0){c[d+20>>2]=1;wc(c[d>>2]|0,49524,-1,1,-1)|0;Qa=j;return}if(!(a[e+25>>0]|0)){h=e+8|0;f=c[h>>2]|0;h=c[h+4>>2]|0;e=c[d>>2]|0;d=e+8|0;if(!(b[d>>1]&9216)){l=e;c[l>>2]=f;c[l+4>>2]=h;b[d>>1]=4;Qa=j;return}else{Ng(e,f,h);Qa=j;return}}i=+g[e>>3];e=c[d>>2]|0;d=e+8|0;if(!(b[d>>1]&9216))b[d>>1]=1;else Bg(e);g[f>>3]=i;g[h>>3]=+g[f>>3];if(!(+g[f>>3]==+g[h>>3])){Qa=j;return}g[e>>3]=i;b[d>>1]=8;Qa=j;return}function Vn(f,h,i){f=f|0;h=h|0;i=i|0;var j=0.0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=Qa;Qa=Qa+16|0;n=q+8|0;o=q;h=c[f+8>>2]|0;if(!(b[h+8>>1]&8192))p=Gc(f,32)|0;else p=c[h+16>>2]|0;l=c[i>>2]|0;m=l+8|0;k=b[m>>1]&31;h=d[816+k>>0]|0;if((k|16|0)==18){h=a[l+10>>0]|0;f=l+16|0;k=l+12|0;if(!(Jg(c[f>>2]|0,n,c[k>>2]|0,h)|0))h=b[m>>1]|0;else{if(!(Mg(c[f>>2]|0,o,c[k>>2]|0,h)|0)){n=o;o=c[n+4>>2]|0;h=l;c[h>>2]=c[n>>2];c[h+4>>2]=o;h=4}else{g[l>>3]=+g[n>>3];h=8}h=b[m>>1]&-3|h;b[m>>1]=h}h=d[816+(h&31)>>0]|0}if(!((p|0)!=0&(h|0)!=5)){Qa=q;return}o=p+16|0;m=o;m=Qv(c[m>>2]|0,c[m+4>>2]|0,-1,-1)|0;n=L()|0;c[o>>2]=m;c[o+4>>2]=n;if((h|0)==1?(a[p+25>>0]|0)==0:0){h=c[i>>2]|0;f=e[h+8>>1]|0;do if(!(f&4)){if(f&8|0){h=Kg(+g[h>>3])|0;f=L()|0;break}if(!(f&18)){h=0;f=0}else{h=Lg(a[h+10>>0]|0,c[h+12>>2]|0,c[h+16>>2]|0)|0;f=L()|0}}else{f=h;h=c[f>>2]|0;f=c[f+4>>2]|0}while(0);g[p>>3]=+g[p>>3]-(+(h>>>0)+4294967296.0*+(f|0));p=p+8|0;o=p;o=Rv(c[o>>2]|0,c[o+4>>2]|0,h|0,f|0)|0;i=L()|0;c[p>>2]=o;c[p+4>>2]=i;Qa=q;return}h=c[i>>2]|0;f=e[h+8>>1]|0;do if(!(f&8)){if(f&4|0){i=h;j=+((c[i>>2]|0)>>>0)+4294967296.0*+(c[i+4>>2]|0);break}if(!(f&18))j=0.0;else j=+Ig(a[h+10>>0]|0,c[h+12>>2]|0,c[h+16>>2]|0)}else j=+g[h>>3];while(0);g[p>>3]=+g[p>>3]-j;Qa=q;return}function Wn(a){a=a|0;var d=0,e=0.0,f=0,h=0,i=0;i=Qa;Qa=Qa+16|0;f=i+8|0;h=i;d=c[a+8>>2]|0;if(!(b[d+8>>1]&8192))d=Gc(a,0)|0;else d=c[d+16>>2]|0;if(!d)e=0.0;else e=+g[d>>3];d=c[a>>2]|0;a=d+8|0;if(!(b[a>>1]&9216))b[a>>1]=1;else Bg(d);g[f>>3]=e;g[h>>3]=+g[f>>3];if(!(+g[f>>3]==+g[h>>3])){Qa=i;return}g[d>>3]=e;b[a>>1]=8;Qa=i;return}function Xn(a){a=a|0;var d=0,e=0,f=0,h=0.0,i=0,j=0,k=0;k=Qa;Qa=Qa+16|0;i=k+8|0;j=k;d=c[a+8>>2]|0;if(!(b[d+8>>1]&8192))d=Gc(a,0)|0;else d=c[d+16>>2]|0;if(!d){Qa=k;return}f=d+16|0;e=c[f>>2]|0;f=c[f+4>>2]|0;if(!((f|0)>0|(f|0)==0&e>>>0>0)){Qa=k;return}h=+g[d>>3]/(+(e>>>0)+4294967296.0*+(f|0));d=c[a>>2]|0;e=d+8|0;if(!(b[e>>1]&9216))b[e>>1]=1;else Bg(d);g[i>>3]=h;g[j>>3]=+g[i>>3];if(!(+g[i>>3]==+g[j>>3])){Qa=k;return}g[d>>3]=h;b[e>>1]=8;Qa=k;return}function Yn(a,d,e){a=a|0;d=d|0;e=e|0;var f=0;f=c[a+8>>2]|0;if(!(b[f+8>>1]&8192))a=Gc(a,8)|0;else a=c[f+16>>2]|0;if(!d){if(!a)return}else if(!(a|0?(1431655765>>>(b[(c[e>>2]|0)+8>>1]&31)&1|0)!=0:0))return;f=a;f=Qv(c[f>>2]|0,c[f+4>>2]|0,1,0)|0;d=L()|0;e=a;c[e>>2]=f;c[e+4>>2]=d;return}function Zn(a){a=a|0;var d=0,e=0,f=0;d=c[a+8>>2]|0;if(!(b[d+8>>1]&8192))d=Gc(a,0)|0;else d=c[d+16>>2]|0;if(!d){e=0;f=0}else{f=d;e=c[f>>2]|0;f=c[f+4>>2]|0}d=c[a>>2]|0;a=d+8|0;if(!(b[a>>1]&9216)){c[d>>2]=e;c[d+4>>2]=f;b[a>>1]=4;return}else{Ng(d,e,f);return}}function _n(a,d,e){a=a|0;d=d|0;e=e|0;var f=0;f=c[a+8>>2]|0;if(!(b[f+8>>1]&8192))a=Gc(a,8)|0;else a=c[f+16>>2]|0;if(!d){if(!a)return}else if(!(a|0?(1431655765>>>(b[(c[e>>2]|0)+8>>1]&31)&1|0)!=0:0))return;f=a;f=Qv(c[f>>2]|0,c[f+4>>2]|0,-1,-1)|0;d=L()|0;e=a;c[e>>2]=f;c[e+4>>2]=d;return}function $n(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;if(-1431655766>>>(b[(c[f>>2]|0)+8>>1]&31)&1|0)return;g=c[d+8>>2]|0;if(!(b[g+8>>1]&8192))k=Gc(d,24)|0;else k=c[g+16>>2]|0;if(!k)return;h=k+12|0;i=(c[h>>2]|0)==0;c[h>>2]=c[(c[(c[d>>2]|0)+32>>2]|0)+108>>2];do if(!i){if((e|0)==2){d=f+4|0;e=c[d>>2]|0;g=b[e+8>>1]|0;if((g&514)==514?(a[e+10>>0]|0)==1:0)h=c[e+16>>2]|0;else if(!(g&1)){h=Eg(e,1)|0;e=c[d>>2]|0}else h=0;g=b[e+8>>1]|0;if((g&2)!=0?(a[e+10>>0]|0)==1:0)g=c[e+12>>2]|0;else j=16;do if((j|0)==16){d=g&65535;if(!(d&16)){if(d&1|0){g=0;break}g=Dg(e,1)|0;break}else{g=c[e+12>>2]|0;if(!(d&16384))break;g=(c[e>>2]|0)+g|0;break}}while(0);if(!h)break;else d=h}else{g=1;d=41685}e=k+16|0;h=c[e>>2]|0;i=h+g|0;if(i>>>0>=(c[k+8>>2]|0)>>>0){ub(k,d,g);break}if(g|0){c[e>>2]=i;cw((c[k+4>>2]|0)+h|0,d|0,g|0)|0}}while(0);d=c[f>>2]|0;g=b[d+8>>1]|0;if((g&514)==514?(a[d+10>>0]|0)==1:0){i=c[d+16>>2]|0;e=d}else if(!(g&1)){i=Eg(d,1)|0;e=c[f>>2]|0}else{i=0;e=d}g=b[e+8>>1]|0;if((g&2)!=0?(a[e+10>>0]|0)==1:0)d=c[e+12>>2]|0;else j=34;do if((j|0)==34){g=g&65535;if(!(g&16)){if(g&1|0){d=0;break}d=Dg(e,1)|0;break}else{d=c[e+12>>2]|0;if(!(g&16384))break;d=(c[e>>2]|0)+d|0;break}}while(0);if(!i)return;g=k+16|0;e=c[g>>2]|0;h=e+d|0;if(h>>>0>=(c[k+8>>2]|0)>>>0){ub(k,i,d);return}if(!d)return;c[g>>2]=h;cw((c[k+4>>2]|0)+e|0,i|0,d|0)|0;return}function ao(d){d=d|0;var e=0,f=0,g=0;e=c[d+8>>2]|0;if(!(b[e+8>>1]&8192))e=Gc(d,0)|0;else e=c[e+16>>2]|0;if(!e)return;switch(a[e+20>>0]|0){case 18:{c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;return}case 7:{e=c[d>>2]|0;f=e+8|0;if(!(b[f>>1]&9216))b[f>>1]=1;else{Bg(e);e=c[d>>2]|0}c[d+20>>2]=7;e=c[e+32>>2]|0;f=e+81|0;if(a[f>>0]|0)return;if(a[e+82>>0]|0)return;a[f>>0]=1;if((c[e+180>>2]|0)>0)c[e+264>>2]=1;d=e+272|0;c[d>>2]=(c[d>>2]|0)+1;e=c[e+236>>2]|0;if(!e)return;c[e+12>>2]=7;return}default:{f=e+4|0;g=c[f>>2]|0;if(((g|0)!=0?(a[g+(c[e+16>>2]|0)>>0]=0,(c[e+12>>2]|0)!=0):0)?(a[e+21>>0]&4)==0:0)e=Zd(e)|0;else e=c[f>>2]|0;if((wc(c[d>>2]|0,e,-1,1,90)|0)!=18)return;c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;return}}}function bo(d){d=d|0;var e=0,f=0;e=c[d+8>>2]|0;if(!(b[e+8>>1]&8192))e=Gc(d,0)|0;else e=c[e+16>>2]|0;if(!e)return;switch(a[e+20>>0]|0){case 18:{c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;return}case 7:{e=c[d>>2]|0;f=e+8|0;if(!(b[f>>1]&9216))b[f>>1]=1;else{Bg(e);e=c[d>>2]|0}c[d+20>>2]=7;e=c[e+32>>2]|0;f=e+81|0;if(a[f>>0]|0)return;if(a[e+82>>0]|0)return;a[f>>0]=1;if((c[e+180>>2]|0)>0)c[e+264>>2]=1;d=e+272|0;c[d>>2]=(c[d>>2]|0)+1;e=c[e+236>>2]|0;if(!e)return;c[e+12>>2]=7;return}default:{f=c[e+16>>2]|0;if(!f)e=0;else{e=e+4|0;a[(c[e>>2]|0)+f>>0]=0;e=c[e>>2]|0}if((wc(c[d>>2]|0,e,-1,1,-1)|0)!=18)return;c[d+20>>2]=18;wc(c[d>>2]|0,31223,-1,1,0)|0;return}}}function co(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;if(-1431655766>>>(b[(c[f>>2]|0)+8>>1]&31)&1|0)return;g=c[d+8>>2]|0;if(!(b[g+8>>1]&8192))k=Gc(d,24)|0;else k=c[g+16>>2]|0;if(!k)return;h=c[f>>2]|0;d=b[h+8>>1]|0;if((d&2)!=0?(a[h+10>>0]|0)==1:0)j=c[h+12>>2]|0;else i=9;do if((i|0)==9){d=d&65535;if(!(d&16)){if(d&1|0){j=0;break}j=Dg(h,1)|0;break}else{g=c[h+12>>2]|0;if(!(d&16384)){j=g;break}j=(c[h>>2]|0)+g|0;break}}while(0);do if((e|0)==2){h=c[f+4>>2]|0;d=b[h+8>>1]|0;if(d&2?(a[h+10>>0]|0)==1:0){d=c[h+12>>2]|0;break}g=d&65535;if(!(g&16)){if(g&1|0){d=0;break}d=Dg(h,1)|0;break}else{d=c[h+12>>2]|0;if(!(g&16384))break;d=(c[h>>2]|0)+d|0;break}}else d=1;while(0);d=d+j|0;g=k+16|0;h=c[g>>2]|0;if((h|0)>(d|0)){f=h-d|0;c[g>>2]=f;e=c[k+4>>2]|0;dw(e|0,e+d|0,f|0)|0;if(c[g>>2]|0)return}else c[g>>2]=0;c[k+12>>2]=0;return}function eo(f,h,i){f=f|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0;J=Qa;Qa=Qa+368|0;F=J+16|0;r=J;q=J+356|0;G=J+336|0;H=J+60|0;u=J+32|0;I=c[(c[f>>2]|0)+32>>2]|0;h=c[i>>2]|0;do if(h){j=b[h+8>>1]|0;if((j&514)==514?(a[h+10>>0]|0)==1:0){B=c[h+16>>2]|0;break}if(!(j&1))B=Eg(h,1)|0;else B=0}else B=0;while(0);h=c[i+12>>2]|0;do if(h){j=b[h+8>>1]|0;if((j&514)==514?(a[h+10>>0]|0)==1:0){t=c[h+16>>2]|0;break}if(!(j&1))t=Eg(h,1)|0;else t=0}else t=0;while(0);h=c[i+16>>2]|0;do if(h){j=b[h+8>>1]|0;if((j&514)==514?(a[h+10>>0]|0)==1:0){y=c[h+16>>2]|0;break}if(!(j&1))y=Eg(h,1)|0;else y=0}else y=0;while(0);h=c[i+20>>2]|0;j=e[h+8>>1]|0;do if(!(j&4)){if(j&8|0){x=Kg(+g[h>>3])|0;L()|0;break}if(!(j&18))x=0;else{x=Lg(a[h+10>>0]|0,c[h+12>>2]|0,c[h+16>>2]|0)|0;L()|0}}else x=c[h>>2]|0;while(0);h=c[i+24>>2]|0;do if(h){j=b[h+8>>1]|0;if((j&514)==514?(a[h+10>>0]|0)==1:0){A=c[h+16>>2]|0;break}if(!(j&1))A=Eg(h,1)|0;else A=0}else A=0;while(0);h=c[i+28>>2]|0;j=e[h+8>>1]|0;do if(!(j&4)){if(j&8|0){z=Kg(+g[h>>3])|0;L()|0;break}if(!(j&18))z=0;else{z=Lg(a[h+10>>0]|0,c[h+12>>2]|0,c[h+16>>2]|0)|0;L()|0}}else z=c[h>>2]|0;while(0);h=c[i+32>>2]|0;j=e[h+8>>1]|0;do if(!(j&4)){if(j&8|0){l=Kg(+g[h>>3])|0;L()|0;break}if(!(j&18))l=0;else{l=Lg(a[h+10>>0]|0,c[h+12>>2]|0,c[h+16>>2]|0)|0;L()|0}}else l=c[h>>2]|0;while(0);C=I+312|0;D=c[C>>2]|0;if((x|0)<0|((B|0)==0|(y|0)==0|(A|0)==0)){Qa=J;return}m=c[I+20>>2]|0;n=(m|0)>0;if(n){j=c[I+16>>2]|0;h=0;do{k=c[j+(h<<4)+4>>2]|0;if(k|0)c[(c[k+4>>2]|0)+4>>2]=c[k>>2];h=h+1|0}while((h|0)!=(m|0))}p=Qd(I,y,t)|0;if(!p){Qa=J;return}if((x|0)>=(b[p+42>>1]|0)){Qa=J;return}w=c[(c[p+4>>2]|0)+(x<<4)>>2]|0;c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;c[G+12>>2]=0;c[G+16>>2]=0;s=G+8|0;c[s>>2]=(x|0)==(b[p+40>>1]|0)?-1:x;c[C>>2]=0;c[q>>2]=0;o=(l|0)==0;if(o){a:do if(t){j=m+-1|0;if(n){h=j;m=(c[I+16>>2]|0)+(j<<4)|0;while(1){k=c[m>>2]|0;if(k|0){v=a[k>>0]|0;j=(d[208+(v&255)>>0]|0)-(d[208+(d[t>>0]|0)>>0]|0)|0;if(!(v<<24>>24==0|(j|0)!=0)){l=t;do{k=k+1|0;l=l+1|0;v=a[k>>0]|0;j=(d[208+(v&255)>>0]|0)-(d[208+(d[l>>0]|0)>>0]|0)|0}while(!(v<<24>>24==0|(j|0)!=0))}if(!j)break a}if(!h)break;j=h+-1|0;if((h|0)>0){h=j;m=m+-16|0}else{h=j;break a}}h=109-(d[208+(d[t>>0]|0)>>0]|0)|0;if(!h){j=t;k=50919;do{k=k+1|0;j=j+1|0;v=a[k>>0]|0;h=(d[208+(v&255)>>0]|0)-(d[208+(d[j>>0]|0)>>0]|0)|0}while(!(v<<24>>24==0|(h|0)!=0))}h=((h|0)!=0)<<31>>31}else h=j}else h=-1;while(0);h=h&255}else h=1;j=I+164|0;a[j>>0]=h;v=H+4|0;ew(v|0,0,272)|0;a[H+200>>0]=2;c[H>>2]=I;c[H+132>>2]=1;h=sd(H,B,q)|0;c[v>>2]=c[q>>2];k=I+81|0;h=(a[k>>0]|0)==0?h:7;if(!h)if(((c[H+228>>2]|0)==0?(c[H+232>>2]|0)==0:0)?(c[H+236>>2]|0)==0:0){c[r>>2]=32306;c[r+4>>2]=103316;c[r+8>>2]=31517;Bb(11,32001,r);h=11}else h=0;a[j>>0]=0;n=u+12|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[u>>2]=H;c[u+4>>2]=150;c[u+8>>2]=151;c[u+24>>2]=G;n=G+12|0;c[n>>2]=p;b:do if(!h){q=H+228|0;l=c[q>>2]|0;m=l;do if(l){j=c[l+12>>2]|0;if(j|0){h=H+12|0;c[h>>2]=0;Ik(H,j,0);h=(a[k>>0]|0)==0?c[h>>2]|0:7;if(h|0){E=171;break b}Zj(u,j)|0;break}j=c[l>>2]|0;do if(!j){c[n>>2]=m;u=0}else{t=a[y>>0]|0;h=(d[208+(t&255)>>0]|0)-(d[208+(d[j>>0]|0)>>0]|0)|0;if(!(t<<24>>24==0|(h|0)!=0)){k=y;do{k=k+1|0;j=j+1|0;t=a[k>>0]|0;h=(d[208+(t&255)>>0]|0)-(d[208+(d[j>>0]|0)>>0]|0)|0}while(!(t<<24>>24==0|(h|0)!=0))}c[n>>2]=m;if(h|0){u=0;break}m=c[(c[l+4>>2]|0)+(x<<4)>>2]|0;k=H+272|0;h=c[k>>2]|0;c:do if(h|0){l=k;while(1){j=h+12|0;if((c[h>>2]|0)==(m|0))break;h=c[j>>2]|0;if(!h)break c;else l=j}c[l>>2]=c[j>>2];c[j>>2]=c[G>>2];c[G>>2]=h;t=G+4|0;c[t>>2]=(c[t>>2]|0)+1}while(0);d:do if((c[s>>2]|0)<0){l=(c[q>>2]|0)+40|0;h=c[k>>2]|0;if(!h)break;while(1){j=h+12|0;if((c[h>>2]|0)==(l|0))break;h=c[j>>2]|0;if(!h)break d;else k=j}c[k>>2]=c[j>>2];c[j>>2]=c[G>>2];c[G>>2]=h;t=G+4|0;c[t>>2]=(c[t>>2]|0)+1}while(0);h=c[q>>2]|0;k=c[h+24>>2]|0;do if(k){j=c[k>>2]|0;if((j|0)<=0)break;h=k+4|0;while(1){k=c[h>>2]|0;if(k|0?Yj(u,k)|0:0)break;if((j|0)>1){j=j+-1|0;h=h+20|0}else break}h=c[q>>2]|0}while(0);h=c[h+8>>2]|0;if(h|0)do{k=c[h+40>>2]|0;e:do if(k|0){j=c[k>>2]|0;if((j|0)<=0)break;k=k+4|0;while(1){l=c[k>>2]|0;if(l|0?Yj(u,l)|0:0)break e;if((j|0)>1){j=j+-1|0;k=k+20|0}else break}}while(0);h=c[h+20>>2]|0}while((h|0)!=0);h=c[H+232>>2]|0;if(!h){u=1;break}while(1){k=c[h+40>>2]|0;f:do if(k|0){j=c[k>>2]|0;if((j|0)<=0)break;k=k+4|0;while(1){l=c[k>>2]|0;if(l|0?Yj(u,l)|0:0)break f;if((j|0)>1){j=j+-1|0;k=k+20|0}else break}}while(0);h=c[h+20>>2]|0;if(!h){u=1;break}}}while(0);h=c[(c[q>>2]|0)+16>>2]|0;if(h|0){q=H+272|0;r=((w|0)!=0)<<31>>31;s=(w|0)==0;t=G+4|0;do{o=c[h+20>>2]|0;if((o|0)>0){p=h+8|0;n=0;do{g:do if(u){m=h+36+(n<<3)|0;if((c[m>>2]|0)!=(x|0))break;j=c[q>>2]|0;if(!j)break;l=q;while(1){k=j+12|0;if((c[j>>2]|0)==(m|0))break;j=c[k>>2]|0;if(!j)break g;else l=k}c[l>>2]=c[k>>2];c[k>>2]=c[G>>2];c[G>>2]=j;c[t>>2]=(c[t>>2]|0)+1}while(0);k=c[p>>2]|0;h:do if(k|0){m=a[k>>0]|0;j=(d[208+(m&255)>>0]|0)-(d[208+(d[y>>0]|0)>>0]|0)|0;if(!(m<<24>>24==0|(j|0)!=0)){l=y;do{k=k+1|0;l=l+1|0;m=a[k>>0]|0;j=(d[208+(m&255)>>0]|0)-(d[208+(d[l>>0]|0)>>0]|0)|0}while(!(m<<24>>24==0|(j|0)!=0))}if(j|0)break;m=c[h+36+(n<<3)+4>>2]|0;do if(!m)j=r;else{if(s)break h;l=a[m>>0]|0;j=(d[208+(l&255)>>0]|0)-(d[208+(d[w>>0]|0)>>0]|0)|0;if(l<<24>>24==0|(j|0)!=0)break;k=w;l=m;do{l=l+1|0;k=k+1|0;K=a[l>>0]|0;j=(d[208+(K&255)>>0]|0)-(d[208+(d[k>>0]|0)>>0]|0)|0}while(!(K<<24>>24==0|(j|0)!=0))}while(0);if(j|0)break;j=c[q>>2]|0;if(!j)break;l=q;while(1){k=j+12|0;if((c[j>>2]|0)==(m|0))break;j=c[k>>2]|0;if(!j)break h;else l=k}c[l>>2]=c[k>>2];c[k>>2]=c[G>>2];c[G>>2]=j;c[t>>2]=(c[t>>2]|0)+1}while(0);n=n+1|0}while((n|0)<(o|0))}h=c[h+4>>2]|0}while((h|0)!=0)}}else{l=H+232|0;h=c[l>>2]|0;if(h|0){k=c[h+40>>2]|0;do if(k){j=c[k>>2]|0;if((j|0)<=0)break;h=k+4|0;while(1){k=c[h>>2]|0;if(k|0?Yj(u,k)|0:0)break;if((j|0)>1){j=j+-1|0;h=h+20|0}else break}h=c[l>>2]|0}while(0);h=c[h+36>>2]|0;if(!h)break;Yj(u,h)|0;break}h=jo(H,o?t:0)|0;if(h|0){E=171;break b}k=H+236|0;h=c[(c[k>>2]|0)+28>>2]|0;if(h|0)do{j=c[h+12>>2]|0;do if(j|0){if(($c(H,0,j,t)|0)!=(p|0))break;j=c[h+28>>2]|0;if(j|0)ko(H,G,c[j+8>>2]|0,w);lo(H,G,c[h+24>>2]|0,w);ko(H,G,c[h+20>>2]|0,w)}while(0);h=c[h+36>>2]|0}while((h|0)!=0);if((c[H+120>>2]|0)==(p|0))lo(H,G,c[(c[k>>2]|0)+16>>2]|0,w);mo(u,c[k>>2]|0)}while(0);h=no(f,G,B,A,z)|0;if(h|0)E=171}else E=171;while(0);do if((E|0)==171){if(!(c[v>>2]|0)){c[f+20>>2]=h;j=c[f>>2]|0;if(!(b[j+8>>1]&1))break;i:do switch(h|0){case 516:{h=50738;break}case 100:{h=50760;break}case 101:{h=50782;break}default:{h=h&255;if(h>>>0<29){if(!(520028155>>>h&1)){h=50724;break i}h=c[22960+(h<<2)>>2]|0}else h=50724}}while(0);wc(j,h,-1,1,0)|0;break}j=c[i+4>>2]|0;k=c[i+8>>2]|0;j:do if(j){h=b[j+8>>1]|0;do if((h&514)==514){if((a[j+10>>0]|0)!=1)break;j=c[j+16>>2]|0;break j}while(0);if(!(h&1))j=Eg(j,1)|0;else j=0}else j=0;while(0);k:do if(!k)h=0;else{h=b[k+8>>1]|0;do if((h&514)==514){if((a[k+10>>0]|0)!=1)break;h=c[k+16>>2]|0;break k}while(0);if(h&1){h=0;break}h=Eg(k,1)|0}while(0);K=c[v>>2]|0;c[F>>2]=j;c[F+4>>2]=h;c[F+8>>2]=59952;c[F+12>>2]=K;h=zb(49618,F)|0;c[f+20>>2]=1;wc(c[f>>2]|0,h,-1,1,-1)|0;if(h|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](h);break}else{K=Ua[c[29352>>2]&127](h)|0;c[14978]=(c[14978]|0)-K;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](h);break}}while(0);oo(H);po(I,c[G>>2]|0);c[C>>2]=D;Qa=J;return}
function me(a,d,f,g){a=a|0;d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=Qa;Qa=Qa+48|0;j=r+16|0;n=r+8|0;m=r;p=r+24|0;q=c[a+36>>2]|0;h=c[q>>2]|0;o=(1<<f+d)-(1<<d)|0;if(g&1|0){i=c[h+32>>2]|0;if(!i)h=0;else{h=0;do{if((i|0)!=(q|0))h=b[i+10>>1]|h;i=c[i+4>>2]|0}while((i|0)!=0)}i=o&65535;if(((o&(h&65535)|0)==0?(l=c[(c[(c[a+8>>2]|0)+40>>2]|0)+12>>2]|0,(l|0)>-1):0)?(b[p>>1]=2,b[p+2>>1]=0,c[p+4>>2]=d+120,c[p+8>>2]=f,f=c[606]|0,c[m>>2]=p,(Wa[f&127](l,13,m)|0)==-1):0){q=5;Qa=r;return q|0}p=~i;f=q+12|0;b[f>>1]=(e[f>>1]|0)&p;q=q+10|0;b[q>>1]=(e[q>>1]|0)&p;q=0;Qa=r;return q|0}h=c[h+32>>2]|0;i=(h|0)==0;if(!(g&4)){a:do if(!i){while(1){if(o&(e[h+12>>1]|0)|0){h=5;i=33;break}if(o&(e[h+10>>1]|0)|0){h=5;i=33;break}h=c[h+4>>2]|0;if(!h)break a}if((i|0)==33){Qa=r;return h|0}}while(0);h=c[(c[(c[a+8>>2]|0)+40>>2]|0)+12>>2]|0;if((h|0)>-1?(b[p>>1]=1,b[p+2>>1]=0,c[p+4>>2]=d+120,c[p+8>>2]=f,f=c[606]|0,c[j>>2]=p,(Wa[f&127](h,13,j)|0)==-1):0){q=5;Qa=r;return q|0}q=q+12|0;b[q>>1]=o|(e[q>>1]|0);q=0;Qa=r;return q|0}else{b:do if(i)h=0;else{i=0;while(1){if(o&(e[h+12>>1]|0)|0){h=5;break}i=b[h+10>>1]|i;h=c[h+4>>2]|0;if(!h){h=i;break b}}Qa=r;return h|0}while(0);if(((o&(h&65535)|0)==0?(k=c[(c[(c[a+8>>2]|0)+40>>2]|0)+12>>2]|0,(k|0)>-1):0)?(b[p>>1]=0,b[p+2>>1]=0,c[p+4>>2]=d+120,c[p+8>>2]=f,f=c[606]|0,c[n>>2]=p,(Wa[f&127](k,13,n)|0)==-1):0){q=5;Qa=r;return q|0}q=q+10|0;b[q>>1]=o|(e[q>>1]|0);q=0;Qa=r;return q|0}return 0}function ne(a){a=a|0;return}function oe(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;e=a+36|0;f=c[e>>2]|0;if(!f)return 0;g=c[f>>2]|0;d=g+32|0;while(1){h=c[d>>2]|0;if((h|0)==(f|0))break;else d=h+4|0}c[d>>2]=c[f+4>>2];if(!(c[7324]|0))_a[c[29344>>2]&127](f);else{h=Ua[c[29352>>2]&127](f)|0;c[14978]=(c[14978]|0)-h;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](f)}c[e>>2]=0;f=g+28|0;h=(c[f>>2]|0)+-1|0;c[f>>2]=h;if(h|0)return 0;if(b|0?(c[g+12>>2]|0)>-1:0)Ua[c[2532>>2]&127](c[g+8>>2]|0)|0;ye(a);return 0}function pe(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;c[f>>2]=0;return 0}function qe(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return 0}function re(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;j=Qa;Qa=Qa+192|0;i=j+24|0;g=j+16|0;f=j+8|0;e=j;h=j+104|0;d=j+28|0;if(b[a+18>>1]&128){Qa=j;return}if(Va[c[2400>>2]&255](c[a+12>>2]|0,d)|0){c[e>>2]=c[a+32>>2];Bb(28,31582,e);Qa=j;return}switch(c[d+16>>2]|0){case 0:{c[f>>2]=c[a+32>>2];Bb(28,31606,f);Qa=j;return}case 1:{e=a+8|0;if(!(c[e>>2]|0)){Qa=j;return}d=a+32|0;if(!(Va[c[2388>>2]&255](c[d>>2]|0,h)|0)){a=(c[e>>2]|0)+8|0;if((c[a+4>>2]|0)==0?(c[a>>2]|0)==(c[h+72>>2]|0):0){Qa=j;return}}c[i>>2]=c[d>>2];Bb(28,31662,i);Qa=j;return}default:{c[g>>2]=c[a+32>>2];Bb(28,31635,g);Qa=j;return}}}function se(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=Qa;Qa=Qa+16|0;f=e;c[f>>2]=d;d=Ku(a,b,f)|0;Qa=e;return d|0}function te(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;j=Qa;Qa=Qa+576|0;g=j+552|0;h=j+536|0;e=j+528|0;k=j+520|0;f=j;c[k>>2]=b;Ab(512,f,31408,k)|0;b=Cu(f)|0;a:do if((b|0)>0)while(1){if((a[f+b>>0]|0)==47)break a;if((b|0)>1)b=b+-1|0;else{i=5;break}}else i=5;while(0);if((i|0)==5)if((a[f>>0]|0)==47)b=1;else{a[f>>0]=46;b=1}a[f+b>>0]=0;while(1){b=Wa[c[2340>>2]&127](f,524288,420)|0;if((b|0)<0){if((c[(su()|0)>>2]|0)!=4){i=14;break}}else{if((b|0)>2){i=13;break}Ua[c[2352>>2]&127](b)|0;c[e>>2]=f;c[e+4>>2]=b;Bb(28,31900,e);if((Wa[c[2340>>2]&127](31943,0,0)|0)<0){b=-1;i=14;break}}}if((i|0)==13){c[d>>2]=b;k=0;Qa=j;return k|0}else if((i|0)==14){c[d>>2]=b;c[h>>2]=31984;c[h+4>>2]=36187;c[h+8>>2]=31517;Bb(14,32001,h);i=c[(su()|0)>>2]|0;k=bv(i)|0;c[g>>2]=36187;c[g+4>>2]=i;c[g+8>>2]=31807;c[g+12>>2]=f;c[g+16>>2]=k;Bb(14,31953,g);k=14;Qa=j;return k|0}return 0}function ue(){return Ka(30)|0}function ve(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;k=Qa;Qa=Qa+96|0;h=k;i=k+8|0;j=(d|0)!=0;f=j?d:420;g=b|524288;while(1){e=Wa[c[2340>>2]&127](a,g,f)|0;if((e|0)<0){if((c[(su()|0)>>2]|0)!=4){a=13;break}}else{if((e|0)>2){a=7;break}Ua[c[2352>>2]&127](e)|0;c[h>>2]=a;c[h+4>>2]=e;Bb(28,31900,h);if((Wa[c[2340>>2]&127](31943,b,d)|0)<0){e=-1;a=13;break}}}if((a|0)==7){if(!j){j=e;Qa=k;return j|0}if(((Va[c[2400>>2]&255](e,i)|0)==0?(c[i+36>>2]|0)==0:0)?(c[i+12>>2]&511|0)!=(d|0):0)Va[c[2508>>2]&255](e,d)|0;j=e;Qa=k;return j|0}else if((a|0)==13){Qa=k;return e|0}return 0}function we(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;k=Qa;Qa=Qa+112|0;j=k+80|0;i=k;a[d>>0]=0;e=c[14771]|0;if(!(c[672]|0))c[672]=Ca(32077)|0;if(!(c[673]|0))c[673]=Ca(32091)|0;f=i+12|0;g=e;e=0;while(1){if(((g|0?(Va[c[2388>>2]&255](g,i)|0)==0:0)?(c[f>>2]&61440|0)==16384:0)?(Va[c[2364>>2]&255](g,3)|0)==0:0)break;if(e>>>0>5){h=11;break}g=c[2688+(e<<2)>>2]|0;e=e+1|0}if((h|0)==11){j=6410;Qa=k;return j|0}f=d+(b+-2)|0;e=0;while(1){Db(8,i);a[f>>0]=0;l=i;m=c[l>>2]|0;l=c[l+4>>2]|0;c[j>>2]=g;h=j+8|0;c[h>>2]=m;c[h+4>>2]=l;c[j+16>>2]=0;Ab(b,d,32037,j)|0;if(e>>>0>10|(a[f>>0]|0)!=0){e=1;h=16;break}if(!(Va[c[2364>>2]&255](d,0)|0))e=e+1|0;else{e=0;h=16;break}}if((h|0)==16){Qa=k;return e|0}return 0}function xe(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;m=Qa;Qa=Qa+80|0;l=m+48|0;i=m+24|0;h=m+16|0;k=m;f=m+56|0;b[f+2>>1]=0;c[f+4>>2]=128;c[f+8>>2]=1;b[f>>1]=1;o=c[606]|0;g=e+12|0;n=c[g>>2]|0;c[k>>2]=f;if(Wa[o&127](n,12,k)|0){o=3850;Qa=m;return o|0}a:do switch(b[f>>1]|0){case 2:{if(a[e+22>>0]|0){a[e+23>>0]=1;o=1288;Qa=m;return o|0}d=d+8|0;f=c[(c[(c[d>>2]|0)+40>>2]|0)+12>>2]|0;if((f|0)>-1?(b[k>>1]=1,b[k+2>>1]=0,c[k+4>>2]=128,c[k+8>>2]=1,o=c[606]|0,c[h>>2]=k,(Wa[o&127](f,13,h)|0)==-1):0){o=5;Qa=m;return o|0}f=c[g>>2]|0;do{g=Va[c[2412>>2]&255](f,3)|0;if((g|0)>=0){j=12;break}}while((c[(su()|0)>>2]|0)==4);if((j|0)==12?(g|0)==0:0)break a;n=c[e+8>>2]|0;l=c[(su()|0)>>2]|0;o=bv(l)|0;c[i>>2]=36954;c[i+4>>2]=l;c[i+8>>2]=31726;c[i+12>>2]=(n|0)==0?59952:n;c[i+16>>2]=o;Bb(4618,31953,i);o=4618;Qa=m;return o|0}case 1:{o=5;Qa=m;return o|0}default:d=d+8|0}while(0);d=c[(c[(c[d>>2]|0)+40>>2]|0)+12>>2]|0;if((d|0)>-1){b[k>>1]=0;b[k+2>>1]=0;c[k+4>>2]=128;c[k+8>>2]=1;o=c[606]|0;c[l>>2]=k;d=(Wa[o&127](d,13,l)|0)==-1;d=d?5:0}else d=0;o=d;Qa=m;return o|0}function ye(a){a=a|0;var d=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;n=Qa;Qa=Qa+32|0;m=n;l=c[(c[a+8>>2]|0)+40>>2]|0;if(!l){Qa=n;return}if(c[l+28>>2]|0){Qa=n;return}f=Ta[c[2640>>2]&127]()|0;f=(f|0)<32768?1:(f|0)/32768|0;h=l+20|0;if(!(b[h>>1]|0))d=l+24|0;else{i=l+12|0;d=l+24|0;j=l+16|0;g=0;do{do if((c[i>>2]|0)<=-1){k=c[(c[d>>2]|0)+(g<<2)>>2]|0;if(k|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{o=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-o;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}}else Va[c[2616>>2]&255](c[(c[d>>2]|0)+(g<<2)>>2]|0,c[j>>2]|0)|0;while(0);g=g+f|0}while((g|0)<(e[h>>1]|0))}d=c[d>>2]|0;do if(d|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](d);break}else{o=Ua[c[29352>>2]&127](d)|0;c[14978]=(c[14978]|0)-o;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](d);break}while(0);f=l+12|0;d=c[f>>2]|0;if((d|0)>-1){if(Ua[c[2352>>2]&127](d)|0){if(!a)d=0;else d=c[a+32>>2]|0;a=c[(su()|0)>>2]|0;o=bv(a)|0;c[m>>2]=36897;c[m+4>>2]=a;c[m+8>>2]=31695;c[m+12>>2]=(d|0)==0?59952:d;c[m+16>>2]=o;Bb(4106,31953,m)}c[f>>2]=-1}c[(c[l>>2]|0)+40>>2]=0;if(!(c[7324]|0)){_a[c[29344>>2]&127](l);Qa=n;return}else{o=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-o;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);Qa=n;return}}function ze(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;f=Qa;Qa=Qa+32|0;e=f;b=a+12|0;d=c[b>>2]|0;if((d|0)>-1){if(Ua[c[2352>>2]&127](d)|0){g=c[a+32>>2]|0;h=c[(su()|0)>>2]|0;d=bv(h)|0;c[e>>2]=34584;c[e+4>>2]=h;c[e+8>>2]=31695;c[e+12>>2]=(g|0)==0?59952:g;c[e+16>>2]=d;Bb(4106,31953,e)}c[b>>2]=-1}b=c[a+28>>2]|0;if(!b){b=a;d=b+52|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(d|0));Qa=f;return 0}if(!(c[7324]|0)){_a[c[29344>>2]&127](b);b=a;d=b+52|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(d|0));Qa=f;return 0}else{d=Ua[c[29352>>2]&127](b)|0;c[14978]=(c[14978]|0)-d;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](b);b=a;d=b+52|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(d|0));Qa=f;return 0}return 0}function Ae(a,b){a=a|0;b=b|0;return 0}function Be(a,b){a=a|0;b=b|0;return 0}function Ce(a,b){a=a|0;b=b|0;c[b>>2]=0;return 0}function De(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;g=Qa;Qa=Qa+32|0;f=g;e=b+24|0;d=b+16|0;do if(a[d>>0]|0){if((Ua[c[2568>>2]&127](c[e>>2]|0)|0)>=0){a[d>>0]=0;break}d=c[(su()|0)>>2]|0;if((d|0)!=2)c[b+20>>2]=d}while(0);d=c[e>>2]|0;do if(d|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](d);break}else{e=Ua[c[29352>>2]&127](d)|0;c[14978]=(c[14978]|0)-e;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](d);break}while(0);d=b+12|0;e=c[d>>2]|0;if((e|0)>-1){if(Ua[c[2352>>2]&127](e)|0){h=c[b+32>>2]|0;i=c[(su()|0)>>2]|0;e=bv(i)|0;c[f>>2]=34584;c[f+4>>2]=i;c[f+8>>2]=31695;c[f+12>>2]=(h|0)==0?59952:h;c[f+16>>2]=e;Bb(4106,31953,f)}c[d>>2]=-1}d=c[b+28>>2]|0;if(!d){d=b;e=d+52|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(e|0));Qa=g;return 0}if(!(c[7324]|0)){_a[c[29344>>2]&127](d);d=b;e=d+52|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(e|0));Qa=g;return 0}else{e=Ua[c[29352>>2]&127](d)|0;c[14978]=(c[14978]|0)-e;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](d);d=b;e=d+52|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(e|0));Qa=g;return 0}return 0}function Ee(b,d){b=b|0;d=d|0;var e=0,f=0;e=c[b+24>>2]|0;f=b+16|0;if(a[f>>0]|0){a[f>>0]=d;Oa(e|0,0)|0;b=0;return b|0}e=Va[c[2556>>2]&255](e,511)|0;if((e|0)>=0){a[f>>0]=d;b=e;return b|0}d=c[(su()|0)>>2]|0;switch(d|0){case 1:{e=3;break}case 37:case 4:case 16:case 110:case 11:case 13:case 17:{b=5;return b|0}default:e=3850}c[b+20>>2]=d;b=e;return b|0}function Fe(b,e){b=b|0;e=e|0;var f=0,g=0;f=c[b+24>>2]|0;g=b+16|0;if((d[g>>0]|0|0)==(e|0)){b=0;return b|0}if((e|0)==1){a[g>>0]=1;b=0;return b|0}if((Ua[c[2568>>2]&127](f)|0)>=0){a[g>>0]=0;b=0;return b|0}e=c[(su()|0)>>2]|0;if((e|0)==2){b=0;return b|0}c[b+20>>2]=e;b=2058;return b|0}function Ge(a,b){a=a|0;b=b|0;c[b>>2]=(Va[c[2364>>2]&255](c[a+24>>2]|0,0)|0)==0&1;return 0}function He(a,b){a=a|0;b=b|0;return 29744}function Ie(a,b){a=a|0;b=b|0;return 29820}function Je(a,b){a=a|0;b=b|0;var d=0;if((b|0)==3082)return;if((b&251|4|0)!=14)return;b=c[a>>2]|0;d=c[b+68>>2]|0;if(!d)b=0;else b=Wa[d&127](b,0,0)|0;c[a+72>>2]=b;return}function Ke(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=Qa;Qa=Qa+96|0;h=f+72|0;g=c[b+108>>2]|0;c[h+4>>2]=f;c[h>>2]=b;c[h+8>>2]=70;c[h+12>>2]=g;c[h+16>>2]=0;g=h+20|0;a[g>>0]=0;a[h+21>>0]=1;rb(h,d,e);e=wb(h)|0;if((a[g>>0]|0)!=7){Qa=f;return e|0}d=b+81|0;if(a[d>>0]|0){Qa=f;return e|0}if(a[b+82>>0]|0){Qa=f;return e|0}a[d>>0]=1;if((c[b+180>>2]|0)>0)c[b+264>>2]=1;d=b+272|0;c[d>>2]=(c[d>>2]|0)+1;d=c[b+236>>2]|0;if(!d){Qa=f;return e|0}c[d+12>>2]=7;Qa=f;return e|0}function Le(a,d){a=a|0;d=d|0;var e=0,f=0;e=c[a+260>>2]|0;do if(e|0){f=e+8|0;if(!(b[f>>1]&9216)){b[f>>1]=1;break}else{Bg(e);break}}while(0);if((d|0)==3082)return;if((d&251|4|0)!=14)return;d=c[a>>2]|0;e=c[d+68>>2]|0;if(!e)d=0;else d=Wa[e&127](d,0,0)|0;c[a+72>>2]=d;return}function Me(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;h=Qa;Qa=Qa+16|0;d=h+4|0;f=c[b>>2]|0;g=f+16|0;if(c[(c[g>>2]|0)+20>>2]|0){g=0;Qa=h;return g|0}if(a[b+199>>0]|0){g=0;Qa=h;return g|0}e=Ne(c[f>>2]|0,0,f,d,0,542)|0;if(e|0){ad(b,32157,h);c[b+12>>2]=e;g=1;Qa=h;return g|0}e=c[d>>2]|0;c[(c[g>>2]|0)+20>>2]=e;if((Sd(e,c[f+92>>2]|0,-1,0)|0)==7){Dc(f);g=1;Qa=h;return g|0}else{g=0;Qa=h;return g|0}return 0}function Ne(e,f,g,h,i,j){e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;J=Qa;Qa=Qa+128|0;p=J+104|0;D=J+120|0;A=J+116|0;H=J;G=(f|0)==0;if(!G){k=(a[f>>0]|0)==0;if(zu(f,32227)|0)if(k)B=4;else{k=0;B=5}else B=6}else B=4;if((B|0)==4)if((a[g+80>>0]|0)==2){k=1;B=6}else{k=1;B=5}if((B|0)==5)if(!(j&128)){F=0;E=i}else B=6;if((B|0)==6){F=1;E=i|2}C=(j&256|0)!=0&(F|k)?j&-769|512:j;if(!(c[7324]|0)){i=Ua[c[29340>>2]&127](48)|0;if(!i){h=7;Qa=J;return h|0}else I=i}else{i=Ua[c[29356>>2]&127](48)|0;if((c[14985]|0)>>>0<48)c[14985]=48;l=59064;j=c[l>>2]|0;l=c[l+4>>2]|0;if((l|0)>0|(l|0)==0&j>>>0>0){I=c[14978]|0;z=Rv(j|0,l|0,i|0,((i|0)<0)<<31>>31|0)|0;y=L()|0;c[14768]=((y|0)<0|(y|0)==0&z>>>0<=I>>>0)&1}j=Ua[c[29340>>2]&127](i)|0;if(!j){h=7;Qa=J;return h|0}i=Ua[c[29352>>2]&127](j)|0;i=(c[14978]|0)+i|0;c[14978]=i;if(i>>>0>(c[14982]|0)>>>0)c[14982]=i;i=(c[14981]|0)+1|0;c[14981]=i;if(i>>>0>(c[14987]|0)>>>0){c[14987]=i;I=j}else I=j}l=I+4|0;s=l+44|0;do{a[l>>0]=0;l=l+1|0}while((l|0)<(s|0));c[I>>2]=g;c[I+32>>2]=I;c[I+36>>2]=1;a:do if(!k?!((C&131072|0)==0|F&(C&64|0)==0):0){if(G)k=0;else k=(Cu(f)|0)&1073741823;l=k+1|0;m=(c[e+8>>2]|0)+1|0;k=(m|0)>(l|0)?m:l;z=Qv(k|0,0,-1,-1)|0;y=L()|0;do if(!(y>>>0>0|(y|0)==0&z>>>0>2147483390)){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](k)|0;a[I+9>>0]=1;if(!k)break;else n=k}else{j=Ua[c[29356>>2]&127](k)|0;if((c[14985]|0)>>>0<k>>>0)c[14985]=k;k=59064;i=c[k>>2]|0;k=c[k+4>>2]|0;if((k|0)>0|(k|0)==0&i>>>0>0){z=c[14978]|0;y=Rv(i|0,k|0,j|0,((j|0)<0)<<31>>31|0)|0;x=L()|0;c[14768]=((x|0)<0|(x|0)==0&y>>>0<=z>>>0)&1}i=Ua[c[29340>>2]&127](j)|0;if(!i){B=33;break}k=Ua[c[29352>>2]&127](i)|0;k=(c[14978]|0)+k|0;c[14978]=k;if(k>>>0>(c[14982]|0)>>>0)c[14982]=k;k=(c[14981]|0)+1|0;c[14981]=k;if(k>>>0>(c[14987]|0)>>>0)c[14987]=k;a[I+9>>0]=1;n=i}if(!F){a[n>>0]=0;k=Xa[c[e+36>>2]&127](e,f,m,n)|0;if(k|0){if(!(c[7324]|0))_a[c[29344>>2]&127](n);else{h=Ua[c[29352>>2]&127](n)|0;c[14978]=(c[14978]|0)-h;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](n)}if(!(c[7324]|0)){_a[c[29344>>2]&127](I);h=k;Qa=J;return h|0}else{h=Ua[c[29352>>2]&127](I)|0;c[14978]=(c[14978]|0)-h;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](I);h=k;Qa=J;return h|0}}}else cw(n|0,f|0,l|0)|0;j=c[14822]|0;b:do if(!j)j=0;else{while(1){k=c[j>>2]|0;if((zu(n,c[k+168>>2]|0)|0)==0?(c[k>>2]|0)==(e|0):0)break;j=c[j+68>>2]|0;if(!j){j=0;break b}}k=c[g+20>>2]|0;c:do if((k|0)>0){l=c[g+16>>2]|0;while(1){i=k;k=k+-1|0;z=c[l+(k<<4)+4>>2]|0;if(z|0?(c[z+4>>2]|0)==(j|0):0)break;if((i|0)<=1)break c}if(!(c[7324]|0))_a[c[29344>>2]&127](n);else{h=Ua[c[29352>>2]&127](n)|0;c[14978]=(c[14978]|0)-h;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](n)}if(!(c[7324]|0)){_a[c[29344>>2]&127](I);h=19;Qa=J;return h|0}else{h=Ua[c[29352>>2]&127](I)|0;c[14978]=(c[14978]|0)-h;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](I);h=19;Qa=J;return h|0}}while(0);c[I+4>>2]=j;z=j+64|0;c[z>>2]=(c[z>>2]|0)+1}while(0);if(!(c[7324]|0))_a[c[29344>>2]&127](n);else{z=Ua[c[29352>>2]&127](n)|0;c[14978]=(c[14978]|0)-z;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](n)}if(!j){B=69;break a}if(!(a[I+9>>0]|0))break a;else{B=213;break a}}else B=33;while(0);if((B|0)==33)a[I+9>>0]=1;if(!(c[7324]|0)){_a[c[29344>>2]&127](I);h=7;Qa=J;return h|0}else{h=Ua[c[29352>>2]&127](I)|0;c[14978]=(c[14978]|0)-h;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](I);h=7;Qa=J;return h|0}}else B=69;while(0);d:do if((B|0)==69){if(!(c[7324]|0)){j=Ua[c[29340>>2]&127](84)|0;if(!j)k=7;else B=80}else{k=Ua[c[29356>>2]&127](84)|0;if((c[14985]|0)>>>0<84)c[14985]=84;j=59064;i=c[j>>2]|0;j=c[j+4>>2]|0;if((j|0)>0|(j|0)==0&i>>>0>0){z=c[14978]|0;y=Rv(i|0,j|0,k|0,((k|0)<0)<<31>>31|0)|0;x=L()|0;c[14768]=((x|0)<0|(x|0)==0&y>>>0<=z>>>0)&1}j=Ua[c[29340>>2]&127](k)|0;if(j){k=Ua[c[29352>>2]&127](j)|0;k=(c[14978]|0)+k|0;c[14978]=k;if(k>>>0>(c[14982]|0)>>>0)c[14982]=k;k=(c[14981]|0)+1|0;c[14981]=k;if(k>>>0>(c[14987]|0)>>>0){c[14987]=k;B=80}else B=80}else k=7}do if((B|0)==80){l=j+4|0;s=l+80|0;do{a[l>>0]=0;l=l+1|0}while((l|0)<(s|0));y=E&1;z=(y|0)!=0;c[D>>2]=4096;s=e+4|0;u=c[s>>2]|0;u=((u|0)>72?u:72)+7&-8;c[j>>2]=0;do if(!(E&2))if(!G)if(a[f>>0]|0){o=e+8|0;m=(c[o>>2]|0)+1|0;k=m<<1;B=Qv(k|0,((k|0)<0)<<31>>31|0,-1,-1)|0;x=L()|0;if(!(x>>>0>0|(x|0)==0&B>>>0>2147483390)){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](k)|0;if(!k){k=7;B=229;break}else i=k}else{l=Ua[c[29356>>2]&127](k)|0;if((c[14985]|0)>>>0<k>>>0)c[14985]=k;i=59064;k=c[i>>2]|0;i=c[i+4>>2]|0;if((i|0)>0|(i|0)==0&k>>>0>0){B=c[14978]|0;x=Rv(k|0,i|0,l|0,((l|0)<0)<<31>>31|0)|0;w=L()|0;c[14768]=((w|0)<0|(w|0)==0&x>>>0<=B>>>0)&1}i=Ua[c[29340>>2]&127](l)|0;if(!i){k=7;B=229;break}k=Ua[c[29352>>2]&127](i)|0;k=(c[14978]|0)+k|0;c[14978]=k;if(k>>>0>(c[14982]|0)>>>0)c[14982]=k;k=(c[14981]|0)+1|0;c[14981]=k;if(k>>>0>(c[14987]|0)>>>0)c[14987]=k}a[i>>0]=0;k=Xa[c[e+36>>2]&127](e,f,m,i)|0;n=(Cu(i)|0)&1073741823;m=f+(((Cu(f)|0)&1073741823)+1)|0;if(!(a[m>>0]|0))l=m;else{l=m;do{l=l+(((Cu(l)|0)&1073741823)+1)|0;l=l+(((Cu(l)|0)&1073741823)+1)|0}while((a[l>>0]|0)!=0)}if(!k){if((n+8|0)<=(c[o>>2]|0)){x=0;r=l+1-m|0;p=m;q=1;B=119;break}c[p>>2]=31984;c[p+4>>2]=55390;c[p+8>>2]=31517;Bb(14,32001,p);k=14}if(!(c[7324]|0)){_a[c[29344>>2]&127](i);B=229;break}else{B=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-B;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);B=229;break}}else{k=7;B=229}}else{x=0;r=0;p=0;i=0;n=0;q=1;B=119}else{f=0;x=0;r=0;p=0;i=0;n=0;q=0;B=119}else if(!G)if(a[f>>0]|0){m=(Cu(f)|0)+1|0;B=Qv(m|0,0,-1,-1)|0;x=L()|0;if(x>>>0>0|(x|0)==0&B>>>0>2147483390){k=7;B=229}else{if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](m)|0;if(!k){k=7;B=229;break}}else{k=Ua[c[29356>>2]&127](m)|0;if((c[14985]|0)>>>0<m>>>0)c[14985]=m;l=59064;i=c[l>>2]|0;l=c[l+4>>2]|0;if((l|0)>0|(l|0)==0&i>>>0>0){B=c[14978]|0;x=Rv(i|0,l|0,k|0,((k|0)<0)<<31>>31|0)|0;w=L()|0;c[14768]=((w|0)<0|(w|0)==0&x>>>0<=B>>>0)&1}k=Ua[c[29340>>2]&127](k)|0;if(!k){k=7;B=229;break}i=Ua[c[29352>>2]&127](k)|0;i=(c[14978]|0)+i|0;c[14978]=i;if(i>>>0>(c[14982]|0)>>>0)c[14982]=i;i=(c[14981]|0)+1|0;c[14981]=i;if(i>>>0>(c[14987]|0)>>>0)c[14987]=i}cw(k|0,f|0,m|0)|0;f=0;x=1;r=0;p=0;i=k;n=(Cu(k)|0)&1073741823;q=0;B=119}}else{x=1;r=0;p=0;i=0;n=0;q=1;B=119}else{f=0;x=1;r=0;p=0;i=0;n=0;q=0;B=119}while(0);e:do if((B|0)==119){o=(u<<1)+17+(n*3|0)+r+((c[s>>2]|0)+279&-8)|0;w=Qv(o|0,0,-1,-1)|0;v=L()|0;do if(!(v>>>0>0|(v|0)==0&w>>>0>2147483390)){if(!(c[7324]|0)){k=Ua[c[29340>>2]&127](o)|0;if(!k)break;else w=k}else{k=Ua[c[29356>>2]&127](o)|0;if((c[14985]|0)>>>0<o>>>0)c[14985]=o;m=59064;l=c[m>>2]|0;m=c[m+4>>2]|0;if((m|0)>0|(m|0)==0&l>>>0>0){w=c[14978]|0;v=Rv(l|0,m|0,k|0,((k|0)<0)<<31>>31|0)|0;t=L()|0;c[14768]=((t|0)<0|(t|0)==0&v>>>0<=w>>>0)&1}l=Ua[c[29340>>2]&127](k)|0;if(!l)break;k=Ua[c[29352>>2]&127](l)|0;k=(c[14978]|0)+k|0;c[14978]=k;if(k>>>0>(c[14982]|0)>>>0)c[14982]=k;k=(c[14981]|0)+1|0;c[14981]=k;if(k>>>0>(c[14987]|0)>>>0){c[14987]=k;w=l}else w=l}ew(w|0,0,o|0)|0;t=w+212|0;c[t>>2]=w+224;k=w+272|0;v=w+60|0;c[v>>2]=k;k=k+((c[s>>2]|0)+7&-8)|0;c[w+68>>2]=k;k=k+u|0;c[w+64>>2]=k;k=k+u|0;m=w+168|0;c[m>>2]=k;do if(i|0){l=n+1|0;o=w+172|0;c[o>>2]=k+(r+l);cw(k|0,i|0,n|0)|0;if(r|0)cw((c[m>>2]|0)+l|0,p|0,r|0)|0;cw(c[o>>2]|0,i|0,n|0)|0;l=(c[o>>2]|0)+n|0;k=32236;s=l+10|0;do{a[l>>0]=a[k>>0]|0;l=l+1|0;k=k+1|0}while((l|0)<(s|0));s=(c[o>>2]|0)+(n+9)|0;u=w+220|0;c[u>>2]=s;cw(s|0,i|0,n|0)|0;u=(c[u>>2]|0)+n|0;a[u>>0]=a[32246]|0;a[u+1>>0]=a[32247]|0;a[u+2>>0]=a[32248]|0;a[u+3>>0]=a[32249]|0;a[u+4>>0]=a[32250]|0;if(!(c[7324]|0)){_a[c[29344>>2]&127](i);break}else{u=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-u;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);break}}while(0);c[w>>2]=e;c[w+144>>2]=C;f:do if(q?(a[f>>0]|0)!=0:0){c[A>>2]=0;k=Ya[c[e+24>>2]&127](e,c[m>>2]|0,c[v>>2]|0,C&556927,A)|0;m=c[A>>2]&1;if(k|0)break;l=c[v>>2]|0;l=Ua[c[(c[l>>2]|0)+48>>2]&127](l)|0;g:do if(!m){do if(!(a[w+12>>0]|0)){B=c[v>>2]|0;if((Ua[c[(c[B>>2]|0)+48>>2]&127](B)|0)&4096|0)break;k=c[v>>2]|0;i=c[(c[k>>2]|0)+44>>2]|0;do if(i){B=Ua[i&127](k)|0;k=(B|0)<65536?B:65536;if((B|0)<32){k=512;break}c[w+148>>2]=k;if(k>>>0<=4096)break g;if(k>>>0>8192){c[D>>2]=8192;break g}else{c[D>>2]=k;break g}}else k=4096;while(0);c[w+148>>2]=k;break g}while(0);c[w+148>>2]=512}while(0);k=f+(((Cu(f)|0)&1073741823)+1)|0;h:do if(!(a[k>>0]|0))k=0;else{while(1){B=zu(k,32252)|0;k=k+(((Cu(k)|0)&1073741823)+1)|0;if(!B)break;k=k+(((Cu(k)|0)&1073741823)+1)|0;if(!(a[k>>0]|0)){k=0;break h}}k=(Xm(k,1,0)|0)<<24>>24!=0}while(0);a[w+13>>0]=k&1;i:do if(!(l&8192)){k=f+(((Cu(f)|0)&1073741823)+1)|0;j:do if(a[k>>0]|0){while(1){B=zu(k,32259)|0;k=k+(((Cu(k)|0)&1073741823)+1)|0;if(!B)break;k=k+(((Cu(k)|0)&1073741823)+1)|0;if(!(a[k>>0]|0))break j}if((Xm(k,1,0)|0)<<24>>24)break i}while(0);q=m;f=0;B=170;break f}while(0);k=C|1;B=168}else{k=C;B=168}while(0);if((B|0)==168){a[w+16>>0]=1;a[w+17>>0]=4;a[w+13>>0]=1;q=k&1;f=1;B=170}if((B|0)==170){k=Qe(w,D,-1)|0;if(!k){p=c[D>>2]|0;r=(x|0)==0;i=x^1;k=r?119:0;n=c[t>>2]|0;l=n;s=l+48|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(s|0));o=n+24|0;c[o>>2]=1;l=n+28|0;c[l>>2]=88;a[n+32>>0]=i;a[n+33>>0]=2;c[n+36>>2]=k;c[n+40>>2]=w;k=n+16|0;c[k>>2]=100;c[n+20>>2]=1;m=Wa[c[29424>>2]&127](p,128,i)|0;if(!m)k=7;else{i=c[7357]|0;k=c[k>>2]|0;if((k|0)<=-1){C=Wv(k|0,((k|0)<0)<<31>>31|0,-1024,-1)|0;D=L()|0;k=(c[l>>2]|0)+(c[o>>2]|0)|0;k=Uv(C|0,D|0,k|0,((k|0)<0)<<31>>31|0)|0;L()|0}$a[i&127](m,k);k=n+44|0;i=c[k>>2]|0;if(i|0)_a[c[29452>>2]&127](i);c[k>>2]=m;c[o>>2]=p;a[w+6>>0]=y^1;c[w+156>>2]=1073741823;a[w+12>>0]=f;a[w+4>>0]=f;a[w+18>>0]=f;a[w+15>>0]=x;a[w+14>>0]=q;a[w+7>>0]=f;do if(!(f<<24>>24)){a[w+8>>0]=1;a[w+9>>0]=0;a[w+10>>0]=2;a[w+11>>0]=10;b[w+140>>1]=88;D=w+160|0;c[D>>2]=-1;c[D+4>>2]=-1;D=c[v>>2]|0;if((Ua[c[(c[D>>2]|0)+48>>2]&127](D)|0)&4096|0){k=512;break}k=c[v>>2]|0;i=c[(c[k>>2]|0)+44>>2]|0;if(!i){k=4096;break}k=Ua[i&127](k)|0;k=(k|0)<32?512:(k|0)<65536?k:65536}else{b[w+140>>1]=88;k=w+160|0;c[k>>2]=-1;c[k+4>>2]=-1;k=512}while(0);c[w+148>>2]=k;if(z|r^1)a[w+5>>0]=((y&255)<<1&255^2)+2<<24>>24;c[w+200>>2]=92;c[w+204>>2]=(c[w+40>>2]|0)==0?74:75;c[j>>2]=w;D=g+48|0;s=c[D+4>>2]|0;l=w+128|0;c[l>>2]=c[D>>2];c[l+4>>2]=s;l=H;s=l+100|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(s|0));k=c[v>>2]|0;i=c[k>>2]|0;if(i|0){k=Ya[c[i+8>>2]&127](k,H,100,0,0)|0;switch(k|0){case 0:case 522:break;default:{B=230;break e}}}a[j+16>>0]=E;c[j+4>>2]=g;k=c[j>>2]|0;i=k+176|0;c[i>>2]=117;c[k+180>>2]=j;l=c[k+60>>2]|0;m=c[l>>2]|0;if(!m)l=k;else{Wa[c[m+40>>2]&127](l,15,i)|0;l=c[j>>2]|0}c[I+4>>2]=j;c[j+8>>2]=0;c[j+12>>2]=0;if(a[l+14>>0]|0){E=j+22|0;b[E>>1]=b[E>>1]|1}k=d[H+17>>0]<<16|d[H+16>>0]<<8;m=j+32|0;c[m>>2]=k;do if((k+-512|0)>>>0>65024)B=205;else{if(k+16777215&k|0){B=205;break}k=a[H+20>>0]|0;i=j+22|0;b[i>>1]=b[i>>1]|2;a[j+17>>0]=(d[H+53>>0]<<16|d[H+52>>0]<<24|d[H+54>>0]<<8|d[H+55>>0]|0)!=0&1;i=(d[H+65>>0]<<16|d[H+64>>0]<<24|d[H+66>>0]<<8|d[H+67>>0]|0)!=0&1;B=208}while(0);do if((B|0)==205){c[m>>2]=0;if(G|F){k=0;break}a[j+17>>0]=0;k=0;i=0;B=208}while(0);if((B|0)==208)a[j+18>>0]=i;i=k&255;k=Qe(l,m,i)|0;if(k|0){B=230;break e}c[j+36>>2]=(c[m>>2]|0)-i;c[j+64>>2]=1;if(!(a[I+9>>0]|0))break d;c[j+68>>2]=c[14822];c[14822]=j;B=213;break d}}}i=c[v>>2]|0;l=c[i>>2]|0;if(l|0){Ua[c[l+4>>2]&127](i)|0;c[i>>2]=0}l=c[w+208>>2]|0;k:do if(l|0){i=l;do if((c[14816]|0)>>>0<=i>>>0)if((c[14817]|0)>>>0>i>>>0){c[14979]=(c[14979]|0)+-1;c[l>>2]=c[14819];c[14819]=l;g=(c[14820]|0)+1|0;c[14820]=g;c[14821]=(g|0)<(c[14815]|0)&1;break k}else{i=Ua[c[29352>>2]&127](l)|0;break}else i=Ua[c[29352>>2]&127](l)|0;while(0);c[14980]=(c[14980]|0)-i;if(!(c[7324]|0)){_a[c[29344>>2]&127](l);break}else{g=Ua[c[29352>>2]&127](l)|0;c[14978]=(c[14978]|0)-g;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](l);break}}while(0);if(!(c[7324]|0)){_a[c[29344>>2]&127](w);B=229;break e}else{B=Ua[c[29352>>2]&127](w)|0;c[14978]=(c[14978]|0)-B;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](w);B=229;break e}}while(0);if(i)if(!(c[7324]|0)){_a[c[29344>>2]&127](i);k=7;B=229;break}else{k=Ua[c[29352>>2]&127](i)|0;c[14978]=(c[14978]|0)-k;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](i);k=7;B=229;break}else{k=7;B=229}}while(0);if((B|0)==229)if(j)B=230;if((B|0)==230){i=c[j>>2]|0;if(i)Re(i,0)}if(j)if(!(c[7324]|0)){_a[c[29344>>2]&127](j);break}else{g=Ua[c[29352>>2]&127](j)|0;c[14978]=(c[14978]|0)-g;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](j);break}}while(0);if(!(c[7324]|0))_a[c[29344>>2]&127](I);else{g=Ua[c[29352>>2]&127](I)|0;c[14978]=(c[14978]|0)-g;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](I)}c[h>>2]=0;h=k;Qa=J;return h|0}while(0);l:do if((B|0)==213){m=c[g+20>>2]|0;if((m|0)>0){l=c[g+16>>2]|0;k=0;while(1){i=c[l+(k<<4)+4>>2]|0;if(i|0?a[i+9>>0]|0:0)break;k=k+1|0;if((k|0)>=(m|0))break l}while(1){k=c[i+28>>2]|0;if(!k)break;else i=k}m=c[I+4>>2]|0;if(m>>>0<(c[i+4>>2]|0)>>>0){c[I+24>>2]=i;c[I+28>>2]=0;c[i+28>>2]=I;break}k=i+24|0;l=c[k>>2]|0;m:do if(!l)B=224;else{while(1){if((c[l+4>>2]|0)>>>0>=m>>>0)break;k=l+24|0;i=c[k>>2]|0;if(!i){i=l;B=224;break m}else{g=l;l=i;i=g}}c[I+24>>2]=l;c[I+28>>2]=i;c[l+28>>2]=I}while(0);if((B|0)==224){c[I+24>>2]=0;c[I+28>>2]=i}c[k>>2]=I}}while(0);c[h>>2]=I;k=c[I+4>>2]|0;c[k+4>>2]=c[I>>2];if(!(c[k+48>>2]|0)){h=c[(c[k>>2]|0)+212>>2]|0;c[h+16>>2]=-2e3;g=c[7357]|0;I=c[h+44>>2]|0;h=(c[h+28>>2]|0)+(c[h+24>>2]|0)|0;h=Uv(2048e3,0,h|0,((h|0)<0)<<31>>31|0)|0;L()|0;$a[g&127](I,h)}k=c[(c[j>>2]|0)+60>>2]|0;i=c[k>>2]|0;if(!i){h=0;Qa=J;return h|0}Wa[c[i+40>>2]&127](k,30,j+4|0)|0;h=0;Qa=J;return h|0}function Oe(d){d=d|0;var e=0;e=c[d+8>>2]|0;if(!(a[e>>0]|0))return;a[e>>0]=0;if((b[d+30>>1]|0)<=1)return;Ef(e)|0;return}function Pe(b){b=b|0;var d=0,e=0,f=0,g=0;f=c[b+4>>2]|0;b=c[(c[b>>2]|0)+60>>2]|0;d=c[f+396>>2]|0;if(!d){g=0;return g|0}g=f+404|0;e=c[g>>2]|0;if((e|0)<0){g=0;return g|0}if(!(a[f+408>>0]|0))b=Va[d&255](c[f+400>>2]|0,e)|0;else b=Wa[d&127](c[f+400>>2]|0,e,b)|0;if(!b)d=-1;else d=(c[g>>2]|0)+1|0;c[g>>2]=d;g=b;return g|0}function Qe(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;r=Qa;Qa=Qa+16|0;o=r;p=c[f>>2]|0;if(!((a[e+15>>0]|0)!=0?(c[e+24>>2]|0)!=0:0))l=3;a:do if(((l|0)==3?(m=e+212|0,p|0?(c[(c[m>>2]|0)+12>>2]|0)==0:0):0)?(q=e+152|0,(p|0)!=(c[q>>2]|0)):0){n=o;c[n>>2]=0;c[n+4>>2]=0;if(((a[e+16>>0]|0)!=0?(i=c[e+60>>2]|0,j=c[i>>2]|0,(j|0)!=0):0)?(k=Va[c[j+24>>2]&255](i,o)|0,(k|0)!=0):0)g=k;else l=8;b:do if((l|0)==8){k=p+8|0;if((c[14813]|0)>=(k|0)?(h=c[14819]|0,(h|0)!=0):0){c[14819]=c[h>>2];n=c[14820]|0;c[14820]=n+-1;c[14821]=(n|0)<=(c[14815]|0)&1;if((c[14986]|0)>>>0<k>>>0)c[14986]=k;i=(c[14979]|0)+1|0;c[14979]=i;if(i>>>0>(c[14983]|0)>>>0)c[14983]=i}else{n=Qv(k|0,((k|0)<0)<<31>>31|0,-1,-1)|0;l=L()|0;if(l>>>0>0|(l|0)==0&n>>>0>2147483390){g=7;break}if(!(c[7324]|0)){h=Ua[c[29340>>2]&127](k)|0;if(!h){g=7;break}}else{h=Ua[c[29356>>2]&127](k)|0;if((c[14985]|0)>>>0<k>>>0)c[14985]=k;j=59064;i=c[j>>2]|0;j=c[j+4>>2]|0;if((j|0)>0|(j|0)==0&i>>>0>0){n=c[14978]|0;l=Rv(i|0,j|0,h|0,((h|0)<0)<<31>>31|0)|0;j=L()|0;c[14768]=((j|0)<0|(j|0)==0&l>>>0<=n>>>0)&1}h=Ua[c[29340>>2]&127](h)|0;if(!h){g=7;break}i=Ua[c[29352>>2]&127](h)|0;i=(c[14978]|0)+i|0;c[14978]=i;if(i>>>0>(c[14982]|0)>>>0)c[14982]=i;i=(c[14981]|0)+1|0;c[14981]=i;if(i>>>0>(c[14987]|0)>>>0)c[14987]=i}i=Ua[c[29352>>2]&127](h)|0;if((c[14986]|0)>>>0<k>>>0)c[14986]=k;i=(c[14980]|0)+i|0;c[14980]=i;if(i>>>0>(c[14984]|0)>>>0)c[14984]=i}k=h+p|0;n=k;a[n>>0]=0;a[n+1>>0]=0;a[n+2>>0]=0;a[n+3>>0]=0;k=k+4|0;a[k>>0]=0;a[k+1>>0]=0;a[k+2>>0]=0;a[k+3>>0]=0;Df(e);k=c[m>>2]|0;m=k+24|0;do if(c[m>>2]|0){j=k+28|0;n=Wa[c[29424>>2]&127](p,(c[j>>2]|0)+40|0,d[k+32>>0]|0)|0;if(n|0){l=c[7357]|0;i=c[k+16>>2]|0;if((i|0)<=-1){t=Wv(i|0,((i|0)<0)<<31>>31|0,-1024,-1)|0;s=L()|0;i=(c[j>>2]|0)+(c[m>>2]|0)|0;i=Uv(t|0,s|0,i|0,((i|0)<0)<<31>>31|0)|0;L()|0}$a[l&127](n,i);i=k+44|0;j=c[i>>2]|0;if(j|0)_a[c[29452>>2]&127](j);c[i>>2]=n;c[m>>2]=p;break}g=h;do if((c[14816]|0)>>>0<=g>>>0)if((c[14817]|0)>>>0>g>>>0){c[14979]=(c[14979]|0)+-1;c[h>>2]=c[14819];c[14819]=h;g=(c[14820]|0)+1|0;c[14820]=g;c[14821]=(g|0)<(c[14815]|0)&1;g=7;break b}else{g=Ua[c[29352>>2]&127](h)|0;break}else g=Ua[c[29352>>2]&127](h)|0;while(0);c[14980]=(c[14980]|0)-g;if(!(c[7324]|0)){_a[c[29344>>2]&127](h);g=7;break b}else{g=Ua[c[29352>>2]&127](h)|0;c[14978]=(c[14978]|0)-g;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](h);g=7;break b}}while(0);j=e+208|0;k=c[j>>2]|0;c:do if(k|0){i=k;do if((c[14816]|0)>>>0<=i>>>0)if((c[14817]|0)>>>0>i>>>0){c[14979]=(c[14979]|0)+-1;c[k>>2]=c[14819];c[14819]=k;t=(c[14820]|0)+1|0;c[14820]=t;c[14821]=(t|0)<(c[14815]|0)&1;break c}else{i=Ua[c[29352>>2]&127](k)|0;break}else i=Ua[c[29352>>2]&127](k)|0;while(0);c[14980]=(c[14980]|0)-i;if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{t=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-t;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}}while(0);c[j>>2]=h;t=o;s=c[t>>2]|0;t=c[t+4>>2]|0;o=Qv(p|0,0,-1,-1)|0;t=Qv(o|0,L()|0,s|0,t|0)|0;t=Uv(t|0,L()|0,p|0,0)|0;L()|0;c[e+24>>2]=t;c[q>>2]=p;break a}while(0);c[f>>2]=c[q>>2];t=g;Qa=r;return t|0}while(0);c[f>>2]=c[e+152>>2];h=e+142|0;if((g|0)<0)g=b[h>>1]|0;b[h>>1]=g;t=0;Qa=r;return t|0}function Re(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=Qa;Qa=Qa+16|0;h=o;n=c[b+208>>2]|0;f=c[b+136>>2]|0;if(f|0)do{g=f;f=c[f+16>>2]|0;if(!(c[7324]|0))_a[c[29344>>2]&127](g);else{l=Ua[c[29352>>2]&127](g)|0;c[14978]=(c[14978]|0)-l;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](g)}}while((f|0)!=0);l=b+4|0;a[l>>0]=0;do if((e|0)!=0?(0==0?(c[e+32>>2]&2048|0)==0:0):0){c[h>>2]=0;if((((a[b+12>>0]|0)==0?(c[b+24>>2]|0)!=0:0)?(i=c[b+60>>2]|0,j=c[i>>2]|0,(j|0)!=0):0)?(k=Wa[c[j+40>>2]&127](i,20,h)|0,(k|0)!=12):0){if(c[h>>2]|k|0){f=0;break}}else m=14;f=n}else f=0;while(0);k=b+216|0;Nf(c[k>>2]|0,e,d[b+11>>0]|0,c[b+152>>2]|0,f)|0;c[k>>2]=0;Df(b);if(!(a[b+15>>0]|0)){h=b+64|0;f=c[h>>2]|0;g=c[f>>2]|0;a:do if(g|0){if(!(a[b+7>>0]|0)){f=Va[c[g+20>>2]&255](f,2)|0;if(!f){f=c[h>>2]|0;g=c[f>>2]|0;m=22}}else m=22;if((m|0)==22)f=Va[c[g+24>>2]&255](f,b+80|0)|0;switch((f&255)<<24>>24){case 10:case 13:break;default:break a}c[b+40>>2]=f;a[b+16>>0]=6;c[b+204>>2]=(f|0)==0?74:75}while(0);switch(a[b+16>>0]|0){case 0:case 6:break;case 1:{if(!(a[l>>0]|0))sf(b,0,0)|0;break}default:rf(b)|0}tf(b)}else tf(b);f=c[b+64>>2]|0;g=c[f>>2]|0;if(g|0){Ua[c[g+4>>2]&127](f)|0;c[f>>2]=0}f=c[b+60>>2]|0;g=c[f>>2]|0;if(g|0){Ua[c[g+4>>2]&127](f)|0;c[f>>2]=0}b:do if(n|0){f=n;do if((c[14816]|0)>>>0<=f>>>0)if((c[14817]|0)>>>0>f>>>0){c[14979]=(c[14979]|0)+-1;c[n>>2]=c[14819];c[14819]=n;n=(c[14820]|0)+1|0;c[14820]=n;c[14821]=(n|0)<(c[14815]|0)&1;break b}else{f=Ua[c[29352>>2]&127](n)|0;break}else f=Ua[c[29352>>2]&127](n)|0;while(0);c[14980]=(c[14980]|0)-f;if(!(c[7324]|0)){_a[c[29344>>2]&127](n);break}else{m=Ua[c[29352>>2]&127](n)|0;c[14978]=(c[14978]|0)-m;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](n);break}}while(0);_a[c[29452>>2]&127](c[(c[b+212>>2]|0)+44>>2]|0);if(!(c[7324]|0)){_a[c[29344>>2]&127](b);Qa=o;return}else{n=Ua[c[29352>>2]&127](b)|0;c[14978]=(c[14978]|0)-n;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](b);Qa=o;return}}function Se(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;h=d+40|0;if(c[h>>2]|0){e=0;return e|0}g=a[d+20>>0]|0;if(g<<24>>24){if(g&3){e=0;return e|0}if(b[e+28>>1]&8){e=0;return e|0}}j=d+196|0;c[j>>2]=(c[j>>2]|0)+1;c[e+16>>2]=0;do if(c[d+216>>2]|0){f=Te(e)|0;if(!f){f=Ue(d,e,0,0)|0;i=12}}else{if(!((b[e+28>>1]&8)==0?(a[d+16>>0]|0)!=3:0))i=10;if((i|0)==10?(f=Ve(d,1)|0,f|0):0)break;f=We(d,e)|0;i=12}while(0);if((i|0)==12)if(!f){j=c[e+12>>2]|0;f=j+8|0;g=e+36|0;d=c[g>>2]|0;if((c[f>>2]|0)==(e|0))c[f>>2]=d;h=c[e+32>>2]|0;i=(h|0)==0;if(i){c[j+4>>2]=d;f=d}else{c[h+36>>2]=d;f=c[g>>2]|0}if(!f){c[j>>2]=h;if(i)a[j+33>>0]=2}else c[f+32>>2]=h;i=e+28|0;b[i>>1]=b[i>>1]&-16|1;if(b[e+30>>1]|0){e=0;return e|0}if(!(a[j+32>>0]|0)){e=0;return e|0}ab[c[29440>>2]&255](c[j+44>>2]|0,c[e>>2]|0,0);e=0;return e|0}switch((f&255)<<24>>24){case 10:case 13:break;default:{e=f;return e|0}}c[h>>2]=f;a[d+16>>0]=6;c[d+204>>2]=75;e=f;return e|0}function Te(b){b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;v=Qa;Qa=Qa+16|0;r=v;q=c[b+20>>2]|0;s=b+24|0;i=c[s>>2]|0;t=q+96|0;g=c[t>>2]|0;if((g|0)<=0){u=0;Qa=v;return u|0}u=q+92|0;m=c[u>>2]|0;n=i+-1|0;l=0;a:while(1){b:do if((c[m+(l*48|0)+20>>2]|0)>>>0>=i>>>0){h=c[m+(l*48|0)+16>>2]|0;e=c[h>>2]|0;if(n>>>0>=e>>>0)break a;f=c[h+8>>2]|0;if(!f)j=n;else{j=n;k=h;do{e=(j>>>0)/(f>>>0)|0;k=c[k+12+(e<<2)>>2]|0;if(!k)break a;j=j-(G(e,f)|0)|0;f=c[k+8>>2]|0}while((f|0)!=0);h=k;e=c[k>>2]|0}if(e>>>0<4001)if(!(1<<(j&7)&d[h+12+(j>>>3)>>0]))break a;else break;k=j+1|0;e=(j>>>0)%125|0;f=c[h+12+(e<<2)>>2]|0;if(!f)break a;while(1){if((f|0)==(k|0))break b;e=((e+1|0)>>>0)%125|0;f=c[h+12+(e<<2)>>2]|0;if(!f)break a}}while(0);l=l+1|0;if((l|0)>=(g|0)){e=0;p=35;break}}if((p|0)==35){Qa=v;return e|0}e=a[q+5>>0]|0;do if(e<<24>>24!=2){k=q+68|0;h=c[k>>2]|0;c:do if(!(c[h>>2]|0)){do if(e<<24>>24!=4?(o=c[7334]|0,(a[q+21>>0]|0)==0):0){e=c[q>>2]|0;f=h;g=f+72|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));if(o|0){g=o;f=(o|0)>0?o:1020;break}e=Ya[c[e+24>>2]&127](e,0,h,8222,0)|0;if(!e)break c;Qa=v;return e|0}else p=22;while(0);if((p|0)==22){e=c[q>>2]|0;f=h;g=f+72|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));g=-1;f=1020}c[h+4>>2]=f;c[h>>2]=29896;c[h+8>>2]=g;c[h+56>>2]=8222;c[h+64>>2]=0;c[h+60>>2]=e}while(0);i=c[b+4>>2]|0;j=q+52|0;f=q+152|0;g=(c[f>>2]|0)+4|0;g=Wv(g|0,((g|0)<0)<<31>>31|0,c[j>>2]|0,0)|0;h=L()|0;e=c[k>>2]|0;q=c[s>>2]|0;a[r>>0]=q>>>24;a[r+1>>0]=q>>>16;a[r+2>>0]=q>>>8;a[r+3>>0]=q;e=Ya[c[(c[e>>2]|0)+12>>2]&127](e,r,4,g,h)|0;if(e|0){u=e;Qa=v;return u|0}b=c[k>>2]|0;q=c[f>>2]|0;r=Qv(g|0,h|0,4,0)|0;e=L()|0;e=Ya[c[(c[b>>2]|0)+12>>2]&127](b,i,q,r,e)|0;if(!e){e=j;g=c[t>>2]|0;i=c[s>>2]|0;break}else{u=e;Qa=v;return u|0}}else e=q+52|0;while(0);c[e>>2]=(c[e>>2]|0)+1;if((g|0)<=0){u=0;Qa=v;return u|0}e=0;h=0;while(1){f=c[u>>2]|0;if((c[f+(h*48|0)+20>>2]|0)>>>0<i>>>0)f=g;else{e=bf(c[f+(h*48|0)+16>>2]|0,i)|0|e;f=c[t>>2]|0}h=h+1|0;if((h|0)>=(f|0))break;else g=f}Qa=v;return e|0}function Ue(e,f,g,h){e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0;za=Qa;Qa=Qa+48|0;sa=za+32|0;qa=za;k=za+36|0;c[k>>2]=f;R=(h|0)==0;if(!R){c[k>>2]=f;if(!f){ya=0;f=0}else{i=f;f=0;j=k;do{xa=(c[i+24>>2]|0)>>>0>g>>>0;ya=i+16|0;f=f+((xa^1)&1)|0;j=xa?j:ya;i=c[ya>>2]|0;c[j>>2]=i}while((i|0)!=0);ya=c[k>>2]|0}}else{ya=f;f=1}xa=e+192|0;c[xa>>2]=(c[xa>>2]|0)+f;if((c[ya+24>>2]|0)==1){va=c[ya+20>>2]|0;va=(d[va+105>>0]<<16|d[va+104>>0]<<24|d[va+106>>0]<<8|d[va+107>>0])+1|0;xa=ya+4|0;wa=c[xa>>2]|0;oa=va>>>24&255;a[wa+24>>0]=oa;ra=va>>>16&255;a[wa+25>>0]=ra;ua=va>>>8&255;a[wa+26>>0]=ua;va=va&255;a[wa+27>>0]=va;wa=c[xa>>2]|0;a[wa+92>>0]=oa;a[wa+93>>0]=ra;a[wa+94>>0]=ua;a[wa+95>>0]=va;xa=c[xa>>2]|0;a[xa+96>>0]=0;a[xa+97>>0]=46;a[xa+98>>0]=52;a[xa+99>>0]=32}wa=c[e+216>>2]|0;ua=c[e+152>>2]|0;U=d[e+11>>0]|0;va=wa+32|0;f=c[c[va>>2]>>2]|0;xa=wa+52|0;if(!(Ju(xa,f,48)|0))B=0;else B=(c[f+16>>2]|0)+1|0;o=wa+40|0;if(!(b[o>>1]|0)){a:do if(!(c[f+96>>2]|0)){l=wa+43|0;$=20}else{Db(4,qa);k=wa+43|0;b:do if(!(a[k>>0]|0)){f=c[wa+4>>2]|0;f=Xa[c[(c[f>>2]|0)+56>>2]&127](f,4,4,10)|0;switch(f|0){case 0:{$=15;break b}case 5:break b;default:{}}p=f;break a}else $=15;while(0);if(($|0)==15){m=c[qa>>2]|0;i=c[va>>2]|0;f=c[i>>2]|0;j=f+96|0;$=wa+84|0;oa=wa+112|0;c[oa>>2]=(c[oa>>2]|0)+1;c[wa+68>>2]=0;oa=$+1|0;ra=$+2|0;n=$+3|0;l=(d[oa>>0]<<16|d[$>>0]<<24|d[ra>>0]<<8|d[n>>0])+1|0;a[$>>0]=l>>>24;a[oa>>0]=l>>>16;a[ra>>0]=l>>>8;a[n>>0]=l;c[wa+88>>2]=m;i=c[i>>2]|0;a[wa+64>>0]=1;c[xa>>2]=3007e3;n=c[xa+4>>2]|0;l=n+6014e3+(c[xa+8>>2]|0)|0;n=n+3007e3+(c[xa+12>>2]|0)+l|0;l=n+l|0;n=n+(c[xa+20>>2]|0)+l|0;l=l+(c[xa+24>>2]|0)+n|0;n=n+(c[xa+28>>2]|0)+l|0;l=l+(c[xa+32>>2]|0)+n|0;c[wa+92>>2]=l;c[wa+96>>2]=n+m+l;l=i+48|0;m=xa;n=l+48|0;do{a[l>>0]=a[m>>0]|0;l=l+1|0;m=m+1|0}while((l|0)<(n|0));if((a[k>>0]|0)!=2){ra=c[wa+4>>2]|0;_a[c[(c[ra>>2]|0)+60>>2]&127](ra)}l=i;m=xa;n=l+48|0;do{a[l>>0]=a[m>>0]|0;l=l+1|0;m=m+1|0}while((l|0)<(n|0));c[j>>2]=0;c[f+128>>2]=0;c[f+104>>2]=0;c[f+108>>2]=-1;c[f+112>>2]=-1;c[f+116>>2]=-1;if(!(a[k>>0]|0)){ra=c[wa+4>>2]|0;Xa[c[(c[ra>>2]|0)+56>>2]&127](ra,4,4,9)|0}}l=k;$=20}while(0);if(($|0)==20){if(!(a[l>>0]|0)){ra=c[wa+4>>2]|0;Xa[c[(c[ra>>2]|0)+56>>2]&127](ra,3,1,5)|0}b[o>>1]=-1;f=0;do{f=f+1|0;i=ef(wa,qa,1,f)|0}while((i|0)==-1);p=i}if(p|0){g=p;Qa=za;return g|0}}ra=wa+68|0;l=c[ra>>2]|0;c:do if(!l){a[qa>>0]=55;a[qa+1>>0]=127;a[qa+2>>0]=6;a[qa+3>>0]=-126;f=qa+4|0;a[f>>0]=0;a[qa+5>>0]=45;a[qa+6>>0]=-30;a[qa+7>>0]=24;i=qa+8|0;a[i>>0]=ua>>>24;a[qa+9>>0]=ua>>>16;a[qa+10>>0]=ua>>>8;a[qa+11>>0]=ua;j=qa+12|0;oa=c[wa+112>>2]|0;a[j>>0]=oa>>>24;a[qa+13>>0]=oa>>>16;a[qa+14>>0]=oa>>>8;a[qa+15>>0]=oa;k=wa+84|0;if(!oa)Db(8,k);oa=k;Y=c[oa>>2]|0;oa=c[oa+4>>2]|0;W=qa+16|0;c[W>>2]=Y;c[W+4>>2]=oa;W=c[qa>>2]|0;X=(c[f>>2]|0)+W|0;f=X+W+(c[i>>2]|0)|0;i=(c[j>>2]|0)+X+f|0;f=f+Y+i|0;i=i+oa+f|0;a[qa+24>>0]=f>>>24;a[qa+25>>0]=f>>>16;a[qa+26>>0]=f>>>8;a[qa+27>>0]=f;a[qa+28>>0]=i>>>24;a[qa+29>>0]=i>>>16;a[qa+30>>0]=i>>>8;a[qa+31>>0]=i;c[wa+36>>2]=ua;a[wa+65>>0]=0;c[wa+76>>2]=f;c[wa+80>>2]=i;a[wa+47>>0]=1;i=wa+8|0;f=c[i>>2]|0;f=Ya[c[(c[f>>2]|0)+12>>2]&127](f,qa,32,0,0)|0;do if(!f){if((a[wa+48>>0]|0?(q=c[i>>2]|0,r=U>>>2&3,r|0):0)?(s=Va[c[(c[q>>2]|0)+20>>2]&255](q,r)|0,s|0):0){f=s;break}Y=i;break c}while(0);g=f;Qa=za;return g|0}else Y=wa+8|0;while(0);V=c[Y>>2]|0;W=ua+24|0;X=((W|0)<0)<<31>>31;i=Wv(l|0,0,W|0,X|0)|0;i=Qv(i|0,L()|0,32,0)|0;f=L()|0;oa=(ya|0)==0;d:do if(!oa){q=(B|0)==0;r=V;s=U&3;t=(s|0)==0;u=wa+104|0;v=((ua|0)<0)<<31>>31;p=ya;m=0;o=f;n=i;e:while(1){do if(q)$=47;else{j=p+16|0;if(!(R|(c[j>>2]|0)!=0)){K=0;S=l+1|0;$=49;break}c[qa>>2]=0;cf(wa,c[p+24>>2]|0,qa)|0;k=c[qa>>2]|0;if(k>>>0<B>>>0){$=47;break}f=Wv(k+-1|0,0,W|0,X|0)|0;f=Qv(f|0,L()|0,56,0)|0;i=L()|0;if(((c[u>>2]|0)+-1|0)>>>0>=k>>>0)c[u>>2]=k;C=c[Y>>2]|0;C=Ya[c[(c[C>>2]|0)+12>>2]&127](C,c[p+4>>2]|0,ua,f,i)|0;if(C|0){$=45;break e}w=p+28|0;b[w>>1]=b[w>>1]&-65;w=l;x=m;y=j;z=n;A=o}while(0);if(($|0)==47){f=l+1|0;if(R){M=0;T=f;$=50}else{K=c[p+16>>2]|0;S=f;$=49}}if(($|0)==49){M=(K|0)==0?g:0;T=S;$=50}if(($|0)==50){$=0;m=c[p+4>>2]|0;kf(wa,c[p+24>>2]|0,M,m,qa);if(!(o>>>0<4294967295|(o|0)==-1&n>>>0<4294967272)){l=0-n|0;f=Ya[c[(c[r>>2]|0)+12>>2]&127](r,qa,l,n,o)|0;if(f|0){E=f;$=63;break}f=Qv(n|0,o|0,l|0,((l|0)<0)<<31>>31|0)|0;i=L()|0;j=n+24|0;if(t)k=0;else k=Va[c[(c[r>>2]|0)+20>>2]&255](r,s)|0;if((j|0)!=0&(k|0)==0){H=j;J=qa+l|0;N=f;O=i;$=55}else F=k}else{H=24;J=qa;N=n;O=o;$=55}if(($|0)==55){$=0;F=Ya[c[(c[r>>2]|0)+12>>2]&127](r,J,H,N,O)|0}if(F|0){E=F;$=63;break}f=Qv(n|0,o|0,24,0)|0;i=L()|0;Qv(f|0,i|0,ua|0,v|0)|0;if(!((o|0)>-1|(o|0)==-1&n>>>0>4294967271|(L()|0)<0)){l=-24-n|0;j=Ya[c[(c[r>>2]|0)+12>>2]&127](r,m,l,f,i)|0;if(j|0){E=j;$=63;break}f=Qv(f|0,i|0,l|0,((l|0)<0)<<31>>31|0)|0;i=L()|0;j=ua-l|0;if(t)k=0;else k=Va[c[(c[r>>2]|0)+20>>2]&255](r,s)|0;if((j|0)!=0&(k|0)==0){G=j;I=m+l|0;P=f;Q=i;$=62}else D=k}else{G=ua;I=m;P=f;Q=i;$=62}if(($|0)==62){$=0;D=Ya[c[(c[r>>2]|0)+12>>2]&127](r,I,G,P,Q)|0}f=p+28|0;if(D|0){da=D;$=127;break}z=Qv(n|0,o|0,W|0,X|0)|0;A=L()|0;b[f>>1]=b[f>>1]|64;w=T;x=p;y=p+16|0}p=c[y>>2]|0;if(!p){ma=w;ta=x;Z=z;_=A;break d}else{l=w;m=x;o=A;n=z}}if(($|0)==45){g=C;Qa=za;return g|0}else if(($|0)==63){g=E;Qa=za;return g|0}else if(($|0)==127){Qa=za;return da|0}}else{ma=l;ta=0;Z=i;_=f}while(0);A=(h|0)!=0;if(A){i=wa+104|0;if(c[i>>2]|0){m=(c[wa+36>>2]|0)+24|0;v=lb(m)|0;if(!v){g=7;Qa=za;return g|0}p=c[i>>2]|0;o=(p|0)==1;n=((m|0)<0)<<31>>31;p=Wv(p+-2|0,0,m|0,n|0)|0;p=Qv(p|0,L()|0,48,0)|0;f=L()|0;q=c[Y>>2]|0;f=Ya[c[(c[q>>2]|0)+8>>2]&127](q,v,8,o?24:p,o?0:f)|0;o=v+1|0;p=v+2|0;q=v+3|0;c[wa+76>>2]=d[o>>0]<<16|d[v>>0]<<24|d[p>>0]<<8|d[q>>0];r=v+4|0;s=v+5|0;t=v+6|0;u=v+7|0;c[wa+80>>2]=d[s>>0]<<16|d[r>>0]<<24|d[t>>0]<<8|d[u>>0];j=c[i>>2]|0;c[i>>2]=0;f:do if(!((f|0)!=0|j>>>0>ma>>>0)){l=v+24|0;do{i=Wv(j+-1|0,0,m|0,n|0)|0;i=Qv(i|0,L()|0,32,0)|0;k=L()|0;f=c[Y>>2]|0;f=Ya[c[(c[f>>2]|0)+8>>2]&127](f,v,m,i,k)|0;if(f|0)break f;kf(wa,d[o>>0]<<16|d[v>>0]<<24|d[p>>0]<<8|d[q>>0],d[s>>0]<<16|d[r>>0]<<24|d[t>>0]<<8|d[u>>0],l,qa);f=c[Y>>2]|0;f=Ya[c[(c[f>>2]|0)+12>>2]&127](f,qa,24,i,k)|0;j=j+1|0}while(!(j>>>0>ma>>>0|(f|0)!=0))}while(0);if(!(c[7324]|0))_a[c[29344>>2]&127](v);else{T=Ua[c[29352>>2]&127](v)|0;c[14978]=(c[14978]|0)-T;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](v)}if(f|0){g=f;Qa=za;return g|0}}z=U&3;do if(!z){i=0;k=0}else{if(a[wa+49>>0]|0){f=c[Y>>2]|0;i=c[(c[f>>2]|0)+44>>2]|0;if(!i){f=4096;i=0}else{i=Ua[i&127](f)|0;U=(i|0)<32;i=(i|0)<65536?i:65536;f=U?512:i;i=U?0:((i|0)<0)<<31>>31}y=Qv(Z|0,_|0,-1,-1)|0;y=Qv(y|0,L()|0,f|0,i|0)|0;v=L()|0;u=Xv(y|0,v|0,f|0,i|0)|0;u=Rv(y|0,v|0,u|0,L()|0)|0;v=L()|0;y=(u|0)==(Z|0)&(v|0)==(_|0);g:do if((v|0)>(_|0)|(v|0)==(_|0)&u>>>0>Z>>>0){s=ta+4|0;t=ta+24|0;w=V;x=((ua|0)<0)<<31>>31;k=0;r=Z;q=_;while(1){p=c[s>>2]|0;kf(wa,c[t>>2]|0,g,p,qa);n=Qv(r|0,q|0,24,0)|0;o=L()|0;if(!((v|0)>(o|0)|(v|0)==(o|0)&u>>>0>n>>>0)){m=Rv(u|0,v|0,r|0,q|0)|0;L()|0;f=Ya[c[(c[w>>2]|0)+12>>2]&127](w,qa,m,r,q)|0;if(f|0){ba=f;break}f=Qv(r|0,q|0,m|0,((m|0)<0)<<31>>31|0)|0;i=L()|0;j=24-m|0;l=Va[c[(c[w>>2]|0)+20>>2]&255](w,z)|0;if((j|0)!=0&(l|0)==0){fa=j;ha=qa+m|0;ia=f;ja=i;$=89}else ca=l}else{fa=24;ha=qa;ia=r;ja=q;$=89}if(($|0)==89){$=0;ca=Ya[c[(c[w>>2]|0)+12>>2]&127](w,ha,fa,ia,ja)|0}if(ca|0){ba=ca;break}_=Qv(n|0,o|0,ua|0,x|0)|0;Z=L()|0;if(!((v|0)<(o|0)|(v|0)==(o|0)&u>>>0<=n>>>0|((Z|0)<(v|0)|(Z|0)==(v|0)&_>>>0<u>>>0))){m=Rv(u|0,v|0,n|0,o|0)|0;L()|0;f=Ya[c[(c[w>>2]|0)+12>>2]&127](w,p,m,n,o)|0;if(f|0){ba=f;break}f=Qv(n|0,o|0,m|0,((m|0)<0)<<31>>31|0)|0;i=L()|0;j=ua-m|0;l=Va[c[(c[w>>2]|0)+20>>2]&255](w,z)|0;if((j|0)!=0&(l|0)==0){ea=j;ga=p+m|0;ka=f;la=i;$=94}else aa=l}else{ea=ua;ga=p;ka=n;la=o;$=94}if(($|0)==94){$=0;aa=Ya[c[(c[w>>2]|0)+12>>2]&127](w,ga,ea,ka,la)|0}if(aa|0){da=aa;$=127;break}r=Qv(r|0,q|0,W|0,X|0)|0;q=L()|0;k=k+1|0;if(!((v|0)>(q|0)|(v|0)==(q|0)&u>>>0>r>>>0))break g}if(($|0)==127){Qa=za;return da|0}g=ba;Qa=za;return g|0}else k=0;while(0);if(!y){i=0;break}}else k=0;i=V;i=Va[c[(c[i>>2]|0)+20>>2]&255](i,z)|0}while(0);m=wa+47|0;if((a[m>>0]|0)!=0?(pa=wa+16|0,na=c[pa>>2]|0,pa=c[pa+4>>2]|0,(pa|0)>-1|(pa|0)==-1&na>>>0>4294967295):0){l=Wv(k+ma|0,0,W|0,X|0)|0;l=Qv(l|0,L()|0,32,0)|0;j=L()|0;f=(j|0)>(pa|0)|(j|0)==(pa|0)&l>>>0>na>>>0;l=f?l:na;j=f?j:pa;f=c[Y>>2]|0;f=Va[c[(c[f>>2]|0)+24>>2]&255](f,qa)|0;pa=c[qa+4>>2]|0;if((f|0)==0&((pa|0)>(j|0)|((pa|0)==(j|0)?(c[qa>>2]|0)>>>0>l>>>0:0))){f=c[Y>>2]|0;f=Wa[c[(c[f>>2]|0)+16>>2]&127](f,l,j)|0}if(f|0){c[sa>>2]=c[wa+108>>2];Bb(f,32326,sa)}a[m>>0]=0}}else{i=0;k=0}f=c[ra>>2]|0;if((ya|0)!=0&(i|0)==0){l=ya;do{j=f+1|0;if(!(b[l+28>>1]&64))i=0;else{i=df(wa,j,c[l+24>>2]|0)|0;f=j}l=c[l+16>>2]|0}while((i|0)==0&(l|0)!=0)}j=(i|0)==0;if((k|0)>0&j){l=ta+24|0;while(1){f=f+1|0;i=df(wa,f,c[l>>2]|0)|0;j=(i|0)==0;if((k|0)>1&j)k=k+-1|0;else{k=f;break}}}else k=f;if(j){b[wa+66>>1]=ua&65280|ua>>>16;c[ra>>2]=k;if(A){f=wa+60|0;m=c[f>>2]|0;c[f>>2]=m+1;c[wa+72>>2]=g;f=c[c[va>>2]>>2]|0;a[wa+64>>0]=1;c[xa>>2]=3007e3;l=c[xa+4>>2]|0;m=m+6014001+l|0;l=l+3007e3+(c[xa+12>>2]|0)+m|0;m=m+k+l|0;l=l+g+m|0;m=m+(c[xa+24>>2]|0)+l|0;l=l+(c[xa+28>>2]|0)+m|0;m=m+(c[xa+32>>2]|0)+l|0;l=l+(c[xa+36>>2]|0)+m|0;c[wa+92>>2]=m;c[wa+96>>2]=l;l=f+48|0;m=xa;n=l+48|0;do{a[l>>0]=a[m>>0]|0;l=l+1|0;m=m+1|0}while((l|0)<(n|0));if((a[wa+43>>0]|0)!=2){g=c[wa+4>>2]|0;_a[c[(c[g>>2]|0)+60>>2]&127](g)}l=f;m=xa;n=l+48|0;do{a[l>>0]=a[m>>0]|0;l=l+1|0;m=m+1|0}while((l|0)<(n|0));c[wa+12>>2]=k}}else if(i|0){g=i;Qa=za;return g|0}j=e+88|0;i=c[j>>2]|0;if((i|0)==0|oa){g=0;Qa=za;return g|0}f=ya;while(1){if(i|0)lf(i,c[f+24>>2]|0,c[f+4>>2]|0);f=c[f+16>>2]|0;if(!f){da=0;break}i=c[j>>2]|0}Qa=za;return da|0}function Ve(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=Qa;Qa=Qa+32|0;l=t+16|0;p=t;f=c[d+40>>2]|0;if(f|0){d=f;Qa=t;return d|0}a:do if(!(c[d+216>>2]|0)){k=d+17|0;g=d+13|0;h=d+60|0;i=d+176|0;j=d+180|0;b:while(1){switch(a[k>>0]|0){case 0:case 1:case 2:case 3:case 5:break;default:break a}if(a[g>>0]|0){g=7;break}f=c[h>>2]|0;f=Va[c[(c[f>>2]|0)+28>>2]&255](f,4)|0;switch(f|0){case 0:{g=7;break b}case 5:break;default:{g=36;break b}}if(!(Ua[c[i>>2]&127](c[j>>2]|0)|0)){f=5;g=36;break}}if((g|0)==7){a[k>>0]=4;break}else if((g|0)==36){Qa=t;return f|0}}while(0);do if(!(a[d+7>>0]|0)){j=d+64|0;if(c[c[j>>2]>>2]|0?(a[d+5>>0]|0)!=4:0){i=c[d+60>>2]|0;i=Ua[c[(c[i>>2]|0)+48>>2]&127](i)|0;k=(i&512|0)==0;c:do if(k){g=p;c[g>>2]=-117058087;c[g+4>>2]=-681336544;g=c[d+44>>2]|0;a[p+8>>0]=g>>>24;a[p+9>>0]=g>>>16;a[p+10>>0]=g>>>8;a[p+11>>0]=g;g=d+72|0;f=c[g>>2]|0;g=c[g+4>>2]|0;if((f|0)==0&(g|0)==0){g=0;h=0}else{f=Qv(f|0,g|0,-1,-1)|0;h=L()|0;g=c[d+148>>2]|0;h=Uv(f|0,h|0,g|0,0)|0;h=Qv(h|0,L()|0,1,0)|0;g=Wv(h|0,L()|0,g|0,0)|0;h=L()|0}f=c[j>>2]|0;f=Ya[c[(c[f>>2]|0)+8>>2]&127](f,l,8,g,h)|0;if(!f)if(!(Ju(l,32352,8)|0)){f=c[j>>2]|0;f=Ya[c[(c[f>>2]|0)+12>>2]&127](f,59953,1,g,h)|0;g=19}else g=20;else g=19;if((g|0)==19)switch(f|0){case 0:case 522:{g=20;break}default:{}}do if((g|0)==20){g=i&1024;if(((g|0)==0&(a[d+8>>0]|0)!=0?(m=c[j>>2]|0,n=a[d+10>>0]|0,n<<24>>24):0)?(o=Va[c[(c[m>>2]|0)+20>>2]&255](m,n&255)|0,o|0):0){f=o;break}o=c[j>>2]|0;f=d+80|0;f=Ya[c[(c[o>>2]|0)+12>>2]&127](o,p,12,c[f>>2]|0,c[f+4>>2]|0)|0;if(!f){f=g;break c}}while(0);d=f;Qa=t;return d|0}else f=i&1024;while(0);if(((f|0)==0?(q=c[j>>2]|0,r=a[d+10>>0]|0,r=(r<<24>>24==3?16:0)|r&255,r|0):0)?(s=Va[c[(c[q>>2]|0)+20>>2]&255](q,r)|0,s|0):0){d=s;Qa=t;return d|0}q=d+72|0;r=c[q+4>>2]|0;s=d+80|0;c[s>>2]=c[q>>2];c[s+4>>2]=r;if((e|0)==0|k^1)break;c[d+44>>2]=0;f=mf(d)|0;if(!f)break;Qa=t;return f|0}q=d+72|0;r=c[q+4>>2]|0;s=d+80|0;c[s>>2]=c[q>>2];c[s+4>>2]=r}while(0);g=c[d+212>>2]|0;f=c[g>>2]|0;if(f|0)do{s=f+28|0;b[s>>1]=b[s>>1]&-9;f=c[f+32>>2]|0}while((f|0)!=0);c[g+8>>2]=c[g+4>>2];a[d+16>>0]=4;d=0;Qa=t;return d|0}function We(e,f){e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;t=Qa;Qa=Qa+16|0;l=t;s=e+60|0;h=c[s>>2]|0;if((c[h>>2]|0)==0?(g=c[e>>2]|0,g=Ya[c[g+24>>2]&127](g,0,h,c[e+144>>2]&556897|30,0)|0,g|0):0){s=g;Qa=t;return s|0}k=e+36|0;h=c[k>>2]|0;j=e+24|0;g=c[j>>2]|0;do if(h>>>0<g>>>0){if((c[f+16>>2]|0)==0?(c[f+24>>2]|0)>>>0<=h>>>0:0)break;r=c[e+152>>2]|0;r=Wv(r|0,((r|0)<0)<<31>>31|0,g|0,0)|0;i=L()|0;h=l;c[h>>2]=r;c[h+4>>2]=i;h=c[s>>2]|0;i=c[h>>2]|0;if(i){Wa[c[i+40>>2]&127](h,5,l)|0;g=c[j>>2]|0}c[k>>2]=g}while(0);if(!f){s=0;Qa=t;return s|0}n=e+24|0;o=e+152|0;p=e+104|0;q=e+32|0;r=e+192|0;m=e+88|0;do{e=c[f+24>>2]|0;if(e>>>0<=(c[n>>2]|0)>>>0?(b[f+28>>1]&16)==0:0){g=c[o>>2]|0;h=Wv(g|0,((g|0)<0)<<31>>31|0,e+-1|0,0)|0;i=L()|0;j=(e|0)==1;if(j){k=c[f+20>>2]|0;k=((d[k+105>>0]|0)<<16|(d[k+104>>0]|0)<<24|(d[k+106>>0]|0)<<8|(d[k+107>>0]|0))+1|0;l=f+4|0;g=c[l>>2]|0;w=k>>>24&255;a[g+24>>0]=w;v=k>>>16&255;a[g+25>>0]=v;u=k>>>8&255;a[g+26>>0]=u;k=k&255;a[g+27>>0]=k;g=c[l>>2]|0;a[g+92>>0]=w;a[g+93>>0]=v;a[g+94>>0]=u;a[g+95>>0]=k;g=c[l>>2]|0;a[g+96>>0]=0;a[g+97>>0]=46;a[g+98>>0]=52;a[g+99>>0]=32;g=c[o>>2]|0}else l=f+4|0;k=c[l>>2]|0;w=c[s>>2]|0;g=Ya[c[(c[w>>2]|0)+12>>2]&127](w,k,g,h,i)|0;if(j){j=p;h=k+24|0;i=j+16|0;do{a[j>>0]=a[h>>0]|0;j=j+1|0;h=h+1|0}while((j|0)<(i|0))}if(e>>>0>(c[q>>2]|0)>>>0)c[q>>2]=e;c[r>>2]=(c[r>>2]|0)+1;h=c[m>>2]|0;if(h)lf(h,e,c[l>>2]|0)}else g=0;f=c[f+16>>2]|0}while((g|0)==0&(f|0)!=0);Qa=t;return g|0}function Xe(a){a=a|0;var b=0,d=0,e=0;d=a+16|0;a=c[d>>2]|0;if(!a){c[d>>2]=0;return 0}do{b=a;a=c[a>>2]|0;if(!(c[7324]|0))_a[c[29344>>2]&127](b);else{e=Ua[c[29352>>2]&127](b)|0;c[14978]=(c[14978]|0)-e;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](b)}}while((a|0)!=0);c[d>>2]=0;return 0}function Ye(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;l=a+40|0;k=l;a:do if((e|0)==0&(f|0)==0|((c[k>>2]|0)!=(e|0)?1:(c[k+4>>2]|0)!=(f|0))){g=c[a+16>>2]|0;if(!g)g=0;else{j=c[a+4>>2]|0;k=((j|0)<0)<<31>>31;h=0;i=0;while(1){h=Qv(h|0,i|0,j|0,k|0)|0;i=L()|0;if((i|0)>(f|0)|(i|0)==(f|0)&h>>>0>e>>>0)break a;g=c[g>>2]|0;if(!g){g=0;break}}}}else g=c[a+48>>2]|0;while(0);k=a+4|0;i=c[k>>2]|0;j=Xv(e|0,f|0,i|0,((i|0)<0)<<31>>31|0)|0;L()|0;i=i-j|0;h=(i|0)>(d|0)?d:i;cw(b|0,g+4+j|0,h|0)|0;i=d-i|0;b:do if((i|0)>-1){j=b;do{g=c[g>>2]|0;if(!((i|0)!=0&(g|0)!=0))break b;j=j+h|0;b=c[k>>2]|0;h=(i|0)<(b|0)?i:b;cw(j|0,g+4|0,h|0)|0;i=i-b|0}while((i|0)>-1)}while(0);b=(g|0)==0;e=Qv(d|0,((d|0)<0)<<31>>31|0,e|0,f|0)|0;f=L()|0;c[l>>2]=b?0:e;c[l+4>>2]=b?0:f;c[a+48>>2]=g;return 0}function Ze(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0;I=Qa;Qa=Qa+32|0;G=I;H=a+8|0;g=c[H>>2]|0;if((g|0)>0?(F=Qv(d|0,((d|0)<0)<<31>>31|0,e|0,f|0)|0,D=L()|0,E=((g|0)<0)<<31>>31,(D|0)>(E|0)|(D|0)==(E|0)&F>>>0>g>>>0):0){m=c[a>>2]|0;t=a+4|0;u=c[t>>2]|0;D=H;C=c[D>>2]|0;D=c[D+4>>2]|0;v=a+16|0;g=c[v>>2]|0;w=a+20|0;x=c[w>>2]|0;y=a+24|0;F=y;E=c[F>>2]|0;F=c[F+4>>2]|0;z=a+32|0;c[G>>2]=c[z>>2];c[G+4>>2]=c[z+4>>2];c[G+8>>2]=c[z+8>>2];c[G+12>>2]=c[z+12>>2];c[G+16>>2]=c[z+16>>2];c[G+20>>2]=c[z+20>>2];A=a+56|0;B=c[A>>2]|0;n=a+60|0;o=c[n>>2]|0;p=a+64|0;q=c[p>>2]|0;r=a+68|0;s=c[r>>2]|0;h=a;i=h+72|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(i|0));h=Ya[c[o+24>>2]&127](o,q,a,B&556927,0)|0;a:do if(!h){if(g|0){i=u;j=g;k=0;l=0;do{J=Qv(k|0,l|0,i|0,((i|0)<0)<<31>>31|0)|0;K=L()|0;h=Rv(E|0,F|0,k|0,l|0)|0;L()|0;i=(K|0)>(F|0)|(K|0)==(F|0)&J>>>0>E>>>0?h:i;h=Ya[c[(c[a>>2]|0)+12>>2]&127](a,j+4|0,i,k,l)|0;if(h|0){i=a;break a}k=Qv(k|0,l|0,i|0,((i|0)<0)<<31>>31|0)|0;l=L()|0;j=c[j>>2]|0}while((j|0)!=0);do{h=g;g=c[g>>2]|0;if(!(c[7324]|0))_a[c[29344>>2]&127](h);else{K=Ua[c[29352>>2]&127](h)|0;c[14978]=(c[14978]|0)-K;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](h)}}while((g|0)!=0)}K=Ya[c[(c[a>>2]|0)+12>>2]&127](a,b,d,e,f)|0;Qa=I;return K|0}else i=a;while(0);j=c[i>>2]|0;if(j|0){Ua[c[j+4>>2]&127](a)|0;c[i>>2]=0}c[a>>2]=m;c[t>>2]=u;K=H;c[K>>2]=C;c[K+4>>2]=D;c[v>>2]=g;c[w>>2]=x;K=y;c[K>>2]=E;c[K+4>>2]=F;c[z>>2]=c[G>>2];c[z+4>>2]=c[G+4>>2];c[z+8>>2]=c[G+8>>2];c[z+12>>2]=c[G+12>>2];c[z+16>>2]=c[G+16>>2];c[z+20>>2]=c[G+20>>2];c[A>>2]=B;c[n>>2]=o;c[p>>2]=q;c[r>>2]=s;K=h;Qa=I;return K|0}b:do if((d|0)>0){m=a+24|0;n=a+32|0;o=a+4|0;p=a+16|0;i=m;l=d;h=c[i>>2]|0;i=c[i+4>>2]|0;while(1){g=c[n>>2]|0;j=c[o>>2]|0;i=Xv(h|0,i|0,j|0,((j|0)<0)<<31>>31|0)|0;L()|0;k=j-i|0;k=(l|0)<(k|0)?l:k;if(!i){h=lb(j+4|0)|0;if(!h){g=3082;break}c[h>>2]=0;if(!g)c[p>>2]=h;else c[g>>2]=h;c[n>>2]=h;g=h}cw(g+4+i|0,b|0,k|0)|0;l=l-k|0;h=m;h=Qv(c[h>>2]|0,c[h+4>>2]|0,k|0,((k|0)<0)<<31>>31|0)|0;i=L()|0;K=m;c[K>>2]=h;c[K+4>>2]=i;if((l|0)<=0)break b;else b=b+k|0}Qa=I;return g|0}while(0);c[a+12>>2]=e+d;K=0;Qa=I;return K|0}function _e(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;if(!((b|0)==0&(d|0)==0))return 0;e=a+16|0;b=c[e>>2]|0;if(b|0)do{d=b;b=c[b>>2]|0;if(!(c[7324]|0))_a[c[29344>>2]&127](d);else{f=Ua[c[29352>>2]&127](d)|0;c[14978]=(c[14978]|0)-f;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](d)}}while((b|0)!=0);c[e>>2]=0;c[a+12>>2]=0;c[a+32>>2]=0;f=a+24|0;c[f>>2]=0;c[f+4>>2]=0;c[a+48>>2]=0;f=a+40|0;c[f>>2]=0;c[f+4>>2]=0;return 0}function $e(a,b){a=a|0;b=b|0;return 0}function af(a,b){a=a|0;b=b|0;var d=0;d=a+24|0;a=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=a;return 0}function bf(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;if(!b){m=0;return m|0}e=e+-1|0;a:do if((c[b>>2]|0)>>>0>4e3){l=b;j=b;while(1){i=c[l+8>>2]|0;if(!i)break;h=(e>>>0)/(i>>>0)|0;e=e-(G(h,i)|0)|0;h=l+12+(h<<2)|0;b=c[h>>2]|0;if(!b){if(!(c[7324]|0)){b=Ua[c[29340>>2]&127](512)|0;if(!b){m=17;break}}else{b=Ua[c[29356>>2]&127](512)|0;if((c[14985]|0)>>>0<512)c[14985]=512;g=59064;f=c[g>>2]|0;g=c[g+4>>2]|0;if((g|0)>0|(g|0)==0&f>>>0>0){l=c[14978]|0;k=Rv(f|0,g|0,b|0,((b|0)<0)<<31>>31|0)|0;j=L()|0;c[14768]=((j|0)<0|(j|0)==0&k>>>0<=l>>>0)&1}b=Ua[c[29340>>2]&127](b)|0;if(!b){m=17;break}f=Ua[c[29352>>2]&127](b)|0;f=(c[14978]|0)+f|0;c[14978]=f;if(f>>>0>(c[14982]|0)>>>0)c[14982]=f;f=(c[14981]|0)+1|0;c[14981]=f;if(f>>>0>(c[14987]|0)>>>0)c[14987]=f}ew(b+4|0,0,508)|0;c[b>>2]=i;c[h>>2]=b}if((c[b>>2]|0)>>>0>4e3){l=b;j=b}else break a}if((m|0)==17){c[h>>2]=0;m=7;return m|0}i=l+8|0;k=e+1|0;b=(e>>>0)%125|0;h=l+12|0;f=l+12+(b<<2)|0;e=c[f>>2]|0;if(!e){b=l+4|0;e=c[b>>2]|0;if(e>>>0<124)m=46}else{f=b;do{if((e|0)==(k|0)){e=0;m=47;break}e=f+1|0;f=e>>>0>124?0:e;e=c[l+12+(f<<2)>>2]|0}while((e|0)!=0);if((m|0)==47)return e|0;b=l+4|0;e=c[b>>2]|0;if(e>>>0<=61){f=l+12+(f<<2)|0;m=46}}if((m|0)==46){c[b>>2]=e+1;c[f>>2]=k;m=0;return m|0}if(!(c[7324]|0)){e=Ua[c[29340>>2]&127](500)|0;if(!e){m=7;return m|0}else g=e}else{b=Ua[c[29356>>2]&127](500)|0;if((c[14985]|0)>>>0<500)c[14985]=500;e=59064;f=c[e>>2]|0;e=c[e+4>>2]|0;if((e|0)>0|(e|0)==0&f>>>0>0){m=c[14978]|0;g=Rv(f|0,e|0,b|0,((b|0)<0)<<31>>31|0)|0;f=L()|0;c[14768]=((f|0)<0|(f|0)==0&g>>>0<=m>>>0)&1}b=Ua[c[29340>>2]&127](b)|0;if(!b){m=7;return m|0}e=Ua[c[29352>>2]&127](b)|0;e=(c[14978]|0)+e|0;c[14978]=e;if(e>>>0>(c[14982]|0)>>>0)c[14982]=e;e=(c[14981]|0)+1|0;c[14981]=e;if(e>>>0>(c[14987]|0)>>>0){c[14987]=e;g=b}else g=b}cw(g|0,h|0,500)|0;ew(h|0,0,500)|0;c[i>>2]=(((c[j>>2]|0)+124|0)>>>0)/125|0;e=bf(l,k)|0;f=0;do{b=c[g+(f<<2)>>2]|0;if(b)e=bf(l,b)|0|e;f=f+1|0}while((f|0)!=125);if(!(c[7324]|0)){_a[c[29344>>2]&127](g);m=e;return m|0}else{m=Ua[c[29352>>2]&127](g)|0;c[14978]=(c[14978]|0)-m;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](g);m=e;return m|0}}while(0);m=b+12+(e>>>3)|0;a[m>>0]=1<<(e&7)|(d[m>>0]|0);m=0;return m|0}function cf(d,f,g){d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;C=Qa;Qa=Qa+32|0;A=C;x=C+12|0;z=c[d+68>>2]|0;do if(z|0){if((b[d+40>>1]|0)==0?(a[d+50>>0]|0)==0:0)break;r=d+100|0;s=((c[r>>2]|0)+33|0)>>>12;h=(z+33|0)>>>12;a:do if(h>>>0<s>>>0)h=0;else{t=x+4|0;u=d+24|0;v=d+32|0;w=x+8|0;q=f*383&8191;p=h;b:while(1){if((c[u>>2]|0)>(p|0)?(y=c[(c[v>>2]|0)+(p<<2)>>2]|0,c[t>>2]=y,(y|0)!=0):0)h=y;else{h=hf(d,p,t)|0;if(h|0)break;h=c[t>>2]|0}n=h+16384|0;c[x>>2]=n;if(!p){h=h+136|0;c[t>>2]=h;o=0}else o=(p<<12)+-34|0;c[w>>2]=o;m=h+-4|0;c[t>>2]=m;i=n+(q<<1)|0;if(b[i>>1]|0){k=8192;l=q;h=0;while(1){j=o+(e[i>>1]|0)|0;if(j>>>0<=z>>>0?j>>>0>=(c[r>>2]|0)>>>0:0)h=(c[m+(e[i>>1]<<2)>>2]|0)==(f|0)?j:h;if(!k){B=22;break b}l=l+1&8191;i=n+(l<<1)|0;if(!(b[i>>1]|0))break;else k=k+-1|0}if(h|0)break a}if((p|0)>(s|0))p=p+-1|0;else{h=0;break a}}if((B|0)==22){c[A>>2]=32306;c[A+4>>2]=61232;c[A+8>>2]=31517;Bb(11,32001,A);h=11}B=h;Qa=C;return B|0}while(0);c[g>>2]=h;B=0;Qa=C;return B|0}while(0);c[g>>2]=0;B=0;Qa=C;return B|0}function df(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=Qa;Qa=Qa+48|0;r=s;p=s+24|0;l=s+12|0;j=d+33|0;k=j>>>12;m=l+4|0;n=a+24|0;if(!((c[n>>2]|0)>(k|0)?(g=c[(c[a+32>>2]|0)+(k<<2)>>2]|0,c[m>>2]=g,(g|0)!=0):0))i=3;do if((i|0)==3){g=hf(a,k,m)|0;if(!g){g=c[m>>2]|0;break}else{f=g;Qa=s;return f|0}}while(0);q=g+16384|0;c[l>>2]=q;if(!k){k=g+136|0;c[m>>2]=k;i=0}else{i=(j&-4096)+-34|0;k=g}c[l+8>>2]=i;j=k+-4|0;c[m>>2]=j;o=d-i|0;if((o|0)==1)ew(k|0,0,g+32768-k|0)|0;m=j+(o<<2)|0;if(c[m>>2]|0){d=a+68|0;g=c[d>>2]|0;do if(g|0){g=g+33|0;i=g>>>12;k=p+4|0;if(!((c[n>>2]|0)>(i|0)?(h=c[(c[a+32>>2]|0)+(i<<2)>>2]|0,c[k>>2]=h,(h|0)!=0):0)){if(hf(a,i,k)|0)break;h=c[k>>2]|0}l=h+16384|0;c[p>>2]=l;if(!i){j=h+136|0;c[k>>2]=j;g=0}else{g=(g&-4096)+-34|0;j=h}c[p+8>>2]=g;c[k>>2]=j+-4;h=(c[d>>2]|0)-g|0;g=0;do{i=l+(g<<1)|0;if((h|0)<(e[i>>1]|0))b[i>>1]=0;g=g+1|0}while((g|0)!=8192);p=j+(h<<2)|0;ew(p|0,0,l-p|0)|0}while(0)}h=f*383&8191;g=q+(h<<1)|0;a:do if(b[g>>1]|0){i=o;while(1){if(!i)break;h=h+1&8191;g=q+(h<<1)|0;if(!(b[g>>1]|0))break a;else i=i+-1|0}c[r>>2]=32306;c[r+4>>2]=59401;c[r+8>>2]=31517;Bb(11,32001,r);f=11;Qa=s;return f|0}while(0);c[m>>2]=f;b[g>>1]=o;f=0;Qa=s;return f|0}function ef(d,f,g,h){d=d|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;A=Qa;Qa=Qa+64|0;u=A+32|0;k=A;j=A+48|0;v=A+44|0;w=A+40|0;do if((h|0)>5)if((h|0)>100){d=15;Qa=A;return d|0}else{z=h+-9|0;z=G(z*39|0,z)|0;y=c[d>>2]|0;Va[c[y+60>>2]&255](y,(h|0)>9?z:1)|0;break}while(0);a:do if(!g){z=d+50|0;if(!(a[z>>0]|0)){g=ff(d,f)|0;b:do if((g|0)==5){if(!(c[c[d+32>>2]>>2]|0)){d=-1;Qa=A;return d|0}h=d+43|0;if(a[h>>0]|0){d=-1;Qa=A;return d|0}i=d+4|0;g=c[i>>2]|0;g=Xa[c[(c[g>>2]|0)+56>>2]&127](g,2,1,6)|0;switch(g|0){case 0:break;case 5:{d=261;Qa=A;return d|0}default:break b}if(a[h>>0]|0){d=-1;Qa=A;return d|0}d=c[i>>2]|0;Xa[c[(c[d>>2]|0)+56>>2]&127](d,2,1,5)|0;d=-1;Qa=A;return d|0}while(0);if(g|0){d=g;Qa=A;return d|0}if(!(a[z>>0]|0)){j=d+32|0;m=(c[c[j>>2]>>2]|0)+96|0;l=d+52|0;h=d+68|0;if((c[m>>2]|0)!=(c[h>>2]|0)){g=0;break}k=d+43|0;i=a[k>>0]|0;if(!(i<<24>>24)){g=c[d+4>>2]|0;g=Xa[c[(c[g>>2]|0)+56>>2]&127](g,3,1,6)|0;i=a[k>>0]|0}else g=0;if(i<<24>>24!=2){f=c[d+4>>2]|0;_a[c[(c[f>>2]|0)+60>>2]&127](f)}switch(g|0){case 5:break a;case 0:break;default:{d=g;Qa=A;return d|0}}if(!(Ju(c[c[j>>2]>>2]|0,l,48)|0)){b[d+40>>1]=0;d=0;Qa=A;return d|0}if(a[k>>0]|0){d=-1;Qa=A;return d|0}d=c[d+4>>2]|0;Xa[c[(c[d>>2]|0)+56>>2]&127](d,3,1,5)|0;d=-1;Qa=A;return d|0}}x=d+43|0;y=d+4|0;if(!(a[x>>0]|0)){g=c[y>>2]|0;g=Xa[c[(c[g>>2]|0)+56>>2]&127](g,3,1,6)|0;switch(g|0){case 0:{t=17;break}case 5:{g=-1;t=35;break}default:t=34}}else t=17;c:do if((t|0)==17){b[d+40>>1]=0;g=c[y>>2]|0;g=Ya[c[(c[g>>2]|0)+52>>2]&127](g,0,32768,0,j)|0;switch(g|0){case 8:{g=-1;t=35;break c}case 1288:break;default:{t=34;break c}}g=d+52|0;h=c[c[d+32>>2]>>2]|0;i=g+48|0;do{a[g>>0]=a[h>>0]|0;g=g+1|0;h=h+1|0}while((g|0)<(i|0));t=d+8|0;g=c[t>>2]|0;g=Va[c[(c[g>>2]|0)+24>>2]&255](g,u)|0;if(!g){s=u;r=c[s+4>>2]|0;if((r|0)<0|(r|0)==0&(c[s>>2]|0)>>>0<32){c[f>>2]=1;g=((c[d+68>>2]|0)!=0)<<31>>31;t=34;break}g=c[t>>2]|0;g=Ya[c[(c[g>>2]|0)+8>>2]&127](g,k,32,0,0)|0;if(!g)if(!(Ju(d+84|0,k+16|0,8)|0)){g=d+66|0;n=(e[g>>1]|0)+24|0;o=nb(n,0)|0;if(o){m=o+24|0;p=d+76|0;q=c[p>>2]|0;r=d+80|0;s=c[r>>2]|0;i=Wv((e[g>>1]|0)+24|0,0,c[d+68>>2]|0,0)|0;i=Qv(i|0,L()|0,32,0)|0;j=L()|0;g=Qv(i|0,j|0,n|0,0)|0;h=L()|0;l=u;k=c[l+4>>2]|0;d:do if((h|0)>(k|0)|((h|0)==(k|0)?g>>>0>(c[l>>2]|0)>>>0:0))g=0;else{l=g;k=h;h=i;g=j;while(1){j=c[t>>2]|0;g=Ya[c[(c[j>>2]|0)+8>>2]&127](j,o,n,h,g)|0;if(g|0)break;if(!(jf(d,v,w,m,o)|0)){g=0;break}if(c[w>>2]|0){g=-1;break d}g=Qv(l|0,k|0,n|0,0)|0;h=L()|0;j=u;i=c[j+4>>2]|0;if((h|0)>(i|0)|((h|0)==(i|0)?g>>>0>(c[j>>2]|0)>>>0:0)){g=0;break d}else{i=k;j=l;l=g;k=h;g=i;h=j}}}while(0);c[p>>2]=q;c[r>>2]=s;if(!(c[7324]|0)){_a[c[29344>>2]&127](o);t=34;break}else{t=Ua[c[29352>>2]&127](o)|0;c[14978]=(c[14978]|0)-t;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](o);t=34;break}}else{g=7;t=35}}else{g=-1;t=35}else t=35}else t=35}while(0);if((t|0)==34)if(!g)g=0;else t=35;if((t|0)==35){i=d+24|0;if((c[i>>2]|0)>0){j=d+32|0;h=0;do{k=c[(c[j>>2]|0)+(h<<2)>>2]|0;do if(k|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{w=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-w;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}while(0);c[(c[j>>2]|0)+(h<<2)>>2]=0;h=h+1|0}while((h|0)<(c[i>>2]|0))}a[z>>0]=0;h=d+44|0;if(a[h>>0]|0){if(!(a[x>>0]|0)){z=c[y>>2]|0;Xa[c[(c[z>>2]|0)+56>>2]&127](z,0,1,9)|0}a[h>>0]=0;c[d+104>>2]=0;a[d+47>>0]=0}h=d+40|0;i=b[h>>1]|0;if(i<<16>>16>-1){if(!(a[x>>0]|0)){d=c[y>>2]|0;Xa[c[(c[d>>2]|0)+56>>2]&127](d,(i<<16>>16)+3|0,1,5)|0}b[h>>1]=-1}c[f>>2]=1}d=g;Qa=A;return d|0}else{g=0;l=d+52|0;h=d+68|0;m=(c[c[d+32>>2]>>2]|0)+96|0}while(0);s=c[h>>2]|0;i=m+8|0;o=c[i>>2]|0;k=o>>>0>s>>>0;o=k?0:o;n=m+12|0;p=c[n>>2]|0;y=o>>>0>p>>>0|p>>>0>s>>>0;p=y?o:p;o=m+16|0;f=c[o>>2]|0;x=p>>>0>f>>>0|f>>>0>s>>>0;f=x?p:f;p=m+20|0;j=c[p>>2]|0;z=f>>>0>j>>>0|j>>>0>s>>>0;k=z?(x?(y?(k^1)&1:2):3):4;j=z?f:j;e:do if(!(a[d+46>>0]&2)){if((k|0)==0|j>>>0<s>>>0){q=d+43|0;r=d+4|0;f:do if(!(a[q>>0]|0)){g=c[r>>2]|0;g=Xa[c[(c[g>>2]|0)+56>>2]&127](g,4,1,10)|0;switch(g|0){case 0:{k=1;h=4;g=i;break f}case 5:break;default:{d=g;Qa=A;return d|0}}if(!(a[q>>0]|0)){g=c[r>>2]|0;g=Xa[c[(c[g>>2]|0)+56>>2]&127](g,5,1,10)|0;switch(g|0){case 0:{k=2;h=5;g=n;break f}case 5:break;default:{d=g;Qa=A;return d|0}}if(!(a[q>>0]|0)){g=c[r>>2]|0;g=Xa[c[(c[g>>2]|0)+56>>2]&127](g,6,1,10)|0;switch(g|0){case 0:{k=3;h=6;g=o;break f}case 5:break;default:{d=g;Qa=A;return d|0}}if(!(a[q>>0]|0)){g=c[r>>2]|0;g=Xa[c[(c[g>>2]|0)+56>>2]&127](g,7,1,10)|0;switch(g|0){case 5:{t=69;break e}case 0:{k=4;h=7;g=p;break f}default:{}}Qa=A;return g|0}else{k=4;h=7;g=p}}else{k=3;h=6;g=o}}else{k=2;h=5;g=n}}else{k=1;h=4;g=i}while(0);c[g>>2]=s;if(!(a[q>>0]|0)){j=c[r>>2]|0;Xa[c[(c[j>>2]|0)+56>>2]&127](j,h,1,9)|0;j=s}else j=s}}else t=69;while(0);if((t|0)==69)if(!k){d=(g|0)==5?-1:1288;Qa=A;return d|0}h=k+3|0;i=d+43|0;g=a[i>>0]|0;do if(!(g<<24>>24)){g=c[d+4>>2]|0;g=Xa[c[(c[g>>2]|0)+56>>2]&127](g,h,1,6)|0;if(!g){g=a[i>>0]|0;break}d=(g|0)==5?-1:g;Qa=A;return d|0}while(0);c[d+100>>2]=(c[m>>2]|0)+1;if(g<<24>>24!=2){f=c[d+4>>2]|0;_a[c[(c[f>>2]|0)+60>>2]&127](f)}if((c[m+4+(k<<2)>>2]|0)==(j|0)?(Ju(c[c[d+32>>2]>>2]|0,l,48)|0)==0:0){b[d+40>>1]=k;d=0;Qa=A;return d|0}if(a[i>>0]|0){d=-1;Qa=A;return d|0}d=c[d+4>>2]|0;Xa[c[(c[d>>2]|0)+56>>2]&127](d,h,1,5)|0;d=-1;Qa=A;return d|0}function ff(e,f){e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,M=0,N=0,O=0,P=0;O=Qa;Qa=Qa+96|0;K=O+64|0;G=O+56|0;p=O+40|0;B=O+32|0;m=O;C=O+84|0;D=O+80|0;j=O+76|0;N=e+24|0;if((c[N>>2]|0)>0?(M=c[c[e+32>>2]>>2]|0,c[j>>2]=M,(M|0)!=0):0){g=0;M=6}else{g=hf(e,0,j)|0;switch(g|0){case 0:break;case 1288:{a[e+50>>0]=1;a[e+43>>0]=2;c[f>>2]=1;break}default:{N=g;Qa=O;return N|0}}if(!(c[j>>2]|0)){h=1;M=7}else M=6}if((M|0)==6){h=gf(e,f)|0;if(!h)M=67;else M=7}do if((M|0)==7){if((a[e+50>>0]|0)==0?a[e+46>>0]&2:0){h=e+43|0;if(a[h>>0]|0){g=264;break}i=e+4|0;g=c[i>>2]|0;g=Xa[c[(c[g>>2]|0)+56>>2]&127](g,0,1,6)|0;if(g|0)break;if(a[h>>0]|0){g=264;break}g=c[i>>2]|0;Xa[c[(c[g>>2]|0)+56>>2]&127](g,0,1,5)|0;g=264;break}I=e+43|0;if((a[I>>0]|0)==0?(i=c[e+4>>2]|0,i=Xa[c[(c[i>>2]|0)+56>>2]&127](i,0,1,10)|0,i|0):0){g=i;break}H=e+44|0;a[H>>0]=1;if((c[N>>2]|0)>0?(F=c[c[e+32>>2]>>2]|0,c[j>>2]=F,(F|0)!=0):0)M=18;else{g=hf(e,0,j)|0;if(!g)M=18}if((M|0)==18){h=gf(e,f)|0;if(!h){h=0;g=0}else{F=d[e+45>>0]|0;E=F+1|0;F=2-F|0;if(!(a[I>>0]|0)){i=e+4|0;g=c[i>>2]|0;g=Xa[c[(c[g>>2]|0)+56>>2]&127](g,E,F,10)|0;if(!g)if((a[I>>0]|0)==0?(k=c[i>>2]|0,k=Xa[c[(c[k>>2]|0)+56>>2]&127](k,4,4,10)|0,(k|0)!=0):0)if(!(a[I>>0]|0)){g=c[i>>2]|0;Xa[c[(c[g>>2]|0)+56>>2]&127](g,E,F,9)|0;g=k}else g=k;else M=25}else M=25;if((M|0)==25){A=e+52|0;i=A;l=i+48|0;do{c[i>>2]=0;i=i+4|0}while((i|0)<(l|0));z=e+8|0;g=c[z>>2]|0;g=Va[c[(c[g>>2]|0)+24>>2]&255](g,B)|0;a:do if(!g){y=B;x=c[y+4>>2]|0;b:do if((x|0)>0|(x|0)==0&(c[y>>2]|0)>>>0>32){g=c[z>>2]|0;g=Ya[c[(c[g>>2]|0)+8>>2]&127](g,m,32,0,0)|0;c:do if(!g){g=d[m+3>>0]|0;i=m+8|0;n=d[m+9>>0]<<16|d[i>>0]<<24;o=d[m+10>>0]<<8;l=n|o|d[m+11>>0];if((d[m+1>>0]<<16|d[m>>0]<<24|d[m+2>>0]<<8|g&254|0)==931071618?!((l+-512|0)>>>0>65024|(l+-1&l|0)!=0):0){x=g&1;a[e+65>>0]=x;c[e+36>>2]=l;g=m+12|0;c[e+112>>2]=d[m+13>>0]<<16|d[g>>0]<<24|d[m+14>>0]<<8|d[m+15>>0];w=m+16|0;j=c[w>>2]|0;w=c[w+4>>2]|0;y=e+84|0;c[y>>2]=j;c[y+4>>2]=w;y=e+76|0;if(!x){x=c[m>>2]|0;k=c[m+4>>2]|0;w=k+x|0;x=w+x+(c[i>>2]|0)|0;i=(c[g>>2]|0)+w+x|0;g=i+(c[m+20>>2]|0)|0;i=x+j+i|0}else{w=bw(c[m>>2]|0)|0;k=c[m+4>>2]|0;x=(bw(k|0)|0)+w|0;i=x+w+(bw(c[i>>2]|0)|0)|0;g=(bw(c[g>>2]|0)|0)+x+i|0;i=i+(bw(j|0)|0)+g|0;g=g+(bw(c[m+20>>2]|0)|0)|0}g=g+i|0;c[y>>2]=i;x=e+80|0;c[x>>2]=g;do if((i|0)==(d[m+25>>0]<<16|d[m+24>>0]<<24|d[m+26>>0]<<8|d[m+27>>0]|0)){if((g|0)!=(d[m+29>>0]<<16|d[m+28>>0]<<24|d[m+30>>0]<<8|d[m+31>>0]|0))break;if((d[m+5>>0]<<16|k<<24|d[m+6>>0]<<8|d[m+7>>0]|0)!=3007e3){c[p>>2]=31984;c[p+4>>2]=59539;c[p+8>>2]=31517;Bb(14,32001,p);g=14;break a}r=l+24|0;s=((r|0)<0)<<31>>31;w=nb(r,s)|0;if(!w){g=7;break c}t=w+24|0;g=Qv(r|0,s|0,32,0)|0;m=L()|0;v=B;u=c[v+4>>2]|0;d:do if((m|0)>(u|0)|((m|0)==(u|0)?g>>>0>(c[v>>2]|0)>>>0:0)){g=0;i=0;j=0}else{u=e+68|0;v=e+72|0;p=(n>>>16|o)&65535;q=e+66|0;o=0;i=0;j=0;k=32;l=0;n=g;while(1){o=o+1|0;g=c[z>>2]|0;g=Ya[c[(c[g>>2]|0)+8>>2]&127](g,w,r,k,l)|0;if(g|0)break;if(!(jf(e,C,D,t,w)|0)){g=0;break}g=df(e,o,c[C>>2]|0)|0;if(g|0)break;g=c[D>>2]|0;if(g){c[u>>2]=o;c[v>>2]=g;b[q>>1]=p;i=c[y>>2]|0;j=c[x>>2]|0}g=Qv(n|0,m|0,r|0,s|0)|0;k=L()|0;l=B;P=c[l+4>>2]|0;if((k|0)>(P|0)|((k|0)==(P|0)?g>>>0>(c[l>>2]|0)>>>0:0)){g=0;break d}else{l=m;P=n;n=g;m=k;k=P}}}while(0);if(!(c[7324]|0))_a[c[29344>>2]&127](w);else{P=Ua[c[29352>>2]&127](w)|0;c[14978]=(c[14978]|0)-P;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](w)}if(!g){g=j;break b}else break a}while(0);i=0;g=0;break b}i=0;g=0;break b}while(0);break a}else{i=0;g=0}while(0);c[e+76>>2]=i;c[e+80>>2]=g;j=e+32|0;k=c[c[j>>2]>>2]|0;a[e+64>>0]=1;c[A>>2]=3007e3;P=c[A+4>>2]|0;l=P+6014e3+(c[A+8>>2]|0)|0;P=P+3007e3+(c[A+12>>2]|0)+l|0;l=(c[A+16>>2]|0)+l+P|0;P=(c[A+20>>2]|0)+P+l|0;l=l+i+P|0;i=P+g+l|0;g=l+(c[A+32>>2]|0)+i|0;i=i+(c[A+36>>2]|0)+g|0;c[e+92>>2]=g;c[e+96>>2]=i;i=k+48|0;g=A;l=i+48|0;do{a[i>>0]=a[g>>0]|0;i=i+1|0;g=g+1|0}while((i|0)<(l|0));if((a[I>>0]|0)!=2){P=c[e+4>>2]|0;_a[c[(c[P>>2]|0)+60>>2]&127](P)}i=k;g=A;l=i+48|0;do{a[i>>0]=a[g>>0]|0;i=i+1|0;g=g+1|0}while((i|0)<(l|0));j=c[c[j>>2]>>2]|0;c[j+96>>2]=0;g=e+68|0;c[j+128>>2]=c[g>>2];c[j+100>>2]=0;i=j+104|0;c[i>>2]=-1;c[j+108>>2]=-1;c[j+112>>2]=-1;c[j+116>>2]=-1;j=c[g>>2]|0;if(j|0)c[i>>2]=j;if(!(c[e+72>>2]|0))g=0;else{P=c[e+108>>2]|0;c[G>>2]=c[g>>2];c[G+4>>2]=P;Bb(283,32269,G);g=0}}while(0);if((a[I>>0]|0)==0?(J=e+4|0,P=c[J>>2]|0,Xa[c[(c[P>>2]|0)+56>>2]&127](P,E,F,9)|0,(a[I>>0]|0)==0):0){P=c[J>>2]|0;Xa[c[(c[P>>2]|0)+56>>2]&127](P,4,4,9)|0}}c[f>>2]=1}}a[H>>0]=0;if(!(a[I>>0]|0)){P=c[e+4>>2]|0;Xa[c[(c[P>>2]|0)+56>>2]&127](P,0,1,9)|0}if(!h)M=67}while(0);if((M|0)==67)if((c[e+52>>2]|0)!=3007e3){c[K>>2]=31984;c[K+4>>2]=60517;c[K+8>>2]=31517;Bb(14,32001,K);g=14}i=e+50|0;if(!(a[i>>0]|0)){P=g;Qa=O;return P|0}l=e+43|0;if(!g)g=0;else{if((c[N>>2]|0)>0){j=e+32|0;h=0;do{k=c[(c[j>>2]|0)+(h<<2)>>2]|0;do if(k|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{P=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-P;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}while(0);c[(c[j>>2]|0)+(h<<2)>>2]=0;h=h+1|0}while((h|0)<(c[N>>2]|0))}if((a[l>>0]|0)!=2){P=c[e+4>>2]|0;Va[c[(c[P>>2]|0)+64>>2]&255](P,0)|0}a[i>>0]=0;g=(g|0)==522?-1:g}a[l>>0]=0;P=g;Qa=O;return P|0}function gf(b,d){b=b|0;d=d|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;l=Qa;Qa=Qa+96|0;k=l+48|0;g=l;h=c[c[b+32>>2]>>2]|0;f=k;i=h;j=f+48|0;do{a[f>>0]=a[i>>0]|0;f=f+1|0;i=i+1|0}while((f|0)<(j|0));if((a[b+43>>0]|0)!=2){j=c[b+4>>2]|0;_a[c[(c[j>>2]|0)+60>>2]&127](j)}f=g;i=h+48|0;j=f+48|0;do{a[f>>0]=a[i>>0]|0;f=f+1|0;i=i+1|0}while((f|0)<(j|0));if(Ju(k,g,48)|0){k=1;Qa=l;return k|0}if(!(a[k+12>>0]|0)){k=1;Qa=l;return k|0}g=c[k>>2]|0;f=(c[k+4>>2]|0)+g|0;g=g+f+(c[k+8>>2]|0)|0;f=(c[k+12>>2]|0)+f+g|0;g=g+f+(c[k+16>>2]|0)|0;f=(c[k+20>>2]|0)+f+g|0;g=g+f+(c[k+24>>2]|0)|0;f=(c[k+28>>2]|0)+f+g|0;g=g+f+(c[k+32>>2]|0)|0;if((g|0)!=(c[k+40>>2]|0)){k=1;Qa=l;return k|0}if(((c[k+36>>2]|0)+f+g|0)!=(c[k+44>>2]|0)){k=1;Qa=l;return k|0}f=b+52|0;if(!(Ju(f,k,48)|0)){k=0;Qa=l;return k|0}c[d>>2]=1;i=k;j=f+48|0;do{c[f>>2]=c[i>>2];f=f+4|0;i=i+4|0}while((f|0)<(j|0));k=e[b+66>>1]|0;c[b+36>>2]=k<<16&65536|k&65024;k=0;Qa=l;return k|0}function hf(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;h=b+24|0;do if((c[h>>2]|0)<=(e|0)){i=e+1|0;j=b+32|0;k=c[j>>2]|0;if((kb()|0)==0?(g=qb(k,i<<2,0)|0,g|0):0){k=c[h>>2]|0;ew(g+(k<<2)|0,0,i-k<<2|0)|0;c[j>>2]=g;c[h>>2]=i;break}c[f>>2]=0;f=7;return f|0}while(0);if((a[b+43>>0]|0)!=2){h=c[b+4>>2]|0;g=b+32|0;h=Ya[c[(c[h>>2]|0)+52>>2]&127](h,e,32768,d[b+44>>0]|0,(c[g>>2]|0)+(e<<2)|0)|0;i=b+46|0;if((h&255|0)==8){a[i>>0]=a[i>>0]|2;h=(h|0)==8?0:h}}else{if(!(c[7324]|0)){g=Ua[c[29340>>2]&127](32768)|0;if(!g)g=0;else l=18}else{g=Ua[c[29356>>2]&127](32768)|0;if((c[14985]|0)>>>0<32768)c[14985]=32768;i=59064;h=c[i>>2]|0;i=c[i+4>>2]|0;if((i|0)>0|(i|0)==0&h>>>0>0){k=c[14978]|0;j=Rv(h|0,i|0,g|0,((g|0)<0)<<31>>31|0)|0;i=L()|0;c[14768]=((i|0)<0|(i|0)==0&j>>>0<=k>>>0)&1}g=Ua[c[29340>>2]&127](g)|0;if(g){h=Ua[c[29352>>2]&127](g)|0;h=(c[14978]|0)+h|0;c[14978]=h;if(h>>>0>(c[14982]|0)>>>0)c[14982]=h;h=(c[14981]|0)+1|0;c[14981]=h;if(h>>>0>(c[14987]|0)>>>0){c[14987]=h;l=18}else l=18}else g=0}if((l|0)==18)ew(g|0,0,32768)|0;b=b+32|0;c[(c[b>>2]|0)+(e<<2)>>2]=g;h=(c[(c[b>>2]|0)+(e<<2)>>2]|0)==0?7:0;g=b}c[f>>2]=c[(c[g>>2]|0)+(e<<2)>>2];f=h;return f|0}function jf(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0;n=b+76|0;if(Ju(b+84|0,h+8|0,8)|0){n=0;return n|0}l=d[h+1>>0]<<16|d[h>>0]<<24|d[h+2>>0]<<8|d[h+3>>0];if(!l){n=0;return n|0}i=c[n>>2]|0;m=b+80|0;j=c[m>>2]|0;if(!(a[b+65>>0]|0)){i=i+j+(c[h>>2]|0)|0;o=(c[h+4>>2]|0)+j+i|0;c[n>>2]=i;c[m>>2]=o;k=g+(c[b+36>>2]|0)|0;j=g;b=o;do{i=i+b+(c[j>>2]|0)|0;b=(c[j+4>>2]|0)+b+i|0;j=j+8|0}while(j>>>0<k>>>0)}else{i=i+j+(bw(c[h>>2]|0)|0)|0;o=(bw(c[h+4>>2]|0)|0)+j+i|0;c[n>>2]=i;c[m>>2]=o;k=g+(c[b+36>>2]|0)|0;j=g;b=o;do{i=i+b+(bw(c[j>>2]|0)|0)|0;b=(bw(c[j+4>>2]|0)|0)+b+i|0;j=j+8|0}while(j>>>0<k>>>0)}c[n>>2]=i;c[m>>2]=b;if((i|0)!=(d[h+17>>0]<<16|d[h+16>>0]<<24|d[h+18>>0]<<8|d[h+19>>0]|0)){o=0;return o|0}if((b|0)!=(d[h+21>>0]<<16|d[h+20>>0]<<24|d[h+22>>0]<<8|d[h+23>>0]|0)){o=0;return o|0}c[e>>2]=l;c[f>>2]=d[h+5>>0]<<16|d[h+4>>0]<<24|d[h+6>>0]<<8|d[h+7>>0];o=1;return o|0}function kf(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0;j=b+76|0;a[h>>0]=e>>>24;a[h+1>>0]=e>>>16;a[h+2>>0]=e>>>8;a[h+3>>0]=e;a[h+4>>0]=f>>>24;a[h+5>>0]=f>>>16;a[h+6>>0]=f>>>8;a[h+7>>0]=f;e=h+8|0;if(c[b+104>>2]|0){f=e+16|0;do{a[e>>0]=0;e=e+1|0}while((e|0)<(f|0));return}i=b+84|0;k=i;k=d[k>>0]|d[k+1>>0]<<8|d[k+2>>0]<<16|d[k+3>>0]<<24;i=i+4|0;i=d[i>>0]|d[i+1>>0]<<8|d[i+2>>0]<<16|d[i+3>>0]<<24;f=e;a[f>>0]=k;a[f+1>>0]=k>>8;a[f+2>>0]=k>>16;a[f+3>>0]=k>>24;e=e+4|0;a[e>>0]=i;a[e+1>>0]=i>>8;a[e+2>>0]=i>>16;a[e+3>>0]=i>>24;e=c[j>>2]|0;i=b+80|0;f=c[i>>2]|0;if(!(a[b+65>>0]|0)){k=e+f+(c[h>>2]|0)|0;e=(c[h+4>>2]|0)+f+k|0;c[j>>2]=k;c[i>>2]=e;b=g+(c[b+36>>2]|0)|0;f=k;do{f=f+e+(c[g>>2]|0)|0;e=(c[g+4>>2]|0)+e+f|0;g=g+8|0}while(g>>>0<b>>>0)}else{k=e+f+(bw(c[h>>2]|0)|0)|0;e=(bw(c[h+4>>2]|0)|0)+f+k|0;c[j>>2]=k;c[i>>2]=e;b=g+(c[b+36>>2]|0)|0;f=k;do{f=f+e+(bw(c[g>>2]|0)|0)|0;e=(bw(c[g+4>>2]|0)|0)+e+f|0;g=g+8|0}while(g>>>0<b>>>0)}c[j>>2]=f;c[i>>2]=e;a[h+16>>0]=f>>>24;a[h+17>>0]=f>>>16;a[h+18>>0]=f>>>8;a[h+19>>0]=f;k=c[i>>2]|0;a[h+20>>0]=k>>>24;a[h+21>>0]=k>>>16;a[h+22>>0]=k>>>8;a[h+23>>0]=k;return}function lf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;do{e=a+28|0;switch(c[e>>2]|0){case 6:case 0:case 5:{if((c[a+16>>2]|0)>>>0>b>>>0?(f=Yb(a,b,d,1)|0,f|0):0)c[e>>2]=f;break}default:{}}a=c[a+44>>2]|0}while((a|0)!=0);return}function mf(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;k=c[b+208>>2]|0;j=b+152|0;m=c[j>>2]|0;l=b+148|0;i=c[l>>2]|0;m=m>>>0>i>>>0?i:m;h=c[b+96>>2]|0;if((h|0)>0){e=c[b+92>>2]|0;f=b+72|0;d=0;do{g=e+(d*48|0)+8|0;n=g;if((c[n>>2]|0)==0&(c[n+4>>2]|0)==0){p=f;o=c[p+4>>2]|0;n=g;c[n>>2]=c[p>>2];c[n+4>>2]=o}d=d+1|0}while((d|0)<(h|0));g=f}else g=b+72|0;e=g;d=c[e>>2]|0;e=c[e+4>>2]|0;if((d|0)==0&(e|0)==0){d=0;e=0}else{d=Qv(d|0,e|0,-1,-1)|0;d=Uv(d|0,L()|0,i|0,0)|0;d=Qv(d|0,L()|0,1,0)|0;d=Wv(d|0,L()|0,i|0,0)|0;e=L()|0}p=g;c[p>>2]=d;c[p+4>>2]=e;p=b+80|0;c[p>>2]=d;c[p+4>>2]=e;if(((a[b+7>>0]|0)==0?(a[b+5>>0]|0)!=4:0)?(p=c[b+60>>2]|0,((Ua[c[(c[p>>2]|0)+48>>2]&127](p)|0)&512|0)==0):0){d=k;e=d+12|0;do{a[d>>0]=0;d=d+1|0}while((d|0)<(e|0))}else{p=k;o=p;a[o>>0]=-117058087;a[o+1>>0]=-117058087>>8;a[o+2>>0]=-117058087>>16;a[o+3>>0]=-117058087>>24;p=p+4|0;a[p>>0]=-681336544;a[p+1>>0]=-681336544>>8;a[p+2>>0]=-681336544>>16;a[p+3>>0]=-681336544>>24;p=k+8|0;a[p>>0]=-1;a[p+1>>0]=-1>>8;a[p+2>>0]=-1>>16;a[p+3>>0]=-1>>24}f=b+48|0;Db(4,f);f=c[f>>2]|0;a[k+12>>0]=f>>>24;a[k+13>>0]=f>>>16;a[k+14>>0]=f>>>8;a[k+15>>0]=f;f=c[b+28>>2]|0;a[k+16>>0]=f>>>24;a[k+17>>0]=f>>>16;a[k+18>>0]=f>>>8;a[k+19>>0]=f;f=c[l>>2]|0;a[k+20>>0]=f>>>24;a[k+21>>0]=f>>>16;a[k+22>>0]=f>>>8;a[k+23>>0]=f;f=c[j>>2]|0;a[k+24>>0]=f>>>24;a[k+25>>0]=f>>>16;a[k+26>>0]=f>>>8;a[k+27>>0]=f;ew(k+28|0,0,m+-28|0)|0;f=b+64|0;e=0;while(1){if(e>>>0>=(c[l>>2]|0)>>>0){d=0;e=17;break}n=c[f>>2]|0;d=g;d=Ya[c[(c[n>>2]|0)+12>>2]&127](n,k,m,c[d>>2]|0,c[d+4>>2]|0)|0;n=g;n=Qv(c[n>>2]|0,c[n+4>>2]|0,m|0,0)|0;o=L()|0;p=g;c[p>>2]=n;c[p+4>>2]=o;if(!d)e=e+m|0;else{e=17;break}}if((e|0)==17)return d|0;return 0}function nf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[d>>2]=0;return c[a+40>>2]|0}function of(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=Qa;Qa=Qa+32|0;l=q+16|0;h=q;if(!e){c[h>>2]=32306;c[h+4>>2]=56058;c[h+8>>2]=31517;Bb(11,32001,h);d=11;Qa=q;return d|0}p=d+212|0;h=c[p>>2]|0;h=Wa[c[29436>>2]&127](c[h+44>>2]|0,e,a[h+33>>0]&3)|0;a:do if(!h){j=c[p>>2]|0;if((a[j+33>>0]|0)!=2){k=j+44|0;n=Ua[c[29432>>2]&127](c[k>>2]|0)|0;b:do if((n|0)>(c[j+20>>2]|0)){i=j+8|0;h=c[i>>2]|0;c:do if(!h)m=12;else{while(1){if((b[h+30>>1]|0)==0?(b[h+28>>1]&8)==0:0)break;h=c[h+36>>2]|0;if(!h){m=12;break c}}c[i>>2]=h}while(0);d:do if((m|0)==12){c[i>>2]=0;h=c[j+4>>2]|0;if(!h)break b;while(1){if(!(b[h+30>>1]|0))break d;h=c[h+36>>2]|0;if(!h)break b}}while(0);h=Va[c[j+36>>2]&255](c[j+40>>2]|0,h)|0;switch(h|0){case 0:case 5:break;default:break a}}while(0);h=Wa[c[29436>>2]&127](c[k>>2]|0,e,2)|0;if(h)m=18;else h=7}else h=7}else m=18;while(0);do if((m|0)==18){i=c[p>>2]|0;j=c[h+4>>2]|0;if(!(c[j>>2]|0))n=qf(i,e,h)|0;else{n=i+12|0;c[n>>2]=(c[n>>2]|0)+1;n=j+30|0;b[n>>1]=(b[n>>1]|0)+1<<16>>16;n=j}c[f>>2]=n;h=g&1;i=n+20|0;j=(h|0)!=0;if(!(j|(c[i>>2]|0)==0)){d=d+184|0;c[d>>2]=(c[d>>2]|0)+1;d=0;Qa=q;return d|0}do if((e|0)>=0?(o=d+152|0,((1073741824/(c[o>>2]|0)|0)+1|0)!=(e|0)):0){c[i>>2]=d;if(c[c[d+60>>2]>>2]|0?((h|0)==0?(c[d+24>>2]|0)>>>0>=e>>>0:0):0){h=d+188|0;c[h>>2]=(c[h>>2]|0)+1;h=pf(n)|0;if(!h)h=0;else break;Qa=q;return h|0}if((c[d+156>>2]|0)>>>0<e>>>0)h=13;else{if(j){if((c[d+28>>2]|0)>>>0>=e>>>0)bf(c[d+56>>2]|0,e)|0;g=d+96|0;h=c[g>>2]|0;if((h|0)>0){k=d+92|0;j=0;do{i=c[k>>2]|0;if((c[i+(j*48|0)+20>>2]|0)>>>0>=e>>>0){bf(c[i+(j*48|0)+16>>2]|0,e)|0;h=c[g>>2]|0}j=j+1|0}while((j|0)<(h|0))}}ew(c[n+4>>2]|0,0,c[o>>2]|0)|0;d=0;Qa=q;return d|0}}else m=38;while(0);if((m|0)==38){c[l>>2]=32306;c[l+4>>2]=56090;c[l+8>>2]=31517;Bb(11,32001,l);if(!n){h=11;break}else h=11}m=c[n+12>>2]|0;do if(b[n+28>>1]&2){i=m+8|0;j=n+36|0;k=c[j>>2]|0;if((c[i>>2]|0)==(n|0))c[i>>2]=k;g=c[n+32>>2]|0;l=(g|0)==0;if(l){c[m+4>>2]=k;i=k}else{c[g+36>>2]=k;i=c[j>>2]|0}if(i|0){c[i+32>>2]=g;break}c[m>>2]=g;if(l)a[m+33>>0]=2}while(0);o=m+12|0;c[o>>2]=(c[o>>2]|0)+-1;ab[c[29440>>2]&255](c[m+44>>2]|0,c[n>>2]|0,1)}while(0);if(!(c[(c[p>>2]|0)+12>>2]|0)){switch(a[d+16>>0]|0){case 0:case 6:break;case 1:{if(!(a[d+4>>0]|0))sf(d,0,0)|0;break}default:rf(d)|0}tf(d)}c[f>>2]=0;d=h;Qa=q;return d|0}function pf(b){b=b|0;var d=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=Qa;Qa=Qa+16|0;f=k;i=c[b+20>>2]|0;c[f>>2]=0;g=i+216|0;d=c[g>>2]|0;h=b+24|0;if(d){d=cf(d,c[h>>2]|0,f)|0;if(d|0){b=d;Qa=k;return b|0}d=c[f>>2]|0;if(d){l=c[g>>2]|0;f=c[i+152>>2]|0;m=c[b+4>>2]|0;n=c[l+8>>2]|0;l=e[l+66>>1]|0;l=l<<16&65536|l&65024;g=Wv(l|24|0,0,d+-1|0,0)|0;g=Qv(g|0,L()|0,56,0)|0;d=L()|0;d=Ya[c[(c[n>>2]|0)+8>>2]&127](n,m,(l|0)<(f|0)?l:f,g,d)|0}else j=5}else j=5;if((j|0)==5){m=c[i+152>>2]|0;n=Wv((c[h>>2]|0)+-1|0,0,m|0,((m|0)<0)<<31>>31|0)|0;d=L()|0;l=c[i+60>>2]|0;d=Ya[c[(c[l>>2]|0)+8>>2]&127](l,c[b+4>>2]|0,m,n,d)|0;d=(d|0)==522?0:d}if((c[h>>2]|0)!=1){n=d;Qa=k;return n|0}if(!d){g=i+104|0;d=(c[b+4>>2]|0)+24|0;f=g+16|0;do{a[g>>0]=a[d>>0]|0;g=g+1|0;d=d+1|0}while((g|0)<(f|0));n=0;Qa=k;return n|0}else{n=i+104|0;c[n>>2]=-1;c[n+4>>2]=-1;c[n+8>>2]=-1;c[n+12>>2]=-1;n=d;Qa=k;return n|0}return 0}function qf(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;g=f+4|0;h=c[g>>2]|0;do{i=h+16|0;c[i>>2]=0;c[i+4>>2]=0;c[i+8>>2]=0;c[i+12>>2]=0;c[i+16>>2]=0;c[i+20>>2]=0;c[h>>2]=f;c[h+4>>2]=c[f>>2];i=h+40|0;c[h+8>>2]=i;j=i;a[j>>0]=0;a[j+1>>0]=0;a[j+2>>0]=0;a[j+3>>0]=0;i=i+4|0;a[i>>0]=0;a[i+1>>0]=0;a[i+2>>0]=0;a[i+3>>0]=0;c[h+12>>2]=d;c[h+24>>2]=e;b[h+28>>1]=1;h=c[g>>2]|0}while(!(c[h>>2]|0));j=d+12|0;c[j>>2]=(c[j>>2]|0)+1;j=h+30|0;b[j>>1]=(b[j>>1]|0)+1<<16>>16;return h|0}function rf(b){b=b|0;var e=0,f=0,g=0;g=b+16|0;f=a[g>>0]|0;if(f<<24>>24==6){g=c[b+40>>2]|0;return g|0}if((f&255)<2){g=0;return g|0}do if(!(c[b+216>>2]|0)){if(!(f<<24>>24==2?1:(c[c[b+64>>2]>>2]|0)==0)){e=vf(b,0)|0;break}e=sf(b,0,0)|0;if((f&255)>2&(a[b+15>>0]|0)==0){c[b+40>>2]=4;a[g>>0]=6;c[b+204>>2]=75;g=e;return g|0}}else{e=uf(b,2,-1)|0;f=sf(b,d[b+19>>0]|0,0)|0;e=(e|0)==0?f:e}while(0);switch((e&255)<<24>>24){case 10:case 13:break;default:{g=e;return g|0}}c[b+40>>2]=e;a[g>>0]=6;c[b+204>>2]=(e|0)==0?74:75;g=e;return g|0}function sf(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;B=Qa;Qa=Qa+16|0;w=B;A=e+16|0;if((d[A>>0]|0)<2?(d[e+17>>0]|0)<2:0){A=0;Qa=B;return A|0}l=e+96|0;if((c[l>>2]|0)>0){k=e+92|0;i=0;do{wf(c[(c[k>>2]|0)+(i*48|0)+16>>2]|0);i=i+1|0}while((i|0)<(c[l>>2]|0))}z=e+4|0;k=c[e+68>>2]|0;i=c[k>>2]|0;if(!(a[z>>0]|0)){if(i|0)y=9}else if((i|0)==29896){i=29896;y=9}if((y|0)==9){Ua[c[i+4>>2]&127](k)|0;c[k>>2]=0}i=e+92|0;k=c[i>>2]|0;do if(k|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](k);break}else{s=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-s;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k);break}while(0);c[i>>2]=0;c[l>>2]=0;c[e+52>>2]=0;n=e+64|0;o=c[n>>2]|0;m=c[o>>2]|0;a:do if(!m)i=0;else{if((m|0)==29896){l=o+16|0;i=c[l>>2]|0;if(i|0)do{k=i;i=c[i>>2]|0;if(!(c[7324]|0))_a[c[29344>>2]&127](k);else{s=Ua[c[29352>>2]&127](k)|0;c[14978]=(c[14978]|0)-s;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](k)}}while((i|0)!=0);c[l>>2]=0;c[o>>2]=0;i=0;break}i=a[e+5>>0]|0;switch(i<<24>>24){case 3:{k=e+72|0;s=k;if(!((c[s>>2]|0)==0&(c[s+4>>2]|0)==0)){i=Wa[c[m+16>>2]&127](o,0,0)|0;if(!i)if((a[e+8>>0]|0)!=0?(p=c[n>>2]|0,q=a[e+10>>0]|0,q<<24>>24!=0):0)i=Va[c[(c[p>>2]|0)+20>>2]&255](p,q&255)|0;else i=0}else i=0;s=k;c[s>>2]=0;c[s+4>>2]=0;break a}case 1:break;default:if(i<<24>>24==5|(a[z>>0]|0)==0){s=(a[e+12>>0]|0)==0;Ua[c[m+4>>2]&127](o)|0;c[o>>2]=0;if(!s){i=0;break a}i=c[e>>2]|0;i=Wa[c[i+28>>2]&127](i,c[e+172>>2]|0,d[e+9>>0]|0)|0;break a}}if(!f)i=(a[e+12>>0]|0)!=0&1;else i=1;f=e+72|0;s=f;if(!((c[s>>2]|0)==0&(c[s+4>>2]|0)==0)){l=e+160|0;k=c[l>>2]|0;l=c[l+4>>2]|0;if((i|0)!=0|(k|0)==0&(l|0)==0)i=Wa[c[m+16>>2]&127](o,0,0)|0;else i=Ya[c[m+12>>2]&127](o,59008,28,0,0)|0;if(!i){if(!(a[e+7>>0]|0)){i=c[n>>2]|0;i=Va[c[(c[i>>2]|0)+20>>2]&255](i,(a[e+10>>0]|16)&255)|0}else i=0;if(((l|0)>0|(l|0)==0&k>>>0>0)&(i|0)==0){i=c[n>>2]|0;i=Va[c[(c[i>>2]|0)+24>>2]&255](i,w)|0;s=w;r=c[s+4>>2]|0;if((i|0)==0&((r|0)>(l|0)|((r|0)==(l|0)?(c[s>>2]|0)>>>0>k>>>0:0))){i=c[n>>2]|0;i=Wa[c[(c[i>>2]|0)+16>>2]&127](i,k,l)|0}}}}else i=0;s=f;c[s>>2]=0;c[s+4>>2]=0}while(0);s=e+56|0;wf(c[s>>2]|0);c[s>>2]=0;c[e+44>>2]=0;s=(i|0)==0;if(s){do if((a[e+15>>0]|0)==0?(a[e+12>>0]|0)!=0:0){if(g|0?c[c[e+60>>2]>>2]|0:0){l=c[e+212>>2]|0;k=c[l+16>>2]|0;if((k|0)<=-1){q=Wv(k|0,((k|0)<0)<<31>>31|0,-1024,-1)|0;r=L()|0;k=(c[l+28>>2]|0)+(c[l+24>>2]|0)|0;k=Uv(q|0,r|0,k|0,((k|0)<0)<<31>>31|0)|0;L()|0}l=c[l>>2]|0;if(!l){l=0;f=0}else{f=0;do{f=f+1|0;l=c[l+32>>2]|0}while((l|0)!=0);l=Wv(f|0,0,100,0)|0;f=L()|0}if(k|0?(r=Uv(l|0,f|0,k|0,((k|0)<0)<<31>>31|0)|0,L()|0,(r|0)>=25):0){y=60;break}}l=c[e+212>>2]|0;k=c[l>>2]|0;if(k|0)do{r=k+28|0;b[r>>1]=b[r>>1]&-13;k=c[k+32>>2]|0}while((k|0)!=0);c[l+8>>2]=c[l+4>>2]}else y=60;while(0);if((y|0)==60){r=e+212|0;l=c[r>>2]|0;k=c[l>>2]|0;if(k){do{q=c[k+12>>2]|0;f=q+8|0;m=k+36|0;n=c[m>>2]|0;if((c[f>>2]|0)==(k|0))c[f>>2]=n;o=c[k+32>>2]|0;p=(o|0)==0;if(p){c[q+4>>2]=n;f=n}else{c[o+36>>2]=n;f=c[m>>2]|0}if(!f){c[q>>2]=o;if(p)a[q+33>>0]=2}else c[f+32>>2]=o;p=k+28|0;b[p>>1]=b[p>>1]&-16|1;if((b[k+30>>1]|0)==0?a[q+32>>0]|0:0)ab[c[29440>>2]&255](c[q+44>>2]|0,c[k>>2]|0,0);k=c[l>>2]|0}while((k|0)!=0);l=c[r>>2]|0}}k=c[e+24>>2]|0;r=l+44|0;if(c[r>>2]|0){f=c[l>>2]|0;if(f|0)do{p=f;f=c[f+32>>2]|0;if((c[p+24>>2]|0)>>>0>k>>>0){q=c[p+12>>2]|0;n=q+8|0;o=p+36|0;m=c[o>>2]|0;if((c[n>>2]|0)==(p|0))c[n>>2]=m;n=(f|0)==0;if(n)c[q+4>>2]=m;else{c[f+36>>2]=m;m=c[o>>2]|0}if(!m){c[q>>2]=f;if(n)a[q+33>>0]=2}else c[m+32>>2]=f;o=p+28|0;b[o>>1]=b[o>>1]&-16|1;if((b[p+30>>1]|0)==0?a[q+32>>0]|0:0)ab[c[29440>>2]&255](c[q+44>>2]|0,c[p>>2]|0,0)}}while((f|0)!=0);if(!k)if((c[l+12>>2]|0)!=0?(t=Wa[c[29436>>2]&127](c[r>>2]|0,1,0)|0,(t|0)!=0):0){ew(c[t>>2]|0,0,c[l+24>>2]|0)|0;k=1}else k=0;$a[c[29448>>2]&127](c[r>>2]|0,k+1|0)}}q=e+216|0;k=c[q>>2]|0;if(!k)if((g|0)!=0&s){n=e+32|0;o=c[e+24>>2]|0;if(((c[n>>2]|0)>>>0>o>>>0?(x=e+60|0,u=c[x>>2]|0,v=c[u>>2]|0,(v|0)!=0):0)?((a[A>>0]|0)+-1&255)>2:0){p=c[e+152>>2]|0;i=Va[c[v+24>>2]&255](u,w)|0;l=((p|0)<0)<<31>>31;f=Wv(p|0,l|0,o|0,0)|0;m=L()|0;do if(!i){k=w;i=c[k>>2]|0;k=c[k+4>>2]|0;if((i|0)==(f|0)&(k|0)==(m|0))h=0;else{if(!((k|0)>(m|0)|(k|0)==(m|0)&i>>>0>f>>>0)){w=Qv(i|0,k|0,p|0,l|0)|0;v=L()|0;if(!((v|0)>(m|0)|(v|0)==(m|0)&w>>>0>f>>>0)){w=c[e+208>>2]|0;ew(w|0,0,p|0)|0;x=c[x>>2]|0;y=Rv(f|0,m|0,p|0,l|0)|0;h=L()|0;h=Ya[c[(c[x>>2]|0)+12>>2]&127](x,w,p,y,h)|0;y=117}}else{h=c[x>>2]|0;h=Wa[c[(c[h>>2]|0)+16>>2]&127](h,f,m)|0;y=117}if((y|0)==117?h|0:0)break;c[n>>2]=o;h=0}}else h=i;while(0)}else h=0}else h=i;else{h=k+44|0;if(!(a[h>>0]|0))h=i;else{if(!(a[k+43>>0]|0)){y=c[k+4>>2]|0;Xa[c[(c[y>>2]|0)+56>>2]&127](y,0,1,9)|0}a[h>>0]=0;c[k+104>>2]=0;a[k+47>>0]=0;h=i}}do if((g|0)!=0&(h|0)==0){h=c[e+60>>2]|0;i=c[h>>2]|0;if(i|0?(j=Wa[c[i+40>>2]&127](h,22,0)|0,(j|0)!=12):0)break;j=0}else j=h;while(0);b:do if(!(a[z>>0]|0)){h=c[q>>2]|0;do if(h|0){i=h+43|0;if(!(a[i>>0]|0)){h=0;break b}a[i>>0]=0;z=c[h+4>>2]|0;if(!(Xa[c[(c[z>>2]|0)+56>>2]&127](z,(b[h+40>>1]|0)+3|0,1,6)|0))if(!(a[i>>0]|0))break;else{h=0;break b}else{a[i>>0]=1;h=0;break b}}while(0);h=c[e+60>>2]|0;i=c[h>>2]|0;if(i){if(!(a[e+13>>0]|0))h=Va[c[i+32>>2]&255](h,1)|0;else h=0;i=e+17|0;if((a[i>>0]|0)!=5)a[i>>0]=1}else h=0;a[e+18>>0]=0}else h=0;while(0);a[A>>0]=1;a[e+19>>0]=0;A=(j|0)==0?h:j;Qa=B;return A|0}function tf(d){d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;g=d+56|0;wf(c[g>>2]|0);c[g>>2]=0;g=d+96|0;if((c[g>>2]|0)>0){f=d+92|0;e=0;do{wf(c[(c[f>>2]|0)+(e*48|0)+16>>2]|0);e=e+1|0}while((e|0)<(c[g>>2]|0))}h=d+4|0;f=c[d+68>>2]|0;e=c[f>>2]|0;if(!(a[h>>0]|0)){if(e|0)k=7}else if((e|0)==29896){e=29896;k=7}if((k|0)==7){Ua[c[e+4>>2]&127](f)|0;c[f>>2]=0}e=d+92|0;f=c[e>>2]|0;do if(f|0)if(!(c[7324]|0)){_a[c[29344>>2]&127](f);break}else{l=Ua[c[29352>>2]&127](f)|0;c[14978]=(c[14978]|0)-l;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](f);break}while(0);c[e>>2]=0;c[g>>2]=0;c[d+52>>2]=0;g=c[d+216>>2]|0;if(!g){if(!(a[h>>0]|0)){e=d+60|0;f=c[e>>2]|0;g=c[f>>2]|0;if(!(((g|0)!=0?((Ua[c[g+48>>2]&127](f)|0)&2048|0)!=0:0)?(a[d+5>>0]&5)==1:0))k=25;if((k|0)==25?(i=c[d+64>>2]|0,j=c[i>>2]|0,j|0):0){Ua[c[j+4>>2]&127](i)|0;c[i>>2]=0}e=c[e>>2]|0;f=c[e>>2]|0;if(f|0){if(!(a[d+13>>0]|0))f=Va[c[f+32>>2]&255](e,0)|0;else f=0;e=d+17|0;if((a[e>>0]|0)!=5)a[e>>0]=0;if(f|0?(a[d+16>>0]|0)==6:0)a[e>>0]=5}a[d+18>>0]=0;k=36}}else{e=g+44|0;if(a[e>>0]|0){if(!(a[g+43>>0]|0)){l=c[g+4>>2]|0;Xa[c[(c[l>>2]|0)+56>>2]&127](l,0,1,9)|0}a[e>>0]=0;c[g+104>>2]=0;a[g+47>>0]=0}e=g+40|0;f=b[e>>1]|0;if(f<<16>>16>-1){if(!(a[g+43>>0]|0)){l=c[g+4>>2]|0;Xa[c[(c[l>>2]|0)+56>>2]&127](l,(f<<16>>16)+3|0,1,5)|0}b[e>>1]=-1;k=36}else k=36}if((k|0)==36)a[d+16>>0]=0;f=d+40|0;if(!(c[f>>2]|0)){l=d+72|0;d=d+19|0;a[d>>0]=0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;return}if(!(a[d+12>>0]|0)){Df(d);a[d+18>>0]=0;e=0}else e=(c[c[d+64>>2]>>2]|0)==0&1;a[d+16>>0]=e;c[f>>2]=0;c[d+204>>2]=74;l=d+72|0;d=d+19|0;a[d>>0]=0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;return}function uf(d,f,g){d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;y=Qa;Qa=Qa+32|0;x=y+8|0;w=y;h=c[d+40>>2]|0;if(h|0){d=h;Qa=y;return d|0}k=d+96|0;h=c[k>>2]|0;if((h|0)<=(g|0)){d=0;Qa=y;return d|0}j=(f|0)==1;g=((j^1)&1)+g|0;if((g|0)<(h|0)){f=d+92|0;h=g;do{wf(c[(c[f>>2]|0)+(h*48|0)+16>>2]|0);h=h+1|0}while((h|0)<(c[k>>2]|0))}c[k>>2]=g;if(j){if(g|0){d=0;Qa=y;return d|0}g=c[d+68>>2]|0;h=c[g>>2]|0;if(!h){d=0;Qa=y;return d|0}if((h|0)==29896){i=g+16|0;h=c[i>>2]|0;if(h|0)do{f=h;h=c[h>>2]|0;if(!(c[7324]|0))_a[c[29344>>2]&127](f);else{x=Ua[c[29352>>2]&127](f)|0;c[14978]=(c[14978]|0)-x;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](f)}}while((h|0)!=0);c[i>>2]=0;c[g+12>>2]=0;c[g+32>>2]=0;x=g+24|0;c[x>>2]=0;c[x+4>>2]=0;c[g+48>>2]=0;x=g+40|0;c[x>>2]=0;c[x+4>>2]=0}c[d+52>>2]=0;d=0;Qa=y;return d|0}s=d+216|0;if((c[s>>2]|0)==0?(c[c[d+64>>2]>>2]|0)==0:0){d=0;Qa=y;return d|0}if((g|0)!=0?(l=g+-1|0,u=c[d+92>>2]|0,m=u+(l*48|0)|0,l=u+(l*48|0)+20|0,(m|0)!=0):0){j=c[l>>2]|0;if(!(c[7324]|0)){h=Ua[c[29340>>2]&127](512)|0;if(!h){d=7;Qa=y;return d|0}}else{h=Ua[c[29356>>2]&127](512)|0;if((c[14985]|0)>>>0<512)c[14985]=512;g=59064;f=c[g>>2]|0;g=c[g+4>>2]|0;if((g|0)>0|(g|0)==0&f>>>0>0){u=c[14978]|0;r=Rv(f|0,g|0,h|0,((h|0)<0)<<31>>31|0)|0;q=L()|0;c[14768]=((q|0)<0|(q|0)==0&r>>>0<=u>>>0)&1}h=Ua[c[29340>>2]&127](h)|0;if(!h){d=7;Qa=y;return d|0}f=Ua[c[29352>>2]&127](h)|0;f=(c[14978]|0)+f|0;c[14978]=f;if(f>>>0>(c[14982]|0)>>>0)c[14982]=f;f=(c[14981]|0)+1|0;c[14981]=f;if(f>>>0>(c[14987]|0)>>>0)c[14987]=f}ew(h+4|0,0,508)|0;c[h>>2]=j;u=h;h=l;g=d+28|0;r=m;q=1}else{g=d+28|0;u=0;h=g;r=0;q=0}f=d+24|0;c[f>>2]=c[h>>2];a[d+18>>0]=a[d+12>>0]|0;a:do if(q){l=d+72|0;f=l;i=c[f>>2]|0;f=c[f+4>>2]|0;if(!(c[s>>2]|0)){j=r+8|0;g=c[j>>2]|0;j=c[j+4>>2]|0;h=(g|0)==0&(j|0)==0;g=h?i:g;j=h?f:j;h=r;k=c[h>>2]|0;h=c[h+4>>2]|0;p=l;c[p>>2]=k;c[p+4>>2]=h;if((h|0)<(j|0)|(h|0)==(j|0)&k>>>0<g>>>0)while(1){h=xf(d,l,u,1,1)|0;if(h|0){p=i;o=f;break a}h=l;k=c[h>>2]|0;h=c[h+4>>2]|0;if(!((h|0)<(j|0)|(h|0)==(j|0)&k>>>0<g>>>0)){p=i;t=71;break}}else{p=i;t=71}}else{h=l;t=70}}else{o=c[s>>2]|0;if(!o){h=d+72|0;f=h;i=c[f>>2]|0;f=c[f+4>>2]|0;t=70;break}c[f>>2]=c[g>>2];if(a[o+44>>0]|0){n=o+68|0;l=c[n>>2]|0;m=o+32|0;j=c[m>>2]|0;h=o+52|0;f=c[j>>2]|0;g=h+48|0;do{a[h>>0]=a[f>>0]|0;h=h+1|0;f=f+1|0}while((h|0)<(g|0));f=c[n>>2]|0;h=f+1|0;if(h>>>0>l>>>0)h=0;else{k=h;g=j;while(1){h=f+34|0;f=h>>>12;if(!f)h=(c[g>>2]|0)+(h<<2)|0;else h=(c[g+(f<<2)>>2]|0)+((h&4095)<<2)|0;h=zf(d,c[h>>2]|0)|0;f=k+1|0;if(f>>>0>l>>>0|(h|0)!=0)break;w=k;k=f;g=c[m>>2]|0;f=w}f=c[n>>2]|0}if((l|0)!=(f|0))do if(f|0){f=f+33|0;g=f>>>12;k=x+4|0;if(!((c[o+24>>2]|0)>(g|0)?(i=c[(c[m>>2]|0)+(g<<2)>>2]|0,c[k>>2]=i,(i|0)!=0):0)){if(hf(o,g,k)|0)break;i=c[k>>2]|0}l=i+16384|0;c[x>>2]=l;if(!g){j=i+136|0;c[k>>2]=j;f=0}else{f=(f&-4096)+-34|0;j=i}c[x+8>>2]=f;c[k>>2]=j+-4;i=(c[n>>2]|0)-f|0;f=0;do{g=l+(f<<1)|0;if((i|0)<(e[g>>1]|0))b[g>>1]=0;f=f+1|0}while((f|0)!=8192);x=j+(i<<2)|0;ew(x|0,0,l-x|0)|0}while(0)}else h=0;f=Af(c[d+212>>2]|0)|0;if(!((h|0)==0&(f|0)!=0)){d=h;Qa=y;return d|0}do{h=f;f=c[f+16>>2]|0;h=zf(d,c[h+24>>2]|0)|0}while((f|0)!=0&(h|0)==0);Qa=y;return h|0}while(0);if((t|0)==70){l=h;c[l>>2]=0;c[l+4>>2]=0;l=h;h=0;k=0;p=i;t=71}b:do if((t|0)==71){m=d+80|0;n=d+148|0;o=d+152|0;if((h|0)<(f|0)|(h|0)==(f|0)&k>>>0<p>>>0)while(1){c[x>>2]=0;h=yf(d,0,p,f,x,w)|0;i=c[x>>2]|0;if(!i){i=m;i=Qv(c[i>>2]|0,c[i+4>>2]|0,c[n>>2]|0,0)|0;g=L()|0;t=l;if((i|0)==(c[t>>2]|0)?(g|0)==(c[t+4>>2]|0):0){k=Rv(p|0,f|0,i|0,g|0)|0;t=L()|0;i=(c[o>>2]|0)+8|0;i=Uv(k|0,t|0,i|0,((i|0)<0)<<31>>31|0)|0;L()|0;c[x>>2]=i;t=76}else t=81}else t=76;c:do if((t|0)==76){t=0;if((h|0)==0&(i|0)!=0){j=0;while(1){g=l;h=c[g>>2]|0;g=c[g+4>>2]|0;if(!((g|0)<(f|0)|(g|0)==(f|0)&h>>>0<p>>>0))break;h=xf(d,l,u,1,1)|0;j=j+1|0;if(!(j>>>0<i>>>0&(h|0)==0)){t=81;break c}}i=g}else t=81}while(0);if((t|0)==81){t=0;if(h|0){o=f;break b}h=l;i=c[h+4>>2]|0;h=c[h>>2]|0}if(!((i|0)<(f|0)|(i|0)==(f|0)&h>>>0<p>>>0)){h=0;o=f;break}}else{h=0;o=f}}while(0);if(q){n=r+24|0;f=c[n>>2]|0;m=(c[d+152>>2]|0)+4|0;m=Wv(m|0,((m|0)<0)<<31>>31|0,f|0,0)|0;q=L()|0;k=w;c[k>>2]=m;c[k+4>>2]=q;k=c[s>>2]|0;if(!k){if(!h)t=105}else{h=r+28|0;i=r+40|0;g=k+112|0;if((c[i>>2]|0)==(c[g>>2]|0))h=c[h>>2]|0;else{c[h>>2]=0;c[i>>2]=c[g>>2];h=0}m=k+68|0;if(h>>>0<(c[m>>2]|0)>>>0){c[m>>2]=h;c[k+76>>2]=c[r+32>>2];c[k+80>>2]=c[r+36>>2];do if(h|0){h=h+33|0;i=h>>>12;j=x+4|0;if((c[k+24>>2]|0)>(i|0)?(v=c[(c[k+32>>2]|0)+(i<<2)>>2]|0,c[j>>2]=v,(v|0)!=0):0)f=v;else{if(hf(k,i,j)|0)break;f=c[j>>2]|0}k=f+16384|0;c[x>>2]=k;if(!i){g=f+136|0;c[j>>2]=g;h=0}else{h=(h&-4096)+-34|0;g=f}c[x+8>>2]=h;c[j>>2]=g+-4;f=(c[m>>2]|0)-h|0;h=0;do{i=k+(h<<1)|0;if((f|0)<(e[i>>1]|0))b[i>>1]=0;h=h+1|0}while((h|0)!=8192);x=g+(f<<2)|0;ew(x|0,0,k-x|0)|0}while(0);f=c[n>>2]|0;t=105}else t=105}d:do if((t|0)==105){i=d+52|0;while(1){if(f>>>0>=(c[i>>2]|0)>>>0){h=0;break d}h=xf(d,w,u,0,1)|0;if(!h)f=f+1|0;else break}}while(0)}wf(u);if(h|0){d=h;Qa=y;return d|0}d=l;c[d>>2]=p;c[d+4>>2]=o;d=0;Qa=y;return d|0}function vf(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,M=0;M=Qa;Qa=Qa+48|0;K=M+16|0;H=M+8|0;I=M+40|0;x=M;y=M+36|0;z=M+32|0;G=M+28|0;A=M+24|0;h=c[b>>2]|0;c[z>>2]=0;c[G>>2]=1;w=b+152|0;c[A>>2]=c[w>>2];C=b+64|0;g=c[C>>2]|0;g=Va[c[(c[g>>2]|0)+24>>2]&255](g,x)|0;a:do if(!g){B=b+208|0;f=c[B>>2]|0;g=Cf(c[C>>2]|0,f,(c[(c[b>>2]|0)+8>>2]|0)+1|0)|0;if(!g){if(!(a[f>>0]|0))f=0;else f=Xa[c[h+32>>2]&127](h,f,0,G)|0;b:do if((f|0)==0&(c[G>>2]|0)!=0){p=b+72|0;q=p;c[q>>2]=0;c[q+4>>2]=0;q=b+148|0;r=b+80|0;s=b+60|0;t=b+24|0;u=b+16|0;v=b+32|0;f=0;h=d;c:while(1){do{g=x;g=yf(b,d,c[g>>2]|0,c[g+4>>2]|0,y,z)|0;switch(g|0){case 101:{h=f;break b}case 0:break;default:{e=g;J=37;break b}}g=c[y>>2]|0;if((g|0)==-1){n=x;n=Rv(c[n>>2]|0,c[n+4>>2]|0,c[q>>2]|0,0)|0;o=L()|0;g=(c[w>>2]|0)+8|0;g=Uv(n|0,o|0,g|0,((g|0)<0)<<31>>31|0)|0;L()|0;c[y>>2]=g}if(!(g|d)){j=r;l=c[q>>2]|0;j=Qv(c[j>>2]|0,c[j+4>>2]|0,l|0,0)|0;i=L()|0;m=p;k=c[m>>2]|0;m=c[m+4>>2]|0;if((j|0)==(k|0)&(i|0)==(m|0)){o=x;o=Rv(c[o>>2]|0,c[o+4>>2]|0,j|0,i|0)|0;k=L()|0;g=(c[w>>2]|0)+8|0;g=Uv(o|0,k|0,g|0,((g|0)<0)<<31>>31|0)|0;L()|0;c[y>>2]=g;k=j;j=0}else{i=m;j=0}}else{i=p;k=c[i>>2]|0;l=c[q>>2]|0;i=c[i+4>>2]|0;j=0}if((k|0)==(l|0)&(i|0)==(j|0)){n=c[z>>2]|0;i=c[s>>2]|0;j=c[i>>2]|0;if(j|0?((a[u>>0]|0)+-1&255)>2:0){o=c[w>>2]|0;i=Va[c[j+24>>2]&255](i,H)|0;k=((o|0)<0)<<31>>31;l=Wv(o|0,k|0,n|0,0)|0;m=L()|0;if(i|0){e=i;break c}j=H;i=c[j>>2]|0;j=c[j+4>>2]|0;if(!((i|0)==(l|0)&(j|0)==(m|0))){do if((j|0)>(m|0)|(j|0)==(m|0)&i>>>0>l>>>0){e=c[s>>2]|0;e=Wa[c[(c[e>>2]|0)+16>>2]&127](e,l,m)|0;J=24}else{j=Qv(i|0,j|0,o|0,k|0)|0;i=L()|0;if((i|0)>(m|0)|(i|0)==(m|0)&j>>>0>l>>>0)break;j=c[B>>2]|0;ew(j|0,0,o|0)|0;i=c[s>>2]|0;J=Rv(l|0,m|0,o|0,k|0)|0;e=L()|0;e=Ya[c[(c[i>>2]|0)+12>>2]&127](i,j,o,J,e)|0;J=24}while(0);if((J|0)==24?(J=0,e|0):0)break c;c[v>>2]=n}}c[t>>2]=n}}while(!(g|0));i=0;d:while(1){if(h|0)Df(b);h=xf(b,p,0,1,0)|0;switch(h|0){case 522:{h=f;break b}case 101:{J=35;break d}case 0:break;default:{e=h;J=37;break b}}f=f+1|0;i=i+1|0;if(i>>>0>=g>>>0)break;else h=0}if((J|0)==35){J=0;m=x;n=c[m+4>>2]|0;o=p;c[o>>2]=c[m>>2];c[o+4>>2]=n}h=0}J=38;break a}else{e=f;f=0;J=37}while(0);if((J|0)==37)if(!e)h=f;else{J=38;break}g=Qe(b,A,-1)|0;e=b+12|0;a[b+18>>0]=a[e>>0]|0;if(!g){s=c[B>>2]|0;g=Cf(c[C>>2]|0,s,(c[(c[b>>2]|0)+8>>2]|0)+1|0)|0;if(!g){if(((a[b+16>>0]|0)+-1&255)>2){i=b+60|0;f=c[i>>2]|0;g=c[f>>2]|0;if(g|0){g=Wa[c[g+40>>2]&127](f,21,0)|0;switch(g|0){case 0:case 12:break;default:break a}}if(((a[b+7>>0]|0)==0?(D=c[i>>2]|0,E=a[b+10>>0]|0,E<<24>>24):0)?(F=Va[c[(c[D>>2]|0)+20>>2]&255](D,E&255)|0,F|0):0){g=F;break}}g=sf(b,(a[s>>0]|0)!=0&1,0)|0;if(!g)if((a[s>>0]|0)!=0&(c[G>>2]|0)!=0){r=c[b>>2]|0;j=r+4|0;k=c[j>>2]<<1;G=Qv(k|0,((k|0)<0)<<31>>31|0,-1,-1)|0;F=L()|0;do if(!(F>>>0>0|(F|0)==0&G>>>0>2147483390)){if(!(c[7324]|0)){f=Ua[c[29340>>2]&127](k)|0;if(!f){f=7;break}else q=f}else{f=Ua[c[29356>>2]&127](k)|0;if((c[14985]|0)>>>0<k>>>0)c[14985]=k;i=59064;g=c[i>>2]|0;i=c[i+4>>2]|0;if((i|0)>0|(i|0)==0&g>>>0>0){G=c[14978]|0;F=Rv(g|0,i|0,f|0,((f|0)<0)<<31>>31|0)|0;E=L()|0;c[14768]=((E|0)<0|(E|0)==0&F>>>0<=G>>>0)&1}g=Ua[c[29340>>2]&127](f)|0;if(!g){f=7;break}f=Ua[c[29352>>2]&127](g)|0;f=(c[14978]|0)+f|0;c[14978]=f;if(f>>>0>(c[14982]|0)>>>0)c[14982]=f;f=(c[14981]|0)+1|0;c[14981]=f;if(f>>>0>(c[14987]|0)>>>0){c[14987]=f;q=g}else q=g}ew(q|0,0,k|0)|0;o=q+(c[j>>2]|0)|0;p=r+24|0;f=Ya[c[p>>2]&127](r,s,q,16385,0)|0;e:do if(!f){f=Va[c[(c[q>>2]|0)+24>>2]&255](q,H)|0;if(!f){n=(c[r+8>>2]|0)+1|0;G=H;G=Qv(c[G>>2]|0,c[G+4>>2]|0,n|0,((n|0)<0)<<31>>31|0)|0;F=L()|0;f=Qv(G|0,F|0,1,0)|0;L()|0;if(!(F>>>0>0|(F|0)==0&G>>>0>2147483390)){do if(!(c[7324]|0)){f=Ua[c[29340>>2]&127](f)|0;if(!f){f=7;break e}else g=f}else{i=Ua[c[29356>>2]&127](f)|0;if((c[14985]|0)>>>0<f>>>0)c[14985]=f;g=59064;f=c[g>>2]|0;g=c[g+4>>2]|0;if((g|0)>0|(g|0)==0&f>>>0>0){G=c[14978]|0;F=Rv(f|0,g|0,i|0,((i|0)<0)<<31>>31|0)|0;E=L()|0;c[14768]=((E|0)<0|(E|0)==0&F>>>0<=G>>>0)&1}g=Ua[c[29340>>2]&127](i)|0;if(!g){f=7;break e}f=Ua[c[29352>>2]&127](g)|0;f=(c[14978]|0)+f|0;c[14978]=f;if(f>>>0>(c[14982]|0)>>>0)c[14982]=f;f=(c[14981]|0)+1|0;c[14981]=f;if(f>>>0<=(c[14987]|0)>>>0)break;c[14987]=f}while(0);f=c[H>>2]|0;m=g+(f+1)|0;f=Ya[c[(c[q>>2]|0)+8>>2]&127](q,g,f,0,0)|0;if(!f){a[g+(c[H>>2]|0)>>0]=0;k=g;G=H;F=c[G+4>>2]|0;f:do if((F|0)>0|(F|0)==0&(c[G>>2]|0)>>>0>0){l=r+32|0;j=g;g:while(1){f=Xa[c[l>>2]&127](r,j,0,I)|0;if(f|0)break;do if(c[I>>2]|0){f=Ya[c[p>>2]&127](r,j,o,2049,0)|0;if(f|0)break g;f=Cf(o,m,n)|0;i=c[o>>2]|0;if(i|0){Ua[c[i+4>>2]&127](o)|0;c[o>>2]=0}if(f|0)break g;if(!(a[m>>0]|0))break;if(!(zu(m,s)|0)){f=0;break g}}while(0);j=j+(((Cu(j)|0)&1073741823)+1)|0;G=j-k|0;E=((G|0)<0)<<31>>31;F=H;D=c[F+4>>2]|0;if(!((D|0)>(E|0)|((D|0)==(E|0)?(c[F>>2]|0)>>>0>G>>>0:0))){J=88;break f}}}else J=88;while(0);if((J|0)==88){f=c[q>>2]|0;if(f|0){Ua[c[f+4>>2]&127](q)|0;c[q>>2]=0}f=Wa[c[r+28>>2]&127](r,s,0)|0}if(!g)break}if(!(c[7324]|0)){_a[c[29344>>2]&127](g);break}else{I=Ua[c[29352>>2]&127](g)|0;c[14978]=(c[14978]|0)-I;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](g);break}}else f=7}}while(0);g=c[q>>2]|0;if(g|0){Ua[c[g+4>>2]&127](q)|0;c[q>>2]=0}if(!(c[7324]|0)){_a[c[29344>>2]&127](q);break}else{I=Ua[c[29352>>2]&127](q)|0;c[14978]=(c[14978]|0)-I;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](q);break}}else f=7;while(0);g=f}else g=0}}}else{f=0;e=g;J=38}}else{f=0;e=g;J=38}while(0);if((J|0)==38){J=b+12|0;a[b+18>>0]=a[J>>0]|0;h=f;g=e;e=J}if((d|0)!=0&(h|0)!=0){d=c[b+172>>2]|0;c[K>>2]=h;c[K+4>>2]=d;Bb(539,32360,K)}if(a[e>>0]|0){K=512;b=b+148|0;c[b>>2]=K;Qa=M;return g|0}e=b+60|0;K=c[e>>2]|0;if((Ua[c[(c[K>>2]|0)+48>>2]&127](K)|0)&4096|0){K=512;b=b+148|0;c[b>>2]=K;Qa=M;return g|0}e=c[e>>2]|0;f=c[(c[e>>2]|0)+44>>2]|0;if(!f){K=4096;b=b+148|0;c[b>>2]=K;Qa=M;return g|0}K=Ua[f&127](e)|0;K=(K|0)<32?512:(K|0)<65536?K:65536;b=b+148|0;c[b>>2]=K;Qa=M;return g|0}function wf(a){a=a|0;var b=0,d=0;if(!a)return;if(c[a+8>>2]|0){d=a+12|0;b=0;do{wf(c[d+(b<<2)>>2]|0);b=b+1|0}while((b|0)!=125)}if(!(c[7324]|0)){_a[c[29344>>2]&127](a);return}else{d=Ua[c[29352>>2]&127](a)|0;c[14978]=(c[14978]|0)-d;c[14981]=(c[14981]|0)+-1;_a[c[29344>>2]&127](a);return}}function xf(f,g,h,i,j){f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,H=0,I=0,J=0,K=0;K=Qa;Qa=Qa+16|0;v=K+4|0;J=K;I=c[f+208>>2]|0;C=(i|0)!=0;r=c[(C?f+64|0:f+68|0)>>2]|0;k=g;k=Ya[c[(c[r>>2]|0)+8>>2]&127](r,v,4,c[k>>2]|0,c[k+4>>2]|0)|0;if(k|0){J=k;Qa=K;return J|0}s=v+1|0;t=v+2|0;u=v+3|0;D=d[s>>0]<<16|d[v>>0]<<24|d[t>>0]<<8|d[u>>0];H=f+152|0;q=c[H>>2]|0;w=g;w=Qv(c[w>>2]|0,c[w+4>>2]|0,4,0)|0;k=L()|0;k=Ya[c[(c[r>>2]|0)+8>>2]&127](r,I,q,w,k)|0;if(k|0){J=k;Qa=K;return J|0}k=c[H>>2]|0;p=(i<<2)+4+k|0;q=g;p=Qv(c[q>>2]|0,c[q+4>>2]|0,p|0,((p|0)<0)<<31>>31|0)|0;q=L()|0;w=g;c[w>>2]=p;c[w+4>>2]=q;if(!D){J=101;Qa=K;return J|0}if((D|0)==((1073741824/(k|0)|0)+1|0)){J=101;Qa=K;return J|0}if(D>>>0>(c[f+24>>2]|0)>>>0){J=0;Qa=K;return J|0}w=(h|0)==0;a:do if(!w?(m=D+-1|0,n=c[h>>2]|0,m>>>0<n>>>0):0){l=c[h+8>>2]|0;if(!l){o=h;k=n}else{n=h;do{k=(m>>>0)/(l>>>0)|0;n=c[n+12+(k<<2)>>2]|0;if(!n)break a;m=m-(G(k,l)|0)|0;l=c[n+8>>2]|0}while((l|0)!=0);o=n;k=c[n>>2]|0}if(k>>>0<4001){if(!(1<<(m&7)&d[o+12+(m>>>3)>>0]))break;else k=0;Qa=K;return k|0}n=m+1|0;k=(m>>>0)%125|0;l=c[o+12+(k<<2)>>2]|0;if(l|0){while(1){if((l|0)==(n|0)){k=0;break}k=((k+1|0)>>>0)%125|0;l=c[o+12+(k<<2)>>2]|0;if(!l)break a}Qa=K;return k|0}}while(0);if(C){q=Qv(p|0,q|0,-4,-1)|0;k=L()|0;k=Ya[c[(c[r>>2]|0)+8>>2]&127](r,v,4,q,k)|0;if(k|0){J=k;Qa=K;return J|0}m=d[s>>0]<<16|d[v>>0]<<24|d[t>>0]<<8|d[u>>0];if(!j){k=c[f+48>>2]|0;l=c[H>>2]|0;if((l|0)>200)do{j=l;l=l+-200|0;k=k+(d[I+l>>0]|0)|0}while((j|0)>400);if((k|0)!=(m|0)){J=101;Qa=K;return J|0}}}if(!w?(x=bf(h,D)|0,x|0):0){J=x;Qa=K;return J|0}p=(D|0)==1;if(p?(y=f+142|0,z=a[I+20>>0]|0,(b[y>>1]|0)!=(z&255|0)):0)b[y>>1]=z&255;do if((c[f+216>>2]|0)==0?(A=f+212|0,B=Wa[c[29436>>2]&127](c[(c[A>>2]|0)+44>>2]|0,D,0)|0,(B|0)!=0):0){k=c[A>>2]|0;l=c[B+4>>2]|0;if(!(c[l>>2]|0)){l=qf(k,D,B)|0;break}else{B=k+12|0;c[B>>2]=(c[B>>2]|0)+1;B=l+30|0;b[B>>1]=(b[B>>1]|0)+1<<16>>16;break}}else l=0;while(0);c[J>>2]=l;if(C)if(!(a[f+7>>0]|0)){C=g;B=c[C+4>>2]|0;k=f+80|0;g=c[k+4>>2]|0;k=((B|0)<(g|0)|((B|0)==(g|0)?(c[C>>2]|0)>>>0<=(c[k>>2]|0)>>>0:0))&1}else k=1;else if(!l)k=1;else k=((e[l+28>>1]|0)>>>3&1^1)&65535;m=c[f+60>>2]|0;n=c[m>>2]|0;do if(n){o=a[f+16>>0]|0;if((o&255)>3){if(!k){F=51;break}}else if(!((k|0)!=0&o<<24>>24==0)){F=51;break}E=c[H>>2]|0;k=Wv(E|0,((E|0)<0)<<31>>31|0,D+-1|0,0)|0;l=L()|0;l=Ya[c[n+12>>2]&127](m,I,E,k,l)|0;k=f+32|0;if(D>>>0>(c[k>>2]|0)>>>0)c[k>>2]=D;k=c[f+88>>2]|0;if(!k)n=l;else{lf(k,D,I);n=l}}else F=51;while(0);if((F|0)==51)if((i|0)==0&(l|0)==0){F=f+20|0;a[F>>0]=a[F>>0]|2;k=Xa[c[f+204>>2]&127](f,D,J,1)|0;a[F>>0]=a[F>>0]&-3;if(k|0){J=k;Qa=K;return J|0}n=c[J>>2]|0;l=n+28|0;k=e[l>>1]|0;if((k&17|0)!=0?(E=k&65519,b[l>>1]=E,(k&1|0)!=0):0){m=(E^3)&65535;b[l>>1]=m;k=c[n+12>>2]|0;c[n+36>>2]=0;l=c[k>>2]|0;c[n+32>>2]=l;if(!l){c[k+4>>2]=n;if(a[k+32>>0]|0)a[k+33>>0]=1}else c[l+36>>2]=n;c[k>>2]=n;k=k+8|0;if((m&8)==0&(c[k>>2]|0)==0){c[k>>2]=n;n=0}else n=0}else n=0}else n=0;k=c[J>>2]|0;if(!k){J=n;Qa=K;return J|0}k=c[k+4>>2]|0;cw(k|0,I|0,c[H>>2]|0)|0;_a[c[f+200>>2]&127](c[J>>2]|0);if(p){m=f+104|0;k=k+24|0;l=m+16|0;do{a[m>>0]=a[k>>0]|0;m=m+1|0;k=k+1|0}while((m|0)<(l|0))}Bf(c[J>>2]|0);J=n;Qa=K;return J|0}function yf(a,b,e,f,g,h){a=a|0;b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=Qa;Qa=Qa+32|0;p=t+16|0;k=t+8|0;q=t;s=a+72|0;j=s;i=c[j>>2]|0;j=c[j+4>>2]|0;if((i|0)==0&(j|0)==0){i=a+148|0;r=i;n=0;o=0;i=c[i>>2]|0;j=0}else{o=Qv(i|0,j|0,-1,-1)|0;n=L()|0;r=a+148|0;i=c[r>>2]|0;n=Uv(o|0,n|0,i|0,0)|0;n=Qv(n|0,L()|0,1,0)|0;n=Wv(n|0,L()|0,i|0,0)|0;o=L()|0;j=0}m=s;c[m>>2]=n;c[m+4>>2]=o;m=Qv(n|0,o|0,i|0,j|0)|0;l=L()|0;if((l|0)>(f|0)|(l|0)==(f|0)&m>>>0>e>>>0){s=101;Qa=t;return s|0}if((b|0)==0?(m=a+80|0,(n|0)==(c[m>>2]|0)?(o|0)==(c[m+4>>2]|0):0):0)e=a+64|0;else{i=a+64|0;j=c[i>>2]|0;j=Ya[c[(c[j>>2]|0)+8>>2]&127](j,k,8,n,o)|0;if(j|0){s=j;Qa=t;return s|0}if(!(Ju(k,32352,8)|0))e=i;else{s=101;Qa=t;return s|0}}l=c[e>>2]|0;m=Qv(n|0,o|0,8,0)|0;i=L()|0;i=Ya[c[(c[l>>2]|0)+8>>2]&127](l,p,4,m,i)|0;if(i|0){s=i;Qa=t;return s|0}k=p+1|0;l=p+2|0;m=p+3|0;c[g>>2]=(d[k>>0]|0)<<16|(d[p>>0]|0)<<24|(d[l>>0]|0)<<8|(d[m>>0]|0);f=c[e>>2]|0;g=Qv(n|0,o|0,12,0)|0;i=L()|0;i=Ya[c[(c[f>>2]|0)+8>>2]&127](f,p,4,g,i)|0;if(i|0){s=i;Qa=t;return s|0}c[a+48>>2]=(d[k>>0]|0)<<16|(d[p>>0]|0)<<24|(d[l>>0]|0)<<8|(d[m>>0]|0);f=c[e>>2]|0;g=Qv(n|0,o|0,16,0)|0;i=L()|0;i=Ya[c[(c[f>>2]|0)+8>>2]&127](f,p,4,g,i)|0;if(i|0){s=i;Qa=t;return s|0}c[h>>2]=(d[k>>0]|0)<<16|(d[p>>0]|0)<<24|(d[l>>0]|0)<<8|(d[m>>0]|0);j=s;b=c[j>>2]|0;j=c[j+4>>2]|0;a:do if((b|0)==0&(j|0)==0){g=c[e>>2]|0;h=Qv(n|0,o|0,20,0)|0;i=L()|0;i=Ya[c[(c[g>>2]|0)+8>>2]&127](g,p,4,h,i)|0;do if(!i){f=(d[k>>0]|0)<<16|(d[p>>0]|0)<<24|(d[l>>0]|0)<<8|(d[m>>0]|0);h=c[e>>2]|0;o=Qv(n|0,o|0,24,0)|0;i=L()|0;i=Ya[c[(c[h>>2]|0)+8>>2]&127](h,p,4,o,i)|0;if(i|0)break;i=(d[k>>0]|0)<<16|(d[p>>0]|0)<<24|(d[l>>0]|0)<<8|(d[m>>0]|0);c[q>>2]=i;if(!i){i=c[a+152>>2]|0;c[q>>2]=i}if((!((f+-32|0)>>>0>65504|(i+-512|0)>>>0>65024)?(i+-1&i|0)==0:0)?(f+-1&f|0)==0:0){e=Qe(a,q,-1)|0;c[r>>2]=f;j=s;b=c[j>>2]|0;j=c[j+4>>2]|0;i=f;break a}else i=101}while(0);s=i;Qa=t;return s|0}else{e=0;i=c[r>>2]|0}while(0);q=Qv(b|0,j|0,i|0,0)|0;r=L()|0;c[s>>2]=q;c[s+4>>2]=r;s=e;Qa=t;return s|0}function zf(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;f=d+212|0;h=Wa[c[29436>>2]&127](c[(c[f>>2]|0)+44>>2]|0,e,0)|0;do if(!h)g=0;else{f=c[f>>2]|0;g=c[h+4>>2]|0;if(!(c[g>>2]|0)){f=qf(f,e,h)|0;if(!f){g=0;break}g=f;f=b[f+30>>1]|0}else{k=f+12|0;c[k>>2]=(c[k>>2]|0)+1;k=g+30|0;f=(b[k>>1]|0)+1<<16>>16;b[k>>1]=f}if(f<<16>>16!=1){f=pf(g)|0;if(!f){_a[c[d+200>>2]&127](g);if(!(b[g+28>>1]&32)){Bf(g);g=0;break}else{k=c[g+20>>2]|0;j=k+120|0;c[j>>2]=(c[j>>2]|0)+-1;k=k+136|0;c[g+16>>2]=c[k>>2];c[k>>2]=g;g=0;break}}else if(!(b[g+28>>1]&32)){Bf(g);g=f;break}else{k=c[g+20>>2]|0;j=k+120|0;c[j>>2]=(c[j>>2]|0)+-1;k=k+136|0;c[g+16>>2]=c[k>>2];c[k>>2]=g;g=f;break}}k=c[g+12>>2]|0;do if(b[g+28>>1]&2){f=k+8|0;e=g+36|0;h=c[e>>2]|0;if((c[f>>2]|0)==(g|0))c[f>>2]=h;i=c[g+32>>2]|0;j=(i|0)==0;if(j){c[k+4>>2]=h;f=h}else{c[i+36>>2]=h;f=c[e>>2]|0}if(f|0){c[f+32>>2]=i;break}c[k>>2]=i;if(j)a[k+33>>0]=2}while(0);j=k+12|0;c[j>>2]=(c[j>>2]|0)+-1;ab[c[29440>>2]&255](c[k+44>>2]|0,c[g>>2]|0,1);g=0}while(0);f=c[d+88>>2]|0;if(!f)return g|0;do{c[f+16>>2]=1;f=c[f+44>>2]|0}while((f|0)!=0);return g|0}function Af(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=Qa;Qa=Qa+176|0;m=o+128|0;n=o;e=c[a>>2]|0;d=(e|0)==0;if(!d){a=e;do{l=a;a=c[a+32>>2]|0;c[l+16>>2]=a}while((a|0)!=0);a=n;b=a+128|0;do{c[a>>2]=0;a=a+4|0}while((a|0)<(b|0));if(d)a=0;else{l=m+16|0;j=m+16|0;k=n+124|0;do{h=e+16|0;a=e;e=c[h>>2]|0;c[h>>2]=0;h=0;while(1){i=n+(h<<2)|0;b=c[i>>2]|0;if(!b){b=9;break}d=m;g=b;a:while(1){f=c[g+24>>2]|0;b=d;while(1){b=b+16|0;if(f>>>0<(c[a+24>>2]|0)>>>0)break;c[b>>2]=a;b=c[a+16>>2]|0;if(!b){b=a;a=g;break a}else{d=a;a=b;b=d}}c[b>>2]=g;b=c[g+16>>2]|0;if(!b){b=g;break}else{d=g;g=b}}c[b+16>>2]=a;a=c[l>>2]|0;c[i>>2]=0;h=h+1|0;if(h>>>0>=31){b=16;break}}if((b|0)==9)c[i>>2]=a;else if((b|0)==16?(0,(h|0)==31):0){b=m;f=c[k>>2]|0;b:while(1){d=c[f+24>>2]|0;while(1){b=b+16|0;if(d>>>0<(c[a+24>>2]|0)>>>0)break;c[b>>2]=a;b=c[a+16>>2]|0;if(!b){b=a;a=f;break b}else{i=a;a=b;b=i}}c[b>>2]=f;b=c[f+16>>2]|0;if(!b){b=f;break}else{i=f;f=b;b=i}}c[b+16>>2]=a;c[k>>2]=c[j>>2]}}while((e|0)!=0);a=c[n>>2]|0}}else{a=n;b=a+128|0;do{c[a>>2]=0;a=a+4|0}while((a|0)<(b|0));a=0}g=m+16|0;f=1;do{b=c[n+(f<<2)>>2]|0;if(b)if(!a)a=b;else{d=m;c:while(1){e=c[a+24>>2]|0;while(1){d=d+16|0;if(e>>>0<(c[b+24>>2]|0)>>>0)break;c[d>>2]=b;d=c[b+16>>2]|0;if(!d){d=b;break c}else{l=b;b=d;d=l}}c[d>>2]=a;d=c[a+16>>2]|0;if(!d){d=a;a=b;break}else{l=a;a=d;d=l}}c[d+16>>2]=a;a=c[g>>2]|0}f=f+1|0}while((f|0)!=32);Qa=o;return a|0}function Bf(d){d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=c[d+12>>2]|0;m=k+12|0;c[m>>2]=(c[m>>2]|0)+-1;m=d+30|0;n=(b[m>>1]|0)+-1<<16>>16;b[m>>1]=n;if(n<<16>>16)return;m=b[d+28>>1]|0;if(m&1){if(!(a[k+32>>0]|0))return;ab[c[29440>>2]&255](c[k+44>>2]|0,c[d>>2]|0,0);return}n=k+8|0;e=c[n>>2]|0;j=d+36|0;g=c[j>>2]|0;if((e|0)==(d|0)){c[n>>2]=g;l=g}else l=e;i=d+32|0;f=c[i>>2]|0;h=(f|0)==0;if(h){c[k+4>>2]=g;e=g}else{c[f+36>>2]=g;e=c[j>>2]|0}do if(!e){c[k>>2]=f;if(h){a[k+33>>0]=2;c[j>>2]=0;c[i>>2]=0;e=k;g=16;break}else{c[j>>2]=0;e=k;g=15;break}}else{c[e+32>>2]=f;f=c[k>>2]|0;c[j>>2]=0;c[i>>2]=f;if(!f){e=k;g=16}else{e=k;g=15}}while(0);if((g|0)==15)c[f+36>>2]=d;else if((g|0)==16){c[k+4>>2]=d;if(a[k+32>>0]|0)a[k+33>>0]=1}c[e>>2]=d;if(!((m&8)==0&(l|0)==0))return;c[n>>2]=d;return}function Cf(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;p=Qa;Qa=Qa+32|0;l=p+16|0;n=p;o=p+8|0;a[e>>0]=0;i=Va[c[(c[b>>2]|0)+24>>2]&255](b,n)|0;h=n;g=c[h>>2]|0;h=c[h+4>>2]|0;if((i|0)!=0|((h|0)<0|(h|0)==0&g>>>0<16)){e=i;Qa=p;return e|0}m=Qv(g|0,h|0,-16,-1)|0;g=L()|0;g=Ya[c[(c[b>>2]|0)+8>>2]&127](b,l,4,m,g)|0;if(g|0){e=g;Qa=p;return e|0}i=l+1|0;j=l+2|0;k=l+3|0;m=d[i>>0]<<16|d[l>>0]<<24|d[j>>0]<<8|d[k>>0];if(m>>>0>=f>>>0){e=0;Qa=p;return e|0}h=n;g=c[h>>2]|0;h=c[h+4>>2]|0;f=Qv(g|0,h|0,-16,-1)|0;q=L()|0;if((m|0)==0|((q|0)<0|(q|0)==0&f>>>0<m>>>0)){q=0;Qa=p;return q|0}q=Qv(g|0,h|0,-12,-1)|0;g=L()|0;g=Ya[c[(c[b>>2]|0)+8>>2]&127](b,l,4,q,g)|0;if(g|0){q=g;Qa=p;return q|0}g=d[i>>0]<<16|d[l>>0]<<24|d[j>>0]<<8|d[k>>0];q=n;q=Qv(c[q>>2]|0,c[q+4>>2]|0,-8,-1)|0;h=L()|0;h=Ya[c[(c[b>>2]|0)+8>>2]&127](b,o,8,q,h)|0;if(h|0){q=h;Qa=p;return q|0}if(Ju(o,32352,8)|0){q=0;Qa=p;return q|0}q=n;h=c[q>>2]|0;q=c[q+4>>2]|0;o=Rv(-16,-1,m|0,0)|0;q=Qv(o|0,L()|0,h|0,q|0)|0;h=L()|0;h=Ya[c[(c[b>>2]|0)+8>>2]&127](b,e,m,q,h)|0;if(h|0){q=h;Qa=p;return q|0}h=0;do{g=g-(a[e+h>>0]|0)|0;h=h+1|0}while((h|0)!=(m|0));a[e+((g|0)==0?m:0)>>0]=0;q=0;Qa=p;return q|0}function Df(d){d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=d+100|0;c[e>>2]=(c[e>>2]|0)+1;e=c[d+88>>2]|0;if(e|0)do{c[e+16>>2]=1;e=c[e+44>>2]|0}while((e|0)!=0);j=c[d+212>>2]|0;k=j+44|0;if(!(c[k>>2]|0))return;e=c[j>>2]|0;if(e|0)do{h=e;e=c[e+32>>2]|0;if(c[h+24>>2]|0){i=c[h+12>>2]|0;f=i+8|0;g=h+36|0;d=c[g>>2]|0;if((c[f>>2]|0)==(h|0))c[f>>2]=d;f=(e|0)==0;if(f)c[i+4>>2]=d;else{c[e+36>>2]=d;d=c[g>>2]|0}if(!d){c[i>>2]=e;if(f)a[i+33>>0]=2}else c[d+32>>2]=e;g=h+28|0;b[g>>1]=b[g>>1]&-16|1;if((b[h+30>>1]|0)==0?a[i+32>>0]|0:0)ab[c[29440>>2]&255](c[i+44>>2]|0,c[h>>2]|0,0)}}while((e|0)!=0);if((c[j+12>>2]|0)!=0?(l=Wa[c[29436>>2]&127](c[k>>2]|0,1,0)|0,(l|0)!=0):0){ew(c[l>>2]|0,0,c[j+24>>2]|0)|0;e=2}else e=1;$a[c[29448>>2]&127](c[k>>2]|0,e);return}function Ef(e){e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;p=Qa;Qa=Qa+48|0;o=p+32|0;g=p+16|0;f=p;k=c[e+52>>2]|0;l=c[e+56>>2]|0;m=d[e+9>>0]|0;n=l+m|0;q=d[n>>0]|0;j=q>>>3;h=j&255;a[e+8>>0]=h;j=4-(j<<2)|0;a[e+10>>0]=j;i=e+76|0;c[i>>2]=120;switch((q&247)<<24>>24){case 5:{a[e+2>>0]=1;f=e+3|0;if(!(h<<24>>24)){a[f>>0]=0;c[i>>2]=121;f=181}else{a[f>>0]=1;f=180}c[e+80>>2]=f;b[e+14>>1]=b[k+28>>1]|0;f=k+30|0;break}case 2:{a[e+2>>0]=0;a[e+3>>0]=0;c[e+80>>2]=179;b[e+14>>1]=b[k+24>>1]|0;f=k+26|0;break}default:{c[f>>2]=32306;c[f+4>>2]=65035;c[f+8>>2]=31517;Bb(11,32001,f);c[g>>2]=32306;c[g+4>>2]=65185;c[g+8>>2]=31517;Bb(11,32001,g);q=11;Qa=p;return q|0}}b[e+16>>1]=b[f>>1]|0;a[e+11>>0]=a[k+21>>0]|0;q=c[k+32>>2]|0;b[e+26>>1]=q+65535;a[e+12>>0]=0;j=j&252;b[e+18>>1]=m+8+j;c[e+64>>2]=n+j+8;c[e+60>>2]=l+(c[k+36>>2]|0);c[e+68>>2]=l+j;n=n+3|0;n=(d[n>>0]|0)<<8|(d[n+1>>0]|0);b[e+24>>1]=n;if(n>>>0>(((q+-8|0)>>>0)/6|0)>>>0){c[o>>2]=32306;c[o+4>>2]=65199;c[o+8>>2]=31517;Bb(11,32001,o);q=11;Qa=p;return q|0}c[e+20>>2]=-1;a[e>>0]=1;if(0==0?(c[(c[k+4>>2]|0)+32>>2]&2097152|0)==0:0){q=0;Qa=p;return q|0}q=Ff(e)|0;Qa=p;return q|0}function Ff(f){f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=Qa;Qa=Qa+32|0;q=r+16|0;p=r;k=e[f+18>>1]|0;m=f+24|0;l=b[m>>1]|0;n=((l&65535)<<1)+k|0;h=c[(c[f+52>>2]|0)+36>>2]|0;i=c[f+56>>2]|0;o=((a[f+8>>0]|0)==0?-5:-4)+h|0;if(!(l<<16>>16)){q=0;Qa=r;return q|0}j=f+76|0;g=0;while(1){l=i+((g<<1)+k)|0;l=d[l>>0]<<8|d[l+1>>0];if(l>>>0<n>>>0|(l|0)>(o|0)){f=5;break}g=g+1|0;if((l+((Va[c[j>>2]&255](f,i+l|0)|0)&65535)|0)>(h|0)){f=7;break}if(g>>>0>=(e[m>>1]|0)>>>0){g=0;f=8;break}}if((f|0)==5){c[p>>2]=32306;c[p+4>>2]=65148;c[p+8>>2]=31517;Bb(11,32001,p);q=11;Qa=r;return q|0}else if((f|0)==7){c[q>>2]=32306;c[q+4>>2]=65153;c[q+8>>2]=31517;Bb(11,32001,q);q=11;Qa=r;return q|0}else if((f|0)==8){Qa=r;return g|0}return 0}function Gf(b,f){b=b|0;f=f|0;var g=0,h=0,i=0,j=0;i=f+(d[b+10>>0]|0)|0;j=a[i>>0]|0;h=j&255;if(j<<24>>24<0){g=0;h=h&127;do{g=g+1|0;j=a[i+g>>0]|0;h=h<<7|j&127}while(j<<24>>24<0&g>>>0<8);i=i+g|0;j=h}else j=h;if(!(a[b+2>>0]|0))g=i+1|0;else{g=1;do{h=g;g=g+1|0}while((a[i+h>>0]|0)<0&g>>>0<10);g=i+g|0}h=e[b+14>>1]|0;if(j>>>0>h>>>0){i=e[b+16>>1]|0;b=(((j-i|0)>>>0)%(((c[(c[b+52>>2]|0)+36>>2]|0)+-4|0)>>>0)|0)+i|0;f=(g-f&65535)+4+(b>>>0>h>>>0?i:b)|0;f=f&65535;return f|0}else{f=g-f+j|0;f=f>>>0>4?f:4;f=f&65535;return f|0}return 0}function Hf(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=a[f>>0]|0;i=n&255;if(n<<24>>24<0){h=0;i=i&127;do{h=h+1|0;n=a[f+h>>0]|0;i=i<<7|n&127}while(n<<24>>24<0&h>>>0<8);n=f+h|0}else n=f;h=n+1|0;m=a[h>>0]|0;j=m&255;do if(m<<24>>24<0){j=aw(j|0,0,7)|0;L()|0;h=n+2|0;m=a[h>>0]|0;j=j&16256|m&127;if(m<<24>>24<=-1){k=2;h=1;l=0;while(1){if(h>>>0>6){m=10;break}j=aw(j|0,l|0,7)|0;l=L()|0;h=k+1|0;m=a[n+h>>0]|0;j=j|m&127;if(m<<24>>24>-1){m=11;break}else{m=k;k=h;h=m}}if((m|0)==10){m=aw(j|0,l|0,8)|0;l=L()|0;j=n+k+1|0;h=j;j=m|(d[j>>0]|0);break}else if((m|0)==11){h=n+h|0;break}}else l=0}else l=0;while(0);k=h+1|0;h=g;c[h>>2]=j;c[h+4>>2]=l;c[g+12>>2]=i;c[g+8>>2]=k;h=b[e+14>>1]|0;if(i>>>0>(h&65535)>>>0){Lf(h,b[e+16>>1]|0,c[(c[e+52>>2]|0)+36>>2]|0,f,g);return}else{f=k-f+i|0;b[g+18>>1]=(f&65532|0)==0?4:f&65535;b[g+16>>1]=i;return}}function If(b,c){b=b|0;c=c|0;var d=0;b=4;do{d=b;b=b+1|0}while((a[c+d>>0]|0)<0&b>>>0<13);return b&65535|0}function Jf(a,d,e){a=a|0;d=d|0;e=e|0;b[e+18>>1]=((Mf(d+4|0,e)|0)&255)+4;c[e+12>>2]=0;b[e+16>>1]=0;c[e+8>>2]=0;return}function Kf(e,f,g){e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0;k=f+(d[e+10>>0]|0)|0;i=a[k>>0]|0;j=i&255;if(i<<24>>24<0){h=0;i=j&127;do{h=h+1|0;j=a[k+h>>0]|0;i=i<<7|j&127}while(j<<24>>24<0&h>>>0<8);h=k+h|0;j=i}else h=k;h=h+1|0;i=g;c[i>>2]=j;c[i+4>>2]=0;c[g+12>>2]=j;c[g+8>>2]=h;i=b[e+14>>1]|0;if(j>>>0>(i&65535)>>>0){Lf(i,b[e+16>>1]|0,c[(c[e+52>>2]|0)+36>>2]|0,f,g);return}else{f=h-f+j|0;b[g+18>>1]=(f&65532|0)==0?4:f&65535;b[g+16>>1]=j;return}}function Lf(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;h=d&65535;e=((((c[g+12>>2]|0)-h|0)>>>0)%((e+-4|0)>>>0)|0)+h|0;a=(e|0)>(a&65535|0);b[g+16>>1]=a?d:e&65535;b[g+18>>1]=4-f+((c[g+8>>2]|0)+(a?h:e&65535));return}function Mf(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=a[b>>0]|0;g=f&255;do if(g&128){f=d[b+1>>0]|0;if(!(f&128)){l=2;j=0;f=g<<7&16256|f;break}l=d[b+2>>0]|0;g=(g<<14|l)&2080895;if(!(l&128)){l=3;j=0;f=g|f<<7&16256;break}l=d[b+3>>0]|0;f=(f<<14|l)&2080895;if(!(l&128)){l=4;j=0;f=f|g<<7;break}k=a[b+4>>0]|0;l=k&255;h=g<<14|l;if(!(l&128)){l=5;j=g>>>18;f=h|f<<7;break}j=f|g<<7;l=d[b+5>>0]|0;i=f<<14|l;if(!(l&128)){l=6;j=j>>>18;f=i|h<<7&266354560;break}l=d[b+6>>0]|0;f=h<<14|l;if(!(l&128)){l=7;j=j>>>11;f=f&-266354561|i<<7&266354560;break}g=f&2080895;l=d[b+7>>0]|0;f=i<<14|l;if(!(l&128)){l=8;j=j>>>4;f=f&-266354561|g<<7;break}else{l=9;j=(k&120)>>>3|j<<4;f=f<<8&532709120|g<<15|(d[b+8>>0]|0);break}}else{l=1;j=0;f=f&255}while(0);c[e>>2]=f;c[e+4>>2]=j;return l|0}function Nf(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=Qa;Qa=Qa+16|0;l=n+8|0;k=n;j=n+12|0;if(!b){b=0;Qa=n;return b|0}if(g){i=b+4|0;h=c[i>>2]|0;h=Va[c[(c[h>>2]|0)+28>>2]&255](h,4)|0;if(!h){h=b+43|0;if(!(a[h>>0]|0))a[h>>0]=1;h=Of(b,d,0,0,0,e,f,g,0,0)|0;if(!h){c[j>>2]=-1;h=c[i>>2]|0