
// We are modularizing this manually because the current modularize setting in Emscripten has some issues:
// https://github.com/kripken/emscripten/issues/5820
// In addition, When you use emcc's modularization, it still expects to export a global object called `Module`,
// which is able to be used/called before the WASM is loaded.
// The modularization below exports a promise that loads and resolves to the actual sql.js module.
// That way, this module can't be used before the WASM is finished loading.

// We are going to define a function that a user will call to start loading initializing our Sql.js library
// However, that function might be called multiple times, and on subsequent calls, we don't actually want it to instantiate a new instance of the Module
// Instead, we want to return the previously loaded module

// TODO: Make this not declare a global if used in the browser
var initSqlJsPromise = undefined;

var initSqlJs = function (moduleConfig) {

    if (initSqlJsPromise){
      return initSqlJsPromise;
    }
    // If we're here, we've never called this function before
    initSqlJsPromise = new Promise((resolveModule, reject) => {

        // We are modularizing this manually because the current modularize setting in Emscripten has some issues:
        // https://github.com/kripken/emscripten/issues/5820

        // The way to affect the loading of emcc compiled modules is to create a variable called `Module` and add
        // properties to it, like `preRun`, `postRun`, etc
        // We are using that to get notified when the WASM has finished loading.
        // Only then will we return our promise

        // If they passed in a moduleConfig object, use that
        // Otherwise, initialize Module to the empty object
        var Module = typeof moduleConfig !== 'undefined' ? moduleConfig : {};

        // EMCC only allows for a single onAbort function (not an array of functions)
        // So if the user defined their own onAbort function, we remember it and call it
        var originalOnAbortFunction = Module['onAbort'];
        Module['onAbort'] = function (errorThatCausedAbort) {
            reject(new Error(errorThatCausedAbort));
            if (originalOnAbortFunction){
              originalOnAbortFunction(errorThatCausedAbort);
            }
        };

        Module['postRun'] = Module['postRun'] || [];
        Module['postRun'].push(function () {
            // When Emscripted calls postRun, this promise resolves with the built Module
            resolveModule(Module);
        });

        // There is a section of code in the emcc-generated code below that looks like this:
        // (Note that this is lowercase `module`)
        // if (typeof module !== 'undefined') {
        //     module['exports'] = Module;
        // }
        // When that runs, it's going to overwrite our own modularization export efforts in shell-post.js!
        // The only way to tell emcc not to emit it is to pass the MODULARIZE=1 or MODULARIZE_INSTANCE=1 flags,
        // but that carries with it additional unnecessary baggage/bugs we don't want either.
        // So, we have three options:
        // 1) We undefine `module`
        // 2) We remember what `module['exports']` was at the beginning of this function and we restore it later
        // 3) We write a script to remove those lines of code as part of the Make process.
        //
        // Since those are the only lines of code that care about module, we will undefine it. It's the most straightforward
        // of the options, and has the side effect of reducing emcc's efforts to modify the module if its output were to change in the future.
        // That's a nice side effect since we're handling the modularization efforts ourselves
        module = undefined;
        
        // The emcc-generated code and shell-post.js code goes below,
        // meaning that all of it runs inside of this promise. If anything throws an exception, our promise will abort
var aa;var f;f||(f=typeof Module !== 'undefined' ? Module : {});
var wa=function(){var a;var b=h(4);var c={};var d=function(){function a(a,b){this.jb=a;this.db=b;this.rb=1;this.Jb=[]}a.prototype.bind=function(a){if(!this.jb)throw"Statement closed";this.reset();return Array.isArray(a)?this.qc(a):this.rc(a)};a.prototype.step=function(){var a;if(!this.jb)throw"Statement closed";this.rb=1;switch(a=Xb(this.jb)){case c.mc:return!0;case c.DONE:return!1;default:return this.db.handleError(a)}};a.prototype.xc=function(a){null==a&&(a=this.rb++);return Yb(this.jb,a)};a.prototype.yc=
function(a){null==a&&(a=this.rb++);return Zb(this.jb,a)};a.prototype.getBlob=function(a){var b;null==a&&(a=this.rb++);var c=$b(this.jb,a);var d=ac(this.jb,a);var e=new Uint8Array(c);for(a=b=0;0<=c?b<c:b>c;a=0<=c?++b:--b)e[a]=l[d+a];return e};a.prototype.get=function(a){var b,d;null!=a&&this.bind(a)&&this.step();var e=[];a=b=0;for(d=kb(this.jb);0<=d?b<d:b>d;a=0<=d?++b:--b)switch(bc(this.jb,a)){case c.lc:case c.FLOAT:e.push(this.xc(a));break;case c.nc:e.push(this.yc(a));break;case c.dc:e.push(this.getBlob(a));
break;default:e.push(null)}return e};a.prototype.getColumnNames=function(){var a,b;var c=[];var d=a=0;for(b=kb(this.jb);0<=b?a<b:a>b;d=0<=b?++a:--a)c.push(cc(this.jb,d));return c};a.prototype.getAsObject=function(a){var b,c;var d=this.get(a);var e=this.getColumnNames();var g={};a=b=0;for(c=e.length;b<c;a=++b){var Ka=e[a];g[Ka]=d[a]}return g};a.prototype.run=function(a){null!=a&&this.bind(a);this.step();return this.reset()};a.prototype.uc=function(a,b){var c;null==b&&(b=this.rb++);a=ba(a);this.Jb.push(c=
ca(a));this.db.handleError(da(this.jb,b,c,a.length-1,0))};a.prototype.pc=function(a,b){var c;null==b&&(b=this.rb++);this.Jb.push(c=ca(a));this.db.handleError(La(this.jb,b,c,a.length,0))};a.prototype.tc=function(a,b){null==b&&(b=this.rb++);this.db.handleError((a===(a|0)?dc:ec)(this.jb,b,a))};a.prototype.sc=function(a){null==a&&(a=this.rb++);La(this.jb,a,0,0,0)};a.prototype.Vb=function(a,b){null==b&&(b=this.rb++);switch(typeof a){case "string":this.uc(a,b);break;case "number":case "boolean":this.tc(a+
0,b);break;case "object":if(null===a)this.sc(b);else if(null!=a.length)this.pc(a,b);else throw"Wrong API use : tried to bind a value of an unknown type ("+a+").";}};a.prototype.rc=function(a){var b;for(b in a){var c=a[b];var d=fc(this.jb,b);0!==d&&this.Vb(c,d)}return!0};a.prototype.qc=function(a){var b,c;var d=b=0;for(c=a.length;b<c;d=++b){var e=a[d];this.Vb(e,d+1)}return!0};a.prototype.reset=function(){this.freemem();return hc(this.jb)===c.Cb&&ic(this.jb)===c.Cb};a.prototype.freemem=function(){for(var a;a=
this.Jb.pop();)fa(a);return null};a.prototype.free=function(){this.freemem();var a=jc(this.jb)===c.Cb;delete this.db.Gb[this.jb];this.jb=ea;return a};return a}();var e=function(){function a(a){this.filename="dbfile_"+(4294967295*Math.random()>>>0);if(null!=a){var c=this.filename,d=c?n("/",c):"/";c=ia(!0,!0);d=ja(d,(void 0!==c?c:438)&4095|32768,0);if(a){if("string"===typeof a){for(var e=Array(a.length),k=0,Ka=a.length;k<Ka;++k)e[k]=a.charCodeAt(k);a=e}ka(d,c|146);e=p(d,"w");la(e,a,0,a.length,0,void 0);
ma(e);ka(d,c)}}this.handleError(g(this.filename,b));this.db=q(b,"i32");kc(this.db);this.Gb={};this.sb={}}a.prototype.run=function(a,c){if(!this.db)throw"Database closed";c?(a=this.prepare(a,c),a.step(),a.free()):this.handleError(m(this.db,a,0,0,b));return this};a.prototype.exec=function(a){if(!this.db)throw"Database closed";var c=na();var e=oa(a)+1;var g=h(e);r(a,l,g,e);a=g;e=h(4);for(g=[];q(a,"i8")!==ea;){pa(b);pa(e);this.handleError(ha(this.db,a,-1,b,e));var k=q(b,"i32");a=q(e,"i32");if(k!==ea){var m=
new d(k,this);for(k=null;m.step();)null===k&&(k={columns:m.getColumnNames(),values:[]},g.push(k)),k.values.push(m.get());m.free()}}qa(c);return g};a.prototype.each=function(a,b,c,d){"function"===typeof b&&(d=c,c=b,b=void 0);for(a=this.prepare(a,b);a.step();)c(a.getAsObject());a.free();if("function"===typeof d)return d()};a.prototype.prepare=function(a,c){pa(b);this.handleError(z(this.db,a,-1,b,ea));a=q(b,"i32");if(a===ea)throw"Nothing to prepare";var e=new d(a,this);null!=c&&e.bind(c);return this.Gb[a]=
e};a.prototype["export"]=function(){var a;var c=this.Gb;for(e in c){var d=c[e];d.free()}d=this.sb;for(e in d)c=d[e],t[c-ra]=null;this.sb={};this.handleError(k(this.db));d=this.filename;var e=e={encoding:"binary"};e.flags=e.flags||"r";e.encoding=e.encoding||"binary";if("utf8"!==e.encoding&&"binary"!==e.encoding)throw Error('Invalid encoding type "'+e.encoding+'"');c=p(d,e.flags);d=sa(d).size;var m=new Uint8Array(d);ta(c,m,0,d,0);"utf8"===e.encoding?a=v(m,0):"binary"===e.encoding&&(a=m);ma(c);this.handleError(g(this.filename,
b));this.db=q(b,"i32");return a};a.prototype.close=function(){var a;var b=this.Gb;for(a in b){var c=b[a];c.free()}c=this.sb;for(a in c)b=c[a],t[b-ra]=null;this.sb={};this.handleError(k(this.db));ua("/"+this.filename);return this.db=null};a.prototype.handleError=function(a){if(a===c.Cb)return null;a=lc(this.db);throw Error(a);};a.prototype.getRowsModified=function(){return u(this.db)};a.prototype.create_function=function(a,b){a in this.sb&&(t[this.sb[a]-ra]=null,delete this.sb[a]);var d=va(function(a,
c,d){var e,g;var k=[];for(e=g=0;0<=c?g<c:g>c;e=0<=c?++g:--g){var m=q(d+4*e,"i32");var z=nc(m);e=function(){switch(!1){case 1!==z:return pb;case 2!==z:return pb;case 3!==z:return oc;case 4!==z:return function(a){var b,c;var d=qc(a);var e=rc(a);a=new Uint8Array(d);for(b=c=0;0<=d?c<d:c>d;b=0<=d?++c:--c)a[b]=l[e+b];return a};default:return function(){return null}}}();e=e(m);k.push(e)}try{var u=b.apply(null,k)}catch(pc){u=pc;qb(a,u,-1);return}switch(typeof u){case "boolean":sc(a,u?1:0);break;case "number":tc(a,
u);break;case "string":uc(a,u,-1,-1);break;case "object":null===u?rb(a):null!=u.length?(c=ca(u),vc(a,c,u.length,-1),fa(c)):qb(a,"Wrong API use : tried to return a value of an unknown type ("+u+").",-1);break;default:rb(a)}});this.sb[a]=d;this.handleError(wc(this.db,a,b.length,c.oc,0,d,0,0,0));return this};return a}();var g=f.cwrap("sqlite3_open","number",["string","number"]);var k=f.cwrap("sqlite3_close_v2","number",["number"]);var m=f.cwrap("sqlite3_exec","number",["number","string","number","number",
"number"]);f.cwrap("sqlite3_free","",["number"]);var u=f.cwrap("sqlite3_changes","number",["number"]);var z=f.cwrap("sqlite3_prepare_v2","number",["number","string","number","number","number"]);var ha=f.cwrap("sqlite3_prepare_v2","number",["number","number","number","number","number"]);var da=f.cwrap("sqlite3_bind_text","number",["number","number","number","number","number"]);var La=f.cwrap("sqlite3_bind_blob","number",["number","number","number","number","number"]);var ec=f.cwrap("sqlite3_bind_double",
"number",["number","number","number"]);var dc=f.cwrap("sqlite3_bind_int","number",["number","number","number"]);var fc=f.cwrap("sqlite3_bind_parameter_index","number",["number","string"]);var Xb=f.cwrap("sqlite3_step","number",["number"]);var lc=f.cwrap("sqlite3_errmsg","string",["number"]);var kb=f.cwrap("sqlite3_data_count","number",["number"]);var Yb=f.cwrap("sqlite3_column_double","number",["number","number"]);var Zb=f.cwrap("sqlite3_column_text","string",["number","number"]);var ac=f.cwrap("sqlite3_column_blob",
"number",["number","number"]);var $b=f.cwrap("sqlite3_column_bytes","number",["number","number"]);var bc=f.cwrap("sqlite3_column_type","number",["number","number"]);var cc=f.cwrap("sqlite3_column_name","string",["number","number"]);var ic=f.cwrap("sqlite3_reset","number",["number"]);var hc=f.cwrap("sqlite3_clear_bindings","number",["number"]);var jc=f.cwrap("sqlite3_finalize","number",["number"]);var wc=f.cwrap("sqlite3_create_function_v2","number","number string number number number number number number number".split(" "));
var nc=f.cwrap("sqlite3_value_type","number",["number"]);var qc=f.cwrap("sqlite3_value_bytes","number",["number"]);var oc=f.cwrap("sqlite3_value_text","string",["number"]);f.cwrap("sqlite3_value_int","number",["number"]);var rc=f.cwrap("sqlite3_value_blob","number",["number"]);var pb=f.cwrap("sqlite3_value_double","number",["number"]);var tc=f.cwrap("sqlite3_result_double","",["number","number"]);var rb=f.cwrap("sqlite3_result_null","",["number"]);var uc=f.cwrap("sqlite3_result_text","",["number",
"string","number","number"]);var vc=f.cwrap("sqlite3_result_blob","",["number","number","number","number"]);var sc=f.cwrap("sqlite3_result_int","",["number","number"]);f.cwrap("sqlite3_result_int64","",["number","number"]);var qb=f.cwrap("sqlite3_result_error","",["number","string","number"]);var kc=f.cwrap("RegisterExtensionFunctions","number",["number"]);this.SQL={Database:e};for(a in this.SQL)f[a]=this.SQL[a];var ea=0;c.Cb=0;c.Be=1;c.Ue=2;c.df=3;c.Hc=4;c.Jc=5;c.Xe=6;c.NOMEM=7;c.gf=8;c.Ve=9;c.We=
10;c.Mc=11;c.NOTFOUND=12;c.Te=13;c.Kc=14;c.ef=15;c.EMPTY=16;c.hf=17;c.jf=18;c.Lc=19;c.Ye=20;c.Ze=21;c.$e=22;c.Ic=23;c.Se=24;c.ff=25;c.af=26;c.bf=27;c.kf=28;c.mc=100;c.DONE=101;c.lc=1;c.FLOAT=2;c.nc=3;c.dc=4;c.cf=5;c.oc=1}.bind(this);f.preRun=f.preRun||[];f.preRun.push(wa);var xa={},w;for(w in f)f.hasOwnProperty(w)&&(xa[w]=f[w]);f.arguments=[];f.thisProgram="./this.program";f.quit=function(a,b){throw b;};f.preRun=[];f.postRun=[];var x=!1,y=!1,A=!1,ya=!1;x="object"===typeof window;y="function"===typeof importScripts;
A="object"===typeof process&&"function"===typeof require&&!x&&!y;ya=!x&&!A&&!y;var B="";
if(A){B=__dirname+"/";var za,Aa;f.read=function(a,b){za||(za=require("fs"));Aa||(Aa=require("path"));a=Aa.normalize(a);a=za.readFileSync(a);return b?a:a.toString()};f.readBinary=function(a){a=f.read(a,!0);a.buffer||(a=new Uint8Array(a));assert(a.buffer);return a};1<process.argv.length&&(f.thisProgram=process.argv[1].replace(/\\/g,"/"));f.arguments=process.argv.slice(2);"undefined"!==typeof module&&(module.exports=f);process.on("unhandledRejection",C);f.quit=function(a){process.exit(a)};f.inspect=
function(){return"[Emscripten Module object]"}}else if(ya)"undefined"!=typeof read&&(f.read=function(a){return read(a)}),f.readBinary=function(a){if("function"===typeof readbuffer)return new Uint8Array(readbuffer(a));a=read(a,"binary");assert("object"===typeof a);return a},"undefined"!=typeof scriptArgs?f.arguments=scriptArgs:"undefined"!=typeof arguments&&(f.arguments=arguments),"function"===typeof quit&&(f.quit=function(a){quit(a)});else if(x||y)y?B=self.location.href:document.currentScript&&(B=
document.currentScript.src),B=0!==B.indexOf("blob:")?B.substr(0,B.lastIndexOf("/")+1):"",f.read=function(a){var b=new XMLHttpRequest;b.open("GET",a,!1);b.send(null);return b.responseText},y&&(f.readBinary=function(a){var b=new XMLHttpRequest;b.open("GET",a,!1);b.responseType="arraybuffer";b.send(null);return new Uint8Array(b.response)}),f.readAsync=function(a,b,c){var d=new XMLHttpRequest;d.open("GET",a,!0);d.responseType="arraybuffer";d.onload=function(){200==d.status||0==d.status&&d.response?b(d.response):
c()};d.onerror=c;d.send(null)},f.setWindowTitle=function(a){document.title=a};var Ba=f.print||("undefined"!==typeof console?console.log.bind(console):"undefined"!==typeof print?print:null),D=f.printErr||("undefined"!==typeof printErr?printErr:"undefined"!==typeof console&&console.warn.bind(console)||Ba);for(w in xa)xa.hasOwnProperty(w)&&(f[w]=xa[w]);xa=void 0;function Ca(a){var b=E[Da>>2];a=b+a+15&-16;if(a<=Ea())E[Da>>2]=a;else if(!Fa(a))return 0;return b}
var Ga={"f64-rem":function(a,b){return a%b},"debugger":function(){debugger}},ra=1,t=Array(64);function va(a){for(var b=0;64>b;b++)if(!t[b])return t[b]=a,ra+b;throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.";}"object"!==typeof WebAssembly&&D("no native wasm support detected");
function q(a,b){b=b||"i8";"*"===b.charAt(b.length-1)&&(b="i32");switch(b){case "i1":return l[a>>0];case "i8":return l[a>>0];case "i16":return Ha[a>>1];case "i32":return E[a>>2];case "i64":return E[a>>2];case "float":return Ia[a>>2];case "double":return Ja[a>>3];default:C("invalid type for getValue: "+b)}return null}var Ma,Na=!1;function assert(a,b){a||C("Assertion failed: "+b)}function Oa(a){var b=f["_"+a];assert(b,"Cannot call unknown function "+a+", make sure it is exported");return b}
function Pa(a,b,c,d){var e={string:function(a){var b=0;if(null!==a&&void 0!==a&&0!==a){var c=(a.length<<2)+1;b=h(c);r(a,F,b,c)}return b},array:function(a){var b=h(a.length);l.set(a,b);return b}},g=Oa(a),k=[];a=0;if(d)for(var m=0;m<d.length;m++){var u=e[c[m]];u?(0===a&&(a=na()),k[m]=u(d[m])):k[m]=d[m]}c=g.apply(null,k);c=function(a){return"string"===b?G(a):"boolean"===b?!!a:a}(c);0!==a&&qa(a);return c}
function pa(a){var b="i32";"*"===b.charAt(b.length-1)&&(b="i32");switch(b){case "i1":l[a>>0]=0;break;case "i8":l[a>>0]=0;break;case "i16":Ha[a>>1]=0;break;case "i32":E[a>>2]=0;break;case "i64":aa=[0,1<=+Qa(0)?~~+Ra(0)>>>0:0];E[a>>2]=aa[0];E[a+4>>2]=aa[1];break;case "float":Ia[a>>2]=0;break;case "double":Ja[a>>3]=0;break;default:C("invalid type for setValue: "+b)}}var Sa=0,Ta=3;
function ca(a){var b=Sa;if("number"===typeof a){var c=!0;var d=a}else c=!1,d=a.length;b=b==Ta?e:[Ua,h,Ca][b](Math.max(d,1));if(c){var e=b;assert(0==(b&3));for(a=b+(d&-4);e<a;e+=4)E[e>>2]=0;for(a=b+d;e<a;)l[e++>>0]=0;return b}a.subarray||a.slice?F.set(a,b):F.set(new Uint8Array(a),b);return b}var Va="undefined"!==typeof TextDecoder?new TextDecoder("utf8"):void 0;
function v(a,b,c){var d=b+c;for(c=b;a[c]&&!(c>=d);)++c;if(16<c-b&&a.subarray&&Va)return Va.decode(a.subarray(b,c));for(d="";b<c;){var e=a[b++];if(e&128){var g=a[b++]&63;if(192==(e&224))d+=String.fromCharCode((e&31)<<6|g);else{var k=a[b++]&63;e=224==(e&240)?(e&15)<<12|g<<6|k:(e&7)<<18|g<<12|k<<6|a[b++]&63;65536>e?d+=String.fromCharCode(e):(e-=65536,d+=String.fromCharCode(55296|e>>10,56320|e&1023))}}else d+=String.fromCharCode(e)}return d}function G(a){return a?v(F,a,void 0):""}
function r(a,b,c,d){if(!(0<d))return 0;var e=c;d=c+d-1;for(var g=0;g<a.length;++g){var k=a.charCodeAt(g);if(55296<=k&&57343>=k){var m=a.charCodeAt(++g);k=65536+((k&1023)<<10)|m&1023}if(127>=k){if(c>=d)break;b[c++]=k}else{if(2047>=k){if(c+1>=d)break;b[c++]=192|k>>6}else{if(65535>=k){if(c+2>=d)break;b[c++]=224|k>>12}else{if(c+3>=d)break;b[c++]=240|k>>18;b[c++]=128|k>>12&63}b[c++]=128|k>>6&63}b[c++]=128|k&63}}b[c]=0;return c-e}
function oa(a){for(var b=0,c=0;c<a.length;++c){var d=a.charCodeAt(c);55296<=d&&57343>=d&&(d=65536+((d&1023)<<10)|a.charCodeAt(++c)&1023);127>=d?++b:b=2047>=d?b+2:65535>=d?b+3:b+4}return b}"undefined"!==typeof TextDecoder&&new TextDecoder("utf-16le");function Wa(a){return a.replace(/__Z[\w\d_]+/g,function(a){return a===a?a:a+" ["+a+"]"})}function Xa(a){0<a%65536&&(a+=65536-a%65536);return a}var buffer,l,F,Ha,E,Ia,Ja;
function Ya(){f.HEAP8=l=new Int8Array(buffer);f.HEAP16=Ha=new Int16Array(buffer);f.HEAP32=E=new Int32Array(buffer);f.HEAPU8=F=new Uint8Array(buffer);f.HEAPU16=new Uint16Array(buffer);f.HEAPU32=new Uint32Array(buffer);f.HEAPF32=Ia=new Float32Array(buffer);f.HEAPF64=Ja=new Float64Array(buffer)}var Da=62736,Za=f.TOTAL_MEMORY||16777216;5242880>Za&&D("TOTAL_MEMORY should be larger than TOTAL_STACK, was "+Za+"! (TOTAL_STACK=5242880)");
f.buffer?buffer=f.buffer:"object"===typeof WebAssembly&&"function"===typeof WebAssembly.Memory?(Ma=new WebAssembly.Memory({initial:Za/65536}),buffer=Ma.buffer):buffer=new ArrayBuffer(Za);Ya();E[Da>>2]=5305872;function $a(a){for(;0<a.length;){var b=a.shift();if("function"==typeof b)b();else{var c=b.wc;"number"===typeof c?void 0===b.Kb?f.dynCall_v(c):f.dynCall_vi(c,b.Kb):c(void 0===b.Kb?null:b.Kb)}}}var ab=[],bb=[],cb=[],db=[],eb=!1;function fb(){var a=f.preRun.shift();ab.unshift(a)}
var Qa=Math.abs,Ra=Math.ceil,H=0,gb=null,hb=null;f.preloadedImages={};f.preloadedAudios={};function ib(){var a=I;return String.prototype.startsWith?a.startsWith("data:application/octet-stream;base64,"):0===a.indexOf("data:application/octet-stream;base64,")}var I="sql-wasm.wasm";if(!ib()){var jb=I;I=f.locateFile?f.locateFile(jb,B):B+jb}
function lb(){try{if(f.wasmBinary)return new Uint8Array(f.wasmBinary);if(f.readBinary)return f.readBinary(I);throw"both async and sync fetching of the wasm failed";}catch(a){C(a)}}function mb(){return f.wasmBinary||!x&&!y||"function"!==typeof fetch?new Promise(function(a){a(lb())}):fetch(I,{credentials:"same-origin"}).then(function(a){if(!a.ok)throw"failed to load wasm binary file at '"+I+"'";return a.arrayBuffer()}).catch(function(){return lb()})}
function nb(a){function b(a){f.asm=a.exports;H--;f.monitorRunDependencies&&f.monitorRunDependencies(H);0==H&&(null!==gb&&(clearInterval(gb),gb=null),hb&&(a=hb,hb=null,a()))}function c(a){b(a.instance)}function d(a){mb().then(function(a){return WebAssembly.instantiate(a,e)}).then(a,function(a){D("failed to asynchronously prepare wasm: "+a);C(a)})}var e={env:a,global:{NaN:NaN,Infinity:Infinity},"global.Math":Math,asm2wasm:Ga};H++;f.monitorRunDependencies&&f.monitorRunDependencies(H);if(f.instantiateWasm)try{return f.instantiateWasm(e,
b)}catch(g){return D("Module.instantiateWasm callback failed with error: "+g),!1}f.wasmBinary||"function"!==typeof WebAssembly.instantiateStreaming||ib()||"function"!==typeof fetch?d(c):WebAssembly.instantiateStreaming(fetch(I,{credentials:"same-origin"}),e).then(c,function(a){D("wasm streaming compile failed: "+a);D("falling back to ArrayBuffer instantiation");d(c)});return{}}
f.asm=function(a,b){b.memory=Ma;b.table=new WebAssembly.Table({initial:2688,maximum:2688,element:"anyfunc"});b.__memory_base=1024;b.__table_base=0;return nb(b)};bb.push({wc:function(){ob()}});var J={};
function sb(a){if(sb.wb){var b=E[a>>2];var c=E[b>>2]}else sb.wb=!0,J.USER=J.LOGNAME="web_user",J.PATH="/",J.PWD="/",J.HOME="/home/web_user",J.LANG="C.UTF-8",J._=f.thisProgram,c=eb?Ua(1024):Ca(1024),b=eb?Ua(256):Ca(256),E[b>>2]=c,E[a>>2]=b;a=[];var d=0,e;for(e in J)if("string"===typeof J[e]){var g=e+"="+J[e];a.push(g);d+=g.length}if(1024<d)throw Error("Environment size exceeded TOTAL_ENV_SIZE!");for(e=0;e<a.length;e++){d=g=a[e];for(var k=c,m=0;m<d.length;++m)l[k++>>0]=d.charCodeAt(m);l[k>>0]=0;E[b+
4*e>>2]=c;c+=g.length+1}E[b+4*a.length>>2]=0}function tb(a){f.___errno_location&&(E[f.___errno_location()>>2]=a);return a}function ub(a,b){for(var c=0,d=a.length-1;0<=d;d--){var e=a[d];"."===e?a.splice(d,1):".."===e?(a.splice(d,1),c++):c&&(a.splice(d,1),c--)}if(b)for(;c;c--)a.unshift("..");return a}function vb(a){var b="/"===a.charAt(0),c="/"===a.substr(-1);(a=ub(a.split("/").filter(function(a){return!!a}),!b).join("/"))||b||(a=".");a&&c&&(a+="/");return(b?"/":"")+a}
function wb(a){var b=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/.exec(a).slice(1);a=b[0];b=b[1];if(!a&&!b)return".";b&&(b=b.substr(0,b.length-1));return a+b}function xb(a){if("/"===a)return"/";var b=a.lastIndexOf("/");return-1===b?a:a.substr(b+1)}function yb(){var a=Array.prototype.slice.call(arguments,0);return vb(a.join("/"))}function n(a,b){return vb(a+"/"+b)}
function zb(){for(var a="",b=!1,c=arguments.length-1;-1<=c&&!b;c--){b=0<=c?arguments[c]:"/";if("string"!==typeof b)throw new TypeError("Arguments to path.resolve must be strings");if(!b)return"";a=b+"/"+a;b="/"===b.charAt(0)}a=ub(a.split("/").filter(function(a){return!!a}),!b).join("/");return(b?"/":"")+a||"."}var Ab=[];function Bb(a,b){Ab[a]={input:[],output:[],zb:b};Cb(a,Db)}
var Db={open:function(a){var b=Ab[a.node.rdev];if(!b)throw new K(L.Hb);a.tty=b;a.seekable=!1},close:function(a){a.tty.zb.flush(a.tty)},flush:function(a){a.tty.zb.flush(a.tty)},read:function(a,b,c,d){if(!a.tty||!a.tty.zb.bc)throw new K(L.Tb);for(var e=0,g=0;g<d;g++){try{var k=a.tty.zb.bc(a.tty)}catch(m){throw new K(L.Qb);}if(void 0===k&&0===e)throw new K(L.fc);if(null===k||void 0===k)break;e++;b[c+g]=k}e&&(a.node.timestamp=Date.now());return e},write:function(a,b,c,d){if(!a.tty||!a.tty.zb.Nb)throw new K(L.Tb);
try{for(var e=0;e<d;e++)a.tty.zb.Nb(a.tty,b[c+e])}catch(g){throw new K(L.Qb);}d&&(a.node.timestamp=Date.now());return e}},Eb={bc:function(a){if(!a.input.length){var b=null;if(A){var c=new Buffer(256),d=0,e=process.stdin.fd;if("win32"!=process.platform){var g=!1;try{e=fs.openSync("/dev/stdin","r"),g=!0}catch(k){}}try{d=fs.readSync(e,c,0,256,null)}catch(k){if(-1!=k.toString().indexOf("EOF"))d=0;else throw k;}g&&fs.closeSync(e);0<d?b=c.slice(0,d).toString("utf-8"):b=null}else"undefined"!=typeof window&&
"function"==typeof window.prompt?(b=window.prompt("Input: "),null!==b&&(b+="\n")):"function"==typeof readline&&(b=readline(),null!==b&&(b+="\n"));if(!b)return null;a.input=ba(b,!0)}return a.input.shift()},Nb:function(a,b){null===b||10===b?(Ba(v(a.output,0)),a.output=[]):0!=b&&a.output.push(b)},flush:function(a){a.output&&0<a.output.length&&(Ba(v(a.output,0)),a.output=[])}},Fb={Nb:function(a,b){null===b||10===b?(D(v(a.output,0)),a.output=[]):0!=b&&a.output.push(b)},flush:function(a){a.output&&0<a.output.length&&
(D(v(a.output,0)),a.output=[])}},M={qb:null,nb:function(){return M.createNode(null,"/",16895,0)},createNode:function(a,b,c,d){if(24576===(c&61440)||4096===(c&61440))throw new K(L.jc);M.qb||(M.qb={dir:{node:{pb:M.fb.pb,lb:M.fb.lb,lookup:M.fb.lookup,Ab:M.fb.Ab,rename:M.fb.rename,unlink:M.fb.unlink,rmdir:M.fb.rmdir,readdir:M.fb.readdir,symlink:M.fb.symlink},stream:{tb:M.hb.tb}},file:{node:{pb:M.fb.pb,lb:M.fb.lb},stream:{tb:M.hb.tb,read:M.hb.read,write:M.hb.write,Ub:M.hb.Ub,Eb:M.hb.Eb,Fb:M.hb.Fb}},link:{node:{pb:M.fb.pb,
lb:M.fb.lb,readlink:M.fb.readlink},stream:{}},Xb:{node:{pb:M.fb.pb,lb:M.fb.lb},stream:Gb}});c=Hb(a,b,c,d);N(c.mode)?(c.fb=M.qb.dir.node,c.hb=M.qb.dir.stream,c.gb={}):32768===(c.mode&61440)?(c.fb=M.qb.file.node,c.hb=M.qb.file.stream,c.kb=0,c.gb=null):40960===(c.mode&61440)?(c.fb=M.qb.link.node,c.hb=M.qb.link.stream):8192===(c.mode&61440)&&(c.fb=M.qb.Xb.node,c.hb=M.qb.Xb.stream);c.timestamp=Date.now();a&&(a.gb[b]=c);return c},lf:function(a){if(a.gb&&a.gb.subarray){for(var b=[],c=0;c<a.kb;++c)b.push(a.gb[c]);
return b}return a.gb},mf:function(a){return a.gb?a.gb.subarray?a.gb.subarray(0,a.kb):new Uint8Array(a.gb):new Uint8Array},Yb:function(a,b){var c=a.gb?a.gb.length:0;c>=b||(b=Math.max(b,c*(1048576>c?2:1.125)|0),0!=c&&(b=Math.max(b,256)),c=a.gb,a.gb=new Uint8Array(b),0<a.kb&&a.gb.set(c.subarray(0,a.kb),0))},Dc:function(a,b){if(a.kb!=b)if(0==b)a.gb=null,a.kb=0;else{if(!a.gb||a.gb.subarray){var c=a.gb;a.gb=new Uint8Array(new ArrayBuffer(b));c&&a.gb.set(c.subarray(0,Math.min(b,a.kb)))}else if(a.gb||(a.gb=
[]),a.gb.length>b)a.gb.length=b;else for(;a.gb.length<b;)a.gb.push(0);a.kb=b}},fb:{pb:function(a){var b={};b.dev=8192===(a.mode&61440)?a.id:1;b.ino=a.id;b.mode=a.mode;b.nlink=1;b.uid=0;b.gid=0;b.rdev=a.rdev;N(a.mode)?b.size=4096:32768===(a.mode&61440)?b.size=a.kb:40960===(a.mode&61440)?b.size=a.link.length:b.size=0;b.atime=new Date(a.timestamp);b.mtime=new Date(a.timestamp);b.ctime=new Date(a.timestamp);b.ub=4096;b.blocks=Math.ceil(b.size/b.ub);return b},lb:function(a,b){void 0!==b.mode&&(a.mode=
b.mode);void 0!==b.timestamp&&(a.timestamp=b.timestamp);void 0!==b.size&&M.Dc(a,b.size)},lookup:function(){throw Ib[L.hc];},Ab:function(a,b,c,d){return M.createNode(a,b,c,d)},rename:function(a,b,c){if(N(a.mode)){try{var d=O(b,c)}catch(g){}if(d)for(var e in d.gb)throw new K(L.Sb);}delete a.parent.gb[a.name];a.name=c;b.gb[c]=a;a.parent=b},unlink:function(a,b){delete a.gb[b]},rmdir:function(a,b){var c=O(a,b),d;for(d in c.gb)throw new K(L.Sb);delete a.gb[b]},readdir:function(a){var b=[".",".."],c;for(c in a.gb)a.gb.hasOwnProperty(c)&&
b.push(c);return b},symlink:function(a,b,c){a=M.createNode(a,b,41471,0);a.link=c;return a},readlink:function(a){if(40960!==(a.mode&61440))throw new K(L.mb);return a.link}},hb:{read:function(a,b,c,d,e){var g=a.node.gb;if(e>=a.node.kb)return 0;a=Math.min(a.node.kb-e,d);if(8<a&&g.subarray)b.set(g.subarray(e,e+a),c);else for(d=0;d<a;d++)b[c+d]=g[e+d];return a},write:function(a,b,c,d,e,g){g=!1;if(!d)return 0;a=a.node;a.timestamp=Date.now();if(b.subarray&&(!a.gb||a.gb.subarray)){if(g)return a.gb=b.subarray(c,
c+d),a.kb=d;if(0===a.kb&&0===e)return a.gb=new Uint8Array(b.subarray(c,c+d)),a.kb=d;if(e+d<=a.kb)return a.gb.set(b.subarray(c,c+d),e),d}M.Yb(a,e+d);if(a.gb.subarray&&b.subarray)a.gb.set(b.subarray(c,c+d),e);else for(g=0;g<d;g++)a.gb[e+g]=b[c+g];a.kb=Math.max(a.kb,e+d);return d},tb:function(a,b,c){1===c?b+=a.position:2===c&&32768===(a.node.mode&61440)&&(b+=a.node.kb);if(0>b)throw new K(L.mb);return b},Ub:function(a,b,c){M.Yb(a.node,b+c);a.node.kb=Math.max(a.node.kb,b+c)},Eb:function(a,b,c,d,e,g,k){if(32768!==
(a.node.mode&61440))throw new K(L.Hb);c=a.node.gb;if(k&2||c.buffer!==b&&c.buffer!==b.buffer){if(0<e||e+d<a.node.kb)c.subarray?c=c.subarray(e,e+d):c=Array.prototype.slice.call(c,e,e+d);a=!0;d=Ua(d);if(!d)throw new K(L.Rb);b.set(c,d)}else a=!1,d=c.byteOffset;return{Cc:d,Ib:a}},Fb:function(a,b,c,d,e){if(32768!==(a.node.mode&61440))throw new K(L.Hb);if(e&2)return 0;M.hb.write(a,b,0,d,c,!1);return 0}}},P={Db:!1,Fc:function(){P.Db=!!process.platform.match(/^win/);var a=process.binding("constants");a.fs&&
(a=a.fs);P.Zb={1024:a.O_APPEND,64:a.O_CREAT,128:a.O_EXCL,0:a.O_RDONLY,2:a.O_RDWR,4096:a.O_SYNC,512:a.O_TRUNC,1:a.O_WRONLY}},Wb:function(a){return Buffer.wb?Buffer.from(a):new Buffer(a)},nb:function(a){assert(A);return P.createNode(null,"/",P.ac(a.Mb.root),0)},createNode:function(a,b,c){if(!N(c)&&32768!==(c&61440)&&40960!==(c&61440))throw new K(L.mb);a=Hb(a,b,c);a.fb=P.fb;a.hb=P.hb;return a},ac:function(a){try{var b=fs.lstatSync(a);P.Db&&(b.mode=b.mode|(b.mode&292)>>2)}catch(c){if(!c.code)throw c;
throw new K(L[c.code]);}return b.mode},ob:function(a){for(var b=[];a.parent!==a;)b.push(a.name),a=a.parent;b.push(a.nb.Mb.root);b.reverse();return yb.apply(null,b)},vc:function(a){a&=-2656257;var b=0,c;for(c in P.Zb)a&c&&(b|=P.Zb[c],a^=c);if(a)throw new K(L.mb);return b},fb:{pb:function(a){a=P.ob(a);try{var b=fs.lstatSync(a)}catch(c){if(!c.code)throw c;throw new K(L[c.code]);}P.Db&&!b.ub&&(b.ub=4096);P.Db&&!b.blocks&&(b.blocks=(b.size+b.ub-1)/b.ub|0);return{dev:b.dev,ino:b.ino,mode:b.mode,nlink:b.nlink,
uid:b.uid,gid:b.gid,rdev:b.rdev,size:b.size,atime:b.atime,mtime:b.mtime,ctime:b.ctime,ub:b.ub,blocks:b.blocks}},lb:function(a,b){var c=P.ob(a);try{void 0!==b.mode&&(fs.chmodSync(c,b.mode),a.mode=b.mode),void 0!==b.size&&fs.truncateSync(c,b.size)}catch(d){if(!d.code)throw d;throw new K(L[d.code]);}},lookup:function(a,b){var c=n(P.ob(a),b);c=P.ac(c);return P.createNode(a,b,c)},Ab:function(a,b,c,d){a=P.createNode(a,b,c,d);b=P.ob(a);try{N(a.mode)?fs.mkdirSync(b,a.mode):fs.writeFileSync(b,"",{mode:a.mode})}catch(e){if(!e.code)throw e;
throw new K(L[e.code]);}return a},rename:function(a,b,c){a=P.ob(a);b=n(P.ob(b),c);try{fs.renameSync(a,b)}catch(d){if(!d.code)throw d;throw new K(L[d.code]);}},unlink:function(a,b){a=n(P.ob(a),b);try{fs.unlinkSync(a)}catch(c){if(!c.code)throw c;throw new K(L[c.code]);}},rmdir:function(a,b){a=n(P.ob(a),b);try{fs.rmdirSync(a)}catch(c){if(!c.code)throw c;throw new K(L[c.code]);}},readdir:function(a){a=P.ob(a);try{return fs.readdirSync(a)}catch(b){if(!b.code)throw b;throw new K(L[b.code]);}},symlink:function(a,
b,c){a=n(P.ob(a),b);try{fs.symlinkSync(c,a)}catch(d){if(!d.code)throw d;throw new K(L[d.code]);}},readlink:function(a){var b=P.ob(a);try{return b=fs.readlinkSync(b),b=Jb.relative(Jb.resolve(a.nb.Mb.root),b)}catch(c){if(!c.code)throw c;throw new K(L[c.code]);}}},hb:{open:function(a){var b=P.ob(a.node);try{32768===(a.node.mode&61440)&&(a.Bb=fs.openSync(b,P.vc(a.flags)))}catch(c){if(!c.code)throw c;throw new K(L[c.code]);}},close:function(a){try{32768===(a.node.mode&61440)&&a.Bb&&fs.closeSync(a.Bb)}catch(b){if(!b.code)throw b;
throw new K(L[b.code]);}},read:function(a,b,c,d,e){if(0===d)return 0;try{return fs.readSync(a.Bb,P.Wb(b.buffer),c,d,e)}catch(g){throw new K(L[g.code]);}},write:function(a,b,c,d,e){try{return fs.writeSync(a.Bb,P.Wb(b.buffer),c,d,e)}catch(g){throw new K(L[g.code]);}},tb:function(a,b,c){if(1===c)b+=a.position;else if(2===c&&32768===(a.node.mode&61440))try{b+=fs.fstatSync(a.Bb).size}catch(d){throw new K(L[d.code]);}if(0>b)throw new K(L.mb);return b}}},Kb=null,Lb={},Q=[],Mb=1,R=null,Nb=!0,S={},K=null,
Ib={};function T(a,b){a=zb("/",a);b=b||{};if(!a)return{path:"",node:null};var c={$b:!0,Ob:0},d;for(d in c)void 0===b[d]&&(b[d]=c[d]);if(8<b.Ob)throw new K(40);a=ub(a.split("/").filter(function(a){return!!a}),!1);var e=Kb;c="/";for(d=0;d<a.length;d++){var g=d===a.length-1;if(g&&b.parent)break;e=O(e,a[d]);c=n(c,a[d]);e.xb&&(!g||g&&b.$b)&&(e=e.xb.root);if(!g||b.vb)for(g=0;40960===(e.mode&61440);)if(e=Ob(c),c=zb(wb(c),e),e=T(c,{Ob:b.Ob}).node,40<g++)throw new K(40);}return{path:c,node:e}}
function Pb(a){for(var b;;){if(a===a.parent)return a=a.nb.cc,b?"/"!==a[a.length-1]?a+"/"+b:a+b:a;b=b?a.name+"/"+b:a.name;a=a.parent}}function Qb(a,b){for(var c=0,d=0;d<b.length;d++)c=(c<<5)-c+b.charCodeAt(d)|0;return(a+c>>>0)%R.length}function Rb(a){var b=Qb(a.parent.id,a.name);a.yb=R[b];R[b]=a}function Sb(a){var b=Qb(a.parent.id,a.name);if(R[b]===a)R[b]=a.yb;else for(b=R[b];b;){if(b.yb===a){b.yb=a.yb;break}b=b.yb}}
function O(a,b){var c;if(c=(c=Tb(a,"x"))?c:a.fb.lookup?0:13)throw new K(c,a);for(c=R[Qb(a.id,b)];c;c=c.yb){var d=c.name;if(c.parent.id===a.id&&d===b)return c}return a.fb.lookup(a,b)}
function Hb(a,b,c,d){Ub||(Ub=function(a,b,c,d){a||(a=this);this.parent=a;this.nb=a.nb;this.xb=null;this.id=Mb++;this.name=b;this.mode=c;this.fb={};this.hb={};this.rdev=d},Ub.prototype={},Object.defineProperties(Ub.prototype,{read:{get:function(){return 365===(this.mode&365)},set:function(a){a?this.mode|=365:this.mode&=-366}},write:{get:function(){return 146===(this.mode&146)},set:function(a){a?this.mode|=146:this.mode&=-147}}}));a=new Ub(a,b,c,d);Rb(a);return a}
function N(a){return 16384===(a&61440)}var Vb={r:0,rs:1052672,"r+":2,w:577,wx:705,xw:705,"w+":578,"wx+":706,"xw+":706,a:1089,ax:1217,xa:1217,"a+":1090,"ax+":1218,"xa+":1218};function Wb(a){var b=["r","w","rw"][a&3];a&512&&(b+="w");return b}function Tb(a,b){if(Nb)return 0;if(-1===b.indexOf("r")||a.mode&292){if(-1!==b.indexOf("w")&&!(a.mode&146)||-1!==b.indexOf("x")&&!(a.mode&73))return 13}else return 13;return 0}function mc(a,b){try{return O(a,b),17}catch(c){}return Tb(a,"wx")}
function xc(a,b,c){try{var d=O(a,b)}catch(e){return e.ib}if(a=Tb(a,"wx"))return a;if(c){if(!N(d.mode))return 20;if(d===d.parent||"/"===Pb(d))return 16}else if(N(d.mode))return 21;return 0}function yc(a){var b=4096;for(a=a||0;a<=b;a++)if(!Q[a])return a;throw new K(24);}
function zc(a,b){Ac||(Ac=function(){},Ac.prototype={},Object.defineProperties(Ac.prototype,{object:{get:function(){return this.node},set:function(a){this.node=a}}}));var c=new Ac,d;for(d in a)c[d]=a[d];a=c;b=yc(b);a.fd=b;return Q[b]=a}var Gb={open:function(a){a.hb=Lb[a.node.rdev].hb;a.hb.open&&a.hb.open(a)},tb:function(){throw new K(29);}};function Cb(a,b){Lb[a]={hb:b}}
function Bc(a,b){var c="/"===b,d=!b;if(c&&Kb)throw new K(16);if(!c&&!d){var e=T(b,{$b:!1});b=e.path;e=e.node;if(e.xb)throw new K(16);if(!N(e.mode))throw new K(20);}b={type:a,Mb:{},cc:b,Bc:[]};a=a.nb(b);a.nb=b;b.root=a;c?Kb=a:e&&(e.xb=b,e.nb&&e.nb.Bc.push(b))}function ja(a,b,c){var d=T(a,{parent:!0}).node;a=xb(a);if(!a||"."===a||".."===a)throw new K(22);var e=mc(d,a);if(e)throw new K(e);if(!d.fb.Ab)throw new K(1);return d.fb.Ab(d,a,b,c)}function U(a,b){ja(a,(void 0!==b?b:511)&1023|16384,0)}
function Cc(a,b,c){"undefined"===typeof c&&(c=b,b=438);ja(a,b|8192,c)}function Dc(a,b){if(!zb(a))throw new K(2);var c=T(b,{parent:!0}).node;if(!c)throw new K(2);b=xb(b);var d=mc(c,b);if(d)throw new K(d);if(!c.fb.symlink)throw new K(1);c.fb.symlink(c,b,a)}
function ua(a){var b=T(a,{parent:!0}).node,c=xb(a),d=O(b,c),e=xc(b,c,!1);if(e)throw new K(e);if(!b.fb.unlink)throw new K(1);if(d.xb)throw new K(16);try{S.willDeletePath&&S.willDeletePath(a)}catch(g){console.log("FS.trackingDelegate['willDeletePath']('"+a+"') threw an exception: "+g.message)}b.fb.unlink(b,c);Sb(d);try{if(S.onDeletePath)S.onDeletePath(a)}catch(g){console.log("FS.trackingDelegate['onDeletePath']('"+a+"') threw an exception: "+g.message)}}
function Ob(a){a=T(a).node;if(!a)throw new K(2);if(!a.fb.readlink)throw new K(22);return zb(Pb(a.parent),a.fb.readlink(a))}function sa(a,b){a=T(a,{vb:!b}).node;if(!a)throw new K(2);if(!a.fb.pb)throw new K(1);return a.fb.pb(a)}function Ec(a){return sa(a,!0)}function ka(a,b){var c;"string"===typeof a?c=T(a,{vb:!0}).node:c=a;if(!c.fb.lb)throw new K(1);c.fb.lb(c,{mode:b&4095|c.mode&-4096,timestamp:Date.now()})}
function Fc(a){var b;"string"===typeof a?b=T(a,{vb:!0}).node:b=a;if(!b.fb.lb)throw new K(1);b.fb.lb(b,{timestamp:Date.now()})}function Gc(a,b){if(0>b)throw new K(22);var c;"string"===typeof a?c=T(a,{vb:!0}).node:c=a;if(!c.fb.lb)throw new K(1);if(N(c.mode))throw new K(21);if(32768!==(c.mode&61440))throw new K(22);if(a=Tb(c,"w"))throw new K(a);c.fb.lb(c,{size:b,timestamp:Date.now()})}
function p(a,b,c,d){if(""===a)throw new K(2);if("string"===typeof b){var e=Vb[b];if("undefined"===typeof e)throw Error("Unknown file open mode: "+b);b=e}c=b&64?("undefined"===typeof c?438:c)&4095|32768:0;if("object"===typeof a)var g=a;else{a=vb(a);try{g=T(a,{vb:!(b&131072)}).node}catch(k){}}e=!1;if(b&64)if(g){if(b&128)throw new K(17);}else g=ja(a,c,0),e=!0;if(!g)throw new K(2);8192===(g.mode&61440)&&(b&=-513);if(b&65536&&!N(g.mode))throw new K(20);if(!e&&(c=g?40960===(g.mode&61440)?40:N(g.mode)&&
("r"!==Wb(b)||b&512)?21:Tb(g,Wb(b)):2))throw new K(c);b&512&&Gc(g,0);b&=-641;d=zc({node:g,path:Pb(g),flags:b,seekable:!0,position:0,hb:g.hb,Gc:[],error:!1},d);d.hb.open&&d.hb.open(d);!f.logReadFiles||b&1||(Hc||(Hc={}),a in Hc||(Hc[a]=1,console.log("FS.trackingDelegate error on read file: "+a)));try{S.onOpenFile&&(g=0,1!==(b&2097155)&&(g|=1),0!==(b&2097155)&&(g|=2),S.onOpenFile(a,g))}catch(k){console.log("FS.trackingDelegate['onOpenFile']('"+a+"', flags) threw an exception: "+k.message)}return d}
function ma(a){if(null===a.fd)throw new K(9);a.Lb&&(a.Lb=null);try{a.hb.close&&a.hb.close(a)}catch(b){throw b;}finally{Q[a.fd]=null}a.fd=null}function Ic(a,b,c){if(null===a.fd)throw new K(9);if(!a.seekable||!a.hb.tb)throw new K(29);if(0!=c&&1!=c&&2!=c)throw new K(22);a.position=a.hb.tb(a,b,c);a.Gc=[]}
function ta(a,b,c,d,e){if(0>d||0>e)throw new K(22);if(null===a.fd)throw new K(9);if(1===(a.flags&2097155))throw new K(9);if(N(a.node.mode))throw new K(21);if(!a.hb.read)throw new K(22);var g="undefined"!==typeof e;if(!g)e=a.position;else if(!a.seekable)throw new K(29);b=a.hb.read(a,b,c,d,e);g||(a.position+=b);return b}
function la(a,b,c,d,e,g){if(0>d||0>e)throw new K(22);if(null===a.fd)throw new K(9);if(0===(a.flags&2097155))throw new K(9);if(N(a.node.mode))throw new K(21);if(!a.hb.write)throw new K(22);a.flags&1024&&Ic(a,0,2);var k="undefined"!==typeof e;if(!k)e=a.position;else if(!a.seekable)throw new K(29);b=a.hb.write(a,b,c,d,e,g);k||(a.position+=b);try{if(a.path&&S.onWriteToFile)S.onWriteToFile(a.path)}catch(m){console.log("FS.trackingDelegate['onWriteToFile']('"+a.path+"') threw an exception: "+m.message)}return b}
function Jc(){K||(K=function(a,b){this.node=b;this.Ec=function(a){this.ib=a};this.Ec(a);this.message="FS error";this.stack&&Object.defineProperty(this,"stack",{value:Error().stack,writable:!0})},K.prototype=Error(),K.prototype.constructor=K,[2].forEach(function(a){Ib[a]=new K(a);Ib[a].stack="<generic error, no stack>"}))}var Kc;function ia(a,b){var c=0;a&&(c|=365);b&&(c|=146);return c}
function Lc(a,b,c){a=n("/dev",a);var d=ia(!!b,!!c);Mc||(Mc=64);var e=Mc++<<8|0;Cb(e,{open:function(a){a.seekable=!1},close:function(){c&&c.buffer&&c.buffer.length&&c(10)},read:function(a,c,d,e){for(var g=0,k=0;k<e;k++){try{var m=b()}catch(La){throw new K(5);}if(void 0===m&&0===g)throw new K(11);if(null===m||void 0===m)break;g++;c[d+k]=m}g&&(a.node.timestamp=Date.now());return g},write:function(a,b,d,e){for(var g=0;g<e;g++)try{c(b[d+g])}catch(ha){throw new K(5);}e&&(a.node.timestamp=Date.now());return g}});
Cc(a,d,e)}
var Mc,V={},Ub,Ac,Hc,L={jc:1,hc:2,Fe:3,xd:4,Qb:5,Tb:6,Nc:7,Yd:8,Pb:9,bd:10,fc:11,Pe:11,Rb:12,ec:13,qd:14,je:15,$c:16,pd:17,Qe:18,Hb:19,ic:20,zd:21,mb:22,Td:23,Ld:24,oe:25,Me:26,rd:27,fe:28,Ee:29,Ae:30,Md:31,ue:32,md:33,kc:34,be:42,ud:43,cd:44,Bd:45,Cd:46,Dd:47,Jd:48,Ne:49,Wd:50,Ad:51,jd:35,Zd:37,Tc:52,Wc:53,Re:54,Ud:55,Xc:56,Yc:57,kd:35,Zc:59,he:60,Xd:61,Je:62,ge:63,ce:64,de:65,ze:66,$d:67,Qc:68,Ge:69,dd:70,ve:71,Od:72,nd:73,Vc:74,pe:76,Uc:77,ye:78,Ed:79,Fd:80,Id:81,Hd:82,Gd:83,ie:38,Sb:39,Pd:36,
Kd:40,qe:95,te:96,hd:104,Vd:105,Rc:97,xe:91,me:88,ee:92,Ce:108,gd:111,Oc:98,ed:103,Sd:101,Qd:100,Ke:110,sd:112,td:113,wd:115,Sc:114,ld:89,Nd:90,we:93,De:94,Pc:99,Rd:102,yd:106,ke:107,Le:109,Oe:87,od:122,He:116,ne:95,ae:123,vd:84,re:75,ad:125,le:131,se:130,Ie:86},Nc={};
function Oc(a,b,c){try{var d=a(b)}catch(e){if(e&&e.node&&vb(b)!==vb(Pb(e.node)))return-L.ic;throw e;}E[c>>2]=d.dev;E[c+4>>2]=0;E[c+8>>2]=d.ino;E[c+12>>2]=d.mode;E[c+16>>2]=d.nlink;E[c+20>>2]=d.uid;E[c+24>>2]=d.gid;E[c+28>>2]=d.rdev;E[c+32>>2]=0;E[c+36>>2]=d.size;E[c+40>>2]=4096;E[c+44>>2]=d.blocks;E[c+48>>2]=d.atime.getTime()/1E3|0;E[c+52>>2]=0;E[c+56>>2]=d.mtime.getTime()/1E3|0;E[c+60>>2]=0;E[c+64>>2]=d.ctime.getTime()/1E3|0;E[c+68>>2]=0;E[c+72>>2]=d.ino;return 0}var W=0;
function X(){W+=4;return E[W-4>>2]}function Y(){return G(X())}function Z(){var a=Q[X()];if(!a)throw new K(L.Pb);return a}function Ea(){return l.length}function Fa(a){if(2147418112<a)return!1;for(var b=Math.max(Ea(),16777216);b<a;)536870912>=b?b=Xa(2*b):b=Math.min(Xa((3*b+2147483648)/4),2147418112);a=Xa(b);var c=buffer.byteLength;try{var d=-1!==Ma.grow((a-c)/65536)?buffer=Ma.buffer:null}catch(e){d=null}if(!d||d.byteLength!=b)return!1;Ya();return!0}
function Pc(a){if(0===a)return 0;a=G(a);if(!J.hasOwnProperty(a))return 0;Pc.wb&&fa(Pc.wb);a=J[a];var b=oa(a)+1,c=Ua(b);c&&r(a,l,c,b);Pc.wb=c;return Pc.wb}r("GMT",F,62880,4);
function Qc(){function a(a){return(a=a.toTimeString().match(/\(([A-Za-z ]+)\)$/))?a[1]:"GMT"}if(!Rc){Rc=!0;E[Sc()>>2]=60*(new Date).getTimezoneOffset();var b=new Date(2E3,0,1),c=new Date(2E3,6,1);E[Tc()>>2]=Number(b.getTimezoneOffset()!=c.getTimezoneOffset());var d=a(b),e=a(c);d=ca(ba(d));e=ca(ba(e));c.getTimezoneOffset()<b.getTimezoneOffset()?(E[Uc()>>2]=d,E[Uc()+4>>2]=e):(E[Uc()>>2]=e,E[Uc()+4>>2]=d)}}var Rc;
function Vc(a){a/=1E3;if((x||y)&&self.performance&&self.performance.now)for(var b=self.performance.now();self.performance.now()-b<a;);else for(b=Date.now();Date.now()-b<a;);return 0}f._usleep=Vc;Jc();R=Array(4096);Bc(M,"/");U("/tmp");U("/home");U("/home/web_user");
(function(){U("/dev");Cb(259,{read:function(){return 0},write:function(a,b,c,k){return k}});Cc("/dev/null",259);Bb(1280,Eb);Bb(1536,Fb);Cc("/dev/tty",1280);Cc("/dev/tty1",1536);if("object"===typeof crypto&&"function"===typeof crypto.getRandomValues){var a=new Uint8Array(1);var b=function(){crypto.getRandomValues(a);return a[0]}}else if(A)try{var c=require("crypto");b=function(){return c.randomBytes(1)[0]}}catch(d){}b||(b=function(){C("random_device")});Lc("random",b);Lc("urandom",b);U("/dev/shm");
U("/dev/shm/tmp")})();U("/proc");U("/proc/self");U("/proc/self/fd");Bc({nb:function(){var a=Hb("/proc/self","fd",16895,73);a.fb={lookup:function(a,c){var b=Q[+c];if(!b)throw new K(9);a={parent:null,nb:{cc:"fake"},fb:{readlink:function(){return b.path}}};return a.parent=a}};return a}},"/proc/self/fd");if(A){var fs=require("fs"),Jb=require("path");P.Fc()}function ba(a,b){var c=Array(oa(a)+1);a=r(a,c,0,c.length);b&&(c.length=a);return c}
var Yc=f.asm({},{n:C,l:function(a){return t[a]()},i:function(a,b){return t[a](b)},h:function(a,b,c){return t[a](b,c)},g:function(a,b,c,d){return t[a](b,c,d)},f:function(a,b,c,d,e){return t[a](b,c,d,e)},e:function(a,b,c,d,e,g){return t[a](b,c,d,e,g)},d:function(a,b,c,d,e,g,k){return t[a](b,c,d,e,g,k)},C:function(a,b,c,d,e){return t[a](b,c,d,e)},B:function(a,b,c){return t[a](b,c)},A:function(a,b,c,d){return t[a](b,c,d)},z:function(a,b,c,d,e){return t[a](b,c,d,e)},y:function(a,b,c,d){return t[a](b,c,
d)},c:function(a,b){t[a](b)},b:function(a,b,c){t[a](b,c)},k:function(a,b,c,d){t[a](b,c,d)},j:function(a,b,c,d,e){t[a](b,c,d,e)},x:function(a,b,c,d,e,g){t[a](b,c,d,e,g)},w:function(a,b,c,d){t[a](b,c,d)},v:function(a,b,c,d){t[a](b,c,d)},m:function(a,b,c,d){C("Assertion failed: "+G(a)+", at: "+[b?G(b):"unknown filename",c,d?G(d):"unknown function"])},ha:sb,u:tb,ga:function(a,b){W=b;try{var c=Y();ua(c);return 0}catch(d){return"undefined"!==typeof V&&d instanceof K||C(d),-d.ib}},fa:function(a,b){W=b;try{return Z(),
0}catch(c){return"undefined"!==typeof V&&c instanceof K||C(c),-c.ib}},ea:function(a,b){W=b;try{var c=Z();X();var d=X(),e=X(),g=X();Ic(c,d,g);E[e>>2]=c.position;c.Lb&&0===d&&0===g&&(c.Lb=null);return 0}catch(k){return"undefined"!==typeof V&&k instanceof K||C(k),-k.ib}},da:function(a,b){W=b;try{var c=Y(),d=X();ka(c,d);return 0}catch(e){return"undefined"!==typeof V&&e instanceof K||C(e),-e.ib}},ca:function(a,b){W=b;try{var c=X(),d=X();if(0===d)return-L.mb;if(d<oa("/")+1)return-L.kc;r("/",F,c,d);return c}catch(e){return"undefined"!==
typeof V&&e instanceof K||C(e),-e.ib}},ba:function(a,b){W=b;try{var c=X(),d=X(),e=X(),g=X(),k=X(),m=X();m<<=12;a=!1;if(-1===k){var u=Wc(16384,d);if(!u)return-L.Rb;Xc(u,0,d);a=!0}else{var z=Q[k];if(!z)return-L.Pb;b=F;if(1===(z.flags&2097155))throw new K(13);if(!z.hb.Eb)throw new K(19);var ha=z.hb.Eb(z,b,c,d,m,e,g);u=ha.Cc;a=ha.Ib}Nc[u]={Ac:u,zc:d,Ib:a,fd:k,flags:g};return u}catch(da){return"undefined"!==typeof V&&da instanceof K||C(da),-da.ib}},aa:function(a,b){W=b;try{var c=X();X();var d=X();X();
var e=Q[c];if(!e)throw new K(9);if(0===(e.flags&2097155))throw new K(22);Gc(e.node,d);return 0}catch(g){return"undefined"!==typeof V&&g instanceof K||C(g),-g.ib}},t:function(a,b){W=b;try{var c=Y(),d=X();return Oc(sa,c,d)}catch(e){return"undefined"!==typeof V&&e instanceof K||C(e),-e.ib}},$:function(a,b){W=b;try{var c=Y(),d=X();return Oc(Ec,c,d)}catch(e){return"undefined"!==typeof V&&e instanceof K||C(e),-e.ib}},_:function(a,b){W=b;try{var c=Z(),d=X();return Oc(sa,c.path,d)}catch(e){return"undefined"!==
typeof V&&e instanceof K||C(e),-e.ib}},Z:function(a,b){W=b;return 42},Y:function(a,b){W=b;return 0},X:function(a,b){W=b;try{var c=X();X();X();var d=Q[c];if(!d)throw new K(9);Fc(d.node);return 0}catch(e){return"undefined"!==typeof V&&e instanceof K||C(e),-e.ib}},W:function(a,b){W=b;try{var c=Y();X();X();Fc(c);return 0}catch(d){return"undefined"!==typeof V&&d instanceof K||C(d),-d.ib}},o:function(a,b){W=b;try{var c=Z();switch(X()){case 0:var d=X();return 0>d?-L.mb:p(c.path,c.flags,0,d).fd;case 1:case 2:return 0;
case 3:return c.flags;case 4:return d=X(),c.flags|=d,0;case 12:return d=X(),Ha[d+0>>1]=2,0;case 13:case 14:return 0;case 16:case 8:return-L.mb;case 9:return tb(L.mb),-1;default:return-L.mb}}catch(e){return"undefined"!==typeof V&&e instanceof K||C(e),-e.ib}},V:function(a,b){W=b;try{var c=Z(),d=X(),e=X();return ta(c,l,d,e)}catch(g){return"undefined"!==typeof V&&g instanceof K||C(g),-g.ib}},U:function(a,b){W=b;try{var c=Y();var d=X();if(d&-8)var e=-L.mb;else{var g=T(c,{vb:!0}).node;a="";d&4&&(a+="r");
d&2&&(a+="w");d&1&&(a+="x");e=a&&Tb(g,a)?-L.ec:0}return e}catch(k){return"undefined"!==typeof V&&k instanceof K||C(k),-k.ib}},T:function(a,b){W=b;try{var c=Y(),d=X();a=c;a=vb(a);"/"===a[a.length-1]&&(a=a.substr(0,a.length-1));U(a,d);return 0}catch(e){return"undefined"!==typeof V&&e instanceof K||C(e),-e.ib}},S:function(a,b){W=b;try{var c=Z(),d=X(),e=X();return la(c,l,d,e)}catch(g){return"undefined"!==typeof V&&g instanceof K||C(g),-g.ib}},R:function(a,b){W=b;try{var c=Y(),d=T(c,{parent:!0}).node,
e=xb(c),g=O(d,e),k=xc(d,e,!0);if(k)throw new K(k);if(!d.fb.rmdir)throw new K(1);if(g.xb)throw new K(16);try{S.willDeletePath&&S.willDeletePath(c)}catch(m){console.log("FS.trackingDelegate['willDeletePath']('"+c+"') threw an exception: "+m.message)}d.fb.rmdir(d,e);Sb(g);try{if(S.onDeletePath)S.onDeletePath(c)}catch(m){console.log("FS.trackingDelegate['onDeletePath']('"+c+"') threw an exception: "+m.message)}return 0}catch(m){return"undefined"!==typeof V&&m instanceof K||C(m),-m.ib}},Q:function(a,b){W=
b;try{var c=Y(),d=X(),e=X();return p(c,d,e).fd}catch(g){return"undefined"!==typeof V&&g instanceof K||C(g),-g.ib}},s:function(a,b){W=b;try{var c=Z();ma(c);return 0}catch(d){return"undefined"!==typeof V&&d instanceof K||C(d),-d.ib}},P:function(a,b){W=b;try{var c=Y(),d=X();var e=X();if(0>=e)var g=-L.mb;else{var k=Ob(c),m=Math.min(e,oa(k)),u=l[d+m];r(k,F,d,e+1);l[d+m]=u;g=m}return g}catch(z){return"undefined"!==typeof V&&z instanceof K||C(z),-z.ib}},O:function(a,b){W=b;try{var c=X(),d=X(),e=Nc[c];if(!e)return 0;
if(d===e.zc){var g=Q[e.fd],k=e.flags,m=new Uint8Array(F.subarray(c,c+d));g&&g.hb.Fb&&g.hb.Fb(g,m,0,d,k);Nc[c]=null;e.Ib&&fa(e.Ac)}return 0}catch(u){return"undefined"!==typeof V&&u instanceof K||C(u),-u.ib}},N:function(a,b){W=b;try{var c=X(),d=X(),e=Q[c];if(!e)throw new K(9);ka(e.node,d);return 0}catch(g){return"undefined"!==typeof V&&g instanceof K||C(g),-g.ib}},M:Ea,L:function(a,b,c){F.set(F.subarray(b,b+c),a)},K:Fa,r:Pc,q:function(a){var b=Date.now();E[a>>2]=b/1E3|0;E[a+4>>2]=b%1E3*1E3|0;return 0},
J:function(a){return Math.log(a)/Math.LN10},p:function(){C("trap!")},I:function(a){Qc();a=new Date(1E3*E[a>>2]);E[15708]=a.getSeconds();E[15709]=a.getMinutes();E[15710]=a.getHours();E[15711]=a.getDate();E[15712]=a.getMonth();E[15713]=a.getFullYear()-1900;E[15714]=a.getDay();var b=new Date(a.getFullYear(),0,1);E[15715]=(a.getTime()-b.getTime())/864E5|0;E[15717]=-(60*a.getTimezoneOffset());var c=(new Date(2E3,6,1)).getTimezoneOffset();b=b.getTimezoneOffset();a=(c!=b&&a.getTimezoneOffset()==Math.min(b,
c))|0;E[15716]=a;a=E[Uc()+(a?4:0)>>2];E[15718]=a;return 62832},H:function(a,b){var c=E[a>>2];a=E[a+4>>2];0!==b&&(E[b>>2]=0,E[b+4>>2]=0);return Vc(1E6*c+a/1E3)},G:function(a){switch(a){case 30:return 16384;case 85:return 131068;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;
case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;
case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1E3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:return"object"===typeof navigator?navigator.hardwareConcurrency||1:1}tb(22);return-1},
F:function(a){var b=Date.now()/1E3|0;a&&(E[a>>2]=b);return b},E:function(a,b){if(b){var c=1E3*E[b+8>>2];c+=E[b+12>>2]/1E3}else c=Date.now();a=G(a);try{b=c;var d=T(a,{vb:!0}).node;d.fb.lb(d,{timestamp:Math.max(b,c)});return 0}catch(e){a=e;if(!(a instanceof K)){a+=" : ";a:{d=Error();if(!d.stack){try{throw Error(0);}catch(g){d=g}if(!d.stack){d="(no stack trace available)";break a}}d=d.stack.toString()}f.extraStackTrace&&(d+="\n"+f.extraStackTrace());d=Wa(d);throw a+d;}tb(a.ib);return-1}},D:function(){C("OOM")},
a:Da},buffer);f.asm=Yc;f._RegisterExtensionFunctions=function(){return f.asm.ia.apply(null,arguments)};var ob=f.___emscripten_environ_constructor=function(){return f.asm.ja.apply(null,arguments)};f.___errno_location=function(){return f.asm.ka.apply(null,arguments)};
var Tc=f.__get_daylight=function(){return f.asm.la.apply(null,arguments)},Sc=f.__get_timezone=function(){return f.asm.ma.apply(null,arguments)},Uc=f.__get_tzname=function(){return f.asm.na.apply(null,arguments)},fa=f._free=function(){return f.asm.oa.apply(null,arguments)},Ua=f._malloc=function(){return f.asm.pa.apply(null,arguments)},Wc=f._memalign=function(){return f.asm.qa.apply(null,arguments)},Xc=f._memset=function(){return f.asm.ra.apply(null,arguments)};
f._sqlite3_bind_blob=function(){return f.asm.sa.apply(null,arguments)};f._sqlite3_bind_double=function(){return f.asm.ta.apply(null,arguments)};f._sqlite3_bind_int=function(){return f.asm.ua.apply(null,arguments)};f._sqlite3_bind_parameter_index=function(){return f.asm.va.apply(null,arguments)};f._sqlite3_bind_text=function(){return f.asm.wa.apply(null,arguments)};f._sqlite3_changes=function(){return f.asm.xa.apply(null,arguments)};f._sqlite3_clear_bindings=function(){return f.asm.ya.apply(null,arguments)};
f._sqlite3_close_v2=function(){return f.asm.za.apply(null,arguments)};f._sqlite3_column_blob=function(){return f.asm.Aa.apply(null,arguments)};f._sqlite3_column_bytes=function(){return f.asm.Ba.apply(null,arguments)};f._sqlite3_column_double=function(){return f.asm.Ca.apply(null,arguments)};f._sqlite3_column_name=function(){return f.asm.Da.apply(null,arguments)};f._sqlite3_column_text=function(){return f.asm.Ea.apply(null,arguments)};f._sqlite3_column_type=function(){return f.asm.Fa.apply(null,arguments)};
f._sqlite3_create_function_v2=function(){return f.asm.Ga.apply(null,arguments)};f._sqlite3_data_count=function(){return f.asm.Ha.apply(null,arguments)};f._sqlite3_errmsg=function(){return f.asm.Ia.apply(null,arguments)};f._sqlite3_exec=function(){return f.asm.Ja.apply(null,arguments)};f._sqlite3_finalize=function(){return f.asm.Ka.apply(null,arguments)};f._sqlite3_free=function(){return f.asm.La.apply(null,arguments)};f._sqlite3_open=function(){return f.asm.Ma.apply(null,arguments)};
f._sqlite3_prepare_v2=function(){return f.asm.Na.apply(null,arguments)};f._sqlite3_reset=function(){return f.asm.Oa.apply(null,arguments)};f._sqlite3_result_blob=function(){return f.asm.Pa.apply(null,arguments)};f._sqlite3_result_double=function(){return f.asm.Qa.apply(null,arguments)};f._sqlite3_result_error=function(){return f.asm.Ra.apply(null,arguments)};f._sqlite3_result_int=function(){return f.asm.Sa.apply(null,arguments)};f._sqlite3_result_int64=function(){return f.asm.Ta.apply(null,arguments)};
f._sqlite3_result_null=function(){return f.asm.Ua.apply(null,arguments)};f._sqlite3_result_text=function(){return f.asm.Va.apply(null,arguments)};f._sqlite3_step=function(){return f.asm.Wa.apply(null,arguments)};f._sqlite3_value_blob=function(){return f.asm.Xa.apply(null,arguments)};f._sqlite3_value_bytes=function(){return f.asm.Ya.apply(null,arguments)};f._sqlite3_value_double=function(){return f.asm.Za.apply(null,arguments)};f._sqlite3_value_int=function(){return f.asm._a.apply(null,arguments)};
f._sqlite3_value_text=function(){return f.asm.$a.apply(null,arguments)};f._sqlite3_value_type=function(){return f.asm.ab.apply(null,arguments)};var h=f.stackAlloc=function(){return f.asm.cb.apply(null,arguments)},qa=f.stackRestore=function(){return f.asm.db.apply(null,arguments)},na=f.stackSave=function(){return f.asm.eb.apply(null,arguments)};f.dynCall_vi=function(){return f.asm.bb.apply(null,arguments)};f.asm=Yc;
f.cwrap=function(a,b,c,d){c=c||[];var e=c.every(function(a){return"number"===a});return"string"!==b&&e&&!d?Oa(a):function(){return Pa(a,b,c,arguments)}};f.stackSave=na;f.stackRestore=qa;f.stackAlloc=h;function Zc(a){this.name="ExitStatus";this.message="Program terminated with exit("+a+")";this.status=a}Zc.prototype=Error();Zc.prototype.constructor=Zc;hb=function $c(){f.calledRun||ad();f.calledRun||(hb=$c)};
function ad(){function a(){if(!f.calledRun&&(f.calledRun=!0,!Na)){eb||(eb=!0,f.noFSInit||Kc||(Kc=!0,Jc(),f.stdin=f.stdin,f.stdout=f.stdout,f.stderr=f.stderr,f.stdin?Lc("stdin",f.stdin):Dc("/dev/tty","/dev/stdin"),f.stdout?Lc("stdout",null,f.stdout):Dc("/dev/tty","/dev/stdout"),f.stderr?Lc("stderr",null,f.stderr):Dc("/dev/tty1","/dev/stderr"),p("/dev/stdin","r"),p("/dev/stdout","w"),p("/dev/stderr","w")),$a(bb));Nb=!1;$a(cb);if(f.onRuntimeInitialized)f.onRuntimeInitialized();if(f.postRun)for("function"==
typeof f.postRun&&(f.postRun=[f.postRun]);f.postRun.length;){var a=f.postRun.shift();db.unshift(a)}$a(db)}}if(!(0<H)){if(f.preRun)for("function"==typeof f.preRun&&(f.preRun=[f.preRun]);f.preRun.length;)fb();$a(ab);0<H||f.calledRun||(f.setStatus?(f.setStatus("Running..."),setTimeout(function(){setTimeout(function(){f.setStatus("")},1);a()},1)):a())}}f.run=ad;
function C(a){if(f.onAbort)f.onAbort(a);void 0!==a?(Ba(a),D(a),a=JSON.stringify(a)):a="";Na=!0;throw"abort("+a+"). Build with -s ASSERTIONS=1 for more info.";}f.abort=C;if(f.preInit)for("function"==typeof f.preInit&&(f.preInit=[f.preInit]);0<f.preInit.length;)f.preInit.pop()();f.noExitRuntime=!0;ad();


        // The shell-pre.js and emcc-generated code goes above
        return Module;
    }); // The end of the promise being returned

  return initSqlJsPromise;
} // The end of our initSqlJs function

// This bit below is copied almost exactly from what you get when you use the MODULARIZE=1 flag with emcc
// However, we don't want to use the emcc modularization. See shell-pre.js
if (typeof exports === 'object' && typeof module === 'object'){
    module.exports = initSqlJs;
    // This will allow the module to be used in ES6 or CommonJS
    module.exports.default = initSqlJs;
}
else if (typeof define === 'function' && define['amd']) {
    define([], function() { return initSqlJs; });
}
else if (typeof exports === 'object'){
    exports["Module"] = initSqlJs;
}
    
// Generated by CoffeeScript 1.12.7
var createDb, db, sqlModuleReady;

if (typeof importScripts === 'function') {
  db = null;
  createDb = function(data) {
    if (db != null) {
      db.close();
    }
    return db = new SQL.Database(data);
  };
  sqlModuleReady = initSqlJs();
  self.onmessage = function(event) {
    return sqlModuleReady.then(function() {
      var buff, callback, data, done, err, result;
      data = event['data'];
      switch (data != null ? data['action'] : void 0) {
        case 'open':
          buff = data['buffer'];
          createDb((buff ? new Uint8Array(buff) : void 0));
          return postMessage({
            'id': data['id'],
            'ready': true
          });
        case 'exec':
          if (db === null) {
            createDb();
          }
          if (!data['sql']) {
            throw 'exec: Missing query string';
          }
          return postMessage({
            'id': data['id'],
            'results': db.exec(data['sql'])
          });
        case 'each':
          if (db === null) {
            createDb();
          }
          callback = function(row) {
            return postMessage({
              'id': data['id'],
              'row': row,
              'finished': false
            });
          };
          done = function() {
            return postMessage({
              'id': data['id'],
              'finished': true
            });
          };
          return db.each(data['sql'], data['params'], callback, done);
        case 'export':
          buff = db["export"]();
          result = {
            'id': data['id'],
            'buffer': buff
          };
          try {
            return postMessage(result, [result]);
          } catch (error) {
            err = error;
            return postMessage(result);
          }
          break;
        case 'close':
          return db != null ? db.close() : void 0;
        default:
          throw new 'Invalid action : ' + (data != null ? data['action'] : void 0);
      }
    });
  };
}
