import { root } from './root';
const Object = root.Object;
if (typeof Object.assign != 'function') {
    (function () {
        Object.assign = function assignPolyfill(target, ...sources) {
            if (target === undefined || target === null) {
                throw new TypeError('Cannot convert undefined or null to object');
            }
            const output = Object(target);
            const len = sources.length;
            for (let index = 0; index < len; index++) {
                let source = sources[index];
                if (source !== undefined && source !== null) {
                    for (let key in source) {
                        if (source.hasOwnProperty(key)) {
                            output[key] = source[key];
                        }
                    }
                }
            }
            return output;
        };
    })();
}
export const assign = Object.assign;
//# sourceMappingURL=assign.js.map