var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
define(["require", "exports", '../Subscriber', '../util/tryCatch', '../util/errorObject', '../util/EmptyError'], function (require, exports, Subscriber_1, tryCatch_1, errorObject_1, EmptyError_1) {
    function first(predicate, resultSelector, defaultValue) {
        return this.lift(new FirstOperator(predicate, resultSelector, defaultValue, this));
    }
    exports.first = first;
    var FirstOperator = (function () {
        function FirstOperator(predicate, resultSelector, defaultValue, source) {
            this.predicate = predicate;
            this.resultSelector = resultSelector;
            this.defaultValue = defaultValue;
            this.source = source;
        }
        FirstOperator.prototype.call = function (observer) {
            return new FirstSubscriber(observer, this.predicate, this.resultSelector, this.defaultValue, this.source);
        };
        return FirstOperator;
    })();
    var FirstSubscriber = (function (_super) {
        __extends(FirstSubscriber, _super);
        function FirstSubscriber(destination, predicate, resultSelector, defaultValue, source) {
            _super.call(this, destination);
            this.predicate = predicate;
            this.resultSelector = resultSelector;
            this.defaultValue = defaultValue;
            this.source = source;
            this.index = 0;
            this.hasCompleted = false;
        }
        FirstSubscriber.prototype._next = function (value) {
            var _a = this, destination = _a.destination, predicate = _a.predicate, resultSelector = _a.resultSelector;
            var index = this.index++;
            var passed = true;
            if (predicate) {
                passed = tryCatch_1.tryCatch(predicate)(value, index, this.source);
                if (passed === errorObject_1.errorObject) {
                    destination.error(errorObject_1.errorObject.e);
                    return;
                }
            }
            if (passed) {
                if (resultSelector) {
                    var result = tryCatch_1.tryCatch(resultSelector)(value, index);
                    if (result === errorObject_1.errorObject) {
                        destination.error(errorObject_1.errorObject.e);
                        return;
                    }
                    destination.next(result);
                }
                else {
                    destination.next(value);
                }
                destination.complete();
                this.hasCompleted = true;
            }
        };
        FirstSubscriber.prototype._complete = function () {
            var destination = this.destination;
            if (!this.hasCompleted && typeof this.defaultValue !== 'undefined') {
                destination.next(this.defaultValue);
                destination.complete();
            }
            else if (!this.hasCompleted) {
                destination.error(new EmptyError_1.EmptyError);
            }
        };
        return FirstSubscriber;
    })(Subscriber_1.Subscriber);
});
//# sourceMappingURL=first.js.map