var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
define(["require", "exports", '../util/tryCatch', '../util/errorObject', '../OuterSubscriber', '../util/subscribeToResult'], function (require, exports, tryCatch_1, errorObject_1, OuterSubscriber_1, subscribeToResult_1) {
    var MergeMapToOperator = (function () {
        function MergeMapToOperator(ish, resultSelector, concurrent) {
            if (concurrent === void 0) { concurrent = Number.POSITIVE_INFINITY; }
            this.ish = ish;
            this.resultSelector = resultSelector;
            this.concurrent = concurrent;
        }
        MergeMapToOperator.prototype.call = function (observer) {
            return new MergeMapToSubscriber(observer, this.ish, this.resultSelector, this.concurrent);
        };
        return MergeMapToOperator;
    })();
    exports.MergeMapToOperator = MergeMapToOperator;
    var MergeMapToSubscriber = (function (_super) {
        __extends(MergeMapToSubscriber, _super);
        function MergeMapToSubscriber(destination, ish, resultSelector, concurrent) {
            if (concurrent === void 0) { concurrent = Number.POSITIVE_INFINITY; }
            _super.call(this, destination);
            this.ish = ish;
            this.resultSelector = resultSelector;
            this.concurrent = concurrent;
            this.hasCompleted = false;
            this.buffer = [];
            this.active = 0;
            this.index = 0;
        }
        MergeMapToSubscriber.prototype._next = function (value) {
            if (this.active < this.concurrent) {
                var resultSelector = this.resultSelector;
                var index = this.index++;
                var ish = this.ish;
                var destination = this.destination;
                if (ish === errorObject_1.errorObject) {
                    destination.error(ish.e);
                }
                else {
                    this.active++;
                    this._innerSub(ish, destination, resultSelector, value, index);
                }
            }
            else {
                this.buffer.push(value);
            }
        };
        MergeMapToSubscriber.prototype._innerSub = function (ish, destination, resultSelector, value, index) {
            this.add(subscribeToResult_1.subscribeToResult(this, ish, value, index));
        };
        MergeMapToSubscriber.prototype._complete = function () {
            this.hasCompleted = true;
            if (this.active === 0 && this.buffer.length === 0) {
                this.destination.complete();
            }
        };
        MergeMapToSubscriber.prototype.notifyNext = function (outerValue, innerValue, outerIndex, innerIndex) {
            var _a = this, resultSelector = _a.resultSelector, destination = _a.destination;
            if (resultSelector) {
                var result = tryCatch_1.tryCatch(resultSelector)(outerValue, innerValue, outerIndex, innerIndex);
                if (result === errorObject_1.errorObject) {
                    destination.error(errorObject_1.errorObject.e);
                }
                else {
                    destination.next(result);
                }
            }
            else {
                destination.next(innerValue);
            }
        };
        MergeMapToSubscriber.prototype.notifyError = function (err) {
            this.destination.error(err);
        };
        MergeMapToSubscriber.prototype.notifyComplete = function (innerSub) {
            var buffer = this.buffer;
            this.remove(innerSub);
            this.active--;
            if (buffer.length > 0) {
                this._next(buffer.shift());
            }
            else if (this.active === 0 && this.hasCompleted) {
                this.destination.complete();
            }
        };
        return MergeMapToSubscriber;
    })(OuterSubscriber_1.OuterSubscriber);
    exports.MergeMapToSubscriber = MergeMapToSubscriber;
});
//# sourceMappingURL=mergeMapTo-support.js.map