var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
define(["require", "exports", '../OuterSubscriber', '../util/subscribeToResult'], function (require, exports, OuterSubscriber_1, subscribeToResult_1) {
    function _switch() {
        return this.lift(new SwitchOperator());
    }
    exports._switch = _switch;
    var SwitchOperator = (function () {
        function SwitchOperator() {
        }
        SwitchOperator.prototype.call = function (subscriber) {
            return new SwitchSubscriber(subscriber);
        };
        return SwitchOperator;
    })();
    var SwitchSubscriber = (function (_super) {
        __extends(SwitchSubscriber, _super);
        function SwitchSubscriber(destination) {
            _super.call(this, destination);
            this.active = 0;
            this.hasCompleted = false;
        }
        SwitchSubscriber.prototype._next = function (value) {
            this.unsubscribeInner();
            this.active++;
            this.add(this.innerSubscription = subscribeToResult_1.subscribeToResult(this, value));
        };
        SwitchSubscriber.prototype._complete = function () {
            this.hasCompleted = true;
            if (this.active === 0) {
                this.destination.complete();
            }
        };
        SwitchSubscriber.prototype.unsubscribeInner = function () {
            this.active = this.active > 0 ? this.active - 1 : 0;
            var innerSubscription = this.innerSubscription;
            if (innerSubscription) {
                innerSubscription.unsubscribe();
                this.remove(innerSubscription);
            }
        };
        SwitchSubscriber.prototype.notifyNext = function (outerValue, innerValue) {
            this.destination.next(innerValue);
        };
        SwitchSubscriber.prototype.notifyError = function (err) {
            this.destination.error(err);
        };
        SwitchSubscriber.prototype.notifyComplete = function () {
            this.unsubscribeInner();
            if (this.hasCompleted && this.active === 0) {
                this.destination.complete();
            }
        };
        return SwitchSubscriber;
    })(OuterSubscriber_1.OuterSubscriber);
});
//# sourceMappingURL=switch.js.map