var Subscriber_1 = require('./Subscriber');
// HACK: the Babel part of the build doesn't like this reference.
// seems to put it in an infinite loop.
//import Notification from './Notification';
var Symbol_observer_1 = require('./util/Symbol_observer');
var Observable = (function () {
    function Observable(subscribe) {
        if (subscribe) {
            this._subscribe = subscribe;
        }
    }
    Observable.prototype.lift = function (operator) {
        var observable = new Observable();
        observable.source = this;
        observable.operator = operator;
        return observable;
    };
    Observable.prototype[Symbol_observer_1.default] = function (observer) {
        return this.subscribe(observer);
    };
    Observable.prototype.subscribe = function (observerOrNext, error, complete) {
        var subscriber;
        if (observerOrNext && typeof observerOrNext === "object") {
            if (observerOrNext instanceof Subscriber_1.default) {
                subscriber = observerOrNext;
            }
            else {
                subscriber = new Subscriber_1.default(observerOrNext);
            }
        }
        else {
            var next = observerOrNext;
            subscriber = Subscriber_1.default.create(next, error, complete);
        }
        subscriber.add(this._subscribe(subscriber));
        return subscriber;
    };
    Observable.prototype.forEach = function (nextHandler) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this[Symbol_observer_1.default]({
                next: nextHandler,
                error: reject,
                complete: resolve
            });
        });
    };
    Observable.prototype._subscribe = function (subscriber) {
        return this.source._subscribe(this.operator.call(subscriber));
    };
    return Observable;
})();
exports.default = Observable;
