var noop_1 = require('./util/noop');
var throwError_1 = require('./util/throwError');
var Observer = (function () {
    function Observer(destination) {
        if (!destination) {
            return;
        }
        (typeof destination.next === "function") || (destination.next = noop_1.default);
        (typeof destination.error === "function") || (destination.error = throwError_1.default);
        (typeof destination.complete === "function") || (destination.complete = noop_1.default);
        this.destination = destination;
    }
    Observer.prototype.next = function (value) {
        this._next(value);
    };
    Observer.prototype.error = function (error) {
        this._error(error);
    };
    Observer.prototype.complete = function () {
        this._complete();
    };
    Observer.prototype._next = function (value) {
        this.destination.next(value);
    };
    Observer.prototype._error = function (error) {
        this.destination.error(error);
    };
    Observer.prototype._complete = function () {
        this.destination.complete();
    };
    return Observer;
})();
exports.default = Observer;
