import Subscription from './Subscription';
export default class Scheduler {
    static immediate: Scheduler;
    static nextTick: Scheduler;
    now(): number;
    schedule<T>(delay: number, state: any, work: (x?: any) => Subscription<T> | void): Subscription<T>;
}
export declare class ImmediateScheduler extends Scheduler {
    actions: Action<any>[];
    active: boolean;
    scheduled: boolean;
    flush(): void;
    schedule<T>(delay: number, state: any, work: (x?: any) => Subscription<T> | void): Subscription<T>;
    scheduleNow<T>(state: any, work: (x?: any) => Subscription<T> | void): Action<T>;
    scheduleLater<T>(state: any, work: (x?: any) => Subscription<T> | void, delay: number): Action<T>;
}
export declare class NextTickScheduler extends ImmediateScheduler {
    scheduleNow<T>(state: any, work: (x?: any) => Subscription<T> | void): Action<T>;
}
export declare class Action<T> extends Subscription<T> {
    scheduler: ImmediateScheduler;
    work: (x?: any) => Subscription<T> | void;
    state: any;
    constructor(scheduler: ImmediateScheduler, work: (x?: any) => Subscription<T> | void);
    schedule(state?: any): Action<T>;
    execute(): void;
    unsubscribe(): void;
}
export declare class NextTickAction<T> extends Action<T> {
    id: number;
    schedule(state?: any): Action<T>;
    unsubscribe(): void;
}
export declare class FutureAction<T> extends Action<T> {
    scheduler: ImmediateScheduler;
    work: (x?: any) => Subscription<T> | void;
    delay: number;
    id: number;
    constructor(scheduler: ImmediateScheduler, work: (x?: any) => Subscription<T> | void, delay: number);
    schedule(state?: any): Action<T>;
    unsubscribe(): void;
}
