var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Immediate_1 = require('./util/Immediate');
var Subscription_1 = require('./Subscription');
var Scheduler = (function () {
    function Scheduler() {
    }
    Scheduler.prototype.now = function () {
        return Date.now();
    };
    Scheduler.prototype.schedule = function (delay, state, work) {
        throw new Error("Scheduler.prototype.schedule not implemented.");
    };
    return Scheduler;
})();
exports.default = Scheduler;
var ImmediateScheduler = (function (_super) {
    __extends(ImmediateScheduler, _super);
    function ImmediateScheduler() {
        _super.apply(this, arguments);
        this.actions = [];
        this.active = false;
        this.scheduled = false;
    }
    ImmediateScheduler.prototype.flush = function () {
        if (this.active || this.scheduled) {
            return;
        }
        this.active = true;
        var actions = this.actions;
        for (var action = void 0; action = actions.shift();) {
            action.execute();
        }
        this.active = false;
    };
    ImmediateScheduler.prototype.schedule = function (delay, state, work) {
        return (delay <= 0) ?
            this.scheduleNow(state, work) :
            this.scheduleLater(state, work, delay);
    };
    ImmediateScheduler.prototype.scheduleNow = function (state, work) {
        return new Action(this, work).schedule(state);
    };
    ImmediateScheduler.prototype.scheduleLater = function (state, work, delay) {
        return new FutureAction(this, work, delay).schedule(state);
    };
    return ImmediateScheduler;
})(Scheduler);
exports.ImmediateScheduler = ImmediateScheduler;
var NextTickScheduler = (function (_super) {
    __extends(NextTickScheduler, _super);
    function NextTickScheduler() {
        _super.apply(this, arguments);
    }
    NextTickScheduler.prototype.scheduleNow = function (state, work) {
        return (this.scheduled ?
            new Action(this, work) :
            new NextTickAction(this, work)).schedule(state);
    };
    return NextTickScheduler;
})(ImmediateScheduler);
exports.NextTickScheduler = NextTickScheduler;
Scheduler.immediate = new ImmediateScheduler();
Scheduler.nextTick = new NextTickScheduler();
var Action = (function (_super) {
    __extends(Action, _super);
    function Action(scheduler, work) {
        _super.call(this);
        this.scheduler = scheduler;
        this.work = work;
    }
    Action.prototype.schedule = function (state) {
        this.state = state;
        var scheduler = this.scheduler;
        scheduler.actions.push(this);
        scheduler.flush();
        return this;
    };
    Action.prototype.execute = function () {
        if (this.isUnsubscribed) {
            throw new Error("How did did we execute a canceled Action?");
        }
        this.work(this.state);
    };
    Action.prototype.unsubscribe = function () {
        var scheduler = this.scheduler;
        var actions = scheduler.actions;
        var index = actions.indexOf(this);
        this.work = void 0;
        this.state = void 0;
        this.scheduler = void 0;
        if (index !== -1) {
            actions.splice(index, 1);
        }
        _super.prototype.unsubscribe.call(this);
    };
    return Action;
})(Subscription_1.default);
exports.Action = Action;
var NextTickAction = (function (_super) {
    __extends(NextTickAction, _super);
    function NextTickAction() {
        _super.apply(this, arguments);
    }
    NextTickAction.prototype.schedule = function (state) {
        var _this = this;
        this.state = state;
        var scheduler = this.scheduler;
        scheduler.actions.push(this);
        if (!scheduler.scheduled) {
            scheduler.scheduled = true;
            this.id = Immediate_1.Immediate.setImmediate(function () {
                _this.id = void 0;
                _this.scheduler.scheduled = false;
                _this.scheduler.flush();
            });
        }
        return this;
    };
    NextTickAction.prototype.unsubscribe = function () {
        var id = this.id;
        var scheduler = this.scheduler;
        _super.prototype.unsubscribe.call(this);
        if (scheduler.actions.length === 0) {
            scheduler.active = false;
            scheduler.scheduled = false;
            if (id) {
                this.id = void 0;
                Immediate_1.Immediate.clearImmediate(id);
            }
        }
    };
    return NextTickAction;
})(Action);
exports.NextTickAction = NextTickAction;
var FutureAction = (function (_super) {
    __extends(FutureAction, _super);
    function FutureAction(scheduler, work, delay) {
        _super.call(this, scheduler, work);
        this.scheduler = scheduler;
        this.work = work;
        this.delay = delay;
    }
    FutureAction.prototype.schedule = function (state) {
        var _this = this;
        this.state = state;
        var id = this.id;
        if (id != null) {
            this.id = undefined;
            clearTimeout(id);
        }
        var scheduler = this.scheduler;
        this.id = setTimeout(function () {
            _this.id = void 0;
            scheduler.actions.push(_this);
            scheduler.flush();
        }, this.delay);
        return this;
    };
    FutureAction.prototype.unsubscribe = function () {
        var id = this.id;
        if (id != null) {
            this.id = void 0;
            clearTimeout(id);
        }
        _super.prototype.unsubscribe.call(this);
    };
    return FutureAction;
})(Action);
exports.FutureAction = FutureAction;
