import Operator from './Operator';
import Observer from './Observer';
import Observable from './Observable';
import Subscription from './Subscription';
export default class Subject<T> extends Observable<T> implements Observer<T>, Subscription<T> {
    static create<T>(source: Observable<T>, destination: Observer<T>): Subject<T>;
    destination: Observer<T>;
    observers: Observer<T>[];
    isUnsubscribed: boolean;
    dispatching: boolean;
    errorSignal: boolean;
    errorInstance: any;
    completeSignal: boolean;
    lift<T, R>(operator: Operator<T, R>): Observable<T>;
    _subscribe(subscriber: any): SubjectSubscription<T>;
    add(subscription?: any): void;
    remove(subscription?: any): void;
    unsubscribe(): void;
    next(value: any): void;
    error(error: any): void;
    complete(): void;
    _next(value?: any): void;
    _error(error?: any): void;
    _complete(): void;
}
export declare class SubjectSubscription<T> implements Subscription<T> {
    subject: Subject<T>;
    observer: Observer<any>;
    isUnsubscribed: boolean;
    constructor(subject: Subject<T>, observer: Observer<any>);
    add(x?: any): void;
    remove(x?: any): void;
    unsubscribe(): void;
}
