var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var noop_1 = require('./util/noop');
var throwError_1 = require('./util/throwError');
var tryOrOnError_1 = require('./util/tryOrOnError');
var Observer_1 = require('./Observer');
var Subscription_1 = require('./Subscription');
var subscriptionAdd = Subscription_1.default.prototype.add;
var subscriptionRemove = Subscription_1.default.prototype.remove;
var subscriptionUnsubscribe = Subscription_1.default.prototype.unsubscribe;
var Subscriber = (function (_super) {
    __extends(Subscriber, _super);
    function Subscriber(destination) {
        _super.call(this, destination);
        this._isUnsubscribed = false;
        if (!destination) {
            return;
        }
        var subscription = destination._subscription;
        if (subscription) {
            this._subscription = subscription;
        }
        else if (destination instanceof Subscriber) {
            this._subscription = destination;
        }
    }
    Subscriber.create = function (next, error, complete) {
        var subscriber = new Subscriber();
        subscriber._next = (typeof next === "function") && tryOrOnError_1.default(next) || noop_1.default;
        subscriber._error = (typeof error === "function") && error || throwError_1.default;
        subscriber._complete = (typeof complete === "function") && complete || noop_1.default;
        return subscriber;
    };
    Object.defineProperty(Subscriber.prototype, "isUnsubscribed", {
        get: function () {
            var subscription = this._subscription;
            if (subscription) {
                // route to the shared Subscription if it exists
                return this._isUnsubscribed || subscription.isUnsubscribed;
            }
            else {
                return this._isUnsubscribed;
            }
        },
        set: function (value) {
            var subscription = this._subscription;
            if (subscription) {
                // route to the shared Subscription if it exists
                subscription.isUnsubscribed = value;
            }
            else {
                this._isUnsubscribed = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Subscriber.prototype.add = function (sub) {
        // route add to the shared Subscription if it exists
        subscriptionAdd.call(this._subscription || this, sub);
    };
    Subscriber.prototype.remove = function (sub) {
        // route remove to the shared Subscription if it exists
        subscriptionRemove.call(this._subscription || this, sub);
    };
    Subscriber.prototype.unsubscribe = function () {
        if (this._isUnsubscribed) {
            return;
        }
        else if (this._subscription) {
            this._isUnsubscribed = true;
        }
        else {
            subscriptionUnsubscribe.call(this);
        }
    };
    Subscriber.prototype.next = function (value) {
        if (!this.isUnsubscribed) {
            this._next(value);
        }
    };
    Subscriber.prototype.error = function (error) {
        if (!this.isUnsubscribed) {
            this._error(error);
            this.unsubscribe();
        }
    };
    Subscriber.prototype.complete = function () {
        if (!this.isUnsubscribed) {
            this._complete();
            this.unsubscribe();
        }
    };
    return Subscriber;
})(Observer_1.default);
exports.default = Subscriber;
