var Subscription = (function () {
    function Subscription(_unsubscribe) {
        this.isUnsubscribed = false;
        // hide `_unsubscribe` from TypeScript so we can implement Subscription
        if (_unsubscribe) {
            this._unsubscribe = _unsubscribe;
        }
    }
    Subscription.prototype.unsubscribe = function () {
        if (this.isUnsubscribed) {
            return;
        }
        this.isUnsubscribed = true;
        var self = this;
        var unsubscribe = self._unsubscribe;
        var subscriptions = self._subscriptions;
        self._subscriptions = void 0;
        if (unsubscribe != null) {
            unsubscribe.call(this);
        }
        if (subscriptions != null) {
            var index = -1;
            var len = subscriptions.length;
            while (++index < len) {
                subscriptions[index].unsubscribe();
            }
        }
    };
    Subscription.prototype.add = function (subscription) {
        // return early if: 
        //  1. the subscription is null
        //  2. we're attempting to add ourself
        //  3. we're attempting to add the static `empty` Subscription
        if (subscription == null || (subscription === this) || (subscription === Subscription.empty)) {
            return;
        }
        var self = this;
        var sub = subscription;
        switch (typeof sub) {
            case "function":
                sub = new Subscription(subscription);
            case "object":
                if (sub.isUnsubscribed || typeof sub.unsubscribe !== "function") {
                    break;
                }
                else if (this.isUnsubscribed) {
                    sub.unsubscribe();
                }
                else {
                    var subscriptions = self._subscriptions || (self._subscriptions = []);
                    subscriptions.push(sub);
                }
                break;
            default:
                throw new Error('Unrecognized subscription ' + subscription + ' added to Subscription.');
        }
    };
    Subscription.prototype.remove = function (subscription) {
        // return early if: 
        //  1. the subscription is null
        //  2. we're attempting to remove ourself
        //  3. we're attempting to remove the static `empty` Subscription
        if (subscription == null || (subscription === this) || (subscription === Subscription.empty)) {
            return;
        }
        var self = this;
        var subscriptions = self._subscriptions;
        if (subscriptions) {
            var subscriptionIndex = subscriptions.indexOf(subscription);
            if (subscriptionIndex !== -1) {
                subscriptions.splice(subscriptionIndex, 1);
            }
        }
    };
    Subscription.empty = (function (empty) {
        empty.isUnsubscribed = true;
        return empty;
    })(new Subscription());
    return Subscription;
})();
exports.default = Subscription;
