import Subject from '../Subject';
import Observable from '../Observable';
import Subscription from '../Subscription';
export default class ConnectableObservable<T> extends Observable<T> {
    source: Observable<T>;
    protected subjectFactory: () => Subject<T>;
    subject: Subject<T>;
    subscription: Subscription<T>;
    constructor(source: Observable<T>, subjectFactory: () => Subject<T>);
    _subscribe(subscriber: any): Subscription<T>;
    _getSubject(): Subject<T>;
    connect(): Subscription<T>;
    refCount(): RefCountObservable<T>;
}
export declare class ConnectableSubscription<T> extends Subscription<T> {
    protected connectable: ConnectableObservable<T>;
    constructor(connectable: ConnectableObservable<T>);
    _unsubscribe(): void;
}
export declare class RefCountObservable<T> extends Observable<T> {
    protected connectable: ConnectableObservable<T>;
    refCount: number;
    connection: Subscription<T>;
    constructor(connectable: ConnectableObservable<T>, refCount?: number);
    _subscribe(subscriber: any): Subscription<T>;
}
export declare class RefCountSubscription<T> extends Subscription<T> {
    protected refCountObservable: RefCountObservable<T>;
    constructor(refCountObservable: RefCountObservable<T>);
    _unsubscribe(): void;
}
