var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Observable_1 = require('../Observable');
var PromiseObservable = (function (_super) {
    __extends(PromiseObservable, _super);
    function PromiseObservable(promise) {
        _super.call(this);
        this.promise = promise;
    }
    PromiseObservable.create = function (promise) {
        return new PromiseObservable(promise);
    };
    PromiseObservable.prototype._subscribe = function (subscriber) {
        this.promise.then(function (x) {
            if (!subscriber.isUnsubscribed) {
                subscriber.next(x);
                subscriber.complete();
            }
        }, function (e) {
            if (!subscriber.isUnsubscribed) {
                subscriber.error(e);
            }
        });
    };
    return PromiseObservable;
})(Observable_1.default);
exports.default = PromiseObservable;
