var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Scheduler_1 = require('../Scheduler');
var Observable_1 = require('../Observable');
var SubscribeOnObservable = (function (_super) {
    __extends(SubscribeOnObservable, _super);
    function SubscribeOnObservable(source, delay, scheduler) {
        if (delay === void 0) { delay = 0; }
        if (scheduler === void 0) { scheduler = Scheduler_1.default.nextTick; }
        _super.call(this);
        this.source = source;
        this.delay = delay;
        this.scheduler = scheduler;
    }
    SubscribeOnObservable.create = function (source, delay, scheduler) {
        if (delay === void 0) { delay = 0; }
        if (scheduler === void 0) { scheduler = Scheduler_1.default.nextTick; }
        return new SubscribeOnObservable(source, delay, scheduler);
    };
    SubscribeOnObservable.dispatch = function (_a) {
        var source = _a.source, subscriber = _a.subscriber;
        return source.subscribe(subscriber);
    };
    SubscribeOnObservable.prototype._subscribe = function (subscriber) {
        var delay = this.delay;
        var source = this.source;
        var scheduler = this.scheduler;
        subscriber.add(scheduler.schedule(delay, {
            source: source, subscriber: subscriber
        }, SubscribeOnObservable.dispatch));
    };
    return SubscribeOnObservable;
})(Observable_1.default);
exports.default = SubscribeOnObservable;
