var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var Subscriber_1 = require('../Subscriber');
var tryCatch_1 = require('../util/tryCatch');
var errorObject_1 = require('../util/errorObject');
function _catch(selector) {
    var catchOperator = new CatchOperator(selector);
    var caught = this.lift(catchOperator);
    catchOperator.caught = caught;
    return caught;
}
exports.default = _catch;
var CatchOperator = (function (_super) {
    __extends(CatchOperator, _super);
    function CatchOperator(selector) {
        _super.call(this);
        this.selector = selector;
    }
    CatchOperator.prototype.call = function (observer) {
        return new CatchSubscriber(observer, this.selector, this.caught);
    };
    return CatchOperator;
})(Operator_1.default);
exports.CatchOperator = CatchOperator;
var CatchSubscriber = (function (_super) {
    __extends(CatchSubscriber, _super);
    function CatchSubscriber(destination, selector, caught) {
        _super.call(this, destination);
        this.selector = selector;
        this.caught = caught;
    }
    CatchSubscriber.prototype._error = function (err) {
        var result = tryCatch_1.default(this.selector)(err, this.caught);
        if (result === errorObject_1.errorObject) {
            this.destination.error(errorObject_1.errorObject.e);
        }
        else {
            this.add(result.subscribe(this.destination));
        }
    };
    return CatchSubscriber;
})(Subscriber_1.default);
exports.CatchSubscriber = CatchSubscriber;
