var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var ArrayObservable_1 = require('../observables/ArrayObservable');
var zip_1 = require('./zip');
function combineLatest() {
    var xs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        xs[_i - 0] = arguments[_i];
    }
    var project = xs[xs.length - 1];
    if (typeof project === "function") {
        xs.pop();
    }
    if (typeof this.subscribe === "function") {
        return new ArrayObservable_1.default([this].concat(xs)).lift(new CombineLatestOperator(project));
    }
    return new ArrayObservable_1.default(xs).lift(new CombineLatestOperator(project));
}
exports.default = combineLatest;
var CombineLatestOperator = (function (_super) {
    __extends(CombineLatestOperator, _super);
    function CombineLatestOperator(project) {
        _super.call(this);
        this.project = project;
    }
    CombineLatestOperator.prototype.call = function (observer) {
        return new CombineLatestSubscriber(observer, this.project);
    };
    return CombineLatestOperator;
})(Operator_1.default);
exports.CombineLatestOperator = CombineLatestOperator;
var CombineLatestSubscriber = (function (_super) {
    __extends(CombineLatestSubscriber, _super);
    function CombineLatestSubscriber(destination, project) {
        _super.call(this, destination, project, []);
    }
    CombineLatestSubscriber.prototype._subscribeInner = function (observable, values, index, total) {
        return observable.subscribe(new CombineLatestInnerSubscriber(this, values, index, total));
    };
    CombineLatestSubscriber.prototype._innerComplete = function (innerSubscriber) {
        if ((this.active -= 1) === 0) {
            this.destination.complete();
        }
    };
    return CombineLatestSubscriber;
})(zip_1.ZipSubscriber);
exports.CombineLatestSubscriber = CombineLatestSubscriber;
var CombineLatestInnerSubscriber = (function (_super) {
    __extends(CombineLatestInnerSubscriber, _super);
    function CombineLatestInnerSubscriber(parent, values, index, total) {
        _super.call(this, parent, values, index, total);
    }
    CombineLatestInnerSubscriber.prototype._next = function (x) {
        var index = this.index;
        var total = this.total;
        var parent = this.parent;
        var values = this.values;
        var valueBox = values[index];
        var limit;
        if (valueBox) {
            valueBox[0] = x;
            limit = parent.limit;
        }
        else {
            limit = parent.limit += 1;
            values[index] = [x];
        }
        if (limit === total) {
            this._projectNext(values, parent.project);
        }
    };
    return CombineLatestInnerSubscriber;
})(zip_1.ZipInnerSubscriber);
exports.CombineLatestInnerSubscriber = CombineLatestInnerSubscriber;
