var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var Subscriber_1 = require('../Subscriber');
function defaultIfEmpty(defaultValue) {
    if (defaultValue === void 0) { defaultValue = null; }
    return this.lift(new DefaultIfEmptyOperator(defaultValue));
}
exports.default = defaultIfEmpty;
var DefaultIfEmptyOperator = (function (_super) {
    __extends(DefaultIfEmptyOperator, _super);
    function DefaultIfEmptyOperator(defaultValue) {
        _super.call(this);
        this.defaultValue = defaultValue;
    }
    DefaultIfEmptyOperator.prototype.call = function (observer) {
        return new DefaultIfEmptySubscriber(observer, this.defaultValue);
    };
    return DefaultIfEmptyOperator;
})(Operator_1.default);
exports.DefaultIfEmptyOperator = DefaultIfEmptyOperator;
var DefaultIfEmptySubscriber = (function (_super) {
    __extends(DefaultIfEmptySubscriber, _super);
    function DefaultIfEmptySubscriber(destination, defaultValue) {
        _super.call(this, destination);
        this.defaultValue = defaultValue;
        this.isEmpty = true;
    }
    DefaultIfEmptySubscriber.prototype._next = function (x) {
        this.isEmpty = false;
        this.destination.next(x);
    };
    DefaultIfEmptySubscriber.prototype._complete = function () {
        if (this.isEmpty) {
            this.destination.next(this.defaultValue);
        }
        this.destination.complete();
    };
    return DefaultIfEmptySubscriber;
})(Subscriber_1.default);
exports.DefaultIfEmptySubscriber = DefaultIfEmptySubscriber;
