var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var Subscriber_1 = require('../Subscriber');
var tryCatch_1 = require('../util/tryCatch');
var errorObject_1 = require('../util/errorObject');
var bindCallback_1 = require('../util/bindCallback');
function distinctUntilChanged(compare, thisArg) {
    return this.lift(new DistinctUntilChangedOperator(thisArg ?
        bindCallback_1.default(compare, thisArg, 2) :
        compare));
}
exports.default = distinctUntilChanged;
var DistinctUntilChangedOperator = (function (_super) {
    __extends(DistinctUntilChangedOperator, _super);
    function DistinctUntilChangedOperator(compare) {
        _super.call(this);
        this.compare = compare;
    }
    DistinctUntilChangedOperator.prototype.call = function (observer) {
        return new DistinctUntilChangedSubscriber(observer, this.compare);
    };
    return DistinctUntilChangedOperator;
})(Operator_1.default);
exports.DistinctUntilChangedOperator = DistinctUntilChangedOperator;
var DistinctUntilChangedSubscriber = (function (_super) {
    __extends(DistinctUntilChangedSubscriber, _super);
    function DistinctUntilChangedSubscriber(destination, compare) {
        _super.call(this, destination);
        this.hasValue = false;
        if (typeof compare === "function") {
            this.compare = compare;
        }
    }
    DistinctUntilChangedSubscriber.prototype.compare = function (x, y) {
        return x === y;
    };
    DistinctUntilChangedSubscriber.prototype._next = function (x) {
        var result = false;
        if (this.hasValue) {
            result = tryCatch_1.default(this.compare)(this.value, x);
            if (result === errorObject_1.errorObject) {
                this.destination.error(errorObject_1.errorObject.e);
                return;
            }
        }
        else {
            this.hasValue = true;
        }
        if (Boolean(result) === false) {
            this.value = x;
            this.destination.next(x);
        }
    };
    return DistinctUntilChangedSubscriber;
})(Subscriber_1.default);
exports.DistinctUntilChangedSubscriber = DistinctUntilChangedSubscriber;
