var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var merge_1 = require('./merge');
var EmptyObservable_1 = require('../observables/EmptyObservable');
var ScalarObservable_1 = require('../observables/ScalarObservable');
var tryCatch_1 = require('../util/tryCatch');
var errorObject_1 = require('../util/errorObject');
function expand(project) {
    return this.lift(new ExpandOperator(project));
}
exports.default = expand;
var ExpandOperator = (function (_super) {
    __extends(ExpandOperator, _super);
    function ExpandOperator(project) {
        _super.call(this);
        this.project = project;
    }
    ExpandOperator.prototype.call = function (observer) {
        return new ExpandSubscriber(observer, this.project);
    };
    return ExpandOperator;
})(Operator_1.default);
exports.ExpandOperator = ExpandOperator;
var ExpandSubscriber = (function (_super) {
    __extends(ExpandSubscriber, _super);
    function ExpandSubscriber(destination, project) {
        _super.call(this, destination, Number.POSITIVE_INFINITY);
        this.project = project;
    }
    ExpandSubscriber.prototype._project = function (value, index) {
        var observable = tryCatch_1.default(this.project).call(this, value, index);
        if (observable === errorObject_1.errorObject) {
            this.error(errorObject_1.errorObject.e);
            return null;
        }
        return observable;
    };
    ExpandSubscriber.prototype._subscribeInner = function (observable, value, index) {
        if (observable instanceof ScalarObservable_1.default) {
            this.destination.next(observable.value);
            this._innerComplete();
            this._next(observable.value);
        }
        else if (observable instanceof EmptyObservable_1.default) {
            this._innerComplete();
        }
        else {
            return observable.subscribe(new ExpandInnerSubscriber(this));
        }
    };
    return ExpandSubscriber;
})(merge_1.MergeSubscriber);
exports.ExpandSubscriber = ExpandSubscriber;
var ExpandInnerSubscriber = (function (_super) {
    __extends(ExpandInnerSubscriber, _super);
    function ExpandInnerSubscriber(parent) {
        _super.call(this, parent);
    }
    ExpandInnerSubscriber.prototype._next = function (value) {
        this.destination.next(value);
        this.parent.next(value);
    };
    return ExpandInnerSubscriber;
})(merge_1.MergeInnerSubscriber);
exports.ExpandInnerSubscriber = ExpandInnerSubscriber;
