var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var Subscriber_1 = require('../Subscriber');
var tryCatch_1 = require('../util/tryCatch');
var errorObject_1 = require('../util/errorObject');
var bindCallback_1 = require('../util/bindCallback');
function filter(select, thisArg) {
    return this.lift(new FilterOperator(select, thisArg));
}
exports.default = filter;
var FilterOperator = (function (_super) {
    __extends(FilterOperator, _super);
    function FilterOperator(select, thisArg) {
        _super.call(this);
        this.select = bindCallback_1.default(select, thisArg, 2);
    }
    FilterOperator.prototype.call = function (observer) {
        return new FilterSubscriber(observer, this.select);
    };
    return FilterOperator;
})(Operator_1.default);
exports.FilterOperator = FilterOperator;
var FilterSubscriber = (function (_super) {
    __extends(FilterSubscriber, _super);
    function FilterSubscriber(destination, select) {
        _super.call(this, destination);
        this.count = 0;
        this.select = select;
    }
    FilterSubscriber.prototype._next = function (x) {
        var result = tryCatch_1.default(this.select)(x, this.count++);
        if (result === errorObject_1.errorObject) {
            this.destination.error(errorObject_1.errorObject.e);
        }
        else if (Boolean(result)) {
            this.destination.next(x);
        }
    };
    return FilterSubscriber;
})(Subscriber_1.default);
exports.FilterSubscriber = FilterSubscriber;
