import Operator from '../Operator';
import Observer from '../Observer';
import Observable from '../Observable';
import { MergeSubscriber, MergeInnerSubscriber } from './merge';
export default function flatMap<T, R>(project: (x: T, ix: number) => Observable<any>, projectResult?: (x: T, y: any, ix: number, iy: number) => R, concurrent?: number): any;
export declare class FlatMapOperator<T, R> extends Operator<T, R> {
    project: (x: T, ix: number) => Observable<any>;
    projectResult: (x: T, y: any, ix: number, iy: number) => R;
    concurrent: number;
    constructor(project: (x: T, ix: number) => Observable<any>, projectResult?: (x: T, y: any, ix: number, iy: number) => R, concurrent?: number);
    call(observer: Observer<R>): Observer<T>;
}
export declare class FlatMapSubscriber<T, R> extends MergeSubscriber<T, R> {
    project: (x: T, ix: number) => Observable<any>;
    projectResult: (x: T, y: any, ix: number, iy: number) => R;
    constructor(destination: Observer<R>, concurrent: number, project: (x: T, ix: number) => Observable<any>, projectResult?: (x: T, y: any, ix: number, iy: number) => R);
    _project(value: any, index: any): any;
    _subscribeInner(observable: any, value: any, index: any): any;
}
export declare class FlatMapInnerSubscriber<T, R> extends MergeInnerSubscriber<T, R> {
    value: any;
    index: number;
    project: (x: T, y: any, ix: number, iy: number) => R;
    count: number;
    constructor(parent: FlatMapSubscriber<T, R>, value: any, index: number, project?: (x: T, y: any, ix: number, iy: number) => R);
    _next(value: any): void;
}
