var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var merge_1 = require('./merge');
var ScalarObservable_1 = require('../observables/ScalarObservable');
var tryCatch_1 = require('../util/tryCatch');
var errorObject_1 = require('../util/errorObject');
function flatMap(project, projectResult, concurrent) {
    return this.lift(new FlatMapOperator(project, projectResult, concurrent));
}
exports.default = flatMap;
var FlatMapOperator = (function (_super) {
    __extends(FlatMapOperator, _super);
    function FlatMapOperator(project, projectResult, concurrent) {
        if (concurrent === void 0) { concurrent = Number.POSITIVE_INFINITY; }
        _super.call(this);
        this.project = project;
        this.projectResult = projectResult;
        this.concurrent = concurrent;
    }
    FlatMapOperator.prototype.call = function (observer) {
        return new FlatMapSubscriber(observer, this.concurrent, this.project, this.projectResult);
    };
    return FlatMapOperator;
})(Operator_1.default);
exports.FlatMapOperator = FlatMapOperator;
var FlatMapSubscriber = (function (_super) {
    __extends(FlatMapSubscriber, _super);
    function FlatMapSubscriber(destination, concurrent, project, projectResult) {
        _super.call(this, destination, concurrent);
        this.project = project;
        this.projectResult = projectResult;
    }
    FlatMapSubscriber.prototype._project = function (value, index) {
        var observable = tryCatch_1.default(this.project).call(this, value, index);
        if (observable === errorObject_1.errorObject) {
            this.error(errorObject_1.errorObject.e);
            return null;
        }
        return observable;
    };
    FlatMapSubscriber.prototype._subscribeInner = function (observable, value, index) {
        var projectResult = this.projectResult;
        if (projectResult) {
            return observable.subscribe(new FlatMapInnerSubscriber(this, value, index, projectResult));
        }
        else if (observable instanceof ScalarObservable_1.default) {
            this.destination.next(observable.value);
            this._innerComplete();
        }
        else {
            return observable.subscribe(new merge_1.MergeInnerSubscriber(this));
        }
    };
    return FlatMapSubscriber;
})(merge_1.MergeSubscriber);
exports.FlatMapSubscriber = FlatMapSubscriber;
var FlatMapInnerSubscriber = (function (_super) {
    __extends(FlatMapInnerSubscriber, _super);
    function FlatMapInnerSubscriber(parent, value, index, project) {
        _super.call(this, parent);
        this.count = 0;
        this.value = value;
        this.index = index;
        this.project = project;
    }
    FlatMapInnerSubscriber.prototype._next = function (value) {
        var result = value;
        var index = this.count++;
        result = tryCatch_1.default(this.project).call(this, this.value, value, this.index, index);
        if (result === errorObject_1.errorObject) {
            this.destination.error(errorObject_1.errorObject.e);
        }
        else {
            this.destination.next(result);
        }
    };
    return FlatMapInnerSubscriber;
})(merge_1.MergeInnerSubscriber);
exports.FlatMapInnerSubscriber = FlatMapInnerSubscriber;
