var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var flatMap_1 = require('./flatMap');
function flatMapTo(observable, projectResult, concurrent) {
    return this.lift(new FlatMapToOperator(observable, projectResult, concurrent));
}
exports.default = flatMapTo;
var FlatMapToOperator = (function (_super) {
    __extends(FlatMapToOperator, _super);
    function FlatMapToOperator(observable, projectResult, concurrent) {
        if (concurrent === void 0) { concurrent = Number.POSITIVE_INFINITY; }
        _super.call(this);
        this.observable = observable;
        this.projectResult = projectResult;
        this.concurrent = concurrent;
    }
    FlatMapToOperator.prototype.call = function (observer) {
        return new FlatMapToSubscriber(observer, this.concurrent, this.observable, this.projectResult);
    };
    return FlatMapToOperator;
})(Operator_1.default);
exports.FlatMapToOperator = FlatMapToOperator;
var FlatMapToSubscriber = (function (_super) {
    __extends(FlatMapToSubscriber, _super);
    function FlatMapToSubscriber(destination, concurrent, observable, projectResult) {
        _super.call(this, destination, concurrent, null, projectResult);
        this.observable = observable;
    }
    FlatMapToSubscriber.prototype._project = function (value, index) {
        return this.observable;
    };
    return FlatMapToSubscriber;
})(flatMap_1.FlatMapSubscriber);
exports.FlatMapToSubscriber = FlatMapToSubscriber;
