var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var Subscriber_1 = require('../Subscriber');
var tryCatch_1 = require('../util/tryCatch');
var errorObject_1 = require('../util/errorObject');
var bindCallback_1 = require('../util/bindCallback');
function map(project, thisArg) {
    return this.lift(new MapOperator(project, thisArg));
}
exports.default = map;
var MapOperator = (function (_super) {
    __extends(MapOperator, _super);
    function MapOperator(project, thisArg) {
        _super.call(this);
        this.project = bindCallback_1.default(project, thisArg, 2);
    }
    MapOperator.prototype.call = function (observer) {
        return new MapSubscriber(observer, this.project);
    };
    return MapOperator;
})(Operator_1.default);
exports.MapOperator = MapOperator;
var MapSubscriber = (function (_super) {
    __extends(MapSubscriber, _super);
    function MapSubscriber(destination, project) {
        _super.call(this, destination);
        this.count = 0;
        this.project = project;
    }
    MapSubscriber.prototype._next = function (x) {
        var result = tryCatch_1.default(this.project)(x, this.count++);
        if (result === errorObject_1.errorObject) {
            this.error(errorObject_1.errorObject.e);
        }
        else {
            this.destination.next(result);
        }
    };
    return MapSubscriber;
})(Subscriber_1.default);
exports.MapSubscriber = MapSubscriber;
