var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var Subscriber_1 = require('../Subscriber');
var Notification_1 = require('../Notification');
function materialize() {
    return this.lift(new MaterializeOperator());
}
exports.default = materialize;
var MaterializeOperator = (function (_super) {
    __extends(MaterializeOperator, _super);
    function MaterializeOperator() {
        _super.apply(this, arguments);
    }
    MaterializeOperator.prototype.call = function (observer) {
        return new MaterializeSubscriber(observer);
    };
    return MaterializeOperator;
})(Operator_1.default);
exports.MaterializeOperator = MaterializeOperator;
var MaterializeSubscriber = (function (_super) {
    __extends(MaterializeSubscriber, _super);
    function MaterializeSubscriber(destination) {
        _super.call(this, destination);
    }
    MaterializeSubscriber.prototype._next = function (value) {
        this.destination.next(Notification_1.default.createNext(value));
    };
    MaterializeSubscriber.prototype._error = function (err) {
        var destination = this.destination;
        destination.next(Notification_1.default.createError(err));
        destination.complete();
    };
    MaterializeSubscriber.prototype._complete = function () {
        var destination = this.destination;
        destination.next(Notification_1.default.createComplete());
        destination.complete();
    };
    return MaterializeSubscriber;
})(Subscriber_1.default);
exports.MaterializeSubscriber = MaterializeSubscriber;
