var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var Subscriber_1 = require('../Subscriber');
var ArrayObservable_1 = require('../observables/ArrayObservable');
var ScalarObservable_1 = require('../observables/ScalarObservable');
function merge(scheduler, concurrent) {
    var observables = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        observables[_i - 2] = arguments[_i];
    }
    var xs = [];
    if (typeof this.subscribe === "function") {
        xs.push(this);
    }
    if (concurrent && typeof concurrent.subscribe === "function") {
        xs.push(concurrent);
        concurrent = scheduler;
    }
    if (scheduler && typeof scheduler === "object") {
        if (typeof scheduler.subscribe === "function") {
            xs.push(scheduler);
            scheduler = undefined;
            concurrent = Number.POSITIVE_INFINITY;
        }
        else if (typeof scheduler.schedule === "function") {
            concurrent = Number.POSITIVE_INFINITY;
        }
    }
    return new ArrayObservable_1.default(xs.concat(observables), scheduler).lift(new MergeOperator(concurrent));
}
exports.default = merge;
var MergeOperator = (function (_super) {
    __extends(MergeOperator, _super);
    function MergeOperator(concurrent) {
        if (concurrent === void 0) { concurrent = Number.POSITIVE_INFINITY; }
        _super.call(this);
        this.concurrent = concurrent;
    }
    MergeOperator.prototype.call = function (observer) {
        return new MergeSubscriber(observer, this.concurrent);
    };
    return MergeOperator;
})(Operator_1.default);
exports.MergeOperator = MergeOperator;
var MergeSubscriber = (function (_super) {
    __extends(MergeSubscriber, _super);
    function MergeSubscriber(destination, concurrent) {
        _super.call(this, destination);
        this.count = 0;
        this.active = 0;
        this.stopped = false;
        this.buffer = [];
        this.concurrent = concurrent;
    }
    MergeSubscriber.prototype._next = function (value) {
        var active = this.active;
        if (active < this.concurrent) {
            var index = this.count;
            var observable = this._project(value, index);
            if (observable) {
                this.count = index + 1;
                this.active = active + 1;
                this.add(this._subscribeInner(observable, value, index));
            }
        }
        else {
            this._buffer(value);
        }
    };
    MergeSubscriber.prototype._complete = function () {
        this.stopped = true;
        if (this.active === 0 && this.buffer.length === 0) {
            this.destination.complete();
        }
    };
    MergeSubscriber.prototype._unsubscribe = function () {
        this.buffer = void 0;
    };
    MergeSubscriber.prototype._project = function (value, index) {
        return value;
    };
    MergeSubscriber.prototype._buffer = function (value) {
        this.buffer.push(value);
    };
    MergeSubscriber.prototype._subscribeInner = function (observable, value, index) {
        if (observable instanceof ScalarObservable_1.default) {
            this.destination.next(observable.value);
            this._innerComplete();
        }
        else {
            return observable.subscribe(new MergeInnerSubscriber(this));
        }
    };
    MergeSubscriber.prototype._innerComplete = function () {
        var buffer = this.buffer;
        var active = this.active -= 1;
        var stopped = this.stopped;
        var pending = buffer.length;
        if (stopped && active === 0 && pending === 0) {
            this.destination.complete();
        }
        else if (active < this.concurrent && pending > 0) {
            this._next(buffer.shift());
        }
    };
    return MergeSubscriber;
})(Subscriber_1.default);
exports.MergeSubscriber = MergeSubscriber;
var MergeInnerSubscriber = (function (_super) {
    __extends(MergeInnerSubscriber, _super);
    function MergeInnerSubscriber(parent) {
        _super.call(this, parent.destination);
        this.parent = parent;
    }
    MergeInnerSubscriber.prototype._complete = function () {
        this.parent._innerComplete();
    };
    return MergeInnerSubscriber;
})(Subscriber_1.default);
exports.MergeInnerSubscriber = MergeInnerSubscriber;
