var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var Subscriber_1 = require('../Subscriber');
function observeOn(scheduler, delay) {
    if (delay === void 0) { delay = 0; }
    return this.lift(new ObserveOnOperator(scheduler, delay));
}
exports.default = observeOn;
var ObserveOnOperator = (function (_super) {
    __extends(ObserveOnOperator, _super);
    function ObserveOnOperator(scheduler, delay) {
        if (delay === void 0) { delay = 0; }
        _super.call(this);
        this.delay = delay;
        this.scheduler = scheduler;
    }
    ObserveOnOperator.prototype.call = function (observer) {
        return new ObserveOnSubscriber(observer, this.scheduler, this.delay);
    };
    return ObserveOnOperator;
})(Operator_1.default);
exports.ObserveOnOperator = ObserveOnOperator;
var ObserveOnSubscriber = (function (_super) {
    __extends(ObserveOnSubscriber, _super);
    function ObserveOnSubscriber(destination, scheduler, delay) {
        if (delay === void 0) { delay = 0; }
        _super.call(this, destination);
        this.delay = delay;
        this.scheduler = scheduler;
    }
    ObserveOnSubscriber.dispatch = function (_a) {
        var type = _a.type, value = _a.value, destination = _a.destination;
        destination[type](value);
    };
    ObserveOnSubscriber.prototype._next = function (x) {
        this.add(this.scheduler.schedule(this.delay, new ScheduledNotification("next", x, this.destination), ObserveOnSubscriber.dispatch));
    };
    ObserveOnSubscriber.prototype._error = function (e) {
        this.add(this.scheduler.schedule(this.delay, new ScheduledNotification("error", e, this.destination), ObserveOnSubscriber.dispatch));
    };
    ObserveOnSubscriber.prototype._complete = function () {
        this.add(this.scheduler.schedule(this.delay, new ScheduledNotification("complete", void 0, this.destination), ObserveOnSubscriber.dispatch));
    };
    return ObserveOnSubscriber;
})(Subscriber_1.default);
exports.ObserveOnSubscriber = ObserveOnSubscriber;
var ScheduledNotification = (function () {
    function ScheduledNotification(type, value, destination) {
        this.type = type;
        this.value = value;
        this.destination = destination;
    }
    return ScheduledNotification;
})();
