var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var Subscriber_1 = require('../Subscriber');
var Subject_1 = require('../Subject');
var tryCatch_1 = require('../util/tryCatch');
var errorObject_1 = require('../util/errorObject');
function retryWhen(notifier) {
    return this.lift(new RetryWhenOperator(notifier, this));
}
exports.default = retryWhen;
var RetryWhenOperator = (function (_super) {
    __extends(RetryWhenOperator, _super);
    function RetryWhenOperator(notifier, original) {
        _super.call(this);
        this.notifier = notifier;
        this.original = original;
    }
    RetryWhenOperator.prototype.call = function (observer) {
        return new RetryWhenSubscriber(observer, this.notifier, this.original);
    };
    return RetryWhenOperator;
})(Operator_1.default);
exports.RetryWhenOperator = RetryWhenOperator;
var RetryWhenSubscriber = (function (_super) {
    __extends(RetryWhenSubscriber, _super);
    function RetryWhenSubscriber(destination, notifier, original) {
        _super.call(this, destination);
        this.notifier = notifier;
        this.original = original;
    }
    RetryWhenSubscriber.prototype._error = function (err) {
        if (!this.retryNotifications) {
            this.errors = new Subject_1.default();
            var notifications = tryCatch_1.default(this.notifier).call(this, this.errors);
            if (notifications === errorObject_1.errorObject) {
                this.destination.error(errorObject_1.errorObject.e);
            }
            else {
                this.retryNotifications = notifications;
                this.retryNotificationSubscription = notifications.subscribe(new RetryNotificationSubscriber(this));
                this.add(this.retryNotificationSubscription);
            }
        }
        this.errors.next(err);
    };
    RetryWhenSubscriber.prototype.finalError = function (err) {
        this.destination.error(err);
    };
    RetryWhenSubscriber.prototype.resubscribe = function () {
        this.original.subscribe(this);
    };
    return RetryWhenSubscriber;
})(Subscriber_1.default);
exports.RetryWhenSubscriber = RetryWhenSubscriber;
var RetryNotificationSubscriber = (function (_super) {
    __extends(RetryNotificationSubscriber, _super);
    function RetryNotificationSubscriber(parent) {
        _super.call(this, null);
        this.parent = parent;
    }
    RetryNotificationSubscriber.prototype._next = function (value) {
        this.parent.resubscribe();
    };
    RetryNotificationSubscriber.prototype._error = function (err) {
        this.parent.finalError(err);
    };
    RetryNotificationSubscriber.prototype._complete = function () {
        this.parent.complete();
    };
    return RetryNotificationSubscriber;
})(Subscriber_1.default);
exports.RetryNotificationSubscriber = RetryNotificationSubscriber;
